# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetRepositoryResult',
    'AwaitableGetRepositoryResult',
    'get_repository',
    'get_repository_output',
]

@pulumi.output_type
class GetRepositoryResult:
    """
    A collection of values returned by getRepository.
    """
    def __init__(__self__, create_time=None, description=None, docker_configs=None, format=None, id=None, kms_key_name=None, labels=None, location=None, maven_configs=None, mode=None, name=None, project=None, remote_repository_configs=None, repository_id=None, update_time=None, virtual_repository_configs=None):
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if docker_configs and not isinstance(docker_configs, list):
            raise TypeError("Expected argument 'docker_configs' to be a list")
        pulumi.set(__self__, "docker_configs", docker_configs)
        if format and not isinstance(format, str):
            raise TypeError("Expected argument 'format' to be a str")
        pulumi.set(__self__, "format", format)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kms_key_name and not isinstance(kms_key_name, str):
            raise TypeError("Expected argument 'kms_key_name' to be a str")
        pulumi.set(__self__, "kms_key_name", kms_key_name)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if maven_configs and not isinstance(maven_configs, list):
            raise TypeError("Expected argument 'maven_configs' to be a list")
        pulumi.set(__self__, "maven_configs", maven_configs)
        if mode and not isinstance(mode, str):
            raise TypeError("Expected argument 'mode' to be a str")
        pulumi.set(__self__, "mode", mode)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if remote_repository_configs and not isinstance(remote_repository_configs, list):
            raise TypeError("Expected argument 'remote_repository_configs' to be a list")
        pulumi.set(__self__, "remote_repository_configs", remote_repository_configs)
        if repository_id and not isinstance(repository_id, str):
            raise TypeError("Expected argument 'repository_id' to be a str")
        pulumi.set(__self__, "repository_id", repository_id)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)
        if virtual_repository_configs and not isinstance(virtual_repository_configs, list):
            raise TypeError("Expected argument 'virtual_repository_configs' to be a list")
        pulumi.set(__self__, "virtual_repository_configs", virtual_repository_configs)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="dockerConfigs")
    def docker_configs(self) -> Sequence['outputs.GetRepositoryDockerConfigResult']:
        return pulumi.get(self, "docker_configs")

    @property
    @pulumi.getter
    def format(self) -> str:
        return pulumi.get(self, "format")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> str:
        return pulumi.get(self, "kms_key_name")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> str:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="mavenConfigs")
    def maven_configs(self) -> Sequence['outputs.GetRepositoryMavenConfigResult']:
        return pulumi.get(self, "maven_configs")

    @property
    @pulumi.getter
    def mode(self) -> str:
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> Optional[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="remoteRepositoryConfigs")
    def remote_repository_configs(self) -> Sequence['outputs.GetRepositoryRemoteRepositoryConfigResult']:
        return pulumi.get(self, "remote_repository_configs")

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> str:
        return pulumi.get(self, "repository_id")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="virtualRepositoryConfigs")
    def virtual_repository_configs(self) -> Sequence['outputs.GetRepositoryVirtualRepositoryConfigResult']:
        return pulumi.get(self, "virtual_repository_configs")


class AwaitableGetRepositoryResult(GetRepositoryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRepositoryResult(
            create_time=self.create_time,
            description=self.description,
            docker_configs=self.docker_configs,
            format=self.format,
            id=self.id,
            kms_key_name=self.kms_key_name,
            labels=self.labels,
            location=self.location,
            maven_configs=self.maven_configs,
            mode=self.mode,
            name=self.name,
            project=self.project,
            remote_repository_configs=self.remote_repository_configs,
            repository_id=self.repository_id,
            update_time=self.update_time,
            virtual_repository_configs=self.virtual_repository_configs)


def get_repository(location: Optional[str] = None,
                   project: Optional[str] = None,
                   repository_id: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRepositoryResult:
    """
    Get information about a Google Artifact Registry Repository. For more information see
    the [official documentation](https://cloud.google.com/artifact-registry/docs/)
    and [API](https://cloud.google.com/artifact-registry/docs/apis).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_repo = gcp.artifactregistry.get_repository(location="us-central1",
        repository_id="my-repository")
    ```


    :param str location: The location of the artifact registry repository. eg us-central1
           
           - - -
    :param str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    :param str repository_id: The last part of the repository name.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['project'] = project
    __args__['repositoryId'] = repository_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:artifactregistry/getRepository:getRepository', __args__, opts=opts, typ=GetRepositoryResult).value

    return AwaitableGetRepositoryResult(
        create_time=pulumi.get(__ret__, 'create_time'),
        description=pulumi.get(__ret__, 'description'),
        docker_configs=pulumi.get(__ret__, 'docker_configs'),
        format=pulumi.get(__ret__, 'format'),
        id=pulumi.get(__ret__, 'id'),
        kms_key_name=pulumi.get(__ret__, 'kms_key_name'),
        labels=pulumi.get(__ret__, 'labels'),
        location=pulumi.get(__ret__, 'location'),
        maven_configs=pulumi.get(__ret__, 'maven_configs'),
        mode=pulumi.get(__ret__, 'mode'),
        name=pulumi.get(__ret__, 'name'),
        project=pulumi.get(__ret__, 'project'),
        remote_repository_configs=pulumi.get(__ret__, 'remote_repository_configs'),
        repository_id=pulumi.get(__ret__, 'repository_id'),
        update_time=pulumi.get(__ret__, 'update_time'),
        virtual_repository_configs=pulumi.get(__ret__, 'virtual_repository_configs'))


@_utilities.lift_output_func(get_repository)
def get_repository_output(location: Optional[pulumi.Input[str]] = None,
                          project: Optional[pulumi.Input[Optional[str]]] = None,
                          repository_id: Optional[pulumi.Input[str]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRepositoryResult]:
    """
    Get information about a Google Artifact Registry Repository. For more information see
    the [official documentation](https://cloud.google.com/artifact-registry/docs/)
    and [API](https://cloud.google.com/artifact-registry/docs/apis).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_repo = gcp.artifactregistry.get_repository(location="us-central1",
        repository_id="my-repository")
    ```


    :param str location: The location of the artifact registry repository. eg us-central1
           
           - - -
    :param str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    :param str repository_id: The last part of the repository name.
    """
    ...
