# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TableArgs', 'Table']

@pulumi.input_type
class TableArgs:
    def __init__(__self__, *,
                 dataset_id: pulumi.Input[str],
                 table_id: pulumi.Input[str],
                 clusterings: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encryption_configuration: Optional[pulumi.Input['TableEncryptionConfigurationArgs']] = None,
                 expiration_time: Optional[pulumi.Input[int]] = None,
                 external_data_configuration: Optional[pulumi.Input['TableExternalDataConfigurationArgs']] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 materialized_view: Optional[pulumi.Input['TableMaterializedViewArgs']] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 range_partitioning: Optional[pulumi.Input['TableRangePartitioningArgs']] = None,
                 schema: Optional[pulumi.Input[str]] = None,
                 time_partitioning: Optional[pulumi.Input['TableTimePartitioningArgs']] = None,
                 view: Optional[pulumi.Input['TableViewArgs']] = None):
        """
        The set of arguments for constructing a Table resource.
        :param pulumi.Input[str] dataset_id: The dataset ID to create the table in.
               Changing this forces a new resource to be created.
        :param pulumi.Input[str] table_id: A unique ID for the resource.
               Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] clusterings: Specifies column names to use for data clustering.
               Up to four top-level columns are allowed, and should be specified in
               descending priority order.
        :param pulumi.Input[bool] deletion_protection: Whether or not to allow the provider to destroy the instance. Unless this field is set to false
               in state, a `=destroy` or `=update` that would delete the instance will fail.
        :param pulumi.Input[str] description: The field description.
        :param pulumi.Input['TableEncryptionConfigurationArgs'] encryption_configuration: Specifies how the table should be encrypted.
               If left blank, the table will be encrypted with a Google-managed key; that process
               is transparent to the user.  Structure is documented below.
        :param pulumi.Input[int] expiration_time: The time when this table expires, in
               milliseconds since the epoch. If not present, the table will persist
               indefinitely. Expired tables will be deleted and their storage
               reclaimed.
        :param pulumi.Input['TableExternalDataConfigurationArgs'] external_data_configuration: Describes the data format,
               location, and other properties of a table stored outside of BigQuery.
               By defining these properties, the data source can then be queried as
               if it were a standard BigQuery table. Structure is documented below.
        :param pulumi.Input[str] friendly_name: A descriptive name for the table.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A mapping of labels to assign to the resource.
        :param pulumi.Input['TableMaterializedViewArgs'] materialized_view: If specified, configures this table as a materialized view.
               Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input['TableRangePartitioningArgs'] range_partitioning: If specified, configures range-based
               partitioning for this table. Structure is documented below.
        :param pulumi.Input[str] schema: A JSON schema for the table.
               
               ~>**NOTE:** Because this field expects a JSON string, any changes to the
               string will create a diff, even if the JSON itself hasn't changed.
               If the API returns a different value for the same schema, e.g. it
               switched the order of values or replaced `STRUCT` field type with `RECORD`
               field type, we currently cannot suppress the recurring diff this causes.
               As a workaround, we recommend using the schema as returned by the API.
               
               ~>**NOTE:**  When setting `schema` for `external_data_configuration`, please use
               `external_data_configuration.schema` documented below.
        :param pulumi.Input['TableTimePartitioningArgs'] time_partitioning: If specified, configures time-based
               partitioning for this table. Structure is documented below.
        :param pulumi.Input['TableViewArgs'] view: If specified, configures this table as a view.
               Structure is documented below.
        """
        pulumi.set(__self__, "dataset_id", dataset_id)
        pulumi.set(__self__, "table_id", table_id)
        if clusterings is not None:
            pulumi.set(__self__, "clusterings", clusterings)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encryption_configuration is not None:
            pulumi.set(__self__, "encryption_configuration", encryption_configuration)
        if expiration_time is not None:
            pulumi.set(__self__, "expiration_time", expiration_time)
        if external_data_configuration is not None:
            pulumi.set(__self__, "external_data_configuration", external_data_configuration)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if materialized_view is not None:
            pulumi.set(__self__, "materialized_view", materialized_view)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if range_partitioning is not None:
            pulumi.set(__self__, "range_partitioning", range_partitioning)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if time_partitioning is not None:
            pulumi.set(__self__, "time_partitioning", time_partitioning)
        if view is not None:
            pulumi.set(__self__, "view", view)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> pulumi.Input[str]:
        """
        The dataset ID to create the table in.
        Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "dataset_id")

    @dataset_id.setter
    def dataset_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "dataset_id", value)

    @property
    @pulumi.getter(name="tableId")
    def table_id(self) -> pulumi.Input[str]:
        """
        A unique ID for the resource.
        Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "table_id")

    @table_id.setter
    def table_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "table_id", value)

    @property
    @pulumi.getter
    def clusterings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies column names to use for data clustering.
        Up to four top-level columns are allowed, and should be specified in
        descending priority order.
        """
        return pulumi.get(self, "clusterings")

    @clusterings.setter
    def clusterings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "clusterings", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to allow the provider to destroy the instance. Unless this field is set to false
        in state, a `=destroy` or `=update` that would delete the instance will fail.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The field description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> Optional[pulumi.Input['TableEncryptionConfigurationArgs']]:
        """
        Specifies how the table should be encrypted.
        If left blank, the table will be encrypted with a Google-managed key; that process
        is transparent to the user.  Structure is documented below.
        """
        return pulumi.get(self, "encryption_configuration")

    @encryption_configuration.setter
    def encryption_configuration(self, value: Optional[pulumi.Input['TableEncryptionConfigurationArgs']]):
        pulumi.set(self, "encryption_configuration", value)

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> Optional[pulumi.Input[int]]:
        """
        The time when this table expires, in
        milliseconds since the epoch. If not present, the table will persist
        indefinitely. Expired tables will be deleted and their storage
        reclaimed.
        """
        return pulumi.get(self, "expiration_time")

    @expiration_time.setter
    def expiration_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "expiration_time", value)

    @property
    @pulumi.getter(name="externalDataConfiguration")
    def external_data_configuration(self) -> Optional[pulumi.Input['TableExternalDataConfigurationArgs']]:
        """
        Describes the data format,
        location, and other properties of a table stored outside of BigQuery.
        By defining these properties, the data source can then be queried as
        if it were a standard BigQuery table. Structure is documented below.
        """
        return pulumi.get(self, "external_data_configuration")

    @external_data_configuration.setter
    def external_data_configuration(self, value: Optional[pulumi.Input['TableExternalDataConfigurationArgs']]):
        pulumi.set(self, "external_data_configuration", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        A descriptive name for the table.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A mapping of labels to assign to the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="materializedView")
    def materialized_view(self) -> Optional[pulumi.Input['TableMaterializedViewArgs']]:
        """
        If specified, configures this table as a materialized view.
        Structure is documented below.
        """
        return pulumi.get(self, "materialized_view")

    @materialized_view.setter
    def materialized_view(self, value: Optional[pulumi.Input['TableMaterializedViewArgs']]):
        pulumi.set(self, "materialized_view", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="rangePartitioning")
    def range_partitioning(self) -> Optional[pulumi.Input['TableRangePartitioningArgs']]:
        """
        If specified, configures range-based
        partitioning for this table. Structure is documented below.
        """
        return pulumi.get(self, "range_partitioning")

    @range_partitioning.setter
    def range_partitioning(self, value: Optional[pulumi.Input['TableRangePartitioningArgs']]):
        pulumi.set(self, "range_partitioning", value)

    @property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[str]]:
        """
        A JSON schema for the table.

        ~>**NOTE:** Because this field expects a JSON string, any changes to the
        string will create a diff, even if the JSON itself hasn't changed.
        If the API returns a different value for the same schema, e.g. it
        switched the order of values or replaced `STRUCT` field type with `RECORD`
        field type, we currently cannot suppress the recurring diff this causes.
        As a workaround, we recommend using the schema as returned by the API.

        ~>**NOTE:**  When setting `schema` for `external_data_configuration`, please use
        `external_data_configuration.schema` documented below.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schema", value)

    @property
    @pulumi.getter(name="timePartitioning")
    def time_partitioning(self) -> Optional[pulumi.Input['TableTimePartitioningArgs']]:
        """
        If specified, configures time-based
        partitioning for this table. Structure is documented below.
        """
        return pulumi.get(self, "time_partitioning")

    @time_partitioning.setter
    def time_partitioning(self, value: Optional[pulumi.Input['TableTimePartitioningArgs']]):
        pulumi.set(self, "time_partitioning", value)

    @property
    @pulumi.getter
    def view(self) -> Optional[pulumi.Input['TableViewArgs']]:
        """
        If specified, configures this table as a view.
        Structure is documented below.
        """
        return pulumi.get(self, "view")

    @view.setter
    def view(self, value: Optional[pulumi.Input['TableViewArgs']]):
        pulumi.set(self, "view", value)


@pulumi.input_type
class _TableState:
    def __init__(__self__, *,
                 clusterings: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 creation_time: Optional[pulumi.Input[int]] = None,
                 dataset_id: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encryption_configuration: Optional[pulumi.Input['TableEncryptionConfigurationArgs']] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 expiration_time: Optional[pulumi.Input[int]] = None,
                 external_data_configuration: Optional[pulumi.Input['TableExternalDataConfigurationArgs']] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 last_modified_time: Optional[pulumi.Input[int]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 materialized_view: Optional[pulumi.Input['TableMaterializedViewArgs']] = None,
                 num_bytes: Optional[pulumi.Input[int]] = None,
                 num_long_term_bytes: Optional[pulumi.Input[int]] = None,
                 num_rows: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 range_partitioning: Optional[pulumi.Input['TableRangePartitioningArgs']] = None,
                 schema: Optional[pulumi.Input[str]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 table_id: Optional[pulumi.Input[str]] = None,
                 time_partitioning: Optional[pulumi.Input['TableTimePartitioningArgs']] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 view: Optional[pulumi.Input['TableViewArgs']] = None):
        """
        Input properties used for looking up and filtering Table resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] clusterings: Specifies column names to use for data clustering.
               Up to four top-level columns are allowed, and should be specified in
               descending priority order.
        :param pulumi.Input[int] creation_time: The time when this table was created, in milliseconds since the epoch.
        :param pulumi.Input[str] dataset_id: The dataset ID to create the table in.
               Changing this forces a new resource to be created.
        :param pulumi.Input[bool] deletion_protection: Whether or not to allow the provider to destroy the instance. Unless this field is set to false
               in state, a `=destroy` or `=update` that would delete the instance will fail.
        :param pulumi.Input[str] description: The field description.
        :param pulumi.Input['TableEncryptionConfigurationArgs'] encryption_configuration: Specifies how the table should be encrypted.
               If left blank, the table will be encrypted with a Google-managed key; that process
               is transparent to the user.  Structure is documented below.
        :param pulumi.Input[str] etag: A hash of the resource.
        :param pulumi.Input[int] expiration_time: The time when this table expires, in
               milliseconds since the epoch. If not present, the table will persist
               indefinitely. Expired tables will be deleted and their storage
               reclaimed.
        :param pulumi.Input['TableExternalDataConfigurationArgs'] external_data_configuration: Describes the data format,
               location, and other properties of a table stored outside of BigQuery.
               By defining these properties, the data source can then be queried as
               if it were a standard BigQuery table. Structure is documented below.
        :param pulumi.Input[str] friendly_name: A descriptive name for the table.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A mapping of labels to assign to the resource.
        :param pulumi.Input[int] last_modified_time: The time when this table was last modified, in milliseconds since the epoch.
        :param pulumi.Input[str] location: The geographic location where the table resides. This value is inherited from the dataset.
        :param pulumi.Input['TableMaterializedViewArgs'] materialized_view: If specified, configures this table as a materialized view.
               Structure is documented below.
        :param pulumi.Input[int] num_bytes: The size of this table in bytes, excluding any data in the streaming buffer.
        :param pulumi.Input[int] num_long_term_bytes: The number of bytes in the table that are considered "long-term storage".
        :param pulumi.Input[int] num_rows: The number of rows of data in this table, excluding any data in the streaming buffer.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input['TableRangePartitioningArgs'] range_partitioning: If specified, configures range-based
               partitioning for this table. Structure is documented below.
        :param pulumi.Input[str] schema: A JSON schema for the table.
               
               ~>**NOTE:** Because this field expects a JSON string, any changes to the
               string will create a diff, even if the JSON itself hasn't changed.
               If the API returns a different value for the same schema, e.g. it
               switched the order of values or replaced `STRUCT` field type with `RECORD`
               field type, we currently cannot suppress the recurring diff this causes.
               As a workaround, we recommend using the schema as returned by the API.
               
               ~>**NOTE:**  When setting `schema` for `external_data_configuration`, please use
               `external_data_configuration.schema` documented below.
        :param pulumi.Input[str] self_link: The URI of the created resource.
        :param pulumi.Input[str] table_id: A unique ID for the resource.
               Changing this forces a new resource to be created.
        :param pulumi.Input['TableTimePartitioningArgs'] time_partitioning: If specified, configures time-based
               partitioning for this table. Structure is documented below.
        :param pulumi.Input[str] type: The supported types are DAY, HOUR, MONTH, and YEAR,
               which will generate one partition per day, hour, month, and year, respectively.
        :param pulumi.Input['TableViewArgs'] view: If specified, configures this table as a view.
               Structure is documented below.
        """
        if clusterings is not None:
            pulumi.set(__self__, "clusterings", clusterings)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encryption_configuration is not None:
            pulumi.set(__self__, "encryption_configuration", encryption_configuration)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if expiration_time is not None:
            pulumi.set(__self__, "expiration_time", expiration_time)
        if external_data_configuration is not None:
            pulumi.set(__self__, "external_data_configuration", external_data_configuration)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if last_modified_time is not None:
            pulumi.set(__self__, "last_modified_time", last_modified_time)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if materialized_view is not None:
            pulumi.set(__self__, "materialized_view", materialized_view)
        if num_bytes is not None:
            pulumi.set(__self__, "num_bytes", num_bytes)
        if num_long_term_bytes is not None:
            pulumi.set(__self__, "num_long_term_bytes", num_long_term_bytes)
        if num_rows is not None:
            pulumi.set(__self__, "num_rows", num_rows)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if range_partitioning is not None:
            pulumi.set(__self__, "range_partitioning", range_partitioning)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if table_id is not None:
            pulumi.set(__self__, "table_id", table_id)
        if time_partitioning is not None:
            pulumi.set(__self__, "time_partitioning", time_partitioning)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if view is not None:
            pulumi.set(__self__, "view", view)

    @property
    @pulumi.getter
    def clusterings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies column names to use for data clustering.
        Up to four top-level columns are allowed, and should be specified in
        descending priority order.
        """
        return pulumi.get(self, "clusterings")

    @clusterings.setter
    def clusterings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "clusterings", value)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[int]]:
        """
        The time when this table was created, in milliseconds since the epoch.
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "creation_time", value)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[pulumi.Input[str]]:
        """
        The dataset ID to create the table in.
        Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "dataset_id")

    @dataset_id.setter
    def dataset_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dataset_id", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to allow the provider to destroy the instance. Unless this field is set to false
        in state, a `=destroy` or `=update` that would delete the instance will fail.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The field description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> Optional[pulumi.Input['TableEncryptionConfigurationArgs']]:
        """
        Specifies how the table should be encrypted.
        If left blank, the table will be encrypted with a Google-managed key; that process
        is transparent to the user.  Structure is documented below.
        """
        return pulumi.get(self, "encryption_configuration")

    @encryption_configuration.setter
    def encryption_configuration(self, value: Optional[pulumi.Input['TableEncryptionConfigurationArgs']]):
        pulumi.set(self, "encryption_configuration", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        A hash of the resource.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> Optional[pulumi.Input[int]]:
        """
        The time when this table expires, in
        milliseconds since the epoch. If not present, the table will persist
        indefinitely. Expired tables will be deleted and their storage
        reclaimed.
        """
        return pulumi.get(self, "expiration_time")

    @expiration_time.setter
    def expiration_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "expiration_time", value)

    @property
    @pulumi.getter(name="externalDataConfiguration")
    def external_data_configuration(self) -> Optional[pulumi.Input['TableExternalDataConfigurationArgs']]:
        """
        Describes the data format,
        location, and other properties of a table stored outside of BigQuery.
        By defining these properties, the data source can then be queried as
        if it were a standard BigQuery table. Structure is documented below.
        """
        return pulumi.get(self, "external_data_configuration")

    @external_data_configuration.setter
    def external_data_configuration(self, value: Optional[pulumi.Input['TableExternalDataConfigurationArgs']]):
        pulumi.set(self, "external_data_configuration", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        A descriptive name for the table.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A mapping of labels to assign to the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> Optional[pulumi.Input[int]]:
        """
        The time when this table was last modified, in milliseconds since the epoch.
        """
        return pulumi.get(self, "last_modified_time")

    @last_modified_time.setter
    def last_modified_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "last_modified_time", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The geographic location where the table resides. This value is inherited from the dataset.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="materializedView")
    def materialized_view(self) -> Optional[pulumi.Input['TableMaterializedViewArgs']]:
        """
        If specified, configures this table as a materialized view.
        Structure is documented below.
        """
        return pulumi.get(self, "materialized_view")

    @materialized_view.setter
    def materialized_view(self, value: Optional[pulumi.Input['TableMaterializedViewArgs']]):
        pulumi.set(self, "materialized_view", value)

    @property
    @pulumi.getter(name="numBytes")
    def num_bytes(self) -> Optional[pulumi.Input[int]]:
        """
        The size of this table in bytes, excluding any data in the streaming buffer.
        """
        return pulumi.get(self, "num_bytes")

    @num_bytes.setter
    def num_bytes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_bytes", value)

    @property
    @pulumi.getter(name="numLongTermBytes")
    def num_long_term_bytes(self) -> Optional[pulumi.Input[int]]:
        """
        The number of bytes in the table that are considered "long-term storage".
        """
        return pulumi.get(self, "num_long_term_bytes")

    @num_long_term_bytes.setter
    def num_long_term_bytes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_long_term_bytes", value)

    @property
    @pulumi.getter(name="numRows")
    def num_rows(self) -> Optional[pulumi.Input[int]]:
        """
        The number of rows of data in this table, excluding any data in the streaming buffer.
        """
        return pulumi.get(self, "num_rows")

    @num_rows.setter
    def num_rows(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_rows", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="rangePartitioning")
    def range_partitioning(self) -> Optional[pulumi.Input['TableRangePartitioningArgs']]:
        """
        If specified, configures range-based
        partitioning for this table. Structure is documented below.
        """
        return pulumi.get(self, "range_partitioning")

    @range_partitioning.setter
    def range_partitioning(self, value: Optional[pulumi.Input['TableRangePartitioningArgs']]):
        pulumi.set(self, "range_partitioning", value)

    @property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[str]]:
        """
        A JSON schema for the table.

        ~>**NOTE:** Because this field expects a JSON string, any changes to the
        string will create a diff, even if the JSON itself hasn't changed.
        If the API returns a different value for the same schema, e.g. it
        switched the order of values or replaced `STRUCT` field type with `RECORD`
        field type, we currently cannot suppress the recurring diff this causes.
        As a workaround, we recommend using the schema as returned by the API.

        ~>**NOTE:**  When setting `schema` for `external_data_configuration`, please use
        `external_data_configuration.schema` documented below.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schema", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter(name="tableId")
    def table_id(self) -> Optional[pulumi.Input[str]]:
        """
        A unique ID for the resource.
        Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "table_id")

    @table_id.setter
    def table_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "table_id", value)

    @property
    @pulumi.getter(name="timePartitioning")
    def time_partitioning(self) -> Optional[pulumi.Input['TableTimePartitioningArgs']]:
        """
        If specified, configures time-based
        partitioning for this table. Structure is documented below.
        """
        return pulumi.get(self, "time_partitioning")

    @time_partitioning.setter
    def time_partitioning(self, value: Optional[pulumi.Input['TableTimePartitioningArgs']]):
        pulumi.set(self, "time_partitioning", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The supported types are DAY, HOUR, MONTH, and YEAR,
        which will generate one partition per day, hour, month, and year, respectively.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def view(self) -> Optional[pulumi.Input['TableViewArgs']]:
        """
        If specified, configures this table as a view.
        Structure is documented below.
        """
        return pulumi.get(self, "view")

    @view.setter
    def view(self, value: Optional[pulumi.Input['TableViewArgs']]):
        pulumi.set(self, "view", value)


class Table(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 clusterings: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dataset_id: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encryption_configuration: Optional[pulumi.Input[pulumi.InputType['TableEncryptionConfigurationArgs']]] = None,
                 expiration_time: Optional[pulumi.Input[int]] = None,
                 external_data_configuration: Optional[pulumi.Input[pulumi.InputType['TableExternalDataConfigurationArgs']]] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 materialized_view: Optional[pulumi.Input[pulumi.InputType['TableMaterializedViewArgs']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 range_partitioning: Optional[pulumi.Input[pulumi.InputType['TableRangePartitioningArgs']]] = None,
                 schema: Optional[pulumi.Input[str]] = None,
                 table_id: Optional[pulumi.Input[str]] = None,
                 time_partitioning: Optional[pulumi.Input[pulumi.InputType['TableTimePartitioningArgs']]] = None,
                 view: Optional[pulumi.Input[pulumi.InputType['TableViewArgs']]] = None,
                 __props__=None):
        """
        Creates a table resource in a dataset for Google BigQuery. For more information see
        [the official documentation](https://cloud.google.com/bigquery/docs/) and
        [API](https://cloud.google.com/bigquery/docs/reference/rest/v2/tables).

        > **Note**: On newer versions of the provider, you must explicitly set `deletion_protection=false`
        (and run `pulumi update` to write the field to state) in order to destroy an instance.
        It is recommended to not set this field (or set it to true) until you're ready to destroy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_dataset = gcp.bigquery.Dataset("defaultDataset",
            dataset_id="foo",
            friendly_name="test",
            description="This is a test description",
            location="EU",
            default_table_expiration_ms=3600000,
            labels={
                "env": "default",
            })
        default_table = gcp.bigquery.Table("defaultTable",
            dataset_id=default_dataset.dataset_id,
            table_id="bar",
            time_partitioning=gcp.bigquery.TableTimePartitioningArgs(
                type="DAY",
            ),
            labels={
                "env": "default",
            },
            schema=\"\"\"[
          {
            "name": "permalink",
            "type": "STRING",
            "mode": "NULLABLE",
            "description": "The Permalink"
          },
          {
            "name": "state",
            "type": "STRING",
            "mode": "NULLABLE",
            "description": "State where the head office is located"
          }
        ]
        \"\"\")
        sheet = gcp.bigquery.Table("sheet",
            dataset_id=default_dataset.dataset_id,
            table_id="sheet",
            external_data_configuration=gcp.bigquery.TableExternalDataConfigurationArgs(
                autodetect=True,
                source_format="GOOGLE_SHEETS",
                google_sheets_options=gcp.bigquery.TableExternalDataConfigurationGoogleSheetsOptionsArgs(
                    skip_leading_rows=1,
                ),
                source_uris=["https://docs.google.com/spreadsheets/d/123456789012345"],
            ))
        ```

        ## Import

        BigQuery tables imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:bigquery/table:Table default projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}
        ```

        ```sh
         $ pulumi import gcp:bigquery/table:Table default {{project}}/{{dataset_id}}/{{table_id}}
        ```

        ```sh
         $ pulumi import gcp:bigquery/table:Table default {{dataset_id}}/{{table_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] clusterings: Specifies column names to use for data clustering.
               Up to four top-level columns are allowed, and should be specified in
               descending priority order.
        :param pulumi.Input[str] dataset_id: The dataset ID to create the table in.
               Changing this forces a new resource to be created.
        :param pulumi.Input[bool] deletion_protection: Whether or not to allow the provider to destroy the instance. Unless this field is set to false
               in state, a `=destroy` or `=update` that would delete the instance will fail.
        :param pulumi.Input[str] description: The field description.
        :param pulumi.Input[pulumi.InputType['TableEncryptionConfigurationArgs']] encryption_configuration: Specifies how the table should be encrypted.
               If left blank, the table will be encrypted with a Google-managed key; that process
               is transparent to the user.  Structure is documented below.
        :param pulumi.Input[int] expiration_time: The time when this table expires, in
               milliseconds since the epoch. If not present, the table will persist
               indefinitely. Expired tables will be deleted and their storage
               reclaimed.
        :param pulumi.Input[pulumi.InputType['TableExternalDataConfigurationArgs']] external_data_configuration: Describes the data format,
               location, and other properties of a table stored outside of BigQuery.
               By defining these properties, the data source can then be queried as
               if it were a standard BigQuery table. Structure is documented below.
        :param pulumi.Input[str] friendly_name: A descriptive name for the table.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A mapping of labels to assign to the resource.
        :param pulumi.Input[pulumi.InputType['TableMaterializedViewArgs']] materialized_view: If specified, configures this table as a materialized view.
               Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[pulumi.InputType['TableRangePartitioningArgs']] range_partitioning: If specified, configures range-based
               partitioning for this table. Structure is documented below.
        :param pulumi.Input[str] schema: A JSON schema for the table.
               
               ~>**NOTE:** Because this field expects a JSON string, any changes to the
               string will create a diff, even if the JSON itself hasn't changed.
               If the API returns a different value for the same schema, e.g. it
               switched the order of values or replaced `STRUCT` field type with `RECORD`
               field type, we currently cannot suppress the recurring diff this causes.
               As a workaround, we recommend using the schema as returned by the API.
               
               ~>**NOTE:**  When setting `schema` for `external_data_configuration`, please use
               `external_data_configuration.schema` documented below.
        :param pulumi.Input[str] table_id: A unique ID for the resource.
               Changing this forces a new resource to be created.
        :param pulumi.Input[pulumi.InputType['TableTimePartitioningArgs']] time_partitioning: If specified, configures time-based
               partitioning for this table. Structure is documented below.
        :param pulumi.Input[pulumi.InputType['TableViewArgs']] view: If specified, configures this table as a view.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TableArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a table resource in a dataset for Google BigQuery. For more information see
        [the official documentation](https://cloud.google.com/bigquery/docs/) and
        [API](https://cloud.google.com/bigquery/docs/reference/rest/v2/tables).

        > **Note**: On newer versions of the provider, you must explicitly set `deletion_protection=false`
        (and run `pulumi update` to write the field to state) in order to destroy an instance.
        It is recommended to not set this field (or set it to true) until you're ready to destroy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_dataset = gcp.bigquery.Dataset("defaultDataset",
            dataset_id="foo",
            friendly_name="test",
            description="This is a test description",
            location="EU",
            default_table_expiration_ms=3600000,
            labels={
                "env": "default",
            })
        default_table = gcp.bigquery.Table("defaultTable",
            dataset_id=default_dataset.dataset_id,
            table_id="bar",
            time_partitioning=gcp.bigquery.TableTimePartitioningArgs(
                type="DAY",
            ),
            labels={
                "env": "default",
            },
            schema=\"\"\"[
          {
            "name": "permalink",
            "type": "STRING",
            "mode": "NULLABLE",
            "description": "The Permalink"
          },
          {
            "name": "state",
            "type": "STRING",
            "mode": "NULLABLE",
            "description": "State where the head office is located"
          }
        ]
        \"\"\")
        sheet = gcp.bigquery.Table("sheet",
            dataset_id=default_dataset.dataset_id,
            table_id="sheet",
            external_data_configuration=gcp.bigquery.TableExternalDataConfigurationArgs(
                autodetect=True,
                source_format="GOOGLE_SHEETS",
                google_sheets_options=gcp.bigquery.TableExternalDataConfigurationGoogleSheetsOptionsArgs(
                    skip_leading_rows=1,
                ),
                source_uris=["https://docs.google.com/spreadsheets/d/123456789012345"],
            ))
        ```

        ## Import

        BigQuery tables imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:bigquery/table:Table default projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}
        ```

        ```sh
         $ pulumi import gcp:bigquery/table:Table default {{project}}/{{dataset_id}}/{{table_id}}
        ```

        ```sh
         $ pulumi import gcp:bigquery/table:Table default {{dataset_id}}/{{table_id}}
        ```

        :param str resource_name: The name of the resource.
        :param TableArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TableArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 clusterings: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dataset_id: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encryption_configuration: Optional[pulumi.Input[pulumi.InputType['TableEncryptionConfigurationArgs']]] = None,
                 expiration_time: Optional[pulumi.Input[int]] = None,
                 external_data_configuration: Optional[pulumi.Input[pulumi.InputType['TableExternalDataConfigurationArgs']]] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 materialized_view: Optional[pulumi.Input[pulumi.InputType['TableMaterializedViewArgs']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 range_partitioning: Optional[pulumi.Input[pulumi.InputType['TableRangePartitioningArgs']]] = None,
                 schema: Optional[pulumi.Input[str]] = None,
                 table_id: Optional[pulumi.Input[str]] = None,
                 time_partitioning: Optional[pulumi.Input[pulumi.InputType['TableTimePartitioningArgs']]] = None,
                 view: Optional[pulumi.Input[pulumi.InputType['TableViewArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TableArgs.__new__(TableArgs)

            __props__.__dict__["clusterings"] = clusterings
            if dataset_id is None and not opts.urn:
                raise TypeError("Missing required property 'dataset_id'")
            __props__.__dict__["dataset_id"] = dataset_id
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["description"] = description
            __props__.__dict__["encryption_configuration"] = encryption_configuration
            __props__.__dict__["expiration_time"] = expiration_time
            __props__.__dict__["external_data_configuration"] = external_data_configuration
            __props__.__dict__["friendly_name"] = friendly_name
            __props__.__dict__["labels"] = labels
            __props__.__dict__["materialized_view"] = materialized_view
            __props__.__dict__["project"] = project
            __props__.__dict__["range_partitioning"] = range_partitioning
            __props__.__dict__["schema"] = schema
            if table_id is None and not opts.urn:
                raise TypeError("Missing required property 'table_id'")
            __props__.__dict__["table_id"] = table_id
            __props__.__dict__["time_partitioning"] = time_partitioning
            __props__.__dict__["view"] = view
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["last_modified_time"] = None
            __props__.__dict__["location"] = None
            __props__.__dict__["num_bytes"] = None
            __props__.__dict__["num_long_term_bytes"] = None
            __props__.__dict__["num_rows"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["type"] = None
        super(Table, __self__).__init__(
            'gcp:bigquery/table:Table',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            clusterings: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            creation_time: Optional[pulumi.Input[int]] = None,
            dataset_id: Optional[pulumi.Input[str]] = None,
            deletion_protection: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            encryption_configuration: Optional[pulumi.Input[pulumi.InputType['TableEncryptionConfigurationArgs']]] = None,
            etag: Optional[pulumi.Input[str]] = None,
            expiration_time: Optional[pulumi.Input[int]] = None,
            external_data_configuration: Optional[pulumi.Input[pulumi.InputType['TableExternalDataConfigurationArgs']]] = None,
            friendly_name: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            last_modified_time: Optional[pulumi.Input[int]] = None,
            location: Optional[pulumi.Input[str]] = None,
            materialized_view: Optional[pulumi.Input[pulumi.InputType['TableMaterializedViewArgs']]] = None,
            num_bytes: Optional[pulumi.Input[int]] = None,
            num_long_term_bytes: Optional[pulumi.Input[int]] = None,
            num_rows: Optional[pulumi.Input[int]] = None,
            project: Optional[pulumi.Input[str]] = None,
            range_partitioning: Optional[pulumi.Input[pulumi.InputType['TableRangePartitioningArgs']]] = None,
            schema: Optional[pulumi.Input[str]] = None,
            self_link: Optional[pulumi.Input[str]] = None,
            table_id: Optional[pulumi.Input[str]] = None,
            time_partitioning: Optional[pulumi.Input[pulumi.InputType['TableTimePartitioningArgs']]] = None,
            type: Optional[pulumi.Input[str]] = None,
            view: Optional[pulumi.Input[pulumi.InputType['TableViewArgs']]] = None) -> 'Table':
        """
        Get an existing Table resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] clusterings: Specifies column names to use for data clustering.
               Up to four top-level columns are allowed, and should be specified in
               descending priority order.
        :param pulumi.Input[int] creation_time: The time when this table was created, in milliseconds since the epoch.
        :param pulumi.Input[str] dataset_id: The dataset ID to create the table in.
               Changing this forces a new resource to be created.
        :param pulumi.Input[bool] deletion_protection: Whether or not to allow the provider to destroy the instance. Unless this field is set to false
               in state, a `=destroy` or `=update` that would delete the instance will fail.
        :param pulumi.Input[str] description: The field description.
        :param pulumi.Input[pulumi.InputType['TableEncryptionConfigurationArgs']] encryption_configuration: Specifies how the table should be encrypted.
               If left blank, the table will be encrypted with a Google-managed key; that process
               is transparent to the user.  Structure is documented below.
        :param pulumi.Input[str] etag: A hash of the resource.
        :param pulumi.Input[int] expiration_time: The time when this table expires, in
               milliseconds since the epoch. If not present, the table will persist
               indefinitely. Expired tables will be deleted and their storage
               reclaimed.
        :param pulumi.Input[pulumi.InputType['TableExternalDataConfigurationArgs']] external_data_configuration: Describes the data format,
               location, and other properties of a table stored outside of BigQuery.
               By defining these properties, the data source can then be queried as
               if it were a standard BigQuery table. Structure is documented below.
        :param pulumi.Input[str] friendly_name: A descriptive name for the table.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A mapping of labels to assign to the resource.
        :param pulumi.Input[int] last_modified_time: The time when this table was last modified, in milliseconds since the epoch.
        :param pulumi.Input[str] location: The geographic location where the table resides. This value is inherited from the dataset.
        :param pulumi.Input[pulumi.InputType['TableMaterializedViewArgs']] materialized_view: If specified, configures this table as a materialized view.
               Structure is documented below.
        :param pulumi.Input[int] num_bytes: The size of this table in bytes, excluding any data in the streaming buffer.
        :param pulumi.Input[int] num_long_term_bytes: The number of bytes in the table that are considered "long-term storage".
        :param pulumi.Input[int] num_rows: The number of rows of data in this table, excluding any data in the streaming buffer.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[pulumi.InputType['TableRangePartitioningArgs']] range_partitioning: If specified, configures range-based
               partitioning for this table. Structure is documented below.
        :param pulumi.Input[str] schema: A JSON schema for the table.
               
               ~>**NOTE:** Because this field expects a JSON string, any changes to the
               string will create a diff, even if the JSON itself hasn't changed.
               If the API returns a different value for the same schema, e.g. it
               switched the order of values or replaced `STRUCT` field type with `RECORD`
               field type, we currently cannot suppress the recurring diff this causes.
               As a workaround, we recommend using the schema as returned by the API.
               
               ~>**NOTE:**  When setting `schema` for `external_data_configuration`, please use
               `external_data_configuration.schema` documented below.
        :param pulumi.Input[str] self_link: The URI of the created resource.
        :param pulumi.Input[str] table_id: A unique ID for the resource.
               Changing this forces a new resource to be created.
        :param pulumi.Input[pulumi.InputType['TableTimePartitioningArgs']] time_partitioning: If specified, configures time-based
               partitioning for this table. Structure is documented below.
        :param pulumi.Input[str] type: The supported types are DAY, HOUR, MONTH, and YEAR,
               which will generate one partition per day, hour, month, and year, respectively.
        :param pulumi.Input[pulumi.InputType['TableViewArgs']] view: If specified, configures this table as a view.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TableState.__new__(_TableState)

        __props__.__dict__["clusterings"] = clusterings
        __props__.__dict__["creation_time"] = creation_time
        __props__.__dict__["dataset_id"] = dataset_id
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["description"] = description
        __props__.__dict__["encryption_configuration"] = encryption_configuration
        __props__.__dict__["etag"] = etag
        __props__.__dict__["expiration_time"] = expiration_time
        __props__.__dict__["external_data_configuration"] = external_data_configuration
        __props__.__dict__["friendly_name"] = friendly_name
        __props__.__dict__["labels"] = labels
        __props__.__dict__["last_modified_time"] = last_modified_time
        __props__.__dict__["location"] = location
        __props__.__dict__["materialized_view"] = materialized_view
        __props__.__dict__["num_bytes"] = num_bytes
        __props__.__dict__["num_long_term_bytes"] = num_long_term_bytes
        __props__.__dict__["num_rows"] = num_rows
        __props__.__dict__["project"] = project
        __props__.__dict__["range_partitioning"] = range_partitioning
        __props__.__dict__["schema"] = schema
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["table_id"] = table_id
        __props__.__dict__["time_partitioning"] = time_partitioning
        __props__.__dict__["type"] = type
        __props__.__dict__["view"] = view
        return Table(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def clusterings(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Specifies column names to use for data clustering.
        Up to four top-level columns are allowed, and should be specified in
        descending priority order.
        """
        return pulumi.get(self, "clusterings")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[int]:
        """
        The time when this table was created, in milliseconds since the epoch.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> pulumi.Output[str]:
        """
        The dataset ID to create the table in.
        Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not to allow the provider to destroy the instance. Unless this field is set to false
        in state, a `=destroy` or `=update` that would delete the instance will fail.
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The field description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> pulumi.Output[Optional['outputs.TableEncryptionConfiguration']]:
        """
        Specifies how the table should be encrypted.
        If left blank, the table will be encrypted with a Google-managed key; that process
        is transparent to the user.  Structure is documented below.
        """
        return pulumi.get(self, "encryption_configuration")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        """
        A hash of the resource.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> pulumi.Output[int]:
        """
        The time when this table expires, in
        milliseconds since the epoch. If not present, the table will persist
        indefinitely. Expired tables will be deleted and their storage
        reclaimed.
        """
        return pulumi.get(self, "expiration_time")

    @property
    @pulumi.getter(name="externalDataConfiguration")
    def external_data_configuration(self) -> pulumi.Output[Optional['outputs.TableExternalDataConfiguration']]:
        """
        Describes the data format,
        location, and other properties of a table stored outside of BigQuery.
        By defining these properties, the data source can then be queried as
        if it were a standard BigQuery table. Structure is documented below.
        """
        return pulumi.get(self, "external_data_configuration")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> pulumi.Output[Optional[str]]:
        """
        A descriptive name for the table.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A mapping of labels to assign to the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> pulumi.Output[int]:
        """
        The time when this table was last modified, in milliseconds since the epoch.
        """
        return pulumi.get(self, "last_modified_time")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The geographic location where the table resides. This value is inherited from the dataset.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="materializedView")
    def materialized_view(self) -> pulumi.Output[Optional['outputs.TableMaterializedView']]:
        """
        If specified, configures this table as a materialized view.
        Structure is documented below.
        """
        return pulumi.get(self, "materialized_view")

    @property
    @pulumi.getter(name="numBytes")
    def num_bytes(self) -> pulumi.Output[int]:
        """
        The size of this table in bytes, excluding any data in the streaming buffer.
        """
        return pulumi.get(self, "num_bytes")

    @property
    @pulumi.getter(name="numLongTermBytes")
    def num_long_term_bytes(self) -> pulumi.Output[int]:
        """
        The number of bytes in the table that are considered "long-term storage".
        """
        return pulumi.get(self, "num_long_term_bytes")

    @property
    @pulumi.getter(name="numRows")
    def num_rows(self) -> pulumi.Output[int]:
        """
        The number of rows of data in this table, excluding any data in the streaming buffer.
        """
        return pulumi.get(self, "num_rows")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="rangePartitioning")
    def range_partitioning(self) -> pulumi.Output[Optional['outputs.TableRangePartitioning']]:
        """
        If specified, configures range-based
        partitioning for this table. Structure is documented below.
        """
        return pulumi.get(self, "range_partitioning")

    @property
    @pulumi.getter
    def schema(self) -> pulumi.Output[str]:
        """
        A JSON schema for the table.

        ~>**NOTE:** Because this field expects a JSON string, any changes to the
        string will create a diff, even if the JSON itself hasn't changed.
        If the API returns a different value for the same schema, e.g. it
        switched the order of values or replaced `STRUCT` field type with `RECORD`
        field type, we currently cannot suppress the recurring diff this causes.
        As a workaround, we recommend using the schema as returned by the API.

        ~>**NOTE:**  When setting `schema` for `external_data_configuration`, please use
        `external_data_configuration.schema` documented below.
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="tableId")
    def table_id(self) -> pulumi.Output[str]:
        """
        A unique ID for the resource.
        Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "table_id")

    @property
    @pulumi.getter(name="timePartitioning")
    def time_partitioning(self) -> pulumi.Output[Optional['outputs.TableTimePartitioning']]:
        """
        If specified, configures time-based
        partitioning for this table. Structure is documented below.
        """
        return pulumi.get(self, "time_partitioning")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The supported types are DAY, HOUR, MONTH, and YEAR,
        which will generate one partition per day, hour, month, and year, respectively.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def view(self) -> pulumi.Output[Optional['outputs.TableView']]:
        """
        If specified, configures this table as a view.
        Structure is documented below.
        """
        return pulumi.get(self, "view")

