# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetTableIamPolicyResult',
    'AwaitableGetTableIamPolicyResult',
    'get_table_iam_policy',
    'get_table_iam_policy_output',
]

@pulumi.output_type
class GetTableIamPolicyResult:
    """
    A collection of values returned by getTableIamPolicy.
    """
    def __init__(__self__, etag=None, id=None, instance=None, policy_data=None, project=None, table=None):
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance and not isinstance(instance, str):
            raise TypeError("Expected argument 'instance' to be a str")
        pulumi.set(__self__, "instance", instance)
        if policy_data and not isinstance(policy_data, str):
            raise TypeError("Expected argument 'policy_data' to be a str")
        pulumi.set(__self__, "policy_data", policy_data)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if table and not isinstance(table, str):
            raise TypeError("Expected argument 'table' to be a str")
        pulumi.set(__self__, "table", table)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        (Computed) The etag of the IAM policy.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def instance(self) -> str:
        return pulumi.get(self, "instance")

    @property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> str:
        """
        (Computed) The policy data
        """
        return pulumi.get(self, "policy_data")

    @property
    @pulumi.getter
    def project(self) -> str:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def table(self) -> str:
        return pulumi.get(self, "table")


class AwaitableGetTableIamPolicyResult(GetTableIamPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTableIamPolicyResult(
            etag=self.etag,
            id=self.id,
            instance=self.instance,
            policy_data=self.policy_data,
            project=self.project,
            table=self.table)


def get_table_iam_policy(instance: Optional[str] = None,
                         project: Optional[str] = None,
                         table: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTableIamPolicyResult:
    """
    Retrieves the current IAM policy data for a Bigtable Table.

    ## example

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.bigtable.get_table_iam_policy(instance=google_bigtable_instance["instance"]["name"],
        table=google_bigtable_table["table"]["name"])
    ```


    :param str instance: The name or relative resource id of the instance that owns the table.
    :param str table: The name or relative resource id of the table to manage IAM policies for.
    """
    __args__ = dict()
    __args__['instance'] = instance
    __args__['project'] = project
    __args__['table'] = table
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:bigtable/getTableIamPolicy:getTableIamPolicy', __args__, opts=opts, typ=GetTableIamPolicyResult).value

    return AwaitableGetTableIamPolicyResult(
        etag=pulumi.get(__ret__, 'etag'),
        id=pulumi.get(__ret__, 'id'),
        instance=pulumi.get(__ret__, 'instance'),
        policy_data=pulumi.get(__ret__, 'policy_data'),
        project=pulumi.get(__ret__, 'project'),
        table=pulumi.get(__ret__, 'table'))


@_utilities.lift_output_func(get_table_iam_policy)
def get_table_iam_policy_output(instance: Optional[pulumi.Input[str]] = None,
                                project: Optional[pulumi.Input[Optional[str]]] = None,
                                table: Optional[pulumi.Input[str]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTableIamPolicyResult]:
    """
    Retrieves the current IAM policy data for a Bigtable Table.

    ## example

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.bigtable.get_table_iam_policy(instance=google_bigtable_instance["instance"]["name"],
        table=google_bigtable_table["table"]["name"])
    ```


    :param str instance: The name or relative resource id of the instance that owns the table.
    :param str table: The name or relative resource id of the table to manage IAM policies for.
    """
    ...
