# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'ConnectionGithubConfigArgs',
    'ConnectionGithubConfigAuthorizerCredentialArgs',
    'ConnectionGithubEnterpriseConfigArgs',
    'ConnectionGithubEnterpriseConfigServiceDirectoryConfigArgs',
    'ConnectionGitlabConfigArgs',
    'ConnectionGitlabConfigAuthorizerCredentialArgs',
    'ConnectionGitlabConfigReadAuthorizerCredentialArgs',
    'ConnectionGitlabConfigServiceDirectoryConfigArgs',
    'ConnectionIAMBindingConditionArgs',
    'ConnectionIAMMemberConditionArgs',
    'ConnectionInstallationStateArgs',
]

@pulumi.input_type
class ConnectionGithubConfigArgs:
    def __init__(__self__, *,
                 app_installation_id: Optional[pulumi.Input[int]] = None,
                 authorizer_credential: Optional[pulumi.Input['ConnectionGithubConfigAuthorizerCredentialArgs']] = None):
        """
        :param pulumi.Input[int] app_installation_id: GitHub App installation id.
        :param pulumi.Input['ConnectionGithubConfigAuthorizerCredentialArgs'] authorizer_credential: OAuth credential of the account that authorized the Cloud Build GitHub App. It is recommended to use a robot account instead of a human user account. The OAuth token must be tied to the Cloud Build GitHub App.
        """
        if app_installation_id is not None:
            pulumi.set(__self__, "app_installation_id", app_installation_id)
        if authorizer_credential is not None:
            pulumi.set(__self__, "authorizer_credential", authorizer_credential)

    @property
    @pulumi.getter(name="appInstallationId")
    def app_installation_id(self) -> Optional[pulumi.Input[int]]:
        """
        GitHub App installation id.
        """
        return pulumi.get(self, "app_installation_id")

    @app_installation_id.setter
    def app_installation_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "app_installation_id", value)

    @property
    @pulumi.getter(name="authorizerCredential")
    def authorizer_credential(self) -> Optional[pulumi.Input['ConnectionGithubConfigAuthorizerCredentialArgs']]:
        """
        OAuth credential of the account that authorized the Cloud Build GitHub App. It is recommended to use a robot account instead of a human user account. The OAuth token must be tied to the Cloud Build GitHub App.
        """
        return pulumi.get(self, "authorizer_credential")

    @authorizer_credential.setter
    def authorizer_credential(self, value: Optional[pulumi.Input['ConnectionGithubConfigAuthorizerCredentialArgs']]):
        pulumi.set(self, "authorizer_credential", value)


@pulumi.input_type
class ConnectionGithubConfigAuthorizerCredentialArgs:
    def __init__(__self__, *,
                 oauth_token_secret_version: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] oauth_token_secret_version: A SecretManager resource containing the OAuth token that authorizes the Cloud Build connection. Format: `projects/*/secrets/*/versions/*`.
        :param pulumi.Input[str] username: Output only. The username associated to this token.
        """
        if oauth_token_secret_version is not None:
            pulumi.set(__self__, "oauth_token_secret_version", oauth_token_secret_version)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="oauthTokenSecretVersion")
    def oauth_token_secret_version(self) -> Optional[pulumi.Input[str]]:
        """
        A SecretManager resource containing the OAuth token that authorizes the Cloud Build connection. Format: `projects/*/secrets/*/versions/*`.
        """
        return pulumi.get(self, "oauth_token_secret_version")

    @oauth_token_secret_version.setter
    def oauth_token_secret_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth_token_secret_version", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. The username associated to this token.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class ConnectionGithubEnterpriseConfigArgs:
    def __init__(__self__, *,
                 host_uri: pulumi.Input[str],
                 app_id: Optional[pulumi.Input[int]] = None,
                 app_installation_id: Optional[pulumi.Input[int]] = None,
                 app_slug: Optional[pulumi.Input[str]] = None,
                 private_key_secret_version: Optional[pulumi.Input[str]] = None,
                 service_directory_config: Optional[pulumi.Input['ConnectionGithubEnterpriseConfigServiceDirectoryConfigArgs']] = None,
                 ssl_ca: Optional[pulumi.Input[str]] = None,
                 webhook_secret_secret_version: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] host_uri: Required. The URI of the GitHub Enterprise host this connection is for.
        :param pulumi.Input[int] app_id: Id of the GitHub App created from the manifest.
        :param pulumi.Input[int] app_installation_id: ID of the installation of the GitHub App.
        :param pulumi.Input[str] app_slug: The URL-friendly name of the GitHub App.
        :param pulumi.Input[str] private_key_secret_version: SecretManager resource containing the private key of the GitHub App, formatted as `projects/*/secrets/*/versions/*`.
        :param pulumi.Input['ConnectionGithubEnterpriseConfigServiceDirectoryConfigArgs'] service_directory_config: Configuration for using Service Directory to privately connect to a GitHub Enterprise server. This should only be set if the GitHub Enterprise server is hosted on-premises and not reachable by public internet. If this field is left empty, calls to the GitHub Enterprise server will be made over the public internet.
        :param pulumi.Input[str] ssl_ca: SSL certificate to use for requests to GitHub Enterprise.
        :param pulumi.Input[str] webhook_secret_secret_version: SecretManager resource containing the webhook secret of the GitHub App, formatted as `projects/*/secrets/*/versions/*`.
        """
        pulumi.set(__self__, "host_uri", host_uri)
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if app_installation_id is not None:
            pulumi.set(__self__, "app_installation_id", app_installation_id)
        if app_slug is not None:
            pulumi.set(__self__, "app_slug", app_slug)
        if private_key_secret_version is not None:
            pulumi.set(__self__, "private_key_secret_version", private_key_secret_version)
        if service_directory_config is not None:
            pulumi.set(__self__, "service_directory_config", service_directory_config)
        if ssl_ca is not None:
            pulumi.set(__self__, "ssl_ca", ssl_ca)
        if webhook_secret_secret_version is not None:
            pulumi.set(__self__, "webhook_secret_secret_version", webhook_secret_secret_version)

    @property
    @pulumi.getter(name="hostUri")
    def host_uri(self) -> pulumi.Input[str]:
        """
        Required. The URI of the GitHub Enterprise host this connection is for.
        """
        return pulumi.get(self, "host_uri")

    @host_uri.setter
    def host_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "host_uri", value)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[int]]:
        """
        Id of the GitHub App created from the manifest.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter(name="appInstallationId")
    def app_installation_id(self) -> Optional[pulumi.Input[int]]:
        """
        ID of the installation of the GitHub App.
        """
        return pulumi.get(self, "app_installation_id")

    @app_installation_id.setter
    def app_installation_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "app_installation_id", value)

    @property
    @pulumi.getter(name="appSlug")
    def app_slug(self) -> Optional[pulumi.Input[str]]:
        """
        The URL-friendly name of the GitHub App.
        """
        return pulumi.get(self, "app_slug")

    @app_slug.setter
    def app_slug(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_slug", value)

    @property
    @pulumi.getter(name="privateKeySecretVersion")
    def private_key_secret_version(self) -> Optional[pulumi.Input[str]]:
        """
        SecretManager resource containing the private key of the GitHub App, formatted as `projects/*/secrets/*/versions/*`.
        """
        return pulumi.get(self, "private_key_secret_version")

    @private_key_secret_version.setter
    def private_key_secret_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_key_secret_version", value)

    @property
    @pulumi.getter(name="serviceDirectoryConfig")
    def service_directory_config(self) -> Optional[pulumi.Input['ConnectionGithubEnterpriseConfigServiceDirectoryConfigArgs']]:
        """
        Configuration for using Service Directory to privately connect to a GitHub Enterprise server. This should only be set if the GitHub Enterprise server is hosted on-premises and not reachable by public internet. If this field is left empty, calls to the GitHub Enterprise server will be made over the public internet.
        """
        return pulumi.get(self, "service_directory_config")

    @service_directory_config.setter
    def service_directory_config(self, value: Optional[pulumi.Input['ConnectionGithubEnterpriseConfigServiceDirectoryConfigArgs']]):
        pulumi.set(self, "service_directory_config", value)

    @property
    @pulumi.getter(name="sslCa")
    def ssl_ca(self) -> Optional[pulumi.Input[str]]:
        """
        SSL certificate to use for requests to GitHub Enterprise.
        """
        return pulumi.get(self, "ssl_ca")

    @ssl_ca.setter
    def ssl_ca(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_ca", value)

    @property
    @pulumi.getter(name="webhookSecretSecretVersion")
    def webhook_secret_secret_version(self) -> Optional[pulumi.Input[str]]:
        """
        SecretManager resource containing the webhook secret of the GitHub App, formatted as `projects/*/secrets/*/versions/*`.
        """
        return pulumi.get(self, "webhook_secret_secret_version")

    @webhook_secret_secret_version.setter
    def webhook_secret_secret_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "webhook_secret_secret_version", value)


@pulumi.input_type
class ConnectionGithubEnterpriseConfigServiceDirectoryConfigArgs:
    def __init__(__self__, *,
                 service: pulumi.Input[str]):
        """
        :param pulumi.Input[str] service: Required. The Service Directory service name. Format: projects/{project}/locations/{location}/namespaces/{namespace}/services/{service}.
        """
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter
    def service(self) -> pulumi.Input[str]:
        """
        Required. The Service Directory service name. Format: projects/{project}/locations/{location}/namespaces/{namespace}/services/{service}.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: pulumi.Input[str]):
        pulumi.set(self, "service", value)


@pulumi.input_type
class ConnectionGitlabConfigArgs:
    def __init__(__self__, *,
                 authorizer_credential: pulumi.Input['ConnectionGitlabConfigAuthorizerCredentialArgs'],
                 read_authorizer_credential: pulumi.Input['ConnectionGitlabConfigReadAuthorizerCredentialArgs'],
                 webhook_secret_secret_version: pulumi.Input[str],
                 host_uri: Optional[pulumi.Input[str]] = None,
                 server_version: Optional[pulumi.Input[str]] = None,
                 service_directory_config: Optional[pulumi.Input['ConnectionGitlabConfigServiceDirectoryConfigArgs']] = None,
                 ssl_ca: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input['ConnectionGitlabConfigAuthorizerCredentialArgs'] authorizer_credential: Required. A GitLab personal access token with the `api` scope access.
        :param pulumi.Input['ConnectionGitlabConfigReadAuthorizerCredentialArgs'] read_authorizer_credential: Required. A GitLab personal access token with the minimum `read_api` scope access.
        :param pulumi.Input[str] webhook_secret_secret_version: Required. Immutable. SecretManager resource containing the webhook secret of a GitLab Enterprise project, formatted as `projects/*/secrets/*/versions/*`.
        :param pulumi.Input[str] host_uri: The URI of the GitLab Enterprise host this connection is for. If not specified, the default value is https://gitlab.com.
        :param pulumi.Input[str] server_version: Output only. Version of the GitLab Enterprise server running on the `host_uri`.
        :param pulumi.Input['ConnectionGitlabConfigServiceDirectoryConfigArgs'] service_directory_config: Configuration for using Service Directory to privately connect to a GitLab Enterprise server. This should only be set if the GitLab Enterprise server is hosted on-premises and not reachable by public internet. If this field is left empty, calls to the GitLab Enterprise server will be made over the public internet.
        :param pulumi.Input[str] ssl_ca: SSL certificate to use for requests to GitLab Enterprise.
        """
        pulumi.set(__self__, "authorizer_credential", authorizer_credential)
        pulumi.set(__self__, "read_authorizer_credential", read_authorizer_credential)
        pulumi.set(__self__, "webhook_secret_secret_version", webhook_secret_secret_version)
        if host_uri is not None:
            pulumi.set(__self__, "host_uri", host_uri)
        if server_version is not None:
            pulumi.set(__self__, "server_version", server_version)
        if service_directory_config is not None:
            pulumi.set(__self__, "service_directory_config", service_directory_config)
        if ssl_ca is not None:
            pulumi.set(__self__, "ssl_ca", ssl_ca)

    @property
    @pulumi.getter(name="authorizerCredential")
    def authorizer_credential(self) -> pulumi.Input['ConnectionGitlabConfigAuthorizerCredentialArgs']:
        """
        Required. A GitLab personal access token with the `api` scope access.
        """
        return pulumi.get(self, "authorizer_credential")

    @authorizer_credential.setter
    def authorizer_credential(self, value: pulumi.Input['ConnectionGitlabConfigAuthorizerCredentialArgs']):
        pulumi.set(self, "authorizer_credential", value)

    @property
    @pulumi.getter(name="readAuthorizerCredential")
    def read_authorizer_credential(self) -> pulumi.Input['ConnectionGitlabConfigReadAuthorizerCredentialArgs']:
        """
        Required. A GitLab personal access token with the minimum `read_api` scope access.
        """
        return pulumi.get(self, "read_authorizer_credential")

    @read_authorizer_credential.setter
    def read_authorizer_credential(self, value: pulumi.Input['ConnectionGitlabConfigReadAuthorizerCredentialArgs']):
        pulumi.set(self, "read_authorizer_credential", value)

    @property
    @pulumi.getter(name="webhookSecretSecretVersion")
    def webhook_secret_secret_version(self) -> pulumi.Input[str]:
        """
        Required. Immutable. SecretManager resource containing the webhook secret of a GitLab Enterprise project, formatted as `projects/*/secrets/*/versions/*`.
        """
        return pulumi.get(self, "webhook_secret_secret_version")

    @webhook_secret_secret_version.setter
    def webhook_secret_secret_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "webhook_secret_secret_version", value)

    @property
    @pulumi.getter(name="hostUri")
    def host_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of the GitLab Enterprise host this connection is for. If not specified, the default value is https://gitlab.com.
        """
        return pulumi.get(self, "host_uri")

    @host_uri.setter
    def host_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_uri", value)

    @property
    @pulumi.getter(name="serverVersion")
    def server_version(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. Version of the GitLab Enterprise server running on the `host_uri`.
        """
        return pulumi.get(self, "server_version")

    @server_version.setter
    def server_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_version", value)

    @property
    @pulumi.getter(name="serviceDirectoryConfig")
    def service_directory_config(self) -> Optional[pulumi.Input['ConnectionGitlabConfigServiceDirectoryConfigArgs']]:
        """
        Configuration for using Service Directory to privately connect to a GitLab Enterprise server. This should only be set if the GitLab Enterprise server is hosted on-premises and not reachable by public internet. If this field is left empty, calls to the GitLab Enterprise server will be made over the public internet.
        """
        return pulumi.get(self, "service_directory_config")

    @service_directory_config.setter
    def service_directory_config(self, value: Optional[pulumi.Input['ConnectionGitlabConfigServiceDirectoryConfigArgs']]):
        pulumi.set(self, "service_directory_config", value)

    @property
    @pulumi.getter(name="sslCa")
    def ssl_ca(self) -> Optional[pulumi.Input[str]]:
        """
        SSL certificate to use for requests to GitLab Enterprise.
        """
        return pulumi.get(self, "ssl_ca")

    @ssl_ca.setter
    def ssl_ca(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_ca", value)


@pulumi.input_type
class ConnectionGitlabConfigAuthorizerCredentialArgs:
    def __init__(__self__, *,
                 user_token_secret_version: pulumi.Input[str],
                 username: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] user_token_secret_version: Required. A SecretManager resource containing the user token that authorizes the Cloud Build connection. Format: `projects/*/secrets/*/versions/*`.
        :param pulumi.Input[str] username: Output only. The username associated to this token.
        """
        pulumi.set(__self__, "user_token_secret_version", user_token_secret_version)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="userTokenSecretVersion")
    def user_token_secret_version(self) -> pulumi.Input[str]:
        """
        Required. A SecretManager resource containing the user token that authorizes the Cloud Build connection. Format: `projects/*/secrets/*/versions/*`.
        """
        return pulumi.get(self, "user_token_secret_version")

    @user_token_secret_version.setter
    def user_token_secret_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_token_secret_version", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. The username associated to this token.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class ConnectionGitlabConfigReadAuthorizerCredentialArgs:
    def __init__(__self__, *,
                 user_token_secret_version: pulumi.Input[str],
                 username: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] user_token_secret_version: Required. A SecretManager resource containing the user token that authorizes the Cloud Build connection. Format: `projects/*/secrets/*/versions/*`.
        :param pulumi.Input[str] username: Output only. The username associated to this token.
               
               - - -
        """
        pulumi.set(__self__, "user_token_secret_version", user_token_secret_version)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="userTokenSecretVersion")
    def user_token_secret_version(self) -> pulumi.Input[str]:
        """
        Required. A SecretManager resource containing the user token that authorizes the Cloud Build connection. Format: `projects/*/secrets/*/versions/*`.
        """
        return pulumi.get(self, "user_token_secret_version")

    @user_token_secret_version.setter
    def user_token_secret_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_token_secret_version", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. The username associated to this token.

        - - -
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class ConnectionGitlabConfigServiceDirectoryConfigArgs:
    def __init__(__self__, *,
                 service: pulumi.Input[str]):
        """
        :param pulumi.Input[str] service: Required. The Service Directory service name. Format: projects/{project}/locations/{location}/namespaces/{namespace}/services/{service}.
        """
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter
    def service(self) -> pulumi.Input[str]:
        """
        Required. The Service Directory service name. Format: projects/{project}/locations/{location}/namespaces/{namespace}/services/{service}.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: pulumi.Input[str]):
        pulumi.set(self, "service", value)


@pulumi.input_type
class ConnectionIAMBindingConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[str],
                 title: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[str]:
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class ConnectionIAMMemberConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[str],
                 title: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[str]:
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class ConnectionInstallationStateArgs:
    def __init__(__self__, *,
                 action_uri: Optional[pulumi.Input[str]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 stage: Optional[pulumi.Input[str]] = None):
        if action_uri is not None:
            pulumi.set(__self__, "action_uri", action_uri)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if stage is not None:
            pulumi.set(__self__, "stage", stage)

    @property
    @pulumi.getter(name="actionUri")
    def action_uri(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "action_uri")

    @action_uri.setter
    def action_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action_uri", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def stage(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "stage")

    @stage.setter
    def stage(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stage", value)


