# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['JobArgs', 'Job']

@pulumi.input_type
class JobArgs:
    def __init__(__self__, *,
                 template: pulumi.Input['JobTemplateArgs'],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 binary_authorization: Optional[pulumi.Input['JobBinaryAuthorizationArgs']] = None,
                 client: Optional[pulumi.Input[str]] = None,
                 client_version: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 launch_stage: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Job resource.
        :param pulumi.Input['JobTemplateArgs'] template: The template used to create executions for this Job.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
               Cloud Run API v2 does not support annotations with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
               All system annotations in v1 now have a corresponding field in v2 ExecutionTemplate.
               This field follows Kubernetes annotations' namespacing, limits, and rules.
               
               (Optional)
               Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
               Cloud Run API v2 does not support annotations with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected on new resources.
               All system annotations in v1 now have a corresponding field in v2 Job.
               This field follows Kubernetes annotations' namespacing, limits, and rules.
        :param pulumi.Input['JobBinaryAuthorizationArgs'] binary_authorization: Settings for the Binary Authorization feature.
               Structure is documented below.
        :param pulumi.Input[str] client: Arbitrary identifier for the API client.
        :param pulumi.Input[str] client_version: Arbitrary version identifier for the API client.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter,
               or break down billing charges by team, component, environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or
               https://cloud.google.com/run/docs/configuring/labels.
               Cloud Run API v2 does not support labels with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
               All system labels in v1 now have a corresponding field in v2 ExecutionTemplate.
               
               (Optional)
               Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter, or break down billing charges by team, component,
               environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or https://cloud.google.com/run/docs/configuring/labels.
               Cloud Run API v2 does not support labels with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
               All system labels in v1 now have a corresponding field in v2 Job.
        :param pulumi.Input[str] launch_stage: The launch stage as defined by [Google Cloud Platform Launch Stages](https://cloud.google.com/products#product-launch-stages). Cloud Run supports ALPHA, BETA, and GA.
               If no value is specified, GA is assumed. Set the launch stage to a preview stage on input to allow use of preview features in that stage. On read (or output), describes whether the resource uses preview features.
               For example, if ALPHA is provided as input, but only BETA and GA-level features are used, this field will be BETA on output.
               Possible values are: `UNIMPLEMENTED`, `PRELAUNCH`, `EARLY_ACCESS`, `ALPHA`, `BETA`, `GA`, `DEPRECATED`.
        :param pulumi.Input[str] location: The location of the cloud run job
        :param pulumi.Input[str] name: Name of the Job.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "template", template)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if binary_authorization is not None:
            pulumi.set(__self__, "binary_authorization", binary_authorization)
        if client is not None:
            pulumi.set(__self__, "client", client)
        if client_version is not None:
            pulumi.set(__self__, "client_version", client_version)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if launch_stage is not None:
            pulumi.set(__self__, "launch_stage", launch_stage)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def template(self) -> pulumi.Input['JobTemplateArgs']:
        """
        The template used to create executions for this Job.
        Structure is documented below.
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: pulumi.Input['JobTemplateArgs']):
        pulumi.set(self, "template", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
        Cloud Run API v2 does not support annotations with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
        All system annotations in v1 now have a corresponding field in v2 ExecutionTemplate.
        This field follows Kubernetes annotations' namespacing, limits, and rules.

        (Optional)
        Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
        Cloud Run API v2 does not support annotations with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected on new resources.
        All system annotations in v1 now have a corresponding field in v2 Job.
        This field follows Kubernetes annotations' namespacing, limits, and rules.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="binaryAuthorization")
    def binary_authorization(self) -> Optional[pulumi.Input['JobBinaryAuthorizationArgs']]:
        """
        Settings for the Binary Authorization feature.
        Structure is documented below.
        """
        return pulumi.get(self, "binary_authorization")

    @binary_authorization.setter
    def binary_authorization(self, value: Optional[pulumi.Input['JobBinaryAuthorizationArgs']]):
        pulumi.set(self, "binary_authorization", value)

    @property
    @pulumi.getter
    def client(self) -> Optional[pulumi.Input[str]]:
        """
        Arbitrary identifier for the API client.
        """
        return pulumi.get(self, "client")

    @client.setter
    def client(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client", value)

    @property
    @pulumi.getter(name="clientVersion")
    def client_version(self) -> Optional[pulumi.Input[str]]:
        """
        Arbitrary version identifier for the API client.
        """
        return pulumi.get(self, "client_version")

    @client_version.setter
    def client_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_version", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter,
        or break down billing charges by team, component, environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or
        https://cloud.google.com/run/docs/configuring/labels.
        Cloud Run API v2 does not support labels with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
        All system labels in v1 now have a corresponding field in v2 ExecutionTemplate.

        (Optional)
        Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter, or break down billing charges by team, component,
        environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or https://cloud.google.com/run/docs/configuring/labels.
        Cloud Run API v2 does not support labels with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
        All system labels in v1 now have a corresponding field in v2 Job.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="launchStage")
    def launch_stage(self) -> Optional[pulumi.Input[str]]:
        """
        The launch stage as defined by [Google Cloud Platform Launch Stages](https://cloud.google.com/products#product-launch-stages). Cloud Run supports ALPHA, BETA, and GA.
        If no value is specified, GA is assumed. Set the launch stage to a preview stage on input to allow use of preview features in that stage. On read (or output), describes whether the resource uses preview features.
        For example, if ALPHA is provided as input, but only BETA and GA-level features are used, this field will be BETA on output.
        Possible values are: `UNIMPLEMENTED`, `PRELAUNCH`, `EARLY_ACCESS`, `ALPHA`, `BETA`, `GA`, `DEPRECATED`.
        """
        return pulumi.get(self, "launch_stage")

    @launch_stage.setter
    def launch_stage(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "launch_stage", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location of the cloud run job
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Job.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _JobState:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 binary_authorization: Optional[pulumi.Input['JobBinaryAuthorizationArgs']] = None,
                 client: Optional[pulumi.Input[str]] = None,
                 client_version: Optional[pulumi.Input[str]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['JobConditionArgs']]]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 execution_count: Optional[pulumi.Input[int]] = None,
                 generation: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 latest_created_executions: Optional[pulumi.Input[Sequence[pulumi.Input['JobLatestCreatedExecutionArgs']]]] = None,
                 launch_stage: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 observed_generation: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 reconciling: Optional[pulumi.Input[bool]] = None,
                 template: Optional[pulumi.Input['JobTemplateArgs']] = None,
                 terminal_conditions: Optional[pulumi.Input[Sequence[pulumi.Input['JobTerminalConditionArgs']]]] = None,
                 uid: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Job resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
               Cloud Run API v2 does not support annotations with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
               All system annotations in v1 now have a corresponding field in v2 ExecutionTemplate.
               This field follows Kubernetes annotations' namespacing, limits, and rules.
               
               (Optional)
               Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
               Cloud Run API v2 does not support annotations with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected on new resources.
               All system annotations in v1 now have a corresponding field in v2 Job.
               This field follows Kubernetes annotations' namespacing, limits, and rules.
        :param pulumi.Input['JobBinaryAuthorizationArgs'] binary_authorization: Settings for the Binary Authorization feature.
               Structure is documented below.
        :param pulumi.Input[str] client: Arbitrary identifier for the API client.
        :param pulumi.Input[str] client_version: Arbitrary version identifier for the API client.
        :param pulumi.Input[Sequence[pulumi.Input['JobConditionArgs']]] conditions: The Conditions of all other associated sub-resources. They contain additional diagnostics information in case the Job does not reach its desired state. See comments in reconciling for additional information on `reconciliation` process in Cloud Run.
               Structure is documented below.
        :param pulumi.Input[str] etag: A system-generated fingerprint for this version of the resource. May be used to detect modification conflict during updates.
        :param pulumi.Input[int] execution_count: Number of executions created for this job.
        :param pulumi.Input[str] generation: A number that monotonically increases every time the user modifies the desired state.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter,
               or break down billing charges by team, component, environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or
               https://cloud.google.com/run/docs/configuring/labels.
               Cloud Run API v2 does not support labels with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
               All system labels in v1 now have a corresponding field in v2 ExecutionTemplate.
               
               (Optional)
               Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter, or break down billing charges by team, component,
               environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or https://cloud.google.com/run/docs/configuring/labels.
               Cloud Run API v2 does not support labels with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
               All system labels in v1 now have a corresponding field in v2 Job.
        :param pulumi.Input[Sequence[pulumi.Input['JobLatestCreatedExecutionArgs']]] latest_created_executions: Name of the last created execution.
               Structure is documented below.
        :param pulumi.Input[str] launch_stage: The launch stage as defined by [Google Cloud Platform Launch Stages](https://cloud.google.com/products#product-launch-stages). Cloud Run supports ALPHA, BETA, and GA.
               If no value is specified, GA is assumed. Set the launch stage to a preview stage on input to allow use of preview features in that stage. On read (or output), describes whether the resource uses preview features.
               For example, if ALPHA is provided as input, but only BETA and GA-level features are used, this field will be BETA on output.
               Possible values are: `UNIMPLEMENTED`, `PRELAUNCH`, `EARLY_ACCESS`, `ALPHA`, `BETA`, `GA`, `DEPRECATED`.
        :param pulumi.Input[str] location: The location of the cloud run job
        :param pulumi.Input[str] name: Name of the Job.
        :param pulumi.Input[str] observed_generation: The generation of this Job. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[bool] reconciling: Returns true if the Job is currently being acted upon by the system to bring it into the desired state.
               When a new Job is created, or an existing one is updated, Cloud Run will asynchronously perform all necessary steps to bring the Job to the desired state. This process is called reconciliation. While reconciliation is in process, observedGeneration and latest_succeeded_execution, will have transient values that might mismatch the intended state: Once reconciliation is over (and this field is false), there are two possible outcomes: reconciliation succeeded and the state matches the Job, or there was an error, and reconciliation failed. This state can be found in terminalCondition.state.
               If reconciliation succeeded, the following fields will match: observedGeneration and generation, latest_succeeded_execution and latestCreatedExecution.
               If reconciliation failed, observedGeneration and latest_succeeded_execution will have the state of the last succeeded execution or empty for newly created Job. Additional information on the failure can be found in terminalCondition and conditions
        :param pulumi.Input['JobTemplateArgs'] template: The template used to create executions for this Job.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['JobTerminalConditionArgs']]] terminal_conditions: The Condition of this Job, containing its readiness status, and detailed error information in case it did not reach the desired state
               Structure is documented below.
        :param pulumi.Input[str] uid: Server assigned unique identifier for the Execution. The value is a UUID4 string and guaranteed to remain unchanged until the resource is deleted.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if binary_authorization is not None:
            pulumi.set(__self__, "binary_authorization", binary_authorization)
        if client is not None:
            pulumi.set(__self__, "client", client)
        if client_version is not None:
            pulumi.set(__self__, "client_version", client_version)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if execution_count is not None:
            pulumi.set(__self__, "execution_count", execution_count)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if latest_created_executions is not None:
            pulumi.set(__self__, "latest_created_executions", latest_created_executions)
        if launch_stage is not None:
            pulumi.set(__self__, "launch_stage", launch_stage)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if reconciling is not None:
            pulumi.set(__self__, "reconciling", reconciling)
        if template is not None:
            pulumi.set(__self__, "template", template)
        if terminal_conditions is not None:
            pulumi.set(__self__, "terminal_conditions", terminal_conditions)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
        Cloud Run API v2 does not support annotations with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
        All system annotations in v1 now have a corresponding field in v2 ExecutionTemplate.
        This field follows Kubernetes annotations' namespacing, limits, and rules.

        (Optional)
        Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
        Cloud Run API v2 does not support annotations with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected on new resources.
        All system annotations in v1 now have a corresponding field in v2 Job.
        This field follows Kubernetes annotations' namespacing, limits, and rules.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="binaryAuthorization")
    def binary_authorization(self) -> Optional[pulumi.Input['JobBinaryAuthorizationArgs']]:
        """
        Settings for the Binary Authorization feature.
        Structure is documented below.
        """
        return pulumi.get(self, "binary_authorization")

    @binary_authorization.setter
    def binary_authorization(self, value: Optional[pulumi.Input['JobBinaryAuthorizationArgs']]):
        pulumi.set(self, "binary_authorization", value)

    @property
    @pulumi.getter
    def client(self) -> Optional[pulumi.Input[str]]:
        """
        Arbitrary identifier for the API client.
        """
        return pulumi.get(self, "client")

    @client.setter
    def client(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client", value)

    @property
    @pulumi.getter(name="clientVersion")
    def client_version(self) -> Optional[pulumi.Input[str]]:
        """
        Arbitrary version identifier for the API client.
        """
        return pulumi.get(self, "client_version")

    @client_version.setter
    def client_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_version", value)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobConditionArgs']]]]:
        """
        The Conditions of all other associated sub-resources. They contain additional diagnostics information in case the Job does not reach its desired state. See comments in reconciling for additional information on `reconciliation` process in Cloud Run.
        Structure is documented below.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        A system-generated fingerprint for this version of the resource. May be used to detect modification conflict during updates.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter(name="executionCount")
    def execution_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of executions created for this job.
        """
        return pulumi.get(self, "execution_count")

    @execution_count.setter
    def execution_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "execution_count", value)

    @property
    @pulumi.getter
    def generation(self) -> Optional[pulumi.Input[str]]:
        """
        A number that monotonically increases every time the user modifies the desired state.
        """
        return pulumi.get(self, "generation")

    @generation.setter
    def generation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "generation", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter,
        or break down billing charges by team, component, environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or
        https://cloud.google.com/run/docs/configuring/labels.
        Cloud Run API v2 does not support labels with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
        All system labels in v1 now have a corresponding field in v2 ExecutionTemplate.

        (Optional)
        Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter, or break down billing charges by team, component,
        environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or https://cloud.google.com/run/docs/configuring/labels.
        Cloud Run API v2 does not support labels with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
        All system labels in v1 now have a corresponding field in v2 Job.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="latestCreatedExecutions")
    def latest_created_executions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobLatestCreatedExecutionArgs']]]]:
        """
        Name of the last created execution.
        Structure is documented below.
        """
        return pulumi.get(self, "latest_created_executions")

    @latest_created_executions.setter
    def latest_created_executions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobLatestCreatedExecutionArgs']]]]):
        pulumi.set(self, "latest_created_executions", value)

    @property
    @pulumi.getter(name="launchStage")
    def launch_stage(self) -> Optional[pulumi.Input[str]]:
        """
        The launch stage as defined by [Google Cloud Platform Launch Stages](https://cloud.google.com/products#product-launch-stages). Cloud Run supports ALPHA, BETA, and GA.
        If no value is specified, GA is assumed. Set the launch stage to a preview stage on input to allow use of preview features in that stage. On read (or output), describes whether the resource uses preview features.
        For example, if ALPHA is provided as input, but only BETA and GA-level features are used, this field will be BETA on output.
        Possible values are: `UNIMPLEMENTED`, `PRELAUNCH`, `EARLY_ACCESS`, `ALPHA`, `BETA`, `GA`, `DEPRECATED`.
        """
        return pulumi.get(self, "launch_stage")

    @launch_stage.setter
    def launch_stage(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "launch_stage", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location of the cloud run job
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Job.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[pulumi.Input[str]]:
        """
        The generation of this Job. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        """
        return pulumi.get(self, "observed_generation")

    @observed_generation.setter
    def observed_generation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "observed_generation", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def reconciling(self) -> Optional[pulumi.Input[bool]]:
        """
        Returns true if the Job is currently being acted upon by the system to bring it into the desired state.
        When a new Job is created, or an existing one is updated, Cloud Run will asynchronously perform all necessary steps to bring the Job to the desired state. This process is called reconciliation. While reconciliation is in process, observedGeneration and latest_succeeded_execution, will have transient values that might mismatch the intended state: Once reconciliation is over (and this field is false), there are two possible outcomes: reconciliation succeeded and the state matches the Job, or there was an error, and reconciliation failed. This state can be found in terminalCondition.state.
        If reconciliation succeeded, the following fields will match: observedGeneration and generation, latest_succeeded_execution and latestCreatedExecution.
        If reconciliation failed, observedGeneration and latest_succeeded_execution will have the state of the last succeeded execution or empty for newly created Job. Additional information on the failure can be found in terminalCondition and conditions
        """
        return pulumi.get(self, "reconciling")

    @reconciling.setter
    def reconciling(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reconciling", value)

    @property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input['JobTemplateArgs']]:
        """
        The template used to create executions for this Job.
        Structure is documented below.
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input['JobTemplateArgs']]):
        pulumi.set(self, "template", value)

    @property
    @pulumi.getter(name="terminalConditions")
    def terminal_conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobTerminalConditionArgs']]]]:
        """
        The Condition of this Job, containing its readiness status, and detailed error information in case it did not reach the desired state
        Structure is documented below.
        """
        return pulumi.get(self, "terminal_conditions")

    @terminal_conditions.setter
    def terminal_conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobTerminalConditionArgs']]]]):
        pulumi.set(self, "terminal_conditions", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        Server assigned unique identifier for the Execution. The value is a UUID4 string and guaranteed to remain unchanged until the resource is deleted.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)


class Job(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 binary_authorization: Optional[pulumi.Input[pulumi.InputType['JobBinaryAuthorizationArgs']]] = None,
                 client: Optional[pulumi.Input[str]] = None,
                 client_version: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 launch_stage: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 template: Optional[pulumi.Input[pulumi.InputType['JobTemplateArgs']]] = None,
                 __props__=None):
        """
        A Cloud Run Job resource that references a container image which is run to completion.

        To get more information about Job, see:

        * [API documentation](https://cloud.google.com/run/docs/reference/rest/v2/projects.locations.jobs)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/run/docs/)

        ## Example Usage
        ### Cloudrunv2 Job Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.Job("default",
            location="us-central1",
            template=gcp.cloudrunv2.JobTemplateArgs(
                template=gcp.cloudrunv2.JobTemplateTemplateArgs(
                    containers=[gcp.cloudrunv2.JobTemplateTemplateContainerArgs(
                        image="us-docker.pkg.dev/cloudrun/container/hello",
                    )],
                ),
            ))
        ```
        ### Cloudrunv2 Job Sql

        ```python
        import pulumi
        import pulumi_gcp as gcp

        secret = gcp.secretmanager.Secret("secret",
            secret_id="secret",
            replication=gcp.secretmanager.SecretReplicationArgs(
                automatic=True,
            ))
        instance = gcp.sql.DatabaseInstance("instance",
            region="us-central1",
            database_version="MYSQL_5_7",
            settings=gcp.sql.DatabaseInstanceSettingsArgs(
                tier="db-f1-micro",
            ),
            deletion_protection=True)
        default = gcp.cloudrunv2.Job("default",
            location="us-central1",
            template=gcp.cloudrunv2.JobTemplateArgs(
                template=gcp.cloudrunv2.JobTemplateTemplateArgs(
                    volumes=[gcp.cloudrunv2.JobTemplateTemplateVolumeArgs(
                        name="cloudsql",
                        cloud_sql_instance=gcp.cloudrunv2.JobTemplateTemplateVolumeCloudSqlInstanceArgs(
                            instances=[instance.connection_name],
                        ),
                    )],
                    containers=[gcp.cloudrunv2.JobTemplateTemplateContainerArgs(
                        image="us-docker.pkg.dev/cloudrun/container/hello",
                        envs=[
                            gcp.cloudrunv2.JobTemplateTemplateContainerEnvArgs(
                                name="FOO",
                                value="bar",
                            ),
                            gcp.cloudrunv2.JobTemplateTemplateContainerEnvArgs(
                                name="latestdclsecret",
                                value_source=gcp.cloudrunv2.JobTemplateTemplateContainerEnvValueSourceArgs(
                                    secret_key_ref=gcp.cloudrunv2.JobTemplateTemplateContainerEnvValueSourceSecretKeyRefArgs(
                                        secret=secret.secret_id,
                                        version="1",
                                    ),
                                ),
                            ),
                        ],
                        volume_mounts=[gcp.cloudrunv2.JobTemplateTemplateContainerVolumeMountArgs(
                            name="cloudsql",
                            mount_path="/cloudsql",
                        )],
                    )],
                ),
            ))
        project = gcp.organizations.get_project()
        secret_version_data = gcp.secretmanager.SecretVersion("secret-version-data",
            secret=secret.name,
            secret_data="secret-data")
        secret_access = gcp.secretmanager.SecretIamMember("secret-access",
            secret_id=secret.id,
            role="roles/secretmanager.secretAccessor",
            member=f"serviceAccount:{project.number}-compute@developer.gserviceaccount.com",
            opts=pulumi.ResourceOptions(depends_on=[secret]))
        ```
        ### Cloudrunv2 Job Vpcaccess

        ```python
        import pulumi
        import pulumi_gcp as gcp

        custom_test_network = gcp.compute.Network("customTestNetwork", auto_create_subnetworks=False)
        custom_test_subnetwork = gcp.compute.Subnetwork("customTestSubnetwork",
            ip_cidr_range="10.2.0.0/28",
            region="us-central1",
            network=custom_test_network.id)
        connector = gcp.vpcaccess.Connector("connector",
            subnet=gcp.vpcaccess.ConnectorSubnetArgs(
                name=custom_test_subnetwork.name,
            ),
            machine_type="e2-standard-4",
            min_instances=2,
            max_instances=3,
            region="us-central1")
        default = gcp.cloudrunv2.Job("default",
            location="us-central1",
            template=gcp.cloudrunv2.JobTemplateArgs(
                template=gcp.cloudrunv2.JobTemplateTemplateArgs(
                    containers=[gcp.cloudrunv2.JobTemplateTemplateContainerArgs(
                        image="us-docker.pkg.dev/cloudrun/container/hello",
                    )],
                    vpc_access=gcp.cloudrunv2.JobTemplateTemplateVpcAccessArgs(
                        connector=connector.id,
                        egress="ALL_TRAFFIC",
                    ),
                ),
            ))
        ```
        ### Cloudrunv2 Job Secret

        ```python
        import pulumi
        import pulumi_gcp as gcp

        secret = gcp.secretmanager.Secret("secret",
            secret_id="secret",
            replication=gcp.secretmanager.SecretReplicationArgs(
                automatic=True,
            ))
        default = gcp.cloudrunv2.Job("default",
            location="us-central1",
            template=gcp.cloudrunv2.JobTemplateArgs(
                template=gcp.cloudrunv2.JobTemplateTemplateArgs(
                    volumes=[gcp.cloudrunv2.JobTemplateTemplateVolumeArgs(
                        name="a-volume",
                        secret=gcp.cloudrunv2.JobTemplateTemplateVolumeSecretArgs(
                            secret=secret.secret_id,
                            default_mode=292,
                            items=[gcp.cloudrunv2.JobTemplateTemplateVolumeSecretItemArgs(
                                version="1",
                                path="my-secret",
                                mode=256,
                            )],
                        ),
                    )],
                    containers=[gcp.cloudrunv2.JobTemplateTemplateContainerArgs(
                        image="us-docker.pkg.dev/cloudrun/container/hello",
                        volume_mounts=[gcp.cloudrunv2.JobTemplateTemplateContainerVolumeMountArgs(
                            name="a-volume",
                            mount_path="/secrets",
                        )],
                    )],
                ),
            ))
        project = gcp.organizations.get_project()
        secret_version_data = gcp.secretmanager.SecretVersion("secret-version-data",
            secret=secret.name,
            secret_data="secret-data")
        secret_access = gcp.secretmanager.SecretIamMember("secret-access",
            secret_id=secret.id,
            role="roles/secretmanager.secretAccessor",
            member=f"serviceAccount:{project.number}-compute@developer.gserviceaccount.com",
            opts=pulumi.ResourceOptions(depends_on=[secret]))
        ```
        ### Cloudrunv2 Job Emptydir

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.Job("default",
            location="us-central1",
            launch_stage="BETA",
            template=gcp.cloudrunv2.JobTemplateArgs(
                template=gcp.cloudrunv2.JobTemplateTemplateArgs(
                    containers=[gcp.cloudrunv2.JobTemplateTemplateContainerArgs(
                        image="us-docker.pkg.dev/cloudrun/container/hello",
                        volume_mounts=[gcp.cloudrunv2.JobTemplateTemplateContainerVolumeMountArgs(
                            name="empty-dir-volume",
                            mount_path="/mnt",
                        )],
                    )],
                    volumes=[gcp.cloudrunv2.JobTemplateTemplateVolumeArgs(
                        name="empty-dir-volume",
                        empty_dir=gcp.cloudrunv2.JobTemplateTemplateVolumeEmptyDirArgs(
                            medium="MEMORY",
                            size_limit="128Mi",
                        ),
                    )],
                ),
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```

        ## Import

        Job can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:cloudrunv2/job:Job default projects/{{project}}/locations/{{location}}/jobs/{{name}}
        ```

        ```sh
         $ pulumi import gcp:cloudrunv2/job:Job default {{project}}/{{location}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:cloudrunv2/job:Job default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
               Cloud Run API v2 does not support annotations with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
               All system annotations in v1 now have a corresponding field in v2 ExecutionTemplate.
               This field follows Kubernetes annotations' namespacing, limits, and rules.
               
               (Optional)
               Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
               Cloud Run API v2 does not support annotations with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected on new resources.
               All system annotations in v1 now have a corresponding field in v2 Job.
               This field follows Kubernetes annotations' namespacing, limits, and rules.
        :param pulumi.Input[pulumi.InputType['JobBinaryAuthorizationArgs']] binary_authorization: Settings for the Binary Authorization feature.
               Structure is documented below.
        :param pulumi.Input[str] client: Arbitrary identifier for the API client.
        :param pulumi.Input[str] client_version: Arbitrary version identifier for the API client.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter,
               or break down billing charges by team, component, environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or
               https://cloud.google.com/run/docs/configuring/labels.
               Cloud Run API v2 does not support labels with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
               All system labels in v1 now have a corresponding field in v2 ExecutionTemplate.
               
               (Optional)
               Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter, or break down billing charges by team, component,
               environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or https://cloud.google.com/run/docs/configuring/labels.
               Cloud Run API v2 does not support labels with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
               All system labels in v1 now have a corresponding field in v2 Job.
        :param pulumi.Input[str] launch_stage: The launch stage as defined by [Google Cloud Platform Launch Stages](https://cloud.google.com/products#product-launch-stages). Cloud Run supports ALPHA, BETA, and GA.
               If no value is specified, GA is assumed. Set the launch stage to a preview stage on input to allow use of preview features in that stage. On read (or output), describes whether the resource uses preview features.
               For example, if ALPHA is provided as input, but only BETA and GA-level features are used, this field will be BETA on output.
               Possible values are: `UNIMPLEMENTED`, `PRELAUNCH`, `EARLY_ACCESS`, `ALPHA`, `BETA`, `GA`, `DEPRECATED`.
        :param pulumi.Input[str] location: The location of the cloud run job
        :param pulumi.Input[str] name: Name of the Job.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[pulumi.InputType['JobTemplateArgs']] template: The template used to create executions for this Job.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: JobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Cloud Run Job resource that references a container image which is run to completion.

        To get more information about Job, see:

        * [API documentation](https://cloud.google.com/run/docs/reference/rest/v2/projects.locations.jobs)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/run/docs/)

        ## Example Usage
        ### Cloudrunv2 Job Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.Job("default",
            location="us-central1",
            template=gcp.cloudrunv2.JobTemplateArgs(
                template=gcp.cloudrunv2.JobTemplateTemplateArgs(
                    containers=[gcp.cloudrunv2.JobTemplateTemplateContainerArgs(
                        image="us-docker.pkg.dev/cloudrun/container/hello",
                    )],
                ),
            ))
        ```
        ### Cloudrunv2 Job Sql

        ```python
        import pulumi
        import pulumi_gcp as gcp

        secret = gcp.secretmanager.Secret("secret",
            secret_id="secret",
            replication=gcp.secretmanager.SecretReplicationArgs(
                automatic=True,
            ))
        instance = gcp.sql.DatabaseInstance("instance",
            region="us-central1",
            database_version="MYSQL_5_7",
            settings=gcp.sql.DatabaseInstanceSettingsArgs(
                tier="db-f1-micro",
            ),
            deletion_protection=True)
        default = gcp.cloudrunv2.Job("default",
            location="us-central1",
            template=gcp.cloudrunv2.JobTemplateArgs(
                template=gcp.cloudrunv2.JobTemplateTemplateArgs(
                    volumes=[gcp.cloudrunv2.JobTemplateTemplateVolumeArgs(
                        name="cloudsql",
                        cloud_sql_instance=gcp.cloudrunv2.JobTemplateTemplateVolumeCloudSqlInstanceArgs(
                            instances=[instance.connection_name],
                        ),
                    )],
                    containers=[gcp.cloudrunv2.JobTemplateTemplateContainerArgs(
                        image="us-docker.pkg.dev/cloudrun/container/hello",
                        envs=[
                            gcp.cloudrunv2.JobTemplateTemplateContainerEnvArgs(
                                name="FOO",
                                value="bar",
                            ),
                            gcp.cloudrunv2.JobTemplateTemplateContainerEnvArgs(
                                name="latestdclsecret",
                                value_source=gcp.cloudrunv2.JobTemplateTemplateContainerEnvValueSourceArgs(
                                    secret_key_ref=gcp.cloudrunv2.JobTemplateTemplateContainerEnvValueSourceSecretKeyRefArgs(
                                        secret=secret.secret_id,
                                        version="1",
                                    ),
                                ),
                            ),
                        ],
                        volume_mounts=[gcp.cloudrunv2.JobTemplateTemplateContainerVolumeMountArgs(
                            name="cloudsql",
                            mount_path="/cloudsql",
                        )],
                    )],
                ),
            ))
        project = gcp.organizations.get_project()
        secret_version_data = gcp.secretmanager.SecretVersion("secret-version-data",
            secret=secret.name,
            secret_data="secret-data")
        secret_access = gcp.secretmanager.SecretIamMember("secret-access",
            secret_id=secret.id,
            role="roles/secretmanager.secretAccessor",
            member=f"serviceAccount:{project.number}-compute@developer.gserviceaccount.com",
            opts=pulumi.ResourceOptions(depends_on=[secret]))
        ```
        ### Cloudrunv2 Job Vpcaccess

        ```python
        import pulumi
        import pulumi_gcp as gcp

        custom_test_network = gcp.compute.Network("customTestNetwork", auto_create_subnetworks=False)
        custom_test_subnetwork = gcp.compute.Subnetwork("customTestSubnetwork",
            ip_cidr_range="10.2.0.0/28",
            region="us-central1",
            network=custom_test_network.id)
        connector = gcp.vpcaccess.Connector("connector",
            subnet=gcp.vpcaccess.ConnectorSubnetArgs(
                name=custom_test_subnetwork.name,
            ),
            machine_type="e2-standard-4",
            min_instances=2,
            max_instances=3,
            region="us-central1")
        default = gcp.cloudrunv2.Job("default",
            location="us-central1",
            template=gcp.cloudrunv2.JobTemplateArgs(
                template=gcp.cloudrunv2.JobTemplateTemplateArgs(
                    containers=[gcp.cloudrunv2.JobTemplateTemplateContainerArgs(
                        image="us-docker.pkg.dev/cloudrun/container/hello",
                    )],
                    vpc_access=gcp.cloudrunv2.JobTemplateTemplateVpcAccessArgs(
                        connector=connector.id,
                        egress="ALL_TRAFFIC",
                    ),
                ),
            ))
        ```
        ### Cloudrunv2 Job Secret

        ```python
        import pulumi
        import pulumi_gcp as gcp

        secret = gcp.secretmanager.Secret("secret",
            secret_id="secret",
            replication=gcp.secretmanager.SecretReplicationArgs(
                automatic=True,
            ))
        default = gcp.cloudrunv2.Job("default",
            location="us-central1",
            template=gcp.cloudrunv2.JobTemplateArgs(
                template=gcp.cloudrunv2.JobTemplateTemplateArgs(
                    volumes=[gcp.cloudrunv2.JobTemplateTemplateVolumeArgs(
                        name="a-volume",
                        secret=gcp.cloudrunv2.JobTemplateTemplateVolumeSecretArgs(
                            secret=secret.secret_id,
                            default_mode=292,
                            items=[gcp.cloudrunv2.JobTemplateTemplateVolumeSecretItemArgs(
                                version="1",
                                path="my-secret",
                                mode=256,
                            )],
                        ),
                    )],
                    containers=[gcp.cloudrunv2.JobTemplateTemplateContainerArgs(
                        image="us-docker.pkg.dev/cloudrun/container/hello",
                        volume_mounts=[gcp.cloudrunv2.JobTemplateTemplateContainerVolumeMountArgs(
                            name="a-volume",
                            mount_path="/secrets",
                        )],
                    )],
                ),
            ))
        project = gcp.organizations.get_project()
        secret_version_data = gcp.secretmanager.SecretVersion("secret-version-data",
            secret=secret.name,
            secret_data="secret-data")
        secret_access = gcp.secretmanager.SecretIamMember("secret-access",
            secret_id=secret.id,
            role="roles/secretmanager.secretAccessor",
            member=f"serviceAccount:{project.number}-compute@developer.gserviceaccount.com",
            opts=pulumi.ResourceOptions(depends_on=[secret]))
        ```
        ### Cloudrunv2 Job Emptydir

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.Job("default",
            location="us-central1",
            launch_stage="BETA",
            template=gcp.cloudrunv2.JobTemplateArgs(
                template=gcp.cloudrunv2.JobTemplateTemplateArgs(
                    containers=[gcp.cloudrunv2.JobTemplateTemplateContainerArgs(
                        image="us-docker.pkg.dev/cloudrun/container/hello",
                        volume_mounts=[gcp.cloudrunv2.JobTemplateTemplateContainerVolumeMountArgs(
                            name="empty-dir-volume",
                            mount_path="/mnt",
                        )],
                    )],
                    volumes=[gcp.cloudrunv2.JobTemplateTemplateVolumeArgs(
                        name="empty-dir-volume",
                        empty_dir=gcp.cloudrunv2.JobTemplateTemplateVolumeEmptyDirArgs(
                            medium="MEMORY",
                            size_limit="128Mi",
                        ),
                    )],
                ),
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```

        ## Import

        Job can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:cloudrunv2/job:Job default projects/{{project}}/locations/{{location}}/jobs/{{name}}
        ```

        ```sh
         $ pulumi import gcp:cloudrunv2/job:Job default {{project}}/{{location}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:cloudrunv2/job:Job default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param JobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(JobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 binary_authorization: Optional[pulumi.Input[pulumi.InputType['JobBinaryAuthorizationArgs']]] = None,
                 client: Optional[pulumi.Input[str]] = None,
                 client_version: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 launch_stage: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 template: Optional[pulumi.Input[pulumi.InputType['JobTemplateArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = JobArgs.__new__(JobArgs)

            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["binary_authorization"] = binary_authorization
            __props__.__dict__["client"] = client
            __props__.__dict__["client_version"] = client_version
            __props__.__dict__["labels"] = labels
            __props__.__dict__["launch_stage"] = launch_stage
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            if template is None and not opts.urn:
                raise TypeError("Missing required property 'template'")
            __props__.__dict__["template"] = template
            __props__.__dict__["conditions"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["execution_count"] = None
            __props__.__dict__["generation"] = None
            __props__.__dict__["latest_created_executions"] = None
            __props__.__dict__["observed_generation"] = None
            __props__.__dict__["reconciling"] = None
            __props__.__dict__["terminal_conditions"] = None
            __props__.__dict__["uid"] = None
        super(Job, __self__).__init__(
            'gcp:cloudrunv2/job:Job',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            binary_authorization: Optional[pulumi.Input[pulumi.InputType['JobBinaryAuthorizationArgs']]] = None,
            client: Optional[pulumi.Input[str]] = None,
            client_version: Optional[pulumi.Input[str]] = None,
            conditions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['JobConditionArgs']]]]] = None,
            etag: Optional[pulumi.Input[str]] = None,
            execution_count: Optional[pulumi.Input[int]] = None,
            generation: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            latest_created_executions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['JobLatestCreatedExecutionArgs']]]]] = None,
            launch_stage: Optional[pulumi.Input[str]] = None,
            location: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            observed_generation: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            reconciling: Optional[pulumi.Input[bool]] = None,
            template: Optional[pulumi.Input[pulumi.InputType['JobTemplateArgs']]] = None,
            terminal_conditions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['JobTerminalConditionArgs']]]]] = None,
            uid: Optional[pulumi.Input[str]] = None) -> 'Job':
        """
        Get an existing Job resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
               Cloud Run API v2 does not support annotations with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
               All system annotations in v1 now have a corresponding field in v2 ExecutionTemplate.
               This field follows Kubernetes annotations' namespacing, limits, and rules.
               
               (Optional)
               Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
               Cloud Run API v2 does not support annotations with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected on new resources.
               All system annotations in v1 now have a corresponding field in v2 Job.
               This field follows Kubernetes annotations' namespacing, limits, and rules.
        :param pulumi.Input[pulumi.InputType['JobBinaryAuthorizationArgs']] binary_authorization: Settings for the Binary Authorization feature.
               Structure is documented below.
        :param pulumi.Input[str] client: Arbitrary identifier for the API client.
        :param pulumi.Input[str] client_version: Arbitrary version identifier for the API client.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['JobConditionArgs']]]] conditions: The Conditions of all other associated sub-resources. They contain additional diagnostics information in case the Job does not reach its desired state. See comments in reconciling for additional information on `reconciliation` process in Cloud Run.
               Structure is documented below.
        :param pulumi.Input[str] etag: A system-generated fingerprint for this version of the resource. May be used to detect modification conflict during updates.
        :param pulumi.Input[int] execution_count: Number of executions created for this job.
        :param pulumi.Input[str] generation: A number that monotonically increases every time the user modifies the desired state.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter,
               or break down billing charges by team, component, environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or
               https://cloud.google.com/run/docs/configuring/labels.
               Cloud Run API v2 does not support labels with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
               All system labels in v1 now have a corresponding field in v2 ExecutionTemplate.
               
               (Optional)
               Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter, or break down billing charges by team, component,
               environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or https://cloud.google.com/run/docs/configuring/labels.
               Cloud Run API v2 does not support labels with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
               All system labels in v1 now have a corresponding field in v2 Job.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['JobLatestCreatedExecutionArgs']]]] latest_created_executions: Name of the last created execution.
               Structure is documented below.
        :param pulumi.Input[str] launch_stage: The launch stage as defined by [Google Cloud Platform Launch Stages](https://cloud.google.com/products#product-launch-stages). Cloud Run supports ALPHA, BETA, and GA.
               If no value is specified, GA is assumed. Set the launch stage to a preview stage on input to allow use of preview features in that stage. On read (or output), describes whether the resource uses preview features.
               For example, if ALPHA is provided as input, but only BETA and GA-level features are used, this field will be BETA on output.
               Possible values are: `UNIMPLEMENTED`, `PRELAUNCH`, `EARLY_ACCESS`, `ALPHA`, `BETA`, `GA`, `DEPRECATED`.
        :param pulumi.Input[str] location: The location of the cloud run job
        :param pulumi.Input[str] name: Name of the Job.
        :param pulumi.Input[str] observed_generation: The generation of this Job. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[bool] reconciling: Returns true if the Job is currently being acted upon by the system to bring it into the desired state.
               When a new Job is created, or an existing one is updated, Cloud Run will asynchronously perform all necessary steps to bring the Job to the desired state. This process is called reconciliation. While reconciliation is in process, observedGeneration and latest_succeeded_execution, will have transient values that might mismatch the intended state: Once reconciliation is over (and this field is false), there are two possible outcomes: reconciliation succeeded and the state matches the Job, or there was an error, and reconciliation failed. This state can be found in terminalCondition.state.
               If reconciliation succeeded, the following fields will match: observedGeneration and generation, latest_succeeded_execution and latestCreatedExecution.
               If reconciliation failed, observedGeneration and latest_succeeded_execution will have the state of the last succeeded execution or empty for newly created Job. Additional information on the failure can be found in terminalCondition and conditions
        :param pulumi.Input[pulumi.InputType['JobTemplateArgs']] template: The template used to create executions for this Job.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['JobTerminalConditionArgs']]]] terminal_conditions: The Condition of this Job, containing its readiness status, and detailed error information in case it did not reach the desired state
               Structure is documented below.
        :param pulumi.Input[str] uid: Server assigned unique identifier for the Execution. The value is a UUID4 string and guaranteed to remain unchanged until the resource is deleted.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _JobState.__new__(_JobState)

        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["binary_authorization"] = binary_authorization
        __props__.__dict__["client"] = client
        __props__.__dict__["client_version"] = client_version
        __props__.__dict__["conditions"] = conditions
        __props__.__dict__["etag"] = etag
        __props__.__dict__["execution_count"] = execution_count
        __props__.__dict__["generation"] = generation
        __props__.__dict__["labels"] = labels
        __props__.__dict__["latest_created_executions"] = latest_created_executions
        __props__.__dict__["launch_stage"] = launch_stage
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["observed_generation"] = observed_generation
        __props__.__dict__["project"] = project
        __props__.__dict__["reconciling"] = reconciling
        __props__.__dict__["template"] = template
        __props__.__dict__["terminal_conditions"] = terminal_conditions
        __props__.__dict__["uid"] = uid
        return Job(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
        Cloud Run API v2 does not support annotations with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
        All system annotations in v1 now have a corresponding field in v2 ExecutionTemplate.
        This field follows Kubernetes annotations' namespacing, limits, and rules.

        (Optional)
        Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
        Cloud Run API v2 does not support annotations with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected on new resources.
        All system annotations in v1 now have a corresponding field in v2 Job.
        This field follows Kubernetes annotations' namespacing, limits, and rules.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="binaryAuthorization")
    def binary_authorization(self) -> pulumi.Output[Optional['outputs.JobBinaryAuthorization']]:
        """
        Settings for the Binary Authorization feature.
        Structure is documented below.
        """
        return pulumi.get(self, "binary_authorization")

    @property
    @pulumi.getter
    def client(self) -> pulumi.Output[Optional[str]]:
        """
        Arbitrary identifier for the API client.
        """
        return pulumi.get(self, "client")

    @property
    @pulumi.getter(name="clientVersion")
    def client_version(self) -> pulumi.Output[Optional[str]]:
        """
        Arbitrary version identifier for the API client.
        """
        return pulumi.get(self, "client_version")

    @property
    @pulumi.getter
    def conditions(self) -> pulumi.Output[Sequence['outputs.JobCondition']]:
        """
        The Conditions of all other associated sub-resources. They contain additional diagnostics information in case the Job does not reach its desired state. See comments in reconciling for additional information on `reconciliation` process in Cloud Run.
        Structure is documented below.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        """
        A system-generated fingerprint for this version of the resource. May be used to detect modification conflict during updates.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="executionCount")
    def execution_count(self) -> pulumi.Output[int]:
        """
        Number of executions created for this job.
        """
        return pulumi.get(self, "execution_count")

    @property
    @pulumi.getter
    def generation(self) -> pulumi.Output[str]:
        """
        A number that monotonically increases every time the user modifies the desired state.
        """
        return pulumi.get(self, "generation")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter,
        or break down billing charges by team, component, environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or
        https://cloud.google.com/run/docs/configuring/labels.
        Cloud Run API v2 does not support labels with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
        All system labels in v1 now have a corresponding field in v2 ExecutionTemplate.

        (Optional)
        Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter, or break down billing charges by team, component,
        environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or https://cloud.google.com/run/docs/configuring/labels.
        Cloud Run API v2 does not support labels with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
        All system labels in v1 now have a corresponding field in v2 Job.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="latestCreatedExecutions")
    def latest_created_executions(self) -> pulumi.Output[Sequence['outputs.JobLatestCreatedExecution']]:
        """
        Name of the last created execution.
        Structure is documented below.
        """
        return pulumi.get(self, "latest_created_executions")

    @property
    @pulumi.getter(name="launchStage")
    def launch_stage(self) -> pulumi.Output[str]:
        """
        The launch stage as defined by [Google Cloud Platform Launch Stages](https://cloud.google.com/products#product-launch-stages). Cloud Run supports ALPHA, BETA, and GA.
        If no value is specified, GA is assumed. Set the launch stage to a preview stage on input to allow use of preview features in that stage. On read (or output), describes whether the resource uses preview features.
        For example, if ALPHA is provided as input, but only BETA and GA-level features are used, this field will be BETA on output.
        Possible values are: `UNIMPLEMENTED`, `PRELAUNCH`, `EARLY_ACCESS`, `ALPHA`, `BETA`, `GA`, `DEPRECATED`.
        """
        return pulumi.get(self, "launch_stage")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[str]]:
        """
        The location of the cloud run job
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the Job.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> pulumi.Output[str]:
        """
        The generation of this Job. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        """
        return pulumi.get(self, "observed_generation")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def reconciling(self) -> pulumi.Output[bool]:
        """
        Returns true if the Job is currently being acted upon by the system to bring it into the desired state.
        When a new Job is created, or an existing one is updated, Cloud Run will asynchronously perform all necessary steps to bring the Job to the desired state. This process is called reconciliation. While reconciliation is in process, observedGeneration and latest_succeeded_execution, will have transient values that might mismatch the intended state: Once reconciliation is over (and this field is false), there are two possible outcomes: reconciliation succeeded and the state matches the Job, or there was an error, and reconciliation failed. This state can be found in terminalCondition.state.
        If reconciliation succeeded, the following fields will match: observedGeneration and generation, latest_succeeded_execution and latestCreatedExecution.
        If reconciliation failed, observedGeneration and latest_succeeded_execution will have the state of the last succeeded execution or empty for newly created Job. Additional information on the failure can be found in terminalCondition and conditions
        """
        return pulumi.get(self, "reconciling")

    @property
    @pulumi.getter
    def template(self) -> pulumi.Output['outputs.JobTemplate']:
        """
        The template used to create executions for this Job.
        Structure is documented below.
        """
        return pulumi.get(self, "template")

    @property
    @pulumi.getter(name="terminalConditions")
    def terminal_conditions(self) -> pulumi.Output[Sequence['outputs.JobTerminalCondition']]:
        """
        The Condition of this Job, containing its readiness status, and detailed error information in case it did not reach the desired state
        Structure is documented below.
        """
        return pulumi.get(self, "terminal_conditions")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[str]:
        """
        Server assigned unique identifier for the Execution. The value is a UUID4 string and guaranteed to remain unchanged until the resource is deleted.
        """
        return pulumi.get(self, "uid")

