# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'JobBinaryAuthorization',
    'JobCondition',
    'JobIamBindingCondition',
    'JobIamMemberCondition',
    'JobLatestCreatedExecution',
    'JobTemplate',
    'JobTemplateTemplate',
    'JobTemplateTemplateContainer',
    'JobTemplateTemplateContainerEnv',
    'JobTemplateTemplateContainerEnvValueSource',
    'JobTemplateTemplateContainerEnvValueSourceSecretKeyRef',
    'JobTemplateTemplateContainerLivenessProbe',
    'JobTemplateTemplateContainerLivenessProbeHttpGet',
    'JobTemplateTemplateContainerLivenessProbeHttpGetHttpHeader',
    'JobTemplateTemplateContainerLivenessProbeTcpSocket',
    'JobTemplateTemplateContainerPort',
    'JobTemplateTemplateContainerResources',
    'JobTemplateTemplateContainerStartupProbe',
    'JobTemplateTemplateContainerStartupProbeHttpGet',
    'JobTemplateTemplateContainerStartupProbeHttpGetHttpHeader',
    'JobTemplateTemplateContainerStartupProbeTcpSocket',
    'JobTemplateTemplateContainerVolumeMount',
    'JobTemplateTemplateVolume',
    'JobTemplateTemplateVolumeCloudSqlInstance',
    'JobTemplateTemplateVolumeEmptyDir',
    'JobTemplateTemplateVolumeSecret',
    'JobTemplateTemplateVolumeSecretItem',
    'JobTemplateTemplateVpcAccess',
    'JobTerminalCondition',
    'ServiceBinaryAuthorization',
    'ServiceCondition',
    'ServiceIamBindingCondition',
    'ServiceIamMemberCondition',
    'ServiceTemplate',
    'ServiceTemplateContainer',
    'ServiceTemplateContainerEnv',
    'ServiceTemplateContainerEnvValueSource',
    'ServiceTemplateContainerEnvValueSourceSecretKeyRef',
    'ServiceTemplateContainerLivenessProbe',
    'ServiceTemplateContainerLivenessProbeGrpc',
    'ServiceTemplateContainerLivenessProbeHttpGet',
    'ServiceTemplateContainerLivenessProbeHttpGetHttpHeader',
    'ServiceTemplateContainerLivenessProbeTcpSocket',
    'ServiceTemplateContainerPort',
    'ServiceTemplateContainerResources',
    'ServiceTemplateContainerStartupProbe',
    'ServiceTemplateContainerStartupProbeGrpc',
    'ServiceTemplateContainerStartupProbeHttpGet',
    'ServiceTemplateContainerStartupProbeHttpGetHttpHeader',
    'ServiceTemplateContainerStartupProbeTcpSocket',
    'ServiceTemplateContainerVolumeMount',
    'ServiceTemplateScaling',
    'ServiceTemplateVolume',
    'ServiceTemplateVolumeCloudSqlInstance',
    'ServiceTemplateVolumeEmptyDir',
    'ServiceTemplateVolumeSecret',
    'ServiceTemplateVolumeSecretItem',
    'ServiceTemplateVpcAccess',
    'ServiceTerminalCondition',
    'ServiceTraffic',
    'ServiceTrafficStatus',
]

@pulumi.output_type
class JobBinaryAuthorization(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "breakglassJustification":
            suggest = "breakglass_justification"
        elif key == "useDefault":
            suggest = "use_default"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobBinaryAuthorization. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobBinaryAuthorization.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobBinaryAuthorization.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 breakglass_justification: Optional[str] = None,
                 use_default: Optional[bool] = None):
        """
        :param str breakglass_justification: If present, indicates to use Breakglass using this justification. If useDefault is False, then it must be empty. For more information on breakglass, see https://cloud.google.com/binary-authorization/docs/using-breakglass
        :param bool use_default: If True, indicates to use the default project's binary authorization policy. If False, binary authorization will be disabled.
        """
        if breakglass_justification is not None:
            pulumi.set(__self__, "breakglass_justification", breakglass_justification)
        if use_default is not None:
            pulumi.set(__self__, "use_default", use_default)

    @property
    @pulumi.getter(name="breakglassJustification")
    def breakglass_justification(self) -> Optional[str]:
        """
        If present, indicates to use Breakglass using this justification. If useDefault is False, then it must be empty. For more information on breakglass, see https://cloud.google.com/binary-authorization/docs/using-breakglass
        """
        return pulumi.get(self, "breakglass_justification")

    @property
    @pulumi.getter(name="useDefault")
    def use_default(self) -> Optional[bool]:
        """
        If True, indicates to use the default project's binary authorization policy. If False, binary authorization will be disabled.
        """
        return pulumi.get(self, "use_default")


@pulumi.output_type
class JobCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executionReason":
            suggest = "execution_reason"
        elif key == "lastTransitionTime":
            suggest = "last_transition_time"
        elif key == "revisionReason":
            suggest = "revision_reason"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execution_reason: Optional[str] = None,
                 last_transition_time: Optional[str] = None,
                 message: Optional[str] = None,
                 reason: Optional[str] = None,
                 revision_reason: Optional[str] = None,
                 severity: Optional[str] = None,
                 state: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str execution_reason: (Output)
               A reason for the execution condition.
        :param str last_transition_time: (Output)
               Last time the condition transitioned from one status to another.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param str message: (Output)
               Human readable message indicating details about the current status.
        :param str reason: (Output)
               A common (service-level) reason for this condition.
        :param str revision_reason: (Output)
               A reason for the revision condition.
        :param str severity: (Output)
               How to interpret failures of this condition, one of Error, Warning, Info
        :param str state: (Output)
               State of the condition.
        :param str type: (Output)
               type is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting Types common to all resources include: * "Ready": True when the Resource is ready.
        """
        if execution_reason is not None:
            pulumi.set(__self__, "execution_reason", execution_reason)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if revision_reason is not None:
            pulumi.set(__self__, "revision_reason", revision_reason)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="executionReason")
    def execution_reason(self) -> Optional[str]:
        """
        (Output)
        A reason for the execution condition.
        """
        return pulumi.get(self, "execution_reason")

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[str]:
        """
        (Output)
        Last time the condition transitioned from one status to another.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "last_transition_time")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        (Output)
        Human readable message indicating details about the current status.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def reason(self) -> Optional[str]:
        """
        (Output)
        A common (service-level) reason for this condition.
        """
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter(name="revisionReason")
    def revision_reason(self) -> Optional[str]:
        """
        (Output)
        A reason for the revision condition.
        """
        return pulumi.get(self, "revision_reason")

    @property
    @pulumi.getter
    def severity(self) -> Optional[str]:
        """
        (Output)
        How to interpret failures of this condition, one of Error, Warning, Info
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        (Output)
        State of the condition.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        (Output)
        type is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting Types common to all resources include: * "Ready": True when the Resource is ready.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class JobIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class JobIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class JobLatestCreatedExecution(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "completionTime":
            suggest = "completion_time"
        elif key == "createTime":
            suggest = "create_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobLatestCreatedExecution. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobLatestCreatedExecution.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobLatestCreatedExecution.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 completion_time: Optional[str] = None,
                 create_time: Optional[str] = None,
                 name: Optional[str] = None):
        """
        :param str completion_time: (Output)
               Completion timestamp of the execution.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param str create_time: (Output)
               Creation timestamp of the execution.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param str name: Name of the Job.
        """
        if completion_time is not None:
            pulumi.set(__self__, "completion_time", completion_time)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="completionTime")
    def completion_time(self) -> Optional[str]:
        """
        (Output)
        Completion timestamp of the execution.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "completion_time")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[str]:
        """
        (Output)
        Creation timestamp of the execution.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the Job.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class JobTemplate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskCount":
            suggest = "task_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 template: 'outputs.JobTemplateTemplate',
                 annotations: Optional[Mapping[str, str]] = None,
                 labels: Optional[Mapping[str, str]] = None,
                 parallelism: Optional[int] = None,
                 task_count: Optional[int] = None):
        """
        :param 'JobTemplateTemplateArgs' template: Describes the task(s) that will be created when executing an execution
               Structure is documented below.
        :param Mapping[str, str] annotations: Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
               Cloud Run API v2 does not support annotations with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
               All system annotations in v1 now have a corresponding field in v2 ExecutionTemplate.
               This field follows Kubernetes annotations' namespacing, limits, and rules.
        :param Mapping[str, str] labels: Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter,
               or break down billing charges by team, component, environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or
               https://cloud.google.com/run/docs/configuring/labels.
               Cloud Run API v2 does not support labels with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
               All system labels in v1 now have a corresponding field in v2 ExecutionTemplate.
        :param int parallelism: Specifies the maximum desired number of tasks the execution should run at given time. Must be <= taskCount. When the job is run, if this field is 0 or unset, the maximum possible value will be used for that execution. The actual number of tasks running in steady state will be less than this number when there are fewer tasks waiting to be completed remaining, i.e. when the work left to do is less than max parallelism.
        :param int task_count: Specifies the desired number of tasks the execution should run. Setting to 1 means that parallelism is limited to 1 and the success of that task signals the success of the execution. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
        """
        pulumi.set(__self__, "template", template)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if parallelism is not None:
            pulumi.set(__self__, "parallelism", parallelism)
        if task_count is not None:
            pulumi.set(__self__, "task_count", task_count)

    @property
    @pulumi.getter
    def template(self) -> 'outputs.JobTemplateTemplate':
        """
        Describes the task(s) that will be created when executing an execution
        Structure is documented below.
        """
        return pulumi.get(self, "template")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Mapping[str, str]]:
        """
        Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
        Cloud Run API v2 does not support annotations with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
        All system annotations in v1 now have a corresponding field in v2 ExecutionTemplate.
        This field follows Kubernetes annotations' namespacing, limits, and rules.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, str]]:
        """
        Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter,
        or break down billing charges by team, component, environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or
        https://cloud.google.com/run/docs/configuring/labels.
        Cloud Run API v2 does not support labels with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
        All system labels in v1 now have a corresponding field in v2 ExecutionTemplate.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def parallelism(self) -> Optional[int]:
        """
        Specifies the maximum desired number of tasks the execution should run at given time. Must be <= taskCount. When the job is run, if this field is 0 or unset, the maximum possible value will be used for that execution. The actual number of tasks running in steady state will be less than this number when there are fewer tasks waiting to be completed remaining, i.e. when the work left to do is less than max parallelism.
        """
        return pulumi.get(self, "parallelism")

    @property
    @pulumi.getter(name="taskCount")
    def task_count(self) -> Optional[int]:
        """
        Specifies the desired number of tasks the execution should run. Setting to 1 means that parallelism is limited to 1 and the success of that task signals the success of the execution. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
        """
        return pulumi.get(self, "task_count")


@pulumi.output_type
class JobTemplateTemplate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionKey":
            suggest = "encryption_key"
        elif key == "executionEnvironment":
            suggest = "execution_environment"
        elif key == "maxRetries":
            suggest = "max_retries"
        elif key == "serviceAccount":
            suggest = "service_account"
        elif key == "vpcAccess":
            suggest = "vpc_access"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 containers: Optional[Sequence['outputs.JobTemplateTemplateContainer']] = None,
                 encryption_key: Optional[str] = None,
                 execution_environment: Optional[str] = None,
                 max_retries: Optional[int] = None,
                 service_account: Optional[str] = None,
                 timeout: Optional[str] = None,
                 volumes: Optional[Sequence['outputs.JobTemplateTemplateVolume']] = None,
                 vpc_access: Optional['outputs.JobTemplateTemplateVpcAccess'] = None):
        """
        :param Sequence['JobTemplateTemplateContainerArgs'] containers: Holds the single container that defines the unit of execution for this task.
               Structure is documented below.
        :param str encryption_key: A reference to a customer managed encryption key (CMEK) to use to encrypt this container image. For more information, go to https://cloud.google.com/run/docs/securing/using-cmek
        :param str execution_environment: The execution environment being used to host this Task.
               Possible values are: `EXECUTION_ENVIRONMENT_GEN1`, `EXECUTION_ENVIRONMENT_GEN2`.
        :param int max_retries: Number of retries allowed per Task, before marking this Task failed.
        :param str service_account: Email address of the IAM service account associated with the Task of a Job. The service account represents the identity of the running task, and determines what permissions the task has. If not provided, the task will use the project's default service account.
        :param str timeout: Max allowed time duration the Task may be active before the system will actively try to mark it failed and kill associated containers. This applies per attempt of a task, meaning each retry can run for the full timeout.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        :param Sequence['JobTemplateTemplateVolumeArgs'] volumes: A list of Volumes to make available to containers.
               Structure is documented below.
        :param 'JobTemplateTemplateVpcAccessArgs' vpc_access: VPC Access configuration to use for this Task. For more information, visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
               Structure is documented below.
        """
        if containers is not None:
            pulumi.set(__self__, "containers", containers)
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)
        if execution_environment is not None:
            pulumi.set(__self__, "execution_environment", execution_environment)
        if max_retries is not None:
            pulumi.set(__self__, "max_retries", max_retries)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)
        if vpc_access is not None:
            pulumi.set(__self__, "vpc_access", vpc_access)

    @property
    @pulumi.getter
    def containers(self) -> Optional[Sequence['outputs.JobTemplateTemplateContainer']]:
        """
        Holds the single container that defines the unit of execution for this task.
        Structure is documented below.
        """
        return pulumi.get(self, "containers")

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional[str]:
        """
        A reference to a customer managed encryption key (CMEK) to use to encrypt this container image. For more information, go to https://cloud.google.com/run/docs/securing/using-cmek
        """
        return pulumi.get(self, "encryption_key")

    @property
    @pulumi.getter(name="executionEnvironment")
    def execution_environment(self) -> Optional[str]:
        """
        The execution environment being used to host this Task.
        Possible values are: `EXECUTION_ENVIRONMENT_GEN1`, `EXECUTION_ENVIRONMENT_GEN2`.
        """
        return pulumi.get(self, "execution_environment")

    @property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> Optional[int]:
        """
        Number of retries allowed per Task, before marking this Task failed.
        """
        return pulumi.get(self, "max_retries")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[str]:
        """
        Email address of the IAM service account associated with the Task of a Job. The service account represents the identity of the running task, and determines what permissions the task has. If not provided, the task will use the project's default service account.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[str]:
        """
        Max allowed time duration the Task may be active before the system will actively try to mark it failed and kill associated containers. This applies per attempt of a task, meaning each retry can run for the full timeout.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter
    def volumes(self) -> Optional[Sequence['outputs.JobTemplateTemplateVolume']]:
        """
        A list of Volumes to make available to containers.
        Structure is documented below.
        """
        return pulumi.get(self, "volumes")

    @property
    @pulumi.getter(name="vpcAccess")
    def vpc_access(self) -> Optional['outputs.JobTemplateTemplateVpcAccess']:
        """
        VPC Access configuration to use for this Task. For more information, visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
        Structure is documented below.
        """
        return pulumi.get(self, "vpc_access")


@pulumi.output_type
class JobTemplateTemplateContainer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "livenessProbe":
            suggest = "liveness_probe"
        elif key == "startupProbe":
            suggest = "startup_probe"
        elif key == "volumeMounts":
            suggest = "volume_mounts"
        elif key == "workingDir":
            suggest = "working_dir"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateTemplateContainer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateTemplateContainer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateTemplateContainer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image: str,
                 args: Optional[Sequence[str]] = None,
                 commands: Optional[Sequence[str]] = None,
                 envs: Optional[Sequence['outputs.JobTemplateTemplateContainerEnv']] = None,
                 liveness_probe: Optional['outputs.JobTemplateTemplateContainerLivenessProbe'] = None,
                 name: Optional[str] = None,
                 ports: Optional[Sequence['outputs.JobTemplateTemplateContainerPort']] = None,
                 resources: Optional['outputs.JobTemplateTemplateContainerResources'] = None,
                 startup_probe: Optional['outputs.JobTemplateTemplateContainerStartupProbe'] = None,
                 volume_mounts: Optional[Sequence['outputs.JobTemplateTemplateContainerVolumeMount']] = None,
                 working_dir: Optional[str] = None):
        """
        :param str image: URL of the Container image in Google Container Registry or Google Artifact Registry. More info: https://kubernetes.io/docs/concepts/containers/images
        :param Sequence[str] args: Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        :param Sequence[str] commands: Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        :param Sequence['JobTemplateTemplateContainerEnvArgs'] envs: List of environment variables to set in the container.
               Structure is documented below.
        :param 'JobTemplateTemplateContainerLivenessProbeArgs' liveness_probe: (Optional, Deprecated)
               Periodic probe of container liveness. Container will be restarted if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
               This field is not supported in Cloud Run Job currently.
               Structure is documented below.
        :param str name: Name of the container specified as a DNS_LABEL.
        :param Sequence['JobTemplateTemplateContainerPortArgs'] ports: List of ports to expose from the container. Only a single port can be specified. The specified ports must be listening on all interfaces (0.0.0.0) within the container to be accessible.
               If omitted, a port number will be chosen and passed to the container through the PORT environment variable for the container to listen on
               Structure is documented below.
        :param 'JobTemplateTemplateContainerResourcesArgs' resources: Compute Resource requirements by this container. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
               Structure is documented below.
        :param 'JobTemplateTemplateContainerStartupProbeArgs' startup_probe: (Optional, Deprecated)
               Startup probe of application within the container. All other probes are disabled if a startup probe is provided, until it succeeds. Container will not be added to service endpoints if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
               This field is not supported in Cloud Run Job currently.
               Structure is documented below.
        :param Sequence['JobTemplateTemplateContainerVolumeMountArgs'] volume_mounts: Volume to mount into the container's filesystem.
               Structure is documented below.
        :param str working_dir: Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image.
        """
        pulumi.set(__self__, "image", image)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if liveness_probe is not None:
            pulumi.set(__self__, "liveness_probe", liveness_probe)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if startup_probe is not None:
            pulumi.set(__self__, "startup_probe", startup_probe)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)
        if working_dir is not None:
            pulumi.set(__self__, "working_dir", working_dir)

    @property
    @pulumi.getter
    def image(self) -> str:
        """
        URL of the Container image in Google Container Registry or Google Artifact Registry. More info: https://kubernetes.io/docs/concepts/containers/images
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    def args(self) -> Optional[Sequence[str]]:
        """
        Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def commands(self) -> Optional[Sequence[str]]:
        """
        Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter
    def envs(self) -> Optional[Sequence['outputs.JobTemplateTemplateContainerEnv']]:
        """
        List of environment variables to set in the container.
        Structure is documented below.
        """
        return pulumi.get(self, "envs")

    @property
    @pulumi.getter(name="livenessProbe")
    def liveness_probe(self) -> Optional['outputs.JobTemplateTemplateContainerLivenessProbe']:
        """
        (Optional, Deprecated)
        Periodic probe of container liveness. Container will be restarted if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        This field is not supported in Cloud Run Job currently.
        Structure is documented below.
        """
        warnings.warn("""Cloud Run Job does not support liveness probe and `liveness_probe` field will be removed in a future major release.""", DeprecationWarning)
        pulumi.log.warn("""liveness_probe is deprecated: Cloud Run Job does not support liveness probe and `liveness_probe` field will be removed in a future major release.""")

        return pulumi.get(self, "liveness_probe")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the container specified as a DNS_LABEL.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def ports(self) -> Optional[Sequence['outputs.JobTemplateTemplateContainerPort']]:
        """
        List of ports to expose from the container. Only a single port can be specified. The specified ports must be listening on all interfaces (0.0.0.0) within the container to be accessible.
        If omitted, a port number will be chosen and passed to the container through the PORT environment variable for the container to listen on
        Structure is documented below.
        """
        return pulumi.get(self, "ports")

    @property
    @pulumi.getter
    def resources(self) -> Optional['outputs.JobTemplateTemplateContainerResources']:
        """
        Compute Resource requirements by this container. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
        Structure is documented below.
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter(name="startupProbe")
    def startup_probe(self) -> Optional['outputs.JobTemplateTemplateContainerStartupProbe']:
        """
        (Optional, Deprecated)
        Startup probe of application within the container. All other probes are disabled if a startup probe is provided, until it succeeds. Container will not be added to service endpoints if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        This field is not supported in Cloud Run Job currently.
        Structure is documented below.
        """
        warnings.warn("""Cloud Run Job does not support startup probe and `startup_probe` field will be removed in a future major release.""", DeprecationWarning)
        pulumi.log.warn("""startup_probe is deprecated: Cloud Run Job does not support startup probe and `startup_probe` field will be removed in a future major release.""")

        return pulumi.get(self, "startup_probe")

    @property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[Sequence['outputs.JobTemplateTemplateContainerVolumeMount']]:
        """
        Volume to mount into the container's filesystem.
        Structure is documented below.
        """
        return pulumi.get(self, "volume_mounts")

    @property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> Optional[str]:
        """
        Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image.
        """
        return pulumi.get(self, "working_dir")


@pulumi.output_type
class JobTemplateTemplateContainerEnv(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valueSource":
            suggest = "value_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateTemplateContainerEnv. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateTemplateContainerEnv.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateTemplateContainerEnv.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 value: Optional[str] = None,
                 value_source: Optional['outputs.JobTemplateTemplateContainerEnvValueSource'] = None):
        """
        :param str name: Name of the environment variable. Must be a C_IDENTIFIER, and mnay not exceed 32768 characters.
        :param str value: Variable references $(VAR_NAME) are expanded using the previous defined environment variables in the container and any route environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "", and the maximum length is 32768 bytes
        :param 'JobTemplateTemplateContainerEnvValueSourceArgs' value_source: Source for the environment variable's value.
               Structure is documented below.
        """
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_source is not None:
            pulumi.set(__self__, "value_source", value_source)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the environment variable. Must be a C_IDENTIFIER, and mnay not exceed 32768 characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Variable references $(VAR_NAME) are expanded using the previous defined environment variables in the container and any route environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "", and the maximum length is 32768 bytes
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="valueSource")
    def value_source(self) -> Optional['outputs.JobTemplateTemplateContainerEnvValueSource']:
        """
        Source for the environment variable's value.
        Structure is documented below.
        """
        return pulumi.get(self, "value_source")


@pulumi.output_type
class JobTemplateTemplateContainerEnvValueSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretKeyRef":
            suggest = "secret_key_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateTemplateContainerEnvValueSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateTemplateContainerEnvValueSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateTemplateContainerEnvValueSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_key_ref: Optional['outputs.JobTemplateTemplateContainerEnvValueSourceSecretKeyRef'] = None):
        """
        :param 'JobTemplateTemplateContainerEnvValueSourceSecretKeyRefArgs' secret_key_ref: Selects a secret and a specific version from Cloud Secret Manager.
               Structure is documented below.
        """
        if secret_key_ref is not None:
            pulumi.set(__self__, "secret_key_ref", secret_key_ref)

    @property
    @pulumi.getter(name="secretKeyRef")
    def secret_key_ref(self) -> Optional['outputs.JobTemplateTemplateContainerEnvValueSourceSecretKeyRef']:
        """
        Selects a secret and a specific version from Cloud Secret Manager.
        Structure is documented below.
        """
        return pulumi.get(self, "secret_key_ref")


@pulumi.output_type
class JobTemplateTemplateContainerEnvValueSourceSecretKeyRef(dict):
    def __init__(__self__, *,
                 secret: str,
                 version: str):
        """
        :param str secret: The name of the secret in Cloud Secret Manager. Format: {secretName} if the secret is in the same project. projects/{project}/secrets/{secretName} if the secret is in a different project.
        :param str version: The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version.
        """
        pulumi.set(__self__, "secret", secret)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def secret(self) -> str:
        """
        The name of the secret in Cloud Secret Manager. Format: {secretName} if the secret is in the same project. projects/{project}/secrets/{secretName} if the secret is in a different project.
        """
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class JobTemplateTemplateContainerLivenessProbe(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureThreshold":
            suggest = "failure_threshold"
        elif key == "httpGet":
            suggest = "http_get"
        elif key == "initialDelaySeconds":
            suggest = "initial_delay_seconds"
        elif key == "periodSeconds":
            suggest = "period_seconds"
        elif key == "tcpSocket":
            suggest = "tcp_socket"
        elif key == "timeoutSeconds":
            suggest = "timeout_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateTemplateContainerLivenessProbe. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateTemplateContainerLivenessProbe.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateTemplateContainerLivenessProbe.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failure_threshold: Optional[int] = None,
                 http_get: Optional['outputs.JobTemplateTemplateContainerLivenessProbeHttpGet'] = None,
                 initial_delay_seconds: Optional[int] = None,
                 period_seconds: Optional[int] = None,
                 tcp_socket: Optional['outputs.JobTemplateTemplateContainerLivenessProbeTcpSocket'] = None,
                 timeout_seconds: Optional[int] = None):
        """
        :param int failure_threshold: Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.
        :param 'JobTemplateTemplateContainerLivenessProbeHttpGetArgs' http_get: HTTPGet specifies the http request to perform. Exactly one of HTTPGet or TCPSocket must be specified.
               Structure is documented below.
        :param int initial_delay_seconds: Number of seconds after the container has started before the probe is initiated. Defaults to 0 seconds. Minimum value is 0. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        :param int period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. Must be greater or equal than timeoutSeconds
        :param 'JobTemplateTemplateContainerLivenessProbeTcpSocketArgs' tcp_socket: TCPSocket specifies an action involving a TCP port. Exactly one of HTTPGet or TCPSocket must be specified.
               Structure is documented below.
        :param int timeout_seconds: Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 3600. Must be smaller than periodSeconds. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if http_get is not None:
            pulumi.set(__self__, "http_get", http_get)
        if initial_delay_seconds is not None:
            pulumi.set(__self__, "initial_delay_seconds", initial_delay_seconds)
        if period_seconds is not None:
            pulumi.set(__self__, "period_seconds", period_seconds)
        if tcp_socket is not None:
            pulumi.set(__self__, "tcp_socket", tcp_socket)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[int]:
        """
        Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.
        """
        return pulumi.get(self, "failure_threshold")

    @property
    @pulumi.getter(name="httpGet")
    def http_get(self) -> Optional['outputs.JobTemplateTemplateContainerLivenessProbeHttpGet']:
        """
        HTTPGet specifies the http request to perform. Exactly one of HTTPGet or TCPSocket must be specified.
        Structure is documented below.
        """
        return pulumi.get(self, "http_get")

    @property
    @pulumi.getter(name="initialDelaySeconds")
    def initial_delay_seconds(self) -> Optional[int]:
        """
        Number of seconds after the container has started before the probe is initiated. Defaults to 0 seconds. Minimum value is 0. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "initial_delay_seconds")

    @property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> Optional[int]:
        """
        How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. Must be greater or equal than timeoutSeconds
        """
        return pulumi.get(self, "period_seconds")

    @property
    @pulumi.getter(name="tcpSocket")
    def tcp_socket(self) -> Optional['outputs.JobTemplateTemplateContainerLivenessProbeTcpSocket']:
        """
        TCPSocket specifies an action involving a TCP port. Exactly one of HTTPGet or TCPSocket must be specified.
        Structure is documented below.
        """
        return pulumi.get(self, "tcp_socket")

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[int]:
        """
        Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 3600. Must be smaller than periodSeconds. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class JobTemplateTemplateContainerLivenessProbeHttpGet(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpHeaders":
            suggest = "http_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateTemplateContainerLivenessProbeHttpGet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateTemplateContainerLivenessProbeHttpGet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateTemplateContainerLivenessProbeHttpGet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_headers: Optional[Sequence['outputs.JobTemplateTemplateContainerLivenessProbeHttpGetHttpHeader']] = None,
                 path: Optional[str] = None):
        """
        :param Sequence['JobTemplateTemplateContainerLivenessProbeHttpGetHttpHeaderArgs'] http_headers: Custom headers to set in the request. HTTP allows repeated headers.
               Structure is documented below.
        :param str path: Path to access on the HTTP server. Defaults to '/'.
        """
        if http_headers is not None:
            pulumi.set(__self__, "http_headers", http_headers)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="httpHeaders")
    def http_headers(self) -> Optional[Sequence['outputs.JobTemplateTemplateContainerLivenessProbeHttpGetHttpHeader']]:
        """
        Custom headers to set in the request. HTTP allows repeated headers.
        Structure is documented below.
        """
        return pulumi.get(self, "http_headers")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Path to access on the HTTP server. Defaults to '/'.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class JobTemplateTemplateContainerLivenessProbeHttpGetHttpHeader(dict):
    def __init__(__self__, *,
                 name: str,
                 value: Optional[str] = None):
        """
        :param str name: The header field name
        :param str value: The header field value
        """
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The header field name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The header field value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class JobTemplateTemplateContainerLivenessProbeTcpSocket(dict):
    def __init__(__self__, *,
                 port: Optional[int] = None):
        """
        :param int port: Port number to access on the container. Must be in the range 1 to 65535. If not specified, defaults to 8080.
        """
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Port number to access on the container. Must be in the range 1 to 65535. If not specified, defaults to 8080.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class JobTemplateTemplateContainerPort(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerPort":
            suggest = "container_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateTemplateContainerPort. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateTemplateContainerPort.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateTemplateContainerPort.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_port: Optional[int] = None,
                 name: Optional[str] = None):
        """
        :param int container_port: Port number the container listens on. This must be a valid TCP port number, 0 < containerPort < 65536.
        :param str name: If specified, used to specify which protocol to use. Allowed values are "http1" and "h2c".
        """
        if container_port is not None:
            pulumi.set(__self__, "container_port", container_port)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> Optional[int]:
        """
        Port number the container listens on. This must be a valid TCP port number, 0 < containerPort < 65536.
        """
        return pulumi.get(self, "container_port")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        If specified, used to specify which protocol to use. Allowed values are "http1" and "h2c".
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class JobTemplateTemplateContainerResources(dict):
    def __init__(__self__, *,
                 limits: Optional[Mapping[str, str]] = None):
        """
        :param Mapping[str, str] limits: Only memory and CPU are supported. Note: The only supported values for CPU are '1', '2', '4', and '8'. Setting 4 CPU requires at least 2Gi of memory. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        if limits is not None:
            pulumi.set(__self__, "limits", limits)

    @property
    @pulumi.getter
    def limits(self) -> Optional[Mapping[str, str]]:
        """
        Only memory and CPU are supported. Note: The only supported values for CPU are '1', '2', '4', and '8'. Setting 4 CPU requires at least 2Gi of memory. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        return pulumi.get(self, "limits")


@pulumi.output_type
class JobTemplateTemplateContainerStartupProbe(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureThreshold":
            suggest = "failure_threshold"
        elif key == "httpGet":
            suggest = "http_get"
        elif key == "initialDelaySeconds":
            suggest = "initial_delay_seconds"
        elif key == "periodSeconds":
            suggest = "period_seconds"
        elif key == "tcpSocket":
            suggest = "tcp_socket"
        elif key == "timeoutSeconds":
            suggest = "timeout_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateTemplateContainerStartupProbe. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateTemplateContainerStartupProbe.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateTemplateContainerStartupProbe.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failure_threshold: Optional[int] = None,
                 http_get: Optional['outputs.JobTemplateTemplateContainerStartupProbeHttpGet'] = None,
                 initial_delay_seconds: Optional[int] = None,
                 period_seconds: Optional[int] = None,
                 tcp_socket: Optional['outputs.JobTemplateTemplateContainerStartupProbeTcpSocket'] = None,
                 timeout_seconds: Optional[int] = None):
        """
        :param int failure_threshold: Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.
        :param 'JobTemplateTemplateContainerStartupProbeHttpGetArgs' http_get: HTTPGet specifies the http request to perform. Exactly one of HTTPGet or TCPSocket must be specified.
               Structure is documented below.
        :param int initial_delay_seconds: Number of seconds after the container has started before the probe is initiated. Defaults to 0 seconds. Minimum value is 0. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        :param int period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. Must be greater or equal than timeoutSeconds
        :param 'JobTemplateTemplateContainerStartupProbeTcpSocketArgs' tcp_socket: TCPSocket specifies an action involving a TCP port. Exactly one of HTTPGet or TCPSocket must be specified.
               Structure is documented below.
        :param int timeout_seconds: Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 3600. Must be smaller than periodSeconds. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if http_get is not None:
            pulumi.set(__self__, "http_get", http_get)
        if initial_delay_seconds is not None:
            pulumi.set(__self__, "initial_delay_seconds", initial_delay_seconds)
        if period_seconds is not None:
            pulumi.set(__self__, "period_seconds", period_seconds)
        if tcp_socket is not None:
            pulumi.set(__self__, "tcp_socket", tcp_socket)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[int]:
        """
        Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.
        """
        return pulumi.get(self, "failure_threshold")

    @property
    @pulumi.getter(name="httpGet")
    def http_get(self) -> Optional['outputs.JobTemplateTemplateContainerStartupProbeHttpGet']:
        """
        HTTPGet specifies the http request to perform. Exactly one of HTTPGet or TCPSocket must be specified.
        Structure is documented below.
        """
        return pulumi.get(self, "http_get")

    @property
    @pulumi.getter(name="initialDelaySeconds")
    def initial_delay_seconds(self) -> Optional[int]:
        """
        Number of seconds after the container has started before the probe is initiated. Defaults to 0 seconds. Minimum value is 0. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "initial_delay_seconds")

    @property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> Optional[int]:
        """
        How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. Must be greater or equal than timeoutSeconds
        """
        return pulumi.get(self, "period_seconds")

    @property
    @pulumi.getter(name="tcpSocket")
    def tcp_socket(self) -> Optional['outputs.JobTemplateTemplateContainerStartupProbeTcpSocket']:
        """
        TCPSocket specifies an action involving a TCP port. Exactly one of HTTPGet or TCPSocket must be specified.
        Structure is documented below.
        """
        return pulumi.get(self, "tcp_socket")

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[int]:
        """
        Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 3600. Must be smaller than periodSeconds. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class JobTemplateTemplateContainerStartupProbeHttpGet(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpHeaders":
            suggest = "http_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateTemplateContainerStartupProbeHttpGet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateTemplateContainerStartupProbeHttpGet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateTemplateContainerStartupProbeHttpGet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_headers: Optional[Sequence['outputs.JobTemplateTemplateContainerStartupProbeHttpGetHttpHeader']] = None,
                 path: Optional[str] = None):
        """
        :param Sequence['JobTemplateTemplateContainerStartupProbeHttpGetHttpHeaderArgs'] http_headers: Custom headers to set in the request. HTTP allows repeated headers.
               Structure is documented below.
        :param str path: Path to access on the HTTP server. Defaults to '/'.
        """
        if http_headers is not None:
            pulumi.set(__self__, "http_headers", http_headers)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="httpHeaders")
    def http_headers(self) -> Optional[Sequence['outputs.JobTemplateTemplateContainerStartupProbeHttpGetHttpHeader']]:
        """
        Custom headers to set in the request. HTTP allows repeated headers.
        Structure is documented below.
        """
        return pulumi.get(self, "http_headers")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Path to access on the HTTP server. Defaults to '/'.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class JobTemplateTemplateContainerStartupProbeHttpGetHttpHeader(dict):
    def __init__(__self__, *,
                 name: str,
                 value: Optional[str] = None):
        """
        :param str name: The header field name
        :param str value: The header field value
        """
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The header field name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The header field value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class JobTemplateTemplateContainerStartupProbeTcpSocket(dict):
    def __init__(__self__, *,
                 port: Optional[int] = None):
        """
        :param int port: Port number to access on the container. Must be in the range 1 to 65535. If not specified, defaults to 8080.
        """
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Port number to access on the container. Must be in the range 1 to 65535. If not specified, defaults to 8080.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class JobTemplateTemplateContainerVolumeMount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPath":
            suggest = "mount_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateTemplateContainerVolumeMount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateTemplateContainerVolumeMount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateTemplateContainerVolumeMount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_path: str,
                 name: str):
        """
        :param str mount_path: Path within the container at which the volume should be mounted. Must not contain ':'. For Cloud SQL volumes, it can be left empty, or must otherwise be /cloudsql. All instances defined in the Volume will be available as /cloudsql/[instance]. For more information on Cloud SQL volumes, visit https://cloud.google.com/sql/docs/mysql/connect-run
        :param str name: This must match the Name of a Volume.
        """
        pulumi.set(__self__, "mount_path", mount_path)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> str:
        """
        Path within the container at which the volume should be mounted. Must not contain ':'. For Cloud SQL volumes, it can be left empty, or must otherwise be /cloudsql. All instances defined in the Volume will be available as /cloudsql/[instance]. For more information on Cloud SQL volumes, visit https://cloud.google.com/sql/docs/mysql/connect-run
        """
        return pulumi.get(self, "mount_path")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        This must match the Name of a Volume.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class JobTemplateTemplateVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudSqlInstance":
            suggest = "cloud_sql_instance"
        elif key == "emptyDir":
            suggest = "empty_dir"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateTemplateVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateTemplateVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateTemplateVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 cloud_sql_instance: Optional['outputs.JobTemplateTemplateVolumeCloudSqlInstance'] = None,
                 empty_dir: Optional['outputs.JobTemplateTemplateVolumeEmptyDir'] = None,
                 secret: Optional['outputs.JobTemplateTemplateVolumeSecret'] = None):
        """
        :param str name: Volume's name.
        :param 'JobTemplateTemplateVolumeCloudSqlInstanceArgs' cloud_sql_instance: For Cloud SQL volumes, contains the specific instances that should be mounted. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run.
               Structure is documented below.
        :param 'JobTemplateTemplateVolumeSecretArgs' secret: Secret represents a secret that should populate this volume. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
               Structure is documented below.
        """
        pulumi.set(__self__, "name", name)
        if cloud_sql_instance is not None:
            pulumi.set(__self__, "cloud_sql_instance", cloud_sql_instance)
        if empty_dir is not None:
            pulumi.set(__self__, "empty_dir", empty_dir)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Volume's name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="cloudSqlInstance")
    def cloud_sql_instance(self) -> Optional['outputs.JobTemplateTemplateVolumeCloudSqlInstance']:
        """
        For Cloud SQL volumes, contains the specific instances that should be mounted. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run.
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_sql_instance")

    @property
    @pulumi.getter(name="emptyDir")
    def empty_dir(self) -> Optional['outputs.JobTemplateTemplateVolumeEmptyDir']:
        return pulumi.get(self, "empty_dir")

    @property
    @pulumi.getter
    def secret(self) -> Optional['outputs.JobTemplateTemplateVolumeSecret']:
        """
        Secret represents a secret that should populate this volume. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
        Structure is documented below.
        """
        return pulumi.get(self, "secret")


@pulumi.output_type
class JobTemplateTemplateVolumeCloudSqlInstance(dict):
    def __init__(__self__, *,
                 instances: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] instances: The Cloud SQL instance connection names, as can be found in https://console.cloud.google.com/sql/instances. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run. Format: {project}:{location}:{instance}
        """
        if instances is not None:
            pulumi.set(__self__, "instances", instances)

    @property
    @pulumi.getter
    def instances(self) -> Optional[Sequence[str]]:
        """
        The Cloud SQL instance connection names, as can be found in https://console.cloud.google.com/sql/instances. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run. Format: {project}:{location}:{instance}
        """
        return pulumi.get(self, "instances")


@pulumi.output_type
class JobTemplateTemplateVolumeEmptyDir(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sizeLimit":
            suggest = "size_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateTemplateVolumeEmptyDir. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateTemplateVolumeEmptyDir.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateTemplateVolumeEmptyDir.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 medium: Optional[str] = None,
                 size_limit: Optional[str] = None):
        """
        :param str medium: The different types of medium supported for EmptyDir.
               Default value is `MEMORY`.
               Possible values are: `MEMORY`.
        :param str size_limit: Limit on the storage usable by this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. This field's values are of the 'Quantity' k8s type: https://kubernetes.io/docs/reference/kubernetes-api/common-definitions/quantity/. The default is nil which means that the limit is undefined. More info: https://kubernetes.io/docs/concepts/storage/volumes/#emptydir.
        """
        if medium is not None:
            pulumi.set(__self__, "medium", medium)
        if size_limit is not None:
            pulumi.set(__self__, "size_limit", size_limit)

    @property
    @pulumi.getter
    def medium(self) -> Optional[str]:
        """
        The different types of medium supported for EmptyDir.
        Default value is `MEMORY`.
        Possible values are: `MEMORY`.
        """
        return pulumi.get(self, "medium")

    @property
    @pulumi.getter(name="sizeLimit")
    def size_limit(self) -> Optional[str]:
        """
        Limit on the storage usable by this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. This field's values are of the 'Quantity' k8s type: https://kubernetes.io/docs/reference/kubernetes-api/common-definitions/quantity/. The default is nil which means that the limit is undefined. More info: https://kubernetes.io/docs/concepts/storage/volumes/#emptydir.
        """
        return pulumi.get(self, "size_limit")


@pulumi.output_type
class JobTemplateTemplateVolumeSecret(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultMode":
            suggest = "default_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateTemplateVolumeSecret. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateTemplateVolumeSecret.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateTemplateVolumeSecret.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret: str,
                 default_mode: Optional[int] = None,
                 items: Optional[Sequence['outputs.JobTemplateTemplateVolumeSecretItem']] = None):
        """
        :param str secret: The name of the secret in Cloud Secret Manager. Format: {secret} if the secret is in the same project. projects/{project}/secrets/{secret} if the secret is in a different project.
        :param int default_mode: Integer representation of mode bits to use on created files by default. Must be a value between 0000 and 0777 (octal), defaulting to 0444. Directories within the path are not affected by this setting.
        :param Sequence['JobTemplateTemplateVolumeSecretItemArgs'] items: If unspecified, the volume will expose a file whose name is the secret, relative to VolumeMount.mount_path. If specified, the key will be used as the version to fetch from Cloud Secret Manager and the path will be the name of the file exposed in the volume. When items are defined, they must specify a path and a version.
               Structure is documented below.
        """
        pulumi.set(__self__, "secret", secret)
        if default_mode is not None:
            pulumi.set(__self__, "default_mode", default_mode)
        if items is not None:
            pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def secret(self) -> str:
        """
        The name of the secret in Cloud Secret Manager. Format: {secret} if the secret is in the same project. projects/{project}/secrets/{secret} if the secret is in a different project.
        """
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter(name="defaultMode")
    def default_mode(self) -> Optional[int]:
        """
        Integer representation of mode bits to use on created files by default. Must be a value between 0000 and 0777 (octal), defaulting to 0444. Directories within the path are not affected by this setting.
        """
        return pulumi.get(self, "default_mode")

    @property
    @pulumi.getter
    def items(self) -> Optional[Sequence['outputs.JobTemplateTemplateVolumeSecretItem']]:
        """
        If unspecified, the volume will expose a file whose name is the secret, relative to VolumeMount.mount_path. If specified, the key will be used as the version to fetch from Cloud Secret Manager and the path will be the name of the file exposed in the volume. When items are defined, they must specify a path and a version.
        Structure is documented below.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class JobTemplateTemplateVolumeSecretItem(dict):
    def __init__(__self__, *,
                 mode: int,
                 path: str,
                 version: str):
        """
        :param int mode: Integer octal mode bits to use on this file, must be a value between 01 and 0777 (octal). If 0 or not set, the Volume's default mode will be used.
        :param str path: The relative path of the secret in the container.
        :param str version: The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version
        """
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def mode(self) -> int:
        """
        Integer octal mode bits to use on this file, must be a value between 01 and 0777 (octal). If 0 or not set, the Volume's default mode will be used.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The relative path of the secret in the container.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class JobTemplateTemplateVpcAccess(dict):
    def __init__(__self__, *,
                 connector: Optional[str] = None,
                 egress: Optional[str] = None):
        """
        :param str connector: VPC Access connector name. Format: projects/{project}/locations/{location}/connectors/{connector}, where {project} can be project id or number.
        :param str egress: Traffic VPC egress settings.
               Possible values are: `ALL_TRAFFIC`, `PRIVATE_RANGES_ONLY`.
               
               - - -
        """
        if connector is not None:
            pulumi.set(__self__, "connector", connector)
        if egress is not None:
            pulumi.set(__self__, "egress", egress)

    @property
    @pulumi.getter
    def connector(self) -> Optional[str]:
        """
        VPC Access connector name. Format: projects/{project}/locations/{location}/connectors/{connector}, where {project} can be project id or number.
        """
        return pulumi.get(self, "connector")

    @property
    @pulumi.getter
    def egress(self) -> Optional[str]:
        """
        Traffic VPC egress settings.
        Possible values are: `ALL_TRAFFIC`, `PRIVATE_RANGES_ONLY`.

        - - -
        """
        return pulumi.get(self, "egress")


@pulumi.output_type
class JobTerminalCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executionReason":
            suggest = "execution_reason"
        elif key == "lastTransitionTime":
            suggest = "last_transition_time"
        elif key == "revisionReason":
            suggest = "revision_reason"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTerminalCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTerminalCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTerminalCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execution_reason: Optional[str] = None,
                 last_transition_time: Optional[str] = None,
                 message: Optional[str] = None,
                 reason: Optional[str] = None,
                 revision_reason: Optional[str] = None,
                 severity: Optional[str] = None,
                 state: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str execution_reason: (Output)
               A reason for the execution condition.
        :param str last_transition_time: (Output)
               Last time the condition transitioned from one status to another.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param str message: (Output)
               Human readable message indicating details about the current status.
        :param str reason: (Output)
               A common (service-level) reason for this condition.
        :param str revision_reason: (Output)
               A reason for the revision condition.
        :param str severity: (Output)
               How to interpret failures of this condition, one of Error, Warning, Info
        :param str state: (Output)
               State of the condition.
        :param str type: (Output)
               type is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting Types common to all resources include: * "Ready": True when the Resource is ready.
        """
        if execution_reason is not None:
            pulumi.set(__self__, "execution_reason", execution_reason)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if revision_reason is not None:
            pulumi.set(__self__, "revision_reason", revision_reason)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="executionReason")
    def execution_reason(self) -> Optional[str]:
        """
        (Output)
        A reason for the execution condition.
        """
        return pulumi.get(self, "execution_reason")

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[str]:
        """
        (Output)
        Last time the condition transitioned from one status to another.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "last_transition_time")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        (Output)
        Human readable message indicating details about the current status.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def reason(self) -> Optional[str]:
        """
        (Output)
        A common (service-level) reason for this condition.
        """
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter(name="revisionReason")
    def revision_reason(self) -> Optional[str]:
        """
        (Output)
        A reason for the revision condition.
        """
        return pulumi.get(self, "revision_reason")

    @property
    @pulumi.getter
    def severity(self) -> Optional[str]:
        """
        (Output)
        How to interpret failures of this condition, one of Error, Warning, Info
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        (Output)
        State of the condition.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        (Output)
        type is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting Types common to all resources include: * "Ready": True when the Resource is ready.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ServiceBinaryAuthorization(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "breakglassJustification":
            suggest = "breakglass_justification"
        elif key == "useDefault":
            suggest = "use_default"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceBinaryAuthorization. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceBinaryAuthorization.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceBinaryAuthorization.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 breakglass_justification: Optional[str] = None,
                 use_default: Optional[bool] = None):
        """
        :param str breakglass_justification: If present, indicates to use Breakglass using this justification. If useDefault is False, then it must be empty. For more information on breakglass, see https://cloud.google.com/binary-authorization/docs/using-breakglass
        :param bool use_default: If True, indicates to use the default project's binary authorization policy. If False, binary authorization will be disabled.
        """
        if breakglass_justification is not None:
            pulumi.set(__self__, "breakglass_justification", breakglass_justification)
        if use_default is not None:
            pulumi.set(__self__, "use_default", use_default)

    @property
    @pulumi.getter(name="breakglassJustification")
    def breakglass_justification(self) -> Optional[str]:
        """
        If present, indicates to use Breakglass using this justification. If useDefault is False, then it must be empty. For more information on breakglass, see https://cloud.google.com/binary-authorization/docs/using-breakglass
        """
        return pulumi.get(self, "breakglass_justification")

    @property
    @pulumi.getter(name="useDefault")
    def use_default(self) -> Optional[bool]:
        """
        If True, indicates to use the default project's binary authorization policy. If False, binary authorization will be disabled.
        """
        return pulumi.get(self, "use_default")


@pulumi.output_type
class ServiceCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executionReason":
            suggest = "execution_reason"
        elif key == "lastTransitionTime":
            suggest = "last_transition_time"
        elif key == "revisionReason":
            suggest = "revision_reason"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execution_reason: Optional[str] = None,
                 last_transition_time: Optional[str] = None,
                 message: Optional[str] = None,
                 reason: Optional[str] = None,
                 revision_reason: Optional[str] = None,
                 severity: Optional[str] = None,
                 state: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str execution_reason: (Output)
               A reason for the execution condition.
        :param str last_transition_time: (Output)
               Last time the condition transitioned from one status to another.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param str message: (Output)
               Human readable message indicating details about the current status.
        :param str reason: (Output)
               A common (service-level) reason for this condition.
        :param str revision_reason: (Output)
               A reason for the revision condition.
        :param str severity: (Output)
               How to interpret failures of this condition, one of Error, Warning, Info
        :param str state: (Output)
               State of the condition.
        :param str type: The allocation type for this traffic target.
               Possible values are: `TRAFFIC_TARGET_ALLOCATION_TYPE_LATEST`, `TRAFFIC_TARGET_ALLOCATION_TYPE_REVISION`.
        """
        if execution_reason is not None:
            pulumi.set(__self__, "execution_reason", execution_reason)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if revision_reason is not None:
            pulumi.set(__self__, "revision_reason", revision_reason)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="executionReason")
    def execution_reason(self) -> Optional[str]:
        """
        (Output)
        A reason for the execution condition.
        """
        return pulumi.get(self, "execution_reason")

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[str]:
        """
        (Output)
        Last time the condition transitioned from one status to another.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "last_transition_time")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        (Output)
        Human readable message indicating details about the current status.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def reason(self) -> Optional[str]:
        """
        (Output)
        A common (service-level) reason for this condition.
        """
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter(name="revisionReason")
    def revision_reason(self) -> Optional[str]:
        """
        (Output)
        A reason for the revision condition.
        """
        return pulumi.get(self, "revision_reason")

    @property
    @pulumi.getter
    def severity(self) -> Optional[str]:
        """
        (Output)
        How to interpret failures of this condition, one of Error, Warning, Info
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        (Output)
        State of the condition.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The allocation type for this traffic target.
        Possible values are: `TRAFFIC_TARGET_ALLOCATION_TYPE_LATEST`, `TRAFFIC_TARGET_ALLOCATION_TYPE_REVISION`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ServiceIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class ServiceIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class ServiceTemplate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionKey":
            suggest = "encryption_key"
        elif key == "executionEnvironment":
            suggest = "execution_environment"
        elif key == "maxInstanceRequestConcurrency":
            suggest = "max_instance_request_concurrency"
        elif key == "serviceAccount":
            suggest = "service_account"
        elif key == "sessionAffinity":
            suggest = "session_affinity"
        elif key == "vpcAccess":
            suggest = "vpc_access"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 annotations: Optional[Mapping[str, str]] = None,
                 containers: Optional[Sequence['outputs.ServiceTemplateContainer']] = None,
                 encryption_key: Optional[str] = None,
                 execution_environment: Optional[str] = None,
                 labels: Optional[Mapping[str, str]] = None,
                 max_instance_request_concurrency: Optional[int] = None,
                 revision: Optional[str] = None,
                 scaling: Optional['outputs.ServiceTemplateScaling'] = None,
                 service_account: Optional[str] = None,
                 session_affinity: Optional[bool] = None,
                 timeout: Optional[str] = None,
                 volumes: Optional[Sequence['outputs.ServiceTemplateVolume']] = None,
                 vpc_access: Optional['outputs.ServiceTemplateVpcAccess'] = None):
        """
        :param Mapping[str, str] annotations: Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
               Cloud Run API v2 does not support annotations with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
               All system annotations in v1 now have a corresponding field in v2 RevisionTemplate.
               This field follows Kubernetes annotations' namespacing, limits, and rules.
        :param Sequence['ServiceTemplateContainerArgs'] containers: Holds the containers that define the unit of execution for this Service.
               Structure is documented below.
        :param str encryption_key: A reference to a customer managed encryption key (CMEK) to use to encrypt this container image. For more information, go to https://cloud.google.com/run/docs/securing/using-cmek
        :param str execution_environment: The sandbox environment to host this Revision.
               Possible values are: `EXECUTION_ENVIRONMENT_GEN1`, `EXECUTION_ENVIRONMENT_GEN2`.
        :param Mapping[str, str] labels: Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter, or break down billing charges by team, component, environment, state, etc.
               For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or https://cloud.google.com/run/docs/configuring/labels.
               Cloud Run API v2 does not support labels with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
               All system labels in v1 now have a corresponding field in v2 RevisionTemplate.
        :param int max_instance_request_concurrency: Sets the maximum number of requests that each serving instance can receive.
        :param str revision: The unique name for the revision. If this field is omitted, it will be automatically generated based on the Service name.
        :param 'ServiceTemplateScalingArgs' scaling: Scaling settings for this Revision.
               Structure is documented below.
        :param str service_account: Email address of the IAM service account associated with the revision of the service. The service account represents the identity of the running revision, and determines what permissions the revision has. If not provided, the revision will use the project's default service account.
        :param bool session_affinity: Enables session affinity. For more information, go to https://cloud.google.com/run/docs/configuring/session-affinity
        :param str timeout: Max allowed time for an instance to respond to a request.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        :param Sequence['ServiceTemplateVolumeArgs'] volumes: A list of Volumes to make available to containers.
               Structure is documented below.
        :param 'ServiceTemplateVpcAccessArgs' vpc_access: VPC Access configuration to use for this Task. For more information, visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
               Structure is documented below.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if containers is not None:
            pulumi.set(__self__, "containers", containers)
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)
        if execution_environment is not None:
            pulumi.set(__self__, "execution_environment", execution_environment)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if max_instance_request_concurrency is not None:
            pulumi.set(__self__, "max_instance_request_concurrency", max_instance_request_concurrency)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)
        if scaling is not None:
            pulumi.set(__self__, "scaling", scaling)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if session_affinity is not None:
            pulumi.set(__self__, "session_affinity", session_affinity)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)
        if vpc_access is not None:
            pulumi.set(__self__, "vpc_access", vpc_access)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Mapping[str, str]]:
        """
        Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
        Cloud Run API v2 does not support annotations with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
        All system annotations in v1 now have a corresponding field in v2 RevisionTemplate.
        This field follows Kubernetes annotations' namespacing, limits, and rules.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def containers(self) -> Optional[Sequence['outputs.ServiceTemplateContainer']]:
        """
        Holds the containers that define the unit of execution for this Service.
        Structure is documented below.
        """
        return pulumi.get(self, "containers")

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional[str]:
        """
        A reference to a customer managed encryption key (CMEK) to use to encrypt this container image. For more information, go to https://cloud.google.com/run/docs/securing/using-cmek
        """
        return pulumi.get(self, "encryption_key")

    @property
    @pulumi.getter(name="executionEnvironment")
    def execution_environment(self) -> Optional[str]:
        """
        The sandbox environment to host this Revision.
        Possible values are: `EXECUTION_ENVIRONMENT_GEN1`, `EXECUTION_ENVIRONMENT_GEN2`.
        """
        return pulumi.get(self, "execution_environment")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, str]]:
        """
        Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter, or break down billing charges by team, component, environment, state, etc.
        For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or https://cloud.google.com/run/docs/configuring/labels.
        Cloud Run API v2 does not support labels with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
        All system labels in v1 now have a corresponding field in v2 RevisionTemplate.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="maxInstanceRequestConcurrency")
    def max_instance_request_concurrency(self) -> Optional[int]:
        """
        Sets the maximum number of requests that each serving instance can receive.
        """
        return pulumi.get(self, "max_instance_request_concurrency")

    @property
    @pulumi.getter
    def revision(self) -> Optional[str]:
        """
        The unique name for the revision. If this field is omitted, it will be automatically generated based on the Service name.
        """
        return pulumi.get(self, "revision")

    @property
    @pulumi.getter
    def scaling(self) -> Optional['outputs.ServiceTemplateScaling']:
        """
        Scaling settings for this Revision.
        Structure is documented below.
        """
        return pulumi.get(self, "scaling")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[str]:
        """
        Email address of the IAM service account associated with the revision of the service. The service account represents the identity of the running revision, and determines what permissions the revision has. If not provided, the revision will use the project's default service account.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter(name="sessionAffinity")
    def session_affinity(self) -> Optional[bool]:
        """
        Enables session affinity. For more information, go to https://cloud.google.com/run/docs/configuring/session-affinity
        """
        return pulumi.get(self, "session_affinity")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[str]:
        """
        Max allowed time for an instance to respond to a request.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter
    def volumes(self) -> Optional[Sequence['outputs.ServiceTemplateVolume']]:
        """
        A list of Volumes to make available to containers.
        Structure is documented below.
        """
        return pulumi.get(self, "volumes")

    @property
    @pulumi.getter(name="vpcAccess")
    def vpc_access(self) -> Optional['outputs.ServiceTemplateVpcAccess']:
        """
        VPC Access configuration to use for this Task. For more information, visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
        Structure is documented below.
        """
        return pulumi.get(self, "vpc_access")


@pulumi.output_type
class ServiceTemplateContainer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dependsOns":
            suggest = "depends_ons"
        elif key == "livenessProbe":
            suggest = "liveness_probe"
        elif key == "startupProbe":
            suggest = "startup_probe"
        elif key == "volumeMounts":
            suggest = "volume_mounts"
        elif key == "workingDir":
            suggest = "working_dir"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateContainer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateContainer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateContainer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image: str,
                 args: Optional[Sequence[str]] = None,
                 commands: Optional[Sequence[str]] = None,
                 depends_ons: Optional[Sequence[str]] = None,
                 envs: Optional[Sequence['outputs.ServiceTemplateContainerEnv']] = None,
                 liveness_probe: Optional['outputs.ServiceTemplateContainerLivenessProbe'] = None,
                 name: Optional[str] = None,
                 ports: Optional[Sequence['outputs.ServiceTemplateContainerPort']] = None,
                 resources: Optional['outputs.ServiceTemplateContainerResources'] = None,
                 startup_probe: Optional['outputs.ServiceTemplateContainerStartupProbe'] = None,
                 volume_mounts: Optional[Sequence['outputs.ServiceTemplateContainerVolumeMount']] = None,
                 working_dir: Optional[str] = None):
        """
        :param str image: URL of the Container image in Google Container Registry or Google Artifact Registry. More info: https://kubernetes.io/docs/concepts/containers/images
        :param Sequence[str] args: Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        :param Sequence[str] commands: Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        :param Sequence['ServiceTemplateContainerEnvArgs'] envs: List of environment variables to set in the container.
               Structure is documented below.
        :param 'ServiceTemplateContainerLivenessProbeArgs' liveness_probe: Periodic probe of container liveness. Container will be restarted if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
               Structure is documented below.
        :param str name: Name of the container specified as a DNS_LABEL.
        :param Sequence['ServiceTemplateContainerPortArgs'] ports: List of ports to expose from the container. Only a single port can be specified. The specified ports must be listening on all interfaces (0.0.0.0) within the container to be accessible.
               If omitted, a port number will be chosen and passed to the container through the PORT environment variable for the container to listen on
               Structure is documented below.
        :param 'ServiceTemplateContainerResourcesArgs' resources: Compute Resource requirements by this container. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
               Structure is documented below.
        :param 'ServiceTemplateContainerStartupProbeArgs' startup_probe: Startup probe of application within the container. All other probes are disabled if a startup probe is provided, until it succeeds. Container will not be added to service endpoints if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
               Structure is documented below.
        :param Sequence['ServiceTemplateContainerVolumeMountArgs'] volume_mounts: Volume to mount into the container's filesystem.
               Structure is documented below.
        :param str working_dir: Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image.
        """
        pulumi.set(__self__, "image", image)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if depends_ons is not None:
            pulumi.set(__self__, "depends_ons", depends_ons)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if liveness_probe is not None:
            pulumi.set(__self__, "liveness_probe", liveness_probe)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if startup_probe is not None:
            pulumi.set(__self__, "startup_probe", startup_probe)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)
        if working_dir is not None:
            pulumi.set(__self__, "working_dir", working_dir)

    @property
    @pulumi.getter
    def image(self) -> str:
        """
        URL of the Container image in Google Container Registry or Google Artifact Registry. More info: https://kubernetes.io/docs/concepts/containers/images
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    def args(self) -> Optional[Sequence[str]]:
        """
        Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def commands(self) -> Optional[Sequence[str]]:
        """
        Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter(name="dependsOns")
    def depends_ons(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "depends_ons")

    @property
    @pulumi.getter
    def envs(self) -> Optional[Sequence['outputs.ServiceTemplateContainerEnv']]:
        """
        List of environment variables to set in the container.
        Structure is documented below.
        """
        return pulumi.get(self, "envs")

    @property
    @pulumi.getter(name="livenessProbe")
    def liveness_probe(self) -> Optional['outputs.ServiceTemplateContainerLivenessProbe']:
        """
        Periodic probe of container liveness. Container will be restarted if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        Structure is documented below.
        """
        return pulumi.get(self, "liveness_probe")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the container specified as a DNS_LABEL.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def ports(self) -> Optional[Sequence['outputs.ServiceTemplateContainerPort']]:
        """
        List of ports to expose from the container. Only a single port can be specified. The specified ports must be listening on all interfaces (0.0.0.0) within the container to be accessible.
        If omitted, a port number will be chosen and passed to the container through the PORT environment variable for the container to listen on
        Structure is documented below.
        """
        return pulumi.get(self, "ports")

    @property
    @pulumi.getter
    def resources(self) -> Optional['outputs.ServiceTemplateContainerResources']:
        """
        Compute Resource requirements by this container. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
        Structure is documented below.
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter(name="startupProbe")
    def startup_probe(self) -> Optional['outputs.ServiceTemplateContainerStartupProbe']:
        """
        Startup probe of application within the container. All other probes are disabled if a startup probe is provided, until it succeeds. Container will not be added to service endpoints if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        Structure is documented below.
        """
        return pulumi.get(self, "startup_probe")

    @property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[Sequence['outputs.ServiceTemplateContainerVolumeMount']]:
        """
        Volume to mount into the container's filesystem.
        Structure is documented below.
        """
        return pulumi.get(self, "volume_mounts")

    @property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> Optional[str]:
        """
        Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image.
        """
        return pulumi.get(self, "working_dir")


@pulumi.output_type
class ServiceTemplateContainerEnv(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valueSource":
            suggest = "value_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateContainerEnv. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateContainerEnv.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateContainerEnv.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 value: Optional[str] = None,
                 value_source: Optional['outputs.ServiceTemplateContainerEnvValueSource'] = None):
        """
        :param str name: Name of the environment variable. Must be a C_IDENTIFIER, and mnay not exceed 32768 characters.
        :param str value: Variable references $(VAR_NAME) are expanded using the previous defined environment variables in the container and any route environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "", and the maximum length is 32768 bytes
        :param 'ServiceTemplateContainerEnvValueSourceArgs' value_source: Source for the environment variable's value.
               Structure is documented below.
        """
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_source is not None:
            pulumi.set(__self__, "value_source", value_source)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the environment variable. Must be a C_IDENTIFIER, and mnay not exceed 32768 characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Variable references $(VAR_NAME) are expanded using the previous defined environment variables in the container and any route environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "", and the maximum length is 32768 bytes
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="valueSource")
    def value_source(self) -> Optional['outputs.ServiceTemplateContainerEnvValueSource']:
        """
        Source for the environment variable's value.
        Structure is documented below.
        """
        return pulumi.get(self, "value_source")


@pulumi.output_type
class ServiceTemplateContainerEnvValueSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretKeyRef":
            suggest = "secret_key_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateContainerEnvValueSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateContainerEnvValueSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateContainerEnvValueSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_key_ref: Optional['outputs.ServiceTemplateContainerEnvValueSourceSecretKeyRef'] = None):
        """
        :param 'ServiceTemplateContainerEnvValueSourceSecretKeyRefArgs' secret_key_ref: Selects a secret and a specific version from Cloud Secret Manager.
               Structure is documented below.
        """
        if secret_key_ref is not None:
            pulumi.set(__self__, "secret_key_ref", secret_key_ref)

    @property
    @pulumi.getter(name="secretKeyRef")
    def secret_key_ref(self) -> Optional['outputs.ServiceTemplateContainerEnvValueSourceSecretKeyRef']:
        """
        Selects a secret and a specific version from Cloud Secret Manager.
        Structure is documented below.
        """
        return pulumi.get(self, "secret_key_ref")


@pulumi.output_type
class ServiceTemplateContainerEnvValueSourceSecretKeyRef(dict):
    def __init__(__self__, *,
                 secret: str,
                 version: Optional[str] = None):
        """
        :param str secret: The name of the secret in Cloud Secret Manager. Format: {secretName} if the secret is in the same project. projects/{project}/secrets/{secretName} if the secret is in a different project.
        :param str version: The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version.
        """
        pulumi.set(__self__, "secret", secret)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def secret(self) -> str:
        """
        The name of the secret in Cloud Secret Manager. Format: {secretName} if the secret is in the same project. projects/{project}/secrets/{secretName} if the secret is in a different project.
        """
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ServiceTemplateContainerLivenessProbe(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureThreshold":
            suggest = "failure_threshold"
        elif key == "httpGet":
            suggest = "http_get"
        elif key == "initialDelaySeconds":
            suggest = "initial_delay_seconds"
        elif key == "periodSeconds":
            suggest = "period_seconds"
        elif key == "tcpSocket":
            suggest = "tcp_socket"
        elif key == "timeoutSeconds":
            suggest = "timeout_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateContainerLivenessProbe. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateContainerLivenessProbe.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateContainerLivenessProbe.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failure_threshold: Optional[int] = None,
                 grpc: Optional['outputs.ServiceTemplateContainerLivenessProbeGrpc'] = None,
                 http_get: Optional['outputs.ServiceTemplateContainerLivenessProbeHttpGet'] = None,
                 initial_delay_seconds: Optional[int] = None,
                 period_seconds: Optional[int] = None,
                 tcp_socket: Optional['outputs.ServiceTemplateContainerLivenessProbeTcpSocket'] = None,
                 timeout_seconds: Optional[int] = None):
        """
        :param int failure_threshold: Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.
        :param 'ServiceTemplateContainerLivenessProbeGrpcArgs' grpc: GRPC specifies an action involving a GRPC port.
               Structure is documented below.
        :param 'ServiceTemplateContainerLivenessProbeHttpGetArgs' http_get: HTTPGet specifies the http request to perform.
               Structure is documented below.
        :param int initial_delay_seconds: Number of seconds after the container has started before the probe is initiated. Defaults to 0 seconds. Minimum value is 0. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        :param int period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. Must be greater or equal than timeoutSeconds
        :param 'ServiceTemplateContainerLivenessProbeTcpSocketArgs' tcp_socket: (Optional, Deprecated)
               TCPSocket specifies an action involving a TCP port. This field is not supported in liveness probe currently.
               Structure is documented below.
        :param int timeout_seconds: Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 3600. Must be smaller than periodSeconds. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if grpc is not None:
            pulumi.set(__self__, "grpc", grpc)
        if http_get is not None:
            pulumi.set(__self__, "http_get", http_get)
        if initial_delay_seconds is not None:
            pulumi.set(__self__, "initial_delay_seconds", initial_delay_seconds)
        if period_seconds is not None:
            pulumi.set(__self__, "period_seconds", period_seconds)
        if tcp_socket is not None:
            pulumi.set(__self__, "tcp_socket", tcp_socket)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[int]:
        """
        Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.
        """
        return pulumi.get(self, "failure_threshold")

    @property
    @pulumi.getter
    def grpc(self) -> Optional['outputs.ServiceTemplateContainerLivenessProbeGrpc']:
        """
        GRPC specifies an action involving a GRPC port.
        Structure is documented below.
        """
        return pulumi.get(self, "grpc")

    @property
    @pulumi.getter(name="httpGet")
    def http_get(self) -> Optional['outputs.ServiceTemplateContainerLivenessProbeHttpGet']:
        """
        HTTPGet specifies the http request to perform.
        Structure is documented below.
        """
        return pulumi.get(self, "http_get")

    @property
    @pulumi.getter(name="initialDelaySeconds")
    def initial_delay_seconds(self) -> Optional[int]:
        """
        Number of seconds after the container has started before the probe is initiated. Defaults to 0 seconds. Minimum value is 0. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "initial_delay_seconds")

    @property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> Optional[int]:
        """
        How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. Must be greater or equal than timeoutSeconds
        """
        return pulumi.get(self, "period_seconds")

    @property
    @pulumi.getter(name="tcpSocket")
    def tcp_socket(self) -> Optional['outputs.ServiceTemplateContainerLivenessProbeTcpSocket']:
        """
        (Optional, Deprecated)
        TCPSocket specifies an action involving a TCP port. This field is not supported in liveness probe currently.
        Structure is documented below.
        """
        warnings.warn("""Cloud Run does not support tcp socket in liveness probe and `liveness_probe.tcp_socket` field will be removed in a future major release.""", DeprecationWarning)
        pulumi.log.warn("""tcp_socket is deprecated: Cloud Run does not support tcp socket in liveness probe and `liveness_probe.tcp_socket` field will be removed in a future major release.""")

        return pulumi.get(self, "tcp_socket")

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[int]:
        """
        Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 3600. Must be smaller than periodSeconds. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class ServiceTemplateContainerLivenessProbeGrpc(dict):
    def __init__(__self__, *,
                 port: Optional[int] = None,
                 service: Optional[str] = None):
        """
        :param int port: Port number to access on the container. Number must be in the range 1 to 65535.
               If not specified, defaults to the same value as container.ports[0].containerPort.
        :param str service: The name of the service to place in the gRPC HealthCheckRequest
               (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).
               If this is not specified, the default behavior is defined by gRPC.
        """
        if port is not None:
            pulumi.set(__self__, "port", port)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Port number to access on the container. Number must be in the range 1 to 65535.
        If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def service(self) -> Optional[str]:
        """
        The name of the service to place in the gRPC HealthCheckRequest
        (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).
        If this is not specified, the default behavior is defined by gRPC.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class ServiceTemplateContainerLivenessProbeHttpGet(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpHeaders":
            suggest = "http_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateContainerLivenessProbeHttpGet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateContainerLivenessProbeHttpGet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateContainerLivenessProbeHttpGet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_headers: Optional[Sequence['outputs.ServiceTemplateContainerLivenessProbeHttpGetHttpHeader']] = None,
                 path: Optional[str] = None,
                 port: Optional[int] = None):
        """
        :param Sequence['ServiceTemplateContainerLivenessProbeHttpGetHttpHeaderArgs'] http_headers: Custom headers to set in the request. HTTP allows repeated headers.
               Structure is documented below.
        :param str path: Path to access on the HTTP server. Defaults to '/'.
        :param int port: Port number to access on the container. Must be in the range 1 to 65535.
               If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        if http_headers is not None:
            pulumi.set(__self__, "http_headers", http_headers)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="httpHeaders")
    def http_headers(self) -> Optional[Sequence['outputs.ServiceTemplateContainerLivenessProbeHttpGetHttpHeader']]:
        """
        Custom headers to set in the request. HTTP allows repeated headers.
        Structure is documented below.
        """
        return pulumi.get(self, "http_headers")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Path to access on the HTTP server. Defaults to '/'.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Port number to access on the container. Must be in the range 1 to 65535.
        If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ServiceTemplateContainerLivenessProbeHttpGetHttpHeader(dict):
    def __init__(__self__, *,
                 name: str,
                 value: Optional[str] = None):
        """
        :param str name: The header field name
        :param str value: The header field value
        """
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The header field name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The header field value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ServiceTemplateContainerLivenessProbeTcpSocket(dict):
    def __init__(__self__, *,
                 port: Optional[int] = None):
        """
        :param int port: Port number to access on the container. Must be in the range 1 to 65535.
               If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Port number to access on the container. Must be in the range 1 to 65535.
        If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ServiceTemplateContainerPort(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerPort":
            suggest = "container_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateContainerPort. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateContainerPort.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateContainerPort.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_port: Optional[int] = None,
                 name: Optional[str] = None):
        """
        :param int container_port: Port number the container listens on. This must be a valid TCP port number, 0 < containerPort < 65536.
        :param str name: If specified, used to specify which protocol to use. Allowed values are "http1" and "h2c".
        """
        if container_port is not None:
            pulumi.set(__self__, "container_port", container_port)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> Optional[int]:
        """
        Port number the container listens on. This must be a valid TCP port number, 0 < containerPort < 65536.
        """
        return pulumi.get(self, "container_port")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        If specified, used to specify which protocol to use. Allowed values are "http1" and "h2c".
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ServiceTemplateContainerResources(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuIdle":
            suggest = "cpu_idle"
        elif key == "startupCpuBoost":
            suggest = "startup_cpu_boost"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateContainerResources. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateContainerResources.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateContainerResources.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu_idle: Optional[bool] = None,
                 limits: Optional[Mapping[str, str]] = None,
                 startup_cpu_boost: Optional[bool] = None):
        """
        :param bool cpu_idle: Determines whether CPU should be throttled or not outside of requests.
        :param Mapping[str, str] limits: Only memory and CPU are supported. Note: The only supported values for CPU are '1', '2', '4', and '8'. Setting 4 CPU requires at least 2Gi of memory. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        :param bool startup_cpu_boost: Determines whether CPU should be boosted on startup of a new container instance above the requested CPU threshold, this can help reduce cold-start latency.
        """
        if cpu_idle is not None:
            pulumi.set(__self__, "cpu_idle", cpu_idle)
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if startup_cpu_boost is not None:
            pulumi.set(__self__, "startup_cpu_boost", startup_cpu_boost)

    @property
    @pulumi.getter(name="cpuIdle")
    def cpu_idle(self) -> Optional[bool]:
        """
        Determines whether CPU should be throttled or not outside of requests.
        """
        return pulumi.get(self, "cpu_idle")

    @property
    @pulumi.getter
    def limits(self) -> Optional[Mapping[str, str]]:
        """
        Only memory and CPU are supported. Note: The only supported values for CPU are '1', '2', '4', and '8'. Setting 4 CPU requires at least 2Gi of memory. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        return pulumi.get(self, "limits")

    @property
    @pulumi.getter(name="startupCpuBoost")
    def startup_cpu_boost(self) -> Optional[bool]:
        """
        Determines whether CPU should be boosted on startup of a new container instance above the requested CPU threshold, this can help reduce cold-start latency.
        """
        return pulumi.get(self, "startup_cpu_boost")


@pulumi.output_type
class ServiceTemplateContainerStartupProbe(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureThreshold":
            suggest = "failure_threshold"
        elif key == "httpGet":
            suggest = "http_get"
        elif key == "initialDelaySeconds":
            suggest = "initial_delay_seconds"
        elif key == "periodSeconds":
            suggest = "period_seconds"
        elif key == "tcpSocket":
            suggest = "tcp_socket"
        elif key == "timeoutSeconds":
            suggest = "timeout_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateContainerStartupProbe. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateContainerStartupProbe.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateContainerStartupProbe.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failure_threshold: Optional[int] = None,
                 grpc: Optional['outputs.ServiceTemplateContainerStartupProbeGrpc'] = None,
                 http_get: Optional['outputs.ServiceTemplateContainerStartupProbeHttpGet'] = None,
                 initial_delay_seconds: Optional[int] = None,
                 period_seconds: Optional[int] = None,
                 tcp_socket: Optional['outputs.ServiceTemplateContainerStartupProbeTcpSocket'] = None,
                 timeout_seconds: Optional[int] = None):
        """
        :param int failure_threshold: Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.
        :param 'ServiceTemplateContainerStartupProbeGrpcArgs' grpc: GRPC specifies an action involving a GRPC port.
               Structure is documented below.
        :param 'ServiceTemplateContainerStartupProbeHttpGetArgs' http_get: HTTPGet specifies the http request to perform. Exactly one of HTTPGet or TCPSocket must be specified.
               Structure is documented below.
        :param int initial_delay_seconds: Number of seconds after the container has started before the probe is initiated. Defaults to 0 seconds. Minimum value is 0. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        :param int period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. Must be greater or equal than timeoutSeconds
        :param 'ServiceTemplateContainerStartupProbeTcpSocketArgs' tcp_socket: TCPSocket specifies an action involving a TCP port. Exactly one of HTTPGet or TCPSocket must be specified.
               Structure is documented below.
        :param int timeout_seconds: Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 3600. Must be smaller than periodSeconds. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if grpc is not None:
            pulumi.set(__self__, "grpc", grpc)
        if http_get is not None:
            pulumi.set(__self__, "http_get", http_get)
        if initial_delay_seconds is not None:
            pulumi.set(__self__, "initial_delay_seconds", initial_delay_seconds)
        if period_seconds is not None:
            pulumi.set(__self__, "period_seconds", period_seconds)
        if tcp_socket is not None:
            pulumi.set(__self__, "tcp_socket", tcp_socket)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[int]:
        """
        Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.
        """
        return pulumi.get(self, "failure_threshold")

    @property
    @pulumi.getter
    def grpc(self) -> Optional['outputs.ServiceTemplateContainerStartupProbeGrpc']:
        """
        GRPC specifies an action involving a GRPC port.
        Structure is documented below.
        """
        return pulumi.get(self, "grpc")

    @property
    @pulumi.getter(name="httpGet")
    def http_get(self) -> Optional['outputs.ServiceTemplateContainerStartupProbeHttpGet']:
        """
        HTTPGet specifies the http request to perform. Exactly one of HTTPGet or TCPSocket must be specified.
        Structure is documented below.
        """
        return pulumi.get(self, "http_get")

    @property
    @pulumi.getter(name="initialDelaySeconds")
    def initial_delay_seconds(self) -> Optional[int]:
        """
        Number of seconds after the container has started before the probe is initiated. Defaults to 0 seconds. Minimum value is 0. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "initial_delay_seconds")

    @property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> Optional[int]:
        """
        How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. Must be greater or equal than timeoutSeconds
        """
        return pulumi.get(self, "period_seconds")

    @property
    @pulumi.getter(name="tcpSocket")
    def tcp_socket(self) -> Optional['outputs.ServiceTemplateContainerStartupProbeTcpSocket']:
        """
        TCPSocket specifies an action involving a TCP port. Exactly one of HTTPGet or TCPSocket must be specified.
        Structure is documented below.
        """
        return pulumi.get(self, "tcp_socket")

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[int]:
        """
        Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 3600. Must be smaller than periodSeconds. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class ServiceTemplateContainerStartupProbeGrpc(dict):
    def __init__(__self__, *,
                 port: Optional[int] = None,
                 service: Optional[str] = None):
        """
        :param int port: Port number to access on the container. Number must be in the range 1 to 65535.
               If not specified, defaults to the same value as container.ports[0].containerPort.
        :param str service: The name of the service to place in the gRPC HealthCheckRequest
               (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).
               If this is not specified, the default behavior is defined by gRPC.
        """
        if port is not None:
            pulumi.set(__self__, "port", port)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Port number to access on the container. Number must be in the range 1 to 65535.
        If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def service(self) -> Optional[str]:
        """
        The name of the service to place in the gRPC HealthCheckRequest
        (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).
        If this is not specified, the default behavior is defined by gRPC.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class ServiceTemplateContainerStartupProbeHttpGet(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpHeaders":
            suggest = "http_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateContainerStartupProbeHttpGet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateContainerStartupProbeHttpGet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateContainerStartupProbeHttpGet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_headers: Optional[Sequence['outputs.ServiceTemplateContainerStartupProbeHttpGetHttpHeader']] = None,
                 path: Optional[str] = None,
                 port: Optional[int] = None):
        """
        :param Sequence['ServiceTemplateContainerStartupProbeHttpGetHttpHeaderArgs'] http_headers: Custom headers to set in the request. HTTP allows repeated headers.
               Structure is documented below.
        :param str path: Path to access on the HTTP server. Defaults to '/'.
        :param int port: Port number to access on the container. Must be in the range 1 to 65535.
               If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        if http_headers is not None:
            pulumi.set(__self__, "http_headers", http_headers)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="httpHeaders")
    def http_headers(self) -> Optional[Sequence['outputs.ServiceTemplateContainerStartupProbeHttpGetHttpHeader']]:
        """
        Custom headers to set in the request. HTTP allows repeated headers.
        Structure is documented below.
        """
        return pulumi.get(self, "http_headers")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Path to access on the HTTP server. Defaults to '/'.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Port number to access on the container. Must be in the range 1 to 65535.
        If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ServiceTemplateContainerStartupProbeHttpGetHttpHeader(dict):
    def __init__(__self__, *,
                 name: str,
                 value: Optional[str] = None):
        """
        :param str name: The header field name
        :param str value: The header field value
        """
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The header field name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The header field value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ServiceTemplateContainerStartupProbeTcpSocket(dict):
    def __init__(__self__, *,
                 port: Optional[int] = None):
        """
        :param int port: Port number to access on the container. Must be in the range 1 to 65535.
               If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Port number to access on the container. Must be in the range 1 to 65535.
        If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ServiceTemplateContainerVolumeMount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPath":
            suggest = "mount_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateContainerVolumeMount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateContainerVolumeMount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateContainerVolumeMount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_path: str,
                 name: str):
        """
        :param str mount_path: Path within the container at which the volume should be mounted. Must not contain ':'. For Cloud SQL volumes, it can be left empty, or must otherwise be /cloudsql. All instances defined in the Volume will be available as /cloudsql/[instance]. For more information on Cloud SQL volumes, visit https://cloud.google.com/sql/docs/mysql/connect-run
        :param str name: This must match the Name of a Volume.
        """
        pulumi.set(__self__, "mount_path", mount_path)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> str:
        """
        Path within the container at which the volume should be mounted. Must not contain ':'. For Cloud SQL volumes, it can be left empty, or must otherwise be /cloudsql. All instances defined in the Volume will be available as /cloudsql/[instance]. For more information on Cloud SQL volumes, visit https://cloud.google.com/sql/docs/mysql/connect-run
        """
        return pulumi.get(self, "mount_path")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        This must match the Name of a Volume.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ServiceTemplateScaling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxInstanceCount":
            suggest = "max_instance_count"
        elif key == "minInstanceCount":
            suggest = "min_instance_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateScaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateScaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateScaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_instance_count: Optional[int] = None,
                 min_instance_count: Optional[int] = None):
        """
        :param int max_instance_count: Maximum number of serving instances that this resource should have.
        :param int min_instance_count: Minimum number of serving instances that this resource should have.
        """
        if max_instance_count is not None:
            pulumi.set(__self__, "max_instance_count", max_instance_count)
        if min_instance_count is not None:
            pulumi.set(__self__, "min_instance_count", min_instance_count)

    @property
    @pulumi.getter(name="maxInstanceCount")
    def max_instance_count(self) -> Optional[int]:
        """
        Maximum number of serving instances that this resource should have.
        """
        return pulumi.get(self, "max_instance_count")

    @property
    @pulumi.getter(name="minInstanceCount")
    def min_instance_count(self) -> Optional[int]:
        """
        Minimum number of serving instances that this resource should have.
        """
        return pulumi.get(self, "min_instance_count")


@pulumi.output_type
class ServiceTemplateVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudSqlInstance":
            suggest = "cloud_sql_instance"
        elif key == "emptyDir":
            suggest = "empty_dir"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 cloud_sql_instance: Optional['outputs.ServiceTemplateVolumeCloudSqlInstance'] = None,
                 empty_dir: Optional['outputs.ServiceTemplateVolumeEmptyDir'] = None,
                 secret: Optional['outputs.ServiceTemplateVolumeSecret'] = None):
        """
        :param str name: Volume's name.
        :param 'ServiceTemplateVolumeCloudSqlInstanceArgs' cloud_sql_instance: For Cloud SQL volumes, contains the specific instances that should be mounted. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run.
               Structure is documented below.
        :param 'ServiceTemplateVolumeSecretArgs' secret: Secret represents a secret that should populate this volume. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
               Structure is documented below.
        """
        pulumi.set(__self__, "name", name)
        if cloud_sql_instance is not None:
            pulumi.set(__self__, "cloud_sql_instance", cloud_sql_instance)
        if empty_dir is not None:
            pulumi.set(__self__, "empty_dir", empty_dir)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Volume's name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="cloudSqlInstance")
    def cloud_sql_instance(self) -> Optional['outputs.ServiceTemplateVolumeCloudSqlInstance']:
        """
        For Cloud SQL volumes, contains the specific instances that should be mounted. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run.
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_sql_instance")

    @property
    @pulumi.getter(name="emptyDir")
    def empty_dir(self) -> Optional['outputs.ServiceTemplateVolumeEmptyDir']:
        return pulumi.get(self, "empty_dir")

    @property
    @pulumi.getter
    def secret(self) -> Optional['outputs.ServiceTemplateVolumeSecret']:
        """
        Secret represents a secret that should populate this volume. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
        Structure is documented below.
        """
        return pulumi.get(self, "secret")


@pulumi.output_type
class ServiceTemplateVolumeCloudSqlInstance(dict):
    def __init__(__self__, *,
                 instances: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] instances: The Cloud SQL instance connection names, as can be found in https://console.cloud.google.com/sql/instances. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run. Format: {project}:{location}:{instance}
        """
        if instances is not None:
            pulumi.set(__self__, "instances", instances)

    @property
    @pulumi.getter
    def instances(self) -> Optional[Sequence[str]]:
        """
        The Cloud SQL instance connection names, as can be found in https://console.cloud.google.com/sql/instances. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run. Format: {project}:{location}:{instance}
        """
        return pulumi.get(self, "instances")


@pulumi.output_type
class ServiceTemplateVolumeEmptyDir(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sizeLimit":
            suggest = "size_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateVolumeEmptyDir. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateVolumeEmptyDir.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateVolumeEmptyDir.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 medium: Optional[str] = None,
                 size_limit: Optional[str] = None):
        """
        :param str medium: The different types of medium supported for EmptyDir.
               Default value is `MEMORY`.
               Possible values are: `MEMORY`.
        :param str size_limit: Limit on the storage usable by this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. This field's values are of the 'Quantity' k8s type: https://kubernetes.io/docs/reference/kubernetes-api/common-definitions/quantity/. The default is nil which means that the limit is undefined. More info: https://kubernetes.io/docs/concepts/storage/volumes/#emptydir.
               
               - - -
        """
        if medium is not None:
            pulumi.set(__self__, "medium", medium)
        if size_limit is not None:
            pulumi.set(__self__, "size_limit", size_limit)

    @property
    @pulumi.getter
    def medium(self) -> Optional[str]:
        """
        The different types of medium supported for EmptyDir.
        Default value is `MEMORY`.
        Possible values are: `MEMORY`.
        """
        return pulumi.get(self, "medium")

    @property
    @pulumi.getter(name="sizeLimit")
    def size_limit(self) -> Optional[str]:
        """
        Limit on the storage usable by this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. This field's values are of the 'Quantity' k8s type: https://kubernetes.io/docs/reference/kubernetes-api/common-definitions/quantity/. The default is nil which means that the limit is undefined. More info: https://kubernetes.io/docs/concepts/storage/volumes/#emptydir.

        - - -
        """
        return pulumi.get(self, "size_limit")


@pulumi.output_type
class ServiceTemplateVolumeSecret(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultMode":
            suggest = "default_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateVolumeSecret. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateVolumeSecret.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateVolumeSecret.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret: str,
                 default_mode: Optional[int] = None,
                 items: Optional[Sequence['outputs.ServiceTemplateVolumeSecretItem']] = None):
        """
        :param str secret: The name of the secret in Cloud Secret Manager. Format: {secret} if the secret is in the same project. projects/{project}/secrets/{secret} if the secret is in a different project.
        :param int default_mode: Integer representation of mode bits to use on created files by default. Must be a value between 0000 and 0777 (octal), defaulting to 0444. Directories within the path are not affected by this setting.
        :param Sequence['ServiceTemplateVolumeSecretItemArgs'] items: If unspecified, the volume will expose a file whose name is the secret, relative to VolumeMount.mount_path. If specified, the key will be used as the version to fetch from Cloud Secret Manager and the path will be the name of the file exposed in the volume. When items are defined, they must specify a path and a version.
               Structure is documented below.
        """
        pulumi.set(__self__, "secret", secret)
        if default_mode is not None:
            pulumi.set(__self__, "default_mode", default_mode)
        if items is not None:
            pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def secret(self) -> str:
        """
        The name of the secret in Cloud Secret Manager. Format: {secret} if the secret is in the same project. projects/{project}/secrets/{secret} if the secret is in a different project.
        """
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter(name="defaultMode")
    def default_mode(self) -> Optional[int]:
        """
        Integer representation of mode bits to use on created files by default. Must be a value between 0000 and 0777 (octal), defaulting to 0444. Directories within the path are not affected by this setting.
        """
        return pulumi.get(self, "default_mode")

    @property
    @pulumi.getter
    def items(self) -> Optional[Sequence['outputs.ServiceTemplateVolumeSecretItem']]:
        """
        If unspecified, the volume will expose a file whose name is the secret, relative to VolumeMount.mount_path. If specified, the key will be used as the version to fetch from Cloud Secret Manager and the path will be the name of the file exposed in the volume. When items are defined, they must specify a path and a version.
        Structure is documented below.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class ServiceTemplateVolumeSecretItem(dict):
    def __init__(__self__, *,
                 mode: int,
                 path: str,
                 version: Optional[str] = None):
        """
        :param int mode: Integer octal mode bits to use on this file, must be a value between 01 and 0777 (octal). If 0 or not set, the Volume's default mode will be used.
        :param str path: The relative path of the secret in the container.
        :param str version: The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version
        """
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "path", path)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def mode(self) -> int:
        """
        Integer octal mode bits to use on this file, must be a value between 01 and 0777 (octal). If 0 or not set, the Volume's default mode will be used.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The relative path of the secret in the container.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ServiceTemplateVpcAccess(dict):
    def __init__(__self__, *,
                 connector: Optional[str] = None,
                 egress: Optional[str] = None):
        """
        :param str connector: VPC Access connector name. Format: projects/{project}/locations/{location}/connectors/{connector}, where {project} can be project id or number.
        :param str egress: Traffic VPC egress settings.
               Possible values are: `ALL_TRAFFIC`, `PRIVATE_RANGES_ONLY`.
        """
        if connector is not None:
            pulumi.set(__self__, "connector", connector)
        if egress is not None:
            pulumi.set(__self__, "egress", egress)

    @property
    @pulumi.getter
    def connector(self) -> Optional[str]:
        """
        VPC Access connector name. Format: projects/{project}/locations/{location}/connectors/{connector}, where {project} can be project id or number.
        """
        return pulumi.get(self, "connector")

    @property
    @pulumi.getter
    def egress(self) -> Optional[str]:
        """
        Traffic VPC egress settings.
        Possible values are: `ALL_TRAFFIC`, `PRIVATE_RANGES_ONLY`.
        """
        return pulumi.get(self, "egress")


@pulumi.output_type
class ServiceTerminalCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executionReason":
            suggest = "execution_reason"
        elif key == "lastTransitionTime":
            suggest = "last_transition_time"
        elif key == "revisionReason":
            suggest = "revision_reason"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTerminalCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTerminalCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTerminalCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execution_reason: Optional[str] = None,
                 last_transition_time: Optional[str] = None,
                 message: Optional[str] = None,
                 reason: Optional[str] = None,
                 revision_reason: Optional[str] = None,
                 severity: Optional[str] = None,
                 state: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str execution_reason: (Output)
               A reason for the execution condition.
        :param str last_transition_time: (Output)
               Last time the condition transitioned from one status to another.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param str message: (Output)
               Human readable message indicating details about the current status.
        :param str reason: (Output)
               A common (service-level) reason for this condition.
        :param str revision_reason: (Output)
               A reason for the revision condition.
        :param str severity: (Output)
               How to interpret failures of this condition, one of Error, Warning, Info
        :param str state: (Output)
               State of the condition.
        :param str type: The allocation type for this traffic target.
               Possible values are: `TRAFFIC_TARGET_ALLOCATION_TYPE_LATEST`, `TRAFFIC_TARGET_ALLOCATION_TYPE_REVISION`.
        """
        if execution_reason is not None:
            pulumi.set(__self__, "execution_reason", execution_reason)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if revision_reason is not None:
            pulumi.set(__self__, "revision_reason", revision_reason)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="executionReason")
    def execution_reason(self) -> Optional[str]:
        """
        (Output)
        A reason for the execution condition.
        """
        return pulumi.get(self, "execution_reason")

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[str]:
        """
        (Output)
        Last time the condition transitioned from one status to another.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "last_transition_time")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        (Output)
        Human readable message indicating details about the current status.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def reason(self) -> Optional[str]:
        """
        (Output)
        A common (service-level) reason for this condition.
        """
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter(name="revisionReason")
    def revision_reason(self) -> Optional[str]:
        """
        (Output)
        A reason for the revision condition.
        """
        return pulumi.get(self, "revision_reason")

    @property
    @pulumi.getter
    def severity(self) -> Optional[str]:
        """
        (Output)
        How to interpret failures of this condition, one of Error, Warning, Info
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        (Output)
        State of the condition.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The allocation type for this traffic target.
        Possible values are: `TRAFFIC_TARGET_ALLOCATION_TYPE_LATEST`, `TRAFFIC_TARGET_ALLOCATION_TYPE_REVISION`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ServiceTraffic(dict):
    def __init__(__self__, *,
                 percent: Optional[int] = None,
                 revision: Optional[str] = None,
                 tag: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param int percent: Specifies percent of the traffic to this Revision. This defaults to zero if unspecified.
        :param str revision: Revision to which to send this portion of traffic, if traffic allocation is by revision.
        :param str tag: Indicates a string to be part of the URI to exclusively reference this target.
        :param str type: The allocation type for this traffic target.
               Possible values are: `TRAFFIC_TARGET_ALLOCATION_TYPE_LATEST`, `TRAFFIC_TARGET_ALLOCATION_TYPE_REVISION`.
        """
        if percent is not None:
            pulumi.set(__self__, "percent", percent)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def percent(self) -> Optional[int]:
        """
        Specifies percent of the traffic to this Revision. This defaults to zero if unspecified.
        """
        return pulumi.get(self, "percent")

    @property
    @pulumi.getter
    def revision(self) -> Optional[str]:
        """
        Revision to which to send this portion of traffic, if traffic allocation is by revision.
        """
        return pulumi.get(self, "revision")

    @property
    @pulumi.getter
    def tag(self) -> Optional[str]:
        """
        Indicates a string to be part of the URI to exclusively reference this target.
        """
        return pulumi.get(self, "tag")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The allocation type for this traffic target.
        Possible values are: `TRAFFIC_TARGET_ALLOCATION_TYPE_LATEST`, `TRAFFIC_TARGET_ALLOCATION_TYPE_REVISION`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ServiceTrafficStatus(dict):
    def __init__(__self__, *,
                 percent: Optional[int] = None,
                 revision: Optional[str] = None,
                 tag: Optional[str] = None,
                 type: Optional[str] = None,
                 uri: Optional[str] = None):
        """
        :param int percent: Specifies percent of the traffic to this Revision. This defaults to zero if unspecified.
        :param str revision: The unique name for the revision. If this field is omitted, it will be automatically generated based on the Service name.
               
               (Optional)
               Revision to which to send this portion of traffic, if traffic allocation is by revision.
        :param str tag: Indicates a string to be part of the URI to exclusively reference this target.
        :param str type: The allocation type for this traffic target.
               Possible values are: `TRAFFIC_TARGET_ALLOCATION_TYPE_LATEST`, `TRAFFIC_TARGET_ALLOCATION_TYPE_REVISION`.
        :param str uri: (Output)
               Displays the target URI.
        """
        if percent is not None:
            pulumi.set(__self__, "percent", percent)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def percent(self) -> Optional[int]:
        """
        Specifies percent of the traffic to this Revision. This defaults to zero if unspecified.
        """
        return pulumi.get(self, "percent")

    @property
    @pulumi.getter
    def revision(self) -> Optional[str]:
        """
        The unique name for the revision. If this field is omitted, it will be automatically generated based on the Service name.

        (Optional)
        Revision to which to send this portion of traffic, if traffic allocation is by revision.
        """
        return pulumi.get(self, "revision")

    @property
    @pulumi.getter
    def tag(self) -> Optional[str]:
        """
        Indicates a string to be part of the URI to exclusively reference this target.
        """
        return pulumi.get(self, "tag")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The allocation type for this traffic target.
        Possible values are: `TRAFFIC_TARGET_ALLOCATION_TYPE_LATEST`, `TRAFFIC_TARGET_ALLOCATION_TYPE_REVISION`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def uri(self) -> Optional[str]:
        """
        (Output)
        Displays the target URI.
        """
        return pulumi.get(self, "uri")


