# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['AddressArgs', 'Address']

@pulumi.input_type
class AddressArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 address_type: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 network_tier: Optional[pulumi.Input[str]] = None,
                 prefix_length: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 purpose: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 subnetwork: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Address resource.
        :param pulumi.Input[str] address: The static external IP address represented by this resource. Only
               IPv4 is supported. An address may only be specified for INTERNAL
               address types. The IP address must be inside the specified subnetwork,
               if any. Set by the API if undefined.
        :param pulumi.Input[str] address_type: The type of address to reserve.
               Note: if you set this argument's value as `INTERNAL` you need to leave the `network_tier` argument unset in that resource block.
               Default value is `EXTERNAL`.
               Possible values are: `INTERNAL`, `EXTERNAL`.
        :param pulumi.Input[str] description: An optional description of this resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels to apply to this address.  A list of key->value pairs.
        :param pulumi.Input[str] name: Name of the resource. The name must be 1-63 characters long, and
               comply with RFC1035. Specifically, the name must be 1-63 characters
               long and match the regular expression `a-z?`
               which means the first character must be a lowercase letter, and all
               following characters must be a dash, lowercase letter, or digit,
               except the last character, which cannot be a dash.
               
               
               - - -
        :param pulumi.Input[str] network: The URL of the network in which to reserve the address. This field
               can only be used with INTERNAL type with the VPC_PEERING and
               IPSEC_INTERCONNECT purposes.
        :param pulumi.Input[str] network_tier: The networking tier used for configuring this address. If this field is not
               specified, it is assumed to be PREMIUM.
               This argument should not be used when configuring Internal addresses, because [network tier cannot be set for internal traffic; it's always Premium](https://cloud.google.com/network-tiers/docs/overview).
               Possible values are: `PREMIUM`, `STANDARD`.
        :param pulumi.Input[int] prefix_length: The prefix length if the resource represents an IP range.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] purpose: The purpose of this resource, which can be one of the following values.
               * GCE_ENDPOINT for addresses that are used by VM instances, alias IP
               ranges, load balancers, and similar resources.
               * SHARED_LOADBALANCER_VIP for an address that can be used by multiple
               internal load balancers.
               * VPC_PEERING for addresses that are reserved for VPC peer networks.
               * IPSEC_INTERCONNECT for addresses created from a private IP range that
               are reserved for a VLAN attachment in an HA VPN over Cloud Interconnect
               configuration. These addresses are regional resources.
               * PRIVATE_SERVICE_CONNECT for a private network address that is used to
               configure Private Service Connect. Only global internal addresses can use
               this purpose.
               
               This should only be set when using an Internal address.
        :param pulumi.Input[str] region: The Region in which the created address should reside.
               If it is not provided, the provider region is used.
        :param pulumi.Input[str] subnetwork: The URL of the subnetwork in which to reserve the address. If an IP
               address is specified, it must be within the subnetwork's IP range.
               This field can only be used with INTERNAL type with
               GCE_ENDPOINT/DNS_RESOLVER purposes.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if address_type is not None:
            pulumi.set(__self__, "address_type", address_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if network_tier is not None:
            pulumi.set(__self__, "network_tier", network_tier)
        if prefix_length is not None:
            pulumi.set(__self__, "prefix_length", prefix_length)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if purpose is not None:
            pulumi.set(__self__, "purpose", purpose)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        The static external IP address represented by this resource. Only
        IPv4 is supported. An address may only be specified for INTERNAL
        address types. The IP address must be inside the specified subnetwork,
        if any. Set by the API if undefined.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter(name="addressType")
    def address_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of address to reserve.
        Note: if you set this argument's value as `INTERNAL` you need to leave the `network_tier` argument unset in that resource block.
        Default value is `EXTERNAL`.
        Possible values are: `INTERNAL`, `EXTERNAL`.
        """
        return pulumi.get(self, "address_type")

    @address_type.setter
    def address_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels to apply to this address.  A list of key->value pairs.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource. The name must be 1-63 characters long, and
        comply with RFC1035. Specifically, the name must be 1-63 characters
        long and match the regular expression `a-z?`
        which means the first character must be a lowercase letter, and all
        following characters must be a dash, lowercase letter, or digit,
        except the last character, which cannot be a dash.


        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of the network in which to reserve the address. This field
        can only be used with INTERNAL type with the VPC_PEERING and
        IPSEC_INTERCONNECT purposes.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="networkTier")
    def network_tier(self) -> Optional[pulumi.Input[str]]:
        """
        The networking tier used for configuring this address. If this field is not
        specified, it is assumed to be PREMIUM.
        This argument should not be used when configuring Internal addresses, because [network tier cannot be set for internal traffic; it's always Premium](https://cloud.google.com/network-tiers/docs/overview).
        Possible values are: `PREMIUM`, `STANDARD`.
        """
        return pulumi.get(self, "network_tier")

    @network_tier.setter
    def network_tier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_tier", value)

    @property
    @pulumi.getter(name="prefixLength")
    def prefix_length(self) -> Optional[pulumi.Input[int]]:
        """
        The prefix length if the resource represents an IP range.
        """
        return pulumi.get(self, "prefix_length")

    @prefix_length.setter
    def prefix_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "prefix_length", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def purpose(self) -> Optional[pulumi.Input[str]]:
        """
        The purpose of this resource, which can be one of the following values.
        * GCE_ENDPOINT for addresses that are used by VM instances, alias IP
        ranges, load balancers, and similar resources.
        * SHARED_LOADBALANCER_VIP for an address that can be used by multiple
        internal load balancers.
        * VPC_PEERING for addresses that are reserved for VPC peer networks.
        * IPSEC_INTERCONNECT for addresses created from a private IP range that
        are reserved for a VLAN attachment in an HA VPN over Cloud Interconnect
        configuration. These addresses are regional resources.
        * PRIVATE_SERVICE_CONNECT for a private network address that is used to
        configure Private Service Connect. Only global internal addresses can use
        this purpose.

        This should only be set when using an Internal address.
        """
        return pulumi.get(self, "purpose")

    @purpose.setter
    def purpose(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "purpose", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The Region in which the created address should reside.
        If it is not provided, the provider region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def subnetwork(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of the subnetwork in which to reserve the address. If an IP
        address is specified, it must be within the subnetwork's IP range.
        This field can only be used with INTERNAL type with
        GCE_ENDPOINT/DNS_RESOLVER purposes.
        """
        return pulumi.get(self, "subnetwork")

    @subnetwork.setter
    def subnetwork(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnetwork", value)


@pulumi.input_type
class _AddressState:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 address_type: Optional[pulumi.Input[str]] = None,
                 creation_timestamp: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 label_fingerprint: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 network_tier: Optional[pulumi.Input[str]] = None,
                 prefix_length: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 purpose: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 subnetwork: Optional[pulumi.Input[str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering Address resources.
        :param pulumi.Input[str] address: The static external IP address represented by this resource. Only
               IPv4 is supported. An address may only be specified for INTERNAL
               address types. The IP address must be inside the specified subnetwork,
               if any. Set by the API if undefined.
        :param pulumi.Input[str] address_type: The type of address to reserve.
               Note: if you set this argument's value as `INTERNAL` you need to leave the `network_tier` argument unset in that resource block.
               Default value is `EXTERNAL`.
               Possible values are: `INTERNAL`, `EXTERNAL`.
        :param pulumi.Input[str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[str] description: An optional description of this resource.
        :param pulumi.Input[str] label_fingerprint: The fingerprint used for optimistic locking of this resource. Used internally during updates.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels to apply to this address.  A list of key->value pairs.
        :param pulumi.Input[str] name: Name of the resource. The name must be 1-63 characters long, and
               comply with RFC1035. Specifically, the name must be 1-63 characters
               long and match the regular expression `a-z?`
               which means the first character must be a lowercase letter, and all
               following characters must be a dash, lowercase letter, or digit,
               except the last character, which cannot be a dash.
               
               
               - - -
        :param pulumi.Input[str] network: The URL of the network in which to reserve the address. This field
               can only be used with INTERNAL type with the VPC_PEERING and
               IPSEC_INTERCONNECT purposes.
        :param pulumi.Input[str] network_tier: The networking tier used for configuring this address. If this field is not
               specified, it is assumed to be PREMIUM.
               This argument should not be used when configuring Internal addresses, because [network tier cannot be set for internal traffic; it's always Premium](https://cloud.google.com/network-tiers/docs/overview).
               Possible values are: `PREMIUM`, `STANDARD`.
        :param pulumi.Input[int] prefix_length: The prefix length if the resource represents an IP range.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] purpose: The purpose of this resource, which can be one of the following values.
               * GCE_ENDPOINT for addresses that are used by VM instances, alias IP
               ranges, load balancers, and similar resources.
               * SHARED_LOADBALANCER_VIP for an address that can be used by multiple
               internal load balancers.
               * VPC_PEERING for addresses that are reserved for VPC peer networks.
               * IPSEC_INTERCONNECT for addresses created from a private IP range that
               are reserved for a VLAN attachment in an HA VPN over Cloud Interconnect
               configuration. These addresses are regional resources.
               * PRIVATE_SERVICE_CONNECT for a private network address that is used to
               configure Private Service Connect. Only global internal addresses can use
               this purpose.
               
               This should only be set when using an Internal address.
        :param pulumi.Input[str] region: The Region in which the created address should reside.
               If it is not provided, the provider region is used.
        :param pulumi.Input[str] self_link: The URI of the created resource.
        :param pulumi.Input[str] subnetwork: The URL of the subnetwork in which to reserve the address. If an IP
               address is specified, it must be within the subnetwork's IP range.
               This field can only be used with INTERNAL type with
               GCE_ENDPOINT/DNS_RESOLVER purposes.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] users: The URLs of the resources that are using this address.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if address_type is not None:
            pulumi.set(__self__, "address_type", address_type)
        if creation_timestamp is not None:
            pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if label_fingerprint is not None:
            pulumi.set(__self__, "label_fingerprint", label_fingerprint)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if network_tier is not None:
            pulumi.set(__self__, "network_tier", network_tier)
        if prefix_length is not None:
            pulumi.set(__self__, "prefix_length", prefix_length)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if purpose is not None:
            pulumi.set(__self__, "purpose", purpose)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)
        if users is not None:
            pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        The static external IP address represented by this resource. Only
        IPv4 is supported. An address may only be specified for INTERNAL
        address types. The IP address must be inside the specified subnetwork,
        if any. Set by the API if undefined.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter(name="addressType")
    def address_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of address to reserve.
        Note: if you set this argument's value as `INTERNAL` you need to leave the `network_tier` argument unset in that resource block.
        Default value is `EXTERNAL`.
        Possible values are: `INTERNAL`, `EXTERNAL`.
        """
        return pulumi.get(self, "address_type")

    @address_type.setter
    def address_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address_type", value)

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> Optional[pulumi.Input[str]]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @creation_timestamp.setter
    def creation_timestamp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_timestamp", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="labelFingerprint")
    def label_fingerprint(self) -> Optional[pulumi.Input[str]]:
        """
        The fingerprint used for optimistic locking of this resource. Used internally during updates.
        """
        return pulumi.get(self, "label_fingerprint")

    @label_fingerprint.setter
    def label_fingerprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label_fingerprint", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels to apply to this address.  A list of key->value pairs.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource. The name must be 1-63 characters long, and
        comply with RFC1035. Specifically, the name must be 1-63 characters
        long and match the regular expression `a-z?`
        which means the first character must be a lowercase letter, and all
        following characters must be a dash, lowercase letter, or digit,
        except the last character, which cannot be a dash.


        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of the network in which to reserve the address. This field
        can only be used with INTERNAL type with the VPC_PEERING and
        IPSEC_INTERCONNECT purposes.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="networkTier")
    def network_tier(self) -> Optional[pulumi.Input[str]]:
        """
        The networking tier used for configuring this address. If this field is not
        specified, it is assumed to be PREMIUM.
        This argument should not be used when configuring Internal addresses, because [network tier cannot be set for internal traffic; it's always Premium](https://cloud.google.com/network-tiers/docs/overview).
        Possible values are: `PREMIUM`, `STANDARD`.
        """
        return pulumi.get(self, "network_tier")

    @network_tier.setter
    def network_tier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_tier", value)

    @property
    @pulumi.getter(name="prefixLength")
    def prefix_length(self) -> Optional[pulumi.Input[int]]:
        """
        The prefix length if the resource represents an IP range.
        """
        return pulumi.get(self, "prefix_length")

    @prefix_length.setter
    def prefix_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "prefix_length", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def purpose(self) -> Optional[pulumi.Input[str]]:
        """
        The purpose of this resource, which can be one of the following values.
        * GCE_ENDPOINT for addresses that are used by VM instances, alias IP
        ranges, load balancers, and similar resources.
        * SHARED_LOADBALANCER_VIP for an address that can be used by multiple
        internal load balancers.
        * VPC_PEERING for addresses that are reserved for VPC peer networks.
        * IPSEC_INTERCONNECT for addresses created from a private IP range that
        are reserved for a VLAN attachment in an HA VPN over Cloud Interconnect
        configuration. These addresses are regional resources.
        * PRIVATE_SERVICE_CONNECT for a private network address that is used to
        configure Private Service Connect. Only global internal addresses can use
        this purpose.

        This should only be set when using an Internal address.
        """
        return pulumi.get(self, "purpose")

    @purpose.setter
    def purpose(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "purpose", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The Region in which the created address should reside.
        If it is not provided, the provider region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter
    def subnetwork(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of the subnetwork in which to reserve the address. If an IP
        address is specified, it must be within the subnetwork's IP range.
        This field can only be used with INTERNAL type with
        GCE_ENDPOINT/DNS_RESOLVER purposes.
        """
        return pulumi.get(self, "subnetwork")

    @subnetwork.setter
    def subnetwork(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnetwork", value)

    @property
    @pulumi.getter
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The URLs of the resources that are using this address.
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "users", value)


class Address(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[str]] = None,
                 address_type: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 network_tier: Optional[pulumi.Input[str]] = None,
                 prefix_length: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 purpose: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 subnetwork: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Represents an Address resource.

        Each virtual machine instance has an ephemeral internal IP address and,
        optionally, an external IP address. To communicate between instances on
        the same network, you can use an instance's internal IP address. To
        communicate with the Internet and instances outside of the same network,
        you must specify the instance's external IP address.

        Internal IP addresses are ephemeral and only belong to an instance for
        the lifetime of the instance; if the instance is deleted and recreated,
        the instance is assigned a new internal IP address, either by Compute
        Engine or by you. External IP addresses can be either ephemeral or
        static.

        To get more information about Address, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/beta/addresses)
        * How-to Guides
            * [Reserving a Static External IP Address](https://cloud.google.com/compute/docs/instances-and-network)
            * [Reserving a Static Internal IP Address](https://cloud.google.com/compute/docs/ip-addresses/reserve-static-internal-ip-address)

        ## Example Usage
        ### Address Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        ip_address = gcp.compute.Address("ipAddress")
        ```
        ### Address With Subnetwork

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_network = gcp.compute.Network("defaultNetwork")
        default_subnetwork = gcp.compute.Subnetwork("defaultSubnetwork",
            ip_cidr_range="10.0.0.0/16",
            region="us-central1",
            network=default_network.id)
        internal_with_subnet_and_address = gcp.compute.Address("internalWithSubnetAndAddress",
            subnetwork=default_subnetwork.id,
            address_type="INTERNAL",
            address="10.0.42.42",
            region="us-central1")
        ```
        ### Address With Gce Endpoint

        ```python
        import pulumi
        import pulumi_gcp as gcp

        internal_with_gce_endpoint = gcp.compute.Address("internalWithGceEndpoint",
            address_type="INTERNAL",
            purpose="GCE_ENDPOINT")
        ```
        ### Instance With Ip

        ```python
        import pulumi
        import pulumi_gcp as gcp

        static = gcp.compute.Address("static")
        debian_image = gcp.compute.get_image(family="debian-11",
            project="debian-cloud")
        instance_with_ip = gcp.compute.Instance("instanceWithIp",
            machine_type="f1-micro",
            zone="us-central1-a",
            boot_disk=gcp.compute.InstanceBootDiskArgs(
                initialize_params=gcp.compute.InstanceBootDiskInitializeParamsArgs(
                    image=debian_image.self_link,
                ),
            ),
            network_interfaces=[gcp.compute.InstanceNetworkInterfaceArgs(
                network="default",
                access_configs=[gcp.compute.InstanceNetworkInterfaceAccessConfigArgs(
                    nat_ip=static.address,
                )],
            )])
        ```
        ### Compute Address Ipsec Interconnect

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network = gcp.compute.Network("network", auto_create_subnetworks=False)
        ipsec_interconnect_address = gcp.compute.Address("ipsec-interconnect-address",
            address_type="INTERNAL",
            purpose="IPSEC_INTERCONNECT",
            address="192.168.1.0",
            prefix_length=29,
            network=network.self_link)
        ```

        ## Import

        Address can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:compute/address:Address default projects/{{project}}/regions/{{region}}/addresses/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/address:Address default {{project}}/{{region}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/address:Address default {{region}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/address:Address default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] address: The static external IP address represented by this resource. Only
               IPv4 is supported. An address may only be specified for INTERNAL
               address types. The IP address must be inside the specified subnetwork,
               if any. Set by the API if undefined.
        :param pulumi.Input[str] address_type: The type of address to reserve.
               Note: if you set this argument's value as `INTERNAL` you need to leave the `network_tier` argument unset in that resource block.
               Default value is `EXTERNAL`.
               Possible values are: `INTERNAL`, `EXTERNAL`.
        :param pulumi.Input[str] description: An optional description of this resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels to apply to this address.  A list of key->value pairs.
        :param pulumi.Input[str] name: Name of the resource. The name must be 1-63 characters long, and
               comply with RFC1035. Specifically, the name must be 1-63 characters
               long and match the regular expression `a-z?`
               which means the first character must be a lowercase letter, and all
               following characters must be a dash, lowercase letter, or digit,
               except the last character, which cannot be a dash.
               
               
               - - -
        :param pulumi.Input[str] network: The URL of the network in which to reserve the address. This field
               can only be used with INTERNAL type with the VPC_PEERING and
               IPSEC_INTERCONNECT purposes.
        :param pulumi.Input[str] network_tier: The networking tier used for configuring this address. If this field is not
               specified, it is assumed to be PREMIUM.
               This argument should not be used when configuring Internal addresses, because [network tier cannot be set for internal traffic; it's always Premium](https://cloud.google.com/network-tiers/docs/overview).
               Possible values are: `PREMIUM`, `STANDARD`.
        :param pulumi.Input[int] prefix_length: The prefix length if the resource represents an IP range.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] purpose: The purpose of this resource, which can be one of the following values.
               * GCE_ENDPOINT for addresses that are used by VM instances, alias IP
               ranges, load balancers, and similar resources.
               * SHARED_LOADBALANCER_VIP for an address that can be used by multiple
               internal load balancers.
               * VPC_PEERING for addresses that are reserved for VPC peer networks.
               * IPSEC_INTERCONNECT for addresses created from a private IP range that
               are reserved for a VLAN attachment in an HA VPN over Cloud Interconnect
               configuration. These addresses are regional resources.
               * PRIVATE_SERVICE_CONNECT for a private network address that is used to
               configure Private Service Connect. Only global internal addresses can use
               this purpose.
               
               This should only be set when using an Internal address.
        :param pulumi.Input[str] region: The Region in which the created address should reside.
               If it is not provided, the provider region is used.
        :param pulumi.Input[str] subnetwork: The URL of the subnetwork in which to reserve the address. If an IP
               address is specified, it must be within the subnetwork's IP range.
               This field can only be used with INTERNAL type with
               GCE_ENDPOINT/DNS_RESOLVER purposes.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AddressArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents an Address resource.

        Each virtual machine instance has an ephemeral internal IP address and,
        optionally, an external IP address. To communicate between instances on
        the same network, you can use an instance's internal IP address. To
        communicate with the Internet and instances outside of the same network,
        you must specify the instance's external IP address.

        Internal IP addresses are ephemeral and only belong to an instance for
        the lifetime of the instance; if the instance is deleted and recreated,
        the instance is assigned a new internal IP address, either by Compute
        Engine or by you. External IP addresses can be either ephemeral or
        static.

        To get more information about Address, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/beta/addresses)
        * How-to Guides
            * [Reserving a Static External IP Address](https://cloud.google.com/compute/docs/instances-and-network)
            * [Reserving a Static Internal IP Address](https://cloud.google.com/compute/docs/ip-addresses/reserve-static-internal-ip-address)

        ## Example Usage
        ### Address Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        ip_address = gcp.compute.Address("ipAddress")
        ```
        ### Address With Subnetwork

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_network = gcp.compute.Network("defaultNetwork")
        default_subnetwork = gcp.compute.Subnetwork("defaultSubnetwork",
            ip_cidr_range="10.0.0.0/16",
            region="us-central1",
            network=default_network.id)
        internal_with_subnet_and_address = gcp.compute.Address("internalWithSubnetAndAddress",
            subnetwork=default_subnetwork.id,
            address_type="INTERNAL",
            address="10.0.42.42",
            region="us-central1")
        ```
        ### Address With Gce Endpoint

        ```python
        import pulumi
        import pulumi_gcp as gcp

        internal_with_gce_endpoint = gcp.compute.Address("internalWithGceEndpoint",
            address_type="INTERNAL",
            purpose="GCE_ENDPOINT")
        ```
        ### Instance With Ip

        ```python
        import pulumi
        import pulumi_gcp as gcp

        static = gcp.compute.Address("static")
        debian_image = gcp.compute.get_image(family="debian-11",
            project="debian-cloud")
        instance_with_ip = gcp.compute.Instance("instanceWithIp",
            machine_type="f1-micro",
            zone="us-central1-a",
            boot_disk=gcp.compute.InstanceBootDiskArgs(
                initialize_params=gcp.compute.InstanceBootDiskInitializeParamsArgs(
                    image=debian_image.self_link,
                ),
            ),
            network_interfaces=[gcp.compute.InstanceNetworkInterfaceArgs(
                network="default",
                access_configs=[gcp.compute.InstanceNetworkInterfaceAccessConfigArgs(
                    nat_ip=static.address,
                )],
            )])
        ```
        ### Compute Address Ipsec Interconnect

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network = gcp.compute.Network("network", auto_create_subnetworks=False)
        ipsec_interconnect_address = gcp.compute.Address("ipsec-interconnect-address",
            address_type="INTERNAL",
            purpose="IPSEC_INTERCONNECT",
            address="192.168.1.0",
            prefix_length=29,
            network=network.self_link)
        ```

        ## Import

        Address can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:compute/address:Address default projects/{{project}}/regions/{{region}}/addresses/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/address:Address default {{project}}/{{region}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/address:Address default {{region}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/address:Address default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param AddressArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AddressArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[str]] = None,
                 address_type: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 network_tier: Optional[pulumi.Input[str]] = None,
                 prefix_length: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 purpose: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 subnetwork: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AddressArgs.__new__(AddressArgs)

            __props__.__dict__["address"] = address
            __props__.__dict__["address_type"] = address_type
            __props__.__dict__["description"] = description
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            __props__.__dict__["network"] = network
            __props__.__dict__["network_tier"] = network_tier
            __props__.__dict__["prefix_length"] = prefix_length
            __props__.__dict__["project"] = project
            __props__.__dict__["purpose"] = purpose
            __props__.__dict__["region"] = region
            __props__.__dict__["subnetwork"] = subnetwork
            __props__.__dict__["creation_timestamp"] = None
            __props__.__dict__["label_fingerprint"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["users"] = None
        super(Address, __self__).__init__(
            'gcp:compute/address:Address',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address: Optional[pulumi.Input[str]] = None,
            address_type: Optional[pulumi.Input[str]] = None,
            creation_timestamp: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            label_fingerprint: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network: Optional[pulumi.Input[str]] = None,
            network_tier: Optional[pulumi.Input[str]] = None,
            prefix_length: Optional[pulumi.Input[int]] = None,
            project: Optional[pulumi.Input[str]] = None,
            purpose: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            self_link: Optional[pulumi.Input[str]] = None,
            subnetwork: Optional[pulumi.Input[str]] = None,
            users: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'Address':
        """
        Get an existing Address resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] address: The static external IP address represented by this resource. Only
               IPv4 is supported. An address may only be specified for INTERNAL
               address types. The IP address must be inside the specified subnetwork,
               if any. Set by the API if undefined.
        :param pulumi.Input[str] address_type: The type of address to reserve.
               Note: if you set this argument's value as `INTERNAL` you need to leave the `network_tier` argument unset in that resource block.
               Default value is `EXTERNAL`.
               Possible values are: `INTERNAL`, `EXTERNAL`.
        :param pulumi.Input[str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[str] description: An optional description of this resource.
        :param pulumi.Input[str] label_fingerprint: The fingerprint used for optimistic locking of this resource. Used internally during updates.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels to apply to this address.  A list of key->value pairs.
        :param pulumi.Input[str] name: Name of the resource. The name must be 1-63 characters long, and
               comply with RFC1035. Specifically, the name must be 1-63 characters
               long and match the regular expression `a-z?`
               which means the first character must be a lowercase letter, and all
               following characters must be a dash, lowercase letter, or digit,
               except the last character, which cannot be a dash.
               
               
               - - -
        :param pulumi.Input[str] network: The URL of the network in which to reserve the address. This field
               can only be used with INTERNAL type with the VPC_PEERING and
               IPSEC_INTERCONNECT purposes.
        :param pulumi.Input[str] network_tier: The networking tier used for configuring this address. If this field is not
               specified, it is assumed to be PREMIUM.
               This argument should not be used when configuring Internal addresses, because [network tier cannot be set for internal traffic; it's always Premium](https://cloud.google.com/network-tiers/docs/overview).
               Possible values are: `PREMIUM`, `STANDARD`.
        :param pulumi.Input[int] prefix_length: The prefix length if the resource represents an IP range.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] purpose: The purpose of this resource, which can be one of the following values.
               * GCE_ENDPOINT for addresses that are used by VM instances, alias IP
               ranges, load balancers, and similar resources.
               * SHARED_LOADBALANCER_VIP for an address that can be used by multiple
               internal load balancers.
               * VPC_PEERING for addresses that are reserved for VPC peer networks.
               * IPSEC_INTERCONNECT for addresses created from a private IP range that
               are reserved for a VLAN attachment in an HA VPN over Cloud Interconnect
               configuration. These addresses are regional resources.
               * PRIVATE_SERVICE_CONNECT for a private network address that is used to
               configure Private Service Connect. Only global internal addresses can use
               this purpose.
               
               This should only be set when using an Internal address.
        :param pulumi.Input[str] region: The Region in which the created address should reside.
               If it is not provided, the provider region is used.
        :param pulumi.Input[str] self_link: The URI of the created resource.
        :param pulumi.Input[str] subnetwork: The URL of the subnetwork in which to reserve the address. If an IP
               address is specified, it must be within the subnetwork's IP range.
               This field can only be used with INTERNAL type with
               GCE_ENDPOINT/DNS_RESOLVER purposes.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] users: The URLs of the resources that are using this address.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AddressState.__new__(_AddressState)

        __props__.__dict__["address"] = address
        __props__.__dict__["address_type"] = address_type
        __props__.__dict__["creation_timestamp"] = creation_timestamp
        __props__.__dict__["description"] = description
        __props__.__dict__["label_fingerprint"] = label_fingerprint
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["network_tier"] = network_tier
        __props__.__dict__["prefix_length"] = prefix_length
        __props__.__dict__["project"] = project
        __props__.__dict__["purpose"] = purpose
        __props__.__dict__["region"] = region
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["subnetwork"] = subnetwork
        __props__.__dict__["users"] = users
        return Address(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Output[str]:
        """
        The static external IP address represented by this resource. Only
        IPv4 is supported. An address may only be specified for INTERNAL
        address types. The IP address must be inside the specified subnetwork,
        if any. Set by the API if undefined.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="addressType")
    def address_type(self) -> pulumi.Output[Optional[str]]:
        """
        The type of address to reserve.
        Note: if you set this argument's value as `INTERNAL` you need to leave the `network_tier` argument unset in that resource block.
        Default value is `EXTERNAL`.
        Possible values are: `INTERNAL`, `EXTERNAL`.
        """
        return pulumi.get(self, "address_type")

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[str]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="labelFingerprint")
    def label_fingerprint(self) -> pulumi.Output[str]:
        """
        The fingerprint used for optimistic locking of this resource. Used internally during updates.
        """
        return pulumi.get(self, "label_fingerprint")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Labels to apply to this address.  A list of key->value pairs.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the resource. The name must be 1-63 characters long, and
        comply with RFC1035. Specifically, the name must be 1-63 characters
        long and match the regular expression `a-z?`
        which means the first character must be a lowercase letter, and all
        following characters must be a dash, lowercase letter, or digit,
        except the last character, which cannot be a dash.


        - - -
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> pulumi.Output[Optional[str]]:
        """
        The URL of the network in which to reserve the address. This field
        can only be used with INTERNAL type with the VPC_PEERING and
        IPSEC_INTERCONNECT purposes.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="networkTier")
    def network_tier(self) -> pulumi.Output[str]:
        """
        The networking tier used for configuring this address. If this field is not
        specified, it is assumed to be PREMIUM.
        This argument should not be used when configuring Internal addresses, because [network tier cannot be set for internal traffic; it's always Premium](https://cloud.google.com/network-tiers/docs/overview).
        Possible values are: `PREMIUM`, `STANDARD`.
        """
        return pulumi.get(self, "network_tier")

    @property
    @pulumi.getter(name="prefixLength")
    def prefix_length(self) -> pulumi.Output[Optional[int]]:
        """
        The prefix length if the resource represents an IP range.
        """
        return pulumi.get(self, "prefix_length")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def purpose(self) -> pulumi.Output[str]:
        """
        The purpose of this resource, which can be one of the following values.
        * GCE_ENDPOINT for addresses that are used by VM instances, alias IP
        ranges, load balancers, and similar resources.
        * SHARED_LOADBALANCER_VIP for an address that can be used by multiple
        internal load balancers.
        * VPC_PEERING for addresses that are reserved for VPC peer networks.
        * IPSEC_INTERCONNECT for addresses created from a private IP range that
        are reserved for a VLAN attachment in an HA VPN over Cloud Interconnect
        configuration. These addresses are regional resources.
        * PRIVATE_SERVICE_CONNECT for a private network address that is used to
        configure Private Service Connect. Only global internal addresses can use
        this purpose.

        This should only be set when using an Internal address.
        """
        return pulumi.get(self, "purpose")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The Region in which the created address should reside.
        If it is not provided, the provider region is used.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter
    def subnetwork(self) -> pulumi.Output[str]:
        """
        The URL of the subnetwork in which to reserve the address. If an IP
        address is specified, it must be within the subnetwork's IP range.
        This field can only be used with INTERNAL type with
        GCE_ENDPOINT/DNS_RESOLVER purposes.
        """
        return pulumi.get(self, "subnetwork")

    @property
    @pulumi.getter
    def users(self) -> pulumi.Output[Sequence[str]]:
        """
        The URLs of the resources that are using this address.
        """
        return pulumi.get(self, "users")

