# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['CaExternalAccountKeyArgs', 'CaExternalAccountKey']

@pulumi.input_type
class CaExternalAccountKeyArgs:
    def __init__(__self__, *,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a CaExternalAccountKey resource.
        :param pulumi.Input[str] location: Location for the externalAccountKey. Currently only `global` is supported.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Location for the externalAccountKey. Currently only `global` is supported.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _CaExternalAccountKeyState:
    def __init__(__self__, *,
                 b64_mac_key: Optional[pulumi.Input[str]] = None,
                 key_id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering CaExternalAccountKey resources.
        :param pulumi.Input[str] b64_mac_key: Base64-URL-encoded HS256 key. It is generated by the PublicCertificateAuthorityService
               when the ExternalAccountKey is created.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[str] key_id: It is generated by the PublicCertificateAuthorityService when the ExternalAccountKey is created.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[str] location: Location for the externalAccountKey. Currently only `global` is supported.
        :param pulumi.Input[str] name: Resource name. projects/{project}/locations/{location}/externalAccountKeys/{keyId}.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        if b64_mac_key is not None:
            pulumi.set(__self__, "b64_mac_key", b64_mac_key)
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="b64MacKey")
    def b64_mac_key(self) -> Optional[pulumi.Input[str]]:
        """
        Base64-URL-encoded HS256 key. It is generated by the PublicCertificateAuthorityService
        when the ExternalAccountKey is created.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "b64_mac_key")

    @b64_mac_key.setter
    def b64_mac_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "b64_mac_key", value)

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[pulumi.Input[str]]:
        """
        It is generated by the PublicCertificateAuthorityService when the ExternalAccountKey is created.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_id", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Location for the externalAccountKey. Currently only `global` is supported.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource name. projects/{project}/locations/{location}/externalAccountKeys/{keyId}.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


class CaExternalAccountKey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        A representation of an ExternalAccountKey used for external account binding within ACME.

        To get more information about ExternalAccountKey, see:

        * [API documentation](https://cloud.google.com/certificate-manager/docs/reference/public-ca/rest/v1/projects.locations.externalAccountKeys/create)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/certificate-manager/docs/public-ca)
            * [Request EAB key ID and HMAC](https://cloud.google.com/certificate-manager/docs/public-ca-tutorial#request-key-hmac)
            * [Request Certificate Using Public CA](https://cloud.google.com/certificate-manager/docs/public-ca-tutorial)

        > **Warning:** This resource is create-only and could not be read from the API.
        On delete, the resource would be removed from the state.
        You must use an EAB secret within 7 days of obtaining it.
        The EAB secret is invalidated if you don't use it within 7 days.
        The ACME account registered by using an EAB secret has no expiration.

        > **Warning:** All arguments including the following potentially sensitive
        values will be stored in the raw state as plain text: `key_id`, `b64_mac_key`.
        Read more about sensitive data in state.

        ## Example Usage
        ### Public Ca External Account Key

        ```python
        import pulumi
        import pulumi_gcp as gcp

        prod = gcp.compute.CaExternalAccountKey("prod", project="my-project-name")
        ```

        ## Import

        This resource does not support import.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] location: Location for the externalAccountKey. Currently only `global` is supported.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[CaExternalAccountKeyArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A representation of an ExternalAccountKey used for external account binding within ACME.

        To get more information about ExternalAccountKey, see:

        * [API documentation](https://cloud.google.com/certificate-manager/docs/reference/public-ca/rest/v1/projects.locations.externalAccountKeys/create)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/certificate-manager/docs/public-ca)
            * [Request EAB key ID and HMAC](https://cloud.google.com/certificate-manager/docs/public-ca-tutorial#request-key-hmac)
            * [Request Certificate Using Public CA](https://cloud.google.com/certificate-manager/docs/public-ca-tutorial)

        > **Warning:** This resource is create-only and could not be read from the API.
        On delete, the resource would be removed from the state.
        You must use an EAB secret within 7 days of obtaining it.
        The EAB secret is invalidated if you don't use it within 7 days.
        The ACME account registered by using an EAB secret has no expiration.

        > **Warning:** All arguments including the following potentially sensitive
        values will be stored in the raw state as plain text: `key_id`, `b64_mac_key`.
        Read more about sensitive data in state.

        ## Example Usage
        ### Public Ca External Account Key

        ```python
        import pulumi
        import pulumi_gcp as gcp

        prod = gcp.compute.CaExternalAccountKey("prod", project="my-project-name")
        ```

        ## Import

        This resource does not support import.

        :param str resource_name: The name of the resource.
        :param CaExternalAccountKeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CaExternalAccountKeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CaExternalAccountKeyArgs.__new__(CaExternalAccountKeyArgs)

            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["b64_mac_key"] = None
            __props__.__dict__["key_id"] = None
            __props__.__dict__["name"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["b64MacKey", "keyId"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(CaExternalAccountKey, __self__).__init__(
            'gcp:compute/caExternalAccountKey:CaExternalAccountKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            b64_mac_key: Optional[pulumi.Input[str]] = None,
            key_id: Optional[pulumi.Input[str]] = None,
            location: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None) -> 'CaExternalAccountKey':
        """
        Get an existing CaExternalAccountKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] b64_mac_key: Base64-URL-encoded HS256 key. It is generated by the PublicCertificateAuthorityService
               when the ExternalAccountKey is created.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[str] key_id: It is generated by the PublicCertificateAuthorityService when the ExternalAccountKey is created.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[str] location: Location for the externalAccountKey. Currently only `global` is supported.
        :param pulumi.Input[str] name: Resource name. projects/{project}/locations/{location}/externalAccountKeys/{keyId}.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CaExternalAccountKeyState.__new__(_CaExternalAccountKeyState)

        __props__.__dict__["b64_mac_key"] = b64_mac_key
        __props__.__dict__["key_id"] = key_id
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        return CaExternalAccountKey(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="b64MacKey")
    def b64_mac_key(self) -> pulumi.Output[str]:
        """
        Base64-URL-encoded HS256 key. It is generated by the PublicCertificateAuthorityService
        when the ExternalAccountKey is created.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "b64_mac_key")

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> pulumi.Output[str]:
        """
        It is generated by the PublicCertificateAuthorityService when the ExternalAccountKey is created.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[str]]:
        """
        Location for the externalAccountKey. Currently only `global` is supported.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Resource name. projects/{project}/locations/{location}/externalAccountKeys/{keyId}.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

