# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GlobalForwardingRuleArgs', 'GlobalForwardingRule']

@pulumi.input_type
class GlobalForwardingRuleArgs:
    def __init__(__self__, *,
                 target: pulumi.Input[str],
                 allow_psc_global_access: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 ip_protocol: Optional[pulumi.Input[str]] = None,
                 ip_version: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 load_balancing_scheme: Optional[pulumi.Input[str]] = None,
                 metadata_filters: Optional[pulumi.Input[Sequence[pulumi.Input['GlobalForwardingRuleMetadataFilterArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 no_automate_dns_zone: Optional[pulumi.Input[bool]] = None,
                 port_range: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 source_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a GlobalForwardingRule resource.
        :param pulumi.Input[str] target: The URL of the target resource to receive the matched traffic.  For
               regional forwarding rules, this target must be in the same region as the
               forwarding rule. For global forwarding rules, this target must be a global
               load balancing resource.
               The forwarded traffic must be of a type appropriate to the target object.
               *  For load balancers, see the "Target" column in [Port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
               *  For Private Service Connect forwarding rules that forward traffic to Google APIs, provide the name of a supported Google API bundle:
               *  `vpc-sc` - [ APIs that support VPC Service Controls](https://cloud.google.com/vpc-service-controls/docs/supported-products).
               *  `all-apis` - [All supported Google APIs](https://cloud.google.com/vpc/docs/private-service-connect#supported-apis).
               
               For Private Service Connect forwarding rules that forward traffic to managed services, the target must be a service attachment.
               
               
               - - -
        :param pulumi.Input[bool] allow_psc_global_access: This is used in PSC consumer ForwardingRule to control whether the PSC endpoint can be accessed from another region.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when
               you create the resource.
        :param pulumi.Input[str] ip_address: IP address for which this forwarding rule accepts traffic. When a client
               sends traffic to this IP address, the forwarding rule directs the traffic
               to the referenced `target`.
               While creating a forwarding rule, specifying an `IPAddress` is
               required under the following circumstances:
               * When the `target` is set to `targetGrpcProxy` and
               `validateForProxyless` is set to `true`, the
               `IPAddress` should be set to `0.0.0.0`.
               * When the `target` is a Private Service Connect Google APIs
               bundle, you must specify an `IPAddress`.
               
               Otherwise, you can optionally specify an IP address that references an
               existing static (reserved) IP address resource. When omitted, Google Cloud
               assigns an ephemeral IP address.
               Use one of the following formats to specify an IP address while creating a
               forwarding rule:
               * IP address number, as in `100.1.2.3`
               * IPv6 address range, as in `2600:1234::/96`
               * Full resource URL, as in
               `https://www.googleapis.com/compute/v1/projects/project_id/regions/region/addresses/address-name`
               * Partial URL or by name, as in:
               * `projects/project_id/regions/region/addresses/address-name`
               * `regions/region/addresses/address-name`
               * `global/addresses/address-name`
               * `address-name`
               
               The forwarding rule's `target`,
               and in most cases, also the `loadBalancingScheme`, determine the
               type of IP address that you can use. For detailed information, see
               [IP address
               specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
               When reading an `IPAddress`, the API always returns the IP
               address number.
        :param pulumi.Input[str] ip_protocol: The IP protocol to which this rule applies.
               For protocol forwarding, valid
               options are `TCP`, `UDP`, `ESP`,
               `AH`, `SCTP`, `ICMP` and
               `L3_DEFAULT`.
               The valid IP protocols are different for different load balancing products
               as described in [Load balancing
               features](https://cloud.google.com/load-balancing/docs/features#protocols_from_the_load_balancer_to_the_backends).
               Possible values are: `TCP`, `UDP`, `ESP`, `AH`, `SCTP`, `ICMP`.
        :param pulumi.Input[str] ip_version: The IP Version that will be used by this global forwarding rule.
               Possible values are: `IPV4`, `IPV6`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels to apply to this forwarding rule.  A list of key->value pairs.
        :param pulumi.Input[str] load_balancing_scheme: Specifies the forwarding rule type.
               For more information about forwarding rules, refer to
               [Forwarding rule concepts](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts).
               Default value is `EXTERNAL`.
               Possible values are: `EXTERNAL`, `EXTERNAL_MANAGED`, `INTERNAL_SELF_MANAGED`.
        :param pulumi.Input[Sequence[pulumi.Input['GlobalForwardingRuleMetadataFilterArgs']]] metadata_filters: Opaque filter criteria used by Loadbalancer to restrict routing
               configuration to a limited set xDS compliant clients. In their xDS
               requests to Loadbalancer, xDS clients present node metadata. If a
               match takes place, the relevant routing configuration is made available
               to those proxies.
               For each metadataFilter in this list, if its filterMatchCriteria is set
               to MATCH_ANY, at least one of the filterLabels must match the
               corresponding label provided in the metadata. If its filterMatchCriteria
               is set to MATCH_ALL, then all of its filterLabels must match with
               corresponding labels in the provided metadata.
               metadataFilters specified here can be overridden by those specified in
               the UrlMap that this ForwardingRule references.
               metadataFilters only applies to Loadbalancers that have their
               loadBalancingScheme set to INTERNAL_SELF_MANAGED.
               Structure is documented below.
        :param pulumi.Input[str] name: Name of the resource; provided by the client when the resource is created.
               The name must be 1-63 characters long, and comply with
               [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
               Specifically, the name must be 1-63 characters long and match the regular
               expression `a-z?` which means the first
               character must be a lowercase letter, and all following characters must
               be a dash, lowercase letter, or digit, except the last character, which
               cannot be a dash.
               For Private Service Connect forwarding rules that forward traffic to Google
               APIs, the forwarding rule name must be a 1-20 characters string with
               lowercase letters and numbers and must start with a letter.
        :param pulumi.Input[str] network: This field is not used for external load balancing.
               For Internal TCP/UDP Load Balancing, this field identifies the network that
               the load balanced IP should belong to for this Forwarding Rule.
               If the subnetwork is specified, the network of the subnetwork will be used.
               If neither subnetwork nor this field is specified, the default network will
               be used.
               For Private Service Connect forwarding rules that forward traffic to Google
               APIs, a network must be provided.
        :param pulumi.Input[bool] no_automate_dns_zone: This is used in PSC consumer ForwardingRule to control whether it should try to auto-generate a DNS zone or not. Non-PSC forwarding rules do not use this field.
        :param pulumi.Input[str] port_range: This field can only be used:
               * If `IPProtocol` is one of TCP, UDP, or SCTP.
               * By backend service-based network load balancers, target pool-based
               network load balancers, internal proxy load balancers, external proxy load
               balancers, Traffic Director, external protocol forwarding, and Classic VPN.
               Some products have restrictions on what ports can be used. See
               [port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#port_specifications)
               for details.
               
               * TargetHttpProxy: 80, 8080
               * TargetHttpsProxy: 443
               * TargetTcpProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995,
               1883, 5222
               * TargetSslProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995,
               1883, 5222
               * TargetVpnGateway: 500, 4500
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_ip_ranges: If not empty, this Forwarding Rule will only forward the traffic when the source IP address matches one of the IP addresses or CIDR ranges set here. Note that a Forwarding Rule can only have up to 64 source IP ranges, and this field can only be used with a regional Forwarding Rule whose scheme is EXTERNAL. Each sourceIpRange entry should be either an IP address (for example, 1.2.3.4) or a CIDR range (for example, 1.2.3.0/24).
        """
        pulumi.set(__self__, "target", target)
        if allow_psc_global_access is not None:
            pulumi.set(__self__, "allow_psc_global_access", allow_psc_global_access)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ip_protocol is not None:
            pulumi.set(__self__, "ip_protocol", ip_protocol)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if load_balancing_scheme is not None:
            pulumi.set(__self__, "load_balancing_scheme", load_balancing_scheme)
        if metadata_filters is not None:
            pulumi.set(__self__, "metadata_filters", metadata_filters)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if no_automate_dns_zone is not None:
            pulumi.set(__self__, "no_automate_dns_zone", no_automate_dns_zone)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if source_ip_ranges is not None:
            pulumi.set(__self__, "source_ip_ranges", source_ip_ranges)

    @property
    @pulumi.getter
    def target(self) -> pulumi.Input[str]:
        """
        The URL of the target resource to receive the matched traffic.  For
        regional forwarding rules, this target must be in the same region as the
        forwarding rule. For global forwarding rules, this target must be a global
        load balancing resource.
        The forwarded traffic must be of a type appropriate to the target object.
        *  For load balancers, see the "Target" column in [Port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
        *  For Private Service Connect forwarding rules that forward traffic to Google APIs, provide the name of a supported Google API bundle:
        *  `vpc-sc` - [ APIs that support VPC Service Controls](https://cloud.google.com/vpc-service-controls/docs/supported-products).
        *  `all-apis` - [All supported Google APIs](https://cloud.google.com/vpc/docs/private-service-connect#supported-apis).

        For Private Service Connect forwarding rules that forward traffic to managed services, the target must be a service attachment.


        - - -
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: pulumi.Input[str]):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter(name="allowPscGlobalAccess")
    def allow_psc_global_access(self) -> Optional[pulumi.Input[bool]]:
        """
        This is used in PSC consumer ForwardingRule to control whether the PSC endpoint can be accessed from another region.
        """
        return pulumi.get(self, "allow_psc_global_access")

    @allow_psc_global_access.setter
    def allow_psc_global_access(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_psc_global_access", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource. Provide this property when
        you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        IP address for which this forwarding rule accepts traffic. When a client
        sends traffic to this IP address, the forwarding rule directs the traffic
        to the referenced `target`.
        While creating a forwarding rule, specifying an `IPAddress` is
        required under the following circumstances:
        * When the `target` is set to `targetGrpcProxy` and
        `validateForProxyless` is set to `true`, the
        `IPAddress` should be set to `0.0.0.0`.
        * When the `target` is a Private Service Connect Google APIs
        bundle, you must specify an `IPAddress`.

        Otherwise, you can optionally specify an IP address that references an
        existing static (reserved) IP address resource. When omitted, Google Cloud
        assigns an ephemeral IP address.
        Use one of the following formats to specify an IP address while creating a
        forwarding rule:
        * IP address number, as in `100.1.2.3`
        * IPv6 address range, as in `2600:1234::/96`
        * Full resource URL, as in
        `https://www.googleapis.com/compute/v1/projects/project_id/regions/region/addresses/address-name`
        * Partial URL or by name, as in:
        * `projects/project_id/regions/region/addresses/address-name`
        * `regions/region/addresses/address-name`
        * `global/addresses/address-name`
        * `address-name`

        The forwarding rule's `target`,
        and in most cases, also the `loadBalancingScheme`, determine the
        type of IP address that you can use. For detailed information, see
        [IP address
        specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
        When reading an `IPAddress`, the API always returns the IP
        address number.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The IP protocol to which this rule applies.
        For protocol forwarding, valid
        options are `TCP`, `UDP`, `ESP`,
        `AH`, `SCTP`, `ICMP` and
        `L3_DEFAULT`.
        The valid IP protocols are different for different load balancing products
        as described in [Load balancing
        features](https://cloud.google.com/load-balancing/docs/features#protocols_from_the_load_balancer_to_the_backends).
        Possible values are: `TCP`, `UDP`, `ESP`, `AH`, `SCTP`, `ICMP`.
        """
        return pulumi.get(self, "ip_protocol")

    @ip_protocol.setter
    def ip_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_protocol", value)

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[str]]:
        """
        The IP Version that will be used by this global forwarding rule.
        Possible values are: `IPV4`, `IPV6`.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_version", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels to apply to this forwarding rule.  A list of key->value pairs.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="loadBalancingScheme")
    def load_balancing_scheme(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the forwarding rule type.
        For more information about forwarding rules, refer to
        [Forwarding rule concepts](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts).
        Default value is `EXTERNAL`.
        Possible values are: `EXTERNAL`, `EXTERNAL_MANAGED`, `INTERNAL_SELF_MANAGED`.
        """
        return pulumi.get(self, "load_balancing_scheme")

    @load_balancing_scheme.setter
    def load_balancing_scheme(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancing_scheme", value)

    @property
    @pulumi.getter(name="metadataFilters")
    def metadata_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GlobalForwardingRuleMetadataFilterArgs']]]]:
        """
        Opaque filter criteria used by Loadbalancer to restrict routing
        configuration to a limited set xDS compliant clients. In their xDS
        requests to Loadbalancer, xDS clients present node metadata. If a
        match takes place, the relevant routing configuration is made available
        to those proxies.
        For each metadataFilter in this list, if its filterMatchCriteria is set
        to MATCH_ANY, at least one of the filterLabels must match the
        corresponding label provided in the metadata. If its filterMatchCriteria
        is set to MATCH_ALL, then all of its filterLabels must match with
        corresponding labels in the provided metadata.
        metadataFilters specified here can be overridden by those specified in
        the UrlMap that this ForwardingRule references.
        metadataFilters only applies to Loadbalancers that have their
        loadBalancingScheme set to INTERNAL_SELF_MANAGED.
        Structure is documented below.
        """
        return pulumi.get(self, "metadata_filters")

    @metadata_filters.setter
    def metadata_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GlobalForwardingRuleMetadataFilterArgs']]]]):
        pulumi.set(self, "metadata_filters", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource; provided by the client when the resource is created.
        The name must be 1-63 characters long, and comply with
        [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
        Specifically, the name must be 1-63 characters long and match the regular
        expression `a-z?` which means the first
        character must be a lowercase letter, and all following characters must
        be a dash, lowercase letter, or digit, except the last character, which
        cannot be a dash.
        For Private Service Connect forwarding rules that forward traffic to Google
        APIs, the forwarding rule name must be a 1-20 characters string with
        lowercase letters and numbers and must start with a letter.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        This field is not used for external load balancing.
        For Internal TCP/UDP Load Balancing, this field identifies the network that
        the load balanced IP should belong to for this Forwarding Rule.
        If the subnetwork is specified, the network of the subnetwork will be used.
        If neither subnetwork nor this field is specified, the default network will
        be used.
        For Private Service Connect forwarding rules that forward traffic to Google
        APIs, a network must be provided.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="noAutomateDnsZone")
    def no_automate_dns_zone(self) -> Optional[pulumi.Input[bool]]:
        """
        This is used in PSC consumer ForwardingRule to control whether it should try to auto-generate a DNS zone or not. Non-PSC forwarding rules do not use this field.
        """
        return pulumi.get(self, "no_automate_dns_zone")

    @no_automate_dns_zone.setter
    def no_automate_dns_zone(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "no_automate_dns_zone", value)

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[pulumi.Input[str]]:
        """
        This field can only be used:
        * If `IPProtocol` is one of TCP, UDP, or SCTP.
        * By backend service-based network load balancers, target pool-based
        network load balancers, internal proxy load balancers, external proxy load
        balancers, Traffic Director, external protocol forwarding, and Classic VPN.
        Some products have restrictions on what ports can be used. See
        [port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#port_specifications)
        for details.

        * TargetHttpProxy: 80, 8080
        * TargetHttpsProxy: 443
        * TargetTcpProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995,
        1883, 5222
        * TargetSslProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995,
        1883, 5222
        * TargetVpnGateway: 500, 4500
        """
        return pulumi.get(self, "port_range")

    @port_range.setter
    def port_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_range", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="sourceIpRanges")
    def source_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        If not empty, this Forwarding Rule will only forward the traffic when the source IP address matches one of the IP addresses or CIDR ranges set here. Note that a Forwarding Rule can only have up to 64 source IP ranges, and this field can only be used with a regional Forwarding Rule whose scheme is EXTERNAL. Each sourceIpRange entry should be either an IP address (for example, 1.2.3.4) or a CIDR range (for example, 1.2.3.0/24).
        """
        return pulumi.get(self, "source_ip_ranges")

    @source_ip_ranges.setter
    def source_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "source_ip_ranges", value)


@pulumi.input_type
class _GlobalForwardingRuleState:
    def __init__(__self__, *,
                 allow_psc_global_access: Optional[pulumi.Input[bool]] = None,
                 base_forwarding_rule: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 ip_protocol: Optional[pulumi.Input[str]] = None,
                 ip_version: Optional[pulumi.Input[str]] = None,
                 label_fingerprint: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 load_balancing_scheme: Optional[pulumi.Input[str]] = None,
                 metadata_filters: Optional[pulumi.Input[Sequence[pulumi.Input['GlobalForwardingRuleMetadataFilterArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 no_automate_dns_zone: Optional[pulumi.Input[bool]] = None,
                 port_range: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 psc_connection_id: Optional[pulumi.Input[str]] = None,
                 psc_connection_status: Optional[pulumi.Input[str]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 source_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 target: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering GlobalForwardingRule resources.
        :param pulumi.Input[bool] allow_psc_global_access: This is used in PSC consumer ForwardingRule to control whether the PSC endpoint can be accessed from another region.
        :param pulumi.Input[str] base_forwarding_rule: [Output Only] The URL for the corresponding base Forwarding Rule. By base Forwarding Rule, we mean the Forwarding Rule that has the same IP address, protocol, and port settings with the current Forwarding Rule, but without sourceIPRanges specified. Always empty if the current Forwarding Rule does not have sourceIPRanges specified.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when
               you create the resource.
        :param pulumi.Input[str] ip_address: IP address for which this forwarding rule accepts traffic. When a client
               sends traffic to this IP address, the forwarding rule directs the traffic
               to the referenced `target`.
               While creating a forwarding rule, specifying an `IPAddress` is
               required under the following circumstances:
               * When the `target` is set to `targetGrpcProxy` and
               `validateForProxyless` is set to `true`, the
               `IPAddress` should be set to `0.0.0.0`.
               * When the `target` is a Private Service Connect Google APIs
               bundle, you must specify an `IPAddress`.
               
               Otherwise, you can optionally specify an IP address that references an
               existing static (reserved) IP address resource. When omitted, Google Cloud
               assigns an ephemeral IP address.
               Use one of the following formats to specify an IP address while creating a
               forwarding rule:
               * IP address number, as in `100.1.2.3`
               * IPv6 address range, as in `2600:1234::/96`
               * Full resource URL, as in
               `https://www.googleapis.com/compute/v1/projects/project_id/regions/region/addresses/address-name`
               * Partial URL or by name, as in:
               * `projects/project_id/regions/region/addresses/address-name`
               * `regions/region/addresses/address-name`
               * `global/addresses/address-name`
               * `address-name`
               
               The forwarding rule's `target`,
               and in most cases, also the `loadBalancingScheme`, determine the
               type of IP address that you can use. For detailed information, see
               [IP address
               specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
               When reading an `IPAddress`, the API always returns the IP
               address number.
        :param pulumi.Input[str] ip_protocol: The IP protocol to which this rule applies.
               For protocol forwarding, valid
               options are `TCP`, `UDP`, `ESP`,
               `AH`, `SCTP`, `ICMP` and
               `L3_DEFAULT`.
               The valid IP protocols are different for different load balancing products
               as described in [Load balancing
               features](https://cloud.google.com/load-balancing/docs/features#protocols_from_the_load_balancer_to_the_backends).
               Possible values are: `TCP`, `UDP`, `ESP`, `AH`, `SCTP`, `ICMP`.
        :param pulumi.Input[str] ip_version: The IP Version that will be used by this global forwarding rule.
               Possible values are: `IPV4`, `IPV6`.
        :param pulumi.Input[str] label_fingerprint: The fingerprint used for optimistic locking of this resource.  Used
               internally during updates.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels to apply to this forwarding rule.  A list of key->value pairs.
        :param pulumi.Input[str] load_balancing_scheme: Specifies the forwarding rule type.
               For more information about forwarding rules, refer to
               [Forwarding rule concepts](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts).
               Default value is `EXTERNAL`.
               Possible values are: `EXTERNAL`, `EXTERNAL_MANAGED`, `INTERNAL_SELF_MANAGED`.
        :param pulumi.Input[Sequence[pulumi.Input['GlobalForwardingRuleMetadataFilterArgs']]] metadata_filters: Opaque filter criteria used by Loadbalancer to restrict routing
               configuration to a limited set xDS compliant clients. In their xDS
               requests to Loadbalancer, xDS clients present node metadata. If a
               match takes place, the relevant routing configuration is made available
               to those proxies.
               For each metadataFilter in this list, if its filterMatchCriteria is set
               to MATCH_ANY, at least one of the filterLabels must match the
               corresponding label provided in the metadata. If its filterMatchCriteria
               is set to MATCH_ALL, then all of its filterLabels must match with
               corresponding labels in the provided metadata.
               metadataFilters specified here can be overridden by those specified in
               the UrlMap that this ForwardingRule references.
               metadataFilters only applies to Loadbalancers that have their
               loadBalancingScheme set to INTERNAL_SELF_MANAGED.
               Structure is documented below.
        :param pulumi.Input[str] name: Name of the resource; provided by the client when the resource is created.
               The name must be 1-63 characters long, and comply with
               [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
               Specifically, the name must be 1-63 characters long and match the regular
               expression `a-z?` which means the first
               character must be a lowercase letter, and all following characters must
               be a dash, lowercase letter, or digit, except the last character, which
               cannot be a dash.
               For Private Service Connect forwarding rules that forward traffic to Google
               APIs, the forwarding rule name must be a 1-20 characters string with
               lowercase letters and numbers and must start with a letter.
        :param pulumi.Input[str] network: This field is not used for external load balancing.
               For Internal TCP/UDP Load Balancing, this field identifies the network that
               the load balanced IP should belong to for this Forwarding Rule.
               If the subnetwork is specified, the network of the subnetwork will be used.
               If neither subnetwork nor this field is specified, the default network will
               be used.
               For Private Service Connect forwarding rules that forward traffic to Google
               APIs, a network must be provided.
        :param pulumi.Input[bool] no_automate_dns_zone: This is used in PSC consumer ForwardingRule to control whether it should try to auto-generate a DNS zone or not. Non-PSC forwarding rules do not use this field.
        :param pulumi.Input[str] port_range: This field can only be used:
               * If `IPProtocol` is one of TCP, UDP, or SCTP.
               * By backend service-based network load balancers, target pool-based
               network load balancers, internal proxy load balancers, external proxy load
               balancers, Traffic Director, external protocol forwarding, and Classic VPN.
               Some products have restrictions on what ports can be used. See
               [port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#port_specifications)
               for details.
               
               * TargetHttpProxy: 80, 8080
               * TargetHttpsProxy: 443
               * TargetTcpProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995,
               1883, 5222
               * TargetSslProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995,
               1883, 5222
               * TargetVpnGateway: 500, 4500
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] psc_connection_id: The PSC connection id of the PSC Forwarding Rule.
        :param pulumi.Input[str] psc_connection_status: The PSC connection status of the PSC Forwarding Rule. Possible values: `STATUS_UNSPECIFIED`, `PENDING`, `ACCEPTED`, `REJECTED`, `CLOSED`
        :param pulumi.Input[str] self_link: The URI of the created resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_ip_ranges: If not empty, this Forwarding Rule will only forward the traffic when the source IP address matches one of the IP addresses or CIDR ranges set here. Note that a Forwarding Rule can only have up to 64 source IP ranges, and this field can only be used with a regional Forwarding Rule whose scheme is EXTERNAL. Each sourceIpRange entry should be either an IP address (for example, 1.2.3.4) or a CIDR range (for example, 1.2.3.0/24).
        :param pulumi.Input[str] target: The URL of the target resource to receive the matched traffic.  For
               regional forwarding rules, this target must be in the same region as the
               forwarding rule. For global forwarding rules, this target must be a global
               load balancing resource.
               The forwarded traffic must be of a type appropriate to the target object.
               *  For load balancers, see the "Target" column in [Port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
               *  For Private Service Connect forwarding rules that forward traffic to Google APIs, provide the name of a supported Google API bundle:
               *  `vpc-sc` - [ APIs that support VPC Service Controls](https://cloud.google.com/vpc-service-controls/docs/supported-products).
               *  `all-apis` - [All supported Google APIs](https://cloud.google.com/vpc/docs/private-service-connect#supported-apis).
               
               For Private Service Connect forwarding rules that forward traffic to managed services, the target must be a service attachment.
               
               
               - - -
        """
        if allow_psc_global_access is not None:
            pulumi.set(__self__, "allow_psc_global_access", allow_psc_global_access)
        if base_forwarding_rule is not None:
            pulumi.set(__self__, "base_forwarding_rule", base_forwarding_rule)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ip_protocol is not None:
            pulumi.set(__self__, "ip_protocol", ip_protocol)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if label_fingerprint is not None:
            pulumi.set(__self__, "label_fingerprint", label_fingerprint)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if load_balancing_scheme is not None:
            pulumi.set(__self__, "load_balancing_scheme", load_balancing_scheme)
        if metadata_filters is not None:
            pulumi.set(__self__, "metadata_filters", metadata_filters)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if no_automate_dns_zone is not None:
            pulumi.set(__self__, "no_automate_dns_zone", no_automate_dns_zone)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if psc_connection_id is not None:
            pulumi.set(__self__, "psc_connection_id", psc_connection_id)
        if psc_connection_status is not None:
            pulumi.set(__self__, "psc_connection_status", psc_connection_status)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if source_ip_ranges is not None:
            pulumi.set(__self__, "source_ip_ranges", source_ip_ranges)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter(name="allowPscGlobalAccess")
    def allow_psc_global_access(self) -> Optional[pulumi.Input[bool]]:
        """
        This is used in PSC consumer ForwardingRule to control whether the PSC endpoint can be accessed from another region.
        """
        return pulumi.get(self, "allow_psc_global_access")

    @allow_psc_global_access.setter
    def allow_psc_global_access(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_psc_global_access", value)

    @property
    @pulumi.getter(name="baseForwardingRule")
    def base_forwarding_rule(self) -> Optional[pulumi.Input[str]]:
        """
        [Output Only] The URL for the corresponding base Forwarding Rule. By base Forwarding Rule, we mean the Forwarding Rule that has the same IP address, protocol, and port settings with the current Forwarding Rule, but without sourceIPRanges specified. Always empty if the current Forwarding Rule does not have sourceIPRanges specified.
        """
        return pulumi.get(self, "base_forwarding_rule")

    @base_forwarding_rule.setter
    def base_forwarding_rule(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base_forwarding_rule", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource. Provide this property when
        you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        IP address for which this forwarding rule accepts traffic. When a client
        sends traffic to this IP address, the forwarding rule directs the traffic
        to the referenced `target`.
        While creating a forwarding rule, specifying an `IPAddress` is
        required under the following circumstances:
        * When the `target` is set to `targetGrpcProxy` and
        `validateForProxyless` is set to `true`, the
        `IPAddress` should be set to `0.0.0.0`.
        * When the `target` is a Private Service Connect Google APIs
        bundle, you must specify an `IPAddress`.

        Otherwise, you can optionally specify an IP address that references an
        existing static (reserved) IP address resource. When omitted, Google Cloud
        assigns an ephemeral IP address.
        Use one of the following formats to specify an IP address while creating a
        forwarding rule:
        * IP address number, as in `100.1.2.3`
        * IPv6 address range, as in `2600:1234::/96`
        * Full resource URL, as in
        `https://www.googleapis.com/compute/v1/projects/project_id/regions/region/addresses/address-name`
        * Partial URL or by name, as in:
        * `projects/project_id/regions/region/addresses/address-name`
        * `regions/region/addresses/address-name`
        * `global/addresses/address-name`
        * `address-name`

        The forwarding rule's `target`,
        and in most cases, also the `loadBalancingScheme`, determine the
        type of IP address that you can use. For detailed information, see
        [IP address
        specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
        When reading an `IPAddress`, the API always returns the IP
        address number.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The IP protocol to which this rule applies.
        For protocol forwarding, valid
        options are `TCP`, `UDP`, `ESP`,
        `AH`, `SCTP`, `ICMP` and
        `L3_DEFAULT`.
        The valid IP protocols are different for different load balancing products
        as described in [Load balancing
        features](https://cloud.google.com/load-balancing/docs/features#protocols_from_the_load_balancer_to_the_backends).
        Possible values are: `TCP`, `UDP`, `ESP`, `AH`, `SCTP`, `ICMP`.
        """
        return pulumi.get(self, "ip_protocol")

    @ip_protocol.setter
    def ip_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_protocol", value)

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[str]]:
        """
        The IP Version that will be used by this global forwarding rule.
        Possible values are: `IPV4`, `IPV6`.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_version", value)

    @property
    @pulumi.getter(name="labelFingerprint")
    def label_fingerprint(self) -> Optional[pulumi.Input[str]]:
        """
        The fingerprint used for optimistic locking of this resource.  Used
        internally during updates.
        """
        return pulumi.get(self, "label_fingerprint")

    @label_fingerprint.setter
    def label_fingerprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label_fingerprint", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels to apply to this forwarding rule.  A list of key->value pairs.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="loadBalancingScheme")
    def load_balancing_scheme(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the forwarding rule type.
        For more information about forwarding rules, refer to
        [Forwarding rule concepts](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts).
        Default value is `EXTERNAL`.
        Possible values are: `EXTERNAL`, `EXTERNAL_MANAGED`, `INTERNAL_SELF_MANAGED`.
        """
        return pulumi.get(self, "load_balancing_scheme")

    @load_balancing_scheme.setter
    def load_balancing_scheme(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancing_scheme", value)

    @property
    @pulumi.getter(name="metadataFilters")
    def metadata_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GlobalForwardingRuleMetadataFilterArgs']]]]:
        """
        Opaque filter criteria used by Loadbalancer to restrict routing
        configuration to a limited set xDS compliant clients. In their xDS
        requests to Loadbalancer, xDS clients present node metadata. If a
        match takes place, the relevant routing configuration is made available
        to those proxies.
        For each metadataFilter in this list, if its filterMatchCriteria is set
        to MATCH_ANY, at least one of the filterLabels must match the
        corresponding label provided in the metadata. If its filterMatchCriteria
        is set to MATCH_ALL, then all of its filterLabels must match with
        corresponding labels in the provided metadata.
        metadataFilters specified here can be overridden by those specified in
        the UrlMap that this ForwardingRule references.
        metadataFilters only applies to Loadbalancers that have their
        loadBalancingScheme set to INTERNAL_SELF_MANAGED.
        Structure is documented below.
        """
        return pulumi.get(self, "metadata_filters")

    @metadata_filters.setter
    def metadata_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GlobalForwardingRuleMetadataFilterArgs']]]]):
        pulumi.set(self, "metadata_filters", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource; provided by the client when the resource is created.
        The name must be 1-63 characters long, and comply with
        [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
        Specifically, the name must be 1-63 characters long and match the regular
        expression `a-z?` which means the first
        character must be a lowercase letter, and all following characters must
        be a dash, lowercase letter, or digit, except the last character, which
        cannot be a dash.
        For Private Service Connect forwarding rules that forward traffic to Google
        APIs, the forwarding rule name must be a 1-20 characters string with
        lowercase letters and numbers and must start with a letter.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        This field is not used for external load balancing.
        For Internal TCP/UDP Load Balancing, this field identifies the network that
        the load balanced IP should belong to for this Forwarding Rule.
        If the subnetwork is specified, the network of the subnetwork will be used.
        If neither subnetwork nor this field is specified, the default network will
        be used.
        For Private Service Connect forwarding rules that forward traffic to Google
        APIs, a network must be provided.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="noAutomateDnsZone")
    def no_automate_dns_zone(self) -> Optional[pulumi.Input[bool]]:
        """
        This is used in PSC consumer ForwardingRule to control whether it should try to auto-generate a DNS zone or not. Non-PSC forwarding rules do not use this field.
        """
        return pulumi.get(self, "no_automate_dns_zone")

    @no_automate_dns_zone.setter
    def no_automate_dns_zone(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "no_automate_dns_zone", value)

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[pulumi.Input[str]]:
        """
        This field can only be used:
        * If `IPProtocol` is one of TCP, UDP, or SCTP.
        * By backend service-based network load balancers, target pool-based
        network load balancers, internal proxy load balancers, external proxy load
        balancers, Traffic Director, external protocol forwarding, and Classic VPN.
        Some products have restrictions on what ports can be used. See
        [port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#port_specifications)
        for details.

        * TargetHttpProxy: 80, 8080
        * TargetHttpsProxy: 443
        * TargetTcpProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995,
        1883, 5222
        * TargetSslProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995,
        1883, 5222
        * TargetVpnGateway: 500, 4500
        """
        return pulumi.get(self, "port_range")

    @port_range.setter
    def port_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_range", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pscConnectionId")
    def psc_connection_id(self) -> Optional[pulumi.Input[str]]:
        """
        The PSC connection id of the PSC Forwarding Rule.
        """
        return pulumi.get(self, "psc_connection_id")

    @psc_connection_id.setter
    def psc_connection_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "psc_connection_id", value)

    @property
    @pulumi.getter(name="pscConnectionStatus")
    def psc_connection_status(self) -> Optional[pulumi.Input[str]]:
        """
        The PSC connection status of the PSC Forwarding Rule. Possible values: `STATUS_UNSPECIFIED`, `PENDING`, `ACCEPTED`, `REJECTED`, `CLOSED`
        """
        return pulumi.get(self, "psc_connection_status")

    @psc_connection_status.setter
    def psc_connection_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "psc_connection_status", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter(name="sourceIpRanges")
    def source_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        If not empty, this Forwarding Rule will only forward the traffic when the source IP address matches one of the IP addresses or CIDR ranges set here. Note that a Forwarding Rule can only have up to 64 source IP ranges, and this field can only be used with a regional Forwarding Rule whose scheme is EXTERNAL. Each sourceIpRange entry should be either an IP address (for example, 1.2.3.4) or a CIDR range (for example, 1.2.3.0/24).
        """
        return pulumi.get(self, "source_ip_ranges")

    @source_ip_ranges.setter
    def source_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "source_ip_ranges", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of the target resource to receive the matched traffic.  For
        regional forwarding rules, this target must be in the same region as the
        forwarding rule. For global forwarding rules, this target must be a global
        load balancing resource.
        The forwarded traffic must be of a type appropriate to the target object.
        *  For load balancers, see the "Target" column in [Port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
        *  For Private Service Connect forwarding rules that forward traffic to Google APIs, provide the name of a supported Google API bundle:
        *  `vpc-sc` - [ APIs that support VPC Service Controls](https://cloud.google.com/vpc-service-controls/docs/supported-products).
        *  `all-apis` - [All supported Google APIs](https://cloud.google.com/vpc/docs/private-service-connect#supported-apis).

        For Private Service Connect forwarding rules that forward traffic to managed services, the target must be a service attachment.


        - - -
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target", value)


class GlobalForwardingRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_psc_global_access: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 ip_protocol: Optional[pulumi.Input[str]] = None,
                 ip_version: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 load_balancing_scheme: Optional[pulumi.Input[str]] = None,
                 metadata_filters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GlobalForwardingRuleMetadataFilterArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 no_automate_dns_zone: Optional[pulumi.Input[bool]] = None,
                 port_range: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 source_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 target: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Represents a GlobalForwardingRule resource. Global forwarding rules are
        used to forward traffic to the correct load balancer for HTTP load
        balancing. Global forwarding rules can only be used for HTTP load
        balancing.

        For more information, see
        https://cloud.google.com/compute/docs/load-balancing/http/

        ## Example Usage
        ### Global Forwarding Rule External Managed

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_backend_service = gcp.compute.BackendService("defaultBackendService",
            port_name="http",
            protocol="HTTP",
            timeout_sec=10,
            load_balancing_scheme="EXTERNAL_MANAGED")
        default_url_map = gcp.compute.URLMap("defaultURLMap",
            description="a description",
            default_service=default_backend_service.id,
            host_rules=[gcp.compute.URLMapHostRuleArgs(
                hosts=["mysite.com"],
                path_matcher="allpaths",
            )],
            path_matchers=[gcp.compute.URLMapPathMatcherArgs(
                name="allpaths",
                default_service=default_backend_service.id,
                path_rules=[gcp.compute.URLMapPathMatcherPathRuleArgs(
                    paths=["/*"],
                    service=default_backend_service.id,
                )],
            )])
        default_target_http_proxy = gcp.compute.TargetHttpProxy("defaultTargetHttpProxy",
            description="a description",
            url_map=default_url_map.id)
        default_global_forwarding_rule = gcp.compute.GlobalForwardingRule("defaultGlobalForwardingRule",
            target=default_target_http_proxy.id,
            port_range="80",
            load_balancing_scheme="EXTERNAL_MANAGED")
        ```
        ### Private Service Connect Google Apis

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network = gcp.compute.Network("network",
            project="my-project-name",
            auto_create_subnetworks=False,
            opts=pulumi.ResourceOptions(provider=google_beta))
        vpc_subnetwork = gcp.compute.Subnetwork("vpcSubnetwork",
            project=network.project,
            ip_cidr_range="10.2.0.0/16",
            region="us-central1",
            network=network.id,
            private_ip_google_access=True,
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_global_address = gcp.compute.GlobalAddress("defaultGlobalAddress",
            project=network.project,
            address_type="INTERNAL",
            purpose="PRIVATE_SERVICE_CONNECT",
            network=network.id,
            address="100.100.100.106",
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_global_forwarding_rule = gcp.compute.GlobalForwardingRule("defaultGlobalForwardingRule",
            project=network.project,
            target="all-apis",
            network=network.id,
            ip_address=default_global_address.id,
            load_balancing_scheme="",
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Private Service Connect Google Apis No Automate Dns

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network = gcp.compute.Network("network",
            project="my-project-name",
            auto_create_subnetworks=False,
            opts=pulumi.ResourceOptions(provider=google_beta))
        vpc_subnetwork = gcp.compute.Subnetwork("vpcSubnetwork",
            project=network.project,
            ip_cidr_range="10.2.0.0/16",
            region="us-central1",
            network=network.id,
            private_ip_google_access=True,
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_global_address = gcp.compute.GlobalAddress("defaultGlobalAddress",
            project=network.project,
            address_type="INTERNAL",
            purpose="PRIVATE_SERVICE_CONNECT",
            network=network.id,
            address="100.100.100.106",
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_global_forwarding_rule = gcp.compute.GlobalForwardingRule("defaultGlobalForwardingRule",
            project=network.project,
            target="all-apis",
            network=network.id,
            ip_address=default_global_address.id,
            load_balancing_scheme="",
            no_automate_dns_zone=False,
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```

        ## Import

        GlobalForwardingRule can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:compute/globalForwardingRule:GlobalForwardingRule default projects/{{project}}/global/forwardingRules/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/globalForwardingRule:GlobalForwardingRule default {{project}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/globalForwardingRule:GlobalForwardingRule default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] allow_psc_global_access: This is used in PSC consumer ForwardingRule to control whether the PSC endpoint can be accessed from another region.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when
               you create the resource.
        :param pulumi.Input[str] ip_address: IP address for which this forwarding rule accepts traffic. When a client
               sends traffic to this IP address, the forwarding rule directs the traffic
               to the referenced `target`.
               While creating a forwarding rule, specifying an `IPAddress` is
               required under the following circumstances:
               * When the `target` is set to `targetGrpcProxy` and
               `validateForProxyless` is set to `true`, the
               `IPAddress` should be set to `0.0.0.0`.
               * When the `target` is a Private Service Connect Google APIs
               bundle, you must specify an `IPAddress`.
               
               Otherwise, you can optionally specify an IP address that references an
               existing static (reserved) IP address resource. When omitted, Google Cloud
               assigns an ephemeral IP address.
               Use one of the following formats to specify an IP address while creating a
               forwarding rule:
               * IP address number, as in `100.1.2.3`
               * IPv6 address range, as in `2600:1234::/96`
               * Full resource URL, as in
               `https://www.googleapis.com/compute/v1/projects/project_id/regions/region/addresses/address-name`
               * Partial URL or by name, as in:
               * `projects/project_id/regions/region/addresses/address-name`
               * `regions/region/addresses/address-name`
               * `global/addresses/address-name`
               * `address-name`
               
               The forwarding rule's `target`,
               and in most cases, also the `loadBalancingScheme`, determine the
               type of IP address that you can use. For detailed information, see
               [IP address
               specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
               When reading an `IPAddress`, the API always returns the IP
               address number.
        :param pulumi.Input[str] ip_protocol: The IP protocol to which this rule applies.
               For protocol forwarding, valid
               options are `TCP`, `UDP`, `ESP`,
               `AH`, `SCTP`, `ICMP` and
               `L3_DEFAULT`.
               The valid IP protocols are different for different load balancing products
               as described in [Load balancing
               features](https://cloud.google.com/load-balancing/docs/features#protocols_from_the_load_balancer_to_the_backends).
               Possible values are: `TCP`, `UDP`, `ESP`, `AH`, `SCTP`, `ICMP`.
        :param pulumi.Input[str] ip_version: The IP Version that will be used by this global forwarding rule.
               Possible values are: `IPV4`, `IPV6`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels to apply to this forwarding rule.  A list of key->value pairs.
        :param pulumi.Input[str] load_balancing_scheme: Specifies the forwarding rule type.
               For more information about forwarding rules, refer to
               [Forwarding rule concepts](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts).
               Default value is `EXTERNAL`.
               Possible values are: `EXTERNAL`, `EXTERNAL_MANAGED`, `INTERNAL_SELF_MANAGED`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GlobalForwardingRuleMetadataFilterArgs']]]] metadata_filters: Opaque filter criteria used by Loadbalancer to restrict routing
               configuration to a limited set xDS compliant clients. In their xDS
               requests to Loadbalancer, xDS clients present node metadata. If a
               match takes place, the relevant routing configuration is made available
               to those proxies.
               For each metadataFilter in this list, if its filterMatchCriteria is set
               to MATCH_ANY, at least one of the filterLabels must match the
               corresponding label provided in the metadata. If its filterMatchCriteria
               is set to MATCH_ALL, then all of its filterLabels must match with
               corresponding labels in the provided metadata.
               metadataFilters specified here can be overridden by those specified in
               the UrlMap that this ForwardingRule references.
               metadataFilters only applies to Loadbalancers that have their
               loadBalancingScheme set to INTERNAL_SELF_MANAGED.
               Structure is documented below.
        :param pulumi.Input[str] name: Name of the resource; provided by the client when the resource is created.
               The name must be 1-63 characters long, and comply with
               [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
               Specifically, the name must be 1-63 characters long and match the regular
               expression `a-z?` which means the first
               character must be a lowercase letter, and all following characters must
               be a dash, lowercase letter, or digit, except the last character, which
               cannot be a dash.
               For Private Service Connect forwarding rules that forward traffic to Google
               APIs, the forwarding rule name must be a 1-20 characters string with
               lowercase letters and numbers and must start with a letter.
        :param pulumi.Input[str] network: This field is not used for external load balancing.
               For Internal TCP/UDP Load Balancing, this field identifies the network that
               the load balanced IP should belong to for this Forwarding Rule.
               If the subnetwork is specified, the network of the subnetwork will be used.
               If neither subnetwork nor this field is specified, the default network will
               be used.
               For Private Service Connect forwarding rules that forward traffic to Google
               APIs, a network must be provided.
        :param pulumi.Input[bool] no_automate_dns_zone: This is used in PSC consumer ForwardingRule to control whether it should try to auto-generate a DNS zone or not. Non-PSC forwarding rules do not use this field.
        :param pulumi.Input[str] port_range: This field can only be used:
               * If `IPProtocol` is one of TCP, UDP, or SCTP.
               * By backend service-based network load balancers, target pool-based
               network load balancers, internal proxy load balancers, external proxy load
               balancers, Traffic Director, external protocol forwarding, and Classic VPN.
               Some products have restrictions on what ports can be used. See
               [port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#port_specifications)
               for details.
               
               * TargetHttpProxy: 80, 8080
               * TargetHttpsProxy: 443
               * TargetTcpProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995,
               1883, 5222
               * TargetSslProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995,
               1883, 5222
               * TargetVpnGateway: 500, 4500
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_ip_ranges: If not empty, this Forwarding Rule will only forward the traffic when the source IP address matches one of the IP addresses or CIDR ranges set here. Note that a Forwarding Rule can only have up to 64 source IP ranges, and this field can only be used with a regional Forwarding Rule whose scheme is EXTERNAL. Each sourceIpRange entry should be either an IP address (for example, 1.2.3.4) or a CIDR range (for example, 1.2.3.0/24).
        :param pulumi.Input[str] target: The URL of the target resource to receive the matched traffic.  For
               regional forwarding rules, this target must be in the same region as the
               forwarding rule. For global forwarding rules, this target must be a global
               load balancing resource.
               The forwarded traffic must be of a type appropriate to the target object.
               *  For load balancers, see the "Target" column in [Port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
               *  For Private Service Connect forwarding rules that forward traffic to Google APIs, provide the name of a supported Google API bundle:
               *  `vpc-sc` - [ APIs that support VPC Service Controls](https://cloud.google.com/vpc-service-controls/docs/supported-products).
               *  `all-apis` - [All supported Google APIs](https://cloud.google.com/vpc/docs/private-service-connect#supported-apis).
               
               For Private Service Connect forwarding rules that forward traffic to managed services, the target must be a service attachment.
               
               
               - - -
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GlobalForwardingRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a GlobalForwardingRule resource. Global forwarding rules are
        used to forward traffic to the correct load balancer for HTTP load
        balancing. Global forwarding rules can only be used for HTTP load
        balancing.

        For more information, see
        https://cloud.google.com/compute/docs/load-balancing/http/

        ## Example Usage
        ### Global Forwarding Rule External Managed

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_backend_service = gcp.compute.BackendService("defaultBackendService",
            port_name="http",
            protocol="HTTP",
            timeout_sec=10,
            load_balancing_scheme="EXTERNAL_MANAGED")
        default_url_map = gcp.compute.URLMap("defaultURLMap",
            description="a description",
            default_service=default_backend_service.id,
            host_rules=[gcp.compute.URLMapHostRuleArgs(
                hosts=["mysite.com"],
                path_matcher="allpaths",
            )],
            path_matchers=[gcp.compute.URLMapPathMatcherArgs(
                name="allpaths",
                default_service=default_backend_service.id,
                path_rules=[gcp.compute.URLMapPathMatcherPathRuleArgs(
                    paths=["/*"],
                    service=default_backend_service.id,
                )],
            )])
        default_target_http_proxy = gcp.compute.TargetHttpProxy("defaultTargetHttpProxy",
            description="a description",
            url_map=default_url_map.id)
        default_global_forwarding_rule = gcp.compute.GlobalForwardingRule("defaultGlobalForwardingRule",
            target=default_target_http_proxy.id,
            port_range="80",
            load_balancing_scheme="EXTERNAL_MANAGED")
        ```
        ### Private Service Connect Google Apis

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network = gcp.compute.Network("network",
            project="my-project-name",
            auto_create_subnetworks=False,
            opts=pulumi.ResourceOptions(provider=google_beta))
        vpc_subnetwork = gcp.compute.Subnetwork("vpcSubnetwork",
            project=network.project,
            ip_cidr_range="10.2.0.0/16",
            region="us-central1",
            network=network.id,
            private_ip_google_access=True,
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_global_address = gcp.compute.GlobalAddress("defaultGlobalAddress",
            project=network.project,
            address_type="INTERNAL",
            purpose="PRIVATE_SERVICE_CONNECT",
            network=network.id,
            address="100.100.100.106",
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_global_forwarding_rule = gcp.compute.GlobalForwardingRule("defaultGlobalForwardingRule",
            project=network.project,
            target="all-apis",
            network=network.id,
            ip_address=default_global_address.id,
            load_balancing_scheme="",
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Private Service Connect Google Apis No Automate Dns

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network = gcp.compute.Network("network",
            project="my-project-name",
            auto_create_subnetworks=False,
            opts=pulumi.ResourceOptions(provider=google_beta))
        vpc_subnetwork = gcp.compute.Subnetwork("vpcSubnetwork",
            project=network.project,
            ip_cidr_range="10.2.0.0/16",
            region="us-central1",
            network=network.id,
            private_ip_google_access=True,
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_global_address = gcp.compute.GlobalAddress("defaultGlobalAddress",
            project=network.project,
            address_type="INTERNAL",
            purpose="PRIVATE_SERVICE_CONNECT",
            network=network.id,
            address="100.100.100.106",
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_global_forwarding_rule = gcp.compute.GlobalForwardingRule("defaultGlobalForwardingRule",
            project=network.project,
            target="all-apis",
            network=network.id,
            ip_address=default_global_address.id,
            load_balancing_scheme="",
            no_automate_dns_zone=False,
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```

        ## Import

        GlobalForwardingRule can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:compute/globalForwardingRule:GlobalForwardingRule default projects/{{project}}/global/forwardingRules/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/globalForwardingRule:GlobalForwardingRule default {{project}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/globalForwardingRule:GlobalForwardingRule default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param GlobalForwardingRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GlobalForwardingRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_psc_global_access: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 ip_protocol: Optional[pulumi.Input[str]] = None,
                 ip_version: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 load_balancing_scheme: Optional[pulumi.Input[str]] = None,
                 metadata_filters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GlobalForwardingRuleMetadataFilterArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 no_automate_dns_zone: Optional[pulumi.Input[bool]] = None,
                 port_range: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 source_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 target: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GlobalForwardingRuleArgs.__new__(GlobalForwardingRuleArgs)

            __props__.__dict__["allow_psc_global_access"] = allow_psc_global_access
            __props__.__dict__["description"] = description
            __props__.__dict__["ip_address"] = ip_address
            __props__.__dict__["ip_protocol"] = ip_protocol
            __props__.__dict__["ip_version"] = ip_version
            __props__.__dict__["labels"] = labels
            __props__.__dict__["load_balancing_scheme"] = load_balancing_scheme
            __props__.__dict__["metadata_filters"] = metadata_filters
            __props__.__dict__["name"] = name
            __props__.__dict__["network"] = network
            __props__.__dict__["no_automate_dns_zone"] = no_automate_dns_zone
            __props__.__dict__["port_range"] = port_range
            __props__.__dict__["project"] = project
            __props__.__dict__["source_ip_ranges"] = source_ip_ranges
            if target is None and not opts.urn:
                raise TypeError("Missing required property 'target'")
            __props__.__dict__["target"] = target
            __props__.__dict__["base_forwarding_rule"] = None
            __props__.__dict__["label_fingerprint"] = None
            __props__.__dict__["psc_connection_id"] = None
            __props__.__dict__["psc_connection_status"] = None
            __props__.__dict__["self_link"] = None
        super(GlobalForwardingRule, __self__).__init__(
            'gcp:compute/globalForwardingRule:GlobalForwardingRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_psc_global_access: Optional[pulumi.Input[bool]] = None,
            base_forwarding_rule: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            ip_address: Optional[pulumi.Input[str]] = None,
            ip_protocol: Optional[pulumi.Input[str]] = None,
            ip_version: Optional[pulumi.Input[str]] = None,
            label_fingerprint: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            load_balancing_scheme: Optional[pulumi.Input[str]] = None,
            metadata_filters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GlobalForwardingRuleMetadataFilterArgs']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network: Optional[pulumi.Input[str]] = None,
            no_automate_dns_zone: Optional[pulumi.Input[bool]] = None,
            port_range: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            psc_connection_id: Optional[pulumi.Input[str]] = None,
            psc_connection_status: Optional[pulumi.Input[str]] = None,
            self_link: Optional[pulumi.Input[str]] = None,
            source_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            target: Optional[pulumi.Input[str]] = None) -> 'GlobalForwardingRule':
        """
        Get an existing GlobalForwardingRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] allow_psc_global_access: This is used in PSC consumer ForwardingRule to control whether the PSC endpoint can be accessed from another region.
        :param pulumi.Input[str] base_forwarding_rule: [Output Only] The URL for the corresponding base Forwarding Rule. By base Forwarding Rule, we mean the Forwarding Rule that has the same IP address, protocol, and port settings with the current Forwarding Rule, but without sourceIPRanges specified. Always empty if the current Forwarding Rule does not have sourceIPRanges specified.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when
               you create the resource.
        :param pulumi.Input[str] ip_address: IP address for which this forwarding rule accepts traffic. When a client
               sends traffic to this IP address, the forwarding rule directs the traffic
               to the referenced `target`.
               While creating a forwarding rule, specifying an `IPAddress` is
               required under the following circumstances:
               * When the `target` is set to `targetGrpcProxy` and
               `validateForProxyless` is set to `true`, the
               `IPAddress` should be set to `0.0.0.0`.
               * When the `target` is a Private Service Connect Google APIs
               bundle, you must specify an `IPAddress`.
               
               Otherwise, you can optionally specify an IP address that references an
               existing static (reserved) IP address resource. When omitted, Google Cloud
               assigns an ephemeral IP address.
               Use one of the following formats to specify an IP address while creating a
               forwarding rule:
               * IP address number, as in `100.1.2.3`
               * IPv6 address range, as in `2600:1234::/96`
               * Full resource URL, as in
               `https://www.googleapis.com/compute/v1/projects/project_id/regions/region/addresses/address-name`
               * Partial URL or by name, as in:
               * `projects/project_id/regions/region/addresses/address-name`
               * `regions/region/addresses/address-name`
               * `global/addresses/address-name`
               * `address-name`
               
               The forwarding rule's `target`,
               and in most cases, also the `loadBalancingScheme`, determine the
               type of IP address that you can use. For detailed information, see
               [IP address
               specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
               When reading an `IPAddress`, the API always returns the IP
               address number.
        :param pulumi.Input[str] ip_protocol: The IP protocol to which this rule applies.
               For protocol forwarding, valid
               options are `TCP`, `UDP`, `ESP`,
               `AH`, `SCTP`, `ICMP` and
               `L3_DEFAULT`.
               The valid IP protocols are different for different load balancing products
               as described in [Load balancing
               features](https://cloud.google.com/load-balancing/docs/features#protocols_from_the_load_balancer_to_the_backends).
               Possible values are: `TCP`, `UDP`, `ESP`, `AH`, `SCTP`, `ICMP`.
        :param pulumi.Input[str] ip_version: The IP Version that will be used by this global forwarding rule.
               Possible values are: `IPV4`, `IPV6`.
        :param pulumi.Input[str] label_fingerprint: The fingerprint used for optimistic locking of this resource.  Used
               internally during updates.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels to apply to this forwarding rule.  A list of key->value pairs.
        :param pulumi.Input[str] load_balancing_scheme: Specifies the forwarding rule type.
               For more information about forwarding rules, refer to
               [Forwarding rule concepts](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts).
               Default value is `EXTERNAL`.
               Possible values are: `EXTERNAL`, `EXTERNAL_MANAGED`, `INTERNAL_SELF_MANAGED`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GlobalForwardingRuleMetadataFilterArgs']]]] metadata_filters: Opaque filter criteria used by Loadbalancer to restrict routing
               configuration to a limited set xDS compliant clients. In their xDS
               requests to Loadbalancer, xDS clients present node metadata. If a
               match takes place, the relevant routing configuration is made available
               to those proxies.
               For each metadataFilter in this list, if its filterMatchCriteria is set
               to MATCH_ANY, at least one of the filterLabels must match the
               corresponding label provided in the metadata. If its filterMatchCriteria
               is set to MATCH_ALL, then all of its filterLabels must match with
               corresponding labels in the provided metadata.
               metadataFilters specified here can be overridden by those specified in
               the UrlMap that this ForwardingRule references.
               metadataFilters only applies to Loadbalancers that have their
               loadBalancingScheme set to INTERNAL_SELF_MANAGED.
               Structure is documented below.
        :param pulumi.Input[str] name: Name of the resource; provided by the client when the resource is created.
               The name must be 1-63 characters long, and comply with
               [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
               Specifically, the name must be 1-63 characters long and match the regular
               expression `a-z?` which means the first
               character must be a lowercase letter, and all following characters must
               be a dash, lowercase letter, or digit, except the last character, which
               cannot be a dash.
               For Private Service Connect forwarding rules that forward traffic to Google
               APIs, the forwarding rule name must be a 1-20 characters string with
               lowercase letters and numbers and must start with a letter.
        :param pulumi.Input[str] network: This field is not used for external load balancing.
               For Internal TCP/UDP Load Balancing, this field identifies the network that
               the load balanced IP should belong to for this Forwarding Rule.
               If the subnetwork is specified, the network of the subnetwork will be used.
               If neither subnetwork nor this field is specified, the default network will
               be used.
               For Private Service Connect forwarding rules that forward traffic to Google
               APIs, a network must be provided.
        :param pulumi.Input[bool] no_automate_dns_zone: This is used in PSC consumer ForwardingRule to control whether it should try to auto-generate a DNS zone or not. Non-PSC forwarding rules do not use this field.
        :param pulumi.Input[str] port_range: This field can only be used:
               * If `IPProtocol` is one of TCP, UDP, or SCTP.
               * By backend service-based network load balancers, target pool-based
               network load balancers, internal proxy load balancers, external proxy load
               balancers, Traffic Director, external protocol forwarding, and Classic VPN.
               Some products have restrictions on what ports can be used. See
               [port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#port_specifications)
               for details.
               
               * TargetHttpProxy: 80, 8080
               * TargetHttpsProxy: 443
               * TargetTcpProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995,
               1883, 5222
               * TargetSslProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995,
               1883, 5222
               * TargetVpnGateway: 500, 4500
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] psc_connection_id: The PSC connection id of the PSC Forwarding Rule.
        :param pulumi.Input[str] psc_connection_status: The PSC connection status of the PSC Forwarding Rule. Possible values: `STATUS_UNSPECIFIED`, `PENDING`, `ACCEPTED`, `REJECTED`, `CLOSED`
        :param pulumi.Input[str] self_link: The URI of the created resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_ip_ranges: If not empty, this Forwarding Rule will only forward the traffic when the source IP address matches one of the IP addresses or CIDR ranges set here. Note that a Forwarding Rule can only have up to 64 source IP ranges, and this field can only be used with a regional Forwarding Rule whose scheme is EXTERNAL. Each sourceIpRange entry should be either an IP address (for example, 1.2.3.4) or a CIDR range (for example, 1.2.3.0/24).
        :param pulumi.Input[str] target: The URL of the target resource to receive the matched traffic.  For
               regional forwarding rules, this target must be in the same region as the
               forwarding rule. For global forwarding rules, this target must be a global
               load balancing resource.
               The forwarded traffic must be of a type appropriate to the target object.
               *  For load balancers, see the "Target" column in [Port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
               *  For Private Service Connect forwarding rules that forward traffic to Google APIs, provide the name of a supported Google API bundle:
               *  `vpc-sc` - [ APIs that support VPC Service Controls](https://cloud.google.com/vpc-service-controls/docs/supported-products).
               *  `all-apis` - [All supported Google APIs](https://cloud.google.com/vpc/docs/private-service-connect#supported-apis).
               
               For Private Service Connect forwarding rules that forward traffic to managed services, the target must be a service attachment.
               
               
               - - -
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GlobalForwardingRuleState.__new__(_GlobalForwardingRuleState)

        __props__.__dict__["allow_psc_global_access"] = allow_psc_global_access
        __props__.__dict__["base_forwarding_rule"] = base_forwarding_rule
        __props__.__dict__["description"] = description
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["ip_protocol"] = ip_protocol
        __props__.__dict__["ip_version"] = ip_version
        __props__.__dict__["label_fingerprint"] = label_fingerprint
        __props__.__dict__["labels"] = labels
        __props__.__dict__["load_balancing_scheme"] = load_balancing_scheme
        __props__.__dict__["metadata_filters"] = metadata_filters
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["no_automate_dns_zone"] = no_automate_dns_zone
        __props__.__dict__["port_range"] = port_range
        __props__.__dict__["project"] = project
        __props__.__dict__["psc_connection_id"] = psc_connection_id
        __props__.__dict__["psc_connection_status"] = psc_connection_status
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["source_ip_ranges"] = source_ip_ranges
        __props__.__dict__["target"] = target
        return GlobalForwardingRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowPscGlobalAccess")
    def allow_psc_global_access(self) -> pulumi.Output[Optional[bool]]:
        """
        This is used in PSC consumer ForwardingRule to control whether the PSC endpoint can be accessed from another region.
        """
        return pulumi.get(self, "allow_psc_global_access")

    @property
    @pulumi.getter(name="baseForwardingRule")
    def base_forwarding_rule(self) -> pulumi.Output[str]:
        """
        [Output Only] The URL for the corresponding base Forwarding Rule. By base Forwarding Rule, we mean the Forwarding Rule that has the same IP address, protocol, and port settings with the current Forwarding Rule, but without sourceIPRanges specified. Always empty if the current Forwarding Rule does not have sourceIPRanges specified.
        """
        return pulumi.get(self, "base_forwarding_rule")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        An optional description of this resource. Provide this property when
        you create the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[str]:
        """
        IP address for which this forwarding rule accepts traffic. When a client
        sends traffic to this IP address, the forwarding rule directs the traffic
        to the referenced `target`.
        While creating a forwarding rule, specifying an `IPAddress` is
        required under the following circumstances:
        * When the `target` is set to `targetGrpcProxy` and
        `validateForProxyless` is set to `true`, the
        `IPAddress` should be set to `0.0.0.0`.
        * When the `target` is a Private Service Connect Google APIs
        bundle, you must specify an `IPAddress`.

        Otherwise, you can optionally specify an IP address that references an
        existing static (reserved) IP address resource. When omitted, Google Cloud
        assigns an ephemeral IP address.
        Use one of the following formats to specify an IP address while creating a
        forwarding rule:
        * IP address number, as in `100.1.2.3`
        * IPv6 address range, as in `2600:1234::/96`
        * Full resource URL, as in
        `https://www.googleapis.com/compute/v1/projects/project_id/regions/region/addresses/address-name`
        * Partial URL or by name, as in:
        * `projects/project_id/regions/region/addresses/address-name`
        * `regions/region/addresses/address-name`
        * `global/addresses/address-name`
        * `address-name`

        The forwarding rule's `target`,
        and in most cases, also the `loadBalancingScheme`, determine the
        type of IP address that you can use. For detailed information, see
        [IP address
        specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
        When reading an `IPAddress`, the API always returns the IP
        address number.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> pulumi.Output[str]:
        """
        The IP protocol to which this rule applies.
        For protocol forwarding, valid
        options are `TCP`, `UDP`, `ESP`,
        `AH`, `SCTP`, `ICMP` and
        `L3_DEFAULT`.
        The valid IP protocols are different for different load balancing products
        as described in [Load balancing
        features](https://cloud.google.com/load-balancing/docs/features#protocols_from_the_load_balancer_to_the_backends).
        Possible values are: `TCP`, `UDP`, `ESP`, `AH`, `SCTP`, `ICMP`.
        """
        return pulumi.get(self, "ip_protocol")

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> pulumi.Output[Optional[str]]:
        """
        The IP Version that will be used by this global forwarding rule.
        Possible values are: `IPV4`, `IPV6`.
        """
        return pulumi.get(self, "ip_version")

    @property
    @pulumi.getter(name="labelFingerprint")
    def label_fingerprint(self) -> pulumi.Output[str]:
        """
        The fingerprint used for optimistic locking of this resource.  Used
        internally during updates.
        """
        return pulumi.get(self, "label_fingerprint")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Labels to apply to this forwarding rule.  A list of key->value pairs.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="loadBalancingScheme")
    def load_balancing_scheme(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the forwarding rule type.
        For more information about forwarding rules, refer to
        [Forwarding rule concepts](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts).
        Default value is `EXTERNAL`.
        Possible values are: `EXTERNAL`, `EXTERNAL_MANAGED`, `INTERNAL_SELF_MANAGED`.
        """
        return pulumi.get(self, "load_balancing_scheme")

    @property
    @pulumi.getter(name="metadataFilters")
    def metadata_filters(self) -> pulumi.Output[Optional[Sequence['outputs.GlobalForwardingRuleMetadataFilter']]]:
        """
        Opaque filter criteria used by Loadbalancer to restrict routing
        configuration to a limited set xDS compliant clients. In their xDS
        requests to Loadbalancer, xDS clients present node metadata. If a
        match takes place, the relevant routing configuration is made available
        to those proxies.
        For each metadataFilter in this list, if its filterMatchCriteria is set
        to MATCH_ANY, at least one of the filterLabels must match the
        corresponding label provided in the metadata. If its filterMatchCriteria
        is set to MATCH_ALL, then all of its filterLabels must match with
        corresponding labels in the provided metadata.
        metadataFilters specified here can be overridden by those specified in
        the UrlMap that this ForwardingRule references.
        metadataFilters only applies to Loadbalancers that have their
        loadBalancingScheme set to INTERNAL_SELF_MANAGED.
        Structure is documented below.
        """
        return pulumi.get(self, "metadata_filters")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the resource; provided by the client when the resource is created.
        The name must be 1-63 characters long, and comply with
        [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
        Specifically, the name must be 1-63 characters long and match the regular
        expression `a-z?` which means the first
        character must be a lowercase letter, and all following characters must
        be a dash, lowercase letter, or digit, except the last character, which
        cannot be a dash.
        For Private Service Connect forwarding rules that forward traffic to Google
        APIs, the forwarding rule name must be a 1-20 characters string with
        lowercase letters and numbers and must start with a letter.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> pulumi.Output[str]:
        """
        This field is not used for external load balancing.
        For Internal TCP/UDP Load Balancing, this field identifies the network that
        the load balanced IP should belong to for this Forwarding Rule.
        If the subnetwork is specified, the network of the subnetwork will be used.
        If neither subnetwork nor this field is specified, the default network will
        be used.
        For Private Service Connect forwarding rules that forward traffic to Google
        APIs, a network must be provided.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="noAutomateDnsZone")
    def no_automate_dns_zone(self) -> pulumi.Output[Optional[bool]]:
        """
        This is used in PSC consumer ForwardingRule to control whether it should try to auto-generate a DNS zone or not. Non-PSC forwarding rules do not use this field.
        """
        return pulumi.get(self, "no_automate_dns_zone")

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> pulumi.Output[Optional[str]]:
        """
        This field can only be used:
        * If `IPProtocol` is one of TCP, UDP, or SCTP.
        * By backend service-based network load balancers, target pool-based
        network load balancers, internal proxy load balancers, external proxy load
        balancers, Traffic Director, external protocol forwarding, and Classic VPN.
        Some products have restrictions on what ports can be used. See
        [port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#port_specifications)
        for details.

        * TargetHttpProxy: 80, 8080
        * TargetHttpsProxy: 443
        * TargetTcpProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995,
        1883, 5222
        * TargetSslProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995,
        1883, 5222
        * TargetVpnGateway: 500, 4500
        """
        return pulumi.get(self, "port_range")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pscConnectionId")
    def psc_connection_id(self) -> pulumi.Output[str]:
        """
        The PSC connection id of the PSC Forwarding Rule.
        """
        return pulumi.get(self, "psc_connection_id")

    @property
    @pulumi.getter(name="pscConnectionStatus")
    def psc_connection_status(self) -> pulumi.Output[str]:
        """
        The PSC connection status of the PSC Forwarding Rule. Possible values: `STATUS_UNSPECIFIED`, `PENDING`, `ACCEPTED`, `REJECTED`, `CLOSED`
        """
        return pulumi.get(self, "psc_connection_status")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="sourceIpRanges")
    def source_ip_ranges(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        If not empty, this Forwarding Rule will only forward the traffic when the source IP address matches one of the IP addresses or CIDR ranges set here. Note that a Forwarding Rule can only have up to 64 source IP ranges, and this field can only be used with a regional Forwarding Rule whose scheme is EXTERNAL. Each sourceIpRange entry should be either an IP address (for example, 1.2.3.4) or a CIDR range (for example, 1.2.3.0/24).
        """
        return pulumi.get(self, "source_ip_ranges")

    @property
    @pulumi.getter
    def target(self) -> pulumi.Output[str]:
        """
        The URL of the target resource to receive the matched traffic.  For
        regional forwarding rules, this target must be in the same region as the
        forwarding rule. For global forwarding rules, this target must be a global
        load balancing resource.
        The forwarded traffic must be of a type appropriate to the target object.
        *  For load balancers, see the "Target" column in [Port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
        *  For Private Service Connect forwarding rules that forward traffic to Google APIs, provide the name of a supported Google API bundle:
        *  `vpc-sc` - [ APIs that support VPC Service Controls](https://cloud.google.com/vpc-service-controls/docs/supported-products).
        *  `all-apis` - [All supported Google APIs](https://cloud.google.com/vpc/docs/private-service-connect#supported-apis).

        For Private Service Connect forwarding rules that forward traffic to managed services, the target must be a service attachment.


        - - -
        """
        return pulumi.get(self, "target")

