# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RegionCommitmentArgs', 'RegionCommitment']

@pulumi.input_type
class RegionCommitmentArgs:
    def __init__(__self__, *,
                 plan: pulumi.Input[str],
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 category: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 license_resource: Optional[pulumi.Input['RegionCommitmentLicenseResourceArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input['RegionCommitmentResourceArgs']]]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a RegionCommitment resource.
        :param pulumi.Input[str] plan: The plan for this commitment, which determines duration and discount rate.
               The currently supported plans are TWELVE_MONTH (1 year), and THIRTY_SIX_MONTH (3 years).
               Possible values are: `TWELVE_MONTH`, `THIRTY_SIX_MONTH`.
               
               
               - - -
        :param pulumi.Input[bool] auto_renew: Specifies whether to enable automatic renewal for the commitment.
               The default value is false if not specified.
               If the field is set to true, the commitment will be automatically renewed for either
               one or three years according to the terms of the existing commitment.
        :param pulumi.Input[str] category: The category of the commitment. Category MACHINE specifies commitments composed of
               machine resources such as VCPU or MEMORY, listed in resources. Category LICENSE
               specifies commitments composed of software licenses, listed in licenseResources.
               Note that only MACHINE commitments should have a Type specified.
               Possible values are: `LICENSE`, `MACHINE`.
        :param pulumi.Input[str] description: An optional description of this resource.
        :param pulumi.Input['RegionCommitmentLicenseResourceArgs'] license_resource: The license specification required as part of a license commitment.
               Structure is documented below.
        :param pulumi.Input[str] name: Name of the resource. The name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: URL of the region where this commitment may be used.
        :param pulumi.Input[Sequence[pulumi.Input['RegionCommitmentResourceArgs']]] resources: A list of commitment amounts for particular resources.
               Note that VCPU and MEMORY resource commitments must occur together.
               Structure is documented below.
        :param pulumi.Input[str] type: The type of commitment, which affects the discount rate and the eligible resources.
               The type could be one of the following value: `MEMORY_OPTIMIZED`, `ACCELERATOR_OPTIMIZED`,
               `GENERAL_PURPOSE_N1`, `GENERAL_PURPOSE_N2`, `GENERAL_PURPOSE_N2D`, `GENERAL_PURPOSE_E2`,
               `GENERAL_PURPOSE_T2D`, `GENERAL_PURPOSE_C3`, `COMPUTE_OPTIMIZED_C2`, `COMPUTE_OPTIMIZED_C2D` and
               `GRAPHICS_OPTIMIZED_G2`
        """
        pulumi.set(__self__, "plan", plan)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if license_resource is not None:
            pulumi.set(__self__, "license_resource", license_resource)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def plan(self) -> pulumi.Input[str]:
        """
        The plan for this commitment, which determines duration and discount rate.
        The currently supported plans are TWELVE_MONTH (1 year), and THIRTY_SIX_MONTH (3 years).
        Possible values are: `TWELVE_MONTH`, `THIRTY_SIX_MONTH`.


        - - -
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: pulumi.Input[str]):
        pulumi.set(self, "plan", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable automatic renewal for the commitment.
        The default value is false if not specified.
        If the field is set to true, the commitment will be automatically renewed for either
        one or three years according to the terms of the existing commitment.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[str]]:
        """
        The category of the commitment. Category MACHINE specifies commitments composed of
        machine resources such as VCPU or MEMORY, listed in resources. Category LICENSE
        specifies commitments composed of software licenses, listed in licenseResources.
        Note that only MACHINE commitments should have a Type specified.
        Possible values are: `LICENSE`, `MACHINE`.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="licenseResource")
    def license_resource(self) -> Optional[pulumi.Input['RegionCommitmentLicenseResourceArgs']]:
        """
        The license specification required as part of a license commitment.
        Structure is documented below.
        """
        return pulumi.get(self, "license_resource")

    @license_resource.setter
    def license_resource(self, value: Optional[pulumi.Input['RegionCommitmentLicenseResourceArgs']]):
        pulumi.set(self, "license_resource", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource. The name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        URL of the region where this commitment may be used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RegionCommitmentResourceArgs']]]]:
        """
        A list of commitment amounts for particular resources.
        Note that VCPU and MEMORY resource commitments must occur together.
        Structure is documented below.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RegionCommitmentResourceArgs']]]]):
        pulumi.set(self, "resources", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of commitment, which affects the discount rate and the eligible resources.
        The type could be one of the following value: `MEMORY_OPTIMIZED`, `ACCELERATOR_OPTIMIZED`,
        `GENERAL_PURPOSE_N1`, `GENERAL_PURPOSE_N2`, `GENERAL_PURPOSE_N2D`, `GENERAL_PURPOSE_E2`,
        `GENERAL_PURPOSE_T2D`, `GENERAL_PURPOSE_C3`, `COMPUTE_OPTIMIZED_C2`, `COMPUTE_OPTIMIZED_C2D` and
        `GRAPHICS_OPTIMIZED_G2`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _RegionCommitmentState:
    def __init__(__self__, *,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 category: Optional[pulumi.Input[str]] = None,
                 commitment_id: Optional[pulumi.Input[int]] = None,
                 creation_timestamp: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 end_timestamp: Optional[pulumi.Input[str]] = None,
                 license_resource: Optional[pulumi.Input['RegionCommitmentLicenseResourceArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 plan: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input['RegionCommitmentResourceArgs']]]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 start_timestamp: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 status_message: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering RegionCommitment resources.
        :param pulumi.Input[bool] auto_renew: Specifies whether to enable automatic renewal for the commitment.
               The default value is false if not specified.
               If the field is set to true, the commitment will be automatically renewed for either
               one or three years according to the terms of the existing commitment.
        :param pulumi.Input[str] category: The category of the commitment. Category MACHINE specifies commitments composed of
               machine resources such as VCPU or MEMORY, listed in resources. Category LICENSE
               specifies commitments composed of software licenses, listed in licenseResources.
               Note that only MACHINE commitments should have a Type specified.
               Possible values are: `LICENSE`, `MACHINE`.
        :param pulumi.Input[int] commitment_id: Unique identifier for the resource.
        :param pulumi.Input[str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[str] description: An optional description of this resource.
        :param pulumi.Input[str] end_timestamp: Commitment end time in RFC3339 text format.
        :param pulumi.Input['RegionCommitmentLicenseResourceArgs'] license_resource: The license specification required as part of a license commitment.
               Structure is documented below.
        :param pulumi.Input[str] name: Name of the resource. The name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[str] plan: The plan for this commitment, which determines duration and discount rate.
               The currently supported plans are TWELVE_MONTH (1 year), and THIRTY_SIX_MONTH (3 years).
               Possible values are: `TWELVE_MONTH`, `THIRTY_SIX_MONTH`.
               
               
               - - -
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: URL of the region where this commitment may be used.
        :param pulumi.Input[Sequence[pulumi.Input['RegionCommitmentResourceArgs']]] resources: A list of commitment amounts for particular resources.
               Note that VCPU and MEMORY resource commitments must occur together.
               Structure is documented below.
        :param pulumi.Input[str] self_link: The URI of the created resource.
        :param pulumi.Input[str] start_timestamp: Commitment start time in RFC3339 text format.
        :param pulumi.Input[str] status: Status of the commitment with regards to eventual expiration
               (each commitment has an end date defined).
        :param pulumi.Input[str] status_message: A human-readable explanation of the status.
        :param pulumi.Input[str] type: The type of commitment, which affects the discount rate and the eligible resources.
               The type could be one of the following value: `MEMORY_OPTIMIZED`, `ACCELERATOR_OPTIMIZED`,
               `GENERAL_PURPOSE_N1`, `GENERAL_PURPOSE_N2`, `GENERAL_PURPOSE_N2D`, `GENERAL_PURPOSE_E2`,
               `GENERAL_PURPOSE_T2D`, `GENERAL_PURPOSE_C3`, `COMPUTE_OPTIMIZED_C2`, `COMPUTE_OPTIMIZED_C2D` and
               `GRAPHICS_OPTIMIZED_G2`
        """
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if commitment_id is not None:
            pulumi.set(__self__, "commitment_id", commitment_id)
        if creation_timestamp is not None:
            pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if end_timestamp is not None:
            pulumi.set(__self__, "end_timestamp", end_timestamp)
        if license_resource is not None:
            pulumi.set(__self__, "license_resource", license_resource)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if start_timestamp is not None:
            pulumi.set(__self__, "start_timestamp", start_timestamp)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if status_message is not None:
            pulumi.set(__self__, "status_message", status_message)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable automatic renewal for the commitment.
        The default value is false if not specified.
        If the field is set to true, the commitment will be automatically renewed for either
        one or three years according to the terms of the existing commitment.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[str]]:
        """
        The category of the commitment. Category MACHINE specifies commitments composed of
        machine resources such as VCPU or MEMORY, listed in resources. Category LICENSE
        specifies commitments composed of software licenses, listed in licenseResources.
        Note that only MACHINE commitments should have a Type specified.
        Possible values are: `LICENSE`, `MACHINE`.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter(name="commitmentId")
    def commitment_id(self) -> Optional[pulumi.Input[int]]:
        """
        Unique identifier for the resource.
        """
        return pulumi.get(self, "commitment_id")

    @commitment_id.setter
    def commitment_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "commitment_id", value)

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> Optional[pulumi.Input[str]]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @creation_timestamp.setter
    def creation_timestamp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_timestamp", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="endTimestamp")
    def end_timestamp(self) -> Optional[pulumi.Input[str]]:
        """
        Commitment end time in RFC3339 text format.
        """
        return pulumi.get(self, "end_timestamp")

    @end_timestamp.setter
    def end_timestamp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_timestamp", value)

    @property
    @pulumi.getter(name="licenseResource")
    def license_resource(self) -> Optional[pulumi.Input['RegionCommitmentLicenseResourceArgs']]:
        """
        The license specification required as part of a license commitment.
        Structure is documented below.
        """
        return pulumi.get(self, "license_resource")

    @license_resource.setter
    def license_resource(self, value: Optional[pulumi.Input['RegionCommitmentLicenseResourceArgs']]):
        pulumi.set(self, "license_resource", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource. The name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input[str]]:
        """
        The plan for this commitment, which determines duration and discount rate.
        The currently supported plans are TWELVE_MONTH (1 year), and THIRTY_SIX_MONTH (3 years).
        Possible values are: `TWELVE_MONTH`, `THIRTY_SIX_MONTH`.


        - - -
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "plan", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        URL of the region where this commitment may be used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RegionCommitmentResourceArgs']]]]:
        """
        A list of commitment amounts for particular resources.
        Note that VCPU and MEMORY resource commitments must occur together.
        Structure is documented below.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RegionCommitmentResourceArgs']]]]):
        pulumi.set(self, "resources", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter(name="startTimestamp")
    def start_timestamp(self) -> Optional[pulumi.Input[str]]:
        """
        Commitment start time in RFC3339 text format.
        """
        return pulumi.get(self, "start_timestamp")

    @start_timestamp.setter
    def start_timestamp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_timestamp", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of the commitment with regards to eventual expiration
        (each commitment has an end date defined).
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> Optional[pulumi.Input[str]]:
        """
        A human-readable explanation of the status.
        """
        return pulumi.get(self, "status_message")

    @status_message.setter
    def status_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status_message", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of commitment, which affects the discount rate and the eligible resources.
        The type could be one of the following value: `MEMORY_OPTIMIZED`, `ACCELERATOR_OPTIMIZED`,
        `GENERAL_PURPOSE_N1`, `GENERAL_PURPOSE_N2`, `GENERAL_PURPOSE_N2D`, `GENERAL_PURPOSE_E2`,
        `GENERAL_PURPOSE_T2D`, `GENERAL_PURPOSE_C3`, `COMPUTE_OPTIMIZED_C2`, `COMPUTE_OPTIMIZED_C2D` and
        `GRAPHICS_OPTIMIZED_G2`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class RegionCommitment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 category: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 license_resource: Optional[pulumi.Input[pulumi.InputType['RegionCommitmentLicenseResourceArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 plan: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RegionCommitmentResourceArgs']]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Represents a regional Commitment resource.

        Creating a commitment resource means that you are purchasing a committed
        use contract with an explicit start and end time. You can create commitments
        based on vCPUs and memory usage and receive discounted rates.

        To get more information about RegionCommitment, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/regionCommitments)
        * How-to Guides
            * [Committed use discounts for Compute Engine](https://cloud.google.com/compute/docs/instances/committed-use-discounts-overview)

        ## Example Usage
        ### Compute Region Commitment Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        foobar = gcp.compute.RegionCommitment("foobar",
            plan="THIRTY_SIX_MONTH",
            resources=[
                gcp.compute.RegionCommitmentResourceArgs(
                    amount="4",
                    type="VCPU",
                ),
                gcp.compute.RegionCommitmentResourceArgs(
                    amount="9",
                    type="MEMORY",
                ),
            ])
        ```
        ### Compute Region Commitment Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        foobar = gcp.compute.RegionCommitment("foobar",
            auto_renew=True,
            category="MACHINE",
            description="some description",
            plan="THIRTY_SIX_MONTH",
            resources=[
                gcp.compute.RegionCommitmentResourceArgs(
                    amount="4",
                    type="VCPU",
                ),
                gcp.compute.RegionCommitmentResourceArgs(
                    amount="9",
                    type="MEMORY",
                ),
            ],
            type="MEMORY_OPTIMIZED")
        ```

        ## Import

        RegionCommitment can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:compute/regionCommitment:RegionCommitment default projects/{{project}}/regions/{{region}}/commitments/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/regionCommitment:RegionCommitment default {{project}}/{{region}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/regionCommitment:RegionCommitment default {{region}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/regionCommitment:RegionCommitment default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_renew: Specifies whether to enable automatic renewal for the commitment.
               The default value is false if not specified.
               If the field is set to true, the commitment will be automatically renewed for either
               one or three years according to the terms of the existing commitment.
        :param pulumi.Input[str] category: The category of the commitment. Category MACHINE specifies commitments composed of
               machine resources such as VCPU or MEMORY, listed in resources. Category LICENSE
               specifies commitments composed of software licenses, listed in licenseResources.
               Note that only MACHINE commitments should have a Type specified.
               Possible values are: `LICENSE`, `MACHINE`.
        :param pulumi.Input[str] description: An optional description of this resource.
        :param pulumi.Input[pulumi.InputType['RegionCommitmentLicenseResourceArgs']] license_resource: The license specification required as part of a license commitment.
               Structure is documented below.
        :param pulumi.Input[str] name: Name of the resource. The name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[str] plan: The plan for this commitment, which determines duration and discount rate.
               The currently supported plans are TWELVE_MONTH (1 year), and THIRTY_SIX_MONTH (3 years).
               Possible values are: `TWELVE_MONTH`, `THIRTY_SIX_MONTH`.
               
               
               - - -
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: URL of the region where this commitment may be used.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RegionCommitmentResourceArgs']]]] resources: A list of commitment amounts for particular resources.
               Note that VCPU and MEMORY resource commitments must occur together.
               Structure is documented below.
        :param pulumi.Input[str] type: The type of commitment, which affects the discount rate and the eligible resources.
               The type could be one of the following value: `MEMORY_OPTIMIZED`, `ACCELERATOR_OPTIMIZED`,
               `GENERAL_PURPOSE_N1`, `GENERAL_PURPOSE_N2`, `GENERAL_PURPOSE_N2D`, `GENERAL_PURPOSE_E2`,
               `GENERAL_PURPOSE_T2D`, `GENERAL_PURPOSE_C3`, `COMPUTE_OPTIMIZED_C2`, `COMPUTE_OPTIMIZED_C2D` and
               `GRAPHICS_OPTIMIZED_G2`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RegionCommitmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a regional Commitment resource.

        Creating a commitment resource means that you are purchasing a committed
        use contract with an explicit start and end time. You can create commitments
        based on vCPUs and memory usage and receive discounted rates.

        To get more information about RegionCommitment, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/regionCommitments)
        * How-to Guides
            * [Committed use discounts for Compute Engine](https://cloud.google.com/compute/docs/instances/committed-use-discounts-overview)

        ## Example Usage
        ### Compute Region Commitment Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        foobar = gcp.compute.RegionCommitment("foobar",
            plan="THIRTY_SIX_MONTH",
            resources=[
                gcp.compute.RegionCommitmentResourceArgs(
                    amount="4",
                    type="VCPU",
                ),
                gcp.compute.RegionCommitmentResourceArgs(
                    amount="9",
                    type="MEMORY",
                ),
            ])
        ```
        ### Compute Region Commitment Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        foobar = gcp.compute.RegionCommitment("foobar",
            auto_renew=True,
            category="MACHINE",
            description="some description",
            plan="THIRTY_SIX_MONTH",
            resources=[
                gcp.compute.RegionCommitmentResourceArgs(
                    amount="4",
                    type="VCPU",
                ),
                gcp.compute.RegionCommitmentResourceArgs(
                    amount="9",
                    type="MEMORY",
                ),
            ],
            type="MEMORY_OPTIMIZED")
        ```

        ## Import

        RegionCommitment can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:compute/regionCommitment:RegionCommitment default projects/{{project}}/regions/{{region}}/commitments/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/regionCommitment:RegionCommitment default {{project}}/{{region}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/regionCommitment:RegionCommitment default {{region}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/regionCommitment:RegionCommitment default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param RegionCommitmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RegionCommitmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 category: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 license_resource: Optional[pulumi.Input[pulumi.InputType['RegionCommitmentLicenseResourceArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 plan: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RegionCommitmentResourceArgs']]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RegionCommitmentArgs.__new__(RegionCommitmentArgs)

            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["category"] = category
            __props__.__dict__["description"] = description
            __props__.__dict__["license_resource"] = license_resource
            __props__.__dict__["name"] = name
            if plan is None and not opts.urn:
                raise TypeError("Missing required property 'plan'")
            __props__.__dict__["plan"] = plan
            __props__.__dict__["project"] = project
            __props__.__dict__["region"] = region
            __props__.__dict__["resources"] = resources
            __props__.__dict__["type"] = type
            __props__.__dict__["commitment_id"] = None
            __props__.__dict__["creation_timestamp"] = None
            __props__.__dict__["end_timestamp"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["start_timestamp"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["status_message"] = None
        super(RegionCommitment, __self__).__init__(
            'gcp:compute/regionCommitment:RegionCommitment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_renew: Optional[pulumi.Input[bool]] = None,
            category: Optional[pulumi.Input[str]] = None,
            commitment_id: Optional[pulumi.Input[int]] = None,
            creation_timestamp: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            end_timestamp: Optional[pulumi.Input[str]] = None,
            license_resource: Optional[pulumi.Input[pulumi.InputType['RegionCommitmentLicenseResourceArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            plan: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            resources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RegionCommitmentResourceArgs']]]]] = None,
            self_link: Optional[pulumi.Input[str]] = None,
            start_timestamp: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            status_message: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'RegionCommitment':
        """
        Get an existing RegionCommitment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_renew: Specifies whether to enable automatic renewal for the commitment.
               The default value is false if not specified.
               If the field is set to true, the commitment will be automatically renewed for either
               one or three years according to the terms of the existing commitment.
        :param pulumi.Input[str] category: The category of the commitment. Category MACHINE specifies commitments composed of
               machine resources such as VCPU or MEMORY, listed in resources. Category LICENSE
               specifies commitments composed of software licenses, listed in licenseResources.
               Note that only MACHINE commitments should have a Type specified.
               Possible values are: `LICENSE`, `MACHINE`.
        :param pulumi.Input[int] commitment_id: Unique identifier for the resource.
        :param pulumi.Input[str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[str] description: An optional description of this resource.
        :param pulumi.Input[str] end_timestamp: Commitment end time in RFC3339 text format.
        :param pulumi.Input[pulumi.InputType['RegionCommitmentLicenseResourceArgs']] license_resource: The license specification required as part of a license commitment.
               Structure is documented below.
        :param pulumi.Input[str] name: Name of the resource. The name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[str] plan: The plan for this commitment, which determines duration and discount rate.
               The currently supported plans are TWELVE_MONTH (1 year), and THIRTY_SIX_MONTH (3 years).
               Possible values are: `TWELVE_MONTH`, `THIRTY_SIX_MONTH`.
               
               
               - - -
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: URL of the region where this commitment may be used.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RegionCommitmentResourceArgs']]]] resources: A list of commitment amounts for particular resources.
               Note that VCPU and MEMORY resource commitments must occur together.
               Structure is documented below.
        :param pulumi.Input[str] self_link: The URI of the created resource.
        :param pulumi.Input[str] start_timestamp: Commitment start time in RFC3339 text format.
        :param pulumi.Input[str] status: Status of the commitment with regards to eventual expiration
               (each commitment has an end date defined).
        :param pulumi.Input[str] status_message: A human-readable explanation of the status.
        :param pulumi.Input[str] type: The type of commitment, which affects the discount rate and the eligible resources.
               The type could be one of the following value: `MEMORY_OPTIMIZED`, `ACCELERATOR_OPTIMIZED`,
               `GENERAL_PURPOSE_N1`, `GENERAL_PURPOSE_N2`, `GENERAL_PURPOSE_N2D`, `GENERAL_PURPOSE_E2`,
               `GENERAL_PURPOSE_T2D`, `GENERAL_PURPOSE_C3`, `COMPUTE_OPTIMIZED_C2`, `COMPUTE_OPTIMIZED_C2D` and
               `GRAPHICS_OPTIMIZED_G2`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RegionCommitmentState.__new__(_RegionCommitmentState)

        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["category"] = category
        __props__.__dict__["commitment_id"] = commitment_id
        __props__.__dict__["creation_timestamp"] = creation_timestamp
        __props__.__dict__["description"] = description
        __props__.__dict__["end_timestamp"] = end_timestamp
        __props__.__dict__["license_resource"] = license_resource
        __props__.__dict__["name"] = name
        __props__.__dict__["plan"] = plan
        __props__.__dict__["project"] = project
        __props__.__dict__["region"] = region
        __props__.__dict__["resources"] = resources
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["start_timestamp"] = start_timestamp
        __props__.__dict__["status"] = status
        __props__.__dict__["status_message"] = status_message
        __props__.__dict__["type"] = type
        return RegionCommitment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[bool]:
        """
        Specifies whether to enable automatic renewal for the commitment.
        The default value is false if not specified.
        If the field is set to true, the commitment will be automatically renewed for either
        one or three years according to the terms of the existing commitment.
        """
        return pulumi.get(self, "auto_renew")

    @property
    @pulumi.getter
    def category(self) -> pulumi.Output[str]:
        """
        The category of the commitment. Category MACHINE specifies commitments composed of
        machine resources such as VCPU or MEMORY, listed in resources. Category LICENSE
        specifies commitments composed of software licenses, listed in licenseResources.
        Note that only MACHINE commitments should have a Type specified.
        Possible values are: `LICENSE`, `MACHINE`.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter(name="commitmentId")
    def commitment_id(self) -> pulumi.Output[int]:
        """
        Unique identifier for the resource.
        """
        return pulumi.get(self, "commitment_id")

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[str]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="endTimestamp")
    def end_timestamp(self) -> pulumi.Output[str]:
        """
        Commitment end time in RFC3339 text format.
        """
        return pulumi.get(self, "end_timestamp")

    @property
    @pulumi.getter(name="licenseResource")
    def license_resource(self) -> pulumi.Output[Optional['outputs.RegionCommitmentLicenseResource']]:
        """
        The license specification required as part of a license commitment.
        Structure is documented below.
        """
        return pulumi.get(self, "license_resource")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the resource. The name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def plan(self) -> pulumi.Output[str]:
        """
        The plan for this commitment, which determines duration and discount rate.
        The currently supported plans are TWELVE_MONTH (1 year), and THIRTY_SIX_MONTH (3 years).
        Possible values are: `TWELVE_MONTH`, `THIRTY_SIX_MONTH`.


        - - -
        """
        return pulumi.get(self, "plan")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        URL of the region where this commitment may be used.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def resources(self) -> pulumi.Output[Optional[Sequence['outputs.RegionCommitmentResource']]]:
        """
        A list of commitment amounts for particular resources.
        Note that VCPU and MEMORY resource commitments must occur together.
        Structure is documented below.
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="startTimestamp")
    def start_timestamp(self) -> pulumi.Output[str]:
        """
        Commitment start time in RFC3339 text format.
        """
        return pulumi.get(self, "start_timestamp")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Status of the commitment with regards to eventual expiration
        (each commitment has an end date defined).
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> pulumi.Output[str]:
        """
        A human-readable explanation of the status.
        """
        return pulumi.get(self, "status_message")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of commitment, which affects the discount rate and the eligible resources.
        The type could be one of the following value: `MEMORY_OPTIMIZED`, `ACCELERATOR_OPTIMIZED`,
        `GENERAL_PURPOSE_N1`, `GENERAL_PURPOSE_N2`, `GENERAL_PURPOSE_N2D`, `GENERAL_PURPOSE_E2`,
        `GENERAL_PURPOSE_T2D`, `GENERAL_PURPOSE_C3`, `COMPUTE_OPTIMIZED_C2`, `COMPUTE_OPTIMIZED_C2D` and
        `GRAPHICS_OPTIMIZED_G2`
        """
        return pulumi.get(self, "type")

