# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['RouteArgs', 'Route']

@pulumi.input_type
class RouteArgs:
    def __init__(__self__, *,
                 dest_range: pulumi.Input[str],
                 network: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 next_hop_gateway: Optional[pulumi.Input[str]] = None,
                 next_hop_ilb: Optional[pulumi.Input[str]] = None,
                 next_hop_instance: Optional[pulumi.Input[str]] = None,
                 next_hop_instance_zone: Optional[pulumi.Input[str]] = None,
                 next_hop_ip: Optional[pulumi.Input[str]] = None,
                 next_hop_vpn_tunnel: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Route resource.
        :param pulumi.Input[str] dest_range: The destination range of outgoing packets that this route applies to.
               Only IPv4 is supported.
        :param pulumi.Input[str] network: The network that this route applies to.
               
               
               - - -
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property
               when you create the resource.
        :param pulumi.Input[str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035.  Specifically, the name must be 1-63 characters long and
               match the regular expression `a-z?` which means
               the first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the
               last character, which cannot be a dash.
        :param pulumi.Input[str] next_hop_gateway: URL to a gateway that should handle matching packets.
               Currently, you can only specify the internet gateway, using a full or
               partial valid URL:
               * `https://www.googleapis.com/compute/v1/projects/project/global/gateways/default-internet-gateway`
               * `projects/project/global/gateways/default-internet-gateway`
               * `global/gateways/default-internet-gateway`
               * The string `default-internet-gateway`.
        :param pulumi.Input[str] next_hop_ilb: The IP address or URL to a forwarding rule of type
               loadBalancingScheme=INTERNAL that should handle matching
               packets.
               With the GA provider you can only specify the forwarding
               rule as a partial or full URL. For example, the following
               are all valid values:
               * 10.128.0.56
               * https://www.googleapis.com/compute/v1/projects/project/regions/region/forwardingRules/forwardingRule
               * regions/region/forwardingRules/forwardingRule
               When the beta provider, you can also specify the IP address
               of a forwarding rule from the same VPC or any peered VPC.
               Note that this can only be used when the destinationRange is
               a public (non-RFC 1918) IP CIDR range.
        :param pulumi.Input[str] next_hop_instance: URL to an instance that should handle matching packets.
               You can specify this as a full or partial URL. For example:
               * `https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/instance`
               * `projects/project/zones/zone/instances/instance`
               * `zones/zone/instances/instance`
               * Just the instance name, with the zone in `next_hop_instance_zone`.
        :param pulumi.Input[str] next_hop_instance_zone: (Optional when `next_hop_instance` is
               specified)  The zone of the instance specified in
               `next_hop_instance`.  Omit if `next_hop_instance` is specified as
               a URL.
        :param pulumi.Input[str] next_hop_ip: Network IP address of an instance that should handle matching packets.
        :param pulumi.Input[str] next_hop_vpn_tunnel: URL to a VpnTunnel that should handle matching packets.
        :param pulumi.Input[int] priority: The priority of this route. Priority is used to break ties in cases
               where there is more than one matching route of equal prefix length.
               In the case of two routes with equal prefix length, the one with the
               lowest-numbered priority value wins.
               Default value is 1000. Valid range is 0 through 65535.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of instance tags to which this route applies.
        """
        pulumi.set(__self__, "dest_range", dest_range)
        pulumi.set(__self__, "network", network)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if next_hop_gateway is not None:
            pulumi.set(__self__, "next_hop_gateway", next_hop_gateway)
        if next_hop_ilb is not None:
            pulumi.set(__self__, "next_hop_ilb", next_hop_ilb)
        if next_hop_instance is not None:
            pulumi.set(__self__, "next_hop_instance", next_hop_instance)
        if next_hop_instance_zone is not None:
            pulumi.set(__self__, "next_hop_instance_zone", next_hop_instance_zone)
        if next_hop_ip is not None:
            pulumi.set(__self__, "next_hop_ip", next_hop_ip)
        if next_hop_vpn_tunnel is not None:
            pulumi.set(__self__, "next_hop_vpn_tunnel", next_hop_vpn_tunnel)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="destRange")
    def dest_range(self) -> pulumi.Input[str]:
        """
        The destination range of outgoing packets that this route applies to.
        Only IPv4 is supported.
        """
        return pulumi.get(self, "dest_range")

    @dest_range.setter
    def dest_range(self, value: pulumi.Input[str]):
        pulumi.set(self, "dest_range", value)

    @property
    @pulumi.getter
    def network(self) -> pulumi.Input[str]:
        """
        The network that this route applies to.


        - - -
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: pulumi.Input[str]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource. Provide this property
        when you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035.  Specifically, the name must be 1-63 characters long and
        match the regular expression `a-z?` which means
        the first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the
        last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nextHopGateway")
    def next_hop_gateway(self) -> Optional[pulumi.Input[str]]:
        """
        URL to a gateway that should handle matching packets.
        Currently, you can only specify the internet gateway, using a full or
        partial valid URL:
        * `https://www.googleapis.com/compute/v1/projects/project/global/gateways/default-internet-gateway`
        * `projects/project/global/gateways/default-internet-gateway`
        * `global/gateways/default-internet-gateway`
        * The string `default-internet-gateway`.
        """
        return pulumi.get(self, "next_hop_gateway")

    @next_hop_gateway.setter
    def next_hop_gateway(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "next_hop_gateway", value)

    @property
    @pulumi.getter(name="nextHopIlb")
    def next_hop_ilb(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address or URL to a forwarding rule of type
        loadBalancingScheme=INTERNAL that should handle matching
        packets.
        With the GA provider you can only specify the forwarding
        rule as a partial or full URL. For example, the following
        are all valid values:
        * 10.128.0.56
        * https://www.googleapis.com/compute/v1/projects/project/regions/region/forwardingRules/forwardingRule
        * regions/region/forwardingRules/forwardingRule
        When the beta provider, you can also specify the IP address
        of a forwarding rule from the same VPC or any peered VPC.
        Note that this can only be used when the destinationRange is
        a public (non-RFC 1918) IP CIDR range.
        """
        return pulumi.get(self, "next_hop_ilb")

    @next_hop_ilb.setter
    def next_hop_ilb(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "next_hop_ilb", value)

    @property
    @pulumi.getter(name="nextHopInstance")
    def next_hop_instance(self) -> Optional[pulumi.Input[str]]:
        """
        URL to an instance that should handle matching packets.
        You can specify this as a full or partial URL. For example:
        * `https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/instance`
        * `projects/project/zones/zone/instances/instance`
        * `zones/zone/instances/instance`
        * Just the instance name, with the zone in `next_hop_instance_zone`.
        """
        return pulumi.get(self, "next_hop_instance")

    @next_hop_instance.setter
    def next_hop_instance(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "next_hop_instance", value)

    @property
    @pulumi.getter(name="nextHopInstanceZone")
    def next_hop_instance_zone(self) -> Optional[pulumi.Input[str]]:
        """
        (Optional when `next_hop_instance` is
        specified)  The zone of the instance specified in
        `next_hop_instance`.  Omit if `next_hop_instance` is specified as
        a URL.
        """
        return pulumi.get(self, "next_hop_instance_zone")

    @next_hop_instance_zone.setter
    def next_hop_instance_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "next_hop_instance_zone", value)

    @property
    @pulumi.getter(name="nextHopIp")
    def next_hop_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Network IP address of an instance that should handle matching packets.
        """
        return pulumi.get(self, "next_hop_ip")

    @next_hop_ip.setter
    def next_hop_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "next_hop_ip", value)

    @property
    @pulumi.getter(name="nextHopVpnTunnel")
    def next_hop_vpn_tunnel(self) -> Optional[pulumi.Input[str]]:
        """
        URL to a VpnTunnel that should handle matching packets.
        """
        return pulumi.get(self, "next_hop_vpn_tunnel")

    @next_hop_vpn_tunnel.setter
    def next_hop_vpn_tunnel(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "next_hop_vpn_tunnel", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        The priority of this route. Priority is used to break ties in cases
        where there is more than one matching route of equal prefix length.
        In the case of two routes with equal prefix length, the one with the
        lowest-numbered priority value wins.
        Default value is 1000. Valid range is 0 through 65535.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of instance tags to which this route applies.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _RouteState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 dest_range: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 next_hop_gateway: Optional[pulumi.Input[str]] = None,
                 next_hop_ilb: Optional[pulumi.Input[str]] = None,
                 next_hop_instance: Optional[pulumi.Input[str]] = None,
                 next_hop_instance_zone: Optional[pulumi.Input[str]] = None,
                 next_hop_ip: Optional[pulumi.Input[str]] = None,
                 next_hop_network: Optional[pulumi.Input[str]] = None,
                 next_hop_vpn_tunnel: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering Route resources.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property
               when you create the resource.
        :param pulumi.Input[str] dest_range: The destination range of outgoing packets that this route applies to.
               Only IPv4 is supported.
        :param pulumi.Input[str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035.  Specifically, the name must be 1-63 characters long and
               match the regular expression `a-z?` which means
               the first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the
               last character, which cannot be a dash.
        :param pulumi.Input[str] network: The network that this route applies to.
               
               
               - - -
        :param pulumi.Input[str] next_hop_gateway: URL to a gateway that should handle matching packets.
               Currently, you can only specify the internet gateway, using a full or
               partial valid URL:
               * `https://www.googleapis.com/compute/v1/projects/project/global/gateways/default-internet-gateway`
               * `projects/project/global/gateways/default-internet-gateway`
               * `global/gateways/default-internet-gateway`
               * The string `default-internet-gateway`.
        :param pulumi.Input[str] next_hop_ilb: The IP address or URL to a forwarding rule of type
               loadBalancingScheme=INTERNAL that should handle matching
               packets.
               With the GA provider you can only specify the forwarding
               rule as a partial or full URL. For example, the following
               are all valid values:
               * 10.128.0.56
               * https://www.googleapis.com/compute/v1/projects/project/regions/region/forwardingRules/forwardingRule
               * regions/region/forwardingRules/forwardingRule
               When the beta provider, you can also specify the IP address
               of a forwarding rule from the same VPC or any peered VPC.
               Note that this can only be used when the destinationRange is
               a public (non-RFC 1918) IP CIDR range.
        :param pulumi.Input[str] next_hop_instance: URL to an instance that should handle matching packets.
               You can specify this as a full or partial URL. For example:
               * `https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/instance`
               * `projects/project/zones/zone/instances/instance`
               * `zones/zone/instances/instance`
               * Just the instance name, with the zone in `next_hop_instance_zone`.
        :param pulumi.Input[str] next_hop_instance_zone: (Optional when `next_hop_instance` is
               specified)  The zone of the instance specified in
               `next_hop_instance`.  Omit if `next_hop_instance` is specified as
               a URL.
        :param pulumi.Input[str] next_hop_ip: Network IP address of an instance that should handle matching packets.
        :param pulumi.Input[str] next_hop_network: URL to a Network that should handle matching packets.
        :param pulumi.Input[str] next_hop_vpn_tunnel: URL to a VpnTunnel that should handle matching packets.
        :param pulumi.Input[int] priority: The priority of this route. Priority is used to break ties in cases
               where there is more than one matching route of equal prefix length.
               In the case of two routes with equal prefix length, the one with the
               lowest-numbered priority value wins.
               Default value is 1000. Valid range is 0 through 65535.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] self_link: The URI of the created resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of instance tags to which this route applies.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dest_range is not None:
            pulumi.set(__self__, "dest_range", dest_range)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if next_hop_gateway is not None:
            pulumi.set(__self__, "next_hop_gateway", next_hop_gateway)
        if next_hop_ilb is not None:
            pulumi.set(__self__, "next_hop_ilb", next_hop_ilb)
        if next_hop_instance is not None:
            pulumi.set(__self__, "next_hop_instance", next_hop_instance)
        if next_hop_instance_zone is not None:
            pulumi.set(__self__, "next_hop_instance_zone", next_hop_instance_zone)
        if next_hop_ip is not None:
            pulumi.set(__self__, "next_hop_ip", next_hop_ip)
        if next_hop_network is not None:
            pulumi.set(__self__, "next_hop_network", next_hop_network)
        if next_hop_vpn_tunnel is not None:
            pulumi.set(__self__, "next_hop_vpn_tunnel", next_hop_vpn_tunnel)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource. Provide this property
        when you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="destRange")
    def dest_range(self) -> Optional[pulumi.Input[str]]:
        """
        The destination range of outgoing packets that this route applies to.
        Only IPv4 is supported.
        """
        return pulumi.get(self, "dest_range")

    @dest_range.setter
    def dest_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dest_range", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035.  Specifically, the name must be 1-63 characters long and
        match the regular expression `a-z?` which means
        the first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the
        last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        The network that this route applies to.


        - - -
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="nextHopGateway")
    def next_hop_gateway(self) -> Optional[pulumi.Input[str]]:
        """
        URL to a gateway that should handle matching packets.
        Currently, you can only specify the internet gateway, using a full or
        partial valid URL:
        * `https://www.googleapis.com/compute/v1/projects/project/global/gateways/default-internet-gateway`
        * `projects/project/global/gateways/default-internet-gateway`
        * `global/gateways/default-internet-gateway`
        * The string `default-internet-gateway`.
        """
        return pulumi.get(self, "next_hop_gateway")

    @next_hop_gateway.setter
    def next_hop_gateway(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "next_hop_gateway", value)

    @property
    @pulumi.getter(name="nextHopIlb")
    def next_hop_ilb(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address or URL to a forwarding rule of type
        loadBalancingScheme=INTERNAL that should handle matching
        packets.
        With the GA provider you can only specify the forwarding
        rule as a partial or full URL. For example, the following
        are all valid values:
        * 10.128.0.56
        * https://www.googleapis.com/compute/v1/projects/project/regions/region/forwardingRules/forwardingRule
        * regions/region/forwardingRules/forwardingRule
        When the beta provider, you can also specify the IP address
        of a forwarding rule from the same VPC or any peered VPC.
        Note that this can only be used when the destinationRange is
        a public (non-RFC 1918) IP CIDR range.
        """
        return pulumi.get(self, "next_hop_ilb")

    @next_hop_ilb.setter
    def next_hop_ilb(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "next_hop_ilb", value)

    @property
    @pulumi.getter(name="nextHopInstance")
    def next_hop_instance(self) -> Optional[pulumi.Input[str]]:
        """
        URL to an instance that should handle matching packets.
        You can specify this as a full or partial URL. For example:
        * `https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/instance`
        * `projects/project/zones/zone/instances/instance`
        * `zones/zone/instances/instance`
        * Just the instance name, with the zone in `next_hop_instance_zone`.
        """
        return pulumi.get(self, "next_hop_instance")

    @next_hop_instance.setter
    def next_hop_instance(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "next_hop_instance", value)

    @property
    @pulumi.getter(name="nextHopInstanceZone")
    def next_hop_instance_zone(self) -> Optional[pulumi.Input[str]]:
        """
        (Optional when `next_hop_instance` is
        specified)  The zone of the instance specified in
        `next_hop_instance`.  Omit if `next_hop_instance` is specified as
        a URL.
        """
        return pulumi.get(self, "next_hop_instance_zone")

    @next_hop_instance_zone.setter
    def next_hop_instance_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "next_hop_instance_zone", value)

    @property
    @pulumi.getter(name="nextHopIp")
    def next_hop_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Network IP address of an instance that should handle matching packets.
        """
        return pulumi.get(self, "next_hop_ip")

    @next_hop_ip.setter
    def next_hop_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "next_hop_ip", value)

    @property
    @pulumi.getter(name="nextHopNetwork")
    def next_hop_network(self) -> Optional[pulumi.Input[str]]:
        """
        URL to a Network that should handle matching packets.
        """
        return pulumi.get(self, "next_hop_network")

    @next_hop_network.setter
    def next_hop_network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "next_hop_network", value)

    @property
    @pulumi.getter(name="nextHopVpnTunnel")
    def next_hop_vpn_tunnel(self) -> Optional[pulumi.Input[str]]:
        """
        URL to a VpnTunnel that should handle matching packets.
        """
        return pulumi.get(self, "next_hop_vpn_tunnel")

    @next_hop_vpn_tunnel.setter
    def next_hop_vpn_tunnel(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "next_hop_vpn_tunnel", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        The priority of this route. Priority is used to break ties in cases
        where there is more than one matching route of equal prefix length.
        In the case of two routes with equal prefix length, the one with the
        lowest-numbered priority value wins.
        Default value is 1000. Valid range is 0 through 65535.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of instance tags to which this route applies.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


class Route(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dest_range: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 next_hop_gateway: Optional[pulumi.Input[str]] = None,
                 next_hop_ilb: Optional[pulumi.Input[str]] = None,
                 next_hop_instance: Optional[pulumi.Input[str]] = None,
                 next_hop_instance_zone: Optional[pulumi.Input[str]] = None,
                 next_hop_ip: Optional[pulumi.Input[str]] = None,
                 next_hop_vpn_tunnel: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Represents a Route resource.

        A route is a rule that specifies how certain packets should be handled by
        the virtual network. Routes are associated with virtual machines by tag,
        and the set of routes for a particular virtual machine is called its
        routing table. For each packet leaving a virtual machine, the system
        searches that virtual machine's routing table for a single best matching
        route.

        Routes match packets by destination IP address, preferring smaller or more
        specific ranges over larger ones. If there is a tie, the system selects
        the route with the smallest priority value. If there is still a tie, it
        uses the layer three and four packet headers to select just one of the
        remaining matching routes. The packet is then forwarded as specified by
        the next_hop field of the winning route -- either to another virtual
        machine destination, a virtual machine gateway or a Compute
        Engine-operated gateway. Packets that do not match any route in the
        sending virtual machine's routing table will be dropped.

        A Route resource must have exactly one specification of either
        nextHopGateway, nextHopInstance, nextHopIp, nextHopVpnTunnel, or
        nextHopIlb.

        To get more information about Route, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/routes)
        * How-to Guides
            * [Using Routes](https://cloud.google.com/vpc/docs/using-routes)

        ## Example Usage
        ### Route Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_network = gcp.compute.Network("defaultNetwork")
        default_route = gcp.compute.Route("defaultRoute",
            dest_range="15.0.0.0/24",
            network=default_network.name,
            next_hop_ip="10.132.1.5",
            priority=100)
        ```

        ## Import

        Route can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:compute/route:Route default projects/{{project}}/global/routes/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/route:Route default {{project}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/route:Route default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property
               when you create the resource.
        :param pulumi.Input[str] dest_range: The destination range of outgoing packets that this route applies to.
               Only IPv4 is supported.
        :param pulumi.Input[str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035.  Specifically, the name must be 1-63 characters long and
               match the regular expression `a-z?` which means
               the first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the
               last character, which cannot be a dash.
        :param pulumi.Input[str] network: The network that this route applies to.
               
               
               - - -
        :param pulumi.Input[str] next_hop_gateway: URL to a gateway that should handle matching packets.
               Currently, you can only specify the internet gateway, using a full or
               partial valid URL:
               * `https://www.googleapis.com/compute/v1/projects/project/global/gateways/default-internet-gateway`
               * `projects/project/global/gateways/default-internet-gateway`
               * `global/gateways/default-internet-gateway`
               * The string `default-internet-gateway`.
        :param pulumi.Input[str] next_hop_ilb: The IP address or URL to a forwarding rule of type
               loadBalancingScheme=INTERNAL that should handle matching
               packets.
               With the GA provider you can only specify the forwarding
               rule as a partial or full URL. For example, the following
               are all valid values:
               * 10.128.0.56
               * https://www.googleapis.com/compute/v1/projects/project/regions/region/forwardingRules/forwardingRule
               * regions/region/forwardingRules/forwardingRule
               When the beta provider, you can also specify the IP address
               of a forwarding rule from the same VPC or any peered VPC.
               Note that this can only be used when the destinationRange is
               a public (non-RFC 1918) IP CIDR range.
        :param pulumi.Input[str] next_hop_instance: URL to an instance that should handle matching packets.
               You can specify this as a full or partial URL. For example:
               * `https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/instance`
               * `projects/project/zones/zone/instances/instance`
               * `zones/zone/instances/instance`
               * Just the instance name, with the zone in `next_hop_instance_zone`.
        :param pulumi.Input[str] next_hop_instance_zone: (Optional when `next_hop_instance` is
               specified)  The zone of the instance specified in
               `next_hop_instance`.  Omit if `next_hop_instance` is specified as
               a URL.
        :param pulumi.Input[str] next_hop_ip: Network IP address of an instance that should handle matching packets.
        :param pulumi.Input[str] next_hop_vpn_tunnel: URL to a VpnTunnel that should handle matching packets.
        :param pulumi.Input[int] priority: The priority of this route. Priority is used to break ties in cases
               where there is more than one matching route of equal prefix length.
               In the case of two routes with equal prefix length, the one with the
               lowest-numbered priority value wins.
               Default value is 1000. Valid range is 0 through 65535.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of instance tags to which this route applies.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RouteArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a Route resource.

        A route is a rule that specifies how certain packets should be handled by
        the virtual network. Routes are associated with virtual machines by tag,
        and the set of routes for a particular virtual machine is called its
        routing table. For each packet leaving a virtual machine, the system
        searches that virtual machine's routing table for a single best matching
        route.

        Routes match packets by destination IP address, preferring smaller or more
        specific ranges over larger ones. If there is a tie, the system selects
        the route with the smallest priority value. If there is still a tie, it
        uses the layer three and four packet headers to select just one of the
        remaining matching routes. The packet is then forwarded as specified by
        the next_hop field of the winning route -- either to another virtual
        machine destination, a virtual machine gateway or a Compute
        Engine-operated gateway. Packets that do not match any route in the
        sending virtual machine's routing table will be dropped.

        A Route resource must have exactly one specification of either
        nextHopGateway, nextHopInstance, nextHopIp, nextHopVpnTunnel, or
        nextHopIlb.

        To get more information about Route, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/routes)
        * How-to Guides
            * [Using Routes](https://cloud.google.com/vpc/docs/using-routes)

        ## Example Usage
        ### Route Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_network = gcp.compute.Network("defaultNetwork")
        default_route = gcp.compute.Route("defaultRoute",
            dest_range="15.0.0.0/24",
            network=default_network.name,
            next_hop_ip="10.132.1.5",
            priority=100)
        ```

        ## Import

        Route can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:compute/route:Route default projects/{{project}}/global/routes/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/route:Route default {{project}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/route:Route default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param RouteArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RouteArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dest_range: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 next_hop_gateway: Optional[pulumi.Input[str]] = None,
                 next_hop_ilb: Optional[pulumi.Input[str]] = None,
                 next_hop_instance: Optional[pulumi.Input[str]] = None,
                 next_hop_instance_zone: Optional[pulumi.Input[str]] = None,
                 next_hop_ip: Optional[pulumi.Input[str]] = None,
                 next_hop_vpn_tunnel: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RouteArgs.__new__(RouteArgs)

            __props__.__dict__["description"] = description
            if dest_range is None and not opts.urn:
                raise TypeError("Missing required property 'dest_range'")
            __props__.__dict__["dest_range"] = dest_range
            __props__.__dict__["name"] = name
            if network is None and not opts.urn:
                raise TypeError("Missing required property 'network'")
            __props__.__dict__["network"] = network
            __props__.__dict__["next_hop_gateway"] = next_hop_gateway
            __props__.__dict__["next_hop_ilb"] = next_hop_ilb
            __props__.__dict__["next_hop_instance"] = next_hop_instance
            __props__.__dict__["next_hop_instance_zone"] = next_hop_instance_zone
            __props__.__dict__["next_hop_ip"] = next_hop_ip
            __props__.__dict__["next_hop_vpn_tunnel"] = next_hop_vpn_tunnel
            __props__.__dict__["priority"] = priority
            __props__.__dict__["project"] = project
            __props__.__dict__["tags"] = tags
            __props__.__dict__["next_hop_network"] = None
            __props__.__dict__["self_link"] = None
        super(Route, __self__).__init__(
            'gcp:compute/route:Route',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            dest_range: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network: Optional[pulumi.Input[str]] = None,
            next_hop_gateway: Optional[pulumi.Input[str]] = None,
            next_hop_ilb: Optional[pulumi.Input[str]] = None,
            next_hop_instance: Optional[pulumi.Input[str]] = None,
            next_hop_instance_zone: Optional[pulumi.Input[str]] = None,
            next_hop_ip: Optional[pulumi.Input[str]] = None,
            next_hop_network: Optional[pulumi.Input[str]] = None,
            next_hop_vpn_tunnel: Optional[pulumi.Input[str]] = None,
            priority: Optional[pulumi.Input[int]] = None,
            project: Optional[pulumi.Input[str]] = None,
            self_link: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'Route':
        """
        Get an existing Route resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property
               when you create the resource.
        :param pulumi.Input[str] dest_range: The destination range of outgoing packets that this route applies to.
               Only IPv4 is supported.
        :param pulumi.Input[str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035.  Specifically, the name must be 1-63 characters long and
               match the regular expression `a-z?` which means
               the first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the
               last character, which cannot be a dash.
        :param pulumi.Input[str] network: The network that this route applies to.
               
               
               - - -
        :param pulumi.Input[str] next_hop_gateway: URL to a gateway that should handle matching packets.
               Currently, you can only specify the internet gateway, using a full or
               partial valid URL:
               * `https://www.googleapis.com/compute/v1/projects/project/global/gateways/default-internet-gateway`
               * `projects/project/global/gateways/default-internet-gateway`
               * `global/gateways/default-internet-gateway`
               * The string `default-internet-gateway`.
        :param pulumi.Input[str] next_hop_ilb: The IP address or URL to a forwarding rule of type
               loadBalancingScheme=INTERNAL that should handle matching
               packets.
               With the GA provider you can only specify the forwarding
               rule as a partial or full URL. For example, the following
               are all valid values:
               * 10.128.0.56
               * https://www.googleapis.com/compute/v1/projects/project/regions/region/forwardingRules/forwardingRule
               * regions/region/forwardingRules/forwardingRule
               When the beta provider, you can also specify the IP address
               of a forwarding rule from the same VPC or any peered VPC.
               Note that this can only be used when the destinationRange is
               a public (non-RFC 1918) IP CIDR range.
        :param pulumi.Input[str] next_hop_instance: URL to an instance that should handle matching packets.
               You can specify this as a full or partial URL. For example:
               * `https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/instance`
               * `projects/project/zones/zone/instances/instance`
               * `zones/zone/instances/instance`
               * Just the instance name, with the zone in `next_hop_instance_zone`.
        :param pulumi.Input[str] next_hop_instance_zone: (Optional when `next_hop_instance` is
               specified)  The zone of the instance specified in
               `next_hop_instance`.  Omit if `next_hop_instance` is specified as
               a URL.
        :param pulumi.Input[str] next_hop_ip: Network IP address of an instance that should handle matching packets.
        :param pulumi.Input[str] next_hop_network: URL to a Network that should handle matching packets.
        :param pulumi.Input[str] next_hop_vpn_tunnel: URL to a VpnTunnel that should handle matching packets.
        :param pulumi.Input[int] priority: The priority of this route. Priority is used to break ties in cases
               where there is more than one matching route of equal prefix length.
               In the case of two routes with equal prefix length, the one with the
               lowest-numbered priority value wins.
               Default value is 1000. Valid range is 0 through 65535.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] self_link: The URI of the created resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of instance tags to which this route applies.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RouteState.__new__(_RouteState)

        __props__.__dict__["description"] = description
        __props__.__dict__["dest_range"] = dest_range
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["next_hop_gateway"] = next_hop_gateway
        __props__.__dict__["next_hop_ilb"] = next_hop_ilb
        __props__.__dict__["next_hop_instance"] = next_hop_instance
        __props__.__dict__["next_hop_instance_zone"] = next_hop_instance_zone
        __props__.__dict__["next_hop_ip"] = next_hop_ip
        __props__.__dict__["next_hop_network"] = next_hop_network
        __props__.__dict__["next_hop_vpn_tunnel"] = next_hop_vpn_tunnel
        __props__.__dict__["priority"] = priority
        __props__.__dict__["project"] = project
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["tags"] = tags
        return Route(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        An optional description of this resource. Provide this property
        when you create the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destRange")
    def dest_range(self) -> pulumi.Output[str]:
        """
        The destination range of outgoing packets that this route applies to.
        Only IPv4 is supported.
        """
        return pulumi.get(self, "dest_range")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035.  Specifically, the name must be 1-63 characters long and
        match the regular expression `a-z?` which means
        the first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the
        last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> pulumi.Output[str]:
        """
        The network that this route applies to.


        - - -
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="nextHopGateway")
    def next_hop_gateway(self) -> pulumi.Output[Optional[str]]:
        """
        URL to a gateway that should handle matching packets.
        Currently, you can only specify the internet gateway, using a full or
        partial valid URL:
        * `https://www.googleapis.com/compute/v1/projects/project/global/gateways/default-internet-gateway`
        * `projects/project/global/gateways/default-internet-gateway`
        * `global/gateways/default-internet-gateway`
        * The string `default-internet-gateway`.
        """
        return pulumi.get(self, "next_hop_gateway")

    @property
    @pulumi.getter(name="nextHopIlb")
    def next_hop_ilb(self) -> pulumi.Output[Optional[str]]:
        """
        The IP address or URL to a forwarding rule of type
        loadBalancingScheme=INTERNAL that should handle matching
        packets.
        With the GA provider you can only specify the forwarding
        rule as a partial or full URL. For example, the following
        are all valid values:
        * 10.128.0.56
        * https://www.googleapis.com/compute/v1/projects/project/regions/region/forwardingRules/forwardingRule
        * regions/region/forwardingRules/forwardingRule
        When the beta provider, you can also specify the IP address
        of a forwarding rule from the same VPC or any peered VPC.
        Note that this can only be used when the destinationRange is
        a public (non-RFC 1918) IP CIDR range.
        """
        return pulumi.get(self, "next_hop_ilb")

    @property
    @pulumi.getter(name="nextHopInstance")
    def next_hop_instance(self) -> pulumi.Output[Optional[str]]:
        """
        URL to an instance that should handle matching packets.
        You can specify this as a full or partial URL. For example:
        * `https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/instance`
        * `projects/project/zones/zone/instances/instance`
        * `zones/zone/instances/instance`
        * Just the instance name, with the zone in `next_hop_instance_zone`.
        """
        return pulumi.get(self, "next_hop_instance")

    @property
    @pulumi.getter(name="nextHopInstanceZone")
    def next_hop_instance_zone(self) -> pulumi.Output[str]:
        """
        (Optional when `next_hop_instance` is
        specified)  The zone of the instance specified in
        `next_hop_instance`.  Omit if `next_hop_instance` is specified as
        a URL.
        """
        return pulumi.get(self, "next_hop_instance_zone")

    @property
    @pulumi.getter(name="nextHopIp")
    def next_hop_ip(self) -> pulumi.Output[str]:
        """
        Network IP address of an instance that should handle matching packets.
        """
        return pulumi.get(self, "next_hop_ip")

    @property
    @pulumi.getter(name="nextHopNetwork")
    def next_hop_network(self) -> pulumi.Output[str]:
        """
        URL to a Network that should handle matching packets.
        """
        return pulumi.get(self, "next_hop_network")

    @property
    @pulumi.getter(name="nextHopVpnTunnel")
    def next_hop_vpn_tunnel(self) -> pulumi.Output[Optional[str]]:
        """
        URL to a VpnTunnel that should handle matching packets.
        """
        return pulumi.get(self, "next_hop_vpn_tunnel")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[Optional[int]]:
        """
        The priority of this route. Priority is used to break ties in cases
        where there is more than one matching route of equal prefix length.
        In the case of two routes with equal prefix length, the one with the
        lowest-numbered priority value wins.
        Default value is 1000. Valid range is 0 through 65535.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of instance tags to which this route applies.
        """
        return pulumi.get(self, "tags")

