# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SecurityPolicyArgs', 'SecurityPolicy']

@pulumi.input_type
class SecurityPolicyArgs:
    def __init__(__self__, *,
                 adaptive_protection_config: Optional[pulumi.Input['SecurityPolicyAdaptiveProtectionConfigArgs']] = None,
                 advanced_options_config: Optional[pulumi.Input['SecurityPolicyAdvancedOptionsConfigArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 recaptcha_options_config: Optional[pulumi.Input['SecurityPolicyRecaptchaOptionsConfigArgs']] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityPolicyRuleArgs']]]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SecurityPolicy resource.
        :param pulumi.Input['SecurityPolicyAdaptiveProtectionConfigArgs'] adaptive_protection_config: Configuration for [Google Cloud Armor Adaptive Protection](https://cloud.google.com/armor/docs/adaptive-protection-overview?hl=en). Structure is documented below.
        :param pulumi.Input['SecurityPolicyAdvancedOptionsConfigArgs'] advanced_options_config: [Advanced Configuration Options](https://cloud.google.com/armor/docs/security-policy-overview#json-parsing).
               Structure is documented below.
        :param pulumi.Input[str] description: An optional description of this security policy. Max size is 2048.
        :param pulumi.Input[str] name: The name of the security policy.
               
               - - -
        :param pulumi.Input[str] project: The project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input['SecurityPolicyRecaptchaOptionsConfigArgs'] recaptcha_options_config: [reCAPTCHA Configuration Options](https://cloud.google.com/armor/docs/configure-security-policies?hl=en#use_a_manual_challenge_to_distinguish_between_human_or_automated_clients). Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['SecurityPolicyRuleArgs']]] rules: The set of rules that belong to this policy. There must always be a default
               rule (rule with priority 2147483647 and match "\\*"). If no rules are provided when creating a
               security policy, a default rule with action "allow" will be added. Structure is documented below.
        :param pulumi.Input[str] type: The type indicates the intended use of the security policy. This field can be set only at resource creation time.
               * CLOUD_ARMOR - Cloud Armor backend security policies can be configured to filter incoming HTTP requests targeting backend services.
               They filter requests before they hit the origin servers.
               * CLOUD_ARMOR_EDGE - Cloud Armor edge security policies can be configured to filter incoming HTTP requests targeting backend services
               (including Cloud CDN-enabled) as well as backend buckets (Cloud Storage).
               They filter requests before the request is served from Google's cache.
               * CLOUD_ARMOR_INTERNAL_SERVICE - Cloud Armor internal service policies can be configured to filter HTTP requests targeting services
               managed by Traffic Director in a service mesh. They filter requests before the request is served from the application.
        """
        if adaptive_protection_config is not None:
            pulumi.set(__self__, "adaptive_protection_config", adaptive_protection_config)
        if advanced_options_config is not None:
            pulumi.set(__self__, "advanced_options_config", advanced_options_config)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if recaptcha_options_config is not None:
            pulumi.set(__self__, "recaptcha_options_config", recaptcha_options_config)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="adaptiveProtectionConfig")
    def adaptive_protection_config(self) -> Optional[pulumi.Input['SecurityPolicyAdaptiveProtectionConfigArgs']]:
        """
        Configuration for [Google Cloud Armor Adaptive Protection](https://cloud.google.com/armor/docs/adaptive-protection-overview?hl=en). Structure is documented below.
        """
        return pulumi.get(self, "adaptive_protection_config")

    @adaptive_protection_config.setter
    def adaptive_protection_config(self, value: Optional[pulumi.Input['SecurityPolicyAdaptiveProtectionConfigArgs']]):
        pulumi.set(self, "adaptive_protection_config", value)

    @property
    @pulumi.getter(name="advancedOptionsConfig")
    def advanced_options_config(self) -> Optional[pulumi.Input['SecurityPolicyAdvancedOptionsConfigArgs']]:
        """
        [Advanced Configuration Options](https://cloud.google.com/armor/docs/security-policy-overview#json-parsing).
        Structure is documented below.
        """
        return pulumi.get(self, "advanced_options_config")

    @advanced_options_config.setter
    def advanced_options_config(self, value: Optional[pulumi.Input['SecurityPolicyAdvancedOptionsConfigArgs']]):
        pulumi.set(self, "advanced_options_config", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this security policy. Max size is 2048.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the security policy.

        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="recaptchaOptionsConfig")
    def recaptcha_options_config(self) -> Optional[pulumi.Input['SecurityPolicyRecaptchaOptionsConfigArgs']]:
        """
        [reCAPTCHA Configuration Options](https://cloud.google.com/armor/docs/configure-security-policies?hl=en#use_a_manual_challenge_to_distinguish_between_human_or_automated_clients). Structure is documented below.
        """
        return pulumi.get(self, "recaptcha_options_config")

    @recaptcha_options_config.setter
    def recaptcha_options_config(self, value: Optional[pulumi.Input['SecurityPolicyRecaptchaOptionsConfigArgs']]):
        pulumi.set(self, "recaptcha_options_config", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityPolicyRuleArgs']]]]:
        """
        The set of rules that belong to this policy. There must always be a default
        rule (rule with priority 2147483647 and match "\\*"). If no rules are provided when creating a
        security policy, a default rule with action "allow" will be added. Structure is documented below.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityPolicyRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type indicates the intended use of the security policy. This field can be set only at resource creation time.
        * CLOUD_ARMOR - Cloud Armor backend security policies can be configured to filter incoming HTTP requests targeting backend services.
        They filter requests before they hit the origin servers.
        * CLOUD_ARMOR_EDGE - Cloud Armor edge security policies can be configured to filter incoming HTTP requests targeting backend services
        (including Cloud CDN-enabled) as well as backend buckets (Cloud Storage).
        They filter requests before the request is served from Google's cache.
        * CLOUD_ARMOR_INTERNAL_SERVICE - Cloud Armor internal service policies can be configured to filter HTTP requests targeting services
        managed by Traffic Director in a service mesh. They filter requests before the request is served from the application.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _SecurityPolicyState:
    def __init__(__self__, *,
                 adaptive_protection_config: Optional[pulumi.Input['SecurityPolicyAdaptiveProtectionConfigArgs']] = None,
                 advanced_options_config: Optional[pulumi.Input['SecurityPolicyAdvancedOptionsConfigArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 fingerprint: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 recaptcha_options_config: Optional[pulumi.Input['SecurityPolicyRecaptchaOptionsConfigArgs']] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityPolicyRuleArgs']]]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SecurityPolicy resources.
        :param pulumi.Input['SecurityPolicyAdaptiveProtectionConfigArgs'] adaptive_protection_config: Configuration for [Google Cloud Armor Adaptive Protection](https://cloud.google.com/armor/docs/adaptive-protection-overview?hl=en). Structure is documented below.
        :param pulumi.Input['SecurityPolicyAdvancedOptionsConfigArgs'] advanced_options_config: [Advanced Configuration Options](https://cloud.google.com/armor/docs/security-policy-overview#json-parsing).
               Structure is documented below.
        :param pulumi.Input[str] description: An optional description of this security policy. Max size is 2048.
        :param pulumi.Input[str] fingerprint: Fingerprint of this resource.
        :param pulumi.Input[str] name: The name of the security policy.
               
               - - -
        :param pulumi.Input[str] project: The project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input['SecurityPolicyRecaptchaOptionsConfigArgs'] recaptcha_options_config: [reCAPTCHA Configuration Options](https://cloud.google.com/armor/docs/configure-security-policies?hl=en#use_a_manual_challenge_to_distinguish_between_human_or_automated_clients). Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['SecurityPolicyRuleArgs']]] rules: The set of rules that belong to this policy. There must always be a default
               rule (rule with priority 2147483647 and match "\\*"). If no rules are provided when creating a
               security policy, a default rule with action "allow" will be added. Structure is documented below.
        :param pulumi.Input[str] self_link: The URI of the created resourc
        :param pulumi.Input[str] type: The type indicates the intended use of the security policy. This field can be set only at resource creation time.
               * CLOUD_ARMOR - Cloud Armor backend security policies can be configured to filter incoming HTTP requests targeting backend services.
               They filter requests before they hit the origin servers.
               * CLOUD_ARMOR_EDGE - Cloud Armor edge security policies can be configured to filter incoming HTTP requests targeting backend services
               (including Cloud CDN-enabled) as well as backend buckets (Cloud Storage).
               They filter requests before the request is served from Google's cache.
               * CLOUD_ARMOR_INTERNAL_SERVICE - Cloud Armor internal service policies can be configured to filter HTTP requests targeting services
               managed by Traffic Director in a service mesh. They filter requests before the request is served from the application.
        """
        if adaptive_protection_config is not None:
            pulumi.set(__self__, "adaptive_protection_config", adaptive_protection_config)
        if advanced_options_config is not None:
            pulumi.set(__self__, "advanced_options_config", advanced_options_config)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if fingerprint is not None:
            pulumi.set(__self__, "fingerprint", fingerprint)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if recaptcha_options_config is not None:
            pulumi.set(__self__, "recaptcha_options_config", recaptcha_options_config)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="adaptiveProtectionConfig")
    def adaptive_protection_config(self) -> Optional[pulumi.Input['SecurityPolicyAdaptiveProtectionConfigArgs']]:
        """
        Configuration for [Google Cloud Armor Adaptive Protection](https://cloud.google.com/armor/docs/adaptive-protection-overview?hl=en). Structure is documented below.
        """
        return pulumi.get(self, "adaptive_protection_config")

    @adaptive_protection_config.setter
    def adaptive_protection_config(self, value: Optional[pulumi.Input['SecurityPolicyAdaptiveProtectionConfigArgs']]):
        pulumi.set(self, "adaptive_protection_config", value)

    @property
    @pulumi.getter(name="advancedOptionsConfig")
    def advanced_options_config(self) -> Optional[pulumi.Input['SecurityPolicyAdvancedOptionsConfigArgs']]:
        """
        [Advanced Configuration Options](https://cloud.google.com/armor/docs/security-policy-overview#json-parsing).
        Structure is documented below.
        """
        return pulumi.get(self, "advanced_options_config")

    @advanced_options_config.setter
    def advanced_options_config(self, value: Optional[pulumi.Input['SecurityPolicyAdvancedOptionsConfigArgs']]):
        pulumi.set(self, "advanced_options_config", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this security policy. Max size is 2048.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def fingerprint(self) -> Optional[pulumi.Input[str]]:
        """
        Fingerprint of this resource.
        """
        return pulumi.get(self, "fingerprint")

    @fingerprint.setter
    def fingerprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fingerprint", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the security policy.

        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="recaptchaOptionsConfig")
    def recaptcha_options_config(self) -> Optional[pulumi.Input['SecurityPolicyRecaptchaOptionsConfigArgs']]:
        """
        [reCAPTCHA Configuration Options](https://cloud.google.com/armor/docs/configure-security-policies?hl=en#use_a_manual_challenge_to_distinguish_between_human_or_automated_clients). Structure is documented below.
        """
        return pulumi.get(self, "recaptcha_options_config")

    @recaptcha_options_config.setter
    def recaptcha_options_config(self, value: Optional[pulumi.Input['SecurityPolicyRecaptchaOptionsConfigArgs']]):
        pulumi.set(self, "recaptcha_options_config", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityPolicyRuleArgs']]]]:
        """
        The set of rules that belong to this policy. There must always be a default
        rule (rule with priority 2147483647 and match "\\*"). If no rules are provided when creating a
        security policy, a default rule with action "allow" will be added. Structure is documented below.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityPolicyRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of the created resourc
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type indicates the intended use of the security policy. This field can be set only at resource creation time.
        * CLOUD_ARMOR - Cloud Armor backend security policies can be configured to filter incoming HTTP requests targeting backend services.
        They filter requests before they hit the origin servers.
        * CLOUD_ARMOR_EDGE - Cloud Armor edge security policies can be configured to filter incoming HTTP requests targeting backend services
        (including Cloud CDN-enabled) as well as backend buckets (Cloud Storage).
        They filter requests before the request is served from Google's cache.
        * CLOUD_ARMOR_INTERNAL_SERVICE - Cloud Armor internal service policies can be configured to filter HTTP requests targeting services
        managed by Traffic Director in a service mesh. They filter requests before the request is served from the application.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class SecurityPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 adaptive_protection_config: Optional[pulumi.Input[pulumi.InputType['SecurityPolicyAdaptiveProtectionConfigArgs']]] = None,
                 advanced_options_config: Optional[pulumi.Input[pulumi.InputType['SecurityPolicyAdvancedOptionsConfigArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 recaptcha_options_config: Optional[pulumi.Input[pulumi.InputType['SecurityPolicyRecaptchaOptionsConfigArgs']]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityPolicyRuleArgs']]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        A Security Policy defines an IP blacklist or whitelist that protects load balanced Google Cloud services by denying or permitting traffic from specified IP ranges. For more information
        see the [official documentation](https://cloud.google.com/armor/docs/configure-security-policies)
        and the [API](https://cloud.google.com/compute/docs/reference/rest/beta/securityPolicies).

        Security Policy is used by google_compute_backend_service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        policy = gcp.compute.SecurityPolicy("policy", rules=[
            gcp.compute.SecurityPolicyRuleArgs(
                action="deny(403)",
                description="Deny access to IPs in 9.9.9.0/24",
                match=gcp.compute.SecurityPolicyRuleMatchArgs(
                    config=gcp.compute.SecurityPolicyRuleMatchConfigArgs(
                        src_ip_ranges=["9.9.9.0/24"],
                    ),
                    versioned_expr="SRC_IPS_V1",
                ),
                priority=1000,
            ),
            gcp.compute.SecurityPolicyRuleArgs(
                action="allow",
                description="default rule",
                match=gcp.compute.SecurityPolicyRuleMatchArgs(
                    config=gcp.compute.SecurityPolicyRuleMatchConfigArgs(
                        src_ip_ranges=["*"],
                    ),
                    versioned_expr="SRC_IPS_V1",
                ),
                priority=2147483647,
            ),
        ])
        ```
        ### With ReCAPTCHA Configuration Options

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.recaptcha.EnterpriseKey("primary",
            display_name="display-name",
            labels={
                "label-one": "value-one",
            },
            project="my-project-name",
            web_settings=gcp.recaptcha.EnterpriseKeyWebSettingsArgs(
                integration_type="INVISIBLE",
                allow_all_domains=True,
                allowed_domains=["localhost"],
            ))
        policy = gcp.compute.SecurityPolicy("policy",
            description="basic security policy",
            type="CLOUD_ARMOR",
            recaptcha_options_config=gcp.compute.SecurityPolicyRecaptchaOptionsConfigArgs(
                redirect_site_key=primary.name,
            ))
        ```
        ### With Header Actions

        ```python
        import pulumi
        import pulumi_gcp as gcp

        policy = gcp.compute.SecurityPolicy("policy", rules=[
            gcp.compute.SecurityPolicyRuleArgs(
                action="allow",
                description="default rule",
                match=gcp.compute.SecurityPolicyRuleMatchArgs(
                    config=gcp.compute.SecurityPolicyRuleMatchConfigArgs(
                        src_ip_ranges=["*"],
                    ),
                    versioned_expr="SRC_IPS_V1",
                ),
                priority=2147483647,
            ),
            gcp.compute.SecurityPolicyRuleArgs(
                action="allow",
                header_action=gcp.compute.SecurityPolicyRuleHeaderActionArgs(
                    request_headers_to_adds=[
                        gcp.compute.SecurityPolicyRuleHeaderActionRequestHeadersToAddArgs(
                            header_name="reCAPTCHA-Warning",
                            header_value="high",
                        ),
                        gcp.compute.SecurityPolicyRuleHeaderActionRequestHeadersToAddArgs(
                            header_name="X-Resource",
                            header_value="test",
                        ),
                    ],
                ),
                match=gcp.compute.SecurityPolicyRuleMatchArgs(
                    expr=gcp.compute.SecurityPolicyRuleMatchExprArgs(
                        expression="request.path.matches(\\"/login.html\\") && token.recaptcha_session.score < 0.2",
                    ),
                ),
                priority=1000,
            ),
        ])
        ```
        ### With EnforceOnKey Value As Empty String
        A scenario example that won't cause any conflict between `enforce_on_key` and `enforce_on_key_configs`, because `enforce_on_key` was specified as an empty string:

        ```python
        import pulumi
        import pulumi_gcp as gcp

        policy = gcp.compute.SecurityPolicy("policy",
            description="throttle rule with enforce_on_key_configs",
            rules=[gcp.compute.SecurityPolicyRuleArgs(
                action="throttle",
                description="default rule",
                match=gcp.compute.SecurityPolicyRuleMatchArgs(
                    config=gcp.compute.SecurityPolicyRuleMatchConfigArgs(
                        src_ip_ranges=["*"],
                    ),
                    versioned_expr="SRC_IPS_V1",
                ),
                priority=2147483647,
                rate_limit_options=gcp.compute.SecurityPolicyRuleRateLimitOptionsArgs(
                    conform_action="allow",
                    enforce_on_key="",
                    enforce_on_key_configs=[gcp.compute.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfigArgs(
                        enforce_on_key_type="IP",
                    )],
                    exceed_action="redirect",
                    exceed_redirect_options=gcp.compute.SecurityPolicyRuleRateLimitOptionsExceedRedirectOptionsArgs(
                        target="<https://www.example.com>",
                        type="EXTERNAL_302",
                    ),
                    rate_limit_threshold=gcp.compute.SecurityPolicyRuleRateLimitOptionsRateLimitThresholdArgs(
                        count=10,
                        interval_sec=60,
                    ),
                ),
            )])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['SecurityPolicyAdaptiveProtectionConfigArgs']] adaptive_protection_config: Configuration for [Google Cloud Armor Adaptive Protection](https://cloud.google.com/armor/docs/adaptive-protection-overview?hl=en). Structure is documented below.
        :param pulumi.Input[pulumi.InputType['SecurityPolicyAdvancedOptionsConfigArgs']] advanced_options_config: [Advanced Configuration Options](https://cloud.google.com/armor/docs/security-policy-overview#json-parsing).
               Structure is documented below.
        :param pulumi.Input[str] description: An optional description of this security policy. Max size is 2048.
        :param pulumi.Input[str] name: The name of the security policy.
               
               - - -
        :param pulumi.Input[str] project: The project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[pulumi.InputType['SecurityPolicyRecaptchaOptionsConfigArgs']] recaptcha_options_config: [reCAPTCHA Configuration Options](https://cloud.google.com/armor/docs/configure-security-policies?hl=en#use_a_manual_challenge_to_distinguish_between_human_or_automated_clients). Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityPolicyRuleArgs']]]] rules: The set of rules that belong to this policy. There must always be a default
               rule (rule with priority 2147483647 and match "\\*"). If no rules are provided when creating a
               security policy, a default rule with action "allow" will be added. Structure is documented below.
        :param pulumi.Input[str] type: The type indicates the intended use of the security policy. This field can be set only at resource creation time.
               * CLOUD_ARMOR - Cloud Armor backend security policies can be configured to filter incoming HTTP requests targeting backend services.
               They filter requests before they hit the origin servers.
               * CLOUD_ARMOR_EDGE - Cloud Armor edge security policies can be configured to filter incoming HTTP requests targeting backend services
               (including Cloud CDN-enabled) as well as backend buckets (Cloud Storage).
               They filter requests before the request is served from Google's cache.
               * CLOUD_ARMOR_INTERNAL_SERVICE - Cloud Armor internal service policies can be configured to filter HTTP requests targeting services
               managed by Traffic Director in a service mesh. They filter requests before the request is served from the application.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SecurityPolicyArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Security Policy defines an IP blacklist or whitelist that protects load balanced Google Cloud services by denying or permitting traffic from specified IP ranges. For more information
        see the [official documentation](https://cloud.google.com/armor/docs/configure-security-policies)
        and the [API](https://cloud.google.com/compute/docs/reference/rest/beta/securityPolicies).

        Security Policy is used by google_compute_backend_service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        policy = gcp.compute.SecurityPolicy("policy", rules=[
            gcp.compute.SecurityPolicyRuleArgs(
                action="deny(403)",
                description="Deny access to IPs in 9.9.9.0/24",
                match=gcp.compute.SecurityPolicyRuleMatchArgs(
                    config=gcp.compute.SecurityPolicyRuleMatchConfigArgs(
                        src_ip_ranges=["9.9.9.0/24"],
                    ),
                    versioned_expr="SRC_IPS_V1",
                ),
                priority=1000,
            ),
            gcp.compute.SecurityPolicyRuleArgs(
                action="allow",
                description="default rule",
                match=gcp.compute.SecurityPolicyRuleMatchArgs(
                    config=gcp.compute.SecurityPolicyRuleMatchConfigArgs(
                        src_ip_ranges=["*"],
                    ),
                    versioned_expr="SRC_IPS_V1",
                ),
                priority=2147483647,
            ),
        ])
        ```
        ### With ReCAPTCHA Configuration Options

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.recaptcha.EnterpriseKey("primary",
            display_name="display-name",
            labels={
                "label-one": "value-one",
            },
            project="my-project-name",
            web_settings=gcp.recaptcha.EnterpriseKeyWebSettingsArgs(
                integration_type="INVISIBLE",
                allow_all_domains=True,
                allowed_domains=["localhost"],
            ))
        policy = gcp.compute.SecurityPolicy("policy",
            description="basic security policy",
            type="CLOUD_ARMOR",
            recaptcha_options_config=gcp.compute.SecurityPolicyRecaptchaOptionsConfigArgs(
                redirect_site_key=primary.name,
            ))
        ```
        ### With Header Actions

        ```python
        import pulumi
        import pulumi_gcp as gcp

        policy = gcp.compute.SecurityPolicy("policy", rules=[
            gcp.compute.SecurityPolicyRuleArgs(
                action="allow",
                description="default rule",
                match=gcp.compute.SecurityPolicyRuleMatchArgs(
                    config=gcp.compute.SecurityPolicyRuleMatchConfigArgs(
                        src_ip_ranges=["*"],
                    ),
                    versioned_expr="SRC_IPS_V1",
                ),
                priority=2147483647,
            ),
            gcp.compute.SecurityPolicyRuleArgs(
                action="allow",
                header_action=gcp.compute.SecurityPolicyRuleHeaderActionArgs(
                    request_headers_to_adds=[
                        gcp.compute.SecurityPolicyRuleHeaderActionRequestHeadersToAddArgs(
                            header_name="reCAPTCHA-Warning",
                            header_value="high",
                        ),
                        gcp.compute.SecurityPolicyRuleHeaderActionRequestHeadersToAddArgs(
                            header_name="X-Resource",
                            header_value="test",
                        ),
                    ],
                ),
                match=gcp.compute.SecurityPolicyRuleMatchArgs(
                    expr=gcp.compute.SecurityPolicyRuleMatchExprArgs(
                        expression="request.path.matches(\\"/login.html\\") && token.recaptcha_session.score < 0.2",
                    ),
                ),
                priority=1000,
            ),
        ])
        ```
        ### With EnforceOnKey Value As Empty String
        A scenario example that won't cause any conflict between `enforce_on_key` and `enforce_on_key_configs`, because `enforce_on_key` was specified as an empty string:

        ```python
        import pulumi
        import pulumi_gcp as gcp

        policy = gcp.compute.SecurityPolicy("policy",
            description="throttle rule with enforce_on_key_configs",
            rules=[gcp.compute.SecurityPolicyRuleArgs(
                action="throttle",
                description="default rule",
                match=gcp.compute.SecurityPolicyRuleMatchArgs(
                    config=gcp.compute.SecurityPolicyRuleMatchConfigArgs(
                        src_ip_ranges=["*"],
                    ),
                    versioned_expr="SRC_IPS_V1",
                ),
                priority=2147483647,
                rate_limit_options=gcp.compute.SecurityPolicyRuleRateLimitOptionsArgs(
                    conform_action="allow",
                    enforce_on_key="",
                    enforce_on_key_configs=[gcp.compute.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfigArgs(
                        enforce_on_key_type="IP",
                    )],
                    exceed_action="redirect",
                    exceed_redirect_options=gcp.compute.SecurityPolicyRuleRateLimitOptionsExceedRedirectOptionsArgs(
                        target="<https://www.example.com>",
                        type="EXTERNAL_302",
                    ),
                    rate_limit_threshold=gcp.compute.SecurityPolicyRuleRateLimitOptionsRateLimitThresholdArgs(
                        count=10,
                        interval_sec=60,
                    ),
                ),
            )])
        ```

        :param str resource_name: The name of the resource.
        :param SecurityPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecurityPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 adaptive_protection_config: Optional[pulumi.Input[pulumi.InputType['SecurityPolicyAdaptiveProtectionConfigArgs']]] = None,
                 advanced_options_config: Optional[pulumi.Input[pulumi.InputType['SecurityPolicyAdvancedOptionsConfigArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 recaptcha_options_config: Optional[pulumi.Input[pulumi.InputType['SecurityPolicyRecaptchaOptionsConfigArgs']]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityPolicyRuleArgs']]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecurityPolicyArgs.__new__(SecurityPolicyArgs)

            __props__.__dict__["adaptive_protection_config"] = adaptive_protection_config
            __props__.__dict__["advanced_options_config"] = advanced_options_config
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["recaptcha_options_config"] = recaptcha_options_config
            __props__.__dict__["rules"] = rules
            __props__.__dict__["type"] = type
            __props__.__dict__["fingerprint"] = None
            __props__.__dict__["self_link"] = None
        super(SecurityPolicy, __self__).__init__(
            'gcp:compute/securityPolicy:SecurityPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            adaptive_protection_config: Optional[pulumi.Input[pulumi.InputType['SecurityPolicyAdaptiveProtectionConfigArgs']]] = None,
            advanced_options_config: Optional[pulumi.Input[pulumi.InputType['SecurityPolicyAdvancedOptionsConfigArgs']]] = None,
            description: Optional[pulumi.Input[str]] = None,
            fingerprint: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            recaptcha_options_config: Optional[pulumi.Input[pulumi.InputType['SecurityPolicyRecaptchaOptionsConfigArgs']]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityPolicyRuleArgs']]]]] = None,
            self_link: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'SecurityPolicy':
        """
        Get an existing SecurityPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['SecurityPolicyAdaptiveProtectionConfigArgs']] adaptive_protection_config: Configuration for [Google Cloud Armor Adaptive Protection](https://cloud.google.com/armor/docs/adaptive-protection-overview?hl=en). Structure is documented below.
        :param pulumi.Input[pulumi.InputType['SecurityPolicyAdvancedOptionsConfigArgs']] advanced_options_config: [Advanced Configuration Options](https://cloud.google.com/armor/docs/security-policy-overview#json-parsing).
               Structure is documented below.
        :param pulumi.Input[str] description: An optional description of this security policy. Max size is 2048.
        :param pulumi.Input[str] fingerprint: Fingerprint of this resource.
        :param pulumi.Input[str] name: The name of the security policy.
               
               - - -
        :param pulumi.Input[str] project: The project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[pulumi.InputType['SecurityPolicyRecaptchaOptionsConfigArgs']] recaptcha_options_config: [reCAPTCHA Configuration Options](https://cloud.google.com/armor/docs/configure-security-policies?hl=en#use_a_manual_challenge_to_distinguish_between_human_or_automated_clients). Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityPolicyRuleArgs']]]] rules: The set of rules that belong to this policy. There must always be a default
               rule (rule with priority 2147483647 and match "\\*"). If no rules are provided when creating a
               security policy, a default rule with action "allow" will be added. Structure is documented below.
        :param pulumi.Input[str] self_link: The URI of the created resourc
        :param pulumi.Input[str] type: The type indicates the intended use of the security policy. This field can be set only at resource creation time.
               * CLOUD_ARMOR - Cloud Armor backend security policies can be configured to filter incoming HTTP requests targeting backend services.
               They filter requests before they hit the origin servers.
               * CLOUD_ARMOR_EDGE - Cloud Armor edge security policies can be configured to filter incoming HTTP requests targeting backend services
               (including Cloud CDN-enabled) as well as backend buckets (Cloud Storage).
               They filter requests before the request is served from Google's cache.
               * CLOUD_ARMOR_INTERNAL_SERVICE - Cloud Armor internal service policies can be configured to filter HTTP requests targeting services
               managed by Traffic Director in a service mesh. They filter requests before the request is served from the application.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecurityPolicyState.__new__(_SecurityPolicyState)

        __props__.__dict__["adaptive_protection_config"] = adaptive_protection_config
        __props__.__dict__["advanced_options_config"] = advanced_options_config
        __props__.__dict__["description"] = description
        __props__.__dict__["fingerprint"] = fingerprint
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["recaptcha_options_config"] = recaptcha_options_config
        __props__.__dict__["rules"] = rules
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["type"] = type
        return SecurityPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="adaptiveProtectionConfig")
    def adaptive_protection_config(self) -> pulumi.Output[Optional['outputs.SecurityPolicyAdaptiveProtectionConfig']]:
        """
        Configuration for [Google Cloud Armor Adaptive Protection](https://cloud.google.com/armor/docs/adaptive-protection-overview?hl=en). Structure is documented below.
        """
        return pulumi.get(self, "adaptive_protection_config")

    @property
    @pulumi.getter(name="advancedOptionsConfig")
    def advanced_options_config(self) -> pulumi.Output['outputs.SecurityPolicyAdvancedOptionsConfig']:
        """
        [Advanced Configuration Options](https://cloud.google.com/armor/docs/security-policy-overview#json-parsing).
        Structure is documented below.
        """
        return pulumi.get(self, "advanced_options_config")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        An optional description of this security policy. Max size is 2048.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def fingerprint(self) -> pulumi.Output[str]:
        """
        Fingerprint of this resource.
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the security policy.

        - - -
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="recaptchaOptionsConfig")
    def recaptcha_options_config(self) -> pulumi.Output[Optional['outputs.SecurityPolicyRecaptchaOptionsConfig']]:
        """
        [reCAPTCHA Configuration Options](https://cloud.google.com/armor/docs/configure-security-policies?hl=en#use_a_manual_challenge_to_distinguish_between_human_or_automated_clients). Structure is documented below.
        """
        return pulumi.get(self, "recaptcha_options_config")

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Sequence['outputs.SecurityPolicyRule']]:
        """
        The set of rules that belong to this policy. There must always be a default
        rule (rule with priority 2147483647 and match "\\*"). If no rules are provided when creating a
        security policy, a default rule with action "allow" will be added. Structure is documented below.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        """
        The URI of the created resourc
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type indicates the intended use of the security policy. This field can be set only at resource creation time.
        * CLOUD_ARMOR - Cloud Armor backend security policies can be configured to filter incoming HTTP requests targeting backend services.
        They filter requests before they hit the origin servers.
        * CLOUD_ARMOR_EDGE - Cloud Armor edge security policies can be configured to filter incoming HTTP requests targeting backend services
        (including Cloud CDN-enabled) as well as backend buckets (Cloud Storage).
        They filter requests before the request is served from Google's cache.
        * CLOUD_ARMOR_INTERNAL_SERVICE - Cloud Armor internal service policies can be configured to filter HTTP requests targeting services
        managed by Traffic Director in a service mesh. They filter requests before the request is served from the application.
        """
        return pulumi.get(self, "type")

