# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['URLMapArgs', 'URLMap']

@pulumi.input_type
class URLMapArgs:
    def __init__(__self__, *,
                 default_route_action: Optional[pulumi.Input['URLMapDefaultRouteActionArgs']] = None,
                 default_service: Optional[pulumi.Input[str]] = None,
                 default_url_redirect: Optional[pulumi.Input['URLMapDefaultUrlRedirectArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 header_action: Optional[pulumi.Input['URLMapHeaderActionArgs']] = None,
                 host_rules: Optional[pulumi.Input[Sequence[pulumi.Input['URLMapHostRuleArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 path_matchers: Optional[pulumi.Input[Sequence[pulumi.Input['URLMapPathMatcherArgs']]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 tests: Optional[pulumi.Input[Sequence[pulumi.Input['URLMapTestArgs']]]] = None):
        """
        The set of arguments for constructing a URLMap resource.
        :param pulumi.Input['URLMapDefaultRouteActionArgs'] default_route_action: defaultRouteAction takes effect when none of the hostRules match. The load balancer performs advanced routing actions
               like URL rewrites, header transformations, etc. prior to forwarding the request to the selected backend.
               If defaultRouteAction specifies any weightedBackendServices, defaultService must not be set. Conversely if defaultService
               is set, defaultRouteAction cannot contain any weightedBackendServices.
               Only one of defaultRouteAction or defaultUrlRedirect must be set.
               Structure is documented below.
        :param pulumi.Input[str] default_service: The backend service or backend bucket to use when none of the given rules match.
        :param pulumi.Input['URLMapDefaultUrlRedirectArgs'] default_url_redirect: When none of the specified hostRules match, the request is redirected to a URL specified
               by defaultUrlRedirect. If defaultUrlRedirect is specified, defaultService or
               defaultRouteAction must not be set.
               Structure is documented below.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when you create
               the resource.
        :param pulumi.Input['URLMapHeaderActionArgs'] header_action: Specifies changes to request and response headers that need to take effect for
               the selected backendService. The headerAction specified here take effect after
               headerAction specified under pathMatcher.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['URLMapHostRuleArgs']]] host_rules: The list of HostRules to use against the URL.
               Structure is documented below.
        :param pulumi.Input[str] name: Name of the resource. Provided by the client when the resource is created. The
               name must be 1-63 characters long, and comply with RFC1035. Specifically, the
               name must be 1-63 characters long and match the regular expression
               `a-z?` which means the first character must be a lowercase
               letter, and all following characters must be a dash, lowercase letter, or digit,
               except the last character, which cannot be a dash.
               
               
               - - -
        :param pulumi.Input[Sequence[pulumi.Input['URLMapPathMatcherArgs']]] path_matchers: The list of named PathMatchers to use against the URL.
               Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input['URLMapTestArgs']]] tests: The list of expected URL mapping tests. Request to update this UrlMap will
               succeed only if all of the test cases pass. You can specify a maximum of 100
               tests per UrlMap.
               Structure is documented below.
        """
        if default_route_action is not None:
            pulumi.set(__self__, "default_route_action", default_route_action)
        if default_service is not None:
            pulumi.set(__self__, "default_service", default_service)
        if default_url_redirect is not None:
            pulumi.set(__self__, "default_url_redirect", default_url_redirect)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if header_action is not None:
            pulumi.set(__self__, "header_action", header_action)
        if host_rules is not None:
            pulumi.set(__self__, "host_rules", host_rules)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path_matchers is not None:
            pulumi.set(__self__, "path_matchers", path_matchers)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if tests is not None:
            pulumi.set(__self__, "tests", tests)

    @property
    @pulumi.getter(name="defaultRouteAction")
    def default_route_action(self) -> Optional[pulumi.Input['URLMapDefaultRouteActionArgs']]:
        """
        defaultRouteAction takes effect when none of the hostRules match. The load balancer performs advanced routing actions
        like URL rewrites, header transformations, etc. prior to forwarding the request to the selected backend.
        If defaultRouteAction specifies any weightedBackendServices, defaultService must not be set. Conversely if defaultService
        is set, defaultRouteAction cannot contain any weightedBackendServices.
        Only one of defaultRouteAction or defaultUrlRedirect must be set.
        Structure is documented below.
        """
        return pulumi.get(self, "default_route_action")

    @default_route_action.setter
    def default_route_action(self, value: Optional[pulumi.Input['URLMapDefaultRouteActionArgs']]):
        pulumi.set(self, "default_route_action", value)

    @property
    @pulumi.getter(name="defaultService")
    def default_service(self) -> Optional[pulumi.Input[str]]:
        """
        The backend service or backend bucket to use when none of the given rules match.
        """
        return pulumi.get(self, "default_service")

    @default_service.setter
    def default_service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_service", value)

    @property
    @pulumi.getter(name="defaultUrlRedirect")
    def default_url_redirect(self) -> Optional[pulumi.Input['URLMapDefaultUrlRedirectArgs']]:
        """
        When none of the specified hostRules match, the request is redirected to a URL specified
        by defaultUrlRedirect. If defaultUrlRedirect is specified, defaultService or
        defaultRouteAction must not be set.
        Structure is documented below.
        """
        return pulumi.get(self, "default_url_redirect")

    @default_url_redirect.setter
    def default_url_redirect(self, value: Optional[pulumi.Input['URLMapDefaultUrlRedirectArgs']]):
        pulumi.set(self, "default_url_redirect", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource. Provide this property when you create
        the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="headerAction")
    def header_action(self) -> Optional[pulumi.Input['URLMapHeaderActionArgs']]:
        """
        Specifies changes to request and response headers that need to take effect for
        the selected backendService. The headerAction specified here take effect after
        headerAction specified under pathMatcher.
        Structure is documented below.
        """
        return pulumi.get(self, "header_action")

    @header_action.setter
    def header_action(self, value: Optional[pulumi.Input['URLMapHeaderActionArgs']]):
        pulumi.set(self, "header_action", value)

    @property
    @pulumi.getter(name="hostRules")
    def host_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['URLMapHostRuleArgs']]]]:
        """
        The list of HostRules to use against the URL.
        Structure is documented below.
        """
        return pulumi.get(self, "host_rules")

    @host_rules.setter
    def host_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['URLMapHostRuleArgs']]]]):
        pulumi.set(self, "host_rules", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource. Provided by the client when the resource is created. The
        name must be 1-63 characters long, and comply with RFC1035. Specifically, the
        name must be 1-63 characters long and match the regular expression
        `a-z?` which means the first character must be a lowercase
        letter, and all following characters must be a dash, lowercase letter, or digit,
        except the last character, which cannot be a dash.


        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pathMatchers")
    def path_matchers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['URLMapPathMatcherArgs']]]]:
        """
        The list of named PathMatchers to use against the URL.
        Structure is documented below.
        """
        return pulumi.get(self, "path_matchers")

    @path_matchers.setter
    def path_matchers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['URLMapPathMatcherArgs']]]]):
        pulumi.set(self, "path_matchers", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def tests(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['URLMapTestArgs']]]]:
        """
        The list of expected URL mapping tests. Request to update this UrlMap will
        succeed only if all of the test cases pass. You can specify a maximum of 100
        tests per UrlMap.
        Structure is documented below.
        """
        return pulumi.get(self, "tests")

    @tests.setter
    def tests(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['URLMapTestArgs']]]]):
        pulumi.set(self, "tests", value)


@pulumi.input_type
class _URLMapState:
    def __init__(__self__, *,
                 creation_timestamp: Optional[pulumi.Input[str]] = None,
                 default_route_action: Optional[pulumi.Input['URLMapDefaultRouteActionArgs']] = None,
                 default_service: Optional[pulumi.Input[str]] = None,
                 default_url_redirect: Optional[pulumi.Input['URLMapDefaultUrlRedirectArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 fingerprint: Optional[pulumi.Input[str]] = None,
                 header_action: Optional[pulumi.Input['URLMapHeaderActionArgs']] = None,
                 host_rules: Optional[pulumi.Input[Sequence[pulumi.Input['URLMapHostRuleArgs']]]] = None,
                 map_id: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 path_matchers: Optional[pulumi.Input[Sequence[pulumi.Input['URLMapPathMatcherArgs']]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 tests: Optional[pulumi.Input[Sequence[pulumi.Input['URLMapTestArgs']]]] = None):
        """
        Input properties used for looking up and filtering URLMap resources.
        :param pulumi.Input[str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input['URLMapDefaultRouteActionArgs'] default_route_action: defaultRouteAction takes effect when none of the hostRules match. The load balancer performs advanced routing actions
               like URL rewrites, header transformations, etc. prior to forwarding the request to the selected backend.
               If defaultRouteAction specifies any weightedBackendServices, defaultService must not be set. Conversely if defaultService
               is set, defaultRouteAction cannot contain any weightedBackendServices.
               Only one of defaultRouteAction or defaultUrlRedirect must be set.
               Structure is documented below.
        :param pulumi.Input[str] default_service: The backend service or backend bucket to use when none of the given rules match.
        :param pulumi.Input['URLMapDefaultUrlRedirectArgs'] default_url_redirect: When none of the specified hostRules match, the request is redirected to a URL specified
               by defaultUrlRedirect. If defaultUrlRedirect is specified, defaultService or
               defaultRouteAction must not be set.
               Structure is documented below.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when you create
               the resource.
        :param pulumi.Input[str] fingerprint: Fingerprint of this resource. A hash of the contents stored in this object. This
               field is used in optimistic locking.
        :param pulumi.Input['URLMapHeaderActionArgs'] header_action: Specifies changes to request and response headers that need to take effect for
               the selected backendService. The headerAction specified here take effect after
               headerAction specified under pathMatcher.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['URLMapHostRuleArgs']]] host_rules: The list of HostRules to use against the URL.
               Structure is documented below.
        :param pulumi.Input[int] map_id: The unique identifier for the resource.
        :param pulumi.Input[str] name: Name of the resource. Provided by the client when the resource is created. The
               name must be 1-63 characters long, and comply with RFC1035. Specifically, the
               name must be 1-63 characters long and match the regular expression
               `a-z?` which means the first character must be a lowercase
               letter, and all following characters must be a dash, lowercase letter, or digit,
               except the last character, which cannot be a dash.
               
               
               - - -
        :param pulumi.Input[Sequence[pulumi.Input['URLMapPathMatcherArgs']]] path_matchers: The list of named PathMatchers to use against the URL.
               Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] self_link: The URI of the created resource.
        :param pulumi.Input[Sequence[pulumi.Input['URLMapTestArgs']]] tests: The list of expected URL mapping tests. Request to update this UrlMap will
               succeed only if all of the test cases pass. You can specify a maximum of 100
               tests per UrlMap.
               Structure is documented below.
        """
        if creation_timestamp is not None:
            pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if default_route_action is not None:
            pulumi.set(__self__, "default_route_action", default_route_action)
        if default_service is not None:
            pulumi.set(__self__, "default_service", default_service)
        if default_url_redirect is not None:
            pulumi.set(__self__, "default_url_redirect", default_url_redirect)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if fingerprint is not None:
            pulumi.set(__self__, "fingerprint", fingerprint)
        if header_action is not None:
            pulumi.set(__self__, "header_action", header_action)
        if host_rules is not None:
            pulumi.set(__self__, "host_rules", host_rules)
        if map_id is not None:
            pulumi.set(__self__, "map_id", map_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path_matchers is not None:
            pulumi.set(__self__, "path_matchers", path_matchers)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if tests is not None:
            pulumi.set(__self__, "tests", tests)

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> Optional[pulumi.Input[str]]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @creation_timestamp.setter
    def creation_timestamp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_timestamp", value)

    @property
    @pulumi.getter(name="defaultRouteAction")
    def default_route_action(self) -> Optional[pulumi.Input['URLMapDefaultRouteActionArgs']]:
        """
        defaultRouteAction takes effect when none of the hostRules match. The load balancer performs advanced routing actions
        like URL rewrites, header transformations, etc. prior to forwarding the request to the selected backend.
        If defaultRouteAction specifies any weightedBackendServices, defaultService must not be set. Conversely if defaultService
        is set, defaultRouteAction cannot contain any weightedBackendServices.
        Only one of defaultRouteAction or defaultUrlRedirect must be set.
        Structure is documented below.
        """
        return pulumi.get(self, "default_route_action")

    @default_route_action.setter
    def default_route_action(self, value: Optional[pulumi.Input['URLMapDefaultRouteActionArgs']]):
        pulumi.set(self, "default_route_action", value)

    @property
    @pulumi.getter(name="defaultService")
    def default_service(self) -> Optional[pulumi.Input[str]]:
        """
        The backend service or backend bucket to use when none of the given rules match.
        """
        return pulumi.get(self, "default_service")

    @default_service.setter
    def default_service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_service", value)

    @property
    @pulumi.getter(name="defaultUrlRedirect")
    def default_url_redirect(self) -> Optional[pulumi.Input['URLMapDefaultUrlRedirectArgs']]:
        """
        When none of the specified hostRules match, the request is redirected to a URL specified
        by defaultUrlRedirect. If defaultUrlRedirect is specified, defaultService or
        defaultRouteAction must not be set.
        Structure is documented below.
        """
        return pulumi.get(self, "default_url_redirect")

    @default_url_redirect.setter
    def default_url_redirect(self, value: Optional[pulumi.Input['URLMapDefaultUrlRedirectArgs']]):
        pulumi.set(self, "default_url_redirect", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource. Provide this property when you create
        the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def fingerprint(self) -> Optional[pulumi.Input[str]]:
        """
        Fingerprint of this resource. A hash of the contents stored in this object. This
        field is used in optimistic locking.
        """
        return pulumi.get(self, "fingerprint")

    @fingerprint.setter
    def fingerprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fingerprint", value)

    @property
    @pulumi.getter(name="headerAction")
    def header_action(self) -> Optional[pulumi.Input['URLMapHeaderActionArgs']]:
        """
        Specifies changes to request and response headers that need to take effect for
        the selected backendService. The headerAction specified here take effect after
        headerAction specified under pathMatcher.
        Structure is documented below.
        """
        return pulumi.get(self, "header_action")

    @header_action.setter
    def header_action(self, value: Optional[pulumi.Input['URLMapHeaderActionArgs']]):
        pulumi.set(self, "header_action", value)

    @property
    @pulumi.getter(name="hostRules")
    def host_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['URLMapHostRuleArgs']]]]:
        """
        The list of HostRules to use against the URL.
        Structure is documented below.
        """
        return pulumi.get(self, "host_rules")

    @host_rules.setter
    def host_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['URLMapHostRuleArgs']]]]):
        pulumi.set(self, "host_rules", value)

    @property
    @pulumi.getter(name="mapId")
    def map_id(self) -> Optional[pulumi.Input[int]]:
        """
        The unique identifier for the resource.
        """
        return pulumi.get(self, "map_id")

    @map_id.setter
    def map_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "map_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource. Provided by the client when the resource is created. The
        name must be 1-63 characters long, and comply with RFC1035. Specifically, the
        name must be 1-63 characters long and match the regular expression
        `a-z?` which means the first character must be a lowercase
        letter, and all following characters must be a dash, lowercase letter, or digit,
        except the last character, which cannot be a dash.


        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pathMatchers")
    def path_matchers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['URLMapPathMatcherArgs']]]]:
        """
        The list of named PathMatchers to use against the URL.
        Structure is documented below.
        """
        return pulumi.get(self, "path_matchers")

    @path_matchers.setter
    def path_matchers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['URLMapPathMatcherArgs']]]]):
        pulumi.set(self, "path_matchers", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter
    def tests(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['URLMapTestArgs']]]]:
        """
        The list of expected URL mapping tests. Request to update this UrlMap will
        succeed only if all of the test cases pass. You can specify a maximum of 100
        tests per UrlMap.
        Structure is documented below.
        """
        return pulumi.get(self, "tests")

    @tests.setter
    def tests(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['URLMapTestArgs']]]]):
        pulumi.set(self, "tests", value)


class URLMap(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_route_action: Optional[pulumi.Input[pulumi.InputType['URLMapDefaultRouteActionArgs']]] = None,
                 default_service: Optional[pulumi.Input[str]] = None,
                 default_url_redirect: Optional[pulumi.Input[pulumi.InputType['URLMapDefaultUrlRedirectArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 header_action: Optional[pulumi.Input[pulumi.InputType['URLMapHeaderActionArgs']]] = None,
                 host_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['URLMapHostRuleArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 path_matchers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['URLMapPathMatcherArgs']]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 tests: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['URLMapTestArgs']]]]] = None,
                 __props__=None):
        """
        UrlMaps are used to route requests to a backend service based on rules
        that you define for the host and path of an incoming URL.

        To get more information about UrlMap, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/urlMaps)

        ## Example Usage

        ## Import

        UrlMap can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:compute/uRLMap:URLMap default projects/{{project}}/global/urlMaps/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/uRLMap:URLMap default {{project}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/uRLMap:URLMap default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['URLMapDefaultRouteActionArgs']] default_route_action: defaultRouteAction takes effect when none of the hostRules match. The load balancer performs advanced routing actions
               like URL rewrites, header transformations, etc. prior to forwarding the request to the selected backend.
               If defaultRouteAction specifies any weightedBackendServices, defaultService must not be set. Conversely if defaultService
               is set, defaultRouteAction cannot contain any weightedBackendServices.
               Only one of defaultRouteAction or defaultUrlRedirect must be set.
               Structure is documented below.
        :param pulumi.Input[str] default_service: The backend service or backend bucket to use when none of the given rules match.
        :param pulumi.Input[pulumi.InputType['URLMapDefaultUrlRedirectArgs']] default_url_redirect: When none of the specified hostRules match, the request is redirected to a URL specified
               by defaultUrlRedirect. If defaultUrlRedirect is specified, defaultService or
               defaultRouteAction must not be set.
               Structure is documented below.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when you create
               the resource.
        :param pulumi.Input[pulumi.InputType['URLMapHeaderActionArgs']] header_action: Specifies changes to request and response headers that need to take effect for
               the selected backendService. The headerAction specified here take effect after
               headerAction specified under pathMatcher.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['URLMapHostRuleArgs']]]] host_rules: The list of HostRules to use against the URL.
               Structure is documented below.
        :param pulumi.Input[str] name: Name of the resource. Provided by the client when the resource is created. The
               name must be 1-63 characters long, and comply with RFC1035. Specifically, the
               name must be 1-63 characters long and match the regular expression
               `a-z?` which means the first character must be a lowercase
               letter, and all following characters must be a dash, lowercase letter, or digit,
               except the last character, which cannot be a dash.
               
               
               - - -
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['URLMapPathMatcherArgs']]]] path_matchers: The list of named PathMatchers to use against the URL.
               Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['URLMapTestArgs']]]] tests: The list of expected URL mapping tests. Request to update this UrlMap will
               succeed only if all of the test cases pass. You can specify a maximum of 100
               tests per UrlMap.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[URLMapArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        UrlMaps are used to route requests to a backend service based on rules
        that you define for the host and path of an incoming URL.

        To get more information about UrlMap, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/urlMaps)

        ## Example Usage

        ## Import

        UrlMap can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:compute/uRLMap:URLMap default projects/{{project}}/global/urlMaps/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/uRLMap:URLMap default {{project}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/uRLMap:URLMap default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param URLMapArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(URLMapArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_route_action: Optional[pulumi.Input[pulumi.InputType['URLMapDefaultRouteActionArgs']]] = None,
                 default_service: Optional[pulumi.Input[str]] = None,
                 default_url_redirect: Optional[pulumi.Input[pulumi.InputType['URLMapDefaultUrlRedirectArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 header_action: Optional[pulumi.Input[pulumi.InputType['URLMapHeaderActionArgs']]] = None,
                 host_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['URLMapHostRuleArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 path_matchers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['URLMapPathMatcherArgs']]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 tests: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['URLMapTestArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = URLMapArgs.__new__(URLMapArgs)

            __props__.__dict__["default_route_action"] = default_route_action
            __props__.__dict__["default_service"] = default_service
            __props__.__dict__["default_url_redirect"] = default_url_redirect
            __props__.__dict__["description"] = description
            __props__.__dict__["header_action"] = header_action
            __props__.__dict__["host_rules"] = host_rules
            __props__.__dict__["name"] = name
            __props__.__dict__["path_matchers"] = path_matchers
            __props__.__dict__["project"] = project
            __props__.__dict__["tests"] = tests
            __props__.__dict__["creation_timestamp"] = None
            __props__.__dict__["fingerprint"] = None
            __props__.__dict__["map_id"] = None
            __props__.__dict__["self_link"] = None
        super(URLMap, __self__).__init__(
            'gcp:compute/uRLMap:URLMap',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            creation_timestamp: Optional[pulumi.Input[str]] = None,
            default_route_action: Optional[pulumi.Input[pulumi.InputType['URLMapDefaultRouteActionArgs']]] = None,
            default_service: Optional[pulumi.Input[str]] = None,
            default_url_redirect: Optional[pulumi.Input[pulumi.InputType['URLMapDefaultUrlRedirectArgs']]] = None,
            description: Optional[pulumi.Input[str]] = None,
            fingerprint: Optional[pulumi.Input[str]] = None,
            header_action: Optional[pulumi.Input[pulumi.InputType['URLMapHeaderActionArgs']]] = None,
            host_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['URLMapHostRuleArgs']]]]] = None,
            map_id: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            path_matchers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['URLMapPathMatcherArgs']]]]] = None,
            project: Optional[pulumi.Input[str]] = None,
            self_link: Optional[pulumi.Input[str]] = None,
            tests: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['URLMapTestArgs']]]]] = None) -> 'URLMap':
        """
        Get an existing URLMap resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[pulumi.InputType['URLMapDefaultRouteActionArgs']] default_route_action: defaultRouteAction takes effect when none of the hostRules match. The load balancer performs advanced routing actions
               like URL rewrites, header transformations, etc. prior to forwarding the request to the selected backend.
               If defaultRouteAction specifies any weightedBackendServices, defaultService must not be set. Conversely if defaultService
               is set, defaultRouteAction cannot contain any weightedBackendServices.
               Only one of defaultRouteAction or defaultUrlRedirect must be set.
               Structure is documented below.
        :param pulumi.Input[str] default_service: The backend service or backend bucket to use when none of the given rules match.
        :param pulumi.Input[pulumi.InputType['URLMapDefaultUrlRedirectArgs']] default_url_redirect: When none of the specified hostRules match, the request is redirected to a URL specified
               by defaultUrlRedirect. If defaultUrlRedirect is specified, defaultService or
               defaultRouteAction must not be set.
               Structure is documented below.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when you create
               the resource.
        :param pulumi.Input[str] fingerprint: Fingerprint of this resource. A hash of the contents stored in this object. This
               field is used in optimistic locking.
        :param pulumi.Input[pulumi.InputType['URLMapHeaderActionArgs']] header_action: Specifies changes to request and response headers that need to take effect for
               the selected backendService. The headerAction specified here take effect after
               headerAction specified under pathMatcher.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['URLMapHostRuleArgs']]]] host_rules: The list of HostRules to use against the URL.
               Structure is documented below.
        :param pulumi.Input[int] map_id: The unique identifier for the resource.
        :param pulumi.Input[str] name: Name of the resource. Provided by the client when the resource is created. The
               name must be 1-63 characters long, and comply with RFC1035. Specifically, the
               name must be 1-63 characters long and match the regular expression
               `a-z?` which means the first character must be a lowercase
               letter, and all following characters must be a dash, lowercase letter, or digit,
               except the last character, which cannot be a dash.
               
               
               - - -
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['URLMapPathMatcherArgs']]]] path_matchers: The list of named PathMatchers to use against the URL.
               Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] self_link: The URI of the created resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['URLMapTestArgs']]]] tests: The list of expected URL mapping tests. Request to update this UrlMap will
               succeed only if all of the test cases pass. You can specify a maximum of 100
               tests per UrlMap.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _URLMapState.__new__(_URLMapState)

        __props__.__dict__["creation_timestamp"] = creation_timestamp
        __props__.__dict__["default_route_action"] = default_route_action
        __props__.__dict__["default_service"] = default_service
        __props__.__dict__["default_url_redirect"] = default_url_redirect
        __props__.__dict__["description"] = description
        __props__.__dict__["fingerprint"] = fingerprint
        __props__.__dict__["header_action"] = header_action
        __props__.__dict__["host_rules"] = host_rules
        __props__.__dict__["map_id"] = map_id
        __props__.__dict__["name"] = name
        __props__.__dict__["path_matchers"] = path_matchers
        __props__.__dict__["project"] = project
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["tests"] = tests
        return URLMap(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[str]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter(name="defaultRouteAction")
    def default_route_action(self) -> pulumi.Output[Optional['outputs.URLMapDefaultRouteAction']]:
        """
        defaultRouteAction takes effect when none of the hostRules match. The load balancer performs advanced routing actions
        like URL rewrites, header transformations, etc. prior to forwarding the request to the selected backend.
        If defaultRouteAction specifies any weightedBackendServices, defaultService must not be set. Conversely if defaultService
        is set, defaultRouteAction cannot contain any weightedBackendServices.
        Only one of defaultRouteAction or defaultUrlRedirect must be set.
        Structure is documented below.
        """
        return pulumi.get(self, "default_route_action")

    @property
    @pulumi.getter(name="defaultService")
    def default_service(self) -> pulumi.Output[Optional[str]]:
        """
        The backend service or backend bucket to use when none of the given rules match.
        """
        return pulumi.get(self, "default_service")

    @property
    @pulumi.getter(name="defaultUrlRedirect")
    def default_url_redirect(self) -> pulumi.Output[Optional['outputs.URLMapDefaultUrlRedirect']]:
        """
        When none of the specified hostRules match, the request is redirected to a URL specified
        by defaultUrlRedirect. If defaultUrlRedirect is specified, defaultService or
        defaultRouteAction must not be set.
        Structure is documented below.
        """
        return pulumi.get(self, "default_url_redirect")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        An optional description of this resource. Provide this property when you create
        the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def fingerprint(self) -> pulumi.Output[str]:
        """
        Fingerprint of this resource. A hash of the contents stored in this object. This
        field is used in optimistic locking.
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter(name="headerAction")
    def header_action(self) -> pulumi.Output[Optional['outputs.URLMapHeaderAction']]:
        """
        Specifies changes to request and response headers that need to take effect for
        the selected backendService. The headerAction specified here take effect after
        headerAction specified under pathMatcher.
        Structure is documented below.
        """
        return pulumi.get(self, "header_action")

    @property
    @pulumi.getter(name="hostRules")
    def host_rules(self) -> pulumi.Output[Optional[Sequence['outputs.URLMapHostRule']]]:
        """
        The list of HostRules to use against the URL.
        Structure is documented below.
        """
        return pulumi.get(self, "host_rules")

    @property
    @pulumi.getter(name="mapId")
    def map_id(self) -> pulumi.Output[int]:
        """
        The unique identifier for the resource.
        """
        return pulumi.get(self, "map_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the resource. Provided by the client when the resource is created. The
        name must be 1-63 characters long, and comply with RFC1035. Specifically, the
        name must be 1-63 characters long and match the regular expression
        `a-z?` which means the first character must be a lowercase
        letter, and all following characters must be a dash, lowercase letter, or digit,
        except the last character, which cannot be a dash.


        - - -
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pathMatchers")
    def path_matchers(self) -> pulumi.Output[Optional[Sequence['outputs.URLMapPathMatcher']]]:
        """
        The list of named PathMatchers to use against the URL.
        Structure is documented below.
        """
        return pulumi.get(self, "path_matchers")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter
    def tests(self) -> pulumi.Output[Optional[Sequence['outputs.URLMapTest']]]:
        """
        The list of expected URL mapping tests. Request to update this UrlMap will
        succeed only if all of the test cases pass. You can specify a maximum of 100
        tests per UrlMap.
        Structure is documented below.
        """
        return pulumi.get(self, "tests")

