# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'ConnectionProfileAlloydbArgs',
    'ConnectionProfileAlloydbSettingsArgs',
    'ConnectionProfileAlloydbSettingsInitialUserArgs',
    'ConnectionProfileAlloydbSettingsPrimaryInstanceSettingsArgs',
    'ConnectionProfileAlloydbSettingsPrimaryInstanceSettingsMachineConfigArgs',
    'ConnectionProfileCloudsqlArgs',
    'ConnectionProfileCloudsqlSettingsArgs',
    'ConnectionProfileCloudsqlSettingsIpConfigArgs',
    'ConnectionProfileCloudsqlSettingsIpConfigAuthorizedNetworkArgs',
    'ConnectionProfileErrorArgs',
    'ConnectionProfileMysqlArgs',
    'ConnectionProfileMysqlSslArgs',
    'ConnectionProfilePostgresqlArgs',
    'ConnectionProfilePostgresqlSslArgs',
]

@pulumi.input_type
class ConnectionProfileAlloydbArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[str],
                 settings: Optional[pulumi.Input['ConnectionProfileAlloydbSettingsArgs']] = None):
        """
        :param pulumi.Input[str] cluster_id: Required. The AlloyDB cluster ID that this connection profile is associated with.
        :param pulumi.Input['ConnectionProfileAlloydbSettingsArgs'] settings: Immutable. Metadata used to create the destination AlloyDB cluster.
               Structure is documented below.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[str]:
        """
        Required. The AlloyDB cluster ID that this connection profile is associated with.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input['ConnectionProfileAlloydbSettingsArgs']]:
        """
        Immutable. Metadata used to create the destination AlloyDB cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input['ConnectionProfileAlloydbSettingsArgs']]):
        pulumi.set(self, "settings", value)


@pulumi.input_type
class ConnectionProfileAlloydbSettingsArgs:
    def __init__(__self__, *,
                 initial_user: pulumi.Input['ConnectionProfileAlloydbSettingsInitialUserArgs'],
                 vpc_network: pulumi.Input[str],
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 primary_instance_settings: Optional[pulumi.Input['ConnectionProfileAlloydbSettingsPrimaryInstanceSettingsArgs']] = None):
        """
        :param pulumi.Input['ConnectionProfileAlloydbSettingsInitialUserArgs'] initial_user: Required. Input only. Initial user to setup during cluster creation.
               Structure is documented below.
        :param pulumi.Input[str] vpc_network: Required. The resource link for the VPC network in which cluster resources are created and from which they are accessible via Private IP. The network must belong to the same project as the cluster.
               It is specified in the form: 'projects/{project_number}/global/networks/{network_id}'. This is required to create a cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels for the AlloyDB cluster created by DMS.
        :param pulumi.Input['ConnectionProfileAlloydbSettingsPrimaryInstanceSettingsArgs'] primary_instance_settings: Settings for the cluster's primary instance
               Structure is documented below.
        """
        pulumi.set(__self__, "initial_user", initial_user)
        pulumi.set(__self__, "vpc_network", vpc_network)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if primary_instance_settings is not None:
            pulumi.set(__self__, "primary_instance_settings", primary_instance_settings)

    @property
    @pulumi.getter(name="initialUser")
    def initial_user(self) -> pulumi.Input['ConnectionProfileAlloydbSettingsInitialUserArgs']:
        """
        Required. Input only. Initial user to setup during cluster creation.
        Structure is documented below.
        """
        return pulumi.get(self, "initial_user")

    @initial_user.setter
    def initial_user(self, value: pulumi.Input['ConnectionProfileAlloydbSettingsInitialUserArgs']):
        pulumi.set(self, "initial_user", value)

    @property
    @pulumi.getter(name="vpcNetwork")
    def vpc_network(self) -> pulumi.Input[str]:
        """
        Required. The resource link for the VPC network in which cluster resources are created and from which they are accessible via Private IP. The network must belong to the same project as the cluster.
        It is specified in the form: 'projects/{project_number}/global/networks/{network_id}'. This is required to create a cluster.
        """
        return pulumi.get(self, "vpc_network")

    @vpc_network.setter
    def vpc_network(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_network", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels for the AlloyDB cluster created by DMS.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="primaryInstanceSettings")
    def primary_instance_settings(self) -> Optional[pulumi.Input['ConnectionProfileAlloydbSettingsPrimaryInstanceSettingsArgs']]:
        """
        Settings for the cluster's primary instance
        Structure is documented below.
        """
        return pulumi.get(self, "primary_instance_settings")

    @primary_instance_settings.setter
    def primary_instance_settings(self, value: Optional[pulumi.Input['ConnectionProfileAlloydbSettingsPrimaryInstanceSettingsArgs']]):
        pulumi.set(self, "primary_instance_settings", value)


@pulumi.input_type
class ConnectionProfileAlloydbSettingsInitialUserArgs:
    def __init__(__self__, *,
                 password: pulumi.Input[str],
                 user: pulumi.Input[str],
                 password_set: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] password: The initial password for the user.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[str] user: The database username.
        :param pulumi.Input[bool] password_set: (Output)
               Output only. Indicates if the initialUser.password field has been set.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "user", user)
        if password_set is not None:
            pulumi.set(__self__, "password_set", password_set)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        The initial password for the user.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def user(self) -> pulumi.Input[str]:
        """
        The database username.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: pulumi.Input[str]):
        pulumi.set(self, "user", value)

    @property
    @pulumi.getter(name="passwordSet")
    def password_set(self) -> Optional[pulumi.Input[bool]]:
        """
        (Output)
        Output only. Indicates if the initialUser.password field has been set.
        """
        return pulumi.get(self, "password_set")

    @password_set.setter
    def password_set(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "password_set", value)


@pulumi.input_type
class ConnectionProfileAlloydbSettingsPrimaryInstanceSettingsArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 machine_config: pulumi.Input['ConnectionProfileAlloydbSettingsPrimaryInstanceSettingsMachineConfigArgs'],
                 database_flags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 private_ip: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] id: The database username.
        :param pulumi.Input['ConnectionProfileAlloydbSettingsPrimaryInstanceSettingsMachineConfigArgs'] machine_config: Configuration for the machines that host the underlying database engine.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] database_flags: Database flags to pass to AlloyDB when DMS is creating the AlloyDB cluster and instances. See the AlloyDB documentation for how these can be used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels for the AlloyDB primary instance created by DMS.
        :param pulumi.Input[str] private_ip: (Output)
               Output only. The private IP address for the Instance. This is the connection endpoint for an end-user application.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "machine_config", machine_config)
        if database_flags is not None:
            pulumi.set(__self__, "database_flags", database_flags)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        The database username.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="machineConfig")
    def machine_config(self) -> pulumi.Input['ConnectionProfileAlloydbSettingsPrimaryInstanceSettingsMachineConfigArgs']:
        """
        Configuration for the machines that host the underlying database engine.
        Structure is documented below.
        """
        return pulumi.get(self, "machine_config")

    @machine_config.setter
    def machine_config(self, value: pulumi.Input['ConnectionProfileAlloydbSettingsPrimaryInstanceSettingsMachineConfigArgs']):
        pulumi.set(self, "machine_config", value)

    @property
    @pulumi.getter(name="databaseFlags")
    def database_flags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Database flags to pass to AlloyDB when DMS is creating the AlloyDB cluster and instances. See the AlloyDB documentation for how these can be used.
        """
        return pulumi.get(self, "database_flags")

    @database_flags.setter
    def database_flags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "database_flags", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels for the AlloyDB primary instance created by DMS.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Output only. The private IP address for the Instance. This is the connection endpoint for an end-user application.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip", value)


@pulumi.input_type
class ConnectionProfileAlloydbSettingsPrimaryInstanceSettingsMachineConfigArgs:
    def __init__(__self__, *,
                 cpu_count: pulumi.Input[int]):
        """
        :param pulumi.Input[int] cpu_count: The number of CPU's in the VM instance.
        """
        pulumi.set(__self__, "cpu_count", cpu_count)

    @property
    @pulumi.getter(name="cpuCount")
    def cpu_count(self) -> pulumi.Input[int]:
        """
        The number of CPU's in the VM instance.
        """
        return pulumi.get(self, "cpu_count")

    @cpu_count.setter
    def cpu_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "cpu_count", value)


@pulumi.input_type
class ConnectionProfileCloudsqlArgs:
    def __init__(__self__, *,
                 cloud_sql_id: Optional[pulumi.Input[str]] = None,
                 private_ip: Optional[pulumi.Input[str]] = None,
                 public_ip: Optional[pulumi.Input[str]] = None,
                 settings: Optional[pulumi.Input['ConnectionProfileCloudsqlSettingsArgs']] = None):
        """
        :param pulumi.Input[str] cloud_sql_id: (Output)
               Output only. The Cloud SQL instance ID that this connection profile is associated with.
        :param pulumi.Input[str] private_ip: (Output)
               Output only. The Cloud SQL database instance's private IP.
        :param pulumi.Input[str] public_ip: (Output)
               Output only. The Cloud SQL database instance's public IP.
        :param pulumi.Input['ConnectionProfileCloudsqlSettingsArgs'] settings: Immutable. Metadata used to create the destination Cloud SQL database.
               Structure is documented below.
        """
        if cloud_sql_id is not None:
            pulumi.set(__self__, "cloud_sql_id", cloud_sql_id)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)

    @property
    @pulumi.getter(name="cloudSqlId")
    def cloud_sql_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Output only. The Cloud SQL instance ID that this connection profile is associated with.
        """
        return pulumi.get(self, "cloud_sql_id")

    @cloud_sql_id.setter
    def cloud_sql_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_sql_id", value)

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Output only. The Cloud SQL database instance's private IP.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip", value)

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Output only. The Cloud SQL database instance's public IP.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_ip", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input['ConnectionProfileCloudsqlSettingsArgs']]:
        """
        Immutable. Metadata used to create the destination Cloud SQL database.
        Structure is documented below.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input['ConnectionProfileCloudsqlSettingsArgs']]):
        pulumi.set(self, "settings", value)


@pulumi.input_type
class ConnectionProfileCloudsqlSettingsArgs:
    def __init__(__self__, *,
                 source_id: pulumi.Input[str],
                 activation_policy: Optional[pulumi.Input[str]] = None,
                 auto_storage_increase: Optional[pulumi.Input[bool]] = None,
                 cmek_key_name: Optional[pulumi.Input[str]] = None,
                 collation: Optional[pulumi.Input[str]] = None,
                 data_disk_size_gb: Optional[pulumi.Input[str]] = None,
                 data_disk_type: Optional[pulumi.Input[str]] = None,
                 database_flags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 database_version: Optional[pulumi.Input[str]] = None,
                 ip_config: Optional[pulumi.Input['ConnectionProfileCloudsqlSettingsIpConfigArgs']] = None,
                 root_password: Optional[pulumi.Input[str]] = None,
                 root_password_set: Optional[pulumi.Input[bool]] = None,
                 storage_auto_resize_limit: Optional[pulumi.Input[str]] = None,
                 tier: Optional[pulumi.Input[str]] = None,
                 user_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] source_id: The Database Migration Service source connection profile ID, in the format: projects/my_project_name/locations/us-central1/connectionProfiles/connection_profile_ID
        :param pulumi.Input[str] activation_policy: The activation policy specifies when the instance is activated; it is applicable only when the instance state is 'RUNNABLE'.
               Possible values are: `ALWAYS`, `NEVER`.
        :param pulumi.Input[bool] auto_storage_increase: If you enable this setting, Cloud SQL checks your available storage every 30 seconds. If the available storage falls below a threshold size, Cloud SQL automatically adds additional storage capacity.
               If the available storage repeatedly falls below the threshold size, Cloud SQL continues to add storage until it reaches the maximum of 30 TB.
        :param pulumi.Input[str] cmek_key_name: The KMS key name used for the csql instance.
        :param pulumi.Input[str] collation: The Cloud SQL default instance level collation.
        :param pulumi.Input[str] data_disk_size_gb: The storage capacity available to the database, in GB. The minimum (and default) size is 10GB.
        :param pulumi.Input[str] data_disk_type: The type of storage.
               Possible values are: `PD_SSD`, `PD_HDD`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] database_flags: The database flags passed to the Cloud SQL instance at startup.
        :param pulumi.Input[str] database_version: The database engine type and version.
               Currently supported values located at https://cloud.google.com/database-migration/docs/reference/rest/v1/projects.locations.connectionProfiles#sqldatabaseversion
        :param pulumi.Input['ConnectionProfileCloudsqlSettingsIpConfigArgs'] ip_config: The settings for IP Management. This allows to enable or disable the instance IP and manage which external networks can connect to the instance. The IPv4 address cannot be disabled.
               Structure is documented below.
        :param pulumi.Input[str] root_password: Input only. Initial root password.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[bool] root_password_set: (Output)
               Output only. Indicates If this connection profile root password is stored.
        :param pulumi.Input[str] storage_auto_resize_limit: The maximum size to which storage capacity can be automatically increased. The default value is 0, which specifies that there is no limit.
        :param pulumi.Input[str] tier: The tier (or machine type) for this instance, for example: db-n1-standard-1 (MySQL instances) or db-custom-1-3840 (PostgreSQL instances).
               For more information, see https://cloud.google.com/sql/docs/mysql/instance-settings
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] user_labels: The resource labels for a Cloud SQL instance to use to annotate any related underlying resources such as Compute Engine VMs.
        :param pulumi.Input[str] zone: The Google Cloud Platform zone where your Cloud SQL datdabse instance is located.
        """
        pulumi.set(__self__, "source_id", source_id)
        if activation_policy is not None:
            pulumi.set(__self__, "activation_policy", activation_policy)
        if auto_storage_increase is not None:
            pulumi.set(__self__, "auto_storage_increase", auto_storage_increase)
        if cmek_key_name is not None:
            pulumi.set(__self__, "cmek_key_name", cmek_key_name)
        if collation is not None:
            pulumi.set(__self__, "collation", collation)
        if data_disk_size_gb is not None:
            pulumi.set(__self__, "data_disk_size_gb", data_disk_size_gb)
        if data_disk_type is not None:
            pulumi.set(__self__, "data_disk_type", data_disk_type)
        if database_flags is not None:
            pulumi.set(__self__, "database_flags", database_flags)
        if database_version is not None:
            pulumi.set(__self__, "database_version", database_version)
        if ip_config is not None:
            pulumi.set(__self__, "ip_config", ip_config)
        if root_password is not None:
            pulumi.set(__self__, "root_password", root_password)
        if root_password_set is not None:
            pulumi.set(__self__, "root_password_set", root_password_set)
        if storage_auto_resize_limit is not None:
            pulumi.set(__self__, "storage_auto_resize_limit", storage_auto_resize_limit)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)
        if user_labels is not None:
            pulumi.set(__self__, "user_labels", user_labels)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> pulumi.Input[str]:
        """
        The Database Migration Service source connection profile ID, in the format: projects/my_project_name/locations/us-central1/connectionProfiles/connection_profile_ID
        """
        return pulumi.get(self, "source_id")

    @source_id.setter
    def source_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_id", value)

    @property
    @pulumi.getter(name="activationPolicy")
    def activation_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The activation policy specifies when the instance is activated; it is applicable only when the instance state is 'RUNNABLE'.
        Possible values are: `ALWAYS`, `NEVER`.
        """
        return pulumi.get(self, "activation_policy")

    @activation_policy.setter
    def activation_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "activation_policy", value)

    @property
    @pulumi.getter(name="autoStorageIncrease")
    def auto_storage_increase(self) -> Optional[pulumi.Input[bool]]:
        """
        If you enable this setting, Cloud SQL checks your available storage every 30 seconds. If the available storage falls below a threshold size, Cloud SQL automatically adds additional storage capacity.
        If the available storage repeatedly falls below the threshold size, Cloud SQL continues to add storage until it reaches the maximum of 30 TB.
        """
        return pulumi.get(self, "auto_storage_increase")

    @auto_storage_increase.setter
    def auto_storage_increase(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_storage_increase", value)

    @property
    @pulumi.getter(name="cmekKeyName")
    def cmek_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        The KMS key name used for the csql instance.
        """
        return pulumi.get(self, "cmek_key_name")

    @cmek_key_name.setter
    def cmek_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cmek_key_name", value)

    @property
    @pulumi.getter
    def collation(self) -> Optional[pulumi.Input[str]]:
        """
        The Cloud SQL default instance level collation.
        """
        return pulumi.get(self, "collation")

    @collation.setter
    def collation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "collation", value)

    @property
    @pulumi.getter(name="dataDiskSizeGb")
    def data_disk_size_gb(self) -> Optional[pulumi.Input[str]]:
        """
        The storage capacity available to the database, in GB. The minimum (and default) size is 10GB.
        """
        return pulumi.get(self, "data_disk_size_gb")

    @data_disk_size_gb.setter
    def data_disk_size_gb(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_disk_size_gb", value)

    @property
    @pulumi.getter(name="dataDiskType")
    def data_disk_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of storage.
        Possible values are: `PD_SSD`, `PD_HDD`.
        """
        return pulumi.get(self, "data_disk_type")

    @data_disk_type.setter
    def data_disk_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_disk_type", value)

    @property
    @pulumi.getter(name="databaseFlags")
    def database_flags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The database flags passed to the Cloud SQL instance at startup.
        """
        return pulumi.get(self, "database_flags")

    @database_flags.setter
    def database_flags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "database_flags", value)

    @property
    @pulumi.getter(name="databaseVersion")
    def database_version(self) -> Optional[pulumi.Input[str]]:
        """
        The database engine type and version.
        Currently supported values located at https://cloud.google.com/database-migration/docs/reference/rest/v1/projects.locations.connectionProfiles#sqldatabaseversion
        """
        return pulumi.get(self, "database_version")

    @database_version.setter
    def database_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_version", value)

    @property
    @pulumi.getter(name="ipConfig")
    def ip_config(self) -> Optional[pulumi.Input['ConnectionProfileCloudsqlSettingsIpConfigArgs']]:
        """
        The settings for IP Management. This allows to enable or disable the instance IP and manage which external networks can connect to the instance. The IPv4 address cannot be disabled.
        Structure is documented below.
        """
        return pulumi.get(self, "ip_config")

    @ip_config.setter
    def ip_config(self, value: Optional[pulumi.Input['ConnectionProfileCloudsqlSettingsIpConfigArgs']]):
        pulumi.set(self, "ip_config", value)

    @property
    @pulumi.getter(name="rootPassword")
    def root_password(self) -> Optional[pulumi.Input[str]]:
        """
        Input only. Initial root password.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "root_password")

    @root_password.setter
    def root_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "root_password", value)

    @property
    @pulumi.getter(name="rootPasswordSet")
    def root_password_set(self) -> Optional[pulumi.Input[bool]]:
        """
        (Output)
        Output only. Indicates If this connection profile root password is stored.
        """
        return pulumi.get(self, "root_password_set")

    @root_password_set.setter
    def root_password_set(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "root_password_set", value)

    @property
    @pulumi.getter(name="storageAutoResizeLimit")
    def storage_auto_resize_limit(self) -> Optional[pulumi.Input[str]]:
        """
        The maximum size to which storage capacity can be automatically increased. The default value is 0, which specifies that there is no limit.
        """
        return pulumi.get(self, "storage_auto_resize_limit")

    @storage_auto_resize_limit.setter
    def storage_auto_resize_limit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_auto_resize_limit", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[str]]:
        """
        The tier (or machine type) for this instance, for example: db-n1-standard-1 (MySQL instances) or db-custom-1-3840 (PostgreSQL instances).
        For more information, see https://cloud.google.com/sql/docs/mysql/instance-settings
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tier", value)

    @property
    @pulumi.getter(name="userLabels")
    def user_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The resource labels for a Cloud SQL instance to use to annotate any related underlying resources such as Compute Engine VMs.
        """
        return pulumi.get(self, "user_labels")

    @user_labels.setter
    def user_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "user_labels", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        The Google Cloud Platform zone where your Cloud SQL datdabse instance is located.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class ConnectionProfileCloudsqlSettingsIpConfigArgs:
    def __init__(__self__, *,
                 authorized_networks: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionProfileCloudsqlSettingsIpConfigAuthorizedNetworkArgs']]]] = None,
                 enable_ipv4: Optional[pulumi.Input[bool]] = None,
                 private_network: Optional[pulumi.Input[str]] = None,
                 require_ssl: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ConnectionProfileCloudsqlSettingsIpConfigAuthorizedNetworkArgs']]] authorized_networks: The list of external networks that are allowed to connect to the instance using the IP.
               Structure is documented below.
        :param pulumi.Input[bool] enable_ipv4: Whether the instance should be assigned an IPv4 address or not.
        :param pulumi.Input[str] private_network: The resource link for the VPC network from which the Cloud SQL instance is accessible for private IP. For example, projects/myProject/global/networks/default.
               This setting can be updated, but it cannot be removed after it is set.
        :param pulumi.Input[bool] require_ssl: Whether SSL connections over IP should be enforced or not.
        """
        if authorized_networks is not None:
            pulumi.set(__self__, "authorized_networks", authorized_networks)
        if enable_ipv4 is not None:
            pulumi.set(__self__, "enable_ipv4", enable_ipv4)
        if private_network is not None:
            pulumi.set(__self__, "private_network", private_network)
        if require_ssl is not None:
            pulumi.set(__self__, "require_ssl", require_ssl)

    @property
    @pulumi.getter(name="authorizedNetworks")
    def authorized_networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionProfileCloudsqlSettingsIpConfigAuthorizedNetworkArgs']]]]:
        """
        The list of external networks that are allowed to connect to the instance using the IP.
        Structure is documented below.
        """
        return pulumi.get(self, "authorized_networks")

    @authorized_networks.setter
    def authorized_networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionProfileCloudsqlSettingsIpConfigAuthorizedNetworkArgs']]]]):
        pulumi.set(self, "authorized_networks", value)

    @property
    @pulumi.getter(name="enableIpv4")
    def enable_ipv4(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the instance should be assigned an IPv4 address or not.
        """
        return pulumi.get(self, "enable_ipv4")

    @enable_ipv4.setter
    def enable_ipv4(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_ipv4", value)

    @property
    @pulumi.getter(name="privateNetwork")
    def private_network(self) -> Optional[pulumi.Input[str]]:
        """
        The resource link for the VPC network from which the Cloud SQL instance is accessible for private IP. For example, projects/myProject/global/networks/default.
        This setting can be updated, but it cannot be removed after it is set.
        """
        return pulumi.get(self, "private_network")

    @private_network.setter
    def private_network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_network", value)

    @property
    @pulumi.getter(name="requireSsl")
    def require_ssl(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether SSL connections over IP should be enforced or not.
        """
        return pulumi.get(self, "require_ssl")

    @require_ssl.setter
    def require_ssl(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_ssl", value)


@pulumi.input_type
class ConnectionProfileCloudsqlSettingsIpConfigAuthorizedNetworkArgs:
    def __init__(__self__, *,
                 value: pulumi.Input[str],
                 expire_time: Optional[pulumi.Input[str]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] value: The allowlisted value for the access control list.
        :param pulumi.Input[str] expire_time: The time when this access control entry expires in RFC 3339 format.
        :param pulumi.Input[str] label: A label to identify this entry.
        :param pulumi.Input[str] ttl: Input only. The time-to-leave of this access control entry.
        """
        pulumi.set(__self__, "value", value)
        if expire_time is not None:
            pulumi.set(__self__, "expire_time", expire_time)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The allowlisted value for the access control list.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time when this access control entry expires in RFC 3339 format.
        """
        return pulumi.get(self, "expire_time")

    @expire_time.setter
    def expire_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expire_time", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        A label to identify this entry.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[str]]:
        """
        Input only. The time-to-leave of this access control entry.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ttl", value)


@pulumi.input_type
class ConnectionProfileErrorArgs:
    def __init__(__self__, *,
                 code: Optional[pulumi.Input[int]] = None,
                 details: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, Any]]]]] = None,
                 message: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] code: (Output)
               The status code, which should be an enum value of google.rpc.Code.
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, Any]]]] details: (Output)
               A list of messages that carry the error details.
        :param pulumi.Input[str] message: (Output)
               Human readable message indicating details about the current status.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[int]]:
        """
        (Output)
        The status code, which should be an enum value of google.rpc.Code.
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter
    def details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, Any]]]]]:
        """
        (Output)
        A list of messages that carry the error details.
        """
        return pulumi.get(self, "details")

    @details.setter
    def details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, Any]]]]]):
        pulumi.set(self, "details", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Human readable message indicating details about the current status.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)


@pulumi.input_type
class ConnectionProfileMysqlArgs:
    def __init__(__self__, *,
                 host: pulumi.Input[str],
                 password: pulumi.Input[str],
                 port: pulumi.Input[int],
                 username: pulumi.Input[str],
                 cloud_sql_id: Optional[pulumi.Input[str]] = None,
                 password_set: Optional[pulumi.Input[bool]] = None,
                 ssl: Optional[pulumi.Input['ConnectionProfileMysqlSslArgs']] = None):
        """
        :param pulumi.Input[str] host: Required. The IP or hostname of the source MySQL database.
        :param pulumi.Input[str] password: Required. Input only. The password for the user that Database Migration Service will be using to connect to the database.
               This field is not returned on request, and the value is encrypted when stored in Database Migration Service.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[int] port: Required. The network port of the source MySQL database.
        :param pulumi.Input[str] username: Required. The username that Database Migration Service will use to connect to the database. The value is encrypted when stored in Database Migration Service.
        :param pulumi.Input[str] cloud_sql_id: If the source is a Cloud SQL database, use this field to provide the Cloud SQL instance ID of the source.
        :param pulumi.Input[bool] password_set: (Output)
               Output only. Indicates If this connection profile password is stored.
        :param pulumi.Input['ConnectionProfileMysqlSslArgs'] ssl: SSL configuration for the destination to connect to the source database.
               Structure is documented below.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "username", username)
        if cloud_sql_id is not None:
            pulumi.set(__self__, "cloud_sql_id", cloud_sql_id)
        if password_set is not None:
            pulumi.set(__self__, "password_set", password_set)
        if ssl is not None:
            pulumi.set(__self__, "ssl", ssl)

    @property
    @pulumi.getter
    def host(self) -> pulumi.Input[str]:
        """
        Required. The IP or hostname of the source MySQL database.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: pulumi.Input[str]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        Required. Input only. The password for the user that Database Migration Service will be using to connect to the database.
        This field is not returned on request, and the value is encrypted when stored in Database Migration Service.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        Required. The network port of the source MySQL database.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        Required. The username that Database Migration Service will use to connect to the database. The value is encrypted when stored in Database Migration Service.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="cloudSqlId")
    def cloud_sql_id(self) -> Optional[pulumi.Input[str]]:
        """
        If the source is a Cloud SQL database, use this field to provide the Cloud SQL instance ID of the source.
        """
        return pulumi.get(self, "cloud_sql_id")

    @cloud_sql_id.setter
    def cloud_sql_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_sql_id", value)

    @property
    @pulumi.getter(name="passwordSet")
    def password_set(self) -> Optional[pulumi.Input[bool]]:
        """
        (Output)
        Output only. Indicates If this connection profile password is stored.
        """
        return pulumi.get(self, "password_set")

    @password_set.setter
    def password_set(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "password_set", value)

    @property
    @pulumi.getter
    def ssl(self) -> Optional[pulumi.Input['ConnectionProfileMysqlSslArgs']]:
        """
        SSL configuration for the destination to connect to the source database.
        Structure is documented below.
        """
        return pulumi.get(self, "ssl")

    @ssl.setter
    def ssl(self, value: Optional[pulumi.Input['ConnectionProfileMysqlSslArgs']]):
        pulumi.set(self, "ssl", value)


@pulumi.input_type
class ConnectionProfileMysqlSslArgs:
    def __init__(__self__, *,
                 ca_certificate: pulumi.Input[str],
                 client_certificate: Optional[pulumi.Input[str]] = None,
                 client_key: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] ca_certificate: Required. Input only. The x509 PEM-encoded certificate of the CA that signed the source database server's certificate.
               The replica will use this certificate to verify it's connecting to the right host.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[str] client_certificate: Input only. The x509 PEM-encoded certificate that will be used by the replica to authenticate against the source database server.
               If this field is used then the 'clientKey' field is mandatory
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[str] client_key: Input only. The unencrypted PKCS#1 or PKCS#8 PEM-encoded private key associated with the Client Certificate.
               If this field is used then the 'clientCertificate' field is mandatory.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[str] type: (Output)
               The current connection profile state.
        """
        pulumi.set(__self__, "ca_certificate", ca_certificate)
        if client_certificate is not None:
            pulumi.set(__self__, "client_certificate", client_certificate)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> pulumi.Input[str]:
        """
        Required. Input only. The x509 PEM-encoded certificate of the CA that signed the source database server's certificate.
        The replica will use this certificate to verify it's connecting to the right host.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "ca_certificate")

    @ca_certificate.setter
    def ca_certificate(self, value: pulumi.Input[str]):
        pulumi.set(self, "ca_certificate", value)

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        Input only. The x509 PEM-encoded certificate that will be used by the replica to authenticate against the source database server.
        If this field is used then the 'clientKey' field is mandatory
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "client_certificate")

    @client_certificate.setter
    def client_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_certificate", value)

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[pulumi.Input[str]]:
        """
        Input only. The unencrypted PKCS#1 or PKCS#8 PEM-encoded private key associated with the Client Certificate.
        If this field is used then the 'clientCertificate' field is mandatory.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "client_key")

    @client_key.setter
    def client_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_key", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        The current connection profile state.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ConnectionProfilePostgresqlArgs:
    def __init__(__self__, *,
                 host: pulumi.Input[str],
                 password: pulumi.Input[str],
                 port: pulumi.Input[int],
                 username: pulumi.Input[str],
                 cloud_sql_id: Optional[pulumi.Input[str]] = None,
                 network_architecture: Optional[pulumi.Input[str]] = None,
                 password_set: Optional[pulumi.Input[bool]] = None,
                 ssl: Optional[pulumi.Input['ConnectionProfilePostgresqlSslArgs']] = None):
        """
        :param pulumi.Input[str] host: Required. The IP or hostname of the source MySQL database.
        :param pulumi.Input[str] password: Required. Input only. The password for the user that Database Migration Service will be using to connect to the database.
               This field is not returned on request, and the value is encrypted when stored in Database Migration Service.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[int] port: Required. The network port of the source MySQL database.
        :param pulumi.Input[str] username: Required. The username that Database Migration Service will use to connect to the database. The value is encrypted when stored in Database Migration Service.
        :param pulumi.Input[str] cloud_sql_id: If the source is a Cloud SQL database, use this field to provide the Cloud SQL instance ID of the source.
        :param pulumi.Input[str] network_architecture: (Output)
               Output only. If the source is a Cloud SQL database, this field indicates the network architecture it's associated with.
        :param pulumi.Input[bool] password_set: (Output)
               Output only. Indicates If this connection profile password is stored.
        :param pulumi.Input['ConnectionProfilePostgresqlSslArgs'] ssl: SSL configuration for the destination to connect to the source database.
               Structure is documented below.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "username", username)
        if cloud_sql_id is not None:
            pulumi.set(__self__, "cloud_sql_id", cloud_sql_id)
        if network_architecture is not None:
            pulumi.set(__self__, "network_architecture", network_architecture)
        if password_set is not None:
            pulumi.set(__self__, "password_set", password_set)
        if ssl is not None:
            pulumi.set(__self__, "ssl", ssl)

    @property
    @pulumi.getter
    def host(self) -> pulumi.Input[str]:
        """
        Required. The IP or hostname of the source MySQL database.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: pulumi.Input[str]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        Required. Input only. The password for the user that Database Migration Service will be using to connect to the database.
        This field is not returned on request, and the value is encrypted when stored in Database Migration Service.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        Required. The network port of the source MySQL database.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        Required. The username that Database Migration Service will use to connect to the database. The value is encrypted when stored in Database Migration Service.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="cloudSqlId")
    def cloud_sql_id(self) -> Optional[pulumi.Input[str]]:
        """
        If the source is a Cloud SQL database, use this field to provide the Cloud SQL instance ID of the source.
        """
        return pulumi.get(self, "cloud_sql_id")

    @cloud_sql_id.setter
    def cloud_sql_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_sql_id", value)

    @property
    @pulumi.getter(name="networkArchitecture")
    def network_architecture(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Output only. If the source is a Cloud SQL database, this field indicates the network architecture it's associated with.
        """
        return pulumi.get(self, "network_architecture")

    @network_architecture.setter
    def network_architecture(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_architecture", value)

    @property
    @pulumi.getter(name="passwordSet")
    def password_set(self) -> Optional[pulumi.Input[bool]]:
        """
        (Output)
        Output only. Indicates If this connection profile password is stored.
        """
        return pulumi.get(self, "password_set")

    @password_set.setter
    def password_set(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "password_set", value)

    @property
    @pulumi.getter
    def ssl(self) -> Optional[pulumi.Input['ConnectionProfilePostgresqlSslArgs']]:
        """
        SSL configuration for the destination to connect to the source database.
        Structure is documented below.
        """
        return pulumi.get(self, "ssl")

    @ssl.setter
    def ssl(self, value: Optional[pulumi.Input['ConnectionProfilePostgresqlSslArgs']]):
        pulumi.set(self, "ssl", value)


@pulumi.input_type
class ConnectionProfilePostgresqlSslArgs:
    def __init__(__self__, *,
                 ca_certificate: pulumi.Input[str],
                 client_certificate: Optional[pulumi.Input[str]] = None,
                 client_key: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] ca_certificate: Required. Input only. The x509 PEM-encoded certificate of the CA that signed the source database server's certificate.
               The replica will use this certificate to verify it's connecting to the right host.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[str] client_certificate: Input only. The x509 PEM-encoded certificate that will be used by the replica to authenticate against the source database server.
               If this field is used then the 'clientKey' field is mandatory
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[str] client_key: Input only. The unencrypted PKCS#1 or PKCS#8 PEM-encoded private key associated with the Client Certificate.
               If this field is used then the 'clientCertificate' field is mandatory.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[str] type: (Output)
               The current connection profile state.
        """
        pulumi.set(__self__, "ca_certificate", ca_certificate)
        if client_certificate is not None:
            pulumi.set(__self__, "client_certificate", client_certificate)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> pulumi.Input[str]:
        """
        Required. Input only. The x509 PEM-encoded certificate of the CA that signed the source database server's certificate.
        The replica will use this certificate to verify it's connecting to the right host.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "ca_certificate")

    @ca_certificate.setter
    def ca_certificate(self, value: pulumi.Input[str]):
        pulumi.set(self, "ca_certificate", value)

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        Input only. The x509 PEM-encoded certificate that will be used by the replica to authenticate against the source database server.
        If this field is used then the 'clientKey' field is mandatory
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "client_certificate")

    @client_certificate.setter
    def client_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_certificate", value)

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[pulumi.Input[str]]:
        """
        Input only. The unencrypted PKCS#1 or PKCS#8 PEM-encoded private key associated with the Client Certificate.
        If this field is used then the 'clientCertificate' field is mandatory.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "client_key")

    @client_key.setter
    def client_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_key", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        The current connection profile state.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


