# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConnectionProfileArgs', 'ConnectionProfile']

@pulumi.input_type
class ConnectionProfileArgs:
    def __init__(__self__, *,
                 connection_profile_id: pulumi.Input[str],
                 alloydb: Optional[pulumi.Input['ConnectionProfileAlloydbArgs']] = None,
                 cloudsql: Optional[pulumi.Input['ConnectionProfileCloudsqlArgs']] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 mysql: Optional[pulumi.Input['ConnectionProfileMysqlArgs']] = None,
                 postgresql: Optional[pulumi.Input['ConnectionProfilePostgresqlArgs']] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ConnectionProfile resource.
        :param pulumi.Input[str] connection_profile_id: The ID of the connection profile.
               
               
               - - -
        :param pulumi.Input['ConnectionProfileAlloydbArgs'] alloydb: Specifies required connection parameters, and the parameters required to create an AlloyDB destination cluster.
               Structure is documented below.
        :param pulumi.Input['ConnectionProfileCloudsqlArgs'] cloudsql: Specifies required connection parameters, and, optionally, the parameters required to create a Cloud SQL destination database instance.
               Structure is documented below.
        :param pulumi.Input[str] display_name: The connection profile display name.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: The resource labels for connection profile to use to annotate any related underlying resources such as Compute Engine VMs.
        :param pulumi.Input[str] location: The location where the connection profile should reside.
        :param pulumi.Input['ConnectionProfileMysqlArgs'] mysql: Specifies connection parameters required specifically for MySQL databases.
               Structure is documented below.
        :param pulumi.Input['ConnectionProfilePostgresqlArgs'] postgresql: Specifies connection parameters required specifically for PostgreSQL databases.
               Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "connection_profile_id", connection_profile_id)
        if alloydb is not None:
            pulumi.set(__self__, "alloydb", alloydb)
        if cloudsql is not None:
            pulumi.set(__self__, "cloudsql", cloudsql)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if mysql is not None:
            pulumi.set(__self__, "mysql", mysql)
        if postgresql is not None:
            pulumi.set(__self__, "postgresql", postgresql)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="connectionProfileId")
    def connection_profile_id(self) -> pulumi.Input[str]:
        """
        The ID of the connection profile.


        - - -
        """
        return pulumi.get(self, "connection_profile_id")

    @connection_profile_id.setter
    def connection_profile_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "connection_profile_id", value)

    @property
    @pulumi.getter
    def alloydb(self) -> Optional[pulumi.Input['ConnectionProfileAlloydbArgs']]:
        """
        Specifies required connection parameters, and the parameters required to create an AlloyDB destination cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "alloydb")

    @alloydb.setter
    def alloydb(self, value: Optional[pulumi.Input['ConnectionProfileAlloydbArgs']]):
        pulumi.set(self, "alloydb", value)

    @property
    @pulumi.getter
    def cloudsql(self) -> Optional[pulumi.Input['ConnectionProfileCloudsqlArgs']]:
        """
        Specifies required connection parameters, and, optionally, the parameters required to create a Cloud SQL destination database instance.
        Structure is documented below.
        """
        return pulumi.get(self, "cloudsql")

    @cloudsql.setter
    def cloudsql(self, value: Optional[pulumi.Input['ConnectionProfileCloudsqlArgs']]):
        pulumi.set(self, "cloudsql", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The connection profile display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The resource labels for connection profile to use to annotate any related underlying resources such as Compute Engine VMs.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location where the connection profile should reside.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def mysql(self) -> Optional[pulumi.Input['ConnectionProfileMysqlArgs']]:
        """
        Specifies connection parameters required specifically for MySQL databases.
        Structure is documented below.
        """
        return pulumi.get(self, "mysql")

    @mysql.setter
    def mysql(self, value: Optional[pulumi.Input['ConnectionProfileMysqlArgs']]):
        pulumi.set(self, "mysql", value)

    @property
    @pulumi.getter
    def postgresql(self) -> Optional[pulumi.Input['ConnectionProfilePostgresqlArgs']]:
        """
        Specifies connection parameters required specifically for PostgreSQL databases.
        Structure is documented below.
        """
        return pulumi.get(self, "postgresql")

    @postgresql.setter
    def postgresql(self, value: Optional[pulumi.Input['ConnectionProfilePostgresqlArgs']]):
        pulumi.set(self, "postgresql", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _ConnectionProfileState:
    def __init__(__self__, *,
                 alloydb: Optional[pulumi.Input['ConnectionProfileAlloydbArgs']] = None,
                 cloudsql: Optional[pulumi.Input['ConnectionProfileCloudsqlArgs']] = None,
                 connection_profile_id: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 dbprovider: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 errors: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionProfileErrorArgs']]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 mysql: Optional[pulumi.Input['ConnectionProfileMysqlArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 postgresql: Optional[pulumi.Input['ConnectionProfilePostgresqlArgs']] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ConnectionProfile resources.
        :param pulumi.Input['ConnectionProfileAlloydbArgs'] alloydb: Specifies required connection parameters, and the parameters required to create an AlloyDB destination cluster.
               Structure is documented below.
        :param pulumi.Input['ConnectionProfileCloudsqlArgs'] cloudsql: Specifies required connection parameters, and, optionally, the parameters required to create a Cloud SQL destination database instance.
               Structure is documented below.
        :param pulumi.Input[str] connection_profile_id: The ID of the connection profile.
               
               
               - - -
        :param pulumi.Input[str] create_time: Output only. The timestamp when the resource was created. A timestamp in RFC3339 UTC 'Zulu' format, accurate to nanoseconds. Example: '2014-10-02T15:01:23.045123456Z'.
        :param pulumi.Input[str] dbprovider: The database provider.
        :param pulumi.Input[str] display_name: The connection profile display name.
        :param pulumi.Input[Sequence[pulumi.Input['ConnectionProfileErrorArgs']]] errors: Output only. The error details in case of state FAILED.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: The resource labels for connection profile to use to annotate any related underlying resources such as Compute Engine VMs.
        :param pulumi.Input[str] location: The location where the connection profile should reside.
        :param pulumi.Input['ConnectionProfileMysqlArgs'] mysql: Specifies connection parameters required specifically for MySQL databases.
               Structure is documented below.
        :param pulumi.Input[str] name: The name of this connection profile resource in the form of projects/{project}/locations/{location}/connectionProfiles/{connectionProfile}.
        :param pulumi.Input['ConnectionProfilePostgresqlArgs'] postgresql: Specifies connection parameters required specifically for PostgreSQL databases.
               Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] state: The current connection profile state.
        """
        if alloydb is not None:
            pulumi.set(__self__, "alloydb", alloydb)
        if cloudsql is not None:
            pulumi.set(__self__, "cloudsql", cloudsql)
        if connection_profile_id is not None:
            pulumi.set(__self__, "connection_profile_id", connection_profile_id)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if dbprovider is not None:
            pulumi.set(__self__, "dbprovider", dbprovider)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if errors is not None:
            pulumi.set(__self__, "errors", errors)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if mysql is not None:
            pulumi.set(__self__, "mysql", mysql)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if postgresql is not None:
            pulumi.set(__self__, "postgresql", postgresql)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def alloydb(self) -> Optional[pulumi.Input['ConnectionProfileAlloydbArgs']]:
        """
        Specifies required connection parameters, and the parameters required to create an AlloyDB destination cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "alloydb")

    @alloydb.setter
    def alloydb(self, value: Optional[pulumi.Input['ConnectionProfileAlloydbArgs']]):
        pulumi.set(self, "alloydb", value)

    @property
    @pulumi.getter
    def cloudsql(self) -> Optional[pulumi.Input['ConnectionProfileCloudsqlArgs']]:
        """
        Specifies required connection parameters, and, optionally, the parameters required to create a Cloud SQL destination database instance.
        Structure is documented below.
        """
        return pulumi.get(self, "cloudsql")

    @cloudsql.setter
    def cloudsql(self, value: Optional[pulumi.Input['ConnectionProfileCloudsqlArgs']]):
        pulumi.set(self, "cloudsql", value)

    @property
    @pulumi.getter(name="connectionProfileId")
    def connection_profile_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the connection profile.


        - - -
        """
        return pulumi.get(self, "connection_profile_id")

    @connection_profile_id.setter
    def connection_profile_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_profile_id", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. The timestamp when the resource was created. A timestamp in RFC3339 UTC 'Zulu' format, accurate to nanoseconds. Example: '2014-10-02T15:01:23.045123456Z'.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def dbprovider(self) -> Optional[pulumi.Input[str]]:
        """
        The database provider.
        """
        return pulumi.get(self, "dbprovider")

    @dbprovider.setter
    def dbprovider(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dbprovider", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The connection profile display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def errors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionProfileErrorArgs']]]]:
        """
        Output only. The error details in case of state FAILED.
        Structure is documented below.
        """
        return pulumi.get(self, "errors")

    @errors.setter
    def errors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionProfileErrorArgs']]]]):
        pulumi.set(self, "errors", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The resource labels for connection profile to use to annotate any related underlying resources such as Compute Engine VMs.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location where the connection profile should reside.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def mysql(self) -> Optional[pulumi.Input['ConnectionProfileMysqlArgs']]:
        """
        Specifies connection parameters required specifically for MySQL databases.
        Structure is documented below.
        """
        return pulumi.get(self, "mysql")

    @mysql.setter
    def mysql(self, value: Optional[pulumi.Input['ConnectionProfileMysqlArgs']]):
        pulumi.set(self, "mysql", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of this connection profile resource in the form of projects/{project}/locations/{location}/connectionProfiles/{connectionProfile}.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def postgresql(self) -> Optional[pulumi.Input['ConnectionProfilePostgresqlArgs']]:
        """
        Specifies connection parameters required specifically for PostgreSQL databases.
        Structure is documented below.
        """
        return pulumi.get(self, "postgresql")

    @postgresql.setter
    def postgresql(self, value: Optional[pulumi.Input['ConnectionProfilePostgresqlArgs']]):
        pulumi.set(self, "postgresql", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current connection profile state.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)


class ConnectionProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alloydb: Optional[pulumi.Input[pulumi.InputType['ConnectionProfileAlloydbArgs']]] = None,
                 cloudsql: Optional[pulumi.Input[pulumi.InputType['ConnectionProfileCloudsqlArgs']]] = None,
                 connection_profile_id: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 mysql: Optional[pulumi.Input[pulumi.InputType['ConnectionProfileMysqlArgs']]] = None,
                 postgresql: Optional[pulumi.Input[pulumi.InputType['ConnectionProfilePostgresqlArgs']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        A connection profile definition.

        To get more information about ConnectionProfile, see:

        * [API documentation](https://cloud.google.com/database-migration/docs/reference/rest/v1/projects.locations.connectionProfiles/create)
        * How-to Guides
            * [Database Migration](https://cloud.google.com/database-migration/docs/)

        > **Warning:** All arguments including the following potentially sensitive
        values will be stored in the raw state as plain text: `mysql.password`, `mysql.ssl.client_key`, `mysql.ssl.client_certificate`, `mysql.ssl.ca_certificate`, `postgresql.password`, `postgresql.ssl.client_key`, `postgresql.ssl.client_certificate`, `postgresql.ssl.ca_certificate`, `cloudsql.settings.root_password`, `alloydb.settings.initial_user.password`.
        Read more about sensitive data in state.

        ## Example Usage
        ### Database Migration Service Connection Profile Cloudsql

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        cloudsqldb = gcp.sql.DatabaseInstance("cloudsqldb",
            database_version="MYSQL_5_7",
            settings=gcp.sql.DatabaseInstanceSettingsArgs(
                tier="db-n1-standard-1",
                deletion_protection_enabled=False,
            ),
            deletion_protection=False)
        sql_client_cert = gcp.sql.SslCert("sqlClientCert",
            common_name="my-cert",
            instance=cloudsqldb.name,
            opts=pulumi.ResourceOptions(depends_on=[cloudsqldb]))
        sqldb_user = gcp.sql.User("sqldbUser",
            instance=cloudsqldb.name,
            password="my-password",
            opts=pulumi.ResourceOptions(depends_on=[sql_client_cert]))
        cloudsqlprofile = gcp.databasemigrationservice.ConnectionProfile("cloudsqlprofile",
            location="us-central1",
            connection_profile_id="my-fromprofileid",
            display_name="my-fromprofileid_display",
            labels={
                "foo": "bar",
            },
            mysql=gcp.databasemigrationservice.ConnectionProfileMysqlArgs(
                host=cloudsqldb.ip_addresses[0].ip_address,
                port=3306,
                username=sqldb_user.name,
                password=sqldb_user.password,
                ssl=gcp.databasemigrationservice.ConnectionProfileMysqlSslArgs(
                    client_key=sql_client_cert.private_key,
                    client_certificate=sql_client_cert.cert,
                    ca_certificate=sql_client_cert.server_ca_cert,
                ),
                cloud_sql_id="my-database",
            ),
            opts=pulumi.ResourceOptions(depends_on=[sqldb_user]))
        cloudsqlprofile_destination = gcp.databasemigrationservice.ConnectionProfile("cloudsqlprofileDestination",
            location="us-central1",
            connection_profile_id="my-toprofileid",
            display_name="my-toprofileid_displayname",
            labels={
                "foo": "bar",
            },
            cloudsql=gcp.databasemigrationservice.ConnectionProfileCloudsqlArgs(
                settings=gcp.databasemigrationservice.ConnectionProfileCloudsqlSettingsArgs(
                    database_version="MYSQL_5_7",
                    user_labels={
                        "cloudfoo": "cloudbar",
                    },
                    tier="db-n1-standard-1",
                    storage_auto_resize_limit="0",
                    activation_policy="ALWAYS",
                    ip_config=gcp.databasemigrationservice.ConnectionProfileCloudsqlSettingsIpConfigArgs(
                        enable_ipv4=True,
                        require_ssl=True,
                    ),
                    auto_storage_increase=True,
                    data_disk_type="PD_HDD",
                    data_disk_size_gb="11",
                    zone="us-central1-b",
                    source_id=f"projects/{project.project_id}/locations/us-central1/connectionProfiles/my-fromprofileid",
                    root_password="testpasscloudsql",
                ),
            ),
            opts=pulumi.ResourceOptions(depends_on=[cloudsqlprofile]))
        ```
        ### Database Migration Service Connection Profile Postgres

        ```python
        import pulumi
        import pulumi_gcp as gcp

        postgresqldb = gcp.sql.DatabaseInstance("postgresqldb",
            database_version="POSTGRES_12",
            settings=gcp.sql.DatabaseInstanceSettingsArgs(
                tier="db-custom-2-13312",
            ),
            deletion_protection=False)
        sql_client_cert = gcp.sql.SslCert("sqlClientCert",
            common_name="my-cert",
            instance=postgresqldb.name,
            opts=pulumi.ResourceOptions(depends_on=[postgresqldb]))
        sqldb_user = gcp.sql.User("sqldbUser",
            instance=postgresqldb.name,
            password="my-password",
            opts=pulumi.ResourceOptions(depends_on=[sql_client_cert]))
        postgresprofile = gcp.databasemigrationservice.ConnectionProfile("postgresprofile",
            location="us-central1",
            connection_profile_id="my-profileid",
            display_name="my-profileid_display",
            labels={
                "foo": "bar",
            },
            postgresql=gcp.databasemigrationservice.ConnectionProfilePostgresqlArgs(
                host=postgresqldb.ip_addresses[0].ip_address,
                port=5432,
                username=sqldb_user.name,
                password=sqldb_user.password,
                ssl=gcp.databasemigrationservice.ConnectionProfilePostgresqlSslArgs(
                    client_key=sql_client_cert.private_key,
                    client_certificate=sql_client_cert.cert,
                    ca_certificate=sql_client_cert.server_ca_cert,
                ),
                cloud_sql_id="my-database",
            ),
            opts=pulumi.ResourceOptions(depends_on=[sqldb_user]))
        ```

        ## Import

        ConnectionProfile can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:databasemigrationservice/connectionProfile:ConnectionProfile default projects/{{project}}/locations/{{location}}/connectionProfiles/{{connection_profile_id}}
        ```

        ```sh
         $ pulumi import gcp:databasemigrationservice/connectionProfile:ConnectionProfile default {{project}}/{{location}}/{{connection_profile_id}}
        ```

        ```sh
         $ pulumi import gcp:databasemigrationservice/connectionProfile:ConnectionProfile default {{location}}/{{connection_profile_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ConnectionProfileAlloydbArgs']] alloydb: Specifies required connection parameters, and the parameters required to create an AlloyDB destination cluster.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['ConnectionProfileCloudsqlArgs']] cloudsql: Specifies required connection parameters, and, optionally, the parameters required to create a Cloud SQL destination database instance.
               Structure is documented below.
        :param pulumi.Input[str] connection_profile_id: The ID of the connection profile.
               
               
               - - -
        :param pulumi.Input[str] display_name: The connection profile display name.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: The resource labels for connection profile to use to annotate any related underlying resources such as Compute Engine VMs.
        :param pulumi.Input[str] location: The location where the connection profile should reside.
        :param pulumi.Input[pulumi.InputType['ConnectionProfileMysqlArgs']] mysql: Specifies connection parameters required specifically for MySQL databases.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['ConnectionProfilePostgresqlArgs']] postgresql: Specifies connection parameters required specifically for PostgreSQL databases.
               Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConnectionProfileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A connection profile definition.

        To get more information about ConnectionProfile, see:

        * [API documentation](https://cloud.google.com/database-migration/docs/reference/rest/v1/projects.locations.connectionProfiles/create)
        * How-to Guides
            * [Database Migration](https://cloud.google.com/database-migration/docs/)

        > **Warning:** All arguments including the following potentially sensitive
        values will be stored in the raw state as plain text: `mysql.password`, `mysql.ssl.client_key`, `mysql.ssl.client_certificate`, `mysql.ssl.ca_certificate`, `postgresql.password`, `postgresql.ssl.client_key`, `postgresql.ssl.client_certificate`, `postgresql.ssl.ca_certificate`, `cloudsql.settings.root_password`, `alloydb.settings.initial_user.password`.
        Read more about sensitive data in state.

        ## Example Usage
        ### Database Migration Service Connection Profile Cloudsql

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        cloudsqldb = gcp.sql.DatabaseInstance("cloudsqldb",
            database_version="MYSQL_5_7",
            settings=gcp.sql.DatabaseInstanceSettingsArgs(
                tier="db-n1-standard-1",
                deletion_protection_enabled=False,
            ),
            deletion_protection=False)
        sql_client_cert = gcp.sql.SslCert("sqlClientCert",
            common_name="my-cert",
            instance=cloudsqldb.name,
            opts=pulumi.ResourceOptions(depends_on=[cloudsqldb]))
        sqldb_user = gcp.sql.User("sqldbUser",
            instance=cloudsqldb.name,
            password="my-password",
            opts=pulumi.ResourceOptions(depends_on=[sql_client_cert]))
        cloudsqlprofile = gcp.databasemigrationservice.ConnectionProfile("cloudsqlprofile",
            location="us-central1",
            connection_profile_id="my-fromprofileid",
            display_name="my-fromprofileid_display",
            labels={
                "foo": "bar",
            },
            mysql=gcp.databasemigrationservice.ConnectionProfileMysqlArgs(
                host=cloudsqldb.ip_addresses[0].ip_address,
                port=3306,
                username=sqldb_user.name,
                password=sqldb_user.password,
                ssl=gcp.databasemigrationservice.ConnectionProfileMysqlSslArgs(
                    client_key=sql_client_cert.private_key,
                    client_certificate=sql_client_cert.cert,
                    ca_certificate=sql_client_cert.server_ca_cert,
                ),
                cloud_sql_id="my-database",
            ),
            opts=pulumi.ResourceOptions(depends_on=[sqldb_user]))
        cloudsqlprofile_destination = gcp.databasemigrationservice.ConnectionProfile("cloudsqlprofileDestination",
            location="us-central1",
            connection_profile_id="my-toprofileid",
            display_name="my-toprofileid_displayname",
            labels={
                "foo": "bar",
            },
            cloudsql=gcp.databasemigrationservice.ConnectionProfileCloudsqlArgs(
                settings=gcp.databasemigrationservice.ConnectionProfileCloudsqlSettingsArgs(
                    database_version="MYSQL_5_7",
                    user_labels={
                        "cloudfoo": "cloudbar",
                    },
                    tier="db-n1-standard-1",
                    storage_auto_resize_limit="0",
                    activation_policy="ALWAYS",
                    ip_config=gcp.databasemigrationservice.ConnectionProfileCloudsqlSettingsIpConfigArgs(
                        enable_ipv4=True,
                        require_ssl=True,
                    ),
                    auto_storage_increase=True,
                    data_disk_type="PD_HDD",
                    data_disk_size_gb="11",
                    zone="us-central1-b",
                    source_id=f"projects/{project.project_id}/locations/us-central1/connectionProfiles/my-fromprofileid",
                    root_password="testpasscloudsql",
                ),
            ),
            opts=pulumi.ResourceOptions(depends_on=[cloudsqlprofile]))
        ```
        ### Database Migration Service Connection Profile Postgres

        ```python
        import pulumi
        import pulumi_gcp as gcp

        postgresqldb = gcp.sql.DatabaseInstance("postgresqldb",
            database_version="POSTGRES_12",
            settings=gcp.sql.DatabaseInstanceSettingsArgs(
                tier="db-custom-2-13312",
            ),
            deletion_protection=False)
        sql_client_cert = gcp.sql.SslCert("sqlClientCert",
            common_name="my-cert",
            instance=postgresqldb.name,
            opts=pulumi.ResourceOptions(depends_on=[postgresqldb]))
        sqldb_user = gcp.sql.User("sqldbUser",
            instance=postgresqldb.name,
            password="my-password",
            opts=pulumi.ResourceOptions(depends_on=[sql_client_cert]))
        postgresprofile = gcp.databasemigrationservice.ConnectionProfile("postgresprofile",
            location="us-central1",
            connection_profile_id="my-profileid",
            display_name="my-profileid_display",
            labels={
                "foo": "bar",
            },
            postgresql=gcp.databasemigrationservice.ConnectionProfilePostgresqlArgs(
                host=postgresqldb.ip_addresses[0].ip_address,
                port=5432,
                username=sqldb_user.name,
                password=sqldb_user.password,
                ssl=gcp.databasemigrationservice.ConnectionProfilePostgresqlSslArgs(
                    client_key=sql_client_cert.private_key,
                    client_certificate=sql_client_cert.cert,
                    ca_certificate=sql_client_cert.server_ca_cert,
                ),
                cloud_sql_id="my-database",
            ),
            opts=pulumi.ResourceOptions(depends_on=[sqldb_user]))
        ```

        ## Import

        ConnectionProfile can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:databasemigrationservice/connectionProfile:ConnectionProfile default projects/{{project}}/locations/{{location}}/connectionProfiles/{{connection_profile_id}}
        ```

        ```sh
         $ pulumi import gcp:databasemigrationservice/connectionProfile:ConnectionProfile default {{project}}/{{location}}/{{connection_profile_id}}
        ```

        ```sh
         $ pulumi import gcp:databasemigrationservice/connectionProfile:ConnectionProfile default {{location}}/{{connection_profile_id}}
        ```

        :param str resource_name: The name of the resource.
        :param ConnectionProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConnectionProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alloydb: Optional[pulumi.Input[pulumi.InputType['ConnectionProfileAlloydbArgs']]] = None,
                 cloudsql: Optional[pulumi.Input[pulumi.InputType['ConnectionProfileCloudsqlArgs']]] = None,
                 connection_profile_id: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 mysql: Optional[pulumi.Input[pulumi.InputType['ConnectionProfileMysqlArgs']]] = None,
                 postgresql: Optional[pulumi.Input[pulumi.InputType['ConnectionProfilePostgresqlArgs']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConnectionProfileArgs.__new__(ConnectionProfileArgs)

            __props__.__dict__["alloydb"] = alloydb
            __props__.__dict__["cloudsql"] = cloudsql
            if connection_profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'connection_profile_id'")
            __props__.__dict__["connection_profile_id"] = connection_profile_id
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["labels"] = labels
            __props__.__dict__["location"] = location
            __props__.__dict__["mysql"] = mysql
            __props__.__dict__["postgresql"] = postgresql
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["dbprovider"] = None
            __props__.__dict__["errors"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["state"] = None
        super(ConnectionProfile, __self__).__init__(
            'gcp:databasemigrationservice/connectionProfile:ConnectionProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alloydb: Optional[pulumi.Input[pulumi.InputType['ConnectionProfileAlloydbArgs']]] = None,
            cloudsql: Optional[pulumi.Input[pulumi.InputType['ConnectionProfileCloudsqlArgs']]] = None,
            connection_profile_id: Optional[pulumi.Input[str]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            dbprovider: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            errors: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConnectionProfileErrorArgs']]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            location: Optional[pulumi.Input[str]] = None,
            mysql: Optional[pulumi.Input[pulumi.InputType['ConnectionProfileMysqlArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            postgresql: Optional[pulumi.Input[pulumi.InputType['ConnectionProfilePostgresqlArgs']]] = None,
            project: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None) -> 'ConnectionProfile':
        """
        Get an existing ConnectionProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ConnectionProfileAlloydbArgs']] alloydb: Specifies required connection parameters, and the parameters required to create an AlloyDB destination cluster.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['ConnectionProfileCloudsqlArgs']] cloudsql: Specifies required connection parameters, and, optionally, the parameters required to create a Cloud SQL destination database instance.
               Structure is documented below.
        :param pulumi.Input[str] connection_profile_id: The ID of the connection profile.
               
               
               - - -
        :param pulumi.Input[str] create_time: Output only. The timestamp when the resource was created. A timestamp in RFC3339 UTC 'Zulu' format, accurate to nanoseconds. Example: '2014-10-02T15:01:23.045123456Z'.
        :param pulumi.Input[str] dbprovider: The database provider.
        :param pulumi.Input[str] display_name: The connection profile display name.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConnectionProfileErrorArgs']]]] errors: Output only. The error details in case of state FAILED.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: The resource labels for connection profile to use to annotate any related underlying resources such as Compute Engine VMs.
        :param pulumi.Input[str] location: The location where the connection profile should reside.
        :param pulumi.Input[pulumi.InputType['ConnectionProfileMysqlArgs']] mysql: Specifies connection parameters required specifically for MySQL databases.
               Structure is documented below.
        :param pulumi.Input[str] name: The name of this connection profile resource in the form of projects/{project}/locations/{location}/connectionProfiles/{connectionProfile}.
        :param pulumi.Input[pulumi.InputType['ConnectionProfilePostgresqlArgs']] postgresql: Specifies connection parameters required specifically for PostgreSQL databases.
               Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] state: The current connection profile state.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConnectionProfileState.__new__(_ConnectionProfileState)

        __props__.__dict__["alloydb"] = alloydb
        __props__.__dict__["cloudsql"] = cloudsql
        __props__.__dict__["connection_profile_id"] = connection_profile_id
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["dbprovider"] = dbprovider
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["errors"] = errors
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["mysql"] = mysql
        __props__.__dict__["name"] = name
        __props__.__dict__["postgresql"] = postgresql
        __props__.__dict__["project"] = project
        __props__.__dict__["state"] = state
        return ConnectionProfile(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def alloydb(self) -> pulumi.Output[Optional['outputs.ConnectionProfileAlloydb']]:
        """
        Specifies required connection parameters, and the parameters required to create an AlloyDB destination cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "alloydb")

    @property
    @pulumi.getter
    def cloudsql(self) -> pulumi.Output[Optional['outputs.ConnectionProfileCloudsql']]:
        """
        Specifies required connection parameters, and, optionally, the parameters required to create a Cloud SQL destination database instance.
        Structure is documented below.
        """
        return pulumi.get(self, "cloudsql")

    @property
    @pulumi.getter(name="connectionProfileId")
    def connection_profile_id(self) -> pulumi.Output[str]:
        """
        The ID of the connection profile.


        - - -
        """
        return pulumi.get(self, "connection_profile_id")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Output only. The timestamp when the resource was created. A timestamp in RFC3339 UTC 'Zulu' format, accurate to nanoseconds. Example: '2014-10-02T15:01:23.045123456Z'.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def dbprovider(self) -> pulumi.Output[str]:
        """
        The database provider.
        """
        return pulumi.get(self, "dbprovider")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[str]]:
        """
        The connection profile display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def errors(self) -> pulumi.Output[Sequence['outputs.ConnectionProfileError']]:
        """
        Output only. The error details in case of state FAILED.
        Structure is documented below.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        The resource labels for connection profile to use to annotate any related underlying resources such as Compute Engine VMs.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[str]]:
        """
        The location where the connection profile should reside.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def mysql(self) -> pulumi.Output[Optional['outputs.ConnectionProfileMysql']]:
        """
        Specifies connection parameters required specifically for MySQL databases.
        Structure is documented below.
        """
        return pulumi.get(self, "mysql")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of this connection profile resource in the form of projects/{project}/locations/{location}/connectionProfiles/{connectionProfile}.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def postgresql(self) -> pulumi.Output[Optional['outputs.ConnectionProfilePostgresql']]:
        """
        Specifies connection parameters required specifically for PostgreSQL databases.
        Structure is documented below.
        """
        return pulumi.get(self, "postgresql")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current connection profile state.
        """
        return pulumi.get(self, "state")

