# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PreventionJobTriggerArgs', 'PreventionJobTrigger']

@pulumi.input_type
class PreventionJobTriggerArgs:
    def __init__(__self__, *,
                 parent: pulumi.Input[str],
                 triggers: pulumi.Input[Sequence[pulumi.Input['PreventionJobTriggerTriggerArgs']]],
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 inspect_job: Optional[pulumi.Input['PreventionJobTriggerInspectJobArgs']] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 trigger_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a PreventionJobTrigger resource.
        :param pulumi.Input[str] parent: The parent of the trigger, either in the format `projects/{{project}}`
               or `projects/{{project}}/locations/{{location}}`
        :param pulumi.Input[Sequence[pulumi.Input['PreventionJobTriggerTriggerArgs']]] triggers: What event needs to occur for a new job to be started.
               Structure is documented below.
        :param pulumi.Input[str] description: A description of the job trigger.
               
               (Optional)
               A short description of where the data is coming from. Will be stored once in the job. 256 max length.
        :param pulumi.Input[str] display_name: User set display name of the job trigger.
        :param pulumi.Input['PreventionJobTriggerInspectJobArgs'] inspect_job: Controls what and how to inspect for findings.
               Structure is documented below.
        :param pulumi.Input[str] status: Whether the trigger is currently active.
               Default value is `HEALTHY`.
               Possible values are: `PAUSED`, `HEALTHY`, `CANCELLED`.
        :param pulumi.Input[str] trigger_id: The trigger id can contain uppercase and lowercase letters, numbers, and hyphens;
               that is, it must match the regular expression: [a-zA-Z\\d-_]+.
               The maximum length is 100 characters. Can be empty to allow the system to generate one.
        """
        pulumi.set(__self__, "parent", parent)
        pulumi.set(__self__, "triggers", triggers)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if inspect_job is not None:
            pulumi.set(__self__, "inspect_job", inspect_job)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if trigger_id is not None:
            pulumi.set(__self__, "trigger_id", trigger_id)

    @property
    @pulumi.getter
    def parent(self) -> pulumi.Input[str]:
        """
        The parent of the trigger, either in the format `projects/{{project}}`
        or `projects/{{project}}/locations/{{location}}`
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: pulumi.Input[str]):
        pulumi.set(self, "parent", value)

    @property
    @pulumi.getter
    def triggers(self) -> pulumi.Input[Sequence[pulumi.Input['PreventionJobTriggerTriggerArgs']]]:
        """
        What event needs to occur for a new job to be started.
        Structure is documented below.
        """
        return pulumi.get(self, "triggers")

    @triggers.setter
    def triggers(self, value: pulumi.Input[Sequence[pulumi.Input['PreventionJobTriggerTriggerArgs']]]):
        pulumi.set(self, "triggers", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the job trigger.

        (Optional)
        A short description of where the data is coming from. Will be stored once in the job. 256 max length.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        User set display name of the job trigger.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="inspectJob")
    def inspect_job(self) -> Optional[pulumi.Input['PreventionJobTriggerInspectJobArgs']]:
        """
        Controls what and how to inspect for findings.
        Structure is documented below.
        """
        return pulumi.get(self, "inspect_job")

    @inspect_job.setter
    def inspect_job(self, value: Optional[pulumi.Input['PreventionJobTriggerInspectJobArgs']]):
        pulumi.set(self, "inspect_job", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Whether the trigger is currently active.
        Default value is `HEALTHY`.
        Possible values are: `PAUSED`, `HEALTHY`, `CANCELLED`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="triggerId")
    def trigger_id(self) -> Optional[pulumi.Input[str]]:
        """
        The trigger id can contain uppercase and lowercase letters, numbers, and hyphens;
        that is, it must match the regular expression: [a-zA-Z\\d-_]+.
        The maximum length is 100 characters. Can be empty to allow the system to generate one.
        """
        return pulumi.get(self, "trigger_id")

    @trigger_id.setter
    def trigger_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "trigger_id", value)


@pulumi.input_type
class _PreventionJobTriggerState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 inspect_job: Optional[pulumi.Input['PreventionJobTriggerInspectJobArgs']] = None,
                 last_run_time: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parent: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 trigger_id: Optional[pulumi.Input[str]] = None,
                 triggers: Optional[pulumi.Input[Sequence[pulumi.Input['PreventionJobTriggerTriggerArgs']]]] = None,
                 update_time: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering PreventionJobTrigger resources.
        :param pulumi.Input[str] create_time: (Output)
               The creation timestamp of an inspectTemplate. Set by the server.
        :param pulumi.Input[str] description: A description of the job trigger.
               
               (Optional)
               A short description of where the data is coming from. Will be stored once in the job. 256 max length.
        :param pulumi.Input[str] display_name: User set display name of the job trigger.
        :param pulumi.Input['PreventionJobTriggerInspectJobArgs'] inspect_job: Controls what and how to inspect for findings.
               Structure is documented below.
        :param pulumi.Input[str] last_run_time: The timestamp of the last time this trigger executed.
        :param pulumi.Input[str] name: Name of the information type. Either a name of your choosing when creating a CustomInfoType, or one of the names listed
               at https://cloud.google.com/dlp/docs/infotypes-reference when specifying a built-in type.
               
               (Required)
               Name of the information type. Either a name of your choosing when creating a CustomInfoType, or one of the names listed
               at https://cloud.google.com/dlp/docs/infotypes-reference when specifying a built-in type.
               
               (Required)
               Name of the information type. Either a name of your choosing when creating a CustomInfoType, or one of the names listed
               at https://cloud.google.com/dlp/docs/infotypes-reference when specifying a built-in type.
               
               (Required)
               Name of the information type. Either a name of your choosing when creating a CustomInfoType, or one of the names listed
               at https://cloud.google.com/dlp/docs/infotypes-reference when specifying a built-in type.
               
               (Required)
               Name of the information type. Either a name of your choosing when creating a CustomInfoType, or one of the names
               listed at https://cloud.google.com/dlp/docs/infotypes-reference when specifying a built-in type.
               
               (Required)
               Resource name of the requested StoredInfoType, for example `organizations/433245324/storedInfoTypes/432452342`
               or `projects/project-id/storedInfoTypes/432452342`.
               
               (Required)
               Specification of the field containing the timestamp of scanned items. Used for data sources like Datastore and BigQuery.
               For BigQuery: Required to filter out rows based on the given start and end times. If not specified and the table was
               modified between the given start and end times, the entire table will be scanned. The valid data types of the timestamp
               field are: INTEGER, DATE, TIMESTAMP, or DATETIME BigQuery column.
               For Datastore. Valid data types of the timestamp field are: TIMESTAMP. Datastore entity will be scanned if the
               timestamp property does not exist or its value is empty or invalid.
               
               (Required)
               The name of the Datastore kind.
               
               (Required)
               Name of a BigQuery field to be returned with the findings.
               
               (Required)
               Name describing the field to which scanning is limited.
               
               (Required)
               Name describing the field excluded from scanning.
               
               (Required)
               Name describing the field.
        :param pulumi.Input[str] parent: The parent of the trigger, either in the format `projects/{{project}}`
               or `projects/{{project}}/locations/{{location}}`
        :param pulumi.Input[str] status: Whether the trigger is currently active.
               Default value is `HEALTHY`.
               Possible values are: `PAUSED`, `HEALTHY`, `CANCELLED`.
        :param pulumi.Input[str] trigger_id: The trigger id can contain uppercase and lowercase letters, numbers, and hyphens;
               that is, it must match the regular expression: [a-zA-Z\\d-_]+.
               The maximum length is 100 characters. Can be empty to allow the system to generate one.
        :param pulumi.Input[Sequence[pulumi.Input['PreventionJobTriggerTriggerArgs']]] triggers: What event needs to occur for a new job to be started.
               Structure is documented below.
        :param pulumi.Input[str] update_time: The last update timestamp of an inspectTemplate. Set by the server.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if inspect_job is not None:
            pulumi.set(__self__, "inspect_job", inspect_job)
        if last_run_time is not None:
            pulumi.set(__self__, "last_run_time", last_run_time)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if trigger_id is not None:
            pulumi.set(__self__, "trigger_id", trigger_id)
        if triggers is not None:
            pulumi.set(__self__, "triggers", triggers)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        The creation timestamp of an inspectTemplate. Set by the server.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the job trigger.

        (Optional)
        A short description of where the data is coming from. Will be stored once in the job. 256 max length.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        User set display name of the job trigger.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="inspectJob")
    def inspect_job(self) -> Optional[pulumi.Input['PreventionJobTriggerInspectJobArgs']]:
        """
        Controls what and how to inspect for findings.
        Structure is documented below.
        """
        return pulumi.get(self, "inspect_job")

    @inspect_job.setter
    def inspect_job(self, value: Optional[pulumi.Input['PreventionJobTriggerInspectJobArgs']]):
        pulumi.set(self, "inspect_job", value)

    @property
    @pulumi.getter(name="lastRunTime")
    def last_run_time(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp of the last time this trigger executed.
        """
        return pulumi.get(self, "last_run_time")

    @last_run_time.setter
    def last_run_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_run_time", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the information type. Either a name of your choosing when creating a CustomInfoType, or one of the names listed
        at https://cloud.google.com/dlp/docs/infotypes-reference when specifying a built-in type.

        (Required)
        Name of the information type. Either a name of your choosing when creating a CustomInfoType, or one of the names listed
        at https://cloud.google.com/dlp/docs/infotypes-reference when specifying a built-in type.

        (Required)
        Name of the information type. Either a name of your choosing when creating a CustomInfoType, or one of the names listed
        at https://cloud.google.com/dlp/docs/infotypes-reference when specifying a built-in type.

        (Required)
        Name of the information type. Either a name of your choosing when creating a CustomInfoType, or one of the names listed
        at https://cloud.google.com/dlp/docs/infotypes-reference when specifying a built-in type.

        (Required)
        Name of the information type. Either a name of your choosing when creating a CustomInfoType, or one of the names
        listed at https://cloud.google.com/dlp/docs/infotypes-reference when specifying a built-in type.

        (Required)
        Resource name of the requested StoredInfoType, for example `organizations/433245324/storedInfoTypes/432452342`
        or `projects/project-id/storedInfoTypes/432452342`.

        (Required)
        Specification of the field containing the timestamp of scanned items. Used for data sources like Datastore and BigQuery.
        For BigQuery: Required to filter out rows based on the given start and end times. If not specified and the table was
        modified between the given start and end times, the entire table will be scanned. The valid data types of the timestamp
        field are: INTEGER, DATE, TIMESTAMP, or DATETIME BigQuery column.
        For Datastore. Valid data types of the timestamp field are: TIMESTAMP. Datastore entity will be scanned if the
        timestamp property does not exist or its value is empty or invalid.

        (Required)
        The name of the Datastore kind.

        (Required)
        Name of a BigQuery field to be returned with the findings.

        (Required)
        Name describing the field to which scanning is limited.

        (Required)
        Name describing the field excluded from scanning.

        (Required)
        Name describing the field.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[str]]:
        """
        The parent of the trigger, either in the format `projects/{{project}}`
        or `projects/{{project}}/locations/{{location}}`
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Whether the trigger is currently active.
        Default value is `HEALTHY`.
        Possible values are: `PAUSED`, `HEALTHY`, `CANCELLED`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="triggerId")
    def trigger_id(self) -> Optional[pulumi.Input[str]]:
        """
        The trigger id can contain uppercase and lowercase letters, numbers, and hyphens;
        that is, it must match the regular expression: [a-zA-Z\\d-_]+.
        The maximum length is 100 characters. Can be empty to allow the system to generate one.
        """
        return pulumi.get(self, "trigger_id")

    @trigger_id.setter
    def trigger_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "trigger_id", value)

    @property
    @pulumi.getter
    def triggers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PreventionJobTriggerTriggerArgs']]]]:
        """
        What event needs to occur for a new job to be started.
        Structure is documented below.
        """
        return pulumi.get(self, "triggers")

    @triggers.setter
    def triggers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PreventionJobTriggerTriggerArgs']]]]):
        pulumi.set(self, "triggers", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        The last update timestamp of an inspectTemplate. Set by the server.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)


class PreventionJobTrigger(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 inspect_job: Optional[pulumi.Input[pulumi.InputType['PreventionJobTriggerInspectJobArgs']]] = None,
                 parent: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 trigger_id: Optional[pulumi.Input[str]] = None,
                 triggers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PreventionJobTriggerTriggerArgs']]]]] = None,
                 __props__=None):
        """
        A job trigger configuration.

        To get more information about JobTrigger, see:

        * [API documentation](https://cloud.google.com/dlp/docs/reference/rest/v2/projects.jobTriggers)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dlp/docs/creating-job-triggers)

        ## Example Usage
        ### Dlp Job Trigger Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.dataloss.PreventionJobTrigger("basic",
            description="Description",
            display_name="Displayname",
            inspect_job=gcp.dataloss.PreventionJobTriggerInspectJobArgs(
                actions=[gcp.dataloss.PreventionJobTriggerInspectJobActionArgs(
                    save_findings=gcp.dataloss.PreventionJobTriggerInspectJobActionSaveFindingsArgs(
                        output_config=gcp.dataloss.PreventionJobTriggerInspectJobActionSaveFindingsOutputConfigArgs(
                            table=gcp.dataloss.PreventionJobTriggerInspectJobActionSaveFindingsOutputConfigTableArgs(
                                dataset_id="dataset",
                                project_id="project",
                            ),
                        ),
                    ),
                )],
                inspect_template_name="fake",
                storage_config=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigArgs(
                    cloud_storage_options=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsArgs(
                        file_set=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetArgs(
                            url="gs://mybucket/directory/",
                        ),
                    ),
                ),
            ),
            parent="projects/my-project-name",
            triggers=[gcp.dataloss.PreventionJobTriggerTriggerArgs(
                schedule=gcp.dataloss.PreventionJobTriggerTriggerScheduleArgs(
                    recurrence_period_duration="86400s",
                ),
            )])
        ```
        ### Dlp Job Trigger Bigquery Row Limit

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bigquery_row_limit = gcp.dataloss.PreventionJobTrigger("bigqueryRowLimit",
            description="Description",
            display_name="Displayname",
            inspect_job=gcp.dataloss.PreventionJobTriggerInspectJobArgs(
                actions=[gcp.dataloss.PreventionJobTriggerInspectJobActionArgs(
                    save_findings=gcp.dataloss.PreventionJobTriggerInspectJobActionSaveFindingsArgs(
                        output_config=gcp.dataloss.PreventionJobTriggerInspectJobActionSaveFindingsOutputConfigArgs(
                            table=gcp.dataloss.PreventionJobTriggerInspectJobActionSaveFindingsOutputConfigTableArgs(
                                dataset_id="dataset",
                                project_id="project",
                            ),
                        ),
                    ),
                )],
                inspect_template_name="fake",
                storage_config=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigArgs(
                    big_query_options=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigBigQueryOptionsArgs(
                        rows_limit=1000,
                        sample_method="RANDOM_START",
                        table_reference=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReferenceArgs(
                            dataset_id="dataset",
                            project_id="project",
                            table_id="table_to_scan",
                        ),
                    ),
                ),
            ),
            parent="projects/my-project-name",
            triggers=[gcp.dataloss.PreventionJobTriggerTriggerArgs(
                schedule=gcp.dataloss.PreventionJobTriggerTriggerScheduleArgs(
                    recurrence_period_duration="86400s",
                ),
            )])
        ```
        ### Dlp Job Trigger Bigquery Row Limit Percentage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bigquery_row_limit_percentage = gcp.dataloss.PreventionJobTrigger("bigqueryRowLimitPercentage",
            description="Description",
            display_name="Displayname",
            inspect_job=gcp.dataloss.PreventionJobTriggerInspectJobArgs(
                actions=[gcp.dataloss.PreventionJobTriggerInspectJobActionArgs(
                    save_findings=gcp.dataloss.PreventionJobTriggerInspectJobActionSaveFindingsArgs(
                        output_config=gcp.dataloss.PreventionJobTriggerInspectJobActionSaveFindingsOutputConfigArgs(
                            table=gcp.dataloss.PreventionJobTriggerInspectJobActionSaveFindingsOutputConfigTableArgs(
                                dataset_id="dataset",
                                project_id="project",
                            ),
                        ),
                    ),
                )],
                inspect_template_name="fake",
                storage_config=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigArgs(
                    big_query_options=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigBigQueryOptionsArgs(
                        rows_limit_percent=50,
                        sample_method="RANDOM_START",
                        table_reference=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReferenceArgs(
                            dataset_id="dataset",
                            project_id="project",
                            table_id="table_to_scan",
                        ),
                    ),
                ),
            ),
            parent="projects/my-project-name",
            triggers=[gcp.dataloss.PreventionJobTriggerTriggerArgs(
                schedule=gcp.dataloss.PreventionJobTriggerTriggerScheduleArgs(
                    recurrence_period_duration="86400s",
                ),
            )])
        ```
        ### Dlp Job Trigger Job Notification Emails

        ```python
        import pulumi
        import pulumi_gcp as gcp

        job_notification_emails = gcp.dataloss.PreventionJobTrigger("jobNotificationEmails",
            description="Description for the job_trigger created by terraform",
            display_name="TerraformDisplayName",
            inspect_job=gcp.dataloss.PreventionJobTriggerInspectJobArgs(
                actions=[gcp.dataloss.PreventionJobTriggerInspectJobActionArgs(
                    job_notification_emails=gcp.dataloss.PreventionJobTriggerInspectJobActionJobNotificationEmailsArgs(),
                )],
                inspect_template_name="sample-inspect-template",
                storage_config=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigArgs(
                    cloud_storage_options=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsArgs(
                        file_set=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetArgs(
                            url="gs://mybucket/directory/",
                        ),
                    ),
                ),
            ),
            parent="projects/my-project-name",
            triggers=[gcp.dataloss.PreventionJobTriggerTriggerArgs(
                schedule=gcp.dataloss.PreventionJobTriggerTriggerScheduleArgs(
                    recurrence_period_duration="86400s",
                ),
            )])
        ```
        ### Dlp Job Trigger Deidentify

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_dataset = gcp.bigquery.Dataset("defaultDataset",
            dataset_id="tf_test",
            friendly_name="terraform-test",
            description="Description for the dataset created by terraform",
            location="US",
            default_table_expiration_ms=3600000,
            labels={
                "env": "default",
            })
        default_table = gcp.bigquery.Table("defaultTable",
            dataset_id=default_dataset.dataset_id,
            table_id="tf_test",
            deletion_protection=False,
            time_partitioning=gcp.bigquery.TableTimePartitioningArgs(
                type="DAY",
            ),
            labels={
                "env": "default",
            },
            schema=\"\"\"    [
            {
              "name": "quantity",
              "type": "NUMERIC",
              "mode": "NULLABLE",
              "description": "The quantity"
            },
            {
              "name": "name",
              "type": "STRING",
              "mode": "NULLABLE",
              "description": "Name of the object"
            }
            ]
        \"\"\")
        deidentify = gcp.dataloss.PreventionJobTrigger("deidentify",
            parent="projects/my-project-name",
            description="Description for the job_trigger created by terraform",
            display_name="TerraformDisplayName",
            triggers=[gcp.dataloss.PreventionJobTriggerTriggerArgs(
                schedule=gcp.dataloss.PreventionJobTriggerTriggerScheduleArgs(
                    recurrence_period_duration="86400s",
                ),
            )],
            inspect_job=gcp.dataloss.PreventionJobTriggerInspectJobArgs(
                inspect_template_name="sample-inspect-template",
                actions=[gcp.dataloss.PreventionJobTriggerInspectJobActionArgs(
                    deidentify=gcp.dataloss.PreventionJobTriggerInspectJobActionDeidentifyArgs(
                        cloud_storage_output="gs://samplebucket/dir/",
                        file_types_to_transforms=[
                            "CSV",
                            "TSV",
                        ],
                        transformation_details_storage_config=gcp.dataloss.PreventionJobTriggerInspectJobActionDeidentifyTransformationDetailsStorageConfigArgs(
                            table=gcp.dataloss.PreventionJobTriggerInspectJobActionDeidentifyTransformationDetailsStorageConfigTableArgs(
                                project_id="my-project-name",
                                dataset_id=default_dataset.dataset_id,
                                table_id=default_table.table_id,
                            ),
                        ),
                        transformation_config=gcp.dataloss.PreventionJobTriggerInspectJobActionDeidentifyTransformationConfigArgs(
                            deidentify_template="sample-deidentify-template",
                            image_redact_template="sample-image-redact-template",
                            structured_deidentify_template="sample-structured-deidentify-template",
                        ),
                    ),
                )],
                storage_config=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigArgs(
                    cloud_storage_options=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsArgs(
                        file_set=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetArgs(
                            url="gs://mybucket/directory/",
                        ),
                    ),
                ),
            ))
        ```
        ### Dlp Job Trigger Hybrid

        ```python
        import pulumi
        import pulumi_gcp as gcp

        hybrid_trigger = gcp.dataloss.PreventionJobTrigger("hybridTrigger",
            inspect_job=gcp.dataloss.PreventionJobTriggerInspectJobArgs(
                actions=[gcp.dataloss.PreventionJobTriggerInspectJobActionArgs(
                    save_findings=gcp.dataloss.PreventionJobTriggerInspectJobActionSaveFindingsArgs(
                        output_config=gcp.dataloss.PreventionJobTriggerInspectJobActionSaveFindingsOutputConfigArgs(
                            table=gcp.dataloss.PreventionJobTriggerInspectJobActionSaveFindingsOutputConfigTableArgs(
                                dataset_id="dataset",
                                project_id="project",
                            ),
                        ),
                    ),
                )],
                inspect_template_name="fake",
                storage_config=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigArgs(
                    hybrid_options=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigHybridOptionsArgs(
                        description="Hybrid job trigger for data from the comments field of a table that contains customer appointment bookings",
                        labels={
                            "env": "prod",
                        },
                        required_finding_label_keys=["appointment-bookings-comments"],
                        table_options=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigHybridOptionsTableOptionsArgs(
                            identifying_fields=[gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigHybridOptionsTableOptionsIdentifyingFieldArgs(
                                name="booking_id",
                            )],
                        ),
                    ),
                ),
            ),
            parent="projects/my-project-name",
            triggers=[gcp.dataloss.PreventionJobTriggerTriggerArgs(
                manual=gcp.dataloss.PreventionJobTriggerTriggerManualArgs(),
            )])
        ```
        ### Dlp Job Trigger Publish To Stackdriver

        ```python
        import pulumi
        import pulumi_gcp as gcp

        publish_to_stackdriver = gcp.dataloss.PreventionJobTrigger("publishToStackdriver",
            description="Description for the job_trigger created by terraform",
            display_name="TerraformDisplayName",
            inspect_job=gcp.dataloss.PreventionJobTriggerInspectJobArgs(
                actions=[gcp.dataloss.PreventionJobTriggerInspectJobActionArgs(
                    publish_to_stackdriver=gcp.dataloss.PreventionJobTriggerInspectJobActionPublishToStackdriverArgs(),
                )],
                inspect_template_name="sample-inspect-template",
                storage_config=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigArgs(
                    cloud_storage_options=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsArgs(
                        file_set=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetArgs(
                            url="gs://mybucket/directory/",
                        ),
                    ),
                ),
            ),
            parent="projects/my-project-name",
            triggers=[gcp.dataloss.PreventionJobTriggerTriggerArgs(
                schedule=gcp.dataloss.PreventionJobTriggerTriggerScheduleArgs(
                    recurrence_period_duration="86400s",
                ),
            )])
        ```
        ### Dlp Job Trigger With Id

        ```python
        import pulumi
        import pulumi_gcp as gcp

        with_trigger_id = gcp.dataloss.PreventionJobTrigger("withTriggerId",
            description="Starting description",
            display_name="display",
            inspect_job=gcp.dataloss.PreventionJobTriggerInspectJobArgs(
                actions=[gcp.dataloss.PreventionJobTriggerInspectJobActionArgs(
                    save_findings=gcp.dataloss.PreventionJobTriggerInspectJobActionSaveFindingsArgs(
                        output_config=gcp.dataloss.PreventionJobTriggerInspectJobActionSaveFindingsOutputConfigArgs(
                            table=gcp.dataloss.PreventionJobTriggerInspectJobActionSaveFindingsOutputConfigTableArgs(
                                dataset_id="dataset123",
                                project_id="project",
                            ),
                        ),
                    ),
                )],
                inspect_template_name="fake",
                storage_config=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigArgs(
                    cloud_storage_options=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsArgs(
                        file_set=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetArgs(
                            url="gs://mybucket/directory/",
                        ),
                    ),
                ),
            ),
            parent="projects/my-project-name",
            trigger_id="id-",
            triggers=[gcp.dataloss.PreventionJobTriggerTriggerArgs(
                schedule=gcp.dataloss.PreventionJobTriggerTriggerScheduleArgs(
                    recurrence_period_duration="86400s",
                ),
            )])
        ```

        ## Import

        JobTrigger can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:dataloss/preventionJobTrigger:PreventionJobTrigger default {{parent}}/jobTriggers/{{name}}
        ```

        ```sh
         $ pulumi import gcp:dataloss/preventionJobTrigger:PreventionJobTrigger default {{parent}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A description of the job trigger.
               
               (Optional)
               A short description of where the data is coming from. Will be stored once in the job. 256 max length.
        :param pulumi.Input[str] display_name: User set display name of the job trigger.
        :param pulumi.Input[pulumi.InputType['PreventionJobTriggerInspectJobArgs']] inspect_job: Controls what and how to inspect for findings.
               Structure is documented below.
        :param pulumi.Input[str] parent: The parent of the trigger, either in the format `projects/{{project}}`
               or `projects/{{project}}/locations/{{location}}`
        :param pulumi.Input[str] status: Whether the trigger is currently active.
               Default value is `HEALTHY`.
               Possible values are: `PAUSED`, `HEALTHY`, `CANCELLED`.
        :param pulumi.Input[str] trigger_id: The trigger id can contain uppercase and lowercase letters, numbers, and hyphens;
               that is, it must match the regular expression: [a-zA-Z\\d-_]+.
               The maximum length is 100 characters. Can be empty to allow the system to generate one.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PreventionJobTriggerTriggerArgs']]]] triggers: What event needs to occur for a new job to be started.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PreventionJobTriggerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A job trigger configuration.

        To get more information about JobTrigger, see:

        * [API documentation](https://cloud.google.com/dlp/docs/reference/rest/v2/projects.jobTriggers)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dlp/docs/creating-job-triggers)

        ## Example Usage
        ### Dlp Job Trigger Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.dataloss.PreventionJobTrigger("basic",
            description="Description",
            display_name="Displayname",
            inspect_job=gcp.dataloss.PreventionJobTriggerInspectJobArgs(
                actions=[gcp.dataloss.PreventionJobTriggerInspectJobActionArgs(
                    save_findings=gcp.dataloss.PreventionJobTriggerInspectJobActionSaveFindingsArgs(
                        output_config=gcp.dataloss.PreventionJobTriggerInspectJobActionSaveFindingsOutputConfigArgs(
                            table=gcp.dataloss.PreventionJobTriggerInspectJobActionSaveFindingsOutputConfigTableArgs(
                                dataset_id="dataset",
                                project_id="project",
                            ),
                        ),
                    ),
                )],
                inspect_template_name="fake",
                storage_config=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigArgs(
                    cloud_storage_options=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsArgs(
                        file_set=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetArgs(
                            url="gs://mybucket/directory/",
                        ),
                    ),
                ),
            ),
            parent="projects/my-project-name",
            triggers=[gcp.dataloss.PreventionJobTriggerTriggerArgs(
                schedule=gcp.dataloss.PreventionJobTriggerTriggerScheduleArgs(
                    recurrence_period_duration="86400s",
                ),
            )])
        ```
        ### Dlp Job Trigger Bigquery Row Limit

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bigquery_row_limit = gcp.dataloss.PreventionJobTrigger("bigqueryRowLimit",
            description="Description",
            display_name="Displayname",
            inspect_job=gcp.dataloss.PreventionJobTriggerInspectJobArgs(
                actions=[gcp.dataloss.PreventionJobTriggerInspectJobActionArgs(
                    save_findings=gcp.dataloss.PreventionJobTriggerInspectJobActionSaveFindingsArgs(
                        output_config=gcp.dataloss.PreventionJobTriggerInspectJobActionSaveFindingsOutputConfigArgs(
                            table=gcp.dataloss.PreventionJobTriggerInspectJobActionSaveFindingsOutputConfigTableArgs(
                                dataset_id="dataset",
                                project_id="project",
                            ),
                        ),
                    ),
                )],
                inspect_template_name="fake",
                storage_config=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigArgs(
                    big_query_options=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigBigQueryOptionsArgs(
                        rows_limit=1000,
                        sample_method="RANDOM_START",
                        table_reference=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReferenceArgs(
                            dataset_id="dataset",
                            project_id="project",
                            table_id="table_to_scan",
                        ),
                    ),
                ),
            ),
            parent="projects/my-project-name",
            triggers=[gcp.dataloss.PreventionJobTriggerTriggerArgs(
                schedule=gcp.dataloss.PreventionJobTriggerTriggerScheduleArgs(
                    recurrence_period_duration="86400s",
                ),
            )])
        ```
        ### Dlp Job Trigger Bigquery Row Limit Percentage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bigquery_row_limit_percentage = gcp.dataloss.PreventionJobTrigger("bigqueryRowLimitPercentage",
            description="Description",
            display_name="Displayname",
            inspect_job=gcp.dataloss.PreventionJobTriggerInspectJobArgs(
                actions=[gcp.dataloss.PreventionJobTriggerInspectJobActionArgs(
                    save_findings=gcp.dataloss.PreventionJobTriggerInspectJobActionSaveFindingsArgs(
                        output_config=gcp.dataloss.PreventionJobTriggerInspectJobActionSaveFindingsOutputConfigArgs(
                            table=gcp.dataloss.PreventionJobTriggerInspectJobActionSaveFindingsOutputConfigTableArgs(
                                dataset_id="dataset",
                                project_id="project",
                            ),
                        ),
                    ),
                )],
                inspect_template_name="fake",
                storage_config=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigArgs(
                    big_query_options=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigBigQueryOptionsArgs(
                        rows_limit_percent=50,
                        sample_method="RANDOM_START",
                        table_reference=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReferenceArgs(
                            dataset_id="dataset",
                            project_id="project",
                            table_id="table_to_scan",
                        ),
                    ),
                ),
            ),
            parent="projects/my-project-name",
            triggers=[gcp.dataloss.PreventionJobTriggerTriggerArgs(
                schedule=gcp.dataloss.PreventionJobTriggerTriggerScheduleArgs(
                    recurrence_period_duration="86400s",
                ),
            )])
        ```
        ### Dlp Job Trigger Job Notification Emails

        ```python
        import pulumi
        import pulumi_gcp as gcp

        job_notification_emails = gcp.dataloss.PreventionJobTrigger("jobNotificationEmails",
            description="Description for the job_trigger created by terraform",
            display_name="TerraformDisplayName",
            inspect_job=gcp.dataloss.PreventionJobTriggerInspectJobArgs(
                actions=[gcp.dataloss.PreventionJobTriggerInspectJobActionArgs(
                    job_notification_emails=gcp.dataloss.PreventionJobTriggerInspectJobActionJobNotificationEmailsArgs(),
                )],
                inspect_template_name="sample-inspect-template",
                storage_config=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigArgs(
                    cloud_storage_options=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsArgs(
                        file_set=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetArgs(
                            url="gs://mybucket/directory/",
                        ),
                    ),
                ),
            ),
            parent="projects/my-project-name",
            triggers=[gcp.dataloss.PreventionJobTriggerTriggerArgs(
                schedule=gcp.dataloss.PreventionJobTriggerTriggerScheduleArgs(
                    recurrence_period_duration="86400s",
                ),
            )])
        ```
        ### Dlp Job Trigger Deidentify

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_dataset = gcp.bigquery.Dataset("defaultDataset",
            dataset_id="tf_test",
            friendly_name="terraform-test",
            description="Description for the dataset created by terraform",
            location="US",
            default_table_expiration_ms=3600000,
            labels={
                "env": "default",
            })
        default_table = gcp.bigquery.Table("defaultTable",
            dataset_id=default_dataset.dataset_id,
            table_id="tf_test",
            deletion_protection=False,
            time_partitioning=gcp.bigquery.TableTimePartitioningArgs(
                type="DAY",
            ),
            labels={
                "env": "default",
            },
            schema=\"\"\"    [
            {
              "name": "quantity",
              "type": "NUMERIC",
              "mode": "NULLABLE",
              "description": "The quantity"
            },
            {
              "name": "name",
              "type": "STRING",
              "mode": "NULLABLE",
              "description": "Name of the object"
            }
            ]
        \"\"\")
        deidentify = gcp.dataloss.PreventionJobTrigger("deidentify",
            parent="projects/my-project-name",
            description="Description for the job_trigger created by terraform",
            display_name="TerraformDisplayName",
            triggers=[gcp.dataloss.PreventionJobTriggerTriggerArgs(
                schedule=gcp.dataloss.PreventionJobTriggerTriggerScheduleArgs(
                    recurrence_period_duration="86400s",
                ),
            )],
            inspect_job=gcp.dataloss.PreventionJobTriggerInspectJobArgs(
                inspect_template_name="sample-inspect-template",
                actions=[gcp.dataloss.PreventionJobTriggerInspectJobActionArgs(
                    deidentify=gcp.dataloss.PreventionJobTriggerInspectJobActionDeidentifyArgs(
                        cloud_storage_output="gs://samplebucket/dir/",
                        file_types_to_transforms=[
                            "CSV",
                            "TSV",
                        ],
                        transformation_details_storage_config=gcp.dataloss.PreventionJobTriggerInspectJobActionDeidentifyTransformationDetailsStorageConfigArgs(
                            table=gcp.dataloss.PreventionJobTriggerInspectJobActionDeidentifyTransformationDetailsStorageConfigTableArgs(
                                project_id="my-project-name",
                                dataset_id=default_dataset.dataset_id,
                                table_id=default_table.table_id,
                            ),
                        ),
                        transformation_config=gcp.dataloss.PreventionJobTriggerInspectJobActionDeidentifyTransformationConfigArgs(
                            deidentify_template="sample-deidentify-template",
                            image_redact_template="sample-image-redact-template",
                            structured_deidentify_template="sample-structured-deidentify-template",
                        ),
                    ),
                )],
                storage_config=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigArgs(
                    cloud_storage_options=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsArgs(
                        file_set=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetArgs(
                            url="gs://mybucket/directory/",
                        ),
                    ),
                ),
            ))
        ```
        ### Dlp Job Trigger Hybrid

        ```python
        import pulumi
        import pulumi_gcp as gcp

        hybrid_trigger = gcp.dataloss.PreventionJobTrigger("hybridTrigger",
            inspect_job=gcp.dataloss.PreventionJobTriggerInspectJobArgs(
                actions=[gcp.dataloss.PreventionJobTriggerInspectJobActionArgs(
                    save_findings=gcp.dataloss.PreventionJobTriggerInspectJobActionSaveFindingsArgs(
                        output_config=gcp.dataloss.PreventionJobTriggerInspectJobActionSaveFindingsOutputConfigArgs(
                            table=gcp.dataloss.PreventionJobTriggerInspectJobActionSaveFindingsOutputConfigTableArgs(
                                dataset_id="dataset",
                                project_id="project",
                            ),
                        ),
                    ),
                )],
                inspect_template_name="fake",
                storage_config=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigArgs(
                    hybrid_options=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigHybridOptionsArgs(
                        description="Hybrid job trigger for data from the comments field of a table that contains customer appointment bookings",
                        labels={
                            "env": "prod",
                        },
                        required_finding_label_keys=["appointment-bookings-comments"],
                        table_options=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigHybridOptionsTableOptionsArgs(
                            identifying_fields=[gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigHybridOptionsTableOptionsIdentifyingFieldArgs(
                                name="booking_id",
                            )],
                        ),
                    ),
                ),
            ),
            parent="projects/my-project-name",
            triggers=[gcp.dataloss.PreventionJobTriggerTriggerArgs(
                manual=gcp.dataloss.PreventionJobTriggerTriggerManualArgs(),
            )])
        ```
        ### Dlp Job Trigger Publish To Stackdriver

        ```python
        import pulumi
        import pulumi_gcp as gcp

        publish_to_stackdriver = gcp.dataloss.PreventionJobTrigger("publishToStackdriver",
            description="Description for the job_trigger created by terraform",
            display_name="TerraformDisplayName",
            inspect_job=gcp.dataloss.PreventionJobTriggerInspectJobArgs(
                actions=[gcp.dataloss.PreventionJobTriggerInspectJobActionArgs(
                    publish_to_stackdriver=gcp.dataloss.PreventionJobTriggerInspectJobActionPublishToStackdriverArgs(),
                )],
                inspect_template_name="sample-inspect-template",
                storage_config=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigArgs(
                    cloud_storage_options=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsArgs(
                        file_set=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetArgs(
                            url="gs://mybucket/directory/",
                        ),
                    ),
                ),
            ),
            parent="projects/my-project-name",
            triggers=[gcp.dataloss.PreventionJobTriggerTriggerArgs(
                schedule=gcp.dataloss.PreventionJobTriggerTriggerScheduleArgs(
                    recurrence_period_duration="86400s",
                ),
            )])
        ```
        ### Dlp Job Trigger With Id

        ```python
        import pulumi
        import pulumi_gcp as gcp

        with_trigger_id = gcp.dataloss.PreventionJobTrigger("withTriggerId",
            description="Starting description",
            display_name="display",
            inspect_job=gcp.dataloss.PreventionJobTriggerInspectJobArgs(
                actions=[gcp.dataloss.PreventionJobTriggerInspectJobActionArgs(
                    save_findings=gcp.dataloss.PreventionJobTriggerInspectJobActionSaveFindingsArgs(
                        output_config=gcp.dataloss.PreventionJobTriggerInspectJobActionSaveFindingsOutputConfigArgs(
                            table=gcp.dataloss.PreventionJobTriggerInspectJobActionSaveFindingsOutputConfigTableArgs(
                                dataset_id="dataset123",
                                project_id="project",
                            ),
                        ),
                    ),
                )],
                inspect_template_name="fake",
                storage_config=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigArgs(
                    cloud_storage_options=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsArgs(
                        file_set=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetArgs(
                            url="gs://mybucket/directory/",
                        ),
                    ),
                ),
            ),
            parent="projects/my-project-name",
            trigger_id="id-",
            triggers=[gcp.dataloss.PreventionJobTriggerTriggerArgs(
                schedule=gcp.dataloss.PreventionJobTriggerTriggerScheduleArgs(
                    recurrence_period_duration="86400s",
                ),
            )])
        ```

        ## Import

        JobTrigger can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:dataloss/preventionJobTrigger:PreventionJobTrigger default {{parent}}/jobTriggers/{{name}}
        ```

        ```sh
         $ pulumi import gcp:dataloss/preventionJobTrigger:PreventionJobTrigger default {{parent}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param PreventionJobTriggerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PreventionJobTriggerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 inspect_job: Optional[pulumi.Input[pulumi.InputType['PreventionJobTriggerInspectJobArgs']]] = None,
                 parent: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 trigger_id: Optional[pulumi.Input[str]] = None,
                 triggers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PreventionJobTriggerTriggerArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PreventionJobTriggerArgs.__new__(PreventionJobTriggerArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["inspect_job"] = inspect_job
            if parent is None and not opts.urn:
                raise TypeError("Missing required property 'parent'")
            __props__.__dict__["parent"] = parent
            __props__.__dict__["status"] = status
            __props__.__dict__["trigger_id"] = trigger_id
            if triggers is None and not opts.urn:
                raise TypeError("Missing required property 'triggers'")
            __props__.__dict__["triggers"] = triggers
            __props__.__dict__["create_time"] = None
            __props__.__dict__["last_run_time"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["update_time"] = None
        super(PreventionJobTrigger, __self__).__init__(
            'gcp:dataloss/preventionJobTrigger:PreventionJobTrigger',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            inspect_job: Optional[pulumi.Input[pulumi.InputType['PreventionJobTriggerInspectJobArgs']]] = None,
            last_run_time: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            parent: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            trigger_id: Optional[pulumi.Input[str]] = None,
            triggers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PreventionJobTriggerTriggerArgs']]]]] = None,
            update_time: Optional[pulumi.Input[str]] = None) -> 'PreventionJobTrigger':
        """
        Get an existing PreventionJobTrigger resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] create_time: (Output)
               The creation timestamp of an inspectTemplate. Set by the server.
        :param pulumi.Input[str] description: A description of the job trigger.
               
               (Optional)
               A short description of where the data is coming from. Will be stored once in the job. 256 max length.
        :param pulumi.Input[str] display_name: User set display name of the job trigger.
        :param pulumi.Input[pulumi.InputType['PreventionJobTriggerInspectJobArgs']] inspect_job: Controls what and how to inspect for findings.
               Structure is documented below.
        :param pulumi.Input[str] last_run_time: The timestamp of the last time this trigger executed.
        :param pulumi.Input[str] name: Name of the information type. Either a name of your choosing when creating a CustomInfoType, or one of the names listed
               at https://cloud.google.com/dlp/docs/infotypes-reference when specifying a built-in type.
               
               (Required)
               Name of the information type. Either a name of your choosing when creating a CustomInfoType, or one of the names listed
               at https://cloud.google.com/dlp/docs/infotypes-reference when specifying a built-in type.
               
               (Required)
               Name of the information type. Either a name of your choosing when creating a CustomInfoType, or one of the names listed
               at https://cloud.google.com/dlp/docs/infotypes-reference when specifying a built-in type.
               
               (Required)
               Name of the information type. Either a name of your choosing when creating a CustomInfoType, or one of the names listed
               at https://cloud.google.com/dlp/docs/infotypes-reference when specifying a built-in type.
               
               (Required)
               Name of the information type. Either a name of your choosing when creating a CustomInfoType, or one of the names
               listed at https://cloud.google.com/dlp/docs/infotypes-reference when specifying a built-in type.
               
               (Required)
               Resource name of the requested StoredInfoType, for example `organizations/433245324/storedInfoTypes/432452342`
               or `projects/project-id/storedInfoTypes/432452342`.
               
               (Required)
               Specification of the field containing the timestamp of scanned items. Used for data sources like Datastore and BigQuery.
               For BigQuery: Required to filter out rows based on the given start and end times. If not specified and the table was
               modified between the given start and end times, the entire table will be scanned. The valid data types of the timestamp
               field are: INTEGER, DATE, TIMESTAMP, or DATETIME BigQuery column.
               For Datastore. Valid data types of the timestamp field are: TIMESTAMP. Datastore entity will be scanned if the
               timestamp property does not exist or its value is empty or invalid.
               
               (Required)
               The name of the Datastore kind.
               
               (Required)
               Name of a BigQuery field to be returned with the findings.
               
               (Required)
               Name describing the field to which scanning is limited.
               
               (Required)
               Name describing the field excluded from scanning.
               
               (Required)
               Name describing the field.
        :param pulumi.Input[str] parent: The parent of the trigger, either in the format `projects/{{project}}`
               or `projects/{{project}}/locations/{{location}}`
        :param pulumi.Input[str] status: Whether the trigger is currently active.
               Default value is `HEALTHY`.
               Possible values are: `PAUSED`, `HEALTHY`, `CANCELLED`.
        :param pulumi.Input[str] trigger_id: The trigger id can contain uppercase and lowercase letters, numbers, and hyphens;
               that is, it must match the regular expression: [a-zA-Z\\d-_]+.
               The maximum length is 100 characters. Can be empty to allow the system to generate one.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PreventionJobTriggerTriggerArgs']]]] triggers: What event needs to occur for a new job to be started.
               Structure is documented below.
        :param pulumi.Input[str] update_time: The last update timestamp of an inspectTemplate. Set by the server.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PreventionJobTriggerState.__new__(_PreventionJobTriggerState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["inspect_job"] = inspect_job
        __props__.__dict__["last_run_time"] = last_run_time
        __props__.__dict__["name"] = name
        __props__.__dict__["parent"] = parent
        __props__.__dict__["status"] = status
        __props__.__dict__["trigger_id"] = trigger_id
        __props__.__dict__["triggers"] = triggers
        __props__.__dict__["update_time"] = update_time
        return PreventionJobTrigger(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        (Output)
        The creation timestamp of an inspectTemplate. Set by the server.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A description of the job trigger.

        (Optional)
        A short description of where the data is coming from. Will be stored once in the job. 256 max length.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[str]]:
        """
        User set display name of the job trigger.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="inspectJob")
    def inspect_job(self) -> pulumi.Output[Optional['outputs.PreventionJobTriggerInspectJob']]:
        """
        Controls what and how to inspect for findings.
        Structure is documented below.
        """
        return pulumi.get(self, "inspect_job")

    @property
    @pulumi.getter(name="lastRunTime")
    def last_run_time(self) -> pulumi.Output[str]:
        """
        The timestamp of the last time this trigger executed.
        """
        return pulumi.get(self, "last_run_time")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the information type. Either a name of your choosing when creating a CustomInfoType, or one of the names listed
        at https://cloud.google.com/dlp/docs/infotypes-reference when specifying a built-in type.

        (Required)
        Name of the information type. Either a name of your choosing when creating a CustomInfoType, or one of the names listed
        at https://cloud.google.com/dlp/docs/infotypes-reference when specifying a built-in type.

        (Required)
        Name of the information type. Either a name of your choosing when creating a CustomInfoType, or one of the names listed
        at https://cloud.google.com/dlp/docs/infotypes-reference when specifying a built-in type.

        (Required)
        Name of the information type. Either a name of your choosing when creating a CustomInfoType, or one of the names listed
        at https://cloud.google.com/dlp/docs/infotypes-reference when specifying a built-in type.

        (Required)
        Name of the information type. Either a name of your choosing when creating a CustomInfoType, or one of the names
        listed at https://cloud.google.com/dlp/docs/infotypes-reference when specifying a built-in type.

        (Required)
        Resource name of the requested StoredInfoType, for example `organizations/433245324/storedInfoTypes/432452342`
        or `projects/project-id/storedInfoTypes/432452342`.

        (Required)
        Specification of the field containing the timestamp of scanned items. Used for data sources like Datastore and BigQuery.
        For BigQuery: Required to filter out rows based on the given start and end times. If not specified and the table was
        modified between the given start and end times, the entire table will be scanned. The valid data types of the timestamp
        field are: INTEGER, DATE, TIMESTAMP, or DATETIME BigQuery column.
        For Datastore. Valid data types of the timestamp field are: TIMESTAMP. Datastore entity will be scanned if the
        timestamp property does not exist or its value is empty or invalid.

        (Required)
        The name of the Datastore kind.

        (Required)
        Name of a BigQuery field to be returned with the findings.

        (Required)
        Name describing the field to which scanning is limited.

        (Required)
        Name describing the field excluded from scanning.

        (Required)
        Name describing the field.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parent(self) -> pulumi.Output[str]:
        """
        The parent of the trigger, either in the format `projects/{{project}}`
        or `projects/{{project}}/locations/{{location}}`
        """
        return pulumi.get(self, "parent")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[str]]:
        """
        Whether the trigger is currently active.
        Default value is `HEALTHY`.
        Possible values are: `PAUSED`, `HEALTHY`, `CANCELLED`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="triggerId")
    def trigger_id(self) -> pulumi.Output[str]:
        """
        The trigger id can contain uppercase and lowercase letters, numbers, and hyphens;
        that is, it must match the regular expression: [a-zA-Z\\d-_]+.
        The maximum length is 100 characters. Can be empty to allow the system to generate one.
        """
        return pulumi.get(self, "trigger_id")

    @property
    @pulumi.getter
    def triggers(self) -> pulumi.Output[Sequence['outputs.PreventionJobTriggerTrigger']]:
        """
        What event needs to occur for a new job to be started.
        Structure is documented below.
        """
        return pulumi.get(self, "triggers")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The last update timestamp of an inspectTemplate. Set by the server.
        """
        return pulumi.get(self, "update_time")

