# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DatascanArgs', 'Datascan']

@pulumi.input_type
class DatascanArgs:
    def __init__(__self__, *,
                 data: pulumi.Input['DatascanDataArgs'],
                 data_scan_id: pulumi.Input[str],
                 execution_spec: pulumi.Input['DatascanExecutionSpecArgs'],
                 location: pulumi.Input[str],
                 data_profile_spec: Optional[pulumi.Input['DatascanDataProfileSpecArgs']] = None,
                 data_quality_spec: Optional[pulumi.Input['DatascanDataQualitySpecArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Datascan resource.
        :param pulumi.Input['DatascanDataArgs'] data: The data source for DataScan.
               Structure is documented below.
        :param pulumi.Input[str] data_scan_id: DataScan identifier. Must contain only lowercase letters, numbers and hyphens. Must start with a letter. Must end with a number or a letter.
        :param pulumi.Input['DatascanExecutionSpecArgs'] execution_spec: DataScan execution settings.
               Structure is documented below.
        :param pulumi.Input[str] location: The location where the data scan should reside.
        :param pulumi.Input['DatascanDataProfileSpecArgs'] data_profile_spec: DataProfileScan related setting.
               Structure is documented below.
        :param pulumi.Input['DatascanDataQualitySpecArgs'] data_quality_spec: DataQualityScan related setting.
               Structure is documented below.
        :param pulumi.Input[str] description: Description of the scan.
        :param pulumi.Input[str] display_name: User friendly display name.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: User-defined labels for the scan. A list of key->value pairs.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "data", data)
        pulumi.set(__self__, "data_scan_id", data_scan_id)
        pulumi.set(__self__, "execution_spec", execution_spec)
        pulumi.set(__self__, "location", location)
        if data_profile_spec is not None:
            pulumi.set(__self__, "data_profile_spec", data_profile_spec)
        if data_quality_spec is not None:
            pulumi.set(__self__, "data_quality_spec", data_quality_spec)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def data(self) -> pulumi.Input['DatascanDataArgs']:
        """
        The data source for DataScan.
        Structure is documented below.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: pulumi.Input['DatascanDataArgs']):
        pulumi.set(self, "data", value)

    @property
    @pulumi.getter(name="dataScanId")
    def data_scan_id(self) -> pulumi.Input[str]:
        """
        DataScan identifier. Must contain only lowercase letters, numbers and hyphens. Must start with a letter. Must end with a number or a letter.
        """
        return pulumi.get(self, "data_scan_id")

    @data_scan_id.setter
    def data_scan_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "data_scan_id", value)

    @property
    @pulumi.getter(name="executionSpec")
    def execution_spec(self) -> pulumi.Input['DatascanExecutionSpecArgs']:
        """
        DataScan execution settings.
        Structure is documented below.
        """
        return pulumi.get(self, "execution_spec")

    @execution_spec.setter
    def execution_spec(self, value: pulumi.Input['DatascanExecutionSpecArgs']):
        pulumi.set(self, "execution_spec", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        The location where the data scan should reside.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="dataProfileSpec")
    def data_profile_spec(self) -> Optional[pulumi.Input['DatascanDataProfileSpecArgs']]:
        """
        DataProfileScan related setting.
        Structure is documented below.
        """
        return pulumi.get(self, "data_profile_spec")

    @data_profile_spec.setter
    def data_profile_spec(self, value: Optional[pulumi.Input['DatascanDataProfileSpecArgs']]):
        pulumi.set(self, "data_profile_spec", value)

    @property
    @pulumi.getter(name="dataQualitySpec")
    def data_quality_spec(self) -> Optional[pulumi.Input['DatascanDataQualitySpecArgs']]:
        """
        DataQualityScan related setting.
        Structure is documented below.
        """
        return pulumi.get(self, "data_quality_spec")

    @data_quality_spec.setter
    def data_quality_spec(self, value: Optional[pulumi.Input['DatascanDataQualitySpecArgs']]):
        pulumi.set(self, "data_quality_spec", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the scan.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        User friendly display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        User-defined labels for the scan. A list of key->value pairs.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _DatascanState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[str]] = None,
                 data: Optional[pulumi.Input['DatascanDataArgs']] = None,
                 data_profile_results: Optional[pulumi.Input[Sequence[pulumi.Input['DatascanDataProfileResultArgs']]]] = None,
                 data_profile_spec: Optional[pulumi.Input['DatascanDataProfileSpecArgs']] = None,
                 data_quality_results: Optional[pulumi.Input[Sequence[pulumi.Input['DatascanDataQualityResultArgs']]]] = None,
                 data_quality_spec: Optional[pulumi.Input['DatascanDataQualitySpecArgs']] = None,
                 data_scan_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 execution_spec: Optional[pulumi.Input['DatascanExecutionSpecArgs']] = None,
                 execution_statuses: Optional[pulumi.Input[Sequence[pulumi.Input['DatascanExecutionStatusArgs']]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 uid: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Datascan resources.
        :param pulumi.Input[str] create_time: The time when the scan was created.
        :param pulumi.Input['DatascanDataArgs'] data: The data source for DataScan.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['DatascanDataProfileResultArgs']]] data_profile_results: The result of the data profile scan.
               Structure is documented below.
        :param pulumi.Input['DatascanDataProfileSpecArgs'] data_profile_spec: DataProfileScan related setting.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['DatascanDataQualityResultArgs']]] data_quality_results: The result of the data quality scan.
               Structure is documented below.
        :param pulumi.Input['DatascanDataQualitySpecArgs'] data_quality_spec: DataQualityScan related setting.
               Structure is documented below.
        :param pulumi.Input[str] data_scan_id: DataScan identifier. Must contain only lowercase letters, numbers and hyphens. Must start with a letter. Must end with a number or a letter.
        :param pulumi.Input[str] description: Description of the scan.
        :param pulumi.Input[str] display_name: User friendly display name.
        :param pulumi.Input['DatascanExecutionSpecArgs'] execution_spec: DataScan execution settings.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['DatascanExecutionStatusArgs']]] execution_statuses: Status of the data scan execution.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: User-defined labels for the scan. A list of key->value pairs.
        :param pulumi.Input[str] location: The location where the data scan should reside.
        :param pulumi.Input[str] name: The name of the field.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] state: Current state of the DataScan.
        :param pulumi.Input[str] type: The field data type.
        :param pulumi.Input[str] uid: System generated globally unique ID for the scan. This ID will be different if the scan is deleted and re-created with the same name.
        :param pulumi.Input[str] update_time: The time when the scan was last updated.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if data_profile_results is not None:
            pulumi.set(__self__, "data_profile_results", data_profile_results)
        if data_profile_spec is not None:
            pulumi.set(__self__, "data_profile_spec", data_profile_spec)
        if data_quality_results is not None:
            pulumi.set(__self__, "data_quality_results", data_quality_results)
        if data_quality_spec is not None:
            pulumi.set(__self__, "data_quality_spec", data_quality_spec)
        if data_scan_id is not None:
            pulumi.set(__self__, "data_scan_id", data_scan_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if execution_spec is not None:
            pulumi.set(__self__, "execution_spec", execution_spec)
        if execution_statuses is not None:
            pulumi.set(__self__, "execution_statuses", execution_statuses)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the scan was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input['DatascanDataArgs']]:
        """
        The data source for DataScan.
        Structure is documented below.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input['DatascanDataArgs']]):
        pulumi.set(self, "data", value)

    @property
    @pulumi.getter(name="dataProfileResults")
    def data_profile_results(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatascanDataProfileResultArgs']]]]:
        """
        The result of the data profile scan.
        Structure is documented below.
        """
        return pulumi.get(self, "data_profile_results")

    @data_profile_results.setter
    def data_profile_results(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatascanDataProfileResultArgs']]]]):
        pulumi.set(self, "data_profile_results", value)

    @property
    @pulumi.getter(name="dataProfileSpec")
    def data_profile_spec(self) -> Optional[pulumi.Input['DatascanDataProfileSpecArgs']]:
        """
        DataProfileScan related setting.
        Structure is documented below.
        """
        return pulumi.get(self, "data_profile_spec")

    @data_profile_spec.setter
    def data_profile_spec(self, value: Optional[pulumi.Input['DatascanDataProfileSpecArgs']]):
        pulumi.set(self, "data_profile_spec", value)

    @property
    @pulumi.getter(name="dataQualityResults")
    def data_quality_results(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatascanDataQualityResultArgs']]]]:
        """
        The result of the data quality scan.
        Structure is documented below.
        """
        return pulumi.get(self, "data_quality_results")

    @data_quality_results.setter
    def data_quality_results(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatascanDataQualityResultArgs']]]]):
        pulumi.set(self, "data_quality_results", value)

    @property
    @pulumi.getter(name="dataQualitySpec")
    def data_quality_spec(self) -> Optional[pulumi.Input['DatascanDataQualitySpecArgs']]:
        """
        DataQualityScan related setting.
        Structure is documented below.
        """
        return pulumi.get(self, "data_quality_spec")

    @data_quality_spec.setter
    def data_quality_spec(self, value: Optional[pulumi.Input['DatascanDataQualitySpecArgs']]):
        pulumi.set(self, "data_quality_spec", value)

    @property
    @pulumi.getter(name="dataScanId")
    def data_scan_id(self) -> Optional[pulumi.Input[str]]:
        """
        DataScan identifier. Must contain only lowercase letters, numbers and hyphens. Must start with a letter. Must end with a number or a letter.
        """
        return pulumi.get(self, "data_scan_id")

    @data_scan_id.setter
    def data_scan_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_scan_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the scan.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        User friendly display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="executionSpec")
    def execution_spec(self) -> Optional[pulumi.Input['DatascanExecutionSpecArgs']]:
        """
        DataScan execution settings.
        Structure is documented below.
        """
        return pulumi.get(self, "execution_spec")

    @execution_spec.setter
    def execution_spec(self, value: Optional[pulumi.Input['DatascanExecutionSpecArgs']]):
        pulumi.set(self, "execution_spec", value)

    @property
    @pulumi.getter(name="executionStatuses")
    def execution_statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatascanExecutionStatusArgs']]]]:
        """
        Status of the data scan execution.
        Structure is documented below.
        """
        return pulumi.get(self, "execution_statuses")

    @execution_statuses.setter
    def execution_statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatascanExecutionStatusArgs']]]]):
        pulumi.set(self, "execution_statuses", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        User-defined labels for the scan. A list of key->value pairs.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location where the data scan should reside.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the field.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        Current state of the DataScan.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The field data type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        System generated globally unique ID for the scan. This ID will be different if the scan is deleted and re-created with the same name.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the scan was last updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)


class Datascan(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data: Optional[pulumi.Input[pulumi.InputType['DatascanDataArgs']]] = None,
                 data_profile_spec: Optional[pulumi.Input[pulumi.InputType['DatascanDataProfileSpecArgs']]] = None,
                 data_quality_spec: Optional[pulumi.Input[pulumi.InputType['DatascanDataQualitySpecArgs']]] = None,
                 data_scan_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 execution_spec: Optional[pulumi.Input[pulumi.InputType['DatascanExecutionSpecArgs']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Represents a user-visible job which provides the insights for the related data source.

        To get more information about Datascan, see:

        * [API documentation](https://cloud.google.com/dataplex/docs/reference/rest)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dataplex/docs)

        ## Example Usage
        ### Dataplex Datascan Basic Profile

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic_profile = gcp.dataplex.Datascan("basicProfile",
            data=gcp.dataplex.DatascanDataArgs(
                resource="//bigquery.googleapis.com/projects/bigquery-public-data/datasets/samples/tables/shakespeare",
            ),
            data_profile_spec=gcp.dataplex.DatascanDataProfileSpecArgs(),
            data_scan_id="tf-test-datascan%{random_suffix}",
            execution_spec=gcp.dataplex.DatascanExecutionSpecArgs(
                trigger=gcp.dataplex.DatascanExecutionSpecTriggerArgs(
                    on_demand=gcp.dataplex.DatascanExecutionSpecTriggerOnDemandArgs(),
                ),
            ),
            location="us-central1",
            project="my-project-name")
        ```
        ### Dataplex Datascan Full Profile

        ```python
        import pulumi
        import pulumi_gcp as gcp

        full_profile = gcp.dataplex.Datascan("fullProfile",
            data=gcp.dataplex.DatascanDataArgs(
                resource="//bigquery.googleapis.com/projects/bigquery-public-data/datasets/samples/tables/shakespeare",
            ),
            data_profile_spec=gcp.dataplex.DatascanDataProfileSpecArgs(
                row_filter="word_count > 10",
                sampling_percent=80,
            ),
            data_scan_id="tf-test-datascan%{random_suffix}",
            description="Example resource - Full Datascan Profile",
            display_name="Full Datascan Profile",
            execution_spec=gcp.dataplex.DatascanExecutionSpecArgs(
                trigger=gcp.dataplex.DatascanExecutionSpecTriggerArgs(
                    schedule=gcp.dataplex.DatascanExecutionSpecTriggerScheduleArgs(
                        cron="TZ=America/New_York 1 1 * * *",
                    ),
                ),
            ),
            labels={
                "author": "billing",
            },
            location="us-central1",
            project="my-project-name")
        ```
        ### Dataplex Datascan Basic Quality

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic_quality = gcp.dataplex.Datascan("basicQuality",
            data=gcp.dataplex.DatascanDataArgs(
                resource="//bigquery.googleapis.com/projects/bigquery-public-data/datasets/samples/tables/shakespeare",
            ),
            data_quality_spec=gcp.dataplex.DatascanDataQualitySpecArgs(
                rules=[gcp.dataplex.DatascanDataQualitySpecRuleArgs(
                    dimension="VALIDITY",
                    table_condition_expectation=gcp.dataplex.DatascanDataQualitySpecRuleTableConditionExpectationArgs(
                        sql_expression="COUNT(*) > 0",
                    ),
                )],
            ),
            data_scan_id="tf-test-datascan%{random_suffix}",
            execution_spec=gcp.dataplex.DatascanExecutionSpecArgs(
                trigger=gcp.dataplex.DatascanExecutionSpecTriggerArgs(
                    on_demand=gcp.dataplex.DatascanExecutionSpecTriggerOnDemandArgs(),
                ),
            ),
            location="us-central1",
            project="my-project-name")
        ```
        ### Dataplex Datascan Full Quality

        ```python
        import pulumi
        import pulumi_gcp as gcp

        full_quality = gcp.dataplex.Datascan("fullQuality",
            data=gcp.dataplex.DatascanDataArgs(
                resource="//bigquery.googleapis.com/projects/bigquery-public-data/datasets/austin_bikeshare/tables/bikeshare_stations",
            ),
            data_quality_spec=gcp.dataplex.DatascanDataQualitySpecArgs(
                row_filter="station_id > 1000",
                rules=[
                    gcp.dataplex.DatascanDataQualitySpecRuleArgs(
                        column="address",
                        dimension="VALIDITY",
                        non_null_expectation=gcp.dataplex.DatascanDataQualitySpecRuleNonNullExpectationArgs(),
                        threshold=0.99,
                    ),
                    gcp.dataplex.DatascanDataQualitySpecRuleArgs(
                        column="council_district",
                        dimension="VALIDITY",
                        ignore_null=True,
                        range_expectation=gcp.dataplex.DatascanDataQualitySpecRuleRangeExpectationArgs(
                            max_value="10",
                            min_value="1",
                            strict_max_enabled=False,
                            strict_min_enabled=True,
                        ),
                        threshold=0.9,
                    ),
                    gcp.dataplex.DatascanDataQualitySpecRuleArgs(
                        column="power_type",
                        dimension="VALIDITY",
                        ignore_null=False,
                        regex_expectation=gcp.dataplex.DatascanDataQualitySpecRuleRegexExpectationArgs(
                            regex=".*solar.*",
                        ),
                    ),
                    gcp.dataplex.DatascanDataQualitySpecRuleArgs(
                        column="property_type",
                        dimension="VALIDITY",
                        ignore_null=False,
                        set_expectation=gcp.dataplex.DatascanDataQualitySpecRuleSetExpectationArgs(
                            values=[
                                "sidewalk",
                                "parkland",
                            ],
                        ),
                    ),
                    gcp.dataplex.DatascanDataQualitySpecRuleArgs(
                        column="address",
                        dimension="UNIQUENESS",
                        uniqueness_expectation=gcp.dataplex.DatascanDataQualitySpecRuleUniquenessExpectationArgs(),
                    ),
                    gcp.dataplex.DatascanDataQualitySpecRuleArgs(
                        column="number_of_docks",
                        dimension="VALIDITY",
                        statistic_range_expectation=gcp.dataplex.DatascanDataQualitySpecRuleStatisticRangeExpectationArgs(
                            max_value="15",
                            min_value="5",
                            statistic="MEAN",
                            strict_max_enabled=True,
                            strict_min_enabled=True,
                        ),
                    ),
                    gcp.dataplex.DatascanDataQualitySpecRuleArgs(
                        column="footprint_length",
                        dimension="VALIDITY",
                        row_condition_expectation=gcp.dataplex.DatascanDataQualitySpecRuleRowConditionExpectationArgs(
                            sql_expression="footprint_length > 0 AND footprint_length <= 10",
                        ),
                    ),
                    gcp.dataplex.DatascanDataQualitySpecRuleArgs(
                        dimension="VALIDITY",
                        table_condition_expectation=gcp.dataplex.DatascanDataQualitySpecRuleTableConditionExpectationArgs(
                            sql_expression="COUNT(*) > 0",
                        ),
                    ),
                ],
                sampling_percent=5,
            ),
            data_scan_id="tf-test-datascan%{random_suffix}",
            description="Example resource - Full Datascan Quality",
            display_name="Full Datascan Quality",
            execution_spec=gcp.dataplex.DatascanExecutionSpecArgs(
                field="modified_date",
                trigger=gcp.dataplex.DatascanExecutionSpecTriggerArgs(
                    schedule=gcp.dataplex.DatascanExecutionSpecTriggerScheduleArgs(
                        cron="TZ=America/New_York 1 1 * * *",
                    ),
                ),
            ),
            labels={
                "author": "billing",
            },
            location="us-central1",
            project="my-project-name")
        ```

        ## Import

        Datascan can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:dataplex/datascan:Datascan default projects/{{project}}/locations/{{location}}/dataScans/{{data_scan_id}}
        ```

        ```sh
         $ pulumi import gcp:dataplex/datascan:Datascan default {{project}}/{{location}}/{{data_scan_id}}
        ```

        ```sh
         $ pulumi import gcp:dataplex/datascan:Datascan default {{location}}/{{data_scan_id}}
        ```

        ```sh
         $ pulumi import gcp:dataplex/datascan:Datascan default {{data_scan_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['DatascanDataArgs']] data: The data source for DataScan.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['DatascanDataProfileSpecArgs']] data_profile_spec: DataProfileScan related setting.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['DatascanDataQualitySpecArgs']] data_quality_spec: DataQualityScan related setting.
               Structure is documented below.
        :param pulumi.Input[str] data_scan_id: DataScan identifier. Must contain only lowercase letters, numbers and hyphens. Must start with a letter. Must end with a number or a letter.
        :param pulumi.Input[str] description: Description of the scan.
        :param pulumi.Input[str] display_name: User friendly display name.
        :param pulumi.Input[pulumi.InputType['DatascanExecutionSpecArgs']] execution_spec: DataScan execution settings.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: User-defined labels for the scan. A list of key->value pairs.
        :param pulumi.Input[str] location: The location where the data scan should reside.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatascanArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a user-visible job which provides the insights for the related data source.

        To get more information about Datascan, see:

        * [API documentation](https://cloud.google.com/dataplex/docs/reference/rest)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dataplex/docs)

        ## Example Usage
        ### Dataplex Datascan Basic Profile

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic_profile = gcp.dataplex.Datascan("basicProfile",
            data=gcp.dataplex.DatascanDataArgs(
                resource="//bigquery.googleapis.com/projects/bigquery-public-data/datasets/samples/tables/shakespeare",
            ),
            data_profile_spec=gcp.dataplex.DatascanDataProfileSpecArgs(),
            data_scan_id="tf-test-datascan%{random_suffix}",
            execution_spec=gcp.dataplex.DatascanExecutionSpecArgs(
                trigger=gcp.dataplex.DatascanExecutionSpecTriggerArgs(
                    on_demand=gcp.dataplex.DatascanExecutionSpecTriggerOnDemandArgs(),
                ),
            ),
            location="us-central1",
            project="my-project-name")
        ```
        ### Dataplex Datascan Full Profile

        ```python
        import pulumi
        import pulumi_gcp as gcp

        full_profile = gcp.dataplex.Datascan("fullProfile",
            data=gcp.dataplex.DatascanDataArgs(
                resource="//bigquery.googleapis.com/projects/bigquery-public-data/datasets/samples/tables/shakespeare",
            ),
            data_profile_spec=gcp.dataplex.DatascanDataProfileSpecArgs(
                row_filter="word_count > 10",
                sampling_percent=80,
            ),
            data_scan_id="tf-test-datascan%{random_suffix}",
            description="Example resource - Full Datascan Profile",
            display_name="Full Datascan Profile",
            execution_spec=gcp.dataplex.DatascanExecutionSpecArgs(
                trigger=gcp.dataplex.DatascanExecutionSpecTriggerArgs(
                    schedule=gcp.dataplex.DatascanExecutionSpecTriggerScheduleArgs(
                        cron="TZ=America/New_York 1 1 * * *",
                    ),
                ),
            ),
            labels={
                "author": "billing",
            },
            location="us-central1",
            project="my-project-name")
        ```
        ### Dataplex Datascan Basic Quality

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic_quality = gcp.dataplex.Datascan("basicQuality",
            data=gcp.dataplex.DatascanDataArgs(
                resource="//bigquery.googleapis.com/projects/bigquery-public-data/datasets/samples/tables/shakespeare",
            ),
            data_quality_spec=gcp.dataplex.DatascanDataQualitySpecArgs(
                rules=[gcp.dataplex.DatascanDataQualitySpecRuleArgs(
                    dimension="VALIDITY",
                    table_condition_expectation=gcp.dataplex.DatascanDataQualitySpecRuleTableConditionExpectationArgs(
                        sql_expression="COUNT(*) > 0",
                    ),
                )],
            ),
            data_scan_id="tf-test-datascan%{random_suffix}",
            execution_spec=gcp.dataplex.DatascanExecutionSpecArgs(
                trigger=gcp.dataplex.DatascanExecutionSpecTriggerArgs(
                    on_demand=gcp.dataplex.DatascanExecutionSpecTriggerOnDemandArgs(),
                ),
            ),
            location="us-central1",
            project="my-project-name")
        ```
        ### Dataplex Datascan Full Quality

        ```python
        import pulumi
        import pulumi_gcp as gcp

        full_quality = gcp.dataplex.Datascan("fullQuality",
            data=gcp.dataplex.DatascanDataArgs(
                resource="//bigquery.googleapis.com/projects/bigquery-public-data/datasets/austin_bikeshare/tables/bikeshare_stations",
            ),
            data_quality_spec=gcp.dataplex.DatascanDataQualitySpecArgs(
                row_filter="station_id > 1000",
                rules=[
                    gcp.dataplex.DatascanDataQualitySpecRuleArgs(
                        column="address",
                        dimension="VALIDITY",
                        non_null_expectation=gcp.dataplex.DatascanDataQualitySpecRuleNonNullExpectationArgs(),
                        threshold=0.99,
                    ),
                    gcp.dataplex.DatascanDataQualitySpecRuleArgs(
                        column="council_district",
                        dimension="VALIDITY",
                        ignore_null=True,
                        range_expectation=gcp.dataplex.DatascanDataQualitySpecRuleRangeExpectationArgs(
                            max_value="10",
                            min_value="1",
                            strict_max_enabled=False,
                            strict_min_enabled=True,
                        ),
                        threshold=0.9,
                    ),
                    gcp.dataplex.DatascanDataQualitySpecRuleArgs(
                        column="power_type",
                        dimension="VALIDITY",
                        ignore_null=False,
                        regex_expectation=gcp.dataplex.DatascanDataQualitySpecRuleRegexExpectationArgs(
                            regex=".*solar.*",
                        ),
                    ),
                    gcp.dataplex.DatascanDataQualitySpecRuleArgs(
                        column="property_type",
                        dimension="VALIDITY",
                        ignore_null=False,
                        set_expectation=gcp.dataplex.DatascanDataQualitySpecRuleSetExpectationArgs(
                            values=[
                                "sidewalk",
                                "parkland",
                            ],
                        ),
                    ),
                    gcp.dataplex.DatascanDataQualitySpecRuleArgs(
                        column="address",
                        dimension="UNIQUENESS",
                        uniqueness_expectation=gcp.dataplex.DatascanDataQualitySpecRuleUniquenessExpectationArgs(),
                    ),
                    gcp.dataplex.DatascanDataQualitySpecRuleArgs(
                        column="number_of_docks",
                        dimension="VALIDITY",
                        statistic_range_expectation=gcp.dataplex.DatascanDataQualitySpecRuleStatisticRangeExpectationArgs(
                            max_value="15",
                            min_value="5",
                            statistic="MEAN",
                            strict_max_enabled=True,
                            strict_min_enabled=True,
                        ),
                    ),
                    gcp.dataplex.DatascanDataQualitySpecRuleArgs(
                        column="footprint_length",
                        dimension="VALIDITY",
                        row_condition_expectation=gcp.dataplex.DatascanDataQualitySpecRuleRowConditionExpectationArgs(
                            sql_expression="footprint_length > 0 AND footprint_length <= 10",
                        ),
                    ),
                    gcp.dataplex.DatascanDataQualitySpecRuleArgs(
                        dimension="VALIDITY",
                        table_condition_expectation=gcp.dataplex.DatascanDataQualitySpecRuleTableConditionExpectationArgs(
                            sql_expression="COUNT(*) > 0",
                        ),
                    ),
                ],
                sampling_percent=5,
            ),
            data_scan_id="tf-test-datascan%{random_suffix}",
            description="Example resource - Full Datascan Quality",
            display_name="Full Datascan Quality",
            execution_spec=gcp.dataplex.DatascanExecutionSpecArgs(
                field="modified_date",
                trigger=gcp.dataplex.DatascanExecutionSpecTriggerArgs(
                    schedule=gcp.dataplex.DatascanExecutionSpecTriggerScheduleArgs(
                        cron="TZ=America/New_York 1 1 * * *",
                    ),
                ),
            ),
            labels={
                "author": "billing",
            },
            location="us-central1",
            project="my-project-name")
        ```

        ## Import

        Datascan can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:dataplex/datascan:Datascan default projects/{{project}}/locations/{{location}}/dataScans/{{data_scan_id}}
        ```

        ```sh
         $ pulumi import gcp:dataplex/datascan:Datascan default {{project}}/{{location}}/{{data_scan_id}}
        ```

        ```sh
         $ pulumi import gcp:dataplex/datascan:Datascan default {{location}}/{{data_scan_id}}
        ```

        ```sh
         $ pulumi import gcp:dataplex/datascan:Datascan default {{data_scan_id}}
        ```

        :param str resource_name: The name of the resource.
        :param DatascanArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatascanArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data: Optional[pulumi.Input[pulumi.InputType['DatascanDataArgs']]] = None,
                 data_profile_spec: Optional[pulumi.Input[pulumi.InputType['DatascanDataProfileSpecArgs']]] = None,
                 data_quality_spec: Optional[pulumi.Input[pulumi.InputType['DatascanDataQualitySpecArgs']]] = None,
                 data_scan_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 execution_spec: Optional[pulumi.Input[pulumi.InputType['DatascanExecutionSpecArgs']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatascanArgs.__new__(DatascanArgs)

            if data is None and not opts.urn:
                raise TypeError("Missing required property 'data'")
            __props__.__dict__["data"] = data
            __props__.__dict__["data_profile_spec"] = data_profile_spec
            __props__.__dict__["data_quality_spec"] = data_quality_spec
            if data_scan_id is None and not opts.urn:
                raise TypeError("Missing required property 'data_scan_id'")
            __props__.__dict__["data_scan_id"] = data_scan_id
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            if execution_spec is None and not opts.urn:
                raise TypeError("Missing required property 'execution_spec'")
            __props__.__dict__["execution_spec"] = execution_spec
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["data_profile_results"] = None
            __props__.__dict__["data_quality_results"] = None
            __props__.__dict__["execution_statuses"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        super(Datascan, __self__).__init__(
            'gcp:dataplex/datascan:Datascan',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            data: Optional[pulumi.Input[pulumi.InputType['DatascanDataArgs']]] = None,
            data_profile_results: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatascanDataProfileResultArgs']]]]] = None,
            data_profile_spec: Optional[pulumi.Input[pulumi.InputType['DatascanDataProfileSpecArgs']]] = None,
            data_quality_results: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatascanDataQualityResultArgs']]]]] = None,
            data_quality_spec: Optional[pulumi.Input[pulumi.InputType['DatascanDataQualitySpecArgs']]] = None,
            data_scan_id: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            execution_spec: Optional[pulumi.Input[pulumi.InputType['DatascanExecutionSpecArgs']]] = None,
            execution_statuses: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatascanExecutionStatusArgs']]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            location: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            uid: Optional[pulumi.Input[str]] = None,
            update_time: Optional[pulumi.Input[str]] = None) -> 'Datascan':
        """
        Get an existing Datascan resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] create_time: The time when the scan was created.
        :param pulumi.Input[pulumi.InputType['DatascanDataArgs']] data: The data source for DataScan.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatascanDataProfileResultArgs']]]] data_profile_results: The result of the data profile scan.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['DatascanDataProfileSpecArgs']] data_profile_spec: DataProfileScan related setting.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatascanDataQualityResultArgs']]]] data_quality_results: The result of the data quality scan.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['DatascanDataQualitySpecArgs']] data_quality_spec: DataQualityScan related setting.
               Structure is documented below.
        :param pulumi.Input[str] data_scan_id: DataScan identifier. Must contain only lowercase letters, numbers and hyphens. Must start with a letter. Must end with a number or a letter.
        :param pulumi.Input[str] description: Description of the scan.
        :param pulumi.Input[str] display_name: User friendly display name.
        :param pulumi.Input[pulumi.InputType['DatascanExecutionSpecArgs']] execution_spec: DataScan execution settings.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatascanExecutionStatusArgs']]]] execution_statuses: Status of the data scan execution.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: User-defined labels for the scan. A list of key->value pairs.
        :param pulumi.Input[str] location: The location where the data scan should reside.
        :param pulumi.Input[str] name: The name of the field.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] state: Current state of the DataScan.
        :param pulumi.Input[str] type: The field data type.
        :param pulumi.Input[str] uid: System generated globally unique ID for the scan. This ID will be different if the scan is deleted and re-created with the same name.
        :param pulumi.Input[str] update_time: The time when the scan was last updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatascanState.__new__(_DatascanState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["data"] = data
        __props__.__dict__["data_profile_results"] = data_profile_results
        __props__.__dict__["data_profile_spec"] = data_profile_spec
        __props__.__dict__["data_quality_results"] = data_quality_results
        __props__.__dict__["data_quality_spec"] = data_quality_spec
        __props__.__dict__["data_scan_id"] = data_scan_id
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["execution_spec"] = execution_spec
        __props__.__dict__["execution_statuses"] = execution_statuses
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["state"] = state
        __props__.__dict__["type"] = type
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        return Datascan(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The time when the scan was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def data(self) -> pulumi.Output['outputs.DatascanData']:
        """
        The data source for DataScan.
        Structure is documented below.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter(name="dataProfileResults")
    def data_profile_results(self) -> pulumi.Output[Sequence['outputs.DatascanDataProfileResult']]:
        """
        The result of the data profile scan.
        Structure is documented below.
        """
        return pulumi.get(self, "data_profile_results")

    @property
    @pulumi.getter(name="dataProfileSpec")
    def data_profile_spec(self) -> pulumi.Output[Optional['outputs.DatascanDataProfileSpec']]:
        """
        DataProfileScan related setting.
        Structure is documented below.
        """
        return pulumi.get(self, "data_profile_spec")

    @property
    @pulumi.getter(name="dataQualityResults")
    def data_quality_results(self) -> pulumi.Output[Sequence['outputs.DatascanDataQualityResult']]:
        """
        The result of the data quality scan.
        Structure is documented below.
        """
        return pulumi.get(self, "data_quality_results")

    @property
    @pulumi.getter(name="dataQualitySpec")
    def data_quality_spec(self) -> pulumi.Output[Optional['outputs.DatascanDataQualitySpec']]:
        """
        DataQualityScan related setting.
        Structure is documented below.
        """
        return pulumi.get(self, "data_quality_spec")

    @property
    @pulumi.getter(name="dataScanId")
    def data_scan_id(self) -> pulumi.Output[str]:
        """
        DataScan identifier. Must contain only lowercase letters, numbers and hyphens. Must start with a letter. Must end with a number or a letter.
        """
        return pulumi.get(self, "data_scan_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the scan.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[str]]:
        """
        User friendly display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="executionSpec")
    def execution_spec(self) -> pulumi.Output['outputs.DatascanExecutionSpec']:
        """
        DataScan execution settings.
        Structure is documented below.
        """
        return pulumi.get(self, "execution_spec")

    @property
    @pulumi.getter(name="executionStatuses")
    def execution_statuses(self) -> pulumi.Output[Sequence['outputs.DatascanExecutionStatus']]:
        """
        Status of the data scan execution.
        Structure is documented below.
        """
        return pulumi.get(self, "execution_statuses")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        User-defined labels for the scan. A list of key->value pairs.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The location where the data scan should reside.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the field.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        Current state of the DataScan.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The field data type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[str]:
        """
        System generated globally unique ID for the scan. This ID will be different if the scan is deleted and re-created with the same name.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The time when the scan was last updated.
        """
        return pulumi.get(self, "update_time")

