# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'AssetDiscoverySpec',
    'AssetDiscoverySpecCsvOptions',
    'AssetDiscoverySpecJsonOptions',
    'AssetDiscoveryStatus',
    'AssetDiscoveryStatusStat',
    'AssetIamBindingCondition',
    'AssetIamMemberCondition',
    'AssetResourceSpec',
    'AssetResourceStatus',
    'AssetSecurityStatus',
    'DatascanData',
    'DatascanDataProfileResult',
    'DatascanDataProfileResultProfile',
    'DatascanDataProfileResultProfileField',
    'DatascanDataProfileResultProfileFieldProfile',
    'DatascanDataProfileResultProfileFieldProfileDoubleProfile',
    'DatascanDataProfileResultProfileFieldProfileIntegerProfile',
    'DatascanDataProfileResultProfileFieldProfileStringProfile',
    'DatascanDataProfileResultProfileFieldProfileTopNValues',
    'DatascanDataProfileResultScannedData',
    'DatascanDataProfileResultScannedDataIncrementalField',
    'DatascanDataProfileSpec',
    'DatascanDataQualityResult',
    'DatascanDataQualityResultDimension',
    'DatascanDataQualityResultRule',
    'DatascanDataQualityResultRuleRule',
    'DatascanDataQualityResultRuleRuleNonNullExpectation',
    'DatascanDataQualityResultRuleRuleRangeExpectation',
    'DatascanDataQualityResultRuleRuleRegexExpectation',
    'DatascanDataQualityResultRuleRuleRowConditionExpectation',
    'DatascanDataQualityResultRuleRuleSetExpectation',
    'DatascanDataQualityResultRuleRuleStatisticRangeExpectation',
    'DatascanDataQualityResultRuleRuleTableConditionExpectation',
    'DatascanDataQualityResultRuleRuleUniquenessExpectation',
    'DatascanDataQualityResultScannedData',
    'DatascanDataQualityResultScannedDataIncrementalField',
    'DatascanDataQualitySpec',
    'DatascanDataQualitySpecRule',
    'DatascanDataQualitySpecRuleNonNullExpectation',
    'DatascanDataQualitySpecRuleRangeExpectation',
    'DatascanDataQualitySpecRuleRegexExpectation',
    'DatascanDataQualitySpecRuleRowConditionExpectation',
    'DatascanDataQualitySpecRuleSetExpectation',
    'DatascanDataQualitySpecRuleStatisticRangeExpectation',
    'DatascanDataQualitySpecRuleTableConditionExpectation',
    'DatascanDataQualitySpecRuleUniquenessExpectation',
    'DatascanExecutionSpec',
    'DatascanExecutionSpecTrigger',
    'DatascanExecutionSpecTriggerOnDemand',
    'DatascanExecutionSpecTriggerSchedule',
    'DatascanExecutionStatus',
    'DatascanIamBindingCondition',
    'DatascanIamMemberCondition',
    'LakeAssetStatus',
    'LakeIamBindingCondition',
    'LakeIamMemberCondition',
    'LakeMetastore',
    'LakeMetastoreStatus',
    'ZoneAssetStatus',
    'ZoneDiscoverySpec',
    'ZoneDiscoverySpecCsvOptions',
    'ZoneDiscoverySpecJsonOptions',
    'ZoneIamBindingCondition',
    'ZoneIamMemberCondition',
    'ZoneResourceSpec',
]

@pulumi.output_type
class AssetDiscoverySpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "csvOptions":
            suggest = "csv_options"
        elif key == "excludePatterns":
            suggest = "exclude_patterns"
        elif key == "includePatterns":
            suggest = "include_patterns"
        elif key == "jsonOptions":
            suggest = "json_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssetDiscoverySpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssetDiscoverySpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssetDiscoverySpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 csv_options: Optional['outputs.AssetDiscoverySpecCsvOptions'] = None,
                 exclude_patterns: Optional[Sequence[str]] = None,
                 include_patterns: Optional[Sequence[str]] = None,
                 json_options: Optional['outputs.AssetDiscoverySpecJsonOptions'] = None,
                 schedule: Optional[str] = None):
        """
        :param bool enabled: Required. Whether discovery is enabled.
        :param 'AssetDiscoverySpecCsvOptionsArgs' csv_options: Optional. Configuration for CSV data.
        :param Sequence[str] exclude_patterns: Optional. The list of patterns to apply for selecting data to exclude during discovery. For Cloud Storage bucket assets, these are interpreted as glob patterns used to match object names. For BigQuery dataset assets, these are interpreted as patterns to match table names.
        :param Sequence[str] include_patterns: Optional. The list of patterns to apply for selecting data to include during discovery if only a subset of the data should considered. For Cloud Storage bucket assets, these are interpreted as glob patterns used to match object names. For BigQuery dataset assets, these are interpreted as patterns to match table names.
        :param 'AssetDiscoverySpecJsonOptionsArgs' json_options: Optional. Configuration for Json data.
        :param str schedule: Optional. Cron schedule (https://en.wikipedia.org/wiki/Cron) for running discovery periodically. Successive discovery runs must be scheduled at least 60 minutes apart. The default value is to run discovery every 60 minutes. To explicitly set a timezone to the cron tab, apply a prefix in the cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or TZ=${IANA_TIME_ZONE}". The ${IANA_TIME_ZONE} may only be a valid string from IANA time zone database. For example, "CRON_TZ=America/New_York 1 * * * *", or "TZ=America/New_York 1 * * * *".
        """
        pulumi.set(__self__, "enabled", enabled)
        if csv_options is not None:
            pulumi.set(__self__, "csv_options", csv_options)
        if exclude_patterns is not None:
            pulumi.set(__self__, "exclude_patterns", exclude_patterns)
        if include_patterns is not None:
            pulumi.set(__self__, "include_patterns", include_patterns)
        if json_options is not None:
            pulumi.set(__self__, "json_options", json_options)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Required. Whether discovery is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="csvOptions")
    def csv_options(self) -> Optional['outputs.AssetDiscoverySpecCsvOptions']:
        """
        Optional. Configuration for CSV data.
        """
        return pulumi.get(self, "csv_options")

    @property
    @pulumi.getter(name="excludePatterns")
    def exclude_patterns(self) -> Optional[Sequence[str]]:
        """
        Optional. The list of patterns to apply for selecting data to exclude during discovery. For Cloud Storage bucket assets, these are interpreted as glob patterns used to match object names. For BigQuery dataset assets, these are interpreted as patterns to match table names.
        """
        return pulumi.get(self, "exclude_patterns")

    @property
    @pulumi.getter(name="includePatterns")
    def include_patterns(self) -> Optional[Sequence[str]]:
        """
        Optional. The list of patterns to apply for selecting data to include during discovery if only a subset of the data should considered. For Cloud Storage bucket assets, these are interpreted as glob patterns used to match object names. For BigQuery dataset assets, these are interpreted as patterns to match table names.
        """
        return pulumi.get(self, "include_patterns")

    @property
    @pulumi.getter(name="jsonOptions")
    def json_options(self) -> Optional['outputs.AssetDiscoverySpecJsonOptions']:
        """
        Optional. Configuration for Json data.
        """
        return pulumi.get(self, "json_options")

    @property
    @pulumi.getter
    def schedule(self) -> Optional[str]:
        """
        Optional. Cron schedule (https://en.wikipedia.org/wiki/Cron) for running discovery periodically. Successive discovery runs must be scheduled at least 60 minutes apart. The default value is to run discovery every 60 minutes. To explicitly set a timezone to the cron tab, apply a prefix in the cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or TZ=${IANA_TIME_ZONE}". The ${IANA_TIME_ZONE} may only be a valid string from IANA time zone database. For example, "CRON_TZ=America/New_York 1 * * * *", or "TZ=America/New_York 1 * * * *".
        """
        return pulumi.get(self, "schedule")


@pulumi.output_type
class AssetDiscoverySpecCsvOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disableTypeInference":
            suggest = "disable_type_inference"
        elif key == "headerRows":
            suggest = "header_rows"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssetDiscoverySpecCsvOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssetDiscoverySpecCsvOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssetDiscoverySpecCsvOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delimiter: Optional[str] = None,
                 disable_type_inference: Optional[bool] = None,
                 encoding: Optional[str] = None,
                 header_rows: Optional[int] = None):
        """
        :param str delimiter: Optional. The delimiter being used to separate values. This defaults to ','.
        :param bool disable_type_inference: Optional. Whether to disable the inference of data type for CSV data. If true, all columns will be registered as strings.
        :param str encoding: Optional. The character encoding of the data. The default is UTF-8.
        :param int header_rows: Optional. The number of rows to interpret as header rows that should be skipped when reading data rows.
        """
        if delimiter is not None:
            pulumi.set(__self__, "delimiter", delimiter)
        if disable_type_inference is not None:
            pulumi.set(__self__, "disable_type_inference", disable_type_inference)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if header_rows is not None:
            pulumi.set(__self__, "header_rows", header_rows)

    @property
    @pulumi.getter
    def delimiter(self) -> Optional[str]:
        """
        Optional. The delimiter being used to separate values. This defaults to ','.
        """
        return pulumi.get(self, "delimiter")

    @property
    @pulumi.getter(name="disableTypeInference")
    def disable_type_inference(self) -> Optional[bool]:
        """
        Optional. Whether to disable the inference of data type for CSV data. If true, all columns will be registered as strings.
        """
        return pulumi.get(self, "disable_type_inference")

    @property
    @pulumi.getter
    def encoding(self) -> Optional[str]:
        """
        Optional. The character encoding of the data. The default is UTF-8.
        """
        return pulumi.get(self, "encoding")

    @property
    @pulumi.getter(name="headerRows")
    def header_rows(self) -> Optional[int]:
        """
        Optional. The number of rows to interpret as header rows that should be skipped when reading data rows.
        """
        return pulumi.get(self, "header_rows")


@pulumi.output_type
class AssetDiscoverySpecJsonOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disableTypeInference":
            suggest = "disable_type_inference"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssetDiscoverySpecJsonOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssetDiscoverySpecJsonOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssetDiscoverySpecJsonOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disable_type_inference: Optional[bool] = None,
                 encoding: Optional[str] = None):
        """
        :param bool disable_type_inference: Optional. Whether to disable the inference of data type for Json data. If true, all columns will be registered as their primitive types (strings, number or boolean).
        :param str encoding: Optional. The character encoding of the data. The default is UTF-8.
        """
        if disable_type_inference is not None:
            pulumi.set(__self__, "disable_type_inference", disable_type_inference)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)

    @property
    @pulumi.getter(name="disableTypeInference")
    def disable_type_inference(self) -> Optional[bool]:
        """
        Optional. Whether to disable the inference of data type for Json data. If true, all columns will be registered as their primitive types (strings, number or boolean).
        """
        return pulumi.get(self, "disable_type_inference")

    @property
    @pulumi.getter
    def encoding(self) -> Optional[str]:
        """
        Optional. The character encoding of the data. The default is UTF-8.
        """
        return pulumi.get(self, "encoding")


@pulumi.output_type
class AssetDiscoveryStatus(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastRunDuration":
            suggest = "last_run_duration"
        elif key == "lastRunTime":
            suggest = "last_run_time"
        elif key == "updateTime":
            suggest = "update_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssetDiscoveryStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssetDiscoveryStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssetDiscoveryStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_run_duration: Optional[str] = None,
                 last_run_time: Optional[str] = None,
                 message: Optional[str] = None,
                 state: Optional[str] = None,
                 stats: Optional[Sequence['outputs.AssetDiscoveryStatusStat']] = None,
                 update_time: Optional[str] = None):
        """
        :param str state: Output only. Current state of the asset. Possible values: STATE_UNSPECIFIED, ACTIVE, CREATING, DELETING, ACTION_REQUIRED
        :param str update_time: Output only. The time when the asset was last updated.
        """
        if last_run_duration is not None:
            pulumi.set(__self__, "last_run_duration", last_run_duration)
        if last_run_time is not None:
            pulumi.set(__self__, "last_run_time", last_run_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if stats is not None:
            pulumi.set(__self__, "stats", stats)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="lastRunDuration")
    def last_run_duration(self) -> Optional[str]:
        return pulumi.get(self, "last_run_duration")

    @property
    @pulumi.getter(name="lastRunTime")
    def last_run_time(self) -> Optional[str]:
        return pulumi.get(self, "last_run_time")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        Output only. Current state of the asset. Possible values: STATE_UNSPECIFIED, ACTIVE, CREATING, DELETING, ACTION_REQUIRED
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def stats(self) -> Optional[Sequence['outputs.AssetDiscoveryStatusStat']]:
        return pulumi.get(self, "stats")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[str]:
        """
        Output only. The time when the asset was last updated.
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class AssetDiscoveryStatusStat(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataItems":
            suggest = "data_items"
        elif key == "dataSize":
            suggest = "data_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssetDiscoveryStatusStat. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssetDiscoveryStatusStat.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssetDiscoveryStatusStat.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_items: Optional[int] = None,
                 data_size: Optional[int] = None,
                 filesets: Optional[int] = None,
                 tables: Optional[int] = None):
        if data_items is not None:
            pulumi.set(__self__, "data_items", data_items)
        if data_size is not None:
            pulumi.set(__self__, "data_size", data_size)
        if filesets is not None:
            pulumi.set(__self__, "filesets", filesets)
        if tables is not None:
            pulumi.set(__self__, "tables", tables)

    @property
    @pulumi.getter(name="dataItems")
    def data_items(self) -> Optional[int]:
        return pulumi.get(self, "data_items")

    @property
    @pulumi.getter(name="dataSize")
    def data_size(self) -> Optional[int]:
        return pulumi.get(self, "data_size")

    @property
    @pulumi.getter
    def filesets(self) -> Optional[int]:
        return pulumi.get(self, "filesets")

    @property
    @pulumi.getter
    def tables(self) -> Optional[int]:
        return pulumi.get(self, "tables")


@pulumi.output_type
class AssetIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class AssetIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class AssetResourceSpec(dict):
    def __init__(__self__, *,
                 type: str,
                 name: Optional[str] = None):
        """
        :param str type: Required. Immutable. Type of resource. Possible values: STORAGE_BUCKET, BIGQUERY_DATASET
               
               - - -
        :param str name: Immutable. Relative name of the cloud resource that contains the data that is being managed within a lake. For example: `projects/{project_number}/buckets/{bucket_id}` `projects/{project_number}/datasets/{dataset_id}`
        """
        pulumi.set(__self__, "type", type)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Required. Immutable. Type of resource. Possible values: STORAGE_BUCKET, BIGQUERY_DATASET

        - - -
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Immutable. Relative name of the cloud resource that contains the data that is being managed within a lake. For example: `projects/{project_number}/buckets/{bucket_id}` `projects/{project_number}/datasets/{dataset_id}`
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class AssetResourceStatus(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "updateTime":
            suggest = "update_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssetResourceStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssetResourceStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssetResourceStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 message: Optional[str] = None,
                 state: Optional[str] = None,
                 update_time: Optional[str] = None):
        """
        :param str state: Output only. Current state of the asset. Possible values: STATE_UNSPECIFIED, ACTIVE, CREATING, DELETING, ACTION_REQUIRED
        :param str update_time: Output only. The time when the asset was last updated.
        """
        if message is not None:
            pulumi.set(__self__, "message", message)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        Output only. Current state of the asset. Possible values: STATE_UNSPECIFIED, ACTIVE, CREATING, DELETING, ACTION_REQUIRED
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[str]:
        """
        Output only. The time when the asset was last updated.
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class AssetSecurityStatus(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "updateTime":
            suggest = "update_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssetSecurityStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssetSecurityStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssetSecurityStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 message: Optional[str] = None,
                 state: Optional[str] = None,
                 update_time: Optional[str] = None):
        """
        :param str state: Output only. Current state of the asset. Possible values: STATE_UNSPECIFIED, ACTIVE, CREATING, DELETING, ACTION_REQUIRED
        :param str update_time: Output only. The time when the asset was last updated.
        """
        if message is not None:
            pulumi.set(__self__, "message", message)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        Output only. Current state of the asset. Possible values: STATE_UNSPECIFIED, ACTIVE, CREATING, DELETING, ACTION_REQUIRED
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[str]:
        """
        Output only. The time when the asset was last updated.
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class DatascanData(dict):
    def __init__(__self__, *,
                 entity: Optional[str] = None,
                 resource: Optional[str] = None):
        """
        :param str entity: The Dataplex entity that represents the data source(e.g. BigQuery table) for Datascan.
        :param str resource: The service-qualified full resource name of the cloud resource for a DataScan job to scan against. The field could be:
               (Cloud Storage bucket for DataDiscoveryScan)BigQuery table of type "TABLE" for DataProfileScan/DataQualityScan.
        """
        if entity is not None:
            pulumi.set(__self__, "entity", entity)
        if resource is not None:
            pulumi.set(__self__, "resource", resource)

    @property
    @pulumi.getter
    def entity(self) -> Optional[str]:
        """
        The Dataplex entity that represents the data source(e.g. BigQuery table) for Datascan.
        """
        return pulumi.get(self, "entity")

    @property
    @pulumi.getter
    def resource(self) -> Optional[str]:
        """
        The service-qualified full resource name of the cloud resource for a DataScan job to scan against. The field could be:
        (Cloud Storage bucket for DataDiscoveryScan)BigQuery table of type "TABLE" for DataProfileScan/DataQualityScan.
        """
        return pulumi.get(self, "resource")


@pulumi.output_type
class DatascanDataProfileResult(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rowCount":
            suggest = "row_count"
        elif key == "scannedDatas":
            suggest = "scanned_datas"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatascanDataProfileResult. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatascanDataProfileResult.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatascanDataProfileResult.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 profiles: Optional[Sequence['outputs.DatascanDataProfileResultProfile']] = None,
                 row_count: Optional[str] = None,
                 scanned_datas: Optional[Sequence['outputs.DatascanDataProfileResultScannedData']] = None):
        """
        :param Sequence['DatascanDataProfileResultProfileArgs'] profiles: Profile information for the corresponding field.
               Structure is documented below.
        :param str row_count: The count of rows scanned.
        :param Sequence['DatascanDataProfileResultScannedDataArgs'] scanned_datas: (Output)
               The data scanned for this result.
               Structure is documented below.
        """
        if profiles is not None:
            pulumi.set(__self__, "profiles", profiles)
        if row_count is not None:
            pulumi.set(__self__, "row_count", row_count)
        if scanned_datas is not None:
            pulumi.set(__self__, "scanned_datas", scanned_datas)

    @property
    @pulumi.getter
    def profiles(self) -> Optional[Sequence['outputs.DatascanDataProfileResultProfile']]:
        """
        Profile information for the corresponding field.
        Structure is documented below.
        """
        return pulumi.get(self, "profiles")

    @property
    @pulumi.getter(name="rowCount")
    def row_count(self) -> Optional[str]:
        """
        The count of rows scanned.
        """
        return pulumi.get(self, "row_count")

    @property
    @pulumi.getter(name="scannedDatas")
    def scanned_datas(self) -> Optional[Sequence['outputs.DatascanDataProfileResultScannedData']]:
        """
        (Output)
        The data scanned for this result.
        Structure is documented below.
        """
        return pulumi.get(self, "scanned_datas")


@pulumi.output_type
class DatascanDataProfileResultProfile(dict):
    def __init__(__self__, *,
                 fields: Optional[Sequence['outputs.DatascanDataProfileResultProfileField']] = None):
        """
        :param Sequence['DatascanDataProfileResultProfileFieldArgs'] fields: List of fields with structural and profile information for each field.
               Structure is documented below.
        """
        if fields is not None:
            pulumi.set(__self__, "fields", fields)

    @property
    @pulumi.getter
    def fields(self) -> Optional[Sequence['outputs.DatascanDataProfileResultProfileField']]:
        """
        List of fields with structural and profile information for each field.
        Structure is documented below.
        """
        return pulumi.get(self, "fields")


@pulumi.output_type
class DatascanDataProfileResultProfileField(dict):
    def __init__(__self__, *,
                 mode: Optional[str] = None,
                 name: Optional[str] = None,
                 profile: Optional['outputs.DatascanDataProfileResultProfileFieldProfile'] = None,
                 type: Optional[str] = None):
        """
        :param str mode: The mode of the field. Possible values include:
               1. REQUIRED, if it is a required field.
               2. NULLABLE, if it is an optional field.
               3. REPEATED, if it is a repeated field.
        :param str name: The name of the field.
        :param 'DatascanDataProfileResultProfileFieldProfileArgs' profile: Profile information for the corresponding field.
               Structure is documented below.
        :param str type: The field data type.
        """
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        The mode of the field. Possible values include:
        1. REQUIRED, if it is a required field.
        2. NULLABLE, if it is an optional field.
        3. REPEATED, if it is a repeated field.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the field.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def profile(self) -> Optional['outputs.DatascanDataProfileResultProfileFieldProfile']:
        """
        Profile information for the corresponding field.
        Structure is documented below.
        """
        return pulumi.get(self, "profile")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The field data type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class DatascanDataProfileResultProfileFieldProfile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "distinctRatio":
            suggest = "distinct_ratio"
        elif key == "doubleProfiles":
            suggest = "double_profiles"
        elif key == "integerProfiles":
            suggest = "integer_profiles"
        elif key == "nullRatio":
            suggest = "null_ratio"
        elif key == "stringProfiles":
            suggest = "string_profiles"
        elif key == "topNValues":
            suggest = "top_n_values"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatascanDataProfileResultProfileFieldProfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatascanDataProfileResultProfileFieldProfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatascanDataProfileResultProfileFieldProfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 distinct_ratio: Optional[int] = None,
                 double_profiles: Optional[Sequence['outputs.DatascanDataProfileResultProfileFieldProfileDoubleProfile']] = None,
                 integer_profiles: Optional[Sequence['outputs.DatascanDataProfileResultProfileFieldProfileIntegerProfile']] = None,
                 null_ratio: Optional[int] = None,
                 string_profiles: Optional[Sequence['outputs.DatascanDataProfileResultProfileFieldProfileStringProfile']] = None,
                 top_n_values: Optional['outputs.DatascanDataProfileResultProfileFieldProfileTopNValues'] = None):
        """
        :param int distinct_ratio: Ratio of rows with distinct values against total scanned rows. Not available for complex non-groupable field type RECORD and fields with REPEATABLE mode.
        :param Sequence['DatascanDataProfileResultProfileFieldProfileDoubleProfileArgs'] double_profiles: (Output)
               Double type field information.
               Structure is documented below.
        :param Sequence['DatascanDataProfileResultProfileFieldProfileIntegerProfileArgs'] integer_profiles: (Output)
               Integer type field information.
               Structure is documented below.
        :param int null_ratio: (Output)
               Ratio of rows with null value against total scanned rows.
        :param Sequence['DatascanDataProfileResultProfileFieldProfileStringProfileArgs'] string_profiles: (Output)
               String type field information.
               Structure is documented below.
        :param 'DatascanDataProfileResultProfileFieldProfileTopNValuesArgs' top_n_values: The list of top N non-null values and number of times they occur in the scanned data. N is 10 or equal to the number of distinct values in the field, whichever is smaller. Not available for complex non-groupable field type RECORD and fields with REPEATABLE mode.
               Structure is documented below.
        """
        if distinct_ratio is not None:
            pulumi.set(__self__, "distinct_ratio", distinct_ratio)
        if double_profiles is not None:
            pulumi.set(__self__, "double_profiles", double_profiles)
        if integer_profiles is not None:
            pulumi.set(__self__, "integer_profiles", integer_profiles)
        if null_ratio is not None:
            pulumi.set(__self__, "null_ratio", null_ratio)
        if string_profiles is not None:
            pulumi.set(__self__, "string_profiles", string_profiles)
        if top_n_values is not None:
            pulumi.set(__self__, "top_n_values", top_n_values)

    @property
    @pulumi.getter(name="distinctRatio")
    def distinct_ratio(self) -> Optional[int]:
        """
        Ratio of rows with distinct values against total scanned rows. Not available for complex non-groupable field type RECORD and fields with REPEATABLE mode.
        """
        return pulumi.get(self, "distinct_ratio")

    @property
    @pulumi.getter(name="doubleProfiles")
    def double_profiles(self) -> Optional[Sequence['outputs.DatascanDataProfileResultProfileFieldProfileDoubleProfile']]:
        """
        (Output)
        Double type field information.
        Structure is documented below.
        """
        return pulumi.get(self, "double_profiles")

    @property
    @pulumi.getter(name="integerProfiles")
    def integer_profiles(self) -> Optional[Sequence['outputs.DatascanDataProfileResultProfileFieldProfileIntegerProfile']]:
        """
        (Output)
        Integer type field information.
        Structure is documented below.
        """
        return pulumi.get(self, "integer_profiles")

    @property
    @pulumi.getter(name="nullRatio")
    def null_ratio(self) -> Optional[int]:
        """
        (Output)
        Ratio of rows with null value against total scanned rows.
        """
        return pulumi.get(self, "null_ratio")

    @property
    @pulumi.getter(name="stringProfiles")
    def string_profiles(self) -> Optional[Sequence['outputs.DatascanDataProfileResultProfileFieldProfileStringProfile']]:
        """
        (Output)
        String type field information.
        Structure is documented below.
        """
        return pulumi.get(self, "string_profiles")

    @property
    @pulumi.getter(name="topNValues")
    def top_n_values(self) -> Optional['outputs.DatascanDataProfileResultProfileFieldProfileTopNValues']:
        """
        The list of top N non-null values and number of times they occur in the scanned data. N is 10 or equal to the number of distinct values in the field, whichever is smaller. Not available for complex non-groupable field type RECORD and fields with REPEATABLE mode.
        Structure is documented below.
        """
        return pulumi.get(self, "top_n_values")


@pulumi.output_type
class DatascanDataProfileResultProfileFieldProfileDoubleProfile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "standardDeviation":
            suggest = "standard_deviation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatascanDataProfileResultProfileFieldProfileDoubleProfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatascanDataProfileResultProfileFieldProfileDoubleProfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatascanDataProfileResultProfileFieldProfileDoubleProfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 average: Optional[int] = None,
                 max: Optional[str] = None,
                 min: Optional[str] = None,
                 quartiles: Optional[str] = None,
                 standard_deviation: Optional[int] = None):
        """
        :param int average: Average of non-null values in the scanned data. NaN, if the field has a NaN.
        :param str max: Maximum of non-null values in the scanned data. NaN, if the field has a NaN.
        :param str min: Minimum of non-null values in the scanned data. NaN, if the field has a NaN.
        :param str quartiles: A quartile divides the number of data points into four parts, or quarters, of more-or-less equal size. Three main quartiles used are: The first quartile (Q1) splits off the lowest 25% of data from the highest 75%. It is also known as the lower or 25th empirical quartile, as 25% of the data is below this point. The second quartile (Q2) is the median of a data set. So, 50% of the data lies below this point. The third quartile (Q3) splits off the highest 25% of data from the lowest 75%. It is known as the upper or 75th empirical quartile, as 75% of the data lies below this point. Here, the quartiles is provided as an ordered list of quartile values for the scanned data, occurring in order Q1, median, Q3.
        :param int standard_deviation: Standard deviation of non-null values in the scanned data. NaN, if the field has a NaN.
        """
        if average is not None:
            pulumi.set(__self__, "average", average)
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)
        if quartiles is not None:
            pulumi.set(__self__, "quartiles", quartiles)
        if standard_deviation is not None:
            pulumi.set(__self__, "standard_deviation", standard_deviation)

    @property
    @pulumi.getter
    def average(self) -> Optional[int]:
        """
        Average of non-null values in the scanned data. NaN, if the field has a NaN.
        """
        return pulumi.get(self, "average")

    @property
    @pulumi.getter
    def max(self) -> Optional[str]:
        """
        Maximum of non-null values in the scanned data. NaN, if the field has a NaN.
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> Optional[str]:
        """
        Minimum of non-null values in the scanned data. NaN, if the field has a NaN.
        """
        return pulumi.get(self, "min")

    @property
    @pulumi.getter
    def quartiles(self) -> Optional[str]:
        """
        A quartile divides the number of data points into four parts, or quarters, of more-or-less equal size. Three main quartiles used are: The first quartile (Q1) splits off the lowest 25% of data from the highest 75%. It is also known as the lower or 25th empirical quartile, as 25% of the data is below this point. The second quartile (Q2) is the median of a data set. So, 50% of the data lies below this point. The third quartile (Q3) splits off the highest 25% of data from the lowest 75%. It is known as the upper or 75th empirical quartile, as 75% of the data lies below this point. Here, the quartiles is provided as an ordered list of quartile values for the scanned data, occurring in order Q1, median, Q3.
        """
        return pulumi.get(self, "quartiles")

    @property
    @pulumi.getter(name="standardDeviation")
    def standard_deviation(self) -> Optional[int]:
        """
        Standard deviation of non-null values in the scanned data. NaN, if the field has a NaN.
        """
        return pulumi.get(self, "standard_deviation")


@pulumi.output_type
class DatascanDataProfileResultProfileFieldProfileIntegerProfile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "standardDeviation":
            suggest = "standard_deviation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatascanDataProfileResultProfileFieldProfileIntegerProfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatascanDataProfileResultProfileFieldProfileIntegerProfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatascanDataProfileResultProfileFieldProfileIntegerProfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 average: Optional[int] = None,
                 max: Optional[str] = None,
                 min: Optional[str] = None,
                 quartiles: Optional[str] = None,
                 standard_deviation: Optional[int] = None):
        """
        :param int average: Average of non-null values in the scanned data. NaN, if the field has a NaN.
        :param str max: Maximum of non-null values in the scanned data. NaN, if the field has a NaN.
        :param str min: Minimum of non-null values in the scanned data. NaN, if the field has a NaN.
        :param str quartiles: A quartile divides the number of data points into four parts, or quarters, of more-or-less equal size. Three main quartiles used are: The first quartile (Q1) splits off the lowest 25% of data from the highest 75%. It is also known as the lower or 25th empirical quartile, as 25% of the data is below this point. The second quartile (Q2) is the median of a data set. So, 50% of the data lies below this point. The third quartile (Q3) splits off the highest 25% of data from the lowest 75%. It is known as the upper or 75th empirical quartile, as 75% of the data lies below this point. Here, the quartiles is provided as an ordered list of quartile values for the scanned data, occurring in order Q1, median, Q3.
        :param int standard_deviation: Standard deviation of non-null values in the scanned data. NaN, if the field has a NaN.
        """
        if average is not None:
            pulumi.set(__self__, "average", average)
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)
        if quartiles is not None:
            pulumi.set(__self__, "quartiles", quartiles)
        if standard_deviation is not None:
            pulumi.set(__self__, "standard_deviation", standard_deviation)

    @property
    @pulumi.getter
    def average(self) -> Optional[int]:
        """
        Average of non-null values in the scanned data. NaN, if the field has a NaN.
        """
        return pulumi.get(self, "average")

    @property
    @pulumi.getter
    def max(self) -> Optional[str]:
        """
        Maximum of non-null values in the scanned data. NaN, if the field has a NaN.
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> Optional[str]:
        """
        Minimum of non-null values in the scanned data. NaN, if the field has a NaN.
        """
        return pulumi.get(self, "min")

    @property
    @pulumi.getter
    def quartiles(self) -> Optional[str]:
        """
        A quartile divides the number of data points into four parts, or quarters, of more-or-less equal size. Three main quartiles used are: The first quartile (Q1) splits off the lowest 25% of data from the highest 75%. It is also known as the lower or 25th empirical quartile, as 25% of the data is below this point. The second quartile (Q2) is the median of a data set. So, 50% of the data lies below this point. The third quartile (Q3) splits off the highest 25% of data from the lowest 75%. It is known as the upper or 75th empirical quartile, as 75% of the data lies below this point. Here, the quartiles is provided as an ordered list of quartile values for the scanned data, occurring in order Q1, median, Q3.
        """
        return pulumi.get(self, "quartiles")

    @property
    @pulumi.getter(name="standardDeviation")
    def standard_deviation(self) -> Optional[int]:
        """
        Standard deviation of non-null values in the scanned data. NaN, if the field has a NaN.
        """
        return pulumi.get(self, "standard_deviation")


@pulumi.output_type
class DatascanDataProfileResultProfileFieldProfileStringProfile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "averageLength":
            suggest = "average_length"
        elif key == "maxLength":
            suggest = "max_length"
        elif key == "minLength":
            suggest = "min_length"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatascanDataProfileResultProfileFieldProfileStringProfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatascanDataProfileResultProfileFieldProfileStringProfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatascanDataProfileResultProfileFieldProfileStringProfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 average_length: Optional[int] = None,
                 max_length: Optional[str] = None,
                 min_length: Optional[str] = None):
        """
        :param int average_length: Average length of non-null values in the scanned data.
        :param str max_length: Maximum length of non-null values in the scanned data.
        :param str min_length: Minimum length of non-null values in the scanned data.
        """
        if average_length is not None:
            pulumi.set(__self__, "average_length", average_length)
        if max_length is not None:
            pulumi.set(__self__, "max_length", max_length)
        if min_length is not None:
            pulumi.set(__self__, "min_length", min_length)

    @property
    @pulumi.getter(name="averageLength")
    def average_length(self) -> Optional[int]:
        """
        Average length of non-null values in the scanned data.
        """
        return pulumi.get(self, "average_length")

    @property
    @pulumi.getter(name="maxLength")
    def max_length(self) -> Optional[str]:
        """
        Maximum length of non-null values in the scanned data.
        """
        return pulumi.get(self, "max_length")

    @property
    @pulumi.getter(name="minLength")
    def min_length(self) -> Optional[str]:
        """
        Minimum length of non-null values in the scanned data.
        """
        return pulumi.get(self, "min_length")


@pulumi.output_type
class DatascanDataProfileResultProfileFieldProfileTopNValues(dict):
    def __init__(__self__, *,
                 count: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str count: Count of the corresponding value in the scanned data.
        :param str value: String value of a top N non-null value.
        """
        if count is not None:
            pulumi.set(__self__, "count", count)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def count(self) -> Optional[str]:
        """
        Count of the corresponding value in the scanned data.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        String value of a top N non-null value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DatascanDataProfileResultScannedData(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "incrementalField":
            suggest = "incremental_field"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatascanDataProfileResultScannedData. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatascanDataProfileResultScannedData.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatascanDataProfileResultScannedData.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 incremental_field: Optional['outputs.DatascanDataProfileResultScannedDataIncrementalField'] = None):
        """
        :param 'DatascanDataProfileResultScannedDataIncrementalFieldArgs' incremental_field: The range denoted by values of an incremental field
               Structure is documented below.
        """
        if incremental_field is not None:
            pulumi.set(__self__, "incremental_field", incremental_field)

    @property
    @pulumi.getter(name="incrementalField")
    def incremental_field(self) -> Optional['outputs.DatascanDataProfileResultScannedDataIncrementalField']:
        """
        The range denoted by values of an incremental field
        Structure is documented below.
        """
        return pulumi.get(self, "incremental_field")


@pulumi.output_type
class DatascanDataProfileResultScannedDataIncrementalField(dict):
    def __init__(__self__, *,
                 end: Optional[str] = None,
                 field: Optional[str] = None,
                 start: Optional[str] = None):
        """
        :param str end: Value that marks the end of the range.
        :param str field: The unnested field (of type Date or Timestamp) that contains values which monotonically increase over time. If not specified, a data scan will run for all data in the table.
        :param str start: Value that marks the start of the range.
        """
        if end is not None:
            pulumi.set(__self__, "end", end)
        if field is not None:
            pulumi.set(__self__, "field", field)
        if start is not None:
            pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter
    def end(self) -> Optional[str]:
        """
        Value that marks the end of the range.
        """
        return pulumi.get(self, "end")

    @property
    @pulumi.getter
    def field(self) -> Optional[str]:
        """
        The unnested field (of type Date or Timestamp) that contains values which monotonically increase over time. If not specified, a data scan will run for all data in the table.
        """
        return pulumi.get(self, "field")

    @property
    @pulumi.getter
    def start(self) -> Optional[str]:
        """
        Value that marks the start of the range.
        """
        return pulumi.get(self, "start")


@pulumi.output_type
class DatascanDataProfileSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rowFilter":
            suggest = "row_filter"
        elif key == "samplingPercent":
            suggest = "sampling_percent"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatascanDataProfileSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatascanDataProfileSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatascanDataProfileSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 row_filter: Optional[str] = None,
                 sampling_percent: Optional[float] = None):
        """
        :param str row_filter: A filter applied to all rows in a single DataScan job. The filter needs to be a valid SQL expression for a WHERE clause in BigQuery standard SQL syntax. Example: col1 >= 0 AND col2 < 10
        :param float sampling_percent: The percentage of the records to be selected from the dataset for DataScan.
        """
        if row_filter is not None:
            pulumi.set(__self__, "row_filter", row_filter)
        if sampling_percent is not None:
            pulumi.set(__self__, "sampling_percent", sampling_percent)

    @property
    @pulumi.getter(name="rowFilter")
    def row_filter(self) -> Optional[str]:
        """
        A filter applied to all rows in a single DataScan job. The filter needs to be a valid SQL expression for a WHERE clause in BigQuery standard SQL syntax. Example: col1 >= 0 AND col2 < 10
        """
        return pulumi.get(self, "row_filter")

    @property
    @pulumi.getter(name="samplingPercent")
    def sampling_percent(self) -> Optional[float]:
        """
        The percentage of the records to be selected from the dataset for DataScan.
        """
        return pulumi.get(self, "sampling_percent")


@pulumi.output_type
class DatascanDataQualityResult(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rowCount":
            suggest = "row_count"
        elif key == "scannedDatas":
            suggest = "scanned_datas"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatascanDataQualityResult. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatascanDataQualityResult.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatascanDataQualityResult.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dimensions: Optional[Sequence['outputs.DatascanDataQualityResultDimension']] = None,
                 passed: Optional[bool] = None,
                 row_count: Optional[str] = None,
                 rules: Optional[Sequence['outputs.DatascanDataQualityResultRule']] = None,
                 scanned_datas: Optional[Sequence['outputs.DatascanDataQualityResultScannedData']] = None):
        """
        :param Sequence['DatascanDataQualityResultDimensionArgs'] dimensions: A list of results at the dimension level.
               Structure is documented below.
        :param bool passed: (Output)
               Whether the rule passed or failed.
        :param str row_count: The count of rows scanned.
        :param Sequence['DatascanDataQualityResultRuleArgs'] rules: The list of rules to evaluate against a data source. At least one rule is required.
               Structure is documented below.
        :param Sequence['DatascanDataQualityResultScannedDataArgs'] scanned_datas: (Output)
               The data scanned for this result.
               Structure is documented below.
        """
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if passed is not None:
            pulumi.set(__self__, "passed", passed)
        if row_count is not None:
            pulumi.set(__self__, "row_count", row_count)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if scanned_datas is not None:
            pulumi.set(__self__, "scanned_datas", scanned_datas)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[Sequence['outputs.DatascanDataQualityResultDimension']]:
        """
        A list of results at the dimension level.
        Structure is documented below.
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter
    def passed(self) -> Optional[bool]:
        """
        (Output)
        Whether the rule passed or failed.
        """
        return pulumi.get(self, "passed")

    @property
    @pulumi.getter(name="rowCount")
    def row_count(self) -> Optional[str]:
        """
        The count of rows scanned.
        """
        return pulumi.get(self, "row_count")

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.DatascanDataQualityResultRule']]:
        """
        The list of rules to evaluate against a data source. At least one rule is required.
        Structure is documented below.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter(name="scannedDatas")
    def scanned_datas(self) -> Optional[Sequence['outputs.DatascanDataQualityResultScannedData']]:
        """
        (Output)
        The data scanned for this result.
        Structure is documented below.
        """
        return pulumi.get(self, "scanned_datas")


@pulumi.output_type
class DatascanDataQualityResultDimension(dict):
    def __init__(__self__, *,
                 passed: Optional[bool] = None):
        """
        :param bool passed: (Output)
               Whether the rule passed or failed.
        """
        if passed is not None:
            pulumi.set(__self__, "passed", passed)

    @property
    @pulumi.getter
    def passed(self) -> Optional[bool]:
        """
        (Output)
        Whether the rule passed or failed.
        """
        return pulumi.get(self, "passed")


@pulumi.output_type
class DatascanDataQualityResultRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "evaluatedCount":
            suggest = "evaluated_count"
        elif key == "failingRowsQuery":
            suggest = "failing_rows_query"
        elif key == "nullCount":
            suggest = "null_count"
        elif key == "passRatio":
            suggest = "pass_ratio"
        elif key == "passedCount":
            suggest = "passed_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatascanDataQualityResultRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatascanDataQualityResultRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatascanDataQualityResultRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 evaluated_count: Optional[str] = None,
                 failing_rows_query: Optional[str] = None,
                 null_count: Optional[str] = None,
                 pass_ratio: Optional[int] = None,
                 passed: Optional[bool] = None,
                 passed_count: Optional[str] = None,
                 rules: Optional[Sequence['outputs.DatascanDataQualityResultRuleRule']] = None):
        """
        :param str evaluated_count: (Output)
               The number of rows a rule was evaluated against. This field is only valid for ColumnMap type rules.
               Evaluated count can be configured to either
               1. include all rows (default) - with null rows automatically failing rule evaluation, or
               2. exclude null rows from the evaluatedCount, by setting ignore_nulls = true.
        :param str failing_rows_query: (Output)
               The query to find rows that did not pass this rule. Only applies to ColumnMap and RowCondition rules.
        :param str null_count: (Output)
               The number of rows with null values in the specified column.
        :param int pass_ratio: (Output)
               The ratio of passedCount / evaluatedCount. This field is only valid for ColumnMap type rules.
        :param bool passed: (Output)
               Whether the rule passed or failed.
        :param str passed_count: (Output)
               The number of rows which passed a rule evaluation. This field is only valid for ColumnMap type rules.
        :param Sequence['DatascanDataQualityResultRuleRuleArgs'] rules: (Output)
               The rule specified in the DataQualitySpec, as is.
               Structure is documented below.
        """
        if evaluated_count is not None:
            pulumi.set(__self__, "evaluated_count", evaluated_count)
        if failing_rows_query is not None:
            pulumi.set(__self__, "failing_rows_query", failing_rows_query)
        if null_count is not None:
            pulumi.set(__self__, "null_count", null_count)
        if pass_ratio is not None:
            pulumi.set(__self__, "pass_ratio", pass_ratio)
        if passed is not None:
            pulumi.set(__self__, "passed", passed)
        if passed_count is not None:
            pulumi.set(__self__, "passed_count", passed_count)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter(name="evaluatedCount")
    def evaluated_count(self) -> Optional[str]:
        """
        (Output)
        The number of rows a rule was evaluated against. This field is only valid for ColumnMap type rules.
        Evaluated count can be configured to either
        1. include all rows (default) - with null rows automatically failing rule evaluation, or
        2. exclude null rows from the evaluatedCount, by setting ignore_nulls = true.
        """
        return pulumi.get(self, "evaluated_count")

    @property
    @pulumi.getter(name="failingRowsQuery")
    def failing_rows_query(self) -> Optional[str]:
        """
        (Output)
        The query to find rows that did not pass this rule. Only applies to ColumnMap and RowCondition rules.
        """
        return pulumi.get(self, "failing_rows_query")

    @property
    @pulumi.getter(name="nullCount")
    def null_count(self) -> Optional[str]:
        """
        (Output)
        The number of rows with null values in the specified column.
        """
        return pulumi.get(self, "null_count")

    @property
    @pulumi.getter(name="passRatio")
    def pass_ratio(self) -> Optional[int]:
        """
        (Output)
        The ratio of passedCount / evaluatedCount. This field is only valid for ColumnMap type rules.
        """
        return pulumi.get(self, "pass_ratio")

    @property
    @pulumi.getter
    def passed(self) -> Optional[bool]:
        """
        (Output)
        Whether the rule passed or failed.
        """
        return pulumi.get(self, "passed")

    @property
    @pulumi.getter(name="passedCount")
    def passed_count(self) -> Optional[str]:
        """
        (Output)
        The number of rows which passed a rule evaluation. This field is only valid for ColumnMap type rules.
        """
        return pulumi.get(self, "passed_count")

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.DatascanDataQualityResultRuleRule']]:
        """
        (Output)
        The rule specified in the DataQualitySpec, as is.
        Structure is documented below.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class DatascanDataQualityResultRuleRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ignoreNull":
            suggest = "ignore_null"
        elif key == "nonNullExpectations":
            suggest = "non_null_expectations"
        elif key == "rangeExpectations":
            suggest = "range_expectations"
        elif key == "regexExpectations":
            suggest = "regex_expectations"
        elif key == "rowConditionExpectations":
            suggest = "row_condition_expectations"
        elif key == "setExpectations":
            suggest = "set_expectations"
        elif key == "statisticRangeExpectations":
            suggest = "statistic_range_expectations"
        elif key == "tableConditionExpectations":
            suggest = "table_condition_expectations"
        elif key == "uniquenessExpectations":
            suggest = "uniqueness_expectations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatascanDataQualityResultRuleRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatascanDataQualityResultRuleRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatascanDataQualityResultRuleRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 column: Optional[str] = None,
                 dimension: Optional[str] = None,
                 ignore_null: Optional[bool] = None,
                 non_null_expectations: Optional[Sequence['outputs.DatascanDataQualityResultRuleRuleNonNullExpectation']] = None,
                 range_expectations: Optional[Sequence['outputs.DatascanDataQualityResultRuleRuleRangeExpectation']] = None,
                 regex_expectations: Optional[Sequence['outputs.DatascanDataQualityResultRuleRuleRegexExpectation']] = None,
                 row_condition_expectations: Optional[Sequence['outputs.DatascanDataQualityResultRuleRuleRowConditionExpectation']] = None,
                 set_expectations: Optional[Sequence['outputs.DatascanDataQualityResultRuleRuleSetExpectation']] = None,
                 statistic_range_expectations: Optional[Sequence['outputs.DatascanDataQualityResultRuleRuleStatisticRangeExpectation']] = None,
                 table_condition_expectations: Optional[Sequence['outputs.DatascanDataQualityResultRuleRuleTableConditionExpectation']] = None,
                 threshold: Optional[int] = None,
                 uniqueness_expectations: Optional[Sequence['outputs.DatascanDataQualityResultRuleRuleUniquenessExpectation']] = None):
        """
        :param str column: The unnested column which this rule is evaluated against.
        :param str dimension: The dimension a rule belongs to. Results are also aggregated at the dimension level. Supported dimensions are ["COMPLETENESS", "ACCURACY", "CONSISTENCY", "VALIDITY", "UNIQUENESS", "INTEGRITY"]
        :param bool ignore_null: Rows with null values will automatically fail a rule, unless ignoreNull is true. In that case, such null rows are trivially considered passing. Only applicable to ColumnMap rules.
        :param Sequence['DatascanDataQualityResultRuleRuleNonNullExpectationArgs'] non_null_expectations: ColumnMap rule which evaluates whether each column value is null.
        :param Sequence['DatascanDataQualityResultRuleRuleRangeExpectationArgs'] range_expectations: ColumnMap rule which evaluates whether each column value lies between a specified range.
               Structure is documented below.
        :param Sequence['DatascanDataQualityResultRuleRuleRegexExpectationArgs'] regex_expectations: ColumnMap rule which evaluates whether each column value matches a specified regex.
               Structure is documented below.
        :param Sequence['DatascanDataQualityResultRuleRuleRowConditionExpectationArgs'] row_condition_expectations: Table rule which evaluates whether each row passes the specified condition.
               Structure is documented below.
        :param Sequence['DatascanDataQualityResultRuleRuleSetExpectationArgs'] set_expectations: ColumnMap rule which evaluates whether each column value is contained by a specified set.
               Structure is documented below.
        :param Sequence['DatascanDataQualityResultRuleRuleStatisticRangeExpectationArgs'] statistic_range_expectations: ColumnAggregate rule which evaluates whether the column aggregate statistic lies between a specified range.
               Structure is documented below.
        :param Sequence['DatascanDataQualityResultRuleRuleTableConditionExpectationArgs'] table_condition_expectations: Table rule which evaluates whether the provided expression is true.
               Structure is documented below.
        :param int threshold: The minimum ratio of passing_rows / total_rows required to pass this rule, with a range of [0.0, 1.0]. 0 indicates default value (i.e. 1.0).
        :param Sequence['DatascanDataQualityResultRuleRuleUniquenessExpectationArgs'] uniqueness_expectations: ColumnAggregate rule which evaluates whether the column has duplicates.
        """
        if column is not None:
            pulumi.set(__self__, "column", column)
        if dimension is not None:
            pulumi.set(__self__, "dimension", dimension)
        if ignore_null is not None:
            pulumi.set(__self__, "ignore_null", ignore_null)
        if non_null_expectations is not None:
            pulumi.set(__self__, "non_null_expectations", non_null_expectations)
        if range_expectations is not None:
            pulumi.set(__self__, "range_expectations", range_expectations)
        if regex_expectations is not None:
            pulumi.set(__self__, "regex_expectations", regex_expectations)
        if row_condition_expectations is not None:
            pulumi.set(__self__, "row_condition_expectations", row_condition_expectations)
        if set_expectations is not None:
            pulumi.set(__self__, "set_expectations", set_expectations)
        if statistic_range_expectations is not None:
            pulumi.set(__self__, "statistic_range_expectations", statistic_range_expectations)
        if table_condition_expectations is not None:
            pulumi.set(__self__, "table_condition_expectations", table_condition_expectations)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)
        if uniqueness_expectations is not None:
            pulumi.set(__self__, "uniqueness_expectations", uniqueness_expectations)

    @property
    @pulumi.getter
    def column(self) -> Optional[str]:
        """
        The unnested column which this rule is evaluated against.
        """
        return pulumi.get(self, "column")

    @property
    @pulumi.getter
    def dimension(self) -> Optional[str]:
        """
        The dimension a rule belongs to. Results are also aggregated at the dimension level. Supported dimensions are ["COMPLETENESS", "ACCURACY", "CONSISTENCY", "VALIDITY", "UNIQUENESS", "INTEGRITY"]
        """
        return pulumi.get(self, "dimension")

    @property
    @pulumi.getter(name="ignoreNull")
    def ignore_null(self) -> Optional[bool]:
        """
        Rows with null values will automatically fail a rule, unless ignoreNull is true. In that case, such null rows are trivially considered passing. Only applicable to ColumnMap rules.
        """
        return pulumi.get(self, "ignore_null")

    @property
    @pulumi.getter(name="nonNullExpectations")
    def non_null_expectations(self) -> Optional[Sequence['outputs.DatascanDataQualityResultRuleRuleNonNullExpectation']]:
        """
        ColumnMap rule which evaluates whether each column value is null.
        """
        return pulumi.get(self, "non_null_expectations")

    @property
    @pulumi.getter(name="rangeExpectations")
    def range_expectations(self) -> Optional[Sequence['outputs.DatascanDataQualityResultRuleRuleRangeExpectation']]:
        """
        ColumnMap rule which evaluates whether each column value lies between a specified range.
        Structure is documented below.
        """
        return pulumi.get(self, "range_expectations")

    @property
    @pulumi.getter(name="regexExpectations")
    def regex_expectations(self) -> Optional[Sequence['outputs.DatascanDataQualityResultRuleRuleRegexExpectation']]:
        """
        ColumnMap rule which evaluates whether each column value matches a specified regex.
        Structure is documented below.
        """
        return pulumi.get(self, "regex_expectations")

    @property
    @pulumi.getter(name="rowConditionExpectations")
    def row_condition_expectations(self) -> Optional[Sequence['outputs.DatascanDataQualityResultRuleRuleRowConditionExpectation']]:
        """
        Table rule which evaluates whether each row passes the specified condition.
        Structure is documented below.
        """
        return pulumi.get(self, "row_condition_expectations")

    @property
    @pulumi.getter(name="setExpectations")
    def set_expectations(self) -> Optional[Sequence['outputs.DatascanDataQualityResultRuleRuleSetExpectation']]:
        """
        ColumnMap rule which evaluates whether each column value is contained by a specified set.
        Structure is documented below.
        """
        return pulumi.get(self, "set_expectations")

    @property
    @pulumi.getter(name="statisticRangeExpectations")
    def statistic_range_expectations(self) -> Optional[Sequence['outputs.DatascanDataQualityResultRuleRuleStatisticRangeExpectation']]:
        """
        ColumnAggregate rule which evaluates whether the column aggregate statistic lies between a specified range.
        Structure is documented below.
        """
        return pulumi.get(self, "statistic_range_expectations")

    @property
    @pulumi.getter(name="tableConditionExpectations")
    def table_condition_expectations(self) -> Optional[Sequence['outputs.DatascanDataQualityResultRuleRuleTableConditionExpectation']]:
        """
        Table rule which evaluates whether the provided expression is true.
        Structure is documented below.
        """
        return pulumi.get(self, "table_condition_expectations")

    @property
    @pulumi.getter
    def threshold(self) -> Optional[int]:
        """
        The minimum ratio of passing_rows / total_rows required to pass this rule, with a range of [0.0, 1.0]. 0 indicates default value (i.e. 1.0).
        """
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter(name="uniquenessExpectations")
    def uniqueness_expectations(self) -> Optional[Sequence['outputs.DatascanDataQualityResultRuleRuleUniquenessExpectation']]:
        """
        ColumnAggregate rule which evaluates whether the column has duplicates.
        """
        return pulumi.get(self, "uniqueness_expectations")


@pulumi.output_type
class DatascanDataQualityResultRuleRuleNonNullExpectation(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class DatascanDataQualityResultRuleRuleRangeExpectation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxValue":
            suggest = "max_value"
        elif key == "minValue":
            suggest = "min_value"
        elif key == "strictMaxEnabled":
            suggest = "strict_max_enabled"
        elif key == "strictMinEnabled":
            suggest = "strict_min_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatascanDataQualityResultRuleRuleRangeExpectation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatascanDataQualityResultRuleRuleRangeExpectation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatascanDataQualityResultRuleRuleRangeExpectation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_value: Optional[str] = None,
                 min_value: Optional[str] = None,
                 strict_max_enabled: Optional[bool] = None,
                 strict_min_enabled: Optional[bool] = None):
        """
        :param str max_value: The maximum column value allowed for a row to pass this validation. At least one of minValue and maxValue need to be provided.
        :param str min_value: The minimum column value allowed for a row to pass this validation. At least one of minValue and maxValue need to be provided.
        :param bool strict_max_enabled: Whether each value needs to be strictly lesser than ('<') the maximum, or if equality is allowed.
               Only relevant if a maxValue has been defined. Default = false.
        :param bool strict_min_enabled: Whether each value needs to be strictly greater than ('>') the minimum, or if equality is allowed.
               Only relevant if a minValue has been defined. Default = false.
        """
        if max_value is not None:
            pulumi.set(__self__, "max_value", max_value)
        if min_value is not None:
            pulumi.set(__self__, "min_value", min_value)
        if strict_max_enabled is not None:
            pulumi.set(__self__, "strict_max_enabled", strict_max_enabled)
        if strict_min_enabled is not None:
            pulumi.set(__self__, "strict_min_enabled", strict_min_enabled)

    @property
    @pulumi.getter(name="maxValue")
    def max_value(self) -> Optional[str]:
        """
        The maximum column value allowed for a row to pass this validation. At least one of minValue and maxValue need to be provided.
        """
        return pulumi.get(self, "max_value")

    @property
    @pulumi.getter(name="minValue")
    def min_value(self) -> Optional[str]:
        """
        The minimum column value allowed for a row to pass this validation. At least one of minValue and maxValue need to be provided.
        """
        return pulumi.get(self, "min_value")

    @property
    @pulumi.getter(name="strictMaxEnabled")
    def strict_max_enabled(self) -> Optional[bool]:
        """
        Whether each value needs to be strictly lesser than ('<') the maximum, or if equality is allowed.
        Only relevant if a maxValue has been defined. Default = false.
        """
        return pulumi.get(self, "strict_max_enabled")

    @property
    @pulumi.getter(name="strictMinEnabled")
    def strict_min_enabled(self) -> Optional[bool]:
        """
        Whether each value needs to be strictly greater than ('>') the minimum, or if equality is allowed.
        Only relevant if a minValue has been defined. Default = false.
        """
        return pulumi.get(self, "strict_min_enabled")


@pulumi.output_type
class DatascanDataQualityResultRuleRuleRegexExpectation(dict):
    def __init__(__self__, *,
                 regex: Optional[str] = None):
        """
        :param str regex: A regular expression the column value is expected to match.
        """
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def regex(self) -> Optional[str]:
        """
        A regular expression the column value is expected to match.
        """
        return pulumi.get(self, "regex")


@pulumi.output_type
class DatascanDataQualityResultRuleRuleRowConditionExpectation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sqlExpression":
            suggest = "sql_expression"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatascanDataQualityResultRuleRuleRowConditionExpectation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatascanDataQualityResultRuleRuleRowConditionExpectation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatascanDataQualityResultRuleRuleRowConditionExpectation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sql_expression: Optional[str] = None):
        """
        :param str sql_expression: The SQL expression.
        """
        if sql_expression is not None:
            pulumi.set(__self__, "sql_expression", sql_expression)

    @property
    @pulumi.getter(name="sqlExpression")
    def sql_expression(self) -> Optional[str]:
        """
        The SQL expression.
        """
        return pulumi.get(self, "sql_expression")


@pulumi.output_type
class DatascanDataQualityResultRuleRuleSetExpectation(dict):
    def __init__(__self__, *,
                 values: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] values: Expected values for the column value.
        """
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[str]]:
        """
        Expected values for the column value.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class DatascanDataQualityResultRuleRuleStatisticRangeExpectation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxValue":
            suggest = "max_value"
        elif key == "minValue":
            suggest = "min_value"
        elif key == "strictMaxEnabled":
            suggest = "strict_max_enabled"
        elif key == "strictMinEnabled":
            suggest = "strict_min_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatascanDataQualityResultRuleRuleStatisticRangeExpectation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatascanDataQualityResultRuleRuleStatisticRangeExpectation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatascanDataQualityResultRuleRuleStatisticRangeExpectation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_value: Optional[str] = None,
                 min_value: Optional[str] = None,
                 statistic: Optional[str] = None,
                 strict_max_enabled: Optional[bool] = None,
                 strict_min_enabled: Optional[bool] = None):
        """
        :param str max_value: The maximum column statistic value allowed for a row to pass this validation.
               At least one of minValue and maxValue need to be provided.
        :param str min_value: The minimum column statistic value allowed for a row to pass this validation.
               At least one of minValue and maxValue need to be provided.
        :param str statistic: column statistics.
               Possible values are: `STATISTIC_UNDEFINED`, `MEAN`, `MIN`, `MAX`.
        :param bool strict_max_enabled: Whether column statistic needs to be strictly lesser than ('<') the maximum, or if equality is allowed.
               Only relevant if a maxValue has been defined. Default = false.
        :param bool strict_min_enabled: Whether column statistic needs to be strictly greater than ('>') the minimum, or if equality is allowed.
               Only relevant if a minValue has been defined. Default = false.
        """
        if max_value is not None:
            pulumi.set(__self__, "max_value", max_value)
        if min_value is not None:
            pulumi.set(__self__, "min_value", min_value)
        if statistic is not None:
            pulumi.set(__self__, "statistic", statistic)
        if strict_max_enabled is not None:
            pulumi.set(__self__, "strict_max_enabled", strict_max_enabled)
        if strict_min_enabled is not None:
            pulumi.set(__self__, "strict_min_enabled", strict_min_enabled)

    @property
    @pulumi.getter(name="maxValue")
    def max_value(self) -> Optional[str]:
        """
        The maximum column statistic value allowed for a row to pass this validation.
        At least one of minValue and maxValue need to be provided.
        """
        return pulumi.get(self, "max_value")

    @property
    @pulumi.getter(name="minValue")
    def min_value(self) -> Optional[str]:
        """
        The minimum column statistic value allowed for a row to pass this validation.
        At least one of minValue and maxValue need to be provided.
        """
        return pulumi.get(self, "min_value")

    @property
    @pulumi.getter
    def statistic(self) -> Optional[str]:
        """
        column statistics.
        Possible values are: `STATISTIC_UNDEFINED`, `MEAN`, `MIN`, `MAX`.
        """
        return pulumi.get(self, "statistic")

    @property
    @pulumi.getter(name="strictMaxEnabled")
    def strict_max_enabled(self) -> Optional[bool]:
        """
        Whether column statistic needs to be strictly lesser than ('<') the maximum, or if equality is allowed.
        Only relevant if a maxValue has been defined. Default = false.
        """
        return pulumi.get(self, "strict_max_enabled")

    @property
    @pulumi.getter(name="strictMinEnabled")
    def strict_min_enabled(self) -> Optional[bool]:
        """
        Whether column statistic needs to be strictly greater than ('>') the minimum, or if equality is allowed.
        Only relevant if a minValue has been defined. Default = false.
        """
        return pulumi.get(self, "strict_min_enabled")


@pulumi.output_type
class DatascanDataQualityResultRuleRuleTableConditionExpectation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sqlExpression":
            suggest = "sql_expression"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatascanDataQualityResultRuleRuleTableConditionExpectation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatascanDataQualityResultRuleRuleTableConditionExpectation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatascanDataQualityResultRuleRuleTableConditionExpectation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sql_expression: Optional[str] = None):
        """
        :param str sql_expression: The SQL expression.
        """
        if sql_expression is not None:
            pulumi.set(__self__, "sql_expression", sql_expression)

    @property
    @pulumi.getter(name="sqlExpression")
    def sql_expression(self) -> Optional[str]:
        """
        The SQL expression.
        """
        return pulumi.get(self, "sql_expression")


@pulumi.output_type
class DatascanDataQualityResultRuleRuleUniquenessExpectation(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class DatascanDataQualityResultScannedData(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "incrementalField":
            suggest = "incremental_field"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatascanDataQualityResultScannedData. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatascanDataQualityResultScannedData.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatascanDataQualityResultScannedData.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 incremental_field: Optional['outputs.DatascanDataQualityResultScannedDataIncrementalField'] = None):
        """
        :param 'DatascanDataQualityResultScannedDataIncrementalFieldArgs' incremental_field: The range denoted by values of an incremental field
               Structure is documented below.
        """
        if incremental_field is not None:
            pulumi.set(__self__, "incremental_field", incremental_field)

    @property
    @pulumi.getter(name="incrementalField")
    def incremental_field(self) -> Optional['outputs.DatascanDataQualityResultScannedDataIncrementalField']:
        """
        The range denoted by values of an incremental field
        Structure is documented below.
        """
        return pulumi.get(self, "incremental_field")


@pulumi.output_type
class DatascanDataQualityResultScannedDataIncrementalField(dict):
    def __init__(__self__, *,
                 end: Optional[str] = None,
                 field: Optional[str] = None,
                 start: Optional[str] = None):
        """
        :param str end: Value that marks the end of the range.
        :param str field: The unnested field (of type Date or Timestamp) that contains values which monotonically increase over time. If not specified, a data scan will run for all data in the table.
        :param str start: Value that marks the start of the range.
        """
        if end is not None:
            pulumi.set(__self__, "end", end)
        if field is not None:
            pulumi.set(__self__, "field", field)
        if start is not None:
            pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter
    def end(self) -> Optional[str]:
        """
        Value that marks the end of the range.
        """
        return pulumi.get(self, "end")

    @property
    @pulumi.getter
    def field(self) -> Optional[str]:
        """
        The unnested field (of type Date or Timestamp) that contains values which monotonically increase over time. If not specified, a data scan will run for all data in the table.
        """
        return pulumi.get(self, "field")

    @property
    @pulumi.getter
    def start(self) -> Optional[str]:
        """
        Value that marks the start of the range.
        """
        return pulumi.get(self, "start")


@pulumi.output_type
class DatascanDataQualitySpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rowFilter":
            suggest = "row_filter"
        elif key == "samplingPercent":
            suggest = "sampling_percent"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatascanDataQualitySpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatascanDataQualitySpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatascanDataQualitySpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 row_filter: Optional[str] = None,
                 rules: Optional[Sequence['outputs.DatascanDataQualitySpecRule']] = None,
                 sampling_percent: Optional[float] = None):
        """
        :param str row_filter: A filter applied to all rows in a single DataScan job. The filter needs to be a valid SQL expression for a WHERE clause in BigQuery standard SQL syntax. Example: col1 >= 0 AND col2 < 10
        :param Sequence['DatascanDataQualitySpecRuleArgs'] rules: The list of rules to evaluate against a data source. At least one rule is required.
               Structure is documented below.
        :param float sampling_percent: The percentage of the records to be selected from the dataset for DataScan.
        """
        if row_filter is not None:
            pulumi.set(__self__, "row_filter", row_filter)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if sampling_percent is not None:
            pulumi.set(__self__, "sampling_percent", sampling_percent)

    @property
    @pulumi.getter(name="rowFilter")
    def row_filter(self) -> Optional[str]:
        """
        A filter applied to all rows in a single DataScan job. The filter needs to be a valid SQL expression for a WHERE clause in BigQuery standard SQL syntax. Example: col1 >= 0 AND col2 < 10
        """
        return pulumi.get(self, "row_filter")

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.DatascanDataQualitySpecRule']]:
        """
        The list of rules to evaluate against a data source. At least one rule is required.
        Structure is documented below.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter(name="samplingPercent")
    def sampling_percent(self) -> Optional[float]:
        """
        The percentage of the records to be selected from the dataset for DataScan.
        """
        return pulumi.get(self, "sampling_percent")


@pulumi.output_type
class DatascanDataQualitySpecRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ignoreNull":
            suggest = "ignore_null"
        elif key == "nonNullExpectation":
            suggest = "non_null_expectation"
        elif key == "rangeExpectation":
            suggest = "range_expectation"
        elif key == "regexExpectation":
            suggest = "regex_expectation"
        elif key == "rowConditionExpectation":
            suggest = "row_condition_expectation"
        elif key == "setExpectation":
            suggest = "set_expectation"
        elif key == "statisticRangeExpectation":
            suggest = "statistic_range_expectation"
        elif key == "tableConditionExpectation":
            suggest = "table_condition_expectation"
        elif key == "uniquenessExpectation":
            suggest = "uniqueness_expectation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatascanDataQualitySpecRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatascanDataQualitySpecRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatascanDataQualitySpecRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dimension: str,
                 column: Optional[str] = None,
                 ignore_null: Optional[bool] = None,
                 non_null_expectation: Optional['outputs.DatascanDataQualitySpecRuleNonNullExpectation'] = None,
                 range_expectation: Optional['outputs.DatascanDataQualitySpecRuleRangeExpectation'] = None,
                 regex_expectation: Optional['outputs.DatascanDataQualitySpecRuleRegexExpectation'] = None,
                 row_condition_expectation: Optional['outputs.DatascanDataQualitySpecRuleRowConditionExpectation'] = None,
                 set_expectation: Optional['outputs.DatascanDataQualitySpecRuleSetExpectation'] = None,
                 statistic_range_expectation: Optional['outputs.DatascanDataQualitySpecRuleStatisticRangeExpectation'] = None,
                 table_condition_expectation: Optional['outputs.DatascanDataQualitySpecRuleTableConditionExpectation'] = None,
                 threshold: Optional[float] = None,
                 uniqueness_expectation: Optional['outputs.DatascanDataQualitySpecRuleUniquenessExpectation'] = None):
        """
        :param str dimension: The dimension a rule belongs to. Results are also aggregated at the dimension level. Supported dimensions are ["COMPLETENESS", "ACCURACY", "CONSISTENCY", "VALIDITY", "UNIQUENESS", "INTEGRITY"]
        :param str column: The unnested column which this rule is evaluated against.
        :param bool ignore_null: Rows with null values will automatically fail a rule, unless ignoreNull is true. In that case, such null rows are trivially considered passing. Only applicable to ColumnMap rules.
        :param 'DatascanDataQualitySpecRuleNonNullExpectationArgs' non_null_expectation: ColumnMap rule which evaluates whether each column value is null.
        :param 'DatascanDataQualitySpecRuleRangeExpectationArgs' range_expectation: ColumnMap rule which evaluates whether each column value lies between a specified range.
               Structure is documented below.
        :param 'DatascanDataQualitySpecRuleRegexExpectationArgs' regex_expectation: ColumnMap rule which evaluates whether each column value matches a specified regex.
               Structure is documented below.
        :param 'DatascanDataQualitySpecRuleRowConditionExpectationArgs' row_condition_expectation: Table rule which evaluates whether each row passes the specified condition.
               Structure is documented below.
        :param 'DatascanDataQualitySpecRuleSetExpectationArgs' set_expectation: ColumnMap rule which evaluates whether each column value is contained by a specified set.
               Structure is documented below.
        :param 'DatascanDataQualitySpecRuleStatisticRangeExpectationArgs' statistic_range_expectation: ColumnAggregate rule which evaluates whether the column aggregate statistic lies between a specified range.
               Structure is documented below.
        :param 'DatascanDataQualitySpecRuleTableConditionExpectationArgs' table_condition_expectation: Table rule which evaluates whether the provided expression is true.
               Structure is documented below.
        :param float threshold: The minimum ratio of passing_rows / total_rows required to pass this rule, with a range of [0.0, 1.0]. 0 indicates default value (i.e. 1.0).
        :param 'DatascanDataQualitySpecRuleUniquenessExpectationArgs' uniqueness_expectation: ColumnAggregate rule which evaluates whether the column has duplicates.
        """
        pulumi.set(__self__, "dimension", dimension)
        if column is not None:
            pulumi.set(__self__, "column", column)
        if ignore_null is not None:
            pulumi.set(__self__, "ignore_null", ignore_null)
        if non_null_expectation is not None:
            pulumi.set(__self__, "non_null_expectation", non_null_expectation)
        if range_expectation is not None:
            pulumi.set(__self__, "range_expectation", range_expectation)
        if regex_expectation is not None:
            pulumi.set(__self__, "regex_expectation", regex_expectation)
        if row_condition_expectation is not None:
            pulumi.set(__self__, "row_condition_expectation", row_condition_expectation)
        if set_expectation is not None:
            pulumi.set(__self__, "set_expectation", set_expectation)
        if statistic_range_expectation is not None:
            pulumi.set(__self__, "statistic_range_expectation", statistic_range_expectation)
        if table_condition_expectation is not None:
            pulumi.set(__self__, "table_condition_expectation", table_condition_expectation)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)
        if uniqueness_expectation is not None:
            pulumi.set(__self__, "uniqueness_expectation", uniqueness_expectation)

    @property
    @pulumi.getter
    def dimension(self) -> str:
        """
        The dimension a rule belongs to. Results are also aggregated at the dimension level. Supported dimensions are ["COMPLETENESS", "ACCURACY", "CONSISTENCY", "VALIDITY", "UNIQUENESS", "INTEGRITY"]
        """
        return pulumi.get(self, "dimension")

    @property
    @pulumi.getter
    def column(self) -> Optional[str]:
        """
        The unnested column which this rule is evaluated against.
        """
        return pulumi.get(self, "column")

    @property
    @pulumi.getter(name="ignoreNull")
    def ignore_null(self) -> Optional[bool]:
        """
        Rows with null values will automatically fail a rule, unless ignoreNull is true. In that case, such null rows are trivially considered passing. Only applicable to ColumnMap rules.
        """
        return pulumi.get(self, "ignore_null")

    @property
    @pulumi.getter(name="nonNullExpectation")
    def non_null_expectation(self) -> Optional['outputs.DatascanDataQualitySpecRuleNonNullExpectation']:
        """
        ColumnMap rule which evaluates whether each column value is null.
        """
        return pulumi.get(self, "non_null_expectation")

    @property
    @pulumi.getter(name="rangeExpectation")
    def range_expectation(self) -> Optional['outputs.DatascanDataQualitySpecRuleRangeExpectation']:
        """
        ColumnMap rule which evaluates whether each column value lies between a specified range.
        Structure is documented below.
        """
        return pulumi.get(self, "range_expectation")

    @property
    @pulumi.getter(name="regexExpectation")
    def regex_expectation(self) -> Optional['outputs.DatascanDataQualitySpecRuleRegexExpectation']:
        """
        ColumnMap rule which evaluates whether each column value matches a specified regex.
        Structure is documented below.
        """
        return pulumi.get(self, "regex_expectation")

    @property
    @pulumi.getter(name="rowConditionExpectation")
    def row_condition_expectation(self) -> Optional['outputs.DatascanDataQualitySpecRuleRowConditionExpectation']:
        """
        Table rule which evaluates whether each row passes the specified condition.
        Structure is documented below.
        """
        return pulumi.get(self, "row_condition_expectation")

    @property
    @pulumi.getter(name="setExpectation")
    def set_expectation(self) -> Optional['outputs.DatascanDataQualitySpecRuleSetExpectation']:
        """
        ColumnMap rule which evaluates whether each column value is contained by a specified set.
        Structure is documented below.
        """
        return pulumi.get(self, "set_expectation")

    @property
    @pulumi.getter(name="statisticRangeExpectation")
    def statistic_range_expectation(self) -> Optional['outputs.DatascanDataQualitySpecRuleStatisticRangeExpectation']:
        """
        ColumnAggregate rule which evaluates whether the column aggregate statistic lies between a specified range.
        Structure is documented below.
        """
        return pulumi.get(self, "statistic_range_expectation")

    @property
    @pulumi.getter(name="tableConditionExpectation")
    def table_condition_expectation(self) -> Optional['outputs.DatascanDataQualitySpecRuleTableConditionExpectation']:
        """
        Table rule which evaluates whether the provided expression is true.
        Structure is documented below.
        """
        return pulumi.get(self, "table_condition_expectation")

    @property
    @pulumi.getter
    def threshold(self) -> Optional[float]:
        """
        The minimum ratio of passing_rows / total_rows required to pass this rule, with a range of [0.0, 1.0]. 0 indicates default value (i.e. 1.0).
        """
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter(name="uniquenessExpectation")
    def uniqueness_expectation(self) -> Optional['outputs.DatascanDataQualitySpecRuleUniquenessExpectation']:
        """
        ColumnAggregate rule which evaluates whether the column has duplicates.
        """
        return pulumi.get(self, "uniqueness_expectation")


@pulumi.output_type
class DatascanDataQualitySpecRuleNonNullExpectation(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class DatascanDataQualitySpecRuleRangeExpectation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxValue":
            suggest = "max_value"
        elif key == "minValue":
            suggest = "min_value"
        elif key == "strictMaxEnabled":
            suggest = "strict_max_enabled"
        elif key == "strictMinEnabled":
            suggest = "strict_min_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatascanDataQualitySpecRuleRangeExpectation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatascanDataQualitySpecRuleRangeExpectation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatascanDataQualitySpecRuleRangeExpectation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_value: Optional[str] = None,
                 min_value: Optional[str] = None,
                 strict_max_enabled: Optional[bool] = None,
                 strict_min_enabled: Optional[bool] = None):
        """
        :param str max_value: The maximum column value allowed for a row to pass this validation. At least one of minValue and maxValue need to be provided.
        :param str min_value: The minimum column value allowed for a row to pass this validation. At least one of minValue and maxValue need to be provided.
        :param bool strict_max_enabled: Whether each value needs to be strictly lesser than ('<') the maximum, or if equality is allowed.
               Only relevant if a maxValue has been defined. Default = false.
        :param bool strict_min_enabled: Whether each value needs to be strictly greater than ('>') the minimum, or if equality is allowed.
               Only relevant if a minValue has been defined. Default = false.
        """
        if max_value is not None:
            pulumi.set(__self__, "max_value", max_value)
        if min_value is not None:
            pulumi.set(__self__, "min_value", min_value)
        if strict_max_enabled is not None:
            pulumi.set(__self__, "strict_max_enabled", strict_max_enabled)
        if strict_min_enabled is not None:
            pulumi.set(__self__, "strict_min_enabled", strict_min_enabled)

    @property
    @pulumi.getter(name="maxValue")
    def max_value(self) -> Optional[str]:
        """
        The maximum column value allowed for a row to pass this validation. At least one of minValue and maxValue need to be provided.
        """
        return pulumi.get(self, "max_value")

    @property
    @pulumi.getter(name="minValue")
    def min_value(self) -> Optional[str]:
        """
        The minimum column value allowed for a row to pass this validation. At least one of minValue and maxValue need to be provided.
        """
        return pulumi.get(self, "min_value")

    @property
    @pulumi.getter(name="strictMaxEnabled")
    def strict_max_enabled(self) -> Optional[bool]:
        """
        Whether each value needs to be strictly lesser than ('<') the maximum, or if equality is allowed.
        Only relevant if a maxValue has been defined. Default = false.
        """
        return pulumi.get(self, "strict_max_enabled")

    @property
    @pulumi.getter(name="strictMinEnabled")
    def strict_min_enabled(self) -> Optional[bool]:
        """
        Whether each value needs to be strictly greater than ('>') the minimum, or if equality is allowed.
        Only relevant if a minValue has been defined. Default = false.
        """
        return pulumi.get(self, "strict_min_enabled")


@pulumi.output_type
class DatascanDataQualitySpecRuleRegexExpectation(dict):
    def __init__(__self__, *,
                 regex: str):
        """
        :param str regex: A regular expression the column value is expected to match.
        """
        pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def regex(self) -> str:
        """
        A regular expression the column value is expected to match.
        """
        return pulumi.get(self, "regex")


@pulumi.output_type
class DatascanDataQualitySpecRuleRowConditionExpectation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sqlExpression":
            suggest = "sql_expression"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatascanDataQualitySpecRuleRowConditionExpectation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatascanDataQualitySpecRuleRowConditionExpectation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatascanDataQualitySpecRuleRowConditionExpectation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sql_expression: str):
        """
        :param str sql_expression: The SQL expression.
        """
        pulumi.set(__self__, "sql_expression", sql_expression)

    @property
    @pulumi.getter(name="sqlExpression")
    def sql_expression(self) -> str:
        """
        The SQL expression.
        """
        return pulumi.get(self, "sql_expression")


@pulumi.output_type
class DatascanDataQualitySpecRuleSetExpectation(dict):
    def __init__(__self__, *,
                 values: Sequence[str]):
        """
        :param Sequence[str] values: Expected values for the column value.
        """
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Expected values for the column value.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class DatascanDataQualitySpecRuleStatisticRangeExpectation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxValue":
            suggest = "max_value"
        elif key == "minValue":
            suggest = "min_value"
        elif key == "strictMaxEnabled":
            suggest = "strict_max_enabled"
        elif key == "strictMinEnabled":
            suggest = "strict_min_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatascanDataQualitySpecRuleStatisticRangeExpectation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatascanDataQualitySpecRuleStatisticRangeExpectation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatascanDataQualitySpecRuleStatisticRangeExpectation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 statistic: str,
                 max_value: Optional[str] = None,
                 min_value: Optional[str] = None,
                 strict_max_enabled: Optional[bool] = None,
                 strict_min_enabled: Optional[bool] = None):
        """
        :param str statistic: column statistics.
               Possible values are: `STATISTIC_UNDEFINED`, `MEAN`, `MIN`, `MAX`.
        :param str max_value: The maximum column statistic value allowed for a row to pass this validation.
               At least one of minValue and maxValue need to be provided.
        :param str min_value: The minimum column statistic value allowed for a row to pass this validation.
               At least one of minValue and maxValue need to be provided.
        :param bool strict_max_enabled: Whether column statistic needs to be strictly lesser than ('<') the maximum, or if equality is allowed.
               Only relevant if a maxValue has been defined. Default = false.
        :param bool strict_min_enabled: Whether column statistic needs to be strictly greater than ('>') the minimum, or if equality is allowed.
               Only relevant if a minValue has been defined. Default = false.
        """
        pulumi.set(__self__, "statistic", statistic)
        if max_value is not None:
            pulumi.set(__self__, "max_value", max_value)
        if min_value is not None:
            pulumi.set(__self__, "min_value", min_value)
        if strict_max_enabled is not None:
            pulumi.set(__self__, "strict_max_enabled", strict_max_enabled)
        if strict_min_enabled is not None:
            pulumi.set(__self__, "strict_min_enabled", strict_min_enabled)

    @property
    @pulumi.getter
    def statistic(self) -> str:
        """
        column statistics.
        Possible values are: `STATISTIC_UNDEFINED`, `MEAN`, `MIN`, `MAX`.
        """
        return pulumi.get(self, "statistic")

    @property
    @pulumi.getter(name="maxValue")
    def max_value(self) -> Optional[str]:
        """
        The maximum column statistic value allowed for a row to pass this validation.
        At least one of minValue and maxValue need to be provided.
        """
        return pulumi.get(self, "max_value")

    @property
    @pulumi.getter(name="minValue")
    def min_value(self) -> Optional[str]:
        """
        The minimum column statistic value allowed for a row to pass this validation.
        At least one of minValue and maxValue need to be provided.
        """
        return pulumi.get(self, "min_value")

    @property
    @pulumi.getter(name="strictMaxEnabled")
    def strict_max_enabled(self) -> Optional[bool]:
        """
        Whether column statistic needs to be strictly lesser than ('<') the maximum, or if equality is allowed.
        Only relevant if a maxValue has been defined. Default = false.
        """
        return pulumi.get(self, "strict_max_enabled")

    @property
    @pulumi.getter(name="strictMinEnabled")
    def strict_min_enabled(self) -> Optional[bool]:
        """
        Whether column statistic needs to be strictly greater than ('>') the minimum, or if equality is allowed.
        Only relevant if a minValue has been defined. Default = false.
        """
        return pulumi.get(self, "strict_min_enabled")


@pulumi.output_type
class DatascanDataQualitySpecRuleTableConditionExpectation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sqlExpression":
            suggest = "sql_expression"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatascanDataQualitySpecRuleTableConditionExpectation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatascanDataQualitySpecRuleTableConditionExpectation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatascanDataQualitySpecRuleTableConditionExpectation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sql_expression: str):
        """
        :param str sql_expression: The SQL expression.
        """
        pulumi.set(__self__, "sql_expression", sql_expression)

    @property
    @pulumi.getter(name="sqlExpression")
    def sql_expression(self) -> str:
        """
        The SQL expression.
        """
        return pulumi.get(self, "sql_expression")


@pulumi.output_type
class DatascanDataQualitySpecRuleUniquenessExpectation(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class DatascanExecutionSpec(dict):
    def __init__(__self__, *,
                 trigger: 'outputs.DatascanExecutionSpecTrigger',
                 field: Optional[str] = None):
        """
        :param 'DatascanExecutionSpecTriggerArgs' trigger: Spec related to how often and when a scan should be triggered.
               Structure is documented below.
        :param str field: The unnested field (of type Date or Timestamp) that contains values which monotonically increase over time. If not specified, a data scan will run for all data in the table.
        """
        pulumi.set(__self__, "trigger", trigger)
        if field is not None:
            pulumi.set(__self__, "field", field)

    @property
    @pulumi.getter
    def trigger(self) -> 'outputs.DatascanExecutionSpecTrigger':
        """
        Spec related to how often and when a scan should be triggered.
        Structure is documented below.
        """
        return pulumi.get(self, "trigger")

    @property
    @pulumi.getter
    def field(self) -> Optional[str]:
        """
        The unnested field (of type Date or Timestamp) that contains values which monotonically increase over time. If not specified, a data scan will run for all data in the table.
        """
        return pulumi.get(self, "field")


@pulumi.output_type
class DatascanExecutionSpecTrigger(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "onDemand":
            suggest = "on_demand"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatascanExecutionSpecTrigger. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatascanExecutionSpecTrigger.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatascanExecutionSpecTrigger.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 on_demand: Optional['outputs.DatascanExecutionSpecTriggerOnDemand'] = None,
                 schedule: Optional['outputs.DatascanExecutionSpecTriggerSchedule'] = None):
        """
        :param 'DatascanExecutionSpecTriggerOnDemandArgs' on_demand: The scan runs once via dataScans.run API.
        :param 'DatascanExecutionSpecTriggerScheduleArgs' schedule: The scan is scheduled to run periodically.
               Structure is documented below.
        """
        if on_demand is not None:
            pulumi.set(__self__, "on_demand", on_demand)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)

    @property
    @pulumi.getter(name="onDemand")
    def on_demand(self) -> Optional['outputs.DatascanExecutionSpecTriggerOnDemand']:
        """
        The scan runs once via dataScans.run API.
        """
        return pulumi.get(self, "on_demand")

    @property
    @pulumi.getter
    def schedule(self) -> Optional['outputs.DatascanExecutionSpecTriggerSchedule']:
        """
        The scan is scheduled to run periodically.
        Structure is documented below.
        """
        return pulumi.get(self, "schedule")


@pulumi.output_type
class DatascanExecutionSpecTriggerOnDemand(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class DatascanExecutionSpecTriggerSchedule(dict):
    def __init__(__self__, *,
                 cron: str):
        """
        :param str cron: Cron schedule for running scans periodically. This field is required for Schedule scans.
               
               - - -
        """
        pulumi.set(__self__, "cron", cron)

    @property
    @pulumi.getter
    def cron(self) -> str:
        """
        Cron schedule for running scans periodically. This field is required for Schedule scans.

        - - -
        """
        return pulumi.get(self, "cron")


@pulumi.output_type
class DatascanExecutionStatus(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "latestJobEndTime":
            suggest = "latest_job_end_time"
        elif key == "latestJobStartTime":
            suggest = "latest_job_start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatascanExecutionStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatascanExecutionStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatascanExecutionStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 latest_job_end_time: Optional[str] = None,
                 latest_job_start_time: Optional[str] = None):
        """
        :param str latest_job_end_time: (Output)
               The time when the latest DataScanJob started.
        :param str latest_job_start_time: (Output)
               The time when the latest DataScanJob ended.
        """
        if latest_job_end_time is not None:
            pulumi.set(__self__, "latest_job_end_time", latest_job_end_time)
        if latest_job_start_time is not None:
            pulumi.set(__self__, "latest_job_start_time", latest_job_start_time)

    @property
    @pulumi.getter(name="latestJobEndTime")
    def latest_job_end_time(self) -> Optional[str]:
        """
        (Output)
        The time when the latest DataScanJob started.
        """
        return pulumi.get(self, "latest_job_end_time")

    @property
    @pulumi.getter(name="latestJobStartTime")
    def latest_job_start_time(self) -> Optional[str]:
        """
        (Output)
        The time when the latest DataScanJob ended.
        """
        return pulumi.get(self, "latest_job_start_time")


@pulumi.output_type
class DatascanIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class DatascanIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class LakeAssetStatus(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activeAssets":
            suggest = "active_assets"
        elif key == "securityPolicyApplyingAssets":
            suggest = "security_policy_applying_assets"
        elif key == "updateTime":
            suggest = "update_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LakeAssetStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LakeAssetStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LakeAssetStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 active_assets: Optional[int] = None,
                 security_policy_applying_assets: Optional[int] = None,
                 update_time: Optional[str] = None):
        """
        :param str update_time: Output only. The time when the lake was last updated.
        """
        if active_assets is not None:
            pulumi.set(__self__, "active_assets", active_assets)
        if security_policy_applying_assets is not None:
            pulumi.set(__self__, "security_policy_applying_assets", security_policy_applying_assets)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="activeAssets")
    def active_assets(self) -> Optional[int]:
        return pulumi.get(self, "active_assets")

    @property
    @pulumi.getter(name="securityPolicyApplyingAssets")
    def security_policy_applying_assets(self) -> Optional[int]:
        return pulumi.get(self, "security_policy_applying_assets")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[str]:
        """
        Output only. The time when the lake was last updated.
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class LakeIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class LakeIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class LakeMetastore(dict):
    def __init__(__self__, *,
                 service: Optional[str] = None):
        """
        :param str service: Optional. A relative reference to the Dataproc Metastore (https://cloud.google.com/dataproc-metastore/docs) service associated with the lake: `projects/{project_id}/locations/{location_id}/services/{service_id}`
        """
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter
    def service(self) -> Optional[str]:
        """
        Optional. A relative reference to the Dataproc Metastore (https://cloud.google.com/dataproc-metastore/docs) service associated with the lake: `projects/{project_id}/locations/{location_id}/services/{service_id}`
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class LakeMetastoreStatus(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "updateTime":
            suggest = "update_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LakeMetastoreStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LakeMetastoreStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LakeMetastoreStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint: Optional[str] = None,
                 message: Optional[str] = None,
                 state: Optional[str] = None,
                 update_time: Optional[str] = None):
        """
        :param str state: Output only. Current state of the lake. Possible values: STATE_UNSPECIFIED, ACTIVE, CREATING, DELETING, ACTION_REQUIRED
        :param str update_time: Output only. The time when the lake was last updated.
        """
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[str]:
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        Output only. Current state of the lake. Possible values: STATE_UNSPECIFIED, ACTIVE, CREATING, DELETING, ACTION_REQUIRED
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[str]:
        """
        Output only. The time when the lake was last updated.
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class ZoneAssetStatus(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activeAssets":
            suggest = "active_assets"
        elif key == "securityPolicyApplyingAssets":
            suggest = "security_policy_applying_assets"
        elif key == "updateTime":
            suggest = "update_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ZoneAssetStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ZoneAssetStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ZoneAssetStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 active_assets: Optional[int] = None,
                 security_policy_applying_assets: Optional[int] = None,
                 update_time: Optional[str] = None):
        """
        :param str update_time: Output only. The time when the zone was last updated.
        """
        if active_assets is not None:
            pulumi.set(__self__, "active_assets", active_assets)
        if security_policy_applying_assets is not None:
            pulumi.set(__self__, "security_policy_applying_assets", security_policy_applying_assets)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="activeAssets")
    def active_assets(self) -> Optional[int]:
        return pulumi.get(self, "active_assets")

    @property
    @pulumi.getter(name="securityPolicyApplyingAssets")
    def security_policy_applying_assets(self) -> Optional[int]:
        return pulumi.get(self, "security_policy_applying_assets")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[str]:
        """
        Output only. The time when the zone was last updated.
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class ZoneDiscoverySpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "csvOptions":
            suggest = "csv_options"
        elif key == "excludePatterns":
            suggest = "exclude_patterns"
        elif key == "includePatterns":
            suggest = "include_patterns"
        elif key == "jsonOptions":
            suggest = "json_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ZoneDiscoverySpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ZoneDiscoverySpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ZoneDiscoverySpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 csv_options: Optional['outputs.ZoneDiscoverySpecCsvOptions'] = None,
                 exclude_patterns: Optional[Sequence[str]] = None,
                 include_patterns: Optional[Sequence[str]] = None,
                 json_options: Optional['outputs.ZoneDiscoverySpecJsonOptions'] = None,
                 schedule: Optional[str] = None):
        """
        :param bool enabled: Required. Whether discovery is enabled.
        :param 'ZoneDiscoverySpecCsvOptionsArgs' csv_options: Optional. Configuration for CSV data.
        :param Sequence[str] exclude_patterns: Optional. The list of patterns to apply for selecting data to exclude during discovery. For Cloud Storage bucket assets, these are interpreted as glob patterns used to match object names. For BigQuery dataset assets, these are interpreted as patterns to match table names.
        :param Sequence[str] include_patterns: Optional. The list of patterns to apply for selecting data to include during discovery if only a subset of the data should considered. For Cloud Storage bucket assets, these are interpreted as glob patterns used to match object names. For BigQuery dataset assets, these are interpreted as patterns to match table names.
        :param 'ZoneDiscoverySpecJsonOptionsArgs' json_options: Optional. Configuration for Json data.
        :param str schedule: Optional. Cron schedule (https://en.wikipedia.org/wiki/Cron) for running discovery periodically. Successive discovery runs must be scheduled at least 60 minutes apart. The default value is to run discovery every 60 minutes. To explicitly set a timezone to the cron tab, apply a prefix in the cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or TZ=${IANA_TIME_ZONE}". The ${IANA_TIME_ZONE} may only be a valid string from IANA time zone database. For example, "CRON_TZ=America/New_York 1 * * * *", or "TZ=America/New_York 1 * * * *".
        """
        pulumi.set(__self__, "enabled", enabled)
        if csv_options is not None:
            pulumi.set(__self__, "csv_options", csv_options)
        if exclude_patterns is not None:
            pulumi.set(__self__, "exclude_patterns", exclude_patterns)
        if include_patterns is not None:
            pulumi.set(__self__, "include_patterns", include_patterns)
        if json_options is not None:
            pulumi.set(__self__, "json_options", json_options)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Required. Whether discovery is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="csvOptions")
    def csv_options(self) -> Optional['outputs.ZoneDiscoverySpecCsvOptions']:
        """
        Optional. Configuration for CSV data.
        """
        return pulumi.get(self, "csv_options")

    @property
    @pulumi.getter(name="excludePatterns")
    def exclude_patterns(self) -> Optional[Sequence[str]]:
        """
        Optional. The list of patterns to apply for selecting data to exclude during discovery. For Cloud Storage bucket assets, these are interpreted as glob patterns used to match object names. For BigQuery dataset assets, these are interpreted as patterns to match table names.
        """
        return pulumi.get(self, "exclude_patterns")

    @property
    @pulumi.getter(name="includePatterns")
    def include_patterns(self) -> Optional[Sequence[str]]:
        """
        Optional. The list of patterns to apply for selecting data to include during discovery if only a subset of the data should considered. For Cloud Storage bucket assets, these are interpreted as glob patterns used to match object names. For BigQuery dataset assets, these are interpreted as patterns to match table names.
        """
        return pulumi.get(self, "include_patterns")

    @property
    @pulumi.getter(name="jsonOptions")
    def json_options(self) -> Optional['outputs.ZoneDiscoverySpecJsonOptions']:
        """
        Optional. Configuration for Json data.
        """
        return pulumi.get(self, "json_options")

    @property
    @pulumi.getter
    def schedule(self) -> Optional[str]:
        """
        Optional. Cron schedule (https://en.wikipedia.org/wiki/Cron) for running discovery periodically. Successive discovery runs must be scheduled at least 60 minutes apart. The default value is to run discovery every 60 minutes. To explicitly set a timezone to the cron tab, apply a prefix in the cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or TZ=${IANA_TIME_ZONE}". The ${IANA_TIME_ZONE} may only be a valid string from IANA time zone database. For example, "CRON_TZ=America/New_York 1 * * * *", or "TZ=America/New_York 1 * * * *".
        """
        return pulumi.get(self, "schedule")


@pulumi.output_type
class ZoneDiscoverySpecCsvOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disableTypeInference":
            suggest = "disable_type_inference"
        elif key == "headerRows":
            suggest = "header_rows"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ZoneDiscoverySpecCsvOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ZoneDiscoverySpecCsvOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ZoneDiscoverySpecCsvOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delimiter: Optional[str] = None,
                 disable_type_inference: Optional[bool] = None,
                 encoding: Optional[str] = None,
                 header_rows: Optional[int] = None):
        """
        :param str delimiter: Optional. The delimiter being used to separate values. This defaults to ','.
        :param bool disable_type_inference: Optional. Whether to disable the inference of data type for CSV data. If true, all columns will be registered as strings.
        :param str encoding: Optional. The character encoding of the data. The default is UTF-8.
        :param int header_rows: Optional. The number of rows to interpret as header rows that should be skipped when reading data rows.
        """
        if delimiter is not None:
            pulumi.set(__self__, "delimiter", delimiter)
        if disable_type_inference is not None:
            pulumi.set(__self__, "disable_type_inference", disable_type_inference)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if header_rows is not None:
            pulumi.set(__self__, "header_rows", header_rows)

    @property
    @pulumi.getter
    def delimiter(self) -> Optional[str]:
        """
        Optional. The delimiter being used to separate values. This defaults to ','.
        """
        return pulumi.get(self, "delimiter")

    @property
    @pulumi.getter(name="disableTypeInference")
    def disable_type_inference(self) -> Optional[bool]:
        """
        Optional. Whether to disable the inference of data type for CSV data. If true, all columns will be registered as strings.
        """
        return pulumi.get(self, "disable_type_inference")

    @property
    @pulumi.getter
    def encoding(self) -> Optional[str]:
        """
        Optional. The character encoding of the data. The default is UTF-8.
        """
        return pulumi.get(self, "encoding")

    @property
    @pulumi.getter(name="headerRows")
    def header_rows(self) -> Optional[int]:
        """
        Optional. The number of rows to interpret as header rows that should be skipped when reading data rows.
        """
        return pulumi.get(self, "header_rows")


@pulumi.output_type
class ZoneDiscoverySpecJsonOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disableTypeInference":
            suggest = "disable_type_inference"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ZoneDiscoverySpecJsonOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ZoneDiscoverySpecJsonOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ZoneDiscoverySpecJsonOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disable_type_inference: Optional[bool] = None,
                 encoding: Optional[str] = None):
        """
        :param bool disable_type_inference: Optional. Whether to disable the inference of data type for Json data. If true, all columns will be registered as their primitive types (strings, number or boolean).
        :param str encoding: Optional. The character encoding of the data. The default is UTF-8.
        """
        if disable_type_inference is not None:
            pulumi.set(__self__, "disable_type_inference", disable_type_inference)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)

    @property
    @pulumi.getter(name="disableTypeInference")
    def disable_type_inference(self) -> Optional[bool]:
        """
        Optional. Whether to disable the inference of data type for Json data. If true, all columns will be registered as their primitive types (strings, number or boolean).
        """
        return pulumi.get(self, "disable_type_inference")

    @property
    @pulumi.getter
    def encoding(self) -> Optional[str]:
        """
        Optional. The character encoding of the data. The default is UTF-8.
        """
        return pulumi.get(self, "encoding")


@pulumi.output_type
class ZoneIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class ZoneIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class ZoneResourceSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "locationType":
            suggest = "location_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ZoneResourceSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ZoneResourceSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ZoneResourceSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 location_type: str):
        """
        :param str location_type: Required. Immutable. The location type of the resources that are allowed to be attached to the assets within this zone. Possible values: LOCATION_TYPE_UNSPECIFIED, SINGLE_REGION, MULTI_REGION
               
               - - -
        """
        pulumi.set(__self__, "location_type", location_type)

    @property
    @pulumi.getter(name="locationType")
    def location_type(self) -> str:
        """
        Required. Immutable. The location type of the resources that are allowed to be attached to the assets within this zone. Possible values: LOCATION_TYPE_UNSPECIFIED, SINGLE_REGION, MULTI_REGION

        - - -
        """
        return pulumi.get(self, "location_type")


