# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetAutoscalingPolicyIamPolicyResult',
    'AwaitableGetAutoscalingPolicyIamPolicyResult',
    'get_autoscaling_policy_iam_policy',
    'get_autoscaling_policy_iam_policy_output',
]

@pulumi.output_type
class GetAutoscalingPolicyIamPolicyResult:
    """
    A collection of values returned by getAutoscalingPolicyIamPolicy.
    """
    def __init__(__self__, etag=None, id=None, location=None, policy_data=None, policy_id=None, project=None):
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if policy_data and not isinstance(policy_data, str):
            raise TypeError("Expected argument 'policy_data' to be a str")
        pulumi.set(__self__, "policy_data", policy_data)
        if policy_id and not isinstance(policy_id, str):
            raise TypeError("Expected argument 'policy_id' to be a str")
        pulumi.set(__self__, "policy_id", policy_id)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        (Computed) The etag of the IAM policy.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> str:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> str:
        """
        (Required only by `dataproc.AutoscalingPolicyIamPolicy`) The policy data generated by
        a `organizations_get_iam_policy` data source.
        """
        return pulumi.get(self, "policy_data")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> str:
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter
    def project(self) -> str:
        return pulumi.get(self, "project")


class AwaitableGetAutoscalingPolicyIamPolicyResult(GetAutoscalingPolicyIamPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAutoscalingPolicyIamPolicyResult(
            etag=self.etag,
            id=self.id,
            location=self.location,
            policy_data=self.policy_data,
            policy_id=self.policy_id,
            project=self.project)


def get_autoscaling_policy_iam_policy(location: Optional[str] = None,
                                      policy_id: Optional[str] = None,
                                      project: Optional[str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAutoscalingPolicyIamPolicyResult:
    """
    Retrieves the current IAM policy data for autoscalingpolicy

    ## example

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.dataproc.get_autoscaling_policy_iam_policy(project=google_dataproc_autoscaling_policy["basic"]["project"],
        location=google_dataproc_autoscaling_policy["basic"]["location"],
        policy_id=google_dataproc_autoscaling_policy["basic"]["policy_id"])
    ```


    :param str location: The  location where the autoscaling policy should reside.
           The default value is `global`.
           Used to find the parent resource to bind the IAM policy to
    :param str policy_id: The policy id. The id must contain only letters (a-z, A-Z), numbers (0-9), underscores (_),
           and hyphens (-). Cannot begin or end with underscore or hyphen. Must consist of between
           3 and 50 characters.
           Used to find the parent resource to bind the IAM policy to
    :param str project: The ID of the project in which the resource belongs.
           If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['policyId'] = policy_id
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:dataproc/getAutoscalingPolicyIamPolicy:getAutoscalingPolicyIamPolicy', __args__, opts=opts, typ=GetAutoscalingPolicyIamPolicyResult).value

    return AwaitableGetAutoscalingPolicyIamPolicyResult(
        etag=pulumi.get(__ret__, 'etag'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        policy_data=pulumi.get(__ret__, 'policy_data'),
        policy_id=pulumi.get(__ret__, 'policy_id'),
        project=pulumi.get(__ret__, 'project'))


@_utilities.lift_output_func(get_autoscaling_policy_iam_policy)
def get_autoscaling_policy_iam_policy_output(location: Optional[pulumi.Input[Optional[str]]] = None,
                                             policy_id: Optional[pulumi.Input[str]] = None,
                                             project: Optional[pulumi.Input[Optional[str]]] = None,
                                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAutoscalingPolicyIamPolicyResult]:
    """
    Retrieves the current IAM policy data for autoscalingpolicy

    ## example

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.dataproc.get_autoscaling_policy_iam_policy(project=google_dataproc_autoscaling_policy["basic"]["project"],
        location=google_dataproc_autoscaling_policy["basic"]["location"],
        policy_id=google_dataproc_autoscaling_policy["basic"]["policy_id"])
    ```


    :param str location: The  location where the autoscaling policy should reside.
           The default value is `global`.
           Used to find the parent resource to bind the IAM policy to
    :param str policy_id: The policy id. The id must contain only letters (a-z, A-Z), numbers (0-9), underscores (_),
           and hyphens (-). Cannot begin or end with underscore or hyphen. Must consist of between
           3 and 50 characters.
           Used to find the parent resource to bind the IAM policy to
    :param str project: The ID of the project in which the resource belongs.
           If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
    """
    ...
