# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetJobIamPolicyResult',
    'AwaitableGetJobIamPolicyResult',
    'get_job_iam_policy',
    'get_job_iam_policy_output',
]

@pulumi.output_type
class GetJobIamPolicyResult:
    """
    A collection of values returned by getJobIamPolicy.
    """
    def __init__(__self__, etag=None, id=None, job_id=None, policy_data=None, project=None, region=None):
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if job_id and not isinstance(job_id, str):
            raise TypeError("Expected argument 'job_id' to be a str")
        pulumi.set(__self__, "job_id", job_id)
        if policy_data and not isinstance(policy_data, str):
            raise TypeError("Expected argument 'policy_data' to be a str")
        pulumi.set(__self__, "policy_data", policy_data)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        (Computed) The etag of the IAM policy.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="jobId")
    def job_id(self) -> str:
        return pulumi.get(self, "job_id")

    @property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> str:
        """
        (Computed) The policy data
        """
        return pulumi.get(self, "policy_data")

    @property
    @pulumi.getter
    def project(self) -> str:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")


class AwaitableGetJobIamPolicyResult(GetJobIamPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetJobIamPolicyResult(
            etag=self.etag,
            id=self.id,
            job_id=self.job_id,
            policy_data=self.policy_data,
            project=self.project,
            region=self.region)


def get_job_iam_policy(job_id: Optional[str] = None,
                       project: Optional[str] = None,
                       region: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetJobIamPolicyResult:
    """
    Retrieves the current IAM policy data for a Dataproc job.

    ## example

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.dataproc.get_job_iam_policy(job_id=google_dataproc_job["pyspark"]["reference"][0]["job_id"],
        region="us-central1")
    ```


    :param str job_id: The name or relative resource id of the job to manage IAM policies for.
    """
    __args__ = dict()
    __args__['jobId'] = job_id
    __args__['project'] = project
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:dataproc/getJobIamPolicy:getJobIamPolicy', __args__, opts=opts, typ=GetJobIamPolicyResult).value

    return AwaitableGetJobIamPolicyResult(
        etag=pulumi.get(__ret__, 'etag'),
        id=pulumi.get(__ret__, 'id'),
        job_id=pulumi.get(__ret__, 'job_id'),
        policy_data=pulumi.get(__ret__, 'policy_data'),
        project=pulumi.get(__ret__, 'project'),
        region=pulumi.get(__ret__, 'region'))


@_utilities.lift_output_func(get_job_iam_policy)
def get_job_iam_policy_output(job_id: Optional[pulumi.Input[str]] = None,
                              project: Optional[pulumi.Input[Optional[str]]] = None,
                              region: Optional[pulumi.Input[Optional[str]]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetJobIamPolicyResult]:
    """
    Retrieves the current IAM policy data for a Dataproc job.

    ## example

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.dataproc.get_job_iam_policy(job_id=google_dataproc_job["pyspark"]["reference"][0]["job_id"],
        region="us-central1")
    ```


    :param str job_id: The name or relative resource id of the job to manage IAM policies for.
    """
    ...
