# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConnectionProfileArgs', 'ConnectionProfile']

@pulumi.input_type
class ConnectionProfileArgs:
    def __init__(__self__, *,
                 connection_profile_id: pulumi.Input[str],
                 display_name: pulumi.Input[str],
                 location: pulumi.Input[str],
                 bigquery_profile: Optional[pulumi.Input['ConnectionProfileBigqueryProfileArgs']] = None,
                 forward_ssh_connectivity: Optional[pulumi.Input['ConnectionProfileForwardSshConnectivityArgs']] = None,
                 gcs_profile: Optional[pulumi.Input['ConnectionProfileGcsProfileArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 mysql_profile: Optional[pulumi.Input['ConnectionProfileMysqlProfileArgs']] = None,
                 oracle_profile: Optional[pulumi.Input['ConnectionProfileOracleProfileArgs']] = None,
                 postgresql_profile: Optional[pulumi.Input['ConnectionProfilePostgresqlProfileArgs']] = None,
                 private_connectivity: Optional[pulumi.Input['ConnectionProfilePrivateConnectivityArgs']] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ConnectionProfile resource.
        :param pulumi.Input[str] connection_profile_id: The connection profile identifier.
        :param pulumi.Input[str] display_name: Display name.
        :param pulumi.Input[str] location: The name of the location this connection profile is located in.
               
               
               - - -
        :param pulumi.Input['ConnectionProfileBigqueryProfileArgs'] bigquery_profile: BigQuery warehouse profile.
        :param pulumi.Input['ConnectionProfileForwardSshConnectivityArgs'] forward_ssh_connectivity: Forward SSH tunnel connectivity.
               Structure is documented below.
        :param pulumi.Input['ConnectionProfileGcsProfileArgs'] gcs_profile: Cloud Storage bucket profile.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels.
        :param pulumi.Input['ConnectionProfileMysqlProfileArgs'] mysql_profile: MySQL database profile.
               Structure is documented below.
        :param pulumi.Input['ConnectionProfileOracleProfileArgs'] oracle_profile: Oracle database profile.
               Structure is documented below.
        :param pulumi.Input['ConnectionProfilePostgresqlProfileArgs'] postgresql_profile: PostgreSQL database profile.
               Structure is documented below.
        :param pulumi.Input['ConnectionProfilePrivateConnectivityArgs'] private_connectivity: Private connectivity.
               Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "connection_profile_id", connection_profile_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "location", location)
        if bigquery_profile is not None:
            pulumi.set(__self__, "bigquery_profile", bigquery_profile)
        if forward_ssh_connectivity is not None:
            pulumi.set(__self__, "forward_ssh_connectivity", forward_ssh_connectivity)
        if gcs_profile is not None:
            pulumi.set(__self__, "gcs_profile", gcs_profile)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if mysql_profile is not None:
            pulumi.set(__self__, "mysql_profile", mysql_profile)
        if oracle_profile is not None:
            pulumi.set(__self__, "oracle_profile", oracle_profile)
        if postgresql_profile is not None:
            pulumi.set(__self__, "postgresql_profile", postgresql_profile)
        if private_connectivity is not None:
            pulumi.set(__self__, "private_connectivity", private_connectivity)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="connectionProfileId")
    def connection_profile_id(self) -> pulumi.Input[str]:
        """
        The connection profile identifier.
        """
        return pulumi.get(self, "connection_profile_id")

    @connection_profile_id.setter
    def connection_profile_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "connection_profile_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        Display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        The name of the location this connection profile is located in.


        - - -
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="bigqueryProfile")
    def bigquery_profile(self) -> Optional[pulumi.Input['ConnectionProfileBigqueryProfileArgs']]:
        """
        BigQuery warehouse profile.
        """
        return pulumi.get(self, "bigquery_profile")

    @bigquery_profile.setter
    def bigquery_profile(self, value: Optional[pulumi.Input['ConnectionProfileBigqueryProfileArgs']]):
        pulumi.set(self, "bigquery_profile", value)

    @property
    @pulumi.getter(name="forwardSshConnectivity")
    def forward_ssh_connectivity(self) -> Optional[pulumi.Input['ConnectionProfileForwardSshConnectivityArgs']]:
        """
        Forward SSH tunnel connectivity.
        Structure is documented below.
        """
        return pulumi.get(self, "forward_ssh_connectivity")

    @forward_ssh_connectivity.setter
    def forward_ssh_connectivity(self, value: Optional[pulumi.Input['ConnectionProfileForwardSshConnectivityArgs']]):
        pulumi.set(self, "forward_ssh_connectivity", value)

    @property
    @pulumi.getter(name="gcsProfile")
    def gcs_profile(self) -> Optional[pulumi.Input['ConnectionProfileGcsProfileArgs']]:
        """
        Cloud Storage bucket profile.
        Structure is documented below.
        """
        return pulumi.get(self, "gcs_profile")

    @gcs_profile.setter
    def gcs_profile(self, value: Optional[pulumi.Input['ConnectionProfileGcsProfileArgs']]):
        pulumi.set(self, "gcs_profile", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="mysqlProfile")
    def mysql_profile(self) -> Optional[pulumi.Input['ConnectionProfileMysqlProfileArgs']]:
        """
        MySQL database profile.
        Structure is documented below.
        """
        return pulumi.get(self, "mysql_profile")

    @mysql_profile.setter
    def mysql_profile(self, value: Optional[pulumi.Input['ConnectionProfileMysqlProfileArgs']]):
        pulumi.set(self, "mysql_profile", value)

    @property
    @pulumi.getter(name="oracleProfile")
    def oracle_profile(self) -> Optional[pulumi.Input['ConnectionProfileOracleProfileArgs']]:
        """
        Oracle database profile.
        Structure is documented below.
        """
        return pulumi.get(self, "oracle_profile")

    @oracle_profile.setter
    def oracle_profile(self, value: Optional[pulumi.Input['ConnectionProfileOracleProfileArgs']]):
        pulumi.set(self, "oracle_profile", value)

    @property
    @pulumi.getter(name="postgresqlProfile")
    def postgresql_profile(self) -> Optional[pulumi.Input['ConnectionProfilePostgresqlProfileArgs']]:
        """
        PostgreSQL database profile.
        Structure is documented below.
        """
        return pulumi.get(self, "postgresql_profile")

    @postgresql_profile.setter
    def postgresql_profile(self, value: Optional[pulumi.Input['ConnectionProfilePostgresqlProfileArgs']]):
        pulumi.set(self, "postgresql_profile", value)

    @property
    @pulumi.getter(name="privateConnectivity")
    def private_connectivity(self) -> Optional[pulumi.Input['ConnectionProfilePrivateConnectivityArgs']]:
        """
        Private connectivity.
        Structure is documented below.
        """
        return pulumi.get(self, "private_connectivity")

    @private_connectivity.setter
    def private_connectivity(self, value: Optional[pulumi.Input['ConnectionProfilePrivateConnectivityArgs']]):
        pulumi.set(self, "private_connectivity", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _ConnectionProfileState:
    def __init__(__self__, *,
                 bigquery_profile: Optional[pulumi.Input['ConnectionProfileBigqueryProfileArgs']] = None,
                 connection_profile_id: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 forward_ssh_connectivity: Optional[pulumi.Input['ConnectionProfileForwardSshConnectivityArgs']] = None,
                 gcs_profile: Optional[pulumi.Input['ConnectionProfileGcsProfileArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 mysql_profile: Optional[pulumi.Input['ConnectionProfileMysqlProfileArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 oracle_profile: Optional[pulumi.Input['ConnectionProfileOracleProfileArgs']] = None,
                 postgresql_profile: Optional[pulumi.Input['ConnectionProfilePostgresqlProfileArgs']] = None,
                 private_connectivity: Optional[pulumi.Input['ConnectionProfilePrivateConnectivityArgs']] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ConnectionProfile resources.
        :param pulumi.Input['ConnectionProfileBigqueryProfileArgs'] bigquery_profile: BigQuery warehouse profile.
        :param pulumi.Input[str] connection_profile_id: The connection profile identifier.
        :param pulumi.Input[str] display_name: Display name.
        :param pulumi.Input['ConnectionProfileForwardSshConnectivityArgs'] forward_ssh_connectivity: Forward SSH tunnel connectivity.
               Structure is documented below.
        :param pulumi.Input['ConnectionProfileGcsProfileArgs'] gcs_profile: Cloud Storage bucket profile.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels.
        :param pulumi.Input[str] location: The name of the location this connection profile is located in.
               
               
               - - -
        :param pulumi.Input['ConnectionProfileMysqlProfileArgs'] mysql_profile: MySQL database profile.
               Structure is documented below.
        :param pulumi.Input[str] name: The resource's name.
        :param pulumi.Input['ConnectionProfileOracleProfileArgs'] oracle_profile: Oracle database profile.
               Structure is documented below.
        :param pulumi.Input['ConnectionProfilePostgresqlProfileArgs'] postgresql_profile: PostgreSQL database profile.
               Structure is documented below.
        :param pulumi.Input['ConnectionProfilePrivateConnectivityArgs'] private_connectivity: Private connectivity.
               Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        if bigquery_profile is not None:
            pulumi.set(__self__, "bigquery_profile", bigquery_profile)
        if connection_profile_id is not None:
            pulumi.set(__self__, "connection_profile_id", connection_profile_id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if forward_ssh_connectivity is not None:
            pulumi.set(__self__, "forward_ssh_connectivity", forward_ssh_connectivity)
        if gcs_profile is not None:
            pulumi.set(__self__, "gcs_profile", gcs_profile)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if mysql_profile is not None:
            pulumi.set(__self__, "mysql_profile", mysql_profile)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oracle_profile is not None:
            pulumi.set(__self__, "oracle_profile", oracle_profile)
        if postgresql_profile is not None:
            pulumi.set(__self__, "postgresql_profile", postgresql_profile)
        if private_connectivity is not None:
            pulumi.set(__self__, "private_connectivity", private_connectivity)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="bigqueryProfile")
    def bigquery_profile(self) -> Optional[pulumi.Input['ConnectionProfileBigqueryProfileArgs']]:
        """
        BigQuery warehouse profile.
        """
        return pulumi.get(self, "bigquery_profile")

    @bigquery_profile.setter
    def bigquery_profile(self, value: Optional[pulumi.Input['ConnectionProfileBigqueryProfileArgs']]):
        pulumi.set(self, "bigquery_profile", value)

    @property
    @pulumi.getter(name="connectionProfileId")
    def connection_profile_id(self) -> Optional[pulumi.Input[str]]:
        """
        The connection profile identifier.
        """
        return pulumi.get(self, "connection_profile_id")

    @connection_profile_id.setter
    def connection_profile_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_profile_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="forwardSshConnectivity")
    def forward_ssh_connectivity(self) -> Optional[pulumi.Input['ConnectionProfileForwardSshConnectivityArgs']]:
        """
        Forward SSH tunnel connectivity.
        Structure is documented below.
        """
        return pulumi.get(self, "forward_ssh_connectivity")

    @forward_ssh_connectivity.setter
    def forward_ssh_connectivity(self, value: Optional[pulumi.Input['ConnectionProfileForwardSshConnectivityArgs']]):
        pulumi.set(self, "forward_ssh_connectivity", value)

    @property
    @pulumi.getter(name="gcsProfile")
    def gcs_profile(self) -> Optional[pulumi.Input['ConnectionProfileGcsProfileArgs']]:
        """
        Cloud Storage bucket profile.
        Structure is documented below.
        """
        return pulumi.get(self, "gcs_profile")

    @gcs_profile.setter
    def gcs_profile(self, value: Optional[pulumi.Input['ConnectionProfileGcsProfileArgs']]):
        pulumi.set(self, "gcs_profile", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the location this connection profile is located in.


        - - -
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="mysqlProfile")
    def mysql_profile(self) -> Optional[pulumi.Input['ConnectionProfileMysqlProfileArgs']]:
        """
        MySQL database profile.
        Structure is documented below.
        """
        return pulumi.get(self, "mysql_profile")

    @mysql_profile.setter
    def mysql_profile(self, value: Optional[pulumi.Input['ConnectionProfileMysqlProfileArgs']]):
        pulumi.set(self, "mysql_profile", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The resource's name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="oracleProfile")
    def oracle_profile(self) -> Optional[pulumi.Input['ConnectionProfileOracleProfileArgs']]:
        """
        Oracle database profile.
        Structure is documented below.
        """
        return pulumi.get(self, "oracle_profile")

    @oracle_profile.setter
    def oracle_profile(self, value: Optional[pulumi.Input['ConnectionProfileOracleProfileArgs']]):
        pulumi.set(self, "oracle_profile", value)

    @property
    @pulumi.getter(name="postgresqlProfile")
    def postgresql_profile(self) -> Optional[pulumi.Input['ConnectionProfilePostgresqlProfileArgs']]:
        """
        PostgreSQL database profile.
        Structure is documented below.
        """
        return pulumi.get(self, "postgresql_profile")

    @postgresql_profile.setter
    def postgresql_profile(self, value: Optional[pulumi.Input['ConnectionProfilePostgresqlProfileArgs']]):
        pulumi.set(self, "postgresql_profile", value)

    @property
    @pulumi.getter(name="privateConnectivity")
    def private_connectivity(self) -> Optional[pulumi.Input['ConnectionProfilePrivateConnectivityArgs']]:
        """
        Private connectivity.
        Structure is documented below.
        """
        return pulumi.get(self, "private_connectivity")

    @private_connectivity.setter
    def private_connectivity(self, value: Optional[pulumi.Input['ConnectionProfilePrivateConnectivityArgs']]):
        pulumi.set(self, "private_connectivity", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


class ConnectionProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bigquery_profile: Optional[pulumi.Input[pulumi.InputType['ConnectionProfileBigqueryProfileArgs']]] = None,
                 connection_profile_id: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 forward_ssh_connectivity: Optional[pulumi.Input[pulumi.InputType['ConnectionProfileForwardSshConnectivityArgs']]] = None,
                 gcs_profile: Optional[pulumi.Input[pulumi.InputType['ConnectionProfileGcsProfileArgs']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 mysql_profile: Optional[pulumi.Input[pulumi.InputType['ConnectionProfileMysqlProfileArgs']]] = None,
                 oracle_profile: Optional[pulumi.Input[pulumi.InputType['ConnectionProfileOracleProfileArgs']]] = None,
                 postgresql_profile: Optional[pulumi.Input[pulumi.InputType['ConnectionProfilePostgresqlProfileArgs']]] = None,
                 private_connectivity: Optional[pulumi.Input[pulumi.InputType['ConnectionProfilePrivateConnectivityArgs']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        A set of reusable connection configurations to be used as a source or destination for a stream.

        To get more information about ConnectionProfile, see:

        * [API documentation](https://cloud.google.com/datastream/docs/reference/rest/v1/projects.locations.connectionProfiles)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/datastream/docs/create-connection-profiles)

        > **Warning:** All arguments including the following potentially sensitive
        values will be stored in the raw state as plain text: `oracle_profile.password`, `mysql_profile.password`, `mysql_profile.ssl_config.client_key`, `mysql_profile.ssl_config.client_certificate`, `mysql_profile.ssl_config.ca_certificate`, `postgresql_profile.password`, `forward_ssh_connectivity.password`, `forward_ssh_connectivity.private_key`.
        Read more about sensitive data in state.

        ## Example Usage
        ### Datastream Connection Profile Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.datastream.ConnectionProfile("default",
            connection_profile_id="my-profile",
            display_name="Connection profile",
            gcs_profile=gcp.datastream.ConnectionProfileGcsProfileArgs(
                bucket="my-bucket",
                root_path="/path",
            ),
            location="us-central1")
        ```
        ### Datastream Connection Profile Bigquery Private Connection

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_network = gcp.compute.Network("defaultNetwork")
        private_connection = gcp.datastream.PrivateConnection("privateConnection",
            display_name="Connection profile",
            location="us-central1",
            private_connection_id="my-connection",
            labels={
                "key": "value",
            },
            vpc_peering_config=gcp.datastream.PrivateConnectionVpcPeeringConfigArgs(
                vpc=default_network.id,
                subnet="10.0.0.0/29",
            ))
        default_connection_profile = gcp.datastream.ConnectionProfile("defaultConnectionProfile",
            display_name="Connection profile",
            location="us-central1",
            connection_profile_id="my-profile",
            bigquery_profile=gcp.datastream.ConnectionProfileBigqueryProfileArgs(),
            private_connectivity=gcp.datastream.ConnectionProfilePrivateConnectivityArgs(
                private_connection=private_connection.id,
            ))
        ```
        ### Datastream Connection Profile Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.datastream.ConnectionProfile("default",
            connection_profile_id="my-profile",
            display_name="Connection profile",
            forward_ssh_connectivity=gcp.datastream.ConnectionProfileForwardSshConnectivityArgs(
                hostname="google.com",
                password="swordfish",
                port=8022,
                username="my-user",
            ),
            gcs_profile=gcp.datastream.ConnectionProfileGcsProfileArgs(
                bucket="my-bucket",
                root_path="/path",
            ),
            labels={
                "key": "value",
            },
            location="us-central1")
        ```
        ### Datastream Connection Profile Postgres

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_random as random

        instance = gcp.sql.DatabaseInstance("instance",
            database_version="POSTGRES_14",
            region="us-central1",
            settings=gcp.sql.DatabaseInstanceSettingsArgs(
                tier="db-f1-micro",
                ip_configuration=gcp.sql.DatabaseInstanceSettingsIpConfigurationArgs(
                    authorized_networks=[
                        gcp.sql.DatabaseInstanceSettingsIpConfigurationAuthorizedNetworkArgs(
                            value="34.71.242.81",
                        ),
                        gcp.sql.DatabaseInstanceSettingsIpConfigurationAuthorizedNetworkArgs(
                            value="34.72.28.29",
                        ),
                        gcp.sql.DatabaseInstanceSettingsIpConfigurationAuthorizedNetworkArgs(
                            value="34.67.6.157",
                        ),
                        gcp.sql.DatabaseInstanceSettingsIpConfigurationAuthorizedNetworkArgs(
                            value="34.67.234.134",
                        ),
                        gcp.sql.DatabaseInstanceSettingsIpConfigurationAuthorizedNetworkArgs(
                            value="34.72.239.218",
                        ),
                    ],
                ),
            ),
            deletion_protection=True)
        db = gcp.sql.Database("db", instance=instance.name)
        pwd = random.RandomPassword("pwd",
            length=16,
            special=False)
        user = gcp.sql.User("user",
            instance=instance.name,
            password=pwd.result)
        default = gcp.datastream.ConnectionProfile("default",
            display_name="Connection profile",
            location="us-central1",
            connection_profile_id="my-profile",
            postgresql_profile=gcp.datastream.ConnectionProfilePostgresqlProfileArgs(
                hostname=instance.public_ip_address,
                username=user.name,
                password=user.password,
                database=db.name,
            ))
        ```

        ## Import

        ConnectionProfile can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:datastream/connectionProfile:ConnectionProfile default projects/{{project}}/locations/{{location}}/connectionProfiles/{{connection_profile_id}}
        ```

        ```sh
         $ pulumi import gcp:datastream/connectionProfile:ConnectionProfile default {{project}}/{{location}}/{{connection_profile_id}}
        ```

        ```sh
         $ pulumi import gcp:datastream/connectionProfile:ConnectionProfile default {{location}}/{{connection_profile_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ConnectionProfileBigqueryProfileArgs']] bigquery_profile: BigQuery warehouse profile.
        :param pulumi.Input[str] connection_profile_id: The connection profile identifier.
        :param pulumi.Input[str] display_name: Display name.
        :param pulumi.Input[pulumi.InputType['ConnectionProfileForwardSshConnectivityArgs']] forward_ssh_connectivity: Forward SSH tunnel connectivity.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['ConnectionProfileGcsProfileArgs']] gcs_profile: Cloud Storage bucket profile.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels.
        :param pulumi.Input[str] location: The name of the location this connection profile is located in.
               
               
               - - -
        :param pulumi.Input[pulumi.InputType['ConnectionProfileMysqlProfileArgs']] mysql_profile: MySQL database profile.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['ConnectionProfileOracleProfileArgs']] oracle_profile: Oracle database profile.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['ConnectionProfilePostgresqlProfileArgs']] postgresql_profile: PostgreSQL database profile.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['ConnectionProfilePrivateConnectivityArgs']] private_connectivity: Private connectivity.
               Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConnectionProfileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A set of reusable connection configurations to be used as a source or destination for a stream.

        To get more information about ConnectionProfile, see:

        * [API documentation](https://cloud.google.com/datastream/docs/reference/rest/v1/projects.locations.connectionProfiles)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/datastream/docs/create-connection-profiles)

        > **Warning:** All arguments including the following potentially sensitive
        values will be stored in the raw state as plain text: `oracle_profile.password`, `mysql_profile.password`, `mysql_profile.ssl_config.client_key`, `mysql_profile.ssl_config.client_certificate`, `mysql_profile.ssl_config.ca_certificate`, `postgresql_profile.password`, `forward_ssh_connectivity.password`, `forward_ssh_connectivity.private_key`.
        Read more about sensitive data in state.

        ## Example Usage
        ### Datastream Connection Profile Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.datastream.ConnectionProfile("default",
            connection_profile_id="my-profile",
            display_name="Connection profile",
            gcs_profile=gcp.datastream.ConnectionProfileGcsProfileArgs(
                bucket="my-bucket",
                root_path="/path",
            ),
            location="us-central1")
        ```
        ### Datastream Connection Profile Bigquery Private Connection

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_network = gcp.compute.Network("defaultNetwork")
        private_connection = gcp.datastream.PrivateConnection("privateConnection",
            display_name="Connection profile",
            location="us-central1",
            private_connection_id="my-connection",
            labels={
                "key": "value",
            },
            vpc_peering_config=gcp.datastream.PrivateConnectionVpcPeeringConfigArgs(
                vpc=default_network.id,
                subnet="10.0.0.0/29",
            ))
        default_connection_profile = gcp.datastream.ConnectionProfile("defaultConnectionProfile",
            display_name="Connection profile",
            location="us-central1",
            connection_profile_id="my-profile",
            bigquery_profile=gcp.datastream.ConnectionProfileBigqueryProfileArgs(),
            private_connectivity=gcp.datastream.ConnectionProfilePrivateConnectivityArgs(
                private_connection=private_connection.id,
            ))
        ```
        ### Datastream Connection Profile Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.datastream.ConnectionProfile("default",
            connection_profile_id="my-profile",
            display_name="Connection profile",
            forward_ssh_connectivity=gcp.datastream.ConnectionProfileForwardSshConnectivityArgs(
                hostname="google.com",
                password="swordfish",
                port=8022,
                username="my-user",
            ),
            gcs_profile=gcp.datastream.ConnectionProfileGcsProfileArgs(
                bucket="my-bucket",
                root_path="/path",
            ),
            labels={
                "key": "value",
            },
            location="us-central1")
        ```
        ### Datastream Connection Profile Postgres

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_random as random

        instance = gcp.sql.DatabaseInstance("instance",
            database_version="POSTGRES_14",
            region="us-central1",
            settings=gcp.sql.DatabaseInstanceSettingsArgs(
                tier="db-f1-micro",
                ip_configuration=gcp.sql.DatabaseInstanceSettingsIpConfigurationArgs(
                    authorized_networks=[
                        gcp.sql.DatabaseInstanceSettingsIpConfigurationAuthorizedNetworkArgs(
                            value="34.71.242.81",
                        ),
                        gcp.sql.DatabaseInstanceSettingsIpConfigurationAuthorizedNetworkArgs(
                            value="34.72.28.29",
                        ),
                        gcp.sql.DatabaseInstanceSettingsIpConfigurationAuthorizedNetworkArgs(
                            value="34.67.6.157",
                        ),
                        gcp.sql.DatabaseInstanceSettingsIpConfigurationAuthorizedNetworkArgs(
                            value="34.67.234.134",
                        ),
                        gcp.sql.DatabaseInstanceSettingsIpConfigurationAuthorizedNetworkArgs(
                            value="34.72.239.218",
                        ),
                    ],
                ),
            ),
            deletion_protection=True)
        db = gcp.sql.Database("db", instance=instance.name)
        pwd = random.RandomPassword("pwd",
            length=16,
            special=False)
        user = gcp.sql.User("user",
            instance=instance.name,
            password=pwd.result)
        default = gcp.datastream.ConnectionProfile("default",
            display_name="Connection profile",
            location="us-central1",
            connection_profile_id="my-profile",
            postgresql_profile=gcp.datastream.ConnectionProfilePostgresqlProfileArgs(
                hostname=instance.public_ip_address,
                username=user.name,
                password=user.password,
                database=db.name,
            ))
        ```

        ## Import

        ConnectionProfile can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:datastream/connectionProfile:ConnectionProfile default projects/{{project}}/locations/{{location}}/connectionProfiles/{{connection_profile_id}}
        ```

        ```sh
         $ pulumi import gcp:datastream/connectionProfile:ConnectionProfile default {{project}}/{{location}}/{{connection_profile_id}}
        ```

        ```sh
         $ pulumi import gcp:datastream/connectionProfile:ConnectionProfile default {{location}}/{{connection_profile_id}}
        ```

        :param str resource_name: The name of the resource.
        :param ConnectionProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConnectionProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bigquery_profile: Optional[pulumi.Input[pulumi.InputType['ConnectionProfileBigqueryProfileArgs']]] = None,
                 connection_profile_id: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 forward_ssh_connectivity: Optional[pulumi.Input[pulumi.InputType['ConnectionProfileForwardSshConnectivityArgs']]] = None,
                 gcs_profile: Optional[pulumi.Input[pulumi.InputType['ConnectionProfileGcsProfileArgs']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 mysql_profile: Optional[pulumi.Input[pulumi.InputType['ConnectionProfileMysqlProfileArgs']]] = None,
                 oracle_profile: Optional[pulumi.Input[pulumi.InputType['ConnectionProfileOracleProfileArgs']]] = None,
                 postgresql_profile: Optional[pulumi.Input[pulumi.InputType['ConnectionProfilePostgresqlProfileArgs']]] = None,
                 private_connectivity: Optional[pulumi.Input[pulumi.InputType['ConnectionProfilePrivateConnectivityArgs']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConnectionProfileArgs.__new__(ConnectionProfileArgs)

            __props__.__dict__["bigquery_profile"] = bigquery_profile
            if connection_profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'connection_profile_id'")
            __props__.__dict__["connection_profile_id"] = connection_profile_id
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["forward_ssh_connectivity"] = forward_ssh_connectivity
            __props__.__dict__["gcs_profile"] = gcs_profile
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["mysql_profile"] = mysql_profile
            __props__.__dict__["oracle_profile"] = oracle_profile
            __props__.__dict__["postgresql_profile"] = postgresql_profile
            __props__.__dict__["private_connectivity"] = private_connectivity
            __props__.__dict__["project"] = project
            __props__.__dict__["name"] = None
        super(ConnectionProfile, __self__).__init__(
            'gcp:datastream/connectionProfile:ConnectionProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bigquery_profile: Optional[pulumi.Input[pulumi.InputType['ConnectionProfileBigqueryProfileArgs']]] = None,
            connection_profile_id: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            forward_ssh_connectivity: Optional[pulumi.Input[pulumi.InputType['ConnectionProfileForwardSshConnectivityArgs']]] = None,
            gcs_profile: Optional[pulumi.Input[pulumi.InputType['ConnectionProfileGcsProfileArgs']]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            location: Optional[pulumi.Input[str]] = None,
            mysql_profile: Optional[pulumi.Input[pulumi.InputType['ConnectionProfileMysqlProfileArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            oracle_profile: Optional[pulumi.Input[pulumi.InputType['ConnectionProfileOracleProfileArgs']]] = None,
            postgresql_profile: Optional[pulumi.Input[pulumi.InputType['ConnectionProfilePostgresqlProfileArgs']]] = None,
            private_connectivity: Optional[pulumi.Input[pulumi.InputType['ConnectionProfilePrivateConnectivityArgs']]] = None,
            project: Optional[pulumi.Input[str]] = None) -> 'ConnectionProfile':
        """
        Get an existing ConnectionProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ConnectionProfileBigqueryProfileArgs']] bigquery_profile: BigQuery warehouse profile.
        :param pulumi.Input[str] connection_profile_id: The connection profile identifier.
        :param pulumi.Input[str] display_name: Display name.
        :param pulumi.Input[pulumi.InputType['ConnectionProfileForwardSshConnectivityArgs']] forward_ssh_connectivity: Forward SSH tunnel connectivity.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['ConnectionProfileGcsProfileArgs']] gcs_profile: Cloud Storage bucket profile.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels.
        :param pulumi.Input[str] location: The name of the location this connection profile is located in.
               
               
               - - -
        :param pulumi.Input[pulumi.InputType['ConnectionProfileMysqlProfileArgs']] mysql_profile: MySQL database profile.
               Structure is documented below.
        :param pulumi.Input[str] name: The resource's name.
        :param pulumi.Input[pulumi.InputType['ConnectionProfileOracleProfileArgs']] oracle_profile: Oracle database profile.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['ConnectionProfilePostgresqlProfileArgs']] postgresql_profile: PostgreSQL database profile.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['ConnectionProfilePrivateConnectivityArgs']] private_connectivity: Private connectivity.
               Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConnectionProfileState.__new__(_ConnectionProfileState)

        __props__.__dict__["bigquery_profile"] = bigquery_profile
        __props__.__dict__["connection_profile_id"] = connection_profile_id
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["forward_ssh_connectivity"] = forward_ssh_connectivity
        __props__.__dict__["gcs_profile"] = gcs_profile
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["mysql_profile"] = mysql_profile
        __props__.__dict__["name"] = name
        __props__.__dict__["oracle_profile"] = oracle_profile
        __props__.__dict__["postgresql_profile"] = postgresql_profile
        __props__.__dict__["private_connectivity"] = private_connectivity
        __props__.__dict__["project"] = project
        return ConnectionProfile(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="bigqueryProfile")
    def bigquery_profile(self) -> pulumi.Output[Optional['outputs.ConnectionProfileBigqueryProfile']]:
        """
        BigQuery warehouse profile.
        """
        return pulumi.get(self, "bigquery_profile")

    @property
    @pulumi.getter(name="connectionProfileId")
    def connection_profile_id(self) -> pulumi.Output[str]:
        """
        The connection profile identifier.
        """
        return pulumi.get(self, "connection_profile_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        Display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="forwardSshConnectivity")
    def forward_ssh_connectivity(self) -> pulumi.Output[Optional['outputs.ConnectionProfileForwardSshConnectivity']]:
        """
        Forward SSH tunnel connectivity.
        Structure is documented below.
        """
        return pulumi.get(self, "forward_ssh_connectivity")

    @property
    @pulumi.getter(name="gcsProfile")
    def gcs_profile(self) -> pulumi.Output[Optional['outputs.ConnectionProfileGcsProfile']]:
        """
        Cloud Storage bucket profile.
        Structure is documented below.
        """
        return pulumi.get(self, "gcs_profile")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Labels.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The name of the location this connection profile is located in.


        - - -
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="mysqlProfile")
    def mysql_profile(self) -> pulumi.Output[Optional['outputs.ConnectionProfileMysqlProfile']]:
        """
        MySQL database profile.
        Structure is documented below.
        """
        return pulumi.get(self, "mysql_profile")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The resource's name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="oracleProfile")
    def oracle_profile(self) -> pulumi.Output[Optional['outputs.ConnectionProfileOracleProfile']]:
        """
        Oracle database profile.
        Structure is documented below.
        """
        return pulumi.get(self, "oracle_profile")

    @property
    @pulumi.getter(name="postgresqlProfile")
    def postgresql_profile(self) -> pulumi.Output[Optional['outputs.ConnectionProfilePostgresqlProfile']]:
        """
        PostgreSQL database profile.
        Structure is documented below.
        """
        return pulumi.get(self, "postgresql_profile")

    @property
    @pulumi.getter(name="privateConnectivity")
    def private_connectivity(self) -> pulumi.Output[Optional['outputs.ConnectionProfilePrivateConnectivity']]:
        """
        Private connectivity.
        Structure is documented below.
        """
        return pulumi.get(self, "private_connectivity")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

