# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetManagedZoneIamPolicyResult',
    'AwaitableGetManagedZoneIamPolicyResult',
    'get_managed_zone_iam_policy',
    'get_managed_zone_iam_policy_output',
]

@pulumi.output_type
class GetManagedZoneIamPolicyResult:
    """
    A collection of values returned by getManagedZoneIamPolicy.
    """
    def __init__(__self__, etag=None, id=None, managed_zone=None, policy_data=None, project=None):
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if managed_zone and not isinstance(managed_zone, str):
            raise TypeError("Expected argument 'managed_zone' to be a str")
        pulumi.set(__self__, "managed_zone", managed_zone)
        if policy_data and not isinstance(policy_data, str):
            raise TypeError("Expected argument 'policy_data' to be a str")
        pulumi.set(__self__, "policy_data", policy_data)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        (Computed) The etag of the IAM policy.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="managedZone")
    def managed_zone(self) -> str:
        return pulumi.get(self, "managed_zone")

    @property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> str:
        """
        (Required only by `dns.DnsManagedZoneIamPolicy`) The policy data generated by
        a `organizations_get_iam_policy` data source.
        """
        return pulumi.get(self, "policy_data")

    @property
    @pulumi.getter
    def project(self) -> str:
        return pulumi.get(self, "project")


class AwaitableGetManagedZoneIamPolicyResult(GetManagedZoneIamPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedZoneIamPolicyResult(
            etag=self.etag,
            id=self.id,
            managed_zone=self.managed_zone,
            policy_data=self.policy_data,
            project=self.project)


def get_managed_zone_iam_policy(managed_zone: Optional[str] = None,
                                project: Optional[str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedZoneIamPolicyResult:
    """
    Retrieves the current IAM policy data for managedzone

    ## example

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.dns.get_managed_zone_iam_policy(project=google_dns_managed_zone["default"]["project"],
        managed_zone=google_dns_managed_zone["default"]["name"])
    ```


    :param str managed_zone: Used to find the parent resource to bind the IAM policy to
    :param str project: The ID of the project in which the resource belongs.
           If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
    """
    __args__ = dict()
    __args__['managedZone'] = managed_zone
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:dns/getManagedZoneIamPolicy:getManagedZoneIamPolicy', __args__, opts=opts, typ=GetManagedZoneIamPolicyResult).value

    return AwaitableGetManagedZoneIamPolicyResult(
        etag=pulumi.get(__ret__, 'etag'),
        id=pulumi.get(__ret__, 'id'),
        managed_zone=pulumi.get(__ret__, 'managed_zone'),
        policy_data=pulumi.get(__ret__, 'policy_data'),
        project=pulumi.get(__ret__, 'project'))


@_utilities.lift_output_func(get_managed_zone_iam_policy)
def get_managed_zone_iam_policy_output(managed_zone: Optional[pulumi.Input[str]] = None,
                                       project: Optional[pulumi.Input[Optional[str]]] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetManagedZoneIamPolicyResult]:
    """
    Retrieves the current IAM policy data for managedzone

    ## example

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.dns.get_managed_zone_iam_policy(project=google_dns_managed_zone["default"]["project"],
        managed_zone=google_dns_managed_zone["default"]["name"])
    ```


    :param str managed_zone: Used to find the parent resource to bind the IAM policy to
    :param str project: The ID of the project in which the resource belongs.
           If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
    """
    ...
