# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetServiceIamPolicyResult',
    'AwaitableGetServiceIamPolicyResult',
    'get_service_iam_policy',
    'get_service_iam_policy_output',
]

@pulumi.output_type
class GetServiceIamPolicyResult:
    """
    A collection of values returned by getServiceIamPolicy.
    """
    def __init__(__self__, etag=None, id=None, policy_data=None, service_name=None):
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if policy_data and not isinstance(policy_data, str):
            raise TypeError("Expected argument 'policy_data' to be a str")
        pulumi.set(__self__, "policy_data", policy_data)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        (Computed) The etag of the IAM policy.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> str:
        """
        (Required only by `endpoints.ServiceIamPolicy`) The policy data generated by
        a `organizations_get_iam_policy` data source.
        """
        return pulumi.get(self, "policy_data")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        return pulumi.get(self, "service_name")


class AwaitableGetServiceIamPolicyResult(GetServiceIamPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServiceIamPolicyResult(
            etag=self.etag,
            id=self.id,
            policy_data=self.policy_data,
            service_name=self.service_name)


def get_service_iam_policy(service_name: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServiceIamPolicyResult:
    """
    Retrieves the current IAM policy data for service

    ## example

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.endpoints.get_service_iam_policy(service_name=google_endpoints_service["endpoints_service"]["service_name"])
    ```
    """
    __args__ = dict()
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:endpoints/getServiceIamPolicy:getServiceIamPolicy', __args__, opts=opts, typ=GetServiceIamPolicyResult).value

    return AwaitableGetServiceIamPolicyResult(
        etag=pulumi.get(__ret__, 'etag'),
        id=pulumi.get(__ret__, 'id'),
        policy_data=pulumi.get(__ret__, 'policy_data'),
        service_name=pulumi.get(__ret__, 'service_name'))


@_utilities.lift_output_func(get_service_iam_policy)
def get_service_iam_policy_output(service_name: Optional[pulumi.Input[str]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetServiceIamPolicyResult]:
    """
    Retrieves the current IAM policy data for service

    ## example

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.endpoints.get_service_iam_policy(service_name=google_endpoints_service["endpoints_service"]["service_name"])
    ```
    """
    ...
