# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['HostingChannelArgs', 'HostingChannel']

@pulumi.input_type
class HostingChannelArgs:
    def __init__(__self__, *,
                 channel_id: pulumi.Input[str],
                 site_id: pulumi.Input[str],
                 expire_time: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 retained_release_count: Optional[pulumi.Input[int]] = None,
                 ttl: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a HostingChannel resource.
        :param pulumi.Input[str] channel_id: Required. Immutable. A unique ID within the site that identifies the channel.
               
               
               - - -
        :param pulumi.Input[str] site_id: Required. The ID of the site in which to create this channel.
        :param pulumi.Input[str] expire_time: The time at which the channel will be automatically deleted. If null, the channel
               will not be automatically deleted. This field is present in the output whether it's
               set directly or via the `ttl` field.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Text labels used for extra metadata and/or filtering
        :param pulumi.Input[int] retained_release_count: The number of previous releases to retain on the channel for rollback or other
               purposes. Must be a number between 1-100. Defaults to 10 for new channels.
        :param pulumi.Input[str] ttl: Input only. A time-to-live for this channel. Sets `expire_time` to the provided
               duration past the time of the request. A duration in seconds with up to nine fractional
               digits, terminated by 's'. Example: "86400s" (one day).
        """
        pulumi.set(__self__, "channel_id", channel_id)
        pulumi.set(__self__, "site_id", site_id)
        if expire_time is not None:
            pulumi.set(__self__, "expire_time", expire_time)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if retained_release_count is not None:
            pulumi.set(__self__, "retained_release_count", retained_release_count)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter(name="channelId")
    def channel_id(self) -> pulumi.Input[str]:
        """
        Required. Immutable. A unique ID within the site that identifies the channel.


        - - -
        """
        return pulumi.get(self, "channel_id")

    @channel_id.setter
    def channel_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "channel_id", value)

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Input[str]:
        """
        Required. The ID of the site in which to create this channel.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "site_id", value)

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time at which the channel will be automatically deleted. If null, the channel
        will not be automatically deleted. This field is present in the output whether it's
        set directly or via the `ttl` field.
        """
        return pulumi.get(self, "expire_time")

    @expire_time.setter
    def expire_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expire_time", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Text labels used for extra metadata and/or filtering
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="retainedReleaseCount")
    def retained_release_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of previous releases to retain on the channel for rollback or other
        purposes. Must be a number between 1-100. Defaults to 10 for new channels.
        """
        return pulumi.get(self, "retained_release_count")

    @retained_release_count.setter
    def retained_release_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retained_release_count", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[str]]:
        """
        Input only. A time-to-live for this channel. Sets `expire_time` to the provided
        duration past the time of the request. A duration in seconds with up to nine fractional
        digits, terminated by 's'. Example: "86400s" (one day).
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ttl", value)


@pulumi.input_type
class _HostingChannelState:
    def __init__(__self__, *,
                 channel_id: Optional[pulumi.Input[str]] = None,
                 expire_time: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 retained_release_count: Optional[pulumi.Input[int]] = None,
                 site_id: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering HostingChannel resources.
        :param pulumi.Input[str] channel_id: Required. Immutable. A unique ID within the site that identifies the channel.
               
               
               - - -
        :param pulumi.Input[str] expire_time: The time at which the channel will be automatically deleted. If null, the channel
               will not be automatically deleted. This field is present in the output whether it's
               set directly or via the `ttl` field.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Text labels used for extra metadata and/or filtering
        :param pulumi.Input[str] name: The fully-qualified resource name for the channel, in the format:
               sites/SITE_ID/channels/CHANNEL_ID
        :param pulumi.Input[int] retained_release_count: The number of previous releases to retain on the channel for rollback or other
               purposes. Must be a number between 1-100. Defaults to 10 for new channels.
        :param pulumi.Input[str] site_id: Required. The ID of the site in which to create this channel.
        :param pulumi.Input[str] ttl: Input only. A time-to-live for this channel. Sets `expire_time` to the provided
               duration past the time of the request. A duration in seconds with up to nine fractional
               digits, terminated by 's'. Example: "86400s" (one day).
        """
        if channel_id is not None:
            pulumi.set(__self__, "channel_id", channel_id)
        if expire_time is not None:
            pulumi.set(__self__, "expire_time", expire_time)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if retained_release_count is not None:
            pulumi.set(__self__, "retained_release_count", retained_release_count)
        if site_id is not None:
            pulumi.set(__self__, "site_id", site_id)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter(name="channelId")
    def channel_id(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Immutable. A unique ID within the site that identifies the channel.


        - - -
        """
        return pulumi.get(self, "channel_id")

    @channel_id.setter
    def channel_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "channel_id", value)

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time at which the channel will be automatically deleted. If null, the channel
        will not be automatically deleted. This field is present in the output whether it's
        set directly or via the `ttl` field.
        """
        return pulumi.get(self, "expire_time")

    @expire_time.setter
    def expire_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expire_time", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Text labels used for extra metadata and/or filtering
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The fully-qualified resource name for the channel, in the format:
        sites/SITE_ID/channels/CHANNEL_ID
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="retainedReleaseCount")
    def retained_release_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of previous releases to retain on the channel for rollback or other
        purposes. Must be a number between 1-100. Defaults to 10 for new channels.
        """
        return pulumi.get(self, "retained_release_count")

    @retained_release_count.setter
    def retained_release_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retained_release_count", value)

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The ID of the site in which to create this channel.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "site_id", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[str]]:
        """
        Input only. A time-to-live for this channel. Sets `expire_time` to the provided
        duration past the time of the request. A duration in seconds with up to nine fractional
        digits, terminated by 's'. Example: "86400s" (one day).
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ttl", value)


class HostingChannel(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 channel_id: Optional[pulumi.Input[str]] = None,
                 expire_time: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 retained_release_count: Optional[pulumi.Input[int]] = None,
                 site_id: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage
        ### Firebasehosting Channel Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_hosting_site = gcp.firebase.HostingSite("defaultHostingSite",
            project="my-project-name",
            site_id="site-with-channel",
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_hosting_channel = gcp.firebase.HostingChannel("defaultHostingChannel",
            site_id=default_hosting_site.site_id,
            channel_id="channel-basic",
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Firebasehosting Channel Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.firebase.HostingSite("default",
            project="my-project-name",
            site_id="site-with-channel",
            opts=pulumi.ResourceOptions(provider=google_beta))
        full = gcp.firebase.HostingChannel("full",
            site_id=default.site_id,
            channel_id="channel-full",
            ttl="86400s",
            retained_release_count=20,
            labels={
                "some-key": "some-value",
            },
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```

        ## Import

        Channel can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:firebase/hostingChannel:HostingChannel default sites/{{site_id}}/channels/{{channel_id}}
        ```

        ```sh
         $ pulumi import gcp:firebase/hostingChannel:HostingChannel default {{site_id}}/{{channel_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] channel_id: Required. Immutable. A unique ID within the site that identifies the channel.
               
               
               - - -
        :param pulumi.Input[str] expire_time: The time at which the channel will be automatically deleted. If null, the channel
               will not be automatically deleted. This field is present in the output whether it's
               set directly or via the `ttl` field.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Text labels used for extra metadata and/or filtering
        :param pulumi.Input[int] retained_release_count: The number of previous releases to retain on the channel for rollback or other
               purposes. Must be a number between 1-100. Defaults to 10 for new channels.
        :param pulumi.Input[str] site_id: Required. The ID of the site in which to create this channel.
        :param pulumi.Input[str] ttl: Input only. A time-to-live for this channel. Sets `expire_time` to the provided
               duration past the time of the request. A duration in seconds with up to nine fractional
               digits, terminated by 's'. Example: "86400s" (one day).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HostingChannelArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage
        ### Firebasehosting Channel Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_hosting_site = gcp.firebase.HostingSite("defaultHostingSite",
            project="my-project-name",
            site_id="site-with-channel",
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_hosting_channel = gcp.firebase.HostingChannel("defaultHostingChannel",
            site_id=default_hosting_site.site_id,
            channel_id="channel-basic",
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Firebasehosting Channel Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.firebase.HostingSite("default",
            project="my-project-name",
            site_id="site-with-channel",
            opts=pulumi.ResourceOptions(provider=google_beta))
        full = gcp.firebase.HostingChannel("full",
            site_id=default.site_id,
            channel_id="channel-full",
            ttl="86400s",
            retained_release_count=20,
            labels={
                "some-key": "some-value",
            },
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```

        ## Import

        Channel can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:firebase/hostingChannel:HostingChannel default sites/{{site_id}}/channels/{{channel_id}}
        ```

        ```sh
         $ pulumi import gcp:firebase/hostingChannel:HostingChannel default {{site_id}}/{{channel_id}}
        ```

        :param str resource_name: The name of the resource.
        :param HostingChannelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HostingChannelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 channel_id: Optional[pulumi.Input[str]] = None,
                 expire_time: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 retained_release_count: Optional[pulumi.Input[int]] = None,
                 site_id: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HostingChannelArgs.__new__(HostingChannelArgs)

            if channel_id is None and not opts.urn:
                raise TypeError("Missing required property 'channel_id'")
            __props__.__dict__["channel_id"] = channel_id
            __props__.__dict__["expire_time"] = expire_time
            __props__.__dict__["labels"] = labels
            __props__.__dict__["retained_release_count"] = retained_release_count
            if site_id is None and not opts.urn:
                raise TypeError("Missing required property 'site_id'")
            __props__.__dict__["site_id"] = site_id
            __props__.__dict__["ttl"] = ttl
            __props__.__dict__["name"] = None
        super(HostingChannel, __self__).__init__(
            'gcp:firebase/hostingChannel:HostingChannel',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            channel_id: Optional[pulumi.Input[str]] = None,
            expire_time: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            retained_release_count: Optional[pulumi.Input[int]] = None,
            site_id: Optional[pulumi.Input[str]] = None,
            ttl: Optional[pulumi.Input[str]] = None) -> 'HostingChannel':
        """
        Get an existing HostingChannel resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] channel_id: Required. Immutable. A unique ID within the site that identifies the channel.
               
               
               - - -
        :param pulumi.Input[str] expire_time: The time at which the channel will be automatically deleted. If null, the channel
               will not be automatically deleted. This field is present in the output whether it's
               set directly or via the `ttl` field.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Text labels used for extra metadata and/or filtering
        :param pulumi.Input[str] name: The fully-qualified resource name for the channel, in the format:
               sites/SITE_ID/channels/CHANNEL_ID
        :param pulumi.Input[int] retained_release_count: The number of previous releases to retain on the channel for rollback or other
               purposes. Must be a number between 1-100. Defaults to 10 for new channels.
        :param pulumi.Input[str] site_id: Required. The ID of the site in which to create this channel.
        :param pulumi.Input[str] ttl: Input only. A time-to-live for this channel. Sets `expire_time` to the provided
               duration past the time of the request. A duration in seconds with up to nine fractional
               digits, terminated by 's'. Example: "86400s" (one day).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HostingChannelState.__new__(_HostingChannelState)

        __props__.__dict__["channel_id"] = channel_id
        __props__.__dict__["expire_time"] = expire_time
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["retained_release_count"] = retained_release_count
        __props__.__dict__["site_id"] = site_id
        __props__.__dict__["ttl"] = ttl
        return HostingChannel(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="channelId")
    def channel_id(self) -> pulumi.Output[str]:
        """
        Required. Immutable. A unique ID within the site that identifies the channel.


        - - -
        """
        return pulumi.get(self, "channel_id")

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> pulumi.Output[str]:
        """
        The time at which the channel will be automatically deleted. If null, the channel
        will not be automatically deleted. This field is present in the output whether it's
        set directly or via the `ttl` field.
        """
        return pulumi.get(self, "expire_time")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Text labels used for extra metadata and/or filtering
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The fully-qualified resource name for the channel, in the format:
        sites/SITE_ID/channels/CHANNEL_ID
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="retainedReleaseCount")
    def retained_release_count(self) -> pulumi.Output[int]:
        """
        The number of previous releases to retain on the channel for rollback or other
        purposes. Must be a number between 1-100. Defaults to 10 for new channels.
        """
        return pulumi.get(self, "retained_release_count")

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Output[str]:
        """
        Required. The ID of the site in which to create this channel.
        """
        return pulumi.get(self, "site_id")

    @property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[Optional[str]]:
        """
        Input only. A time-to-live for this channel. Sets `expire_time` to the provided
        duration past the time of the request. A duration in seconds with up to nine fractional
        digits, terminated by 's'. Example: "86400s" (one day).
        """
        return pulumi.get(self, "ttl")

