# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['HostingVersionArgs', 'HostingVersion']

@pulumi.input_type
class HostingVersionArgs:
    def __init__(__self__, *,
                 site_id: pulumi.Input[str],
                 config: Optional[pulumi.Input['HostingVersionConfigArgs']] = None):
        """
        The set of arguments for constructing a HostingVersion resource.
        :param pulumi.Input[str] site_id: Required. The ID of the site in which to create this Version.
               
               
               - - -
        :param pulumi.Input['HostingVersionConfigArgs'] config: The configuration for the behavior of the site. This configuration exists in the `firebase.json` file.
               Structure is documented below.
        """
        pulumi.set(__self__, "site_id", site_id)
        if config is not None:
            pulumi.set(__self__, "config", config)

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Input[str]:
        """
        Required. The ID of the site in which to create this Version.


        - - -
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "site_id", value)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['HostingVersionConfigArgs']]:
        """
        The configuration for the behavior of the site. This configuration exists in the `firebase.json` file.
        Structure is documented below.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['HostingVersionConfigArgs']]):
        pulumi.set(self, "config", value)


@pulumi.input_type
class _HostingVersionState:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input['HostingVersionConfigArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 site_id: Optional[pulumi.Input[str]] = None,
                 version_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering HostingVersion resources.
        :param pulumi.Input['HostingVersionConfigArgs'] config: The configuration for the behavior of the site. This configuration exists in the `firebase.json` file.
               Structure is documented below.
        :param pulumi.Input[str] name: The fully-qualified resource name for the version, in the format:
               sites/SITE_ID/versions/VERSION_ID
        :param pulumi.Input[str] site_id: Required. The ID of the site in which to create this Version.
               
               
               - - -
        :param pulumi.Input[str] version_id: The ID for the version as in sites/SITE_ID/versions/VERSION_ID
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if site_id is not None:
            pulumi.set(__self__, "site_id", site_id)
        if version_id is not None:
            pulumi.set(__self__, "version_id", version_id)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['HostingVersionConfigArgs']]:
        """
        The configuration for the behavior of the site. This configuration exists in the `firebase.json` file.
        Structure is documented below.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['HostingVersionConfigArgs']]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The fully-qualified resource name for the version, in the format:
        sites/SITE_ID/versions/VERSION_ID
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The ID of the site in which to create this Version.


        - - -
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "site_id", value)

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID for the version as in sites/SITE_ID/versions/VERSION_ID
        """
        return pulumi.get(self, "version_id")

    @version_id.setter
    def version_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version_id", value)


class HostingVersion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[pulumi.InputType['HostingVersionConfigArgs']]] = None,
                 site_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage
        ### Firebasehosting Version Redirect

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_hosting_site = gcp.firebase.HostingSite("defaultHostingSite",
            project="my-project-name",
            site_id="site-id",
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_hosting_version = gcp.firebase.HostingVersion("defaultHostingVersion",
            site_id=default_hosting_site.site_id,
            config=gcp.firebase.HostingVersionConfigArgs(
                redirects=[gcp.firebase.HostingVersionConfigRedirectArgs(
                    glob="/google/**",
                    status_code=302,
                    location="https://www.google.com",
                )],
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_hosting_release = gcp.firebase.HostingRelease("defaultHostingRelease",
            site_id=default_hosting_site.site_id,
            version_name=default_hosting_version.name,
            message="Redirect to Google",
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Firebasehosting Version Cloud Run

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_hosting_site = gcp.firebase.HostingSite("defaultHostingSite",
            project="my-project-name",
            site_id="site-id",
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_service = gcp.cloudrunv2.Service("defaultService",
            project="my-project-name",
            location="us-central1",
            ingress="INGRESS_TRAFFIC_ALL",
            template=gcp.cloudrunv2.ServiceTemplateArgs(
                containers=[gcp.cloudrunv2.ServiceTemplateContainerArgs(
                    image="us-docker.pkg.dev/cloudrun/container/hello",
                )],
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_hosting_version = gcp.firebase.HostingVersion("defaultHostingVersion",
            site_id=default_hosting_site.site_id,
            config=gcp.firebase.HostingVersionConfigArgs(
                rewrites=[gcp.firebase.HostingVersionConfigRewriteArgs(
                    glob="/hello/**",
                    run=gcp.firebase.HostingVersionConfigRewriteRunArgs(
                        service_id=default_service.name,
                        region=default_service.location,
                    ),
                )],
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_hosting_release = gcp.firebase.HostingRelease("defaultHostingRelease",
            site_id=default_hosting_site.site_id,
            version_name=default_hosting_version.name,
            message="Cloud Run Integration",
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Firebasehosting Version Cloud Functions

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_hosting_site = gcp.firebase.HostingSite("defaultHostingSite",
            project="my-project-name",
            site_id="site-id",
            opts=pulumi.ResourceOptions(provider=google_beta))
        bucket = gcp.storage.Bucket("bucket",
            project="my-project-name",
            location="US",
            uniform_bucket_level_access=True,
            opts=pulumi.ResourceOptions(provider=google_beta))
        object = gcp.storage.BucketObject("object",
            bucket=bucket.name,
            source=pulumi.FileAsset("function-source.zip"),
            opts=pulumi.ResourceOptions(provider=google_beta))
        # Add path to the zipped function source code
        function = gcp.cloudfunctions.Function("function",
            project="my-project-name",
            description="A Cloud Function connected to Firebase Hosing",
            runtime="nodejs16",
            available_memory_mb=128,
            source_archive_bucket=bucket.name,
            source_archive_object=object.name,
            trigger_http=True,
            entry_point="helloHttp",
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_hosting_version = gcp.firebase.HostingVersion("defaultHostingVersion",
            site_id=default_hosting_site.site_id,
            config=gcp.firebase.HostingVersionConfigArgs(
                rewrites=[gcp.firebase.HostingVersionConfigRewriteArgs(
                    glob="/hello/**",
                    function=function.name,
                )],
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_hosting_release = gcp.firebase.HostingRelease("defaultHostingRelease",
            site_id=default_hosting_site.site_id,
            version_name=default_hosting_version.name,
            message="Cloud Functions Integration",
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```

        ## Import

        Version can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:firebase/hostingVersion:HostingVersion default sites/{{site_id}}/versions/{{version_id}}
        ```

        ```sh
         $ pulumi import gcp:firebase/hostingVersion:HostingVersion default {{site_id}}/{{version_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['HostingVersionConfigArgs']] config: The configuration for the behavior of the site. This configuration exists in the `firebase.json` file.
               Structure is documented below.
        :param pulumi.Input[str] site_id: Required. The ID of the site in which to create this Version.
               
               
               - - -
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HostingVersionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage
        ### Firebasehosting Version Redirect

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_hosting_site = gcp.firebase.HostingSite("defaultHostingSite",
            project="my-project-name",
            site_id="site-id",
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_hosting_version = gcp.firebase.HostingVersion("defaultHostingVersion",
            site_id=default_hosting_site.site_id,
            config=gcp.firebase.HostingVersionConfigArgs(
                redirects=[gcp.firebase.HostingVersionConfigRedirectArgs(
                    glob="/google/**",
                    status_code=302,
                    location="https://www.google.com",
                )],
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_hosting_release = gcp.firebase.HostingRelease("defaultHostingRelease",
            site_id=default_hosting_site.site_id,
            version_name=default_hosting_version.name,
            message="Redirect to Google",
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Firebasehosting Version Cloud Run

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_hosting_site = gcp.firebase.HostingSite("defaultHostingSite",
            project="my-project-name",
            site_id="site-id",
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_service = gcp.cloudrunv2.Service("defaultService",
            project="my-project-name",
            location="us-central1",
            ingress="INGRESS_TRAFFIC_ALL",
            template=gcp.cloudrunv2.ServiceTemplateArgs(
                containers=[gcp.cloudrunv2.ServiceTemplateContainerArgs(
                    image="us-docker.pkg.dev/cloudrun/container/hello",
                )],
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_hosting_version = gcp.firebase.HostingVersion("defaultHostingVersion",
            site_id=default_hosting_site.site_id,
            config=gcp.firebase.HostingVersionConfigArgs(
                rewrites=[gcp.firebase.HostingVersionConfigRewriteArgs(
                    glob="/hello/**",
                    run=gcp.firebase.HostingVersionConfigRewriteRunArgs(
                        service_id=default_service.name,
                        region=default_service.location,
                    ),
                )],
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_hosting_release = gcp.firebase.HostingRelease("defaultHostingRelease",
            site_id=default_hosting_site.site_id,
            version_name=default_hosting_version.name,
            message="Cloud Run Integration",
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Firebasehosting Version Cloud Functions

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_hosting_site = gcp.firebase.HostingSite("defaultHostingSite",
            project="my-project-name",
            site_id="site-id",
            opts=pulumi.ResourceOptions(provider=google_beta))
        bucket = gcp.storage.Bucket("bucket",
            project="my-project-name",
            location="US",
            uniform_bucket_level_access=True,
            opts=pulumi.ResourceOptions(provider=google_beta))
        object = gcp.storage.BucketObject("object",
            bucket=bucket.name,
            source=pulumi.FileAsset("function-source.zip"),
            opts=pulumi.ResourceOptions(provider=google_beta))
        # Add path to the zipped function source code
        function = gcp.cloudfunctions.Function("function",
            project="my-project-name",
            description="A Cloud Function connected to Firebase Hosing",
            runtime="nodejs16",
            available_memory_mb=128,
            source_archive_bucket=bucket.name,
            source_archive_object=object.name,
            trigger_http=True,
            entry_point="helloHttp",
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_hosting_version = gcp.firebase.HostingVersion("defaultHostingVersion",
            site_id=default_hosting_site.site_id,
            config=gcp.firebase.HostingVersionConfigArgs(
                rewrites=[gcp.firebase.HostingVersionConfigRewriteArgs(
                    glob="/hello/**",
                    function=function.name,
                )],
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_hosting_release = gcp.firebase.HostingRelease("defaultHostingRelease",
            site_id=default_hosting_site.site_id,
            version_name=default_hosting_version.name,
            message="Cloud Functions Integration",
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```

        ## Import

        Version can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:firebase/hostingVersion:HostingVersion default sites/{{site_id}}/versions/{{version_id}}
        ```

        ```sh
         $ pulumi import gcp:firebase/hostingVersion:HostingVersion default {{site_id}}/{{version_id}}
        ```

        :param str resource_name: The name of the resource.
        :param HostingVersionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HostingVersionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[pulumi.InputType['HostingVersionConfigArgs']]] = None,
                 site_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HostingVersionArgs.__new__(HostingVersionArgs)

            __props__.__dict__["config"] = config
            if site_id is None and not opts.urn:
                raise TypeError("Missing required property 'site_id'")
            __props__.__dict__["site_id"] = site_id
            __props__.__dict__["name"] = None
            __props__.__dict__["version_id"] = None
        super(HostingVersion, __self__).__init__(
            'gcp:firebase/hostingVersion:HostingVersion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config: Optional[pulumi.Input[pulumi.InputType['HostingVersionConfigArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            site_id: Optional[pulumi.Input[str]] = None,
            version_id: Optional[pulumi.Input[str]] = None) -> 'HostingVersion':
        """
        Get an existing HostingVersion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['HostingVersionConfigArgs']] config: The configuration for the behavior of the site. This configuration exists in the `firebase.json` file.
               Structure is documented below.
        :param pulumi.Input[str] name: The fully-qualified resource name for the version, in the format:
               sites/SITE_ID/versions/VERSION_ID
        :param pulumi.Input[str] site_id: Required. The ID of the site in which to create this Version.
               
               
               - - -
        :param pulumi.Input[str] version_id: The ID for the version as in sites/SITE_ID/versions/VERSION_ID
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HostingVersionState.__new__(_HostingVersionState)

        __props__.__dict__["config"] = config
        __props__.__dict__["name"] = name
        __props__.__dict__["site_id"] = site_id
        __props__.__dict__["version_id"] = version_id
        return HostingVersion(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def config(self) -> pulumi.Output[Optional['outputs.HostingVersionConfig']]:
        """
        The configuration for the behavior of the site. This configuration exists in the `firebase.json` file.
        Structure is documented below.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The fully-qualified resource name for the version, in the format:
        sites/SITE_ID/versions/VERSION_ID
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Output[str]:
        """
        Required. The ID of the site in which to create this Version.


        - - -
        """
        return pulumi.get(self, "site_id")

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> pulumi.Output[str]:
        """
        The ID for the version as in sites/SITE_ID/versions/VERSION_ID
        """
        return pulumi.get(self, "version_id")

