# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['DatabaseArgs', 'Database']

@pulumi.input_type
class DatabaseArgs:
    def __init__(__self__, *,
                 location_id: pulumi.Input[str],
                 type: pulumi.Input[str],
                 app_engine_integration_mode: Optional[pulumi.Input[str]] = None,
                 concurrency_mode: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Database resource.
        :param pulumi.Input[str] location_id: The location of the database. Available databases are listed at
               https://cloud.google.com/firestore/docs/locations.
        :param pulumi.Input[str] type: The type of the database.
               See https://cloud.google.com/datastore/docs/firestore-or-datastore
               for information about how to choose.
               Possible values are: `FIRESTORE_NATIVE`, `DATASTORE_MODE`.
               
               
               - - -
        :param pulumi.Input[str] app_engine_integration_mode: The App Engine integration mode to use for this database.
               Possible values are: `ENABLED`, `DISABLED`.
        :param pulumi.Input[str] concurrency_mode: The concurrency control mode to use for this database.
               Possible values are: `OPTIMISTIC`, `PESSIMISTIC`, `OPTIMISTIC_WITH_ENTITY_GROUPS`.
        :param pulumi.Input[str] name: The ID to use for the database, which will become the final
               component of the database's resource name. This value should be 4-63
               characters. Valid characters are /[a-z][0-9]-/ with first character
               a letter and the last a letter or a number. Must not be
               UUID-like /[0-9a-f]{8}(-[0-9a-f]{4}){3}-[0-9a-f]{12}/.
               "(default)" database id is also valid.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "location_id", location_id)
        pulumi.set(__self__, "type", type)
        if app_engine_integration_mode is not None:
            pulumi.set(__self__, "app_engine_integration_mode", app_engine_integration_mode)
        if concurrency_mode is not None:
            pulumi.set(__self__, "concurrency_mode", concurrency_mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="locationId")
    def location_id(self) -> pulumi.Input[str]:
        """
        The location of the database. Available databases are listed at
        https://cloud.google.com/firestore/docs/locations.
        """
        return pulumi.get(self, "location_id")

    @location_id.setter
    def location_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "location_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the database.
        See https://cloud.google.com/datastore/docs/firestore-or-datastore
        for information about how to choose.
        Possible values are: `FIRESTORE_NATIVE`, `DATASTORE_MODE`.


        - - -
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="appEngineIntegrationMode")
    def app_engine_integration_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The App Engine integration mode to use for this database.
        Possible values are: `ENABLED`, `DISABLED`.
        """
        return pulumi.get(self, "app_engine_integration_mode")

    @app_engine_integration_mode.setter
    def app_engine_integration_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_engine_integration_mode", value)

    @property
    @pulumi.getter(name="concurrencyMode")
    def concurrency_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The concurrency control mode to use for this database.
        Possible values are: `OPTIMISTIC`, `PESSIMISTIC`, `OPTIMISTIC_WITH_ENTITY_GROUPS`.
        """
        return pulumi.get(self, "concurrency_mode")

    @concurrency_mode.setter
    def concurrency_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "concurrency_mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The ID to use for the database, which will become the final
        component of the database's resource name. This value should be 4-63
        characters. Valid characters are /[a-z][0-9]-/ with first character
        a letter and the last a letter or a number. Must not be
        UUID-like /[0-9a-f]{8}(-[0-9a-f]{4}){3}-[0-9a-f]{12}/.
        "(default)" database id is also valid.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _DatabaseState:
    def __init__(__self__, *,
                 app_engine_integration_mode: Optional[pulumi.Input[str]] = None,
                 concurrency_mode: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 key_prefix: Optional[pulumi.Input[str]] = None,
                 location_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Database resources.
        :param pulumi.Input[str] app_engine_integration_mode: The App Engine integration mode to use for this database.
               Possible values are: `ENABLED`, `DISABLED`.
        :param pulumi.Input[str] concurrency_mode: The concurrency control mode to use for this database.
               Possible values are: `OPTIMISTIC`, `PESSIMISTIC`, `OPTIMISTIC_WITH_ENTITY_GROUPS`.
        :param pulumi.Input[str] create_time: The timestamp at which this database was created.
        :param pulumi.Input[str] etag: This checksum is computed by the server based on the value of other fields,
               and may be sent on update and delete requests to ensure the client has an
               up-to-date value before proceeding.
        :param pulumi.Input[str] key_prefix: Output only. The keyPrefix for this database.
               This keyPrefix is used, in combination with the project id ("~") to construct the application id
               that is returned from the Cloud Datastore APIs in Google App Engine first generation runtimes.
               This value may be empty in which case the appid to use for URL-encoded keys is the project_id (eg: foo instead of v~foo).
        :param pulumi.Input[str] location_id: The location of the database. Available databases are listed at
               https://cloud.google.com/firestore/docs/locations.
        :param pulumi.Input[str] name: The ID to use for the database, which will become the final
               component of the database's resource name. This value should be 4-63
               characters. Valid characters are /[a-z][0-9]-/ with first character
               a letter and the last a letter or a number. Must not be
               UUID-like /[0-9a-f]{8}(-[0-9a-f]{4}){3}-[0-9a-f]{12}/.
               "(default)" database id is also valid.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] type: The type of the database.
               See https://cloud.google.com/datastore/docs/firestore-or-datastore
               for information about how to choose.
               Possible values are: `FIRESTORE_NATIVE`, `DATASTORE_MODE`.
               
               
               - - -
        """
        if app_engine_integration_mode is not None:
            pulumi.set(__self__, "app_engine_integration_mode", app_engine_integration_mode)
        if concurrency_mode is not None:
            pulumi.set(__self__, "concurrency_mode", concurrency_mode)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if key_prefix is not None:
            pulumi.set(__self__, "key_prefix", key_prefix)
        if location_id is not None:
            pulumi.set(__self__, "location_id", location_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="appEngineIntegrationMode")
    def app_engine_integration_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The App Engine integration mode to use for this database.
        Possible values are: `ENABLED`, `DISABLED`.
        """
        return pulumi.get(self, "app_engine_integration_mode")

    @app_engine_integration_mode.setter
    def app_engine_integration_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_engine_integration_mode", value)

    @property
    @pulumi.getter(name="concurrencyMode")
    def concurrency_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The concurrency control mode to use for this database.
        Possible values are: `OPTIMISTIC`, `PESSIMISTIC`, `OPTIMISTIC_WITH_ENTITY_GROUPS`.
        """
        return pulumi.get(self, "concurrency_mode")

    @concurrency_mode.setter
    def concurrency_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "concurrency_mode", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp at which this database was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        This checksum is computed by the server based on the value of other fields,
        and may be sent on update and delete requests to ensure the client has an
        up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter(name="keyPrefix")
    def key_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. The keyPrefix for this database.
        This keyPrefix is used, in combination with the project id ("~") to construct the application id
        that is returned from the Cloud Datastore APIs in Google App Engine first generation runtimes.
        This value may be empty in which case the appid to use for URL-encoded keys is the project_id (eg: foo instead of v~foo).
        """
        return pulumi.get(self, "key_prefix")

    @key_prefix.setter
    def key_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_prefix", value)

    @property
    @pulumi.getter(name="locationId")
    def location_id(self) -> Optional[pulumi.Input[str]]:
        """
        The location of the database. Available databases are listed at
        https://cloud.google.com/firestore/docs/locations.
        """
        return pulumi.get(self, "location_id")

    @location_id.setter
    def location_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The ID to use for the database, which will become the final
        component of the database's resource name. This value should be 4-63
        characters. Valid characters are /[a-z][0-9]-/ with first character
        a letter and the last a letter or a number. Must not be
        UUID-like /[0-9a-f]{8}(-[0-9a-f]{4}){3}-[0-9a-f]{12}/.
        "(default)" database id is also valid.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the database.
        See https://cloud.google.com/datastore/docs/firestore-or-datastore
        for information about how to choose.
        Possible values are: `FIRESTORE_NATIVE`, `DATASTORE_MODE`.


        - - -
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class Database(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_engine_integration_mode: Optional[pulumi.Input[str]] = None,
                 concurrency_mode: Optional[pulumi.Input[str]] = None,
                 location_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        A Cloud Firestore Database.

        If you wish to use Firestore with App Engine, use the
        `appengine.Application`
        resource instead.

        To get more information about Database, see:

        * [API documentation](https://cloud.google.com/firestore/docs/reference/rest/v1/projects.databases)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/firestore/docs/)

        ## Example Usage
        ### Firestore Default Database

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        project = gcp.organizations.Project("project",
            project_id="my-project",
            org_id="123456789")
        wait60_seconds = time.index.Time_sleep("wait60Seconds", create_duration=60s,
        opts=pulumi.ResourceOptions(depends_on=[project]))
        firestore = gcp.projects.Service("firestore",
            project=project.project_id,
            service="firestore.googleapis.com",
            opts=pulumi.ResourceOptions(depends_on=[wait60_seconds]))
        database = gcp.firestore.Database("database",
            project=project.project_id,
            location_id="nam5",
            type="FIRESTORE_NATIVE",
            opts=pulumi.ResourceOptions(depends_on=[firestore]))
        ```
        ### Firestore Database

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        project = gcp.organizations.Project("project",
            project_id="my-project",
            org_id="123456789",
            billing_account="000000-0000000-0000000-000000")
        wait60_seconds = time.index.Time_sleep("wait60Seconds", create_duration=60s,
        opts=pulumi.ResourceOptions(depends_on=[project]))
        firestore = gcp.projects.Service("firestore",
            project=project.project_id,
            service="firestore.googleapis.com",
            opts=pulumi.ResourceOptions(depends_on=[wait60_seconds]))
        database = gcp.firestore.Database("database",
            project=project.project_id,
            location_id="nam5",
            type="FIRESTORE_NATIVE",
            concurrency_mode="OPTIMISTIC",
            app_engine_integration_mode="DISABLED",
            opts=pulumi.ResourceOptions(depends_on=[firestore]))
        ```
        ### Firestore Database In Datastore Mode

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        project = gcp.organizations.Project("project",
            project_id="my-project",
            org_id="123456789",
            billing_account="000000-0000000-0000000-000000")
        wait60_seconds = time.index.Time_sleep("wait60Seconds", create_duration=60s,
        opts=pulumi.ResourceOptions(depends_on=[project]))
        firestore = gcp.projects.Service("firestore",
            project=project.project_id,
            service="firestore.googleapis.com",
            opts=pulumi.ResourceOptions(depends_on=[wait60_seconds]))
        database = gcp.firestore.Database("database",
            project=project.project_id,
            location_id="nam5",
            type="DATASTORE_MODE",
            concurrency_mode="OPTIMISTIC",
            app_engine_integration_mode="DISABLED",
            opts=pulumi.ResourceOptions(depends_on=[firestore]))
        ```

        ## Import

        Database can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:firestore/database:Database default projects/{{project}}/databases/{{name}}
        ```

        ```sh
         $ pulumi import gcp:firestore/database:Database default {{project}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:firestore/database:Database default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] app_engine_integration_mode: The App Engine integration mode to use for this database.
               Possible values are: `ENABLED`, `DISABLED`.
        :param pulumi.Input[str] concurrency_mode: The concurrency control mode to use for this database.
               Possible values are: `OPTIMISTIC`, `PESSIMISTIC`, `OPTIMISTIC_WITH_ENTITY_GROUPS`.
        :param pulumi.Input[str] location_id: The location of the database. Available databases are listed at
               https://cloud.google.com/firestore/docs/locations.
        :param pulumi.Input[str] name: The ID to use for the database, which will become the final
               component of the database's resource name. This value should be 4-63
               characters. Valid characters are /[a-z][0-9]-/ with first character
               a letter and the last a letter or a number. Must not be
               UUID-like /[0-9a-f]{8}(-[0-9a-f]{4}){3}-[0-9a-f]{12}/.
               "(default)" database id is also valid.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] type: The type of the database.
               See https://cloud.google.com/datastore/docs/firestore-or-datastore
               for information about how to choose.
               Possible values are: `FIRESTORE_NATIVE`, `DATASTORE_MODE`.
               
               
               - - -
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatabaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Cloud Firestore Database.

        If you wish to use Firestore with App Engine, use the
        `appengine.Application`
        resource instead.

        To get more information about Database, see:

        * [API documentation](https://cloud.google.com/firestore/docs/reference/rest/v1/projects.databases)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/firestore/docs/)

        ## Example Usage
        ### Firestore Default Database

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        project = gcp.organizations.Project("project",
            project_id="my-project",
            org_id="123456789")
        wait60_seconds = time.index.Time_sleep("wait60Seconds", create_duration=60s,
        opts=pulumi.ResourceOptions(depends_on=[project]))
        firestore = gcp.projects.Service("firestore",
            project=project.project_id,
            service="firestore.googleapis.com",
            opts=pulumi.ResourceOptions(depends_on=[wait60_seconds]))
        database = gcp.firestore.Database("database",
            project=project.project_id,
            location_id="nam5",
            type="FIRESTORE_NATIVE",
            opts=pulumi.ResourceOptions(depends_on=[firestore]))
        ```
        ### Firestore Database

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        project = gcp.organizations.Project("project",
            project_id="my-project",
            org_id="123456789",
            billing_account="000000-0000000-0000000-000000")
        wait60_seconds = time.index.Time_sleep("wait60Seconds", create_duration=60s,
        opts=pulumi.ResourceOptions(depends_on=[project]))
        firestore = gcp.projects.Service("firestore",
            project=project.project_id,
            service="firestore.googleapis.com",
            opts=pulumi.ResourceOptions(depends_on=[wait60_seconds]))
        database = gcp.firestore.Database("database",
            project=project.project_id,
            location_id="nam5",
            type="FIRESTORE_NATIVE",
            concurrency_mode="OPTIMISTIC",
            app_engine_integration_mode="DISABLED",
            opts=pulumi.ResourceOptions(depends_on=[firestore]))
        ```
        ### Firestore Database In Datastore Mode

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        project = gcp.organizations.Project("project",
            project_id="my-project",
            org_id="123456789",
            billing_account="000000-0000000-0000000-000000")
        wait60_seconds = time.index.Time_sleep("wait60Seconds", create_duration=60s,
        opts=pulumi.ResourceOptions(depends_on=[project]))
        firestore = gcp.projects.Service("firestore",
            project=project.project_id,
            service="firestore.googleapis.com",
            opts=pulumi.ResourceOptions(depends_on=[wait60_seconds]))
        database = gcp.firestore.Database("database",
            project=project.project_id,
            location_id="nam5",
            type="DATASTORE_MODE",
            concurrency_mode="OPTIMISTIC",
            app_engine_integration_mode="DISABLED",
            opts=pulumi.ResourceOptions(depends_on=[firestore]))
        ```

        ## Import

        Database can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:firestore/database:Database default projects/{{project}}/databases/{{name}}
        ```

        ```sh
         $ pulumi import gcp:firestore/database:Database default {{project}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:firestore/database:Database default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param DatabaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_engine_integration_mode: Optional[pulumi.Input[str]] = None,
                 concurrency_mode: Optional[pulumi.Input[str]] = None,
                 location_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseArgs.__new__(DatabaseArgs)

            __props__.__dict__["app_engine_integration_mode"] = app_engine_integration_mode
            __props__.__dict__["concurrency_mode"] = concurrency_mode
            if location_id is None and not opts.urn:
                raise TypeError("Missing required property 'location_id'")
            __props__.__dict__["location_id"] = location_id
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["create_time"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["key_prefix"] = None
        super(Database, __self__).__init__(
            'gcp:firestore/database:Database',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_engine_integration_mode: Optional[pulumi.Input[str]] = None,
            concurrency_mode: Optional[pulumi.Input[str]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            etag: Optional[pulumi.Input[str]] = None,
            key_prefix: Optional[pulumi.Input[str]] = None,
            location_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'Database':
        """
        Get an existing Database resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] app_engine_integration_mode: The App Engine integration mode to use for this database.
               Possible values are: `ENABLED`, `DISABLED`.
        :param pulumi.Input[str] concurrency_mode: The concurrency control mode to use for this database.
               Possible values are: `OPTIMISTIC`, `PESSIMISTIC`, `OPTIMISTIC_WITH_ENTITY_GROUPS`.
        :param pulumi.Input[str] create_time: The timestamp at which this database was created.
        :param pulumi.Input[str] etag: This checksum is computed by the server based on the value of other fields,
               and may be sent on update and delete requests to ensure the client has an
               up-to-date value before proceeding.
        :param pulumi.Input[str] key_prefix: Output only. The keyPrefix for this database.
               This keyPrefix is used, in combination with the project id ("~") to construct the application id
               that is returned from the Cloud Datastore APIs in Google App Engine first generation runtimes.
               This value may be empty in which case the appid to use for URL-encoded keys is the project_id (eg: foo instead of v~foo).
        :param pulumi.Input[str] location_id: The location of the database. Available databases are listed at
               https://cloud.google.com/firestore/docs/locations.
        :param pulumi.Input[str] name: The ID to use for the database, which will become the final
               component of the database's resource name. This value should be 4-63
               characters. Valid characters are /[a-z][0-9]-/ with first character
               a letter and the last a letter or a number. Must not be
               UUID-like /[0-9a-f]{8}(-[0-9a-f]{4}){3}-[0-9a-f]{12}/.
               "(default)" database id is also valid.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] type: The type of the database.
               See https://cloud.google.com/datastore/docs/firestore-or-datastore
               for information about how to choose.
               Possible values are: `FIRESTORE_NATIVE`, `DATASTORE_MODE`.
               
               
               - - -
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabaseState.__new__(_DatabaseState)

        __props__.__dict__["app_engine_integration_mode"] = app_engine_integration_mode
        __props__.__dict__["concurrency_mode"] = concurrency_mode
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["etag"] = etag
        __props__.__dict__["key_prefix"] = key_prefix
        __props__.__dict__["location_id"] = location_id
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["type"] = type
        return Database(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="appEngineIntegrationMode")
    def app_engine_integration_mode(self) -> pulumi.Output[str]:
        """
        The App Engine integration mode to use for this database.
        Possible values are: `ENABLED`, `DISABLED`.
        """
        return pulumi.get(self, "app_engine_integration_mode")

    @property
    @pulumi.getter(name="concurrencyMode")
    def concurrency_mode(self) -> pulumi.Output[str]:
        """
        The concurrency control mode to use for this database.
        Possible values are: `OPTIMISTIC`, `PESSIMISTIC`, `OPTIMISTIC_WITH_ENTITY_GROUPS`.
        """
        return pulumi.get(self, "concurrency_mode")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The timestamp at which this database was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        """
        This checksum is computed by the server based on the value of other fields,
        and may be sent on update and delete requests to ensure the client has an
        up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="keyPrefix")
    def key_prefix(self) -> pulumi.Output[str]:
        """
        Output only. The keyPrefix for this database.
        This keyPrefix is used, in combination with the project id ("~") to construct the application id
        that is returned from the Cloud Datastore APIs in Google App Engine first generation runtimes.
        This value may be empty in which case the appid to use for URL-encoded keys is the project_id (eg: foo instead of v~foo).
        """
        return pulumi.get(self, "key_prefix")

    @property
    @pulumi.getter(name="locationId")
    def location_id(self) -> pulumi.Output[str]:
        """
        The location of the database. Available databases are listed at
        https://cloud.google.com/firestore/docs/locations.
        """
        return pulumi.get(self, "location_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The ID to use for the database, which will become the final
        component of the database's resource name. This value should be 4-63
        characters. Valid characters are /[a-z][0-9]-/ with first character
        a letter and the last a letter or a number. Must not be
        UUID-like /[0-9a-f]{8}(-[0-9a-f]{4}){3}-[0-9a-f]{12}/.
        "(default)" database id is also valid.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the database.
        See https://cloud.google.com/datastore/docs/firestore-or-datastore
        for information about how to choose.
        Possible values are: `FIRESTORE_NATIVE`, `DATASTORE_MODE`.


        - - -
        """
        return pulumi.get(self, "type")

