# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FieldArgs', 'Field']

@pulumi.input_type
class FieldArgs:
    def __init__(__self__, *,
                 collection: pulumi.Input[str],
                 field: pulumi.Input[str],
                 database: Optional[pulumi.Input[str]] = None,
                 index_config: Optional[pulumi.Input['FieldIndexConfigArgs']] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 ttl_config: Optional[pulumi.Input['FieldTtlConfigArgs']] = None):
        """
        The set of arguments for constructing a Field resource.
        :param pulumi.Input[str] collection: The id of the collection group to configure.
        :param pulumi.Input[str] field: The id of the field to configure.
               
               
               - - -
        :param pulumi.Input[str] database: The Firestore database id. Defaults to `"(default)"`.
        :param pulumi.Input['FieldIndexConfigArgs'] index_config: The single field index configuration for this field.
               Creating an index configuration for this field will override any inherited configuration with the
               indexes specified. Configuring the index configuration with an empty block disables all indexes on
               the field.
               Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['FieldTtlConfigArgs'] ttl_config: If set, this field is configured for TTL deletion.
               Structure is documented below.
        """
        pulumi.set(__self__, "collection", collection)
        pulumi.set(__self__, "field", field)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if index_config is not None:
            pulumi.set(__self__, "index_config", index_config)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if ttl_config is not None:
            pulumi.set(__self__, "ttl_config", ttl_config)

    @property
    @pulumi.getter
    def collection(self) -> pulumi.Input[str]:
        """
        The id of the collection group to configure.
        """
        return pulumi.get(self, "collection")

    @collection.setter
    def collection(self, value: pulumi.Input[str]):
        pulumi.set(self, "collection", value)

    @property
    @pulumi.getter
    def field(self) -> pulumi.Input[str]:
        """
        The id of the field to configure.


        - - -
        """
        return pulumi.get(self, "field")

    @field.setter
    def field(self, value: pulumi.Input[str]):
        pulumi.set(self, "field", value)

    @property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[str]]:
        """
        The Firestore database id. Defaults to `"(default)"`.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter(name="indexConfig")
    def index_config(self) -> Optional[pulumi.Input['FieldIndexConfigArgs']]:
        """
        The single field index configuration for this field.
        Creating an index configuration for this field will override any inherited configuration with the
        indexes specified. Configuring the index configuration with an empty block disables all indexes on
        the field.
        Structure is documented below.
        """
        return pulumi.get(self, "index_config")

    @index_config.setter
    def index_config(self, value: Optional[pulumi.Input['FieldIndexConfigArgs']]):
        pulumi.set(self, "index_config", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="ttlConfig")
    def ttl_config(self) -> Optional[pulumi.Input['FieldTtlConfigArgs']]:
        """
        If set, this field is configured for TTL deletion.
        Structure is documented below.
        """
        return pulumi.get(self, "ttl_config")

    @ttl_config.setter
    def ttl_config(self, value: Optional[pulumi.Input['FieldTtlConfigArgs']]):
        pulumi.set(self, "ttl_config", value)


@pulumi.input_type
class _FieldState:
    def __init__(__self__, *,
                 collection: Optional[pulumi.Input[str]] = None,
                 database: Optional[pulumi.Input[str]] = None,
                 field: Optional[pulumi.Input[str]] = None,
                 index_config: Optional[pulumi.Input['FieldIndexConfigArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 ttl_config: Optional[pulumi.Input['FieldTtlConfigArgs']] = None):
        """
        Input properties used for looking up and filtering Field resources.
        :param pulumi.Input[str] collection: The id of the collection group to configure.
        :param pulumi.Input[str] database: The Firestore database id. Defaults to `"(default)"`.
        :param pulumi.Input[str] field: The id of the field to configure.
               
               
               - - -
        :param pulumi.Input['FieldIndexConfigArgs'] index_config: The single field index configuration for this field.
               Creating an index configuration for this field will override any inherited configuration with the
               indexes specified. Configuring the index configuration with an empty block disables all indexes on
               the field.
               Structure is documented below.
        :param pulumi.Input[str] name: The name of this field. Format:
               `projects/{{project}}/databases/{{database}}/collectionGroups/{{collection}}/fields/{{field}}`
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['FieldTtlConfigArgs'] ttl_config: If set, this field is configured for TTL deletion.
               Structure is documented below.
        """
        if collection is not None:
            pulumi.set(__self__, "collection", collection)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if field is not None:
            pulumi.set(__self__, "field", field)
        if index_config is not None:
            pulumi.set(__self__, "index_config", index_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if ttl_config is not None:
            pulumi.set(__self__, "ttl_config", ttl_config)

    @property
    @pulumi.getter
    def collection(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the collection group to configure.
        """
        return pulumi.get(self, "collection")

    @collection.setter
    def collection(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "collection", value)

    @property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[str]]:
        """
        The Firestore database id. Defaults to `"(default)"`.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter
    def field(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the field to configure.


        - - -
        """
        return pulumi.get(self, "field")

    @field.setter
    def field(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field", value)

    @property
    @pulumi.getter(name="indexConfig")
    def index_config(self) -> Optional[pulumi.Input['FieldIndexConfigArgs']]:
        """
        The single field index configuration for this field.
        Creating an index configuration for this field will override any inherited configuration with the
        indexes specified. Configuring the index configuration with an empty block disables all indexes on
        the field.
        Structure is documented below.
        """
        return pulumi.get(self, "index_config")

    @index_config.setter
    def index_config(self, value: Optional[pulumi.Input['FieldIndexConfigArgs']]):
        pulumi.set(self, "index_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of this field. Format:
        `projects/{{project}}/databases/{{database}}/collectionGroups/{{collection}}/fields/{{field}}`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="ttlConfig")
    def ttl_config(self) -> Optional[pulumi.Input['FieldTtlConfigArgs']]:
        """
        If set, this field is configured for TTL deletion.
        Structure is documented below.
        """
        return pulumi.get(self, "ttl_config")

    @ttl_config.setter
    def ttl_config(self, value: Optional[pulumi.Input['FieldTtlConfigArgs']]):
        pulumi.set(self, "ttl_config", value)


class Field(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 collection: Optional[pulumi.Input[str]] = None,
                 database: Optional[pulumi.Input[str]] = None,
                 field: Optional[pulumi.Input[str]] = None,
                 index_config: Optional[pulumi.Input[pulumi.InputType['FieldIndexConfigArgs']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 ttl_config: Optional[pulumi.Input[pulumi.InputType['FieldTtlConfigArgs']]] = None,
                 __props__=None):
        """
        Represents a single field in the database.
        Fields are grouped by their "Collection Group", which represent all collections
        in the database with the same id.

        To get more information about Field, see:

        * [API documentation](https://cloud.google.com/firestore/docs/reference/rest/v1/projects.databases.collectionGroups.fields)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/firestore/docs/query-data/indexing)

        > **Warning:** This resource creates a Firestore Single Field override on a project that
         already has a Firestore database. If you haven't already created it, you may
        create a `firestore.Database` resource with `location_id` set to your
        chosen location.

        ## Example Usage
        ### Firestore Field Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.firestore.Field("basic",
            collection="chatrooms_%{random_suffix}",
            database="(default)",
            field="basic",
            index_config=gcp.firestore.FieldIndexConfigArgs(
                indexes=[
                    gcp.firestore.FieldIndexConfigIndexArgs(
                        order="ASCENDING",
                        query_scope="COLLECTION_GROUP",
                    ),
                    gcp.firestore.FieldIndexConfigIndexArgs(
                        array_config="CONTAINS",
                    ),
                ],
            ),
            project="my-project-name",
            ttl_config=gcp.firestore.FieldTtlConfigArgs())
        ```
        ### Firestore Field Timestamp

        ```python
        import pulumi
        import pulumi_gcp as gcp

        timestamp = gcp.firestore.Field("timestamp",
            collection="chatrooms_%{random_suffix}",
            field="timestamp",
            index_config=gcp.firestore.FieldIndexConfigArgs(),
            project="my-project-name",
            ttl_config=gcp.firestore.FieldTtlConfigArgs())
        ```
        ### Firestore Field Match Override

        ```python
        import pulumi
        import pulumi_gcp as gcp

        match_override = gcp.firestore.Field("matchOverride",
            collection="chatrooms_%{random_suffix}",
            field="field_with_same_configuration_as_ancestor",
            index_config=gcp.firestore.FieldIndexConfigArgs(
                indexes=[
                    gcp.firestore.FieldIndexConfigIndexArgs(
                        order="ASCENDING",
                    ),
                    gcp.firestore.FieldIndexConfigIndexArgs(
                        order="DESCENDING",
                    ),
                    gcp.firestore.FieldIndexConfigIndexArgs(
                        array_config="CONTAINS",
                    ),
                ],
            ),
            project="my-project-name")
        ```

        ## Import

        Field can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:firestore/field:Field default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] collection: The id of the collection group to configure.
        :param pulumi.Input[str] database: The Firestore database id. Defaults to `"(default)"`.
        :param pulumi.Input[str] field: The id of the field to configure.
               
               
               - - -
        :param pulumi.Input[pulumi.InputType['FieldIndexConfigArgs']] index_config: The single field index configuration for this field.
               Creating an index configuration for this field will override any inherited configuration with the
               indexes specified. Configuring the index configuration with an empty block disables all indexes on
               the field.
               Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[pulumi.InputType['FieldTtlConfigArgs']] ttl_config: If set, this field is configured for TTL deletion.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FieldArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a single field in the database.
        Fields are grouped by their "Collection Group", which represent all collections
        in the database with the same id.

        To get more information about Field, see:

        * [API documentation](https://cloud.google.com/firestore/docs/reference/rest/v1/projects.databases.collectionGroups.fields)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/firestore/docs/query-data/indexing)

        > **Warning:** This resource creates a Firestore Single Field override on a project that
         already has a Firestore database. If you haven't already created it, you may
        create a `firestore.Database` resource with `location_id` set to your
        chosen location.

        ## Example Usage
        ### Firestore Field Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.firestore.Field("basic",
            collection="chatrooms_%{random_suffix}",
            database="(default)",
            field="basic",
            index_config=gcp.firestore.FieldIndexConfigArgs(
                indexes=[
                    gcp.firestore.FieldIndexConfigIndexArgs(
                        order="ASCENDING",
                        query_scope="COLLECTION_GROUP",
                    ),
                    gcp.firestore.FieldIndexConfigIndexArgs(
                        array_config="CONTAINS",
                    ),
                ],
            ),
            project="my-project-name",
            ttl_config=gcp.firestore.FieldTtlConfigArgs())
        ```
        ### Firestore Field Timestamp

        ```python
        import pulumi
        import pulumi_gcp as gcp

        timestamp = gcp.firestore.Field("timestamp",
            collection="chatrooms_%{random_suffix}",
            field="timestamp",
            index_config=gcp.firestore.FieldIndexConfigArgs(),
            project="my-project-name",
            ttl_config=gcp.firestore.FieldTtlConfigArgs())
        ```
        ### Firestore Field Match Override

        ```python
        import pulumi
        import pulumi_gcp as gcp

        match_override = gcp.firestore.Field("matchOverride",
            collection="chatrooms_%{random_suffix}",
            field="field_with_same_configuration_as_ancestor",
            index_config=gcp.firestore.FieldIndexConfigArgs(
                indexes=[
                    gcp.firestore.FieldIndexConfigIndexArgs(
                        order="ASCENDING",
                    ),
                    gcp.firestore.FieldIndexConfigIndexArgs(
                        order="DESCENDING",
                    ),
                    gcp.firestore.FieldIndexConfigIndexArgs(
                        array_config="CONTAINS",
                    ),
                ],
            ),
            project="my-project-name")
        ```

        ## Import

        Field can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:firestore/field:Field default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param FieldArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FieldArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 collection: Optional[pulumi.Input[str]] = None,
                 database: Optional[pulumi.Input[str]] = None,
                 field: Optional[pulumi.Input[str]] = None,
                 index_config: Optional[pulumi.Input[pulumi.InputType['FieldIndexConfigArgs']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 ttl_config: Optional[pulumi.Input[pulumi.InputType['FieldTtlConfigArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FieldArgs.__new__(FieldArgs)

            if collection is None and not opts.urn:
                raise TypeError("Missing required property 'collection'")
            __props__.__dict__["collection"] = collection
            __props__.__dict__["database"] = database
            if field is None and not opts.urn:
                raise TypeError("Missing required property 'field'")
            __props__.__dict__["field"] = field
            __props__.__dict__["index_config"] = index_config
            __props__.__dict__["project"] = project
            __props__.__dict__["ttl_config"] = ttl_config
            __props__.__dict__["name"] = None
        super(Field, __self__).__init__(
            'gcp:firestore/field:Field',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            collection: Optional[pulumi.Input[str]] = None,
            database: Optional[pulumi.Input[str]] = None,
            field: Optional[pulumi.Input[str]] = None,
            index_config: Optional[pulumi.Input[pulumi.InputType['FieldIndexConfigArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            ttl_config: Optional[pulumi.Input[pulumi.InputType['FieldTtlConfigArgs']]] = None) -> 'Field':
        """
        Get an existing Field resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] collection: The id of the collection group to configure.
        :param pulumi.Input[str] database: The Firestore database id. Defaults to `"(default)"`.
        :param pulumi.Input[str] field: The id of the field to configure.
               
               
               - - -
        :param pulumi.Input[pulumi.InputType['FieldIndexConfigArgs']] index_config: The single field index configuration for this field.
               Creating an index configuration for this field will override any inherited configuration with the
               indexes specified. Configuring the index configuration with an empty block disables all indexes on
               the field.
               Structure is documented below.
        :param pulumi.Input[str] name: The name of this field. Format:
               `projects/{{project}}/databases/{{database}}/collectionGroups/{{collection}}/fields/{{field}}`
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[pulumi.InputType['FieldTtlConfigArgs']] ttl_config: If set, this field is configured for TTL deletion.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FieldState.__new__(_FieldState)

        __props__.__dict__["collection"] = collection
        __props__.__dict__["database"] = database
        __props__.__dict__["field"] = field
        __props__.__dict__["index_config"] = index_config
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["ttl_config"] = ttl_config
        return Field(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def collection(self) -> pulumi.Output[str]:
        """
        The id of the collection group to configure.
        """
        return pulumi.get(self, "collection")

    @property
    @pulumi.getter
    def database(self) -> pulumi.Output[Optional[str]]:
        """
        The Firestore database id. Defaults to `"(default)"`.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def field(self) -> pulumi.Output[str]:
        """
        The id of the field to configure.


        - - -
        """
        return pulumi.get(self, "field")

    @property
    @pulumi.getter(name="indexConfig")
    def index_config(self) -> pulumi.Output[Optional['outputs.FieldIndexConfig']]:
        """
        The single field index configuration for this field.
        Creating an index configuration for this field will override any inherited configuration with the
        indexes specified. Configuring the index configuration with an empty block disables all indexes on
        the field.
        Structure is documented below.
        """
        return pulumi.get(self, "index_config")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of this field. Format:
        `projects/{{project}}/databases/{{database}}/collectionGroups/{{collection}}/fields/{{field}}`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="ttlConfig")
    def ttl_config(self) -> pulumi.Output[Optional['outputs.FieldTtlConfig']]:
        """
        If set, this field is configured for TTL deletion.
        Structure is documented below.
        """
        return pulumi.get(self, "ttl_config")

