# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FeatureArgs', 'Feature']

@pulumi.input_type
class FeatureArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[str],
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 spec: Optional[pulumi.Input['FeatureSpecArgs']] = None):
        """
        The set of arguments for constructing a Feature resource.
        :param pulumi.Input[str] location: The location for the resource
               
               
               - - -
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: GCP labels for this Feature.
        :param pulumi.Input[str] name: The full, unique name of this Feature resource
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['FeatureSpecArgs'] spec: Optional. Hub-wide Feature configuration. If this Feature does not support any Hub-wide configuration, this field may be unused.
               Structure is documented below.
        """
        pulumi.set(__self__, "location", location)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        The location for the resource


        - - -
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        GCP labels for this Feature.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The full, unique name of this Feature resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input['FeatureSpecArgs']]:
        """
        Optional. Hub-wide Feature configuration. If this Feature does not support any Hub-wide configuration, this field may be unused.
        Structure is documented below.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input['FeatureSpecArgs']]):
        pulumi.set(self, "spec", value)


@pulumi.input_type
class _FeatureState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[str]] = None,
                 delete_time: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 resource_states: Optional[pulumi.Input[Sequence[pulumi.Input['FeatureResourceStateArgs']]]] = None,
                 spec: Optional[pulumi.Input['FeatureSpecArgs']] = None,
                 states: Optional[pulumi.Input[Sequence[pulumi.Input['FeatureStateArgs']]]] = None,
                 update_time: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Feature resources.
        :param pulumi.Input[str] create_time: Output only. When the Feature resource was created.
        :param pulumi.Input[str] delete_time: Output only. When the Feature resource was deleted.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: GCP labels for this Feature.
        :param pulumi.Input[str] location: The location for the resource
               
               
               - - -
        :param pulumi.Input[str] name: The full, unique name of this Feature resource
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input['FeatureResourceStateArgs']]] resource_states: State of the Feature resource itself.
               Structure is documented below.
        :param pulumi.Input['FeatureSpecArgs'] spec: Optional. Hub-wide Feature configuration. If this Feature does not support any Hub-wide configuration, this field may be unused.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['FeatureStateArgs']]] states: (Output)
               Output only. The "running state" of the Feature in this Hub.
               Structure is documented below.
        :param pulumi.Input[str] update_time: (Output)
               The time this status and any related Feature-specific details were updated. A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z"
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if delete_time is not None:
            pulumi.set(__self__, "delete_time", delete_time)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if resource_states is not None:
            pulumi.set(__self__, "resource_states", resource_states)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if states is not None:
            pulumi.set(__self__, "states", states)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. When the Feature resource was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. When the Feature resource was deleted.
        """
        return pulumi.get(self, "delete_time")

    @delete_time.setter
    def delete_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delete_time", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        GCP labels for this Feature.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location for the resource


        - - -
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The full, unique name of this Feature resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="resourceStates")
    def resource_states(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FeatureResourceStateArgs']]]]:
        """
        State of the Feature resource itself.
        Structure is documented below.
        """
        return pulumi.get(self, "resource_states")

    @resource_states.setter
    def resource_states(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FeatureResourceStateArgs']]]]):
        pulumi.set(self, "resource_states", value)

    @property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input['FeatureSpecArgs']]:
        """
        Optional. Hub-wide Feature configuration. If this Feature does not support any Hub-wide configuration, this field may be unused.
        Structure is documented below.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input['FeatureSpecArgs']]):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter
    def states(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FeatureStateArgs']]]]:
        """
        (Output)
        Output only. The "running state" of the Feature in this Hub.
        Structure is documented below.
        """
        return pulumi.get(self, "states")

    @states.setter
    def states(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FeatureStateArgs']]]]):
        pulumi.set(self, "states", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        The time this status and any related Feature-specific details were updated. A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z"
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)


class Feature(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 spec: Optional[pulumi.Input[pulumi.InputType['FeatureSpecArgs']]] = None,
                 __props__=None):
        """
        Feature represents the settings and status of any Hub Feature.

        To get more information about Feature, see:

        * [API documentation](https://cloud.google.com/anthos/fleet-management/docs/reference/rest/v1/projects.locations.features)
        * How-to Guides
            * [Registering a Cluster](https://cloud.google.com/anthos/multicluster-management/connect/registering-a-cluster#register_cluster)

        ## Example Usage
        ### Gkehub Feature Multi Cluster Ingress

        ```python
        import pulumi
        import pulumi_gcp as gcp

        cluster = gcp.container.Cluster("cluster",
            location="us-central1-a",
            initial_node_count=1)
        membership = gcp.gkehub.Membership("membership",
            membership_id="my-membership",
            endpoint=gcp.gkehub.MembershipEndpointArgs(
                gke_cluster=gcp.gkehub.MembershipEndpointGkeClusterArgs(
                    resource_link=cluster.id.apply(lambda id: f"//container.googleapis.com/{id}"),
                ),
            ),
            description="Membership")
        feature = gcp.gkehub.Feature("feature",
            location="global",
            spec=gcp.gkehub.FeatureSpecArgs(
                multiclusteringress=gcp.gkehub.FeatureSpecMulticlusteringressArgs(
                    config_membership=membership.id,
                ),
            ))
        ```
        ### Gkehub Feature Multi Cluster Service Discovery

        ```python
        import pulumi
        import pulumi_gcp as gcp

        feature = gcp.gkehub.Feature("feature",
            labels={
                "foo": "bar",
            },
            location="global")
        ```
        ### Gkehub Feature Anthos Service Mesh

        ```python
        import pulumi
        import pulumi_gcp as gcp

        feature = gcp.gkehub.Feature("feature", location="global")
        ```
        ### Enable Fleet Observability For Default Logs With Copy

        ```python
        import pulumi
        import pulumi_gcp as gcp

        feature = gcp.gkehub.Feature("feature",
            location="global",
            spec=gcp.gkehub.FeatureSpecArgs(
                fleetobservability=gcp.gkehub.FeatureSpecFleetobservabilityArgs(
                    logging_config=gcp.gkehub.FeatureSpecFleetobservabilityLoggingConfigArgs(
                        default_config=gcp.gkehub.FeatureSpecFleetobservabilityLoggingConfigDefaultConfigArgs(
                            mode="COPY",
                        ),
                    ),
                ),
            ))
        ```
        ### Enable Fleet Observability For Scope Logs With Move

        ```python
        import pulumi
        import pulumi_gcp as gcp

        feature = gcp.gkehub.Feature("feature",
            location="global",
            spec=gcp.gkehub.FeatureSpecArgs(
                fleetobservability=gcp.gkehub.FeatureSpecFleetobservabilityArgs(
                    logging_config=gcp.gkehub.FeatureSpecFleetobservabilityLoggingConfigArgs(
                        fleet_scope_logs_config=gcp.gkehub.FeatureSpecFleetobservabilityLoggingConfigFleetScopeLogsConfigArgs(
                            mode="MOVE",
                        ),
                    ),
                ),
            ))
        ```
        ### Enable Fleet Observability For Both Default And Scope Logs

        ```python
        import pulumi
        import pulumi_gcp as gcp

        feature = gcp.gkehub.Feature("feature",
            location="global",
            spec=gcp.gkehub.FeatureSpecArgs(
                fleetobservability=gcp.gkehub.FeatureSpecFleetobservabilityArgs(
                    logging_config=gcp.gkehub.FeatureSpecFleetobservabilityLoggingConfigArgs(
                        default_config=gcp.gkehub.FeatureSpecFleetobservabilityLoggingConfigDefaultConfigArgs(
                            mode="COPY",
                        ),
                        fleet_scope_logs_config=gcp.gkehub.FeatureSpecFleetobservabilityLoggingConfigFleetScopeLogsConfigArgs(
                            mode="MOVE",
                        ),
                    ),
                ),
            ))
        ```

        ## Import

        Feature can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:gkehub/feature:Feature default projects/{{project}}/locations/{{location}}/features/{{name}}
        ```

        ```sh
         $ pulumi import gcp:gkehub/feature:Feature default {{project}}/{{location}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:gkehub/feature:Feature default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: GCP labels for this Feature.
        :param pulumi.Input[str] location: The location for the resource
               
               
               - - -
        :param pulumi.Input[str] name: The full, unique name of this Feature resource
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[pulumi.InputType['FeatureSpecArgs']] spec: Optional. Hub-wide Feature configuration. If this Feature does not support any Hub-wide configuration, this field may be unused.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FeatureArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Feature represents the settings and status of any Hub Feature.

        To get more information about Feature, see:

        * [API documentation](https://cloud.google.com/anthos/fleet-management/docs/reference/rest/v1/projects.locations.features)
        * How-to Guides
            * [Registering a Cluster](https://cloud.google.com/anthos/multicluster-management/connect/registering-a-cluster#register_cluster)

        ## Example Usage
        ### Gkehub Feature Multi Cluster Ingress

        ```python
        import pulumi
        import pulumi_gcp as gcp

        cluster = gcp.container.Cluster("cluster",
            location="us-central1-a",
            initial_node_count=1)
        membership = gcp.gkehub.Membership("membership",
            membership_id="my-membership",
            endpoint=gcp.gkehub.MembershipEndpointArgs(
                gke_cluster=gcp.gkehub.MembershipEndpointGkeClusterArgs(
                    resource_link=cluster.id.apply(lambda id: f"//container.googleapis.com/{id}"),
                ),
            ),
            description="Membership")
        feature = gcp.gkehub.Feature("feature",
            location="global",
            spec=gcp.gkehub.FeatureSpecArgs(
                multiclusteringress=gcp.gkehub.FeatureSpecMulticlusteringressArgs(
                    config_membership=membership.id,
                ),
            ))
        ```
        ### Gkehub Feature Multi Cluster Service Discovery

        ```python
        import pulumi
        import pulumi_gcp as gcp

        feature = gcp.gkehub.Feature("feature",
            labels={
                "foo": "bar",
            },
            location="global")
        ```
        ### Gkehub Feature Anthos Service Mesh

        ```python
        import pulumi
        import pulumi_gcp as gcp

        feature = gcp.gkehub.Feature("feature", location="global")
        ```
        ### Enable Fleet Observability For Default Logs With Copy

        ```python
        import pulumi
        import pulumi_gcp as gcp

        feature = gcp.gkehub.Feature("feature",
            location="global",
            spec=gcp.gkehub.FeatureSpecArgs(
                fleetobservability=gcp.gkehub.FeatureSpecFleetobservabilityArgs(
                    logging_config=gcp.gkehub.FeatureSpecFleetobservabilityLoggingConfigArgs(
                        default_config=gcp.gkehub.FeatureSpecFleetobservabilityLoggingConfigDefaultConfigArgs(
                            mode="COPY",
                        ),
                    ),
                ),
            ))
        ```
        ### Enable Fleet Observability For Scope Logs With Move

        ```python
        import pulumi
        import pulumi_gcp as gcp

        feature = gcp.gkehub.Feature("feature",
            location="global",
            spec=gcp.gkehub.FeatureSpecArgs(
                fleetobservability=gcp.gkehub.FeatureSpecFleetobservabilityArgs(
                    logging_config=gcp.gkehub.FeatureSpecFleetobservabilityLoggingConfigArgs(
                        fleet_scope_logs_config=gcp.gkehub.FeatureSpecFleetobservabilityLoggingConfigFleetScopeLogsConfigArgs(
                            mode="MOVE",
                        ),
                    ),
                ),
            ))
        ```
        ### Enable Fleet Observability For Both Default And Scope Logs

        ```python
        import pulumi
        import pulumi_gcp as gcp

        feature = gcp.gkehub.Feature("feature",
            location="global",
            spec=gcp.gkehub.FeatureSpecArgs(
                fleetobservability=gcp.gkehub.FeatureSpecFleetobservabilityArgs(
                    logging_config=gcp.gkehub.FeatureSpecFleetobservabilityLoggingConfigArgs(
                        default_config=gcp.gkehub.FeatureSpecFleetobservabilityLoggingConfigDefaultConfigArgs(
                            mode="COPY",
                        ),
                        fleet_scope_logs_config=gcp.gkehub.FeatureSpecFleetobservabilityLoggingConfigFleetScopeLogsConfigArgs(
                            mode="MOVE",
                        ),
                    ),
                ),
            ))
        ```

        ## Import

        Feature can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:gkehub/feature:Feature default projects/{{project}}/locations/{{location}}/features/{{name}}
        ```

        ```sh
         $ pulumi import gcp:gkehub/feature:Feature default {{project}}/{{location}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:gkehub/feature:Feature default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param FeatureArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FeatureArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 spec: Optional[pulumi.Input[pulumi.InputType['FeatureSpecArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FeatureArgs.__new__(FeatureArgs)

            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["spec"] = spec
            __props__.__dict__["create_time"] = None
            __props__.__dict__["delete_time"] = None
            __props__.__dict__["resource_states"] = None
            __props__.__dict__["states"] = None
            __props__.__dict__["update_time"] = None
        super(Feature, __self__).__init__(
            'gcp:gkehub/feature:Feature',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            delete_time: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            location: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            resource_states: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FeatureResourceStateArgs']]]]] = None,
            spec: Optional[pulumi.Input[pulumi.InputType['FeatureSpecArgs']]] = None,
            states: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FeatureStateArgs']]]]] = None,
            update_time: Optional[pulumi.Input[str]] = None) -> 'Feature':
        """
        Get an existing Feature resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] create_time: Output only. When the Feature resource was created.
        :param pulumi.Input[str] delete_time: Output only. When the Feature resource was deleted.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: GCP labels for this Feature.
        :param pulumi.Input[str] location: The location for the resource
               
               
               - - -
        :param pulumi.Input[str] name: The full, unique name of this Feature resource
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FeatureResourceStateArgs']]]] resource_states: State of the Feature resource itself.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['FeatureSpecArgs']] spec: Optional. Hub-wide Feature configuration. If this Feature does not support any Hub-wide configuration, this field may be unused.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FeatureStateArgs']]]] states: (Output)
               Output only. The "running state" of the Feature in this Hub.
               Structure is documented below.
        :param pulumi.Input[str] update_time: (Output)
               The time this status and any related Feature-specific details were updated. A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z"
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FeatureState.__new__(_FeatureState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["delete_time"] = delete_time
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["resource_states"] = resource_states
        __props__.__dict__["spec"] = spec
        __props__.__dict__["states"] = states
        __props__.__dict__["update_time"] = update_time
        return Feature(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Output only. When the Feature resource was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> pulumi.Output[str]:
        """
        Output only. When the Feature resource was deleted.
        """
        return pulumi.get(self, "delete_time")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        GCP labels for this Feature.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The location for the resource


        - - -
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The full, unique name of this Feature resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="resourceStates")
    def resource_states(self) -> pulumi.Output[Sequence['outputs.FeatureResourceState']]:
        """
        State of the Feature resource itself.
        Structure is documented below.
        """
        return pulumi.get(self, "resource_states")

    @property
    @pulumi.getter
    def spec(self) -> pulumi.Output[Optional['outputs.FeatureSpec']]:
        """
        Optional. Hub-wide Feature configuration. If this Feature does not support any Hub-wide configuration, this field may be unused.
        Structure is documented below.
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter
    def states(self) -> pulumi.Output[Sequence['outputs.FeatureState']]:
        """
        (Output)
        Output only. The "running state" of the Feature in this Hub.
        Structure is documented below.
        """
        return pulumi.get(self, "states")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        (Output)
        The time this status and any related Feature-specific details were updated. A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z"
        """
        return pulumi.get(self, "update_time")

