# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BareMetalNodePoolArgs', 'BareMetalNodePool']

@pulumi.input_type
class BareMetalNodePoolArgs:
    def __init__(__self__, *,
                 bare_metal_cluster: pulumi.Input[str],
                 location: pulumi.Input[str],
                 node_pool_config: pulumi.Input['BareMetalNodePoolNodePoolConfigArgs'],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a BareMetalNodePool resource.
        :param pulumi.Input[str] bare_metal_cluster: The cluster this node pool belongs to.
        :param pulumi.Input[str] location: The location of the resource.
        :param pulumi.Input['BareMetalNodePoolNodePoolConfigArgs'] node_pool_config: Node pool configuration.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Annotations on the Bare Metal Node Pool.
               This field has the same restrictions as Kubernetes annotations.
               The total size of all keys and values combined is limited to 256k.
               Key can have 2 segments: prefix (optional) and name (required),
               separated by a slash (/).
               Prefix must be a DNS subdomain.
               Name must be 63 characters or less, begin and end with alphanumerics,
               with dashes (-), underscores (_), dots (.), and alphanumerics between.
        :param pulumi.Input[str] display_name: The display name for the Bare Metal Node Pool.
        :param pulumi.Input[str] name: The bare metal node pool name.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "bare_metal_cluster", bare_metal_cluster)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "node_pool_config", node_pool_config)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="bareMetalCluster")
    def bare_metal_cluster(self) -> pulumi.Input[str]:
        """
        The cluster this node pool belongs to.
        """
        return pulumi.get(self, "bare_metal_cluster")

    @bare_metal_cluster.setter
    def bare_metal_cluster(self, value: pulumi.Input[str]):
        pulumi.set(self, "bare_metal_cluster", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        The location of the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="nodePoolConfig")
    def node_pool_config(self) -> pulumi.Input['BareMetalNodePoolNodePoolConfigArgs']:
        """
        Node pool configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "node_pool_config")

    @node_pool_config.setter
    def node_pool_config(self, value: pulumi.Input['BareMetalNodePoolNodePoolConfigArgs']):
        pulumi.set(self, "node_pool_config", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Annotations on the Bare Metal Node Pool.
        This field has the same restrictions as Kubernetes annotations.
        The total size of all keys and values combined is limited to 256k.
        Key can have 2 segments: prefix (optional) and name (required),
        separated by a slash (/).
        Prefix must be a DNS subdomain.
        Name must be 63 characters or less, begin and end with alphanumerics,
        with dashes (-), underscores (_), dots (.), and alphanumerics between.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name for the Bare Metal Node Pool.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The bare metal node pool name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _BareMetalNodePoolState:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 bare_metal_cluster: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 delete_time: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_pool_config: Optional[pulumi.Input['BareMetalNodePoolNodePoolConfigArgs']] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 reconciling: Optional[pulumi.Input[bool]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 statuses: Optional[pulumi.Input[Sequence[pulumi.Input['BareMetalNodePoolStatusArgs']]]] = None,
                 uid: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering BareMetalNodePool resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Annotations on the Bare Metal Node Pool.
               This field has the same restrictions as Kubernetes annotations.
               The total size of all keys and values combined is limited to 256k.
               Key can have 2 segments: prefix (optional) and name (required),
               separated by a slash (/).
               Prefix must be a DNS subdomain.
               Name must be 63 characters or less, begin and end with alphanumerics,
               with dashes (-), underscores (_), dots (.), and alphanumerics between.
        :param pulumi.Input[str] bare_metal_cluster: The cluster this node pool belongs to.
        :param pulumi.Input[str] create_time: The time the cluster was created, in RFC3339 text format.
        :param pulumi.Input[str] delete_time: The time the cluster was deleted, in RFC3339 text format.
        :param pulumi.Input[str] display_name: The display name for the Bare Metal Node Pool.
        :param pulumi.Input[str] etag: This checksum is computed by the server based on the value of other
               fields, and may be sent on update and delete requests to ensure the
               client has an up-to-date value before proceeding.
               Allows clients to perform consistent read-modify-writes
               through optimistic concurrency control.
        :param pulumi.Input[str] location: The location of the resource.
        :param pulumi.Input[str] name: The bare metal node pool name.
        :param pulumi.Input['BareMetalNodePoolNodePoolConfigArgs'] node_pool_config: Node pool configuration.
               Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[bool] reconciling: If set, there are currently changes in flight to the Bare Metal User Cluster.
        :param pulumi.Input[str] state: (Output)
               The lifecycle state of the condition.
        :param pulumi.Input[Sequence[pulumi.Input['BareMetalNodePoolStatusArgs']]] statuses: Specifies detailed node pool status.
               Structure is documented below.
        :param pulumi.Input[str] uid: The unique identifier of the Bare Metal Node Pool.
        :param pulumi.Input[str] update_time: The time the cluster was last updated, in RFC3339 text format.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if bare_metal_cluster is not None:
            pulumi.set(__self__, "bare_metal_cluster", bare_metal_cluster)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if delete_time is not None:
            pulumi.set(__self__, "delete_time", delete_time)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_pool_config is not None:
            pulumi.set(__self__, "node_pool_config", node_pool_config)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if reconciling is not None:
            pulumi.set(__self__, "reconciling", reconciling)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Annotations on the Bare Metal Node Pool.
        This field has the same restrictions as Kubernetes annotations.
        The total size of all keys and values combined is limited to 256k.
        Key can have 2 segments: prefix (optional) and name (required),
        separated by a slash (/).
        Prefix must be a DNS subdomain.
        Name must be 63 characters or less, begin and end with alphanumerics,
        with dashes (-), underscores (_), dots (.), and alphanumerics between.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="bareMetalCluster")
    def bare_metal_cluster(self) -> Optional[pulumi.Input[str]]:
        """
        The cluster this node pool belongs to.
        """
        return pulumi.get(self, "bare_metal_cluster")

    @bare_metal_cluster.setter
    def bare_metal_cluster(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bare_metal_cluster", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time the cluster was created, in RFC3339 text format.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time the cluster was deleted, in RFC3339 text format.
        """
        return pulumi.get(self, "delete_time")

    @delete_time.setter
    def delete_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delete_time", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name for the Bare Metal Node Pool.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        This checksum is computed by the server based on the value of other
        fields, and may be sent on update and delete requests to ensure the
        client has an up-to-date value before proceeding.
        Allows clients to perform consistent read-modify-writes
        through optimistic concurrency control.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location of the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The bare metal node pool name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodePoolConfig")
    def node_pool_config(self) -> Optional[pulumi.Input['BareMetalNodePoolNodePoolConfigArgs']]:
        """
        Node pool configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "node_pool_config")

    @node_pool_config.setter
    def node_pool_config(self, value: Optional[pulumi.Input['BareMetalNodePoolNodePoolConfigArgs']]):
        pulumi.set(self, "node_pool_config", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def reconciling(self) -> Optional[pulumi.Input[bool]]:
        """
        If set, there are currently changes in flight to the Bare Metal User Cluster.
        """
        return pulumi.get(self, "reconciling")

    @reconciling.setter
    def reconciling(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reconciling", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        The lifecycle state of the condition.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BareMetalNodePoolStatusArgs']]]]:
        """
        Specifies detailed node pool status.
        Structure is documented below.
        """
        return pulumi.get(self, "statuses")

    @statuses.setter
    def statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BareMetalNodePoolStatusArgs']]]]):
        pulumi.set(self, "statuses", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        The unique identifier of the Bare Metal Node Pool.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time the cluster was last updated, in RFC3339 text format.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)


class BareMetalNodePool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 bare_metal_cluster: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_pool_config: Optional[pulumi.Input[pulumi.InputType['BareMetalNodePoolNodePoolConfigArgs']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage
        ### Gkeonprem Bare Metal Node Pool Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_basic = gcp.gkeonprem.BareMetalCluster("default-basic",
            location="us-west1",
            admin_cluster_membership="projects/870316890899/locations/global/memberships/gkeonprem-terraform-test",
            bare_metal_version="1.12.3",
            network_config=gcp.gkeonprem.BareMetalClusterNetworkConfigArgs(
                island_mode_cidr=gcp.gkeonprem.BareMetalClusterNetworkConfigIslandModeCidrArgs(
                    service_address_cidr_blocks=["172.26.0.0/16"],
                    pod_address_cidr_blocks=["10.240.0.0/13"],
                ),
            ),
            control_plane=gcp.gkeonprem.BareMetalClusterControlPlaneArgs(
                control_plane_node_pool_config=gcp.gkeonprem.BareMetalClusterControlPlaneControlPlaneNodePoolConfigArgs(
                    node_pool_config=gcp.gkeonprem.BareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigArgs(
                        labels={},
                        operating_system="LINUX",
                        node_configs=[gcp.gkeonprem.BareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigNodeConfigArgs(
                            labels={},
                            node_ip="10.200.0.9",
                        )],
                    ),
                ),
            ),
            load_balancer=gcp.gkeonprem.BareMetalClusterLoadBalancerArgs(
                port_config=gcp.gkeonprem.BareMetalClusterLoadBalancerPortConfigArgs(
                    control_plane_load_balancer_port=443,
                ),
                vip_config=gcp.gkeonprem.BareMetalClusterLoadBalancerVipConfigArgs(
                    control_plane_vip="10.200.0.13",
                    ingress_vip="10.200.0.14",
                ),
                metal_lb_config=gcp.gkeonprem.BareMetalClusterLoadBalancerMetalLbConfigArgs(
                    address_pools=[gcp.gkeonprem.BareMetalClusterLoadBalancerMetalLbConfigAddressPoolArgs(
                        pool="pool1",
                        addresses=[
                            "10.200.0.14/32",
                            "10.200.0.15/32",
                            "10.200.0.16/32",
                            "10.200.0.17/32",
                            "10.200.0.18/32",
                            "fd00:1::f/128",
                            "fd00:1::10/128",
                            "fd00:1::11/128",
                            "fd00:1::12/128",
                        ],
                    )],
                ),
            ),
            storage=gcp.gkeonprem.BareMetalClusterStorageArgs(
                lvp_share_config=gcp.gkeonprem.BareMetalClusterStorageLvpShareConfigArgs(
                    lvp_config=gcp.gkeonprem.BareMetalClusterStorageLvpShareConfigLvpConfigArgs(
                        path="/mnt/localpv-share",
                        storage_class="local-shared",
                    ),
                    shared_path_pv_count=5,
                ),
                lvp_node_mounts_config=gcp.gkeonprem.BareMetalClusterStorageLvpNodeMountsConfigArgs(
                    path="/mnt/localpv-disk",
                    storage_class="local-disks",
                ),
            ),
            security_config=gcp.gkeonprem.BareMetalClusterSecurityConfigArgs(
                authorization=gcp.gkeonprem.BareMetalClusterSecurityConfigAuthorizationArgs(
                    admin_users=[gcp.gkeonprem.BareMetalClusterSecurityConfigAuthorizationAdminUserArgs(
                        username="admin@hashicorptest.com",
                    )],
                ),
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        nodepool_basic = gcp.gkeonprem.BareMetalNodePool("nodepool-basic",
            bare_metal_cluster=default_basic.name,
            location="us-west1",
            node_pool_config=gcp.gkeonprem.BareMetalNodePoolNodePoolConfigArgs(
                operating_system="LINUX",
                node_configs=[gcp.gkeonprem.BareMetalNodePoolNodePoolConfigNodeConfigArgs(
                    node_ip="10.200.0.11",
                )],
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Gkeonprem Bare Metal Node Pool Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_full = gcp.gkeonprem.BareMetalCluster("default-full",
            location="us-west1",
            admin_cluster_membership="projects/870316890899/locations/global/memberships/gkeonprem-terraform-test",
            bare_metal_version="1.12.3",
            network_config=gcp.gkeonprem.BareMetalClusterNetworkConfigArgs(
                island_mode_cidr=gcp.gkeonprem.BareMetalClusterNetworkConfigIslandModeCidrArgs(
                    service_address_cidr_blocks=["172.26.0.0/16"],
                    pod_address_cidr_blocks=["10.240.0.0/13"],
                ),
            ),
            control_plane=gcp.gkeonprem.BareMetalClusterControlPlaneArgs(
                control_plane_node_pool_config=gcp.gkeonprem.BareMetalClusterControlPlaneControlPlaneNodePoolConfigArgs(
                    node_pool_config=gcp.gkeonprem.BareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigArgs(
                        labels={},
                        operating_system="LINUX",
                        node_configs=[gcp.gkeonprem.BareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigNodeConfigArgs(
                            labels={},
                            node_ip="10.200.0.9",
                        )],
                    ),
                ),
            ),
            load_balancer=gcp.gkeonprem.BareMetalClusterLoadBalancerArgs(
                port_config=gcp.gkeonprem.BareMetalClusterLoadBalancerPortConfigArgs(
                    control_plane_load_balancer_port=443,
                ),
                vip_config=gcp.gkeonprem.BareMetalClusterLoadBalancerVipConfigArgs(
                    control_plane_vip="10.200.0.13",
                    ingress_vip="10.200.0.14",
                ),
                metal_lb_config=gcp.gkeonprem.BareMetalClusterLoadBalancerMetalLbConfigArgs(
                    address_pools=[gcp.gkeonprem.BareMetalClusterLoadBalancerMetalLbConfigAddressPoolArgs(
                        pool="pool1",
                        addresses=[
                            "10.200.0.14/32",
                            "10.200.0.15/32",
                            "10.200.0.16/32",
                            "10.200.0.17/32",
                            "10.200.0.18/32",
                            "fd00:1::f/128",
                            "fd00:1::10/128",
                            "fd00:1::11/128",
                            "fd00:1::12/128",
                        ],
                    )],
                ),
            ),
            storage=gcp.gkeonprem.BareMetalClusterStorageArgs(
                lvp_share_config=gcp.gkeonprem.BareMetalClusterStorageLvpShareConfigArgs(
                    lvp_config=gcp.gkeonprem.BareMetalClusterStorageLvpShareConfigLvpConfigArgs(
                        path="/mnt/localpv-share",
                        storage_class="local-shared",
                    ),
                    shared_path_pv_count=5,
                ),
                lvp_node_mounts_config=gcp.gkeonprem.BareMetalClusterStorageLvpNodeMountsConfigArgs(
                    path="/mnt/localpv-disk",
                    storage_class="local-disks",
                ),
            ),
            security_config=gcp.gkeonprem.BareMetalClusterSecurityConfigArgs(
                authorization=gcp.gkeonprem.BareMetalClusterSecurityConfigAuthorizationArgs(
                    admin_users=[gcp.gkeonprem.BareMetalClusterSecurityConfigAuthorizationAdminUserArgs(
                        username="admin@hashicorptest.com",
                    )],
                ),
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        nodepool_full = gcp.gkeonprem.BareMetalNodePool("nodepool-full",
            display_name="test-name",
            bare_metal_cluster=default_full.name,
            location="us-west1",
            annotations={},
            node_pool_config=gcp.gkeonprem.BareMetalNodePoolNodePoolConfigArgs(
                operating_system="LINUX",
                labels={},
                node_configs=[gcp.gkeonprem.BareMetalNodePoolNodePoolConfigNodeConfigArgs(
                    node_ip="10.200.0.11",
                    labels={},
                )],
                taints=[gcp.gkeonprem.BareMetalNodePoolNodePoolConfigTaintArgs(
                    key="test-key",
                    value="test-value",
                    effect="NO_EXECUTE",
                )],
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```

        ## Import

        BareMetalNodePool can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:gkeonprem/bareMetalNodePool:BareMetalNodePool default projects/{{project}}/locations/{{location}}/bareMetalClusters/{{bare_metal_cluster}}/bareMetalNodePools/{{name}}
        ```

        ```sh
         $ pulumi import gcp:gkeonprem/bareMetalNodePool:BareMetalNodePool default {{project}}/{{location}}/{{bare_metal_cluster}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:gkeonprem/bareMetalNodePool:BareMetalNodePool default {{location}}/{{bare_metal_cluster}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Annotations on the Bare Metal Node Pool.
               This field has the same restrictions as Kubernetes annotations.
               The total size of all keys and values combined is limited to 256k.
               Key can have 2 segments: prefix (optional) and name (required),
               separated by a slash (/).
               Prefix must be a DNS subdomain.
               Name must be 63 characters or less, begin and end with alphanumerics,
               with dashes (-), underscores (_), dots (.), and alphanumerics between.
        :param pulumi.Input[str] bare_metal_cluster: The cluster this node pool belongs to.
        :param pulumi.Input[str] display_name: The display name for the Bare Metal Node Pool.
        :param pulumi.Input[str] location: The location of the resource.
        :param pulumi.Input[str] name: The bare metal node pool name.
        :param pulumi.Input[pulumi.InputType['BareMetalNodePoolNodePoolConfigArgs']] node_pool_config: Node pool configuration.
               Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BareMetalNodePoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage
        ### Gkeonprem Bare Metal Node Pool Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_basic = gcp.gkeonprem.BareMetalCluster("default-basic",
            location="us-west1",
            admin_cluster_membership="projects/870316890899/locations/global/memberships/gkeonprem-terraform-test",
            bare_metal_version="1.12.3",
            network_config=gcp.gkeonprem.BareMetalClusterNetworkConfigArgs(
                island_mode_cidr=gcp.gkeonprem.BareMetalClusterNetworkConfigIslandModeCidrArgs(
                    service_address_cidr_blocks=["172.26.0.0/16"],
                    pod_address_cidr_blocks=["10.240.0.0/13"],
                ),
            ),
            control_plane=gcp.gkeonprem.BareMetalClusterControlPlaneArgs(
                control_plane_node_pool_config=gcp.gkeonprem.BareMetalClusterControlPlaneControlPlaneNodePoolConfigArgs(
                    node_pool_config=gcp.gkeonprem.BareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigArgs(
                        labels={},
                        operating_system="LINUX",
                        node_configs=[gcp.gkeonprem.BareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigNodeConfigArgs(
                            labels={},
                            node_ip="10.200.0.9",
                        )],
                    ),
                ),
            ),
            load_balancer=gcp.gkeonprem.BareMetalClusterLoadBalancerArgs(
                port_config=gcp.gkeonprem.BareMetalClusterLoadBalancerPortConfigArgs(
                    control_plane_load_balancer_port=443,
                ),
                vip_config=gcp.gkeonprem.BareMetalClusterLoadBalancerVipConfigArgs(
                    control_plane_vip="10.200.0.13",
                    ingress_vip="10.200.0.14",
                ),
                metal_lb_config=gcp.gkeonprem.BareMetalClusterLoadBalancerMetalLbConfigArgs(
                    address_pools=[gcp.gkeonprem.BareMetalClusterLoadBalancerMetalLbConfigAddressPoolArgs(
                        pool="pool1",
                        addresses=[
                            "10.200.0.14/32",
                            "10.200.0.15/32",
                            "10.200.0.16/32",
                            "10.200.0.17/32",
                            "10.200.0.18/32",
                            "fd00:1::f/128",
                            "fd00:1::10/128",
                            "fd00:1::11/128",
                            "fd00:1::12/128",
                        ],
                    )],
                ),
            ),
            storage=gcp.gkeonprem.BareMetalClusterStorageArgs(
                lvp_share_config=gcp.gkeonprem.BareMetalClusterStorageLvpShareConfigArgs(
                    lvp_config=gcp.gkeonprem.BareMetalClusterStorageLvpShareConfigLvpConfigArgs(
                        path="/mnt/localpv-share",
                        storage_class="local-shared",
                    ),
                    shared_path_pv_count=5,
                ),
                lvp_node_mounts_config=gcp.gkeonprem.BareMetalClusterStorageLvpNodeMountsConfigArgs(
                    path="/mnt/localpv-disk",
                    storage_class="local-disks",
                ),
            ),
            security_config=gcp.gkeonprem.BareMetalClusterSecurityConfigArgs(
                authorization=gcp.gkeonprem.BareMetalClusterSecurityConfigAuthorizationArgs(
                    admin_users=[gcp.gkeonprem.BareMetalClusterSecurityConfigAuthorizationAdminUserArgs(
                        username="admin@hashicorptest.com",
                    )],
                ),
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        nodepool_basic = gcp.gkeonprem.BareMetalNodePool("nodepool-basic",
            bare_metal_cluster=default_basic.name,
            location="us-west1",
            node_pool_config=gcp.gkeonprem.BareMetalNodePoolNodePoolConfigArgs(
                operating_system="LINUX",
                node_configs=[gcp.gkeonprem.BareMetalNodePoolNodePoolConfigNodeConfigArgs(
                    node_ip="10.200.0.11",
                )],
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Gkeonprem Bare Metal Node Pool Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_full = gcp.gkeonprem.BareMetalCluster("default-full",
            location="us-west1",
            admin_cluster_membership="projects/870316890899/locations/global/memberships/gkeonprem-terraform-test",
            bare_metal_version="1.12.3",
            network_config=gcp.gkeonprem.BareMetalClusterNetworkConfigArgs(
                island_mode_cidr=gcp.gkeonprem.BareMetalClusterNetworkConfigIslandModeCidrArgs(
                    service_address_cidr_blocks=["172.26.0.0/16"],
                    pod_address_cidr_blocks=["10.240.0.0/13"],
                ),
            ),
            control_plane=gcp.gkeonprem.BareMetalClusterControlPlaneArgs(
                control_plane_node_pool_config=gcp.gkeonprem.BareMetalClusterControlPlaneControlPlaneNodePoolConfigArgs(
                    node_pool_config=gcp.gkeonprem.BareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigArgs(
                        labels={},
                        operating_system="LINUX",
                        node_configs=[gcp.gkeonprem.BareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigNodeConfigArgs(
                            labels={},
                            node_ip="10.200.0.9",
                        )],
                    ),
                ),
            ),
            load_balancer=gcp.gkeonprem.BareMetalClusterLoadBalancerArgs(
                port_config=gcp.gkeonprem.BareMetalClusterLoadBalancerPortConfigArgs(
                    control_plane_load_balancer_port=443,
                ),
                vip_config=gcp.gkeonprem.BareMetalClusterLoadBalancerVipConfigArgs(
                    control_plane_vip="10.200.0.13",
                    ingress_vip="10.200.0.14",
                ),
                metal_lb_config=gcp.gkeonprem.BareMetalClusterLoadBalancerMetalLbConfigArgs(
                    address_pools=[gcp.gkeonprem.BareMetalClusterLoadBalancerMetalLbConfigAddressPoolArgs(
                        pool="pool1",
                        addresses=[
                            "10.200.0.14/32",
                            "10.200.0.15/32",
                            "10.200.0.16/32",
                            "10.200.0.17/32",
                            "10.200.0.18/32",
                            "fd00:1::f/128",
                            "fd00:1::10/128",
                            "fd00:1::11/128",
                            "fd00:1::12/128",
                        ],
                    )],
                ),
            ),
            storage=gcp.gkeonprem.BareMetalClusterStorageArgs(
                lvp_share_config=gcp.gkeonprem.BareMetalClusterStorageLvpShareConfigArgs(
                    lvp_config=gcp.gkeonprem.BareMetalClusterStorageLvpShareConfigLvpConfigArgs(
                        path="/mnt/localpv-share",
                        storage_class="local-shared",
                    ),
                    shared_path_pv_count=5,
                ),
                lvp_node_mounts_config=gcp.gkeonprem.BareMetalClusterStorageLvpNodeMountsConfigArgs(
                    path="/mnt/localpv-disk",
                    storage_class="local-disks",
                ),
            ),
            security_config=gcp.gkeonprem.BareMetalClusterSecurityConfigArgs(
                authorization=gcp.gkeonprem.BareMetalClusterSecurityConfigAuthorizationArgs(
                    admin_users=[gcp.gkeonprem.BareMetalClusterSecurityConfigAuthorizationAdminUserArgs(
                        username="admin@hashicorptest.com",
                    )],
                ),
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        nodepool_full = gcp.gkeonprem.BareMetalNodePool("nodepool-full",
            display_name="test-name",
            bare_metal_cluster=default_full.name,
            location="us-west1",
            annotations={},
            node_pool_config=gcp.gkeonprem.BareMetalNodePoolNodePoolConfigArgs(
                operating_system="LINUX",
                labels={},
                node_configs=[gcp.gkeonprem.BareMetalNodePoolNodePoolConfigNodeConfigArgs(
                    node_ip="10.200.0.11",
                    labels={},
                )],
                taints=[gcp.gkeonprem.BareMetalNodePoolNodePoolConfigTaintArgs(
                    key="test-key",
                    value="test-value",
                    effect="NO_EXECUTE",
                )],
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```

        ## Import

        BareMetalNodePool can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:gkeonprem/bareMetalNodePool:BareMetalNodePool default projects/{{project}}/locations/{{location}}/bareMetalClusters/{{bare_metal_cluster}}/bareMetalNodePools/{{name}}
        ```

        ```sh
         $ pulumi import gcp:gkeonprem/bareMetalNodePool:BareMetalNodePool default {{project}}/{{location}}/{{bare_metal_cluster}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:gkeonprem/bareMetalNodePool:BareMetalNodePool default {{location}}/{{bare_metal_cluster}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param BareMetalNodePoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BareMetalNodePoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 bare_metal_cluster: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_pool_config: Optional[pulumi.Input[pulumi.InputType['BareMetalNodePoolNodePoolConfigArgs']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BareMetalNodePoolArgs.__new__(BareMetalNodePoolArgs)

            __props__.__dict__["annotations"] = annotations
            if bare_metal_cluster is None and not opts.urn:
                raise TypeError("Missing required property 'bare_metal_cluster'")
            __props__.__dict__["bare_metal_cluster"] = bare_metal_cluster
            __props__.__dict__["display_name"] = display_name
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if node_pool_config is None and not opts.urn:
                raise TypeError("Missing required property 'node_pool_config'")
            __props__.__dict__["node_pool_config"] = node_pool_config
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["delete_time"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["reconciling"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["statuses"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        super(BareMetalNodePool, __self__).__init__(
            'gcp:gkeonprem/bareMetalNodePool:BareMetalNodePool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            bare_metal_cluster: Optional[pulumi.Input[str]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            delete_time: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            etag: Optional[pulumi.Input[str]] = None,
            location: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            node_pool_config: Optional[pulumi.Input[pulumi.InputType['BareMetalNodePoolNodePoolConfigArgs']]] = None,
            project: Optional[pulumi.Input[str]] = None,
            reconciling: Optional[pulumi.Input[bool]] = None,
            state: Optional[pulumi.Input[str]] = None,
            statuses: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BareMetalNodePoolStatusArgs']]]]] = None,
            uid: Optional[pulumi.Input[str]] = None,
            update_time: Optional[pulumi.Input[str]] = None) -> 'BareMetalNodePool':
        """
        Get an existing BareMetalNodePool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Annotations on the Bare Metal Node Pool.
               This field has the same restrictions as Kubernetes annotations.
               The total size of all keys and values combined is limited to 256k.
               Key can have 2 segments: prefix (optional) and name (required),
               separated by a slash (/).
               Prefix must be a DNS subdomain.
               Name must be 63 characters or less, begin and end with alphanumerics,
               with dashes (-), underscores (_), dots (.), and alphanumerics between.
        :param pulumi.Input[str] bare_metal_cluster: The cluster this node pool belongs to.
        :param pulumi.Input[str] create_time: The time the cluster was created, in RFC3339 text format.
        :param pulumi.Input[str] delete_time: The time the cluster was deleted, in RFC3339 text format.
        :param pulumi.Input[str] display_name: The display name for the Bare Metal Node Pool.
        :param pulumi.Input[str] etag: This checksum is computed by the server based on the value of other
               fields, and may be sent on update and delete requests to ensure the
               client has an up-to-date value before proceeding.
               Allows clients to perform consistent read-modify-writes
               through optimistic concurrency control.
        :param pulumi.Input[str] location: The location of the resource.
        :param pulumi.Input[str] name: The bare metal node pool name.
        :param pulumi.Input[pulumi.InputType['BareMetalNodePoolNodePoolConfigArgs']] node_pool_config: Node pool configuration.
               Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[bool] reconciling: If set, there are currently changes in flight to the Bare Metal User Cluster.
        :param pulumi.Input[str] state: (Output)
               The lifecycle state of the condition.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BareMetalNodePoolStatusArgs']]]] statuses: Specifies detailed node pool status.
               Structure is documented below.
        :param pulumi.Input[str] uid: The unique identifier of the Bare Metal Node Pool.
        :param pulumi.Input[str] update_time: The time the cluster was last updated, in RFC3339 text format.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BareMetalNodePoolState.__new__(_BareMetalNodePoolState)

        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["bare_metal_cluster"] = bare_metal_cluster
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["delete_time"] = delete_time
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["etag"] = etag
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["node_pool_config"] = node_pool_config
        __props__.__dict__["project"] = project
        __props__.__dict__["reconciling"] = reconciling
        __props__.__dict__["state"] = state
        __props__.__dict__["statuses"] = statuses
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        return BareMetalNodePool(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Annotations on the Bare Metal Node Pool.
        This field has the same restrictions as Kubernetes annotations.
        The total size of all keys and values combined is limited to 256k.
        Key can have 2 segments: prefix (optional) and name (required),
        separated by a slash (/).
        Prefix must be a DNS subdomain.
        Name must be 63 characters or less, begin and end with alphanumerics,
        with dashes (-), underscores (_), dots (.), and alphanumerics between.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="bareMetalCluster")
    def bare_metal_cluster(self) -> pulumi.Output[str]:
        """
        The cluster this node pool belongs to.
        """
        return pulumi.get(self, "bare_metal_cluster")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The time the cluster was created, in RFC3339 text format.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> pulumi.Output[str]:
        """
        The time the cluster was deleted, in RFC3339 text format.
        """
        return pulumi.get(self, "delete_time")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[str]]:
        """
        The display name for the Bare Metal Node Pool.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        """
        This checksum is computed by the server based on the value of other
        fields, and may be sent on update and delete requests to ensure the
        client has an up-to-date value before proceeding.
        Allows clients to perform consistent read-modify-writes
        through optimistic concurrency control.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The location of the resource.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The bare metal node pool name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodePoolConfig")
    def node_pool_config(self) -> pulumi.Output['outputs.BareMetalNodePoolNodePoolConfig']:
        """
        Node pool configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "node_pool_config")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def reconciling(self) -> pulumi.Output[bool]:
        """
        If set, there are currently changes in flight to the Bare Metal User Cluster.
        """
        return pulumi.get(self, "reconciling")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        (Output)
        The lifecycle state of the condition.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def statuses(self) -> pulumi.Output[Sequence['outputs.BareMetalNodePoolStatus']]:
        """
        Specifies detailed node pool status.
        Structure is documented below.
        """
        return pulumi.get(self, "statuses")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[str]:
        """
        The unique identifier of the Bare Metal Node Pool.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The time the cluster was last updated, in RFC3339 text format.
        """
        return pulumi.get(self, "update_time")

