# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VMwareClusterArgs', 'VMwareCluster']

@pulumi.input_type
class VMwareClusterArgs:
    def __init__(__self__, *,
                 admin_cluster_membership: pulumi.Input[str],
                 control_plane_node: pulumi.Input['VMwareClusterControlPlaneNodeArgs'],
                 location: pulumi.Input[str],
                 on_prem_version: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 anti_affinity_groups: Optional[pulumi.Input['VMwareClusterAntiAffinityGroupsArgs']] = None,
                 authorization: Optional[pulumi.Input['VMwareClusterAuthorizationArgs']] = None,
                 auto_repair_config: Optional[pulumi.Input['VMwareClusterAutoRepairConfigArgs']] = None,
                 dataplane_v2: Optional[pulumi.Input['VMwareClusterDataplaneV2Args']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_control_plane_v2: Optional[pulumi.Input[bool]] = None,
                 load_balancer: Optional[pulumi.Input['VMwareClusterLoadBalancerArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_config: Optional[pulumi.Input['VMwareClusterNetworkConfigArgs']] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 storage: Optional[pulumi.Input['VMwareClusterStorageArgs']] = None,
                 vm_tracking_enabled: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a VMwareCluster resource.
        :param pulumi.Input[str] admin_cluster_membership: The admin cluster this VMware User Cluster belongs to.
               This is the full resource name of the admin cluster's hub membership.
               In the future, references to other resource types might be allowed if
               admin clusters are modeled as their own resources.
        :param pulumi.Input['VMwareClusterControlPlaneNodeArgs'] control_plane_node: VMware User Cluster control plane nodes must have either 1 or 3 replicas.
               Structure is documented below.
        :param pulumi.Input[str] location: The location of the resource.
        :param pulumi.Input[str] on_prem_version: The Anthos clusters on the VMware version for your user cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Annotations on the VMware User Cluster.
               This field has the same restrictions as Kubernetes annotations.
               The total size of all keys and values combined is limited to 256k.
               Key can have 2 segments: prefix (optional) and name (required),
               separated by a slash (/).
               Prefix must be a DNS subdomain.
               Name must be 63 characters or less, begin and end with alphanumerics,
               with dashes (-), underscores (_), dots (.), and alphanumerics between.
        :param pulumi.Input['VMwareClusterAntiAffinityGroupsArgs'] anti_affinity_groups: AAGConfig specifies whether to spread VMware User Cluster nodes across at
               least three physical hosts in the datacenter.
               Structure is documented below.
        :param pulumi.Input['VMwareClusterAuthorizationArgs'] authorization: RBAC policy that will be applied and managed by GKE On-Prem.
               Structure is documented below.
        :param pulumi.Input['VMwareClusterAutoRepairConfigArgs'] auto_repair_config: Configuration for auto repairing.
               Structure is documented below.
        :param pulumi.Input['VMwareClusterDataplaneV2Args'] dataplane_v2: VmwareDataplaneV2Config specifies configuration for Dataplane V2.
               Structure is documented below.
        :param pulumi.Input[str] description: A human readable description of this VMware User Cluster.
        :param pulumi.Input[bool] enable_control_plane_v2: Enable control plane V2. Default to false.
        :param pulumi.Input['VMwareClusterLoadBalancerArgs'] load_balancer: Load Balancer configuration.
               Structure is documented below.
        :param pulumi.Input[str] name: The VMware cluster name.
        :param pulumi.Input['VMwareClusterNetworkConfigArgs'] network_config: The VMware User Cluster network configuration.
               Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['VMwareClusterStorageArgs'] storage: Storage configuration.
               Structure is documented below.
        :param pulumi.Input[bool] vm_tracking_enabled: Enable VM tracking.
        """
        pulumi.set(__self__, "admin_cluster_membership", admin_cluster_membership)
        pulumi.set(__self__, "control_plane_node", control_plane_node)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "on_prem_version", on_prem_version)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if anti_affinity_groups is not None:
            pulumi.set(__self__, "anti_affinity_groups", anti_affinity_groups)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if auto_repair_config is not None:
            pulumi.set(__self__, "auto_repair_config", auto_repair_config)
        if dataplane_v2 is not None:
            pulumi.set(__self__, "dataplane_v2", dataplane_v2)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_control_plane_v2 is not None:
            pulumi.set(__self__, "enable_control_plane_v2", enable_control_plane_v2)
        if load_balancer is not None:
            pulumi.set(__self__, "load_balancer", load_balancer)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_config is not None:
            pulumi.set(__self__, "network_config", network_config)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if storage is not None:
            pulumi.set(__self__, "storage", storage)
        if vm_tracking_enabled is not None:
            pulumi.set(__self__, "vm_tracking_enabled", vm_tracking_enabled)

    @property
    @pulumi.getter(name="adminClusterMembership")
    def admin_cluster_membership(self) -> pulumi.Input[str]:
        """
        The admin cluster this VMware User Cluster belongs to.
        This is the full resource name of the admin cluster's hub membership.
        In the future, references to other resource types might be allowed if
        admin clusters are modeled as their own resources.
        """
        return pulumi.get(self, "admin_cluster_membership")

    @admin_cluster_membership.setter
    def admin_cluster_membership(self, value: pulumi.Input[str]):
        pulumi.set(self, "admin_cluster_membership", value)

    @property
    @pulumi.getter(name="controlPlaneNode")
    def control_plane_node(self) -> pulumi.Input['VMwareClusterControlPlaneNodeArgs']:
        """
        VMware User Cluster control plane nodes must have either 1 or 3 replicas.
        Structure is documented below.
        """
        return pulumi.get(self, "control_plane_node")

    @control_plane_node.setter
    def control_plane_node(self, value: pulumi.Input['VMwareClusterControlPlaneNodeArgs']):
        pulumi.set(self, "control_plane_node", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        The location of the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="onPremVersion")
    def on_prem_version(self) -> pulumi.Input[str]:
        """
        The Anthos clusters on the VMware version for your user cluster.
        """
        return pulumi.get(self, "on_prem_version")

    @on_prem_version.setter
    def on_prem_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "on_prem_version", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Annotations on the VMware User Cluster.
        This field has the same restrictions as Kubernetes annotations.
        The total size of all keys and values combined is limited to 256k.
        Key can have 2 segments: prefix (optional) and name (required),
        separated by a slash (/).
        Prefix must be a DNS subdomain.
        Name must be 63 characters or less, begin and end with alphanumerics,
        with dashes (-), underscores (_), dots (.), and alphanumerics between.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="antiAffinityGroups")
    def anti_affinity_groups(self) -> Optional[pulumi.Input['VMwareClusterAntiAffinityGroupsArgs']]:
        """
        AAGConfig specifies whether to spread VMware User Cluster nodes across at
        least three physical hosts in the datacenter.
        Structure is documented below.
        """
        return pulumi.get(self, "anti_affinity_groups")

    @anti_affinity_groups.setter
    def anti_affinity_groups(self, value: Optional[pulumi.Input['VMwareClusterAntiAffinityGroupsArgs']]):
        pulumi.set(self, "anti_affinity_groups", value)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input['VMwareClusterAuthorizationArgs']]:
        """
        RBAC policy that will be applied and managed by GKE On-Prem.
        Structure is documented below.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input['VMwareClusterAuthorizationArgs']]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter(name="autoRepairConfig")
    def auto_repair_config(self) -> Optional[pulumi.Input['VMwareClusterAutoRepairConfigArgs']]:
        """
        Configuration for auto repairing.
        Structure is documented below.
        """
        return pulumi.get(self, "auto_repair_config")

    @auto_repair_config.setter
    def auto_repair_config(self, value: Optional[pulumi.Input['VMwareClusterAutoRepairConfigArgs']]):
        pulumi.set(self, "auto_repair_config", value)

    @property
    @pulumi.getter(name="dataplaneV2")
    def dataplane_v2(self) -> Optional[pulumi.Input['VMwareClusterDataplaneV2Args']]:
        """
        VmwareDataplaneV2Config specifies configuration for Dataplane V2.
        Structure is documented below.
        """
        return pulumi.get(self, "dataplane_v2")

    @dataplane_v2.setter
    def dataplane_v2(self, value: Optional[pulumi.Input['VMwareClusterDataplaneV2Args']]):
        pulumi.set(self, "dataplane_v2", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A human readable description of this VMware User Cluster.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enableControlPlaneV2")
    def enable_control_plane_v2(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable control plane V2. Default to false.
        """
        return pulumi.get(self, "enable_control_plane_v2")

    @enable_control_plane_v2.setter
    def enable_control_plane_v2(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_control_plane_v2", value)

    @property
    @pulumi.getter(name="loadBalancer")
    def load_balancer(self) -> Optional[pulumi.Input['VMwareClusterLoadBalancerArgs']]:
        """
        Load Balancer configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "load_balancer")

    @load_balancer.setter
    def load_balancer(self, value: Optional[pulumi.Input['VMwareClusterLoadBalancerArgs']]):
        pulumi.set(self, "load_balancer", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The VMware cluster name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> Optional[pulumi.Input['VMwareClusterNetworkConfigArgs']]:
        """
        The VMware User Cluster network configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "network_config")

    @network_config.setter
    def network_config(self, value: Optional[pulumi.Input['VMwareClusterNetworkConfigArgs']]):
        pulumi.set(self, "network_config", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def storage(self) -> Optional[pulumi.Input['VMwareClusterStorageArgs']]:
        """
        Storage configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "storage")

    @storage.setter
    def storage(self, value: Optional[pulumi.Input['VMwareClusterStorageArgs']]):
        pulumi.set(self, "storage", value)

    @property
    @pulumi.getter(name="vmTrackingEnabled")
    def vm_tracking_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable VM tracking.
        """
        return pulumi.get(self, "vm_tracking_enabled")

    @vm_tracking_enabled.setter
    def vm_tracking_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "vm_tracking_enabled", value)


@pulumi.input_type
class _VMwareClusterState:
    def __init__(__self__, *,
                 admin_cluster_membership: Optional[pulumi.Input[str]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 anti_affinity_groups: Optional[pulumi.Input['VMwareClusterAntiAffinityGroupsArgs']] = None,
                 authorization: Optional[pulumi.Input['VMwareClusterAuthorizationArgs']] = None,
                 auto_repair_config: Optional[pulumi.Input['VMwareClusterAutoRepairConfigArgs']] = None,
                 control_plane_node: Optional[pulumi.Input['VMwareClusterControlPlaneNodeArgs']] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 dataplane_v2: Optional[pulumi.Input['VMwareClusterDataplaneV2Args']] = None,
                 delete_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_control_plane_v2: Optional[pulumi.Input[bool]] = None,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 fleets: Optional[pulumi.Input[Sequence[pulumi.Input['VMwareClusterFleetArgs']]]] = None,
                 load_balancer: Optional[pulumi.Input['VMwareClusterLoadBalancerArgs']] = None,
                 local_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_config: Optional[pulumi.Input['VMwareClusterNetworkConfigArgs']] = None,
                 on_prem_version: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 reconciling: Optional[pulumi.Input[bool]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 statuses: Optional[pulumi.Input[Sequence[pulumi.Input['VMwareClusterStatusArgs']]]] = None,
                 storage: Optional[pulumi.Input['VMwareClusterStorageArgs']] = None,
                 uid: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None,
                 validation_checks: Optional[pulumi.Input[Sequence[pulumi.Input['VMwareClusterValidationCheckArgs']]]] = None,
                 vcenters: Optional[pulumi.Input[Sequence[pulumi.Input['VMwareClusterVcenterArgs']]]] = None,
                 vm_tracking_enabled: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering VMwareCluster resources.
        :param pulumi.Input[str] admin_cluster_membership: The admin cluster this VMware User Cluster belongs to.
               This is the full resource name of the admin cluster's hub membership.
               In the future, references to other resource types might be allowed if
               admin clusters are modeled as their own resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Annotations on the VMware User Cluster.
               This field has the same restrictions as Kubernetes annotations.
               The total size of all keys and values combined is limited to 256k.
               Key can have 2 segments: prefix (optional) and name (required),
               separated by a slash (/).
               Prefix must be a DNS subdomain.
               Name must be 63 characters or less, begin and end with alphanumerics,
               with dashes (-), underscores (_), dots (.), and alphanumerics between.
        :param pulumi.Input['VMwareClusterAntiAffinityGroupsArgs'] anti_affinity_groups: AAGConfig specifies whether to spread VMware User Cluster nodes across at
               least three physical hosts in the datacenter.
               Structure is documented below.
        :param pulumi.Input['VMwareClusterAuthorizationArgs'] authorization: RBAC policy that will be applied and managed by GKE On-Prem.
               Structure is documented below.
        :param pulumi.Input['VMwareClusterAutoRepairConfigArgs'] auto_repair_config: Configuration for auto repairing.
               Structure is documented below.
        :param pulumi.Input['VMwareClusterControlPlaneNodeArgs'] control_plane_node: VMware User Cluster control plane nodes must have either 1 or 3 replicas.
               Structure is documented below.
        :param pulumi.Input[str] create_time: The time at which VMware User Cluster was created.
        :param pulumi.Input['VMwareClusterDataplaneV2Args'] dataplane_v2: VmwareDataplaneV2Config specifies configuration for Dataplane V2.
               Structure is documented below.
        :param pulumi.Input[str] delete_time: The time at which VMware User Cluster was deleted.
        :param pulumi.Input[str] description: A human readable description of this VMware User Cluster.
        :param pulumi.Input[bool] enable_control_plane_v2: Enable control plane V2. Default to false.
        :param pulumi.Input[str] endpoint: The DNS name of VMware User Cluster's API server.
        :param pulumi.Input[str] etag: This checksum is computed by the server based on the value of other
               fields, and may be sent on update and delete requests to ensure the
               client has an up-to-date value before proceeding.
               Allows clients to perform consistent read-modify-writes
               through optimistic concurrency control.
        :param pulumi.Input[Sequence[pulumi.Input['VMwareClusterFleetArgs']]] fleets: Fleet configuration for the cluster.
               Structure is documented below.
        :param pulumi.Input['VMwareClusterLoadBalancerArgs'] load_balancer: Load Balancer configuration.
               Structure is documented below.
        :param pulumi.Input[str] local_name: The object name of the VMware OnPremUserCluster custom resource on the
               associated admin cluster. This field is used to support conflicting
               names when enrolling existing clusters to the API. When used as a part of
               cluster enrollment, this field will differ from the ID in the resource
               name. For new clusters, this field will match the user provided cluster ID
               and be visible in the last component of the resource name. It is not
               modifiable.
               All users should use this name to access their cluster using gkectl or
               kubectl and should expect to see the local name when viewing admin
               cluster controller logs.
        :param pulumi.Input[str] location: The location of the resource.
        :param pulumi.Input[str] name: The VMware cluster name.
        :param pulumi.Input['VMwareClusterNetworkConfigArgs'] network_config: The VMware User Cluster network configuration.
               Structure is documented below.
        :param pulumi.Input[str] on_prem_version: The Anthos clusters on the VMware version for your user cluster.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[bool] reconciling: If set, there are currently changes in flight to the VMware User Cluster.
        :param pulumi.Input[str] state: (Output)
               The lifecycle state of the condition.
        :param pulumi.Input[Sequence[pulumi.Input['VMwareClusterStatusArgs']]] statuses: (Output)
               Specifies the detailed validation check status
               Structure is documented below.
        :param pulumi.Input['VMwareClusterStorageArgs'] storage: Storage configuration.
               Structure is documented below.
        :param pulumi.Input[str] uid: The unique identifier of the VMware User Cluster.
        :param pulumi.Input[str] update_time: The time at which VMware User Cluster was last updated.
        :param pulumi.Input[Sequence[pulumi.Input['VMwareClusterValidationCheckArgs']]] validation_checks: ValidationCheck represents the result of the preflight check job.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['VMwareClusterVcenterArgs']]] vcenters: VmwareVCenterConfig specifies vCenter config for the user cluster.
               Inherited from the admin cluster.
               Structure is documented below.
        :param pulumi.Input[bool] vm_tracking_enabled: Enable VM tracking.
        """
        if admin_cluster_membership is not None:
            pulumi.set(__self__, "admin_cluster_membership", admin_cluster_membership)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if anti_affinity_groups is not None:
            pulumi.set(__self__, "anti_affinity_groups", anti_affinity_groups)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if auto_repair_config is not None:
            pulumi.set(__self__, "auto_repair_config", auto_repair_config)
        if control_plane_node is not None:
            pulumi.set(__self__, "control_plane_node", control_plane_node)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if dataplane_v2 is not None:
            pulumi.set(__self__, "dataplane_v2", dataplane_v2)
        if delete_time is not None:
            pulumi.set(__self__, "delete_time", delete_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_control_plane_v2 is not None:
            pulumi.set(__self__, "enable_control_plane_v2", enable_control_plane_v2)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if fleets is not None:
            pulumi.set(__self__, "fleets", fleets)
        if load_balancer is not None:
            pulumi.set(__self__, "load_balancer", load_balancer)
        if local_name is not None:
            pulumi.set(__self__, "local_name", local_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_config is not None:
            pulumi.set(__self__, "network_config", network_config)
        if on_prem_version is not None:
            pulumi.set(__self__, "on_prem_version", on_prem_version)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if reconciling is not None:
            pulumi.set(__self__, "reconciling", reconciling)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)
        if storage is not None:
            pulumi.set(__self__, "storage", storage)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if validation_checks is not None:
            pulumi.set(__self__, "validation_checks", validation_checks)
        if vcenters is not None:
            pulumi.set(__self__, "vcenters", vcenters)
        if vm_tracking_enabled is not None:
            pulumi.set(__self__, "vm_tracking_enabled", vm_tracking_enabled)

    @property
    @pulumi.getter(name="adminClusterMembership")
    def admin_cluster_membership(self) -> Optional[pulumi.Input[str]]:
        """
        The admin cluster this VMware User Cluster belongs to.
        This is the full resource name of the admin cluster's hub membership.
        In the future, references to other resource types might be allowed if
        admin clusters are modeled as their own resources.
        """
        return pulumi.get(self, "admin_cluster_membership")

    @admin_cluster_membership.setter
    def admin_cluster_membership(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_cluster_membership", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Annotations on the VMware User Cluster.
        This field has the same restrictions as Kubernetes annotations.
        The total size of all keys and values combined is limited to 256k.
        Key can have 2 segments: prefix (optional) and name (required),
        separated by a slash (/).
        Prefix must be a DNS subdomain.
        Name must be 63 characters or less, begin and end with alphanumerics,
        with dashes (-), underscores (_), dots (.), and alphanumerics between.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="antiAffinityGroups")
    def anti_affinity_groups(self) -> Optional[pulumi.Input['VMwareClusterAntiAffinityGroupsArgs']]:
        """
        AAGConfig specifies whether to spread VMware User Cluster nodes across at
        least three physical hosts in the datacenter.
        Structure is documented below.
        """
        return pulumi.get(self, "anti_affinity_groups")

    @anti_affinity_groups.setter
    def anti_affinity_groups(self, value: Optional[pulumi.Input['VMwareClusterAntiAffinityGroupsArgs']]):
        pulumi.set(self, "anti_affinity_groups", value)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input['VMwareClusterAuthorizationArgs']]:
        """
        RBAC policy that will be applied and managed by GKE On-Prem.
        Structure is documented below.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input['VMwareClusterAuthorizationArgs']]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter(name="autoRepairConfig")
    def auto_repair_config(self) -> Optional[pulumi.Input['VMwareClusterAutoRepairConfigArgs']]:
        """
        Configuration for auto repairing.
        Structure is documented below.
        """
        return pulumi.get(self, "auto_repair_config")

    @auto_repair_config.setter
    def auto_repair_config(self, value: Optional[pulumi.Input['VMwareClusterAutoRepairConfigArgs']]):
        pulumi.set(self, "auto_repair_config", value)

    @property
    @pulumi.getter(name="controlPlaneNode")
    def control_plane_node(self) -> Optional[pulumi.Input['VMwareClusterControlPlaneNodeArgs']]:
        """
        VMware User Cluster control plane nodes must have either 1 or 3 replicas.
        Structure is documented below.
        """
        return pulumi.get(self, "control_plane_node")

    @control_plane_node.setter
    def control_plane_node(self, value: Optional[pulumi.Input['VMwareClusterControlPlaneNodeArgs']]):
        pulumi.set(self, "control_plane_node", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time at which VMware User Cluster was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="dataplaneV2")
    def dataplane_v2(self) -> Optional[pulumi.Input['VMwareClusterDataplaneV2Args']]:
        """
        VmwareDataplaneV2Config specifies configuration for Dataplane V2.
        Structure is documented below.
        """
        return pulumi.get(self, "dataplane_v2")

    @dataplane_v2.setter
    def dataplane_v2(self, value: Optional[pulumi.Input['VMwareClusterDataplaneV2Args']]):
        pulumi.set(self, "dataplane_v2", value)

    @property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time at which VMware User Cluster was deleted.
        """
        return pulumi.get(self, "delete_time")

    @delete_time.setter
    def delete_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delete_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A human readable description of this VMware User Cluster.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enableControlPlaneV2")
    def enable_control_plane_v2(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable control plane V2. Default to false.
        """
        return pulumi.get(self, "enable_control_plane_v2")

    @enable_control_plane_v2.setter
    def enable_control_plane_v2(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_control_plane_v2", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The DNS name of VMware User Cluster's API server.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        This checksum is computed by the server based on the value of other
        fields, and may be sent on update and delete requests to ensure the
        client has an up-to-date value before proceeding.
        Allows clients to perform consistent read-modify-writes
        through optimistic concurrency control.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def fleets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VMwareClusterFleetArgs']]]]:
        """
        Fleet configuration for the cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "fleets")

    @fleets.setter
    def fleets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VMwareClusterFleetArgs']]]]):
        pulumi.set(self, "fleets", value)

    @property
    @pulumi.getter(name="loadBalancer")
    def load_balancer(self) -> Optional[pulumi.Input['VMwareClusterLoadBalancerArgs']]:
        """
        Load Balancer configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "load_balancer")

    @load_balancer.setter
    def load_balancer(self, value: Optional[pulumi.Input['VMwareClusterLoadBalancerArgs']]):
        pulumi.set(self, "load_balancer", value)

    @property
    @pulumi.getter(name="localName")
    def local_name(self) -> Optional[pulumi.Input[str]]:
        """
        The object name of the VMware OnPremUserCluster custom resource on the
        associated admin cluster. This field is used to support conflicting
        names when enrolling existing clusters to the API. When used as a part of
        cluster enrollment, this field will differ from the ID in the resource
        name. For new clusters, this field will match the user provided cluster ID
        and be visible in the last component of the resource name. It is not
        modifiable.
        All users should use this name to access their cluster using gkectl or
        kubectl and should expect to see the local name when viewing admin
        cluster controller logs.
        """
        return pulumi.get(self, "local_name")

    @local_name.setter
    def local_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_name", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location of the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The VMware cluster name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> Optional[pulumi.Input['VMwareClusterNetworkConfigArgs']]:
        """
        The VMware User Cluster network configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "network_config")

    @network_config.setter
    def network_config(self, value: Optional[pulumi.Input['VMwareClusterNetworkConfigArgs']]):
        pulumi.set(self, "network_config", value)

    @property
    @pulumi.getter(name="onPremVersion")
    def on_prem_version(self) -> Optional[pulumi.Input[str]]:
        """
        The Anthos clusters on the VMware version for your user cluster.
        """
        return pulumi.get(self, "on_prem_version")

    @on_prem_version.setter
    def on_prem_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "on_prem_version", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def reconciling(self) -> Optional[pulumi.Input[bool]]:
        """
        If set, there are currently changes in flight to the VMware User Cluster.
        """
        return pulumi.get(self, "reconciling")

    @reconciling.setter
    def reconciling(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reconciling", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        The lifecycle state of the condition.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VMwareClusterStatusArgs']]]]:
        """
        (Output)
        Specifies the detailed validation check status
        Structure is documented below.
        """
        return pulumi.get(self, "statuses")

    @statuses.setter
    def statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VMwareClusterStatusArgs']]]]):
        pulumi.set(self, "statuses", value)

    @property
    @pulumi.getter
    def storage(self) -> Optional[pulumi.Input['VMwareClusterStorageArgs']]:
        """
        Storage configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "storage")

    @storage.setter
    def storage(self, value: Optional[pulumi.Input['VMwareClusterStorageArgs']]):
        pulumi.set(self, "storage", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        The unique identifier of the VMware User Cluster.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time at which VMware User Cluster was last updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter(name="validationChecks")
    def validation_checks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VMwareClusterValidationCheckArgs']]]]:
        """
        ValidationCheck represents the result of the preflight check job.
        Structure is documented below.
        """
        return pulumi.get(self, "validation_checks")

    @validation_checks.setter
    def validation_checks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VMwareClusterValidationCheckArgs']]]]):
        pulumi.set(self, "validation_checks", value)

    @property
    @pulumi.getter
    def vcenters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VMwareClusterVcenterArgs']]]]:
        """
        VmwareVCenterConfig specifies vCenter config for the user cluster.
        Inherited from the admin cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "vcenters")

    @vcenters.setter
    def vcenters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VMwareClusterVcenterArgs']]]]):
        pulumi.set(self, "vcenters", value)

    @property
    @pulumi.getter(name="vmTrackingEnabled")
    def vm_tracking_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable VM tracking.
        """
        return pulumi.get(self, "vm_tracking_enabled")

    @vm_tracking_enabled.setter
    def vm_tracking_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "vm_tracking_enabled", value)


class VMwareCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_cluster_membership: Optional[pulumi.Input[str]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 anti_affinity_groups: Optional[pulumi.Input[pulumi.InputType['VMwareClusterAntiAffinityGroupsArgs']]] = None,
                 authorization: Optional[pulumi.Input[pulumi.InputType['VMwareClusterAuthorizationArgs']]] = None,
                 auto_repair_config: Optional[pulumi.Input[pulumi.InputType['VMwareClusterAutoRepairConfigArgs']]] = None,
                 control_plane_node: Optional[pulumi.Input[pulumi.InputType['VMwareClusterControlPlaneNodeArgs']]] = None,
                 dataplane_v2: Optional[pulumi.Input[pulumi.InputType['VMwareClusterDataplaneV2Args']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_control_plane_v2: Optional[pulumi.Input[bool]] = None,
                 load_balancer: Optional[pulumi.Input[pulumi.InputType['VMwareClusterLoadBalancerArgs']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_config: Optional[pulumi.Input[pulumi.InputType['VMwareClusterNetworkConfigArgs']]] = None,
                 on_prem_version: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 storage: Optional[pulumi.Input[pulumi.InputType['VMwareClusterStorageArgs']]] = None,
                 vm_tracking_enabled: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        ## Example Usage
        ### Gkeonprem Vmware Cluster Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        cluster_basic = gcp.gkeonprem.VMwareCluster("cluster-basic",
            location="us-west1",
            admin_cluster_membership="projects/870316890899/locations/global/memberships/gkeonprem-terraform-test",
            description="test cluster",
            on_prem_version="1.13.1-gke.35",
            annotations={},
            network_config=gcp.gkeonprem.VMwareClusterNetworkConfigArgs(
                service_address_cidr_blocks=["10.96.0.0/12"],
                pod_address_cidr_blocks=["192.168.0.0/16"],
                dhcp_ip_config=gcp.gkeonprem.VMwareClusterNetworkConfigDhcpIpConfigArgs(
                    enabled=True,
                ),
            ),
            control_plane_node=gcp.gkeonprem.VMwareClusterControlPlaneNodeArgs(
                cpus=4,
                memory=8192,
                replicas=1,
            ),
            load_balancer=gcp.gkeonprem.VMwareClusterLoadBalancerArgs(
                vip_config=gcp.gkeonprem.VMwareClusterLoadBalancerVipConfigArgs(
                    control_plane_vip="10.251.133.5",
                    ingress_vip="10.251.135.19",
                ),
                metal_lb_config=gcp.gkeonprem.VMwareClusterLoadBalancerMetalLbConfigArgs(
                    address_pools=[
                        gcp.gkeonprem.VMwareClusterLoadBalancerMetalLbConfigAddressPoolArgs(
                            pool="ingress-ip",
                            manual_assign=True,
                            addresses=["10.251.135.19"],
                            avoid_buggy_ips=True,
                        ),
                        gcp.gkeonprem.VMwareClusterLoadBalancerMetalLbConfigAddressPoolArgs(
                            pool="lb-test-ip",
                            manual_assign=True,
                            addresses=["10.251.135.19"],
                            avoid_buggy_ips=True,
                        ),
                    ],
                ),
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Gkeonprem Vmware Cluster F5lb

        ```python
        import pulumi
        import pulumi_gcp as gcp

        cluster_f5lb = gcp.gkeonprem.VMwareCluster("cluster-f5lb",
            location="us-west1",
            admin_cluster_membership="projects/870316890899/locations/global/memberships/gkeonprem-terraform-test",
            description="test cluster",
            on_prem_version="1.13.1-gke.35",
            annotations={},
            network_config=gcp.gkeonprem.VMwareClusterNetworkConfigArgs(
                service_address_cidr_blocks=["10.96.0.0/12"],
                pod_address_cidr_blocks=["192.168.0.0/16"],
                dhcp_ip_config=gcp.gkeonprem.VMwareClusterNetworkConfigDhcpIpConfigArgs(
                    enabled=True,
                ),
                control_plane_v2_config=gcp.gkeonprem.VMwareClusterNetworkConfigControlPlaneV2ConfigArgs(
                    control_plane_ip_block=gcp.gkeonprem.VMwareClusterNetworkConfigControlPlaneV2ConfigControlPlaneIpBlockArgs(
                        ips=[gcp.gkeonprem.VMwareClusterNetworkConfigControlPlaneV2ConfigControlPlaneIpBlockIpArgs(
                            hostname="test-hostname",
                            ip="10.0.0.1",
                        )],
                        netmask="10.0.0.1/32",
                        gateway="test-gateway",
                    ),
                ),
            ),
            control_plane_node=gcp.gkeonprem.VMwareClusterControlPlaneNodeArgs(
                cpus=4,
                memory=8192,
                replicas=1,
                auto_resize_config=gcp.gkeonprem.VMwareClusterControlPlaneNodeAutoResizeConfigArgs(
                    enabled=True,
                ),
            ),
            load_balancer=gcp.gkeonprem.VMwareClusterLoadBalancerArgs(
                vip_config=gcp.gkeonprem.VMwareClusterLoadBalancerVipConfigArgs(
                    control_plane_vip="10.251.133.5",
                    ingress_vip="10.251.135.19",
                ),
                f5_config=gcp.gkeonprem.VMwareClusterLoadBalancerF5ConfigArgs(
                    address="10.0.0.1",
                    partition="test-partition",
                    snat_pool="test-snap-pool",
                ),
            ),
            dataplane_v2=gcp.gkeonprem.VMwareClusterDataplaneV2Args(
                dataplane_v2_enabled=True,
                windows_dataplane_v2_enabled=True,
                advanced_networking=True,
            ),
            vm_tracking_enabled=True,
            enable_control_plane_v2=True,
            authorization=gcp.gkeonprem.VMwareClusterAuthorizationArgs(
                admin_users=[gcp.gkeonprem.VMwareClusterAuthorizationAdminUserArgs(
                    username="testuser@gmail.com",
                )],
            ),
            anti_affinity_groups=gcp.gkeonprem.VMwareClusterAntiAffinityGroupsArgs(
                aag_config_disabled=True,
            ),
            auto_repair_config=gcp.gkeonprem.VMwareClusterAutoRepairConfigArgs(
                enabled=True,
            ),
            storage=gcp.gkeonprem.VMwareClusterStorageArgs(
                vsphere_csi_disabled=True,
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Gkeonprem Vmware Cluster Manuallb

        ```python
        import pulumi
        import pulumi_gcp as gcp

        cluster_manuallb = gcp.gkeonprem.VMwareCluster("cluster-manuallb",
            location="us-west1",
            admin_cluster_membership="projects/870316890899/locations/global/memberships/gkeonprem-terraform-test",
            description="test cluster",
            on_prem_version="1.13.1-gke.35",
            annotations={},
            network_config=gcp.gkeonprem.VMwareClusterNetworkConfigArgs(
                service_address_cidr_blocks=["10.96.0.0/12"],
                pod_address_cidr_blocks=["192.168.0.0/16"],
                host_config=gcp.gkeonprem.VMwareClusterNetworkConfigHostConfigArgs(
                    dns_servers=["10.254.41.1"],
                    ntp_servers=["216.239.35.8"],
                    dns_search_domains=["test-domain"],
                ),
                static_ip_config=gcp.gkeonprem.VMwareClusterNetworkConfigStaticIpConfigArgs(
                    ip_blocks=[gcp.gkeonprem.VMwareClusterNetworkConfigStaticIpConfigIpBlockArgs(
                        netmask="255.255.252.0",
                        gateway="10.251.31.254",
                        ips=[
                            gcp.gkeonprem.VMwareClusterNetworkConfigStaticIpConfigIpBlockIpArgs(
                                ip="10.251.30.153",
                                hostname="test-hostname1",
                            ),
                            gcp.gkeonprem.VMwareClusterNetworkConfigStaticIpConfigIpBlockIpArgs(
                                ip="10.251.31.206",
                                hostname="test-hostname2",
                            ),
                            gcp.gkeonprem.VMwareClusterNetworkConfigStaticIpConfigIpBlockIpArgs(
                                ip="10.251.31.193",
                                hostname="test-hostname3",
                            ),
                            gcp.gkeonprem.VMwareClusterNetworkConfigStaticIpConfigIpBlockIpArgs(
                                ip="10.251.30.230",
                                hostname="test-hostname4",
                            ),
                        ],
                    )],
                ),
            ),
            control_plane_node=gcp.gkeonprem.VMwareClusterControlPlaneNodeArgs(
                cpus=4,
                memory=8192,
                replicas=1,
                auto_resize_config=gcp.gkeonprem.VMwareClusterControlPlaneNodeAutoResizeConfigArgs(
                    enabled=True,
                ),
            ),
            load_balancer=gcp.gkeonprem.VMwareClusterLoadBalancerArgs(
                vip_config=gcp.gkeonprem.VMwareClusterLoadBalancerVipConfigArgs(
                    control_plane_vip="10.251.133.5",
                    ingress_vip="10.251.135.19",
                ),
                manual_lb_config=gcp.gkeonprem.VMwareClusterLoadBalancerManualLbConfigArgs(
                    ingress_http_node_port=30005,
                    ingress_https_node_port=30006,
                    control_plane_node_port=30007,
                    konnectivity_server_node_port=30008,
                ),
            ),
            dataplane_v2=gcp.gkeonprem.VMwareClusterDataplaneV2Args(
                dataplane_v2_enabled=True,
                windows_dataplane_v2_enabled=True,
                advanced_networking=True,
            ),
            vm_tracking_enabled=True,
            enable_control_plane_v2=True,
            authorization=gcp.gkeonprem.VMwareClusterAuthorizationArgs(
                admin_users=[gcp.gkeonprem.VMwareClusterAuthorizationAdminUserArgs(
                    username="testuser@gmail.com",
                )],
            ),
            anti_affinity_groups=gcp.gkeonprem.VMwareClusterAntiAffinityGroupsArgs(
                aag_config_disabled=True,
            ),
            auto_repair_config=gcp.gkeonprem.VMwareClusterAutoRepairConfigArgs(
                enabled=True,
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```

        ## Import

        VmwareCluster can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:gkeonprem/vMwareCluster:VMwareCluster default projects/{{project}}/locations/{{location}}/vmwareClusters/{{name}}
        ```

        ```sh
         $ pulumi import gcp:gkeonprem/vMwareCluster:VMwareCluster default {{project}}/{{location}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:gkeonprem/vMwareCluster:VMwareCluster default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] admin_cluster_membership: The admin cluster this VMware User Cluster belongs to.
               This is the full resource name of the admin cluster's hub membership.
               In the future, references to other resource types might be allowed if
               admin clusters are modeled as their own resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Annotations on the VMware User Cluster.
               This field has the same restrictions as Kubernetes annotations.
               The total size of all keys and values combined is limited to 256k.
               Key can have 2 segments: prefix (optional) and name (required),
               separated by a slash (/).
               Prefix must be a DNS subdomain.
               Name must be 63 characters or less, begin and end with alphanumerics,
               with dashes (-), underscores (_), dots (.), and alphanumerics between.
        :param pulumi.Input[pulumi.InputType['VMwareClusterAntiAffinityGroupsArgs']] anti_affinity_groups: AAGConfig specifies whether to spread VMware User Cluster nodes across at
               least three physical hosts in the datacenter.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['VMwareClusterAuthorizationArgs']] authorization: RBAC policy that will be applied and managed by GKE On-Prem.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['VMwareClusterAutoRepairConfigArgs']] auto_repair_config: Configuration for auto repairing.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['VMwareClusterControlPlaneNodeArgs']] control_plane_node: VMware User Cluster control plane nodes must have either 1 or 3 replicas.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['VMwareClusterDataplaneV2Args']] dataplane_v2: VmwareDataplaneV2Config specifies configuration for Dataplane V2.
               Structure is documented below.
        :param pulumi.Input[str] description: A human readable description of this VMware User Cluster.
        :param pulumi.Input[bool] enable_control_plane_v2: Enable control plane V2. Default to false.
        :param pulumi.Input[pulumi.InputType['VMwareClusterLoadBalancerArgs']] load_balancer: Load Balancer configuration.
               Structure is documented below.
        :param pulumi.Input[str] location: The location of the resource.
        :param pulumi.Input[str] name: The VMware cluster name.
        :param pulumi.Input[pulumi.InputType['VMwareClusterNetworkConfigArgs']] network_config: The VMware User Cluster network configuration.
               Structure is documented below.
        :param pulumi.Input[str] on_prem_version: The Anthos clusters on the VMware version for your user cluster.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[pulumi.InputType['VMwareClusterStorageArgs']] storage: Storage configuration.
               Structure is documented below.
        :param pulumi.Input[bool] vm_tracking_enabled: Enable VM tracking.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VMwareClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage
        ### Gkeonprem Vmware Cluster Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        cluster_basic = gcp.gkeonprem.VMwareCluster("cluster-basic",
            location="us-west1",
            admin_cluster_membership="projects/870316890899/locations/global/memberships/gkeonprem-terraform-test",
            description="test cluster",
            on_prem_version="1.13.1-gke.35",
            annotations={},
            network_config=gcp.gkeonprem.VMwareClusterNetworkConfigArgs(
                service_address_cidr_blocks=["10.96.0.0/12"],
                pod_address_cidr_blocks=["192.168.0.0/16"],
                dhcp_ip_config=gcp.gkeonprem.VMwareClusterNetworkConfigDhcpIpConfigArgs(
                    enabled=True,
                ),
            ),
            control_plane_node=gcp.gkeonprem.VMwareClusterControlPlaneNodeArgs(
                cpus=4,
                memory=8192,
                replicas=1,
            ),
            load_balancer=gcp.gkeonprem.VMwareClusterLoadBalancerArgs(
                vip_config=gcp.gkeonprem.VMwareClusterLoadBalancerVipConfigArgs(
                    control_plane_vip="10.251.133.5",
                    ingress_vip="10.251.135.19",
                ),
                metal_lb_config=gcp.gkeonprem.VMwareClusterLoadBalancerMetalLbConfigArgs(
                    address_pools=[
                        gcp.gkeonprem.VMwareClusterLoadBalancerMetalLbConfigAddressPoolArgs(
                            pool="ingress-ip",
                            manual_assign=True,
                            addresses=["10.251.135.19"],
                            avoid_buggy_ips=True,
                        ),
                        gcp.gkeonprem.VMwareClusterLoadBalancerMetalLbConfigAddressPoolArgs(
                            pool="lb-test-ip",
                            manual_assign=True,
                            addresses=["10.251.135.19"],
                            avoid_buggy_ips=True,
                        ),
                    ],
                ),
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Gkeonprem Vmware Cluster F5lb

        ```python
        import pulumi
        import pulumi_gcp as gcp

        cluster_f5lb = gcp.gkeonprem.VMwareCluster("cluster-f5lb",
            location="us-west1",
            admin_cluster_membership="projects/870316890899/locations/global/memberships/gkeonprem-terraform-test",
            description="test cluster",
            on_prem_version="1.13.1-gke.35",
            annotations={},
            network_config=gcp.gkeonprem.VMwareClusterNetworkConfigArgs(
                service_address_cidr_blocks=["10.96.0.0/12"],
                pod_address_cidr_blocks=["192.168.0.0/16"],
                dhcp_ip_config=gcp.gkeonprem.VMwareClusterNetworkConfigDhcpIpConfigArgs(
                    enabled=True,
                ),
                control_plane_v2_config=gcp.gkeonprem.VMwareClusterNetworkConfigControlPlaneV2ConfigArgs(
                    control_plane_ip_block=gcp.gkeonprem.VMwareClusterNetworkConfigControlPlaneV2ConfigControlPlaneIpBlockArgs(
                        ips=[gcp.gkeonprem.VMwareClusterNetworkConfigControlPlaneV2ConfigControlPlaneIpBlockIpArgs(
                            hostname="test-hostname",
                            ip="10.0.0.1",
                        )],
                        netmask="10.0.0.1/32",
                        gateway="test-gateway",
                    ),
                ),
            ),
            control_plane_node=gcp.gkeonprem.VMwareClusterControlPlaneNodeArgs(
                cpus=4,
                memory=8192,
                replicas=1,
                auto_resize_config=gcp.gkeonprem.VMwareClusterControlPlaneNodeAutoResizeConfigArgs(
                    enabled=True,
                ),
            ),
            load_balancer=gcp.gkeonprem.VMwareClusterLoadBalancerArgs(
                vip_config=gcp.gkeonprem.VMwareClusterLoadBalancerVipConfigArgs(
                    control_plane_vip="10.251.133.5",
                    ingress_vip="10.251.135.19",
                ),
                f5_config=gcp.gkeonprem.VMwareClusterLoadBalancerF5ConfigArgs(
                    address="10.0.0.1",
                    partition="test-partition",
                    snat_pool="test-snap-pool",
                ),
            ),
            dataplane_v2=gcp.gkeonprem.VMwareClusterDataplaneV2Args(
                dataplane_v2_enabled=True,
                windows_dataplane_v2_enabled=True,
                advanced_networking=True,
            ),
            vm_tracking_enabled=True,
            enable_control_plane_v2=True,
            authorization=gcp.gkeonprem.VMwareClusterAuthorizationArgs(
                admin_users=[gcp.gkeonprem.VMwareClusterAuthorizationAdminUserArgs(
                    username="testuser@gmail.com",
                )],
            ),
            anti_affinity_groups=gcp.gkeonprem.VMwareClusterAntiAffinityGroupsArgs(
                aag_config_disabled=True,
            ),
            auto_repair_config=gcp.gkeonprem.VMwareClusterAutoRepairConfigArgs(
                enabled=True,
            ),
            storage=gcp.gkeonprem.VMwareClusterStorageArgs(
                vsphere_csi_disabled=True,
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Gkeonprem Vmware Cluster Manuallb

        ```python
        import pulumi
        import pulumi_gcp as gcp

        cluster_manuallb = gcp.gkeonprem.VMwareCluster("cluster-manuallb",
            location="us-west1",
            admin_cluster_membership="projects/870316890899/locations/global/memberships/gkeonprem-terraform-test",
            description="test cluster",
            on_prem_version="1.13.1-gke.35",
            annotations={},
            network_config=gcp.gkeonprem.VMwareClusterNetworkConfigArgs(
                service_address_cidr_blocks=["10.96.0.0/12"],
                pod_address_cidr_blocks=["192.168.0.0/16"],
                host_config=gcp.gkeonprem.VMwareClusterNetworkConfigHostConfigArgs(
                    dns_servers=["10.254.41.1"],
                    ntp_servers=["216.239.35.8"],
                    dns_search_domains=["test-domain"],
                ),
                static_ip_config=gcp.gkeonprem.VMwareClusterNetworkConfigStaticIpConfigArgs(
                    ip_blocks=[gcp.gkeonprem.VMwareClusterNetworkConfigStaticIpConfigIpBlockArgs(
                        netmask="255.255.252.0",
                        gateway="10.251.31.254",
                        ips=[
                            gcp.gkeonprem.VMwareClusterNetworkConfigStaticIpConfigIpBlockIpArgs(
                                ip="10.251.30.153",
                                hostname="test-hostname1",
                            ),
                            gcp.gkeonprem.VMwareClusterNetworkConfigStaticIpConfigIpBlockIpArgs(
                                ip="10.251.31.206",
                                hostname="test-hostname2",
                            ),
                            gcp.gkeonprem.VMwareClusterNetworkConfigStaticIpConfigIpBlockIpArgs(
                                ip="10.251.31.193",
                                hostname="test-hostname3",
                            ),
                            gcp.gkeonprem.VMwareClusterNetworkConfigStaticIpConfigIpBlockIpArgs(
                                ip="10.251.30.230",
                                hostname="test-hostname4",
                            ),
                        ],
                    )],
                ),
            ),
            control_plane_node=gcp.gkeonprem.VMwareClusterControlPlaneNodeArgs(
                cpus=4,
                memory=8192,
                replicas=1,
                auto_resize_config=gcp.gkeonprem.VMwareClusterControlPlaneNodeAutoResizeConfigArgs(
                    enabled=True,
                ),
            ),
            load_balancer=gcp.gkeonprem.VMwareClusterLoadBalancerArgs(
                vip_config=gcp.gkeonprem.VMwareClusterLoadBalancerVipConfigArgs(
                    control_plane_vip="10.251.133.5",
                    ingress_vip="10.251.135.19",
                ),
                manual_lb_config=gcp.gkeonprem.VMwareClusterLoadBalancerManualLbConfigArgs(
                    ingress_http_node_port=30005,
                    ingress_https_node_port=30006,
                    control_plane_node_port=30007,
                    konnectivity_server_node_port=30008,
                ),
            ),
            dataplane_v2=gcp.gkeonprem.VMwareClusterDataplaneV2Args(
                dataplane_v2_enabled=True,
                windows_dataplane_v2_enabled=True,
                advanced_networking=True,
            ),
            vm_tracking_enabled=True,
            enable_control_plane_v2=True,
            authorization=gcp.gkeonprem.VMwareClusterAuthorizationArgs(
                admin_users=[gcp.gkeonprem.VMwareClusterAuthorizationAdminUserArgs(
                    username="testuser@gmail.com",
                )],
            ),
            anti_affinity_groups=gcp.gkeonprem.VMwareClusterAntiAffinityGroupsArgs(
                aag_config_disabled=True,
            ),
            auto_repair_config=gcp.gkeonprem.VMwareClusterAutoRepairConfigArgs(
                enabled=True,
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```

        ## Import

        VmwareCluster can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:gkeonprem/vMwareCluster:VMwareCluster default projects/{{project}}/locations/{{location}}/vmwareClusters/{{name}}
        ```

        ```sh
         $ pulumi import gcp:gkeonprem/vMwareCluster:VMwareCluster default {{project}}/{{location}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:gkeonprem/vMwareCluster:VMwareCluster default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param VMwareClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VMwareClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_cluster_membership: Optional[pulumi.Input[str]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 anti_affinity_groups: Optional[pulumi.Input[pulumi.InputType['VMwareClusterAntiAffinityGroupsArgs']]] = None,
                 authorization: Optional[pulumi.Input[pulumi.InputType['VMwareClusterAuthorizationArgs']]] = None,
                 auto_repair_config: Optional[pulumi.Input[pulumi.InputType['VMwareClusterAutoRepairConfigArgs']]] = None,
                 control_plane_node: Optional[pulumi.Input[pulumi.InputType['VMwareClusterControlPlaneNodeArgs']]] = None,
                 dataplane_v2: Optional[pulumi.Input[pulumi.InputType['VMwareClusterDataplaneV2Args']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_control_plane_v2: Optional[pulumi.Input[bool]] = None,
                 load_balancer: Optional[pulumi.Input[pulumi.InputType['VMwareClusterLoadBalancerArgs']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_config: Optional[pulumi.Input[pulumi.InputType['VMwareClusterNetworkConfigArgs']]] = None,
                 on_prem_version: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 storage: Optional[pulumi.Input[pulumi.InputType['VMwareClusterStorageArgs']]] = None,
                 vm_tracking_enabled: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VMwareClusterArgs.__new__(VMwareClusterArgs)

            if admin_cluster_membership is None and not opts.urn:
                raise TypeError("Missing required property 'admin_cluster_membership'")
            __props__.__dict__["admin_cluster_membership"] = admin_cluster_membership
            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["anti_affinity_groups"] = anti_affinity_groups
            __props__.__dict__["authorization"] = authorization
            __props__.__dict__["auto_repair_config"] = auto_repair_config
            if control_plane_node is None and not opts.urn:
                raise TypeError("Missing required property 'control_plane_node'")
            __props__.__dict__["control_plane_node"] = control_plane_node
            __props__.__dict__["dataplane_v2"] = dataplane_v2
            __props__.__dict__["description"] = description
            __props__.__dict__["enable_control_plane_v2"] = enable_control_plane_v2
            __props__.__dict__["load_balancer"] = load_balancer
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["network_config"] = network_config
            if on_prem_version is None and not opts.urn:
                raise TypeError("Missing required property 'on_prem_version'")
            __props__.__dict__["on_prem_version"] = on_prem_version
            __props__.__dict__["project"] = project
            __props__.__dict__["storage"] = storage
            __props__.__dict__["vm_tracking_enabled"] = vm_tracking_enabled
            __props__.__dict__["create_time"] = None
            __props__.__dict__["delete_time"] = None
            __props__.__dict__["endpoint"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["fleets"] = None
            __props__.__dict__["local_name"] = None
            __props__.__dict__["reconciling"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["statuses"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
            __props__.__dict__["validation_checks"] = None
            __props__.__dict__["vcenters"] = None
        super(VMwareCluster, __self__).__init__(
            'gcp:gkeonprem/vMwareCluster:VMwareCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_cluster_membership: Optional[pulumi.Input[str]] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            anti_affinity_groups: Optional[pulumi.Input[pulumi.InputType['VMwareClusterAntiAffinityGroupsArgs']]] = None,
            authorization: Optional[pulumi.Input[pulumi.InputType['VMwareClusterAuthorizationArgs']]] = None,
            auto_repair_config: Optional[pulumi.Input[pulumi.InputType['VMwareClusterAutoRepairConfigArgs']]] = None,
            control_plane_node: Optional[pulumi.Input[pulumi.InputType['VMwareClusterControlPlaneNodeArgs']]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            dataplane_v2: Optional[pulumi.Input[pulumi.InputType['VMwareClusterDataplaneV2Args']]] = None,
            delete_time: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            enable_control_plane_v2: Optional[pulumi.Input[bool]] = None,
            endpoint: Optional[pulumi.Input[str]] = None,
            etag: Optional[pulumi.Input[str]] = None,
            fleets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VMwareClusterFleetArgs']]]]] = None,
            load_balancer: Optional[pulumi.Input[pulumi.InputType['VMwareClusterLoadBalancerArgs']]] = None,
            local_name: Optional[pulumi.Input[str]] = None,
            location: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_config: Optional[pulumi.Input[pulumi.InputType['VMwareClusterNetworkConfigArgs']]] = None,
            on_prem_version: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            reconciling: Optional[pulumi.Input[bool]] = None,
            state: Optional[pulumi.Input[str]] = None,
            statuses: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VMwareClusterStatusArgs']]]]] = None,
            storage: Optional[pulumi.Input[pulumi.InputType['VMwareClusterStorageArgs']]] = None,
            uid: Optional[pulumi.Input[str]] = None,
            update_time: Optional[pulumi.Input[str]] = None,
            validation_checks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VMwareClusterValidationCheckArgs']]]]] = None,
            vcenters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VMwareClusterVcenterArgs']]]]] = None,
            vm_tracking_enabled: Optional[pulumi.Input[bool]] = None) -> 'VMwareCluster':
        """
        Get an existing VMwareCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] admin_cluster_membership: The admin cluster this VMware User Cluster belongs to.
               This is the full resource name of the admin cluster's hub membership.
               In the future, references to other resource types might be allowed if
               admin clusters are modeled as their own resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Annotations on the VMware User Cluster.
               This field has the same restrictions as Kubernetes annotations.
               The total size of all keys and values combined is limited to 256k.
               Key can have 2 segments: prefix (optional) and name (required),
               separated by a slash (/).
               Prefix must be a DNS subdomain.
               Name must be 63 characters or less, begin and end with alphanumerics,
               with dashes (-), underscores (_), dots (.), and alphanumerics between.
        :param pulumi.Input[pulumi.InputType['VMwareClusterAntiAffinityGroupsArgs']] anti_affinity_groups: AAGConfig specifies whether to spread VMware User Cluster nodes across at
               least three physical hosts in the datacenter.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['VMwareClusterAuthorizationArgs']] authorization: RBAC policy that will be applied and managed by GKE On-Prem.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['VMwareClusterAutoRepairConfigArgs']] auto_repair_config: Configuration for auto repairing.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['VMwareClusterControlPlaneNodeArgs']] control_plane_node: VMware User Cluster control plane nodes must have either 1 or 3 replicas.
               Structure is documented below.
        :param pulumi.Input[str] create_time: The time at which VMware User Cluster was created.
        :param pulumi.Input[pulumi.InputType['VMwareClusterDataplaneV2Args']] dataplane_v2: VmwareDataplaneV2Config specifies configuration for Dataplane V2.
               Structure is documented below.
        :param pulumi.Input[str] delete_time: The time at which VMware User Cluster was deleted.
        :param pulumi.Input[str] description: A human readable description of this VMware User Cluster.
        :param pulumi.Input[bool] enable_control_plane_v2: Enable control plane V2. Default to false.
        :param pulumi.Input[str] endpoint: The DNS name of VMware User Cluster's API server.
        :param pulumi.Input[str] etag: This checksum is computed by the server based on the value of other
               fields, and may be sent on update and delete requests to ensure the
               client has an up-to-date value before proceeding.
               Allows clients to perform consistent read-modify-writes
               through optimistic concurrency control.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VMwareClusterFleetArgs']]]] fleets: Fleet configuration for the cluster.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['VMwareClusterLoadBalancerArgs']] load_balancer: Load Balancer configuration.
               Structure is documented below.
        :param pulumi.Input[str] local_name: The object name of the VMware OnPremUserCluster custom resource on the
               associated admin cluster. This field is used to support conflicting
               names when enrolling existing clusters to the API. When used as a part of
               cluster enrollment, this field will differ from the ID in the resource
               name. For new clusters, this field will match the user provided cluster ID
               and be visible in the last component of the resource name. It is not
               modifiable.
               All users should use this name to access their cluster using gkectl or
               kubectl and should expect to see the local name when viewing admin
               cluster controller logs.
        :param pulumi.Input[str] location: The location of the resource.
        :param pulumi.Input[str] name: The VMware cluster name.
        :param pulumi.Input[pulumi.InputType['VMwareClusterNetworkConfigArgs']] network_config: The VMware User Cluster network configuration.
               Structure is documented below.
        :param pulumi.Input[str] on_prem_version: The Anthos clusters on the VMware version for your user cluster.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[bool] reconciling: If set, there are currently changes in flight to the VMware User Cluster.
        :param pulumi.Input[str] state: (Output)
               The lifecycle state of the condition.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VMwareClusterStatusArgs']]]] statuses: (Output)
               Specifies the detailed validation check status
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['VMwareClusterStorageArgs']] storage: Storage configuration.
               Structure is documented below.
        :param pulumi.Input[str] uid: The unique identifier of the VMware User Cluster.
        :param pulumi.Input[str] update_time: The time at which VMware User Cluster was last updated.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VMwareClusterValidationCheckArgs']]]] validation_checks: ValidationCheck represents the result of the preflight check job.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VMwareClusterVcenterArgs']]]] vcenters: VmwareVCenterConfig specifies vCenter config for the user cluster.
               Inherited from the admin cluster.
               Structure is documented below.
        :param pulumi.Input[bool] vm_tracking_enabled: Enable VM tracking.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VMwareClusterState.__new__(_VMwareClusterState)

        __props__.__dict__["admin_cluster_membership"] = admin_cluster_membership
        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["anti_affinity_groups"] = anti_affinity_groups
        __props__.__dict__["authorization"] = authorization
        __props__.__dict__["auto_repair_config"] = auto_repair_config
        __props__.__dict__["control_plane_node"] = control_plane_node
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["dataplane_v2"] = dataplane_v2
        __props__.__dict__["delete_time"] = delete_time
        __props__.__dict__["description"] = description
        __props__.__dict__["enable_control_plane_v2"] = enable_control_plane_v2
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["etag"] = etag
        __props__.__dict__["fleets"] = fleets
        __props__.__dict__["load_balancer"] = load_balancer
        __props__.__dict__["local_name"] = local_name
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["network_config"] = network_config
        __props__.__dict__["on_prem_version"] = on_prem_version
        __props__.__dict__["project"] = project
        __props__.__dict__["reconciling"] = reconciling
        __props__.__dict__["state"] = state
        __props__.__dict__["statuses"] = statuses
        __props__.__dict__["storage"] = storage
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["validation_checks"] = validation_checks
        __props__.__dict__["vcenters"] = vcenters
        __props__.__dict__["vm_tracking_enabled"] = vm_tracking_enabled
        return VMwareCluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="adminClusterMembership")
    def admin_cluster_membership(self) -> pulumi.Output[str]:
        """
        The admin cluster this VMware User Cluster belongs to.
        This is the full resource name of the admin cluster's hub membership.
        In the future, references to other resource types might be allowed if
        admin clusters are modeled as their own resources.
        """
        return pulumi.get(self, "admin_cluster_membership")

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Annotations on the VMware User Cluster.
        This field has the same restrictions as Kubernetes annotations.
        The total size of all keys and values combined is limited to 256k.
        Key can have 2 segments: prefix (optional) and name (required),
        separated by a slash (/).
        Prefix must be a DNS subdomain.
        Name must be 63 characters or less, begin and end with alphanumerics,
        with dashes (-), underscores (_), dots (.), and alphanumerics between.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="antiAffinityGroups")
    def anti_affinity_groups(self) -> pulumi.Output['outputs.VMwareClusterAntiAffinityGroups']:
        """
        AAGConfig specifies whether to spread VMware User Cluster nodes across at
        least three physical hosts in the datacenter.
        Structure is documented below.
        """
        return pulumi.get(self, "anti_affinity_groups")

    @property
    @pulumi.getter
    def authorization(self) -> pulumi.Output[Optional['outputs.VMwareClusterAuthorization']]:
        """
        RBAC policy that will be applied and managed by GKE On-Prem.
        Structure is documented below.
        """
        return pulumi.get(self, "authorization")

    @property
    @pulumi.getter(name="autoRepairConfig")
    def auto_repair_config(self) -> pulumi.Output['outputs.VMwareClusterAutoRepairConfig']:
        """
        Configuration for auto repairing.
        Structure is documented below.
        """
        return pulumi.get(self, "auto_repair_config")

    @property
    @pulumi.getter(name="controlPlaneNode")
    def control_plane_node(self) -> pulumi.Output['outputs.VMwareClusterControlPlaneNode']:
        """
        VMware User Cluster control plane nodes must have either 1 or 3 replicas.
        Structure is documented below.
        """
        return pulumi.get(self, "control_plane_node")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The time at which VMware User Cluster was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="dataplaneV2")
    def dataplane_v2(self) -> pulumi.Output['outputs.VMwareClusterDataplaneV2']:
        """
        VmwareDataplaneV2Config specifies configuration for Dataplane V2.
        Structure is documented below.
        """
        return pulumi.get(self, "dataplane_v2")

    @property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> pulumi.Output[str]:
        """
        The time at which VMware User Cluster was deleted.
        """
        return pulumi.get(self, "delete_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A human readable description of this VMware User Cluster.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enableControlPlaneV2")
    def enable_control_plane_v2(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable control plane V2. Default to false.
        """
        return pulumi.get(self, "enable_control_plane_v2")

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[str]:
        """
        The DNS name of VMware User Cluster's API server.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        """
        This checksum is computed by the server based on the value of other
        fields, and may be sent on update and delete requests to ensure the
        client has an up-to-date value before proceeding.
        Allows clients to perform consistent read-modify-writes
        through optimistic concurrency control.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def fleets(self) -> pulumi.Output[Sequence['outputs.VMwareClusterFleet']]:
        """
        Fleet configuration for the cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "fleets")

    @property
    @pulumi.getter(name="loadBalancer")
    def load_balancer(self) -> pulumi.Output[Optional['outputs.VMwareClusterLoadBalancer']]:
        """
        Load Balancer configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "load_balancer")

    @property
    @pulumi.getter(name="localName")
    def local_name(self) -> pulumi.Output[str]:
        """
        The object name of the VMware OnPremUserCluster custom resource on the
        associated admin cluster. This field is used to support conflicting
        names when enrolling existing clusters to the API. When used as a part of
        cluster enrollment, this field will differ from the ID in the resource
        name. For new clusters, this field will match the user provided cluster ID
        and be visible in the last component of the resource name. It is not
        modifiable.
        All users should use this name to access their cluster using gkectl or
        kubectl and should expect to see the local name when viewing admin
        cluster controller logs.
        """
        return pulumi.get(self, "local_name")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The location of the resource.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The VMware cluster name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> pulumi.Output[Optional['outputs.VMwareClusterNetworkConfig']]:
        """
        The VMware User Cluster network configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "network_config")

    @property
    @pulumi.getter(name="onPremVersion")
    def on_prem_version(self) -> pulumi.Output[str]:
        """
        The Anthos clusters on the VMware version for your user cluster.
        """
        return pulumi.get(self, "on_prem_version")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def reconciling(self) -> pulumi.Output[bool]:
        """
        If set, there are currently changes in flight to the VMware User Cluster.
        """
        return pulumi.get(self, "reconciling")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        (Output)
        The lifecycle state of the condition.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def statuses(self) -> pulumi.Output[Sequence['outputs.VMwareClusterStatus']]:
        """
        (Output)
        Specifies the detailed validation check status
        Structure is documented below.
        """
        return pulumi.get(self, "statuses")

    @property
    @pulumi.getter
    def storage(self) -> pulumi.Output['outputs.VMwareClusterStorage']:
        """
        Storage configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "storage")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[str]:
        """
        The unique identifier of the VMware User Cluster.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The time at which VMware User Cluster was last updated.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="validationChecks")
    def validation_checks(self) -> pulumi.Output[Sequence['outputs.VMwareClusterValidationCheck']]:
        """
        ValidationCheck represents the result of the preflight check job.
        Structure is documented below.
        """
        return pulumi.get(self, "validation_checks")

    @property
    @pulumi.getter
    def vcenters(self) -> pulumi.Output[Sequence['outputs.VMwareClusterVcenter']]:
        """
        VmwareVCenterConfig specifies vCenter config for the user cluster.
        Inherited from the admin cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "vcenters")

    @property
    @pulumi.getter(name="vmTrackingEnabled")
    def vm_tracking_enabled(self) -> pulumi.Output[bool]:
        """
        Enable VM tracking.
        """
        return pulumi.get(self, "vm_tracking_enabled")

