# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'InboundSamlConfigIdpConfig',
    'InboundSamlConfigIdpConfigIdpCertificate',
    'InboundSamlConfigSpConfig',
    'InboundSamlConfigSpConfigSpCertificate',
    'ProjectDefaultConfigSignIn',
    'ProjectDefaultConfigSignInAnonymous',
    'ProjectDefaultConfigSignInEmail',
    'ProjectDefaultConfigSignInHashConfig',
    'ProjectDefaultConfigSignInPhoneNumber',
    'TenantInboundSamlConfigIdpConfig',
    'TenantInboundSamlConfigIdpConfigIdpCertificate',
    'TenantInboundSamlConfigSpConfig',
    'TenantInboundSamlConfigSpConfigSpCertificate',
]

@pulumi.output_type
class InboundSamlConfigIdpConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "idpCertificates":
            suggest = "idp_certificates"
        elif key == "idpEntityId":
            suggest = "idp_entity_id"
        elif key == "ssoUrl":
            suggest = "sso_url"
        elif key == "signRequest":
            suggest = "sign_request"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InboundSamlConfigIdpConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InboundSamlConfigIdpConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InboundSamlConfigIdpConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 idp_certificates: Sequence['outputs.InboundSamlConfigIdpConfigIdpCertificate'],
                 idp_entity_id: str,
                 sso_url: str,
                 sign_request: Optional[bool] = None):
        """
        :param Sequence['InboundSamlConfigIdpConfigIdpCertificateArgs'] idp_certificates: The IdP's certificate data to verify the signature in the SAMLResponse issued by the IDP.
               Structure is documented below.
        :param str idp_entity_id: Unique identifier for all SAML entities
        :param str sso_url: URL to send Authentication request to.
        :param bool sign_request: Indicates if outbounding SAMLRequest should be signed.
        """
        pulumi.set(__self__, "idp_certificates", idp_certificates)
        pulumi.set(__self__, "idp_entity_id", idp_entity_id)
        pulumi.set(__self__, "sso_url", sso_url)
        if sign_request is not None:
            pulumi.set(__self__, "sign_request", sign_request)

    @property
    @pulumi.getter(name="idpCertificates")
    def idp_certificates(self) -> Sequence['outputs.InboundSamlConfigIdpConfigIdpCertificate']:
        """
        The IdP's certificate data to verify the signature in the SAMLResponse issued by the IDP.
        Structure is documented below.
        """
        return pulumi.get(self, "idp_certificates")

    @property
    @pulumi.getter(name="idpEntityId")
    def idp_entity_id(self) -> str:
        """
        Unique identifier for all SAML entities
        """
        return pulumi.get(self, "idp_entity_id")

    @property
    @pulumi.getter(name="ssoUrl")
    def sso_url(self) -> str:
        """
        URL to send Authentication request to.
        """
        return pulumi.get(self, "sso_url")

    @property
    @pulumi.getter(name="signRequest")
    def sign_request(self) -> Optional[bool]:
        """
        Indicates if outbounding SAMLRequest should be signed.
        """
        return pulumi.get(self, "sign_request")


@pulumi.output_type
class InboundSamlConfigIdpConfigIdpCertificate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "x509Certificate":
            suggest = "x509_certificate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InboundSamlConfigIdpConfigIdpCertificate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InboundSamlConfigIdpConfigIdpCertificate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InboundSamlConfigIdpConfigIdpCertificate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 x509_certificate: Optional[str] = None):
        """
        :param str x509_certificate: The IdP's x509 certificate.
        """
        if x509_certificate is not None:
            pulumi.set(__self__, "x509_certificate", x509_certificate)

    @property
    @pulumi.getter(name="x509Certificate")
    def x509_certificate(self) -> Optional[str]:
        """
        The IdP's x509 certificate.
        """
        return pulumi.get(self, "x509_certificate")


@pulumi.output_type
class InboundSamlConfigSpConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "callbackUri":
            suggest = "callback_uri"
        elif key == "spCertificates":
            suggest = "sp_certificates"
        elif key == "spEntityId":
            suggest = "sp_entity_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InboundSamlConfigSpConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InboundSamlConfigSpConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InboundSamlConfigSpConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 callback_uri: Optional[str] = None,
                 sp_certificates: Optional[Sequence['outputs.InboundSamlConfigSpConfigSpCertificate']] = None,
                 sp_entity_id: Optional[str] = None):
        """
        :param str callback_uri: Callback URI where responses from IDP are handled. Must start with `https://`.
        :param Sequence['InboundSamlConfigSpConfigSpCertificateArgs'] sp_certificates: (Output)
               The IDP's certificate data to verify the signature in the SAMLResponse issued by the IDP.
               Structure is documented below.
               
               
               <a name="nested_sp_certificates"></a>The `sp_certificates` block contains:
        :param str sp_entity_id: Unique identifier for all SAML entities.
        """
        if callback_uri is not None:
            pulumi.set(__self__, "callback_uri", callback_uri)
        if sp_certificates is not None:
            pulumi.set(__self__, "sp_certificates", sp_certificates)
        if sp_entity_id is not None:
            pulumi.set(__self__, "sp_entity_id", sp_entity_id)

    @property
    @pulumi.getter(name="callbackUri")
    def callback_uri(self) -> Optional[str]:
        """
        Callback URI where responses from IDP are handled. Must start with `https://`.
        """
        return pulumi.get(self, "callback_uri")

    @property
    @pulumi.getter(name="spCertificates")
    def sp_certificates(self) -> Optional[Sequence['outputs.InboundSamlConfigSpConfigSpCertificate']]:
        """
        (Output)
        The IDP's certificate data to verify the signature in the SAMLResponse issued by the IDP.
        Structure is documented below.


        <a name="nested_sp_certificates"></a>The `sp_certificates` block contains:
        """
        return pulumi.get(self, "sp_certificates")

    @property
    @pulumi.getter(name="spEntityId")
    def sp_entity_id(self) -> Optional[str]:
        """
        Unique identifier for all SAML entities.
        """
        return pulumi.get(self, "sp_entity_id")


@pulumi.output_type
class InboundSamlConfigSpConfigSpCertificate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "x509Certificate":
            suggest = "x509_certificate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InboundSamlConfigSpConfigSpCertificate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InboundSamlConfigSpConfigSpCertificate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InboundSamlConfigSpConfigSpCertificate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 x509_certificate: Optional[str] = None):
        """
        :param str x509_certificate: The IdP's x509 certificate.
               
               (Output)
               The x509 certificate
               
               - - -
        """
        if x509_certificate is not None:
            pulumi.set(__self__, "x509_certificate", x509_certificate)

    @property
    @pulumi.getter(name="x509Certificate")
    def x509_certificate(self) -> Optional[str]:
        """
        The IdP's x509 certificate.

        (Output)
        The x509 certificate

        - - -
        """
        return pulumi.get(self, "x509_certificate")


@pulumi.output_type
class ProjectDefaultConfigSignIn(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowDuplicateEmails":
            suggest = "allow_duplicate_emails"
        elif key == "hashConfigs":
            suggest = "hash_configs"
        elif key == "phoneNumber":
            suggest = "phone_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectDefaultConfigSignIn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectDefaultConfigSignIn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectDefaultConfigSignIn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_duplicate_emails: Optional[bool] = None,
                 anonymous: Optional['outputs.ProjectDefaultConfigSignInAnonymous'] = None,
                 email: Optional['outputs.ProjectDefaultConfigSignInEmail'] = None,
                 hash_configs: Optional[Sequence['outputs.ProjectDefaultConfigSignInHashConfig']] = None,
                 phone_number: Optional['outputs.ProjectDefaultConfigSignInPhoneNumber'] = None):
        """
        :param bool allow_duplicate_emails: Whether to allow more than one account to have the same email.
        :param 'ProjectDefaultConfigSignInAnonymousArgs' anonymous: Configuration options related to authenticating an anonymous user.
               Structure is documented below.
        :param 'ProjectDefaultConfigSignInEmailArgs' email: Configuration options related to authenticating a user by their email address.
               Structure is documented below.
        :param Sequence['ProjectDefaultConfigSignInHashConfigArgs'] hash_configs: (Output)
               Output only. Hash config information.
               Structure is documented below.
        :param 'ProjectDefaultConfigSignInPhoneNumberArgs' phone_number: Configuration options related to authenticated a user by their phone number.
               Structure is documented below.
        """
        if allow_duplicate_emails is not None:
            pulumi.set(__self__, "allow_duplicate_emails", allow_duplicate_emails)
        if anonymous is not None:
            pulumi.set(__self__, "anonymous", anonymous)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if hash_configs is not None:
            pulumi.set(__self__, "hash_configs", hash_configs)
        if phone_number is not None:
            pulumi.set(__self__, "phone_number", phone_number)

    @property
    @pulumi.getter(name="allowDuplicateEmails")
    def allow_duplicate_emails(self) -> Optional[bool]:
        """
        Whether to allow more than one account to have the same email.
        """
        return pulumi.get(self, "allow_duplicate_emails")

    @property
    @pulumi.getter
    def anonymous(self) -> Optional['outputs.ProjectDefaultConfigSignInAnonymous']:
        """
        Configuration options related to authenticating an anonymous user.
        Structure is documented below.
        """
        return pulumi.get(self, "anonymous")

    @property
    @pulumi.getter
    def email(self) -> Optional['outputs.ProjectDefaultConfigSignInEmail']:
        """
        Configuration options related to authenticating a user by their email address.
        Structure is documented below.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="hashConfigs")
    def hash_configs(self) -> Optional[Sequence['outputs.ProjectDefaultConfigSignInHashConfig']]:
        """
        (Output)
        Output only. Hash config information.
        Structure is documented below.
        """
        return pulumi.get(self, "hash_configs")

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> Optional['outputs.ProjectDefaultConfigSignInPhoneNumber']:
        """
        Configuration options related to authenticated a user by their phone number.
        Structure is documented below.
        """
        return pulumi.get(self, "phone_number")


@pulumi.output_type
class ProjectDefaultConfigSignInAnonymous(dict):
    def __init__(__self__, *,
                 enabled: bool):
        """
        :param bool enabled: Whether anonymous user auth is enabled for the project or not.
               
               <a name="nested_hash_config"></a>The `hash_config` block contains:
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether anonymous user auth is enabled for the project or not.

        <a name="nested_hash_config"></a>The `hash_config` block contains:
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ProjectDefaultConfigSignInEmail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "passwordRequired":
            suggest = "password_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectDefaultConfigSignInEmail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectDefaultConfigSignInEmail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectDefaultConfigSignInEmail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 password_required: Optional[bool] = None):
        """
        :param bool enabled: Whether email auth is enabled for the project or not.
        :param bool password_required: Whether a password is required for email auth or not. If true, both an email and
               password must be provided to sign in. If false, a user may sign in via either
               email/password or email link.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if password_required is not None:
            pulumi.set(__self__, "password_required", password_required)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Whether email auth is enabled for the project or not.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="passwordRequired")
    def password_required(self) -> Optional[bool]:
        """
        Whether a password is required for email auth or not. If true, both an email and
        password must be provided to sign in. If false, a user may sign in via either
        email/password or email link.
        """
        return pulumi.get(self, "password_required")


@pulumi.output_type
class ProjectDefaultConfigSignInHashConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memoryCost":
            suggest = "memory_cost"
        elif key == "saltSeparator":
            suggest = "salt_separator"
        elif key == "signerKey":
            suggest = "signer_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectDefaultConfigSignInHashConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectDefaultConfigSignInHashConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectDefaultConfigSignInHashConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 algorithm: Optional[str] = None,
                 memory_cost: Optional[int] = None,
                 rounds: Optional[int] = None,
                 salt_separator: Optional[str] = None,
                 signer_key: Optional[str] = None):
        """
        :param str algorithm: (Output)
               Different password hash algorithms used in Identity Toolkit.
        :param int memory_cost: (Output)
               Memory cost for hash calculation. Used by scrypt and other similar password derivation algorithms. See https://tools.ietf.org/html/rfc7914 for explanation of field.
        :param int rounds: (Output)
               How many rounds for hash calculation. Used by scrypt and other similar password derivation algorithms.
        :param str salt_separator: (Output)
               Non-printable character to be inserted between the salt and plain text password in base64.
        :param str signer_key: (Output)
               Signer key in base64.
        """
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if memory_cost is not None:
            pulumi.set(__self__, "memory_cost", memory_cost)
        if rounds is not None:
            pulumi.set(__self__, "rounds", rounds)
        if salt_separator is not None:
            pulumi.set(__self__, "salt_separator", salt_separator)
        if signer_key is not None:
            pulumi.set(__self__, "signer_key", signer_key)

    @property
    @pulumi.getter
    def algorithm(self) -> Optional[str]:
        """
        (Output)
        Different password hash algorithms used in Identity Toolkit.
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter(name="memoryCost")
    def memory_cost(self) -> Optional[int]:
        """
        (Output)
        Memory cost for hash calculation. Used by scrypt and other similar password derivation algorithms. See https://tools.ietf.org/html/rfc7914 for explanation of field.
        """
        return pulumi.get(self, "memory_cost")

    @property
    @pulumi.getter
    def rounds(self) -> Optional[int]:
        """
        (Output)
        How many rounds for hash calculation. Used by scrypt and other similar password derivation algorithms.
        """
        return pulumi.get(self, "rounds")

    @property
    @pulumi.getter(name="saltSeparator")
    def salt_separator(self) -> Optional[str]:
        """
        (Output)
        Non-printable character to be inserted between the salt and plain text password in base64.
        """
        return pulumi.get(self, "salt_separator")

    @property
    @pulumi.getter(name="signerKey")
    def signer_key(self) -> Optional[str]:
        """
        (Output)
        Signer key in base64.
        """
        return pulumi.get(self, "signer_key")


@pulumi.output_type
class ProjectDefaultConfigSignInPhoneNumber(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "testPhoneNumbers":
            suggest = "test_phone_numbers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectDefaultConfigSignInPhoneNumber. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectDefaultConfigSignInPhoneNumber.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectDefaultConfigSignInPhoneNumber.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 test_phone_numbers: Optional[Mapping[str, str]] = None):
        """
        :param bool enabled: Whether phone number auth is enabled for the project or not.
        :param Mapping[str, str] test_phone_numbers: A map of <test phone number, fake code> that can be used for phone auth testing.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if test_phone_numbers is not None:
            pulumi.set(__self__, "test_phone_numbers", test_phone_numbers)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Whether phone number auth is enabled for the project or not.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="testPhoneNumbers")
    def test_phone_numbers(self) -> Optional[Mapping[str, str]]:
        """
        A map of <test phone number, fake code> that can be used for phone auth testing.
        """
        return pulumi.get(self, "test_phone_numbers")


@pulumi.output_type
class TenantInboundSamlConfigIdpConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "idpCertificates":
            suggest = "idp_certificates"
        elif key == "idpEntityId":
            suggest = "idp_entity_id"
        elif key == "ssoUrl":
            suggest = "sso_url"
        elif key == "signRequest":
            suggest = "sign_request"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TenantInboundSamlConfigIdpConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TenantInboundSamlConfigIdpConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TenantInboundSamlConfigIdpConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 idp_certificates: Sequence['outputs.TenantInboundSamlConfigIdpConfigIdpCertificate'],
                 idp_entity_id: str,
                 sso_url: str,
                 sign_request: Optional[bool] = None):
        """
        :param Sequence['TenantInboundSamlConfigIdpConfigIdpCertificateArgs'] idp_certificates: The IDP's certificate data to verify the signature in the SAMLResponse issued by the IDP.
               Structure is documented below.
        :param str idp_entity_id: Unique identifier for all SAML entities
        :param str sso_url: URL to send Authentication request to.
        :param bool sign_request: Indicates if outbounding SAMLRequest should be signed.
        """
        pulumi.set(__self__, "idp_certificates", idp_certificates)
        pulumi.set(__self__, "idp_entity_id", idp_entity_id)
        pulumi.set(__self__, "sso_url", sso_url)
        if sign_request is not None:
            pulumi.set(__self__, "sign_request", sign_request)

    @property
    @pulumi.getter(name="idpCertificates")
    def idp_certificates(self) -> Sequence['outputs.TenantInboundSamlConfigIdpConfigIdpCertificate']:
        """
        The IDP's certificate data to verify the signature in the SAMLResponse issued by the IDP.
        Structure is documented below.
        """
        return pulumi.get(self, "idp_certificates")

    @property
    @pulumi.getter(name="idpEntityId")
    def idp_entity_id(self) -> str:
        """
        Unique identifier for all SAML entities
        """
        return pulumi.get(self, "idp_entity_id")

    @property
    @pulumi.getter(name="ssoUrl")
    def sso_url(self) -> str:
        """
        URL to send Authentication request to.
        """
        return pulumi.get(self, "sso_url")

    @property
    @pulumi.getter(name="signRequest")
    def sign_request(self) -> Optional[bool]:
        """
        Indicates if outbounding SAMLRequest should be signed.
        """
        return pulumi.get(self, "sign_request")


@pulumi.output_type
class TenantInboundSamlConfigIdpConfigIdpCertificate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "x509Certificate":
            suggest = "x509_certificate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TenantInboundSamlConfigIdpConfigIdpCertificate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TenantInboundSamlConfigIdpConfigIdpCertificate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TenantInboundSamlConfigIdpConfigIdpCertificate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 x509_certificate: Optional[str] = None):
        """
        :param str x509_certificate: The x509 certificate
        """
        if x509_certificate is not None:
            pulumi.set(__self__, "x509_certificate", x509_certificate)

    @property
    @pulumi.getter(name="x509Certificate")
    def x509_certificate(self) -> Optional[str]:
        """
        The x509 certificate
        """
        return pulumi.get(self, "x509_certificate")


@pulumi.output_type
class TenantInboundSamlConfigSpConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "callbackUri":
            suggest = "callback_uri"
        elif key == "spEntityId":
            suggest = "sp_entity_id"
        elif key == "spCertificates":
            suggest = "sp_certificates"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TenantInboundSamlConfigSpConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TenantInboundSamlConfigSpConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TenantInboundSamlConfigSpConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 callback_uri: str,
                 sp_entity_id: str,
                 sp_certificates: Optional[Sequence['outputs.TenantInboundSamlConfigSpConfigSpCertificate']] = None):
        """
        :param str callback_uri: Callback URI where responses from IDP are handled. Must start with `https://`.
        :param str sp_entity_id: Unique identifier for all SAML entities.
        :param Sequence['TenantInboundSamlConfigSpConfigSpCertificateArgs'] sp_certificates: (Output)
               The IDP's certificate data to verify the signature in the SAMLResponse issued by the IDP.
               Structure is documented below.
               
               
               <a name="nested_sp_certificates"></a>The `sp_certificates` block contains:
        """
        pulumi.set(__self__, "callback_uri", callback_uri)
        pulumi.set(__self__, "sp_entity_id", sp_entity_id)
        if sp_certificates is not None:
            pulumi.set(__self__, "sp_certificates", sp_certificates)

    @property
    @pulumi.getter(name="callbackUri")
    def callback_uri(self) -> str:
        """
        Callback URI where responses from IDP are handled. Must start with `https://`.
        """
        return pulumi.get(self, "callback_uri")

    @property
    @pulumi.getter(name="spEntityId")
    def sp_entity_id(self) -> str:
        """
        Unique identifier for all SAML entities.
        """
        return pulumi.get(self, "sp_entity_id")

    @property
    @pulumi.getter(name="spCertificates")
    def sp_certificates(self) -> Optional[Sequence['outputs.TenantInboundSamlConfigSpConfigSpCertificate']]:
        """
        (Output)
        The IDP's certificate data to verify the signature in the SAMLResponse issued by the IDP.
        Structure is documented below.


        <a name="nested_sp_certificates"></a>The `sp_certificates` block contains:
        """
        return pulumi.get(self, "sp_certificates")


@pulumi.output_type
class TenantInboundSamlConfigSpConfigSpCertificate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "x509Certificate":
            suggest = "x509_certificate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TenantInboundSamlConfigSpConfigSpCertificate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TenantInboundSamlConfigSpConfigSpCertificate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TenantInboundSamlConfigSpConfigSpCertificate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 x509_certificate: Optional[str] = None):
        """
        :param str x509_certificate: The x509 certificate
               
               (Output)
               The x509 certificate
               
               - - -
        """
        if x509_certificate is not None:
            pulumi.set(__self__, "x509_certificate", x509_certificate)

    @property
    @pulumi.getter(name="x509Certificate")
    def x509_certificate(self) -> Optional[str]:
        """
        The x509 certificate

        (Output)
        The x509 certificate

        - - -
        """
        return pulumi.get(self, "x509_certificate")


