# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProjectDefaultConfigArgs', 'ProjectDefaultConfig']

@pulumi.input_type
class ProjectDefaultConfigArgs:
    def __init__(__self__, *,
                 project: Optional[pulumi.Input[str]] = None,
                 sign_in: Optional[pulumi.Input['ProjectDefaultConfigSignInArgs']] = None):
        """
        The set of arguments for constructing a ProjectDefaultConfig resource.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['ProjectDefaultConfigSignInArgs'] sign_in: Configuration related to local sign in methods.
               Structure is documented below.
        """
        if project is not None:
            pulumi.set(__self__, "project", project)
        if sign_in is not None:
            pulumi.set(__self__, "sign_in", sign_in)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="signIn")
    def sign_in(self) -> Optional[pulumi.Input['ProjectDefaultConfigSignInArgs']]:
        """
        Configuration related to local sign in methods.
        Structure is documented below.
        """
        return pulumi.get(self, "sign_in")

    @sign_in.setter
    def sign_in(self, value: Optional[pulumi.Input['ProjectDefaultConfigSignInArgs']]):
        pulumi.set(self, "sign_in", value)


@pulumi.input_type
class _ProjectDefaultConfigState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 sign_in: Optional[pulumi.Input['ProjectDefaultConfigSignInArgs']] = None):
        """
        Input properties used for looking up and filtering ProjectDefaultConfig resources.
        :param pulumi.Input[str] name: The name of the Config resource. Example: "projects/my-awesome-project/config"
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['ProjectDefaultConfigSignInArgs'] sign_in: Configuration related to local sign in methods.
               Structure is documented below.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if sign_in is not None:
            pulumi.set(__self__, "sign_in", sign_in)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Config resource. Example: "projects/my-awesome-project/config"
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="signIn")
    def sign_in(self) -> Optional[pulumi.Input['ProjectDefaultConfigSignInArgs']]:
        """
        Configuration related to local sign in methods.
        Structure is documented below.
        """
        return pulumi.get(self, "sign_in")

    @sign_in.setter
    def sign_in(self, value: Optional[pulumi.Input['ProjectDefaultConfigSignInArgs']]):
        pulumi.set(self, "sign_in", value)


class ProjectDefaultConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 sign_in: Optional[pulumi.Input[pulumi.InputType['ProjectDefaultConfigSignInArgs']]] = None,
                 __props__=None):
        """
        There is no persistent data associated with this resource.

        > **Warning:** If you are using User ADCs (Application Default Credentials) with this resource,
        you must specify a `billing_project` and set `user_project_override` to true
        in the provider configuration. Otherwise the ACM API will return a 403 error.
        Your account must have the `serviceusage.services.use` permission on the
        `billing_project` you defined.

        ## Example Usage
        ### Identity Platform Project Default Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.identityplatform.ProjectDefaultConfig("default", sign_in=gcp.identityplatform.ProjectDefaultConfigSignInArgs(
            allow_duplicate_emails=True,
            anonymous=gcp.identityplatform.ProjectDefaultConfigSignInAnonymousArgs(
                enabled=True,
            ),
            email=gcp.identityplatform.ProjectDefaultConfigSignInEmailArgs(
                enabled=True,
                password_required=False,
            ),
            phone_number=gcp.identityplatform.ProjectDefaultConfigSignInPhoneNumberArgs(
                enabled=True,
                test_phone_numbers={
                    "+11231231234": "000000",
                },
            ),
        ))
        ```

        ## Import

        ProjectDefaultConfig can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:identityplatform/projectDefaultConfig:ProjectDefaultConfig default projects/{{project}}/config/{{name}}
        ```

        ```sh
         $ pulumi import gcp:identityplatform/projectDefaultConfig:ProjectDefaultConfig default {{project}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:identityplatform/projectDefaultConfig:ProjectDefaultConfig default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[pulumi.InputType['ProjectDefaultConfigSignInArgs']] sign_in: Configuration related to local sign in methods.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProjectDefaultConfigArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        There is no persistent data associated with this resource.

        > **Warning:** If you are using User ADCs (Application Default Credentials) with this resource,
        you must specify a `billing_project` and set `user_project_override` to true
        in the provider configuration. Otherwise the ACM API will return a 403 error.
        Your account must have the `serviceusage.services.use` permission on the
        `billing_project` you defined.

        ## Example Usage
        ### Identity Platform Project Default Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.identityplatform.ProjectDefaultConfig("default", sign_in=gcp.identityplatform.ProjectDefaultConfigSignInArgs(
            allow_duplicate_emails=True,
            anonymous=gcp.identityplatform.ProjectDefaultConfigSignInAnonymousArgs(
                enabled=True,
            ),
            email=gcp.identityplatform.ProjectDefaultConfigSignInEmailArgs(
                enabled=True,
                password_required=False,
            ),
            phone_number=gcp.identityplatform.ProjectDefaultConfigSignInPhoneNumberArgs(
                enabled=True,
                test_phone_numbers={
                    "+11231231234": "000000",
                },
            ),
        ))
        ```

        ## Import

        ProjectDefaultConfig can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:identityplatform/projectDefaultConfig:ProjectDefaultConfig default projects/{{project}}/config/{{name}}
        ```

        ```sh
         $ pulumi import gcp:identityplatform/projectDefaultConfig:ProjectDefaultConfig default {{project}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:identityplatform/projectDefaultConfig:ProjectDefaultConfig default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param ProjectDefaultConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectDefaultConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 sign_in: Optional[pulumi.Input[pulumi.InputType['ProjectDefaultConfigSignInArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectDefaultConfigArgs.__new__(ProjectDefaultConfigArgs)

            __props__.__dict__["project"] = project
            __props__.__dict__["sign_in"] = sign_in
            __props__.__dict__["name"] = None
        super(ProjectDefaultConfig, __self__).__init__(
            'gcp:identityplatform/projectDefaultConfig:ProjectDefaultConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            sign_in: Optional[pulumi.Input[pulumi.InputType['ProjectDefaultConfigSignInArgs']]] = None) -> 'ProjectDefaultConfig':
        """
        Get an existing ProjectDefaultConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: The name of the Config resource. Example: "projects/my-awesome-project/config"
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[pulumi.InputType['ProjectDefaultConfigSignInArgs']] sign_in: Configuration related to local sign in methods.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectDefaultConfigState.__new__(_ProjectDefaultConfigState)

        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["sign_in"] = sign_in
        return ProjectDefaultConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Config resource. Example: "projects/my-awesome-project/config"
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="signIn")
    def sign_in(self) -> pulumi.Output[Optional['outputs.ProjectDefaultConfigSignIn']]:
        """
        Configuration related to local sign in methods.
        Structure is documented below.
        """
        return pulumi.get(self, "sign_in")

