# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetKeyRingIamPolicyResult',
    'AwaitableGetKeyRingIamPolicyResult',
    'get_key_ring_iam_policy',
    'get_key_ring_iam_policy_output',
]

@pulumi.output_type
class GetKeyRingIamPolicyResult:
    """
    A collection of values returned by getKeyRingIamPolicy.
    """
    def __init__(__self__, etag=None, id=None, key_ring_id=None, policy_data=None):
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key_ring_id and not isinstance(key_ring_id, str):
            raise TypeError("Expected argument 'key_ring_id' to be a str")
        pulumi.set(__self__, "key_ring_id", key_ring_id)
        if policy_data and not isinstance(policy_data, str):
            raise TypeError("Expected argument 'policy_data' to be a str")
        pulumi.set(__self__, "policy_data", policy_data)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        (Computed) The etag of the IAM policy.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="keyRingId")
    def key_ring_id(self) -> str:
        return pulumi.get(self, "key_ring_id")

    @property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> str:
        """
        (Computed) The policy data
        """
        return pulumi.get(self, "policy_data")


class AwaitableGetKeyRingIamPolicyResult(GetKeyRingIamPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKeyRingIamPolicyResult(
            etag=self.etag,
            id=self.id,
            key_ring_id=self.key_ring_id,
            policy_data=self.policy_data)


def get_key_ring_iam_policy(key_ring_id: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKeyRingIamPolicyResult:
    """
    Retrieves the current IAM policy data for a Google Cloud KMS key ring.

    ## example

    ```python
    import pulumi
    import pulumi_gcp as gcp

    test_key_ring_iam_policy = gcp.kms.get_key_ring_iam_policy(key_ring_id="{project_id}/{location_name}/{key_ring_name}")
    ```


    :param str key_ring_id: The key ring ID, in the form
           `{project_id}/{location_name}/{key_ring_name}` or
           `{location_name}/{key_ring_name}`. In the second form, the provider's
           project setting will be used as a fallback.
    """
    __args__ = dict()
    __args__['keyRingId'] = key_ring_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:kms/getKeyRingIamPolicy:getKeyRingIamPolicy', __args__, opts=opts, typ=GetKeyRingIamPolicyResult).value

    return AwaitableGetKeyRingIamPolicyResult(
        etag=pulumi.get(__ret__, 'etag'),
        id=pulumi.get(__ret__, 'id'),
        key_ring_id=pulumi.get(__ret__, 'key_ring_id'),
        policy_data=pulumi.get(__ret__, 'policy_data'))


@_utilities.lift_output_func(get_key_ring_iam_policy)
def get_key_ring_iam_policy_output(key_ring_id: Optional[pulumi.Input[str]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetKeyRingIamPolicyResult]:
    """
    Retrieves the current IAM policy data for a Google Cloud KMS key ring.

    ## example

    ```python
    import pulumi
    import pulumi_gcp as gcp

    test_key_ring_iam_policy = gcp.kms.get_key_ring_iam_policy(key_ring_id="{project_id}/{location_name}/{key_ring_name}")
    ```


    :param str key_ring_id: The key ring ID, in the form
           `{project_id}/{location_name}/{key_ring_name}` or
           `{location_name}/{key_ring_name}`. In the second form, the provider's
           project setting will be used as a fallback.
    """
    ...
