# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'BillingAccountBucketConfigCmekSettings',
    'BillingAccountSinkBigqueryOptions',
    'BillingAccountSinkExclusion',
    'FolderBucketConfigCmekSettings',
    'FolderSinkBigqueryOptions',
    'FolderSinkExclusion',
    'LinkedDatasetBigqueryDataset',
    'MetricBucketOptions',
    'MetricBucketOptionsExplicitBuckets',
    'MetricBucketOptionsExponentialBuckets',
    'MetricBucketOptionsLinearBuckets',
    'MetricMetricDescriptor',
    'MetricMetricDescriptorLabel',
    'OrganizationBucketConfigCmekSettings',
    'OrganizationSinkBigqueryOptions',
    'OrganizationSinkExclusion',
    'ProjectBucketConfigCmekSettings',
    'ProjectSinkBigqueryOptions',
    'ProjectSinkExclusion',
    'GetSinkBigqueryOptionResult',
    'GetSinkExclusionResult',
]

@pulumi.output_type
class BillingAccountBucketConfigCmekSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"
        elif key == "kmsKeyVersionName":
            suggest = "kms_key_version_name"
        elif key == "serviceAccountId":
            suggest = "service_account_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BillingAccountBucketConfigCmekSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BillingAccountBucketConfigCmekSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BillingAccountBucketConfigCmekSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: str,
                 kms_key_version_name: Optional[str] = None,
                 name: Optional[str] = None,
                 service_account_id: Optional[str] = None):
        """
        :param str name: The resource name of the bucket. For example: "projects/my-project-id/locations/my-location/buckets/my-bucket-id"
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)
        if kms_key_version_name is not None:
            pulumi.set(__self__, "kms_key_version_name", kms_key_version_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_account_id is not None:
            pulumi.set(__self__, "service_account_id", service_account_id)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> str:
        return pulumi.get(self, "kms_key_name")

    @property
    @pulumi.getter(name="kmsKeyVersionName")
    def kms_key_version_name(self) -> Optional[str]:
        return pulumi.get(self, "kms_key_version_name")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The resource name of the bucket. For example: "projects/my-project-id/locations/my-location/buckets/my-bucket-id"
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> Optional[str]:
        return pulumi.get(self, "service_account_id")


@pulumi.output_type
class BillingAccountSinkBigqueryOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "usePartitionedTables":
            suggest = "use_partitioned_tables"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BillingAccountSinkBigqueryOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BillingAccountSinkBigqueryOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BillingAccountSinkBigqueryOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 use_partitioned_tables: bool):
        """
        :param bool use_partitioned_tables: Whether to use [BigQuery's partition tables](https://cloud.google.com/bigquery/docs/partitioned-tables).
               By default, Logging creates dated tables based on the log entries' timestamps, e.g. syslog_20170523. With partitioned
               tables, the date suffix is no longer present and [special query syntax](https://cloud.google.com/bigquery/docs/querying-partitioned-tables)
               has to be used instead. In both cases, tables are sharded based on UTC timezone.
        """
        pulumi.set(__self__, "use_partitioned_tables", use_partitioned_tables)

    @property
    @pulumi.getter(name="usePartitionedTables")
    def use_partitioned_tables(self) -> bool:
        """
        Whether to use [BigQuery's partition tables](https://cloud.google.com/bigquery/docs/partitioned-tables).
        By default, Logging creates dated tables based on the log entries' timestamps, e.g. syslog_20170523. With partitioned
        tables, the date suffix is no longer present and [special query syntax](https://cloud.google.com/bigquery/docs/querying-partitioned-tables)
        has to be used instead. In both cases, tables are sharded based on UTC timezone.
        """
        return pulumi.get(self, "use_partitioned_tables")


@pulumi.output_type
class BillingAccountSinkExclusion(dict):
    def __init__(__self__, *,
                 filter: str,
                 name: str,
                 description: Optional[str] = None,
                 disabled: Optional[bool] = None):
        """
        :param str filter: An advanced logs filter that matches the log entries to be excluded. By using the sample function, you can exclude less than 100% of the matching log entries. See [Advanced Log Filters](https://cloud.google.com/logging/docs/view/advanced_filters) for information on how to
               write a filter.
        :param str name: A client-assigned identifier, such as `load-balancer-exclusion`. Identifiers are limited to 100 characters and can include only letters, digits, underscores, hyphens, and periods. First character has to be alphanumeric.
        :param str description: A description of this exclusion.
        :param bool disabled: If set to True, then this exclusion is disabled and it does not exclude any log entries.
        """
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)

    @property
    @pulumi.getter
    def filter(self) -> str:
        """
        An advanced logs filter that matches the log entries to be excluded. By using the sample function, you can exclude less than 100% of the matching log entries. See [Advanced Log Filters](https://cloud.google.com/logging/docs/view/advanced_filters) for information on how to
        write a filter.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A client-assigned identifier, such as `load-balancer-exclusion`. Identifiers are limited to 100 characters and can include only letters, digits, underscores, hyphens, and periods. First character has to be alphanumeric.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of this exclusion.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        """
        If set to True, then this exclusion is disabled and it does not exclude any log entries.
        """
        return pulumi.get(self, "disabled")


@pulumi.output_type
class FolderBucketConfigCmekSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"
        elif key == "kmsKeyVersionName":
            suggest = "kms_key_version_name"
        elif key == "serviceAccountId":
            suggest = "service_account_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FolderBucketConfigCmekSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FolderBucketConfigCmekSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FolderBucketConfigCmekSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: str,
                 kms_key_version_name: Optional[str] = None,
                 name: Optional[str] = None,
                 service_account_id: Optional[str] = None):
        """
        :param str name: The resource name of the bucket. For example: "folders/my-folder-id/locations/my-location/buckets/my-bucket-id"
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)
        if kms_key_version_name is not None:
            pulumi.set(__self__, "kms_key_version_name", kms_key_version_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_account_id is not None:
            pulumi.set(__self__, "service_account_id", service_account_id)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> str:
        return pulumi.get(self, "kms_key_name")

    @property
    @pulumi.getter(name="kmsKeyVersionName")
    def kms_key_version_name(self) -> Optional[str]:
        return pulumi.get(self, "kms_key_version_name")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The resource name of the bucket. For example: "folders/my-folder-id/locations/my-location/buckets/my-bucket-id"
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> Optional[str]:
        return pulumi.get(self, "service_account_id")


@pulumi.output_type
class FolderSinkBigqueryOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "usePartitionedTables":
            suggest = "use_partitioned_tables"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FolderSinkBigqueryOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FolderSinkBigqueryOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FolderSinkBigqueryOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 use_partitioned_tables: bool):
        """
        :param bool use_partitioned_tables: Whether to use [BigQuery's partition tables](https://cloud.google.com/bigquery/docs/partitioned-tables).
               By default, Logging creates dated tables based on the log entries' timestamps, e.g. syslog_20170523. With partitioned
               tables, the date suffix is no longer present and [special query syntax](https://cloud.google.com/bigquery/docs/querying-partitioned-tables)
               has to be used instead. In both cases, tables are sharded based on UTC timezone.
        """
        pulumi.set(__self__, "use_partitioned_tables", use_partitioned_tables)

    @property
    @pulumi.getter(name="usePartitionedTables")
    def use_partitioned_tables(self) -> bool:
        """
        Whether to use [BigQuery's partition tables](https://cloud.google.com/bigquery/docs/partitioned-tables).
        By default, Logging creates dated tables based on the log entries' timestamps, e.g. syslog_20170523. With partitioned
        tables, the date suffix is no longer present and [special query syntax](https://cloud.google.com/bigquery/docs/querying-partitioned-tables)
        has to be used instead. In both cases, tables are sharded based on UTC timezone.
        """
        return pulumi.get(self, "use_partitioned_tables")


@pulumi.output_type
class FolderSinkExclusion(dict):
    def __init__(__self__, *,
                 filter: str,
                 name: str,
                 description: Optional[str] = None,
                 disabled: Optional[bool] = None):
        """
        :param str filter: An advanced logs filter that matches the log entries to be excluded. By using the sample function, you can exclude less than 100% of the matching log entries. See [Advanced Log Filters](https://cloud.google.com/logging/docs/view/advanced_filters) for information on how to
               write a filter.
        :param str name: A client-assigned identifier, such as `load-balancer-exclusion`. Identifiers are limited to 100 characters and can include only letters, digits, underscores, hyphens, and periods. First character has to be alphanumeric.
        :param str description: A description of this exclusion.
        :param bool disabled: If set to True, then this exclusion is disabled and it does not exclude any log entries.
        """
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)

    @property
    @pulumi.getter
    def filter(self) -> str:
        """
        An advanced logs filter that matches the log entries to be excluded. By using the sample function, you can exclude less than 100% of the matching log entries. See [Advanced Log Filters](https://cloud.google.com/logging/docs/view/advanced_filters) for information on how to
        write a filter.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A client-assigned identifier, such as `load-balancer-exclusion`. Identifiers are limited to 100 characters and can include only letters, digits, underscores, hyphens, and periods. First character has to be alphanumeric.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of this exclusion.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        """
        If set to True, then this exclusion is disabled and it does not exclude any log entries.
        """
        return pulumi.get(self, "disabled")


@pulumi.output_type
class LinkedDatasetBigqueryDataset(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetId":
            suggest = "dataset_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinkedDatasetBigqueryDataset. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinkedDatasetBigqueryDataset.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinkedDatasetBigqueryDataset.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset_id: Optional[str] = None):
        """
        :param str dataset_id: (Output)
               Output only. The full resource name of the BigQuery dataset. The DATASET_ID will match the ID
               of the link, so the link must match the naming restrictions of BigQuery datasets
               (alphanumeric characters and underscores only). The dataset will have a resource path of
               "bigquery.googleapis.com/projects/[PROJECT_ID]/datasets/[DATASET_ID]"
        """
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[str]:
        """
        (Output)
        Output only. The full resource name of the BigQuery dataset. The DATASET_ID will match the ID
        of the link, so the link must match the naming restrictions of BigQuery datasets
        (alphanumeric characters and underscores only). The dataset will have a resource path of
        "bigquery.googleapis.com/projects/[PROJECT_ID]/datasets/[DATASET_ID]"
        """
        return pulumi.get(self, "dataset_id")


@pulumi.output_type
class MetricBucketOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "explicitBuckets":
            suggest = "explicit_buckets"
        elif key == "exponentialBuckets":
            suggest = "exponential_buckets"
        elif key == "linearBuckets":
            suggest = "linear_buckets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricBucketOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricBucketOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricBucketOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 explicit_buckets: Optional['outputs.MetricBucketOptionsExplicitBuckets'] = None,
                 exponential_buckets: Optional['outputs.MetricBucketOptionsExponentialBuckets'] = None,
                 linear_buckets: Optional['outputs.MetricBucketOptionsLinearBuckets'] = None):
        """
        :param 'MetricBucketOptionsExplicitBucketsArgs' explicit_buckets: Specifies a set of buckets with arbitrary widths.
               Structure is documented below.
        :param 'MetricBucketOptionsExponentialBucketsArgs' exponential_buckets: Specifies an exponential sequence of buckets that have a width that is proportional to the value of
               the lower bound. Each bucket represents a constant relative uncertainty on a specific value in the bucket.
               Structure is documented below.
        :param 'MetricBucketOptionsLinearBucketsArgs' linear_buckets: Specifies a linear sequence of buckets that all have the same width (except overflow and underflow).
               Each bucket represents a constant absolute uncertainty on the specific value in the bucket.
               Structure is documented below.
        """
        if explicit_buckets is not None:
            pulumi.set(__self__, "explicit_buckets", explicit_buckets)
        if exponential_buckets is not None:
            pulumi.set(__self__, "exponential_buckets", exponential_buckets)
        if linear_buckets is not None:
            pulumi.set(__self__, "linear_buckets", linear_buckets)

    @property
    @pulumi.getter(name="explicitBuckets")
    def explicit_buckets(self) -> Optional['outputs.MetricBucketOptionsExplicitBuckets']:
        """
        Specifies a set of buckets with arbitrary widths.
        Structure is documented below.
        """
        return pulumi.get(self, "explicit_buckets")

    @property
    @pulumi.getter(name="exponentialBuckets")
    def exponential_buckets(self) -> Optional['outputs.MetricBucketOptionsExponentialBuckets']:
        """
        Specifies an exponential sequence of buckets that have a width that is proportional to the value of
        the lower bound. Each bucket represents a constant relative uncertainty on a specific value in the bucket.
        Structure is documented below.
        """
        return pulumi.get(self, "exponential_buckets")

    @property
    @pulumi.getter(name="linearBuckets")
    def linear_buckets(self) -> Optional['outputs.MetricBucketOptionsLinearBuckets']:
        """
        Specifies a linear sequence of buckets that all have the same width (except overflow and underflow).
        Each bucket represents a constant absolute uncertainty on the specific value in the bucket.
        Structure is documented below.
        """
        return pulumi.get(self, "linear_buckets")


@pulumi.output_type
class MetricBucketOptionsExplicitBuckets(dict):
    def __init__(__self__, *,
                 bounds: Sequence[float]):
        """
        :param Sequence[float] bounds: The values must be monotonically increasing.
        """
        pulumi.set(__self__, "bounds", bounds)

    @property
    @pulumi.getter
    def bounds(self) -> Sequence[float]:
        """
        The values must be monotonically increasing.
        """
        return pulumi.get(self, "bounds")


@pulumi.output_type
class MetricBucketOptionsExponentialBuckets(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "growthFactor":
            suggest = "growth_factor"
        elif key == "numFiniteBuckets":
            suggest = "num_finite_buckets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricBucketOptionsExponentialBuckets. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricBucketOptionsExponentialBuckets.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricBucketOptionsExponentialBuckets.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 growth_factor: Optional[float] = None,
                 num_finite_buckets: Optional[int] = None,
                 scale: Optional[float] = None):
        """
        :param float growth_factor: Must be greater than 1.
        :param int num_finite_buckets: Must be greater than 0.
        :param float scale: Must be greater than 0.
        """
        if growth_factor is not None:
            pulumi.set(__self__, "growth_factor", growth_factor)
        if num_finite_buckets is not None:
            pulumi.set(__self__, "num_finite_buckets", num_finite_buckets)
        if scale is not None:
            pulumi.set(__self__, "scale", scale)

    @property
    @pulumi.getter(name="growthFactor")
    def growth_factor(self) -> Optional[float]:
        """
        Must be greater than 1.
        """
        return pulumi.get(self, "growth_factor")

    @property
    @pulumi.getter(name="numFiniteBuckets")
    def num_finite_buckets(self) -> Optional[int]:
        """
        Must be greater than 0.
        """
        return pulumi.get(self, "num_finite_buckets")

    @property
    @pulumi.getter
    def scale(self) -> Optional[float]:
        """
        Must be greater than 0.
        """
        return pulumi.get(self, "scale")


@pulumi.output_type
class MetricBucketOptionsLinearBuckets(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "numFiniteBuckets":
            suggest = "num_finite_buckets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricBucketOptionsLinearBuckets. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricBucketOptionsLinearBuckets.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricBucketOptionsLinearBuckets.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 num_finite_buckets: Optional[int] = None,
                 offset: Optional[float] = None,
                 width: Optional[float] = None):
        """
        :param int num_finite_buckets: Must be greater than 0.
        :param float offset: Lower bound of the first bucket.
        :param float width: Must be greater than 0.
        """
        if num_finite_buckets is not None:
            pulumi.set(__self__, "num_finite_buckets", num_finite_buckets)
        if offset is not None:
            pulumi.set(__self__, "offset", offset)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter(name="numFiniteBuckets")
    def num_finite_buckets(self) -> Optional[int]:
        """
        Must be greater than 0.
        """
        return pulumi.get(self, "num_finite_buckets")

    @property
    @pulumi.getter
    def offset(self) -> Optional[float]:
        """
        Lower bound of the first bucket.
        """
        return pulumi.get(self, "offset")

    @property
    @pulumi.getter
    def width(self) -> Optional[float]:
        """
        Must be greater than 0.
        """
        return pulumi.get(self, "width")


@pulumi.output_type
class MetricMetricDescriptor(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricKind":
            suggest = "metric_kind"
        elif key == "valueType":
            suggest = "value_type"
        elif key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricMetricDescriptor. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricMetricDescriptor.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricMetricDescriptor.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_kind: str,
                 value_type: str,
                 display_name: Optional[str] = None,
                 labels: Optional[Sequence['outputs.MetricMetricDescriptorLabel']] = None,
                 unit: Optional[str] = None):
        """
        :param str metric_kind: Whether the metric records instantaneous values, changes to a value, etc.
               Some combinations of metricKind and valueType might not be supported.
               For counter metrics, set this to DELTA.
               Possible values are: `DELTA`, `GAUGE`, `CUMULATIVE`.
        :param str value_type: Whether the measurement is an integer, a floating-point number, etc.
               Some combinations of metricKind and valueType might not be supported.
               For counter metrics, set this to INT64.
               Possible values are: `BOOL`, `INT64`, `DOUBLE`, `STRING`, `DISTRIBUTION`, `MONEY`.
        :param str display_name: A concise name for the metric, which can be displayed in user interfaces. Use sentence case
               without an ending period, for example "Request count". This field is optional but it is
               recommended to be set for any metrics associated with user-visible concepts, such as Quota.
        :param Sequence['MetricMetricDescriptorLabelArgs'] labels: The set of labels that can be used to describe a specific instance of this metric type. For
               example, the appengine.googleapis.com/http/server/response_latencies metric type has a label
               for the HTTP response code, response_code, so you can look at latencies for successful responses
               or just for responses that failed.
               Structure is documented below.
        :param str unit: The unit in which the metric value is reported. It is only applicable if the valueType is
               `INT64`, `DOUBLE`, or `DISTRIBUTION`. The supported units are a subset of
               [The Unified Code for Units of Measure](http://unitsofmeasure.org/ucum.html) standard
        """
        pulumi.set(__self__, "metric_kind", metric_kind)
        pulumi.set(__self__, "value_type", value_type)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter(name="metricKind")
    def metric_kind(self) -> str:
        """
        Whether the metric records instantaneous values, changes to a value, etc.
        Some combinations of metricKind and valueType might not be supported.
        For counter metrics, set this to DELTA.
        Possible values are: `DELTA`, `GAUGE`, `CUMULATIVE`.
        """
        return pulumi.get(self, "metric_kind")

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> str:
        """
        Whether the measurement is an integer, a floating-point number, etc.
        Some combinations of metricKind and valueType might not be supported.
        For counter metrics, set this to INT64.
        Possible values are: `BOOL`, `INT64`, `DOUBLE`, `STRING`, `DISTRIBUTION`, `MONEY`.
        """
        return pulumi.get(self, "value_type")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A concise name for the metric, which can be displayed in user interfaces. Use sentence case
        without an ending period, for example "Request count". This field is optional but it is
        recommended to be set for any metrics associated with user-visible concepts, such as Quota.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Sequence['outputs.MetricMetricDescriptorLabel']]:
        """
        The set of labels that can be used to describe a specific instance of this metric type. For
        example, the appengine.googleapis.com/http/server/response_latencies metric type has a label
        for the HTTP response code, response_code, so you can look at latencies for successful responses
        or just for responses that failed.
        Structure is documented below.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def unit(self) -> Optional[str]:
        """
        The unit in which the metric value is reported. It is only applicable if the valueType is
        `INT64`, `DOUBLE`, or `DISTRIBUTION`. The supported units are a subset of
        [The Unified Code for Units of Measure](http://unitsofmeasure.org/ucum.html) standard
        """
        return pulumi.get(self, "unit")


@pulumi.output_type
class MetricMetricDescriptorLabel(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valueType":
            suggest = "value_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricMetricDescriptorLabel. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricMetricDescriptorLabel.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricMetricDescriptorLabel.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: str,
                 description: Optional[str] = None,
                 value_type: Optional[str] = None):
        """
        :param str key: The label key.
        :param str description: A human-readable description for the label.
        :param str value_type: The type of data that can be assigned to the label.
               Default value is `STRING`.
               Possible values are: `BOOL`, `INT64`, `STRING`.
        """
        pulumi.set(__self__, "key", key)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if value_type is not None:
            pulumi.set(__self__, "value_type", value_type)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The label key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A human-readable description for the label.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> Optional[str]:
        """
        The type of data that can be assigned to the label.
        Default value is `STRING`.
        Possible values are: `BOOL`, `INT64`, `STRING`.
        """
        return pulumi.get(self, "value_type")


@pulumi.output_type
class OrganizationBucketConfigCmekSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"
        elif key == "kmsKeyVersionName":
            suggest = "kms_key_version_name"
        elif key == "serviceAccountId":
            suggest = "service_account_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrganizationBucketConfigCmekSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrganizationBucketConfigCmekSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrganizationBucketConfigCmekSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: str,
                 kms_key_version_name: Optional[str] = None,
                 name: Optional[str] = None,
                 service_account_id: Optional[str] = None):
        """
        :param str name: The resource name of the bucket. For example: "organizations/my-organization-id/locations/my-location/buckets/my-bucket-id"
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)
        if kms_key_version_name is not None:
            pulumi.set(__self__, "kms_key_version_name", kms_key_version_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_account_id is not None:
            pulumi.set(__self__, "service_account_id", service_account_id)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> str:
        return pulumi.get(self, "kms_key_name")

    @property
    @pulumi.getter(name="kmsKeyVersionName")
    def kms_key_version_name(self) -> Optional[str]:
        return pulumi.get(self, "kms_key_version_name")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The resource name of the bucket. For example: "organizations/my-organization-id/locations/my-location/buckets/my-bucket-id"
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> Optional[str]:
        return pulumi.get(self, "service_account_id")


@pulumi.output_type
class OrganizationSinkBigqueryOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "usePartitionedTables":
            suggest = "use_partitioned_tables"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrganizationSinkBigqueryOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrganizationSinkBigqueryOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrganizationSinkBigqueryOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 use_partitioned_tables: bool):
        """
        :param bool use_partitioned_tables: Whether to use [BigQuery's partition tables](https://cloud.google.com/bigquery/docs/partitioned-tables).
               By default, Logging creates dated tables based on the log entries' timestamps, e.g. syslog_20170523. With partitioned
               tables the date suffix is no longer present and [special query syntax](https://cloud.google.com/bigquery/docs/querying-partitioned-tables)
               has to be used instead. In both cases, tables are sharded based on UTC timezone.
        """
        pulumi.set(__self__, "use_partitioned_tables", use_partitioned_tables)

    @property
    @pulumi.getter(name="usePartitionedTables")
    def use_partitioned_tables(self) -> bool:
        """
        Whether to use [BigQuery's partition tables](https://cloud.google.com/bigquery/docs/partitioned-tables).
        By default, Logging creates dated tables based on the log entries' timestamps, e.g. syslog_20170523. With partitioned
        tables the date suffix is no longer present and [special query syntax](https://cloud.google.com/bigquery/docs/querying-partitioned-tables)
        has to be used instead. In both cases, tables are sharded based on UTC timezone.
        """
        return pulumi.get(self, "use_partitioned_tables")


@pulumi.output_type
class OrganizationSinkExclusion(dict):
    def __init__(__self__, *,
                 filter: str,
                 name: str,
                 description: Optional[str] = None,
                 disabled: Optional[bool] = None):
        """
        :param str filter: An advanced logs filter that matches the log entries to be excluded. By using the sample function, you can exclude less than 100% of the matching log entries. See [Advanced Log Filters](https://cloud.google.com/logging/docs/view/advanced_filters) for information on how to
               write a filter.
        :param str name: A client-assigned identifier, such as `load-balancer-exclusion`. Identifiers are limited to 100 characters and can include only letters, digits, underscores, hyphens, and periods. First character has to be alphanumeric.
        :param str description: A description of this exclusion.
        :param bool disabled: If set to True, then this exclusion is disabled and it does not exclude any log entries.
        """
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)

    @property
    @pulumi.getter
    def filter(self) -> str:
        """
        An advanced logs filter that matches the log entries to be excluded. By using the sample function, you can exclude less than 100% of the matching log entries. See [Advanced Log Filters](https://cloud.google.com/logging/docs/view/advanced_filters) for information on how to
        write a filter.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A client-assigned identifier, such as `load-balancer-exclusion`. Identifiers are limited to 100 characters and can include only letters, digits, underscores, hyphens, and periods. First character has to be alphanumeric.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of this exclusion.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        """
        If set to True, then this exclusion is disabled and it does not exclude any log entries.
        """
        return pulumi.get(self, "disabled")


@pulumi.output_type
class ProjectBucketConfigCmekSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"
        elif key == "kmsKeyVersionName":
            suggest = "kms_key_version_name"
        elif key == "serviceAccountId":
            suggest = "service_account_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectBucketConfigCmekSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectBucketConfigCmekSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectBucketConfigCmekSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: str,
                 kms_key_version_name: Optional[str] = None,
                 name: Optional[str] = None,
                 service_account_id: Optional[str] = None):
        """
        :param str kms_key_name: The resource name for the configured Cloud KMS key.
               KMS key name format:
               `'projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]'`
               To enable CMEK for the bucket, set this field to a valid kmsKeyName for which the associated service account has the required cloudkms.cryptoKeyEncrypterDecrypter roles assigned for the key.
               The Cloud KMS key used by the bucket can be updated by changing the kmsKeyName to a new valid key name. Encryption operations that are in progress will be completed with the key that was in use when they started. Decryption operations will be completed using the key that was used at the time of encryption unless access to that key has been revoked.
               See [Enabling CMEK for Logging Buckets](https://cloud.google.com/logging/docs/routing/managed-encryption-storage) for more information.
        :param str kms_key_version_name: The CryptoKeyVersion resource name for the configured Cloud KMS key.
               KMS key name format:
               `'projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]/cryptoKeyVersions/[VERSION]'`
               For example:
               "projects/my-project/locations/us-central1/keyRings/my-ring/cryptoKeys/my-key/cryptoKeyVersions/1"
               This is a read-only field used to convey the specific configured CryptoKeyVersion of kms_key that has been configured. It will be populated in cases where the CMEK settings are bound to a single key version.
        :param str name: The resource name of the CMEK settings.
        :param str service_account_id: The service account associated with a project for which CMEK will apply.
               Before enabling CMEK for a logging bucket, you must first assign the cloudkms.cryptoKeyEncrypterDecrypter role to the service account associated with the project for which CMEK will apply. Use [v2.getCmekSettings](https://cloud.google.com/logging/docs/reference/v2/rest/v2/TopLevel/getCmekSettings#google.logging.v2.ConfigServiceV2.GetCmekSettings) to obtain the service account ID.
               See [Enabling CMEK for Logging Buckets](https://cloud.google.com/logging/docs/routing/managed-encryption-storage) for more information.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)
        if kms_key_version_name is not None:
            pulumi.set(__self__, "kms_key_version_name", kms_key_version_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_account_id is not None:
            pulumi.set(__self__, "service_account_id", service_account_id)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> str:
        """
        The resource name for the configured Cloud KMS key.
        KMS key name format:
        `'projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]'`
        To enable CMEK for the bucket, set this field to a valid kmsKeyName for which the associated service account has the required cloudkms.cryptoKeyEncrypterDecrypter roles assigned for the key.
        The Cloud KMS key used by the bucket can be updated by changing the kmsKeyName to a new valid key name. Encryption operations that are in progress will be completed with the key that was in use when they started. Decryption operations will be completed using the key that was used at the time of encryption unless access to that key has been revoked.
        See [Enabling CMEK for Logging Buckets](https://cloud.google.com/logging/docs/routing/managed-encryption-storage) for more information.
        """
        return pulumi.get(self, "kms_key_name")

    @property
    @pulumi.getter(name="kmsKeyVersionName")
    def kms_key_version_name(self) -> Optional[str]:
        """
        The CryptoKeyVersion resource name for the configured Cloud KMS key.
        KMS key name format:
        `'projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]/cryptoKeyVersions/[VERSION]'`
        For example:
        "projects/my-project/locations/us-central1/keyRings/my-ring/cryptoKeys/my-key/cryptoKeyVersions/1"
        This is a read-only field used to convey the specific configured CryptoKeyVersion of kms_key that has been configured. It will be populated in cases where the CMEK settings are bound to a single key version.
        """
        return pulumi.get(self, "kms_key_version_name")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The resource name of the CMEK settings.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> Optional[str]:
        """
        The service account associated with a project for which CMEK will apply.
        Before enabling CMEK for a logging bucket, you must first assign the cloudkms.cryptoKeyEncrypterDecrypter role to the service account associated with the project for which CMEK will apply. Use [v2.getCmekSettings](https://cloud.google.com/logging/docs/reference/v2/rest/v2/TopLevel/getCmekSettings#google.logging.v2.ConfigServiceV2.GetCmekSettings) to obtain the service account ID.
        See [Enabling CMEK for Logging Buckets](https://cloud.google.com/logging/docs/routing/managed-encryption-storage) for more information.
        """
        return pulumi.get(self, "service_account_id")


@pulumi.output_type
class ProjectSinkBigqueryOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "usePartitionedTables":
            suggest = "use_partitioned_tables"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectSinkBigqueryOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectSinkBigqueryOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectSinkBigqueryOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 use_partitioned_tables: bool):
        """
        :param bool use_partitioned_tables: Whether to use [BigQuery's partition tables](https://cloud.google.com/bigquery/docs/partitioned-tables).
               By default, Logging creates dated tables based on the log entries' timestamps, e.g. `syslog_20170523`. With partitioned
               tables the date suffix is no longer present and [special query syntax](https://cloud.google.com/bigquery/docs/querying-partitioned-tables)
               has to be used instead. In both cases, tables are sharded based on UTC timezone.
        """
        pulumi.set(__self__, "use_partitioned_tables", use_partitioned_tables)

    @property
    @pulumi.getter(name="usePartitionedTables")
    def use_partitioned_tables(self) -> bool:
        """
        Whether to use [BigQuery's partition tables](https://cloud.google.com/bigquery/docs/partitioned-tables).
        By default, Logging creates dated tables based on the log entries' timestamps, e.g. `syslog_20170523`. With partitioned
        tables the date suffix is no longer present and [special query syntax](https://cloud.google.com/bigquery/docs/querying-partitioned-tables)
        has to be used instead. In both cases, tables are sharded based on UTC timezone.
        """
        return pulumi.get(self, "use_partitioned_tables")


@pulumi.output_type
class ProjectSinkExclusion(dict):
    def __init__(__self__, *,
                 filter: str,
                 name: str,
                 description: Optional[str] = None,
                 disabled: Optional[bool] = None):
        """
        :param str filter: An advanced logs filter that matches the log entries to be excluded. By using the sample function, you can exclude less than 100% of the matching log entries. See [Advanced Log Filters](https://cloud.google.com/logging/docs/view/advanced_filters) for information on how to
               write a filter.
        :param str name: A client-assigned identifier, such as `load-balancer-exclusion`. Identifiers are limited to 100 characters and can include only letters, digits, underscores, hyphens, and periods. First character has to be alphanumeric.
        :param str description: A description of this exclusion.
        :param bool disabled: If set to True, then this exclusion is disabled and it does not exclude any log entries.
        """
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)

    @property
    @pulumi.getter
    def filter(self) -> str:
        """
        An advanced logs filter that matches the log entries to be excluded. By using the sample function, you can exclude less than 100% of the matching log entries. See [Advanced Log Filters](https://cloud.google.com/logging/docs/view/advanced_filters) for information on how to
        write a filter.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A client-assigned identifier, such as `load-balancer-exclusion`. Identifiers are limited to 100 characters and can include only letters, digits, underscores, hyphens, and periods. First character has to be alphanumeric.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of this exclusion.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        """
        If set to True, then this exclusion is disabled and it does not exclude any log entries.
        """
        return pulumi.get(self, "disabled")


@pulumi.output_type
class GetSinkBigqueryOptionResult(dict):
    def __init__(__self__, *,
                 use_partitioned_tables: bool):
        """
        :param bool use_partitioned_tables: Whether [BigQuery's partition tables](https://cloud.google.com/bigquery/docs/partitioned-tables) are used.
        """
        pulumi.set(__self__, "use_partitioned_tables", use_partitioned_tables)

    @property
    @pulumi.getter(name="usePartitionedTables")
    def use_partitioned_tables(self) -> bool:
        """
        Whether [BigQuery's partition tables](https://cloud.google.com/bigquery/docs/partitioned-tables) are used.
        """
        return pulumi.get(self, "use_partitioned_tables")


@pulumi.output_type
class GetSinkExclusionResult(dict):
    def __init__(__self__, *,
                 description: str,
                 disabled: bool,
                 filter: str,
                 name: str):
        """
        :param str description: A description of this exclusion.
        :param bool disabled: Whether this exclusion is disabled and it does not exclude any log entries.
        :param str filter: An advanced logs filter that matches the log entries to be excluded.
        :param str name: A client-assigned identifier, such as `load-balancer-exclusion`.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "disabled", disabled)
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A description of this exclusion.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def disabled(self) -> bool:
        """
        Whether this exclusion is disabled and it does not exclude any log entries.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter
    def filter(self) -> str:
        """
        An advanced logs filter that matches the log entries to be excluded.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A client-assigned identifier, such as `load-balancer-exclusion`.
        """
        return pulumi.get(self, "name")


