# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 admin_settings: Optional[pulumi.Input['InstanceAdminSettingsArgs']] = None,
                 consumer_network: Optional[pulumi.Input[str]] = None,
                 deny_maintenance_period: Optional[pulumi.Input['InstanceDenyMaintenancePeriodArgs']] = None,
                 encryption_config: Optional[pulumi.Input['InstanceEncryptionConfigArgs']] = None,
                 maintenance_window: Optional[pulumi.Input['InstanceMaintenanceWindowArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 oauth_config: Optional[pulumi.Input['InstanceOauthConfigArgs']] = None,
                 platform_edition: Optional[pulumi.Input[str]] = None,
                 private_ip_enabled: Optional[pulumi.Input[bool]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 public_ip_enabled: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 reserved_range: Optional[pulumi.Input[str]] = None,
                 user_metadata: Optional[pulumi.Input['InstanceUserMetadataArgs']] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input['InstanceAdminSettingsArgs'] admin_settings: Looker instance Admin settings.
               Structure is documented below.
        :param pulumi.Input[str] consumer_network: Network name in the consumer project in the format of: projects/{project}/global/networks/{network}
               Note that the consumer network may be in a different GCP project than the consumer
               project that is hosting the Looker Instance.
        :param pulumi.Input['InstanceDenyMaintenancePeriodArgs'] deny_maintenance_period: Maintenance denial period for this instance.
               You must allow at least 14 days of maintenance availability
               between any two deny maintenance periods.
               Structure is documented below.
        :param pulumi.Input['InstanceEncryptionConfigArgs'] encryption_config: Looker instance encryption settings.
               Structure is documented below.
        :param pulumi.Input['InstanceMaintenanceWindowArgs'] maintenance_window: Maintenance window for an instance.
               Maintenance of your instance takes place once a month, and will require
               your instance to be restarted during updates, which will temporarily
               disrupt service.
               Structure is documented below.
        :param pulumi.Input[str] name: The ID of the instance or a fully qualified identifier for the instance.
               
               
               - - -
        :param pulumi.Input['InstanceOauthConfigArgs'] oauth_config: Looker Instance OAuth login settings.
               Structure is documented below.
        :param pulumi.Input[str] platform_edition: Platform editions for a Looker instance. Each edition maps to a set of instance features, like its size. Must be one of these values:
               - LOOKER_CORE_TRIAL: trial instance
               - LOOKER_CORE_STANDARD: pay as you go standard instance
               - LOOKER_CORE_STANDARD_ANNUAL: subscription standard instance
               - LOOKER_CORE_ENTERPRISE_ANNUAL: subscription enterprise instance
               - LOOKER_CORE_EMBED_ANNUAL: subscription embed instance
               - LOOKER_MODELER: standalone modeling service
               Default value is `LOOKER_CORE_TRIAL`.
               Possible values are: `LOOKER_CORE_TRIAL`, `LOOKER_CORE_STANDARD`, `LOOKER_CORE_STANDARD_ANNUAL`, `LOOKER_CORE_ENTERPRISE_ANNUAL`, `LOOKER_CORE_EMBED_ANNUAL`, `LOOKER_MODELER`.
        :param pulumi.Input[bool] private_ip_enabled: Whether private IP is enabled on the Looker instance.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[bool] public_ip_enabled: Whether public IP is enabled on the Looker instance.
        :param pulumi.Input[str] region: The name of the Looker region of the instance.
        :param pulumi.Input[str] reserved_range: Name of a reserved IP address range within the consumer network, to be used for
               private service access connection. User may or may not specify this in a request.
        :param pulumi.Input['InstanceUserMetadataArgs'] user_metadata: Metadata about users for a Looker instance.
               These settings are only available when platform edition LOOKER_CORE_STANDARD is set.
               There are ten Standard and two Developer users included in the cost of the product.
               You can allocate additional Standard, Viewer, and Developer users for this instance.
               It is an optional step and can be modified later.
               With the Standard edition of Looker (Google Cloud core), you can provision up to 50
               total users, distributed across Viewer, Standard, and Developer.
               Structure is documented below.
        """
        if admin_settings is not None:
            pulumi.set(__self__, "admin_settings", admin_settings)
        if consumer_network is not None:
            pulumi.set(__self__, "consumer_network", consumer_network)
        if deny_maintenance_period is not None:
            pulumi.set(__self__, "deny_maintenance_period", deny_maintenance_period)
        if encryption_config is not None:
            pulumi.set(__self__, "encryption_config", encryption_config)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oauth_config is not None:
            pulumi.set(__self__, "oauth_config", oauth_config)
        if platform_edition is not None:
            pulumi.set(__self__, "platform_edition", platform_edition)
        if private_ip_enabled is not None:
            pulumi.set(__self__, "private_ip_enabled", private_ip_enabled)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if public_ip_enabled is not None:
            pulumi.set(__self__, "public_ip_enabled", public_ip_enabled)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if reserved_range is not None:
            pulumi.set(__self__, "reserved_range", reserved_range)
        if user_metadata is not None:
            pulumi.set(__self__, "user_metadata", user_metadata)

    @property
    @pulumi.getter(name="adminSettings")
    def admin_settings(self) -> Optional[pulumi.Input['InstanceAdminSettingsArgs']]:
        """
        Looker instance Admin settings.
        Structure is documented below.
        """
        return pulumi.get(self, "admin_settings")

    @admin_settings.setter
    def admin_settings(self, value: Optional[pulumi.Input['InstanceAdminSettingsArgs']]):
        pulumi.set(self, "admin_settings", value)

    @property
    @pulumi.getter(name="consumerNetwork")
    def consumer_network(self) -> Optional[pulumi.Input[str]]:
        """
        Network name in the consumer project in the format of: projects/{project}/global/networks/{network}
        Note that the consumer network may be in a different GCP project than the consumer
        project that is hosting the Looker Instance.
        """
        return pulumi.get(self, "consumer_network")

    @consumer_network.setter
    def consumer_network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consumer_network", value)

    @property
    @pulumi.getter(name="denyMaintenancePeriod")
    def deny_maintenance_period(self) -> Optional[pulumi.Input['InstanceDenyMaintenancePeriodArgs']]:
        """
        Maintenance denial period for this instance.
        You must allow at least 14 days of maintenance availability
        between any two deny maintenance periods.
        Structure is documented below.
        """
        return pulumi.get(self, "deny_maintenance_period")

    @deny_maintenance_period.setter
    def deny_maintenance_period(self, value: Optional[pulumi.Input['InstanceDenyMaintenancePeriodArgs']]):
        pulumi.set(self, "deny_maintenance_period", value)

    @property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> Optional[pulumi.Input['InstanceEncryptionConfigArgs']]:
        """
        Looker instance encryption settings.
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_config")

    @encryption_config.setter
    def encryption_config(self, value: Optional[pulumi.Input['InstanceEncryptionConfigArgs']]):
        pulumi.set(self, "encryption_config", value)

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['InstanceMaintenanceWindowArgs']]:
        """
        Maintenance window for an instance.
        Maintenance of your instance takes place once a month, and will require
        your instance to be restarted during updates, which will temporarily
        disrupt service.
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['InstanceMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the instance or a fully qualified identifier for the instance.


        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="oauthConfig")
    def oauth_config(self) -> Optional[pulumi.Input['InstanceOauthConfigArgs']]:
        """
        Looker Instance OAuth login settings.
        Structure is documented below.
        """
        return pulumi.get(self, "oauth_config")

    @oauth_config.setter
    def oauth_config(self, value: Optional[pulumi.Input['InstanceOauthConfigArgs']]):
        pulumi.set(self, "oauth_config", value)

    @property
    @pulumi.getter(name="platformEdition")
    def platform_edition(self) -> Optional[pulumi.Input[str]]:
        """
        Platform editions for a Looker instance. Each edition maps to a set of instance features, like its size. Must be one of these values:
        - LOOKER_CORE_TRIAL: trial instance
        - LOOKER_CORE_STANDARD: pay as you go standard instance
        - LOOKER_CORE_STANDARD_ANNUAL: subscription standard instance
        - LOOKER_CORE_ENTERPRISE_ANNUAL: subscription enterprise instance
        - LOOKER_CORE_EMBED_ANNUAL: subscription embed instance
        - LOOKER_MODELER: standalone modeling service
        Default value is `LOOKER_CORE_TRIAL`.
        Possible values are: `LOOKER_CORE_TRIAL`, `LOOKER_CORE_STANDARD`, `LOOKER_CORE_STANDARD_ANNUAL`, `LOOKER_CORE_ENTERPRISE_ANNUAL`, `LOOKER_CORE_EMBED_ANNUAL`, `LOOKER_MODELER`.
        """
        return pulumi.get(self, "platform_edition")

    @platform_edition.setter
    def platform_edition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "platform_edition", value)

    @property
    @pulumi.getter(name="privateIpEnabled")
    def private_ip_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether private IP is enabled on the Looker instance.
        """
        return pulumi.get(self, "private_ip_enabled")

    @private_ip_enabled.setter
    def private_ip_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "private_ip_enabled", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="publicIpEnabled")
    def public_ip_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether public IP is enabled on the Looker instance.
        """
        return pulumi.get(self, "public_ip_enabled")

    @public_ip_enabled.setter
    def public_ip_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "public_ip_enabled", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Looker region of the instance.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="reservedRange")
    def reserved_range(self) -> Optional[pulumi.Input[str]]:
        """
        Name of a reserved IP address range within the consumer network, to be used for
        private service access connection. User may or may not specify this in a request.
        """
        return pulumi.get(self, "reserved_range")

    @reserved_range.setter
    def reserved_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reserved_range", value)

    @property
    @pulumi.getter(name="userMetadata")
    def user_metadata(self) -> Optional[pulumi.Input['InstanceUserMetadataArgs']]:
        """
        Metadata about users for a Looker instance.
        These settings are only available when platform edition LOOKER_CORE_STANDARD is set.
        There are ten Standard and two Developer users included in the cost of the product.
        You can allocate additional Standard, Viewer, and Developer users for this instance.
        It is an optional step and can be modified later.
        With the Standard edition of Looker (Google Cloud core), you can provision up to 50
        total users, distributed across Viewer, Standard, and Developer.
        Structure is documented below.
        """
        return pulumi.get(self, "user_metadata")

    @user_metadata.setter
    def user_metadata(self, value: Optional[pulumi.Input['InstanceUserMetadataArgs']]):
        pulumi.set(self, "user_metadata", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 admin_settings: Optional[pulumi.Input['InstanceAdminSettingsArgs']] = None,
                 consumer_network: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 deny_maintenance_period: Optional[pulumi.Input['InstanceDenyMaintenancePeriodArgs']] = None,
                 egress_public_ip: Optional[pulumi.Input[str]] = None,
                 encryption_config: Optional[pulumi.Input['InstanceEncryptionConfigArgs']] = None,
                 ingress_private_ip: Optional[pulumi.Input[str]] = None,
                 ingress_public_ip: Optional[pulumi.Input[str]] = None,
                 looker_uri: Optional[pulumi.Input[str]] = None,
                 looker_version: Optional[pulumi.Input[str]] = None,
                 maintenance_window: Optional[pulumi.Input['InstanceMaintenanceWindowArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 oauth_config: Optional[pulumi.Input['InstanceOauthConfigArgs']] = None,
                 platform_edition: Optional[pulumi.Input[str]] = None,
                 private_ip_enabled: Optional[pulumi.Input[bool]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 public_ip_enabled: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 reserved_range: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None,
                 user_metadata: Optional[pulumi.Input['InstanceUserMetadataArgs']] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input['InstanceAdminSettingsArgs'] admin_settings: Looker instance Admin settings.
               Structure is documented below.
        :param pulumi.Input[str] consumer_network: Network name in the consumer project in the format of: projects/{project}/global/networks/{network}
               Note that the consumer network may be in a different GCP project than the consumer
               project that is hosting the Looker Instance.
        :param pulumi.Input[str] create_time: The time the instance was created in RFC3339 UTC "Zulu" format,
               accurate to nanoseconds.
        :param pulumi.Input['InstanceDenyMaintenancePeriodArgs'] deny_maintenance_period: Maintenance denial period for this instance.
               You must allow at least 14 days of maintenance availability
               between any two deny maintenance periods.
               Structure is documented below.
        :param pulumi.Input[str] egress_public_ip: Public Egress IP (IPv4).
        :param pulumi.Input['InstanceEncryptionConfigArgs'] encryption_config: Looker instance encryption settings.
               Structure is documented below.
        :param pulumi.Input[str] ingress_private_ip: Private Ingress IP (IPv4).
        :param pulumi.Input[str] ingress_public_ip: Public Ingress IP (IPv4).
        :param pulumi.Input[str] looker_uri: Looker instance URI which can be used to access the Looker Instance UI.
        :param pulumi.Input[str] looker_version: The Looker version that the instance is using.
        :param pulumi.Input['InstanceMaintenanceWindowArgs'] maintenance_window: Maintenance window for an instance.
               Maintenance of your instance takes place once a month, and will require
               your instance to be restarted during updates, which will temporarily
               disrupt service.
               Structure is documented below.
        :param pulumi.Input[str] name: The ID of the instance or a fully qualified identifier for the instance.
               
               
               - - -
        :param pulumi.Input['InstanceOauthConfigArgs'] oauth_config: Looker Instance OAuth login settings.
               Structure is documented below.
        :param pulumi.Input[str] platform_edition: Platform editions for a Looker instance. Each edition maps to a set of instance features, like its size. Must be one of these values:
               - LOOKER_CORE_TRIAL: trial instance
               - LOOKER_CORE_STANDARD: pay as you go standard instance
               - LOOKER_CORE_STANDARD_ANNUAL: subscription standard instance
               - LOOKER_CORE_ENTERPRISE_ANNUAL: subscription enterprise instance
               - LOOKER_CORE_EMBED_ANNUAL: subscription embed instance
               - LOOKER_MODELER: standalone modeling service
               Default value is `LOOKER_CORE_TRIAL`.
               Possible values are: `LOOKER_CORE_TRIAL`, `LOOKER_CORE_STANDARD`, `LOOKER_CORE_STANDARD_ANNUAL`, `LOOKER_CORE_ENTERPRISE_ANNUAL`, `LOOKER_CORE_EMBED_ANNUAL`, `LOOKER_MODELER`.
        :param pulumi.Input[bool] private_ip_enabled: Whether private IP is enabled on the Looker instance.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[bool] public_ip_enabled: Whether public IP is enabled on the Looker instance.
        :param pulumi.Input[str] region: The name of the Looker region of the instance.
        :param pulumi.Input[str] reserved_range: Name of a reserved IP address range within the consumer network, to be used for
               private service access connection. User may or may not specify this in a request.
        :param pulumi.Input[str] update_time: The time the instance was updated in RFC3339 UTC "Zulu" format,
               accurate to nanoseconds.
        :param pulumi.Input['InstanceUserMetadataArgs'] user_metadata: Metadata about users for a Looker instance.
               These settings are only available when platform edition LOOKER_CORE_STANDARD is set.
               There are ten Standard and two Developer users included in the cost of the product.
               You can allocate additional Standard, Viewer, and Developer users for this instance.
               It is an optional step and can be modified later.
               With the Standard edition of Looker (Google Cloud core), you can provision up to 50
               total users, distributed across Viewer, Standard, and Developer.
               Structure is documented below.
        """
        if admin_settings is not None:
            pulumi.set(__self__, "admin_settings", admin_settings)
        if consumer_network is not None:
            pulumi.set(__self__, "consumer_network", consumer_network)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if deny_maintenance_period is not None:
            pulumi.set(__self__, "deny_maintenance_period", deny_maintenance_period)
        if egress_public_ip is not None:
            pulumi.set(__self__, "egress_public_ip", egress_public_ip)
        if encryption_config is not None:
            pulumi.set(__self__, "encryption_config", encryption_config)
        if ingress_private_ip is not None:
            pulumi.set(__self__, "ingress_private_ip", ingress_private_ip)
        if ingress_public_ip is not None:
            pulumi.set(__self__, "ingress_public_ip", ingress_public_ip)
        if looker_uri is not None:
            pulumi.set(__self__, "looker_uri", looker_uri)
        if looker_version is not None:
            pulumi.set(__self__, "looker_version", looker_version)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oauth_config is not None:
            pulumi.set(__self__, "oauth_config", oauth_config)
        if platform_edition is not None:
            pulumi.set(__self__, "platform_edition", platform_edition)
        if private_ip_enabled is not None:
            pulumi.set(__self__, "private_ip_enabled", private_ip_enabled)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if public_ip_enabled is not None:
            pulumi.set(__self__, "public_ip_enabled", public_ip_enabled)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if reserved_range is not None:
            pulumi.set(__self__, "reserved_range", reserved_range)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if user_metadata is not None:
            pulumi.set(__self__, "user_metadata", user_metadata)

    @property
    @pulumi.getter(name="adminSettings")
    def admin_settings(self) -> Optional[pulumi.Input['InstanceAdminSettingsArgs']]:
        """
        Looker instance Admin settings.
        Structure is documented below.
        """
        return pulumi.get(self, "admin_settings")

    @admin_settings.setter
    def admin_settings(self, value: Optional[pulumi.Input['InstanceAdminSettingsArgs']]):
        pulumi.set(self, "admin_settings", value)

    @property
    @pulumi.getter(name="consumerNetwork")
    def consumer_network(self) -> Optional[pulumi.Input[str]]:
        """
        Network name in the consumer project in the format of: projects/{project}/global/networks/{network}
        Note that the consumer network may be in a different GCP project than the consumer
        project that is hosting the Looker Instance.
        """
        return pulumi.get(self, "consumer_network")

    @consumer_network.setter
    def consumer_network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consumer_network", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time the instance was created in RFC3339 UTC "Zulu" format,
        accurate to nanoseconds.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="denyMaintenancePeriod")
    def deny_maintenance_period(self) -> Optional[pulumi.Input['InstanceDenyMaintenancePeriodArgs']]:
        """
        Maintenance denial period for this instance.
        You must allow at least 14 days of maintenance availability
        between any two deny maintenance periods.
        Structure is documented below.
        """
        return pulumi.get(self, "deny_maintenance_period")

    @deny_maintenance_period.setter
    def deny_maintenance_period(self, value: Optional[pulumi.Input['InstanceDenyMaintenancePeriodArgs']]):
        pulumi.set(self, "deny_maintenance_period", value)

    @property
    @pulumi.getter(name="egressPublicIp")
    def egress_public_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Public Egress IP (IPv4).
        """
        return pulumi.get(self, "egress_public_ip")

    @egress_public_ip.setter
    def egress_public_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "egress_public_ip", value)

    @property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> Optional[pulumi.Input['InstanceEncryptionConfigArgs']]:
        """
        Looker instance encryption settings.
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_config")

    @encryption_config.setter
    def encryption_config(self, value: Optional[pulumi.Input['InstanceEncryptionConfigArgs']]):
        pulumi.set(self, "encryption_config", value)

    @property
    @pulumi.getter(name="ingressPrivateIp")
    def ingress_private_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Private Ingress IP (IPv4).
        """
        return pulumi.get(self, "ingress_private_ip")

    @ingress_private_ip.setter
    def ingress_private_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ingress_private_ip", value)

    @property
    @pulumi.getter(name="ingressPublicIp")
    def ingress_public_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Public Ingress IP (IPv4).
        """
        return pulumi.get(self, "ingress_public_ip")

    @ingress_public_ip.setter
    def ingress_public_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ingress_public_ip", value)

    @property
    @pulumi.getter(name="lookerUri")
    def looker_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Looker instance URI which can be used to access the Looker Instance UI.
        """
        return pulumi.get(self, "looker_uri")

    @looker_uri.setter
    def looker_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "looker_uri", value)

    @property
    @pulumi.getter(name="lookerVersion")
    def looker_version(self) -> Optional[pulumi.Input[str]]:
        """
        The Looker version that the instance is using.
        """
        return pulumi.get(self, "looker_version")

    @looker_version.setter
    def looker_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "looker_version", value)

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['InstanceMaintenanceWindowArgs']]:
        """
        Maintenance window for an instance.
        Maintenance of your instance takes place once a month, and will require
        your instance to be restarted during updates, which will temporarily
        disrupt service.
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['InstanceMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the instance or a fully qualified identifier for the instance.


        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="oauthConfig")
    def oauth_config(self) -> Optional[pulumi.Input['InstanceOauthConfigArgs']]:
        """
        Looker Instance OAuth login settings.
        Structure is documented below.
        """
        return pulumi.get(self, "oauth_config")

    @oauth_config.setter
    def oauth_config(self, value: Optional[pulumi.Input['InstanceOauthConfigArgs']]):
        pulumi.set(self, "oauth_config", value)

    @property
    @pulumi.getter(name="platformEdition")
    def platform_edition(self) -> Optional[pulumi.Input[str]]:
        """
        Platform editions for a Looker instance. Each edition maps to a set of instance features, like its size. Must be one of these values:
        - LOOKER_CORE_TRIAL: trial instance
        - LOOKER_CORE_STANDARD: pay as you go standard instance
        - LOOKER_CORE_STANDARD_ANNUAL: subscription standard instance
        - LOOKER_CORE_ENTERPRISE_ANNUAL: subscription enterprise instance
        - LOOKER_CORE_EMBED_ANNUAL: subscription embed instance
        - LOOKER_MODELER: standalone modeling service
        Default value is `LOOKER_CORE_TRIAL`.
        Possible values are: `LOOKER_CORE_TRIAL`, `LOOKER_CORE_STANDARD`, `LOOKER_CORE_STANDARD_ANNUAL`, `LOOKER_CORE_ENTERPRISE_ANNUAL`, `LOOKER_CORE_EMBED_ANNUAL`, `LOOKER_MODELER`.
        """
        return pulumi.get(self, "platform_edition")

    @platform_edition.setter
    def platform_edition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "platform_edition", value)

    @property
    @pulumi.getter(name="privateIpEnabled")
    def private_ip_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether private IP is enabled on the Looker instance.
        """
        return pulumi.get(self, "private_ip_enabled")

    @private_ip_enabled.setter
    def private_ip_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "private_ip_enabled", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="publicIpEnabled")
    def public_ip_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether public IP is enabled on the Looker instance.
        """
        return pulumi.get(self, "public_ip_enabled")

    @public_ip_enabled.setter
    def public_ip_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "public_ip_enabled", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Looker region of the instance.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="reservedRange")
    def reserved_range(self) -> Optional[pulumi.Input[str]]:
        """
        Name of a reserved IP address range within the consumer network, to be used for
        private service access connection. User may or may not specify this in a request.
        """
        return pulumi.get(self, "reserved_range")

    @reserved_range.setter
    def reserved_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reserved_range", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time the instance was updated in RFC3339 UTC "Zulu" format,
        accurate to nanoseconds.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter(name="userMetadata")
    def user_metadata(self) -> Optional[pulumi.Input['InstanceUserMetadataArgs']]:
        """
        Metadata about users for a Looker instance.
        These settings are only available when platform edition LOOKER_CORE_STANDARD is set.
        There are ten Standard and two Developer users included in the cost of the product.
        You can allocate additional Standard, Viewer, and Developer users for this instance.
        It is an optional step and can be modified later.
        With the Standard edition of Looker (Google Cloud core), you can provision up to 50
        total users, distributed across Viewer, Standard, and Developer.
        Structure is documented below.
        """
        return pulumi.get(self, "user_metadata")

    @user_metadata.setter
    def user_metadata(self, value: Optional[pulumi.Input['InstanceUserMetadataArgs']]):
        pulumi.set(self, "user_metadata", value)


class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_settings: Optional[pulumi.Input[pulumi.InputType['InstanceAdminSettingsArgs']]] = None,
                 consumer_network: Optional[pulumi.Input[str]] = None,
                 deny_maintenance_period: Optional[pulumi.Input[pulumi.InputType['InstanceDenyMaintenancePeriodArgs']]] = None,
                 encryption_config: Optional[pulumi.Input[pulumi.InputType['InstanceEncryptionConfigArgs']]] = None,
                 maintenance_window: Optional[pulumi.Input[pulumi.InputType['InstanceMaintenanceWindowArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 oauth_config: Optional[pulumi.Input[pulumi.InputType['InstanceOauthConfigArgs']]] = None,
                 platform_edition: Optional[pulumi.Input[str]] = None,
                 private_ip_enabled: Optional[pulumi.Input[bool]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 public_ip_enabled: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 reserved_range: Optional[pulumi.Input[str]] = None,
                 user_metadata: Optional[pulumi.Input[pulumi.InputType['InstanceUserMetadataArgs']]] = None,
                 __props__=None):
        """
        A Google Cloud Looker instance.

        To get more information about Instance, see:

        * [API documentation](https://cloud.google.com/looker/docs/reference/rest/v1/projects.locations.instances)
        * How-to Guides
            * [Create a Looker (Google Cloud core) instance](https://cloud.google.com/looker/docs/looker-core-instance-create)
            * [Configure a Looker (Google Cloud core) instance](https://cloud.google.com/looker/docs/looker-core-instance-setup)

        ## Example Usage
        ### Looker Instance Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        looker_instance = gcp.looker.Instance("looker-instance",
            oauth_config=gcp.looker.InstanceOauthConfigArgs(
                client_id="my-client-id",
                client_secret="my-client-secret",
            ),
            platform_edition="LOOKER_CORE_STANDARD",
            region="us-central1")
        ```
        ### Looker Instance Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        looker_instance = gcp.looker.Instance("looker-instance",
            admin_settings=gcp.looker.InstanceAdminSettingsArgs(
                allowed_email_domains=["google.com"],
            ),
            deny_maintenance_period=gcp.looker.InstanceDenyMaintenancePeriodArgs(
                end_date=gcp.looker.InstanceDenyMaintenancePeriodEndDateArgs(
                    day=1,
                    month=2,
                    year=2050,
                ),
                start_date=gcp.looker.InstanceDenyMaintenancePeriodStartDateArgs(
                    day=1,
                    month=1,
                    year=2050,
                ),
                time=gcp.looker.InstanceDenyMaintenancePeriodTimeArgs(
                    hours=10,
                    minutes=0,
                    nanos=0,
                    seconds=0,
                ),
            ),
            maintenance_window=gcp.looker.InstanceMaintenanceWindowArgs(
                day_of_week="THURSDAY",
                start_time=gcp.looker.InstanceMaintenanceWindowStartTimeArgs(
                    hours=22,
                    minutes=0,
                    nanos=0,
                    seconds=0,
                ),
            ),
            oauth_config=gcp.looker.InstanceOauthConfigArgs(
                client_id="my-client-id",
                client_secret="my-client-secret",
            ),
            platform_edition="LOOKER_CORE_STANDARD",
            public_ip_enabled=True,
            region="us-central1",
            user_metadata=gcp.looker.InstanceUserMetadataArgs(
                additional_developer_user_count=10,
                additional_standard_user_count=10,
                additional_viewer_user_count=10,
            ))
        ```
        ### Looker Instance Enterprise Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        looker_network = gcp.compute.Network("lookerNetwork", auto_create_subnetworks=False)
        looker_range = gcp.compute.GlobalAddress("lookerRange",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=20,
            network=looker_network.id)
        looker_vpc_connection = gcp.servicenetworking.Connection("lookerVpcConnection",
            network=looker_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[looker_range.name])
        looker_instance = gcp.looker.Instance("looker-instance",
            platform_edition="LOOKER_CORE_ENTERPRISE_ANNUAL",
            region="us-central1",
            private_ip_enabled=True,
            public_ip_enabled=False,
            reserved_range=looker_range.name,
            consumer_network=looker_network.id,
            admin_settings=gcp.looker.InstanceAdminSettingsArgs(
                allowed_email_domains=["google.com"],
            ),
            encryption_config=gcp.looker.InstanceEncryptionConfigArgs(
                kms_key_name="looker-kms-key",
            ),
            maintenance_window=gcp.looker.InstanceMaintenanceWindowArgs(
                day_of_week="THURSDAY",
                start_time=gcp.looker.InstanceMaintenanceWindowStartTimeArgs(
                    hours=22,
                    minutes=0,
                    seconds=0,
                    nanos=0,
                ),
            ),
            deny_maintenance_period=gcp.looker.InstanceDenyMaintenancePeriodArgs(
                start_date=gcp.looker.InstanceDenyMaintenancePeriodStartDateArgs(
                    year=2050,
                    month=1,
                    day=1,
                ),
                end_date=gcp.looker.InstanceDenyMaintenancePeriodEndDateArgs(
                    year=2050,
                    month=2,
                    day=1,
                ),
                time=gcp.looker.InstanceDenyMaintenancePeriodTimeArgs(
                    hours=10,
                    minutes=0,
                    seconds=0,
                    nanos=0,
                ),
            ),
            oauth_config=gcp.looker.InstanceOauthConfigArgs(
                client_id="my-client-id",
                client_secret="my-client-secret",
            ),
            opts=pulumi.ResourceOptions(depends_on=[looker_vpc_connection]))
        project = gcp.organizations.get_project()
        crypto_key = gcp.kms.CryptoKeyIAMMember("cryptoKey",
            crypto_key_id="looker-kms-key",
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            member=f"serviceAccount:service-{project.number}@gcp-sa-looker.iam.gserviceaccount.com")
        ```

        ## Import

        Instance can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:looker/instance:Instance default projects/{{project}}/locations/{{region}}/instances/{{name}}
        ```

        ```sh
         $ pulumi import gcp:looker/instance:Instance default {{project}}/{{region}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:looker/instance:Instance default {{region}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:looker/instance:Instance default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['InstanceAdminSettingsArgs']] admin_settings: Looker instance Admin settings.
               Structure is documented below.
        :param pulumi.Input[str] consumer_network: Network name in the consumer project in the format of: projects/{project}/global/networks/{network}
               Note that the consumer network may be in a different GCP project than the consumer
               project that is hosting the Looker Instance.
        :param pulumi.Input[pulumi.InputType['InstanceDenyMaintenancePeriodArgs']] deny_maintenance_period: Maintenance denial period for this instance.
               You must allow at least 14 days of maintenance availability
               between any two deny maintenance periods.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['InstanceEncryptionConfigArgs']] encryption_config: Looker instance encryption settings.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['InstanceMaintenanceWindowArgs']] maintenance_window: Maintenance window for an instance.
               Maintenance of your instance takes place once a month, and will require
               your instance to be restarted during updates, which will temporarily
               disrupt service.
               Structure is documented below.
        :param pulumi.Input[str] name: The ID of the instance or a fully qualified identifier for the instance.
               
               
               - - -
        :param pulumi.Input[pulumi.InputType['InstanceOauthConfigArgs']] oauth_config: Looker Instance OAuth login settings.
               Structure is documented below.
        :param pulumi.Input[str] platform_edition: Platform editions for a Looker instance. Each edition maps to a set of instance features, like its size. Must be one of these values:
               - LOOKER_CORE_TRIAL: trial instance
               - LOOKER_CORE_STANDARD: pay as you go standard instance
               - LOOKER_CORE_STANDARD_ANNUAL: subscription standard instance
               - LOOKER_CORE_ENTERPRISE_ANNUAL: subscription enterprise instance
               - LOOKER_CORE_EMBED_ANNUAL: subscription embed instance
               - LOOKER_MODELER: standalone modeling service
               Default value is `LOOKER_CORE_TRIAL`.
               Possible values are: `LOOKER_CORE_TRIAL`, `LOOKER_CORE_STANDARD`, `LOOKER_CORE_STANDARD_ANNUAL`, `LOOKER_CORE_ENTERPRISE_ANNUAL`, `LOOKER_CORE_EMBED_ANNUAL`, `LOOKER_MODELER`.
        :param pulumi.Input[bool] private_ip_enabled: Whether private IP is enabled on the Looker instance.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[bool] public_ip_enabled: Whether public IP is enabled on the Looker instance.
        :param pulumi.Input[str] region: The name of the Looker region of the instance.
        :param pulumi.Input[str] reserved_range: Name of a reserved IP address range within the consumer network, to be used for
               private service access connection. User may or may not specify this in a request.
        :param pulumi.Input[pulumi.InputType['InstanceUserMetadataArgs']] user_metadata: Metadata about users for a Looker instance.
               These settings are only available when platform edition LOOKER_CORE_STANDARD is set.
               There are ten Standard and two Developer users included in the cost of the product.
               You can allocate additional Standard, Viewer, and Developer users for this instance.
               It is an optional step and can be modified later.
               With the Standard edition of Looker (Google Cloud core), you can provision up to 50
               total users, distributed across Viewer, Standard, and Developer.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[InstanceArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Google Cloud Looker instance.

        To get more information about Instance, see:

        * [API documentation](https://cloud.google.com/looker/docs/reference/rest/v1/projects.locations.instances)
        * How-to Guides
            * [Create a Looker (Google Cloud core) instance](https://cloud.google.com/looker/docs/looker-core-instance-create)
            * [Configure a Looker (Google Cloud core) instance](https://cloud.google.com/looker/docs/looker-core-instance-setup)

        ## Example Usage
        ### Looker Instance Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        looker_instance = gcp.looker.Instance("looker-instance",
            oauth_config=gcp.looker.InstanceOauthConfigArgs(
                client_id="my-client-id",
                client_secret="my-client-secret",
            ),
            platform_edition="LOOKER_CORE_STANDARD",
            region="us-central1")
        ```
        ### Looker Instance Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        looker_instance = gcp.looker.Instance("looker-instance",
            admin_settings=gcp.looker.InstanceAdminSettingsArgs(
                allowed_email_domains=["google.com"],
            ),
            deny_maintenance_period=gcp.looker.InstanceDenyMaintenancePeriodArgs(
                end_date=gcp.looker.InstanceDenyMaintenancePeriodEndDateArgs(
                    day=1,
                    month=2,
                    year=2050,
                ),
                start_date=gcp.looker.InstanceDenyMaintenancePeriodStartDateArgs(
                    day=1,
                    month=1,
                    year=2050,
                ),
                time=gcp.looker.InstanceDenyMaintenancePeriodTimeArgs(
                    hours=10,
                    minutes=0,
                    nanos=0,
                    seconds=0,
                ),
            ),
            maintenance_window=gcp.looker.InstanceMaintenanceWindowArgs(
                day_of_week="THURSDAY",
                start_time=gcp.looker.InstanceMaintenanceWindowStartTimeArgs(
                    hours=22,
                    minutes=0,
                    nanos=0,
                    seconds=0,
                ),
            ),
            oauth_config=gcp.looker.InstanceOauthConfigArgs(
                client_id="my-client-id",
                client_secret="my-client-secret",
            ),
            platform_edition="LOOKER_CORE_STANDARD",
            public_ip_enabled=True,
            region="us-central1",
            user_metadata=gcp.looker.InstanceUserMetadataArgs(
                additional_developer_user_count=10,
                additional_standard_user_count=10,
                additional_viewer_user_count=10,
            ))
        ```
        ### Looker Instance Enterprise Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        looker_network = gcp.compute.Network("lookerNetwork", auto_create_subnetworks=False)
        looker_range = gcp.compute.GlobalAddress("lookerRange",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=20,
            network=looker_network.id)
        looker_vpc_connection = gcp.servicenetworking.Connection("lookerVpcConnection",
            network=looker_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[looker_range.name])
        looker_instance = gcp.looker.Instance("looker-instance",
            platform_edition="LOOKER_CORE_ENTERPRISE_ANNUAL",
            region="us-central1",
            private_ip_enabled=True,
            public_ip_enabled=False,
            reserved_range=looker_range.name,
            consumer_network=looker_network.id,
            admin_settings=gcp.looker.InstanceAdminSettingsArgs(
                allowed_email_domains=["google.com"],
            ),
            encryption_config=gcp.looker.InstanceEncryptionConfigArgs(
                kms_key_name="looker-kms-key",
            ),
            maintenance_window=gcp.looker.InstanceMaintenanceWindowArgs(
                day_of_week="THURSDAY",
                start_time=gcp.looker.InstanceMaintenanceWindowStartTimeArgs(
                    hours=22,
                    minutes=0,
                    seconds=0,
                    nanos=0,
                ),
            ),
            deny_maintenance_period=gcp.looker.InstanceDenyMaintenancePeriodArgs(
                start_date=gcp.looker.InstanceDenyMaintenancePeriodStartDateArgs(
                    year=2050,
                    month=1,
                    day=1,
                ),
                end_date=gcp.looker.InstanceDenyMaintenancePeriodEndDateArgs(
                    year=2050,
                    month=2,
                    day=1,
                ),
                time=gcp.looker.InstanceDenyMaintenancePeriodTimeArgs(
                    hours=10,
                    minutes=0,
                    seconds=0,
                    nanos=0,
                ),
            ),
            oauth_config=gcp.looker.InstanceOauthConfigArgs(
                client_id="my-client-id",
                client_secret="my-client-secret",
            ),
            opts=pulumi.ResourceOptions(depends_on=[looker_vpc_connection]))
        project = gcp.organizations.get_project()
        crypto_key = gcp.kms.CryptoKeyIAMMember("cryptoKey",
            crypto_key_id="looker-kms-key",
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            member=f"serviceAccount:service-{project.number}@gcp-sa-looker.iam.gserviceaccount.com")
        ```

        ## Import

        Instance can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:looker/instance:Instance default projects/{{project}}/locations/{{region}}/instances/{{name}}
        ```

        ```sh
         $ pulumi import gcp:looker/instance:Instance default {{project}}/{{region}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:looker/instance:Instance default {{region}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:looker/instance:Instance default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_settings: Optional[pulumi.Input[pulumi.InputType['InstanceAdminSettingsArgs']]] = None,
                 consumer_network: Optional[pulumi.Input[str]] = None,
                 deny_maintenance_period: Optional[pulumi.Input[pulumi.InputType['InstanceDenyMaintenancePeriodArgs']]] = None,
                 encryption_config: Optional[pulumi.Input[pulumi.InputType['InstanceEncryptionConfigArgs']]] = None,
                 maintenance_window: Optional[pulumi.Input[pulumi.InputType['InstanceMaintenanceWindowArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 oauth_config: Optional[pulumi.Input[pulumi.InputType['InstanceOauthConfigArgs']]] = None,
                 platform_edition: Optional[pulumi.Input[str]] = None,
                 private_ip_enabled: Optional[pulumi.Input[bool]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 public_ip_enabled: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 reserved_range: Optional[pulumi.Input[str]] = None,
                 user_metadata: Optional[pulumi.Input[pulumi.InputType['InstanceUserMetadataArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["admin_settings"] = admin_settings
            __props__.__dict__["consumer_network"] = consumer_network
            __props__.__dict__["deny_maintenance_period"] = deny_maintenance_period
            __props__.__dict__["encryption_config"] = encryption_config
            __props__.__dict__["maintenance_window"] = maintenance_window
            __props__.__dict__["name"] = name
            __props__.__dict__["oauth_config"] = oauth_config
            __props__.__dict__["platform_edition"] = platform_edition
            __props__.__dict__["private_ip_enabled"] = private_ip_enabled
            __props__.__dict__["project"] = project
            __props__.__dict__["public_ip_enabled"] = public_ip_enabled
            __props__.__dict__["region"] = region
            __props__.__dict__["reserved_range"] = reserved_range
            __props__.__dict__["user_metadata"] = user_metadata
            __props__.__dict__["create_time"] = None
            __props__.__dict__["egress_public_ip"] = None
            __props__.__dict__["ingress_private_ip"] = None
            __props__.__dict__["ingress_public_ip"] = None
            __props__.__dict__["looker_uri"] = None
            __props__.__dict__["looker_version"] = None
            __props__.__dict__["update_time"] = None
        super(Instance, __self__).__init__(
            'gcp:looker/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_settings: Optional[pulumi.Input[pulumi.InputType['InstanceAdminSettingsArgs']]] = None,
            consumer_network: Optional[pulumi.Input[str]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            deny_maintenance_period: Optional[pulumi.Input[pulumi.InputType['InstanceDenyMaintenancePeriodArgs']]] = None,
            egress_public_ip: Optional[pulumi.Input[str]] = None,
            encryption_config: Optional[pulumi.Input[pulumi.InputType['InstanceEncryptionConfigArgs']]] = None,
            ingress_private_ip: Optional[pulumi.Input[str]] = None,
            ingress_public_ip: Optional[pulumi.Input[str]] = None,
            looker_uri: Optional[pulumi.Input[str]] = None,
            looker_version: Optional[pulumi.Input[str]] = None,
            maintenance_window: Optional[pulumi.Input[pulumi.InputType['InstanceMaintenanceWindowArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            oauth_config: Optional[pulumi.Input[pulumi.InputType['InstanceOauthConfigArgs']]] = None,
            platform_edition: Optional[pulumi.Input[str]] = None,
            private_ip_enabled: Optional[pulumi.Input[bool]] = None,
            project: Optional[pulumi.Input[str]] = None,
            public_ip_enabled: Optional[pulumi.Input[bool]] = None,
            region: Optional[pulumi.Input[str]] = None,
            reserved_range: Optional[pulumi.Input[str]] = None,
            update_time: Optional[pulumi.Input[str]] = None,
            user_metadata: Optional[pulumi.Input[pulumi.InputType['InstanceUserMetadataArgs']]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['InstanceAdminSettingsArgs']] admin_settings: Looker instance Admin settings.
               Structure is documented below.
        :param pulumi.Input[str] consumer_network: Network name in the consumer project in the format of: projects/{project}/global/networks/{network}
               Note that the consumer network may be in a different GCP project than the consumer
               project that is hosting the Looker Instance.
        :param pulumi.Input[str] create_time: The time the instance was created in RFC3339 UTC "Zulu" format,
               accurate to nanoseconds.
        :param pulumi.Input[pulumi.InputType['InstanceDenyMaintenancePeriodArgs']] deny_maintenance_period: Maintenance denial period for this instance.
               You must allow at least 14 days of maintenance availability
               between any two deny maintenance periods.
               Structure is documented below.
        :param pulumi.Input[str] egress_public_ip: Public Egress IP (IPv4).
        :param pulumi.Input[pulumi.InputType['InstanceEncryptionConfigArgs']] encryption_config: Looker instance encryption settings.
               Structure is documented below.
        :param pulumi.Input[str] ingress_private_ip: Private Ingress IP (IPv4).
        :param pulumi.Input[str] ingress_public_ip: Public Ingress IP (IPv4).
        :param pulumi.Input[str] looker_uri: Looker instance URI which can be used to access the Looker Instance UI.
        :param pulumi.Input[str] looker_version: The Looker version that the instance is using.
        :param pulumi.Input[pulumi.InputType['InstanceMaintenanceWindowArgs']] maintenance_window: Maintenance window for an instance.
               Maintenance of your instance takes place once a month, and will require
               your instance to be restarted during updates, which will temporarily
               disrupt service.
               Structure is documented below.
        :param pulumi.Input[str] name: The ID of the instance or a fully qualified identifier for the instance.
               
               
               - - -
        :param pulumi.Input[pulumi.InputType['InstanceOauthConfigArgs']] oauth_config: Looker Instance OAuth login settings.
               Structure is documented below.
        :param pulumi.Input[str] platform_edition: Platform editions for a Looker instance. Each edition maps to a set of instance features, like its size. Must be one of these values:
               - LOOKER_CORE_TRIAL: trial instance
               - LOOKER_CORE_STANDARD: pay as you go standard instance
               - LOOKER_CORE_STANDARD_ANNUAL: subscription standard instance
               - LOOKER_CORE_ENTERPRISE_ANNUAL: subscription enterprise instance
               - LOOKER_CORE_EMBED_ANNUAL: subscription embed instance
               - LOOKER_MODELER: standalone modeling service
               Default value is `LOOKER_CORE_TRIAL`.
               Possible values are: `LOOKER_CORE_TRIAL`, `LOOKER_CORE_STANDARD`, `LOOKER_CORE_STANDARD_ANNUAL`, `LOOKER_CORE_ENTERPRISE_ANNUAL`, `LOOKER_CORE_EMBED_ANNUAL`, `LOOKER_MODELER`.
        :param pulumi.Input[bool] private_ip_enabled: Whether private IP is enabled on the Looker instance.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[bool] public_ip_enabled: Whether public IP is enabled on the Looker instance.
        :param pulumi.Input[str] region: The name of the Looker region of the instance.
        :param pulumi.Input[str] reserved_range: Name of a reserved IP address range within the consumer network, to be used for
               private service access connection. User may or may not specify this in a request.
        :param pulumi.Input[str] update_time: The time the instance was updated in RFC3339 UTC "Zulu" format,
               accurate to nanoseconds.
        :param pulumi.Input[pulumi.InputType['InstanceUserMetadataArgs']] user_metadata: Metadata about users for a Looker instance.
               These settings are only available when platform edition LOOKER_CORE_STANDARD is set.
               There are ten Standard and two Developer users included in the cost of the product.
               You can allocate additional Standard, Viewer, and Developer users for this instance.
               It is an optional step and can be modified later.
               With the Standard edition of Looker (Google Cloud core), you can provision up to 50
               total users, distributed across Viewer, Standard, and Developer.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["admin_settings"] = admin_settings
        __props__.__dict__["consumer_network"] = consumer_network
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["deny_maintenance_period"] = deny_maintenance_period
        __props__.__dict__["egress_public_ip"] = egress_public_ip
        __props__.__dict__["encryption_config"] = encryption_config
        __props__.__dict__["ingress_private_ip"] = ingress_private_ip
        __props__.__dict__["ingress_public_ip"] = ingress_public_ip
        __props__.__dict__["looker_uri"] = looker_uri
        __props__.__dict__["looker_version"] = looker_version
        __props__.__dict__["maintenance_window"] = maintenance_window
        __props__.__dict__["name"] = name
        __props__.__dict__["oauth_config"] = oauth_config
        __props__.__dict__["platform_edition"] = platform_edition
        __props__.__dict__["private_ip_enabled"] = private_ip_enabled
        __props__.__dict__["project"] = project
        __props__.__dict__["public_ip_enabled"] = public_ip_enabled
        __props__.__dict__["region"] = region
        __props__.__dict__["reserved_range"] = reserved_range
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["user_metadata"] = user_metadata
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="adminSettings")
    def admin_settings(self) -> pulumi.Output[Optional['outputs.InstanceAdminSettings']]:
        """
        Looker instance Admin settings.
        Structure is documented below.
        """
        return pulumi.get(self, "admin_settings")

    @property
    @pulumi.getter(name="consumerNetwork")
    def consumer_network(self) -> pulumi.Output[Optional[str]]:
        """
        Network name in the consumer project in the format of: projects/{project}/global/networks/{network}
        Note that the consumer network may be in a different GCP project than the consumer
        project that is hosting the Looker Instance.
        """
        return pulumi.get(self, "consumer_network")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The time the instance was created in RFC3339 UTC "Zulu" format,
        accurate to nanoseconds.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="denyMaintenancePeriod")
    def deny_maintenance_period(self) -> pulumi.Output[Optional['outputs.InstanceDenyMaintenancePeriod']]:
        """
        Maintenance denial period for this instance.
        You must allow at least 14 days of maintenance availability
        between any two deny maintenance periods.
        Structure is documented below.
        """
        return pulumi.get(self, "deny_maintenance_period")

    @property
    @pulumi.getter(name="egressPublicIp")
    def egress_public_ip(self) -> pulumi.Output[str]:
        """
        Public Egress IP (IPv4).
        """
        return pulumi.get(self, "egress_public_ip")

    @property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> pulumi.Output['outputs.InstanceEncryptionConfig']:
        """
        Looker instance encryption settings.
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_config")

    @property
    @pulumi.getter(name="ingressPrivateIp")
    def ingress_private_ip(self) -> pulumi.Output[str]:
        """
        Private Ingress IP (IPv4).
        """
        return pulumi.get(self, "ingress_private_ip")

    @property
    @pulumi.getter(name="ingressPublicIp")
    def ingress_public_ip(self) -> pulumi.Output[str]:
        """
        Public Ingress IP (IPv4).
        """
        return pulumi.get(self, "ingress_public_ip")

    @property
    @pulumi.getter(name="lookerUri")
    def looker_uri(self) -> pulumi.Output[str]:
        """
        Looker instance URI which can be used to access the Looker Instance UI.
        """
        return pulumi.get(self, "looker_uri")

    @property
    @pulumi.getter(name="lookerVersion")
    def looker_version(self) -> pulumi.Output[str]:
        """
        The Looker version that the instance is using.
        """
        return pulumi.get(self, "looker_version")

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> pulumi.Output[Optional['outputs.InstanceMaintenanceWindow']]:
        """
        Maintenance window for an instance.
        Maintenance of your instance takes place once a month, and will require
        your instance to be restarted during updates, which will temporarily
        disrupt service.
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance_window")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The ID of the instance or a fully qualified identifier for the instance.


        - - -
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="oauthConfig")
    def oauth_config(self) -> pulumi.Output[Optional['outputs.InstanceOauthConfig']]:
        """
        Looker Instance OAuth login settings.
        Structure is documented below.
        """
        return pulumi.get(self, "oauth_config")

    @property
    @pulumi.getter(name="platformEdition")
    def platform_edition(self) -> pulumi.Output[Optional[str]]:
        """
        Platform editions for a Looker instance. Each edition maps to a set of instance features, like its size. Must be one of these values:
        - LOOKER_CORE_TRIAL: trial instance
        - LOOKER_CORE_STANDARD: pay as you go standard instance
        - LOOKER_CORE_STANDARD_ANNUAL: subscription standard instance
        - LOOKER_CORE_ENTERPRISE_ANNUAL: subscription enterprise instance
        - LOOKER_CORE_EMBED_ANNUAL: subscription embed instance
        - LOOKER_MODELER: standalone modeling service
        Default value is `LOOKER_CORE_TRIAL`.
        Possible values are: `LOOKER_CORE_TRIAL`, `LOOKER_CORE_STANDARD`, `LOOKER_CORE_STANDARD_ANNUAL`, `LOOKER_CORE_ENTERPRISE_ANNUAL`, `LOOKER_CORE_EMBED_ANNUAL`, `LOOKER_MODELER`.
        """
        return pulumi.get(self, "platform_edition")

    @property
    @pulumi.getter(name="privateIpEnabled")
    def private_ip_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether private IP is enabled on the Looker instance.
        """
        return pulumi.get(self, "private_ip_enabled")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="publicIpEnabled")
    def public_ip_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether public IP is enabled on the Looker instance.
        """
        return pulumi.get(self, "public_ip_enabled")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The name of the Looker region of the instance.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="reservedRange")
    def reserved_range(self) -> pulumi.Output[Optional[str]]:
        """
        Name of a reserved IP address range within the consumer network, to be used for
        private service access connection. User may or may not specify this in a request.
        """
        return pulumi.get(self, "reserved_range")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The time the instance was updated in RFC3339 UTC "Zulu" format,
        accurate to nanoseconds.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="userMetadata")
    def user_metadata(self) -> pulumi.Output[Optional['outputs.InstanceUserMetadata']]:
        """
        Metadata about users for a Looker instance.
        These settings are only available when platform edition LOOKER_CORE_STANDARD is set.
        There are ten Standard and two Developer users included in the cost of the product.
        You can allocate additional Standard, Viewer, and Developer users for this instance.
        It is an optional step and can be modified later.
        With the Standard edition of Looker (Google Cloud core), you can provision up to 50
        total users, distributed across Viewer, Standard, and Developer.
        Structure is documented below.
        """
        return pulumi.get(self, "user_metadata")

