# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['GatewaySecurityPolicyRuleArgs', 'GatewaySecurityPolicyRule']

@pulumi.input_type
class GatewaySecurityPolicyRuleArgs:
    def __init__(__self__, *,
                 basic_profile: pulumi.Input[str],
                 enabled: pulumi.Input[bool],
                 gateway_security_policy: pulumi.Input[str],
                 location: pulumi.Input[str],
                 priority: pulumi.Input[int],
                 session_matcher: pulumi.Input[str],
                 application_matcher: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 tls_inspection_enabled: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a GatewaySecurityPolicyRule resource.
        :param pulumi.Input[str] basic_profile: Profile which tells what the primitive action should be. Possible values are: * ALLOW * DENY.
               Possible values are: `BASIC_PROFILE_UNSPECIFIED`, `ALLOW`, `DENY`.
        :param pulumi.Input[bool] enabled: Whether the rule is enforced.
        :param pulumi.Input[str] gateway_security_policy: The name of the gatewat security policy this rule belongs to.
               
               
               - - -
        :param pulumi.Input[str] location: The location of the gateway security policy.
        :param pulumi.Input[int] priority: Priority of the rule. Lower number corresponds to higher precedence.
        :param pulumi.Input[str] session_matcher: CEL expression for matching on session criteria.
        :param pulumi.Input[str] application_matcher: CEL expression for matching on L7/application level criteria.
        :param pulumi.Input[str] description: Free-text description of the resource.
        :param pulumi.Input[str] name: Name of the resource. ame is the full resource name so projects/{project}/locations/{location}/gatewaySecurityPolicies/{gateway_security_policy}/rules/{rule}
               rule should match the pattern: (^a-z?$).
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[bool] tls_inspection_enabled: Flag to enable TLS inspection of traffic matching on. Can only be true if the
               parent GatewaySecurityPolicy references a TLSInspectionConfig.
        """
        pulumi.set(__self__, "basic_profile", basic_profile)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "gateway_security_policy", gateway_security_policy)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "session_matcher", session_matcher)
        if application_matcher is not None:
            pulumi.set(__self__, "application_matcher", application_matcher)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if tls_inspection_enabled is not None:
            pulumi.set(__self__, "tls_inspection_enabled", tls_inspection_enabled)

    @property
    @pulumi.getter(name="basicProfile")
    def basic_profile(self) -> pulumi.Input[str]:
        """
        Profile which tells what the primitive action should be. Possible values are: * ALLOW * DENY.
        Possible values are: `BASIC_PROFILE_UNSPECIFIED`, `ALLOW`, `DENY`.
        """
        return pulumi.get(self, "basic_profile")

    @basic_profile.setter
    def basic_profile(self, value: pulumi.Input[str]):
        pulumi.set(self, "basic_profile", value)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Whether the rule is enforced.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="gatewaySecurityPolicy")
    def gateway_security_policy(self) -> pulumi.Input[str]:
        """
        The name of the gatewat security policy this rule belongs to.


        - - -
        """
        return pulumi.get(self, "gateway_security_policy")

    @gateway_security_policy.setter
    def gateway_security_policy(self, value: pulumi.Input[str]):
        pulumi.set(self, "gateway_security_policy", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        The location of the gateway security policy.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Input[int]:
        """
        Priority of the rule. Lower number corresponds to higher precedence.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: pulumi.Input[int]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="sessionMatcher")
    def session_matcher(self) -> pulumi.Input[str]:
        """
        CEL expression for matching on session criteria.
        """
        return pulumi.get(self, "session_matcher")

    @session_matcher.setter
    def session_matcher(self, value: pulumi.Input[str]):
        pulumi.set(self, "session_matcher", value)

    @property
    @pulumi.getter(name="applicationMatcher")
    def application_matcher(self) -> Optional[pulumi.Input[str]]:
        """
        CEL expression for matching on L7/application level criteria.
        """
        return pulumi.get(self, "application_matcher")

    @application_matcher.setter
    def application_matcher(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_matcher", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Free-text description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource. ame is the full resource name so projects/{project}/locations/{location}/gatewaySecurityPolicies/{gateway_security_policy}/rules/{rule}
        rule should match the pattern: (^a-z?$).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="tlsInspectionEnabled")
    def tls_inspection_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to enable TLS inspection of traffic matching on. Can only be true if the
        parent GatewaySecurityPolicy references a TLSInspectionConfig.
        """
        return pulumi.get(self, "tls_inspection_enabled")

    @tls_inspection_enabled.setter
    def tls_inspection_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "tls_inspection_enabled", value)


@pulumi.input_type
class _GatewaySecurityPolicyRuleState:
    def __init__(__self__, *,
                 application_matcher: Optional[pulumi.Input[str]] = None,
                 basic_profile: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 gateway_security_policy: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 session_matcher: Optional[pulumi.Input[str]] = None,
                 tls_inspection_enabled: Optional[pulumi.Input[bool]] = None,
                 update_time: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering GatewaySecurityPolicyRule resources.
        :param pulumi.Input[str] application_matcher: CEL expression for matching on L7/application level criteria.
        :param pulumi.Input[str] basic_profile: Profile which tells what the primitive action should be. Possible values are: * ALLOW * DENY.
               Possible values are: `BASIC_PROFILE_UNSPECIFIED`, `ALLOW`, `DENY`.
        :param pulumi.Input[str] create_time: The timestamp when the resource was created.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
               Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z"
        :param pulumi.Input[str] description: Free-text description of the resource.
        :param pulumi.Input[bool] enabled: Whether the rule is enforced.
        :param pulumi.Input[str] gateway_security_policy: The name of the gatewat security policy this rule belongs to.
               
               
               - - -
        :param pulumi.Input[str] location: The location of the gateway security policy.
        :param pulumi.Input[str] name: Name of the resource. ame is the full resource name so projects/{project}/locations/{location}/gatewaySecurityPolicies/{gateway_security_policy}/rules/{rule}
               rule should match the pattern: (^a-z?$).
        :param pulumi.Input[int] priority: Priority of the rule. Lower number corresponds to higher precedence.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] self_link: Server-defined URL of this resource.
        :param pulumi.Input[str] session_matcher: CEL expression for matching on session criteria.
        :param pulumi.Input[bool] tls_inspection_enabled: Flag to enable TLS inspection of traffic matching on. Can only be true if the
               parent GatewaySecurityPolicy references a TLSInspectionConfig.
        :param pulumi.Input[str] update_time: The timestamp when the resource was updated.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
               Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        if application_matcher is not None:
            pulumi.set(__self__, "application_matcher", application_matcher)
        if basic_profile is not None:
            pulumi.set(__self__, "basic_profile", basic_profile)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if gateway_security_policy is not None:
            pulumi.set(__self__, "gateway_security_policy", gateway_security_policy)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if session_matcher is not None:
            pulumi.set(__self__, "session_matcher", session_matcher)
        if tls_inspection_enabled is not None:
            pulumi.set(__self__, "tls_inspection_enabled", tls_inspection_enabled)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="applicationMatcher")
    def application_matcher(self) -> Optional[pulumi.Input[str]]:
        """
        CEL expression for matching on L7/application level criteria.
        """
        return pulumi.get(self, "application_matcher")

    @application_matcher.setter
    def application_matcher(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_matcher", value)

    @property
    @pulumi.getter(name="basicProfile")
    def basic_profile(self) -> Optional[pulumi.Input[str]]:
        """
        Profile which tells what the primitive action should be. Possible values are: * ALLOW * DENY.
        Possible values are: `BASIC_PROFILE_UNSPECIFIED`, `ALLOW`, `DENY`.
        """
        return pulumi.get(self, "basic_profile")

    @basic_profile.setter
    def basic_profile(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "basic_profile", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp when the resource was created.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z"
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Free-text description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the rule is enforced.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="gatewaySecurityPolicy")
    def gateway_security_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the gatewat security policy this rule belongs to.


        - - -
        """
        return pulumi.get(self, "gateway_security_policy")

    @gateway_security_policy.setter
    def gateway_security_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gateway_security_policy", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location of the gateway security policy.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource. ame is the full resource name so projects/{project}/locations/{location}/gatewaySecurityPolicies/{gateway_security_policy}/rules/{rule}
        rule should match the pattern: (^a-z?$).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Priority of the rule. Lower number corresponds to higher precedence.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[str]]:
        """
        Server-defined URL of this resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter(name="sessionMatcher")
    def session_matcher(self) -> Optional[pulumi.Input[str]]:
        """
        CEL expression for matching on session criteria.
        """
        return pulumi.get(self, "session_matcher")

    @session_matcher.setter
    def session_matcher(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "session_matcher", value)

    @property
    @pulumi.getter(name="tlsInspectionEnabled")
    def tls_inspection_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to enable TLS inspection of traffic matching on. Can only be true if the
        parent GatewaySecurityPolicy references a TLSInspectionConfig.
        """
        return pulumi.get(self, "tls_inspection_enabled")

    @tls_inspection_enabled.setter
    def tls_inspection_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "tls_inspection_enabled", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp when the resource was updated.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)


class GatewaySecurityPolicyRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_matcher: Optional[pulumi.Input[str]] = None,
                 basic_profile: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 gateway_security_policy: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 session_matcher: Optional[pulumi.Input[str]] = None,
                 tls_inspection_enabled: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        The GatewaySecurityPolicyRule resource is in a nested collection within a GatewaySecurityPolicy and represents
        a traffic matching condition and associated action to perform.

        To get more information about GatewaySecurityPolicyRule, see:

        * [API documentation](https://cloud.google.com/secure-web-proxy/docs/reference/network-security/rest/v1/projects.locations.gatewaySecurityPolicies.rules)

        ## Example Usage
        ### Network Security Gateway Security Policy Rules Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_gateway_security_policy = gcp.networksecurity.GatewaySecurityPolicy("defaultGatewaySecurityPolicy",
            location="us-central1",
            description="gateway security policy created to be used as reference by the rule.")
        default_gateway_security_policy_rule = gcp.networksecurity.GatewaySecurityPolicyRule("defaultGatewaySecurityPolicyRule",
            location="us-central1",
            gateway_security_policy=default_gateway_security_policy.name,
            enabled=True,
            description="my description",
            priority=0,
            session_matcher="host() == 'example.com'",
            basic_profile="ALLOW")
        ```
        ### Network Security Gateway Security Policy Rules Advanced

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_gateway_security_policy = gcp.networksecurity.GatewaySecurityPolicy("defaultGatewaySecurityPolicy",
            location="us-central1",
            description="gateway security policy created to be used as reference by the rule.")
        default_gateway_security_policy_rule = gcp.networksecurity.GatewaySecurityPolicyRule("defaultGatewaySecurityPolicyRule",
            location="us-central1",
            gateway_security_policy=default_gateway_security_policy.name,
            enabled=True,
            description="my description",
            priority=0,
            session_matcher="host() == 'example.com'",
            application_matcher="request.method == 'POST'",
            tls_inspection_enabled=False,
            basic_profile="ALLOW")
        ```

        ## Import

        GatewaySecurityPolicyRule can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:networksecurity/gatewaySecurityPolicyRule:GatewaySecurityPolicyRule default projects/{{project}}/locations/{{location}}/gatewaySecurityPolicies/{{gateway_security_policy}}/rules/{{name}}
        ```

        ```sh
         $ pulumi import gcp:networksecurity/gatewaySecurityPolicyRule:GatewaySecurityPolicyRule default {{project}}/{{location}}/{{gateway_security_policy}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:networksecurity/gatewaySecurityPolicyRule:GatewaySecurityPolicyRule default {{location}}/{{gateway_security_policy}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_matcher: CEL expression for matching on L7/application level criteria.
        :param pulumi.Input[str] basic_profile: Profile which tells what the primitive action should be. Possible values are: * ALLOW * DENY.
               Possible values are: `BASIC_PROFILE_UNSPECIFIED`, `ALLOW`, `DENY`.
        :param pulumi.Input[str] description: Free-text description of the resource.
        :param pulumi.Input[bool] enabled: Whether the rule is enforced.
        :param pulumi.Input[str] gateway_security_policy: The name of the gatewat security policy this rule belongs to.
               
               
               - - -
        :param pulumi.Input[str] location: The location of the gateway security policy.
        :param pulumi.Input[str] name: Name of the resource. ame is the full resource name so projects/{project}/locations/{location}/gatewaySecurityPolicies/{gateway_security_policy}/rules/{rule}
               rule should match the pattern: (^a-z?$).
        :param pulumi.Input[int] priority: Priority of the rule. Lower number corresponds to higher precedence.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] session_matcher: CEL expression for matching on session criteria.
        :param pulumi.Input[bool] tls_inspection_enabled: Flag to enable TLS inspection of traffic matching on. Can only be true if the
               parent GatewaySecurityPolicy references a TLSInspectionConfig.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GatewaySecurityPolicyRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The GatewaySecurityPolicyRule resource is in a nested collection within a GatewaySecurityPolicy and represents
        a traffic matching condition and associated action to perform.

        To get more information about GatewaySecurityPolicyRule, see:

        * [API documentation](https://cloud.google.com/secure-web-proxy/docs/reference/network-security/rest/v1/projects.locations.gatewaySecurityPolicies.rules)

        ## Example Usage
        ### Network Security Gateway Security Policy Rules Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_gateway_security_policy = gcp.networksecurity.GatewaySecurityPolicy("defaultGatewaySecurityPolicy",
            location="us-central1",
            description="gateway security policy created to be used as reference by the rule.")
        default_gateway_security_policy_rule = gcp.networksecurity.GatewaySecurityPolicyRule("defaultGatewaySecurityPolicyRule",
            location="us-central1",
            gateway_security_policy=default_gateway_security_policy.name,
            enabled=True,
            description="my description",
            priority=0,
            session_matcher="host() == 'example.com'",
            basic_profile="ALLOW")
        ```
        ### Network Security Gateway Security Policy Rules Advanced

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_gateway_security_policy = gcp.networksecurity.GatewaySecurityPolicy("defaultGatewaySecurityPolicy",
            location="us-central1",
            description="gateway security policy created to be used as reference by the rule.")
        default_gateway_security_policy_rule = gcp.networksecurity.GatewaySecurityPolicyRule("defaultGatewaySecurityPolicyRule",
            location="us-central1",
            gateway_security_policy=default_gateway_security_policy.name,
            enabled=True,
            description="my description",
            priority=0,
            session_matcher="host() == 'example.com'",
            application_matcher="request.method == 'POST'",
            tls_inspection_enabled=False,
            basic_profile="ALLOW")
        ```

        ## Import

        GatewaySecurityPolicyRule can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:networksecurity/gatewaySecurityPolicyRule:GatewaySecurityPolicyRule default projects/{{project}}/locations/{{location}}/gatewaySecurityPolicies/{{gateway_security_policy}}/rules/{{name}}
        ```

        ```sh
         $ pulumi import gcp:networksecurity/gatewaySecurityPolicyRule:GatewaySecurityPolicyRule default {{project}}/{{location}}/{{gateway_security_policy}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:networksecurity/gatewaySecurityPolicyRule:GatewaySecurityPolicyRule default {{location}}/{{gateway_security_policy}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param GatewaySecurityPolicyRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GatewaySecurityPolicyRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_matcher: Optional[pulumi.Input[str]] = None,
                 basic_profile: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 gateway_security_policy: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 session_matcher: Optional[pulumi.Input[str]] = None,
                 tls_inspection_enabled: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GatewaySecurityPolicyRuleArgs.__new__(GatewaySecurityPolicyRuleArgs)

            __props__.__dict__["application_matcher"] = application_matcher
            if basic_profile is None and not opts.urn:
                raise TypeError("Missing required property 'basic_profile'")
            __props__.__dict__["basic_profile"] = basic_profile
            __props__.__dict__["description"] = description
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            if gateway_security_policy is None and not opts.urn:
                raise TypeError("Missing required property 'gateway_security_policy'")
            __props__.__dict__["gateway_security_policy"] = gateway_security_policy
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if priority is None and not opts.urn:
                raise TypeError("Missing required property 'priority'")
            __props__.__dict__["priority"] = priority
            __props__.__dict__["project"] = project
            if session_matcher is None and not opts.urn:
                raise TypeError("Missing required property 'session_matcher'")
            __props__.__dict__["session_matcher"] = session_matcher
            __props__.__dict__["tls_inspection_enabled"] = tls_inspection_enabled
            __props__.__dict__["create_time"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["update_time"] = None
        super(GatewaySecurityPolicyRule, __self__).__init__(
            'gcp:networksecurity/gatewaySecurityPolicyRule:GatewaySecurityPolicyRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_matcher: Optional[pulumi.Input[str]] = None,
            basic_profile: Optional[pulumi.Input[str]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            gateway_security_policy: Optional[pulumi.Input[str]] = None,
            location: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            priority: Optional[pulumi.Input[int]] = None,
            project: Optional[pulumi.Input[str]] = None,
            self_link: Optional[pulumi.Input[str]] = None,
            session_matcher: Optional[pulumi.Input[str]] = None,
            tls_inspection_enabled: Optional[pulumi.Input[bool]] = None,
            update_time: Optional[pulumi.Input[str]] = None) -> 'GatewaySecurityPolicyRule':
        """
        Get an existing GatewaySecurityPolicyRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_matcher: CEL expression for matching on L7/application level criteria.
        :param pulumi.Input[str] basic_profile: Profile which tells what the primitive action should be. Possible values are: * ALLOW * DENY.
               Possible values are: `BASIC_PROFILE_UNSPECIFIED`, `ALLOW`, `DENY`.
        :param pulumi.Input[str] create_time: The timestamp when the resource was created.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
               Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z"
        :param pulumi.Input[str] description: Free-text description of the resource.
        :param pulumi.Input[bool] enabled: Whether the rule is enforced.
        :param pulumi.Input[str] gateway_security_policy: The name of the gatewat security policy this rule belongs to.
               
               
               - - -
        :param pulumi.Input[str] location: The location of the gateway security policy.
        :param pulumi.Input[str] name: Name of the resource. ame is the full resource name so projects/{project}/locations/{location}/gatewaySecurityPolicies/{gateway_security_policy}/rules/{rule}
               rule should match the pattern: (^a-z?$).
        :param pulumi.Input[int] priority: Priority of the rule. Lower number corresponds to higher precedence.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] self_link: Server-defined URL of this resource.
        :param pulumi.Input[str] session_matcher: CEL expression for matching on session criteria.
        :param pulumi.Input[bool] tls_inspection_enabled: Flag to enable TLS inspection of traffic matching on. Can only be true if the
               parent GatewaySecurityPolicy references a TLSInspectionConfig.
        :param pulumi.Input[str] update_time: The timestamp when the resource was updated.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
               Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GatewaySecurityPolicyRuleState.__new__(_GatewaySecurityPolicyRuleState)

        __props__.__dict__["application_matcher"] = application_matcher
        __props__.__dict__["basic_profile"] = basic_profile
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["gateway_security_policy"] = gateway_security_policy
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["priority"] = priority
        __props__.__dict__["project"] = project
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["session_matcher"] = session_matcher
        __props__.__dict__["tls_inspection_enabled"] = tls_inspection_enabled
        __props__.__dict__["update_time"] = update_time
        return GatewaySecurityPolicyRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationMatcher")
    def application_matcher(self) -> pulumi.Output[Optional[str]]:
        """
        CEL expression for matching on L7/application level criteria.
        """
        return pulumi.get(self, "application_matcher")

    @property
    @pulumi.getter(name="basicProfile")
    def basic_profile(self) -> pulumi.Output[str]:
        """
        Profile which tells what the primitive action should be. Possible values are: * ALLOW * DENY.
        Possible values are: `BASIC_PROFILE_UNSPECIFIED`, `ALLOW`, `DENY`.
        """
        return pulumi.get(self, "basic_profile")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The timestamp when the resource was created.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z"
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Free-text description of the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[bool]:
        """
        Whether the rule is enforced.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="gatewaySecurityPolicy")
    def gateway_security_policy(self) -> pulumi.Output[str]:
        """
        The name of the gatewat security policy this rule belongs to.


        - - -
        """
        return pulumi.get(self, "gateway_security_policy")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The location of the gateway security policy.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the resource. ame is the full resource name so projects/{project}/locations/{location}/gatewaySecurityPolicies/{gateway_security_policy}/rules/{rule}
        rule should match the pattern: (^a-z?$).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[int]:
        """
        Priority of the rule. Lower number corresponds to higher precedence.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        """
        Server-defined URL of this resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="sessionMatcher")
    def session_matcher(self) -> pulumi.Output[str]:
        """
        CEL expression for matching on session criteria.
        """
        return pulumi.get(self, "session_matcher")

    @property
    @pulumi.getter(name="tlsInspectionEnabled")
    def tls_inspection_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Flag to enable TLS inspection of traffic matching on. Can only be true if the
        parent GatewaySecurityPolicy references a TLSInspectionConfig.
        """
        return pulumi.get(self, "tls_inspection_enabled")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The timestamp when the resource was updated.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "update_time")

