# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['TlsInspectionPolicyArgs', 'TlsInspectionPolicy']

@pulumi.input_type
class TlsInspectionPolicyArgs:
    def __init__(__self__, *,
                 ca_pool: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 exclude_public_ca_set: Optional[pulumi.Input[bool]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a TlsInspectionPolicy resource.
        :param pulumi.Input[str] ca_pool: A CA pool resource used to issue interception certificates.
        :param pulumi.Input[str] description: Free-text description of the resource.
        :param pulumi.Input[bool] exclude_public_ca_set: If FALSE (the default), use our default set of public CAs in addition to any CAs specified in trustConfig. These public CAs are currently based on the Mozilla Root Program and are subject to change over time. If TRUE, do not accept our default set of public CAs. Only CAs specified in trustConfig will be accepted.
        :param pulumi.Input[str] location: The location of the tls inspection policy.
        :param pulumi.Input[str] name: Short name of the TlsInspectionPolicy resource to be created.
               
               
               - - -
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "ca_pool", ca_pool)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if exclude_public_ca_set is not None:
            pulumi.set(__self__, "exclude_public_ca_set", exclude_public_ca_set)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="caPool")
    def ca_pool(self) -> pulumi.Input[str]:
        """
        A CA pool resource used to issue interception certificates.
        """
        return pulumi.get(self, "ca_pool")

    @ca_pool.setter
    def ca_pool(self, value: pulumi.Input[str]):
        pulumi.set(self, "ca_pool", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Free-text description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="excludePublicCaSet")
    def exclude_public_ca_set(self) -> Optional[pulumi.Input[bool]]:
        """
        If FALSE (the default), use our default set of public CAs in addition to any CAs specified in trustConfig. These public CAs are currently based on the Mozilla Root Program and are subject to change over time. If TRUE, do not accept our default set of public CAs. Only CAs specified in trustConfig will be accepted.
        """
        return pulumi.get(self, "exclude_public_ca_set")

    @exclude_public_ca_set.setter
    def exclude_public_ca_set(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "exclude_public_ca_set", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location of the tls inspection policy.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Short name of the TlsInspectionPolicy resource to be created.


        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _TlsInspectionPolicyState:
    def __init__(__self__, *,
                 ca_pool: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 exclude_public_ca_set: Optional[pulumi.Input[bool]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering TlsInspectionPolicy resources.
        :param pulumi.Input[str] ca_pool: A CA pool resource used to issue interception certificates.
        :param pulumi.Input[str] create_time: The timestamp when the resource was created.
        :param pulumi.Input[str] description: Free-text description of the resource.
        :param pulumi.Input[bool] exclude_public_ca_set: If FALSE (the default), use our default set of public CAs in addition to any CAs specified in trustConfig. These public CAs are currently based on the Mozilla Root Program and are subject to change over time. If TRUE, do not accept our default set of public CAs. Only CAs specified in trustConfig will be accepted.
        :param pulumi.Input[str] location: The location of the tls inspection policy.
        :param pulumi.Input[str] name: Short name of the TlsInspectionPolicy resource to be created.
               
               
               - - -
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] update_time: The timestamp when the resource was updated.
        """
        if ca_pool is not None:
            pulumi.set(__self__, "ca_pool", ca_pool)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if exclude_public_ca_set is not None:
            pulumi.set(__self__, "exclude_public_ca_set", exclude_public_ca_set)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="caPool")
    def ca_pool(self) -> Optional[pulumi.Input[str]]:
        """
        A CA pool resource used to issue interception certificates.
        """
        return pulumi.get(self, "ca_pool")

    @ca_pool.setter
    def ca_pool(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_pool", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp when the resource was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Free-text description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="excludePublicCaSet")
    def exclude_public_ca_set(self) -> Optional[pulumi.Input[bool]]:
        """
        If FALSE (the default), use our default set of public CAs in addition to any CAs specified in trustConfig. These public CAs are currently based on the Mozilla Root Program and are subject to change over time. If TRUE, do not accept our default set of public CAs. Only CAs specified in trustConfig will be accepted.
        """
        return pulumi.get(self, "exclude_public_ca_set")

    @exclude_public_ca_set.setter
    def exclude_public_ca_set(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "exclude_public_ca_set", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location of the tls inspection policy.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Short name of the TlsInspectionPolicy resource to be created.


        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp when the resource was updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)


class TlsInspectionPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ca_pool: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 exclude_public_ca_set: Optional[pulumi.Input[bool]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage
        ### Network Security Tls Inspection Policy Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_ca_pool = gcp.certificateauthority.CaPool("defaultCaPool",
            location="us-central1",
            tier="DEVOPS",
            publishing_options=gcp.certificateauthority.CaPoolPublishingOptionsArgs(
                publish_ca_cert=False,
                publish_crl=False,
            ),
            issuance_policy=gcp.certificateauthority.CaPoolIssuancePolicyArgs(
                maximum_lifetime="1209600s",
                baseline_values=gcp.certificateauthority.CaPoolIssuancePolicyBaselineValuesArgs(
                    ca_options=gcp.certificateauthority.CaPoolIssuancePolicyBaselineValuesCaOptionsArgs(
                        is_ca=False,
                    ),
                    key_usage=gcp.certificateauthority.CaPoolIssuancePolicyBaselineValuesKeyUsageArgs(
                        base_key_usage=gcp.certificateauthority.CaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsageArgs(),
                        extended_key_usage=gcp.certificateauthority.CaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsageArgs(
                            server_auth=True,
                        ),
                    ),
                ),
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_authority = gcp.certificateauthority.Authority("defaultAuthority",
            pool=default_ca_pool.name,
            certificate_authority_id="my-basic-certificate-authority",
            location="us-central1",
            lifetime="86400s",
            type="SELF_SIGNED",
            deletion_protection=False,
            skip_grace_period=True,
            ignore_active_certificates_on_deletion=True,
            config=gcp.certificateauthority.AuthorityConfigArgs(
                subject_config=gcp.certificateauthority.AuthorityConfigSubjectConfigArgs(
                    subject=gcp.certificateauthority.AuthorityConfigSubjectConfigSubjectArgs(
                        organization="Test LLC",
                        common_name="my-ca",
                    ),
                ),
                x509_config=gcp.certificateauthority.AuthorityConfigX509ConfigArgs(
                    ca_options=gcp.certificateauthority.AuthorityConfigX509ConfigCaOptionsArgs(
                        is_ca=True,
                    ),
                    key_usage=gcp.certificateauthority.AuthorityConfigX509ConfigKeyUsageArgs(
                        base_key_usage=gcp.certificateauthority.AuthorityConfigX509ConfigKeyUsageBaseKeyUsageArgs(
                            cert_sign=True,
                            crl_sign=True,
                        ),
                        extended_key_usage=gcp.certificateauthority.AuthorityConfigX509ConfigKeyUsageExtendedKeyUsageArgs(
                            server_auth=False,
                        ),
                    ),
                ),
            ),
            key_spec=gcp.certificateauthority.AuthorityKeySpecArgs(
                algorithm="RSA_PKCS1_4096_SHA256",
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        ns_sa = gcp.projects.ServiceIdentity("nsSa", service="networksecurity.googleapis.com",
        opts=pulumi.ResourceOptions(provider=google_beta))
        tls_inspection_permission = gcp.certificateauthority.CaPoolIamMember("tlsInspectionPermission",
            ca_pool=default_ca_pool.id,
            role="roles/privateca.certificateManager",
            member=ns_sa.email.apply(lambda email: f"serviceAccount:{email}"),
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_tls_inspection_policy = gcp.networksecurity.TlsInspectionPolicy("defaultTlsInspectionPolicy",
            location="us-central1",
            ca_pool=default_ca_pool.id,
            exclude_public_ca_set=False,
            opts=pulumi.ResourceOptions(provider=google_beta,
                depends_on=[
                    default_ca_pool,
                    default_authority,
                    tls_inspection_permission,
                ]))
        ```

        ## Import

        TlsInspectionPolicy can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:networksecurity/tlsInspectionPolicy:TlsInspectionPolicy default projects/{{project}}/locations/{{location}}/tlsInspectionPolicies/{{name}}
        ```

        ```sh
         $ pulumi import gcp:networksecurity/tlsInspectionPolicy:TlsInspectionPolicy default {{project}}/{{location}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:networksecurity/tlsInspectionPolicy:TlsInspectionPolicy default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] ca_pool: A CA pool resource used to issue interception certificates.
        :param pulumi.Input[str] description: Free-text description of the resource.
        :param pulumi.Input[bool] exclude_public_ca_set: If FALSE (the default), use our default set of public CAs in addition to any CAs specified in trustConfig. These public CAs are currently based on the Mozilla Root Program and are subject to change over time. If TRUE, do not accept our default set of public CAs. Only CAs specified in trustConfig will be accepted.
        :param pulumi.Input[str] location: The location of the tls inspection policy.
        :param pulumi.Input[str] name: Short name of the TlsInspectionPolicy resource to be created.
               
               
               - - -
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TlsInspectionPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage
        ### Network Security Tls Inspection Policy Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_ca_pool = gcp.certificateauthority.CaPool("defaultCaPool",
            location="us-central1",
            tier="DEVOPS",
            publishing_options=gcp.certificateauthority.CaPoolPublishingOptionsArgs(
                publish_ca_cert=False,
                publish_crl=False,
            ),
            issuance_policy=gcp.certificateauthority.CaPoolIssuancePolicyArgs(
                maximum_lifetime="1209600s",
                baseline_values=gcp.certificateauthority.CaPoolIssuancePolicyBaselineValuesArgs(
                    ca_options=gcp.certificateauthority.CaPoolIssuancePolicyBaselineValuesCaOptionsArgs(
                        is_ca=False,
                    ),
                    key_usage=gcp.certificateauthority.CaPoolIssuancePolicyBaselineValuesKeyUsageArgs(
                        base_key_usage=gcp.certificateauthority.CaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsageArgs(),
                        extended_key_usage=gcp.certificateauthority.CaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsageArgs(
                            server_auth=True,
                        ),
                    ),
                ),
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_authority = gcp.certificateauthority.Authority("defaultAuthority",
            pool=default_ca_pool.name,
            certificate_authority_id="my-basic-certificate-authority",
            location="us-central1",
            lifetime="86400s",
            type="SELF_SIGNED",
            deletion_protection=False,
            skip_grace_period=True,
            ignore_active_certificates_on_deletion=True,
            config=gcp.certificateauthority.AuthorityConfigArgs(
                subject_config=gcp.certificateauthority.AuthorityConfigSubjectConfigArgs(
                    subject=gcp.certificateauthority.AuthorityConfigSubjectConfigSubjectArgs(
                        organization="Test LLC",
                        common_name="my-ca",
                    ),
                ),
                x509_config=gcp.certificateauthority.AuthorityConfigX509ConfigArgs(
                    ca_options=gcp.certificateauthority.AuthorityConfigX509ConfigCaOptionsArgs(
                        is_ca=True,
                    ),
                    key_usage=gcp.certificateauthority.AuthorityConfigX509ConfigKeyUsageArgs(
                        base_key_usage=gcp.certificateauthority.AuthorityConfigX509ConfigKeyUsageBaseKeyUsageArgs(
                            cert_sign=True,
                            crl_sign=True,
                        ),
                        extended_key_usage=gcp.certificateauthority.AuthorityConfigX509ConfigKeyUsageExtendedKeyUsageArgs(
                            server_auth=False,
                        ),
                    ),
                ),
            ),
            key_spec=gcp.certificateauthority.AuthorityKeySpecArgs(
                algorithm="RSA_PKCS1_4096_SHA256",
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        ns_sa = gcp.projects.ServiceIdentity("nsSa", service="networksecurity.googleapis.com",
        opts=pulumi.ResourceOptions(provider=google_beta))
        tls_inspection_permission = gcp.certificateauthority.CaPoolIamMember("tlsInspectionPermission",
            ca_pool=default_ca_pool.id,
            role="roles/privateca.certificateManager",
            member=ns_sa.email.apply(lambda email: f"serviceAccount:{email}"),
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_tls_inspection_policy = gcp.networksecurity.TlsInspectionPolicy("defaultTlsInspectionPolicy",
            location="us-central1",
            ca_pool=default_ca_pool.id,
            exclude_public_ca_set=False,
            opts=pulumi.ResourceOptions(provider=google_beta,
                depends_on=[
                    default_ca_pool,
                    default_authority,
                    tls_inspection_permission,
                ]))
        ```

        ## Import

        TlsInspectionPolicy can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:networksecurity/tlsInspectionPolicy:TlsInspectionPolicy default projects/{{project}}/locations/{{location}}/tlsInspectionPolicies/{{name}}
        ```

        ```sh
         $ pulumi import gcp:networksecurity/tlsInspectionPolicy:TlsInspectionPolicy default {{project}}/{{location}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:networksecurity/tlsInspectionPolicy:TlsInspectionPolicy default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param TlsInspectionPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TlsInspectionPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ca_pool: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 exclude_public_ca_set: Optional[pulumi.Input[bool]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TlsInspectionPolicyArgs.__new__(TlsInspectionPolicyArgs)

            if ca_pool is None and not opts.urn:
                raise TypeError("Missing required property 'ca_pool'")
            __props__.__dict__["ca_pool"] = ca_pool
            __props__.__dict__["description"] = description
            __props__.__dict__["exclude_public_ca_set"] = exclude_public_ca_set
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["update_time"] = None
        super(TlsInspectionPolicy, __self__).__init__(
            'gcp:networksecurity/tlsInspectionPolicy:TlsInspectionPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ca_pool: Optional[pulumi.Input[str]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            exclude_public_ca_set: Optional[pulumi.Input[bool]] = None,
            location: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            update_time: Optional[pulumi.Input[str]] = None) -> 'TlsInspectionPolicy':
        """
        Get an existing TlsInspectionPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] ca_pool: A CA pool resource used to issue interception certificates.
        :param pulumi.Input[str] create_time: The timestamp when the resource was created.
        :param pulumi.Input[str] description: Free-text description of the resource.
        :param pulumi.Input[bool] exclude_public_ca_set: If FALSE (the default), use our default set of public CAs in addition to any CAs specified in trustConfig. These public CAs are currently based on the Mozilla Root Program and are subject to change over time. If TRUE, do not accept our default set of public CAs. Only CAs specified in trustConfig will be accepted.
        :param pulumi.Input[str] location: The location of the tls inspection policy.
        :param pulumi.Input[str] name: Short name of the TlsInspectionPolicy resource to be created.
               
               
               - - -
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] update_time: The timestamp when the resource was updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TlsInspectionPolicyState.__new__(_TlsInspectionPolicyState)

        __props__.__dict__["ca_pool"] = ca_pool
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["exclude_public_ca_set"] = exclude_public_ca_set
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["update_time"] = update_time
        return TlsInspectionPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="caPool")
    def ca_pool(self) -> pulumi.Output[str]:
        """
        A CA pool resource used to issue interception certificates.
        """
        return pulumi.get(self, "ca_pool")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The timestamp when the resource was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Free-text description of the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="excludePublicCaSet")
    def exclude_public_ca_set(self) -> pulumi.Output[Optional[bool]]:
        """
        If FALSE (the default), use our default set of public CAs in addition to any CAs specified in trustConfig. These public CAs are currently based on the Mozilla Root Program and are subject to change over time. If TRUE, do not accept our default set of public CAs. Only CAs specified in trustConfig will be accepted.
        """
        return pulumi.get(self, "exclude_public_ca_set")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[str]]:
        """
        The location of the tls inspection policy.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Short name of the TlsInspectionPolicy resource to be created.


        - - -
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The timestamp when the resource was updated.
        """
        return pulumi.get(self, "update_time")

