# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GrpcRouteArgs', 'GrpcRoute']

@pulumi.input_type
class GrpcRouteArgs:
    def __init__(__self__, *,
                 hostnames: pulumi.Input[Sequence[pulumi.Input[str]]],
                 rules: pulumi.Input[Sequence[pulumi.Input['GrpcRouteRuleArgs']]],
                 description: Optional[pulumi.Input[str]] = None,
                 gateways: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 meshes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a GrpcRoute resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] hostnames: Required. Service hostnames with an optional port for which this route describes traffic.
        :param pulumi.Input[Sequence[pulumi.Input['GrpcRouteRuleArgs']]] rules: Rules that define how traffic is routed and handled.
               Structure is documented below.
        :param pulumi.Input[str] description: A free-text description of the resource. Max length 1024 characters.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] gateways: List of gateways this GrpcRoute is attached to, as one of the routing rules to route the requests served by the gateway.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Set of label tags associated with the GrpcRoute resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] meshes: List of meshes this GrpcRoute is attached to, as one of the routing rules to route the requests served by the mesh.
        :param pulumi.Input[str] name: Name of the GrpcRoute resource.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "hostnames", hostnames)
        pulumi.set(__self__, "rules", rules)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if gateways is not None:
            pulumi.set(__self__, "gateways", gateways)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if meshes is not None:
            pulumi.set(__self__, "meshes", meshes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def hostnames(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Required. Service hostnames with an optional port for which this route describes traffic.
        """
        return pulumi.get(self, "hostnames")

    @hostnames.setter
    def hostnames(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "hostnames", value)

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Input[Sequence[pulumi.Input['GrpcRouteRuleArgs']]]:
        """
        Rules that define how traffic is routed and handled.
        Structure is documented below.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: pulumi.Input[Sequence[pulumi.Input['GrpcRouteRuleArgs']]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A free-text description of the resource. Max length 1024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def gateways(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of gateways this GrpcRoute is attached to, as one of the routing rules to route the requests served by the gateway.
        """
        return pulumi.get(self, "gateways")

    @gateways.setter
    def gateways(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "gateways", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Set of label tags associated with the GrpcRoute resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def meshes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of meshes this GrpcRoute is attached to, as one of the routing rules to route the requests served by the mesh.
        """
        return pulumi.get(self, "meshes")

    @meshes.setter
    def meshes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "meshes", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the GrpcRoute resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _GrpcRouteState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 gateways: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 meshes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['GrpcRouteRuleArgs']]]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering GrpcRoute resources.
        :param pulumi.Input[str] create_time: Time the GrpcRoute was created in UTC.
        :param pulumi.Input[str] description: A free-text description of the resource. Max length 1024 characters.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] gateways: List of gateways this GrpcRoute is attached to, as one of the routing rules to route the requests served by the gateway.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] hostnames: Required. Service hostnames with an optional port for which this route describes traffic.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Set of label tags associated with the GrpcRoute resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] meshes: List of meshes this GrpcRoute is attached to, as one of the routing rules to route the requests served by the mesh.
        :param pulumi.Input[str] name: Name of the GrpcRoute resource.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input['GrpcRouteRuleArgs']]] rules: Rules that define how traffic is routed and handled.
               Structure is documented below.
        :param pulumi.Input[str] self_link: Server-defined URL of this resource.
        :param pulumi.Input[str] update_time: Time the GrpcRoute was updated in UTC.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if gateways is not None:
            pulumi.set(__self__, "gateways", gateways)
        if hostnames is not None:
            pulumi.set(__self__, "hostnames", hostnames)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if meshes is not None:
            pulumi.set(__self__, "meshes", meshes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time the GrpcRoute was created in UTC.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A free-text description of the resource. Max length 1024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def gateways(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of gateways this GrpcRoute is attached to, as one of the routing rules to route the requests served by the gateway.
        """
        return pulumi.get(self, "gateways")

    @gateways.setter
    def gateways(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "gateways", value)

    @property
    @pulumi.getter
    def hostnames(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Required. Service hostnames with an optional port for which this route describes traffic.
        """
        return pulumi.get(self, "hostnames")

    @hostnames.setter
    def hostnames(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "hostnames", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Set of label tags associated with the GrpcRoute resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def meshes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of meshes this GrpcRoute is attached to, as one of the routing rules to route the requests served by the mesh.
        """
        return pulumi.get(self, "meshes")

    @meshes.setter
    def meshes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "meshes", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the GrpcRoute resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GrpcRouteRuleArgs']]]]:
        """
        Rules that define how traffic is routed and handled.
        Structure is documented below.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GrpcRouteRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[str]]:
        """
        Server-defined URL of this resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time the GrpcRoute was updated in UTC.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)


class GrpcRoute(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 gateways: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 meshes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GrpcRouteRuleArgs']]]]] = None,
                 __props__=None):
        """
        ## Example Usage
        ### Network Services Grpc Route Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networkservices.GrpcRoute("default",
            labels={
                "foo": "bar",
            },
            description="my description",
            hostnames=["example"],
            rules=[gcp.networkservices.GrpcRouteRuleArgs(
                matches=[gcp.networkservices.GrpcRouteRuleMatchArgs(
                    headers=[gcp.networkservices.GrpcRouteRuleMatchHeaderArgs(
                        key="key",
                        value="value",
                    )],
                )],
                action=gcp.networkservices.GrpcRouteRuleActionArgs(
                    retry_policy=gcp.networkservices.GrpcRouteRuleActionRetryPolicyArgs(
                        retry_conditions=["cancelled"],
                        num_retries=1,
                    ),
                ),
            )],
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Network Services Grpc Route Matches And Actions

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networkservices.GrpcRoute("default",
            labels={
                "foo": "bar",
            },
            description="my description",
            hostnames=["example"],
            rules=[gcp.networkservices.GrpcRouteRuleArgs(
                matches=[
                    gcp.networkservices.GrpcRouteRuleMatchArgs(
                        headers=[gcp.networkservices.GrpcRouteRuleMatchHeaderArgs(
                            key="key",
                            value="value",
                        )],
                    ),
                    gcp.networkservices.GrpcRouteRuleMatchArgs(
                        headers=[gcp.networkservices.GrpcRouteRuleMatchHeaderArgs(
                            key="key",
                            value="value",
                        )],
                        method=gcp.networkservices.GrpcRouteRuleMatchMethodArgs(
                            grpc_service="foo",
                            grpc_method="bar",
                            case_sensitive=True,
                        ),
                    ),
                ],
                action=gcp.networkservices.GrpcRouteRuleActionArgs(
                    fault_injection_policy=gcp.networkservices.GrpcRouteRuleActionFaultInjectionPolicyArgs(
                        delay=gcp.networkservices.GrpcRouteRuleActionFaultInjectionPolicyDelayArgs(
                            fixed_delay="1s",
                            percentage=1,
                        ),
                        abort=gcp.networkservices.GrpcRouteRuleActionFaultInjectionPolicyAbortArgs(
                            http_status=500,
                            percentage=1,
                        ),
                    ),
                    retry_policy=gcp.networkservices.GrpcRouteRuleActionRetryPolicyArgs(
                        retry_conditions=["cancelled"],
                        num_retries=1,
                    ),
                ),
            )],
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Network Services Grpc Route Actions

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networkservices.GrpcRoute("default",
            labels={
                "foo": "bar",
            },
            description="my description",
            hostnames=["example"],
            rules=[gcp.networkservices.GrpcRouteRuleArgs(
                action=gcp.networkservices.GrpcRouteRuleActionArgs(
                    fault_injection_policy=gcp.networkservices.GrpcRouteRuleActionFaultInjectionPolicyArgs(
                        delay=gcp.networkservices.GrpcRouteRuleActionFaultInjectionPolicyDelayArgs(
                            fixed_delay="1s",
                            percentage=1,
                        ),
                        abort=gcp.networkservices.GrpcRouteRuleActionFaultInjectionPolicyAbortArgs(
                            http_status=500,
                            percentage=1,
                        ),
                    ),
                    retry_policy=gcp.networkservices.GrpcRouteRuleActionRetryPolicyArgs(
                        retry_conditions=["cancelled"],
                        num_retries=1,
                    ),
                ),
            )],
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```

        ## Import

        GrpcRoute can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:networkservices/grpcRoute:GrpcRoute default projects/{{project}}/locations/global/grpcRoutes/{{name}}
        ```

        ```sh
         $ pulumi import gcp:networkservices/grpcRoute:GrpcRoute default {{project}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:networkservices/grpcRoute:GrpcRoute default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A free-text description of the resource. Max length 1024 characters.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] gateways: List of gateways this GrpcRoute is attached to, as one of the routing rules to route the requests served by the gateway.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] hostnames: Required. Service hostnames with an optional port for which this route describes traffic.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Set of label tags associated with the GrpcRoute resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] meshes: List of meshes this GrpcRoute is attached to, as one of the routing rules to route the requests served by the mesh.
        :param pulumi.Input[str] name: Name of the GrpcRoute resource.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GrpcRouteRuleArgs']]]] rules: Rules that define how traffic is routed and handled.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GrpcRouteArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage
        ### Network Services Grpc Route Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networkservices.GrpcRoute("default",
            labels={
                "foo": "bar",
            },
            description="my description",
            hostnames=["example"],
            rules=[gcp.networkservices.GrpcRouteRuleArgs(
                matches=[gcp.networkservices.GrpcRouteRuleMatchArgs(
                    headers=[gcp.networkservices.GrpcRouteRuleMatchHeaderArgs(
                        key="key",
                        value="value",
                    )],
                )],
                action=gcp.networkservices.GrpcRouteRuleActionArgs(
                    retry_policy=gcp.networkservices.GrpcRouteRuleActionRetryPolicyArgs(
                        retry_conditions=["cancelled"],
                        num_retries=1,
                    ),
                ),
            )],
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Network Services Grpc Route Matches And Actions

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networkservices.GrpcRoute("default",
            labels={
                "foo": "bar",
            },
            description="my description",
            hostnames=["example"],
            rules=[gcp.networkservices.GrpcRouteRuleArgs(
                matches=[
                    gcp.networkservices.GrpcRouteRuleMatchArgs(
                        headers=[gcp.networkservices.GrpcRouteRuleMatchHeaderArgs(
                            key="key",
                            value="value",
                        )],
                    ),
                    gcp.networkservices.GrpcRouteRuleMatchArgs(
                        headers=[gcp.networkservices.GrpcRouteRuleMatchHeaderArgs(
                            key="key",
                            value="value",
                        )],
                        method=gcp.networkservices.GrpcRouteRuleMatchMethodArgs(
                            grpc_service="foo",
                            grpc_method="bar",
                            case_sensitive=True,
                        ),
                    ),
                ],
                action=gcp.networkservices.GrpcRouteRuleActionArgs(
                    fault_injection_policy=gcp.networkservices.GrpcRouteRuleActionFaultInjectionPolicyArgs(
                        delay=gcp.networkservices.GrpcRouteRuleActionFaultInjectionPolicyDelayArgs(
                            fixed_delay="1s",
                            percentage=1,
                        ),
                        abort=gcp.networkservices.GrpcRouteRuleActionFaultInjectionPolicyAbortArgs(
                            http_status=500,
                            percentage=1,
                        ),
                    ),
                    retry_policy=gcp.networkservices.GrpcRouteRuleActionRetryPolicyArgs(
                        retry_conditions=["cancelled"],
                        num_retries=1,
                    ),
                ),
            )],
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Network Services Grpc Route Actions

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networkservices.GrpcRoute("default",
            labels={
                "foo": "bar",
            },
            description="my description",
            hostnames=["example"],
            rules=[gcp.networkservices.GrpcRouteRuleArgs(
                action=gcp.networkservices.GrpcRouteRuleActionArgs(
                    fault_injection_policy=gcp.networkservices.GrpcRouteRuleActionFaultInjectionPolicyArgs(
                        delay=gcp.networkservices.GrpcRouteRuleActionFaultInjectionPolicyDelayArgs(
                            fixed_delay="1s",
                            percentage=1,
                        ),
                        abort=gcp.networkservices.GrpcRouteRuleActionFaultInjectionPolicyAbortArgs(
                            http_status=500,
                            percentage=1,
                        ),
                    ),
                    retry_policy=gcp.networkservices.GrpcRouteRuleActionRetryPolicyArgs(
                        retry_conditions=["cancelled"],
                        num_retries=1,
                    ),
                ),
            )],
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```

        ## Import

        GrpcRoute can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:networkservices/grpcRoute:GrpcRoute default projects/{{project}}/locations/global/grpcRoutes/{{name}}
        ```

        ```sh
         $ pulumi import gcp:networkservices/grpcRoute:GrpcRoute default {{project}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:networkservices/grpcRoute:GrpcRoute default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param GrpcRouteArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GrpcRouteArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 gateways: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 meshes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GrpcRouteRuleArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GrpcRouteArgs.__new__(GrpcRouteArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["gateways"] = gateways
            if hostnames is None and not opts.urn:
                raise TypeError("Missing required property 'hostnames'")
            __props__.__dict__["hostnames"] = hostnames
            __props__.__dict__["labels"] = labels
            __props__.__dict__["meshes"] = meshes
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            if rules is None and not opts.urn:
                raise TypeError("Missing required property 'rules'")
            __props__.__dict__["rules"] = rules
            __props__.__dict__["create_time"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["update_time"] = None
        super(GrpcRoute, __self__).__init__(
            'gcp:networkservices/grpcRoute:GrpcRoute',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            gateways: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            meshes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GrpcRouteRuleArgs']]]]] = None,
            self_link: Optional[pulumi.Input[str]] = None,
            update_time: Optional[pulumi.Input[str]] = None) -> 'GrpcRoute':
        """
        Get an existing GrpcRoute resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] create_time: Time the GrpcRoute was created in UTC.
        :param pulumi.Input[str] description: A free-text description of the resource. Max length 1024 characters.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] gateways: List of gateways this GrpcRoute is attached to, as one of the routing rules to route the requests served by the gateway.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] hostnames: Required. Service hostnames with an optional port for which this route describes traffic.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Set of label tags associated with the GrpcRoute resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] meshes: List of meshes this GrpcRoute is attached to, as one of the routing rules to route the requests served by the mesh.
        :param pulumi.Input[str] name: Name of the GrpcRoute resource.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GrpcRouteRuleArgs']]]] rules: Rules that define how traffic is routed and handled.
               Structure is documented below.
        :param pulumi.Input[str] self_link: Server-defined URL of this resource.
        :param pulumi.Input[str] update_time: Time the GrpcRoute was updated in UTC.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GrpcRouteState.__new__(_GrpcRouteState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["gateways"] = gateways
        __props__.__dict__["hostnames"] = hostnames
        __props__.__dict__["labels"] = labels
        __props__.__dict__["meshes"] = meshes
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["rules"] = rules
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["update_time"] = update_time
        return GrpcRoute(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Time the GrpcRoute was created in UTC.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A free-text description of the resource. Max length 1024 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def gateways(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of gateways this GrpcRoute is attached to, as one of the routing rules to route the requests served by the gateway.
        """
        return pulumi.get(self, "gateways")

    @property
    @pulumi.getter
    def hostnames(self) -> pulumi.Output[Sequence[str]]:
        """
        Required. Service hostnames with an optional port for which this route describes traffic.
        """
        return pulumi.get(self, "hostnames")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Set of label tags associated with the GrpcRoute resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def meshes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of meshes this GrpcRoute is attached to, as one of the routing rules to route the requests served by the mesh.
        """
        return pulumi.get(self, "meshes")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the GrpcRoute resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Sequence['outputs.GrpcRouteRule']]:
        """
        Rules that define how traffic is routed and handled.
        Structure is documented below.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        """
        Server-defined URL of this resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        Time the GrpcRoute was updated in UTC.
        """
        return pulumi.get(self, "update_time")

