# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['HttpRouteArgs', 'HttpRoute']

@pulumi.input_type
class HttpRouteArgs:
    def __init__(__self__, *,
                 hostnames: pulumi.Input[Sequence[pulumi.Input[str]]],
                 rules: pulumi.Input[Sequence[pulumi.Input['HttpRouteRuleArgs']]],
                 description: Optional[pulumi.Input[str]] = None,
                 gateways: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 meshes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a HttpRoute resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] hostnames: Set of hosts that should match against the HTTP host header to select a HttpRoute to process the request.
        :param pulumi.Input[Sequence[pulumi.Input['HttpRouteRuleArgs']]] rules: Rules that define how traffic is routed and handled.
               Structure is documented below.
        :param pulumi.Input[str] description: A free-text description of the resource. Max length 1024 characters.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] gateways: Gateways defines a list of gateways this HttpRoute is attached to, as one of the routing rules to route the requests served by the gateway.
               Each gateway reference should match the pattern: projects/*/locations/global/gateways/<gateway_name>
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Set of label tags associated with the HttpRoute resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] meshes: Meshes defines a list of meshes this HttpRoute is attached to, as one of the routing rules to route the requests served by the mesh.
               Each mesh reference should match the pattern: projects/*/locations/global/meshes/<mesh_name>.
               The attached Mesh should be of a type SIDECAR.
        :param pulumi.Input[str] name: Name of the HttpRoute resource.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "hostnames", hostnames)
        pulumi.set(__self__, "rules", rules)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if gateways is not None:
            pulumi.set(__self__, "gateways", gateways)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if meshes is not None:
            pulumi.set(__self__, "meshes", meshes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def hostnames(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Set of hosts that should match against the HTTP host header to select a HttpRoute to process the request.
        """
        return pulumi.get(self, "hostnames")

    @hostnames.setter
    def hostnames(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "hostnames", value)

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Input[Sequence[pulumi.Input['HttpRouteRuleArgs']]]:
        """
        Rules that define how traffic is routed and handled.
        Structure is documented below.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: pulumi.Input[Sequence[pulumi.Input['HttpRouteRuleArgs']]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A free-text description of the resource. Max length 1024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def gateways(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Gateways defines a list of gateways this HttpRoute is attached to, as one of the routing rules to route the requests served by the gateway.
        Each gateway reference should match the pattern: projects/*/locations/global/gateways/<gateway_name>
        """
        return pulumi.get(self, "gateways")

    @gateways.setter
    def gateways(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "gateways", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Set of label tags associated with the HttpRoute resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def meshes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Meshes defines a list of meshes this HttpRoute is attached to, as one of the routing rules to route the requests served by the mesh.
        Each mesh reference should match the pattern: projects/*/locations/global/meshes/<mesh_name>.
        The attached Mesh should be of a type SIDECAR.
        """
        return pulumi.get(self, "meshes")

    @meshes.setter
    def meshes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "meshes", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the HttpRoute resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _HttpRouteState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 gateways: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 meshes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['HttpRouteRuleArgs']]]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering HttpRoute resources.
        :param pulumi.Input[str] create_time: Time the HttpRoute was created in UTC.
        :param pulumi.Input[str] description: A free-text description of the resource. Max length 1024 characters.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] gateways: Gateways defines a list of gateways this HttpRoute is attached to, as one of the routing rules to route the requests served by the gateway.
               Each gateway reference should match the pattern: projects/*/locations/global/gateways/<gateway_name>
        :param pulumi.Input[Sequence[pulumi.Input[str]]] hostnames: Set of hosts that should match against the HTTP host header to select a HttpRoute to process the request.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Set of label tags associated with the HttpRoute resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] meshes: Meshes defines a list of meshes this HttpRoute is attached to, as one of the routing rules to route the requests served by the mesh.
               Each mesh reference should match the pattern: projects/*/locations/global/meshes/<mesh_name>.
               The attached Mesh should be of a type SIDECAR.
        :param pulumi.Input[str] name: Name of the HttpRoute resource.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input['HttpRouteRuleArgs']]] rules: Rules that define how traffic is routed and handled.
               Structure is documented below.
        :param pulumi.Input[str] self_link: Server-defined URL of this resource.
        :param pulumi.Input[str] update_time: Time the HttpRoute was updated in UTC.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if gateways is not None:
            pulumi.set(__self__, "gateways", gateways)
        if hostnames is not None:
            pulumi.set(__self__, "hostnames", hostnames)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if meshes is not None:
            pulumi.set(__self__, "meshes", meshes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time the HttpRoute was created in UTC.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A free-text description of the resource. Max length 1024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def gateways(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Gateways defines a list of gateways this HttpRoute is attached to, as one of the routing rules to route the requests served by the gateway.
        Each gateway reference should match the pattern: projects/*/locations/global/gateways/<gateway_name>
        """
        return pulumi.get(self, "gateways")

    @gateways.setter
    def gateways(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "gateways", value)

    @property
    @pulumi.getter
    def hostnames(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set of hosts that should match against the HTTP host header to select a HttpRoute to process the request.
        """
        return pulumi.get(self, "hostnames")

    @hostnames.setter
    def hostnames(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "hostnames", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Set of label tags associated with the HttpRoute resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def meshes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Meshes defines a list of meshes this HttpRoute is attached to, as one of the routing rules to route the requests served by the mesh.
        Each mesh reference should match the pattern: projects/*/locations/global/meshes/<mesh_name>.
        The attached Mesh should be of a type SIDECAR.
        """
        return pulumi.get(self, "meshes")

    @meshes.setter
    def meshes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "meshes", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the HttpRoute resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HttpRouteRuleArgs']]]]:
        """
        Rules that define how traffic is routed and handled.
        Structure is documented below.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HttpRouteRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[str]]:
        """
        Server-defined URL of this resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time the HttpRoute was updated in UTC.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)


class HttpRoute(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 gateways: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 meshes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['HttpRouteRuleArgs']]]]] = None,
                 __props__=None):
        """
        ## Example Usage
        ### Network Services Http Route Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networkservices.HttpRoute("default",
            labels={
                "foo": "bar",
            },
            description="my description",
            hostnames=["example"],
            rules=[gcp.networkservices.HttpRouteRuleArgs(
                matches=[gcp.networkservices.HttpRouteRuleMatchArgs(
                    query_parameters=[gcp.networkservices.HttpRouteRuleMatchQueryParameterArgs(
                        query_parameter="key",
                        exact_match="value",
                    )],
                    full_path_match="example",
                )],
            )],
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Network Services Http Route Matches And Actions

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networkservices.HttpRoute("default",
            labels={
                "foo": "bar",
            },
            description="my description",
            hostnames=["example"],
            rules=[gcp.networkservices.HttpRouteRuleArgs(
                matches=[
                    gcp.networkservices.HttpRouteRuleMatchArgs(
                        headers=[gcp.networkservices.HttpRouteRuleMatchHeaderArgs(
                            header="header",
                            invert_match=False,
                            regex_match="header-value",
                        )],
                        query_parameters=[gcp.networkservices.HttpRouteRuleMatchQueryParameterArgs(
                            query_parameter="key",
                            exact_match="value",
                        )],
                        prefix_match="example",
                        ignore_case=False,
                    ),
                    gcp.networkservices.HttpRouteRuleMatchArgs(
                        headers=[gcp.networkservices.HttpRouteRuleMatchHeaderArgs(
                            header="header",
                            invert_match=False,
                            present_match=True,
                        )],
                        query_parameters=[gcp.networkservices.HttpRouteRuleMatchQueryParameterArgs(
                            query_parameter="key",
                            regex_match="value",
                        )],
                        regex_match="example",
                        ignore_case=False,
                    ),
                    gcp.networkservices.HttpRouteRuleMatchArgs(
                        headers=[gcp.networkservices.HttpRouteRuleMatchHeaderArgs(
                            header="header",
                            invert_match=False,
                            present_match=True,
                        )],
                        query_parameters=[gcp.networkservices.HttpRouteRuleMatchQueryParameterArgs(
                            query_parameter="key",
                            present_match=True,
                        )],
                        full_path_match="example",
                        ignore_case=False,
                    ),
                ],
                action=gcp.networkservices.HttpRouteRuleActionArgs(
                    redirect=gcp.networkservices.HttpRouteRuleActionRedirectArgs(
                        host_redirect="new-host",
                        path_redirect="new-path",
                        prefix_rewrite="new-prefix",
                        https_redirect=True,
                        strip_query=True,
                        port_redirect=8081,
                    ),
                    url_rewrite=gcp.networkservices.HttpRouteRuleActionUrlRewriteArgs(
                        path_prefix_rewrite="new-prefix",
                        host_rewrite="new-host",
                    ),
                    retry_policy=gcp.networkservices.HttpRouteRuleActionRetryPolicyArgs(
                        retry_conditions=["server_error"],
                        num_retries=1,
                        per_try_timeout="1s",
                    ),
                    request_mirror_policy=gcp.networkservices.HttpRouteRuleActionRequestMirrorPolicyArgs(
                        destination=gcp.networkservices.HttpRouteRuleActionRequestMirrorPolicyDestinationArgs(
                            service_name="new",
                            weight=1,
                        ),
                    ),
                    cors_policy=gcp.networkservices.HttpRouteRuleActionCorsPolicyArgs(
                        allow_origins=["example"],
                        allow_methods=[
                            "GET",
                            "PUT",
                        ],
                        allow_headers=[
                            "version",
                            "type",
                        ],
                        expose_headers=[
                            "version",
                            "type",
                        ],
                        max_age="1s",
                        allow_credentials=True,
                        disabled=False,
                    ),
                ),
            )],
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Network Services Http Route Actions

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networkservices.HttpRoute("default",
            labels={
                "foo": "bar",
            },
            description="my description",
            hostnames=["example"],
            rules=[gcp.networkservices.HttpRouteRuleArgs(
                action=gcp.networkservices.HttpRouteRuleActionArgs(
                    fault_injection_policy=gcp.networkservices.HttpRouteRuleActionFaultInjectionPolicyArgs(
                        delay=gcp.networkservices.HttpRouteRuleActionFaultInjectionPolicyDelayArgs(
                            fixed_delay="1s",
                            percentage=1,
                        ),
                        abort=gcp.networkservices.HttpRouteRuleActionFaultInjectionPolicyAbortArgs(
                            http_status=500,
                            percentage=1,
                        ),
                    ),
                    url_rewrite=gcp.networkservices.HttpRouteRuleActionUrlRewriteArgs(
                        path_prefix_rewrite="new-prefix",
                        host_rewrite="new-host",
                    ),
                    retry_policy=gcp.networkservices.HttpRouteRuleActionRetryPolicyArgs(
                        retry_conditions=["server_error"],
                        num_retries=1,
                        per_try_timeout="1s",
                    ),
                    request_mirror_policy=gcp.networkservices.HttpRouteRuleActionRequestMirrorPolicyArgs(
                        destination=gcp.networkservices.HttpRouteRuleActionRequestMirrorPolicyDestinationArgs(
                            service_name="new",
                            weight=1,
                        ),
                    ),
                    cors_policy=gcp.networkservices.HttpRouteRuleActionCorsPolicyArgs(
                        allow_origins=["example"],
                        allow_methods=[
                            "GET",
                            "PUT",
                        ],
                        allow_headers=[
                            "version",
                            "type",
                        ],
                        expose_headers=[
                            "version",
                            "type",
                        ],
                        max_age="1s",
                        allow_credentials=True,
                        disabled=False,
                    ),
                    request_header_modifier=gcp.networkservices.HttpRouteRuleActionRequestHeaderModifierArgs(
                        set={
                            "version": "1",
                            "type": "json",
                        },
                        add={
                            "minor-version": "1",
                        },
                        removes=["arg"],
                    ),
                    response_header_modifier=gcp.networkservices.HttpRouteRuleActionResponseHeaderModifierArgs(
                        set={
                            "version": "1",
                            "type": "json",
                        },
                        add={
                            "minor-version": "1",
                        },
                        removes=["removearg"],
                    ),
                ),
            )],
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Network Services Http Route Mesh Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_mesh = gcp.networkservices.Mesh("defaultMesh",
            labels={
                "foo": "bar",
            },
            description="my description",
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_http_route = gcp.networkservices.HttpRoute("defaultHttpRoute",
            labels={
                "foo": "bar",
            },
            description="my description",
            hostnames=["example"],
            meshes=[default_mesh.id],
            rules=[gcp.networkservices.HttpRouteRuleArgs(
                matches=[gcp.networkservices.HttpRouteRuleMatchArgs(
                    query_parameters=[gcp.networkservices.HttpRouteRuleMatchQueryParameterArgs(
                        query_parameter="key",
                        exact_match="value",
                    )],
                    full_path_match="example",
                )],
            )],
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```

        ## Import

        HttpRoute can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:networkservices/httpRoute:HttpRoute default projects/{{project}}/locations/global/httpRoutes/{{name}}
        ```

        ```sh
         $ pulumi import gcp:networkservices/httpRoute:HttpRoute default {{project}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:networkservices/httpRoute:HttpRoute default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A free-text description of the resource. Max length 1024 characters.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] gateways: Gateways defines a list of gateways this HttpRoute is attached to, as one of the routing rules to route the requests served by the gateway.
               Each gateway reference should match the pattern: projects/*/locations/global/gateways/<gateway_name>
        :param pulumi.Input[Sequence[pulumi.Input[str]]] hostnames: Set of hosts that should match against the HTTP host header to select a HttpRoute to process the request.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Set of label tags associated with the HttpRoute resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] meshes: Meshes defines a list of meshes this HttpRoute is attached to, as one of the routing rules to route the requests served by the mesh.
               Each mesh reference should match the pattern: projects/*/locations/global/meshes/<mesh_name>.
               The attached Mesh should be of a type SIDECAR.
        :param pulumi.Input[str] name: Name of the HttpRoute resource.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['HttpRouteRuleArgs']]]] rules: Rules that define how traffic is routed and handled.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HttpRouteArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage
        ### Network Services Http Route Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networkservices.HttpRoute("default",
            labels={
                "foo": "bar",
            },
            description="my description",
            hostnames=["example"],
            rules=[gcp.networkservices.HttpRouteRuleArgs(
                matches=[gcp.networkservices.HttpRouteRuleMatchArgs(
                    query_parameters=[gcp.networkservices.HttpRouteRuleMatchQueryParameterArgs(
                        query_parameter="key",
                        exact_match="value",
                    )],
                    full_path_match="example",
                )],
            )],
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Network Services Http Route Matches And Actions

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networkservices.HttpRoute("default",
            labels={
                "foo": "bar",
            },
            description="my description",
            hostnames=["example"],
            rules=[gcp.networkservices.HttpRouteRuleArgs(
                matches=[
                    gcp.networkservices.HttpRouteRuleMatchArgs(
                        headers=[gcp.networkservices.HttpRouteRuleMatchHeaderArgs(
                            header="header",
                            invert_match=False,
                            regex_match="header-value",
                        )],
                        query_parameters=[gcp.networkservices.HttpRouteRuleMatchQueryParameterArgs(
                            query_parameter="key",
                            exact_match="value",
                        )],
                        prefix_match="example",
                        ignore_case=False,
                    ),
                    gcp.networkservices.HttpRouteRuleMatchArgs(
                        headers=[gcp.networkservices.HttpRouteRuleMatchHeaderArgs(
                            header="header",
                            invert_match=False,
                            present_match=True,
                        )],
                        query_parameters=[gcp.networkservices.HttpRouteRuleMatchQueryParameterArgs(
                            query_parameter="key",
                            regex_match="value",
                        )],
                        regex_match="example",
                        ignore_case=False,
                    ),
                    gcp.networkservices.HttpRouteRuleMatchArgs(
                        headers=[gcp.networkservices.HttpRouteRuleMatchHeaderArgs(
                            header="header",
                            invert_match=False,
                            present_match=True,
                        )],
                        query_parameters=[gcp.networkservices.HttpRouteRuleMatchQueryParameterArgs(
                            query_parameter="key",
                            present_match=True,
                        )],
                        full_path_match="example",
                        ignore_case=False,
                    ),
                ],
                action=gcp.networkservices.HttpRouteRuleActionArgs(
                    redirect=gcp.networkservices.HttpRouteRuleActionRedirectArgs(
                        host_redirect="new-host",
                        path_redirect="new-path",
                        prefix_rewrite="new-prefix",
                        https_redirect=True,
                        strip_query=True,
                        port_redirect=8081,
                    ),
                    url_rewrite=gcp.networkservices.HttpRouteRuleActionUrlRewriteArgs(
                        path_prefix_rewrite="new-prefix",
                        host_rewrite="new-host",
                    ),
                    retry_policy=gcp.networkservices.HttpRouteRuleActionRetryPolicyArgs(
                        retry_conditions=["server_error"],
                        num_retries=1,
                        per_try_timeout="1s",
                    ),
                    request_mirror_policy=gcp.networkservices.HttpRouteRuleActionRequestMirrorPolicyArgs(
                        destination=gcp.networkservices.HttpRouteRuleActionRequestMirrorPolicyDestinationArgs(
                            service_name="new",
                            weight=1,
                        ),
                    ),
                    cors_policy=gcp.networkservices.HttpRouteRuleActionCorsPolicyArgs(
                        allow_origins=["example"],
                        allow_methods=[
                            "GET",
                            "PUT",
                        ],
                        allow_headers=[
                            "version",
                            "type",
                        ],
                        expose_headers=[
                            "version",
                            "type",
                        ],
                        max_age="1s",
                        allow_credentials=True,
                        disabled=False,
                    ),
                ),
            )],
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Network Services Http Route Actions

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networkservices.HttpRoute("default",
            labels={
                "foo": "bar",
            },
            description="my description",
            hostnames=["example"],
            rules=[gcp.networkservices.HttpRouteRuleArgs(
                action=gcp.networkservices.HttpRouteRuleActionArgs(
                    fault_injection_policy=gcp.networkservices.HttpRouteRuleActionFaultInjectionPolicyArgs(
                        delay=gcp.networkservices.HttpRouteRuleActionFaultInjectionPolicyDelayArgs(
                            fixed_delay="1s",
                            percentage=1,
                        ),
                        abort=gcp.networkservices.HttpRouteRuleActionFaultInjectionPolicyAbortArgs(
                            http_status=500,
                            percentage=1,
                        ),
                    ),
                    url_rewrite=gcp.networkservices.HttpRouteRuleActionUrlRewriteArgs(
                        path_prefix_rewrite="new-prefix",
                        host_rewrite="new-host",
                    ),
                    retry_policy=gcp.networkservices.HttpRouteRuleActionRetryPolicyArgs(
                        retry_conditions=["server_error"],
                        num_retries=1,
                        per_try_timeout="1s",
                    ),
                    request_mirror_policy=gcp.networkservices.HttpRouteRuleActionRequestMirrorPolicyArgs(
                        destination=gcp.networkservices.HttpRouteRuleActionRequestMirrorPolicyDestinationArgs(
                            service_name="new",
                            weight=1,
                        ),
                    ),
                    cors_policy=gcp.networkservices.HttpRouteRuleActionCorsPolicyArgs(
                        allow_origins=["example"],
                        allow_methods=[
                            "GET",
                            "PUT",
                        ],
                        allow_headers=[
                            "version",
                            "type",
                        ],
                        expose_headers=[
                            "version",
                            "type",
                        ],
                        max_age="1s",
                        allow_credentials=True,
                        disabled=False,
                    ),
                    request_header_modifier=gcp.networkservices.HttpRouteRuleActionRequestHeaderModifierArgs(
                        set={
                            "version": "1",
                            "type": "json",
                        },
                        add={
                            "minor-version": "1",
                        },
                        removes=["arg"],
                    ),
                    response_header_modifier=gcp.networkservices.HttpRouteRuleActionResponseHeaderModifierArgs(
                        set={
                            "version": "1",
                            "type": "json",
                        },
                        add={
                            "minor-version": "1",
                        },
                        removes=["removearg"],
                    ),
                ),
            )],
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Network Services Http Route Mesh Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_mesh = gcp.networkservices.Mesh("defaultMesh",
            labels={
                "foo": "bar",
            },
            description="my description",
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_http_route = gcp.networkservices.HttpRoute("defaultHttpRoute",
            labels={
                "foo": "bar",
            },
            description="my description",
            hostnames=["example"],
            meshes=[default_mesh.id],
            rules=[gcp.networkservices.HttpRouteRuleArgs(
                matches=[gcp.networkservices.HttpRouteRuleMatchArgs(
                    query_parameters=[gcp.networkservices.HttpRouteRuleMatchQueryParameterArgs(
                        query_parameter="key",
                        exact_match="value",
                    )],
                    full_path_match="example",
                )],
            )],
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```

        ## Import

        HttpRoute can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:networkservices/httpRoute:HttpRoute default projects/{{project}}/locations/global/httpRoutes/{{name}}
        ```

        ```sh
         $ pulumi import gcp:networkservices/httpRoute:HttpRoute default {{project}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:networkservices/httpRoute:HttpRoute default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param HttpRouteArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HttpRouteArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 gateways: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 meshes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['HttpRouteRuleArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HttpRouteArgs.__new__(HttpRouteArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["gateways"] = gateways
            if hostnames is None and not opts.urn:
                raise TypeError("Missing required property 'hostnames'")
            __props__.__dict__["hostnames"] = hostnames
            __props__.__dict__["labels"] = labels
            __props__.__dict__["meshes"] = meshes
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            if rules is None and not opts.urn:
                raise TypeError("Missing required property 'rules'")
            __props__.__dict__["rules"] = rules
            __props__.__dict__["create_time"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["update_time"] = None
        super(HttpRoute, __self__).__init__(
            'gcp:networkservices/httpRoute:HttpRoute',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            gateways: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            meshes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['HttpRouteRuleArgs']]]]] = None,
            self_link: Optional[pulumi.Input[str]] = None,
            update_time: Optional[pulumi.Input[str]] = None) -> 'HttpRoute':
        """
        Get an existing HttpRoute resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] create_time: Time the HttpRoute was created in UTC.
        :param pulumi.Input[str] description: A free-text description of the resource. Max length 1024 characters.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] gateways: Gateways defines a list of gateways this HttpRoute is attached to, as one of the routing rules to route the requests served by the gateway.
               Each gateway reference should match the pattern: projects/*/locations/global/gateways/<gateway_name>
        :param pulumi.Input[Sequence[pulumi.Input[str]]] hostnames: Set of hosts that should match against the HTTP host header to select a HttpRoute to process the request.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Set of label tags associated with the HttpRoute resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] meshes: Meshes defines a list of meshes this HttpRoute is attached to, as one of the routing rules to route the requests served by the mesh.
               Each mesh reference should match the pattern: projects/*/locations/global/meshes/<mesh_name>.
               The attached Mesh should be of a type SIDECAR.
        :param pulumi.Input[str] name: Name of the HttpRoute resource.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['HttpRouteRuleArgs']]]] rules: Rules that define how traffic is routed and handled.
               Structure is documented below.
        :param pulumi.Input[str] self_link: Server-defined URL of this resource.
        :param pulumi.Input[str] update_time: Time the HttpRoute was updated in UTC.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HttpRouteState.__new__(_HttpRouteState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["gateways"] = gateways
        __props__.__dict__["hostnames"] = hostnames
        __props__.__dict__["labels"] = labels
        __props__.__dict__["meshes"] = meshes
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["rules"] = rules
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["update_time"] = update_time
        return HttpRoute(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Time the HttpRoute was created in UTC.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A free-text description of the resource. Max length 1024 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def gateways(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Gateways defines a list of gateways this HttpRoute is attached to, as one of the routing rules to route the requests served by the gateway.
        Each gateway reference should match the pattern: projects/*/locations/global/gateways/<gateway_name>
        """
        return pulumi.get(self, "gateways")

    @property
    @pulumi.getter
    def hostnames(self) -> pulumi.Output[Sequence[str]]:
        """
        Set of hosts that should match against the HTTP host header to select a HttpRoute to process the request.
        """
        return pulumi.get(self, "hostnames")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Set of label tags associated with the HttpRoute resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def meshes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Meshes defines a list of meshes this HttpRoute is attached to, as one of the routing rules to route the requests served by the mesh.
        Each mesh reference should match the pattern: projects/*/locations/global/meshes/<mesh_name>.
        The attached Mesh should be of a type SIDECAR.
        """
        return pulumi.get(self, "meshes")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the HttpRoute resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Sequence['outputs.HttpRouteRule']]:
        """
        Rules that define how traffic is routed and handled.
        Structure is documented below.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        """
        Server-defined URL of this resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        Time the HttpRoute was updated in UTC.
        """
        return pulumi.get(self, "update_time")

