# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'DatabaseInstanceCloneArgs',
    'DatabaseInstanceIpAddressArgs',
    'DatabaseInstanceReplicaConfigurationArgs',
    'DatabaseInstanceRestoreBackupContextArgs',
    'DatabaseInstanceServerCaCertArgs',
    'DatabaseInstanceSettingsArgs',
    'DatabaseInstanceSettingsActiveDirectoryConfigArgs',
    'DatabaseInstanceSettingsAdvancedMachineFeaturesArgs',
    'DatabaseInstanceSettingsBackupConfigurationArgs',
    'DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettingsArgs',
    'DatabaseInstanceSettingsDataCacheConfigArgs',
    'DatabaseInstanceSettingsDatabaseFlagArgs',
    'DatabaseInstanceSettingsDenyMaintenancePeriodArgs',
    'DatabaseInstanceSettingsInsightsConfigArgs',
    'DatabaseInstanceSettingsIpConfigurationArgs',
    'DatabaseInstanceSettingsIpConfigurationAuthorizedNetworkArgs',
    'DatabaseInstanceSettingsLocationPreferenceArgs',
    'DatabaseInstanceSettingsMaintenanceWindowArgs',
    'DatabaseInstanceSettingsPasswordValidationPolicyArgs',
    'DatabaseInstanceSettingsSqlServerAuditConfigArgs',
    'UserPasswordPolicyArgs',
    'UserPasswordPolicyStatusArgs',
    'UserSqlServerUserDetailArgs',
]

@pulumi.input_type
class DatabaseInstanceCloneArgs:
    def __init__(__self__, *,
                 source_instance_name: pulumi.Input[str],
                 allocated_ip_range: Optional[pulumi.Input[str]] = None,
                 database_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 point_in_time: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] source_instance_name: Name of the source instance which will be cloned.
        :param pulumi.Input[str] allocated_ip_range: The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the cloned instance ip will be created in the allocated range. The range name must comply with [RFC 1035](https://tools.ietf.org/html/rfc1035). Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] database_names: (SQL Server only, use with `point_in_time`) Clone only the specified databases from the source instance. Clone all databases if empty.
        :param pulumi.Input[str] point_in_time: The timestamp of the point in time that should be restored.
               
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        pulumi.set(__self__, "source_instance_name", source_instance_name)
        if allocated_ip_range is not None:
            pulumi.set(__self__, "allocated_ip_range", allocated_ip_range)
        if database_names is not None:
            pulumi.set(__self__, "database_names", database_names)
        if point_in_time is not None:
            pulumi.set(__self__, "point_in_time", point_in_time)

    @property
    @pulumi.getter(name="sourceInstanceName")
    def source_instance_name(self) -> pulumi.Input[str]:
        """
        Name of the source instance which will be cloned.
        """
        return pulumi.get(self, "source_instance_name")

    @source_instance_name.setter
    def source_instance_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_instance_name", value)

    @property
    @pulumi.getter(name="allocatedIpRange")
    def allocated_ip_range(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the cloned instance ip will be created in the allocated range. The range name must comply with [RFC 1035](https://tools.ietf.org/html/rfc1035). Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        """
        return pulumi.get(self, "allocated_ip_range")

    @allocated_ip_range.setter
    def allocated_ip_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allocated_ip_range", value)

    @property
    @pulumi.getter(name="databaseNames")
    def database_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (SQL Server only, use with `point_in_time`) Clone only the specified databases from the source instance. Clone all databases if empty.
        """
        return pulumi.get(self, "database_names")

    @database_names.setter
    def database_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "database_names", value)

    @property
    @pulumi.getter(name="pointInTime")
    def point_in_time(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp of the point in time that should be restored.

        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "point_in_time")

    @point_in_time.setter
    def point_in_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "point_in_time", value)


@pulumi.input_type
class DatabaseInstanceIpAddressArgs:
    def __init__(__self__, *,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 time_to_retire: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if time_to_retire is not None:
            pulumi.set(__self__, "time_to_retire", time_to_retire)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="timeToRetire")
    def time_to_retire(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "time_to_retire")

    @time_to_retire.setter
    def time_to_retire(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_to_retire", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class DatabaseInstanceReplicaConfigurationArgs:
    def __init__(__self__, *,
                 ca_certificate: Optional[pulumi.Input[str]] = None,
                 client_certificate: Optional[pulumi.Input[str]] = None,
                 client_key: Optional[pulumi.Input[str]] = None,
                 connect_retry_interval: Optional[pulumi.Input[int]] = None,
                 dump_file_path: Optional[pulumi.Input[str]] = None,
                 failover_target: Optional[pulumi.Input[bool]] = None,
                 master_heartbeat_period: Optional[pulumi.Input[int]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 ssl_cipher: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 verify_server_certificate: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] ca_certificate: PEM representation of the trusted CA's x509
               certificate.
        :param pulumi.Input[str] client_certificate: PEM representation of the replica's x509
               certificate.
        :param pulumi.Input[str] client_key: PEM representation of the replica's private key. The
               corresponding public key in encoded in the `client_certificate`.
        :param pulumi.Input[int] connect_retry_interval: The number of seconds
               between connect retries. MySQL's default is 60 seconds.
        :param pulumi.Input[str] dump_file_path: Path to a SQL file in GCS from which replica
               instances are created. Format is `gs://bucket/filename`.
        :param pulumi.Input[bool] failover_target: Specifies if the replica is the failover target.
               If the field is set to true the replica will be designated as a failover replica.
               If the master instance fails, the replica instance will be promoted as
               the new master instance.
        :param pulumi.Input[int] master_heartbeat_period: Time in ms between replication
               heartbeats.
        :param pulumi.Input[str] password: Password for the replication connection.
        :param pulumi.Input[str] username: Username for replication connection.
        :param pulumi.Input[bool] verify_server_certificate: True if the master's common name
               value is checked during the SSL handshake.
        """
        if ca_certificate is not None:
            pulumi.set(__self__, "ca_certificate", ca_certificate)
        if client_certificate is not None:
            pulumi.set(__self__, "client_certificate", client_certificate)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if connect_retry_interval is not None:
            pulumi.set(__self__, "connect_retry_interval", connect_retry_interval)
        if dump_file_path is not None:
            pulumi.set(__self__, "dump_file_path", dump_file_path)
        if failover_target is not None:
            pulumi.set(__self__, "failover_target", failover_target)
        if master_heartbeat_period is not None:
            pulumi.set(__self__, "master_heartbeat_period", master_heartbeat_period)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if ssl_cipher is not None:
            pulumi.set(__self__, "ssl_cipher", ssl_cipher)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if verify_server_certificate is not None:
            pulumi.set(__self__, "verify_server_certificate", verify_server_certificate)

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        PEM representation of the trusted CA's x509
        certificate.
        """
        return pulumi.get(self, "ca_certificate")

    @ca_certificate.setter
    def ca_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_certificate", value)

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        PEM representation of the replica's x509
        certificate.
        """
        return pulumi.get(self, "client_certificate")

    @client_certificate.setter
    def client_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_certificate", value)

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[pulumi.Input[str]]:
        """
        PEM representation of the replica's private key. The
        corresponding public key in encoded in the `client_certificate`.
        """
        return pulumi.get(self, "client_key")

    @client_key.setter
    def client_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_key", value)

    @property
    @pulumi.getter(name="connectRetryInterval")
    def connect_retry_interval(self) -> Optional[pulumi.Input[int]]:
        """
        The number of seconds
        between connect retries. MySQL's default is 60 seconds.
        """
        return pulumi.get(self, "connect_retry_interval")

    @connect_retry_interval.setter
    def connect_retry_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "connect_retry_interval", value)

    @property
    @pulumi.getter(name="dumpFilePath")
    def dump_file_path(self) -> Optional[pulumi.Input[str]]:
        """
        Path to a SQL file in GCS from which replica
        instances are created. Format is `gs://bucket/filename`.
        """
        return pulumi.get(self, "dump_file_path")

    @dump_file_path.setter
    def dump_file_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dump_file_path", value)

    @property
    @pulumi.getter(name="failoverTarget")
    def failover_target(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if the replica is the failover target.
        If the field is set to true the replica will be designated as a failover replica.
        If the master instance fails, the replica instance will be promoted as
        the new master instance.
        """
        return pulumi.get(self, "failover_target")

    @failover_target.setter
    def failover_target(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "failover_target", value)

    @property
    @pulumi.getter(name="masterHeartbeatPeriod")
    def master_heartbeat_period(self) -> Optional[pulumi.Input[int]]:
        """
        Time in ms between replication
        heartbeats.
        """
        return pulumi.get(self, "master_heartbeat_period")

    @master_heartbeat_period.setter
    def master_heartbeat_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "master_heartbeat_period", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password for the replication connection.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="sslCipher")
    def ssl_cipher(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "ssl_cipher")

    @ssl_cipher.setter
    def ssl_cipher(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_cipher", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Username for replication connection.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="verifyServerCertificate")
    def verify_server_certificate(self) -> Optional[pulumi.Input[bool]]:
        """
        True if the master's common name
        value is checked during the SSL handshake.
        """
        return pulumi.get(self, "verify_server_certificate")

    @verify_server_certificate.setter
    def verify_server_certificate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "verify_server_certificate", value)


@pulumi.input_type
class DatabaseInstanceRestoreBackupContextArgs:
    def __init__(__self__, *,
                 backup_run_id: pulumi.Input[int],
                 instance_id: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] backup_run_id: The ID of the backup run to restore from.
        :param pulumi.Input[str] instance_id: The ID of the instance that the backup was taken from. If left empty,
               this instance's ID will be used.
        :param pulumi.Input[str] project: The full project ID of the source instance.`
        """
        pulumi.set(__self__, "backup_run_id", backup_run_id)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="backupRunId")
    def backup_run_id(self) -> pulumi.Input[int]:
        """
        The ID of the backup run to restore from.
        """
        return pulumi.get(self, "backup_run_id")

    @backup_run_id.setter
    def backup_run_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "backup_run_id", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the instance that the backup was taken from. If left empty,
        this instance's ID will be used.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The full project ID of the source instance.`
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class DatabaseInstanceServerCaCertArgs:
    def __init__(__self__, *,
                 cert: Optional[pulumi.Input[str]] = None,
                 common_name: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 expiration_time: Optional[pulumi.Input[str]] = None,
                 sha1_fingerprint: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] expiration_time: The [RFC 3339](https://tools.ietf.org/html/rfc3339)
               formatted date time string indicating when this whitelist expires.
        """
        if cert is not None:
            pulumi.set(__self__, "cert", cert)
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if expiration_time is not None:
            pulumi.set(__self__, "expiration_time", expiration_time)
        if sha1_fingerprint is not None:
            pulumi.set(__self__, "sha1_fingerprint", sha1_fingerprint)

    @property
    @pulumi.getter
    def cert(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "cert")

    @cert.setter
    def cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cert", value)

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "common_name")

    @common_name.setter
    def common_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "common_name", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> Optional[pulumi.Input[str]]:
        """
        The [RFC 3339](https://tools.ietf.org/html/rfc3339)
        formatted date time string indicating when this whitelist expires.
        """
        return pulumi.get(self, "expiration_time")

    @expiration_time.setter
    def expiration_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiration_time", value)

    @property
    @pulumi.getter(name="sha1Fingerprint")
    def sha1_fingerprint(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "sha1_fingerprint")

    @sha1_fingerprint.setter
    def sha1_fingerprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sha1_fingerprint", value)


@pulumi.input_type
class DatabaseInstanceSettingsArgs:
    def __init__(__self__, *,
                 tier: pulumi.Input[str],
                 activation_policy: Optional[pulumi.Input[str]] = None,
                 active_directory_config: Optional[pulumi.Input['DatabaseInstanceSettingsActiveDirectoryConfigArgs']] = None,
                 advanced_machine_features: Optional[pulumi.Input['DatabaseInstanceSettingsAdvancedMachineFeaturesArgs']] = None,
                 availability_type: Optional[pulumi.Input[str]] = None,
                 backup_configuration: Optional[pulumi.Input['DatabaseInstanceSettingsBackupConfigurationArgs']] = None,
                 collation: Optional[pulumi.Input[str]] = None,
                 connector_enforcement: Optional[pulumi.Input[str]] = None,
                 data_cache_config: Optional[pulumi.Input['DatabaseInstanceSettingsDataCacheConfigArgs']] = None,
                 database_flags: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsDatabaseFlagArgs']]]] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[bool]] = None,
                 deny_maintenance_period: Optional[pulumi.Input['DatabaseInstanceSettingsDenyMaintenancePeriodArgs']] = None,
                 disk_autoresize: Optional[pulumi.Input[bool]] = None,
                 disk_autoresize_limit: Optional[pulumi.Input[int]] = None,
                 disk_size: Optional[pulumi.Input[int]] = None,
                 disk_type: Optional[pulumi.Input[str]] = None,
                 edition: Optional[pulumi.Input[str]] = None,
                 insights_config: Optional[pulumi.Input['DatabaseInstanceSettingsInsightsConfigArgs']] = None,
                 ip_configuration: Optional[pulumi.Input['DatabaseInstanceSettingsIpConfigurationArgs']] = None,
                 location_preference: Optional[pulumi.Input['DatabaseInstanceSettingsLocationPreferenceArgs']] = None,
                 maintenance_window: Optional[pulumi.Input['DatabaseInstanceSettingsMaintenanceWindowArgs']] = None,
                 password_validation_policy: Optional[pulumi.Input['DatabaseInstanceSettingsPasswordValidationPolicyArgs']] = None,
                 pricing_plan: Optional[pulumi.Input[str]] = None,
                 sql_server_audit_config: Optional[pulumi.Input['DatabaseInstanceSettingsSqlServerAuditConfigArgs']] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 user_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 version: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] tier: The machine type to use. See [tiers](https://cloud.google.com/sql/docs/admin-api/v1beta4/tiers)
               for more details and supported versions. Postgres supports only shared-core machine types,
               and custom machine types such as `db-custom-2-13312`. See the [Custom Machine Type Documentation](https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#create) to learn about specifying custom machine types.
        :param pulumi.Input[str] activation_policy: This specifies when the instance should be
               active. Can be either `ALWAYS`, `NEVER` or `ON_DEMAND`.
        :param pulumi.Input[str] availability_type: The availability type of the Cloud SQL
               instance, high availability (`REGIONAL`) or single zone (`ZONAL`).' For all instances, ensure that
               `settings.backup_configuration.enabled` is set to `true`.
               For MySQL instances, ensure that `settings.backup_configuration.binary_log_enabled` is set to `true`.
               For Postgres and SQL Server instances, ensure that `settings.backup_configuration.point_in_time_recovery_enabled`
               is set to `true`. Defaults to `ZONAL`.
        :param pulumi.Input[str] collation: The name of server instance collation.
        :param pulumi.Input[str] connector_enforcement: Specifies if connections must use Cloud SQL connectors.
        :param pulumi.Input[bool] disk_autoresize: Enables auto-resizing of the storage size. Defaults to `true`.
        :param pulumi.Input[int] disk_autoresize_limit: The maximum size to which storage capacity can be automatically increased. The default value is 0, which specifies that there is no limit.
        :param pulumi.Input[int] disk_size: The size of data disk, in GB. Size of a running instance cannot be reduced but can be increased. The minimum value is 10GB.
        :param pulumi.Input[str] disk_type: The type of data disk: PD_SSD or PD_HDD. Defaults to `PD_SSD`.
        :param pulumi.Input[str] edition: The edition of the instance, can be `ENTERPRISE` or `ENTERPRISE_PLUS`.
        :param pulumi.Input[str] pricing_plan: Pricing plan for this instance, can only be `PER_USE`.
        :param pulumi.Input[str] time_zone: The time_zone to be used by the database engine (supported only for SQL Server), in SQL Server timezone format.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] user_labels: A set of key/value user label pairs to assign to the instance.
        """
        pulumi.set(__self__, "tier", tier)
        if activation_policy is not None:
            pulumi.set(__self__, "activation_policy", activation_policy)
        if active_directory_config is not None:
            pulumi.set(__self__, "active_directory_config", active_directory_config)
        if advanced_machine_features is not None:
            pulumi.set(__self__, "advanced_machine_features", advanced_machine_features)
        if availability_type is not None:
            pulumi.set(__self__, "availability_type", availability_type)
        if backup_configuration is not None:
            pulumi.set(__self__, "backup_configuration", backup_configuration)
        if collation is not None:
            pulumi.set(__self__, "collation", collation)
        if connector_enforcement is not None:
            pulumi.set(__self__, "connector_enforcement", connector_enforcement)
        if data_cache_config is not None:
            pulumi.set(__self__, "data_cache_config", data_cache_config)
        if database_flags is not None:
            pulumi.set(__self__, "database_flags", database_flags)
        if deletion_protection_enabled is not None:
            pulumi.set(__self__, "deletion_protection_enabled", deletion_protection_enabled)
        if deny_maintenance_period is not None:
            pulumi.set(__self__, "deny_maintenance_period", deny_maintenance_period)
        if disk_autoresize is not None:
            pulumi.set(__self__, "disk_autoresize", disk_autoresize)
        if disk_autoresize_limit is not None:
            pulumi.set(__self__, "disk_autoresize_limit", disk_autoresize_limit)
        if disk_size is not None:
            pulumi.set(__self__, "disk_size", disk_size)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)
        if edition is not None:
            pulumi.set(__self__, "edition", edition)
        if insights_config is not None:
            pulumi.set(__self__, "insights_config", insights_config)
        if ip_configuration is not None:
            pulumi.set(__self__, "ip_configuration", ip_configuration)
        if location_preference is not None:
            pulumi.set(__self__, "location_preference", location_preference)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if password_validation_policy is not None:
            pulumi.set(__self__, "password_validation_policy", password_validation_policy)
        if pricing_plan is not None:
            pulumi.set(__self__, "pricing_plan", pricing_plan)
        if sql_server_audit_config is not None:
            pulumi.set(__self__, "sql_server_audit_config", sql_server_audit_config)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if user_labels is not None:
            pulumi.set(__self__, "user_labels", user_labels)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def tier(self) -> pulumi.Input[str]:
        """
        The machine type to use. See [tiers](https://cloud.google.com/sql/docs/admin-api/v1beta4/tiers)
        for more details and supported versions. Postgres supports only shared-core machine types,
        and custom machine types such as `db-custom-2-13312`. See the [Custom Machine Type Documentation](https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#create) to learn about specifying custom machine types.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: pulumi.Input[str]):
        pulumi.set(self, "tier", value)

    @property
    @pulumi.getter(name="activationPolicy")
    def activation_policy(self) -> Optional[pulumi.Input[str]]:
        """
        This specifies when the instance should be
        active. Can be either `ALWAYS`, `NEVER` or `ON_DEMAND`.
        """
        return pulumi.get(self, "activation_policy")

    @activation_policy.setter
    def activation_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "activation_policy", value)

    @property
    @pulumi.getter(name="activeDirectoryConfig")
    def active_directory_config(self) -> Optional[pulumi.Input['DatabaseInstanceSettingsActiveDirectoryConfigArgs']]:
        return pulumi.get(self, "active_directory_config")

    @active_directory_config.setter
    def active_directory_config(self, value: Optional[pulumi.Input['DatabaseInstanceSettingsActiveDirectoryConfigArgs']]):
        pulumi.set(self, "active_directory_config", value)

    @property
    @pulumi.getter(name="advancedMachineFeatures")
    def advanced_machine_features(self) -> Optional[pulumi.Input['DatabaseInstanceSettingsAdvancedMachineFeaturesArgs']]:
        return pulumi.get(self, "advanced_machine_features")

    @advanced_machine_features.setter
    def advanced_machine_features(self, value: Optional[pulumi.Input['DatabaseInstanceSettingsAdvancedMachineFeaturesArgs']]):
        pulumi.set(self, "advanced_machine_features", value)

    @property
    @pulumi.getter(name="availabilityType")
    def availability_type(self) -> Optional[pulumi.Input[str]]:
        """
        The availability type of the Cloud SQL
        instance, high availability (`REGIONAL`) or single zone (`ZONAL`).' For all instances, ensure that
        `settings.backup_configuration.enabled` is set to `true`.
        For MySQL instances, ensure that `settings.backup_configuration.binary_log_enabled` is set to `true`.
        For Postgres and SQL Server instances, ensure that `settings.backup_configuration.point_in_time_recovery_enabled`
        is set to `true`. Defaults to `ZONAL`.
        """
        return pulumi.get(self, "availability_type")

    @availability_type.setter
    def availability_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_type", value)

    @property
    @pulumi.getter(name="backupConfiguration")
    def backup_configuration(self) -> Optional[pulumi.Input['DatabaseInstanceSettingsBackupConfigurationArgs']]:
        return pulumi.get(self, "backup_configuration")

    @backup_configuration.setter
    def backup_configuration(self, value: Optional[pulumi.Input['DatabaseInstanceSettingsBackupConfigurationArgs']]):
        pulumi.set(self, "backup_configuration", value)

    @property
    @pulumi.getter
    def collation(self) -> Optional[pulumi.Input[str]]:
        """
        The name of server instance collation.
        """
        return pulumi.get(self, "collation")

    @collation.setter
    def collation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "collation", value)

    @property
    @pulumi.getter(name="connectorEnforcement")
    def connector_enforcement(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies if connections must use Cloud SQL connectors.
        """
        return pulumi.get(self, "connector_enforcement")

    @connector_enforcement.setter
    def connector_enforcement(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connector_enforcement", value)

    @property
    @pulumi.getter(name="dataCacheConfig")
    def data_cache_config(self) -> Optional[pulumi.Input['DatabaseInstanceSettingsDataCacheConfigArgs']]:
        return pulumi.get(self, "data_cache_config")

    @data_cache_config.setter
    def data_cache_config(self, value: Optional[pulumi.Input['DatabaseInstanceSettingsDataCacheConfigArgs']]):
        pulumi.set(self, "data_cache_config", value)

    @property
    @pulumi.getter(name="databaseFlags")
    def database_flags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsDatabaseFlagArgs']]]]:
        return pulumi.get(self, "database_flags")

    @database_flags.setter
    def database_flags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsDatabaseFlagArgs']]]]):
        pulumi.set(self, "database_flags", value)

    @property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "deletion_protection_enabled")

    @deletion_protection_enabled.setter
    def deletion_protection_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection_enabled", value)

    @property
    @pulumi.getter(name="denyMaintenancePeriod")
    def deny_maintenance_period(self) -> Optional[pulumi.Input['DatabaseInstanceSettingsDenyMaintenancePeriodArgs']]:
        return pulumi.get(self, "deny_maintenance_period")

    @deny_maintenance_period.setter
    def deny_maintenance_period(self, value: Optional[pulumi.Input['DatabaseInstanceSettingsDenyMaintenancePeriodArgs']]):
        pulumi.set(self, "deny_maintenance_period", value)

    @property
    @pulumi.getter(name="diskAutoresize")
    def disk_autoresize(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables auto-resizing of the storage size. Defaults to `true`.
        """
        return pulumi.get(self, "disk_autoresize")

    @disk_autoresize.setter
    def disk_autoresize(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disk_autoresize", value)

    @property
    @pulumi.getter(name="diskAutoresizeLimit")
    def disk_autoresize_limit(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum size to which storage capacity can be automatically increased. The default value is 0, which specifies that there is no limit.
        """
        return pulumi.get(self, "disk_autoresize_limit")

    @disk_autoresize_limit.setter
    def disk_autoresize_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disk_autoresize_limit", value)

    @property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> Optional[pulumi.Input[int]]:
        """
        The size of data disk, in GB. Size of a running instance cannot be reduced but can be increased. The minimum value is 10GB.
        """
        return pulumi.get(self, "disk_size")

    @disk_size.setter
    def disk_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disk_size", value)

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of data disk: PD_SSD or PD_HDD. Defaults to `PD_SSD`.
        """
        return pulumi.get(self, "disk_type")

    @disk_type.setter
    def disk_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_type", value)

    @property
    @pulumi.getter
    def edition(self) -> Optional[pulumi.Input[str]]:
        """
        The edition of the instance, can be `ENTERPRISE` or `ENTERPRISE_PLUS`.
        """
        return pulumi.get(self, "edition")

    @edition.setter
    def edition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "edition", value)

    @property
    @pulumi.getter(name="insightsConfig")
    def insights_config(self) -> Optional[pulumi.Input['DatabaseInstanceSettingsInsightsConfigArgs']]:
        return pulumi.get(self, "insights_config")

    @insights_config.setter
    def insights_config(self, value: Optional[pulumi.Input['DatabaseInstanceSettingsInsightsConfigArgs']]):
        pulumi.set(self, "insights_config", value)

    @property
    @pulumi.getter(name="ipConfiguration")
    def ip_configuration(self) -> Optional[pulumi.Input['DatabaseInstanceSettingsIpConfigurationArgs']]:
        return pulumi.get(self, "ip_configuration")

    @ip_configuration.setter
    def ip_configuration(self, value: Optional[pulumi.Input['DatabaseInstanceSettingsIpConfigurationArgs']]):
        pulumi.set(self, "ip_configuration", value)

    @property
    @pulumi.getter(name="locationPreference")
    def location_preference(self) -> Optional[pulumi.Input['DatabaseInstanceSettingsLocationPreferenceArgs']]:
        return pulumi.get(self, "location_preference")

    @location_preference.setter
    def location_preference(self, value: Optional[pulumi.Input['DatabaseInstanceSettingsLocationPreferenceArgs']]):
        pulumi.set(self, "location_preference", value)

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['DatabaseInstanceSettingsMaintenanceWindowArgs']]:
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['DatabaseInstanceSettingsMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @property
    @pulumi.getter(name="passwordValidationPolicy")
    def password_validation_policy(self) -> Optional[pulumi.Input['DatabaseInstanceSettingsPasswordValidationPolicyArgs']]:
        return pulumi.get(self, "password_validation_policy")

    @password_validation_policy.setter
    def password_validation_policy(self, value: Optional[pulumi.Input['DatabaseInstanceSettingsPasswordValidationPolicyArgs']]):
        pulumi.set(self, "password_validation_policy", value)

    @property
    @pulumi.getter(name="pricingPlan")
    def pricing_plan(self) -> Optional[pulumi.Input[str]]:
        """
        Pricing plan for this instance, can only be `PER_USE`.
        """
        return pulumi.get(self, "pricing_plan")

    @pricing_plan.setter
    def pricing_plan(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pricing_plan", value)

    @property
    @pulumi.getter(name="sqlServerAuditConfig")
    def sql_server_audit_config(self) -> Optional[pulumi.Input['DatabaseInstanceSettingsSqlServerAuditConfigArgs']]:
        return pulumi.get(self, "sql_server_audit_config")

    @sql_server_audit_config.setter
    def sql_server_audit_config(self, value: Optional[pulumi.Input['DatabaseInstanceSettingsSqlServerAuditConfigArgs']]):
        pulumi.set(self, "sql_server_audit_config", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The time_zone to be used by the database engine (supported only for SQL Server), in SQL Server timezone format.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)

    @property
    @pulumi.getter(name="userLabels")
    def user_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A set of key/value user label pairs to assign to the instance.
        """
        return pulumi.get(self, "user_labels")

    @user_labels.setter
    def user_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "user_labels", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class DatabaseInstanceSettingsActiveDirectoryConfigArgs:
    def __init__(__self__, *,
                 domain: pulumi.Input[str]):
        """
        :param pulumi.Input[str] domain: The domain name for the active directory (e.g., mydomain.com).
               Can only be used with SQL Server.
        """
        pulumi.set(__self__, "domain", domain)

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Input[str]:
        """
        The domain name for the active directory (e.g., mydomain.com).
        Can only be used with SQL Server.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain", value)


@pulumi.input_type
class DatabaseInstanceSettingsAdvancedMachineFeaturesArgs:
    def __init__(__self__, *,
                 threads_per_core: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] threads_per_core: The number of threads per core. The value of this flag can be 1 or 2. To disable SMT, set this flag to 1. Only available in Cloud SQL for SQL Server instances. See [smt](https://cloud.google.com/sql/docs/sqlserver/create-instance#smt-create-instance) for more details.
        """
        if threads_per_core is not None:
            pulumi.set(__self__, "threads_per_core", threads_per_core)

    @property
    @pulumi.getter(name="threadsPerCore")
    def threads_per_core(self) -> Optional[pulumi.Input[int]]:
        """
        The number of threads per core. The value of this flag can be 1 or 2. To disable SMT, set this flag to 1. Only available in Cloud SQL for SQL Server instances. See [smt](https://cloud.google.com/sql/docs/sqlserver/create-instance#smt-create-instance) for more details.
        """
        return pulumi.get(self, "threads_per_core")

    @threads_per_core.setter
    def threads_per_core(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "threads_per_core", value)


@pulumi.input_type
class DatabaseInstanceSettingsBackupConfigurationArgs:
    def __init__(__self__, *,
                 backup_retention_settings: Optional[pulumi.Input['DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettingsArgs']] = None,
                 binary_log_enabled: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 point_in_time_recovery_enabled: Optional[pulumi.Input[bool]] = None,
                 start_time: Optional[pulumi.Input[str]] = None,
                 transaction_log_retention_days: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input['DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettingsArgs'] backup_retention_settings: Backup retention settings. The configuration is detailed below.
        :param pulumi.Input[bool] binary_log_enabled: True if binary logging is enabled.
               Can only be used with MySQL.
        :param pulumi.Input[bool] enabled: True if backup configuration is enabled.
        :param pulumi.Input[str] location: The region where the backup will be stored
        :param pulumi.Input[bool] point_in_time_recovery_enabled: True if Point-in-time recovery is enabled. Will restart database if enabled after instance creation. Valid only for PostgreSQL and SQL Server instances.
        :param pulumi.Input[str] start_time: `HH:MM` format time indicating when backup
               configuration starts.
        :param pulumi.Input[int] transaction_log_retention_days: The number of days of transaction logs we retain for point in time restore, from 1-7.
        """
        if backup_retention_settings is not None:
            pulumi.set(__self__, "backup_retention_settings", backup_retention_settings)
        if binary_log_enabled is not None:
            pulumi.set(__self__, "binary_log_enabled", binary_log_enabled)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if point_in_time_recovery_enabled is not None:
            pulumi.set(__self__, "point_in_time_recovery_enabled", point_in_time_recovery_enabled)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if transaction_log_retention_days is not None:
            pulumi.set(__self__, "transaction_log_retention_days", transaction_log_retention_days)

    @property
    @pulumi.getter(name="backupRetentionSettings")
    def backup_retention_settings(self) -> Optional[pulumi.Input['DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettingsArgs']]:
        """
        Backup retention settings. The configuration is detailed below.
        """
        return pulumi.get(self, "backup_retention_settings")

    @backup_retention_settings.setter
    def backup_retention_settings(self, value: Optional[pulumi.Input['DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettingsArgs']]):
        pulumi.set(self, "backup_retention_settings", value)

    @property
    @pulumi.getter(name="binaryLogEnabled")
    def binary_log_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        True if binary logging is enabled.
        Can only be used with MySQL.
        """
        return pulumi.get(self, "binary_log_enabled")

    @binary_log_enabled.setter
    def binary_log_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "binary_log_enabled", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        True if backup configuration is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The region where the backup will be stored
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="pointInTimeRecoveryEnabled")
    def point_in_time_recovery_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        True if Point-in-time recovery is enabled. Will restart database if enabled after instance creation. Valid only for PostgreSQL and SQL Server instances.
        """
        return pulumi.get(self, "point_in_time_recovery_enabled")

    @point_in_time_recovery_enabled.setter
    def point_in_time_recovery_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "point_in_time_recovery_enabled", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        `HH:MM` format time indicating when backup
        configuration starts.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter(name="transactionLogRetentionDays")
    def transaction_log_retention_days(self) -> Optional[pulumi.Input[int]]:
        """
        The number of days of transaction logs we retain for point in time restore, from 1-7.
        """
        return pulumi.get(self, "transaction_log_retention_days")

    @transaction_log_retention_days.setter
    def transaction_log_retention_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "transaction_log_retention_days", value)


@pulumi.input_type
class DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettingsArgs:
    def __init__(__self__, *,
                 retained_backups: pulumi.Input[int],
                 retention_unit: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] retained_backups: Depending on the value of retention_unit, this is used to determine if a backup needs to be deleted. If retention_unit
               is 'COUNT', we will retain this many backups.
        :param pulumi.Input[str] retention_unit: The unit that 'retained_backups' represents. Defaults to `COUNT`.
        """
        pulumi.set(__self__, "retained_backups", retained_backups)
        if retention_unit is not None:
            pulumi.set(__self__, "retention_unit", retention_unit)

    @property
    @pulumi.getter(name="retainedBackups")
    def retained_backups(self) -> pulumi.Input[int]:
        """
        Depending on the value of retention_unit, this is used to determine if a backup needs to be deleted. If retention_unit
        is 'COUNT', we will retain this many backups.
        """
        return pulumi.get(self, "retained_backups")

    @retained_backups.setter
    def retained_backups(self, value: pulumi.Input[int]):
        pulumi.set(self, "retained_backups", value)

    @property
    @pulumi.getter(name="retentionUnit")
    def retention_unit(self) -> Optional[pulumi.Input[str]]:
        """
        The unit that 'retained_backups' represents. Defaults to `COUNT`.
        """
        return pulumi.get(self, "retention_unit")

    @retention_unit.setter
    def retention_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "retention_unit", value)


@pulumi.input_type
class DatabaseInstanceSettingsDataCacheConfigArgs:
    def __init__(__self__, *,
                 data_cache_enabled: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] data_cache_enabled: Whether data cache is enabled for the instance. Defaults to `false`
               Can only be used with MYSQL.
        """
        if data_cache_enabled is not None:
            pulumi.set(__self__, "data_cache_enabled", data_cache_enabled)

    @property
    @pulumi.getter(name="dataCacheEnabled")
    def data_cache_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether data cache is enabled for the instance. Defaults to `false`
        Can only be used with MYSQL.
        """
        return pulumi.get(self, "data_cache_enabled")

    @data_cache_enabled.setter
    def data_cache_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "data_cache_enabled", value)


@pulumi.input_type
class DatabaseInstanceSettingsDatabaseFlagArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] name: Name of the flag.
        :param pulumi.Input[str] value: Value of the flag.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the flag.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Value of the flag.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class DatabaseInstanceSettingsDenyMaintenancePeriodArgs:
    def __init__(__self__, *,
                 end_date: pulumi.Input[str],
                 start_date: pulumi.Input[str],
                 time: pulumi.Input[str]):
        """
        :param pulumi.Input[str] end_date: "deny maintenance period" end date. If the year of the end date is empty, the year of the start date also must be empty. In this case, it means the no maintenance interval recurs every year. The date is in format yyyy-mm-dd i.e., 2020-11-01, or mm-dd, i.e., 11-01
        :param pulumi.Input[str] start_date: "deny maintenance period" start date. If the year of the start date is empty, the year of the end date also must be empty. In this case, it means the deny maintenance period recurs every year. The date is in format yyyy-mm-dd i.e., 2020-11-01, or mm-dd, i.e., 11-01
        :param pulumi.Input[str] time: Time in UTC when the "deny maintenance period" starts on startDate and ends on endDate. The time is in format: HH:mm:SS, i.e., 00:00:00
        """
        pulumi.set(__self__, "end_date", end_date)
        pulumi.set(__self__, "start_date", start_date)
        pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter(name="endDate")
    def end_date(self) -> pulumi.Input[str]:
        """
        "deny maintenance period" end date. If the year of the end date is empty, the year of the start date also must be empty. In this case, it means the no maintenance interval recurs every year. The date is in format yyyy-mm-dd i.e., 2020-11-01, or mm-dd, i.e., 11-01
        """
        return pulumi.get(self, "end_date")

    @end_date.setter
    def end_date(self, value: pulumi.Input[str]):
        pulumi.set(self, "end_date", value)

    @property
    @pulumi.getter(name="startDate")
    def start_date(self) -> pulumi.Input[str]:
        """
        "deny maintenance period" start date. If the year of the start date is empty, the year of the end date also must be empty. In this case, it means the deny maintenance period recurs every year. The date is in format yyyy-mm-dd i.e., 2020-11-01, or mm-dd, i.e., 11-01
        """
        return pulumi.get(self, "start_date")

    @start_date.setter
    def start_date(self, value: pulumi.Input[str]):
        pulumi.set(self, "start_date", value)

    @property
    @pulumi.getter
    def time(self) -> pulumi.Input[str]:
        """
        Time in UTC when the "deny maintenance period" starts on startDate and ends on endDate. The time is in format: HH:mm:SS, i.e., 00:00:00
        """
        return pulumi.get(self, "time")

    @time.setter
    def time(self, value: pulumi.Input[str]):
        pulumi.set(self, "time", value)


@pulumi.input_type
class DatabaseInstanceSettingsInsightsConfigArgs:
    def __init__(__self__, *,
                 query_insights_enabled: Optional[pulumi.Input[bool]] = None,
                 query_plans_per_minute: Optional[pulumi.Input[int]] = None,
                 query_string_length: Optional[pulumi.Input[int]] = None,
                 record_application_tags: Optional[pulumi.Input[bool]] = None,
                 record_client_address: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] query_insights_enabled: True if Query Insights feature is enabled.
        :param pulumi.Input[int] query_plans_per_minute: Number of query execution plans captured by Insights per minute for all queries combined. Between 0 and 20. Default to 5.
               
               The optional `settings.password_validation_policy` subblock for instances declares [Password Validation Policy](https://cloud.google.com/sql/docs/postgres/built-in-authentication) configuration. It contains:
        :param pulumi.Input[int] query_string_length: Maximum query length stored in bytes. Between 256 and 4500. Default to 1024. Higher query lengths are more useful for analytical queries, but they also require more memory. Changing the query length requires you to restart the instance. You can still add tags to queries that exceed the length limit.
        :param pulumi.Input[bool] record_application_tags: True if Query Insights will record application tags from query when enabled.
        :param pulumi.Input[bool] record_client_address: True if Query Insights will record client address when enabled.
        """
        if query_insights_enabled is not None:
            pulumi.set(__self__, "query_insights_enabled", query_insights_enabled)
        if query_plans_per_minute is not None:
            pulumi.set(__self__, "query_plans_per_minute", query_plans_per_minute)
        if query_string_length is not None:
            pulumi.set(__self__, "query_string_length", query_string_length)
        if record_application_tags is not None:
            pulumi.set(__self__, "record_application_tags", record_application_tags)
        if record_client_address is not None:
            pulumi.set(__self__, "record_client_address", record_client_address)

    @property
    @pulumi.getter(name="queryInsightsEnabled")
    def query_insights_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        True if Query Insights feature is enabled.
        """
        return pulumi.get(self, "query_insights_enabled")

    @query_insights_enabled.setter
    def query_insights_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "query_insights_enabled", value)

    @property
    @pulumi.getter(name="queryPlansPerMinute")
    def query_plans_per_minute(self) -> Optional[pulumi.Input[int]]:
        """
        Number of query execution plans captured by Insights per minute for all queries combined. Between 0 and 20. Default to 5.

        The optional `settings.password_validation_policy` subblock for instances declares [Password Validation Policy](https://cloud.google.com/sql/docs/postgres/built-in-authentication) configuration. It contains:
        """
        return pulumi.get(self, "query_plans_per_minute")

    @query_plans_per_minute.setter
    def query_plans_per_minute(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "query_plans_per_minute", value)

    @property
    @pulumi.getter(name="queryStringLength")
    def query_string_length(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum query length stored in bytes. Between 256 and 4500. Default to 1024. Higher query lengths are more useful for analytical queries, but they also require more memory. Changing the query length requires you to restart the instance. You can still add tags to queries that exceed the length limit.
        """
        return pulumi.get(self, "query_string_length")

    @query_string_length.setter
    def query_string_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "query_string_length", value)

    @property
    @pulumi.getter(name="recordApplicationTags")
    def record_application_tags(self) -> Optional[pulumi.Input[bool]]:
        """
        True if Query Insights will record application tags from query when enabled.
        """
        return pulumi.get(self, "record_application_tags")

    @record_application_tags.setter
    def record_application_tags(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "record_application_tags", value)

    @property
    @pulumi.getter(name="recordClientAddress")
    def record_client_address(self) -> Optional[pulumi.Input[bool]]:
        """
        True if Query Insights will record client address when enabled.
        """
        return pulumi.get(self, "record_client_address")

    @record_client_address.setter
    def record_client_address(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "record_client_address", value)


@pulumi.input_type
class DatabaseInstanceSettingsIpConfigurationArgs:
    def __init__(__self__, *,
                 allocated_ip_range: Optional[pulumi.Input[str]] = None,
                 authorized_networks: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsIpConfigurationAuthorizedNetworkArgs']]]] = None,
                 enable_private_path_for_google_cloud_services: Optional[pulumi.Input[bool]] = None,
                 ipv4_enabled: Optional[pulumi.Input[bool]] = None,
                 private_network: Optional[pulumi.Input[str]] = None,
                 require_ssl: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] allocated_ip_range: The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the instance ip will be created in the allocated range. The range name must comply with [RFC 1035](https://datatracker.ietf.org/doc/html/rfc1035). Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        :param pulumi.Input[bool] enable_private_path_for_google_cloud_services: Whether Google Cloud services such as BigQuery are allowed to access data in this Cloud SQL instance over a private IP connection. SQLSERVER database type is not supported.
        :param pulumi.Input[bool] ipv4_enabled: Whether this Cloud SQL instance should be assigned
               a public IPV4 address. At least `ipv4_enabled` must be enabled or a
               `private_network` must be configured.
        :param pulumi.Input[str] private_network: The VPC network from which the Cloud SQL
               instance is accessible for private IP. For example, projects/myProject/global/networks/default.
               Specifying a network enables private IP.
               At least `ipv4_enabled` must be enabled or a `private_network` must be configured.
               This setting can be updated, but it cannot be removed after it is set.
        :param pulumi.Input[bool] require_ssl: Whether SSL connections over IP are enforced or not.
        """
        if allocated_ip_range is not None:
            pulumi.set(__self__, "allocated_ip_range", allocated_ip_range)
        if authorized_networks is not None:
            pulumi.set(__self__, "authorized_networks", authorized_networks)
        if enable_private_path_for_google_cloud_services is not None:
            pulumi.set(__self__, "enable_private_path_for_google_cloud_services", enable_private_path_for_google_cloud_services)
        if ipv4_enabled is not None:
            pulumi.set(__self__, "ipv4_enabled", ipv4_enabled)
        if private_network is not None:
            pulumi.set(__self__, "private_network", private_network)
        if require_ssl is not None:
            pulumi.set(__self__, "require_ssl", require_ssl)

    @property
    @pulumi.getter(name="allocatedIpRange")
    def allocated_ip_range(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the instance ip will be created in the allocated range. The range name must comply with [RFC 1035](https://datatracker.ietf.org/doc/html/rfc1035). Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        """
        return pulumi.get(self, "allocated_ip_range")

    @allocated_ip_range.setter
    def allocated_ip_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allocated_ip_range", value)

    @property
    @pulumi.getter(name="authorizedNetworks")
    def authorized_networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsIpConfigurationAuthorizedNetworkArgs']]]]:
        return pulumi.get(self, "authorized_networks")

    @authorized_networks.setter
    def authorized_networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsIpConfigurationAuthorizedNetworkArgs']]]]):
        pulumi.set(self, "authorized_networks", value)

    @property
    @pulumi.getter(name="enablePrivatePathForGoogleCloudServices")
    def enable_private_path_for_google_cloud_services(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether Google Cloud services such as BigQuery are allowed to access data in this Cloud SQL instance over a private IP connection. SQLSERVER database type is not supported.
        """
        return pulumi.get(self, "enable_private_path_for_google_cloud_services")

    @enable_private_path_for_google_cloud_services.setter
    def enable_private_path_for_google_cloud_services(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_private_path_for_google_cloud_services", value)

    @property
    @pulumi.getter(name="ipv4Enabled")
    def ipv4_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this Cloud SQL instance should be assigned
        a public IPV4 address. At least `ipv4_enabled` must be enabled or a
        `private_network` must be configured.
        """
        return pulumi.get(self, "ipv4_enabled")

    @ipv4_enabled.setter
    def ipv4_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ipv4_enabled", value)

    @property
    @pulumi.getter(name="privateNetwork")
    def private_network(self) -> Optional[pulumi.Input[str]]:
        """
        The VPC network from which the Cloud SQL
        instance is accessible for private IP. For example, projects/myProject/global/networks/default.
        Specifying a network enables private IP.
        At least `ipv4_enabled` must be enabled or a `private_network` must be configured.
        This setting can be updated, but it cannot be removed after it is set.
        """
        return pulumi.get(self, "private_network")

    @private_network.setter
    def private_network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_network", value)

    @property
    @pulumi.getter(name="requireSsl")
    def require_ssl(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether SSL connections over IP are enforced or not.
        """
        return pulumi.get(self, "require_ssl")

    @require_ssl.setter
    def require_ssl(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_ssl", value)


@pulumi.input_type
class DatabaseInstanceSettingsIpConfigurationAuthorizedNetworkArgs:
    def __init__(__self__, *,
                 value: pulumi.Input[str],
                 expiration_time: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] value: A CIDR notation IPv4 or IPv6 address that is allowed to
               access this instance. Must be set even if other two attributes are not for
               the whitelist to become active.
        :param pulumi.Input[str] expiration_time: The [RFC 3339](https://tools.ietf.org/html/rfc3339)
               formatted date time string indicating when this whitelist expires.
        :param pulumi.Input[str] name: A name for this whitelist entry.
        """
        pulumi.set(__self__, "value", value)
        if expiration_time is not None:
            pulumi.set(__self__, "expiration_time", expiration_time)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        A CIDR notation IPv4 or IPv6 address that is allowed to
        access this instance. Must be set even if other two attributes are not for
        the whitelist to become active.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> Optional[pulumi.Input[str]]:
        """
        The [RFC 3339](https://tools.ietf.org/html/rfc3339)
        formatted date time string indicating when this whitelist expires.
        """
        return pulumi.get(self, "expiration_time")

    @expiration_time.setter
    def expiration_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiration_time", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A name for this whitelist entry.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class DatabaseInstanceSettingsLocationPreferenceArgs:
    def __init__(__self__, *,
                 follow_gae_application: Optional[pulumi.Input[str]] = None,
                 secondary_zone: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] follow_gae_application: A GAE application whose zone to remain
               in. Must be in the same region as this instance.
        :param pulumi.Input[str] secondary_zone: The preferred Compute Engine zone for the secondary/failover.
               
               The optional `settings.maintenance_window` subblock for instances declares a one-hour
               [maintenance window](https://cloud.google.com/sql/docs/instance-settings?hl=en#maintenance-window-2ndgen)
               when an Instance can automatically restart to apply updates. The maintenance window is specified in UTC time. It supports:
        :param pulumi.Input[str] zone: The preferred compute engine
               [zone](https://cloud.google.com/compute/docs/zones?hl=en).
        """
        if follow_gae_application is not None:
            pulumi.set(__self__, "follow_gae_application", follow_gae_application)
        if secondary_zone is not None:
            pulumi.set(__self__, "secondary_zone", secondary_zone)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="followGaeApplication")
    def follow_gae_application(self) -> Optional[pulumi.Input[str]]:
        """
        A GAE application whose zone to remain
        in. Must be in the same region as this instance.
        """
        return pulumi.get(self, "follow_gae_application")

    @follow_gae_application.setter
    def follow_gae_application(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "follow_gae_application", value)

    @property
    @pulumi.getter(name="secondaryZone")
    def secondary_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The preferred Compute Engine zone for the secondary/failover.

        The optional `settings.maintenance_window` subblock for instances declares a one-hour
        [maintenance window](https://cloud.google.com/sql/docs/instance-settings?hl=en#maintenance-window-2ndgen)
        when an Instance can automatically restart to apply updates. The maintenance window is specified in UTC time. It supports:
        """
        return pulumi.get(self, "secondary_zone")

    @secondary_zone.setter
    def secondary_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secondary_zone", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        The preferred compute engine
        [zone](https://cloud.google.com/compute/docs/zones?hl=en).
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class DatabaseInstanceSettingsMaintenanceWindowArgs:
    def __init__(__self__, *,
                 day: Optional[pulumi.Input[int]] = None,
                 hour: Optional[pulumi.Input[int]] = None,
                 update_track: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] day: Day of week (`1-7`), starting on Monday
        :param pulumi.Input[int] hour: Hour of day (`0-23`), ignored if `day` not set
        :param pulumi.Input[str] update_track: Receive updates earlier (`canary`) or later
               (`stable`)
               
               The optional `settings.insights_config` subblock for instances declares Query Insights([MySQL](https://cloud.google.com/sql/docs/mysql/using-query-insights), [PostgreSQL](https://cloud.google.com/sql/docs/postgres/using-query-insights)) configuration. It contains:
        """
        if day is not None:
            pulumi.set(__self__, "day", day)
        if hour is not None:
            pulumi.set(__self__, "hour", hour)
        if update_track is not None:
            pulumi.set(__self__, "update_track", update_track)

    @property
    @pulumi.getter
    def day(self) -> Optional[pulumi.Input[int]]:
        """
        Day of week (`1-7`), starting on Monday
        """
        return pulumi.get(self, "day")

    @day.setter
    def day(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "day", value)

    @property
    @pulumi.getter
    def hour(self) -> Optional[pulumi.Input[int]]:
        """
        Hour of day (`0-23`), ignored if `day` not set
        """
        return pulumi.get(self, "hour")

    @hour.setter
    def hour(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "hour", value)

    @property
    @pulumi.getter(name="updateTrack")
    def update_track(self) -> Optional[pulumi.Input[str]]:
        """
        Receive updates earlier (`canary`) or later
        (`stable`)

        The optional `settings.insights_config` subblock for instances declares Query Insights([MySQL](https://cloud.google.com/sql/docs/mysql/using-query-insights), [PostgreSQL](https://cloud.google.com/sql/docs/postgres/using-query-insights)) configuration. It contains:
        """
        return pulumi.get(self, "update_track")

    @update_track.setter
    def update_track(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_track", value)


@pulumi.input_type
class DatabaseInstanceSettingsPasswordValidationPolicyArgs:
    def __init__(__self__, *,
                 enable_password_policy: pulumi.Input[bool],
                 complexity: Optional[pulumi.Input[str]] = None,
                 disallow_username_substring: Optional[pulumi.Input[bool]] = None,
                 min_length: Optional[pulumi.Input[int]] = None,
                 password_change_interval: Optional[pulumi.Input[str]] = None,
                 reuse_interval: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[bool] enable_password_policy: Enables or disable the password validation policy.
               
               The optional `replica_configuration` block must have `master_instance_name` set
               to work, cannot be updated, and supports:
        :param pulumi.Input[str] complexity: Checks if the password is a combination of lowercase, uppercase, numeric, and non-alphanumeric characters.
        :param pulumi.Input[bool] disallow_username_substring: Prevents the use of the username in the password.
        :param pulumi.Input[int] min_length: Specifies the minimum number of characters that the password must have.
        :param pulumi.Input[str] password_change_interval: Specifies the minimum duration after which you can change the password.
        :param pulumi.Input[int] reuse_interval: Specifies the number of previous passwords that you can't reuse.
        """
        pulumi.set(__self__, "enable_password_policy", enable_password_policy)
        if complexity is not None:
            pulumi.set(__self__, "complexity", complexity)
        if disallow_username_substring is not None:
            pulumi.set(__self__, "disallow_username_substring", disallow_username_substring)
        if min_length is not None:
            pulumi.set(__self__, "min_length", min_length)
        if password_change_interval is not None:
            pulumi.set(__self__, "password_change_interval", password_change_interval)
        if reuse_interval is not None:
            pulumi.set(__self__, "reuse_interval", reuse_interval)

    @property
    @pulumi.getter(name="enablePasswordPolicy")
    def enable_password_policy(self) -> pulumi.Input[bool]:
        """
        Enables or disable the password validation policy.

        The optional `replica_configuration` block must have `master_instance_name` set
        to work, cannot be updated, and supports:
        """
        return pulumi.get(self, "enable_password_policy")

    @enable_password_policy.setter
    def enable_password_policy(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enable_password_policy", value)

    @property
    @pulumi.getter
    def complexity(self) -> Optional[pulumi.Input[str]]:
        """
        Checks if the password is a combination of lowercase, uppercase, numeric, and non-alphanumeric characters.
        """
        return pulumi.get(self, "complexity")

    @complexity.setter
    def complexity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "complexity", value)

    @property
    @pulumi.getter(name="disallowUsernameSubstring")
    def disallow_username_substring(self) -> Optional[pulumi.Input[bool]]:
        """
        Prevents the use of the username in the password.
        """
        return pulumi.get(self, "disallow_username_substring")

    @disallow_username_substring.setter
    def disallow_username_substring(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disallow_username_substring", value)

    @property
    @pulumi.getter(name="minLength")
    def min_length(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the minimum number of characters that the password must have.
        """
        return pulumi.get(self, "min_length")

    @min_length.setter
    def min_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_length", value)

    @property
    @pulumi.getter(name="passwordChangeInterval")
    def password_change_interval(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the minimum duration after which you can change the password.
        """
        return pulumi.get(self, "password_change_interval")

    @password_change_interval.setter
    def password_change_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password_change_interval", value)

    @property
    @pulumi.getter(name="reuseInterval")
    def reuse_interval(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the number of previous passwords that you can't reuse.
        """
        return pulumi.get(self, "reuse_interval")

    @reuse_interval.setter
    def reuse_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "reuse_interval", value)


@pulumi.input_type
class DatabaseInstanceSettingsSqlServerAuditConfigArgs:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[str]] = None,
                 retention_interval: Optional[pulumi.Input[str]] = None,
                 upload_interval: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] bucket: The name of the destination bucket (e.g., gs://mybucket).
        :param pulumi.Input[str] retention_interval: How long to keep generated audit files. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        :param pulumi.Input[str] upload_interval: How often to upload generated audit files. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if retention_interval is not None:
            pulumi.set(__self__, "retention_interval", retention_interval)
        if upload_interval is not None:
            pulumi.set(__self__, "upload_interval", upload_interval)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the destination bucket (e.g., gs://mybucket).
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="retentionInterval")
    def retention_interval(self) -> Optional[pulumi.Input[str]]:
        """
        How long to keep generated audit files. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "retention_interval")

    @retention_interval.setter
    def retention_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "retention_interval", value)

    @property
    @pulumi.getter(name="uploadInterval")
    def upload_interval(self) -> Optional[pulumi.Input[str]]:
        """
        How often to upload generated audit files. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "upload_interval")

    @upload_interval.setter
    def upload_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "upload_interval", value)


@pulumi.input_type
class UserPasswordPolicyArgs:
    def __init__(__self__, *,
                 allowed_failed_attempts: Optional[pulumi.Input[int]] = None,
                 enable_failed_attempts_check: Optional[pulumi.Input[bool]] = None,
                 enable_password_verification: Optional[pulumi.Input[bool]] = None,
                 password_expiration_duration: Optional[pulumi.Input[str]] = None,
                 statuses: Optional[pulumi.Input[Sequence[pulumi.Input['UserPasswordPolicyStatusArgs']]]] = None):
        """
        :param pulumi.Input[int] allowed_failed_attempts: Number of failed attempts allowed before the user get locked.
        :param pulumi.Input[bool] enable_failed_attempts_check: If true, the check that will lock user after too many failed login attempts will be enabled.
        :param pulumi.Input[bool] enable_password_verification: If true, the user must specify the current password before changing the password. This flag is supported only for MySQL.
        :param pulumi.Input[str] password_expiration_duration: Password expiration duration with one week grace period.
        """
        if allowed_failed_attempts is not None:
            pulumi.set(__self__, "allowed_failed_attempts", allowed_failed_attempts)
        if enable_failed_attempts_check is not None:
            pulumi.set(__self__, "enable_failed_attempts_check", enable_failed_attempts_check)
        if enable_password_verification is not None:
            pulumi.set(__self__, "enable_password_verification", enable_password_verification)
        if password_expiration_duration is not None:
            pulumi.set(__self__, "password_expiration_duration", password_expiration_duration)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)

    @property
    @pulumi.getter(name="allowedFailedAttempts")
    def allowed_failed_attempts(self) -> Optional[pulumi.Input[int]]:
        """
        Number of failed attempts allowed before the user get locked.
        """
        return pulumi.get(self, "allowed_failed_attempts")

    @allowed_failed_attempts.setter
    def allowed_failed_attempts(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "allowed_failed_attempts", value)

    @property
    @pulumi.getter(name="enableFailedAttemptsCheck")
    def enable_failed_attempts_check(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the check that will lock user after too many failed login attempts will be enabled.
        """
        return pulumi.get(self, "enable_failed_attempts_check")

    @enable_failed_attempts_check.setter
    def enable_failed_attempts_check(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_failed_attempts_check", value)

    @property
    @pulumi.getter(name="enablePasswordVerification")
    def enable_password_verification(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the user must specify the current password before changing the password. This flag is supported only for MySQL.
        """
        return pulumi.get(self, "enable_password_verification")

    @enable_password_verification.setter
    def enable_password_verification(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_password_verification", value)

    @property
    @pulumi.getter(name="passwordExpirationDuration")
    def password_expiration_duration(self) -> Optional[pulumi.Input[str]]:
        """
        Password expiration duration with one week grace period.
        """
        return pulumi.get(self, "password_expiration_duration")

    @password_expiration_duration.setter
    def password_expiration_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password_expiration_duration", value)

    @property
    @pulumi.getter
    def statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserPasswordPolicyStatusArgs']]]]:
        return pulumi.get(self, "statuses")

    @statuses.setter
    def statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserPasswordPolicyStatusArgs']]]]):
        pulumi.set(self, "statuses", value)


@pulumi.input_type
class UserPasswordPolicyStatusArgs:
    def __init__(__self__, *,
                 locked: Optional[pulumi.Input[bool]] = None,
                 password_expiration_time: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] locked: If true, user does not have login privileges.
        :param pulumi.Input[str] password_expiration_time: Password expiration duration with one week grace period.
        """
        if locked is not None:
            pulumi.set(__self__, "locked", locked)
        if password_expiration_time is not None:
            pulumi.set(__self__, "password_expiration_time", password_expiration_time)

    @property
    @pulumi.getter
    def locked(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, user does not have login privileges.
        """
        return pulumi.get(self, "locked")

    @locked.setter
    def locked(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "locked", value)

    @property
    @pulumi.getter(name="passwordExpirationTime")
    def password_expiration_time(self) -> Optional[pulumi.Input[str]]:
        """
        Password expiration duration with one week grace period.
        """
        return pulumi.get(self, "password_expiration_time")

    @password_expiration_time.setter
    def password_expiration_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password_expiration_time", value)


@pulumi.input_type
class UserSqlServerUserDetailArgs:
    def __init__(__self__, *,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 server_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if server_roles is not None:
            pulumi.set(__self__, "server_roles", server_roles)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter(name="serverRoles")
    def server_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "server_roles")

    @server_roles.setter
    def server_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "server_roles", value)


