# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DatabaseInstanceArgs', 'DatabaseInstance']

@pulumi.input_type
class DatabaseInstanceArgs:
    def __init__(__self__, *,
                 database_version: pulumi.Input[str],
                 clone: Optional[pulumi.Input['DatabaseInstanceCloneArgs']] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 encryption_key_name: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 maintenance_version: Optional[pulumi.Input[str]] = None,
                 master_instance_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 replica_configuration: Optional[pulumi.Input['DatabaseInstanceReplicaConfigurationArgs']] = None,
                 restore_backup_context: Optional[pulumi.Input['DatabaseInstanceRestoreBackupContextArgs']] = None,
                 root_password: Optional[pulumi.Input[str]] = None,
                 settings: Optional[pulumi.Input['DatabaseInstanceSettingsArgs']] = None):
        """
        The set of arguments for constructing a DatabaseInstance resource.
        :param pulumi.Input[str] database_version: The MySQL, PostgreSQL or
               SQL Server version to use. Supported values include `MYSQL_5_6`,
               `MYSQL_5_7`, `MYSQL_8_0`, `POSTGRES_9_6`,`POSTGRES_10`, `POSTGRES_11`,
               `POSTGRES_12`, `POSTGRES_13`, `POSTGRES_14`, `POSTGRES_15`, `SQLSERVER_2017_STANDARD`,
               `SQLSERVER_2017_ENTERPRISE`, `SQLSERVER_2017_EXPRESS`, `SQLSERVER_2017_WEB`.
               `SQLSERVER_2019_STANDARD`, `SQLSERVER_2019_ENTERPRISE`, `SQLSERVER_2019_EXPRESS`,
               `SQLSERVER_2019_WEB`.
               [Database Version Policies](https://cloud.google.com/sql/docs/db-versions)
               includes an up-to-date reference of supported versions.
        :param pulumi.Input['DatabaseInstanceCloneArgs'] clone: The context needed to create this instance as a clone of another instance. When this field is set during
               resource creation, this provider will attempt to clone another instance as indicated in the context. The
               configuration is detailed below.
        :param pulumi.Input[bool] deletion_protection: Whether or not to allow the provider to destroy the instance. Unless this field is set to false
               in state, a `destroy` or `update` command that deletes the instance will fail. Defaults to `true`.
        :param pulumi.Input[str] encryption_key_name: The full path to the encryption key used for the CMEK disk encryption.  Setting
               up disk encryption currently requires manual steps outside of this provider.
               The provided key must be in the same region as the SQL instance.  In order
               to use this feature, a special kind of service account must be created and
               granted permission on this key.  This step can currently only be done
               manually, please see [this step](https://cloud.google.com/sql/docs/mysql/configure-cmek#service-account).
               That service account needs the `Cloud KMS > Cloud KMS CryptoKey Encrypter/Decrypter` role on your
               key - please see [this step](https://cloud.google.com/sql/docs/mysql/configure-cmek#grantkey).
        :param pulumi.Input[str] instance_type: The type of the instance. The supported values are `SQL_INSTANCE_TYPE_UNSPECIFIED`, `CLOUD_SQL_INSTANCE`, `ON_PREMISES_INSTANCE` and `READ_REPLICA_INSTANCE`.
        :param pulumi.Input[str] maintenance_version: The current software version on the instance. This attribute can not be set during creation. Refer to `available_maintenance_versions` attribute to see what `maintenance_version` are available for upgrade. When this attribute gets updated, it will cause an instance restart. Setting a `maintenance_version` value that is older than the current one on the instance will be ignored.
        :param pulumi.Input[str] master_instance_name: The name of the existing instance that will
               act as the master in the replication setup. Note, this requires the master to
               have `binary_log_enabled` set, as well as existing backups.
        :param pulumi.Input[str] name: The name of the instance. If the name is left
               blank, the provider will randomly generate one when the instance is first
               created. This is done because after a name is used, it cannot be reused for
               up to [one week](https://cloud.google.com/sql/docs/delete-instance).
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[str] region: The region the instance will sit in. If a region is not provided in the resource definition,
               the provider region will be used instead.
               
               - - -
        :param pulumi.Input['DatabaseInstanceReplicaConfigurationArgs'] replica_configuration: The configuration for replication. The
               configuration is detailed below. Valid only for MySQL instances.
        :param pulumi.Input['DatabaseInstanceRestoreBackupContextArgs'] restore_backup_context: The context needed to restore the database to a backup run. This field will
               cause the provider to trigger the database to restore from the backup run indicated. The configuration is detailed below.
               **NOTE:** Restoring from a backup is an imperative action and not recommended via this provider. Adding or modifying this
               block during resource creation/update will trigger the restore action after the resource is created/updated.
        :param pulumi.Input[str] root_password: Initial root password. Can be updated. Required for MS SQL Server.
        :param pulumi.Input['DatabaseInstanceSettingsArgs'] settings: The settings to use for the database. The
               configuration is detailed below. Required if `clone` is not set.
        """
        pulumi.set(__self__, "database_version", database_version)
        if clone is not None:
            pulumi.set(__self__, "clone", clone)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if encryption_key_name is not None:
            pulumi.set(__self__, "encryption_key_name", encryption_key_name)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if maintenance_version is not None:
            pulumi.set(__self__, "maintenance_version", maintenance_version)
        if master_instance_name is not None:
            pulumi.set(__self__, "master_instance_name", master_instance_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replica_configuration is not None:
            pulumi.set(__self__, "replica_configuration", replica_configuration)
        if restore_backup_context is not None:
            pulumi.set(__self__, "restore_backup_context", restore_backup_context)
        if root_password is not None:
            pulumi.set(__self__, "root_password", root_password)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)

    @property
    @pulumi.getter(name="databaseVersion")
    def database_version(self) -> pulumi.Input[str]:
        """
        The MySQL, PostgreSQL or
        SQL Server version to use. Supported values include `MYSQL_5_6`,
        `MYSQL_5_7`, `MYSQL_8_0`, `POSTGRES_9_6`,`POSTGRES_10`, `POSTGRES_11`,
        `POSTGRES_12`, `POSTGRES_13`, `POSTGRES_14`, `POSTGRES_15`, `SQLSERVER_2017_STANDARD`,
        `SQLSERVER_2017_ENTERPRISE`, `SQLSERVER_2017_EXPRESS`, `SQLSERVER_2017_WEB`.
        `SQLSERVER_2019_STANDARD`, `SQLSERVER_2019_ENTERPRISE`, `SQLSERVER_2019_EXPRESS`,
        `SQLSERVER_2019_WEB`.
        [Database Version Policies](https://cloud.google.com/sql/docs/db-versions)
        includes an up-to-date reference of supported versions.
        """
        return pulumi.get(self, "database_version")

    @database_version.setter
    def database_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "database_version", value)

    @property
    @pulumi.getter
    def clone(self) -> Optional[pulumi.Input['DatabaseInstanceCloneArgs']]:
        """
        The context needed to create this instance as a clone of another instance. When this field is set during
        resource creation, this provider will attempt to clone another instance as indicated in the context. The
        configuration is detailed below.
        """
        return pulumi.get(self, "clone")

    @clone.setter
    def clone(self, value: Optional[pulumi.Input['DatabaseInstanceCloneArgs']]):
        pulumi.set(self, "clone", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to allow the provider to destroy the instance. Unless this field is set to false
        in state, a `destroy` or `update` command that deletes the instance will fail. Defaults to `true`.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter(name="encryptionKeyName")
    def encryption_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        The full path to the encryption key used for the CMEK disk encryption.  Setting
        up disk encryption currently requires manual steps outside of this provider.
        The provided key must be in the same region as the SQL instance.  In order
        to use this feature, a special kind of service account must be created and
        granted permission on this key.  This step can currently only be done
        manually, please see [this step](https://cloud.google.com/sql/docs/mysql/configure-cmek#service-account).
        That service account needs the `Cloud KMS > Cloud KMS CryptoKey Encrypter/Decrypter` role on your
        key - please see [this step](https://cloud.google.com/sql/docs/mysql/configure-cmek#grantkey).
        """
        return pulumi.get(self, "encryption_key_name")

    @encryption_key_name.setter
    def encryption_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encryption_key_name", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the instance. The supported values are `SQL_INSTANCE_TYPE_UNSPECIFIED`, `CLOUD_SQL_INSTANCE`, `ON_PREMISES_INSTANCE` and `READ_REPLICA_INSTANCE`.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="maintenanceVersion")
    def maintenance_version(self) -> Optional[pulumi.Input[str]]:
        """
        The current software version on the instance. This attribute can not be set during creation. Refer to `available_maintenance_versions` attribute to see what `maintenance_version` are available for upgrade. When this attribute gets updated, it will cause an instance restart. Setting a `maintenance_version` value that is older than the current one on the instance will be ignored.
        """
        return pulumi.get(self, "maintenance_version")

    @maintenance_version.setter
    def maintenance_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintenance_version", value)

    @property
    @pulumi.getter(name="masterInstanceName")
    def master_instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the existing instance that will
        act as the master in the replication setup. Note, this requires the master to
        have `binary_log_enabled` set, as well as existing backups.
        """
        return pulumi.get(self, "master_instance_name")

    @master_instance_name.setter
    def master_instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_instance_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the instance. If the name is left
        blank, the provider will randomly generate one when the instance is first
        created. This is done because after a name is used, it cannot be reused for
        up to [one week](https://cloud.google.com/sql/docs/delete-instance).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region the instance will sit in. If a region is not provided in the resource definition,
        the provider region will be used instead.

        - - -
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="replicaConfiguration")
    def replica_configuration(self) -> Optional[pulumi.Input['DatabaseInstanceReplicaConfigurationArgs']]:
        """
        The configuration for replication. The
        configuration is detailed below. Valid only for MySQL instances.
        """
        return pulumi.get(self, "replica_configuration")

    @replica_configuration.setter
    def replica_configuration(self, value: Optional[pulumi.Input['DatabaseInstanceReplicaConfigurationArgs']]):
        pulumi.set(self, "replica_configuration", value)

    @property
    @pulumi.getter(name="restoreBackupContext")
    def restore_backup_context(self) -> Optional[pulumi.Input['DatabaseInstanceRestoreBackupContextArgs']]:
        """
        The context needed to restore the database to a backup run. This field will
        cause the provider to trigger the database to restore from the backup run indicated. The configuration is detailed below.
        **NOTE:** Restoring from a backup is an imperative action and not recommended via this provider. Adding or modifying this
        block during resource creation/update will trigger the restore action after the resource is created/updated.
        """
        return pulumi.get(self, "restore_backup_context")

    @restore_backup_context.setter
    def restore_backup_context(self, value: Optional[pulumi.Input['DatabaseInstanceRestoreBackupContextArgs']]):
        pulumi.set(self, "restore_backup_context", value)

    @property
    @pulumi.getter(name="rootPassword")
    def root_password(self) -> Optional[pulumi.Input[str]]:
        """
        Initial root password. Can be updated. Required for MS SQL Server.
        """
        return pulumi.get(self, "root_password")

    @root_password.setter
    def root_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "root_password", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input['DatabaseInstanceSettingsArgs']]:
        """
        The settings to use for the database. The
        configuration is detailed below. Required if `clone` is not set.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input['DatabaseInstanceSettingsArgs']]):
        pulumi.set(self, "settings", value)


@pulumi.input_type
class _DatabaseInstanceState:
    def __init__(__self__, *,
                 available_maintenance_versions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 clone: Optional[pulumi.Input['DatabaseInstanceCloneArgs']] = None,
                 connection_name: Optional[pulumi.Input[str]] = None,
                 database_version: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 encryption_key_name: Optional[pulumi.Input[str]] = None,
                 first_ip_address: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceIpAddressArgs']]]] = None,
                 maintenance_version: Optional[pulumi.Input[str]] = None,
                 master_instance_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_ip_address: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 public_ip_address: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 replica_configuration: Optional[pulumi.Input['DatabaseInstanceReplicaConfigurationArgs']] = None,
                 restore_backup_context: Optional[pulumi.Input['DatabaseInstanceRestoreBackupContextArgs']] = None,
                 root_password: Optional[pulumi.Input[str]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 server_ca_certs: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceServerCaCertArgs']]]] = None,
                 service_account_email_address: Optional[pulumi.Input[str]] = None,
                 settings: Optional[pulumi.Input['DatabaseInstanceSettingsArgs']] = None):
        """
        Input properties used for looking up and filtering DatabaseInstance resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] available_maintenance_versions: The list of all maintenance versions applicable on the instance.
        :param pulumi.Input['DatabaseInstanceCloneArgs'] clone: The context needed to create this instance as a clone of another instance. When this field is set during
               resource creation, this provider will attempt to clone another instance as indicated in the context. The
               configuration is detailed below.
        :param pulumi.Input[str] connection_name: The connection name of the instance to be used in
               connection strings. For example, when connecting with [Cloud SQL Proxy](https://cloud.google.com/sql/docs/mysql/connect-admin-proxy).
        :param pulumi.Input[str] database_version: The MySQL, PostgreSQL or
               SQL Server version to use. Supported values include `MYSQL_5_6`,
               `MYSQL_5_7`, `MYSQL_8_0`, `POSTGRES_9_6`,`POSTGRES_10`, `POSTGRES_11`,
               `POSTGRES_12`, `POSTGRES_13`, `POSTGRES_14`, `POSTGRES_15`, `SQLSERVER_2017_STANDARD`,
               `SQLSERVER_2017_ENTERPRISE`, `SQLSERVER_2017_EXPRESS`, `SQLSERVER_2017_WEB`.
               `SQLSERVER_2019_STANDARD`, `SQLSERVER_2019_ENTERPRISE`, `SQLSERVER_2019_EXPRESS`,
               `SQLSERVER_2019_WEB`.
               [Database Version Policies](https://cloud.google.com/sql/docs/db-versions)
               includes an up-to-date reference of supported versions.
        :param pulumi.Input[bool] deletion_protection: Whether or not to allow the provider to destroy the instance. Unless this field is set to false
               in state, a `destroy` or `update` command that deletes the instance will fail. Defaults to `true`.
        :param pulumi.Input[str] encryption_key_name: The full path to the encryption key used for the CMEK disk encryption.  Setting
               up disk encryption currently requires manual steps outside of this provider.
               The provided key must be in the same region as the SQL instance.  In order
               to use this feature, a special kind of service account must be created and
               granted permission on this key.  This step can currently only be done
               manually, please see [this step](https://cloud.google.com/sql/docs/mysql/configure-cmek#service-account).
               That service account needs the `Cloud KMS > Cloud KMS CryptoKey Encrypter/Decrypter` role on your
               key - please see [this step](https://cloud.google.com/sql/docs/mysql/configure-cmek#grantkey).
        :param pulumi.Input[str] first_ip_address: The first IPv4 address of any type assigned.
        :param pulumi.Input[str] instance_type: The type of the instance. The supported values are `SQL_INSTANCE_TYPE_UNSPECIFIED`, `CLOUD_SQL_INSTANCE`, `ON_PREMISES_INSTANCE` and `READ_REPLICA_INSTANCE`.
        :param pulumi.Input[str] maintenance_version: The current software version on the instance. This attribute can not be set during creation. Refer to `available_maintenance_versions` attribute to see what `maintenance_version` are available for upgrade. When this attribute gets updated, it will cause an instance restart. Setting a `maintenance_version` value that is older than the current one on the instance will be ignored.
        :param pulumi.Input[str] master_instance_name: The name of the existing instance that will
               act as the master in the replication setup. Note, this requires the master to
               have `binary_log_enabled` set, as well as existing backups.
        :param pulumi.Input[str] name: The name of the instance. If the name is left
               blank, the provider will randomly generate one when the instance is first
               created. This is done because after a name is used, it cannot be reused for
               up to [one week](https://cloud.google.com/sql/docs/delete-instance).
        :param pulumi.Input[str] private_ip_address: The first private (`PRIVATE`) IPv4 address assigned.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[str] public_ip_address: The first public (`PRIMARY`) IPv4 address assigned.
        :param pulumi.Input[str] region: The region the instance will sit in. If a region is not provided in the resource definition,
               the provider region will be used instead.
               
               - - -
        :param pulumi.Input['DatabaseInstanceReplicaConfigurationArgs'] replica_configuration: The configuration for replication. The
               configuration is detailed below. Valid only for MySQL instances.
        :param pulumi.Input['DatabaseInstanceRestoreBackupContextArgs'] restore_backup_context: The context needed to restore the database to a backup run. This field will
               cause the provider to trigger the database to restore from the backup run indicated. The configuration is detailed below.
               **NOTE:** Restoring from a backup is an imperative action and not recommended via this provider. Adding or modifying this
               block during resource creation/update will trigger the restore action after the resource is created/updated.
        :param pulumi.Input[str] root_password: Initial root password. Can be updated. Required for MS SQL Server.
        :param pulumi.Input[str] self_link: The URI of the created resource.
        :param pulumi.Input[str] service_account_email_address: The service account email address assigned to the
               instance.
        :param pulumi.Input['DatabaseInstanceSettingsArgs'] settings: The settings to use for the database. The
               configuration is detailed below. Required if `clone` is not set.
        """
        if available_maintenance_versions is not None:
            pulumi.set(__self__, "available_maintenance_versions", available_maintenance_versions)
        if clone is not None:
            pulumi.set(__self__, "clone", clone)
        if connection_name is not None:
            pulumi.set(__self__, "connection_name", connection_name)
        if database_version is not None:
            pulumi.set(__self__, "database_version", database_version)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if encryption_key_name is not None:
            pulumi.set(__self__, "encryption_key_name", encryption_key_name)
        if first_ip_address is not None:
            pulumi.set(__self__, "first_ip_address", first_ip_address)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)
        if maintenance_version is not None:
            pulumi.set(__self__, "maintenance_version", maintenance_version)
        if master_instance_name is not None:
            pulumi.set(__self__, "master_instance_name", master_instance_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if public_ip_address is not None:
            pulumi.set(__self__, "public_ip_address", public_ip_address)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replica_configuration is not None:
            pulumi.set(__self__, "replica_configuration", replica_configuration)
        if restore_backup_context is not None:
            pulumi.set(__self__, "restore_backup_context", restore_backup_context)
        if root_password is not None:
            pulumi.set(__self__, "root_password", root_password)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if server_ca_certs is not None:
            pulumi.set(__self__, "server_ca_certs", server_ca_certs)
        if service_account_email_address is not None:
            pulumi.set(__self__, "service_account_email_address", service_account_email_address)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)

    @property
    @pulumi.getter(name="availableMaintenanceVersions")
    def available_maintenance_versions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of all maintenance versions applicable on the instance.
        """
        return pulumi.get(self, "available_maintenance_versions")

    @available_maintenance_versions.setter
    def available_maintenance_versions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "available_maintenance_versions", value)

    @property
    @pulumi.getter
    def clone(self) -> Optional[pulumi.Input['DatabaseInstanceCloneArgs']]:
        """
        The context needed to create this instance as a clone of another instance. When this field is set during
        resource creation, this provider will attempt to clone another instance as indicated in the context. The
        configuration is detailed below.
        """
        return pulumi.get(self, "clone")

    @clone.setter
    def clone(self, value: Optional[pulumi.Input['DatabaseInstanceCloneArgs']]):
        pulumi.set(self, "clone", value)

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> Optional[pulumi.Input[str]]:
        """
        The connection name of the instance to be used in
        connection strings. For example, when connecting with [Cloud SQL Proxy](https://cloud.google.com/sql/docs/mysql/connect-admin-proxy).
        """
        return pulumi.get(self, "connection_name")

    @connection_name.setter
    def connection_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_name", value)

    @property
    @pulumi.getter(name="databaseVersion")
    def database_version(self) -> Optional[pulumi.Input[str]]:
        """
        The MySQL, PostgreSQL or
        SQL Server version to use. Supported values include `MYSQL_5_6`,
        `MYSQL_5_7`, `MYSQL_8_0`, `POSTGRES_9_6`,`POSTGRES_10`, `POSTGRES_11`,
        `POSTGRES_12`, `POSTGRES_13`, `POSTGRES_14`, `POSTGRES_15`, `SQLSERVER_2017_STANDARD`,
        `SQLSERVER_2017_ENTERPRISE`, `SQLSERVER_2017_EXPRESS`, `SQLSERVER_2017_WEB`.
        `SQLSERVER_2019_STANDARD`, `SQLSERVER_2019_ENTERPRISE`, `SQLSERVER_2019_EXPRESS`,
        `SQLSERVER_2019_WEB`.
        [Database Version Policies](https://cloud.google.com/sql/docs/db-versions)
        includes an up-to-date reference of supported versions.
        """
        return pulumi.get(self, "database_version")

    @database_version.setter
    def database_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_version", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to allow the provider to destroy the instance. Unless this field is set to false
        in state, a `destroy` or `update` command that deletes the instance will fail. Defaults to `true`.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter(name="encryptionKeyName")
    def encryption_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        The full path to the encryption key used for the CMEK disk encryption.  Setting
        up disk encryption currently requires manual steps outside of this provider.
        The provided key must be in the same region as the SQL instance.  In order
        to use this feature, a special kind of service account must be created and
        granted permission on this key.  This step can currently only be done
        manually, please see [this step](https://cloud.google.com/sql/docs/mysql/configure-cmek#service-account).
        That service account needs the `Cloud KMS > Cloud KMS CryptoKey Encrypter/Decrypter` role on your
        key - please see [this step](https://cloud.google.com/sql/docs/mysql/configure-cmek#grantkey).
        """
        return pulumi.get(self, "encryption_key_name")

    @encryption_key_name.setter
    def encryption_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encryption_key_name", value)

    @property
    @pulumi.getter(name="firstIpAddress")
    def first_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The first IPv4 address of any type assigned.
        """
        return pulumi.get(self, "first_ip_address")

    @first_ip_address.setter
    def first_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "first_ip_address", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the instance. The supported values are `SQL_INSTANCE_TYPE_UNSPECIFIED`, `CLOUD_SQL_INSTANCE`, `ON_PREMISES_INSTANCE` and `READ_REPLICA_INSTANCE`.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceIpAddressArgs']]]]:
        return pulumi.get(self, "ip_addresses")

    @ip_addresses.setter
    def ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceIpAddressArgs']]]]):
        pulumi.set(self, "ip_addresses", value)

    @property
    @pulumi.getter(name="maintenanceVersion")
    def maintenance_version(self) -> Optional[pulumi.Input[str]]:
        """
        The current software version on the instance. This attribute can not be set during creation. Refer to `available_maintenance_versions` attribute to see what `maintenance_version` are available for upgrade. When this attribute gets updated, it will cause an instance restart. Setting a `maintenance_version` value that is older than the current one on the instance will be ignored.
        """
        return pulumi.get(self, "maintenance_version")

    @maintenance_version.setter
    def maintenance_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintenance_version", value)

    @property
    @pulumi.getter(name="masterInstanceName")
    def master_instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the existing instance that will
        act as the master in the replication setup. Note, this requires the master to
        have `binary_log_enabled` set, as well as existing backups.
        """
        return pulumi.get(self, "master_instance_name")

    @master_instance_name.setter
    def master_instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_instance_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the instance. If the name is left
        blank, the provider will randomly generate one when the instance is first
        created. This is done because after a name is used, it cannot be reused for
        up to [one week](https://cloud.google.com/sql/docs/delete-instance).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The first private (`PRIVATE`) IPv4 address assigned.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip_address", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The first public (`PRIMARY`) IPv4 address assigned.
        """
        return pulumi.get(self, "public_ip_address")

    @public_ip_address.setter
    def public_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_ip_address", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region the instance will sit in. If a region is not provided in the resource definition,
        the provider region will be used instead.

        - - -
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="replicaConfiguration")
    def replica_configuration(self) -> Optional[pulumi.Input['DatabaseInstanceReplicaConfigurationArgs']]:
        """
        The configuration for replication. The
        configuration is detailed below. Valid only for MySQL instances.
        """
        return pulumi.get(self, "replica_configuration")

    @replica_configuration.setter
    def replica_configuration(self, value: Optional[pulumi.Input['DatabaseInstanceReplicaConfigurationArgs']]):
        pulumi.set(self, "replica_configuration", value)

    @property
    @pulumi.getter(name="restoreBackupContext")
    def restore_backup_context(self) -> Optional[pulumi.Input['DatabaseInstanceRestoreBackupContextArgs']]:
        """
        The context needed to restore the database to a backup run. This field will
        cause the provider to trigger the database to restore from the backup run indicated. The configuration is detailed below.
        **NOTE:** Restoring from a backup is an imperative action and not recommended via this provider. Adding or modifying this
        block during resource creation/update will trigger the restore action after the resource is created/updated.
        """
        return pulumi.get(self, "restore_backup_context")

    @restore_backup_context.setter
    def restore_backup_context(self, value: Optional[pulumi.Input['DatabaseInstanceRestoreBackupContextArgs']]):
        pulumi.set(self, "restore_backup_context", value)

    @property
    @pulumi.getter(name="rootPassword")
    def root_password(self) -> Optional[pulumi.Input[str]]:
        """
        Initial root password. Can be updated. Required for MS SQL Server.
        """
        return pulumi.get(self, "root_password")

    @root_password.setter
    def root_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "root_password", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter(name="serverCaCerts")
    def server_ca_certs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceServerCaCertArgs']]]]:
        return pulumi.get(self, "server_ca_certs")

    @server_ca_certs.setter
    def server_ca_certs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceServerCaCertArgs']]]]):
        pulumi.set(self, "server_ca_certs", value)

    @property
    @pulumi.getter(name="serviceAccountEmailAddress")
    def service_account_email_address(self) -> Optional[pulumi.Input[str]]:
        """
        The service account email address assigned to the
        instance.
        """
        return pulumi.get(self, "service_account_email_address")

    @service_account_email_address.setter
    def service_account_email_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account_email_address", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input['DatabaseInstanceSettingsArgs']]:
        """
        The settings to use for the database. The
        configuration is detailed below. Required if `clone` is not set.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input['DatabaseInstanceSettingsArgs']]):
        pulumi.set(self, "settings", value)


class DatabaseInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 clone: Optional[pulumi.Input[pulumi.InputType['DatabaseInstanceCloneArgs']]] = None,
                 database_version: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 encryption_key_name: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 maintenance_version: Optional[pulumi.Input[str]] = None,
                 master_instance_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 replica_configuration: Optional[pulumi.Input[pulumi.InputType['DatabaseInstanceReplicaConfigurationArgs']]] = None,
                 restore_backup_context: Optional[pulumi.Input[pulumi.InputType['DatabaseInstanceRestoreBackupContextArgs']]] = None,
                 root_password: Optional[pulumi.Input[str]] = None,
                 settings: Optional[pulumi.Input[pulumi.InputType['DatabaseInstanceSettingsArgs']]] = None,
                 __props__=None):
        """
        Creates a new Google SQL Database Instance. For more information, see the [official documentation](https://cloud.google.com/sql/),
        or the [JSON API](https://cloud.google.com/sql/docs/admin-api/v1beta4/instances).

        > **NOTE on `sql.DatabaseInstance`:** - Second-generation instances include a
        default 'root'@'%' user with no password. This user will be deleted by the provider on
        instance creation. You should use `sql.User` to define a custom user with
        a restricted host and strong password.

        > **Note**: On newer versions of the provider, you must explicitly set `deletion_protection=false`
        (and run `pulumi update` to write the field to state) in order to destroy an instance.
        It is recommended to not set this field (or set it to true) until you're ready to destroy the instance and its databases.

        ## Example Usage
        ### SQL Second Generation Instance

        ```python
        import pulumi
        import pulumi_gcp as gcp

        main = gcp.sql.DatabaseInstance("main",
            database_version="POSTGRES_15",
            region="us-central1",
            settings=gcp.sql.DatabaseInstanceSettingsArgs(
                tier="db-f1-micro",
            ))
        ```
        ### Private IP Instance
        > **NOTE:** For private IP instance setup, note that the `sql.DatabaseInstance` does not actually interpolate values from `servicenetworking.Connection`. You must explicitly add a `depends_on`reference as shown below.

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_random as random

        private_network = gcp.compute.Network("privateNetwork", opts=pulumi.ResourceOptions(provider=google_beta))
        private_ip_address = gcp.compute.GlobalAddress("privateIpAddress",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=private_network.id,
            opts=pulumi.ResourceOptions(provider=google_beta))
        private_vpc_connection = gcp.servicenetworking.Connection("privateVpcConnection",
            network=private_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[private_ip_address.name],
            opts=pulumi.ResourceOptions(provider=google_beta))
        db_name_suffix = random.RandomId("dbNameSuffix", byte_length=4)
        instance = gcp.sql.DatabaseInstance("instance",
            region="us-central1",
            database_version="MYSQL_5_7",
            settings=gcp.sql.DatabaseInstanceSettingsArgs(
                tier="db-f1-micro",
                ip_configuration=gcp.sql.DatabaseInstanceSettingsIpConfigurationArgs(
                    ipv4_enabled=False,
                    private_network=private_network.id,
                    enable_private_path_for_google_cloud_services=True,
                ),
            ),
            opts=pulumi.ResourceOptions(provider=google_beta,
                depends_on=[private_vpc_connection]))
        ```
        ### ENTERPRISE_PLUS Instance with data_cache_config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        main = gcp.sql.DatabaseInstance("main",
            database_version="MYSQL_8_0_31",
            settings=gcp.sql.DatabaseInstanceSettingsArgs(
                data_cache_config=gcp.sql.DatabaseInstanceSettingsDataCacheConfigArgs(
                    data_cache_enabled=True,
                ),
                edition="ENTERPRISE_PLUS",
                tier="db-perf-optimized-N-2",
            ))
        ```

        ## Import

        Database instances can be imported using one of any of these accepted formats

        ```sh
         $ pulumi import gcp:sql/databaseInstance:DatabaseInstance main projects/{{project}}/instances/{{name}}
        ```

        ```sh
         $ pulumi import gcp:sql/databaseInstance:DatabaseInstance main {{project}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:sql/databaseInstance:DatabaseInstance main {{name}}
        ```

         config and set on the server. When importing, double-check that your config has all the fields set that you expect- just seeing no diff isn't sufficient to know that your config could reproduce the imported resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['DatabaseInstanceCloneArgs']] clone: The context needed to create this instance as a clone of another instance. When this field is set during
               resource creation, this provider will attempt to clone another instance as indicated in the context. The
               configuration is detailed below.
        :param pulumi.Input[str] database_version: The MySQL, PostgreSQL or
               SQL Server version to use. Supported values include `MYSQL_5_6`,
               `MYSQL_5_7`, `MYSQL_8_0`, `POSTGRES_9_6`,`POSTGRES_10`, `POSTGRES_11`,
               `POSTGRES_12`, `POSTGRES_13`, `POSTGRES_14`, `POSTGRES_15`, `SQLSERVER_2017_STANDARD`,
               `SQLSERVER_2017_ENTERPRISE`, `SQLSERVER_2017_EXPRESS`, `SQLSERVER_2017_WEB`.
               `SQLSERVER_2019_STANDARD`, `SQLSERVER_2019_ENTERPRISE`, `SQLSERVER_2019_EXPRESS`,
               `SQLSERVER_2019_WEB`.
               [Database Version Policies](https://cloud.google.com/sql/docs/db-versions)
               includes an up-to-date reference of supported versions.
        :param pulumi.Input[bool] deletion_protection: Whether or not to allow the provider to destroy the instance. Unless this field is set to false
               in state, a `destroy` or `update` command that deletes the instance will fail. Defaults to `true`.
        :param pulumi.Input[str] encryption_key_name: The full path to the encryption key used for the CMEK disk encryption.  Setting
               up disk encryption currently requires manual steps outside of this provider.
               The provided key must be in the same region as the SQL instance.  In order
               to use this feature, a special kind of service account must be created and
               granted permission on this key.  This step can currently only be done
               manually, please see [this step](https://cloud.google.com/sql/docs/mysql/configure-cmek#service-account).
               That service account needs the `Cloud KMS > Cloud KMS CryptoKey Encrypter/Decrypter` role on your
               key - please see [this step](https://cloud.google.com/sql/docs/mysql/configure-cmek#grantkey).
        :param pulumi.Input[str] instance_type: The type of the instance. The supported values are `SQL_INSTANCE_TYPE_UNSPECIFIED`, `CLOUD_SQL_INSTANCE`, `ON_PREMISES_INSTANCE` and `READ_REPLICA_INSTANCE`.
        :param pulumi.Input[str] maintenance_version: The current software version on the instance. This attribute can not be set during creation. Refer to `available_maintenance_versions` attribute to see what `maintenance_version` are available for upgrade. When this attribute gets updated, it will cause an instance restart. Setting a `maintenance_version` value that is older than the current one on the instance will be ignored.
        :param pulumi.Input[str] master_instance_name: The name of the existing instance that will
               act as the master in the replication setup. Note, this requires the master to
               have `binary_log_enabled` set, as well as existing backups.
        :param pulumi.Input[str] name: The name of the instance. If the name is left
               blank, the provider will randomly generate one when the instance is first
               created. This is done because after a name is used, it cannot be reused for
               up to [one week](https://cloud.google.com/sql/docs/delete-instance).
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[str] region: The region the instance will sit in. If a region is not provided in the resource definition,
               the provider region will be used instead.
               
               - - -
        :param pulumi.Input[pulumi.InputType['DatabaseInstanceReplicaConfigurationArgs']] replica_configuration: The configuration for replication. The
               configuration is detailed below. Valid only for MySQL instances.
        :param pulumi.Input[pulumi.InputType['DatabaseInstanceRestoreBackupContextArgs']] restore_backup_context: The context needed to restore the database to a backup run. This field will
               cause the provider to trigger the database to restore from the backup run indicated. The configuration is detailed below.
               **NOTE:** Restoring from a backup is an imperative action and not recommended via this provider. Adding or modifying this
               block during resource creation/update will trigger the restore action after the resource is created/updated.
        :param pulumi.Input[str] root_password: Initial root password. Can be updated. Required for MS SQL Server.
        :param pulumi.Input[pulumi.InputType['DatabaseInstanceSettingsArgs']] settings: The settings to use for the database. The
               configuration is detailed below. Required if `clone` is not set.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatabaseInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new Google SQL Database Instance. For more information, see the [official documentation](https://cloud.google.com/sql/),
        or the [JSON API](https://cloud.google.com/sql/docs/admin-api/v1beta4/instances).

        > **NOTE on `sql.DatabaseInstance`:** - Second-generation instances include a
        default 'root'@'%' user with no password. This user will be deleted by the provider on
        instance creation. You should use `sql.User` to define a custom user with
        a restricted host and strong password.

        > **Note**: On newer versions of the provider, you must explicitly set `deletion_protection=false`
        (and run `pulumi update` to write the field to state) in order to destroy an instance.
        It is recommended to not set this field (or set it to true) until you're ready to destroy the instance and its databases.

        ## Example Usage
        ### SQL Second Generation Instance

        ```python
        import pulumi
        import pulumi_gcp as gcp

        main = gcp.sql.DatabaseInstance("main",
            database_version="POSTGRES_15",
            region="us-central1",
            settings=gcp.sql.DatabaseInstanceSettingsArgs(
                tier="db-f1-micro",
            ))
        ```
        ### Private IP Instance
        > **NOTE:** For private IP instance setup, note that the `sql.DatabaseInstance` does not actually interpolate values from `servicenetworking.Connection`. You must explicitly add a `depends_on`reference as shown below.

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_random as random

        private_network = gcp.compute.Network("privateNetwork", opts=pulumi.ResourceOptions(provider=google_beta))
        private_ip_address = gcp.compute.GlobalAddress("privateIpAddress",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=private_network.id,
            opts=pulumi.ResourceOptions(provider=google_beta))
        private_vpc_connection = gcp.servicenetworking.Connection("privateVpcConnection",
            network=private_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[private_ip_address.name],
            opts=pulumi.ResourceOptions(provider=google_beta))
        db_name_suffix = random.RandomId("dbNameSuffix", byte_length=4)
        instance = gcp.sql.DatabaseInstance("instance",
            region="us-central1",
            database_version="MYSQL_5_7",
            settings=gcp.sql.DatabaseInstanceSettingsArgs(
                tier="db-f1-micro",
                ip_configuration=gcp.sql.DatabaseInstanceSettingsIpConfigurationArgs(
                    ipv4_enabled=False,
                    private_network=private_network.id,
                    enable_private_path_for_google_cloud_services=True,
                ),
            ),
            opts=pulumi.ResourceOptions(provider=google_beta,
                depends_on=[private_vpc_connection]))
        ```
        ### ENTERPRISE_PLUS Instance with data_cache_config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        main = gcp.sql.DatabaseInstance("main",
            database_version="MYSQL_8_0_31",
            settings=gcp.sql.DatabaseInstanceSettingsArgs(
                data_cache_config=gcp.sql.DatabaseInstanceSettingsDataCacheConfigArgs(
                    data_cache_enabled=True,
                ),
                edition="ENTERPRISE_PLUS",
                tier="db-perf-optimized-N-2",
            ))
        ```

        ## Import

        Database instances can be imported using one of any of these accepted formats

        ```sh
         $ pulumi import gcp:sql/databaseInstance:DatabaseInstance main projects/{{project}}/instances/{{name}}
        ```

        ```sh
         $ pulumi import gcp:sql/databaseInstance:DatabaseInstance main {{project}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:sql/databaseInstance:DatabaseInstance main {{name}}
        ```

         config and set on the server. When importing, double-check that your config has all the fields set that you expect- just seeing no diff isn't sufficient to know that your config could reproduce the imported resource.

        :param str resource_name: The name of the resource.
        :param DatabaseInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 clone: Optional[pulumi.Input[pulumi.InputType['DatabaseInstanceCloneArgs']]] = None,
                 database_version: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 encryption_key_name: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 maintenance_version: Optional[pulumi.Input[str]] = None,
                 master_instance_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 replica_configuration: Optional[pulumi.Input[pulumi.InputType['DatabaseInstanceReplicaConfigurationArgs']]] = None,
                 restore_backup_context: Optional[pulumi.Input[pulumi.InputType['DatabaseInstanceRestoreBackupContextArgs']]] = None,
                 root_password: Optional[pulumi.Input[str]] = None,
                 settings: Optional[pulumi.Input[pulumi.InputType['DatabaseInstanceSettingsArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseInstanceArgs.__new__(DatabaseInstanceArgs)

            __props__.__dict__["clone"] = clone
            if database_version is None and not opts.urn:
                raise TypeError("Missing required property 'database_version'")
            __props__.__dict__["database_version"] = database_version
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["encryption_key_name"] = encryption_key_name
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["maintenance_version"] = maintenance_version
            __props__.__dict__["master_instance_name"] = master_instance_name
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["region"] = region
            __props__.__dict__["replica_configuration"] = replica_configuration
            __props__.__dict__["restore_backup_context"] = restore_backup_context
            __props__.__dict__["root_password"] = None if root_password is None else pulumi.Output.secret(root_password)
            __props__.__dict__["settings"] = settings
            __props__.__dict__["available_maintenance_versions"] = None
            __props__.__dict__["connection_name"] = None
            __props__.__dict__["first_ip_address"] = None
            __props__.__dict__["ip_addresses"] = None
            __props__.__dict__["private_ip_address"] = None
            __props__.__dict__["public_ip_address"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["server_ca_certs"] = None
            __props__.__dict__["service_account_email_address"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["rootPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(DatabaseInstance, __self__).__init__(
            'gcp:sql/databaseInstance:DatabaseInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            available_maintenance_versions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            clone: Optional[pulumi.Input[pulumi.InputType['DatabaseInstanceCloneArgs']]] = None,
            connection_name: Optional[pulumi.Input[str]] = None,
            database_version: Optional[pulumi.Input[str]] = None,
            deletion_protection: Optional[pulumi.Input[bool]] = None,
            encryption_key_name: Optional[pulumi.Input[str]] = None,
            first_ip_address: Optional[pulumi.Input[str]] = None,
            instance_type: Optional[pulumi.Input[str]] = None,
            ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatabaseInstanceIpAddressArgs']]]]] = None,
            maintenance_version: Optional[pulumi.Input[str]] = None,
            master_instance_name: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            private_ip_address: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            public_ip_address: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            replica_configuration: Optional[pulumi.Input[pulumi.InputType['DatabaseInstanceReplicaConfigurationArgs']]] = None,
            restore_backup_context: Optional[pulumi.Input[pulumi.InputType['DatabaseInstanceRestoreBackupContextArgs']]] = None,
            root_password: Optional[pulumi.Input[str]] = None,
            self_link: Optional[pulumi.Input[str]] = None,
            server_ca_certs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatabaseInstanceServerCaCertArgs']]]]] = None,
            service_account_email_address: Optional[pulumi.Input[str]] = None,
            settings: Optional[pulumi.Input[pulumi.InputType['DatabaseInstanceSettingsArgs']]] = None) -> 'DatabaseInstance':
        """
        Get an existing DatabaseInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] available_maintenance_versions: The list of all maintenance versions applicable on the instance.
        :param pulumi.Input[pulumi.InputType['DatabaseInstanceCloneArgs']] clone: The context needed to create this instance as a clone of another instance. When this field is set during
               resource creation, this provider will attempt to clone another instance as indicated in the context. The
               configuration is detailed below.
        :param pulumi.Input[str] connection_name: The connection name of the instance to be used in
               connection strings. For example, when connecting with [Cloud SQL Proxy](https://cloud.google.com/sql/docs/mysql/connect-admin-proxy).
        :param pulumi.Input[str] database_version: The MySQL, PostgreSQL or
               SQL Server version to use. Supported values include `MYSQL_5_6`,
               `MYSQL_5_7`, `MYSQL_8_0`, `POSTGRES_9_6`,`POSTGRES_10`, `POSTGRES_11`,
               `POSTGRES_12`, `POSTGRES_13`, `POSTGRES_14`, `POSTGRES_15`, `SQLSERVER_2017_STANDARD`,
               `SQLSERVER_2017_ENTERPRISE`, `SQLSERVER_2017_EXPRESS`, `SQLSERVER_2017_WEB`.
               `SQLSERVER_2019_STANDARD`, `SQLSERVER_2019_ENTERPRISE`, `SQLSERVER_2019_EXPRESS`,
               `SQLSERVER_2019_WEB`.
               [Database Version Policies](https://cloud.google.com/sql/docs/db-versions)
               includes an up-to-date reference of supported versions.
        :param pulumi.Input[bool] deletion_protection: Whether or not to allow the provider to destroy the instance. Unless this field is set to false
               in state, a `destroy` or `update` command that deletes the instance will fail. Defaults to `true`.
        :param pulumi.Input[str] encryption_key_name: The full path to the encryption key used for the CMEK disk encryption.  Setting
               up disk encryption currently requires manual steps outside of this provider.
               The provided key must be in the same region as the SQL instance.  In order
               to use this feature, a special kind of service account must be created and
               granted permission on this key.  This step can currently only be done
               manually, please see [this step](https://cloud.google.com/sql/docs/mysql/configure-cmek#service-account).
               That service account needs the `Cloud KMS > Cloud KMS CryptoKey Encrypter/Decrypter` role on your
               key - please see [this step](https://cloud.google.com/sql/docs/mysql/configure-cmek#grantkey).
        :param pulumi.Input[str] first_ip_address: The first IPv4 address of any type assigned.
        :param pulumi.Input[str] instance_type: The type of the instance. The supported values are `SQL_INSTANCE_TYPE_UNSPECIFIED`, `CLOUD_SQL_INSTANCE`, `ON_PREMISES_INSTANCE` and `READ_REPLICA_INSTANCE`.
        :param pulumi.Input[str] maintenance_version: The current software version on the instance. This attribute can not be set during creation. Refer to `available_maintenance_versions` attribute to see what `maintenance_version` are available for upgrade. When this attribute gets updated, it will cause an instance restart. Setting a `maintenance_version` value that is older than the current one on the instance will be ignored.
        :param pulumi.Input[str] master_instance_name: The name of the existing instance that will
               act as the master in the replication setup. Note, this requires the master to
               have `binary_log_enabled` set, as well as existing backups.
        :param pulumi.Input[str] name: The name of the instance. If the name is left
               blank, the provider will randomly generate one when the instance is first
               created. This is done because after a name is used, it cannot be reused for
               up to [one week](https://cloud.google.com/sql/docs/delete-instance).
        :param pulumi.Input[str] private_ip_address: The first private (`PRIVATE`) IPv4 address assigned.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[str] public_ip_address: The first public (`PRIMARY`) IPv4 address assigned.
        :param pulumi.Input[str] region: The region the instance will sit in. If a region is not provided in the resource definition,
               the provider region will be used instead.
               
               - - -
        :param pulumi.Input[pulumi.InputType['DatabaseInstanceReplicaConfigurationArgs']] replica_configuration: The configuration for replication. The
               configuration is detailed below. Valid only for MySQL instances.
        :param pulumi.Input[pulumi.InputType['DatabaseInstanceRestoreBackupContextArgs']] restore_backup_context: The context needed to restore the database to a backup run. This field will
               cause the provider to trigger the database to restore from the backup run indicated. The configuration is detailed below.
               **NOTE:** Restoring from a backup is an imperative action and not recommended via this provider. Adding or modifying this
               block during resource creation/update will trigger the restore action after the resource is created/updated.
        :param pulumi.Input[str] root_password: Initial root password. Can be updated. Required for MS SQL Server.
        :param pulumi.Input[str] self_link: The URI of the created resource.
        :param pulumi.Input[str] service_account_email_address: The service account email address assigned to the
               instance.
        :param pulumi.Input[pulumi.InputType['DatabaseInstanceSettingsArgs']] settings: The settings to use for the database. The
               configuration is detailed below. Required if `clone` is not set.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabaseInstanceState.__new__(_DatabaseInstanceState)

        __props__.__dict__["available_maintenance_versions"] = available_maintenance_versions
        __props__.__dict__["clone"] = clone
        __props__.__dict__["connection_name"] = connection_name
        __props__.__dict__["database_version"] = database_version
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["encryption_key_name"] = encryption_key_name
        __props__.__dict__["first_ip_address"] = first_ip_address
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["ip_addresses"] = ip_addresses
        __props__.__dict__["maintenance_version"] = maintenance_version
        __props__.__dict__["master_instance_name"] = master_instance_name
        __props__.__dict__["name"] = name
        __props__.__dict__["private_ip_address"] = private_ip_address
        __props__.__dict__["project"] = project
        __props__.__dict__["public_ip_address"] = public_ip_address
        __props__.__dict__["region"] = region
        __props__.__dict__["replica_configuration"] = replica_configuration
        __props__.__dict__["restore_backup_context"] = restore_backup_context
        __props__.__dict__["root_password"] = root_password
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["server_ca_certs"] = server_ca_certs
        __props__.__dict__["service_account_email_address"] = service_account_email_address
        __props__.__dict__["settings"] = settings
        return DatabaseInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="availableMaintenanceVersions")
    def available_maintenance_versions(self) -> pulumi.Output[Sequence[str]]:
        """
        The list of all maintenance versions applicable on the instance.
        """
        return pulumi.get(self, "available_maintenance_versions")

    @property
    @pulumi.getter
    def clone(self) -> pulumi.Output[Optional['outputs.DatabaseInstanceClone']]:
        """
        The context needed to create this instance as a clone of another instance. When this field is set during
        resource creation, this provider will attempt to clone another instance as indicated in the context. The
        configuration is detailed below.
        """
        return pulumi.get(self, "clone")

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> pulumi.Output[str]:
        """
        The connection name of the instance to be used in
        connection strings. For example, when connecting with [Cloud SQL Proxy](https://cloud.google.com/sql/docs/mysql/connect-admin-proxy).
        """
        return pulumi.get(self, "connection_name")

    @property
    @pulumi.getter(name="databaseVersion")
    def database_version(self) -> pulumi.Output[str]:
        """
        The MySQL, PostgreSQL or
        SQL Server version to use. Supported values include `MYSQL_5_6`,
        `MYSQL_5_7`, `MYSQL_8_0`, `POSTGRES_9_6`,`POSTGRES_10`, `POSTGRES_11`,
        `POSTGRES_12`, `POSTGRES_13`, `POSTGRES_14`, `POSTGRES_15`, `SQLSERVER_2017_STANDARD`,
        `SQLSERVER_2017_ENTERPRISE`, `SQLSERVER_2017_EXPRESS`, `SQLSERVER_2017_WEB`.
        `SQLSERVER_2019_STANDARD`, `SQLSERVER_2019_ENTERPRISE`, `SQLSERVER_2019_EXPRESS`,
        `SQLSERVER_2019_WEB`.
        [Database Version Policies](https://cloud.google.com/sql/docs/db-versions)
        includes an up-to-date reference of supported versions.
        """
        return pulumi.get(self, "database_version")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not to allow the provider to destroy the instance. Unless this field is set to false
        in state, a `destroy` or `update` command that deletes the instance will fail. Defaults to `true`.
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter(name="encryptionKeyName")
    def encryption_key_name(self) -> pulumi.Output[str]:
        """
        The full path to the encryption key used for the CMEK disk encryption.  Setting
        up disk encryption currently requires manual steps outside of this provider.
        The provided key must be in the same region as the SQL instance.  In order
        to use this feature, a special kind of service account must be created and
        granted permission on this key.  This step can currently only be done
        manually, please see [this step](https://cloud.google.com/sql/docs/mysql/configure-cmek#service-account).
        That service account needs the `Cloud KMS > Cloud KMS CryptoKey Encrypter/Decrypter` role on your
        key - please see [this step](https://cloud.google.com/sql/docs/mysql/configure-cmek#grantkey).
        """
        return pulumi.get(self, "encryption_key_name")

    @property
    @pulumi.getter(name="firstIpAddress")
    def first_ip_address(self) -> pulumi.Output[str]:
        """
        The first IPv4 address of any type assigned.
        """
        return pulumi.get(self, "first_ip_address")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[str]:
        """
        The type of the instance. The supported values are `SQL_INSTANCE_TYPE_UNSPECIFIED`, `CLOUD_SQL_INSTANCE`, `ON_PREMISES_INSTANCE` and `READ_REPLICA_INSTANCE`.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> pulumi.Output[Sequence['outputs.DatabaseInstanceIpAddress']]:
        return pulumi.get(self, "ip_addresses")

    @property
    @pulumi.getter(name="maintenanceVersion")
    def maintenance_version(self) -> pulumi.Output[str]:
        """
        The current software version on the instance. This attribute can not be set during creation. Refer to `available_maintenance_versions` attribute to see what `maintenance_version` are available for upgrade. When this attribute gets updated, it will cause an instance restart. Setting a `maintenance_version` value that is older than the current one on the instance will be ignored.
        """
        return pulumi.get(self, "maintenance_version")

    @property
    @pulumi.getter(name="masterInstanceName")
    def master_instance_name(self) -> pulumi.Output[str]:
        """
        The name of the existing instance that will
        act as the master in the replication setup. Note, this requires the master to
        have `binary_log_enabled` set, as well as existing backups.
        """
        return pulumi.get(self, "master_instance_name")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the instance. If the name is left
        blank, the provider will randomly generate one when the instance is first
        created. This is done because after a name is used, it cannot be reused for
        up to [one week](https://cloud.google.com/sql/docs/delete-instance).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> pulumi.Output[str]:
        """
        The first private (`PRIVATE`) IPv4 address assigned.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> pulumi.Output[str]:
        """
        The first public (`PRIMARY`) IPv4 address assigned.
        """
        return pulumi.get(self, "public_ip_address")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region the instance will sit in. If a region is not provided in the resource definition,
        the provider region will be used instead.

        - - -
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="replicaConfiguration")
    def replica_configuration(self) -> pulumi.Output['outputs.DatabaseInstanceReplicaConfiguration']:
        """
        The configuration for replication. The
        configuration is detailed below. Valid only for MySQL instances.
        """
        return pulumi.get(self, "replica_configuration")

    @property
    @pulumi.getter(name="restoreBackupContext")
    def restore_backup_context(self) -> pulumi.Output[Optional['outputs.DatabaseInstanceRestoreBackupContext']]:
        """
        The context needed to restore the database to a backup run. This field will
        cause the provider to trigger the database to restore from the backup run indicated. The configuration is detailed below.
        **NOTE:** Restoring from a backup is an imperative action and not recommended via this provider. Adding or modifying this
        block during resource creation/update will trigger the restore action after the resource is created/updated.
        """
        return pulumi.get(self, "restore_backup_context")

    @property
    @pulumi.getter(name="rootPassword")
    def root_password(self) -> pulumi.Output[Optional[str]]:
        """
        Initial root password. Can be updated. Required for MS SQL Server.
        """
        return pulumi.get(self, "root_password")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="serverCaCerts")
    def server_ca_certs(self) -> pulumi.Output[Sequence['outputs.DatabaseInstanceServerCaCert']]:
        return pulumi.get(self, "server_ca_certs")

    @property
    @pulumi.getter(name="serviceAccountEmailAddress")
    def service_account_email_address(self) -> pulumi.Output[str]:
        """
        The service account email address assigned to the
        instance.
        """
        return pulumi.get(self, "service_account_email_address")

    @property
    @pulumi.getter
    def settings(self) -> pulumi.Output['outputs.DatabaseInstanceSettings']:
        """
        The settings to use for the database. The
        configuration is detailed below. Required if `clone` is not set.
        """
        return pulumi.get(self, "settings")

