# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'BucketAutoclass',
    'BucketCor',
    'BucketCustomPlacementConfig',
    'BucketEncryption',
    'BucketIAMBindingCondition',
    'BucketIAMMemberCondition',
    'BucketLifecycleRule',
    'BucketLifecycleRuleAction',
    'BucketLifecycleRuleCondition',
    'BucketLogging',
    'BucketObjectCustomerEncryption',
    'BucketRetentionPolicy',
    'BucketVersioning',
    'BucketWebsite',
    'DefaultObjectAccessControlProjectTeam',
    'ObjectAccessControlProjectTeam',
    'TransferAgentPoolBandwidthLimit',
    'TransferJobNotificationConfig',
    'TransferJobSchedule',
    'TransferJobScheduleScheduleEndDate',
    'TransferJobScheduleScheduleStartDate',
    'TransferJobScheduleStartTimeOfDay',
    'TransferJobTransferSpec',
    'TransferJobTransferSpecAwsS3DataSource',
    'TransferJobTransferSpecAwsS3DataSourceAwsAccessKey',
    'TransferJobTransferSpecAzureBlobStorageDataSource',
    'TransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentials',
    'TransferJobTransferSpecGcsDataSink',
    'TransferJobTransferSpecGcsDataSource',
    'TransferJobTransferSpecHttpDataSource',
    'TransferJobTransferSpecObjectConditions',
    'TransferJobTransferSpecPosixDataSink',
    'TransferJobTransferSpecPosixDataSource',
    'TransferJobTransferSpecTransferOptions',
    'GetBucketAutoclassResult',
    'GetBucketCorResult',
    'GetBucketCustomPlacementConfigResult',
    'GetBucketEncryptionResult',
    'GetBucketLifecycleRuleResult',
    'GetBucketLifecycleRuleActionResult',
    'GetBucketLifecycleRuleConditionResult',
    'GetBucketLoggingResult',
    'GetBucketObjectContentCustomerEncryptionResult',
    'GetBucketObjectCustomerEncryptionResult',
    'GetBucketRetentionPolicyResult',
    'GetBucketVersioningResult',
    'GetBucketWebsiteResult',
]

@pulumi.output_type
class BucketAutoclass(dict):
    def __init__(__self__, *,
                 enabled: bool):
        """
        :param bool enabled: While set to `true`, autoclass automatically transitions objects in your bucket to appropriate storage classes based on each object's access pattern.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        While set to `true`, autoclass automatically transitions objects in your bucket to appropriate storage classes based on each object's access pattern.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class BucketCor(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxAgeSeconds":
            suggest = "max_age_seconds"
        elif key == "responseHeaders":
            suggest = "response_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketCor. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketCor.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketCor.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_age_seconds: Optional[int] = None,
                 methods: Optional[Sequence[str]] = None,
                 origins: Optional[Sequence[str]] = None,
                 response_headers: Optional[Sequence[str]] = None):
        """
        :param int max_age_seconds: The value, in seconds, to return in the [Access-Control-Max-Age header](https://www.w3.org/TR/cors/#access-control-max-age-response-header) used in preflight responses.
        :param Sequence[str] methods: The list of HTTP methods on which to include CORS response headers, (GET, OPTIONS, POST, etc) Note: "*" is permitted in the list of methods, and means "any method".
        :param Sequence[str] origins: The list of [Origins](https://tools.ietf.org/html/rfc6454) eligible to receive CORS response headers. Note: "*" is permitted in the list of origins, and means "any Origin".
        :param Sequence[str] response_headers: The list of HTTP headers other than the [simple response headers](https://www.w3.org/TR/cors/#simple-response-header) to give permission for the user-agent to share across domains.
        """
        if max_age_seconds is not None:
            pulumi.set(__self__, "max_age_seconds", max_age_seconds)
        if methods is not None:
            pulumi.set(__self__, "methods", methods)
        if origins is not None:
            pulumi.set(__self__, "origins", origins)
        if response_headers is not None:
            pulumi.set(__self__, "response_headers", response_headers)

    @property
    @pulumi.getter(name="maxAgeSeconds")
    def max_age_seconds(self) -> Optional[int]:
        """
        The value, in seconds, to return in the [Access-Control-Max-Age header](https://www.w3.org/TR/cors/#access-control-max-age-response-header) used in preflight responses.
        """
        return pulumi.get(self, "max_age_seconds")

    @property
    @pulumi.getter
    def methods(self) -> Optional[Sequence[str]]:
        """
        The list of HTTP methods on which to include CORS response headers, (GET, OPTIONS, POST, etc) Note: "*" is permitted in the list of methods, and means "any method".
        """
        return pulumi.get(self, "methods")

    @property
    @pulumi.getter
    def origins(self) -> Optional[Sequence[str]]:
        """
        The list of [Origins](https://tools.ietf.org/html/rfc6454) eligible to receive CORS response headers. Note: "*" is permitted in the list of origins, and means "any Origin".
        """
        return pulumi.get(self, "origins")

    @property
    @pulumi.getter(name="responseHeaders")
    def response_headers(self) -> Optional[Sequence[str]]:
        """
        The list of HTTP headers other than the [simple response headers](https://www.w3.org/TR/cors/#simple-response-header) to give permission for the user-agent to share across domains.
        """
        return pulumi.get(self, "response_headers")


@pulumi.output_type
class BucketCustomPlacementConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataLocations":
            suggest = "data_locations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketCustomPlacementConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketCustomPlacementConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketCustomPlacementConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_locations: Sequence[str]):
        """
        :param Sequence[str] data_locations: The list of individual regions that comprise a dual-region bucket. See [Cloud Storage bucket locations](https://cloud.google.com/storage/docs/dual-regions#availability) for a list of acceptable regions. **Note**: If any of the data_locations changes, it will [recreate the bucket](https://cloud.google.com/storage/docs/locations#key-concepts).
        """
        pulumi.set(__self__, "data_locations", data_locations)

    @property
    @pulumi.getter(name="dataLocations")
    def data_locations(self) -> Sequence[str]:
        """
        The list of individual regions that comprise a dual-region bucket. See [Cloud Storage bucket locations](https://cloud.google.com/storage/docs/dual-regions#availability) for a list of acceptable regions. **Note**: If any of the data_locations changes, it will [recreate the bucket](https://cloud.google.com/storage/docs/locations#key-concepts).
        """
        return pulumi.get(self, "data_locations")


@pulumi.output_type
class BucketEncryption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultKmsKeyName":
            suggest = "default_kms_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_kms_key_name: str):
        """
        :param str default_kms_key_name: The `id` of a Cloud KMS key that will be used to encrypt objects inserted into this bucket, if no encryption method is specified.
               You must pay attention to whether the crypto key is available in the location that this bucket is created in.
               See [the docs](https://cloud.google.com/storage/docs/encryption/using-customer-managed-keys) for more details.
               
               > As per [the docs](https://cloud.google.com/storage/docs/encryption/using-customer-managed-keys) for customer-managed encryption keys, the IAM policy for the
               specified key must permit the [automatic Google Cloud Storage service account](https://cloud.google.com/storage/docs/projects#service-accounts) for the bucket's
               project to use the specified key for encryption and decryption operations.
               Although the service account email address follows a well-known format, the service account is created on-demand and may not necessarily exist for your project
               until a relevant action has occurred which triggers its creation.
               You should use the [`storage_get_project_service_account`](https://www.terraform.io/docs/providers/google/d/storage_project_service_account.html) data source to obtain the email
               address for the service account when configuring IAM policy on the Cloud KMS key.
               This data source calls an API which creates the account if required, ensuring your provider applies cleanly and repeatedly irrespective of the
               state of the project.
               You should take care for race conditions when the same provider manages IAM policy on the Cloud KMS crypto key. See the data source page for more details.
        """
        pulumi.set(__self__, "default_kms_key_name", default_kms_key_name)

    @property
    @pulumi.getter(name="defaultKmsKeyName")
    def default_kms_key_name(self) -> str:
        """
        The `id` of a Cloud KMS key that will be used to encrypt objects inserted into this bucket, if no encryption method is specified.
        You must pay attention to whether the crypto key is available in the location that this bucket is created in.
        See [the docs](https://cloud.google.com/storage/docs/encryption/using-customer-managed-keys) for more details.

        > As per [the docs](https://cloud.google.com/storage/docs/encryption/using-customer-managed-keys) for customer-managed encryption keys, the IAM policy for the
        specified key must permit the [automatic Google Cloud Storage service account](https://cloud.google.com/storage/docs/projects#service-accounts) for the bucket's
        project to use the specified key for encryption and decryption operations.
        Although the service account email address follows a well-known format, the service account is created on-demand and may not necessarily exist for your project
        until a relevant action has occurred which triggers its creation.
        You should use the [`storage_get_project_service_account`](https://www.terraform.io/docs/providers/google/d/storage_project_service_account.html) data source to obtain the email
        address for the service account when configuring IAM policy on the Cloud KMS key.
        This data source calls an API which creates the account if required, ensuring your provider applies cleanly and repeatedly irrespective of the
        state of the project.
        You should take care for race conditions when the same provider manages IAM policy on the Cloud KMS crypto key. See the data source page for more details.
        """
        return pulumi.get(self, "default_kms_key_name")


@pulumi.output_type
class BucketIAMBindingCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        """
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str title: A title for the expression, i.e. a short string describing its purpose.
        :param str description: An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
               
               > **Warning:** This provider considers the `role` and condition contents (`title`+`description`+`expression`) as the
               identifier for the binding. This means that if any part of the condition is changed out-of-band, the provider will
               consider it to be an entirely different resource and will treat it as such.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.

        > **Warning:** This provider considers the `role` and condition contents (`title`+`description`+`expression`) as the
        identifier for the binding. This means that if any part of the condition is changed out-of-band, the provider will
        consider it to be an entirely different resource and will treat it as such.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class BucketIAMMemberCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        """
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str title: A title for the expression, i.e. a short string describing its purpose.
        :param str description: An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
               
               > **Warning:** This provider considers the `role` and condition contents (`title`+`description`+`expression`) as the
               identifier for the binding. This means that if any part of the condition is changed out-of-band, the provider will
               consider it to be an entirely different resource and will treat it as such.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.

        > **Warning:** This provider considers the `role` and condition contents (`title`+`description`+`expression`) as the
        identifier for the binding. This means that if any part of the condition is changed out-of-band, the provider will
        consider it to be an entirely different resource and will treat it as such.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class BucketLifecycleRule(dict):
    def __init__(__self__, *,
                 action: 'outputs.BucketLifecycleRuleAction',
                 condition: 'outputs.BucketLifecycleRuleCondition'):
        """
        :param 'BucketLifecycleRuleActionArgs' action: The Lifecycle Rule's action configuration. A single block of this type is supported. Structure is documented below.
        :param 'BucketLifecycleRuleConditionArgs' condition: The Lifecycle Rule's condition configuration. A single block of this type is supported. Structure is documented below.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "condition", condition)

    @property
    @pulumi.getter
    def action(self) -> 'outputs.BucketLifecycleRuleAction':
        """
        The Lifecycle Rule's action configuration. A single block of this type is supported. Structure is documented below.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.BucketLifecycleRuleCondition':
        """
        The Lifecycle Rule's condition configuration. A single block of this type is supported. Structure is documented below.
        """
        return pulumi.get(self, "condition")


@pulumi.output_type
class BucketLifecycleRuleAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageClass":
            suggest = "storage_class"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLifecycleRuleAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLifecycleRuleAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLifecycleRuleAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 storage_class: Optional[str] = None):
        """
        :param str type: The type of the action of this Lifecycle Rule. Supported values include: `Delete`, `SetStorageClass` and `AbortIncompleteMultipartUpload`.
        :param str storage_class: The target [Storage Class](https://cloud.google.com/storage/docs/storage-classes) of objects affected by this Lifecycle Rule. Supported values include: `STANDARD`, `MULTI_REGIONAL`, `REGIONAL`, `NEARLINE`, `COLDLINE`, `ARCHIVE`.
        """
        pulumi.set(__self__, "type", type)
        if storage_class is not None:
            pulumi.set(__self__, "storage_class", storage_class)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the action of this Lifecycle Rule. Supported values include: `Delete`, `SetStorageClass` and `AbortIncompleteMultipartUpload`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> Optional[str]:
        """
        The target [Storage Class](https://cloud.google.com/storage/docs/storage-classes) of objects affected by this Lifecycle Rule. Supported values include: `STANDARD`, `MULTI_REGIONAL`, `REGIONAL`, `NEARLINE`, `COLDLINE`, `ARCHIVE`.
        """
        return pulumi.get(self, "storage_class")


@pulumi.output_type
class BucketLifecycleRuleCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdBefore":
            suggest = "created_before"
        elif key == "customTimeBefore":
            suggest = "custom_time_before"
        elif key == "daysSinceCustomTime":
            suggest = "days_since_custom_time"
        elif key == "daysSinceNoncurrentTime":
            suggest = "days_since_noncurrent_time"
        elif key == "matchesPrefixes":
            suggest = "matches_prefixes"
        elif key == "matchesStorageClasses":
            suggest = "matches_storage_classes"
        elif key == "matchesSuffixes":
            suggest = "matches_suffixes"
        elif key == "noncurrentTimeBefore":
            suggest = "noncurrent_time_before"
        elif key == "numNewerVersions":
            suggest = "num_newer_versions"
        elif key == "withState":
            suggest = "with_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLifecycleRuleCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLifecycleRuleCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLifecycleRuleCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 age: Optional[int] = None,
                 created_before: Optional[str] = None,
                 custom_time_before: Optional[str] = None,
                 days_since_custom_time: Optional[int] = None,
                 days_since_noncurrent_time: Optional[int] = None,
                 matches_prefixes: Optional[Sequence[str]] = None,
                 matches_storage_classes: Optional[Sequence[str]] = None,
                 matches_suffixes: Optional[Sequence[str]] = None,
                 noncurrent_time_before: Optional[str] = None,
                 num_newer_versions: Optional[int] = None,
                 with_state: Optional[str] = None):
        """
        :param int age: Minimum age of an object in days to satisfy this condition.
        :param str created_before: A date in the RFC 3339 format YYYY-MM-DD. This condition is satisfied when an object is created before midnight of the specified date in UTC.
        :param str custom_time_before: A date in the RFC 3339 format YYYY-MM-DD. This condition is satisfied when the customTime metadata for the object is set to an earlier date than the date used in this lifecycle condition.
        :param int days_since_custom_time: Days since the date set in the `customTime` metadata for the object. This condition is satisfied when the current date and time is at least the specified number of days after the `customTime`.
        :param int days_since_noncurrent_time: Relevant only for versioned objects. Number of days elapsed since the noncurrent timestamp of an object.
        :param Sequence[str] matches_prefixes: One or more matching name prefixes to satisfy this condition.
        :param Sequence[str] matches_storage_classes: [Storage Class](https://cloud.google.com/storage/docs/storage-classes) of objects to satisfy this condition. Supported values include: `STANDARD`, `MULTI_REGIONAL`, `REGIONAL`, `NEARLINE`, `COLDLINE`, `ARCHIVE`, `DURABLE_REDUCED_AVAILABILITY`.
        :param Sequence[str] matches_suffixes: One or more matching name suffixes to satisfy this condition.
        :param str noncurrent_time_before: Relevant only for versioned objects. The date in RFC 3339 (e.g. `2017-06-13`) when the object became nonconcurrent.
        :param int num_newer_versions: Relevant only for versioned objects. The number of newer versions of an object to satisfy this condition.
        :param str with_state: Match to live and/or archived objects. Unversioned buckets have only live objects. Supported values include: `"LIVE"`, `"ARCHIVED"`, `"ANY"`.
        """
        if age is not None:
            pulumi.set(__self__, "age", age)
        if created_before is not None:
            pulumi.set(__self__, "created_before", created_before)
        if custom_time_before is not None:
            pulumi.set(__self__, "custom_time_before", custom_time_before)
        if days_since_custom_time is not None:
            pulumi.set(__self__, "days_since_custom_time", days_since_custom_time)
        if days_since_noncurrent_time is not None:
            pulumi.set(__self__, "days_since_noncurrent_time", days_since_noncurrent_time)
        if matches_prefixes is not None:
            pulumi.set(__self__, "matches_prefixes", matches_prefixes)
        if matches_storage_classes is not None:
            pulumi.set(__self__, "matches_storage_classes", matches_storage_classes)
        if matches_suffixes is not None:
            pulumi.set(__self__, "matches_suffixes", matches_suffixes)
        if noncurrent_time_before is not None:
            pulumi.set(__self__, "noncurrent_time_before", noncurrent_time_before)
        if num_newer_versions is not None:
            pulumi.set(__self__, "num_newer_versions", num_newer_versions)
        if with_state is not None:
            pulumi.set(__self__, "with_state", with_state)

    @property
    @pulumi.getter
    def age(self) -> Optional[int]:
        """
        Minimum age of an object in days to satisfy this condition.
        """
        return pulumi.get(self, "age")

    @property
    @pulumi.getter(name="createdBefore")
    def created_before(self) -> Optional[str]:
        """
        A date in the RFC 3339 format YYYY-MM-DD. This condition is satisfied when an object is created before midnight of the specified date in UTC.
        """
        return pulumi.get(self, "created_before")

    @property
    @pulumi.getter(name="customTimeBefore")
    def custom_time_before(self) -> Optional[str]:
        """
        A date in the RFC 3339 format YYYY-MM-DD. This condition is satisfied when the customTime metadata for the object is set to an earlier date than the date used in this lifecycle condition.
        """
        return pulumi.get(self, "custom_time_before")

    @property
    @pulumi.getter(name="daysSinceCustomTime")
    def days_since_custom_time(self) -> Optional[int]:
        """
        Days since the date set in the `customTime` metadata for the object. This condition is satisfied when the current date and time is at least the specified number of days after the `customTime`.
        """
        return pulumi.get(self, "days_since_custom_time")

    @property
    @pulumi.getter(name="daysSinceNoncurrentTime")
    def days_since_noncurrent_time(self) -> Optional[int]:
        """
        Relevant only for versioned objects. Number of days elapsed since the noncurrent timestamp of an object.
        """
        return pulumi.get(self, "days_since_noncurrent_time")

    @property
    @pulumi.getter(name="matchesPrefixes")
    def matches_prefixes(self) -> Optional[Sequence[str]]:
        """
        One or more matching name prefixes to satisfy this condition.
        """
        return pulumi.get(self, "matches_prefixes")

    @property
    @pulumi.getter(name="matchesStorageClasses")
    def matches_storage_classes(self) -> Optional[Sequence[str]]:
        """
        [Storage Class](https://cloud.google.com/storage/docs/storage-classes) of objects to satisfy this condition. Supported values include: `STANDARD`, `MULTI_REGIONAL`, `REGIONAL`, `NEARLINE`, `COLDLINE`, `ARCHIVE`, `DURABLE_REDUCED_AVAILABILITY`.
        """
        return pulumi.get(self, "matches_storage_classes")

    @property
    @pulumi.getter(name="matchesSuffixes")
    def matches_suffixes(self) -> Optional[Sequence[str]]:
        """
        One or more matching name suffixes to satisfy this condition.
        """
        return pulumi.get(self, "matches_suffixes")

    @property
    @pulumi.getter(name="noncurrentTimeBefore")
    def noncurrent_time_before(self) -> Optional[str]:
        """
        Relevant only for versioned objects. The date in RFC 3339 (e.g. `2017-06-13`) when the object became nonconcurrent.
        """
        return pulumi.get(self, "noncurrent_time_before")

    @property
    @pulumi.getter(name="numNewerVersions")
    def num_newer_versions(self) -> Optional[int]:
        """
        Relevant only for versioned objects. The number of newer versions of an object to satisfy this condition.
        """
        return pulumi.get(self, "num_newer_versions")

    @property
    @pulumi.getter(name="withState")
    def with_state(self) -> Optional[str]:
        """
        Match to live and/or archived objects. Unversioned buckets have only live objects. Supported values include: `"LIVE"`, `"ARCHIVED"`, `"ANY"`.
        """
        return pulumi.get(self, "with_state")


@pulumi.output_type
class BucketLogging(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logBucket":
            suggest = "log_bucket"
        elif key == "logObjectPrefix":
            suggest = "log_object_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLogging. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLogging.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLogging.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_bucket: str,
                 log_object_prefix: Optional[str] = None):
        """
        :param str log_bucket: The bucket that will receive log objects.
        :param str log_object_prefix: The object prefix for log objects. If it's not provided,
               by default GCS sets this to this bucket's name.
        """
        pulumi.set(__self__, "log_bucket", log_bucket)
        if log_object_prefix is not None:
            pulumi.set(__self__, "log_object_prefix", log_object_prefix)

    @property
    @pulumi.getter(name="logBucket")
    def log_bucket(self) -> str:
        """
        The bucket that will receive log objects.
        """
        return pulumi.get(self, "log_bucket")

    @property
    @pulumi.getter(name="logObjectPrefix")
    def log_object_prefix(self) -> Optional[str]:
        """
        The object prefix for log objects. If it's not provided,
        by default GCS sets this to this bucket's name.
        """
        return pulumi.get(self, "log_object_prefix")


@pulumi.output_type
class BucketObjectCustomerEncryption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionKey":
            suggest = "encryption_key"
        elif key == "encryptionAlgorithm":
            suggest = "encryption_algorithm"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketObjectCustomerEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketObjectCustomerEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketObjectCustomerEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption_key: str,
                 encryption_algorithm: Optional[str] = None):
        """
        :param str encryption_key: Base64 encoded Customer-Supplied Encryption Key.
        :param str encryption_algorithm: Encryption algorithm. Default: AES256
        """
        pulumi.set(__self__, "encryption_key", encryption_key)
        if encryption_algorithm is not None:
            pulumi.set(__self__, "encryption_algorithm", encryption_algorithm)

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> str:
        """
        Base64 encoded Customer-Supplied Encryption Key.
        """
        return pulumi.get(self, "encryption_key")

    @property
    @pulumi.getter(name="encryptionAlgorithm")
    def encryption_algorithm(self) -> Optional[str]:
        """
        Encryption algorithm. Default: AES256
        """
        return pulumi.get(self, "encryption_algorithm")


@pulumi.output_type
class BucketRetentionPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retentionPeriod":
            suggest = "retention_period"
        elif key == "isLocked":
            suggest = "is_locked"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketRetentionPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketRetentionPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketRetentionPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 retention_period: int,
                 is_locked: Optional[bool] = None):
        """
        :param int retention_period: The period of time, in seconds, that objects in the bucket must be retained and cannot be deleted, overwritten, or archived. The value must be less than 2,147,483,647 seconds.
        :param bool is_locked: If set to `true`, the bucket will be [locked](https://cloud.google.com/storage/docs/using-bucket-lock#lock-bucket) and permanently restrict edits to the bucket's retention policy.  Caution: Locking a bucket is an irreversible action.
        """
        pulumi.set(__self__, "retention_period", retention_period)
        if is_locked is not None:
            pulumi.set(__self__, "is_locked", is_locked)

    @property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> int:
        """
        The period of time, in seconds, that objects in the bucket must be retained and cannot be deleted, overwritten, or archived. The value must be less than 2,147,483,647 seconds.
        """
        return pulumi.get(self, "retention_period")

    @property
    @pulumi.getter(name="isLocked")
    def is_locked(self) -> Optional[bool]:
        """
        If set to `true`, the bucket will be [locked](https://cloud.google.com/storage/docs/using-bucket-lock#lock-bucket) and permanently restrict edits to the bucket's retention policy.  Caution: Locking a bucket is an irreversible action.
        """
        return pulumi.get(self, "is_locked")


@pulumi.output_type
class BucketVersioning(dict):
    def __init__(__self__, *,
                 enabled: bool):
        """
        :param bool enabled: While set to `true`, versioning is fully enabled for this bucket.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        While set to `true`, versioning is fully enabled for this bucket.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class BucketWebsite(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mainPageSuffix":
            suggest = "main_page_suffix"
        elif key == "notFoundPage":
            suggest = "not_found_page"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketWebsite. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketWebsite.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketWebsite.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 main_page_suffix: Optional[str] = None,
                 not_found_page: Optional[str] = None):
        """
        :param str main_page_suffix: Behaves as the bucket's directory index where
               missing objects are treated as potential directories.
        :param str not_found_page: The custom object to return when a requested
               resource is not found.
        """
        if main_page_suffix is not None:
            pulumi.set(__self__, "main_page_suffix", main_page_suffix)
        if not_found_page is not None:
            pulumi.set(__self__, "not_found_page", not_found_page)

    @property
    @pulumi.getter(name="mainPageSuffix")
    def main_page_suffix(self) -> Optional[str]:
        """
        Behaves as the bucket's directory index where
        missing objects are treated as potential directories.
        """
        return pulumi.get(self, "main_page_suffix")

    @property
    @pulumi.getter(name="notFoundPage")
    def not_found_page(self) -> Optional[str]:
        """
        The custom object to return when a requested
        resource is not found.
        """
        return pulumi.get(self, "not_found_page")


@pulumi.output_type
class DefaultObjectAccessControlProjectTeam(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectNumber":
            suggest = "project_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DefaultObjectAccessControlProjectTeam. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DefaultObjectAccessControlProjectTeam.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DefaultObjectAccessControlProjectTeam.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 project_number: Optional[str] = None,
                 team: Optional[str] = None):
        """
        :param str project_number: The project team associated with the entity
        :param str team: The team.
               Possible values are: `editors`, `owners`, `viewers`.
        """
        if project_number is not None:
            pulumi.set(__self__, "project_number", project_number)
        if team is not None:
            pulumi.set(__self__, "team", team)

    @property
    @pulumi.getter(name="projectNumber")
    def project_number(self) -> Optional[str]:
        """
        The project team associated with the entity
        """
        return pulumi.get(self, "project_number")

    @property
    @pulumi.getter
    def team(self) -> Optional[str]:
        """
        The team.
        Possible values are: `editors`, `owners`, `viewers`.
        """
        return pulumi.get(self, "team")


@pulumi.output_type
class ObjectAccessControlProjectTeam(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectNumber":
            suggest = "project_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectAccessControlProjectTeam. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectAccessControlProjectTeam.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectAccessControlProjectTeam.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 project_number: Optional[str] = None,
                 team: Optional[str] = None):
        """
        :param str project_number: The project team associated with the entity
        :param str team: The team.
               Possible values are: `editors`, `owners`, `viewers`.
        """
        if project_number is not None:
            pulumi.set(__self__, "project_number", project_number)
        if team is not None:
            pulumi.set(__self__, "team", team)

    @property
    @pulumi.getter(name="projectNumber")
    def project_number(self) -> Optional[str]:
        """
        The project team associated with the entity
        """
        return pulumi.get(self, "project_number")

    @property
    @pulumi.getter
    def team(self) -> Optional[str]:
        """
        The team.
        Possible values are: `editors`, `owners`, `viewers`.
        """
        return pulumi.get(self, "team")


@pulumi.output_type
class TransferAgentPoolBandwidthLimit(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "limitMbps":
            suggest = "limit_mbps"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransferAgentPoolBandwidthLimit. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransferAgentPoolBandwidthLimit.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransferAgentPoolBandwidthLimit.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 limit_mbps: str):
        """
        :param str limit_mbps: Bandwidth rate in megabytes per second, distributed across all the agents in the pool.
        """
        pulumi.set(__self__, "limit_mbps", limit_mbps)

    @property
    @pulumi.getter(name="limitMbps")
    def limit_mbps(self) -> str:
        """
        Bandwidth rate in megabytes per second, distributed across all the agents in the pool.
        """
        return pulumi.get(self, "limit_mbps")


@pulumi.output_type
class TransferJobNotificationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "payloadFormat":
            suggest = "payload_format"
        elif key == "pubsubTopic":
            suggest = "pubsub_topic"
        elif key == "eventTypes":
            suggest = "event_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransferJobNotificationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransferJobNotificationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransferJobNotificationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 payload_format: str,
                 pubsub_topic: str,
                 event_types: Optional[Sequence[str]] = None):
        """
        :param str payload_format: The desired format of the notification message payloads. One of "NONE" or "JSON".
        :param str pubsub_topic: The Topic.name of the Pub/Sub topic to which to publish notifications. Must be of the format: projects/{project}/topics/{topic}. Not matching this format results in an INVALID_ARGUMENT error.
        :param Sequence[str] event_types: Event types for which a notification is desired. If empty, send notifications for all event types. The valid types are "TRANSFER_OPERATION_SUCCESS", "TRANSFER_OPERATION_FAILED", "TRANSFER_OPERATION_ABORTED".
        """
        pulumi.set(__self__, "payload_format", payload_format)
        pulumi.set(__self__, "pubsub_topic", pubsub_topic)
        if event_types is not None:
            pulumi.set(__self__, "event_types", event_types)

    @property
    @pulumi.getter(name="payloadFormat")
    def payload_format(self) -> str:
        """
        The desired format of the notification message payloads. One of "NONE" or "JSON".
        """
        return pulumi.get(self, "payload_format")

    @property
    @pulumi.getter(name="pubsubTopic")
    def pubsub_topic(self) -> str:
        """
        The Topic.name of the Pub/Sub topic to which to publish notifications. Must be of the format: projects/{project}/topics/{topic}. Not matching this format results in an INVALID_ARGUMENT error.
        """
        return pulumi.get(self, "pubsub_topic")

    @property
    @pulumi.getter(name="eventTypes")
    def event_types(self) -> Optional[Sequence[str]]:
        """
        Event types for which a notification is desired. If empty, send notifications for all event types. The valid types are "TRANSFER_OPERATION_SUCCESS", "TRANSFER_OPERATION_FAILED", "TRANSFER_OPERATION_ABORTED".
        """
        return pulumi.get(self, "event_types")


@pulumi.output_type
class TransferJobSchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scheduleStartDate":
            suggest = "schedule_start_date"
        elif key == "repeatInterval":
            suggest = "repeat_interval"
        elif key == "scheduleEndDate":
            suggest = "schedule_end_date"
        elif key == "startTimeOfDay":
            suggest = "start_time_of_day"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransferJobSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransferJobSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransferJobSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 schedule_start_date: 'outputs.TransferJobScheduleScheduleStartDate',
                 repeat_interval: Optional[str] = None,
                 schedule_end_date: Optional['outputs.TransferJobScheduleScheduleEndDate'] = None,
                 start_time_of_day: Optional['outputs.TransferJobScheduleStartTimeOfDay'] = None):
        """
        :param 'TransferJobScheduleScheduleStartDateArgs' schedule_start_date: The first day the recurring transfer is scheduled to run. If `schedule_start_date` is in the past, the transfer will run for the first time on the following day. Structure documented below.
        :param str repeat_interval: Interval between the start of each scheduled transfer. If unspecified, the default value is 24 hours. This value may not be less than 1 hour. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        :param 'TransferJobScheduleScheduleEndDateArgs' schedule_end_date: The last day the recurring transfer will be run. If `schedule_end_date` is the same as `schedule_start_date`, the transfer will be executed only once. Structure documented below.
        :param 'TransferJobScheduleStartTimeOfDayArgs' start_time_of_day: The time in UTC at which the transfer will be scheduled to start in a day. Transfers may start later than this time. If not specified, recurring and one-time transfers that are scheduled to run today will run immediately; recurring transfers that are scheduled to run on a future date will start at approximately midnight UTC on that date. Note that when configuring a transfer with the Cloud Platform Console, the transfer's start time in a day is specified in your local timezone. Structure documented below.
        """
        pulumi.set(__self__, "schedule_start_date", schedule_start_date)
        if repeat_interval is not None:
            pulumi.set(__self__, "repeat_interval", repeat_interval)
        if schedule_end_date is not None:
            pulumi.set(__self__, "schedule_end_date", schedule_end_date)
        if start_time_of_day is not None:
            pulumi.set(__self__, "start_time_of_day", start_time_of_day)

    @property
    @pulumi.getter(name="scheduleStartDate")
    def schedule_start_date(self) -> 'outputs.TransferJobScheduleScheduleStartDate':
        """
        The first day the recurring transfer is scheduled to run. If `schedule_start_date` is in the past, the transfer will run for the first time on the following day. Structure documented below.
        """
        return pulumi.get(self, "schedule_start_date")

    @property
    @pulumi.getter(name="repeatInterval")
    def repeat_interval(self) -> Optional[str]:
        """
        Interval between the start of each scheduled transfer. If unspecified, the default value is 24 hours. This value may not be less than 1 hour. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "repeat_interval")

    @property
    @pulumi.getter(name="scheduleEndDate")
    def schedule_end_date(self) -> Optional['outputs.TransferJobScheduleScheduleEndDate']:
        """
        The last day the recurring transfer will be run. If `schedule_end_date` is the same as `schedule_start_date`, the transfer will be executed only once. Structure documented below.
        """
        return pulumi.get(self, "schedule_end_date")

    @property
    @pulumi.getter(name="startTimeOfDay")
    def start_time_of_day(self) -> Optional['outputs.TransferJobScheduleStartTimeOfDay']:
        """
        The time in UTC at which the transfer will be scheduled to start in a day. Transfers may start later than this time. If not specified, recurring and one-time transfers that are scheduled to run today will run immediately; recurring transfers that are scheduled to run on a future date will start at approximately midnight UTC on that date. Note that when configuring a transfer with the Cloud Platform Console, the transfer's start time in a day is specified in your local timezone. Structure documented below.
        """
        return pulumi.get(self, "start_time_of_day")


@pulumi.output_type
class TransferJobScheduleScheduleEndDate(dict):
    def __init__(__self__, *,
                 day: int,
                 month: int,
                 year: int):
        """
        :param int day: Day of month. Must be from 1 to 31 and valid for the year and month.
               
               <a name="nested_start_time_of_day"></a>The `start_time_of_day` blocks support:
        :param int month: Month of year. Must be from 1 to 12.
        :param int year: Year of date. Must be from 1 to 9999.
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "month", month)
        pulumi.set(__self__, "year", year)

    @property
    @pulumi.getter
    def day(self) -> int:
        """
        Day of month. Must be from 1 to 31 and valid for the year and month.

        <a name="nested_start_time_of_day"></a>The `start_time_of_day` blocks support:
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter
    def month(self) -> int:
        """
        Month of year. Must be from 1 to 12.
        """
        return pulumi.get(self, "month")

    @property
    @pulumi.getter
    def year(self) -> int:
        """
        Year of date. Must be from 1 to 9999.
        """
        return pulumi.get(self, "year")


@pulumi.output_type
class TransferJobScheduleScheduleStartDate(dict):
    def __init__(__self__, *,
                 day: int,
                 month: int,
                 year: int):
        """
        :param int day: Day of month. Must be from 1 to 31 and valid for the year and month.
               
               <a name="nested_start_time_of_day"></a>The `start_time_of_day` blocks support:
        :param int month: Month of year. Must be from 1 to 12.
        :param int year: Year of date. Must be from 1 to 9999.
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "month", month)
        pulumi.set(__self__, "year", year)

    @property
    @pulumi.getter
    def day(self) -> int:
        """
        Day of month. Must be from 1 to 31 and valid for the year and month.

        <a name="nested_start_time_of_day"></a>The `start_time_of_day` blocks support:
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter
    def month(self) -> int:
        """
        Month of year. Must be from 1 to 12.
        """
        return pulumi.get(self, "month")

    @property
    @pulumi.getter
    def year(self) -> int:
        """
        Year of date. Must be from 1 to 9999.
        """
        return pulumi.get(self, "year")


@pulumi.output_type
class TransferJobScheduleStartTimeOfDay(dict):
    def __init__(__self__, *,
                 hours: int,
                 minutes: int,
                 nanos: int,
                 seconds: int):
        """
        :param int hours: Hours of day in 24 hour format. Should be from 0 to 23
        :param int minutes: Minutes of hour of day. Must be from 0 to 59.
        :param int nanos: Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        :param int seconds: Seconds of minutes of the time. Must normally be from 0 to 59.
        """
        pulumi.set(__self__, "hours", hours)
        pulumi.set(__self__, "minutes", minutes)
        pulumi.set(__self__, "nanos", nanos)
        pulumi.set(__self__, "seconds", seconds)

    @property
    @pulumi.getter
    def hours(self) -> int:
        """
        Hours of day in 24 hour format. Should be from 0 to 23
        """
        return pulumi.get(self, "hours")

    @property
    @pulumi.getter
    def minutes(self) -> int:
        """
        Minutes of hour of day. Must be from 0 to 59.
        """
        return pulumi.get(self, "minutes")

    @property
    @pulumi.getter
    def nanos(self) -> int:
        """
        Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        """
        return pulumi.get(self, "nanos")

    @property
    @pulumi.getter
    def seconds(self) -> int:
        """
        Seconds of minutes of the time. Must normally be from 0 to 59.
        """
        return pulumi.get(self, "seconds")


@pulumi.output_type
class TransferJobTransferSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsS3DataSource":
            suggest = "aws_s3_data_source"
        elif key == "azureBlobStorageDataSource":
            suggest = "azure_blob_storage_data_source"
        elif key == "gcsDataSink":
            suggest = "gcs_data_sink"
        elif key == "gcsDataSource":
            suggest = "gcs_data_source"
        elif key == "httpDataSource":
            suggest = "http_data_source"
        elif key == "objectConditions":
            suggest = "object_conditions"
        elif key == "posixDataSink":
            suggest = "posix_data_sink"
        elif key == "posixDataSource":
            suggest = "posix_data_source"
        elif key == "sinkAgentPoolName":
            suggest = "sink_agent_pool_name"
        elif key == "sourceAgentPoolName":
            suggest = "source_agent_pool_name"
        elif key == "transferOptions":
            suggest = "transfer_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransferJobTransferSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransferJobTransferSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransferJobTransferSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aws_s3_data_source: Optional['outputs.TransferJobTransferSpecAwsS3DataSource'] = None,
                 azure_blob_storage_data_source: Optional['outputs.TransferJobTransferSpecAzureBlobStorageDataSource'] = None,
                 gcs_data_sink: Optional['outputs.TransferJobTransferSpecGcsDataSink'] = None,
                 gcs_data_source: Optional['outputs.TransferJobTransferSpecGcsDataSource'] = None,
                 http_data_source: Optional['outputs.TransferJobTransferSpecHttpDataSource'] = None,
                 object_conditions: Optional['outputs.TransferJobTransferSpecObjectConditions'] = None,
                 posix_data_sink: Optional['outputs.TransferJobTransferSpecPosixDataSink'] = None,
                 posix_data_source: Optional['outputs.TransferJobTransferSpecPosixDataSource'] = None,
                 sink_agent_pool_name: Optional[str] = None,
                 source_agent_pool_name: Optional[str] = None,
                 transfer_options: Optional['outputs.TransferJobTransferSpecTransferOptions'] = None):
        """
        :param 'TransferJobTransferSpecAwsS3DataSourceArgs' aws_s3_data_source: An AWS S3 data source. Structure documented below.
        :param 'TransferJobTransferSpecAzureBlobStorageDataSourceArgs' azure_blob_storage_data_source: An Azure Blob Storage data source. Structure documented below.
        :param 'TransferJobTransferSpecGcsDataSinkArgs' gcs_data_sink: A Google Cloud Storage data sink. Structure documented below.
        :param 'TransferJobTransferSpecGcsDataSourceArgs' gcs_data_source: A Google Cloud Storage data source. Structure documented below.
        :param 'TransferJobTransferSpecHttpDataSourceArgs' http_data_source: A HTTP URL data source. Structure documented below.
        :param 'TransferJobTransferSpecObjectConditionsArgs' object_conditions: Only objects that satisfy these object conditions are included in the set of data source and data sink objects. Object conditions based on objects' `last_modification_time` do not exclude objects in a data sink. Structure documented below.
        :param 'TransferJobTransferSpecPosixDataSinkArgs' posix_data_sink: A POSIX data sink. Structure documented below.
        :param 'TransferJobTransferSpecPosixDataSourceArgs' posix_data_source: A POSIX filesystem data source. Structure documented below.
        :param str sink_agent_pool_name: Specifies the agent pool name associated with the posix data sink. When unspecified, the default name is used.
        :param str source_agent_pool_name: Specifies the agent pool name associated with the posix data source. When unspecified, the default name is used.
        :param 'TransferJobTransferSpecTransferOptionsArgs' transfer_options: Characteristics of how to treat files from datasource and sink during job. If the option `delete_objects_unique_in_sink` is true, object conditions based on objects' `last_modification_time` are ignored and do not exclude objects in a data source or a data sink. Structure documented below.
        """
        if aws_s3_data_source is not None:
            pulumi.set(__self__, "aws_s3_data_source", aws_s3_data_source)
        if azure_blob_storage_data_source is not None:
            pulumi.set(__self__, "azure_blob_storage_data_source", azure_blob_storage_data_source)
        if gcs_data_sink is not None:
            pulumi.set(__self__, "gcs_data_sink", gcs_data_sink)
        if gcs_data_source is not None:
            pulumi.set(__self__, "gcs_data_source", gcs_data_source)
        if http_data_source is not None:
            pulumi.set(__self__, "http_data_source", http_data_source)
        if object_conditions is not None:
            pulumi.set(__self__, "object_conditions", object_conditions)
        if posix_data_sink is not None:
            pulumi.set(__self__, "posix_data_sink", posix_data_sink)
        if posix_data_source is not None:
            pulumi.set(__self__, "posix_data_source", posix_data_source)
        if sink_agent_pool_name is not None:
            pulumi.set(__self__, "sink_agent_pool_name", sink_agent_pool_name)
        if source_agent_pool_name is not None:
            pulumi.set(__self__, "source_agent_pool_name", source_agent_pool_name)
        if transfer_options is not None:
            pulumi.set(__self__, "transfer_options", transfer_options)

    @property
    @pulumi.getter(name="awsS3DataSource")
    def aws_s3_data_source(self) -> Optional['outputs.TransferJobTransferSpecAwsS3DataSource']:
        """
        An AWS S3 data source. Structure documented below.
        """
        return pulumi.get(self, "aws_s3_data_source")

    @property
    @pulumi.getter(name="azureBlobStorageDataSource")
    def azure_blob_storage_data_source(self) -> Optional['outputs.TransferJobTransferSpecAzureBlobStorageDataSource']:
        """
        An Azure Blob Storage data source. Structure documented below.
        """
        return pulumi.get(self, "azure_blob_storage_data_source")

    @property
    @pulumi.getter(name="gcsDataSink")
    def gcs_data_sink(self) -> Optional['outputs.TransferJobTransferSpecGcsDataSink']:
        """
        A Google Cloud Storage data sink. Structure documented below.
        """
        return pulumi.get(self, "gcs_data_sink")

    @property
    @pulumi.getter(name="gcsDataSource")
    def gcs_data_source(self) -> Optional['outputs.TransferJobTransferSpecGcsDataSource']:
        """
        A Google Cloud Storage data source. Structure documented below.
        """
        return pulumi.get(self, "gcs_data_source")

    @property
    @pulumi.getter(name="httpDataSource")
    def http_data_source(self) -> Optional['outputs.TransferJobTransferSpecHttpDataSource']:
        """
        A HTTP URL data source. Structure documented below.
        """
        return pulumi.get(self, "http_data_source")

    @property
    @pulumi.getter(name="objectConditions")
    def object_conditions(self) -> Optional['outputs.TransferJobTransferSpecObjectConditions']:
        """
        Only objects that satisfy these object conditions are included in the set of data source and data sink objects. Object conditions based on objects' `last_modification_time` do not exclude objects in a data sink. Structure documented below.
        """
        return pulumi.get(self, "object_conditions")

    @property
    @pulumi.getter(name="posixDataSink")
    def posix_data_sink(self) -> Optional['outputs.TransferJobTransferSpecPosixDataSink']:
        """
        A POSIX data sink. Structure documented below.
        """
        return pulumi.get(self, "posix_data_sink")

    @property
    @pulumi.getter(name="posixDataSource")
    def posix_data_source(self) -> Optional['outputs.TransferJobTransferSpecPosixDataSource']:
        """
        A POSIX filesystem data source. Structure documented below.
        """
        return pulumi.get(self, "posix_data_source")

    @property
    @pulumi.getter(name="sinkAgentPoolName")
    def sink_agent_pool_name(self) -> Optional[str]:
        """
        Specifies the agent pool name associated with the posix data sink. When unspecified, the default name is used.
        """
        return pulumi.get(self, "sink_agent_pool_name")

    @property
    @pulumi.getter(name="sourceAgentPoolName")
    def source_agent_pool_name(self) -> Optional[str]:
        """
        Specifies the agent pool name associated with the posix data source. When unspecified, the default name is used.
        """
        return pulumi.get(self, "source_agent_pool_name")

    @property
    @pulumi.getter(name="transferOptions")
    def transfer_options(self) -> Optional['outputs.TransferJobTransferSpecTransferOptions']:
        """
        Characteristics of how to treat files from datasource and sink during job. If the option `delete_objects_unique_in_sink` is true, object conditions based on objects' `last_modification_time` are ignored and do not exclude objects in a data source or a data sink. Structure documented below.
        """
        return pulumi.get(self, "transfer_options")


@pulumi.output_type
class TransferJobTransferSpecAwsS3DataSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "awsAccessKey":
            suggest = "aws_access_key"
        elif key == "roleArn":
            suggest = "role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransferJobTransferSpecAwsS3DataSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransferJobTransferSpecAwsS3DataSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransferJobTransferSpecAwsS3DataSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: str,
                 aws_access_key: Optional['outputs.TransferJobTransferSpecAwsS3DataSourceAwsAccessKey'] = None,
                 path: Optional[str] = None,
                 role_arn: Optional[str] = None):
        """
        :param str bucket_name: Google Cloud Storage bucket name.
        :param 'TransferJobTransferSpecAwsS3DataSourceAwsAccessKeyArgs' aws_access_key: AWS credentials block.
        :param str path: Root path to transfer objects. Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'.
        :param str role_arn: The Amazon Resource Name (ARN) of the role to support temporary credentials via 'AssumeRoleWithWebIdentity'. For more information about ARNs, see [IAM ARNs](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns). When a role ARN is provided, Transfer Service fetches temporary credentials for the session using a 'AssumeRoleWithWebIdentity' call for the provided role using the [GoogleServiceAccount][] for this project.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        if aws_access_key is not None:
            pulumi.set(__self__, "aws_access_key", aws_access_key)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        Google Cloud Storage bucket name.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter(name="awsAccessKey")
    def aws_access_key(self) -> Optional['outputs.TransferJobTransferSpecAwsS3DataSourceAwsAccessKey']:
        """
        AWS credentials block.
        """
        return pulumi.get(self, "aws_access_key")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Root path to transfer objects. Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the role to support temporary credentials via 'AssumeRoleWithWebIdentity'. For more information about ARNs, see [IAM ARNs](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns). When a role ARN is provided, Transfer Service fetches temporary credentials for the session using a 'AssumeRoleWithWebIdentity' call for the provided role using the [GoogleServiceAccount][] for this project.
        """
        return pulumi.get(self, "role_arn")


@pulumi.output_type
class TransferJobTransferSpecAwsS3DataSourceAwsAccessKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKeyId":
            suggest = "access_key_id"
        elif key == "secretAccessKey":
            suggest = "secret_access_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransferJobTransferSpecAwsS3DataSourceAwsAccessKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransferJobTransferSpecAwsS3DataSourceAwsAccessKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransferJobTransferSpecAwsS3DataSourceAwsAccessKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key_id: str,
                 secret_access_key: str):
        """
        :param str access_key_id: AWS Key ID.
        :param str secret_access_key: AWS Secret Access Key.
        """
        pulumi.set(__self__, "access_key_id", access_key_id)
        pulumi.set(__self__, "secret_access_key", secret_access_key)

    @property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> str:
        """
        AWS Key ID.
        """
        return pulumi.get(self, "access_key_id")

    @property
    @pulumi.getter(name="secretAccessKey")
    def secret_access_key(self) -> str:
        """
        AWS Secret Access Key.
        """
        return pulumi.get(self, "secret_access_key")


@pulumi.output_type
class TransferJobTransferSpecAzureBlobStorageDataSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureCredentials":
            suggest = "azure_credentials"
        elif key == "storageAccount":
            suggest = "storage_account"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransferJobTransferSpecAzureBlobStorageDataSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransferJobTransferSpecAzureBlobStorageDataSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransferJobTransferSpecAzureBlobStorageDataSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 azure_credentials: 'outputs.TransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentials',
                 container: str,
                 storage_account: str,
                 path: Optional[str] = None):
        """
        :param 'TransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentialsArgs' azure_credentials: Credentials used to authenticate API requests to Azure block.
        :param str container: The container to transfer from the Azure Storage account.`
        :param str storage_account: The name of the Azure Storage account.
        :param str path: Root path to transfer objects. Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'.
        """
        pulumi.set(__self__, "azure_credentials", azure_credentials)
        pulumi.set(__self__, "container", container)
        pulumi.set(__self__, "storage_account", storage_account)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="azureCredentials")
    def azure_credentials(self) -> 'outputs.TransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentials':
        """
        Credentials used to authenticate API requests to Azure block.
        """
        return pulumi.get(self, "azure_credentials")

    @property
    @pulumi.getter
    def container(self) -> str:
        """
        The container to transfer from the Azure Storage account.`
        """
        return pulumi.get(self, "container")

    @property
    @pulumi.getter(name="storageAccount")
    def storage_account(self) -> str:
        """
        The name of the Azure Storage account.
        """
        return pulumi.get(self, "storage_account")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Root path to transfer objects. Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class TransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sasToken":
            suggest = "sas_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sas_token: str):
        """
        :param str sas_token: Azure shared access signature. See [Grant limited access to Azure Storage resources using shared access signatures (SAS)](https://docs.microsoft.com/en-us/azure/storage/common/storage-sas-overview).
               
               <a name="nested_schedule_start_end_date"></a>The `schedule_start_date` and `schedule_end_date` blocks support:
        """
        pulumi.set(__self__, "sas_token", sas_token)

    @property
    @pulumi.getter(name="sasToken")
    def sas_token(self) -> str:
        """
        Azure shared access signature. See [Grant limited access to Azure Storage resources using shared access signatures (SAS)](https://docs.microsoft.com/en-us/azure/storage/common/storage-sas-overview).

        <a name="nested_schedule_start_end_date"></a>The `schedule_start_date` and `schedule_end_date` blocks support:
        """
        return pulumi.get(self, "sas_token")


@pulumi.output_type
class TransferJobTransferSpecGcsDataSink(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransferJobTransferSpecGcsDataSink. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransferJobTransferSpecGcsDataSink.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransferJobTransferSpecGcsDataSink.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: str,
                 path: Optional[str] = None):
        """
        :param str bucket_name: Google Cloud Storage bucket name.
        :param str path: Root path to transfer objects. Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        Google Cloud Storage bucket name.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Root path to transfer objects. Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class TransferJobTransferSpecGcsDataSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransferJobTransferSpecGcsDataSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransferJobTransferSpecGcsDataSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransferJobTransferSpecGcsDataSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: str,
                 path: Optional[str] = None):
        """
        :param str bucket_name: Google Cloud Storage bucket name.
        :param str path: Root path to transfer objects. Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        Google Cloud Storage bucket name.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Root path to transfer objects. Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class TransferJobTransferSpecHttpDataSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "listUrl":
            suggest = "list_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransferJobTransferSpecHttpDataSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransferJobTransferSpecHttpDataSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransferJobTransferSpecHttpDataSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 list_url: str):
        """
        :param str list_url: The URL that points to the file that stores the object list entries. This file must allow public access. Currently, only URLs with HTTP and HTTPS schemes are supported.
        """
        pulumi.set(__self__, "list_url", list_url)

    @property
    @pulumi.getter(name="listUrl")
    def list_url(self) -> str:
        """
        The URL that points to the file that stores the object list entries. This file must allow public access. Currently, only URLs with HTTP and HTTPS schemes are supported.
        """
        return pulumi.get(self, "list_url")


@pulumi.output_type
class TransferJobTransferSpecObjectConditions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludePrefixes":
            suggest = "exclude_prefixes"
        elif key == "includePrefixes":
            suggest = "include_prefixes"
        elif key == "lastModifiedBefore":
            suggest = "last_modified_before"
        elif key == "lastModifiedSince":
            suggest = "last_modified_since"
        elif key == "maxTimeElapsedSinceLastModification":
            suggest = "max_time_elapsed_since_last_modification"
        elif key == "minTimeElapsedSinceLastModification":
            suggest = "min_time_elapsed_since_last_modification"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransferJobTransferSpecObjectConditions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransferJobTransferSpecObjectConditions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransferJobTransferSpecObjectConditions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exclude_prefixes: Optional[Sequence[str]] = None,
                 include_prefixes: Optional[Sequence[str]] = None,
                 last_modified_before: Optional[str] = None,
                 last_modified_since: Optional[str] = None,
                 max_time_elapsed_since_last_modification: Optional[str] = None,
                 min_time_elapsed_since_last_modification: Optional[str] = None):
        """
        :param Sequence[str] exclude_prefixes: `exclude_prefixes` must follow the requirements described for `include_prefixes`. See [Requirements](https://cloud.google.com/storage-transfer/docs/reference/rest/v1/TransferSpec#ObjectConditions).
        :param Sequence[str] include_prefixes: If `include_prefixes` is specified, objects that satisfy the object conditions must have names that start with one of the `include_prefixes` and that do not start with any of the `exclude_prefixes`. If `include_prefixes` is not specified, all objects except those that have names starting with one of the `exclude_prefixes` must satisfy the object conditions. See [Requirements](https://cloud.google.com/storage-transfer/docs/reference/rest/v1/TransferSpec#ObjectConditions).
        :param str last_modified_before: If specified, only objects with a "last modification time" before this timestamp and objects that don't have a "last modification time" are transferred. A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param str last_modified_since: If specified, only objects with a "last modification time" on or after this timestamp and objects that don't have a "last modification time" are transferred. A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param str max_time_elapsed_since_last_modification: A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        :param str min_time_elapsed_since_last_modification: A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        if exclude_prefixes is not None:
            pulumi.set(__self__, "exclude_prefixes", exclude_prefixes)
        if include_prefixes is not None:
            pulumi.set(__self__, "include_prefixes", include_prefixes)
        if last_modified_before is not None:
            pulumi.set(__self__, "last_modified_before", last_modified_before)
        if last_modified_since is not None:
            pulumi.set(__self__, "last_modified_since", last_modified_since)
        if max_time_elapsed_since_last_modification is not None:
            pulumi.set(__self__, "max_time_elapsed_since_last_modification", max_time_elapsed_since_last_modification)
        if min_time_elapsed_since_last_modification is not None:
            pulumi.set(__self__, "min_time_elapsed_since_last_modification", min_time_elapsed_since_last_modification)

    @property
    @pulumi.getter(name="excludePrefixes")
    def exclude_prefixes(self) -> Optional[Sequence[str]]:
        """
        `exclude_prefixes` must follow the requirements described for `include_prefixes`. See [Requirements](https://cloud.google.com/storage-transfer/docs/reference/rest/v1/TransferSpec#ObjectConditions).
        """
        return pulumi.get(self, "exclude_prefixes")

    @property
    @pulumi.getter(name="includePrefixes")
    def include_prefixes(self) -> Optional[Sequence[str]]:
        """
        If `include_prefixes` is specified, objects that satisfy the object conditions must have names that start with one of the `include_prefixes` and that do not start with any of the `exclude_prefixes`. If `include_prefixes` is not specified, all objects except those that have names starting with one of the `exclude_prefixes` must satisfy the object conditions. See [Requirements](https://cloud.google.com/storage-transfer/docs/reference/rest/v1/TransferSpec#ObjectConditions).
        """
        return pulumi.get(self, "include_prefixes")

    @property
    @pulumi.getter(name="lastModifiedBefore")
    def last_modified_before(self) -> Optional[str]:
        """
        If specified, only objects with a "last modification time" before this timestamp and objects that don't have a "last modification time" are transferred. A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "last_modified_before")

    @property
    @pulumi.getter(name="lastModifiedSince")
    def last_modified_since(self) -> Optional[str]:
        """
        If specified, only objects with a "last modification time" on or after this timestamp and objects that don't have a "last modification time" are transferred. A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "last_modified_since")

    @property
    @pulumi.getter(name="maxTimeElapsedSinceLastModification")
    def max_time_elapsed_since_last_modification(self) -> Optional[str]:
        """
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "max_time_elapsed_since_last_modification")

    @property
    @pulumi.getter(name="minTimeElapsedSinceLastModification")
    def min_time_elapsed_since_last_modification(self) -> Optional[str]:
        """
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "min_time_elapsed_since_last_modification")


@pulumi.output_type
class TransferJobTransferSpecPosixDataSink(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rootDirectory":
            suggest = "root_directory"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransferJobTransferSpecPosixDataSink. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransferJobTransferSpecPosixDataSink.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransferJobTransferSpecPosixDataSink.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 root_directory: str):
        """
        :param str root_directory: Root directory path to the filesystem.
        """
        pulumi.set(__self__, "root_directory", root_directory)

    @property
    @pulumi.getter(name="rootDirectory")
    def root_directory(self) -> str:
        """
        Root directory path to the filesystem.
        """
        return pulumi.get(self, "root_directory")


@pulumi.output_type
class TransferJobTransferSpecPosixDataSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rootDirectory":
            suggest = "root_directory"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransferJobTransferSpecPosixDataSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransferJobTransferSpecPosixDataSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransferJobTransferSpecPosixDataSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 root_directory: str):
        """
        :param str root_directory: Root directory path to the filesystem.
               
               <a name="nested_aws_s3_data_source"></a>The `aws_s3_data_source` block supports:
        """
        pulumi.set(__self__, "root_directory", root_directory)

    @property
    @pulumi.getter(name="rootDirectory")
    def root_directory(self) -> str:
        """
        Root directory path to the filesystem.

        <a name="nested_aws_s3_data_source"></a>The `aws_s3_data_source` block supports:
        """
        return pulumi.get(self, "root_directory")


@pulumi.output_type
class TransferJobTransferSpecTransferOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deleteObjectsFromSourceAfterTransfer":
            suggest = "delete_objects_from_source_after_transfer"
        elif key == "deleteObjectsUniqueInSink":
            suggest = "delete_objects_unique_in_sink"
        elif key == "overwriteObjectsAlreadyExistingInSink":
            suggest = "overwrite_objects_already_existing_in_sink"
        elif key == "overwriteWhen":
            suggest = "overwrite_when"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransferJobTransferSpecTransferOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransferJobTransferSpecTransferOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransferJobTransferSpecTransferOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delete_objects_from_source_after_transfer: Optional[bool] = None,
                 delete_objects_unique_in_sink: Optional[bool] = None,
                 overwrite_objects_already_existing_in_sink: Optional[bool] = None,
                 overwrite_when: Optional[str] = None):
        """
        :param bool delete_objects_from_source_after_transfer: Whether objects should be deleted from the source after they are transferred to the sink. Note that this option and `delete_objects_unique_in_sink` are mutually exclusive.
        :param bool delete_objects_unique_in_sink: Whether objects that exist only in the sink should be deleted. Note that this option and
               `delete_objects_from_source_after_transfer` are mutually exclusive.
        :param bool overwrite_objects_already_existing_in_sink: Whether overwriting objects that already exist in the sink is allowed.
        :param str overwrite_when: When to overwrite objects that already exist in the sink. If not set, overwrite behavior is determined by `overwrite_objects_already_existing_in_sink`. Possible values: ALWAYS, DIFFERENT, NEVER.
        """
        if delete_objects_from_source_after_transfer is not None:
            pulumi.set(__self__, "delete_objects_from_source_after_transfer", delete_objects_from_source_after_transfer)
        if delete_objects_unique_in_sink is not None:
            pulumi.set(__self__, "delete_objects_unique_in_sink", delete_objects_unique_in_sink)
        if overwrite_objects_already_existing_in_sink is not None:
            pulumi.set(__self__, "overwrite_objects_already_existing_in_sink", overwrite_objects_already_existing_in_sink)
        if overwrite_when is not None:
            pulumi.set(__self__, "overwrite_when", overwrite_when)

    @property
    @pulumi.getter(name="deleteObjectsFromSourceAfterTransfer")
    def delete_objects_from_source_after_transfer(self) -> Optional[bool]:
        """
        Whether objects should be deleted from the source after they are transferred to the sink. Note that this option and `delete_objects_unique_in_sink` are mutually exclusive.
        """
        return pulumi.get(self, "delete_objects_from_source_after_transfer")

    @property
    @pulumi.getter(name="deleteObjectsUniqueInSink")
    def delete_objects_unique_in_sink(self) -> Optional[bool]:
        """
        Whether objects that exist only in the sink should be deleted. Note that this option and
        `delete_objects_from_source_after_transfer` are mutually exclusive.
        """
        return pulumi.get(self, "delete_objects_unique_in_sink")

    @property
    @pulumi.getter(name="overwriteObjectsAlreadyExistingInSink")
    def overwrite_objects_already_existing_in_sink(self) -> Optional[bool]:
        """
        Whether overwriting objects that already exist in the sink is allowed.
        """
        return pulumi.get(self, "overwrite_objects_already_existing_in_sink")

    @property
    @pulumi.getter(name="overwriteWhen")
    def overwrite_when(self) -> Optional[str]:
        """
        When to overwrite objects that already exist in the sink. If not set, overwrite behavior is determined by `overwrite_objects_already_existing_in_sink`. Possible values: ALWAYS, DIFFERENT, NEVER.
        """
        return pulumi.get(self, "overwrite_when")


@pulumi.output_type
class GetBucketAutoclassResult(dict):
    def __init__(__self__, *,
                 enabled: bool):
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetBucketCorResult(dict):
    def __init__(__self__, *,
                 max_age_seconds: int,
                 methods: Sequence[str],
                 origins: Sequence[str],
                 response_headers: Sequence[str]):
        pulumi.set(__self__, "max_age_seconds", max_age_seconds)
        pulumi.set(__self__, "methods", methods)
        pulumi.set(__self__, "origins", origins)
        pulumi.set(__self__, "response_headers", response_headers)

    @property
    @pulumi.getter(name="maxAgeSeconds")
    def max_age_seconds(self) -> int:
        return pulumi.get(self, "max_age_seconds")

    @property
    @pulumi.getter
    def methods(self) -> Sequence[str]:
        return pulumi.get(self, "methods")

    @property
    @pulumi.getter
    def origins(self) -> Sequence[str]:
        return pulumi.get(self, "origins")

    @property
    @pulumi.getter(name="responseHeaders")
    def response_headers(self) -> Sequence[str]:
        return pulumi.get(self, "response_headers")


@pulumi.output_type
class GetBucketCustomPlacementConfigResult(dict):
    def __init__(__self__, *,
                 data_locations: Sequence[str]):
        pulumi.set(__self__, "data_locations", data_locations)

    @property
    @pulumi.getter(name="dataLocations")
    def data_locations(self) -> Sequence[str]:
        return pulumi.get(self, "data_locations")


@pulumi.output_type
class GetBucketEncryptionResult(dict):
    def __init__(__self__, *,
                 default_kms_key_name: str):
        pulumi.set(__self__, "default_kms_key_name", default_kms_key_name)

    @property
    @pulumi.getter(name="defaultKmsKeyName")
    def default_kms_key_name(self) -> str:
        return pulumi.get(self, "default_kms_key_name")


@pulumi.output_type
class GetBucketLifecycleRuleResult(dict):
    def __init__(__self__, *,
                 actions: Sequence['outputs.GetBucketLifecycleRuleActionResult'],
                 conditions: Sequence['outputs.GetBucketLifecycleRuleConditionResult']):
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "conditions", conditions)

    @property
    @pulumi.getter
    def actions(self) -> Sequence['outputs.GetBucketLifecycleRuleActionResult']:
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.GetBucketLifecycleRuleConditionResult']:
        return pulumi.get(self, "conditions")


@pulumi.output_type
class GetBucketLifecycleRuleActionResult(dict):
    def __init__(__self__, *,
                 storage_class: str,
                 type: str):
        pulumi.set(__self__, "storage_class", storage_class)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> str:
        return pulumi.get(self, "storage_class")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetBucketLifecycleRuleConditionResult(dict):
    def __init__(__self__, *,
                 age: int,
                 created_before: str,
                 custom_time_before: str,
                 days_since_custom_time: int,
                 days_since_noncurrent_time: int,
                 matches_prefixes: Sequence[str],
                 matches_storage_classes: Sequence[str],
                 matches_suffixes: Sequence[str],
                 noncurrent_time_before: str,
                 num_newer_versions: int,
                 with_state: str):
        pulumi.set(__self__, "age", age)
        pulumi.set(__self__, "created_before", created_before)
        pulumi.set(__self__, "custom_time_before", custom_time_before)
        pulumi.set(__self__, "days_since_custom_time", days_since_custom_time)
        pulumi.set(__self__, "days_since_noncurrent_time", days_since_noncurrent_time)
        pulumi.set(__self__, "matches_prefixes", matches_prefixes)
        pulumi.set(__self__, "matches_storage_classes", matches_storage_classes)
        pulumi.set(__self__, "matches_suffixes", matches_suffixes)
        pulumi.set(__self__, "noncurrent_time_before", noncurrent_time_before)
        pulumi.set(__self__, "num_newer_versions", num_newer_versions)
        pulumi.set(__self__, "with_state", with_state)

    @property
    @pulumi.getter
    def age(self) -> int:
        return pulumi.get(self, "age")

    @property
    @pulumi.getter(name="createdBefore")
    def created_before(self) -> str:
        return pulumi.get(self, "created_before")

    @property
    @pulumi.getter(name="customTimeBefore")
    def custom_time_before(self) -> str:
        return pulumi.get(self, "custom_time_before")

    @property
    @pulumi.getter(name="daysSinceCustomTime")
    def days_since_custom_time(self) -> int:
        return pulumi.get(self, "days_since_custom_time")

    @property
    @pulumi.getter(name="daysSinceNoncurrentTime")
    def days_since_noncurrent_time(self) -> int:
        return pulumi.get(self, "days_since_noncurrent_time")

    @property
    @pulumi.getter(name="matchesPrefixes")
    def matches_prefixes(self) -> Sequence[str]:
        return pulumi.get(self, "matches_prefixes")

    @property
    @pulumi.getter(name="matchesStorageClasses")
    def matches_storage_classes(self) -> Sequence[str]:
        return pulumi.get(self, "matches_storage_classes")

    @property
    @pulumi.getter(name="matchesSuffixes")
    def matches_suffixes(self) -> Sequence[str]:
        return pulumi.get(self, "matches_suffixes")

    @property
    @pulumi.getter(name="noncurrentTimeBefore")
    def noncurrent_time_before(self) -> str:
        return pulumi.get(self, "noncurrent_time_before")

    @property
    @pulumi.getter(name="numNewerVersions")
    def num_newer_versions(self) -> int:
        return pulumi.get(self, "num_newer_versions")

    @property
    @pulumi.getter(name="withState")
    def with_state(self) -> str:
        return pulumi.get(self, "with_state")


@pulumi.output_type
class GetBucketLoggingResult(dict):
    def __init__(__self__, *,
                 log_bucket: str,
                 log_object_prefix: str):
        pulumi.set(__self__, "log_bucket", log_bucket)
        pulumi.set(__self__, "log_object_prefix", log_object_prefix)

    @property
    @pulumi.getter(name="logBucket")
    def log_bucket(self) -> str:
        return pulumi.get(self, "log_bucket")

    @property
    @pulumi.getter(name="logObjectPrefix")
    def log_object_prefix(self) -> str:
        return pulumi.get(self, "log_object_prefix")


@pulumi.output_type
class GetBucketObjectContentCustomerEncryptionResult(dict):
    def __init__(__self__, *,
                 encryption_algorithm: str,
                 encryption_key: str):
        pulumi.set(__self__, "encryption_algorithm", encryption_algorithm)
        pulumi.set(__self__, "encryption_key", encryption_key)

    @property
    @pulumi.getter(name="encryptionAlgorithm")
    def encryption_algorithm(self) -> str:
        return pulumi.get(self, "encryption_algorithm")

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> str:
        return pulumi.get(self, "encryption_key")


@pulumi.output_type
class GetBucketObjectCustomerEncryptionResult(dict):
    def __init__(__self__, *,
                 encryption_algorithm: str,
                 encryption_key: str):
        pulumi.set(__self__, "encryption_algorithm", encryption_algorithm)
        pulumi.set(__self__, "encryption_key", encryption_key)

    @property
    @pulumi.getter(name="encryptionAlgorithm")
    def encryption_algorithm(self) -> str:
        return pulumi.get(self, "encryption_algorithm")

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> str:
        return pulumi.get(self, "encryption_key")


@pulumi.output_type
class GetBucketRetentionPolicyResult(dict):
    def __init__(__self__, *,
                 is_locked: bool,
                 retention_period: int):
        pulumi.set(__self__, "is_locked", is_locked)
        pulumi.set(__self__, "retention_period", retention_period)

    @property
    @pulumi.getter(name="isLocked")
    def is_locked(self) -> bool:
        return pulumi.get(self, "is_locked")

    @property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> int:
        return pulumi.get(self, "retention_period")


@pulumi.output_type
class GetBucketVersioningResult(dict):
    def __init__(__self__, *,
                 enabled: bool):
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetBucketWebsiteResult(dict):
    def __init__(__self__, *,
                 main_page_suffix: str,
                 not_found_page: str):
        pulumi.set(__self__, "main_page_suffix", main_page_suffix)
        pulumi.set(__self__, "not_found_page", not_found_page)

    @property
    @pulumi.getter(name="mainPageSuffix")
    def main_page_suffix(self) -> str:
        return pulumi.get(self, "main_page_suffix")

    @property
    @pulumi.getter(name="notFoundPage")
    def not_found_page(self) -> str:
        return pulumi.get(self, "not_found_page")


