# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TransferAgentPoolArgs', 'TransferAgentPool']

@pulumi.input_type
class TransferAgentPoolArgs:
    def __init__(__self__, *,
                 bandwidth_limit: Optional[pulumi.Input['TransferAgentPoolBandwidthLimitArgs']] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a TransferAgentPool resource.
        :param pulumi.Input['TransferAgentPoolBandwidthLimitArgs'] bandwidth_limit: Specifies the bandwidth limit details. If this field is unspecified, the default value is set as 'No Limit'.
               Structure is documented below.
        :param pulumi.Input[str] display_name: Specifies the client-specified AgentPool description.
        :param pulumi.Input[str] name: The ID of the agent pool to create.
               The agentPoolId must meet the following requirements:
               * Length of 128 characters or less.
               * Not start with the string goog.
               * Start with a lowercase ASCII character, followed by:
               * Zero or more: lowercase Latin alphabet characters, numerals, hyphens (-), periods (.), underscores (_), or tildes (~).
               * One or more numerals or lowercase ASCII characters.
               As expressed by the regular expression: ^(?!goog)a-z?$.
               
               
               - - -
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        if bandwidth_limit is not None:
            pulumi.set(__self__, "bandwidth_limit", bandwidth_limit)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="bandwidthLimit")
    def bandwidth_limit(self) -> Optional[pulumi.Input['TransferAgentPoolBandwidthLimitArgs']]:
        """
        Specifies the bandwidth limit details. If this field is unspecified, the default value is set as 'No Limit'.
        Structure is documented below.
        """
        return pulumi.get(self, "bandwidth_limit")

    @bandwidth_limit.setter
    def bandwidth_limit(self, value: Optional[pulumi.Input['TransferAgentPoolBandwidthLimitArgs']]):
        pulumi.set(self, "bandwidth_limit", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the client-specified AgentPool description.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the agent pool to create.
        The agentPoolId must meet the following requirements:
        * Length of 128 characters or less.
        * Not start with the string goog.
        * Start with a lowercase ASCII character, followed by:
        * Zero or more: lowercase Latin alphabet characters, numerals, hyphens (-), periods (.), underscores (_), or tildes (~).
        * One or more numerals or lowercase ASCII characters.
        As expressed by the regular expression: ^(?!goog)a-z?$.


        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _TransferAgentPoolState:
    def __init__(__self__, *,
                 bandwidth_limit: Optional[pulumi.Input['TransferAgentPoolBandwidthLimitArgs']] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering TransferAgentPool resources.
        :param pulumi.Input['TransferAgentPoolBandwidthLimitArgs'] bandwidth_limit: Specifies the bandwidth limit details. If this field is unspecified, the default value is set as 'No Limit'.
               Structure is documented below.
        :param pulumi.Input[str] display_name: Specifies the client-specified AgentPool description.
        :param pulumi.Input[str] name: The ID of the agent pool to create.
               The agentPoolId must meet the following requirements:
               * Length of 128 characters or less.
               * Not start with the string goog.
               * Start with a lowercase ASCII character, followed by:
               * Zero or more: lowercase Latin alphabet characters, numerals, hyphens (-), periods (.), underscores (_), or tildes (~).
               * One or more numerals or lowercase ASCII characters.
               As expressed by the regular expression: ^(?!goog)a-z?$.
               
               
               - - -
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] state: Specifies the state of the AgentPool.
        """
        if bandwidth_limit is not None:
            pulumi.set(__self__, "bandwidth_limit", bandwidth_limit)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="bandwidthLimit")
    def bandwidth_limit(self) -> Optional[pulumi.Input['TransferAgentPoolBandwidthLimitArgs']]:
        """
        Specifies the bandwidth limit details. If this field is unspecified, the default value is set as 'No Limit'.
        Structure is documented below.
        """
        return pulumi.get(self, "bandwidth_limit")

    @bandwidth_limit.setter
    def bandwidth_limit(self, value: Optional[pulumi.Input['TransferAgentPoolBandwidthLimitArgs']]):
        pulumi.set(self, "bandwidth_limit", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the client-specified AgentPool description.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the agent pool to create.
        The agentPoolId must meet the following requirements:
        * Length of 128 characters or less.
        * Not start with the string goog.
        * Start with a lowercase ASCII character, followed by:
        * Zero or more: lowercase Latin alphabet characters, numerals, hyphens (-), periods (.), underscores (_), or tildes (~).
        * One or more numerals or lowercase ASCII characters.
        As expressed by the regular expression: ^(?!goog)a-z?$.


        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the state of the AgentPool.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)


class TransferAgentPool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth_limit: Optional[pulumi.Input[pulumi.InputType['TransferAgentPoolBandwidthLimitArgs']]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Represents an On-Premises Agent pool.

        To get more information about AgentPool, see:

        * [API documentation](https://cloud.google.com/storage-transfer/docs/reference/rest/v1/projects.agentPools)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/storage-transfer/docs/on-prem-agent-pools)

        ## Example Usage
        ### Agent Pool Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.storage.get_transfer_project_service_account(project="my-project-name")
        pubsub_editor_role = gcp.projects.IAMMember("pubsubEditorRole",
            project="my-project-name",
            role="roles/pubsub.editor",
            member=f"serviceAccount:{default.email}")
        example = gcp.storage.TransferAgentPool("example",
            display_name="Source A to destination Z",
            bandwidth_limit=gcp.storage.TransferAgentPoolBandwidthLimitArgs(
                limit_mbps="120",
            ),
            opts=pulumi.ResourceOptions(depends_on=[pubsub_editor_role]))
        ```

        ## Import

        AgentPool can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:storage/transferAgentPool:TransferAgentPool default projects/{{project}}/agentPools/{{name}}
        ```

        ```sh
         $ pulumi import gcp:storage/transferAgentPool:TransferAgentPool default {{project}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:storage/transferAgentPool:TransferAgentPool default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['TransferAgentPoolBandwidthLimitArgs']] bandwidth_limit: Specifies the bandwidth limit details. If this field is unspecified, the default value is set as 'No Limit'.
               Structure is documented below.
        :param pulumi.Input[str] display_name: Specifies the client-specified AgentPool description.
        :param pulumi.Input[str] name: The ID of the agent pool to create.
               The agentPoolId must meet the following requirements:
               * Length of 128 characters or less.
               * Not start with the string goog.
               * Start with a lowercase ASCII character, followed by:
               * Zero or more: lowercase Latin alphabet characters, numerals, hyphens (-), periods (.), underscores (_), or tildes (~).
               * One or more numerals or lowercase ASCII characters.
               As expressed by the regular expression: ^(?!goog)a-z?$.
               
               
               - - -
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[TransferAgentPoolArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents an On-Premises Agent pool.

        To get more information about AgentPool, see:

        * [API documentation](https://cloud.google.com/storage-transfer/docs/reference/rest/v1/projects.agentPools)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/storage-transfer/docs/on-prem-agent-pools)

        ## Example Usage
        ### Agent Pool Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.storage.get_transfer_project_service_account(project="my-project-name")
        pubsub_editor_role = gcp.projects.IAMMember("pubsubEditorRole",
            project="my-project-name",
            role="roles/pubsub.editor",
            member=f"serviceAccount:{default.email}")
        example = gcp.storage.TransferAgentPool("example",
            display_name="Source A to destination Z",
            bandwidth_limit=gcp.storage.TransferAgentPoolBandwidthLimitArgs(
                limit_mbps="120",
            ),
            opts=pulumi.ResourceOptions(depends_on=[pubsub_editor_role]))
        ```

        ## Import

        AgentPool can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:storage/transferAgentPool:TransferAgentPool default projects/{{project}}/agentPools/{{name}}
        ```

        ```sh
         $ pulumi import gcp:storage/transferAgentPool:TransferAgentPool default {{project}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:storage/transferAgentPool:TransferAgentPool default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param TransferAgentPoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TransferAgentPoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth_limit: Optional[pulumi.Input[pulumi.InputType['TransferAgentPoolBandwidthLimitArgs']]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TransferAgentPoolArgs.__new__(TransferAgentPoolArgs)

            __props__.__dict__["bandwidth_limit"] = bandwidth_limit
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["state"] = None
        super(TransferAgentPool, __self__).__init__(
            'gcp:storage/transferAgentPool:TransferAgentPool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bandwidth_limit: Optional[pulumi.Input[pulumi.InputType['TransferAgentPoolBandwidthLimitArgs']]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None) -> 'TransferAgentPool':
        """
        Get an existing TransferAgentPool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['TransferAgentPoolBandwidthLimitArgs']] bandwidth_limit: Specifies the bandwidth limit details. If this field is unspecified, the default value is set as 'No Limit'.
               Structure is documented below.
        :param pulumi.Input[str] display_name: Specifies the client-specified AgentPool description.
        :param pulumi.Input[str] name: The ID of the agent pool to create.
               The agentPoolId must meet the following requirements:
               * Length of 128 characters or less.
               * Not start with the string goog.
               * Start with a lowercase ASCII character, followed by:
               * Zero or more: lowercase Latin alphabet characters, numerals, hyphens (-), periods (.), underscores (_), or tildes (~).
               * One or more numerals or lowercase ASCII characters.
               As expressed by the regular expression: ^(?!goog)a-z?$.
               
               
               - - -
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] state: Specifies the state of the AgentPool.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TransferAgentPoolState.__new__(_TransferAgentPoolState)

        __props__.__dict__["bandwidth_limit"] = bandwidth_limit
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["state"] = state
        return TransferAgentPool(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="bandwidthLimit")
    def bandwidth_limit(self) -> pulumi.Output[Optional['outputs.TransferAgentPoolBandwidthLimit']]:
        """
        Specifies the bandwidth limit details. If this field is unspecified, the default value is set as 'No Limit'.
        Structure is documented below.
        """
        return pulumi.get(self, "bandwidth_limit")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the client-specified AgentPool description.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The ID of the agent pool to create.
        The agentPoolId must meet the following requirements:
        * Length of 128 characters or less.
        * Not start with the string goog.
        * Start with a lowercase ASCII character, followed by:
        * Zero or more: lowercase Latin alphabet characters, numerals, hyphens (-), periods (.), underscores (_), or tildes (~).
        * One or more numerals or lowercase ASCII characters.
        As expressed by the regular expression: ^(?!goog)a-z?$.


        - - -
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        Specifies the state of the AgentPool.
        """
        return pulumi.get(self, "state")

