# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AiIndexArgs', 'AiIndex']

@pulumi.input_type
class AiIndexArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 index_update_method: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 metadata: Optional[pulumi.Input['AiIndexMetadataArgs']] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AiIndex resource.
        :param pulumi.Input[str] display_name: The display name of the Index. The name can be up to 128 characters long and can consist of any UTF-8 characters.
               
               
               - - -
        :param pulumi.Input[str] description: The description of the Index.
        :param pulumi.Input[str] index_update_method: The update method to use with this Index. The value must be the followings. If not set, BATCH_UPDATE will be used by default.
               * BATCH_UPDATE: user can call indexes.patch with files on Cloud Storage of datapoints to update.
               * STREAM_UPDATE: user can call indexes.upsertDatapoints/DeleteDatapoints to update the Index and the updates will be applied in corresponding DeployedIndexes in nearly real-time.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: The labels with user-defined metadata to organize your Indexes.
        :param pulumi.Input['AiIndexMetadataArgs'] metadata: An additional information about the Index
               Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: The region of the index. eg us-central1
        """
        pulumi.set(__self__, "display_name", display_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if index_update_method is not None:
            pulumi.set(__self__, "index_update_method", index_update_method)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        The display name of the Index. The name can be up to 128 characters long and can consist of any UTF-8 characters.


        - - -
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Index.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="indexUpdateMethod")
    def index_update_method(self) -> Optional[pulumi.Input[str]]:
        """
        The update method to use with this Index. The value must be the followings. If not set, BATCH_UPDATE will be used by default.
        * BATCH_UPDATE: user can call indexes.patch with files on Cloud Storage of datapoints to update.
        * STREAM_UPDATE: user can call indexes.upsertDatapoints/DeleteDatapoints to update the Index and the updates will be applied in corresponding DeployedIndexes in nearly real-time.
        """
        return pulumi.get(self, "index_update_method")

    @index_update_method.setter
    def index_update_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "index_update_method", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The labels with user-defined metadata to organize your Indexes.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['AiIndexMetadataArgs']]:
        """
        An additional information about the Index
        Structure is documented below.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['AiIndexMetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region of the index. eg us-central1
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _AiIndexState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[str]] = None,
                 deployed_indexes: Optional[pulumi.Input[Sequence[pulumi.Input['AiIndexDeployedIndexArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 index_stats: Optional[pulumi.Input[Sequence[pulumi.Input['AiIndexIndexStatArgs']]]] = None,
                 index_update_method: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 metadata: Optional[pulumi.Input['AiIndexMetadataArgs']] = None,
                 metadata_schema_uri: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AiIndex resources.
        :param pulumi.Input[str] create_time: The timestamp of when the Index was created in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        :param pulumi.Input[Sequence[pulumi.Input['AiIndexDeployedIndexArgs']]] deployed_indexes: The pointers to DeployedIndexes created from this Index. An Index can be only deleted if all its DeployedIndexes had been undeployed first.
               Structure is documented below.
        :param pulumi.Input[str] description: The description of the Index.
        :param pulumi.Input[str] display_name: The display name of the Index. The name can be up to 128 characters long and can consist of any UTF-8 characters.
               
               
               - - -
        :param pulumi.Input[str] etag: Used to perform consistent read-modify-write updates.
        :param pulumi.Input[Sequence[pulumi.Input['AiIndexIndexStatArgs']]] index_stats: Stats of the index resource.
               Structure is documented below.
        :param pulumi.Input[str] index_update_method: The update method to use with this Index. The value must be the followings. If not set, BATCH_UPDATE will be used by default.
               * BATCH_UPDATE: user can call indexes.patch with files on Cloud Storage of datapoints to update.
               * STREAM_UPDATE: user can call indexes.upsertDatapoints/DeleteDatapoints to update the Index and the updates will be applied in corresponding DeployedIndexes in nearly real-time.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: The labels with user-defined metadata to organize your Indexes.
        :param pulumi.Input['AiIndexMetadataArgs'] metadata: An additional information about the Index
               Structure is documented below.
        :param pulumi.Input[str] metadata_schema_uri: Points to a YAML file stored on Google Cloud Storage describing additional information about the Index, that is specific to it. Unset if the Index does not have any additional information.
        :param pulumi.Input[str] name: The resource name of the Index.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: The region of the index. eg us-central1
        :param pulumi.Input[str] update_time: The timestamp of when the Index was last updated in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if deployed_indexes is not None:
            pulumi.set(__self__, "deployed_indexes", deployed_indexes)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if index_stats is not None:
            pulumi.set(__self__, "index_stats", index_stats)
        if index_update_method is not None:
            pulumi.set(__self__, "index_update_method", index_update_method)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if metadata_schema_uri is not None:
            pulumi.set(__self__, "metadata_schema_uri", metadata_schema_uri)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp of when the Index was created in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="deployedIndexes")
    def deployed_indexes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AiIndexDeployedIndexArgs']]]]:
        """
        The pointers to DeployedIndexes created from this Index. An Index can be only deleted if all its DeployedIndexes had been undeployed first.
        Structure is documented below.
        """
        return pulumi.get(self, "deployed_indexes")

    @deployed_indexes.setter
    def deployed_indexes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AiIndexDeployedIndexArgs']]]]):
        pulumi.set(self, "deployed_indexes", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Index.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name of the Index. The name can be up to 128 characters long and can consist of any UTF-8 characters.


        - - -
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        Used to perform consistent read-modify-write updates.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter(name="indexStats")
    def index_stats(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AiIndexIndexStatArgs']]]]:
        """
        Stats of the index resource.
        Structure is documented below.
        """
        return pulumi.get(self, "index_stats")

    @index_stats.setter
    def index_stats(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AiIndexIndexStatArgs']]]]):
        pulumi.set(self, "index_stats", value)

    @property
    @pulumi.getter(name="indexUpdateMethod")
    def index_update_method(self) -> Optional[pulumi.Input[str]]:
        """
        The update method to use with this Index. The value must be the followings. If not set, BATCH_UPDATE will be used by default.
        * BATCH_UPDATE: user can call indexes.patch with files on Cloud Storage of datapoints to update.
        * STREAM_UPDATE: user can call indexes.upsertDatapoints/DeleteDatapoints to update the Index and the updates will be applied in corresponding DeployedIndexes in nearly real-time.
        """
        return pulumi.get(self, "index_update_method")

    @index_update_method.setter
    def index_update_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "index_update_method", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The labels with user-defined metadata to organize your Indexes.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['AiIndexMetadataArgs']]:
        """
        An additional information about the Index
        Structure is documented below.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['AiIndexMetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="metadataSchemaUri")
    def metadata_schema_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Points to a YAML file stored on Google Cloud Storage describing additional information about the Index, that is specific to it. Unset if the Index does not have any additional information.
        """
        return pulumi.get(self, "metadata_schema_uri")

    @metadata_schema_uri.setter
    def metadata_schema_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metadata_schema_uri", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The resource name of the Index.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region of the index. eg us-central1
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp of when the Index was last updated in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)


class AiIndex(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 index_update_method: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 metadata: Optional[pulumi.Input[pulumi.InputType['AiIndexMetadataArgs']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        A representation of a collection of database items organized in a way that allows for approximate nearest neighbor (a.k.a ANN) algorithms search.

        To get more information about Index, see:

        * [API documentation](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.indexes/)

        ## Example Usage
        ### Vertex Ai Index

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bucket = gcp.storage.Bucket("bucket",
            location="us-central1",
            uniform_bucket_level_access=True)
        # The sample data comes from the following link:
        # https://cloud.google.com/vertex-ai/docs/matching-engine/filtering#specify-namespaces-tokens
        data = gcp.storage.BucketObject("data",
            bucket=bucket.name,
            content=\"\"\"{"id": "42", "embedding": [0.5, 1.0], "restricts": [{"namespace": "class", "allow": ["cat", "pet"]},{"namespace": "category", "allow": ["feline"]}]}
        {"id": "43", "embedding": [0.6, 1.0], "restricts": [{"namespace": "class", "allow": ["dog", "pet"]},{"namespace": "category", "allow": ["canine"]}]}
        \"\"\")
        index = gcp.vertex.AiIndex("index",
            labels={
                "foo": "bar",
            },
            region="us-central1",
            display_name="test-index",
            description="index for test",
            metadata=gcp.vertex.AiIndexMetadataArgs(
                contents_delta_uri=bucket.name.apply(lambda name: f"gs://{name}/contents"),
                config=gcp.vertex.AiIndexMetadataConfigArgs(
                    dimensions=2,
                    approximate_neighbors_count=150,
                    shard_size="SHARD_SIZE_SMALL",
                    distance_measure_type="DOT_PRODUCT_DISTANCE",
                    algorithm_config=gcp.vertex.AiIndexMetadataConfigAlgorithmConfigArgs(
                        tree_ah_config=gcp.vertex.AiIndexMetadataConfigAlgorithmConfigTreeAhConfigArgs(
                            leaf_node_embedding_count=500,
                            leaf_nodes_to_search_percent=7,
                        ),
                    ),
                ),
            ),
            index_update_method="BATCH_UPDATE")
        ```
        ### Vertex Ai Index Streaming

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bucket = gcp.storage.Bucket("bucket",
            location="us-central1",
            uniform_bucket_level_access=True)
        # The sample data comes from the following link:
        # https://cloud.google.com/vertex-ai/docs/matching-engine/filtering#specify-namespaces-tokens
        data = gcp.storage.BucketObject("data",
            bucket=bucket.name,
            content=\"\"\"{"id": "42", "embedding": [0.5, 1.0], "restricts": [{"namespace": "class", "allow": ["cat", "pet"]},{"namespace": "category", "allow": ["feline"]}]}
        {"id": "43", "embedding": [0.6, 1.0], "restricts": [{"namespace": "class", "allow": ["dog", "pet"]},{"namespace": "category", "allow": ["canine"]}]}
        \"\"\")
        index = gcp.vertex.AiIndex("index",
            labels={
                "foo": "bar",
            },
            region="us-central1",
            display_name="test-index",
            description="index for test",
            metadata=gcp.vertex.AiIndexMetadataArgs(
                contents_delta_uri=bucket.name.apply(lambda name: f"gs://{name}/contents"),
                config=gcp.vertex.AiIndexMetadataConfigArgs(
                    dimensions=2,
                    shard_size="SHARD_SIZE_LARGE",
                    distance_measure_type="COSINE_DISTANCE",
                    feature_norm_type="UNIT_L2_NORM",
                    algorithm_config=gcp.vertex.AiIndexMetadataConfigAlgorithmConfigArgs(
                        brute_force_config=gcp.vertex.AiIndexMetadataConfigAlgorithmConfigBruteForceConfigArgs(),
                    ),
                ),
            ),
            index_update_method="STREAM_UPDATE")
        ```

        ## Import

        Index can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:vertex/aiIndex:AiIndex default projects/{{project}}/locations/{{region}}/indexes/{{name}}
        ```

        ```sh
         $ pulumi import gcp:vertex/aiIndex:AiIndex default {{project}}/{{region}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:vertex/aiIndex:AiIndex default {{region}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:vertex/aiIndex:AiIndex default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the Index.
        :param pulumi.Input[str] display_name: The display name of the Index. The name can be up to 128 characters long and can consist of any UTF-8 characters.
               
               
               - - -
        :param pulumi.Input[str] index_update_method: The update method to use with this Index. The value must be the followings. If not set, BATCH_UPDATE will be used by default.
               * BATCH_UPDATE: user can call indexes.patch with files on Cloud Storage of datapoints to update.
               * STREAM_UPDATE: user can call indexes.upsertDatapoints/DeleteDatapoints to update the Index and the updates will be applied in corresponding DeployedIndexes in nearly real-time.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: The labels with user-defined metadata to organize your Indexes.
        :param pulumi.Input[pulumi.InputType['AiIndexMetadataArgs']] metadata: An additional information about the Index
               Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: The region of the index. eg us-central1
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AiIndexArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A representation of a collection of database items organized in a way that allows for approximate nearest neighbor (a.k.a ANN) algorithms search.

        To get more information about Index, see:

        * [API documentation](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.indexes/)

        ## Example Usage
        ### Vertex Ai Index

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bucket = gcp.storage.Bucket("bucket",
            location="us-central1",
            uniform_bucket_level_access=True)
        # The sample data comes from the following link:
        # https://cloud.google.com/vertex-ai/docs/matching-engine/filtering#specify-namespaces-tokens
        data = gcp.storage.BucketObject("data",
            bucket=bucket.name,
            content=\"\"\"{"id": "42", "embedding": [0.5, 1.0], "restricts": [{"namespace": "class", "allow": ["cat", "pet"]},{"namespace": "category", "allow": ["feline"]}]}
        {"id": "43", "embedding": [0.6, 1.0], "restricts": [{"namespace": "class", "allow": ["dog", "pet"]},{"namespace": "category", "allow": ["canine"]}]}
        \"\"\")
        index = gcp.vertex.AiIndex("index",
            labels={
                "foo": "bar",
            },
            region="us-central1",
            display_name="test-index",
            description="index for test",
            metadata=gcp.vertex.AiIndexMetadataArgs(
                contents_delta_uri=bucket.name.apply(lambda name: f"gs://{name}/contents"),
                config=gcp.vertex.AiIndexMetadataConfigArgs(
                    dimensions=2,
                    approximate_neighbors_count=150,
                    shard_size="SHARD_SIZE_SMALL",
                    distance_measure_type="DOT_PRODUCT_DISTANCE",
                    algorithm_config=gcp.vertex.AiIndexMetadataConfigAlgorithmConfigArgs(
                        tree_ah_config=gcp.vertex.AiIndexMetadataConfigAlgorithmConfigTreeAhConfigArgs(
                            leaf_node_embedding_count=500,
                            leaf_nodes_to_search_percent=7,
                        ),
                    ),
                ),
            ),
            index_update_method="BATCH_UPDATE")
        ```
        ### Vertex Ai Index Streaming

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bucket = gcp.storage.Bucket("bucket",
            location="us-central1",
            uniform_bucket_level_access=True)
        # The sample data comes from the following link:
        # https://cloud.google.com/vertex-ai/docs/matching-engine/filtering#specify-namespaces-tokens
        data = gcp.storage.BucketObject("data",
            bucket=bucket.name,
            content=\"\"\"{"id": "42", "embedding": [0.5, 1.0], "restricts": [{"namespace": "class", "allow": ["cat", "pet"]},{"namespace": "category", "allow": ["feline"]}]}
        {"id": "43", "embedding": [0.6, 1.0], "restricts": [{"namespace": "class", "allow": ["dog", "pet"]},{"namespace": "category", "allow": ["canine"]}]}
        \"\"\")
        index = gcp.vertex.AiIndex("index",
            labels={
                "foo": "bar",
            },
            region="us-central1",
            display_name="test-index",
            description="index for test",
            metadata=gcp.vertex.AiIndexMetadataArgs(
                contents_delta_uri=bucket.name.apply(lambda name: f"gs://{name}/contents"),
                config=gcp.vertex.AiIndexMetadataConfigArgs(
                    dimensions=2,
                    shard_size="SHARD_SIZE_LARGE",
                    distance_measure_type="COSINE_DISTANCE",
                    feature_norm_type="UNIT_L2_NORM",
                    algorithm_config=gcp.vertex.AiIndexMetadataConfigAlgorithmConfigArgs(
                        brute_force_config=gcp.vertex.AiIndexMetadataConfigAlgorithmConfigBruteForceConfigArgs(),
                    ),
                ),
            ),
            index_update_method="STREAM_UPDATE")
        ```

        ## Import

        Index can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:vertex/aiIndex:AiIndex default projects/{{project}}/locations/{{region}}/indexes/{{name}}
        ```

        ```sh
         $ pulumi import gcp:vertex/aiIndex:AiIndex default {{project}}/{{region}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:vertex/aiIndex:AiIndex default {{region}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:vertex/aiIndex:AiIndex default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param AiIndexArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AiIndexArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 index_update_method: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 metadata: Optional[pulumi.Input[pulumi.InputType['AiIndexMetadataArgs']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AiIndexArgs.__new__(AiIndexArgs)

            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["index_update_method"] = index_update_method
            __props__.__dict__["labels"] = labels
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["project"] = project
            __props__.__dict__["region"] = region
            __props__.__dict__["create_time"] = None
            __props__.__dict__["deployed_indexes"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["index_stats"] = None
            __props__.__dict__["metadata_schema_uri"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["update_time"] = None
        super(AiIndex, __self__).__init__(
            'gcp:vertex/aiIndex:AiIndex',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            deployed_indexes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AiIndexDeployedIndexArgs']]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            etag: Optional[pulumi.Input[str]] = None,
            index_stats: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AiIndexIndexStatArgs']]]]] = None,
            index_update_method: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            metadata: Optional[pulumi.Input[pulumi.InputType['AiIndexMetadataArgs']]] = None,
            metadata_schema_uri: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            update_time: Optional[pulumi.Input[str]] = None) -> 'AiIndex':
        """
        Get an existing AiIndex resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] create_time: The timestamp of when the Index was created in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AiIndexDeployedIndexArgs']]]] deployed_indexes: The pointers to DeployedIndexes created from this Index. An Index can be only deleted if all its DeployedIndexes had been undeployed first.
               Structure is documented below.
        :param pulumi.Input[str] description: The description of the Index.
        :param pulumi.Input[str] display_name: The display name of the Index. The name can be up to 128 characters long and can consist of any UTF-8 characters.
               
               
               - - -
        :param pulumi.Input[str] etag: Used to perform consistent read-modify-write updates.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AiIndexIndexStatArgs']]]] index_stats: Stats of the index resource.
               Structure is documented below.
        :param pulumi.Input[str] index_update_method: The update method to use with this Index. The value must be the followings. If not set, BATCH_UPDATE will be used by default.
               * BATCH_UPDATE: user can call indexes.patch with files on Cloud Storage of datapoints to update.
               * STREAM_UPDATE: user can call indexes.upsertDatapoints/DeleteDatapoints to update the Index and the updates will be applied in corresponding DeployedIndexes in nearly real-time.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: The labels with user-defined metadata to organize your Indexes.
        :param pulumi.Input[pulumi.InputType['AiIndexMetadataArgs']] metadata: An additional information about the Index
               Structure is documented below.
        :param pulumi.Input[str] metadata_schema_uri: Points to a YAML file stored on Google Cloud Storage describing additional information about the Index, that is specific to it. Unset if the Index does not have any additional information.
        :param pulumi.Input[str] name: The resource name of the Index.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: The region of the index. eg us-central1
        :param pulumi.Input[str] update_time: The timestamp of when the Index was last updated in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AiIndexState.__new__(_AiIndexState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["deployed_indexes"] = deployed_indexes
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["etag"] = etag
        __props__.__dict__["index_stats"] = index_stats
        __props__.__dict__["index_update_method"] = index_update_method
        __props__.__dict__["labels"] = labels
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["metadata_schema_uri"] = metadata_schema_uri
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["region"] = region
        __props__.__dict__["update_time"] = update_time
        return AiIndex(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The timestamp of when the Index was created in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="deployedIndexes")
    def deployed_indexes(self) -> pulumi.Output[Sequence['outputs.AiIndexDeployedIndex']]:
        """
        The pointers to DeployedIndexes created from this Index. An Index can be only deleted if all its DeployedIndexes had been undeployed first.
        Structure is documented below.
        """
        return pulumi.get(self, "deployed_indexes")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the Index.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        The display name of the Index. The name can be up to 128 characters long and can consist of any UTF-8 characters.


        - - -
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        """
        Used to perform consistent read-modify-write updates.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="indexStats")
    def index_stats(self) -> pulumi.Output[Sequence['outputs.AiIndexIndexStat']]:
        """
        Stats of the index resource.
        Structure is documented below.
        """
        return pulumi.get(self, "index_stats")

    @property
    @pulumi.getter(name="indexUpdateMethod")
    def index_update_method(self) -> pulumi.Output[Optional[str]]:
        """
        The update method to use with this Index. The value must be the followings. If not set, BATCH_UPDATE will be used by default.
        * BATCH_UPDATE: user can call indexes.patch with files on Cloud Storage of datapoints to update.
        * STREAM_UPDATE: user can call indexes.upsertDatapoints/DeleteDatapoints to update the Index and the updates will be applied in corresponding DeployedIndexes in nearly real-time.
        """
        return pulumi.get(self, "index_update_method")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        The labels with user-defined metadata to organize your Indexes.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Optional['outputs.AiIndexMetadata']]:
        """
        An additional information about the Index
        Structure is documented below.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="metadataSchemaUri")
    def metadata_schema_uri(self) -> pulumi.Output[str]:
        """
        Points to a YAML file stored on Google Cloud Storage describing additional information about the Index, that is specific to it. Unset if the Index does not have any additional information.
        """
        return pulumi.get(self, "metadata_schema_uri")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The resource name of the Index.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[str]]:
        """
        The region of the index. eg us-central1
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The timestamp of when the Index was last updated in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "update_time")

