# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WorkstationConfigArgs', 'WorkstationConfig']

@pulumi.input_type
class WorkstationConfigArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[str],
                 workstation_cluster_id: pulumi.Input[str],
                 workstation_config_id: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 container: Optional[pulumi.Input['WorkstationConfigContainerArgs']] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 encryption_key: Optional[pulumi.Input['WorkstationConfigEncryptionKeyArgs']] = None,
                 host: Optional[pulumi.Input['WorkstationConfigHostArgs']] = None,
                 idle_timeout: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 persistent_directories: Optional[pulumi.Input[Sequence[pulumi.Input['WorkstationConfigPersistentDirectoryArgs']]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 running_timeout: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a WorkstationConfig resource.
        :param pulumi.Input[str] location: The location where the workstation cluster config should reside.
               
               
               - - -
        :param pulumi.Input[str] workstation_cluster_id: The ID of the parent workstation cluster.
        :param pulumi.Input[str] workstation_config_id: The ID to be assigned to the workstation cluster config.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Client-specified annotations. This is distinct from labels.
        :param pulumi.Input['WorkstationConfigContainerArgs'] container: Container that will be run for each workstation using this configuration when that workstation is started.
               Structure is documented below.
        :param pulumi.Input[str] display_name: Human-readable name for this resource.
        :param pulumi.Input['WorkstationConfigEncryptionKeyArgs'] encryption_key: Encrypts resources of this workstation configuration using a customer-managed encryption key.
               If specified, the boot disk of the Compute Engine instance and the persistent disk are encrypted using this encryption key. If this field is not set, the disks are encrypted using a generated key. Customer-managed encryption keys do not protect disk metadata.
               If the customer-managed encryption key is rotated, when the workstation instance is stopped, the system attempts to recreate the persistent disk with the new version of the key. Be sure to keep older versions of the key until the persistent disk is recreated. Otherwise, data on the persistent disk will be lost.
               If the encryption key is revoked, the workstation session will automatically be stopped within 7 hours.
               Structure is documented below.
        :param pulumi.Input['WorkstationConfigHostArgs'] host: Runtime host for a workstation.
               Structure is documented below.
        :param pulumi.Input[str] idle_timeout: How long to wait before automatically stopping an instance that hasn't recently received any user traffic. A value of 0 indicates that this instance should never time out from idleness. Defaults to 20 minutes.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Client-specified labels that are applied to the resource and that are also propagated to the underlying Compute Engine resources.
        :param pulumi.Input[Sequence[pulumi.Input['WorkstationConfigPersistentDirectoryArgs']]] persistent_directories: Directories to persist across workstation sessions.
               Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] running_timeout: How long to wait before automatically stopping a workstation after it was started. A value of 0 indicates that workstations using this configuration should never time out from running duration. Must be greater than 0 and less than 24 hours if `encryption_key` is set. Defaults to 12 hours.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "workstation_cluster_id", workstation_cluster_id)
        pulumi.set(__self__, "workstation_config_id", workstation_config_id)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if container is not None:
            pulumi.set(__self__, "container", container)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if idle_timeout is not None:
            pulumi.set(__self__, "idle_timeout", idle_timeout)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if persistent_directories is not None:
            pulumi.set(__self__, "persistent_directories", persistent_directories)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if running_timeout is not None:
            pulumi.set(__self__, "running_timeout", running_timeout)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        The location where the workstation cluster config should reside.


        - - -
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="workstationClusterId")
    def workstation_cluster_id(self) -> pulumi.Input[str]:
        """
        The ID of the parent workstation cluster.
        """
        return pulumi.get(self, "workstation_cluster_id")

    @workstation_cluster_id.setter
    def workstation_cluster_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "workstation_cluster_id", value)

    @property
    @pulumi.getter(name="workstationConfigId")
    def workstation_config_id(self) -> pulumi.Input[str]:
        """
        The ID to be assigned to the workstation cluster config.
        """
        return pulumi.get(self, "workstation_config_id")

    @workstation_config_id.setter
    def workstation_config_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "workstation_config_id", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Client-specified annotations. This is distinct from labels.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def container(self) -> Optional[pulumi.Input['WorkstationConfigContainerArgs']]:
        """
        Container that will be run for each workstation using this configuration when that workstation is started.
        Structure is documented below.
        """
        return pulumi.get(self, "container")

    @container.setter
    def container(self, value: Optional[pulumi.Input['WorkstationConfigContainerArgs']]):
        pulumi.set(self, "container", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable name for this resource.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional[pulumi.Input['WorkstationConfigEncryptionKeyArgs']]:
        """
        Encrypts resources of this workstation configuration using a customer-managed encryption key.
        If specified, the boot disk of the Compute Engine instance and the persistent disk are encrypted using this encryption key. If this field is not set, the disks are encrypted using a generated key. Customer-managed encryption keys do not protect disk metadata.
        If the customer-managed encryption key is rotated, when the workstation instance is stopped, the system attempts to recreate the persistent disk with the new version of the key. Be sure to keep older versions of the key until the persistent disk is recreated. Otherwise, data on the persistent disk will be lost.
        If the encryption key is revoked, the workstation session will automatically be stopped within 7 hours.
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_key")

    @encryption_key.setter
    def encryption_key(self, value: Optional[pulumi.Input['WorkstationConfigEncryptionKeyArgs']]):
        pulumi.set(self, "encryption_key", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input['WorkstationConfigHostArgs']]:
        """
        Runtime host for a workstation.
        Structure is documented below.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input['WorkstationConfigHostArgs']]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> Optional[pulumi.Input[str]]:
        """
        How long to wait before automatically stopping an instance that hasn't recently received any user traffic. A value of 0 indicates that this instance should never time out from idleness. Defaults to 20 minutes.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "idle_timeout")

    @idle_timeout.setter
    def idle_timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idle_timeout", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Client-specified labels that are applied to the resource and that are also propagated to the underlying Compute Engine resources.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="persistentDirectories")
    def persistent_directories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkstationConfigPersistentDirectoryArgs']]]]:
        """
        Directories to persist across workstation sessions.
        Structure is documented below.
        """
        return pulumi.get(self, "persistent_directories")

    @persistent_directories.setter
    def persistent_directories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkstationConfigPersistentDirectoryArgs']]]]):
        pulumi.set(self, "persistent_directories", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="runningTimeout")
    def running_timeout(self) -> Optional[pulumi.Input[str]]:
        """
        How long to wait before automatically stopping a workstation after it was started. A value of 0 indicates that workstations using this configuration should never time out from running duration. Must be greater than 0 and less than 24 hours if `encryption_key` is set. Defaults to 12 hours.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "running_timeout")

    @running_timeout.setter
    def running_timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "running_timeout", value)


@pulumi.input_type
class _WorkstationConfigState:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['WorkstationConfigConditionArgs']]]] = None,
                 container: Optional[pulumi.Input['WorkstationConfigContainerArgs']] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 degraded: Optional[pulumi.Input[bool]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 encryption_key: Optional[pulumi.Input['WorkstationConfigEncryptionKeyArgs']] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 host: Optional[pulumi.Input['WorkstationConfigHostArgs']] = None,
                 idle_timeout: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 persistent_directories: Optional[pulumi.Input[Sequence[pulumi.Input['WorkstationConfigPersistentDirectoryArgs']]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 running_timeout: Optional[pulumi.Input[str]] = None,
                 uid: Optional[pulumi.Input[str]] = None,
                 workstation_cluster_id: Optional[pulumi.Input[str]] = None,
                 workstation_config_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering WorkstationConfig resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Client-specified annotations. This is distinct from labels.
        :param pulumi.Input[Sequence[pulumi.Input['WorkstationConfigConditionArgs']]] conditions: Status conditions describing the current resource state.
               Structure is documented below.
        :param pulumi.Input['WorkstationConfigContainerArgs'] container: Container that will be run for each workstation using this configuration when that workstation is started.
               Structure is documented below.
        :param pulumi.Input[str] create_time: Time when this resource was created.
        :param pulumi.Input[bool] degraded: Whether this resource is in degraded mode, in which case it may require user action to restore full functionality. Details can be found in the conditions field.
        :param pulumi.Input[str] display_name: Human-readable name for this resource.
        :param pulumi.Input['WorkstationConfigEncryptionKeyArgs'] encryption_key: Encrypts resources of this workstation configuration using a customer-managed encryption key.
               If specified, the boot disk of the Compute Engine instance and the persistent disk are encrypted using this encryption key. If this field is not set, the disks are encrypted using a generated key. Customer-managed encryption keys do not protect disk metadata.
               If the customer-managed encryption key is rotated, when the workstation instance is stopped, the system attempts to recreate the persistent disk with the new version of the key. Be sure to keep older versions of the key until the persistent disk is recreated. Otherwise, data on the persistent disk will be lost.
               If the encryption key is revoked, the workstation session will automatically be stopped within 7 hours.
               Structure is documented below.
        :param pulumi.Input[str] etag: Checksum computed by the server.
               May be sent on update and delete requests to ensure that the client has an up-to-date value before proceeding.
        :param pulumi.Input['WorkstationConfigHostArgs'] host: Runtime host for a workstation.
               Structure is documented below.
        :param pulumi.Input[str] idle_timeout: How long to wait before automatically stopping an instance that hasn't recently received any user traffic. A value of 0 indicates that this instance should never time out from idleness. Defaults to 20 minutes.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Client-specified labels that are applied to the resource and that are also propagated to the underlying Compute Engine resources.
        :param pulumi.Input[str] location: The location where the workstation cluster config should reside.
               
               
               - - -
        :param pulumi.Input[str] name: Full name of this resource.
        :param pulumi.Input[Sequence[pulumi.Input['WorkstationConfigPersistentDirectoryArgs']]] persistent_directories: Directories to persist across workstation sessions.
               Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] running_timeout: How long to wait before automatically stopping a workstation after it was started. A value of 0 indicates that workstations using this configuration should never time out from running duration. Must be greater than 0 and less than 24 hours if `encryption_key` is set. Defaults to 12 hours.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        :param pulumi.Input[str] uid: The system-generated UID of the resource.
        :param pulumi.Input[str] workstation_cluster_id: The ID of the parent workstation cluster.
        :param pulumi.Input[str] workstation_config_id: The ID to be assigned to the workstation cluster config.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if container is not None:
            pulumi.set(__self__, "container", container)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if degraded is not None:
            pulumi.set(__self__, "degraded", degraded)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if idle_timeout is not None:
            pulumi.set(__self__, "idle_timeout", idle_timeout)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if persistent_directories is not None:
            pulumi.set(__self__, "persistent_directories", persistent_directories)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if running_timeout is not None:
            pulumi.set(__self__, "running_timeout", running_timeout)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if workstation_cluster_id is not None:
            pulumi.set(__self__, "workstation_cluster_id", workstation_cluster_id)
        if workstation_config_id is not None:
            pulumi.set(__self__, "workstation_config_id", workstation_config_id)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Client-specified annotations. This is distinct from labels.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkstationConfigConditionArgs']]]]:
        """
        Status conditions describing the current resource state.
        Structure is documented below.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkstationConfigConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def container(self) -> Optional[pulumi.Input['WorkstationConfigContainerArgs']]:
        """
        Container that will be run for each workstation using this configuration when that workstation is started.
        Structure is documented below.
        """
        return pulumi.get(self, "container")

    @container.setter
    def container(self, value: Optional[pulumi.Input['WorkstationConfigContainerArgs']]):
        pulumi.set(self, "container", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time when this resource was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def degraded(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this resource is in degraded mode, in which case it may require user action to restore full functionality. Details can be found in the conditions field.
        """
        return pulumi.get(self, "degraded")

    @degraded.setter
    def degraded(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "degraded", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable name for this resource.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional[pulumi.Input['WorkstationConfigEncryptionKeyArgs']]:
        """
        Encrypts resources of this workstation configuration using a customer-managed encryption key.
        If specified, the boot disk of the Compute Engine instance and the persistent disk are encrypted using this encryption key. If this field is not set, the disks are encrypted using a generated key. Customer-managed encryption keys do not protect disk metadata.
        If the customer-managed encryption key is rotated, when the workstation instance is stopped, the system attempts to recreate the persistent disk with the new version of the key. Be sure to keep older versions of the key until the persistent disk is recreated. Otherwise, data on the persistent disk will be lost.
        If the encryption key is revoked, the workstation session will automatically be stopped within 7 hours.
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_key")

    @encryption_key.setter
    def encryption_key(self, value: Optional[pulumi.Input['WorkstationConfigEncryptionKeyArgs']]):
        pulumi.set(self, "encryption_key", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        Checksum computed by the server.
        May be sent on update and delete requests to ensure that the client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input['WorkstationConfigHostArgs']]:
        """
        Runtime host for a workstation.
        Structure is documented below.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input['WorkstationConfigHostArgs']]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> Optional[pulumi.Input[str]]:
        """
        How long to wait before automatically stopping an instance that hasn't recently received any user traffic. A value of 0 indicates that this instance should never time out from idleness. Defaults to 20 minutes.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "idle_timeout")

    @idle_timeout.setter
    def idle_timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idle_timeout", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Client-specified labels that are applied to the resource and that are also propagated to the underlying Compute Engine resources.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location where the workstation cluster config should reside.


        - - -
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Full name of this resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="persistentDirectories")
    def persistent_directories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkstationConfigPersistentDirectoryArgs']]]]:
        """
        Directories to persist across workstation sessions.
        Structure is documented below.
        """
        return pulumi.get(self, "persistent_directories")

    @persistent_directories.setter
    def persistent_directories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkstationConfigPersistentDirectoryArgs']]]]):
        pulumi.set(self, "persistent_directories", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="runningTimeout")
    def running_timeout(self) -> Optional[pulumi.Input[str]]:
        """
        How long to wait before automatically stopping a workstation after it was started. A value of 0 indicates that workstations using this configuration should never time out from running duration. Must be greater than 0 and less than 24 hours if `encryption_key` is set. Defaults to 12 hours.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "running_timeout")

    @running_timeout.setter
    def running_timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "running_timeout", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        The system-generated UID of the resource.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="workstationClusterId")
    def workstation_cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the parent workstation cluster.
        """
        return pulumi.get(self, "workstation_cluster_id")

    @workstation_cluster_id.setter
    def workstation_cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workstation_cluster_id", value)

    @property
    @pulumi.getter(name="workstationConfigId")
    def workstation_config_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID to be assigned to the workstation cluster config.
        """
        return pulumi.get(self, "workstation_config_id")

    @workstation_config_id.setter
    def workstation_config_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workstation_config_id", value)


class WorkstationConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 container: Optional[pulumi.Input[pulumi.InputType['WorkstationConfigContainerArgs']]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 encryption_key: Optional[pulumi.Input[pulumi.InputType['WorkstationConfigEncryptionKeyArgs']]] = None,
                 host: Optional[pulumi.Input[pulumi.InputType['WorkstationConfigHostArgs']]] = None,
                 idle_timeout: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 persistent_directories: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WorkstationConfigPersistentDirectoryArgs']]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 running_timeout: Optional[pulumi.Input[str]] = None,
                 workstation_cluster_id: Optional[pulumi.Input[str]] = None,
                 workstation_config_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage
        ### Workstation Config Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_network = gcp.compute.Network("defaultNetwork", auto_create_subnetworks=False,
        opts=pulumi.ResourceOptions(provider=google_beta))
        default_subnetwork = gcp.compute.Subnetwork("defaultSubnetwork",
            ip_cidr_range="10.0.0.0/24",
            region="us-central1",
            network=default_network.name,
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_workstation_cluster = gcp.workstations.WorkstationCluster("defaultWorkstationCluster",
            workstation_cluster_id="workstation-cluster",
            network=default_network.id,
            subnetwork=default_subnetwork.id,
            location="us-central1",
            labels={
                "label": "key",
            },
            annotations={
                "label-one": "value-one",
            },
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_workstation_config = gcp.workstations.WorkstationConfig("defaultWorkstationConfig",
            workstation_config_id="workstation-config",
            workstation_cluster_id=default_workstation_cluster.workstation_cluster_id,
            location="us-central1",
            idle_timeout="600s",
            running_timeout="21600s",
            host=gcp.workstations.WorkstationConfigHostArgs(
                gce_instance=gcp.workstations.WorkstationConfigHostGceInstanceArgs(
                    machine_type="e2-standard-4",
                    boot_disk_size_gb=35,
                    disable_public_ip_addresses=True,
                ),
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Workstation Config Container

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_network = gcp.compute.Network("defaultNetwork", auto_create_subnetworks=False,
        opts=pulumi.ResourceOptions(provider=google_beta))
        default_subnetwork = gcp.compute.Subnetwork("defaultSubnetwork",
            ip_cidr_range="10.0.0.0/24",
            region="us-central1",
            network=default_network.name,
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_workstation_cluster = gcp.workstations.WorkstationCluster("defaultWorkstationCluster",
            workstation_cluster_id="workstation-cluster",
            network=default_network.id,
            subnetwork=default_subnetwork.id,
            location="us-central1",
            labels={
                "label": "key",
            },
            annotations={
                "label-one": "value-one",
            },
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_workstation_config = gcp.workstations.WorkstationConfig("defaultWorkstationConfig",
            workstation_config_id="workstation-config",
            workstation_cluster_id=default_workstation_cluster.workstation_cluster_id,
            location="us-central1",
            host=gcp.workstations.WorkstationConfigHostArgs(
                gce_instance=gcp.workstations.WorkstationConfigHostGceInstanceArgs(
                    machine_type="e2-standard-4",
                    boot_disk_size_gb=35,
                    disable_public_ip_addresses=True,
                ),
            ),
            container=gcp.workstations.WorkstationConfigContainerArgs(
                image="intellij",
                env={
                    "NAME": "FOO",
                    "BABE": "bar",
                },
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Workstation Config Persistent Directories

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_network = gcp.compute.Network("defaultNetwork", auto_create_subnetworks=False,
        opts=pulumi.ResourceOptions(provider=google_beta))
        default_subnetwork = gcp.compute.Subnetwork("defaultSubnetwork",
            ip_cidr_range="10.0.0.0/24",
            region="us-central1",
            network=default_network.name,
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_workstation_cluster = gcp.workstations.WorkstationCluster("defaultWorkstationCluster",
            workstation_cluster_id="workstation-cluster",
            network=default_network.id,
            subnetwork=default_subnetwork.id,
            location="us-central1",
            labels={
                "label": "key",
            },
            annotations={
                "label-one": "value-one",
            },
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_workstation_config = gcp.workstations.WorkstationConfig("defaultWorkstationConfig",
            workstation_config_id="workstation-config",
            workstation_cluster_id=default_workstation_cluster.workstation_cluster_id,
            location="us-central1",
            host=gcp.workstations.WorkstationConfigHostArgs(
                gce_instance=gcp.workstations.WorkstationConfigHostGceInstanceArgs(
                    machine_type="e2-standard-4",
                    boot_disk_size_gb=35,
                    disable_public_ip_addresses=True,
                    shielded_instance_config=gcp.workstations.WorkstationConfigHostGceInstanceShieldedInstanceConfigArgs(
                        enable_secure_boot=True,
                        enable_vtpm=True,
                    ),
                ),
            ),
            persistent_directories=[gcp.workstations.WorkstationConfigPersistentDirectoryArgs(
                mount_path="/home",
                gce_pd=gcp.workstations.WorkstationConfigPersistentDirectoryGcePdArgs(
                    size_gb=200,
                    fs_type="ext4",
                    disk_type="pd-standard",
                    reclaim_policy="DELETE",
                ),
            )],
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Workstation Config Source Snapshot

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_network = gcp.compute.Network("defaultNetwork", auto_create_subnetworks=False,
        opts=pulumi.ResourceOptions(provider=google_beta))
        default_subnetwork = gcp.compute.Subnetwork("defaultSubnetwork",
            ip_cidr_range="10.0.0.0/24",
            region="us-central1",
            network=default_network.name,
            opts=pulumi.ResourceOptions(provider=google_beta))
        my_source_disk = gcp.compute.Disk("mySourceDisk",
            size=10,
            type="pd-ssd",
            zone="us-central1-a",
            opts=pulumi.ResourceOptions(provider=google_beta))
        my_source_snapshot = gcp.compute.Snapshot("mySourceSnapshot",
            source_disk=my_source_disk.name,
            zone="us-central1-a",
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_workstation_cluster = gcp.workstations.WorkstationCluster("defaultWorkstationCluster",
            workstation_cluster_id="workstation-cluster",
            network=default_network.id,
            subnetwork=default_subnetwork.id,
            location="us-central1",
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_workstation_config = gcp.workstations.WorkstationConfig("defaultWorkstationConfig",
            workstation_config_id="workstation-config",
            workstation_cluster_id=default_workstation_cluster.workstation_cluster_id,
            location=default_workstation_cluster.location,
            persistent_directories=[gcp.workstations.WorkstationConfigPersistentDirectoryArgs(
                mount_path="/home",
                gce_pd=gcp.workstations.WorkstationConfigPersistentDirectoryGcePdArgs(
                    source_snapshot=my_source_snapshot.id,
                    reclaim_policy="DELETE",
                ),
            )],
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Workstation Config Shielded Instance Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_network = gcp.compute.Network("defaultNetwork", auto_create_subnetworks=False,
        opts=pulumi.ResourceOptions(provider=google_beta))
        default_subnetwork = gcp.compute.Subnetwork("defaultSubnetwork",
            ip_cidr_range="10.0.0.0/24",
            region="us-central1",
            network=default_network.name,
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_workstation_cluster = gcp.workstations.WorkstationCluster("defaultWorkstationCluster",
            workstation_cluster_id="workstation-cluster",
            network=default_network.id,
            subnetwork=default_subnetwork.id,
            location="us-central1",
            labels={
                "label": "key",
            },
            annotations={
                "label-one": "value-one",
            },
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_workstation_config = gcp.workstations.WorkstationConfig("defaultWorkstationConfig",
            workstation_config_id="workstation-config",
            workstation_cluster_id=default_workstation_cluster.workstation_cluster_id,
            location="us-central1",
            host=gcp.workstations.WorkstationConfigHostArgs(
                gce_instance=gcp.workstations.WorkstationConfigHostGceInstanceArgs(
                    machine_type="e2-standard-4",
                    boot_disk_size_gb=35,
                    disable_public_ip_addresses=True,
                    shielded_instance_config=gcp.workstations.WorkstationConfigHostGceInstanceShieldedInstanceConfigArgs(
                        enable_secure_boot=True,
                        enable_vtpm=True,
                    ),
                ),
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Workstation Config Encryption Key

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_network = gcp.compute.Network("defaultNetwork", auto_create_subnetworks=False,
        opts=pulumi.ResourceOptions(provider=google_beta))
        default_subnetwork = gcp.compute.Subnetwork("defaultSubnetwork",
            ip_cidr_range="10.0.0.0/24",
            region="us-central1",
            network=default_network.name,
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_workstation_cluster = gcp.workstations.WorkstationCluster("defaultWorkstationCluster",
            workstation_cluster_id="workstation-cluster",
            network=default_network.id,
            subnetwork=default_subnetwork.id,
            location="us-central1",
            labels={
                "label": "key",
            },
            annotations={
                "label-one": "value-one",
            },
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_key_ring = gcp.kms.KeyRing("defaultKeyRing", location="us-central1",
        opts=pulumi.ResourceOptions(provider=google_beta))
        default_crypto_key = gcp.kms.CryptoKey("defaultCryptoKey", key_ring=default_key_ring.id,
        opts=pulumi.ResourceOptions(provider=google_beta))
        default_account = gcp.service_account.Account("defaultAccount",
            account_id="my-account",
            display_name="Service Account",
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_workstation_config = gcp.workstations.WorkstationConfig("defaultWorkstationConfig",
            workstation_config_id="workstation-config",
            workstation_cluster_id=default_workstation_cluster.workstation_cluster_id,
            location="us-central1",
            host=gcp.workstations.WorkstationConfigHostArgs(
                gce_instance=gcp.workstations.WorkstationConfigHostGceInstanceArgs(
                    machine_type="e2-standard-4",
                    boot_disk_size_gb=35,
                    disable_public_ip_addresses=True,
                    shielded_instance_config=gcp.workstations.WorkstationConfigHostGceInstanceShieldedInstanceConfigArgs(
                        enable_secure_boot=True,
                        enable_vtpm=True,
                    ),
                ),
            ),
            encryption_key=gcp.workstations.WorkstationConfigEncryptionKeyArgs(
                kms_key=default_crypto_key.id,
                kms_key_service_account=default_account.email,
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```

        ## Import

        WorkstationConfig can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:workstations/workstationConfig:WorkstationConfig default projects/{{project}}/locations/{{location}}/workstationClusters/{{workstation_cluster_id}}/workstationConfigs/{{workstation_config_id}}
        ```

        ```sh
         $ pulumi import gcp:workstations/workstationConfig:WorkstationConfig default {{project}}/{{location}}/{{workstation_cluster_id}}/{{workstation_config_id}}
        ```

        ```sh
         $ pulumi import gcp:workstations/workstationConfig:WorkstationConfig default {{location}}/{{workstation_cluster_id}}/{{workstation_config_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Client-specified annotations. This is distinct from labels.
        :param pulumi.Input[pulumi.InputType['WorkstationConfigContainerArgs']] container: Container that will be run for each workstation using this configuration when that workstation is started.
               Structure is documented below.
        :param pulumi.Input[str] display_name: Human-readable name for this resource.
        :param pulumi.Input[pulumi.InputType['WorkstationConfigEncryptionKeyArgs']] encryption_key: Encrypts resources of this workstation configuration using a customer-managed encryption key.
               If specified, the boot disk of the Compute Engine instance and the persistent disk are encrypted using this encryption key. If this field is not set, the disks are encrypted using a generated key. Customer-managed encryption keys do not protect disk metadata.
               If the customer-managed encryption key is rotated, when the workstation instance is stopped, the system attempts to recreate the persistent disk with the new version of the key. Be sure to keep older versions of the key until the persistent disk is recreated. Otherwise, data on the persistent disk will be lost.
               If the encryption key is revoked, the workstation session will automatically be stopped within 7 hours.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['WorkstationConfigHostArgs']] host: Runtime host for a workstation.
               Structure is documented below.
        :param pulumi.Input[str] idle_timeout: How long to wait before automatically stopping an instance that hasn't recently received any user traffic. A value of 0 indicates that this instance should never time out from idleness. Defaults to 20 minutes.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Client-specified labels that are applied to the resource and that are also propagated to the underlying Compute Engine resources.
        :param pulumi.Input[str] location: The location where the workstation cluster config should reside.
               
               
               - - -
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WorkstationConfigPersistentDirectoryArgs']]]] persistent_directories: Directories to persist across workstation sessions.
               Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] running_timeout: How long to wait before automatically stopping a workstation after it was started. A value of 0 indicates that workstations using this configuration should never time out from running duration. Must be greater than 0 and less than 24 hours if `encryption_key` is set. Defaults to 12 hours.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        :param pulumi.Input[str] workstation_cluster_id: The ID of the parent workstation cluster.
        :param pulumi.Input[str] workstation_config_id: The ID to be assigned to the workstation cluster config.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkstationConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage
        ### Workstation Config Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_network = gcp.compute.Network("defaultNetwork", auto_create_subnetworks=False,
        opts=pulumi.ResourceOptions(provider=google_beta))
        default_subnetwork = gcp.compute.Subnetwork("defaultSubnetwork",
            ip_cidr_range="10.0.0.0/24",
            region="us-central1",
            network=default_network.name,
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_workstation_cluster = gcp.workstations.WorkstationCluster("defaultWorkstationCluster",
            workstation_cluster_id="workstation-cluster",
            network=default_network.id,
            subnetwork=default_subnetwork.id,
            location="us-central1",
            labels={
                "label": "key",
            },
            annotations={
                "label-one": "value-one",
            },
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_workstation_config = gcp.workstations.WorkstationConfig("defaultWorkstationConfig",
            workstation_config_id="workstation-config",
            workstation_cluster_id=default_workstation_cluster.workstation_cluster_id,
            location="us-central1",
            idle_timeout="600s",
            running_timeout="21600s",
            host=gcp.workstations.WorkstationConfigHostArgs(
                gce_instance=gcp.workstations.WorkstationConfigHostGceInstanceArgs(
                    machine_type="e2-standard-4",
                    boot_disk_size_gb=35,
                    disable_public_ip_addresses=True,
                ),
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Workstation Config Container

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_network = gcp.compute.Network("defaultNetwork", auto_create_subnetworks=False,
        opts=pulumi.ResourceOptions(provider=google_beta))
        default_subnetwork = gcp.compute.Subnetwork("defaultSubnetwork",
            ip_cidr_range="10.0.0.0/24",
            region="us-central1",
            network=default_network.name,
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_workstation_cluster = gcp.workstations.WorkstationCluster("defaultWorkstationCluster",
            workstation_cluster_id="workstation-cluster",
            network=default_network.id,
            subnetwork=default_subnetwork.id,
            location="us-central1",
            labels={
                "label": "key",
            },
            annotations={
                "label-one": "value-one",
            },
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_workstation_config = gcp.workstations.WorkstationConfig("defaultWorkstationConfig",
            workstation_config_id="workstation-config",
            workstation_cluster_id=default_workstation_cluster.workstation_cluster_id,
            location="us-central1",
            host=gcp.workstations.WorkstationConfigHostArgs(
                gce_instance=gcp.workstations.WorkstationConfigHostGceInstanceArgs(
                    machine_type="e2-standard-4",
                    boot_disk_size_gb=35,
                    disable_public_ip_addresses=True,
                ),
            ),
            container=gcp.workstations.WorkstationConfigContainerArgs(
                image="intellij",
                env={
                    "NAME": "FOO",
                    "BABE": "bar",
                },
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Workstation Config Persistent Directories

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_network = gcp.compute.Network("defaultNetwork", auto_create_subnetworks=False,
        opts=pulumi.ResourceOptions(provider=google_beta))
        default_subnetwork = gcp.compute.Subnetwork("defaultSubnetwork",
            ip_cidr_range="10.0.0.0/24",
            region="us-central1",
            network=default_network.name,
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_workstation_cluster = gcp.workstations.WorkstationCluster("defaultWorkstationCluster",
            workstation_cluster_id="workstation-cluster",
            network=default_network.id,
            subnetwork=default_subnetwork.id,
            location="us-central1",
            labels={
                "label": "key",
            },
            annotations={
                "label-one": "value-one",
            },
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_workstation_config = gcp.workstations.WorkstationConfig("defaultWorkstationConfig",
            workstation_config_id="workstation-config",
            workstation_cluster_id=default_workstation_cluster.workstation_cluster_id,
            location="us-central1",
            host=gcp.workstations.WorkstationConfigHostArgs(
                gce_instance=gcp.workstations.WorkstationConfigHostGceInstanceArgs(
                    machine_type="e2-standard-4",
                    boot_disk_size_gb=35,
                    disable_public_ip_addresses=True,
                    shielded_instance_config=gcp.workstations.WorkstationConfigHostGceInstanceShieldedInstanceConfigArgs(
                        enable_secure_boot=True,
                        enable_vtpm=True,
                    ),
                ),
            ),
            persistent_directories=[gcp.workstations.WorkstationConfigPersistentDirectoryArgs(
                mount_path="/home",
                gce_pd=gcp.workstations.WorkstationConfigPersistentDirectoryGcePdArgs(
                    size_gb=200,
                    fs_type="ext4",
                    disk_type="pd-standard",
                    reclaim_policy="DELETE",
                ),
            )],
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Workstation Config Source Snapshot

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_network = gcp.compute.Network("defaultNetwork", auto_create_subnetworks=False,
        opts=pulumi.ResourceOptions(provider=google_beta))
        default_subnetwork = gcp.compute.Subnetwork("defaultSubnetwork",
            ip_cidr_range="10.0.0.0/24",
            region="us-central1",
            network=default_network.name,
            opts=pulumi.ResourceOptions(provider=google_beta))
        my_source_disk = gcp.compute.Disk("mySourceDisk",
            size=10,
            type="pd-ssd",
            zone="us-central1-a",
            opts=pulumi.ResourceOptions(provider=google_beta))
        my_source_snapshot = gcp.compute.Snapshot("mySourceSnapshot",
            source_disk=my_source_disk.name,
            zone="us-central1-a",
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_workstation_cluster = gcp.workstations.WorkstationCluster("defaultWorkstationCluster",
            workstation_cluster_id="workstation-cluster",
            network=default_network.id,
            subnetwork=default_subnetwork.id,
            location="us-central1",
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_workstation_config = gcp.workstations.WorkstationConfig("defaultWorkstationConfig",
            workstation_config_id="workstation-config",
            workstation_cluster_id=default_workstation_cluster.workstation_cluster_id,
            location=default_workstation_cluster.location,
            persistent_directories=[gcp.workstations.WorkstationConfigPersistentDirectoryArgs(
                mount_path="/home",
                gce_pd=gcp.workstations.WorkstationConfigPersistentDirectoryGcePdArgs(
                    source_snapshot=my_source_snapshot.id,
                    reclaim_policy="DELETE",
                ),
            )],
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Workstation Config Shielded Instance Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_network = gcp.compute.Network("defaultNetwork", auto_create_subnetworks=False,
        opts=pulumi.ResourceOptions(provider=google_beta))
        default_subnetwork = gcp.compute.Subnetwork("defaultSubnetwork",
            ip_cidr_range="10.0.0.0/24",
            region="us-central1",
            network=default_network.name,
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_workstation_cluster = gcp.workstations.WorkstationCluster("defaultWorkstationCluster",
            workstation_cluster_id="workstation-cluster",
            network=default_network.id,
            subnetwork=default_subnetwork.id,
            location="us-central1",
            labels={
                "label": "key",
            },
            annotations={
                "label-one": "value-one",
            },
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_workstation_config = gcp.workstations.WorkstationConfig("defaultWorkstationConfig",
            workstation_config_id="workstation-config",
            workstation_cluster_id=default_workstation_cluster.workstation_cluster_id,
            location="us-central1",
            host=gcp.workstations.WorkstationConfigHostArgs(
                gce_instance=gcp.workstations.WorkstationConfigHostGceInstanceArgs(
                    machine_type="e2-standard-4",
                    boot_disk_size_gb=35,
                    disable_public_ip_addresses=True,
                    shielded_instance_config=gcp.workstations.WorkstationConfigHostGceInstanceShieldedInstanceConfigArgs(
                        enable_secure_boot=True,
                        enable_vtpm=True,
                    ),
                ),
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Workstation Config Encryption Key

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_network = gcp.compute.Network("defaultNetwork", auto_create_subnetworks=False,
        opts=pulumi.ResourceOptions(provider=google_beta))
        default_subnetwork = gcp.compute.Subnetwork("defaultSubnetwork",
            ip_cidr_range="10.0.0.0/24",
            region="us-central1",
            network=default_network.name,
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_workstation_cluster = gcp.workstations.WorkstationCluster("defaultWorkstationCluster",
            workstation_cluster_id="workstation-cluster",
            network=default_network.id,
            subnetwork=default_subnetwork.id,
            location="us-central1",
            labels={
                "label": "key",
            },
            annotations={
                "label-one": "value-one",
            },
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_key_ring = gcp.kms.KeyRing("defaultKeyRing", location="us-central1",
        opts=pulumi.ResourceOptions(provider=google_beta))
        default_crypto_key = gcp.kms.CryptoKey("defaultCryptoKey", key_ring=default_key_ring.id,
        opts=pulumi.ResourceOptions(provider=google_beta))
        default_account = gcp.service_account.Account("defaultAccount",
            account_id="my-account",
            display_name="Service Account",
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_workstation_config = gcp.workstations.WorkstationConfig("defaultWorkstationConfig",
            workstation_config_id="workstation-config",
            workstation_cluster_id=default_workstation_cluster.workstation_cluster_id,
            location="us-central1",
            host=gcp.workstations.WorkstationConfigHostArgs(
                gce_instance=gcp.workstations.WorkstationConfigHostGceInstanceArgs(
                    machine_type="e2-standard-4",
                    boot_disk_size_gb=35,
                    disable_public_ip_addresses=True,
                    shielded_instance_config=gcp.workstations.WorkstationConfigHostGceInstanceShieldedInstanceConfigArgs(
                        enable_secure_boot=True,
                        enable_vtpm=True,
                    ),
                ),
            ),
            encryption_key=gcp.workstations.WorkstationConfigEncryptionKeyArgs(
                kms_key=default_crypto_key.id,
                kms_key_service_account=default_account.email,
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```

        ## Import

        WorkstationConfig can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:workstations/workstationConfig:WorkstationConfig default projects/{{project}}/locations/{{location}}/workstationClusters/{{workstation_cluster_id}}/workstationConfigs/{{workstation_config_id}}
        ```

        ```sh
         $ pulumi import gcp:workstations/workstationConfig:WorkstationConfig default {{project}}/{{location}}/{{workstation_cluster_id}}/{{workstation_config_id}}
        ```

        ```sh
         $ pulumi import gcp:workstations/workstationConfig:WorkstationConfig default {{location}}/{{workstation_cluster_id}}/{{workstation_config_id}}
        ```

        :param str resource_name: The name of the resource.
        :param WorkstationConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkstationConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 container: Optional[pulumi.Input[pulumi.InputType['WorkstationConfigContainerArgs']]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 encryption_key: Optional[pulumi.Input[pulumi.InputType['WorkstationConfigEncryptionKeyArgs']]] = None,
                 host: Optional[pulumi.Input[pulumi.InputType['WorkstationConfigHostArgs']]] = None,
                 idle_timeout: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 persistent_directories: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WorkstationConfigPersistentDirectoryArgs']]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 running_timeout: Optional[pulumi.Input[str]] = None,
                 workstation_cluster_id: Optional[pulumi.Input[str]] = None,
                 workstation_config_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkstationConfigArgs.__new__(WorkstationConfigArgs)

            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["container"] = container
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["encryption_key"] = encryption_key
            __props__.__dict__["host"] = host
            __props__.__dict__["idle_timeout"] = idle_timeout
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["persistent_directories"] = persistent_directories
            __props__.__dict__["project"] = project
            __props__.__dict__["running_timeout"] = running_timeout
            if workstation_cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'workstation_cluster_id'")
            __props__.__dict__["workstation_cluster_id"] = workstation_cluster_id
            if workstation_config_id is None and not opts.urn:
                raise TypeError("Missing required property 'workstation_config_id'")
            __props__.__dict__["workstation_config_id"] = workstation_config_id
            __props__.__dict__["conditions"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["degraded"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["uid"] = None
        super(WorkstationConfig, __self__).__init__(
            'gcp:workstations/workstationConfig:WorkstationConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            conditions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WorkstationConfigConditionArgs']]]]] = None,
            container: Optional[pulumi.Input[pulumi.InputType['WorkstationConfigContainerArgs']]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            degraded: Optional[pulumi.Input[bool]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            encryption_key: Optional[pulumi.Input[pulumi.InputType['WorkstationConfigEncryptionKeyArgs']]] = None,
            etag: Optional[pulumi.Input[str]] = None,
            host: Optional[pulumi.Input[pulumi.InputType['WorkstationConfigHostArgs']]] = None,
            idle_timeout: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            location: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            persistent_directories: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WorkstationConfigPersistentDirectoryArgs']]]]] = None,
            project: Optional[pulumi.Input[str]] = None,
            running_timeout: Optional[pulumi.Input[str]] = None,
            uid: Optional[pulumi.Input[str]] = None,
            workstation_cluster_id: Optional[pulumi.Input[str]] = None,
            workstation_config_id: Optional[pulumi.Input[str]] = None) -> 'WorkstationConfig':
        """
        Get an existing WorkstationConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Client-specified annotations. This is distinct from labels.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WorkstationConfigConditionArgs']]]] conditions: Status conditions describing the current resource state.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['WorkstationConfigContainerArgs']] container: Container that will be run for each workstation using this configuration when that workstation is started.
               Structure is documented below.
        :param pulumi.Input[str] create_time: Time when this resource was created.
        :param pulumi.Input[bool] degraded: Whether this resource is in degraded mode, in which case it may require user action to restore full functionality. Details can be found in the conditions field.
        :param pulumi.Input[str] display_name: Human-readable name for this resource.
        :param pulumi.Input[pulumi.InputType['WorkstationConfigEncryptionKeyArgs']] encryption_key: Encrypts resources of this workstation configuration using a customer-managed encryption key.
               If specified, the boot disk of the Compute Engine instance and the persistent disk are encrypted using this encryption key. If this field is not set, the disks are encrypted using a generated key. Customer-managed encryption keys do not protect disk metadata.
               If the customer-managed encryption key is rotated, when the workstation instance is stopped, the system attempts to recreate the persistent disk with the new version of the key. Be sure to keep older versions of the key until the persistent disk is recreated. Otherwise, data on the persistent disk will be lost.
               If the encryption key is revoked, the workstation session will automatically be stopped within 7 hours.
               Structure is documented below.
        :param pulumi.Input[str] etag: Checksum computed by the server.
               May be sent on update and delete requests to ensure that the client has an up-to-date value before proceeding.
        :param pulumi.Input[pulumi.InputType['WorkstationConfigHostArgs']] host: Runtime host for a workstation.
               Structure is documented below.
        :param pulumi.Input[str] idle_timeout: How long to wait before automatically stopping an instance that hasn't recently received any user traffic. A value of 0 indicates that this instance should never time out from idleness. Defaults to 20 minutes.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Client-specified labels that are applied to the resource and that are also propagated to the underlying Compute Engine resources.
        :param pulumi.Input[str] location: The location where the workstation cluster config should reside.
               
               
               - - -
        :param pulumi.Input[str] name: Full name of this resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WorkstationConfigPersistentDirectoryArgs']]]] persistent_directories: Directories to persist across workstation sessions.
               Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] running_timeout: How long to wait before automatically stopping a workstation after it was started. A value of 0 indicates that workstations using this configuration should never time out from running duration. Must be greater than 0 and less than 24 hours if `encryption_key` is set. Defaults to 12 hours.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        :param pulumi.Input[str] uid: The system-generated UID of the resource.
        :param pulumi.Input[str] workstation_cluster_id: The ID of the parent workstation cluster.
        :param pulumi.Input[str] workstation_config_id: The ID to be assigned to the workstation cluster config.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkstationConfigState.__new__(_WorkstationConfigState)

        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["conditions"] = conditions
        __props__.__dict__["container"] = container
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["degraded"] = degraded
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["encryption_key"] = encryption_key
        __props__.__dict__["etag"] = etag
        __props__.__dict__["host"] = host
        __props__.__dict__["idle_timeout"] = idle_timeout
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["persistent_directories"] = persistent_directories
        __props__.__dict__["project"] = project
        __props__.__dict__["running_timeout"] = running_timeout
        __props__.__dict__["uid"] = uid
        __props__.__dict__["workstation_cluster_id"] = workstation_cluster_id
        __props__.__dict__["workstation_config_id"] = workstation_config_id
        return WorkstationConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Client-specified annotations. This is distinct from labels.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def conditions(self) -> pulumi.Output[Sequence['outputs.WorkstationConfigCondition']]:
        """
        Status conditions describing the current resource state.
        Structure is documented below.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def container(self) -> pulumi.Output['outputs.WorkstationConfigContainer']:
        """
        Container that will be run for each workstation using this configuration when that workstation is started.
        Structure is documented below.
        """
        return pulumi.get(self, "container")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Time when this resource was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def degraded(self) -> pulumi.Output[bool]:
        """
        Whether this resource is in degraded mode, in which case it may require user action to restore full functionality. Details can be found in the conditions field.
        """
        return pulumi.get(self, "degraded")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[str]]:
        """
        Human-readable name for this resource.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> pulumi.Output[Optional['outputs.WorkstationConfigEncryptionKey']]:
        """
        Encrypts resources of this workstation configuration using a customer-managed encryption key.
        If specified, the boot disk of the Compute Engine instance and the persistent disk are encrypted using this encryption key. If this field is not set, the disks are encrypted using a generated key. Customer-managed encryption keys do not protect disk metadata.
        If the customer-managed encryption key is rotated, when the workstation instance is stopped, the system attempts to recreate the persistent disk with the new version of the key. Be sure to keep older versions of the key until the persistent disk is recreated. Otherwise, data on the persistent disk will be lost.
        If the encryption key is revoked, the workstation session will automatically be stopped within 7 hours.
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_key")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        """
        Checksum computed by the server.
        May be sent on update and delete requests to ensure that the client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def host(self) -> pulumi.Output['outputs.WorkstationConfigHost']:
        """
        Runtime host for a workstation.
        Structure is documented below.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> pulumi.Output[Optional[str]]:
        """
        How long to wait before automatically stopping an instance that hasn't recently received any user traffic. A value of 0 indicates that this instance should never time out from idleness. Defaults to 20 minutes.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "idle_timeout")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Client-specified labels that are applied to the resource and that are also propagated to the underlying Compute Engine resources.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The location where the workstation cluster config should reside.


        - - -
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Full name of this resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="persistentDirectories")
    def persistent_directories(self) -> pulumi.Output[Sequence['outputs.WorkstationConfigPersistentDirectory']]:
        """
        Directories to persist across workstation sessions.
        Structure is documented below.
        """
        return pulumi.get(self, "persistent_directories")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="runningTimeout")
    def running_timeout(self) -> pulumi.Output[Optional[str]]:
        """
        How long to wait before automatically stopping a workstation after it was started. A value of 0 indicates that workstations using this configuration should never time out from running duration. Must be greater than 0 and less than 24 hours if `encryption_key` is set. Defaults to 12 hours.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "running_timeout")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[str]:
        """
        The system-generated UID of the resource.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="workstationClusterId")
    def workstation_cluster_id(self) -> pulumi.Output[str]:
        """
        The ID of the parent workstation cluster.
        """
        return pulumi.get(self, "workstation_cluster_id")

    @property
    @pulumi.getter(name="workstationConfigId")
    def workstation_config_id(self) -> pulumi.Output[str]:
        """
        The ID to be assigned to the workstation cluster config.
        """
        return pulumi.get(self, "workstation_config_id")

