# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['DomainDelegationArgs', 'DomainDelegation']

@pulumi.input_type
class DomainDelegationArgs:
    def __init__(__self__, *,
                 domain: pulumi.Input[_builtins.str],
                 name_servers: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        """
        The set of arguments for constructing a DomainDelegation resource.
        :param pulumi.Input[_builtins.str] domain: The domain name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] name_servers: The list of name servers to delegate to.
               
               # Attributes Reference
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "name_servers", name_servers)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Input[_builtins.str]:
        """
        The domain name.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter(name="nameServers")
    def name_servers(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The list of name servers to delegate to.

        # Attributes Reference
        """
        return pulumi.get(self, "name_servers")

    @name_servers.setter
    def name_servers(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "name_servers", value)


@pulumi.input_type
class _DomainDelegationState:
    def __init__(__self__, *,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 name_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering DomainDelegation resources.
        :param pulumi.Input[_builtins.str] domain: The domain name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] name_servers: The list of name servers to delegate to.
               
               # Attributes Reference
        """
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if name_servers is not None:
            pulumi.set(__self__, "name_servers", name_servers)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain name.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter(name="nameServers")
    def name_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of name servers to delegate to.

        # Attributes Reference
        """
        return pulumi.get(self, "name_servers")

    @name_servers.setter
    def name_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "name_servers", value)


@pulumi.type_token("dnsimple:index/domainDelegation:DomainDelegation")
class DomainDelegation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 name_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_dnsimple as dnsimple

        # Create a domain delegation
        foobar = dnsimple.DomainDelegation("foobar",
            domain=dnsimple["domain"],
            name_servers=[
                "ns1.example.org",
                "ns2.example.com",
            ])
        ```

        ## Import

        DNSimple domain delegations can be imported using the domain name.

        **Importing domain delegation for example.com**

        bash

        ```sh
        $ pulumi import dnsimple:index/domainDelegation:DomainDelegation resource_name example.com
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] domain: The domain name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] name_servers: The list of name servers to delegate to.
               
               # Attributes Reference
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainDelegationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_dnsimple as dnsimple

        # Create a domain delegation
        foobar = dnsimple.DomainDelegation("foobar",
            domain=dnsimple["domain"],
            name_servers=[
                "ns1.example.org",
                "ns2.example.com",
            ])
        ```

        ## Import

        DNSimple domain delegations can be imported using the domain name.

        **Importing domain delegation for example.com**

        bash

        ```sh
        $ pulumi import dnsimple:index/domainDelegation:DomainDelegation resource_name example.com
        ```

        :param str resource_name: The name of the resource.
        :param DomainDelegationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainDelegationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 name_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainDelegationArgs.__new__(DomainDelegationArgs)

            if domain is None and not opts.urn:
                raise TypeError("Missing required property 'domain'")
            __props__.__dict__["domain"] = domain
            if name_servers is None and not opts.urn:
                raise TypeError("Missing required property 'name_servers'")
            __props__.__dict__["name_servers"] = name_servers
        super(DomainDelegation, __self__).__init__(
            'dnsimple:index/domainDelegation:DomainDelegation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            domain: Optional[pulumi.Input[_builtins.str]] = None,
            name_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'DomainDelegation':
        """
        Get an existing DomainDelegation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] domain: The domain name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] name_servers: The list of name servers to delegate to.
               
               # Attributes Reference
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainDelegationState.__new__(_DomainDelegationState)

        __props__.__dict__["domain"] = domain
        __props__.__dict__["name_servers"] = name_servers
        return DomainDelegation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Output[_builtins.str]:
        """
        The domain name.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter(name="nameServers")
    def name_servers(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The list of name servers to delegate to.

        # Attributes Reference
        """
        return pulumi.get(self, "name_servers")

