import pytest

MOCK_EMAILS = {
    "@odata.context": "https://graph.microsoft.com/v1.0/$metadata#users('3a2bc284-f11c-4676-a9e1-6310eea60f26')/messages",
    "value": [
        {
            "@odata.etag": "W/\"CQAAABYAAADUwywT0x3WRJXfefGC8Xz/AABFGtQd\"",
            "id": "AAMkADY1YmE3N2FhLWEwMzQtNDNkMC04Mzg3LTczMTdiMjk2NzRhMABGAAAAAADfsy0XtCMZS5XonZkyBLu6BwDUwywT0x3WRJXfefGC8Xz-AAAAAAEMAADUwywT0x3WRJXfefGC8Xz-AABFMqggAAA=",
            "createdDateTime": "2025-09-17T23:27:01Z",
            "lastModifiedDateTime": "2025-09-17T23:27:11Z",
            "changeKey": "CQAAABYAAADUwywT0x3WRJXfefGC8Xz/AABFGtQd",
            "categories": [],
            "receivedDateTime": "2025-09-17T23:27:02Z",
            "sentDateTime": "2025-09-17T23:26:56Z",
            "hasAttachments": False,
            "internetMessageId": "<BN6PR11MB3954528A636708D58390FF64B317A@BN6PR11MB3954.namprd11.prod.outlook.com>",
            "subject": "",
            "bodyPreview": "",
            "importance": "normal",
            "parentFolderId": "AAMkADY1YmE3N2FhLWEwMzQtNDNkMC04Mzg3LTczMTdiMjk2NzRhMAAuAAAAAADfsy0XtCMZS5XonZkyBLu6AQDUwywT0x3WRJXfefGC8Xz-AAAAAAEMAAA=",
            "conversationId": "AAQkADY1YmE3N2FhLWEwMzQtNDNkMC04Mzg3LTczMTdiMjk2NzRhMAAQAJTE8YDAboJPhSfkedRnOcQ=",
            "conversationIndex": "AQHcKCqOlMTxgMBugk+FJ+R51Gc5xA==",
            "isDeliveryReceiptRequested": None,
            "isReadReceiptRequested": False,
            "isRead": False,
            "isDraft": False,
            "webLink": "https://outlook.office365.com/owa/?ItemID=AAMkADY1YmE3N2FhLWEwMzQtNDNkMC04Mzg3LTczMTdiMjk2NzRhMABGAAAAAADfsy0XtCMZS5XonZkyBLu6BwDUwywT0x3WRJXfefGC8Xz%2FAAAAAAEMAADUwywT0x3WRJXfefGC8Xz%2FAABFMqggAAA%3D&exvsurl=1&viewmodel=ReadMessageItem",
            "inferenceClassification": "focused",
            "body": {
                "contentType": "html",
                "content": "<html><head>\r\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"><style type=\"text/css\" style=\"display:none\">\r\n<!--\r\np\r\n\t{margin-top:0;\r\n\tmargin-bottom:0}\r\n-->\r\n</style></head><body dir=\"ltr\"><div class=\"elementToProof\" style=\"font-family:Aptos,Aptos_EmbeddedFont,Aptos_MSFontService,Calibri,Helvetica,sans-serif; font-size:12pt; color:rgb(0,0,0)\"><br></div></body></html>"
            },
            "sender": {
                "emailAddress": {
                    "name": "TAYTAY Thawatchai",
                    "address": "Jthaenhinbell1999@hotmail.com"
                }
            },
            "from": {
                "emailAddress": {
                    "name": "TAYTAY Thawatchai",
                    "address": "Jthaenhinbell1999@hotmail.com"
                }
            },
            "toRecipients": [
                {
                    "emailAddress": {
                        "name": "Adele Vance",
                        "address": "AdeleV@M365x63639251.OnMicrosoft.com"
                    }
                }
            ],
            "ccRecipients": [],
            "bccRecipients": [],
            "replyTo": [],
            "flag": {
                "flagStatus": "notFlagged"
            }
        },
        {
            "@odata.etag": "W/\"CQAAABYAAADUwywT0x3WRJXfefGC8Xz/AAA9ICdY\"",
            "id": "AAMkADY1YmE3N2FhLWEwMzQtNDNkMC04Mzg3LTczMTdiMjk2NzRhMABGAAAAAADfsy0XtCMZS5XonZkyBLu6BwDUwywT0x3WRJXfefGC8Xz-AAAAAAEMAADUwywT0x3WRJXfefGC8Xz-AAA9NNpuAAA=",
            "createdDateTime": "2025-09-05T12:27:50Z",
            "lastModifiedDateTime": "2025-09-05T12:27:52Z",
            "changeKey": "CQAAABYAAADUwywT0x3WRJXfefGC8Xz/AAA9ICdY",
            "categories": [],
            "receivedDateTime": "2025-09-05T12:27:50Z",
            "sentDateTime": "2025-09-05T12:27:40Z",
            "hasAttachments": False,
            "internetMessageId": "<PlannerDueDate-1774c252-8b1b-49a1-b827-7028fbbb5c27-33505881-acbf-48e1-913d-d6dad3188b1d-r0-SendEmail-rh_cac-aid_8b456222-30e5-4a3b-9075-f5c907f581b7@odspnotify>",
            "subject": "You have late tasks",
            "bodyPreview": "Hi Adele. You have 2 tasks due.\r\n        You have late tasks\r\nTailspin CEO\r\nIn the plan  Logistics\r\n8/29/2025\r\n7 days late\r\nTailspin CEO\r\nIn the plan  PattiF Logistics\r\n8/29/2025\r\n7 days late\r\nOpen in Browser\r\nOpen in Teams\r\nYou are receiving this email b",
            "importance": "normal",
            "parentFolderId": "AAMkADY1YmE3N2FhLWEwMzQtNDNkMC04Mzg3LTczMTdiMjk2NzRhMAAuAAAAAADfsy0XtCMZS5XonZkyBLu6AQDUwywT0x3WRJXfefGC8Xz-AAAAAAEMAAA=",
            "conversationId": "AAQkADY1YmE3N2FhLWEwMzQtNDNkMC04Mzg3LTczMTdiMjk2NzRhMAAQAJLwy6wfavNHu9UBfL-9EaQ=",
            "conversationIndex": "AQHcHmB+kvDLrB9q80e71QF8v/0RpA==",
            "isDeliveryReceiptRequested": None,
            "isReadReceiptRequested": False,
            "isRead": False,
            "isDraft": False,
            "webLink": "https://outlook.office365.com/owa/?ItemID=AAMkADY1YmE3N2FhLWEwMzQtNDNkMC04Mzg3LTczMTdiMjk2NzRhMABGAAAAAADfsy0XtCMZS5XonZkyBLu6BwDUwywT0x3WRJXfefGC8Xz%2FAAAAAAEMAADUwywT0x3WRJXfefGC8Xz%2FAAA9NNpuAAA%3D&exvsurl=1&viewmodel=ReadMessageItem",
            "inferenceClassification": "focused",
            "body": {
                "contentType": "html",
                "content": "<html dir=\"ltr\" lang=\"en-us\"><head>\r\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"><style type=\"text/css\">\r\n<!--\r\n.headerBackgroundMsoTable\r\n\t{border-spacing:0px;\r\n\twidth:100%}\r\n-->\r\n</style></head><body style=\"margin:0px\"><div><table height=\"100%\" width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px\"><tbody><tr><td valign=\"top\" align=\"center\"><table align=\"center\" style=\"border-spacing:0px; width:100%!important; margin-right:auto; margin-left:auto; margin:0 auto; max-width:640px; font-family:'Segoe UI'; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td align=\"left\" style=\"padding:0px; margin:0px\"><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td align=\"center\"><div><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td colspan=\"1\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%\"><tbody><tr><td style=\"padding:32px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:20px; color:#242424\">Hi Adele. You have 2 tasks due. </span></td></tr></tbody></table></td></tr></tbody></table></div></td></tr></tbody></table></td></tr><tr><td align=\"left\" style=\"padding:0px; margin:0px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; border-top:1px solid #E1DFDD; border-bottom:1px solid #E1DFDD; border-top:1px solid rgba(128,128,128,0.25); border-bottom:1px solid rgba(128,128,128,0.25)\"><tbody><tr><td style=\"padding:12px 32px 4px; background-color:#FAFAFA\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%\"><tbody><tr><td style=\"padding:11px 0 3px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%\"><tbody><tr><td style=\"width:35px\"><img src=\"cid:93eb720f-1bb6-4c3d-b4a1-8fb8f9fec0e6\" alt=\"Calendar Late\" width=\"30\" height=\"30\" border=\"0\" style=\"display:block; outline:none; border:none\"> </td><td><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:14px; color:#1B1A19\">You have <b>late</b> tasks </span></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt/DJdyzE93q0qIFCCXvHPucWUAAH4x?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638926720593621507\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Tailspin CEO</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:337f4110-f21a-41f2-b88b-8e0255e2de8c\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638926720593621507\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">Logistics</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:b43ad052-ec89-4284-b091-ddb4ee93ba71\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/29/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#FED9CC\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#A80000\">7 days late</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/vTzrU8ilDEe2WnZp3wobLGUAEek-/gVfS81WBpUekMM8YUNZCe2UAGRn1?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638926720593621507\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Tailspin CEO</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:337f4110-f21a-41f2-b88b-8e0255e2de8c\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/vTzrU8ilDEe2WnZp3wobLGUAEek-?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638926720593621507\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">PattiF Logistics</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:b43ad052-ec89-4284-b091-ddb4ee93ba71\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/29/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#FED9CC\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#A80000\">7 days late</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:20px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td align=\"center\" style=\"padding:6px 20px 6px 20px; border:1px solid #E1DFDD; border-radius:4px; background-color:#5B5FC7; box-shadow:0px 0px 4px rgba(0,0,0,0.09)\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/MyTasks?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638926720593621507\" target=\"_blank\"><strong style=\"display:inline-block; font-weight:600; font-size:14px; font-family:&quot;Segoe UI&quot;,sans-serif; line-height:20px; color:#ffffff; text-decoration:none\">Open in Browser </strong></a></td></tr></tbody></table></td><td style=\"padding-left:10px; padding-right:10px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td align=\"center\" style=\"padding:6px 20px 6px 20px; border:1px solid #E1DFDD; border-radius:4px; background-color:#ffffff; box-shadow:0px 0px 4px rgba(0,0,0,0.09)\"><a href=\"https://teams.microsoft.com/l/entity/com.microsoft.teamspace.tab.planner/mytasks?tenantId=dd172b04-e4e2-4084-885c-47c9cc57f059&amp;webUrl=https%3a%2f%2ftasks.teams.microsoft.com%2fteamsui%2fpersonalApp%2falltasklists&amp;context=%7b%22subEntityId%22%3a%22%2fv1%2fassignedtome%3fnc%3demail%26nt%3dduedate%22%7d\" target=\"_blank\"><strong style=\"display:inline-block; font-weight:600; font-size:14px; font-family:&quot;Segoe UI&quot;,sans-serif; line-height:20px; color:#252424; text-decoration:none\">Open in Teams </strong></a></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td align=\"left\" style=\"padding:0px; margin:0px\"><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" align=\"center\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td align=\"left\" style=\"font-size:12px; line-height:16px; padding:20px 32px\"><div><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"font-family:'Segoe UI',SUWR,Verdana,sans-serif; font-size:10px; line-height:20px; color:#6b6b6b; padding:6px 0; letter-spacing:-0.01em\">You are receiving this email because you have subscribed to Microsoft Office 365. </td></tr><tr><td style=\"font-family:'Segoe UI',SUWR,Verdana,sans-serif; font-size:10px; line-height:20px; color:#6b6b6b; padding:6px 0; letter-spacing:-0.01em\">Notification settings: Go to <a href=\"https://tasks.office.com/\" target=\"_blank\" style=\"color:#6b6b6c; text-decoration:underline\">Planner</a>, select the gear icon, then select &quot;Notifications&quot;. </td></tr><tr><td align=\"left\" style=\"padding-top:12px; text-align:left; padding-bottom:12px\"><hr></td></tr><tr><td align=\"left\" style=\"padding-top:12px; text-align:left; padding-bottom:12px\"><img src=\"cid:ac94a3b3-68bb-467b-aa98-278e6ebe1c05\" alt=\"\" title=\"\" height=\"22\" width=\"90\" style=\"margin:0px; height:22px; width:90px\"> </td></tr><tr><td align=\"left\" style=\"padding-top:12px; text-align:left; padding-bottom:12px\"><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td align=\"left\" style=\"padding:0 4px 0 0; white-space:nowrap\"><p style=\"padding:0px; margin:0px; font-family:'Segoe UI',SUWR,Verdana,sans-serif; font-size:12px; line-height:20px; color:#6b6b6c; letter-spacing:-0.01em\"><a href=\"https://go.microsoft.com/fwlink/?LinkId=521839\" target=\"_blank\" title=\"\" style=\"padding:0px; margin:0px; font-family:'Segoe UI',SUWR,Verdana,sans-serif; font-size:12px; line-height:20px; color:#6b6b6c; letter-spacing:-0.01em\">Privacy&nbsp;Statement</a> </p></td></tr></tbody></table></td></tr><tr><td align=\"left\" style=\"padding-top:12px; text-align:left; padding-bottom:12px\"><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td align=\"left\"><p style=\"margin:0px; font-family:'Segoe UI',SUWR,Verdana,sans-serif; font-size:12px; line-height:20px; color:#6b6b6c; letter-spacing:-0.01em\">This email is generated through Contoso's use of Microsoft 365 and may contain content that is controlled by Contoso.</p></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></div></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></div><img src=\"https://southcentralusr-notifyp.svc.ms:443/api/v2/tracking/method/View?mi=kiv3sUFjNkqcpSdps5Iakw\" aria-hidden=\"true\" role=\"presentation\" height=\"1\" width=\"1\"></body></html>"
            },
            "sender": {
                "emailAddress": {
                    "name": "Microsoft on behalf of your organization",
                    "address": "noreply@planner.office365.com"
                }
            },
            "from": {
                "emailAddress": {
                    "name": "Microsoft on behalf of your organization",
                    "address": "noreply@planner.office365.com"
                }
            },
            "toRecipients": [
                {
                    "emailAddress": {
                        "name": "Adele Vance",
                        "address": "AdeleV@M365x63639251.OnMicrosoft.com"
                    }
                }
            ],
            "ccRecipients": [],
            "bccRecipients": [],
            "replyTo": [],
            "flag": {
                "flagStatus": "notFlagged"
            }
        },
        {
            "@odata.etag": "W/\"CQAAABYAAADUwywT0x3WRJXfefGC8Xz/AAA9IAoe\"",
            "id": "AAMkADY1YmE3N2FhLWEwMzQtNDNkMC04Mzg3LTczMTdiMjk2NzRhMABGAAAAAADfsy0XtCMZS5XonZkyBLu6BwDUwywT0x3WRJXfefGC8Xz-AAAAAAEMAADUwywT0x3WRJXfefGC8Xz-AAA9NNptAAA=",
            "createdDateTime": "2025-09-04T12:27:52Z",
            "lastModifiedDateTime": "2025-09-04T12:27:55Z",
            "changeKey": "CQAAABYAAADUwywT0x3WRJXfefGC8Xz/AAA9IAoe",
            "categories": [],
            "receivedDateTime": "2025-09-04T12:27:52Z",
            "sentDateTime": "2025-09-04T12:27:40Z",
            "hasAttachments": False,
            "internetMessageId": "<PlannerDueDate-dab3f891-c7ed-41df-bd84-3f4597e60072-071b00a5-1be2-4f9c-981c-940e61acb7e6-r0-SendEmail-rh_cac-aid_046ad15b-78f0-4cff-a214-62748280ef84@odspnotify>",
            "subject": "You have late tasks",
            "bodyPreview": "Hi Adele. You have 6 tasks due.\r\n        You have late tasks\r\nTailspin CEO\r\nIn the plan  Logistics\r\n8/29/2025\r\n6 days late\r\nTerra Firm Presentation\r\nIn the plan  PattiF Logistics\r\n8/28/2025\r\n7 days late\r\nTerra Firm Presentation\r\nIn the plan  Logistics\r\n8/",
            "importance": "normal",
            "parentFolderId": "AAMkADY1YmE3N2FhLWEwMzQtNDNkMC04Mzg3LTczMTdiMjk2NzRhMAAuAAAAAADfsy0XtCMZS5XonZkyBLu6AQDUwywT0x3WRJXfefGC8Xz-AAAAAAEMAAA=",
            "conversationId": "AAQkADY1YmE3N2FhLWEwMzQtNDNkMC04Mzg3LTczMTdiMjk2NzRhMAAQAPNoq4Jnj9VHsVIHA_Bfhco=",
            "conversationIndex": "AQHcHZdV82irgmeP1UexUgcD4F+Fyg==",
            "isDeliveryReceiptRequested": None,
            "isReadReceiptRequested": False,
            "isRead": False,
            "isDraft": False,
            "webLink": "https://outlook.office365.com/owa/?ItemID=AAMkADY1YmE3N2FhLWEwMzQtNDNkMC04Mzg3LTczMTdiMjk2NzRhMABGAAAAAADfsy0XtCMZS5XonZkyBLu6BwDUwywT0x3WRJXfefGC8Xz%2FAAAAAAEMAADUwywT0x3WRJXfefGC8Xz%2FAAA9NNptAAA%3D&exvsurl=1&viewmodel=ReadMessageItem",
            "inferenceClassification": "focused",
            "body": {
                "contentType": "html",
                "content": "<html dir=\"ltr\" lang=\"en-us\"><head>\r\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"><style type=\"text/css\">\r\n<!--\r\n.headerBackgroundMsoTable\r\n\t{border-spacing:0px;\r\n\twidth:100%}\r\n-->\r\n</style></head><body style=\"margin:0px\"><div><table height=\"100%\" width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px\"><tbody><tr><td valign=\"top\" align=\"center\"><table align=\"center\" style=\"border-spacing:0px; width:100%!important; margin-right:auto; margin-left:auto; margin:0 auto; max-width:640px; font-family:'Segoe UI'; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td align=\"left\" style=\"padding:0px; margin:0px\"><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td align=\"center\"><div><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td colspan=\"1\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%\"><tbody><tr><td style=\"padding:32px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:20px; color:#242424\">Hi Adele. You have 6 tasks due. </span></td></tr></tbody></table></td></tr></tbody></table></div></td></tr></tbody></table></td></tr><tr><td align=\"left\" style=\"padding:0px; margin:0px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; border-top:1px solid #E1DFDD; border-bottom:1px solid #E1DFDD; border-top:1px solid rgba(128,128,128,0.25); border-bottom:1px solid rgba(128,128,128,0.25)\"><tbody><tr><td style=\"padding:12px 32px 4px; background-color:#FAFAFA\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%\"><tbody><tr><td style=\"padding:11px 0 3px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%\"><tbody><tr><td style=\"width:35px\"><img src=\"cid:737a6979-7f57-455a-9335-7d088cc9ccf6\" alt=\"Calendar Late\" width=\"30\" height=\"30\" border=\"0\" style=\"display:block; outline:none; border:none\"> </td><td><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:14px; color:#1B1A19\">You have <b>late</b> tasks </span></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt/DJdyzE93q0qIFCCXvHPucWUAAH4x?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638925856598016311\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Tailspin CEO</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:4a17f572-8014-4444-8b18-e86a19829293\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638925856598016311\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">Logistics</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:677bb6d2-295e-4baa-9121-9add0f26802e\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/29/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#FED9CC\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#A80000\">6 days late</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/vTzrU8ilDEe2WnZp3wobLGUAEek-/HZ5tnG374U26YV32Le5rS2UAIevZ?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638925856598016311\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Terra Firm Presentation</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:4a17f572-8014-4444-8b18-e86a19829293\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/vTzrU8ilDEe2WnZp3wobLGUAEek-?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638925856598016311\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">PattiF Logistics</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:677bb6d2-295e-4baa-9121-9add0f26802e\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/28/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#FED9CC\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#A80000\">7 days late</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt/LAl8pGDDbEu7LZ5fvs3ABGUAF9GX?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638925856598016311\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Terra Firm Presentation</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:4a17f572-8014-4444-8b18-e86a19829293\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638925856598016311\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">Logistics</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:677bb6d2-295e-4baa-9121-9add0f26802e\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/28/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#FED9CC\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#A80000\">7 days late</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/-zqS58FZ9EeN-_dKGA6XEWUACFRQ/_wvQexctwkmV0W87MdUOV2UAIYct?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638925856598016311\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Submit your expenses</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:4a17f572-8014-4444-8b18-e86a19829293\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/-zqS58FZ9EeN-_dKGA6XEWUACFRQ?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638925856598016311\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">Event Plan</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:677bb6d2-295e-4baa-9121-9add0f26802e\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/28/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#FED9CC\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#A80000\">7 days late</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/oTP_zi2u9k2iHyfIXz4xY2UAFhM3/dc20HY1ewkmy1KmoSmH2EGUAAcTu?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638925856598016311\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Submit your expenses</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:4a17f572-8014-4444-8b18-e86a19829293\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/oTP_zi2u9k2iHyfIXz4xY2UAFhM3?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638925856598016311\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">Event Plan</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:677bb6d2-295e-4baa-9121-9add0f26802e\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/28/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#FED9CC\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#A80000\">7 days late</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:6px 24px; text-align:center\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/MyTasks?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638925856598016311\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; text-decoration:none; color:#106EBE\">View all 6 late tasks</a></td></tr></tbody></table></td></tr><tr><td style=\"padding:20px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td align=\"center\" style=\"padding:6px 20px 6px 20px; border:1px solid #E1DFDD; border-radius:4px; background-color:#5B5FC7; box-shadow:0px 0px 4px rgba(0,0,0,0.09)\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/MyTasks?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638925856598016311\" target=\"_blank\"><strong style=\"display:inline-block; font-weight:600; font-size:14px; font-family:&quot;Segoe UI&quot;,sans-serif; line-height:20px; color:#ffffff; text-decoration:none\">Open in Browser </strong></a></td></tr></tbody></table></td><td style=\"padding-left:10px; padding-right:10px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td align=\"center\" style=\"padding:6px 20px 6px 20px; border:1px solid #E1DFDD; border-radius:4px; background-color:#ffffff; box-shadow:0px 0px 4px rgba(0,0,0,0.09)\"><a href=\"https://teams.microsoft.com/l/entity/com.microsoft.teamspace.tab.planner/mytasks?tenantId=dd172b04-e4e2-4084-885c-47c9cc57f059&amp;webUrl=https%3a%2f%2ftasks.teams.microsoft.com%2fteamsui%2fpersonalApp%2falltasklists&amp;context=%7b%22subEntityId%22%3a%22%2fv1%2fassignedtome%3fnc%3demail%26nt%3dduedate%22%7d\" target=\"_blank\"><strong style=\"display:inline-block; font-weight:600; font-size:14px; font-family:&quot;Segoe UI&quot;,sans-serif; line-height:20px; color:#252424; text-decoration:none\">Open in Teams </strong></a></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td align=\"left\" style=\"padding:0px; margin:0px\"><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" align=\"center\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td align=\"left\" style=\"font-size:12px; line-height:16px; padding:20px 32px\"><div><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"font-family:'Segoe UI',SUWR,Verdana,sans-serif; font-size:10px; line-height:20px; color:#6b6b6b; padding:6px 0; letter-spacing:-0.01em\">You are receiving this email because you have subscribed to Microsoft Office 365. </td></tr><tr><td style=\"font-family:'Segoe UI',SUWR,Verdana,sans-serif; font-size:10px; line-height:20px; color:#6b6b6b; padding:6px 0; letter-spacing:-0.01em\">Notification settings: Go to <a href=\"https://tasks.office.com/\" target=\"_blank\" style=\"color:#6b6b6c; text-decoration:underline\">Planner</a>, select the gear icon, then select &quot;Notifications&quot;. </td></tr><tr><td align=\"left\" style=\"padding-top:12px; text-align:left; padding-bottom:12px\"><hr></td></tr><tr><td align=\"left\" style=\"padding-top:12px; text-align:left; padding-bottom:12px\"><img src=\"cid:ffc735e9-9043-4814-9300-4569b5f0bf9f\" alt=\"\" title=\"\" height=\"22\" width=\"90\" style=\"margin:0px; height:22px; width:90px\"> </td></tr><tr><td align=\"left\" style=\"padding-top:12px; text-align:left; padding-bottom:12px\"><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td align=\"left\" style=\"padding:0 4px 0 0; white-space:nowrap\"><p style=\"padding:0px; margin:0px; font-family:'Segoe UI',SUWR,Verdana,sans-serif; font-size:12px; line-height:20px; color:#6b6b6c; letter-spacing:-0.01em\"><a href=\"https://go.microsoft.com/fwlink/?LinkId=521839\" target=\"_blank\" title=\"\" style=\"padding:0px; margin:0px; font-family:'Segoe UI',SUWR,Verdana,sans-serif; font-size:12px; line-height:20px; color:#6b6b6c; letter-spacing:-0.01em\">Privacy&nbsp;Statement</a> </p></td></tr></tbody></table></td></tr><tr><td align=\"left\" style=\"padding-top:12px; text-align:left; padding-bottom:12px\"><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td align=\"left\"><p style=\"margin:0px; font-family:'Segoe UI',SUWR,Verdana,sans-serif; font-size:12px; line-height:20px; color:#6b6b6c; letter-spacing:-0.01em\">This email is generated through Contoso's use of Microsoft 365 and may contain content that is controlled by Contoso.</p></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></div></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></div><img src=\"https://southcentralusr-notifyp.svc.ms:443/api/v2/tracking/method/View?mi=zSgEJk5i1UWRYsMTnjGRKQ\" aria-hidden=\"true\" role=\"presentation\" height=\"1\" width=\"1\"></body></html>"
            },
            "sender": {
                "emailAddress": {
                    "name": "Microsoft on behalf of your organization",
                    "address": "noreply@planner.office365.com"
                }
            },
            "from": {
                "emailAddress": {
                    "name": "Microsoft on behalf of your organization",
                    "address": "noreply@planner.office365.com"
                }
            },
            "toRecipients": [
                {
                    "emailAddress": {
                        "name": "Adele Vance",
                        "address": "AdeleV@M365x63639251.OnMicrosoft.com"
                    }
                }
            ],
            "ccRecipients": [],
            "bccRecipients": [],
            "replyTo": [],
            "flag": {
                "flagStatus": "notFlagged"
            }
        },
        {
            "@odata.etag": "W/\"CQAAABYAAADUwywT0x3WRJXfefGC8Xz/AAA6KA1t\"",
            "id": "AAMkADY1YmE3N2FhLWEwMzQtNDNkMC04Mzg3LTczMTdiMjk2NzRhMABGAAAAAADfsy0XtCMZS5XonZkyBLu6BwDUwywT0x3WRJXfefGC8Xz-AAAAAAEMAADUwywT0x3WRJXfefGC8Xz-AAA6O1pRAAA=",
            "createdDateTime": "2025-08-31T17:48:52Z",
            "lastModifiedDateTime": "2025-08-31T17:48:55Z",
            "changeKey": "CQAAABYAAADUwywT0x3WRJXfefGC8Xz/AAA6KA1t",
            "categories": [],
            "receivedDateTime": "2025-08-31T17:48:52Z",
            "sentDateTime": "2025-08-31T17:48:44Z",
            "hasAttachments": False,
            "internetMessageId": "<PlannerDueDate-0ae8e90c-4210-4378-a711-9ce364b28ef9-d095296c-bf5a-4385-a524-64d82fec3448-r0-SendEmail-rh_cac-aid_d0619ba8-be5f-4557-9ac7-b0e92ad9e831@odspnotify>",
            "subject": "You have late tasks",
            "bodyPreview": "Hi Adele. You have 8 tasks due.\r\n        You have late tasks\r\nTailspin CEO\r\nIn the plan  Logistics\r\n8/29/2025\r\n2 days late\r\nTerra Firm Presentation\r\nIn the plan  PattiF Logistics\r\n8/28/2025\r\n3 days late\r\nTerra Firm Presentation\r\nIn the plan  Logistics\r\n8/",
            "importance": "normal",
            "parentFolderId": "AAMkADY1YmE3N2FhLWEwMzQtNDNkMC04Mzg3LTczMTdiMjk2NzRhMAAuAAAAAADfsy0XtCMZS5XonZkyBLu6AQDUwywT0x3WRJXfefGC8Xz-AAAAAAEMAAA=",
            "conversationId": "AAQkADY1YmE3N2FhLWEwMzQtNDNkMC04Mzg3LTczMTdiMjk2NzRhMAAQAF5CbFrek85BiWCCr1Roq8M=",
            "conversationIndex": "AQHcGp+DXkJsWt6TzkGJYIKvVGirww==",
            "isDeliveryReceiptRequested": None,
            "isReadReceiptRequested": False,
            "isRead": False,
            "isDraft": False,
            "webLink": "https://outlook.office365.com/owa/?ItemID=AAMkADY1YmE3N2FhLWEwMzQtNDNkMC04Mzg3LTczMTdiMjk2NzRhMABGAAAAAADfsy0XtCMZS5XonZkyBLu6BwDUwywT0x3WRJXfefGC8Xz%2FAAAAAAEMAADUwywT0x3WRJXfefGC8Xz%2FAAA6O1pRAAA%3D&exvsurl=1&viewmodel=ReadMessageItem",
            "inferenceClassification": "focused",
            "body": {
                "contentType": "html",
                "content": "<html dir=\"ltr\" lang=\"en-us\"><head>\r\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"><style type=\"text/css\">\r\n<!--\r\n.headerBackgroundMsoTable\r\n\t{border-spacing:0px;\r\n\twidth:100%}\r\n-->\r\n</style></head><body style=\"margin:0px\"><div><table height=\"100%\" width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px\"><tbody><tr><td valign=\"top\" align=\"center\"><table align=\"center\" style=\"border-spacing:0px; width:100%!important; margin-right:auto; margin-left:auto; margin:0 auto; max-width:640px; font-family:'Segoe UI'; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td align=\"left\" style=\"padding:0px; margin:0px\"><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td align=\"center\"><div><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td colspan=\"1\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%\"><tbody><tr><td style=\"padding:32px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:20px; color:#242424\">Hi Adele. You have 8 tasks due. </span></td></tr></tbody></table></td></tr></tbody></table></div></td></tr></tbody></table></td></tr><tr><td align=\"left\" style=\"padding:0px; margin:0px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; border-top:1px solid #E1DFDD; border-bottom:1px solid #E1DFDD; border-top:1px solid rgba(128,128,128,0.25); border-bottom:1px solid rgba(128,128,128,0.25)\"><tbody><tr><td style=\"padding:12px 32px 4px; background-color:#FAFAFA\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%\"><tbody><tr><td style=\"padding:11px 0 3px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%\"><tbody><tr><td style=\"width:35px\"><img src=\"cid:0dabb0fe-d670-4e95-8869-9d719f31e565\" alt=\"Calendar Late\" width=\"30\" height=\"30\" border=\"0\" style=\"display:block; outline:none; border:none\"> </td><td><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:14px; color:#1B1A19\">You have <b>late</b> tasks </span></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt/DJdyzE93q0qIFCCXvHPucWUAAH4x?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638922593228173185\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Tailspin CEO</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:16a81c7e-44db-4ab4-9325-6a9ad53bc1bb\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638922593228173185\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">Logistics</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:6f853347-5eb4-43ce-939c-6955a8a1e817\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/29/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#FED9CC\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#A80000\">2 days late</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/vTzrU8ilDEe2WnZp3wobLGUAEek-/HZ5tnG374U26YV32Le5rS2UAIevZ?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638922593228173185\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Terra Firm Presentation</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:16a81c7e-44db-4ab4-9325-6a9ad53bc1bb\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/vTzrU8ilDEe2WnZp3wobLGUAEek-?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638922593228173185\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">PattiF Logistics</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:6f853347-5eb4-43ce-939c-6955a8a1e817\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/28/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#FED9CC\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#A80000\">3 days late</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt/LAl8pGDDbEu7LZ5fvs3ABGUAF9GX?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638922593228173185\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Terra Firm Presentation</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:16a81c7e-44db-4ab4-9325-6a9ad53bc1bb\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638922593228173185\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">Logistics</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:6f853347-5eb4-43ce-939c-6955a8a1e817\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/28/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#FED9CC\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#A80000\">3 days late</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/vTzrU8ilDEe2WnZp3wobLGUAEek-/Q16nIEnVI0a4lTZZ79wa32UAAu7z?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638922593228173185\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">StockReport AM</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:16a81c7e-44db-4ab4-9325-6a9ad53bc1bb\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/vTzrU8ilDEe2WnZp3wobLGUAEek-?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638922593228173185\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">PattiF Logistics</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:6f853347-5eb4-43ce-939c-6955a8a1e817\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/24/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#FED9CC\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#A80000\">7 days late</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/-zqS58FZ9EeN-_dKGA6XEWUACFRQ/_wvQexctwkmV0W87MdUOV2UAIYct?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638922593228173185\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Submit your expenses</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:16a81c7e-44db-4ab4-9325-6a9ad53bc1bb\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/-zqS58FZ9EeN-_dKGA6XEWUACFRQ?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638922593228173185\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">Event Plan</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:6f853347-5eb4-43ce-939c-6955a8a1e817\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/28/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#FED9CC\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#A80000\">3 days late</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:6px 24px; text-align:center\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/MyTasks?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638922593228173185\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; text-decoration:none; color:#106EBE\">View all 8 late tasks</a></td></tr></tbody></table></td></tr><tr><td style=\"padding:20px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td align=\"center\" style=\"padding:6px 20px 6px 20px; border:1px solid #E1DFDD; border-radius:4px; background-color:#5B5FC7; box-shadow:0px 0px 4px rgba(0,0,0,0.09)\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/MyTasks?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638922593228173185\" target=\"_blank\"><strong style=\"display:inline-block; font-weight:600; font-size:14px; font-family:&quot;Segoe UI&quot;,sans-serif; line-height:20px; color:#ffffff; text-decoration:none\">Open in Browser </strong></a></td></tr></tbody></table></td><td style=\"padding-left:10px; padding-right:10px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td align=\"center\" style=\"padding:6px 20px 6px 20px; border:1px solid #E1DFDD; border-radius:4px; background-color:#ffffff; box-shadow:0px 0px 4px rgba(0,0,0,0.09)\"><a href=\"https://teams.microsoft.com/l/entity/com.microsoft.teamspace.tab.planner/mytasks?tenantId=dd172b04-e4e2-4084-885c-47c9cc57f059&amp;webUrl=https%3a%2f%2ftasks.teams.microsoft.com%2fteamsui%2fpersonalApp%2falltasklists&amp;context=%7b%22subEntityId%22%3a%22%2fv1%2fassignedtome%3fnc%3demail%26nt%3dduedate%22%7d\" target=\"_blank\"><strong style=\"display:inline-block; font-weight:600; font-size:14px; font-family:&quot;Segoe UI&quot;,sans-serif; line-height:20px; color:#252424; text-decoration:none\">Open in Teams </strong></a></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td align=\"left\" style=\"padding:0px; margin:0px\"><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" align=\"center\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td align=\"left\" style=\"font-size:12px; line-height:16px; padding:20px 32px\"><div><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"font-family:'Segoe UI',SUWR,Verdana,sans-serif; font-size:10px; line-height:20px; color:#6b6b6b; padding:6px 0; letter-spacing:-0.01em\">You are receiving this email because you have subscribed to Microsoft Office 365. </td></tr><tr><td style=\"font-family:'Segoe UI',SUWR,Verdana,sans-serif; font-size:10px; line-height:20px; color:#6b6b6b; padding:6px 0; letter-spacing:-0.01em\">Notification settings: Go to <a href=\"https://tasks.office.com/\" target=\"_blank\" style=\"color:#6b6b6c; text-decoration:underline\">Planner</a>, select the gear icon, then select &quot;Notifications&quot;. </td></tr><tr><td align=\"left\" style=\"padding-top:12px; text-align:left; padding-bottom:12px\"><hr></td></tr><tr><td align=\"left\" style=\"padding-top:12px; text-align:left; padding-bottom:12px\"><img src=\"cid:6de63808-df24-4ded-953f-51e43372feb5\" alt=\"\" title=\"\" height=\"22\" width=\"90\" style=\"margin:0px; height:22px; width:90px\"> </td></tr><tr><td align=\"left\" style=\"padding-top:12px; text-align:left; padding-bottom:12px\"><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td align=\"left\" style=\"padding:0 4px 0 0; white-space:nowrap\"><p style=\"padding:0px; margin:0px; font-family:'Segoe UI',SUWR,Verdana,sans-serif; font-size:12px; line-height:20px; color:#6b6b6c; letter-spacing:-0.01em\"><a href=\"https://go.microsoft.com/fwlink/?LinkId=521839\" target=\"_blank\" title=\"\" style=\"padding:0px; margin:0px; font-family:'Segoe UI',SUWR,Verdana,sans-serif; font-size:12px; line-height:20px; color:#6b6b6c; letter-spacing:-0.01em\">Privacy&nbsp;Statement</a> </p></td></tr></tbody></table></td></tr><tr><td align=\"left\" style=\"padding-top:12px; text-align:left; padding-bottom:12px\"><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td align=\"left\"><p style=\"margin:0px; font-family:'Segoe UI',SUWR,Verdana,sans-serif; font-size:12px; line-height:20px; color:#6b6b6c; letter-spacing:-0.01em\">This email is generated through Contoso's use of Microsoft 365 and may contain content that is controlled by Contoso.</p></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></div></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></div><img src=\"https://southcentralusr-notifyp.svc.ms:443/api/v2/tracking/method/View?mi=HKgzManeX0S7w4-vHN6RQw\" aria-hidden=\"true\" role=\"presentation\" height=\"1\" width=\"1\"></body></html>"
            },
            "sender": {
                "emailAddress": {
                    "name": "Microsoft on behalf of your organization",
                    "address": "noreply@planner.office365.com"
                }
            },
            "from": {
                "emailAddress": {
                    "name": "Microsoft on behalf of your organization",
                    "address": "noreply@planner.office365.com"
                }
            },
            "toRecipients": [
                {
                    "emailAddress": {
                        "name": "Adele Vance",
                        "address": "AdeleV@M365x63639251.OnMicrosoft.com"
                    }
                }
            ],
            "ccRecipients": [],
            "bccRecipients": [],
            "replyTo": [],
            "flag": {
                "flagStatus": "notFlagged"
            }
        },
        {
            "@odata.etag": "W/\"CQAAABYAAADUwywT0x3WRJXfefGC8Xz/AAA1TJax\"",
            "id": "AAMkADY1YmE3N2FhLWEwMzQtNDNkMC04Mzg3LTczMTdiMjk2NzRhMABGAAAAAADfsy0XtCMZS5XonZkyBLu6BwDUwywT0x3WRJXfefGC8Xz-AAAAAAEMAADUwywT0x3WRJXfefGC8Xz-AAA1XZtiAAA=",
            "createdDateTime": "2025-08-30T13:42:05Z",
            "lastModifiedDateTime": "2025-08-30T13:42:08Z",
            "changeKey": "CQAAABYAAADUwywT0x3WRJXfefGC8Xz/AAA1TJax",
            "categories": [],
            "receivedDateTime": "2025-08-30T13:42:05Z",
            "sentDateTime": "2025-08-30T13:41:58Z",
            "hasAttachments": False,
            "internetMessageId": "<PlannerDueDate-7688c09f-c44e-4021-92d2-8de00b402028-d5b84361-b85f-46c2-af73-e30406dc7e75-r0-SendEmail-rh_cac-aid_324e30b0-28af-4e01-9f69-149df0cf97fd@odspnotify>",
            "subject": "You have late tasks",
            "bodyPreview": "Hi Adele. You have 8 tasks due.\r\n        You have late tasks\r\nTailspin CEO\r\nIn the plan  Logistics\r\n8/29/2025\r\n1 day late\r\nTerra Firm Presentation\r\nIn the plan  PattiF Logistics\r\n8/28/2025\r\n2 days late\r\nTerra Firm Presentation\r\nIn the plan  Logistics\r\n8/2",
            "importance": "normal",
            "parentFolderId": "AAMkADY1YmE3N2FhLWEwMzQtNDNkMC04Mzg3LTczMTdiMjk2NzRhMAAuAAAAAADfsy0XtCMZS5XonZkyBLu6AQDUwywT0x3WRJXfefGC8Xz-AAAAAAEMAAA=",
            "conversationId": "AAQkADY1YmE3N2FhLWEwMzQtNDNkMC04Mzg3LTczMTdiMjk2NzRhMAAQAGiZwAlmoaZKnre9TskXskI=",
            "conversationIndex": "AQHcGbPfaJnACWahpkqet71OyReyQg==",
            "isDeliveryReceiptRequested": None,
            "isReadReceiptRequested": False,
            "isRead": False,
            "isDraft": False,
            "webLink": "https://outlook.office365.com/owa/?ItemID=AAMkADY1YmE3N2FhLWEwMzQtNDNkMC04Mzg3LTczMTdiMjk2NzRhMABGAAAAAADfsy0XtCMZS5XonZkyBLu6BwDUwywT0x3WRJXfefGC8Xz%2FAAAAAAEMAADUwywT0x3WRJXfefGC8Xz%2FAAA1XZtiAAA%3D&exvsurl=1&viewmodel=ReadMessageItem",
            "inferenceClassification": "focused",
            "body": {
                "contentType": "html",
                "content": "<html dir=\"ltr\" lang=\"en-us\"><head>\r\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"><style type=\"text/css\">\r\n<!--\r\n.headerBackgroundMsoTable\r\n\t{border-spacing:0px;\r\n\twidth:100%}\r\n-->\r\n</style></head><body style=\"margin:0px\"><div><table height=\"100%\" width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px\"><tbody><tr><td valign=\"top\" align=\"center\"><table align=\"center\" style=\"border-spacing:0px; width:100%!important; margin-right:auto; margin-left:auto; margin:0 auto; max-width:640px; font-family:'Segoe UI'; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td align=\"left\" style=\"padding:0px; margin:0px\"><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td align=\"center\"><div><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td colspan=\"1\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%\"><tbody><tr><td style=\"padding:32px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:20px; color:#242424\">Hi Adele. You have 8 tasks due. </span></td></tr></tbody></table></td></tr></tbody></table></div></td></tr></tbody></table></td></tr><tr><td align=\"left\" style=\"padding:0px; margin:0px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; border-top:1px solid #E1DFDD; border-bottom:1px solid #E1DFDD; border-top:1px solid rgba(128,128,128,0.25); border-bottom:1px solid rgba(128,128,128,0.25)\"><tbody><tr><td style=\"padding:12px 32px 4px; background-color:#FAFAFA\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%\"><tbody><tr><td style=\"padding:11px 0 3px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%\"><tbody><tr><td style=\"width:35px\"><img src=\"cid:56b20eb2-8f7e-4341-b3f5-7041a4fa8766\" alt=\"Calendar Late\" width=\"30\" height=\"30\" border=\"0\" style=\"display:block; outline:none; border:none\"> </td><td><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:14px; color:#1B1A19\">You have <b>late</b> tasks </span></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt/DJdyzE93q0qIFCCXvHPucWUAAH4x?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638921581167416299\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Tailspin CEO</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:2d2378e0-50a8-4c73-bbe3-fe006e2f2f99\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638921581167416299\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">Logistics</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:9dcf8ceb-1eb1-43f4-8e1f-81b714518eaa\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/29/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#FED9CC\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#A80000\">1 day late</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/vTzrU8ilDEe2WnZp3wobLGUAEek-/HZ5tnG374U26YV32Le5rS2UAIevZ?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638921581167416299\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Terra Firm Presentation</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:2d2378e0-50a8-4c73-bbe3-fe006e2f2f99\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/vTzrU8ilDEe2WnZp3wobLGUAEek-?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638921581167416299\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">PattiF Logistics</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:9dcf8ceb-1eb1-43f4-8e1f-81b714518eaa\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/28/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#FED9CC\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#A80000\">2 days late</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt/LAl8pGDDbEu7LZ5fvs3ABGUAF9GX?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638921581167416299\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Terra Firm Presentation</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:2d2378e0-50a8-4c73-bbe3-fe006e2f2f99\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638921581167416299\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">Logistics</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:9dcf8ceb-1eb1-43f4-8e1f-81b714518eaa\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/28/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#FED9CC\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#A80000\">2 days late</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/vTzrU8ilDEe2WnZp3wobLGUAEek-/Q16nIEnVI0a4lTZZ79wa32UAAu7z?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638921581167416299\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">StockReport AM</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:2d2378e0-50a8-4c73-bbe3-fe006e2f2f99\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/vTzrU8ilDEe2WnZp3wobLGUAEek-?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638921581167416299\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">PattiF Logistics</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:9dcf8ceb-1eb1-43f4-8e1f-81b714518eaa\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/24/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#FED9CC\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#A80000\">6 days late</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/-zqS58FZ9EeN-_dKGA6XEWUACFRQ/_wvQexctwkmV0W87MdUOV2UAIYct?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638921581167416299\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Submit your expenses</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:2d2378e0-50a8-4c73-bbe3-fe006e2f2f99\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/-zqS58FZ9EeN-_dKGA6XEWUACFRQ?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638921581167416299\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">Event Plan</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:9dcf8ceb-1eb1-43f4-8e1f-81b714518eaa\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/28/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#FED9CC\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#A80000\">2 days late</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:6px 24px; text-align:center\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/MyTasks?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638921581167416299\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; text-decoration:none; color:#106EBE\">View all 8 late tasks</a></td></tr></tbody></table></td></tr><tr><td style=\"padding:20px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td align=\"center\" style=\"padding:6px 20px 6px 20px; border:1px solid #E1DFDD; border-radius:4px; background-color:#5B5FC7; box-shadow:0px 0px 4px rgba(0,0,0,0.09)\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/MyTasks?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638921581167416299\" target=\"_blank\"><strong style=\"display:inline-block; font-weight:600; font-size:14px; font-family:&quot;Segoe UI&quot;,sans-serif; line-height:20px; color:#ffffff; text-decoration:none\">Open in Browser </strong></a></td></tr></tbody></table></td><td style=\"padding-left:10px; padding-right:10px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td align=\"center\" style=\"padding:6px 20px 6px 20px; border:1px solid #E1DFDD; border-radius:4px; background-color:#ffffff; box-shadow:0px 0px 4px rgba(0,0,0,0.09)\"><a href=\"https://teams.microsoft.com/l/entity/com.microsoft.teamspace.tab.planner/mytasks?tenantId=dd172b04-e4e2-4084-885c-47c9cc57f059&amp;webUrl=https%3a%2f%2ftasks.teams.microsoft.com%2fteamsui%2fpersonalApp%2falltasklists&amp;context=%7b%22subEntityId%22%3a%22%2fv1%2fassignedtome%3fnc%3demail%26nt%3dduedate%22%7d\" target=\"_blank\"><strong style=\"display:inline-block; font-weight:600; font-size:14px; font-family:&quot;Segoe UI&quot;,sans-serif; line-height:20px; color:#252424; text-decoration:none\">Open in Teams </strong></a></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td align=\"left\" style=\"padding:0px; margin:0px\"><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" align=\"center\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td align=\"left\" style=\"font-size:12px; line-height:16px; padding:20px 32px\"><div><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"font-family:'Segoe UI',SUWR,Verdana,sans-serif; font-size:10px; line-height:20px; color:#6b6b6b; padding:6px 0; letter-spacing:-0.01em\">You are receiving this email because you have subscribed to Microsoft Office 365. </td></tr><tr><td style=\"font-family:'Segoe UI',SUWR,Verdana,sans-serif; font-size:10px; line-height:20px; color:#6b6b6b; padding:6px 0; letter-spacing:-0.01em\">Notification settings: Go to <a href=\"https://tasks.office.com/\" target=\"_blank\" style=\"color:#6b6b6c; text-decoration:underline\">Planner</a>, select the gear icon, then select &quot;Notifications&quot;. </td></tr><tr><td align=\"left\" style=\"padding-top:12px; text-align:left; padding-bottom:12px\"><hr></td></tr><tr><td align=\"left\" style=\"padding-top:12px; text-align:left; padding-bottom:12px\"><img src=\"cid:8a77c0e0-434d-4c5f-9961-2713cee9a7ff\" alt=\"\" title=\"\" height=\"22\" width=\"90\" style=\"margin:0px; height:22px; width:90px\"> </td></tr><tr><td align=\"left\" style=\"padding-top:12px; text-align:left; padding-bottom:12px\"><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td align=\"left\" style=\"padding:0 4px 0 0; white-space:nowrap\"><p style=\"padding:0px; margin:0px; font-family:'Segoe UI',SUWR,Verdana,sans-serif; font-size:12px; line-height:20px; color:#6b6b6c; letter-spacing:-0.01em\"><a href=\"https://go.microsoft.com/fwlink/?LinkId=521839\" target=\"_blank\" title=\"\" style=\"padding:0px; margin:0px; font-family:'Segoe UI',SUWR,Verdana,sans-serif; font-size:12px; line-height:20px; color:#6b6b6c; letter-spacing:-0.01em\">Privacy&nbsp;Statement</a> </p></td></tr></tbody></table></td></tr><tr><td align=\"left\" style=\"padding-top:12px; text-align:left; padding-bottom:12px\"><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td align=\"left\"><p style=\"margin:0px; font-family:'Segoe UI',SUWR,Verdana,sans-serif; font-size:12px; line-height:20px; color:#6b6b6c; letter-spacing:-0.01em\">This email is generated through Contoso's use of Microsoft 365 and may contain content that is controlled by Contoso.</p></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></div></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></div><img src=\"https://southcentralusr-notifyp.svc.ms:443/api/v2/tracking/method/View?mi=D1fA6CI9MUef3OkRLF9vvQ\" aria-hidden=\"true\" role=\"presentation\" height=\"1\" width=\"1\"></body></html>"
            },
            "sender": {
                "emailAddress": {
                    "name": "Microsoft on behalf of your organization",
                    "address": "noreply@planner.office365.com"
                }
            },
            "from": {
                "emailAddress": {
                    "name": "Microsoft on behalf of your organization",
                    "address": "noreply@planner.office365.com"
                }
            },
            "toRecipients": [
                {
                    "emailAddress": {
                        "name": "Adele Vance",
                        "address": "AdeleV@M365x63639251.OnMicrosoft.com"
                    }
                }
            ],
            "ccRecipients": [],
            "bccRecipients": [],
            "replyTo": [],
            "flag": {
                "flagStatus": "notFlagged"
            }
        },
        {
            "@odata.etag": "W/\"CQAAABYAAADUwywT0x3WRJXfefGC8Xz/AAA1THQl\"",
            "id": "AAMkADY1YmE3N2FhLWEwMzQtNDNkMC04Mzg3LTczMTdiMjk2NzRhMABGAAAAAADfsy0XtCMZS5XonZkyBLu6BwDUwywT0x3WRJXfefGC8Xz-AAAAAAEMAADUwywT0x3WRJXfefGC8Xz-AAA1XZthAAA=",
            "createdDateTime": "2025-08-29T12:44:57Z",
            "lastModifiedDateTime": "2025-08-29T12:44:59Z",
            "changeKey": "CQAAABYAAADUwywT0x3WRJXfefGC8Xz/AAA1THQl",
            "categories": [],
            "receivedDateTime": "2025-08-29T12:44:57Z",
            "sentDateTime": "2025-08-29T12:44:51Z",
            "hasAttachments": False,
            "internetMessageId": "<PlannerDueDate-0a1bda76-19df-4210-93d9-7a93773a63aa-4ea2cab0-562a-487f-8e2e-e0579523f811-r0-SendEmail-rh_cac-aid_f7ae7205-7f2b-4555-abd6-91ccfc749c6d@odspnotify>",
            "subject": "You have late tasks",
            "bodyPreview": "Hi Adele. You have 8 tasks due.\r\n        You have late tasks\r\nTerra Firm Presentation\r\nIn the plan  PattiF Logistics\r\n8/28/2025\r\n1 day late\r\nTerra Firm Presentation\r\nIn the plan  Logistics\r\n8/28/2025\r\n1 day late\r\nStockReport AM\r\nIn the plan  PattiF Logist",
            "importance": "normal",
            "parentFolderId": "AAMkADY1YmE3N2FhLWEwMzQtNDNkMC04Mzg3LTczMTdiMjk2NzRhMAAuAAAAAADfsy0XtCMZS5XonZkyBLu6AQDUwywT0x3WRJXfefGC8Xz-AAAAAAEMAAA=",
            "conversationId": "AAQkADY1YmE3N2FhLWEwMzQtNDNkMC04Mzg3LTczMTdiMjk2NzRhMAAQAEKcb0SwI21LvS9Kc4cyRpg=",
            "conversationIndex": "AQHcGOK5QpxvRLAjbUu9L0pzhzJGmA==",
            "isDeliveryReceiptRequested": None,
            "isReadReceiptRequested": False,
            "isRead": False,
            "isDraft": False,
            "webLink": "https://outlook.office365.com/owa/?ItemID=AAMkADY1YmE3N2FhLWEwMzQtNDNkMC04Mzg3LTczMTdiMjk2NzRhMABGAAAAAADfsy0XtCMZS5XonZkyBLu6BwDUwywT0x3WRJXfefGC8Xz%2FAAAAAAEMAADUwywT0x3WRJXfefGC8Xz%2FAAA1XZthAAA%3D&exvsurl=1&viewmodel=ReadMessageItem",
            "inferenceClassification": "focused",
            "body": {
                "contentType": "html",
                "content": "<html dir=\"ltr\" lang=\"en-us\"><head>\r\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"><style type=\"text/css\">\r\n<!--\r\n.headerBackgroundMsoTable\r\n\t{border-spacing:0px;\r\n\twidth:100%}\r\n-->\r\n</style></head><body style=\"margin:0px\"><div><table height=\"100%\" width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px\"><tbody><tr><td valign=\"top\" align=\"center\"><table align=\"center\" style=\"border-spacing:0px; width:100%!important; margin-right:auto; margin-left:auto; margin:0 auto; max-width:640px; font-family:'Segoe UI'; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td align=\"left\" style=\"padding:0px; margin:0px\"><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td align=\"center\"><div><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td colspan=\"1\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%\"><tbody><tr><td style=\"padding:32px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:20px; color:#242424\">Hi Adele. You have 8 tasks due. </span></td></tr></tbody></table></td></tr></tbody></table></div></td></tr></tbody></table></td></tr><tr><td align=\"left\" style=\"padding:0px; margin:0px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; border-top:1px solid #E1DFDD; border-bottom:1px solid #E1DFDD; border-top:1px solid rgba(128,128,128,0.25); border-bottom:1px solid rgba(128,128,128,0.25)\"><tbody><tr><td style=\"padding:12px 32px 4px; background-color:#FAFAFA\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%\"><tbody><tr><td style=\"padding:11px 0 3px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%\"><tbody><tr><td style=\"width:35px\"><img src=\"cid:b33eec12-23b9-4930-8336-387861daeaa4\" alt=\"Calendar Late\" width=\"30\" height=\"30\" border=\"0\" style=\"display:block; outline:none; border:none\"> </td><td><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:14px; color:#1B1A19\">You have <b>late</b> tasks </span></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/vTzrU8ilDEe2WnZp3wobLGUAEek-/HZ5tnG374U26YV32Le5rS2UAIevZ?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638920682897486075\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Terra Firm Presentation</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:a854bb28-1d33-46ef-ab3e-da147738c8e9\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/vTzrU8ilDEe2WnZp3wobLGUAEek-?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638920682897486075\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">PattiF Logistics</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:233bc56c-993b-4506-9866-c44a7dadcd32\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/28/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#FED9CC\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#A80000\">1 day late</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt/LAl8pGDDbEu7LZ5fvs3ABGUAF9GX?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638920682897486075\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Terra Firm Presentation</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:a854bb28-1d33-46ef-ab3e-da147738c8e9\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638920682897486075\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">Logistics</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:233bc56c-993b-4506-9866-c44a7dadcd32\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/28/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#FED9CC\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#A80000\">1 day late</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/vTzrU8ilDEe2WnZp3wobLGUAEek-/Q16nIEnVI0a4lTZZ79wa32UAAu7z?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638920682897486075\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">StockReport AM</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:a854bb28-1d33-46ef-ab3e-da147738c8e9\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/vTzrU8ilDEe2WnZp3wobLGUAEek-?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638920682897486075\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">PattiF Logistics</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:233bc56c-993b-4506-9866-c44a7dadcd32\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/24/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#FED9CC\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#A80000\">5 days late</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/-zqS58FZ9EeN-_dKGA6XEWUACFRQ/_wvQexctwkmV0W87MdUOV2UAIYct?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638920682897486075\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Submit your expenses</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:a854bb28-1d33-46ef-ab3e-da147738c8e9\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/-zqS58FZ9EeN-_dKGA6XEWUACFRQ?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638920682897486075\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">Event Plan</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:233bc56c-993b-4506-9866-c44a7dadcd32\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/28/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#FED9CC\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#A80000\">1 day late</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/oTP_zi2u9k2iHyfIXz4xY2UAFhM3/dc20HY1ewkmy1KmoSmH2EGUAAcTu?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638920682897486075\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Submit your expenses</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:a854bb28-1d33-46ef-ab3e-da147738c8e9\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/oTP_zi2u9k2iHyfIXz4xY2UAFhM3?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638920682897486075\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">Event Plan</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:233bc56c-993b-4506-9866-c44a7dadcd32\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/28/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#FED9CC\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#A80000\">1 day late</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:6px 24px; text-align:center\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/MyTasks?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638920682897486075\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; text-decoration:none; color:#106EBE\">View all 6 late tasks</a></td></tr></tbody></table></td></tr><tr><td style=\"padding:11px 0 3px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%\"><tbody><tr><td style=\"width:35px\"><img src=\"cid:93824570-ff14-4c58-a802-5f3660dc36d4\" alt=\"Calendar Late\" width=\"30\" height=\"30\" border=\"0\" style=\"display:block; outline:none; border:none\"> </td><td><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:14px; color:#1B1A19\">You have tasks <b>due today</b> </span></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt/DJdyzE93q0qIFCCXvHPucWUAAH4x?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638920682897486075\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Tailspin CEO</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:a854bb28-1d33-46ef-ab3e-da147738c8e9\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638920682897486075\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">Logistics</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:233bc56c-993b-4506-9866-c44a7dadcd32\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/29/2025</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/vTzrU8ilDEe2WnZp3wobLGUAEek-/gVfS81WBpUekMM8YUNZCe2UAGRn1?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638920682897486075\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Tailspin CEO</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:a854bb28-1d33-46ef-ab3e-da147738c8e9\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/vTzrU8ilDEe2WnZp3wobLGUAEek-?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638920682897486075\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">PattiF Logistics</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:233bc56c-993b-4506-9866-c44a7dadcd32\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/29/2025</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:20px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td align=\"center\" style=\"padding:6px 20px 6px 20px; border:1px solid #E1DFDD; border-radius:4px; background-color:#5B5FC7; box-shadow:0px 0px 4px rgba(0,0,0,0.09)\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/MyTasks?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638920682897486075\" target=\"_blank\"><strong style=\"display:inline-block; font-weight:600; font-size:14px; font-family:&quot;Segoe UI&quot;,sans-serif; line-height:20px; color:#ffffff; text-decoration:none\">Open in Browser </strong></a></td></tr></tbody></table></td><td style=\"padding-left:10px; padding-right:10px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td align=\"center\" style=\"padding:6px 20px 6px 20px; border:1px solid #E1DFDD; border-radius:4px; background-color:#ffffff; box-shadow:0px 0px 4px rgba(0,0,0,0.09)\"><a href=\"https://teams.microsoft.com/l/entity/com.microsoft.teamspace.tab.planner/mytasks?tenantId=dd172b04-e4e2-4084-885c-47c9cc57f059&amp;webUrl=https%3a%2f%2ftasks.teams.microsoft.com%2fteamsui%2fpersonalApp%2falltasklists&amp;context=%7b%22subEntityId%22%3a%22%2fv1%2fassignedtome%3fnc%3demail%26nt%3dduedate%22%7d\" target=\"_blank\"><strong style=\"display:inline-block; font-weight:600; font-size:14px; font-family:&quot;Segoe UI&quot;,sans-serif; line-height:20px; color:#252424; text-decoration:none\">Open in Teams </strong></a></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td align=\"left\" style=\"padding:0px; margin:0px\"><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" align=\"center\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td align=\"left\" style=\"font-size:12px; line-height:16px; padding:20px 32px\"><div><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"font-family:'Segoe UI',SUWR,Verdana,sans-serif; font-size:10px; line-height:20px; color:#6b6b6b; padding:6px 0; letter-spacing:-0.01em\">You are receiving this email because you have subscribed to Microsoft Office 365. </td></tr><tr><td style=\"font-family:'Segoe UI',SUWR,Verdana,sans-serif; font-size:10px; line-height:20px; color:#6b6b6b; padding:6px 0; letter-spacing:-0.01em\">Notification settings: Go to <a href=\"https://tasks.office.com/\" target=\"_blank\" style=\"color:#6b6b6c; text-decoration:underline\">Planner</a>, select the gear icon, then select &quot;Notifications&quot;. </td></tr><tr><td align=\"left\" style=\"padding-top:12px; text-align:left; padding-bottom:12px\"><hr></td></tr><tr><td align=\"left\" style=\"padding-top:12px; text-align:left; padding-bottom:12px\"><img src=\"cid:f5b72099-2bfd-49bd-a617-581b627273a3\" alt=\"\" title=\"\" height=\"22\" width=\"90\" style=\"margin:0px; height:22px; width:90px\"> </td></tr><tr><td align=\"left\" style=\"padding-top:12px; text-align:left; padding-bottom:12px\"><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td align=\"left\" style=\"padding:0 4px 0 0; white-space:nowrap\"><p style=\"padding:0px; margin:0px; font-family:'Segoe UI',SUWR,Verdana,sans-serif; font-size:12px; line-height:20px; color:#6b6b6c; letter-spacing:-0.01em\"><a href=\"https://go.microsoft.com/fwlink/?LinkId=521839\" target=\"_blank\" title=\"\" style=\"padding:0px; margin:0px; font-family:'Segoe UI',SUWR,Verdana,sans-serif; font-size:12px; line-height:20px; color:#6b6b6c; letter-spacing:-0.01em\">Privacy&nbsp;Statement</a> </p></td></tr></tbody></table></td></tr><tr><td align=\"left\" style=\"padding-top:12px; text-align:left; padding-bottom:12px\"><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td align=\"left\"><p style=\"margin:0px; font-family:'Segoe UI',SUWR,Verdana,sans-serif; font-size:12px; line-height:20px; color:#6b6b6c; letter-spacing:-0.01em\">This email is generated through Contoso's use of Microsoft 365 and may contain content that is controlled by Contoso.</p></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></div></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></div><img src=\"https://southcentralusr-notifyp.svc.ms:443/api/v2/tracking/method/View?mi=P7xn9I7R10ml_vy0fHY0bQ\" aria-hidden=\"true\" role=\"presentation\" height=\"1\" width=\"1\"></body></html>"
            },
            "sender": {
                "emailAddress": {
                    "name": "Microsoft on behalf of your organization",
                    "address": "noreply@planner.office365.com"
                }
            },
            "from": {
                "emailAddress": {
                    "name": "Microsoft on behalf of your organization",
                    "address": "noreply@planner.office365.com"
                }
            },
            "toRecipients": [
                {
                    "emailAddress": {
                        "name": "Adele Vance",
                        "address": "AdeleV@M365x63639251.OnMicrosoft.com"
                    }
                }
            ],
            "ccRecipients": [],
            "bccRecipients": [],
            "replyTo": [],
            "flag": {
                "flagStatus": "notFlagged"
            }
        },
        {
            "@odata.etag": "W/\"CQAAABYAAADUwywT0x3WRJXfefGC8Xz/AAA1TFFb\"",
            "id": "AAMkADY1YmE3N2FhLWEwMzQtNDNkMC04Mzg3LTczMTdiMjk2NzRhMABGAAAAAADfsy0XtCMZS5XonZkyBLu6BwDUwywT0x3WRJXfefGC8Xz-AAAAAAEMAADUwywT0x3WRJXfefGC8Xz-AAA1XZtgAAA=",
            "createdDateTime": "2025-08-28T12:44:55Z",
            "lastModifiedDateTime": "2025-08-28T12:44:59Z",
            "changeKey": "CQAAABYAAADUwywT0x3WRJXfefGC8Xz/AAA1TFFb",
            "categories": [],
            "receivedDateTime": "2025-08-28T12:44:56Z",
            "sentDateTime": "2025-08-28T12:44:48Z",
            "hasAttachments": False,
            "internetMessageId": "<PlannerDueDate-6414df0a-e427-4351-9d56-c0edb5e91940-d3e4c884-e83f-44b1-b885-b8101147acfe-r0-SendEmail-rh_cac-aid_c9f3325e-b8b1-4440-9597-d7a78402e0ce@odspnotify>",
            "subject": "You have late tasks",
            "bodyPreview": "Hi Adele. You have 10 tasks due.\r\n        You have late tasks\r\nOrder Patti Smoothie Stuff\r\nIn the plan  PattiF Logistics\r\n8/21/2025\r\n7 days late\r\nStockReport AM\r\nIn the plan  PattiF Logistics\r\n8/24/2025\r\n4 days late\r\nOrder Patti Smoothie Stuff\r\nIn the pla",
            "importance": "normal",
            "parentFolderId": "AAMkADY1YmE3N2FhLWEwMzQtNDNkMC04Mzg3LTczMTdiMjk2NzRhMAAuAAAAAADfsy0XtCMZS5XonZkyBLu6AQDUwywT0x3WRJXfefGC8Xz-AAAAAAEMAAA=",
            "conversationId": "AAQkADY1YmE3N2FhLWEwMzQtNDNkMC04Mzg3LTczMTdiMjk2NzRhMAAQAE59QACGEgZDnx2IpLbiR18=",
            "conversationIndex": "AQHcGBmOTn1AAIYSBkOfHYiktuJHXw==",
            "isDeliveryReceiptRequested": None,
            "isReadReceiptRequested": False,
            "isRead": False,
            "isDraft": False,
            "webLink": "https://outlook.office365.com/owa/?ItemID=AAMkADY1YmE3N2FhLWEwMzQtNDNkMC04Mzg3LTczMTdiMjk2NzRhMABGAAAAAADfsy0XtCMZS5XonZkyBLu6BwDUwywT0x3WRJXfefGC8Xz%2FAAAAAAEMAADUwywT0x3WRJXfefGC8Xz%2FAAA1XZtgAAA%3D&exvsurl=1&viewmodel=ReadMessageItem",
            "inferenceClassification": "focused",
            "body": {
                "contentType": "html",
                "content": "<html dir=\"ltr\" lang=\"en-us\"><head>\r\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"><style type=\"text/css\">\r\n<!--\r\n.headerBackgroundMsoTable\r\n\t{border-spacing:0px;\r\n\twidth:100%}\r\n-->\r\n</style></head><body style=\"margin:0px\"><div><table height=\"100%\" width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px\"><tbody><tr><td valign=\"top\" align=\"center\"><table align=\"center\" style=\"border-spacing:0px; width:100%!important; margin-right:auto; margin-left:auto; margin:0 auto; max-width:640px; font-family:'Segoe UI'; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td align=\"left\" style=\"padding:0px; margin:0px\"><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td align=\"center\"><div><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td colspan=\"1\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%\"><tbody><tr><td style=\"padding:32px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:20px; color:#242424\">Hi Adele. You have 10 tasks due. </span></td></tr></tbody></table></td></tr></tbody></table></div></td></tr></tbody></table></td></tr><tr><td align=\"left\" style=\"padding:0px; margin:0px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; border-top:1px solid #E1DFDD; border-bottom:1px solid #E1DFDD; border-top:1px solid rgba(128,128,128,0.25); border-bottom:1px solid rgba(128,128,128,0.25)\"><tbody><tr><td style=\"padding:12px 32px 4px; background-color:#FAFAFA\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%\"><tbody><tr><td style=\"padding:11px 0 3px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%\"><tbody><tr><td style=\"width:35px\"><img src=\"cid:d621e9fb-5d11-4a7a-8557-5dbf96bd3edd\" alt=\"Calendar Late\" width=\"30\" height=\"30\" border=\"0\" style=\"display:block; outline:none; border:none\"> </td><td><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:14px; color:#1B1A19\">You have <b>late</b> tasks </span></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/vTzrU8ilDEe2WnZp3wobLGUAEek-/B3HAH6m0UU6UgIREFNISfWUAK19q?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638919818877394787\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Order Patti Smoothie Stuff</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:f33cf02c-b134-4b95-95ed-bb3e6a3a3079\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/vTzrU8ilDEe2WnZp3wobLGUAEek-?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638919818877394787\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">PattiF Logistics</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:405256ce-b2bc-4143-8163-17912990054a\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/21/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#FED9CC\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#A80000\">7 days late</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/vTzrU8ilDEe2WnZp3wobLGUAEek-/Q16nIEnVI0a4lTZZ79wa32UAAu7z?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638919818877394787\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">StockReport AM</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:f33cf02c-b134-4b95-95ed-bb3e6a3a3079\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/vTzrU8ilDEe2WnZp3wobLGUAEek-?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638919818877394787\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">PattiF Logistics</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:405256ce-b2bc-4143-8163-17912990054a\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/24/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#FED9CC\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#A80000\">4 days late</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt/bbdxY3fGVEKZxL-HYK35YGUACWL9?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638919818877394787\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Order Patti Smoothie Stuff</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:f33cf02c-b134-4b95-95ed-bb3e6a3a3079\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638919818877394787\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">Logistics</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:405256ce-b2bc-4143-8163-17912990054a\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/21/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#FED9CC\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#A80000\">7 days late</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt/rZ3tUfiphUS5NMB8HoeKz2UAMaev?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638919818877394787\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">StockReport AM</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:f33cf02c-b134-4b95-95ed-bb3e6a3a3079\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638919818877394787\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">Logistics</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:405256ce-b2bc-4143-8163-17912990054a\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/24/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#FED9CC\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#A80000\">4 days late</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:11px 0 3px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%\"><tbody><tr><td style=\"width:35px\"><img src=\"cid:418e4538-3342-4c64-b0ae-210d8d57c39e\" alt=\"Calendar Late\" width=\"30\" height=\"30\" border=\"0\" style=\"display:block; outline:none; border:none\"> </td><td><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:14px; color:#1B1A19\">You have tasks <b>due today</b> </span></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/vTzrU8ilDEe2WnZp3wobLGUAEek-/HZ5tnG374U26YV32Le5rS2UAIevZ?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638919818877394787\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Terra Firm Presentation</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:f33cf02c-b134-4b95-95ed-bb3e6a3a3079\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/vTzrU8ilDEe2WnZp3wobLGUAEek-?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638919818877394787\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">PattiF Logistics</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:405256ce-b2bc-4143-8163-17912990054a\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/28/2025</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt/LAl8pGDDbEu7LZ5fvs3ABGUAF9GX?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638919818877394787\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Terra Firm Presentation</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:f33cf02c-b134-4b95-95ed-bb3e6a3a3079\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638919818877394787\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">Logistics</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:405256ce-b2bc-4143-8163-17912990054a\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/28/2025</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/-zqS58FZ9EeN-_dKGA6XEWUACFRQ/_wvQexctwkmV0W87MdUOV2UAIYct?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638919818877394787\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Submit your expenses</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:f33cf02c-b134-4b95-95ed-bb3e6a3a3079\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/-zqS58FZ9EeN-_dKGA6XEWUACFRQ?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638919818877394787\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">Event Plan</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:405256ce-b2bc-4143-8163-17912990054a\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/28/2025</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/oTP_zi2u9k2iHyfIXz4xY2UAFhM3/dc20HY1ewkmy1KmoSmH2EGUAAcTu?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638919818877394787\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Submit your expenses</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:f33cf02c-b134-4b95-95ed-bb3e6a3a3079\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/oTP_zi2u9k2iHyfIXz4xY2UAFhM3?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638919818877394787\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">Event Plan</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:405256ce-b2bc-4143-8163-17912990054a\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/28/2025</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:11px 0 3px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%\"><tbody><tr><td style=\"width:35px\"><img src=\"cid:a096b762-eb49-44a1-8847-9492ffe97c76\" alt=\"Calendar Late\" width=\"30\" height=\"30\" border=\"0\" style=\"display:block; outline:none; border:none\"> </td><td><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:14px; color:#1B1A19\">You have <b>upcoming</b> tasks </span></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt/DJdyzE93q0qIFCCXvHPucWUAAH4x?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638919818877394787\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Tailspin CEO</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:f33cf02c-b134-4b95-95ed-bb3e6a3a3079\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638919818877394787\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">Logistics</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:405256ce-b2bc-4143-8163-17912990054a\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/29/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#EDEBE9\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#323130\">Due in 1 day</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/vTzrU8ilDEe2WnZp3wobLGUAEek-/gVfS81WBpUekMM8YUNZCe2UAGRn1?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638919818877394787\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Tailspin CEO</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:f33cf02c-b134-4b95-95ed-bb3e6a3a3079\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/vTzrU8ilDEe2WnZp3wobLGUAEek-?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638919818877394787\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">PattiF Logistics</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:405256ce-b2bc-4143-8163-17912990054a\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/29/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#EDEBE9\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#323130\">Due in 1 day</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:20px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td align=\"center\" style=\"padding:6px 20px 6px 20px; border:1px solid #E1DFDD; border-radius:4px; background-color:#5B5FC7; box-shadow:0px 0px 4px rgba(0,0,0,0.09)\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/MyTasks?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638919818877394787\" target=\"_blank\"><strong style=\"display:inline-block; font-weight:600; font-size:14px; font-family:&quot;Segoe UI&quot;,sans-serif; line-height:20px; color:#ffffff; text-decoration:none\">Open in Browser </strong></a></td></tr></tbody></table></td><td style=\"padding-left:10px; padding-right:10px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td align=\"center\" style=\"padding:6px 20px 6px 20px; border:1px solid #E1DFDD; border-radius:4px; background-color:#ffffff; box-shadow:0px 0px 4px rgba(0,0,0,0.09)\"><a href=\"https://teams.microsoft.com/l/entity/com.microsoft.teamspace.tab.planner/mytasks?tenantId=dd172b04-e4e2-4084-885c-47c9cc57f059&amp;webUrl=https%3a%2f%2ftasks.teams.microsoft.com%2fteamsui%2fpersonalApp%2falltasklists&amp;context=%7b%22subEntityId%22%3a%22%2fv1%2fassignedtome%3fnc%3demail%26nt%3dduedate%22%7d\" target=\"_blank\"><strong style=\"display:inline-block; font-weight:600; font-size:14px; font-family:&quot;Segoe UI&quot;,sans-serif; line-height:20px; color:#252424; text-decoration:none\">Open in Teams </strong></a></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td align=\"left\" style=\"padding:0px; margin:0px\"><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" align=\"center\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td align=\"left\" style=\"font-size:12px; line-height:16px; padding:20px 32px\"><div><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"font-family:'Segoe UI',SUWR,Verdana,sans-serif; font-size:10px; line-height:20px; color:#6b6b6b; padding:6px 0; letter-spacing:-0.01em\">You are receiving this email because you have subscribed to Microsoft Office 365. </td></tr><tr><td style=\"font-family:'Segoe UI',SUWR,Verdana,sans-serif; font-size:10px; line-height:20px; color:#6b6b6b; padding:6px 0; letter-spacing:-0.01em\">Notification settings: Go to <a href=\"https://tasks.office.com/\" target=\"_blank\" style=\"color:#6b6b6c; text-decoration:underline\">Planner</a>, select the gear icon, then select &quot;Notifications&quot;. </td></tr><tr><td align=\"left\" style=\"padding-top:12px; text-align:left; padding-bottom:12px\"><hr></td></tr><tr><td align=\"left\" style=\"padding-top:12px; text-align:left; padding-bottom:12px\"><img src=\"cid:9e8489a9-d159-40d8-a723-6a6cd2822fe6\" alt=\"\" title=\"\" height=\"22\" width=\"90\" style=\"margin:0px; height:22px; width:90px\"> </td></tr><tr><td align=\"left\" style=\"padding-top:12px; text-align:left; padding-bottom:12px\"><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td align=\"left\" style=\"padding:0 4px 0 0; white-space:nowrap\"><p style=\"padding:0px; margin:0px; font-family:'Segoe UI',SUWR,Verdana,sans-serif; font-size:12px; line-height:20px; color:#6b6b6c; letter-spacing:-0.01em\"><a href=\"https://go.microsoft.com/fwlink/?LinkId=521839\" target=\"_blank\" title=\"\" style=\"padding:0px; margin:0px; font-family:'Segoe UI',SUWR,Verdana,sans-serif; font-size:12px; line-height:20px; color:#6b6b6c; letter-spacing:-0.01em\">Privacy&nbsp;Statement</a> </p></td></tr></tbody></table></td></tr><tr><td align=\"left\" style=\"padding-top:12px; text-align:left; padding-bottom:12px\"><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td align=\"left\"><p style=\"margin:0px; font-family:'Segoe UI',SUWR,Verdana,sans-serif; font-size:12px; line-height:20px; color:#6b6b6c; letter-spacing:-0.01em\">This email is generated through Contoso's use of Microsoft 365 and may contain content that is controlled by Contoso.</p></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></div></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></div><img src=\"https://southcentralusr-notifyp.svc.ms:443/api/v2/tracking/method/View?mi=LyQeRTi9xEibJ6Uy-kB6dg\" aria-hidden=\"true\" role=\"presentation\" height=\"1\" width=\"1\"></body></html>"
            },
            "sender": {
                "emailAddress": {
                    "name": "Microsoft on behalf of your organization",
                    "address": "noreply@planner.office365.com"
                }
            },
            "from": {
                "emailAddress": {
                    "name": "Microsoft on behalf of your organization",
                    "address": "noreply@planner.office365.com"
                }
            },
            "toRecipients": [
                {
                    "emailAddress": {
                        "name": "Adele Vance",
                        "address": "AdeleV@M365x63639251.OnMicrosoft.com"
                    }
                }
            ],
            "ccRecipients": [],
            "bccRecipients": [],
            "replyTo": [],
            "flag": {
                "flagStatus": "notFlagged"
            }
        },
        {
            "@odata.etag": "W/\"CQAAABYAAADUwywT0x3WRJXfefGC8Xz/AAA1TDcN\"",
            "id": "AAMkADY1YmE3N2FhLWEwMzQtNDNkMC04Mzg3LTczMTdiMjk2NzRhMABGAAAAAADfsy0XtCMZS5XonZkyBLu6BwDUwywT0x3WRJXfefGC8Xz-AAAAAAEMAADUwywT0x3WRJXfefGC8Xz-AAA1XZtfAAA=",
            "createdDateTime": "2025-08-27T13:16:06Z",
            "lastModifiedDateTime": "2025-08-27T13:16:13Z",
            "changeKey": "CQAAABYAAADUwywT0x3WRJXfefGC8Xz/AAA1TDcN",
            "categories": [],
            "receivedDateTime": "2025-08-27T13:16:07Z",
            "sentDateTime": "2025-08-27T13:15:57Z",
            "hasAttachments": False,
            "internetMessageId": "<PlannerDueDate-bbc77cbb-a463-40f1-b048-c4117e052c2b-4fe21f72-b4a4-4825-a389-18f419aeb629-r0-SendEmail-rh_cac-aid_512fe5ca-1bd0-4178-a0ef-3c065c3530f1@odspnotify>",
            "subject": "You have late tasks",
            "bodyPreview": "Hi Adele. You have 10 tasks due.\r\n        You have late tasks\r\nOrder Patti Smoothie Stuff\r\nIn the plan  PattiF Logistics\r\n8/21/2025\r\n6 days late\r\nStockReport AM\r\nIn the plan  PattiF Logistics\r\n8/24/2025\r\n3 days late\r\nOrder Patti Smoothie Stuff\r\nIn the pla",
            "importance": "normal",
            "parentFolderId": "AAMkADY1YmE3N2FhLWEwMzQtNDNkMC04Mzg3LTczMTdiMjk2NzRhMAAuAAAAAADfsy0XtCMZS5XonZkyBLu6AQDUwywT0x3WRJXfefGC8Xz-AAAAAAEMAAA=",
            "conversationId": "AAQkADY1YmE3N2FhLWEwMzQtNDNkMC04Mzg3LTczMTdiMjk2NzRhMAAQAFjSpKSLbalMvTUTmBfBiu0=",
            "conversationIndex": "AQHcF1S/WNKkpIttqUy9NROYF8GK7Q==",
            "isDeliveryReceiptRequested": None,
            "isReadReceiptRequested": False,
            "isRead": False,
            "isDraft": False,
            "webLink": "https://outlook.office365.com/owa/?ItemID=AAMkADY1YmE3N2FhLWEwMzQtNDNkMC04Mzg3LTczMTdiMjk2NzRhMABGAAAAAADfsy0XtCMZS5XonZkyBLu6BwDUwywT0x3WRJXfefGC8Xz%2FAAAAAAEMAADUwywT0x3WRJXfefGC8Xz%2FAAA1XZtfAAA%3D&exvsurl=1&viewmodel=ReadMessageItem",
            "inferenceClassification": "focused",
            "body": {
                "contentType": "html",
                "content": "<html dir=\"ltr\" lang=\"en-us\"><head>\r\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"><style type=\"text/css\">\r\n<!--\r\n.headerBackgroundMsoTable\r\n\t{border-spacing:0px;\r\n\twidth:100%}\r\n-->\r\n</style></head><body style=\"margin:0px\"><div><table height=\"100%\" width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px\"><tbody><tr><td valign=\"top\" align=\"center\"><table align=\"center\" style=\"border-spacing:0px; width:100%!important; margin-right:auto; margin-left:auto; margin:0 auto; max-width:640px; font-family:'Segoe UI'; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td align=\"left\" style=\"padding:0px; margin:0px\"><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td align=\"center\"><div><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td colspan=\"1\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%\"><tbody><tr><td style=\"padding:32px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:20px; color:#242424\">Hi Adele. You have 10 tasks due. </span></td></tr></tbody></table></td></tr></tbody></table></div></td></tr></tbody></table></td></tr><tr><td align=\"left\" style=\"padding:0px; margin:0px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; border-top:1px solid #E1DFDD; border-bottom:1px solid #E1DFDD; border-top:1px solid rgba(128,128,128,0.25); border-bottom:1px solid rgba(128,128,128,0.25)\"><tbody><tr><td style=\"padding:12px 32px 4px; background-color:#FAFAFA\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%\"><tbody><tr><td style=\"padding:11px 0 3px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%\"><tbody><tr><td style=\"width:35px\"><img src=\"cid:f9f63343-c8fa-44ac-8d3e-12254fd5ff47\" alt=\"Calendar Late\" width=\"30\" height=\"30\" border=\"0\" style=\"display:block; outline:none; border:none\"> </td><td><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:14px; color:#1B1A19\">You have <b>late</b> tasks </span></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/vTzrU8ilDEe2WnZp3wobLGUAEek-/B3HAH6m0UU6UgIREFNISfWUAK19q?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638918973563302208\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Order Patti Smoothie Stuff</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:247de373-4d44-47dc-9f20-9a387561a30f\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/vTzrU8ilDEe2WnZp3wobLGUAEek-?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638918973563302208\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">PattiF Logistics</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:2cf70c38-b089-4150-84a4-34e4c472c4e3\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/21/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#FED9CC\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#A80000\">6 days late</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/vTzrU8ilDEe2WnZp3wobLGUAEek-/Q16nIEnVI0a4lTZZ79wa32UAAu7z?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638918973563302208\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">StockReport AM</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:247de373-4d44-47dc-9f20-9a387561a30f\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/vTzrU8ilDEe2WnZp3wobLGUAEek-?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638918973563302208\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">PattiF Logistics</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:2cf70c38-b089-4150-84a4-34e4c472c4e3\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/24/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#FED9CC\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#A80000\">3 days late</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt/bbdxY3fGVEKZxL-HYK35YGUACWL9?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638918973563302208\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Order Patti Smoothie Stuff</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:247de373-4d44-47dc-9f20-9a387561a30f\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638918973563302208\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">Logistics</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:2cf70c38-b089-4150-84a4-34e4c472c4e3\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/21/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#FED9CC\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#A80000\">6 days late</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt/rZ3tUfiphUS5NMB8HoeKz2UAMaev?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638918973563302208\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">StockReport AM</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:247de373-4d44-47dc-9f20-9a387561a30f\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638918973563302208\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">Logistics</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:2cf70c38-b089-4150-84a4-34e4c472c4e3\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/24/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#FED9CC\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#A80000\">3 days late</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:11px 0 3px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%\"><tbody><tr><td style=\"width:35px\"><img src=\"cid:c64a5eed-6a0f-4559-b86e-3b000095cc1d\" alt=\"Calendar Late\" width=\"30\" height=\"30\" border=\"0\" style=\"display:block; outline:none; border:none\"> </td><td><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:14px; color:#1B1A19\">You have <b>upcoming</b> tasks </span></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt/DJdyzE93q0qIFCCXvHPucWUAAH4x?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638918973563302208\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Tailspin CEO</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:247de373-4d44-47dc-9f20-9a387561a30f\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638918973563302208\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">Logistics</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:2cf70c38-b089-4150-84a4-34e4c472c4e3\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/29/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#EDEBE9\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#323130\">Due in 2 days</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/vTzrU8ilDEe2WnZp3wobLGUAEek-/HZ5tnG374U26YV32Le5rS2UAIevZ?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638918973563302208\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Terra Firm Presentation</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:247de373-4d44-47dc-9f20-9a387561a30f\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/vTzrU8ilDEe2WnZp3wobLGUAEek-?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638918973563302208\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">PattiF Logistics</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:2cf70c38-b089-4150-84a4-34e4c472c4e3\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/28/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#EDEBE9\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#323130\">Due in 1 day</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt/LAl8pGDDbEu7LZ5fvs3ABGUAF9GX?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638918973563302208\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Terra Firm Presentation</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:247de373-4d44-47dc-9f20-9a387561a30f\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638918973563302208\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">Logistics</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:2cf70c38-b089-4150-84a4-34e4c472c4e3\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/28/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#EDEBE9\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#323130\">Due in 1 day</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/-zqS58FZ9EeN-_dKGA6XEWUACFRQ/_wvQexctwkmV0W87MdUOV2UAIYct?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638918973563302208\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Submit your expenses</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:247de373-4d44-47dc-9f20-9a387561a30f\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/-zqS58FZ9EeN-_dKGA6XEWUACFRQ?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638918973563302208\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">Event Plan</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:2cf70c38-b089-4150-84a4-34e4c472c4e3\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/28/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#EDEBE9\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#323130\">Due in 1 day</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/oTP_zi2u9k2iHyfIXz4xY2UAFhM3/dc20HY1ewkmy1KmoSmH2EGUAAcTu?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638918973563302208\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Submit your expenses</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:247de373-4d44-47dc-9f20-9a387561a30f\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/oTP_zi2u9k2iHyfIXz4xY2UAFhM3?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638918973563302208\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">Event Plan</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:2cf70c38-b089-4150-84a4-34e4c472c4e3\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/28/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#EDEBE9\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#323130\">Due in 1 day</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:6px 24px; text-align:center\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/MyTasks?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638918973563302208\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; text-decoration:none; color:#106EBE\">View all 6 upcoming tasks</a></td></tr></tbody></table></td></tr><tr><td style=\"padding:20px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td align=\"center\" style=\"padding:6px 20px 6px 20px; border:1px solid #E1DFDD; border-radius:4px; background-color:#5B5FC7; box-shadow:0px 0px 4px rgba(0,0,0,0.09)\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/MyTasks?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638918973563302208\" target=\"_blank\"><strong style=\"display:inline-block; font-weight:600; font-size:14px; font-family:&quot;Segoe UI&quot;,sans-serif; line-height:20px; color:#ffffff; text-decoration:none\">Open in Browser </strong></a></td></tr></tbody></table></td><td style=\"padding-left:10px; padding-right:10px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td align=\"center\" style=\"padding:6px 20px 6px 20px; border:1px solid #E1DFDD; border-radius:4px; background-color:#ffffff; box-shadow:0px 0px 4px rgba(0,0,0,0.09)\"><a href=\"https://teams.microsoft.com/l/entity/com.microsoft.teamspace.tab.planner/mytasks?tenantId=dd172b04-e4e2-4084-885c-47c9cc57f059&amp;webUrl=https%3a%2f%2ftasks.teams.microsoft.com%2fteamsui%2fpersonalApp%2falltasklists&amp;context=%7b%22subEntityId%22%3a%22%2fv1%2fassignedtome%3fnc%3demail%26nt%3dduedate%22%7d\" target=\"_blank\"><strong style=\"display:inline-block; font-weight:600; font-size:14px; font-family:&quot;Segoe UI&quot;,sans-serif; line-height:20px; color:#252424; text-decoration:none\">Open in Teams </strong></a></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td align=\"left\" style=\"padding:0px; margin:0px\"><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" align=\"center\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td align=\"left\" style=\"font-size:12px; line-height:16px; padding:20px 32px\"><div><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"font-family:'Segoe UI',SUWR,Verdana,sans-serif; font-size:10px; line-height:20px; color:#6b6b6b; padding:6px 0; letter-spacing:-0.01em\">You are receiving this email because you have subscribed to Microsoft Office 365. </td></tr><tr><td style=\"font-family:'Segoe UI',SUWR,Verdana,sans-serif; font-size:10px; line-height:20px; color:#6b6b6b; padding:6px 0; letter-spacing:-0.01em\">Notification settings: Go to <a href=\"https://tasks.office.com/\" target=\"_blank\" style=\"color:#6b6b6c; text-decoration:underline\">Planner</a>, select the gear icon, then select &quot;Notifications&quot;. </td></tr><tr><td align=\"left\" style=\"padding-top:12px; text-align:left; padding-bottom:12px\"><hr></td></tr><tr><td align=\"left\" style=\"padding-top:12px; text-align:left; padding-bottom:12px\"><img src=\"cid:6f3e7fdb-022d-4d6e-8319-fd0a27201bc4\" alt=\"\" title=\"\" height=\"22\" width=\"90\" style=\"margin:0px; height:22px; width:90px\"> </td></tr><tr><td align=\"left\" style=\"padding-top:12px; text-align:left; padding-bottom:12px\"><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td align=\"left\" style=\"padding:0 4px 0 0; white-space:nowrap\"><p style=\"padding:0px; margin:0px; font-family:'Segoe UI',SUWR,Verdana,sans-serif; font-size:12px; line-height:20px; color:#6b6b6c; letter-spacing:-0.01em\"><a href=\"https://go.microsoft.com/fwlink/?LinkId=521839\" target=\"_blank\" title=\"\" style=\"padding:0px; margin:0px; font-family:'Segoe UI',SUWR,Verdana,sans-serif; font-size:12px; line-height:20px; color:#6b6b6c; letter-spacing:-0.01em\">Privacy&nbsp;Statement</a> </p></td></tr></tbody></table></td></tr><tr><td align=\"left\" style=\"padding-top:12px; text-align:left; padding-bottom:12px\"><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td align=\"left\"><p style=\"margin:0px; font-family:'Segoe UI',SUWR,Verdana,sans-serif; font-size:12px; line-height:20px; color:#6b6b6c; letter-spacing:-0.01em\">This email is generated through Contoso's use of Microsoft 365 and may contain content that is controlled by Contoso.</p></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></div></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></div><img src=\"https://southcentralusr-notifyp.svc.ms:443/api/v2/tracking/method/View?mi=kDKb9fwzMkiKol-ai0IICg\" aria-hidden=\"true\" role=\"presentation\" height=\"1\" width=\"1\"></body></html>"
            },
            "sender": {
                "emailAddress": {
                    "name": "Microsoft on behalf of your organization",
                    "address": "noreply@planner.office365.com"
                }
            },
            "from": {
                "emailAddress": {
                    "name": "Microsoft on behalf of your organization",
                    "address": "noreply@planner.office365.com"
                }
            },
            "toRecipients": [
                {
                    "emailAddress": {
                        "name": "Adele Vance",
                        "address": "AdeleV@M365x63639251.OnMicrosoft.com"
                    }
                }
            ],
            "ccRecipients": [],
            "bccRecipients": [],
            "replyTo": [],
            "flag": {
                "flagStatus": "notFlagged"
            }
        },
        {
            "@odata.etag": "W/\"CQAAABYAAADUwywT0x3WRJXfefGC8Xz/AAA1S/xZ\"",
            "id": "AAMkADY1YmE3N2FhLWEwMzQtNDNkMC04Mzg3LTczMTdiMjk2NzRhMABGAAAAAADfsy0XtCMZS5XonZkyBLu6BwDUwywT0x3WRJXfefGC8Xz-AAAAAAEMAADUwywT0x3WRJXfefGC8Xz-AAA1XZteAAA=",
            "createdDateTime": "2025-08-25T16:35:25Z",
            "lastModifiedDateTime": "2025-08-25T16:45:21Z",
            "changeKey": "CQAAABYAAADUwywT0x3WRJXfefGC8Xz/AAA1S/xZ",
            "categories": [],
            "receivedDateTime": "2025-08-25T16:35:26Z",
            "sentDateTime": "2025-08-25T16:35:17Z",
            "hasAttachments": False,
            "internetMessageId": "<PlannerDueDate-2b51efc7-3441-4174-a264-376a8bdc18b9-e95d54e8-ca97-4d84-b10c-0d1a8379df75-r0-SendEmail-rh_cac-aid_b35da446-7e3f-46c6-ba34-c534fa24c1bf@odspnotify>",
            "subject": "You have late tasks",
            "bodyPreview": "Hi Adele. You have 10 tasks due.\r\n        You have late tasks\r\nOrder Patti Smoothie Stuff\r\nIn the plan  PattiF Logistics\r\n8/21/2025\r\n4 days late\r\nStockReport AM\r\nIn the plan  PattiF Logistics\r\n8/24/2025\r\n1 day late\r\nOrder Patti Smoothie Stuff\r\nIn the plan",
            "importance": "normal",
            "parentFolderId": "AAMkADY1YmE3N2FhLWEwMzQtNDNkMC04Mzg3LTczMTdiMjk2NzRhMAAuAAAAAADfsy0XtCMZS5XonZkyBLu6AQDUwywT0x3WRJXfefGC8Xz-AAAAAAEMAAA=",
            "conversationId": "AAQkADY1YmE3N2FhLWEwMzQtNDNkMC04Mzg3LTczMTdiMjk2NzRhMAAQANMoJMqXoWFHoAMAFQC77jw=",
            "conversationIndex": "AQHcFd5C0ygkypehYUegAwAVALvuPA==",
            "isDeliveryReceiptRequested": None,
            "isReadReceiptRequested": False,
            "isRead": False,
            "isDraft": False,
            "webLink": "https://outlook.office365.com/owa/?ItemID=AAMkADY1YmE3N2FhLWEwMzQtNDNkMC04Mzg3LTczMTdiMjk2NzRhMABGAAAAAADfsy0XtCMZS5XonZkyBLu6BwDUwywT0x3WRJXfefGC8Xz%2FAAAAAAEMAADUwywT0x3WRJXfefGC8Xz%2FAAA1XZteAAA%3D&exvsurl=1&viewmodel=ReadMessageItem",
            "inferenceClassification": "focused",
            "body": {
                "contentType": "html",
                "content": "<html dir=\"ltr\" lang=\"en-us\"><head>\r\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"><style type=\"text/css\">\r\n<!--\r\n.headerBackgroundMsoTable\r\n\t{border-spacing:0px;\r\n\twidth:100%}\r\n-->\r\n</style></head><body style=\"margin:0px\"><div><table height=\"100%\" width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px\"><tbody><tr><td valign=\"top\" align=\"center\"><table align=\"center\" style=\"border-spacing:0px; width:100%!important; margin-right:auto; margin-left:auto; margin:0 auto; max-width:640px; font-family:'Segoe UI'; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td align=\"left\" style=\"padding:0px; margin:0px\"><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td align=\"center\"><div><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td colspan=\"1\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%\"><tbody><tr><td style=\"padding:32px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:20px; color:#242424\">Hi Adele. You have 10 tasks due. </span></td></tr></tbody></table></td></tr></tbody></table></div></td></tr></tbody></table></td></tr><tr><td align=\"left\" style=\"padding:0px; margin:0px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; border-top:1px solid #E1DFDD; border-bottom:1px solid #E1DFDD; border-top:1px solid rgba(128,128,128,0.25); border-bottom:1px solid rgba(128,128,128,0.25)\"><tbody><tr><td style=\"padding:12px 32px 4px; background-color:#FAFAFA\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%\"><tbody><tr><td style=\"padding:11px 0 3px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%\"><tbody><tr><td style=\"width:35px\"><img src=\"cid:5e43d7c4-90fb-4133-9ba0-a2ddf5e58af8\" alt=\"Calendar Late\" width=\"30\" height=\"30\" border=\"0\" style=\"display:block; outline:none; border:none\"> </td><td><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:14px; color:#1B1A19\">You have <b>late</b> tasks </span></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/vTzrU8ilDEe2WnZp3wobLGUAEek-/B3HAH6m0UU6UgIREFNISfWUAK19q?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638917365155872045\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Order Patti Smoothie Stuff</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:bd8dc5d1-e481-4033-a15c-b51ca9d3d6a1\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/vTzrU8ilDEe2WnZp3wobLGUAEek-?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638917365155872045\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">PattiF Logistics</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:d94ecdad-10b1-4574-b94e-0c3b4997b40a\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/21/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#FED9CC\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#A80000\">4 days late</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/vTzrU8ilDEe2WnZp3wobLGUAEek-/Q16nIEnVI0a4lTZZ79wa32UAAu7z?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638917365155872045\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">StockReport AM</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:bd8dc5d1-e481-4033-a15c-b51ca9d3d6a1\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/vTzrU8ilDEe2WnZp3wobLGUAEek-?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638917365155872045\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">PattiF Logistics</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:d94ecdad-10b1-4574-b94e-0c3b4997b40a\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/24/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#FED9CC\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#A80000\">1 day late</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt/bbdxY3fGVEKZxL-HYK35YGUACWL9?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638917365155872045\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Order Patti Smoothie Stuff</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:bd8dc5d1-e481-4033-a15c-b51ca9d3d6a1\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638917365155872045\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">Logistics</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:d94ecdad-10b1-4574-b94e-0c3b4997b40a\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/21/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#FED9CC\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#A80000\">4 days late</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt/rZ3tUfiphUS5NMB8HoeKz2UAMaev?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638917365155872045\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">StockReport AM</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:bd8dc5d1-e481-4033-a15c-b51ca9d3d6a1\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638917365155872045\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">Logistics</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:d94ecdad-10b1-4574-b94e-0c3b4997b40a\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/24/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#FED9CC\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#A80000\">1 day late</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:11px 0 3px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%\"><tbody><tr><td style=\"width:35px\"><img src=\"cid:7c37bc37-7c40-4109-abd8-91a5d5b7b2f0\" alt=\"Calendar Late\" width=\"30\" height=\"30\" border=\"0\" style=\"display:block; outline:none; border:none\"> </td><td><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:14px; color:#1B1A19\">You have <b>upcoming</b> tasks </span></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt/DJdyzE93q0qIFCCXvHPucWUAAH4x?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638917365155872045\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Tailspin CEO</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:bd8dc5d1-e481-4033-a15c-b51ca9d3d6a1\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638917365155872045\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">Logistics</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:d94ecdad-10b1-4574-b94e-0c3b4997b40a\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/29/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#EDEBE9\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#323130\">Due in 4 days</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/vTzrU8ilDEe2WnZp3wobLGUAEek-/HZ5tnG374U26YV32Le5rS2UAIevZ?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638917365155872045\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Terra Firm Presentation</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:bd8dc5d1-e481-4033-a15c-b51ca9d3d6a1\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/vTzrU8ilDEe2WnZp3wobLGUAEek-?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638917365155872045\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">PattiF Logistics</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:d94ecdad-10b1-4574-b94e-0c3b4997b40a\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/28/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#EDEBE9\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#323130\">Due in 3 days</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt/LAl8pGDDbEu7LZ5fvs3ABGUAF9GX?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638917365155872045\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Terra Firm Presentation</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:bd8dc5d1-e481-4033-a15c-b51ca9d3d6a1\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638917365155872045\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">Logistics</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:d94ecdad-10b1-4574-b94e-0c3b4997b40a\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/28/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#EDEBE9\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#323130\">Due in 3 days</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/-zqS58FZ9EeN-_dKGA6XEWUACFRQ/_wvQexctwkmV0W87MdUOV2UAIYct?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638917365155872045\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Submit your expenses</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:bd8dc5d1-e481-4033-a15c-b51ca9d3d6a1\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/-zqS58FZ9EeN-_dKGA6XEWUACFRQ?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638917365155872045\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">Event Plan</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:d94ecdad-10b1-4574-b94e-0c3b4997b40a\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/28/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#EDEBE9\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#323130\">Due in 3 days</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/oTP_zi2u9k2iHyfIXz4xY2UAFhM3/dc20HY1ewkmy1KmoSmH2EGUAAcTu?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638917365155872045\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Submit your expenses</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:bd8dc5d1-e481-4033-a15c-b51ca9d3d6a1\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/oTP_zi2u9k2iHyfIXz4xY2UAFhM3?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638917365155872045\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">Event Plan</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:d94ecdad-10b1-4574-b94e-0c3b4997b40a\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/28/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#EDEBE9\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#323130\">Due in 3 days</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:6px 24px; text-align:center\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/MyTasks?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638917365155872045\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; text-decoration:none; color:#106EBE\">View all 6 upcoming tasks</a></td></tr></tbody></table></td></tr><tr><td style=\"padding:20px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td align=\"center\" style=\"padding:6px 20px 6px 20px; border:1px solid #E1DFDD; border-radius:4px; background-color:#5B5FC7; box-shadow:0px 0px 4px rgba(0,0,0,0.09)\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/MyTasks?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638917365155872045\" target=\"_blank\"><strong style=\"display:inline-block; font-weight:600; font-size:14px; font-family:&quot;Segoe UI&quot;,sans-serif; line-height:20px; color:#ffffff; text-decoration:none\">Open in Browser </strong></a></td></tr></tbody></table></td><td style=\"padding-left:10px; padding-right:10px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td align=\"center\" style=\"padding:6px 20px 6px 20px; border:1px solid #E1DFDD; border-radius:4px; background-color:#ffffff; box-shadow:0px 0px 4px rgba(0,0,0,0.09)\"><a href=\"https://teams.microsoft.com/l/entity/com.microsoft.teamspace.tab.planner/mytasks?tenantId=dd172b04-e4e2-4084-885c-47c9cc57f059&amp;webUrl=https%3a%2f%2ftasks.teams.microsoft.com%2fteamsui%2fpersonalApp%2falltasklists&amp;context=%7b%22subEntityId%22%3a%22%2fv1%2fassignedtome%3fnc%3demail%26nt%3dduedate%22%7d\" target=\"_blank\"><strong style=\"display:inline-block; font-weight:600; font-size:14px; font-family:&quot;Segoe UI&quot;,sans-serif; line-height:20px; color:#252424; text-decoration:none\">Open in Teams </strong></a></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td align=\"left\" style=\"padding:0px; margin:0px\"><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" align=\"center\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td align=\"left\" style=\"font-size:12px; line-height:16px; padding:20px 32px\"><div><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"font-family:'Segoe UI',SUWR,Verdana,sans-serif; font-size:10px; line-height:20px; color:#6b6b6b; padding:6px 0; letter-spacing:-0.01em\">You are receiving this email because you have subscribed to Microsoft Office 365. </td></tr><tr><td style=\"font-family:'Segoe UI',SUWR,Verdana,sans-serif; font-size:10px; line-height:20px; color:#6b6b6b; padding:6px 0; letter-spacing:-0.01em\">Notification settings: Go to <a href=\"https://tasks.office.com/\" target=\"_blank\" style=\"color:#6b6b6c; text-decoration:underline\">Planner</a>, select the gear icon, then select &quot;Notifications&quot;. </td></tr><tr><td align=\"left\" style=\"padding-top:12px; text-align:left; padding-bottom:12px\"><hr></td></tr><tr><td align=\"left\" style=\"padding-top:12px; text-align:left; padding-bottom:12px\"><img src=\"cid:2f3466ba-50dc-48fd-a599-8ef2a21604b5\" alt=\"\" title=\"\" height=\"22\" width=\"90\" style=\"margin:0px; height:22px; width:90px\"> </td></tr><tr><td align=\"left\" style=\"padding-top:12px; text-align:left; padding-bottom:12px\"><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td align=\"left\" style=\"padding:0 4px 0 0; white-space:nowrap\"><p style=\"padding:0px; margin:0px; font-family:'Segoe UI',SUWR,Verdana,sans-serif; font-size:12px; line-height:20px; color:#6b6b6c; letter-spacing:-0.01em\"><a href=\"https://go.microsoft.com/fwlink/?LinkId=521839\" target=\"_blank\" title=\"\" style=\"padding:0px; margin:0px; font-family:'Segoe UI',SUWR,Verdana,sans-serif; font-size:12px; line-height:20px; color:#6b6b6c; letter-spacing:-0.01em\">Privacy&nbsp;Statement</a> </p></td></tr></tbody></table></td></tr><tr><td align=\"left\" style=\"padding-top:12px; text-align:left; padding-bottom:12px\"><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td align=\"left\"><p style=\"margin:0px; font-family:'Segoe UI',SUWR,Verdana,sans-serif; font-size:12px; line-height:20px; color:#6b6b6c; letter-spacing:-0.01em\">This email is generated through Contoso's use of Microsoft 365 and may contain content that is controlled by Contoso.</p></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></div></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></div><img src=\"https://southcentralusr-notifyp.svc.ms:443/api/v2/tracking/method/View?mi=0iO3OPQ2Qk2nBUHaYmpZmg\" aria-hidden=\"true\" role=\"presentation\" height=\"1\" width=\"1\"></body></html>"
            },
            "sender": {
                "emailAddress": {
                    "name": "Microsoft on behalf of your organization",
                    "address": "noreply@planner.office365.com"
                }
            },
            "from": {
                "emailAddress": {
                    "name": "Microsoft on behalf of your organization",
                    "address": "noreply@planner.office365.com"
                }
            },
            "toRecipients": [
                {
                    "emailAddress": {
                        "name": "Adele Vance",
                        "address": "AdeleV@M365x63639251.OnMicrosoft.com"
                    }
                }
            ],
            "ccRecipients": [],
            "bccRecipients": [],
            "replyTo": [],
            "flag": {
                "flagStatus": "notFlagged"
            }
        },
        {
            "@odata.etag": "W/\"CQAAABYAAADUwywT0x3WRJXfefGC8Xz/AAA1S8uk\"",
            "id": "AAMkADY1YmE3N2FhLWEwMzQtNDNkMC04Mzg3LTczMTdiMjk2NzRhMABGAAAAAADfsy0XtCMZS5XonZkyBLu6BwDUwywT0x3WRJXfefGC8Xz-AAAAAAEMAADUwywT0x3WRJXfefGC8Xz-AAA1XZtdAAA=",
            "createdDateTime": "2025-08-24T16:35:22Z",
            "lastModifiedDateTime": "2025-08-24T16:35:27Z",
            "changeKey": "CQAAABYAAADUwywT0x3WRJXfefGC8Xz/AAA1S8uk",
            "categories": [],
            "receivedDateTime": "2025-08-24T16:35:23Z",
            "sentDateTime": "2025-08-24T16:35:15Z",
            "hasAttachments": False,
            "internetMessageId": "<PlannerDueDate-d6c5903c-3336-4e0a-97bf-5e33f0bfe2a1-0e3c1c06-f565-4e32-828c-848be127100b-r0-SendEmail-rh_cac-aid_0fdf6883-a3cf-4559-a0e5-9fd8ea07f651@odspnotify>",
            "subject": "You have late tasks",
            "bodyPreview": "Hi Adele. You have 10 tasks due.\r\n        You have late tasks\r\nOrder Patti Smoothie Stuff\r\nIn the plan  PattiF Logistics\r\n8/21/2025\r\n3 days late\r\nOrder Patti Smoothie Stuff\r\nIn the plan  Logistics\r\n8/21/2025\r\n3 days late\r\n        You have tasks due today",
            "importance": "normal",
            "parentFolderId": "AAMkADY1YmE3N2FhLWEwMzQtNDNkMC04Mzg3LTczMTdiMjk2NzRhMAAuAAAAAADfsy0XtCMZS5XonZkyBLu6AQDUwywT0x3WRJXfefGC8Xz-AAAAAAEMAAA=",
            "conversationId": "AAQkADY1YmE3N2FhLWEwMzQtNDNkMC04Mzg3LTczMTdiMjk2NzRhMAAQAOPcKbxFRRtNk-eRIdkYPCk=",
            "conversationIndex": "AQHcFRUW49wpvEVFG02T95Eh2Rg8KQ==",
            "isDeliveryReceiptRequested": None,
            "isReadReceiptRequested": False,
            "isRead": False,
            "isDraft": False,
            "webLink": "https://outlook.office365.com/owa/?ItemID=AAMkADY1YmE3N2FhLWEwMzQtNDNkMC04Mzg3LTczMTdiMjk2NzRhMABGAAAAAADfsy0XtCMZS5XonZkyBLu6BwDUwywT0x3WRJXfefGC8Xz%2FAAAAAAEMAADUwywT0x3WRJXfefGC8Xz%2FAAA1XZtdAAA%3D&exvsurl=1&viewmodel=ReadMessageItem",
            "inferenceClassification": "focused",
            "body": {
                "contentType": "html",
                "content": "<html dir=\"ltr\" lang=\"en-us\"><head>\r\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"><style type=\"text/css\">\r\n<!--\r\n.headerBackgroundMsoTable\r\n\t{border-spacing:0px;\r\n\twidth:100%}\r\n-->\r\n</style></head><body style=\"margin:0px\"><div><table height=\"100%\" width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px\"><tbody><tr><td valign=\"top\" align=\"center\"><table align=\"center\" style=\"border-spacing:0px; width:100%!important; margin-right:auto; margin-left:auto; margin:0 auto; max-width:640px; font-family:'Segoe UI'; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td align=\"left\" style=\"padding:0px; margin:0px\"><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td align=\"center\"><div><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td colspan=\"1\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%\"><tbody><tr><td style=\"padding:32px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:20px; color:#242424\">Hi Adele. You have 10 tasks due. </span></td></tr></tbody></table></td></tr></tbody></table></div></td></tr></tbody></table></td></tr><tr><td align=\"left\" style=\"padding:0px; margin:0px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; border-top:1px solid #E1DFDD; border-bottom:1px solid #E1DFDD; border-top:1px solid rgba(128,128,128,0.25); border-bottom:1px solid rgba(128,128,128,0.25)\"><tbody><tr><td style=\"padding:12px 32px 4px; background-color:#FAFAFA\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%\"><tbody><tr><td style=\"padding:11px 0 3px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%\"><tbody><tr><td style=\"width:35px\"><img src=\"cid:b4d53331-21e5-4d54-a923-a1a4958d6a6e\" alt=\"Calendar Late\" width=\"30\" height=\"30\" border=\"0\" style=\"display:block; outline:none; border:none\"> </td><td><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:14px; color:#1B1A19\">You have <b>late</b> tasks </span></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/vTzrU8ilDEe2WnZp3wobLGUAEek-/B3HAH6m0UU6UgIREFNISfWUAK19q?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638916501140188210\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Order Patti Smoothie Stuff</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:a56b32a1-2039-4c32-938b-d41183368958\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/vTzrU8ilDEe2WnZp3wobLGUAEek-?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638916501140188210\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">PattiF Logistics</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:8c85de84-9b2d-4e51-96e4-976574173add\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/21/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#FED9CC\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#A80000\">3 days late</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt/bbdxY3fGVEKZxL-HYK35YGUACWL9?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638916501140188210\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Order Patti Smoothie Stuff</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:a56b32a1-2039-4c32-938b-d41183368958\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638916501140188210\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">Logistics</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:8c85de84-9b2d-4e51-96e4-976574173add\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/21/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#FED9CC\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#A80000\">3 days late</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:11px 0 3px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%\"><tbody><tr><td style=\"width:35px\"><img src=\"cid:26a2806c-bdd8-4360-8e65-d6280089b38e\" alt=\"Calendar Late\" width=\"30\" height=\"30\" border=\"0\" style=\"display:block; outline:none; border:none\"> </td><td><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:14px; color:#1B1A19\">You have tasks <b>due today</b> </span></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/vTzrU8ilDEe2WnZp3wobLGUAEek-/Q16nIEnVI0a4lTZZ79wa32UAAu7z?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638916501140188210\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">StockReport AM</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:a56b32a1-2039-4c32-938b-d41183368958\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/vTzrU8ilDEe2WnZp3wobLGUAEek-?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638916501140188210\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">PattiF Logistics</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:8c85de84-9b2d-4e51-96e4-976574173add\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/24/2025</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt/rZ3tUfiphUS5NMB8HoeKz2UAMaev?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638916501140188210\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">StockReport AM</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:a56b32a1-2039-4c32-938b-d41183368958\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638916501140188210\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">Logistics</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:8c85de84-9b2d-4e51-96e4-976574173add\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/24/2025</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:11px 0 3px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%\"><tbody><tr><td style=\"width:35px\"><img src=\"cid:231c93b6-1a1d-4e77-8ff8-ba51267b043e\" alt=\"Calendar Late\" width=\"30\" height=\"30\" border=\"0\" style=\"display:block; outline:none; border:none\"> </td><td><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:14px; color:#1B1A19\">You have <b>upcoming</b> tasks </span></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt/DJdyzE93q0qIFCCXvHPucWUAAH4x?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638916501140188210\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Tailspin CEO</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:a56b32a1-2039-4c32-938b-d41183368958\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638916501140188210\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">Logistics</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:8c85de84-9b2d-4e51-96e4-976574173add\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/29/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#EDEBE9\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#323130\">Due in 5 days</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/vTzrU8ilDEe2WnZp3wobLGUAEek-/HZ5tnG374U26YV32Le5rS2UAIevZ?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638916501140188210\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Terra Firm Presentation</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:a56b32a1-2039-4c32-938b-d41183368958\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/vTzrU8ilDEe2WnZp3wobLGUAEek-?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638916501140188210\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">PattiF Logistics</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:8c85de84-9b2d-4e51-96e4-976574173add\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/28/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#EDEBE9\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#323130\">Due in 4 days</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt/LAl8pGDDbEu7LZ5fvs3ABGUAF9GX?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638916501140188210\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Terra Firm Presentation</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:a56b32a1-2039-4c32-938b-d41183368958\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/b6hxKqWKRUu3hFkrHFHtN2UABAqt?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638916501140188210\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">Logistics</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:8c85de84-9b2d-4e51-96e4-976574173add\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/28/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#EDEBE9\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#323130\">Due in 4 days</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/-zqS58FZ9EeN-_dKGA6XEWUACFRQ/_wvQexctwkmV0W87MdUOV2UAIYct?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638916501140188210\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Submit your expenses</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:a56b32a1-2039-4c32-938b-d41183368958\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/-zqS58FZ9EeN-_dKGA6XEWUACFRQ?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638916501140188210\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">Event Plan</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:8c85de84-9b2d-4e51-96e4-976574173add\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/28/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#EDEBE9\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#323130\">Due in 4 days</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:12px 24px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"padding:4px 0\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/oTP_zi2u9k2iHyfIXz4xY2UAFhM3/dc20HY1ewkmy1KmoSmH2EGUAAcTu?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638916501140188210\" data-loopstyle=\"{'link'}\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; line-height:20px; color:#1B1A19; text-decoration:underline\">Submit your expenses</a></td></tr><tr><td style=\"padding:4px 0\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#605E5C\">In the plan <span style=\"\"><img src=\"cid:a56b32a1-2039-4c32-938b-d41183368958\" alt=\"Planner\" width=\"20\" height=\"20\" border=\"0\" style=\"display:inline-block; vertical-align:bottom; border:none\"></span> <a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/PlanViews/oTP_zi2u9k2iHyfIXz4xY2UAFhM3?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638916501140188210\" data-loopstyle=\"{'link'}\" style=\"color:#1B1A19; text-decoration:underline\">Event Plan</a></span></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><img src=\"cid:8c85de84-9b2d-4e51-96e4-976574173add\" alt=\"Calendar\" width=\"16\" height=\"16\" border=\"0\" style=\"display:block; outline:none; border:none\"></td><td style=\"padding:0 4px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#1B1A19\">8/28/2025</span></td><td style=\"padding:0 8px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-radius:12px; background-color:#EDEBE9\"><tbody><tr><td style=\"padding:0 10px\"><span style=\"font-family:'Segoe UI',sans-serif; font-weight:400; font-size:12px; line-height:20px; color:#323130\">Due in 4 days</span></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style=\"padding:4px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%; background-color:white; border:1px solid #E1DFDD; border:1px solid rgba(128,128,128,0.25); border-radius:4px\"><tbody><tr><td style=\"padding:6px 24px; text-align:center\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/MyTasks?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638916501140188210\" style=\"font-family:'Segoe UI',sans-serif; font-weight:600; font-size:14px; text-decoration:none; color:#106EBE\">View all 6 upcoming tasks</a></td></tr></tbody></table></td></tr><tr><td style=\"padding:20px 0\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td align=\"center\" style=\"padding:6px 20px 6px 20px; border:1px solid #E1DFDD; border-radius:4px; background-color:#5B5FC7; box-shadow:0px 0px 4px rgba(0,0,0,0.09)\"><a href=\"https://planner.cloud.microsoft/M365x63639251.onmicrosoft.com/en-US/Home/MyTasks?Type=DueDate&amp;Channel=OdspNotify&amp;CreatedTime=638916501140188210\" target=\"_blank\"><strong style=\"display:inline-block; font-weight:600; font-size:14px; font-family:&quot;Segoe UI&quot;,sans-serif; line-height:20px; color:#ffffff; text-decoration:none\">Open in Browser </strong></a></td></tr></tbody></table></td><td style=\"padding-left:10px; padding-right:10px\"><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td align=\"center\" style=\"padding:6px 20px 6px 20px; border:1px solid #E1DFDD; border-radius:4px; background-color:#ffffff; box-shadow:0px 0px 4px rgba(0,0,0,0.09)\"><a href=\"https://teams.microsoft.com/l/entity/com.microsoft.teamspace.tab.planner/mytasks?tenantId=dd172b04-e4e2-4084-885c-47c9cc57f059&amp;webUrl=https%3a%2f%2ftasks.teams.microsoft.com%2fteamsui%2fpersonalApp%2falltasklists&amp;context=%7b%22subEntityId%22%3a%22%2fv1%2fassignedtome%3fnc%3demail%26nt%3dduedate%22%7d\" target=\"_blank\"><strong style=\"display:inline-block; font-weight:600; font-size:14px; font-family:&quot;Segoe UI&quot;,sans-serif; line-height:20px; color:#252424; text-decoration:none\">Open in Teams </strong></a></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td align=\"left\" style=\"padding:0px; margin:0px\"><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" align=\"center\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td align=\"left\" style=\"font-size:12px; line-height:16px; padding:20px 32px\"><div><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td><table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td style=\"font-family:'Segoe UI',SUWR,Verdana,sans-serif; font-size:10px; line-height:20px; color:#6b6b6b; padding:6px 0; letter-spacing:-0.01em\">You are receiving this email because you have subscribed to Microsoft Office 365. </td></tr><tr><td style=\"font-family:'Segoe UI',SUWR,Verdana,sans-serif; font-size:10px; line-height:20px; color:#6b6b6b; padding:6px 0; letter-spacing:-0.01em\">Notification settings: Go to <a href=\"https://tasks.office.com/\" target=\"_blank\" style=\"color:#6b6b6c; text-decoration:underline\">Planner</a>, select the gear icon, then select &quot;Notifications&quot;. </td></tr><tr><td align=\"left\" style=\"padding-top:12px; text-align:left; padding-bottom:12px\"><hr></td></tr><tr><td align=\"left\" style=\"padding-top:12px; text-align:left; padding-bottom:12px\"><img src=\"cid:bc91db93-342b-4af0-abab-b01fb9276546\" alt=\"\" title=\"\" height=\"22\" width=\"90\" style=\"margin:0px; height:22px; width:90px\"> </td></tr><tr><td align=\"left\" style=\"padding-top:12px; text-align:left; padding-bottom:12px\"><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td align=\"left\" style=\"padding:0 4px 0 0; white-space:nowrap\"><p style=\"padding:0px; margin:0px; font-family:'Segoe UI',SUWR,Verdana,sans-serif; font-size:12px; line-height:20px; color:#6b6b6c; letter-spacing:-0.01em\"><a href=\"https://go.microsoft.com/fwlink/?LinkId=521839\" target=\"_blank\" title=\"\" style=\"padding:0px; margin:0px; font-family:'Segoe UI',SUWR,Verdana,sans-serif; font-size:12px; line-height:20px; color:#6b6b6c; letter-spacing:-0.01em\">Privacy&nbsp;Statement</a> </p></td></tr></tbody></table></td></tr><tr><td align=\"left\" style=\"padding-top:12px; text-align:left; padding-bottom:12px\"><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"border-spacing:0px; width:100%\"><tbody><tr><td align=\"left\"><p style=\"margin:0px; font-family:'Segoe UI',SUWR,Verdana,sans-serif; font-size:12px; line-height:20px; color:#6b6b6c; letter-spacing:-0.01em\">This email is generated through Contoso's use of Microsoft 365 and may contain content that is controlled by Contoso.</p></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></div></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></div><img src=\"https://southcentralusr-notifyp.svc.ms:443/api/v2/tracking/method/View?mi=gd6f-X4fQkSvnXYeuOEXZQ\" aria-hidden=\"true\" role=\"presentation\" height=\"1\" width=\"1\"></body></html>"
            },
            "sender": {
                "emailAddress": {
                    "name": "Microsoft on behalf of your organization",
                    "address": "noreply@planner.office365.com"
                }
            },
            "from": {
                "emailAddress": {
                    "name": "Microsoft on behalf of your organization",
                    "address": "noreply@planner.office365.com"
                }
            },
            "toRecipients": [
                {
                    "emailAddress": {
                        "name": "Adele Vance",
                        "address": "AdeleV@M365x63639251.OnMicrosoft.com"
                    }
                }
            ],
            "ccRecipients": [],
            "bccRecipients": [],
            "replyTo": [],
            "flag": {
                "flagStatus": "notFlagged"
            }
        }
    ],
    "@odata.nextLink": "https://graph.microsoft.com/v1.0/me/messages?%24top=10&%24skip=10"
}

@pytest.fixture
def mock_email_correct():
    return MOCK_EMAILS

@pytest.fixture
def mock_email_incorrect():
    return [
        "foobar",
        [
            "foobar"
        ]
    ]

@pytest.fixture
def mock_email_half_correct():
    return [
        "foobar",
        [
            "foobar"
        ],
        {"foobar": "foobar"}
    ]

