/*
 * Copyright (c) 2024. Helge Eichhorn and the LOX contributors
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, you can obtain one at https://mozilla.org/MPL/2.0/.
 */

// Auto-generated by `lox-gen`. Do not edit!

use crate::DynOrigin;
use crate::Elements;
use crate::MeanRadius;
use crate::NaifId;
use crate::Origin;
use crate::PointMass;
use crate::Radii;
use crate::RotationalElement;
use crate::RotationalElementType;
use crate::RotationalElements;
use crate::Spheroid;
use crate::TriaxialEllipsoid;
use crate::TryMeanRadius;
use crate::TryPointMass;
use crate::TryRotationalElements;
use crate::TrySpheroid;
use crate::TryTriaxialEllipsoid;
use crate::UndefinedOriginPropertyError;
use std::fmt::Display;
use std::fmt::Formatter;
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Sun;
impl Origin for Sun {
    fn id(&self) -> NaifId {
        NaifId(10i32)
    }
    fn name(&self) -> &'static str {
        "Sun"
    }
}
impl Display for Sun {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Sun {
    fn gravitational_parameter(&self) -> f64 {
        132712440041.27942f64
    }
}
impl TriaxialEllipsoid for Sun {
    fn radii(&self) -> Radii {
        (695700f64, 695700f64, 695700f64)
    }
}
impl Spheroid for Sun {}
const RIGHT_ASCENSION_SUN: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 4.993910588731375f64,
    c1: 0f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const DECLINATION_SUN: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: 1.1147417932487782f64,
    c1: 0f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const ROTATION_SUN: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 1.4691483511587469f64,
    c1: 0.24756448241988369f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
impl RotationalElements for Sun {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_SUN.angle(t),
            DECLINATION_SUN.angle(t),
            ROTATION_SUN.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_SUN.angle_dot(t),
            DECLINATION_SUN.angle_dot(t),
            ROTATION_SUN.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Mercury;
impl Origin for Mercury {
    fn id(&self) -> NaifId {
        NaifId(199i32)
    }
    fn name(&self) -> &'static str {
        "Mercury"
    }
}
impl Display for Mercury {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Mercury {
    fn gravitational_parameter(&self) -> f64 {
        22031.868551400003f64
    }
}
impl MeanRadius for Mercury {
    fn mean_radius(&self) -> f64 {
        2439.4f64
    }
}
impl TriaxialEllipsoid for Mercury {
    fn radii(&self) -> Radii {
        (2440.53f64, 2440.53f64, 2438.26f64)
    }
}
impl Spheroid for Mercury {}
const RIGHT_ASCENSION_MERCURY: RotationalElement<5usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 4.904554967017021f64,
    c1: -0.0005724679946541401f64,
    c2: 0f64,
    c: [0f64, 0f64, 0f64, 0f64, 0f64],
    theta0: [
        3.0506799486005773f64,
        6.101359897201155f64,
        2.868854538622146f64,
        5.919534488968053f64,
        2.6870291303890443f64,
    ],
    theta1: [
        2608.7878923240937f64,
        5217.575784648187f64,
        7826.363676972282f64,
        10435.151569296375f64,
        13043.939461620466f64,
    ],
};
const DECLINATION_MERCURY: RotationalElement<5usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: 1.0719026867585775f64,
    c1: -0.00008552113334772214f64,
    c2: 0f64,
    c: [0f64, 0f64, 0f64, 0f64, 0f64],
    theta0: [
        3.0506799486005773f64,
        6.101359897201155f64,
        2.868854538622146f64,
        5.919534488968053f64,
        2.6870291303890443f64,
    ],
    theta1: [
        2608.7878923240937f64,
        5217.575784648187f64,
        7826.363676972282f64,
        10435.151569296375f64,
        13043.939461620466f64,
    ],
};
const ROTATION_MERCURY: RotationalElement<5usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 5.752584270622286f64,
    c1: 0.10713722462923113f64,
    c2: 0f64,
    c: [
        0.0001862714861495712f64,
        -0.000019601618296223117f64,
        -0.00000192684349420174f64,
        -0.00000044313909708136026f64,
        -0.00000009965830028887623f64,
    ],
    theta0: [
        3.0506799486005773f64,
        6.101359897201155f64,
        2.868854538622146f64,
        5.919534488968053f64,
        2.6870291303890443f64,
    ],
    theta1: [
        2608.7878923240937f64,
        5217.575784648187f64,
        7826.363676972282f64,
        10435.151569296375f64,
        13043.939461620466f64,
    ],
};
impl RotationalElements for Mercury {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_MERCURY.angle(t),
            DECLINATION_MERCURY.angle(t),
            ROTATION_MERCURY.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_MERCURY.angle_dot(t),
            DECLINATION_MERCURY.angle_dot(t),
            ROTATION_MERCURY.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Venus;
impl Origin for Venus {
    fn id(&self) -> NaifId {
        NaifId(299i32)
    }
    fn name(&self) -> &'static str {
        "Venus"
    }
}
impl Display for Venus {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Venus {
    fn gravitational_parameter(&self) -> f64 {
        324858.592f64
    }
}
impl MeanRadius for Venus {
    fn mean_radius(&self) -> f64 {
        6051.8f64
    }
}
impl TriaxialEllipsoid for Venus {
    fn radii(&self) -> Radii {
        (6051.8f64, 6051.8f64, 6051.8f64)
    }
}
impl Spheroid for Venus {}
const RIGHT_ASCENSION_VENUS: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 4.760560067739733f64,
    c1: 0f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const DECLINATION_VENUS: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: 1.1721631256393916f64,
    c1: 0f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const ROTATION_VENUS: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 2.7960174616949156f64,
    c1: -0.025854762996317376f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
impl RotationalElements for Venus {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_VENUS.angle(t),
            DECLINATION_VENUS.angle(t),
            ROTATION_VENUS.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_VENUS.angle_dot(t),
            DECLINATION_VENUS.angle_dot(t),
            ROTATION_VENUS.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Earth;
impl Origin for Earth {
    fn id(&self) -> NaifId {
        NaifId(399i32)
    }
    fn name(&self) -> &'static str {
        "Earth"
    }
}
impl Display for Earth {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Earth {
    fn gravitational_parameter(&self) -> f64 {
        398600.43550702266f64
    }
}
impl MeanRadius for Earth {
    fn mean_radius(&self) -> f64 {
        6371.0084f64
    }
}
impl TriaxialEllipsoid for Earth {
    fn radii(&self) -> Radii {
        (6378.1366f64, 6378.1366f64, 6356.7519f64)
    }
}
impl Spheroid for Earth {}
const RIGHT_ASCENSION_EARTH: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 0f64,
    c1: -0.011187560505283653f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const DECLINATION_EARTH: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: 1.5707963267948966f64,
    c1: -0.009721483933608416f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const ROTATION_EARTH: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 3.3186912127896577f64,
    c1: 6.3003876824396166f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
impl RotationalElements for Earth {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_EARTH.angle(t),
            DECLINATION_EARTH.angle(t),
            ROTATION_EARTH.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_EARTH.angle_dot(t),
            DECLINATION_EARTH.angle_dot(t),
            ROTATION_EARTH.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Mars;
impl Origin for Mars {
    fn id(&self) -> NaifId {
        NaifId(499i32)
    }
    fn name(&self) -> &'static str {
        "Mars"
    }
}
impl Display for Mars {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Mars {
    fn gravitational_parameter(&self) -> f64 {
        42828.37362069909f64
    }
}
impl MeanRadius for Mars {
    fn mean_radius(&self) -> f64 {
        3389.5f64
    }
}
impl TriaxialEllipsoid for Mars {
    fn radii(&self) -> Radii {
        (3396.19f64, 3396.19f64, 3376.2f64)
    }
}
impl Spheroid for Mars {}
const RIGHT_ASCENSION_MARS: RotationalElement<15usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 5.5373921900749785f64,
    c1: -0.001907216743164288f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0.000001186823891356144f64,
        0.000004153883619746505f64,
        0.0000009075712110370513f64,
        0.00000015707963267948966f64,
        0.007313924403529878f64,
    ],
    theta0: [
        3.328804809897935f64,
        0.37470342287773584f64,
        5.809517398292802f64,
        6.892873571600945f64,
        3.3097152567180146f64,
        2.120032883264378f64,
        4.032588225058434f64,
        4.387288948439982f64,
        3.8045796985836846f64,
        3.424288764152381f64,
        3.4730520762801462f64,
        3.9495523217086292f64,
        4.357448194643978f64,
        4.645778664015252f64,
        1.3857704297725961f64,
    ],
    theta1: [
        277.80594525842264f64,
        555.6129894920322f64,
        334.05422022489097f64,
        668.125936040531f64,
        719340.2120445863f64,
        11.523153020184504f64,
        11.536473384554899f64,
        23.047098122619843f64,
        668.1113614443373f64,
        334.05316148477937f64,
        334.0469780000094f64,
        668.1268926511307f64,
        1002.1807129125305f64,
        1336.235189496269f64,
        0.008801023466045386f64,
    ],
};
const DECLINATION_MARS: RotationalElement<20usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: 0.9500266243444937f64,
    c1: -0.0010170216810942417f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0.000000890117918517108f64,
        0.000002460914245312005f64,
        0.0000005410520681182422f64,
        0.00000008726646259971648f64,
        0.02777297060138025f64,
    ],
    theta0: [
        3.328804809897935f64,
        0.37470342287773584f64,
        5.809517398292802f64,
        6.892873571600945f64,
        3.3097152567180146f64,
        2.120032883264378f64,
        4.032588225058434f64,
        4.387288948439982f64,
        3.8045796985836846f64,
        3.424288764152381f64,
        3.4730520762801462f64,
        3.9495523217086292f64,
        4.357448194643978f64,
        4.645778664015252f64,
        1.3857704297725961f64,
        2.136869016190709f64,
        0.751510868094019f64,
        1.0064158213753553f64,
        1.3871248750853138f64,
        2.9029314796567682f64,
    ],
    theta1: [
        277.80594525842264f64,
        555.6129894920322f64,
        334.05422022489097f64,
        668.125936040531f64,
        719340.2120445863f64,
        11.523153020184504f64,
        11.536473384554899f64,
        23.047098122619843f64,
        668.1113614443373f64,
        334.05316148477937f64,
        334.0469780000094f64,
        668.1268926511307f64,
        1002.1807129125305f64,
        1336.235189496269f64,
        0.008801023466045386f64,
        334.054984682245f64,
        668.1273150051017f64,
        1002.1811764929237f64,
        1336.2354112473317f64,
        0.008801023466045386f64,
    ],
};
const ROTATION_MARS: RotationalElement<26usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 3.0726497570349416f64,
    c1: 6.12422041248567f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0.000002530727415391778f64,
        0.0000027401669256310974f64,
        0.0000006981317007977319f64,
        0.000000017453292519943295f64,
        0.000000017453292519943295f64,
        0.010202182516192693f64,
    ],
    theta0: [
        3.328804809897935f64,
        0.37470342287773584f64,
        5.809517398292802f64,
        6.892873571600945f64,
        3.3097152567180146f64,
        2.120032883264378f64,
        4.032588225058434f64,
        4.387288948439982f64,
        3.8045796985836846f64,
        3.424288764152381f64,
        3.4730520762801462f64,
        3.9495523217086292f64,
        4.357448194643978f64,
        4.645778664015252f64,
        1.3857704297725961f64,
        2.136869016190709f64,
        0.751510868094019f64,
        1.0064158213753553f64,
        1.3871248750853138f64,
        2.9029314796567682f64,
        2.252727410236719f64,
        0.6344650043848296f64,
        0.9890544553471146f64,
        1.1757236496733376f64,
        1.8289772979888115f64,
        1.664898441223219f64,
    ],
    theta1: [
        277.80594525842264f64,
        555.6129894920322f64,
        334.05422022489097f64,
        668.125936040531f64,
        719340.2120445863f64,
        11.523153020184504f64,
        11.536473384554899f64,
        23.047098122619843f64,
        668.1113614443373f64,
        334.05316148477937f64,
        334.0469780000094f64,
        668.1268926511307f64,
        1002.1807129125305f64,
        1336.235189496269f64,
        0.008801023466045386f64,
        334.054984682245f64,
        668.1273150051017f64,
        1002.1811764929237f64,
        1336.2354112473317f64,
        0.008801023466045386f64,
        334.05659172556966f64,
        668.130317528175f64,
        1002.1842799588599f64,
        1336.2285297823557f64,
        1670.2877519268022f64,
        0.008801023466045386f64,
    ],
};
impl RotationalElements for Mars {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_MARS.angle(t),
            DECLINATION_MARS.angle(t),
            ROTATION_MARS.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_MARS.angle_dot(t),
            DECLINATION_MARS.angle_dot(t),
            ROTATION_MARS.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Jupiter;
impl Origin for Jupiter {
    fn id(&self) -> NaifId {
        NaifId(599i32)
    }
    fn name(&self) -> &'static str {
        "Jupiter"
    }
}
impl Display for Jupiter {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Jupiter {
    fn gravitational_parameter(&self) -> f64 {
        126686531.9003704f64
    }
}
impl MeanRadius for Jupiter {
    fn mean_radius(&self) -> f64 {
        69911f64
    }
}
impl TriaxialEllipsoid for Jupiter {
    fn radii(&self) -> Radii {
        (71492f64, 71492f64, 66854f64)
    }
}
impl Spheroid for Jupiter {}
const RIGHT_ASCENSION_JUPITER: RotationalElement<15usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 4.6784701644349695f64,
    c1: -0.00011342894808711148f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0.0000020420352248333656f64,
        0.000016371188383706813f64,
        0.000024993114888558796f64,
        0.0000005235987755982989f64,
        0.00003752457891787809f64,
    ],
    theta0: [
        1.2796754075622423f64,
        0.42970006184100396f64,
        4.9549897464119015f64,
        6.2098814785958245f64,
        2.092649773141201f64,
        4.010766621082969f64,
        6.147922290150026f64,
        1.9783307071355725f64,
        2.5593508151244846f64,
        0.8594001236820079f64,
        1.734171606432425f64,
        3.0699533280603655f64,
        5.241627996900319f64,
        1.9898901100379935f64,
        0.864134346731335f64,
    ],
    theta1: [
        1596.503281347521f64,
        787.7927551311844f64,
        84.66068602648895f64,
        20.792107379008446f64,
        4.574507969477138f64,
        1.1222467090323538f64,
        41.58421475801689f64,
        105.9414855960558f64,
        3193.006562695042f64,
        1575.5855102623689f64,
        84.65553032387855f64,
        20.80363527871787f64,
        4.582318317879813f64,
        105.94580703128374f64,
        1.1222467090323538f64,
    ],
};
const DECLINATION_JUPITER: RotationalElement<15usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: 1.1256553894213766f64,
    c1: 0.00004211479485062318f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0.0000008726646259971648f64,
        0.000007051130178057092f64,
        0.000010768681484805013f64,
        -0.00000022689280275926283f64,
        0.00001616174887346749f64,
    ],
    theta0: [
        1.2796754075622423f64,
        0.42970006184100396f64,
        4.9549897464119015f64,
        6.2098814785958245f64,
        2.092649773141201f64,
        4.010766621082969f64,
        6.147922290150026f64,
        1.9783307071355725f64,
        2.5593508151244846f64,
        0.8594001236820079f64,
        1.734171606432425f64,
        3.0699533280603655f64,
        5.241627996900319f64,
        1.9898901100379935f64,
        0.864134346731335f64,
    ],
    theta1: [
        1596.503281347521f64,
        787.7927551311844f64,
        84.66068602648895f64,
        20.792107379008446f64,
        4.574507969477138f64,
        1.1222467090323538f64,
        41.58421475801689f64,
        105.9414855960558f64,
        3193.006562695042f64,
        1575.5855102623689f64,
        84.65553032387855f64,
        20.80363527871787f64,
        4.582318317879813f64,
        105.94580703128374f64,
        1.1222467090323538f64,
    ],
};
const ROTATION_JUPITER: RotationalElement<15usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 4.973315703557842f64,
    c1: 15.193719457141356f64,
    c2: 0f64,
    c: [
        0f64, 0f64, 0f64, 0f64, 0f64, 0f64, 0f64, 0f64, 0f64, 0f64, 0f64, 0f64, 0f64, 0f64, 0f64,
    ],
    theta0: [
        1.2796754075622423f64,
        0.42970006184100396f64,
        4.9549897464119015f64,
        6.2098814785958245f64,
        2.092649773141201f64,
        4.010766621082969f64,
        6.147922290150026f64,
        1.9783307071355725f64,
        2.5593508151244846f64,
        0.8594001236820079f64,
        1.734171606432425f64,
        3.0699533280603655f64,
        5.241627996900319f64,
        1.9898901100379935f64,
        0.864134346731335f64,
    ],
    theta1: [
        1596.503281347521f64,
        787.7927551311844f64,
        84.66068602648895f64,
        20.792107379008446f64,
        4.574507969477138f64,
        1.1222467090323538f64,
        41.58421475801689f64,
        105.9414855960558f64,
        3193.006562695042f64,
        1575.5855102623689f64,
        84.65553032387855f64,
        20.80363527871787f64,
        4.582318317879813f64,
        105.94580703128374f64,
        1.1222467090323538f64,
    ],
};
impl RotationalElements for Jupiter {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_JUPITER.angle(t),
            DECLINATION_JUPITER.angle(t),
            ROTATION_JUPITER.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_JUPITER.angle_dot(t),
            DECLINATION_JUPITER.angle_dot(t),
            ROTATION_JUPITER.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Saturn;
impl Origin for Saturn {
    fn id(&self) -> NaifId {
        NaifId(699i32)
    }
    fn name(&self) -> &'static str {
        "Saturn"
    }
}
impl Display for Saturn {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Saturn {
    fn gravitational_parameter(&self) -> f64 {
        37931206.23436167f64
    }
}
impl MeanRadius for Saturn {
    fn mean_radius(&self) -> f64 {
        58232f64
    }
}
impl TriaxialEllipsoid for Saturn {
    fn radii(&self) -> Radii {
        (60268f64, 60268f64, 54364f64)
    }
}
impl Spheroid for Saturn {}
const RIGHT_ASCENSION_SATURN: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 0.7084116900919784f64,
    c1: -0.0006283185307179586f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const DECLINATION_SATURN: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: 1.457995697238503f64,
    c1: -0.00006981317007977319f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const ROTATION_SATURN: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 0.6789330790257941f64,
    c1: 14.151023151973554f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
impl RotationalElements for Saturn {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_SATURN.angle(t),
            DECLINATION_SATURN.angle(t),
            ROTATION_SATURN.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_SATURN.angle_dot(t),
            DECLINATION_SATURN.angle_dot(t),
            ROTATION_SATURN.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Uranus;
impl Origin for Uranus {
    fn id(&self) -> NaifId {
        NaifId(799i32)
    }
    fn name(&self) -> &'static str {
        "Uranus"
    }
}
impl Display for Uranus {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Uranus {
    fn gravitational_parameter(&self) -> f64 {
        5793951.256527211f64
    }
}
impl MeanRadius for Uranus {
    fn mean_radius(&self) -> f64 {
        25362f64
    }
}
impl TriaxialEllipsoid for Uranus {
    fn radii(&self) -> Radii {
        (25559f64, 25559f64, 24973f64)
    }
}
impl Spheroid for Uranus {}
const RIGHT_ASCENSION_URANUS: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 4.4909241515991285f64,
    c1: 0f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const DECLINATION_URANUS: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: -0.2648537139901395f64,
    c1: 0f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const ROTATION_URANUS: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 3.557155548489643f64,
    c1: -8.746893698960328f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
impl RotationalElements for Uranus {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_URANUS.angle(t),
            DECLINATION_URANUS.angle(t),
            ROTATION_URANUS.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_URANUS.angle_dot(t),
            DECLINATION_URANUS.angle_dot(t),
            ROTATION_URANUS.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Neptune;
impl Origin for Neptune {
    fn id(&self) -> NaifId {
        NaifId(899i32)
    }
    fn name(&self) -> &'static str {
        "Neptune"
    }
}
impl Display for Neptune {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Neptune {
    fn gravitational_parameter(&self) -> f64 {
        6835103.145462294f64
    }
}
impl MeanRadius for Neptune {
    fn mean_radius(&self) -> f64 {
        24622f64
    }
}
impl TriaxialEllipsoid for Neptune {
    fn radii(&self) -> Radii {
        (24764f64, 24764f64, 24341f64)
    }
}
impl Spheroid for Neptune {}
const RIGHT_ASCENSION_NEPTUNE: RotationalElement<8usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 5.224817648770225f64,
    c1: 0f64,
    c2: 0f64,
    c: [
        0.012217304763960306f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        6.245660728261709f64,
        5.653470513060032f64,
        3.848625533572696f64,
        6.183177941040311f64,
        1.3144074596769295f64,
        0.6171484235051949f64,
        2.4890140462691135f64,
        3.104068074671915f64,
    ],
    theta1: [
        0.9130864514733535f64,
        1092.6913034790819f64,
        961.0515899766616f64,
        812.7038395448996f64,
        455.6949957202075f64,
        250.02539666519567f64,
        49.29857005183183f64,
        0.9130864514733535f64,
    ],
};
const DECLINATION_NEPTUNE: RotationalElement<8usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: 0.7585200929167356f64,
    c1: 0f64,
    c2: 0f64,
    c: [
        -0.00890117918517108f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        6.245660728261709f64,
        5.653470513060032f64,
        3.848625533572696f64,
        6.183177941040311f64,
        1.3144074596769295f64,
        0.6171484235051949f64,
        2.4890140462691135f64,
        3.104068074671915f64,
    ],
    theta1: [
        0.9130864514733535f64,
        1092.6913034790819f64,
        961.0515899766616f64,
        812.7038395448996f64,
        455.6949957202075f64,
        250.02539666519567f64,
        49.29857005183183f64,
        0.9130864514733535f64,
    ],
};
const ROTATION_NEPTUNE: RotationalElement<8usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 4.362939157550385f64,
    c1: 9.444670799468602f64,
    c2: 0f64,
    c: [
        -0.008377580409572781f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        6.245660728261709f64,
        5.653470513060032f64,
        3.848625533572696f64,
        6.183177941040311f64,
        1.3144074596769295f64,
        0.6171484235051949f64,
        2.4890140462691135f64,
        3.104068074671915f64,
    ],
    theta1: [
        0.9130864514733535f64,
        1092.6913034790819f64,
        961.0515899766616f64,
        812.7038395448996f64,
        455.6949957202075f64,
        250.02539666519567f64,
        49.29857005183183f64,
        0.9130864514733535f64,
    ],
};
impl RotationalElements for Neptune {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_NEPTUNE.angle(t),
            DECLINATION_NEPTUNE.angle(t),
            ROTATION_NEPTUNE.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_NEPTUNE.angle_dot(t),
            DECLINATION_NEPTUNE.angle_dot(t),
            ROTATION_NEPTUNE.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Pluto;
impl Origin for Pluto {
    fn id(&self) -> NaifId {
        NaifId(999i32)
    }
    fn name(&self) -> &'static str {
        "Pluto"
    }
}
impl Display for Pluto {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Pluto {
    fn gravitational_parameter(&self) -> f64 {
        869.6138177608748f64
    }
}
impl MeanRadius for Pluto {
    fn mean_radius(&self) -> f64 {
        1188.3f64
    }
}
impl TriaxialEllipsoid for Pluto {
    fn radii(&self) -> Radii {
        (1188.3f64, 1188.3f64, 1188.3f64)
    }
}
impl Spheroid for Pluto {}
const RIGHT_ASCENSION_PLUTO: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 2.3211657321048187f64,
    c1: 0f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const DECLINATION_PLUTO: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: -0.10756464180041053f64,
    c1: 0f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const ROTATION_PLUTO: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 5.283024379324235f64,
    c1: 0.9837115923543857f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
impl RotationalElements for Pluto {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_PLUTO.angle(t),
            DECLINATION_PLUTO.angle(t),
            ROTATION_PLUTO.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_PLUTO.angle_dot(t),
            DECLINATION_PLUTO.angle_dot(t),
            ROTATION_PLUTO.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct SolarSystemBarycenter;
impl Origin for SolarSystemBarycenter {
    fn id(&self) -> NaifId {
        NaifId(0i32)
    }
    fn name(&self) -> &'static str {
        "Solar System Barycenter"
    }
}
impl Display for SolarSystemBarycenter {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for SolarSystemBarycenter {
    fn gravitational_parameter(&self) -> f64 {
        132712440041.27942f64
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct MercuryBarycenter;
impl Origin for MercuryBarycenter {
    fn id(&self) -> NaifId {
        NaifId(1i32)
    }
    fn name(&self) -> &'static str {
        "Mercury Barycenter"
    }
}
impl Display for MercuryBarycenter {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for MercuryBarycenter {
    fn gravitational_parameter(&self) -> f64 {
        22031.868551400003f64
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct VenusBarycenter;
impl Origin for VenusBarycenter {
    fn id(&self) -> NaifId {
        NaifId(2i32)
    }
    fn name(&self) -> &'static str {
        "Venus Barycenter"
    }
}
impl Display for VenusBarycenter {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for VenusBarycenter {
    fn gravitational_parameter(&self) -> f64 {
        324858.592f64
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct EarthBarycenter;
impl Origin for EarthBarycenter {
    fn id(&self) -> NaifId {
        NaifId(3i32)
    }
    fn name(&self) -> &'static str {
        "Earth Barycenter"
    }
}
impl Display for EarthBarycenter {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for EarthBarycenter {
    fn gravitational_parameter(&self) -> f64 {
        403503.2356254802f64
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct MarsBarycenter;
impl Origin for MarsBarycenter {
    fn id(&self) -> NaifId {
        NaifId(4i32)
    }
    fn name(&self) -> &'static str {
        "Mars Barycenter"
    }
}
impl Display for MarsBarycenter {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for MarsBarycenter {
    fn gravitational_parameter(&self) -> f64 {
        42828.3758157561f64
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct JupiterBarycenter;
impl Origin for JupiterBarycenter {
    fn id(&self) -> NaifId {
        NaifId(5i32)
    }
    fn name(&self) -> &'static str {
        "Jupiter Barycenter"
    }
}
impl Display for JupiterBarycenter {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for JupiterBarycenter {
    fn gravitational_parameter(&self) -> f64 {
        126712764.09999998f64
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct SaturnBarycenter;
impl Origin for SaturnBarycenter {
    fn id(&self) -> NaifId {
        NaifId(6i32)
    }
    fn name(&self) -> &'static str {
        "Saturn Barycenter"
    }
}
impl Display for SaturnBarycenter {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for SaturnBarycenter {
    fn gravitational_parameter(&self) -> f64 {
        37940584.8418f64
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct UranusBarycenter;
impl Origin for UranusBarycenter {
    fn id(&self) -> NaifId {
        NaifId(7i32)
    }
    fn name(&self) -> &'static str {
        "Uranus Barycenter"
    }
}
impl Display for UranusBarycenter {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for UranusBarycenter {
    fn gravitational_parameter(&self) -> f64 {
        5794556.3999999985f64
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct NeptuneBarycenter;
impl Origin for NeptuneBarycenter {
    fn id(&self) -> NaifId {
        NaifId(8i32)
    }
    fn name(&self) -> &'static str {
        "Neptune Barycenter"
    }
}
impl Display for NeptuneBarycenter {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for NeptuneBarycenter {
    fn gravitational_parameter(&self) -> f64 {
        6836527.100580399f64
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct PlutoBarycenter;
impl Origin for PlutoBarycenter {
    fn id(&self) -> NaifId {
        NaifId(9i32)
    }
    fn name(&self) -> &'static str {
        "Pluto Barycenter"
    }
}
impl Display for PlutoBarycenter {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for PlutoBarycenter {
    fn gravitational_parameter(&self) -> f64 {
        975.5f64
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Moon;
impl Origin for Moon {
    fn id(&self) -> NaifId {
        NaifId(301i32)
    }
    fn name(&self) -> &'static str {
        "Moon"
    }
}
impl Display for Moon {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Moon {
    fn gravitational_parameter(&self) -> f64 {
        4902.80011845755f64
    }
}
impl MeanRadius for Moon {
    fn mean_radius(&self) -> f64 {
        1737.4f64
    }
}
impl TriaxialEllipsoid for Moon {
    fn radii(&self) -> Radii {
        (1737.4f64, 1737.4f64, 1737.4f64)
    }
}
impl Spheroid for Moon {}
const RIGHT_ASCENSION_MOON: RotationalElement<13usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 4.712299968592838f64,
    c1: 0.000054105206811824215f64,
    c2: 0f64,
    c: [
        -0.06769608569710406f64,
        -0.0021013764194011725f64,
        0.0012217304763960308f64,
        -0.0003001966313430247f64,
        0f64,
        0.0001256637061435917f64,
        0f64,
        0f64,
        0f64,
        -0.00009075712110370513f64,
        0f64,
        0f64,
        0.00007504915783575618f64,
    ],
    theta0: [
        2.1824469631563095f64,
        4.364876473020098f64,
        4.537995681525416f64,
        3.0826877913349846f64,
        6.240058221362807f64,
        5.438253962996612f64,
        2.355548718369107f64,
        4.827877416989155f64,
        0.5973563897875792f64,
        0.2641381289968218f64,
        2.0899096062155698f64,
        4.188109526378113f64,
        0.4372573375021394f64,
    ],
    theta1: [
        -33.781483888495835f64,
        -67.56296777699167f64,
        8294.909972626925f64,
        8504.459388212737f64,
        628.3019668015924f64,
        16833.15084472816f64,
        8328.69145651542f64,
        209.54947933396397f64,
        1114.6285779726247f64,
        -101.3444516654875f64,
        2.301053255936537f64,
        104.77473966698199f64,
        8261.12848873843f64,
    ],
};
const DECLINATION_MOON: RotationalElement<13usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: 1.161328121643011f64,
    c1: 0.00022689280275926284f64,
    c2: 0f64,
    c: [
        0.02691123173650057f64,
        0.0004171336912266448f64,
        -0.00048520153205442357f64,
        0.0001186823891356144f64,
        0f64,
        -0.00005061454830783555f64,
        0.000015707963267948964f64,
        0f64,
        0f64,
        0.000013962634015954637f64,
        0f64,
        0f64,
        -0.000015707963267948964f64,
    ],
    theta0: [
        2.1824469631563095f64,
        4.364876473020098f64,
        4.537995681525416f64,
        3.0826877913349846f64,
        6.240058221362807f64,
        5.438253962996612f64,
        2.355548718369107f64,
        4.827877416989155f64,
        0.5973563897875792f64,
        0.2641381289968218f64,
        2.0899096062155698f64,
        4.188109526378113f64,
        0.4372573375021394f64,
    ],
    theta1: [
        -33.781483888495835f64,
        -67.56296777699167f64,
        8294.909972626925f64,
        8504.459388212737f64,
        628.3019668015924f64,
        16833.15084472816f64,
        8328.69145651542f64,
        209.54947933396397f64,
        1114.6285779726247f64,
        -101.3444516654875f64,
        2.301053255936537f64,
        104.77473966698199f64,
        8261.12848873843f64,
    ],
};
const ROTATION_MOON: RotationalElement<13usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 0.668832858644503f64,
    c1: 0.22997083313948888f64,
    c2: -0.000000000000024434609527920614f64,
    c: [
        0.06215117466351808f64,
        0.00210835773640915f64,
        -0.0011205013797803594f64,
        0.0002757620218151041f64,
        0.0004398229715025711f64,
        -0.00011519173063162575f64,
        -0.00008203047484373349f64,
        -0.00008028514559173915f64,
        0.000048869219055841225f64,
        0.00009075712110370513f64,
        0.00006981317007977319f64,
        0.00003316125578789226f64,
        -0.0000767944870877505f64,
    ],
    theta0: [
        2.1824469631563095f64,
        4.364876473020098f64,
        4.537995681525416f64,
        3.0826877913349846f64,
        6.240058221362807f64,
        5.438253962996612f64,
        2.355548718369107f64,
        4.827877416989155f64,
        0.5973563897875792f64,
        0.2641381289968218f64,
        2.0899096062155698f64,
        4.188109526378113f64,
        0.4372573375021394f64,
    ],
    theta1: [
        -33.781483888495835f64,
        -67.56296777699167f64,
        8294.909972626925f64,
        8504.459388212737f64,
        628.3019668015924f64,
        16833.15084472816f64,
        8328.69145651542f64,
        209.54947933396397f64,
        1114.6285779726247f64,
        -101.3444516654875f64,
        2.301053255936537f64,
        104.77473966698199f64,
        8261.12848873843f64,
    ],
};
impl RotationalElements for Moon {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_MOON.angle(t),
            DECLINATION_MOON.angle(t),
            ROTATION_MOON.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_MOON.angle_dot(t),
            DECLINATION_MOON.angle_dot(t),
            ROTATION_MOON.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Phobos;
impl Origin for Phobos {
    fn id(&self) -> NaifId {
        NaifId(401i32)
    }
    fn name(&self) -> &'static str {
        "Phobos"
    }
}
impl Display for Phobos {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Phobos {
    fn gravitational_parameter(&self) -> f64 {
        0.0007087546066894452f64
    }
}
impl MeanRadius for Phobos {
    fn mean_radius(&self) -> f64 {
        11.08f64
    }
}
impl TriaxialEllipsoid for Phobos {
    fn radii(&self) -> Radii {
        (13f64, 11.4f64, 9.1f64)
    }
}
const RIGHT_ASCENSION_PHOBOS: RotationalElement<4usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 5.544399941316208f64,
    c1: -0.001892691938596266f64,
    c2: 0f64,
    c: [
        -0.031141630416121578f64,
        0.00038621064567151f64,
        -0.00017946365486924213f64,
        -0.00008300698656022431f64,
    ],
    theta0: [
        3.328804809897935f64,
        0.37470342287773584f64,
        5.809517398292802f64,
        6.892873571600945f64,
    ],
    theta1: [
        277.80594525842264f64,
        555.6129894920322f64,
        334.05422022489097f64,
        668.125936040531f64,
    ],
};
const DECLINATION_PHOBOS: RotationalElement<4usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: 0.9230395870244597f64,
    c1: -0.0010707081834185127f64,
    c2: 0f64,
    c: [
        -0.018765175709923063f64,
        0.00011669725164439606f64,
        -0.00011322648989388013f64,
        0.000049144282945955534f64,
    ],
    theta0: [
        3.328804809897935f64,
        0.37470342287773584f64,
        5.809517398292802f64,
        6.892873571600945f64,
    ],
    theta1: [
        277.80594525842264f64,
        555.6129894920322f64,
        334.05422022489097f64,
        668.125936040531f64,
    ],
};
const ROTATION_PHOBOS: RotationalElement<5usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 0.6141419961301966f64,
    c1: 19.702057793318815f64,
    c2: 0.00000000016643698911600935f64,
    c: [
        0.02485728795564792f64,
        -0.0003968499982587423f64,
        0.0000716825922415843f64,
        0.00011029852554073445f64,
        -0.019949113350295186f64,
    ],
    theta0: [
        3.328804809897935f64,
        0.37470342287773584f64,
        5.809517398292802f64,
        6.892873571600945f64,
        3.3097152567180146f64,
    ],
    theta1: [
        277.80594525842264f64,
        555.6129894920322f64,
        334.05422022489097f64,
        668.125936040531f64,
        719340.2120445863f64,
    ],
};
impl RotationalElements for Phobos {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_PHOBOS.angle(t),
            DECLINATION_PHOBOS.angle(t),
            ROTATION_PHOBOS.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_PHOBOS.angle_dot(t),
            DECLINATION_PHOBOS.angle_dot(t),
            ROTATION_PHOBOS.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Deimos;
impl Origin for Deimos {
    fn id(&self) -> NaifId {
        NaifId(402i32)
    }
    fn name(&self) -> &'static str {
        "Deimos"
    }
}
impl Display for Deimos {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Deimos {
    fn gravitational_parameter(&self) -> f64 {
        0.00009615569648120313f64
    }
}
impl MeanRadius for Deimos {
    fn mean_radius(&self) -> f64 {
        6.2f64
    }
}
impl TriaxialEllipsoid for Deimos {
    fn radii(&self) -> Radii {
        (7.8f64, 6f64, 5.1f64)
    }
}
const RIGHT_ASCENSION_DEIMOS: RotationalElement<10usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 5.526708263174914f64,
    c1: -0.0018357397507085887f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0.05396867424229676f64,
        0.004010877798556321f64,
        0.0011202666329959662f64,
        0.00044218562371099577f64,
        0.00013590791618817245f64,
    ],
    theta0: [
        3.328804809897935f64,
        0.37470342287773584f64,
        5.809517398292802f64,
        6.892873571600945f64,
        3.3097152567180146f64,
        2.120032883264378f64,
        4.032588225058434f64,
        4.387288948439982f64,
        3.8045796985836846f64,
        3.424288764152381f64,
    ],
    theta1: [
        277.80594525842264f64,
        555.6129894920322f64,
        334.05422022489097f64,
        668.125936040531f64,
        719340.2120445863f64,
        11.523153020184504f64,
        11.536473384554899f64,
        23.047098122619843f64,
        668.1113614443373f64,
        334.05316148477937f64,
    ],
};
const DECLINATION_DEIMOS: RotationalElement<10usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: 0.9339242922383507f64,
    c1: -0.0010435487658623783f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0.032102888827614605f64,
        0.002500240004017941f64,
        0.00033360380402252296f64,
        -0.0002587607695714273f64,
        0.00003358537079612689f64,
    ],
    theta0: [
        3.328804809897935f64,
        0.37470342287773584f64,
        5.809517398292802f64,
        6.892873571600945f64,
        3.3097152567180146f64,
        2.120032883264378f64,
        4.032588225058434f64,
        4.387288948439982f64,
        3.8045796985836846f64,
        3.424288764152381f64,
    ],
    theta1: [
        277.80594525842264f64,
        555.6129894920322f64,
        334.05422022489097f64,
        668.125936040531f64,
        719340.2120445863f64,
        11.523153020184504f64,
        11.536473384554899f64,
        23.047098122619843f64,
        668.1113614443373f64,
        334.05316148477937f64,
    ],
};
const ROTATION_DEIMOS: RotationalElement<10usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 1.3857797243489947f64,
    c1: 4.977013864082068f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        -0.047814137677880446f64,
        -0.006975837721323607f64,
        -0.0011455047921115052f64,
        -0.0005084039391304362f64,
        0.0002965593651818685f64,
    ],
    theta0: [
        3.328804809897935f64,
        0.37470342287773584f64,
        5.809517398292802f64,
        6.892873571600945f64,
        3.3097152567180146f64,
        2.120032883264378f64,
        4.032588225058434f64,
        4.387288948439982f64,
        3.8045796985836846f64,
        3.424288764152381f64,
    ],
    theta1: [
        277.80594525842264f64,
        555.6129894920322f64,
        334.05422022489097f64,
        668.125936040531f64,
        719340.2120445863f64,
        11.523153020184504f64,
        11.536473384554899f64,
        23.047098122619843f64,
        668.1113614443373f64,
        334.05316148477937f64,
    ],
};
impl RotationalElements for Deimos {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_DEIMOS.angle(t),
            DECLINATION_DEIMOS.angle(t),
            ROTATION_DEIMOS.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_DEIMOS.angle_dot(t),
            DECLINATION_DEIMOS.angle_dot(t),
            ROTATION_DEIMOS.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Io;
impl Origin for Io {
    fn id(&self) -> NaifId {
        NaifId(501i32)
    }
    fn name(&self) -> &'static str {
        "Io"
    }
}
impl Display for Io {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Io {
    fn gravitational_parameter(&self) -> f64 {
        5959.915466180539f64
    }
}
impl MeanRadius for Io {
    fn mean_radius(&self) -> f64 {
        1821.49f64
    }
}
impl TriaxialEllipsoid for Io {
    fn radii(&self) -> Radii {
        (1829.4f64, 1819.4f64, 1815.7f64)
    }
}
const RIGHT_ASCENSION_IO: RotationalElement<4usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 4.678355059970801f64,
    c1: -0.00015707963267948965f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0.0016406094968746698f64,
        0.0004188790204786391f64,
    ],
    theta0: [
        1.2796754075622423f64,
        0.42970006184100396f64,
        4.9549897464119015f64,
        6.2098814785958245f64,
    ],
    theta1: [
        1596.503281347521f64,
        787.7927551311844f64,
        84.66068602648895f64,
        20.792107379008446f64,
    ],
};
const DECLINATION_IO: RotationalElement<4usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: 1.1257373675363425f64,
    c1: 0.00005235987755982989f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0.0006981317007977319f64,
        0.00019198621771937625f64,
    ],
    theta0: [
        1.2796754075622423f64,
        0.42970006184100396f64,
        4.9549897464119015f64,
        6.2098814785958245f64,
    ],
    theta1: [
        1596.503281347521f64,
        787.7927551311844f64,
        84.66068602648895f64,
        20.792107379008446f64,
    ],
};
const ROTATION_IO: RotationalElement<4usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 3.4974652880714365f64,
    c1: 3.551552235248627f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        -0.0014835298641951802f64,
        -0.0003839724354387525f64,
    ],
    theta0: [
        1.2796754075622423f64,
        0.42970006184100396f64,
        4.9549897464119015f64,
        6.2098814785958245f64,
    ],
    theta1: [
        1596.503281347521f64,
        787.7927551311844f64,
        84.66068602648895f64,
        20.792107379008446f64,
    ],
};
impl RotationalElements for Io {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_IO.angle(t),
            DECLINATION_IO.angle(t),
            ROTATION_IO.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_IO.angle_dot(t),
            DECLINATION_IO.angle_dot(t),
            ROTATION_IO.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Europa;
impl Origin for Europa {
    fn id(&self) -> NaifId {
        NaifId(502i32)
    }
    fn name(&self) -> &'static str {
        "Europa"
    }
}
impl Display for Europa {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Europa {
    fn gravitational_parameter(&self) -> f64 {
        3202.712099607295f64
    }
}
impl MeanRadius for Europa {
    fn mean_radius(&self) -> f64 {
        1560.8f64
    }
}
impl TriaxialEllipsoid for Europa {
    fn radii(&self) -> Radii {
        (1562.6f64, 1560.3f64, 1559.5f64)
    }
}
const RIGHT_ASCENSION_EUROPA: RotationalElement<7usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 4.678878658746398f64,
    c1: -0.00015707963267948965f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0.01895427567665842f64,
        0.0010471975511965976f64,
        0.0002617993877991494f64,
        0.00015707963267948965f64,
    ],
    theta0: [
        1.2796754075622423f64,
        0.42970006184100396f64,
        4.9549897464119015f64,
        6.2098814785958245f64,
        2.092649773141201f64,
        4.010766621082969f64,
        6.147922290150026f64,
    ],
    theta1: [
        1596.503281347521f64,
        787.7927551311844f64,
        84.66068602648895f64,
        20.792107379008446f64,
        4.574507969477138f64,
        1.1222467090323538f64,
        41.58421475801689f64,
    ],
};
const DECLINATION_EUROPA: RotationalElement<7usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: 1.125911900461542f64,
    c1: 0.00005235987755982989f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0.008168140899333463f64,
        0.0004537856055185257f64,
        0.00012217304763960306f64,
        0.00003490658503988659f64,
    ],
    theta0: [
        1.2796754075622423f64,
        0.42970006184100396f64,
        4.9549897464119015f64,
        6.2098814785958245f64,
        2.092649773141201f64,
        4.010766621082969f64,
        6.147922290150026f64,
    ],
    theta1: [
        1596.503281347521f64,
        787.7927551311844f64,
        84.66068602648895f64,
        20.792107379008446f64,
        4.574507969477138f64,
        1.1222467090323538f64,
        41.58421475801689f64,
    ],
};
const ROTATION_EUROPA: RotationalElement<7usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 0.6287025031533974f64,
    c1: 1.7693227033738699f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        -0.01710422666954443f64,
        -0.0009424777960769379f64,
        -0.0002443460952792061f64,
        -0.00013962634015954637f64,
    ],
    theta0: [
        1.2796754075622423f64,
        0.42970006184100396f64,
        4.9549897464119015f64,
        6.2098814785958245f64,
        2.092649773141201f64,
        4.010766621082969f64,
        6.147922290150026f64,
    ],
    theta1: [
        1596.503281347521f64,
        787.7927551311844f64,
        84.66068602648895f64,
        20.792107379008446f64,
        4.574507969477138f64,
        1.1222467090323538f64,
        41.58421475801689f64,
    ],
};
impl RotationalElements for Europa {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_EUROPA.angle(t),
            DECLINATION_EUROPA.angle(t),
            ROTATION_EUROPA.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_EUROPA.angle_dot(t),
            DECLINATION_EUROPA.angle_dot(t),
            ROTATION_EUROPA.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Ganymede;
impl Origin for Ganymede {
    fn id(&self) -> NaifId {
        NaifId(503i32)
    }
    fn name(&self) -> &'static str {
        "Ganymede"
    }
}
impl Display for Ganymede {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Ganymede {
    fn gravitational_parameter(&self) -> f64 {
        9887.832752719638f64
    }
}
impl MeanRadius for Ganymede {
    fn mean_radius(&self) -> f64 {
        2631.2f64
    }
}
impl TriaxialEllipsoid for Ganymede {
    fn radii(&self) -> Radii {
        (2631.2f64, 2631.2f64, 2631.2f64)
    }
}
impl Spheroid for Ganymede {}
const RIGHT_ASCENSION_GANYMEDE: RotationalElement<6usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 4.680973053848792f64,
    c1: -0.00015707963267948965f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        -0.0006457718232379018f64,
        0.0075223690760955605f64,
        0.0015882496193148398f64,
    ],
    theta0: [
        1.2796754075622423f64,
        0.42970006184100396f64,
        4.9549897464119015f64,
        6.2098814785958245f64,
        2.092649773141201f64,
        4.010766621082969f64,
    ],
    theta1: [
        1596.503281347521f64,
        787.7927551311844f64,
        84.66068602648895f64,
        20.792107379008446f64,
        4.574507969477138f64,
        1.1222467090323538f64,
    ],
};
const DECLINATION_GANYMEDE: RotationalElement<6usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: 1.1269590980127384f64,
    c1: 0.00005235987755982989f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        -0.00027925268031909274f64,
        0.003246312408709453f64,
        0.0006806784082777885f64,
    ],
    theta0: [
        1.2796754075622423f64,
        0.42970006184100396f64,
        4.9549897464119015f64,
        6.2098814785958245f64,
        2.092649773141201f64,
        4.010766621082969f64,
    ],
    theta1: [
        1596.503281347521f64,
        787.7927551311844f64,
        84.66068602648895f64,
        20.792107379008446f64,
        4.574507969477138f64,
        1.1222467090323538f64,
    ],
};
const ROTATION_GANYMEDE: RotationalElement<6usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 0.7690618815987814f64,
    c1: 0.8782079330731682f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0.0005759586531581288f64,
        -0.006789330790257942f64,
        -0.0014311699866353504f64,
    ],
    theta0: [
        1.2796754075622423f64,
        0.42970006184100396f64,
        4.9549897464119015f64,
        6.2098814785958245f64,
        2.092649773141201f64,
        4.010766621082969f64,
    ],
    theta1: [
        1596.503281347521f64,
        787.7927551311844f64,
        84.66068602648895f64,
        20.792107379008446f64,
        4.574507969477138f64,
        1.1222467090323538f64,
    ],
};
impl RotationalElements for Ganymede {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_GANYMEDE.angle(t),
            DECLINATION_GANYMEDE.angle(t),
            ROTATION_GANYMEDE.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_GANYMEDE.angle_dot(t),
            DECLINATION_GANYMEDE.angle_dot(t),
            ROTATION_GANYMEDE.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Callisto;
impl Origin for Callisto {
    fn id(&self) -> NaifId {
        NaifId(504i32)
    }
    fn name(&self) -> &'static str {
        "Callisto"
    }
}
impl Display for Callisto {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Callisto {
    fn gravitational_parameter(&self) -> f64 {
        7179.283402579837f64
    }
}
impl MeanRadius for Callisto {
    fn mean_radius(&self) -> f64 {
        2410.3f64
    }
}
impl TriaxialEllipsoid for Callisto {
    fn radii(&self) -> Radii {
        (2410.3f64, 2410.3f64, 2410.3f64)
    }
}
impl Spheroid for Callisto {}
const RIGHT_ASCENSION_CALLISTO: RotationalElement<8usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 4.690048765959163f64,
    c1: -0.00015707963267948965f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        -0.001186823891356144f64,
        0.010297442586766544f64,
        0f64,
        0.00017453292519943296f64,
    ],
    theta0: [
        1.2796754075622423f64,
        0.42970006184100396f64,
        4.9549897464119015f64,
        6.2098814785958245f64,
        2.092649773141201f64,
        4.010766621082969f64,
        6.147922290150026f64,
        1.9783307071355725f64,
    ],
    theta1: [
        1596.503281347521f64,
        787.7927551311844f64,
        84.66068602648895f64,
        20.792107379008446f64,
        4.574507969477138f64,
        1.1222467090323538f64,
        41.58421475801689f64,
        105.9414855960558f64,
    ],
};
const DECLINATION_CALLISTO: RotationalElement<8usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: 1.1314969540679238f64,
    c1: 0.00005235987755982989f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        -0.0005061454830783556f64,
        0.004433136300065597f64,
        0f64,
        -0.00006981317007977319f64,
    ],
    theta0: [
        1.2796754075622423f64,
        0.42970006184100396f64,
        4.9549897464119015f64,
        6.2098814785958245f64,
        2.092649773141201f64,
        4.010766621082969f64,
        6.147922290150026f64,
        1.9783307071355725f64,
    ],
    theta1: [
        1596.503281347521f64,
        787.7927551311844f64,
        84.66068602648895f64,
        20.792107379008446f64,
        4.574507969477138f64,
        1.1222467090323538f64,
        41.58421475801689f64,
        105.9414855960558f64,
    ],
};
const ROTATION_CALLISTO: RotationalElement<8usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 4.529303941850484f64,
    c1: 0.37648622085811195f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        0.001064650843716541f64,
        -0.009302604913129777f64,
        0f64,
        -0.00015707963267948965f64,
    ],
    theta0: [
        1.2796754075622423f64,
        0.42970006184100396f64,
        4.9549897464119015f64,
        6.2098814785958245f64,
        2.092649773141201f64,
        4.010766621082969f64,
        6.147922290150026f64,
        1.9783307071355725f64,
    ],
    theta1: [
        1596.503281347521f64,
        787.7927551311844f64,
        84.66068602648895f64,
        20.792107379008446f64,
        4.574507969477138f64,
        1.1222467090323538f64,
        41.58421475801689f64,
        105.9414855960558f64,
    ],
};
impl RotationalElements for Callisto {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_CALLISTO.angle(t),
            DECLINATION_CALLISTO.angle(t),
            ROTATION_CALLISTO.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_CALLISTO.angle_dot(t),
            DECLINATION_CALLISTO.angle_dot(t),
            ROTATION_CALLISTO.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Amalthea;
impl Origin for Amalthea {
    fn id(&self) -> NaifId {
        NaifId(505i32)
    }
    fn name(&self) -> &'static str {
        "Amalthea"
    }
}
impl Display for Amalthea {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Amalthea {
    fn gravitational_parameter(&self) -> f64 {
        0.1645634534798259f64
    }
}
impl MeanRadius for Amalthea {
    fn mean_radius(&self) -> f64 {
        83.5f64
    }
}
impl TriaxialEllipsoid for Amalthea {
    fn radii(&self) -> Radii {
        (125f64, 73f64, 64f64)
    }
}
const RIGHT_ASCENSION_AMALTHEA: RotationalElement<10usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 4.678355059970801f64,
    c1: -0.00015707963267948965f64,
    c2: 0f64,
    c: [
        -0.014660765716752368f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0.00017453292519943296f64,
        0f64,
    ],
    theta0: [
        1.2796754075622423f64,
        0.42970006184100396f64,
        4.9549897464119015f64,
        6.2098814785958245f64,
        2.092649773141201f64,
        4.010766621082969f64,
        6.147922290150026f64,
        1.9783307071355725f64,
        2.5593508151244846f64,
        0.8594001236820079f64,
    ],
    theta1: [
        1596.503281347521f64,
        787.7927551311844f64,
        84.66068602648895f64,
        20.792107379008446f64,
        4.574507969477138f64,
        1.1222467090323538f64,
        41.58421475801689f64,
        105.9414855960558f64,
        3193.006562695042f64,
        1575.5855102623689f64,
    ],
};
const DECLINATION_AMALTHEA: RotationalElement<10usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: 1.125562834611143f64,
    c1: 0.00005235987755982989f64,
    c2: 0f64,
    c: [
        -0.006283185307179586f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        1.2796754075622423f64,
        0.42970006184100396f64,
        4.9549897464119015f64,
        6.2098814785958245f64,
        2.092649773141201f64,
        4.010766621082969f64,
        6.147922290150026f64,
        1.9783307071355725f64,
        2.5593508151244846f64,
        0.8594001236820079f64,
    ],
    theta1: [
        1596.503281347521f64,
        787.7927551311844f64,
        84.66068602648895f64,
        20.792107379008446f64,
        4.574507969477138f64,
        1.1222467090323538f64,
        41.58421475801689f64,
        105.9414855960558f64,
        3193.006562695042f64,
        1575.5855102623689f64,
    ],
};
const ROTATION_AMALTHEA: RotationalElement<10usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 4.043404278095263f64,
    c1: 12.612298185680531f64,
    c2: 0f64,
    c: [
        0.013264502315156905f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        -0.00017453292519943296f64,
        0f64,
    ],
    theta0: [
        1.2796754075622423f64,
        0.42970006184100396f64,
        4.9549897464119015f64,
        6.2098814785958245f64,
        2.092649773141201f64,
        4.010766621082969f64,
        6.147922290150026f64,
        1.9783307071355725f64,
        2.5593508151244846f64,
        0.8594001236820079f64,
    ],
    theta1: [
        1596.503281347521f64,
        787.7927551311844f64,
        84.66068602648895f64,
        20.792107379008446f64,
        4.574507969477138f64,
        1.1222467090323538f64,
        41.58421475801689f64,
        105.9414855960558f64,
        3193.006562695042f64,
        1575.5855102623689f64,
    ],
};
impl RotationalElements for Amalthea {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_AMALTHEA.angle(t),
            DECLINATION_AMALTHEA.angle(t),
            ROTATION_AMALTHEA.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_AMALTHEA.angle_dot(t),
            DECLINATION_AMALTHEA.angle_dot(t),
            ROTATION_AMALTHEA.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Himalia;
impl Origin for Himalia {
    fn id(&self) -> NaifId {
        NaifId(506i32)
    }
    fn name(&self) -> &'static str {
        "Himalia"
    }
}
impl Display for Himalia {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Himalia {
    fn gravitational_parameter(&self) -> f64 {
        0.1515524299611265f64
    }
}
impl MeanRadius for Himalia {
    fn mean_radius(&self) -> f64 {
        85f64
    }
}
impl TriaxialEllipsoid for Himalia {
    fn radii(&self) -> Radii {
        (85f64, 85f64, 85f64)
    }
}
impl Spheroid for Himalia {}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Elara;
impl Origin for Elara {
    fn id(&self) -> NaifId {
        NaifId(507i32)
    }
    fn name(&self) -> &'static str {
        "Elara"
    }
}
impl Display for Elara {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl MeanRadius for Elara {
    fn mean_radius(&self) -> f64 {
        40f64
    }
}
impl TriaxialEllipsoid for Elara {
    fn radii(&self) -> Radii {
        (40f64, 40f64, 40f64)
    }
}
impl Spheroid for Elara {}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Pasiphae;
impl Origin for Pasiphae {
    fn id(&self) -> NaifId {
        NaifId(508i32)
    }
    fn name(&self) -> &'static str {
        "Pasiphae"
    }
}
impl Display for Pasiphae {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl MeanRadius for Pasiphae {
    fn mean_radius(&self) -> f64 {
        18f64
    }
}
impl TriaxialEllipsoid for Pasiphae {
    fn radii(&self) -> Radii {
        (18f64, 18f64, 18f64)
    }
}
impl Spheroid for Pasiphae {}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Sinope;
impl Origin for Sinope {
    fn id(&self) -> NaifId {
        NaifId(509i32)
    }
    fn name(&self) -> &'static str {
        "Sinope"
    }
}
impl Display for Sinope {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl MeanRadius for Sinope {
    fn mean_radius(&self) -> f64 {
        14f64
    }
}
impl TriaxialEllipsoid for Sinope {
    fn radii(&self) -> Radii {
        (14f64, 14f64, 14f64)
    }
}
impl Spheroid for Sinope {}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Lysithea;
impl Origin for Lysithea {
    fn id(&self) -> NaifId {
        NaifId(510i32)
    }
    fn name(&self) -> &'static str {
        "Lysithea"
    }
}
impl Display for Lysithea {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl MeanRadius for Lysithea {
    fn mean_radius(&self) -> f64 {
        12f64
    }
}
impl TriaxialEllipsoid for Lysithea {
    fn radii(&self) -> Radii {
        (12f64, 12f64, 12f64)
    }
}
impl Spheroid for Lysithea {}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Carme;
impl Origin for Carme {
    fn id(&self) -> NaifId {
        NaifId(511i32)
    }
    fn name(&self) -> &'static str {
        "Carme"
    }
}
impl Display for Carme {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl MeanRadius for Carme {
    fn mean_radius(&self) -> f64 {
        15f64
    }
}
impl TriaxialEllipsoid for Carme {
    fn radii(&self) -> Radii {
        (15f64, 15f64, 15f64)
    }
}
impl Spheroid for Carme {}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Ananke;
impl Origin for Ananke {
    fn id(&self) -> NaifId {
        NaifId(512i32)
    }
    fn name(&self) -> &'static str {
        "Ananke"
    }
}
impl Display for Ananke {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl MeanRadius for Ananke {
    fn mean_radius(&self) -> f64 {
        10f64
    }
}
impl TriaxialEllipsoid for Ananke {
    fn radii(&self) -> Radii {
        (10f64, 10f64, 10f64)
    }
}
impl Spheroid for Ananke {}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Leda;
impl Origin for Leda {
    fn id(&self) -> NaifId {
        NaifId(513i32)
    }
    fn name(&self) -> &'static str {
        "Leda"
    }
}
impl Display for Leda {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl MeanRadius for Leda {
    fn mean_radius(&self) -> f64 {
        5f64
    }
}
impl TriaxialEllipsoid for Leda {
    fn radii(&self) -> Radii {
        (5f64, 5f64, 5f64)
    }
}
impl Spheroid for Leda {}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Thebe;
impl Origin for Thebe {
    fn id(&self) -> NaifId {
        NaifId(514i32)
    }
    fn name(&self) -> &'static str {
        "Thebe"
    }
}
impl Display for Thebe {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Thebe {
    fn gravitational_parameter(&self) -> f64 {
        0.030148f64
    }
}
impl MeanRadius for Thebe {
    fn mean_radius(&self) -> f64 {
        49.3f64
    }
}
impl TriaxialEllipsoid for Thebe {
    fn radii(&self) -> Radii {
        (58f64, 49f64, 42f64)
    }
}
const RIGHT_ASCENSION_THEBE: RotationalElement<10usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 4.678355059970801f64,
    c1: -0.00015707963267948965f64,
    c2: 0f64,
    c: [
        0f64,
        -0.03682644721708035f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0.0006981317007977319f64,
    ],
    theta0: [
        1.2796754075622423f64,
        0.42970006184100396f64,
        4.9549897464119015f64,
        6.2098814785958245f64,
        2.092649773141201f64,
        4.010766621082969f64,
        6.147922290150026f64,
        1.9783307071355725f64,
        2.5593508151244846f64,
        0.8594001236820079f64,
    ],
    theta1: [
        1596.503281347521f64,
        787.7927551311844f64,
        84.66068602648895f64,
        20.792107379008446f64,
        4.574507969477138f64,
        1.1222467090323538f64,
        41.58421475801689f64,
        105.9414855960558f64,
        3193.006562695042f64,
        1575.5855102623689f64,
    ],
};
const DECLINATION_THEBE: RotationalElement<10usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: 1.125562834611143f64,
    c1: 0.00005235987755982989f64,
    c2: 0f64,
    c: [
        0f64,
        -0.0158824961931484f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0.00017453292519943296f64,
    ],
    theta0: [
        1.2796754075622423f64,
        0.42970006184100396f64,
        4.9549897464119015f64,
        6.2098814785958245f64,
        2.092649773141201f64,
        4.010766621082969f64,
        6.147922290150026f64,
        1.9783307071355725f64,
        2.5593508151244846f64,
        0.8594001236820079f64,
    ],
    theta1: [
        1596.503281347521f64,
        787.7927551311844f64,
        84.66068602648895f64,
        20.792107379008446f64,
        4.574507969477138f64,
        1.1222467090323538f64,
        41.58421475801689f64,
        105.9414855960558f64,
        3193.006562695042f64,
        1575.5855102623689f64,
    ],
};
const ROTATION_THEBE: RotationalElement<10usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 0.1494001839707146f64,
    c1: 9.31482937374367f64,
    c2: 0f64,
    c: [
        0f64,
        0.033335788713091695f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        -0.0006981317007977319f64,
    ],
    theta0: [
        1.2796754075622423f64,
        0.42970006184100396f64,
        4.9549897464119015f64,
        6.2098814785958245f64,
        2.092649773141201f64,
        4.010766621082969f64,
        6.147922290150026f64,
        1.9783307071355725f64,
        2.5593508151244846f64,
        0.8594001236820079f64,
    ],
    theta1: [
        1596.503281347521f64,
        787.7927551311844f64,
        84.66068602648895f64,
        20.792107379008446f64,
        4.574507969477138f64,
        1.1222467090323538f64,
        41.58421475801689f64,
        105.9414855960558f64,
        3193.006562695042f64,
        1575.5855102623689f64,
    ],
};
impl RotationalElements for Thebe {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_THEBE.angle(t),
            DECLINATION_THEBE.angle(t),
            ROTATION_THEBE.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_THEBE.angle_dot(t),
            DECLINATION_THEBE.angle_dot(t),
            ROTATION_THEBE.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Adrastea;
impl Origin for Adrastea {
    fn id(&self) -> NaifId {
        NaifId(515i32)
    }
    fn name(&self) -> &'static str {
        "Adrastea"
    }
}
impl Display for Adrastea {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Adrastea {
    fn gravitational_parameter(&self) -> f64 {
        0.000139f64
    }
}
impl MeanRadius for Adrastea {
    fn mean_radius(&self) -> f64 {
        8.2f64
    }
}
impl TriaxialEllipsoid for Adrastea {
    fn radii(&self) -> Radii {
        (10f64, 8f64, 7f64)
    }
}
const RIGHT_ASCENSION_ADRASTEA: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 4.678355059970801f64,
    c1: -0.00015707963267948965f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const DECLINATION_ADRASTEA: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: 1.125562834611143f64,
    c1: 0.00005235987755982989f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const ROTATION_ADRASTEA: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 0.5810201079889122f64,
    c1: 21.066100687650238f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
impl RotationalElements for Adrastea {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_ADRASTEA.angle(t),
            DECLINATION_ADRASTEA.angle(t),
            ROTATION_ADRASTEA.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_ADRASTEA.angle_dot(t),
            DECLINATION_ADRASTEA.angle_dot(t),
            ROTATION_ADRASTEA.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Metis;
impl Origin for Metis {
    fn id(&self) -> NaifId {
        NaifId(516i32)
    }
    fn name(&self) -> &'static str {
        "Metis"
    }
}
impl Display for Metis {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Metis {
    fn gravitational_parameter(&self) -> f64 {
        0.002501f64
    }
}
impl MeanRadius for Metis {
    fn mean_radius(&self) -> f64 {
        21.5f64
    }
}
impl TriaxialEllipsoid for Metis {
    fn radii(&self) -> Radii {
        (30f64, 20f64, 17f64)
    }
}
const RIGHT_ASCENSION_METIS: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 4.678355059970801f64,
    c1: -0.00015707963267948965f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const DECLINATION_METIS: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: 1.125562834611143f64,
    c1: 0.00005235987755982989f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const ROTATION_METIS: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 6.040410008227175f64,
    c1: 21.3149160457997f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
impl RotationalElements for Metis {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_METIS.angle(t),
            DECLINATION_METIS.angle(t),
            ROTATION_METIS.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_METIS.angle_dot(t),
            DECLINATION_METIS.angle_dot(t),
            ROTATION_METIS.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Callirrhoe;
impl Origin for Callirrhoe {
    fn id(&self) -> NaifId {
        NaifId(517i32)
    }
    fn name(&self) -> &'static str {
        "Callirrhoe"
    }
}
impl Display for Callirrhoe {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Themisto;
impl Origin for Themisto {
    fn id(&self) -> NaifId {
        NaifId(518i32)
    }
    fn name(&self) -> &'static str {
        "Themisto"
    }
}
impl Display for Themisto {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Magaclite;
impl Origin for Magaclite {
    fn id(&self) -> NaifId {
        NaifId(519i32)
    }
    fn name(&self) -> &'static str {
        "Magaclite"
    }
}
impl Display for Magaclite {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Taygete;
impl Origin for Taygete {
    fn id(&self) -> NaifId {
        NaifId(520i32)
    }
    fn name(&self) -> &'static str {
        "Taygete"
    }
}
impl Display for Taygete {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Chaldene;
impl Origin for Chaldene {
    fn id(&self) -> NaifId {
        NaifId(521i32)
    }
    fn name(&self) -> &'static str {
        "Chaldene"
    }
}
impl Display for Chaldene {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Harpalyke;
impl Origin for Harpalyke {
    fn id(&self) -> NaifId {
        NaifId(522i32)
    }
    fn name(&self) -> &'static str {
        "Harpalyke"
    }
}
impl Display for Harpalyke {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Kalyke;
impl Origin for Kalyke {
    fn id(&self) -> NaifId {
        NaifId(523i32)
    }
    fn name(&self) -> &'static str {
        "Kalyke"
    }
}
impl Display for Kalyke {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Iocaste;
impl Origin for Iocaste {
    fn id(&self) -> NaifId {
        NaifId(524i32)
    }
    fn name(&self) -> &'static str {
        "Iocaste"
    }
}
impl Display for Iocaste {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Erinome;
impl Origin for Erinome {
    fn id(&self) -> NaifId {
        NaifId(525i32)
    }
    fn name(&self) -> &'static str {
        "Erinome"
    }
}
impl Display for Erinome {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Isonoe;
impl Origin for Isonoe {
    fn id(&self) -> NaifId {
        NaifId(526i32)
    }
    fn name(&self) -> &'static str {
        "Isonoe"
    }
}
impl Display for Isonoe {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Praxidike;
impl Origin for Praxidike {
    fn id(&self) -> NaifId {
        NaifId(527i32)
    }
    fn name(&self) -> &'static str {
        "Praxidike"
    }
}
impl Display for Praxidike {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Autonoe;
impl Origin for Autonoe {
    fn id(&self) -> NaifId {
        NaifId(528i32)
    }
    fn name(&self) -> &'static str {
        "Autonoe"
    }
}
impl Display for Autonoe {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Thyone;
impl Origin for Thyone {
    fn id(&self) -> NaifId {
        NaifId(529i32)
    }
    fn name(&self) -> &'static str {
        "Thyone"
    }
}
impl Display for Thyone {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Hermippe;
impl Origin for Hermippe {
    fn id(&self) -> NaifId {
        NaifId(530i32)
    }
    fn name(&self) -> &'static str {
        "Hermippe"
    }
}
impl Display for Hermippe {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Aitne;
impl Origin for Aitne {
    fn id(&self) -> NaifId {
        NaifId(531i32)
    }
    fn name(&self) -> &'static str {
        "Aitne"
    }
}
impl Display for Aitne {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Eurydome;
impl Origin for Eurydome {
    fn id(&self) -> NaifId {
        NaifId(532i32)
    }
    fn name(&self) -> &'static str {
        "Eurydome"
    }
}
impl Display for Eurydome {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Euanthe;
impl Origin for Euanthe {
    fn id(&self) -> NaifId {
        NaifId(533i32)
    }
    fn name(&self) -> &'static str {
        "Euanthe"
    }
}
impl Display for Euanthe {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Euporie;
impl Origin for Euporie {
    fn id(&self) -> NaifId {
        NaifId(534i32)
    }
    fn name(&self) -> &'static str {
        "Euporie"
    }
}
impl Display for Euporie {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Orthosie;
impl Origin for Orthosie {
    fn id(&self) -> NaifId {
        NaifId(535i32)
    }
    fn name(&self) -> &'static str {
        "Orthosie"
    }
}
impl Display for Orthosie {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Sponde;
impl Origin for Sponde {
    fn id(&self) -> NaifId {
        NaifId(536i32)
    }
    fn name(&self) -> &'static str {
        "Sponde"
    }
}
impl Display for Sponde {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Kale;
impl Origin for Kale {
    fn id(&self) -> NaifId {
        NaifId(537i32)
    }
    fn name(&self) -> &'static str {
        "Kale"
    }
}
impl Display for Kale {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Pasithee;
impl Origin for Pasithee {
    fn id(&self) -> NaifId {
        NaifId(538i32)
    }
    fn name(&self) -> &'static str {
        "Pasithee"
    }
}
impl Display for Pasithee {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Hegemone;
impl Origin for Hegemone {
    fn id(&self) -> NaifId {
        NaifId(539i32)
    }
    fn name(&self) -> &'static str {
        "Hegemone"
    }
}
impl Display for Hegemone {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Mneme;
impl Origin for Mneme {
    fn id(&self) -> NaifId {
        NaifId(540i32)
    }
    fn name(&self) -> &'static str {
        "Mneme"
    }
}
impl Display for Mneme {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Aoede;
impl Origin for Aoede {
    fn id(&self) -> NaifId {
        NaifId(541i32)
    }
    fn name(&self) -> &'static str {
        "Aoede"
    }
}
impl Display for Aoede {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Thelxinoe;
impl Origin for Thelxinoe {
    fn id(&self) -> NaifId {
        NaifId(542i32)
    }
    fn name(&self) -> &'static str {
        "Thelxinoe"
    }
}
impl Display for Thelxinoe {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Arche;
impl Origin for Arche {
    fn id(&self) -> NaifId {
        NaifId(543i32)
    }
    fn name(&self) -> &'static str {
        "Arche"
    }
}
impl Display for Arche {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Kallichore;
impl Origin for Kallichore {
    fn id(&self) -> NaifId {
        NaifId(544i32)
    }
    fn name(&self) -> &'static str {
        "Kallichore"
    }
}
impl Display for Kallichore {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Helike;
impl Origin for Helike {
    fn id(&self) -> NaifId {
        NaifId(545i32)
    }
    fn name(&self) -> &'static str {
        "Helike"
    }
}
impl Display for Helike {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Carpo;
impl Origin for Carpo {
    fn id(&self) -> NaifId {
        NaifId(546i32)
    }
    fn name(&self) -> &'static str {
        "Carpo"
    }
}
impl Display for Carpo {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Eukelade;
impl Origin for Eukelade {
    fn id(&self) -> NaifId {
        NaifId(547i32)
    }
    fn name(&self) -> &'static str {
        "Eukelade"
    }
}
impl Display for Eukelade {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Cyllene;
impl Origin for Cyllene {
    fn id(&self) -> NaifId {
        NaifId(548i32)
    }
    fn name(&self) -> &'static str {
        "Cyllene"
    }
}
impl Display for Cyllene {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Kore;
impl Origin for Kore {
    fn id(&self) -> NaifId {
        NaifId(549i32)
    }
    fn name(&self) -> &'static str {
        "Kore"
    }
}
impl Display for Kore {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Herse;
impl Origin for Herse {
    fn id(&self) -> NaifId {
        NaifId(550i32)
    }
    fn name(&self) -> &'static str {
        "Herse"
    }
}
impl Display for Herse {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Dia;
impl Origin for Dia {
    fn id(&self) -> NaifId {
        NaifId(553i32)
    }
    fn name(&self) -> &'static str {
        "Dia"
    }
}
impl Display for Dia {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Mimas;
impl Origin for Mimas {
    fn id(&self) -> NaifId {
        NaifId(601i32)
    }
    fn name(&self) -> &'static str {
        "Mimas"
    }
}
impl Display for Mimas {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Mimas {
    fn gravitational_parameter(&self) -> f64 {
        2.503488768152587f64
    }
}
impl MeanRadius for Mimas {
    fn mean_radius(&self) -> f64 {
        198.2f64
    }
}
impl TriaxialEllipsoid for Mimas {
    fn radii(&self) -> Radii {
        (207.8f64, 196.7f64, 190.6f64)
    }
}
const RIGHT_ASCENSION_MIMAS: RotationalElement<8usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 0.7096508738608943f64,
    c1: -0.0006283185307179586f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0.2366666465704311f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        6.166597313146365f64,
        0.5012585611727715f64,
        3.0962140930379407f64,
        5.235987755982989f64,
        5.523094417936056f64,
        6.0248765778844255f64,
        12.33319462629273f64,
        1.002517122345543f64,
    ],
    theta1: [
        1321.331180819591f64,
        1321.331180819591f64,
        -637.14117008679f64,
        -126.11574641985825f64,
        8.834856673595295f64,
        -17.73778118801837f64,
        2642.662361639182f64,
        2642.662361639182f64,
    ],
};
const DECLINATION_MIMAS: RotationalElement<8usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: 1.457698991265664f64,
    c1: -0.00006981317007977319f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        -0.026703537555513242f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        6.166597313146365f64,
        0.5012585611727715f64,
        3.0962140930379407f64,
        5.235987755982989f64,
        5.523094417936056f64,
        6.0248765778844255f64,
        12.33319462629273f64,
        1.002517122345543f64,
    ],
    theta1: [
        1321.331180819591f64,
        1321.331180819591f64,
        -637.14117008679f64,
        -126.11574641985825f64,
        8.834856673595295f64,
        -17.73778118801837f64,
        2642.662361639182f64,
        2642.662361639182f64,
    ],
};
const ROTATION_MIMAS: RotationalElement<8usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 5.819974923700291f64,
    c1: 6.667062709440567f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        -0.23527038316883564f64,
        0f64,
        -0.7827801695194568f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        6.166597313146365f64,
        0.5012585611727715f64,
        3.0962140930379407f64,
        5.235987755982989f64,
        5.523094417936056f64,
        6.0248765778844255f64,
        12.33319462629273f64,
        1.002517122345543f64,
    ],
    theta1: [
        1321.331180819591f64,
        1321.331180819591f64,
        -637.14117008679f64,
        -126.11574641985825f64,
        8.834856673595295f64,
        -17.73778118801837f64,
        2642.662361639182f64,
        2642.662361639182f64,
    ],
};
impl RotationalElements for Mimas {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_MIMAS.angle(t),
            DECLINATION_MIMAS.angle(t),
            ROTATION_MIMAS.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_MIMAS.angle_dot(t),
            DECLINATION_MIMAS.angle_dot(t),
            ROTATION_MIMAS.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Enceladus;
impl Origin for Enceladus {
    fn id(&self) -> NaifId {
        NaifId(602i32)
    }
    fn name(&self) -> &'static str {
        "Enceladus"
    }
}
impl Display for Enceladus {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Enceladus {
    fn gravitational_parameter(&self) -> f64 {
        7.210366688598896f64
    }
}
impl MeanRadius for Enceladus {
    fn mean_radius(&self) -> f64 {
        252.1f64
    }
}
impl TriaxialEllipsoid for Enceladus {
    fn radii(&self) -> Radii {
        (256.6f64, 251.4f64, 248.3f64)
    }
}
const RIGHT_ASCENSION_ENCELADUS: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 0.7096508738608943f64,
    c1: -0.0006283185307179586f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const DECLINATION_ENCELADUS: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: 1.457698991265664f64,
    c1: -0.00006981317007977319f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const ROTATION_ENCELADUS: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 0.11030480872604163f64,
    c1: 4.585536698039173f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
impl RotationalElements for Enceladus {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_ENCELADUS.angle(t),
            DECLINATION_ENCELADUS.angle(t),
            ROTATION_ENCELADUS.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_ENCELADUS.angle_dot(t),
            DECLINATION_ENCELADUS.angle_dot(t),
            ROTATION_ENCELADUS.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Tethys;
impl Origin for Tethys {
    fn id(&self) -> NaifId {
        NaifId(603i32)
    }
    fn name(&self) -> &'static str {
        "Tethys"
    }
}
impl Display for Tethys {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Tethys {
    fn gravitational_parameter(&self) -> f64 {
        41.21352885489587f64
    }
}
impl MeanRadius for Tethys {
    fn mean_radius(&self) -> f64 {
        531f64
    }
}
impl TriaxialEllipsoid for Tethys {
    fn radii(&self) -> Radii {
        (538.4f64, 528.3f64, 526.3f64)
    }
}
const RIGHT_ASCENSION_TETHYS: RotationalElement<8usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 0.7096508738608943f64,
    c1: -0.0006283185307179586f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0.16859880574265224f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        6.166597313146365f64,
        0.5012585611727715f64,
        3.0962140930379407f64,
        5.235987755982989f64,
        5.523094417936056f64,
        6.0248765778844255f64,
        12.33319462629273f64,
        1.002517122345543f64,
    ],
    theta1: [
        1321.331180819591f64,
        1321.331180819591f64,
        -637.14117008679f64,
        -126.11574641985825f64,
        8.834856673595295f64,
        -17.73778118801837f64,
        2642.662361639182f64,
        2642.662361639182f64,
    ],
};
const DECLINATION_TETHYS: RotationalElement<8usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: 1.457698991265664f64,
    c1: -0.00006981317007977319f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        -0.019024088846738195f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        6.166597313146365f64,
        0.5012585611727715f64,
        3.0962140930379407f64,
        5.235987755982989f64,
        5.523094417936056f64,
        6.0248765778844255f64,
        12.33319462629273f64,
        1.002517122345543f64,
    ],
    theta1: [
        1321.331180819591f64,
        1321.331180819591f64,
        -637.14117008679f64,
        -126.11574641985825f64,
        8.834856673595295f64,
        -17.73778118801837f64,
        2642.662361639182f64,
        2642.662361639182f64,
    ],
};
const ROTATION_TETHYS: RotationalElement<8usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 0.1562069680534925f64,
    c1: 3.328306379991881f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        -0.16755160819145562f64,
        0.03892084231947355f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        6.166597313146365f64,
        0.5012585611727715f64,
        3.0962140930379407f64,
        5.235987755982989f64,
        5.523094417936056f64,
        6.0248765778844255f64,
        12.33319462629273f64,
        1.002517122345543f64,
    ],
    theta1: [
        1321.331180819591f64,
        1321.331180819591f64,
        -637.14117008679f64,
        -126.11574641985825f64,
        8.834856673595295f64,
        -17.73778118801837f64,
        2642.662361639182f64,
        2642.662361639182f64,
    ],
};
impl RotationalElements for Tethys {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_TETHYS.angle(t),
            DECLINATION_TETHYS.angle(t),
            ROTATION_TETHYS.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_TETHYS.angle_dot(t),
            DECLINATION_TETHYS.angle_dot(t),
            ROTATION_TETHYS.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Dione;
impl Origin for Dione {
    fn id(&self) -> NaifId {
        NaifId(604i32)
    }
    fn name(&self) -> &'static str {
        "Dione"
    }
}
impl Display for Dione {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Dione {
    fn gravitational_parameter(&self) -> f64 {
        73.11607172482067f64
    }
}
impl MeanRadius for Dione {
    fn mean_radius(&self) -> f64 {
        561.4f64
    }
}
impl TriaxialEllipsoid for Dione {
    fn radii(&self) -> Radii {
        (563.4f64, 561.3f64, 559.6f64)
    }
}
const RIGHT_ASCENSION_DIONE: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 0.7096508738608943f64,
    c1: -0.0006283185307179586f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const DECLINATION_DIONE: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: 1.457698991265664f64,
    c1: -0.00006981317007977319f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const ROTATION_DIONE: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 6.241297405131723f64,
    c1: 2.295717637805533f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
impl RotationalElements for Dione {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_DIONE.angle(t),
            DECLINATION_DIONE.angle(t),
            ROTATION_DIONE.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_DIONE.angle_dot(t),
            DECLINATION_DIONE.angle_dot(t),
            ROTATION_DIONE.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Rhea;
impl Origin for Rhea {
    fn id(&self) -> NaifId {
        NaifId(605i32)
    }
    fn name(&self) -> &'static str {
        "Rhea"
    }
}
impl Display for Rhea {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Rhea {
    fn gravitational_parameter(&self) -> f64 {
        153.9417519146563f64
    }
}
impl MeanRadius for Rhea {
    fn mean_radius(&self) -> f64 {
        763.5f64
    }
}
impl TriaxialEllipsoid for Rhea {
    fn radii(&self) -> Radii {
        (765f64, 763.1f64, 762.4f64)
    }
}
const RIGHT_ASCENSION_RHEA: RotationalElement<8usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 0.7047639519553103f64,
    c1: -0.0006283185307179586f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0.054105206811824215f64,
        0f64,
        0f64,
    ],
    theta0: [
        6.166597313146365f64,
        0.5012585611727715f64,
        3.0962140930379407f64,
        5.235987755982989f64,
        5.523094417936056f64,
        6.0248765778844255f64,
        12.33319462629273f64,
        1.002517122345543f64,
    ],
    theta1: [
        1321.331180819591f64,
        1321.331180819591f64,
        -637.14117008679f64,
        -126.11574641985825f64,
        8.834856673595295f64,
        -17.73778118801837f64,
        2642.662361639182f64,
        2642.662361639182f64,
    ],
};
const DECLINATION_RHEA: RotationalElement<8usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: 1.4582225900412622f64,
    c1: -0.00006981317007977319f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        -0.006108652381980153f64,
        0f64,
        0f64,
    ],
    theta0: [
        6.166597313146365f64,
        0.5012585611727715f64,
        3.0962140930379407f64,
        5.235987755982989f64,
        5.523094417936056f64,
        6.0248765778844255f64,
        12.33319462629273f64,
        1.002517122345543f64,
    ],
    theta1: [
        1321.331180819591f64,
        1321.331180819591f64,
        -637.14117008679f64,
        -126.11574641985825f64,
        8.834856673595295f64,
        -17.73778118801837f64,
        2642.662361639182f64,
        2642.662361639182f64,
    ],
};
const ROTATION_RHEA: RotationalElement<8usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 4.104316268989865f64,
    c1: 1.3908537151816638f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        -0.05375614096142535f64,
        0f64,
        0f64,
    ],
    theta0: [
        6.166597313146365f64,
        0.5012585611727715f64,
        3.0962140930379407f64,
        5.235987755982989f64,
        5.523094417936056f64,
        6.0248765778844255f64,
        12.33319462629273f64,
        1.002517122345543f64,
    ],
    theta1: [
        1321.331180819591f64,
        1321.331180819591f64,
        -637.14117008679f64,
        -126.11574641985825f64,
        8.834856673595295f64,
        -17.73778118801837f64,
        2642.662361639182f64,
        2642.662361639182f64,
    ],
};
impl RotationalElements for Rhea {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_RHEA.angle(t),
            DECLINATION_RHEA.angle(t),
            ROTATION_RHEA.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_RHEA.angle_dot(t),
            DECLINATION_RHEA.angle_dot(t),
            ROTATION_RHEA.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Titan;
impl Origin for Titan {
    fn id(&self) -> NaifId {
        NaifId(606i32)
    }
    fn name(&self) -> &'static str {
        "Titan"
    }
}
impl Display for Titan {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Titan {
    fn gravitational_parameter(&self) -> f64 {
        8978.137095521046f64
    }
}
impl MeanRadius for Titan {
    fn mean_radius(&self) -> f64 {
        2575f64
    }
}
impl TriaxialEllipsoid for Titan {
    fn radii(&self) -> Radii {
        (2575.15f64, 2574.78f64, 2574.47f64)
    }
}
const RIGHT_ASCENSION_TITAN: RotationalElement<8usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 0.6891031125771652f64,
    c1: 0f64,
    c2: 0f64,
    c: [0f64, 0f64, 0f64, 0f64, 0f64, 0f64, 0f64, 0f64],
    theta0: [
        6.166597313146365f64,
        0.5012585611727715f64,
        3.0962140930379407f64,
        5.235987755982989f64,
        5.523094417936056f64,
        6.0248765778844255f64,
        12.33319462629273f64,
        1.002517122345543f64,
    ],
    theta1: [
        1321.331180819591f64,
        1321.331180819591f64,
        -637.14117008679f64,
        -126.11574641985825f64,
        8.834856673595295f64,
        -17.73778118801837f64,
        2642.662361639182f64,
        2642.662361639182f64,
    ],
};
const DECLINATION_TITAN: RotationalElement<8usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: 1.456091543024577f64,
    c1: 0f64,
    c2: 0f64,
    c: [0f64, 0f64, 0f64, 0f64, 0f64, 0f64, 0f64, 0f64],
    theta0: [
        6.166597313146365f64,
        0.5012585611727715f64,
        3.0962140930379407f64,
        5.235987755982989f64,
        5.523094417936056f64,
        6.0248765778844255f64,
        12.33319462629273f64,
        1.002517122345543f64,
    ],
    theta1: [
        1321.331180819591f64,
        1321.331180819591f64,
        -637.14117008679f64,
        -126.11574641985825f64,
        8.834856673595295f64,
        -17.73778118801837f64,
        2642.662361639182f64,
        2642.662361639182f64,
    ],
};
const ROTATION_TITAN: RotationalElement<8usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 3.2565313114798795f64,
    c1: 0.39404258030637335f64,
    c2: 0f64,
    c: [0f64, 0f64, 0f64, 0f64, 0f64, 0f64, 0f64, 0f64],
    theta0: [
        6.166597313146365f64,
        0.5012585611727715f64,
        3.0962140930379407f64,
        5.235987755982989f64,
        5.523094417936056f64,
        6.0248765778844255f64,
        12.33319462629273f64,
        1.002517122345543f64,
    ],
    theta1: [
        1321.331180819591f64,
        1321.331180819591f64,
        -637.14117008679f64,
        -126.11574641985825f64,
        8.834856673595295f64,
        -17.73778118801837f64,
        2642.662361639182f64,
        2642.662361639182f64,
    ],
};
impl RotationalElements for Titan {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_TITAN.angle(t),
            DECLINATION_TITAN.angle(t),
            ROTATION_TITAN.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_TITAN.angle_dot(t),
            DECLINATION_TITAN.angle_dot(t),
            ROTATION_TITAN.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Hyperion;
impl Origin for Hyperion {
    fn id(&self) -> NaifId {
        NaifId(607i32)
    }
    fn name(&self) -> &'static str {
        "Hyperion"
    }
}
impl Display for Hyperion {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Hyperion {
    fn gravitational_parameter(&self) -> f64 {
        0.3704913747932265f64
    }
}
impl MeanRadius for Hyperion {
    fn mean_radius(&self) -> f64 {
        135f64
    }
}
impl TriaxialEllipsoid for Hyperion {
    fn radii(&self) -> Radii {
        (180.1f64, 133f64, 102.7f64)
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Iapetus;
impl Origin for Iapetus {
    fn id(&self) -> NaifId {
        NaifId(608i32)
    }
    fn name(&self) -> &'static str {
        "Iapetus"
    }
}
impl Display for Iapetus {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Iapetus {
    fn gravitational_parameter(&self) -> f64 {
        120.5151060137642f64
    }
}
impl MeanRadius for Iapetus {
    fn mean_radius(&self) -> f64 {
        734.3f64
    }
}
impl TriaxialEllipsoid for Iapetus {
    fn radii(&self) -> Radii {
        (745.7f64, 745.7f64, 712.1f64)
    }
}
impl Spheroid for Iapetus {}
const RIGHT_ASCENSION_IAPETUS: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 5.552939548145159f64,
    c1: -0.06892305216125608f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const DECLINATION_IAPETUS: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: 1.3095205377713455f64,
    c1: -0.019949113350295186f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const ROTATION_IAPETUS: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 6.199409503083858f64,
    c1: 0.07920229445458282f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
impl RotationalElements for Iapetus {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_IAPETUS.angle(t),
            DECLINATION_IAPETUS.angle(t),
            ROTATION_IAPETUS.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_IAPETUS.angle_dot(t),
            DECLINATION_IAPETUS.angle_dot(t),
            ROTATION_IAPETUS.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Phoebe;
impl Origin for Phoebe {
    fn id(&self) -> NaifId {
        NaifId(609i32)
    }
    fn name(&self) -> &'static str {
        "Phoebe"
    }
}
impl Display for Phoebe {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Phoebe {
    fn gravitational_parameter(&self) -> f64 {
        0.5547860052791678f64
    }
}
impl MeanRadius for Phoebe {
    fn mean_radius(&self) -> f64 {
        106.5f64
    }
}
impl TriaxialEllipsoid for Phoebe {
    fn radii(&self) -> Radii {
        (109.4f64, 108.5f64, 101.8f64)
    }
}
const RIGHT_ASCENSION_PHOEBE: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 6.229080100367762f64,
    c1: 0f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const DECLINATION_PHOEBE: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: 1.3578661580515883f64,
    c1: 0f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const ROTATION_PHOEBE: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 3.116808978211474f64,
    c1: 16.26016798998745f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
impl RotationalElements for Phoebe {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_PHOEBE.angle(t),
            DECLINATION_PHOEBE.angle(t),
            ROTATION_PHOEBE.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_PHOEBE.angle_dot(t),
            DECLINATION_PHOEBE.angle_dot(t),
            ROTATION_PHOEBE.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Janus;
impl Origin for Janus {
    fn id(&self) -> NaifId {
        NaifId(610i32)
    }
    fn name(&self) -> &'static str {
        "Janus"
    }
}
impl Display for Janus {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Janus {
    fn gravitational_parameter(&self) -> f64 {
        0.1265765099012197f64
    }
}
impl MeanRadius for Janus {
    fn mean_radius(&self) -> f64 {
        89.2f64
    }
}
impl TriaxialEllipsoid for Janus {
    fn radii(&self) -> Radii {
        (101.7f64, 93f64, 76.3f64)
    }
}
const RIGHT_ASCENSION_JANUS: RotationalElement<8usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 0.7082546104592989f64,
    c1: -0.0006283185307179586f64,
    c2: 0f64,
    c: [
        0f64,
        -0.028326693759867967f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0.0004014257279586958f64,
    ],
    theta0: [
        6.166597313146365f64,
        0.5012585611727715f64,
        3.0962140930379407f64,
        5.235987755982989f64,
        5.523094417936056f64,
        6.0248765778844255f64,
        12.33319462629273f64,
        1.002517122345543f64,
    ],
    theta1: [
        1321.331180819591f64,
        1321.331180819591f64,
        -637.14117008679f64,
        -126.11574641985825f64,
        8.834856673595295f64,
        -17.73778118801837f64,
        2642.662361639182f64,
        2642.662361639182f64,
    ],
};
const DECLINATION_JANUS: RotationalElement<8usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: 1.457698991265664f64,
    c1: -0.00006981317007977319f64,
    c2: 0f64,
    c: [
        0f64,
        -0.003193952531149623f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0.000017453292519943296f64,
    ],
    theta0: [
        6.166597313146365f64,
        0.5012585611727715f64,
        3.0962140930379407f64,
        5.235987755982989f64,
        5.523094417936056f64,
        6.0248765778844255f64,
        12.33319462629273f64,
        1.002517122345543f64,
    ],
    theta1: [
        1321.331180819591f64,
        1321.331180819591f64,
        -637.14117008679f64,
        -126.11574641985825f64,
        8.834856673595295f64,
        -17.73778118801837f64,
        2642.662361639182f64,
        2642.662361639182f64,
    ],
};
const ROTATION_JANUS: RotationalElement<8usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 1.0267771989482641f64,
    c1: 9.044924285944507f64,
    c2: 0f64,
    c: [
        0f64,
        0.028152160834668535f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        -0.0004014257279586958f64,
    ],
    theta0: [
        6.166597313146365f64,
        0.5012585611727715f64,
        3.0962140930379407f64,
        5.235987755982989f64,
        5.523094417936056f64,
        6.0248765778844255f64,
        12.33319462629273f64,
        1.002517122345543f64,
    ],
    theta1: [
        1321.331180819591f64,
        1321.331180819591f64,
        -637.14117008679f64,
        -126.11574641985825f64,
        8.834856673595295f64,
        -17.73778118801837f64,
        2642.662361639182f64,
        2642.662361639182f64,
    ],
};
impl RotationalElements for Janus {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_JANUS.angle(t),
            DECLINATION_JANUS.angle(t),
            ROTATION_JANUS.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_JANUS.angle_dot(t),
            DECLINATION_JANUS.angle_dot(t),
            ROTATION_JANUS.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Epimetheus;
impl Origin for Epimetheus {
    fn id(&self) -> NaifId {
        NaifId(611i32)
    }
    fn name(&self) -> &'static str {
        "Epimetheus"
    }
}
impl Display for Epimetheus {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Epimetheus {
    fn gravitational_parameter(&self) -> f64 {
        0.03512333288208074f64
    }
}
impl MeanRadius for Epimetheus {
    fn mean_radius(&self) -> f64 {
        58.2f64
    }
}
impl TriaxialEllipsoid for Epimetheus {
    fn radii(&self) -> Radii {
        (64.9f64, 57.3f64, 53f64)
    }
}
const RIGHT_ASCENSION_EPIMETHEUS: RotationalElement<8usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 0.7082546104592989f64,
    c1: -0.0006283185307179586f64,
    c2: 0f64,
    c: [
        -0.05503023131538121f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0.0015009831567151233f64,
        0f64,
    ],
    theta0: [
        6.166597313146365f64,
        0.5012585611727715f64,
        3.0962140930379407f64,
        5.235987755982989f64,
        5.523094417936056f64,
        6.0248765778844255f64,
        12.33319462629273f64,
        1.002517122345543f64,
    ],
    theta1: [
        1321.331180819591f64,
        1321.331180819591f64,
        -637.14117008679f64,
        -126.11574641985825f64,
        8.834856673595295f64,
        -17.73778118801837f64,
        2642.662361639182f64,
        2642.662361639182f64,
    ],
};
const DECLINATION_EPIMETHEUS: RotationalElement<8usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: 1.457698991265664f64,
    c1: -0.00006981317007977319f64,
    c2: 0f64,
    c: [
        -0.006213372137099813f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0.00008726646259971648f64,
        0f64,
    ],
    theta0: [
        6.166597313146365f64,
        0.5012585611727715f64,
        3.0962140930379407f64,
        5.235987755982989f64,
        5.523094417936056f64,
        6.0248765778844255f64,
        12.33319462629273f64,
        1.002517122345543f64,
    ],
    theta1: [
        1321.331180819591f64,
        1321.331180819591f64,
        -637.14117008679f64,
        -126.11574641985825f64,
        8.834856673595295f64,
        -17.73778118801837f64,
        2642.662361639182f64,
        2642.662361639182f64,
    ],
};
const ROTATION_EPIMETHEUS: RotationalElement<8usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 5.128999072835736f64,
    c1: 9.049370273103856f64,
    c2: 0f64,
    c: [
        0.05468116546498235f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        -0.0015009831567151233f64,
        0f64,
    ],
    theta0: [
        6.166597313146365f64,
        0.5012585611727715f64,
        3.0962140930379407f64,
        5.235987755982989f64,
        5.523094417936056f64,
        6.0248765778844255f64,
        12.33319462629273f64,
        1.002517122345543f64,
    ],
    theta1: [
        1321.331180819591f64,
        1321.331180819591f64,
        -637.14117008679f64,
        -126.11574641985825f64,
        8.834856673595295f64,
        -17.73778118801837f64,
        2642.662361639182f64,
        2642.662361639182f64,
    ],
};
impl RotationalElements for Epimetheus {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_EPIMETHEUS.angle(t),
            DECLINATION_EPIMETHEUS.angle(t),
            ROTATION_EPIMETHEUS.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_EPIMETHEUS.angle_dot(t),
            DECLINATION_EPIMETHEUS.angle_dot(t),
            ROTATION_EPIMETHEUS.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Helene;
impl Origin for Helene {
    fn id(&self) -> NaifId {
        NaifId(612i32)
    }
    fn name(&self) -> &'static str {
        "Helene"
    }
}
impl Display for Helene {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Helene {
    fn gravitational_parameter(&self) -> f64 {
        0.0004757419551776972f64
    }
}
impl MeanRadius for Helene {
    fn mean_radius(&self) -> f64 {
        18f64
    }
}
impl TriaxialEllipsoid for Helene {
    fn radii(&self) -> Radii {
        (22.5f64, 19.6f64, 13.3f64)
    }
}
const RIGHT_ASCENSION_HELENE: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 0.7129669994396837f64,
    c1: -0.0006283185307179586f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const DECLINATION_HELENE: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: 1.4545573986120743f64,
    c1: -0.00006981317007977319f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const ROTATION_HELENE: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 4.278151062488501f64,
    c1: 2.297157080652823f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
impl RotationalElements for Helene {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_HELENE.angle(t),
            DECLINATION_HELENE.angle(t),
            ROTATION_HELENE.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_HELENE.angle_dot(t),
            DECLINATION_HELENE.angle_dot(t),
            ROTATION_HELENE.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Telesto;
impl Origin for Telesto {
    fn id(&self) -> NaifId {
        NaifId(613i32)
    }
    fn name(&self) -> &'static str {
        "Telesto"
    }
}
impl Display for Telesto {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl MeanRadius for Telesto {
    fn mean_radius(&self) -> f64 {
        12.4f64
    }
}
impl TriaxialEllipsoid for Telesto {
    fn radii(&self) -> Radii {
        (16.3f64, 11.8f64, 9.8f64)
    }
}
const RIGHT_ASCENSION_TELESTO: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 0.8815658051823358f64,
    c1: -0.0006283185307179586f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const DECLINATION_TELESTO: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: 1.4671237692264334f64,
    c1: -0.00006981317007977319f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const ROTATION_TELESTO: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 0.9927432785343747f64,
    c1: 3.328306811088206f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
impl RotationalElements for Telesto {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_TELESTO.angle(t),
            DECLINATION_TELESTO.angle(t),
            ROTATION_TELESTO.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_TELESTO.angle_dot(t),
            DECLINATION_TELESTO.angle_dot(t),
            ROTATION_TELESTO.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Calypso;
impl Origin for Calypso {
    fn id(&self) -> NaifId {
        NaifId(614i32)
    }
    fn name(&self) -> &'static str {
        "Calypso"
    }
}
impl Display for Calypso {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl MeanRadius for Calypso {
    fn mean_radius(&self) -> f64 {
        9.6f64
    }
}
impl TriaxialEllipsoid for Calypso {
    fn radii(&self) -> Radii {
        (15.3f64, 9.3f64, 6.3f64)
    }
}
const RIGHT_ASCENSION_CALYPSO: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 0.6354743806511354f64,
    c1: -0.0006283185307179586f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const DECLINATION_CALYPSO: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: 1.4842279958959779f64,
    c1: -0.00006981317007977319f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const ROTATION_CALYPSO: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 2.679254934736495f64,
    c1: 3.327893239613983f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
impl RotationalElements for Calypso {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_CALYPSO.angle(t),
            DECLINATION_CALYPSO.angle(t),
            ROTATION_CALYPSO.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_CALYPSO.angle_dot(t),
            DECLINATION_CALYPSO.angle_dot(t),
            ROTATION_CALYPSO.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Atlas;
impl Origin for Atlas {
    fn id(&self) -> NaifId {
        NaifId(615i32)
    }
    fn name(&self) -> &'static str {
        "Atlas"
    }
}
impl Display for Atlas {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Atlas {
    fn gravitational_parameter(&self) -> f64 {
        0.0003718871247516475f64
    }
}
impl MeanRadius for Atlas {
    fn mean_radius(&self) -> f64 {
        15.1f64
    }
}
impl TriaxialEllipsoid for Atlas {
    fn radii(&self) -> Radii {
        (20.5f64, 17.8f64, 9.4f64)
    }
}
const RIGHT_ASCENSION_ATLAS: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 0.7082546104592989f64,
    c1: -0.0006283185307179586f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const DECLINATION_ATLAS: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: 1.4578735241908636f64,
    c1: -0.00006981317007977319f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const ROTATION_ATLAS: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 2.4064599726497815f64,
    c1: 10.442409634437194f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
impl RotationalElements for Atlas {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_ATLAS.angle(t),
            DECLINATION_ATLAS.angle(t),
            ROTATION_ATLAS.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_ATLAS.angle_dot(t),
            DECLINATION_ATLAS.angle_dot(t),
            ROTATION_ATLAS.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Prometheus;
impl Origin for Prometheus {
    fn id(&self) -> NaifId {
        NaifId(616i32)
    }
    fn name(&self) -> &'static str {
        "Prometheus"
    }
}
impl Display for Prometheus {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Prometheus {
    fn gravitational_parameter(&self) -> f64 {
        0.0107520800100761f64
    }
}
impl MeanRadius for Prometheus {
    fn mean_radius(&self) -> f64 {
        43.1f64
    }
}
impl TriaxialEllipsoid for Prometheus {
    fn radii(&self) -> Radii {
        (68.2f64, 41.6f64, 28.2f64)
    }
}
const RIGHT_ASCENSION_PROMETHEUS: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 0.7082546104592989f64,
    c1: -0.0006283185307179586f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const DECLINATION_PROMETHEUS: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: 1.4578735241908636f64,
    c1: -0.00006981317007977319f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const ROTATION_PROMETHEUS: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 5.1686180468560075f64,
    c1: 10.250126710744977f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
impl RotationalElements for Prometheus {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_PROMETHEUS.angle(t),
            DECLINATION_PROMETHEUS.angle(t),
            ROTATION_PROMETHEUS.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_PROMETHEUS.angle_dot(t),
            DECLINATION_PROMETHEUS.angle_dot(t),
            ROTATION_PROMETHEUS.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Pandora;
impl Origin for Pandora {
    fn id(&self) -> NaifId {
        NaifId(617i32)
    }
    fn name(&self) -> &'static str {
        "Pandora"
    }
}
impl Display for Pandora {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Pandora {
    fn gravitational_parameter(&self) -> f64 {
        0.009290325122028795f64
    }
}
impl MeanRadius for Pandora {
    fn mean_radius(&self) -> f64 {
        40.6f64
    }
}
impl TriaxialEllipsoid for Pandora {
    fn radii(&self) -> Radii {
        (52.2f64, 40.8f64, 31.5f64)
    }
}
const RIGHT_ASCENSION_PANDORA: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 0.7082546104592989f64,
    c1: -0.0006283185307179586f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const DECLINATION_PANDORA: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: 1.4578735241908636f64,
    c1: -0.00006981317007977319f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const ROTATION_PANDORA: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 2.8434904173491615f64,
    c1: 9.997055714535051f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
impl RotationalElements for Pandora {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_PANDORA.angle(t),
            DECLINATION_PANDORA.angle(t),
            ROTATION_PANDORA.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_PANDORA.angle_dot(t),
            DECLINATION_PANDORA.angle_dot(t),
            ROTATION_PANDORA.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Pan;
impl Origin for Pan {
    fn id(&self) -> NaifId {
        NaifId(618i32)
    }
    fn name(&self) -> &'static str {
        "Pan"
    }
}
impl Display for Pan {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl MeanRadius for Pan {
    fn mean_radius(&self) -> f64 {
        14f64
    }
}
impl TriaxialEllipsoid for Pan {
    fn radii(&self) -> Radii {
        (17.2f64, 15.4f64, 10.4f64)
    }
}
const RIGHT_ASCENSION_PAN: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 0.7086036763096978f64,
    c1: -0.0006283185307179586f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const DECLINATION_PAN: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: 1.457349925415265f64,
    c1: -0.00006981317007977319f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const ROTATION_PAN: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 0.8517206749732328f64,
    c1: 10.92652906235538f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
impl RotationalElements for Pan {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_PAN.angle(t),
            DECLINATION_PAN.angle(t),
            ROTATION_PAN.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_PAN.angle_dot(t),
            DECLINATION_PAN.angle_dot(t),
            ROTATION_PAN.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Ymir;
impl Origin for Ymir {
    fn id(&self) -> NaifId {
        NaifId(619i32)
    }
    fn name(&self) -> &'static str {
        "Ymir"
    }
}
impl Display for Ymir {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Paaliaq;
impl Origin for Paaliaq {
    fn id(&self) -> NaifId {
        NaifId(620i32)
    }
    fn name(&self) -> &'static str {
        "Paaliaq"
    }
}
impl Display for Paaliaq {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Tarvos;
impl Origin for Tarvos {
    fn id(&self) -> NaifId {
        NaifId(621i32)
    }
    fn name(&self) -> &'static str {
        "Tarvos"
    }
}
impl Display for Tarvos {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Ijiraq;
impl Origin for Ijiraq {
    fn id(&self) -> NaifId {
        NaifId(622i32)
    }
    fn name(&self) -> &'static str {
        "Ijiraq"
    }
}
impl Display for Ijiraq {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Suttungr;
impl Origin for Suttungr {
    fn id(&self) -> NaifId {
        NaifId(623i32)
    }
    fn name(&self) -> &'static str {
        "Suttungr"
    }
}
impl Display for Suttungr {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Kiviuq;
impl Origin for Kiviuq {
    fn id(&self) -> NaifId {
        NaifId(624i32)
    }
    fn name(&self) -> &'static str {
        "Kiviuq"
    }
}
impl Display for Kiviuq {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Mundilfari;
impl Origin for Mundilfari {
    fn id(&self) -> NaifId {
        NaifId(625i32)
    }
    fn name(&self) -> &'static str {
        "Mundilfari"
    }
}
impl Display for Mundilfari {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Albiorix;
impl Origin for Albiorix {
    fn id(&self) -> NaifId {
        NaifId(626i32)
    }
    fn name(&self) -> &'static str {
        "Albiorix"
    }
}
impl Display for Albiorix {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Skathi;
impl Origin for Skathi {
    fn id(&self) -> NaifId {
        NaifId(627i32)
    }
    fn name(&self) -> &'static str {
        "Skathi"
    }
}
impl Display for Skathi {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Erriapus;
impl Origin for Erriapus {
    fn id(&self) -> NaifId {
        NaifId(628i32)
    }
    fn name(&self) -> &'static str {
        "Erriapus"
    }
}
impl Display for Erriapus {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Siarnaq;
impl Origin for Siarnaq {
    fn id(&self) -> NaifId {
        NaifId(629i32)
    }
    fn name(&self) -> &'static str {
        "Siarnaq"
    }
}
impl Display for Siarnaq {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Thrymr;
impl Origin for Thrymr {
    fn id(&self) -> NaifId {
        NaifId(630i32)
    }
    fn name(&self) -> &'static str {
        "Thrymr"
    }
}
impl Display for Thrymr {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Narvi;
impl Origin for Narvi {
    fn id(&self) -> NaifId {
        NaifId(631i32)
    }
    fn name(&self) -> &'static str {
        "Narvi"
    }
}
impl Display for Narvi {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Methone;
impl Origin for Methone {
    fn id(&self) -> NaifId {
        NaifId(632i32)
    }
    fn name(&self) -> &'static str {
        "Methone"
    }
}
impl Display for Methone {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl MeanRadius for Methone {
    fn mean_radius(&self) -> f64 {
        1.45f64
    }
}
impl TriaxialEllipsoid for Methone {
    fn radii(&self) -> Radii {
        (1.94f64, 1.29f64, 1.21f64)
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Pallene;
impl Origin for Pallene {
    fn id(&self) -> NaifId {
        NaifId(633i32)
    }
    fn name(&self) -> &'static str {
        "Pallene"
    }
}
impl Display for Pallene {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl MeanRadius for Pallene {
    fn mean_radius(&self) -> f64 {
        2.23f64
    }
}
impl TriaxialEllipsoid for Pallene {
    fn radii(&self) -> Radii {
        (2.88f64, 2.08f64, 1.8f64)
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Polydeuces;
impl Origin for Polydeuces {
    fn id(&self) -> NaifId {
        NaifId(634i32)
    }
    fn name(&self) -> &'static str {
        "Polydeuces"
    }
}
impl Display for Polydeuces {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl MeanRadius for Polydeuces {
    fn mean_radius(&self) -> f64 {
        1.3f64
    }
}
impl TriaxialEllipsoid for Polydeuces {
    fn radii(&self) -> Radii {
        (1.5f64, 1.2f64, 1f64)
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Daphnis;
impl Origin for Daphnis {
    fn id(&self) -> NaifId {
        NaifId(635i32)
    }
    fn name(&self) -> &'static str {
        "Daphnis"
    }
}
impl Display for Daphnis {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl MeanRadius for Daphnis {
    fn mean_radius(&self) -> f64 {
        3.8f64
    }
}
impl TriaxialEllipsoid for Daphnis {
    fn radii(&self) -> Radii {
        (4.6f64, 4.5f64, 2.8f64)
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Aegir;
impl Origin for Aegir {
    fn id(&self) -> NaifId {
        NaifId(636i32)
    }
    fn name(&self) -> &'static str {
        "Aegir"
    }
}
impl Display for Aegir {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Bebhionn;
impl Origin for Bebhionn {
    fn id(&self) -> NaifId {
        NaifId(637i32)
    }
    fn name(&self) -> &'static str {
        "Bebhionn"
    }
}
impl Display for Bebhionn {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Bergelmir;
impl Origin for Bergelmir {
    fn id(&self) -> NaifId {
        NaifId(638i32)
    }
    fn name(&self) -> &'static str {
        "Bergelmir"
    }
}
impl Display for Bergelmir {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Bestla;
impl Origin for Bestla {
    fn id(&self) -> NaifId {
        NaifId(639i32)
    }
    fn name(&self) -> &'static str {
        "Bestla"
    }
}
impl Display for Bestla {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Farbauti;
impl Origin for Farbauti {
    fn id(&self) -> NaifId {
        NaifId(640i32)
    }
    fn name(&self) -> &'static str {
        "Farbauti"
    }
}
impl Display for Farbauti {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Fenrir;
impl Origin for Fenrir {
    fn id(&self) -> NaifId {
        NaifId(641i32)
    }
    fn name(&self) -> &'static str {
        "Fenrir"
    }
}
impl Display for Fenrir {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Fornjot;
impl Origin for Fornjot {
    fn id(&self) -> NaifId {
        NaifId(642i32)
    }
    fn name(&self) -> &'static str {
        "Fornjot"
    }
}
impl Display for Fornjot {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Hati;
impl Origin for Hati {
    fn id(&self) -> NaifId {
        NaifId(643i32)
    }
    fn name(&self) -> &'static str {
        "Hati"
    }
}
impl Display for Hati {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Hyrrokkin;
impl Origin for Hyrrokkin {
    fn id(&self) -> NaifId {
        NaifId(644i32)
    }
    fn name(&self) -> &'static str {
        "Hyrrokkin"
    }
}
impl Display for Hyrrokkin {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Kari;
impl Origin for Kari {
    fn id(&self) -> NaifId {
        NaifId(645i32)
    }
    fn name(&self) -> &'static str {
        "Kari"
    }
}
impl Display for Kari {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Loge;
impl Origin for Loge {
    fn id(&self) -> NaifId {
        NaifId(646i32)
    }
    fn name(&self) -> &'static str {
        "Loge"
    }
}
impl Display for Loge {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Skoll;
impl Origin for Skoll {
    fn id(&self) -> NaifId {
        NaifId(647i32)
    }
    fn name(&self) -> &'static str {
        "Skoll"
    }
}
impl Display for Skoll {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Surtur;
impl Origin for Surtur {
    fn id(&self) -> NaifId {
        NaifId(648i32)
    }
    fn name(&self) -> &'static str {
        "Surtur"
    }
}
impl Display for Surtur {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Anthe;
impl Origin for Anthe {
    fn id(&self) -> NaifId {
        NaifId(649i32)
    }
    fn name(&self) -> &'static str {
        "Anthe"
    }
}
impl Display for Anthe {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl MeanRadius for Anthe {
    fn mean_radius(&self) -> f64 {
        0.5f64
    }
}
impl TriaxialEllipsoid for Anthe {
    fn radii(&self) -> Radii {
        (0.5f64, 0.5f64, 0.5f64)
    }
}
impl Spheroid for Anthe {}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Jarnsaxa;
impl Origin for Jarnsaxa {
    fn id(&self) -> NaifId {
        NaifId(650i32)
    }
    fn name(&self) -> &'static str {
        "Jarnsaxa"
    }
}
impl Display for Jarnsaxa {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Greip;
impl Origin for Greip {
    fn id(&self) -> NaifId {
        NaifId(651i32)
    }
    fn name(&self) -> &'static str {
        "Greip"
    }
}
impl Display for Greip {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Tarqeq;
impl Origin for Tarqeq {
    fn id(&self) -> NaifId {
        NaifId(652i32)
    }
    fn name(&self) -> &'static str {
        "Tarqeq"
    }
}
impl Display for Tarqeq {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Aegaeon;
impl Origin for Aegaeon {
    fn id(&self) -> NaifId {
        NaifId(653i32)
    }
    fn name(&self) -> &'static str {
        "Aegaeon"
    }
}
impl Display for Aegaeon {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl MeanRadius for Aegaeon {
    fn mean_radius(&self) -> f64 {
        0.33f64
    }
}
impl TriaxialEllipsoid for Aegaeon {
    fn radii(&self) -> Radii {
        (0.7f64, 0.25f64, 0.2f64)
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Ariel;
impl Origin for Ariel {
    fn id(&self) -> NaifId {
        NaifId(701i32)
    }
    fn name(&self) -> &'static str {
        "Ariel"
    }
}
impl Display for Ariel {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Ariel {
    fn gravitational_parameter(&self) -> f64 {
        83.46344431770477f64
    }
}
impl MeanRadius for Ariel {
    fn mean_radius(&self) -> f64 {
        578.9f64
    }
}
impl TriaxialEllipsoid for Ariel {
    fn radii(&self) -> Radii {
        (581.1f64, 577.9f64, 577.7f64)
    }
}
const RIGHT_ASCENSION_ARIEL: RotationalElement<13usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 4.493001093409003f64,
    c1: 0f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0.005061454830783556f64,
    ],
    theta0: [
        2.0202186091834364f64,
        2.4729570171507653f64,
        2.356718088967943f64,
        1.0780898789568973f64,
        4.351454891072263f64,
        0.7655014099247129f64,
        1.3554226970987964f64,
        2.746450110938277f64,
        1.776919711455427f64,
        2.419724474964938f64,
        1.784250094313803f64,
        5.522396286235258f64,
        5.3059754589879615f64,
    ],
    theta1: [
        959.7891933286942f64,
        731.077582955928f64,
        522.3307938967249f64,
        449.1358738582876f64,
        427.10754977009157f64,
        388.83160660922994f64,
        354.1171823199879f64,
        290.6454915444109f64,
        224.66977689099764f64,
        140.70512817020406f64,
        -35.32930378471962f64,
        49.9855316454168f64,
        -0.9065240134858548f64,
    ],
};
const DECLINATION_ARIEL: RotationalElement<13usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: -0.26354471705114374f64,
    c1: 0f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0.004886921905584123f64,
    ],
    theta0: [
        2.0202186091834364f64,
        2.4729570171507653f64,
        2.356718088967943f64,
        1.0780898789568973f64,
        4.351454891072263f64,
        0.7655014099247129f64,
        1.3554226970987964f64,
        2.746450110938277f64,
        1.776919711455427f64,
        2.419724474964938f64,
        1.784250094313803f64,
        5.522396286235258f64,
        5.3059754589879615f64,
    ],
    theta1: [
        959.7891933286942f64,
        731.077582955928f64,
        522.3307938967249f64,
        449.1358738582876f64,
        427.10754977009157f64,
        388.83160660922994f64,
        354.1171823199879f64,
        290.6454915444109f64,
        224.66977689099764f64,
        140.70512817020406f64,
        -35.32930378471962f64,
        49.9855316454168f64,
        -0.9065240134858548f64,
    ],
};
const ROTATION_ARIEL: RotationalElement<13usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 2.7265533574655416f64,
    c1: -2.492952697630833f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0.0008726646259971648f64,
        0.0013962634015954637f64,
    ],
    theta0: [
        2.0202186091834364f64,
        2.4729570171507653f64,
        2.356718088967943f64,
        1.0780898789568973f64,
        4.351454891072263f64,
        0.7655014099247129f64,
        1.3554226970987964f64,
        2.746450110938277f64,
        1.776919711455427f64,
        2.419724474964938f64,
        1.784250094313803f64,
        5.522396286235258f64,
        5.3059754589879615f64,
    ],
    theta1: [
        959.7891933286942f64,
        731.077582955928f64,
        522.3307938967249f64,
        449.1358738582876f64,
        427.10754977009157f64,
        388.83160660922994f64,
        354.1171823199879f64,
        290.6454915444109f64,
        224.66977689099764f64,
        140.70512817020406f64,
        -35.32930378471962f64,
        49.9855316454168f64,
        -0.9065240134858548f64,
    ],
};
impl RotationalElements for Ariel {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_ARIEL.angle(t),
            DECLINATION_ARIEL.angle(t),
            ROTATION_ARIEL.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_ARIEL.angle_dot(t),
            DECLINATION_ARIEL.angle_dot(t),
            ROTATION_ARIEL.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Umbriel;
impl Origin for Umbriel {
    fn id(&self) -> NaifId {
        NaifId(702i32)
    }
    fn name(&self) -> &'static str {
        "Umbriel"
    }
}
impl Display for Umbriel {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Umbriel {
    fn gravitational_parameter(&self) -> f64 {
        85.09338094489388f64
    }
}
impl MeanRadius for Umbriel {
    fn mean_radius(&self) -> f64 {
        584.7f64
    }
}
impl TriaxialEllipsoid for Umbriel {
    fn radii(&self) -> Radii {
        (584.7f64, 584.7f64, 584.7f64)
    }
}
impl Spheroid for Umbriel {}
const RIGHT_ASCENSION_UMBRIEL: RotationalElement<14usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 4.493001093409003f64,
    c1: 0f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0.003665191429188092f64,
    ],
    theta0: [
        2.0202186091834364f64,
        2.4729570171507653f64,
        2.356718088967943f64,
        1.0780898789568973f64,
        4.351454891072263f64,
        0.7655014099247129f64,
        1.3554226970987964f64,
        2.746450110938277f64,
        1.776919711455427f64,
        2.419724474964938f64,
        1.784250094313803f64,
        5.522396286235258f64,
        5.3059754589879615f64,
        5.388005933831694f64,
    ],
    theta1: [
        959.7891933286942f64,
        731.077582955928f64,
        522.3307938967249f64,
        449.1358738582876f64,
        427.10754977009157f64,
        388.83160660922994f64,
        354.1171823199879f64,
        290.6454915444109f64,
        224.66977689099764f64,
        140.70512817020406f64,
        -35.32930378471962f64,
        49.9855316454168f64,
        -0.9065240134858548f64,
        -1.626123264083117f64,
    ],
};
const DECLINATION_UMBRIEL: RotationalElement<14usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: -0.26354471705114374f64,
    c1: 0f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0.003490658503988659f64,
    ],
    theta0: [
        2.0202186091834364f64,
        2.4729570171507653f64,
        2.356718088967943f64,
        1.0780898789568973f64,
        4.351454891072263f64,
        0.7655014099247129f64,
        1.3554226970987964f64,
        2.746450110938277f64,
        1.776919711455427f64,
        2.419724474964938f64,
        1.784250094313803f64,
        5.522396286235258f64,
        5.3059754589879615f64,
        5.388005933831694f64,
    ],
    theta1: [
        959.7891933286942f64,
        731.077582955928f64,
        522.3307938967249f64,
        449.1358738582876f64,
        427.10754977009157f64,
        388.83160660922994f64,
        354.1171823199879f64,
        290.6454915444109f64,
        224.66977689099764f64,
        140.70512817020406f64,
        -35.32930378471962f64,
        49.9855316454168f64,
        -0.9065240134858548f64,
        -1.626123264083117f64,
    ],
};
const ROTATION_UMBRIEL: RotationalElement<14usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 1.885828256779873f64,
    c1: -1.5161481881953498f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        -0.0015707963267948964f64,
        0f64,
        0.0010471975511965976f64,
    ],
    theta0: [
        2.0202186091834364f64,
        2.4729570171507653f64,
        2.356718088967943f64,
        1.0780898789568973f64,
        4.351454891072263f64,
        0.7655014099247129f64,
        1.3554226970987964f64,
        2.746450110938277f64,
        1.776919711455427f64,
        2.419724474964938f64,
        1.784250094313803f64,
        5.522396286235258f64,
        5.3059754589879615f64,
        5.388005933831694f64,
    ],
    theta1: [
        959.7891933286942f64,
        731.077582955928f64,
        522.3307938967249f64,
        449.1358738582876f64,
        427.10754977009157f64,
        388.83160660922994f64,
        354.1171823199879f64,
        290.6454915444109f64,
        224.66977689099764f64,
        140.70512817020406f64,
        -35.32930378471962f64,
        49.9855316454168f64,
        -0.9065240134858548f64,
        -1.626123264083117f64,
    ],
};
impl RotationalElements for Umbriel {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_UMBRIEL.angle(t),
            DECLINATION_UMBRIEL.angle(t),
            ROTATION_UMBRIEL.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_UMBRIEL.angle_dot(t),
            DECLINATION_UMBRIEL.angle_dot(t),
            ROTATION_UMBRIEL.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Titania;
impl Origin for Titania {
    fn id(&self) -> NaifId {
        NaifId(703i32)
    }
    fn name(&self) -> &'static str {
        "Titania"
    }
}
impl Display for Titania {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Titania {
    fn gravitational_parameter(&self) -> f64 {
        226.9437003741248f64
    }
}
impl MeanRadius for Titania {
    fn mean_radius(&self) -> f64 {
        788.9f64
    }
}
impl TriaxialEllipsoid for Titania {
    fn radii(&self) -> Radii {
        (788.9f64, 788.9f64, 788.9f64)
    }
}
impl Spheroid for Titania {}
const RIGHT_ASCENSION_TITANIA: RotationalElement<15usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 4.493001093409003f64,
    c1: 0f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0.005061454830783556f64,
    ],
    theta0: [
        2.0202186091834364f64,
        2.4729570171507653f64,
        2.356718088967943f64,
        1.0780898789568973f64,
        4.351454891072263f64,
        0.7655014099247129f64,
        1.3554226970987964f64,
        2.746450110938277f64,
        1.776919711455427f64,
        2.419724474964938f64,
        1.784250094313803f64,
        5.522396286235258f64,
        5.3059754589879615f64,
        5.388005933831694f64,
        5.948431156647074f64,
    ],
    theta1: [
        959.7891933286942f64,
        731.077582955928f64,
        522.3307938967249f64,
        449.1358738582876f64,
        427.10754977009157f64,
        388.83160660922994f64,
        354.1171823199879f64,
        290.6454915444109f64,
        224.66977689099764f64,
        140.70512817020406f64,
        -35.32930378471962f64,
        49.9855316454168f64,
        -0.9065240134858548f64,
        -1.626123264083117f64,
        -1.314581992602129f64,
    ],
};
const DECLINATION_TITANIA: RotationalElement<15usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: -0.26354471705114374f64,
    c1: 0f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0.004886921905584123f64,
    ],
    theta0: [
        2.0202186091834364f64,
        2.4729570171507653f64,
        2.356718088967943f64,
        1.0780898789568973f64,
        4.351454891072263f64,
        0.7655014099247129f64,
        1.3554226970987964f64,
        2.746450110938277f64,
        1.776919711455427f64,
        2.419724474964938f64,
        1.784250094313803f64,
        5.522396286235258f64,
        5.3059754589879615f64,
        5.388005933831694f64,
        5.948431156647074f64,
    ],
    theta1: [
        959.7891933286942f64,
        731.077582955928f64,
        522.3307938967249f64,
        449.1358738582876f64,
        427.10754977009157f64,
        388.83160660922994f64,
        354.1171823199879f64,
        290.6454915444109f64,
        224.66977689099764f64,
        140.70512817020406f64,
        -35.32930378471962f64,
        49.9855316454168f64,
        -0.9065240134858548f64,
        -1.626123264083117f64,
        -1.314581992602129f64,
    ],
};
const ROTATION_TITANIA: RotationalElement<15usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 1.3568189605003917f64,
    c1: -0.7217186318332268f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0.0013962634015954637f64,
    ],
    theta0: [
        2.0202186091834364f64,
        2.4729570171507653f64,
        2.356718088967943f64,
        1.0780898789568973f64,
        4.351454891072263f64,
        0.7655014099247129f64,
        1.3554226970987964f64,
        2.746450110938277f64,
        1.776919711455427f64,
        2.419724474964938f64,
        1.784250094313803f64,
        5.522396286235258f64,
        5.3059754589879615f64,
        5.388005933831694f64,
        5.948431156647074f64,
    ],
    theta1: [
        959.7891933286942f64,
        731.077582955928f64,
        522.3307938967249f64,
        449.1358738582876f64,
        427.10754977009157f64,
        388.83160660922994f64,
        354.1171823199879f64,
        290.6454915444109f64,
        224.66977689099764f64,
        140.70512817020406f64,
        -35.32930378471962f64,
        49.9855316454168f64,
        -0.9065240134858548f64,
        -1.626123264083117f64,
        -1.314581992602129f64,
    ],
};
impl RotationalElements for Titania {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_TITANIA.angle(t),
            DECLINATION_TITANIA.angle(t),
            ROTATION_TITANIA.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_TITANIA.angle_dot(t),
            DECLINATION_TITANIA.angle_dot(t),
            ROTATION_TITANIA.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Oberon;
impl Origin for Oberon {
    fn id(&self) -> NaifId {
        NaifId(704i32)
    }
    fn name(&self) -> &'static str {
        "Oberon"
    }
}
impl Display for Oberon {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Oberon {
    fn gravitational_parameter(&self) -> f64 {
        205.3234302535623f64
    }
}
impl MeanRadius for Oberon {
    fn mean_radius(&self) -> f64 {
        761.4f64
    }
}
impl TriaxialEllipsoid for Oberon {
    fn radii(&self) -> Radii {
        (761.4f64, 761.4f64, 761.4f64)
    }
}
impl Spheroid for Oberon {}
const RIGHT_ASCENSION_OBERON: RotationalElement<16usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 4.493001093409003f64,
    c1: 0f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0.0027925268031909274f64,
    ],
    theta0: [
        2.0202186091834364f64,
        2.4729570171507653f64,
        2.356718088967943f64,
        1.0780898789568973f64,
        4.351454891072263f64,
        0.7655014099247129f64,
        1.3554226970987964f64,
        2.746450110938277f64,
        1.776919711455427f64,
        2.419724474964938f64,
        1.784250094313803f64,
        5.522396286235258f64,
        5.3059754589879615f64,
        5.388005933831694f64,
        5.948431156647074f64,
        4.522846223618106f64,
    ],
    theta1: [
        959.7891933286942f64,
        731.077582955928f64,
        522.3307938967249f64,
        449.1358738582876f64,
        427.10754977009157f64,
        388.83160660922994f64,
        354.1171823199879f64,
        290.6454915444109f64,
        224.66977689099764f64,
        140.70512817020406f64,
        -35.32930378471962f64,
        49.9855316454168f64,
        -0.9065240134858548f64,
        -1.626123264083117f64,
        -1.314581992602129f64,
        -8.810596596992575f64,
    ],
};
const DECLINATION_OBERON: RotationalElement<16usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: -0.26354471705114374f64,
    c1: 0f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0.0027925268031909274f64,
    ],
    theta0: [
        2.0202186091834364f64,
        2.4729570171507653f64,
        2.356718088967943f64,
        1.0780898789568973f64,
        4.351454891072263f64,
        0.7655014099247129f64,
        1.3554226970987964f64,
        2.746450110938277f64,
        1.776919711455427f64,
        2.419724474964938f64,
        1.784250094313803f64,
        5.522396286235258f64,
        5.3059754589879615f64,
        5.388005933831694f64,
        5.948431156647074f64,
        4.522846223618106f64,
    ],
    theta1: [
        959.7891933286942f64,
        731.077582955928f64,
        522.3307938967249f64,
        449.1358738582876f64,
        427.10754977009157f64,
        388.83160660922994f64,
        354.1171823199879f64,
        290.6454915444109f64,
        224.66977689099764f64,
        140.70512817020406f64,
        -35.32930378471962f64,
        49.9855316454168f64,
        -0.9065240134858548f64,
        -1.626123264083117f64,
        -1.314581992602129f64,
        -8.810596596992575f64,
    ],
};
const ROTATION_OBERON: RotationalElement<16usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 0.1181587903600161f64,
    c1: -0.4666921966546346f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0.0006981317007977319f64,
    ],
    theta0: [
        2.0202186091834364f64,
        2.4729570171507653f64,
        2.356718088967943f64,
        1.0780898789568973f64,
        4.351454891072263f64,
        0.7655014099247129f64,
        1.3554226970987964f64,
        2.746450110938277f64,
        1.776919711455427f64,
        2.419724474964938f64,
        1.784250094313803f64,
        5.522396286235258f64,
        5.3059754589879615f64,
        5.388005933831694f64,
        5.948431156647074f64,
        4.522846223618106f64,
    ],
    theta1: [
        959.7891933286942f64,
        731.077582955928f64,
        522.3307938967249f64,
        449.1358738582876f64,
        427.10754977009157f64,
        388.83160660922994f64,
        354.1171823199879f64,
        290.6454915444109f64,
        224.66977689099764f64,
        140.70512817020406f64,
        -35.32930378471962f64,
        49.9855316454168f64,
        -0.9065240134858548f64,
        -1.626123264083117f64,
        -1.314581992602129f64,
        -8.810596596992575f64,
    ],
};
impl RotationalElements for Oberon {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_OBERON.angle(t),
            DECLINATION_OBERON.angle(t),
            ROTATION_OBERON.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_OBERON.angle_dot(t),
            DECLINATION_OBERON.angle_dot(t),
            ROTATION_OBERON.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Miranda;
impl Origin for Miranda {
    fn id(&self) -> NaifId {
        NaifId(705i32)
    }
    fn name(&self) -> &'static str {
        "Miranda"
    }
}
impl Display for Miranda {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Miranda {
    fn gravitational_parameter(&self) -> f64 {
        4.3195168992321f64
    }
}
impl MeanRadius for Miranda {
    fn mean_radius(&self) -> f64 {
        235.8f64
    }
}
impl TriaxialEllipsoid for Miranda {
    fn radii(&self) -> Radii {
        (240.4f64, 234.2f64, 232.9f64)
    }
}
const RIGHT_ASCENSION_MIRANDA: RotationalElement<18usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 4.493001093409003f64,
    c1: 0f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0.07696902001294993f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        -0.0006981317007977319f64,
        0f64,
    ],
    theta0: [
        2.0202186091834364f64,
        2.4729570171507653f64,
        2.356718088967943f64,
        1.0780898789568973f64,
        4.351454891072263f64,
        0.7655014099247129f64,
        1.3554226970987964f64,
        2.746450110938277f64,
        1.776919711455427f64,
        2.419724474964938f64,
        1.784250094313803f64,
        5.522396286235258f64,
        5.3059754589879615f64,
        5.388005933831694f64,
        5.948431156647074f64,
        4.522846223618106f64,
        3.568500188627606f64,
        11.044792572470516f64,
    ],
    theta1: [
        959.7891933286942f64,
        731.077582955928f64,
        522.3307938967249f64,
        449.1358738582876f64,
        427.10754977009157f64,
        388.83160660922994f64,
        354.1171823199879f64,
        290.6454915444109f64,
        224.66977689099764f64,
        140.70512817020406f64,
        -35.32930378471962f64,
        49.9855316454168f64,
        -0.9065240134858548f64,
        -1.626123264083117f64,
        -1.314581992602129f64,
        -8.810596596992575f64,
        -70.65860756943924f64,
        99.9710632908336f64,
    ],
};
const DECLINATION_MIRANDA: RotationalElement<18usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: -0.2631956512007449f64,
    c1: 0f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0.07417649320975901f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        -0.00034906585039886593f64,
        0f64,
    ],
    theta0: [
        2.0202186091834364f64,
        2.4729570171507653f64,
        2.356718088967943f64,
        1.0780898789568973f64,
        4.351454891072263f64,
        0.7655014099247129f64,
        1.3554226970987964f64,
        2.746450110938277f64,
        1.776919711455427f64,
        2.419724474964938f64,
        1.784250094313803f64,
        5.522396286235258f64,
        5.3059754589879615f64,
        5.388005933831694f64,
        5.948431156647074f64,
        4.522846223618106f64,
        3.568500188627606f64,
        11.044792572470516f64,
    ],
    theta1: [
        959.7891933286942f64,
        731.077582955928f64,
        522.3307938967249f64,
        449.1358738582876f64,
        427.10754977009157f64,
        388.83160660922994f64,
        354.1171823199879f64,
        290.6454915444109f64,
        224.66977689099764f64,
        140.70512817020406f64,
        -35.32930378471962f64,
        49.9855316454168f64,
        -0.9065240134858548f64,
        -1.626123264083117f64,
        -1.314581992602129f64,
        -8.810596596992575f64,
        -70.65860756943924f64,
        99.9710632908336f64,
    ],
};
const ROTATION_MIRANDA: RotationalElement<18usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 0.5358160803622591f64,
    c1: -4.445191100713563f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0.02007128639793479f64,
        -0.022165681500327987f64,
        0f64,
        0f64,
        0f64,
        0f64,
        -0.0015707963267948964f64,
        0.002617993877991494f64,
    ],
    theta0: [
        2.0202186091834364f64,
        2.4729570171507653f64,
        2.356718088967943f64,
        1.0780898789568973f64,
        4.351454891072263f64,
        0.7655014099247129f64,
        1.3554226970987964f64,
        2.746450110938277f64,
        1.776919711455427f64,
        2.419724474964938f64,
        1.784250094313803f64,
        5.522396286235258f64,
        5.3059754589879615f64,
        5.388005933831694f64,
        5.948431156647074f64,
        4.522846223618106f64,
        3.568500188627606f64,
        11.044792572470516f64,
    ],
    theta1: [
        959.7891933286942f64,
        731.077582955928f64,
        522.3307938967249f64,
        449.1358738582876f64,
        427.10754977009157f64,
        388.83160660922994f64,
        354.1171823199879f64,
        290.6454915444109f64,
        224.66977689099764f64,
        140.70512817020406f64,
        -35.32930378471962f64,
        49.9855316454168f64,
        -0.9065240134858548f64,
        -1.626123264083117f64,
        -1.314581992602129f64,
        -8.810596596992575f64,
        -70.65860756943924f64,
        99.9710632908336f64,
    ],
};
impl RotationalElements for Miranda {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_MIRANDA.angle(t),
            DECLINATION_MIRANDA.angle(t),
            ROTATION_MIRANDA.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_MIRANDA.angle_dot(t),
            DECLINATION_MIRANDA.angle_dot(t),
            ROTATION_MIRANDA.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Cordelia;
impl Origin for Cordelia {
    fn id(&self) -> NaifId {
        NaifId(706i32)
    }
    fn name(&self) -> &'static str {
        "Cordelia"
    }
}
impl Display for Cordelia {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl MeanRadius for Cordelia {
    fn mean_radius(&self) -> f64 {
        13f64
    }
}
impl TriaxialEllipsoid for Cordelia {
    fn radii(&self) -> Radii {
        (13f64, 13f64, 13f64)
    }
}
impl Spheroid for Cordelia {}
const RIGHT_ASCENSION_CORDELIA: RotationalElement<18usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 4.49090669830661f64,
    c1: 0f64,
    c2: 0f64,
    c: [
        -0.002617993877991494f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        2.0202186091834364f64,
        2.4729570171507653f64,
        2.356718088967943f64,
        1.0780898789568973f64,
        4.351454891072263f64,
        0.7655014099247129f64,
        1.3554226970987964f64,
        2.746450110938277f64,
        1.776919711455427f64,
        2.419724474964938f64,
        1.784250094313803f64,
        5.522396286235258f64,
        5.3059754589879615f64,
        5.388005933831694f64,
        5.948431156647074f64,
        4.522846223618106f64,
        3.568500188627606f64,
        11.044792572470516f64,
    ],
    theta1: [
        959.7891933286942f64,
        731.077582955928f64,
        522.3307938967249f64,
        449.1358738582876f64,
        427.10754977009157f64,
        388.83160660922994f64,
        354.1171823199879f64,
        290.6454915444109f64,
        224.66977689099764f64,
        140.70512817020406f64,
        -35.32930378471962f64,
        49.9855316454168f64,
        -0.9065240134858548f64,
        -1.626123264083117f64,
        -1.314581992602129f64,
        -8.810596596992575f64,
        -70.65860756943924f64,
        99.9710632908336f64,
    ],
};
const DECLINATION_CORDELIA: RotationalElement<18usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: -0.2649409804527392f64,
    c1: 0f64,
    c2: 0f64,
    c: [
        0.0024434609527920616f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        2.0202186091834364f64,
        2.4729570171507653f64,
        2.356718088967943f64,
        1.0780898789568973f64,
        4.351454891072263f64,
        0.7655014099247129f64,
        1.3554226970987964f64,
        2.746450110938277f64,
        1.776919711455427f64,
        2.419724474964938f64,
        1.784250094313803f64,
        5.522396286235258f64,
        5.3059754589879615f64,
        5.388005933831694f64,
        5.948431156647074f64,
        4.522846223618106f64,
        3.568500188627606f64,
        11.044792572470516f64,
    ],
    theta1: [
        959.7891933286942f64,
        731.077582955928f64,
        522.3307938967249f64,
        449.1358738582876f64,
        427.10754977009157f64,
        388.83160660922994f64,
        354.1171823199879f64,
        290.6454915444109f64,
        224.66977689099764f64,
        140.70512817020406f64,
        -35.32930378471962f64,
        49.9855316454168f64,
        -0.9065240134858548f64,
        -1.626123264083117f64,
        -1.314581992602129f64,
        -8.810596596992575f64,
        -70.65860756943924f64,
        99.9710632908336f64,
    ],
};
const ROTATION_CORDELIA: RotationalElement<18usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 2.2286109218715593f64,
    c1: -18.753921879266084f64,
    c2: 0f64,
    c: [
        -0.0006981317007977319f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        2.0202186091834364f64,
        2.4729570171507653f64,
        2.356718088967943f64,
        1.0780898789568973f64,
        4.351454891072263f64,
        0.7655014099247129f64,
        1.3554226970987964f64,
        2.746450110938277f64,
        1.776919711455427f64,
        2.419724474964938f64,
        1.784250094313803f64,
        5.522396286235258f64,
        5.3059754589879615f64,
        5.388005933831694f64,
        5.948431156647074f64,
        4.522846223618106f64,
        3.568500188627606f64,
        11.044792572470516f64,
    ],
    theta1: [
        959.7891933286942f64,
        731.077582955928f64,
        522.3307938967249f64,
        449.1358738582876f64,
        427.10754977009157f64,
        388.83160660922994f64,
        354.1171823199879f64,
        290.6454915444109f64,
        224.66977689099764f64,
        140.70512817020406f64,
        -35.32930378471962f64,
        49.9855316454168f64,
        -0.9065240134858548f64,
        -1.626123264083117f64,
        -1.314581992602129f64,
        -8.810596596992575f64,
        -70.65860756943924f64,
        99.9710632908336f64,
    ],
};
impl RotationalElements for Cordelia {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_CORDELIA.angle(t),
            DECLINATION_CORDELIA.angle(t),
            ROTATION_CORDELIA.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_CORDELIA.angle_dot(t),
            DECLINATION_CORDELIA.angle_dot(t),
            ROTATION_CORDELIA.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Ophelia;
impl Origin for Ophelia {
    fn id(&self) -> NaifId {
        NaifId(707i32)
    }
    fn name(&self) -> &'static str {
        "Ophelia"
    }
}
impl Display for Ophelia {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl MeanRadius for Ophelia {
    fn mean_radius(&self) -> f64 {
        15f64
    }
}
impl TriaxialEllipsoid for Ophelia {
    fn radii(&self) -> Radii {
        (15f64, 15f64, 15f64)
    }
}
impl Spheroid for Ophelia {}
const RIGHT_ASCENSION_OPHELIA: RotationalElement<18usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 4.49090669830661f64,
    c1: 0f64,
    c2: 0f64,
    c: [
        0f64,
        -0.0015707963267948964f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        2.0202186091834364f64,
        2.4729570171507653f64,
        2.356718088967943f64,
        1.0780898789568973f64,
        4.351454891072263f64,
        0.7655014099247129f64,
        1.3554226970987964f64,
        2.746450110938277f64,
        1.776919711455427f64,
        2.419724474964938f64,
        1.784250094313803f64,
        5.522396286235258f64,
        5.3059754589879615f64,
        5.388005933831694f64,
        5.948431156647074f64,
        4.522846223618106f64,
        3.568500188627606f64,
        11.044792572470516f64,
    ],
    theta1: [
        959.7891933286942f64,
        731.077582955928f64,
        522.3307938967249f64,
        449.1358738582876f64,
        427.10754977009157f64,
        388.83160660922994f64,
        354.1171823199879f64,
        290.6454915444109f64,
        224.66977689099764f64,
        140.70512817020406f64,
        -35.32930378471962f64,
        49.9855316454168f64,
        -0.9065240134858548f64,
        -1.626123264083117f64,
        -1.314581992602129f64,
        -8.810596596992575f64,
        -70.65860756943924f64,
        99.9710632908336f64,
    ],
};
const DECLINATION_OPHELIA: RotationalElement<18usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: -0.2649409804527392f64,
    c1: 0f64,
    c2: 0f64,
    c: [
        0f64,
        0.0015707963267948964f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        2.0202186091834364f64,
        2.4729570171507653f64,
        2.356718088967943f64,
        1.0780898789568973f64,
        4.351454891072263f64,
        0.7655014099247129f64,
        1.3554226970987964f64,
        2.746450110938277f64,
        1.776919711455427f64,
        2.419724474964938f64,
        1.784250094313803f64,
        5.522396286235258f64,
        5.3059754589879615f64,
        5.388005933831694f64,
        5.948431156647074f64,
        4.522846223618106f64,
        3.568500188627606f64,
        11.044792572470516f64,
    ],
    theta1: [
        959.7891933286942f64,
        731.077582955928f64,
        522.3307938967249f64,
        449.1358738582876f64,
        427.10754977009157f64,
        388.83160660922994f64,
        354.1171823199879f64,
        290.6454915444109f64,
        224.66977689099764f64,
        140.70512817020406f64,
        -35.32930378471962f64,
        49.9855316454168f64,
        -0.9065240134858548f64,
        -1.626123264083117f64,
        -1.314581992602129f64,
        -8.810596596992575f64,
        -70.65860756943924f64,
        99.9710632908336f64,
    ],
};
const ROTATION_OPHELIA: RotationalElement<18usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 2.2750366799746087f64,
    c1: -16.692447910262292f64,
    c2: 0f64,
    c: [
        0f64,
        -0.0005235987755982988f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        2.0202186091834364f64,
        2.4729570171507653f64,
        2.356718088967943f64,
        1.0780898789568973f64,
        4.351454891072263f64,
        0.7655014099247129f64,
        1.3554226970987964f64,
        2.746450110938277f64,
        1.776919711455427f64,
        2.419724474964938f64,
        1.784250094313803f64,
        5.522396286235258f64,
        5.3059754589879615f64,
        5.388005933831694f64,
        5.948431156647074f64,
        4.522846223618106f64,
        3.568500188627606f64,
        11.044792572470516f64,
    ],
    theta1: [
        959.7891933286942f64,
        731.077582955928f64,
        522.3307938967249f64,
        449.1358738582876f64,
        427.10754977009157f64,
        388.83160660922994f64,
        354.1171823199879f64,
        290.6454915444109f64,
        224.66977689099764f64,
        140.70512817020406f64,
        -35.32930378471962f64,
        49.9855316454168f64,
        -0.9065240134858548f64,
        -1.626123264083117f64,
        -1.314581992602129f64,
        -8.810596596992575f64,
        -70.65860756943924f64,
        99.9710632908336f64,
    ],
};
impl RotationalElements for Ophelia {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_OPHELIA.angle(t),
            DECLINATION_OPHELIA.angle(t),
            ROTATION_OPHELIA.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_OPHELIA.angle_dot(t),
            DECLINATION_OPHELIA.angle_dot(t),
            ROTATION_OPHELIA.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Bianca;
impl Origin for Bianca {
    fn id(&self) -> NaifId {
        NaifId(708i32)
    }
    fn name(&self) -> &'static str {
        "Bianca"
    }
}
impl Display for Bianca {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl MeanRadius for Bianca {
    fn mean_radius(&self) -> f64 {
        21f64
    }
}
impl TriaxialEllipsoid for Bianca {
    fn radii(&self) -> Radii {
        (21f64, 21f64, 21f64)
    }
}
impl Spheroid for Bianca {}
const RIGHT_ASCENSION_BIANCA: RotationalElement<18usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 4.49090669830661f64,
    c1: 0f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        -0.0027925268031909274f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        2.0202186091834364f64,
        2.4729570171507653f64,
        2.356718088967943f64,
        1.0780898789568973f64,
        4.351454891072263f64,
        0.7655014099247129f64,
        1.3554226970987964f64,
        2.746450110938277f64,
        1.776919711455427f64,
        2.419724474964938f64,
        1.784250094313803f64,
        5.522396286235258f64,
        5.3059754589879615f64,
        5.388005933831694f64,
        5.948431156647074f64,
        4.522846223618106f64,
        3.568500188627606f64,
        11.044792572470516f64,
    ],
    theta1: [
        959.7891933286942f64,
        731.077582955928f64,
        522.3307938967249f64,
        449.1358738582876f64,
        427.10754977009157f64,
        388.83160660922994f64,
        354.1171823199879f64,
        290.6454915444109f64,
        224.66977689099764f64,
        140.70512817020406f64,
        -35.32930378471962f64,
        49.9855316454168f64,
        -0.9065240134858548f64,
        -1.626123264083117f64,
        -1.314581992602129f64,
        -8.810596596992575f64,
        -70.65860756943924f64,
        99.9710632908336f64,
    ],
};
const DECLINATION_BIANCA: RotationalElement<18usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: -0.2649409804527392f64,
    c1: 0f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0.0027925268031909274f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        2.0202186091834364f64,
        2.4729570171507653f64,
        2.356718088967943f64,
        1.0780898789568973f64,
        4.351454891072263f64,
        0.7655014099247129f64,
        1.3554226970987964f64,
        2.746450110938277f64,
        1.776919711455427f64,
        2.419724474964938f64,
        1.784250094313803f64,
        5.522396286235258f64,
        5.3059754589879615f64,
        5.388005933831694f64,
        5.948431156647074f64,
        4.522846223618106f64,
        3.568500188627606f64,
        11.044792572470516f64,
    ],
    theta1: [
        959.7891933286942f64,
        731.077582955928f64,
        522.3307938967249f64,
        449.1358738582876f64,
        427.10754977009157f64,
        388.83160660922994f64,
        354.1171823199879f64,
        290.6454915444109f64,
        224.66977689099764f64,
        140.70512817020406f64,
        -35.32930378471962f64,
        49.9855316454168f64,
        -0.9065240134858548f64,
        -1.626123264083117f64,
        -1.314581992602129f64,
        -8.810596596992575f64,
        -70.65860756943924f64,
        99.9710632908336f64,
    ],
};
const ROTATION_BIANCA: RotationalElement<18usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 1.8406242291532198f64,
    c1: -14.458158751655587f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        -0.0006981317007977319f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        2.0202186091834364f64,
        2.4729570171507653f64,
        2.356718088967943f64,
        1.0780898789568973f64,
        4.351454891072263f64,
        0.7655014099247129f64,
        1.3554226970987964f64,
        2.746450110938277f64,
        1.776919711455427f64,
        2.419724474964938f64,
        1.784250094313803f64,
        5.522396286235258f64,
        5.3059754589879615f64,
        5.388005933831694f64,
        5.948431156647074f64,
        4.522846223618106f64,
        3.568500188627606f64,
        11.044792572470516f64,
    ],
    theta1: [
        959.7891933286942f64,
        731.077582955928f64,
        522.3307938967249f64,
        449.1358738582876f64,
        427.10754977009157f64,
        388.83160660922994f64,
        354.1171823199879f64,
        290.6454915444109f64,
        224.66977689099764f64,
        140.70512817020406f64,
        -35.32930378471962f64,
        49.9855316454168f64,
        -0.9065240134858548f64,
        -1.626123264083117f64,
        -1.314581992602129f64,
        -8.810596596992575f64,
        -70.65860756943924f64,
        99.9710632908336f64,
    ],
};
impl RotationalElements for Bianca {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_BIANCA.angle(t),
            DECLINATION_BIANCA.angle(t),
            ROTATION_BIANCA.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_BIANCA.angle_dot(t),
            DECLINATION_BIANCA.angle_dot(t),
            ROTATION_BIANCA.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Cressida;
impl Origin for Cressida {
    fn id(&self) -> NaifId {
        NaifId(709i32)
    }
    fn name(&self) -> &'static str {
        "Cressida"
    }
}
impl Display for Cressida {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl MeanRadius for Cressida {
    fn mean_radius(&self) -> f64 {
        31f64
    }
}
impl TriaxialEllipsoid for Cressida {
    fn radii(&self) -> Radii {
        (31f64, 31f64, 31f64)
    }
}
impl Spheroid for Cressida {}
const RIGHT_ASCENSION_CRESSIDA: RotationalElement<18usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 4.49090669830661f64,
    c1: 0f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        -0.0006981317007977319f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        2.0202186091834364f64,
        2.4729570171507653f64,
        2.356718088967943f64,
        1.0780898789568973f64,
        4.351454891072263f64,
        0.7655014099247129f64,
        1.3554226970987964f64,
        2.746450110938277f64,
        1.776919711455427f64,
        2.419724474964938f64,
        1.784250094313803f64,
        5.522396286235258f64,
        5.3059754589879615f64,
        5.388005933831694f64,
        5.948431156647074f64,
        4.522846223618106f64,
        3.568500188627606f64,
        11.044792572470516f64,
    ],
    theta1: [
        959.7891933286942f64,
        731.077582955928f64,
        522.3307938967249f64,
        449.1358738582876f64,
        427.10754977009157f64,
        388.83160660922994f64,
        354.1171823199879f64,
        290.6454915444109f64,
        224.66977689099764f64,
        140.70512817020406f64,
        -35.32930378471962f64,
        49.9855316454168f64,
        -0.9065240134858548f64,
        -1.626123264083117f64,
        -1.314581992602129f64,
        -8.810596596992575f64,
        -70.65860756943924f64,
        99.9710632908336f64,
    ],
};
const DECLINATION_CRESSIDA: RotationalElement<18usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: -0.2649409804527392f64,
    c1: 0f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0.0006981317007977319f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        2.0202186091834364f64,
        2.4729570171507653f64,
        2.356718088967943f64,
        1.0780898789568973f64,
        4.351454891072263f64,
        0.7655014099247129f64,
        1.3554226970987964f64,
        2.746450110938277f64,
        1.776919711455427f64,
        2.419724474964938f64,
        1.784250094313803f64,
        5.522396286235258f64,
        5.3059754589879615f64,
        5.388005933831694f64,
        5.948431156647074f64,
        4.522846223618106f64,
        3.568500188627606f64,
        11.044792572470516f64,
    ],
    theta1: [
        959.7891933286942f64,
        731.077582955928f64,
        522.3307938967249f64,
        449.1358738582876f64,
        427.10754977009157f64,
        388.83160660922994f64,
        354.1171823199879f64,
        290.6454915444109f64,
        224.66977689099764f64,
        140.70512817020406f64,
        -35.32930378471962f64,
        49.9855316454168f64,
        -0.9065240134858548f64,
        -1.626123264083117f64,
        -1.314581992602129f64,
        -8.810596596992575f64,
        -70.65860756943924f64,
        99.9710632908336f64,
    ],
};
const ROTATION_CRESSIDA: RotationalElement<18usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 1.0325367854798453f64,
    c1: -13.553906388910956f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        -0.00017453292519943296f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        2.0202186091834364f64,
        2.4729570171507653f64,
        2.356718088967943f64,
        1.0780898789568973f64,
        4.351454891072263f64,
        0.7655014099247129f64,
        1.3554226970987964f64,
        2.746450110938277f64,
        1.776919711455427f64,
        2.419724474964938f64,
        1.784250094313803f64,
        5.522396286235258f64,
        5.3059754589879615f64,
        5.388005933831694f64,
        5.948431156647074f64,
        4.522846223618106f64,
        3.568500188627606f64,
        11.044792572470516f64,
    ],
    theta1: [
        959.7891933286942f64,
        731.077582955928f64,
        522.3307938967249f64,
        449.1358738582876f64,
        427.10754977009157f64,
        388.83160660922994f64,
        354.1171823199879f64,
        290.6454915444109f64,
        224.66977689099764f64,
        140.70512817020406f64,
        -35.32930378471962f64,
        49.9855316454168f64,
        -0.9065240134858548f64,
        -1.626123264083117f64,
        -1.314581992602129f64,
        -8.810596596992575f64,
        -70.65860756943924f64,
        99.9710632908336f64,
    ],
};
impl RotationalElements for Cressida {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_CRESSIDA.angle(t),
            DECLINATION_CRESSIDA.angle(t),
            ROTATION_CRESSIDA.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_CRESSIDA.angle_dot(t),
            DECLINATION_CRESSIDA.angle_dot(t),
            ROTATION_CRESSIDA.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Desdemona;
impl Origin for Desdemona {
    fn id(&self) -> NaifId {
        NaifId(710i32)
    }
    fn name(&self) -> &'static str {
        "Desdemona"
    }
}
impl Display for Desdemona {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl MeanRadius for Desdemona {
    fn mean_radius(&self) -> f64 {
        27f64
    }
}
impl TriaxialEllipsoid for Desdemona {
    fn radii(&self) -> Radii {
        (27f64, 27f64, 27f64)
    }
}
impl Spheroid for Desdemona {}
const RIGHT_ASCENSION_DESDEMONA: RotationalElement<18usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 4.49090669830661f64,
    c1: 0f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        -0.0029670597283903604f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        2.0202186091834364f64,
        2.4729570171507653f64,
        2.356718088967943f64,
        1.0780898789568973f64,
        4.351454891072263f64,
        0.7655014099247129f64,
        1.3554226970987964f64,
        2.746450110938277f64,
        1.776919711455427f64,
        2.419724474964938f64,
        1.784250094313803f64,
        5.522396286235258f64,
        5.3059754589879615f64,
        5.388005933831694f64,
        5.948431156647074f64,
        4.522846223618106f64,
        3.568500188627606f64,
        11.044792572470516f64,
    ],
    theta1: [
        959.7891933286942f64,
        731.077582955928f64,
        522.3307938967249f64,
        449.1358738582876f64,
        427.10754977009157f64,
        388.83160660922994f64,
        354.1171823199879f64,
        290.6454915444109f64,
        224.66977689099764f64,
        140.70512817020406f64,
        -35.32930378471962f64,
        49.9855316454168f64,
        -0.9065240134858548f64,
        -1.626123264083117f64,
        -1.314581992602129f64,
        -8.810596596992575f64,
        -70.65860756943924f64,
        99.9710632908336f64,
    ],
};
const DECLINATION_DESDEMONA: RotationalElement<18usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: -0.2649409804527392f64,
    c1: 0f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        0.0027925268031909274f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        2.0202186091834364f64,
        2.4729570171507653f64,
        2.356718088967943f64,
        1.0780898789568973f64,
        4.351454891072263f64,
        0.7655014099247129f64,
        1.3554226970987964f64,
        2.746450110938277f64,
        1.776919711455427f64,
        2.419724474964938f64,
        1.784250094313803f64,
        5.522396286235258f64,
        5.3059754589879615f64,
        5.388005933831694f64,
        5.948431156647074f64,
        4.522846223618106f64,
        3.568500188627606f64,
        11.044792572470516f64,
    ],
    theta1: [
        959.7891933286942f64,
        731.077582955928f64,
        522.3307938967249f64,
        449.1358738582876f64,
        427.10754977009157f64,
        388.83160660922994f64,
        354.1171823199879f64,
        290.6454915444109f64,
        224.66977689099764f64,
        140.70512817020406f64,
        -35.32930378471962f64,
        49.9855316454168f64,
        -0.9065240134858548f64,
        -1.626123264083117f64,
        -1.314581992602129f64,
        -8.810596596992575f64,
        -70.65860756943924f64,
        99.9710632908336f64,
    ],
};
const ROTATION_DESDEMONA: RotationalElement<18usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 1.6594590527962085f64,
    c1: -13.265430289266899f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        -0.0006981317007977319f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        2.0202186091834364f64,
        2.4729570171507653f64,
        2.356718088967943f64,
        1.0780898789568973f64,
        4.351454891072263f64,
        0.7655014099247129f64,
        1.3554226970987964f64,
        2.746450110938277f64,
        1.776919711455427f64,
        2.419724474964938f64,
        1.784250094313803f64,
        5.522396286235258f64,
        5.3059754589879615f64,
        5.388005933831694f64,
        5.948431156647074f64,
        4.522846223618106f64,
        3.568500188627606f64,
        11.044792572470516f64,
    ],
    theta1: [
        959.7891933286942f64,
        731.077582955928f64,
        522.3307938967249f64,
        449.1358738582876f64,
        427.10754977009157f64,
        388.83160660922994f64,
        354.1171823199879f64,
        290.6454915444109f64,
        224.66977689099764f64,
        140.70512817020406f64,
        -35.32930378471962f64,
        49.9855316454168f64,
        -0.9065240134858548f64,
        -1.626123264083117f64,
        -1.314581992602129f64,
        -8.810596596992575f64,
        -70.65860756943924f64,
        99.9710632908336f64,
    ],
};
impl RotationalElements for Desdemona {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_DESDEMONA.angle(t),
            DECLINATION_DESDEMONA.angle(t),
            ROTATION_DESDEMONA.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_DESDEMONA.angle_dot(t),
            DECLINATION_DESDEMONA.angle_dot(t),
            ROTATION_DESDEMONA.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Juliet;
impl Origin for Juliet {
    fn id(&self) -> NaifId {
        NaifId(711i32)
    }
    fn name(&self) -> &'static str {
        "Juliet"
    }
}
impl Display for Juliet {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl MeanRadius for Juliet {
    fn mean_radius(&self) -> f64 {
        42f64
    }
}
impl TriaxialEllipsoid for Juliet {
    fn radii(&self) -> Radii {
        (42f64, 42f64, 42f64)
    }
}
impl Spheroid for Juliet {}
const RIGHT_ASCENSION_JULIET: RotationalElement<18usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 4.49090669830661f64,
    c1: 0f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        -0.0010471975511965976f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        2.0202186091834364f64,
        2.4729570171507653f64,
        2.356718088967943f64,
        1.0780898789568973f64,
        4.351454891072263f64,
        0.7655014099247129f64,
        1.3554226970987964f64,
        2.746450110938277f64,
        1.776919711455427f64,
        2.419724474964938f64,
        1.784250094313803f64,
        5.522396286235258f64,
        5.3059754589879615f64,
        5.388005933831694f64,
        5.948431156647074f64,
        4.522846223618106f64,
        3.568500188627606f64,
        11.044792572470516f64,
    ],
    theta1: [
        959.7891933286942f64,
        731.077582955928f64,
        522.3307938967249f64,
        449.1358738582876f64,
        427.10754977009157f64,
        388.83160660922994f64,
        354.1171823199879f64,
        290.6454915444109f64,
        224.66977689099764f64,
        140.70512817020406f64,
        -35.32930378471962f64,
        49.9855316454168f64,
        -0.9065240134858548f64,
        -1.626123264083117f64,
        -1.314581992602129f64,
        -8.810596596992575f64,
        -70.65860756943924f64,
        99.9710632908336f64,
    ],
};
const DECLINATION_JULIET: RotationalElement<18usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: -0.2649409804527392f64,
    c1: 0f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0.0010471975511965976f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        2.0202186091834364f64,
        2.4729570171507653f64,
        2.356718088967943f64,
        1.0780898789568973f64,
        4.351454891072263f64,
        0.7655014099247129f64,
        1.3554226970987964f64,
        2.746450110938277f64,
        1.776919711455427f64,
        2.419724474964938f64,
        1.784250094313803f64,
        5.522396286235258f64,
        5.3059754589879615f64,
        5.388005933831694f64,
        5.948431156647074f64,
        4.522846223618106f64,
        3.568500188627606f64,
        11.044792572470516f64,
    ],
    theta1: [
        959.7891933286942f64,
        731.077582955928f64,
        522.3307938967249f64,
        449.1358738582876f64,
        427.10754977009157f64,
        388.83160660922994f64,
        354.1171823199879f64,
        290.6454915444109f64,
        224.66977689099764f64,
        140.70512817020406f64,
        -35.32930378471962f64,
        49.9855316454168f64,
        -0.9065240134858548f64,
        -1.626123264083117f64,
        -1.314581992602129f64,
        -8.810596596992575f64,
        -70.65860756943924f64,
        99.9710632908336f64,
    ],
};
const ROTATION_JULIET: RotationalElement<18usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 5.2806681848340435f64,
    c1: -12.74309158902866f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        -0.00034906585039886593f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        2.0202186091834364f64,
        2.4729570171507653f64,
        2.356718088967943f64,
        1.0780898789568973f64,
        4.351454891072263f64,
        0.7655014099247129f64,
        1.3554226970987964f64,
        2.746450110938277f64,
        1.776919711455427f64,
        2.419724474964938f64,
        1.784250094313803f64,
        5.522396286235258f64,
        5.3059754589879615f64,
        5.388005933831694f64,
        5.948431156647074f64,
        4.522846223618106f64,
        3.568500188627606f64,
        11.044792572470516f64,
    ],
    theta1: [
        959.7891933286942f64,
        731.077582955928f64,
        522.3307938967249f64,
        449.1358738582876f64,
        427.10754977009157f64,
        388.83160660922994f64,
        354.1171823199879f64,
        290.6454915444109f64,
        224.66977689099764f64,
        140.70512817020406f64,
        -35.32930378471962f64,
        49.9855316454168f64,
        -0.9065240134858548f64,
        -1.626123264083117f64,
        -1.314581992602129f64,
        -8.810596596992575f64,
        -70.65860756943924f64,
        99.9710632908336f64,
    ],
};
impl RotationalElements for Juliet {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_JULIET.angle(t),
            DECLINATION_JULIET.angle(t),
            ROTATION_JULIET.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_JULIET.angle_dot(t),
            DECLINATION_JULIET.angle_dot(t),
            ROTATION_JULIET.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Portia;
impl Origin for Portia {
    fn id(&self) -> NaifId {
        NaifId(712i32)
    }
    fn name(&self) -> &'static str {
        "Portia"
    }
}
impl Display for Portia {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl MeanRadius for Portia {
    fn mean_radius(&self) -> f64 {
        54f64
    }
}
impl TriaxialEllipsoid for Portia {
    fn radii(&self) -> Radii {
        (54f64, 54f64, 54f64)
    }
}
impl Spheroid for Portia {}
const RIGHT_ASCENSION_PORTIA: RotationalElement<18usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 4.49090669830661f64,
    c1: 0f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        -0.0015707963267948964f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        2.0202186091834364f64,
        2.4729570171507653f64,
        2.356718088967943f64,
        1.0780898789568973f64,
        4.351454891072263f64,
        0.7655014099247129f64,
        1.3554226970987964f64,
        2.746450110938277f64,
        1.776919711455427f64,
        2.419724474964938f64,
        1.784250094313803f64,
        5.522396286235258f64,
        5.3059754589879615f64,
        5.388005933831694f64,
        5.948431156647074f64,
        4.522846223618106f64,
        3.568500188627606f64,
        11.044792572470516f64,
    ],
    theta1: [
        959.7891933286942f64,
        731.077582955928f64,
        522.3307938967249f64,
        449.1358738582876f64,
        427.10754977009157f64,
        388.83160660922994f64,
        354.1171823199879f64,
        290.6454915444109f64,
        224.66977689099764f64,
        140.70512817020406f64,
        -35.32930378471962f64,
        49.9855316454168f64,
        -0.9065240134858548f64,
        -1.626123264083117f64,
        -1.314581992602129f64,
        -8.810596596992575f64,
        -70.65860756943924f64,
        99.9710632908336f64,
    ],
};
const DECLINATION_PORTIA: RotationalElement<18usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: -0.2649409804527392f64,
    c1: 0f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0.0015707963267948964f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        2.0202186091834364f64,
        2.4729570171507653f64,
        2.356718088967943f64,
        1.0780898789568973f64,
        4.351454891072263f64,
        0.7655014099247129f64,
        1.3554226970987964f64,
        2.746450110938277f64,
        1.776919711455427f64,
        2.419724474964938f64,
        1.784250094313803f64,
        5.522396286235258f64,
        5.3059754589879615f64,
        5.388005933831694f64,
        5.948431156647074f64,
        4.522846223618106f64,
        3.568500188627606f64,
        11.044792572470516f64,
    ],
    theta1: [
        959.7891933286942f64,
        731.077582955928f64,
        522.3307938967249f64,
        449.1358738582876f64,
        427.10754977009157f64,
        388.83160660922994f64,
        354.1171823199879f64,
        290.6454915444109f64,
        224.66977689099764f64,
        140.70512817020406f64,
        -35.32930378471962f64,
        49.9855316454168f64,
        -0.9065240134858548f64,
        -1.626123264083117f64,
        -1.314581992602129f64,
        -8.810596596992575f64,
        -70.65860756943924f64,
        99.9710632908336f64,
    ],
};
const ROTATION_PORTIA: RotationalElement<18usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 0.4368559117741807f64,
    c1: -12.243250601727652f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        -0.00034906585039886593f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        2.0202186091834364f64,
        2.4729570171507653f64,
        2.356718088967943f64,
        1.0780898789568973f64,
        4.351454891072263f64,
        0.7655014099247129f64,
        1.3554226970987964f64,
        2.746450110938277f64,
        1.776919711455427f64,
        2.419724474964938f64,
        1.784250094313803f64,
        5.522396286235258f64,
        5.3059754589879615f64,
        5.388005933831694f64,
        5.948431156647074f64,
        4.522846223618106f64,
        3.568500188627606f64,
        11.044792572470516f64,
    ],
    theta1: [
        959.7891933286942f64,
        731.077582955928f64,
        522.3307938967249f64,
        449.1358738582876f64,
        427.10754977009157f64,
        388.83160660922994f64,
        354.1171823199879f64,
        290.6454915444109f64,
        224.66977689099764f64,
        140.70512817020406f64,
        -35.32930378471962f64,
        49.9855316454168f64,
        -0.9065240134858548f64,
        -1.626123264083117f64,
        -1.314581992602129f64,
        -8.810596596992575f64,
        -70.65860756943924f64,
        99.9710632908336f64,
    ],
};
impl RotationalElements for Portia {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_PORTIA.angle(t),
            DECLINATION_PORTIA.angle(t),
            ROTATION_PORTIA.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_PORTIA.angle_dot(t),
            DECLINATION_PORTIA.angle_dot(t),
            ROTATION_PORTIA.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Rosalind;
impl Origin for Rosalind {
    fn id(&self) -> NaifId {
        NaifId(713i32)
    }
    fn name(&self) -> &'static str {
        "Rosalind"
    }
}
impl Display for Rosalind {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl MeanRadius for Rosalind {
    fn mean_radius(&self) -> f64 {
        27f64
    }
}
impl TriaxialEllipsoid for Rosalind {
    fn radii(&self) -> Radii {
        (27f64, 27f64, 27f64)
    }
}
impl Spheroid for Rosalind {}
const RIGHT_ASCENSION_ROSALIND: RotationalElement<18usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 4.49090669830661f64,
    c1: 0f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        -0.005061454830783556f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        2.0202186091834364f64,
        2.4729570171507653f64,
        2.356718088967943f64,
        1.0780898789568973f64,
        4.351454891072263f64,
        0.7655014099247129f64,
        1.3554226970987964f64,
        2.746450110938277f64,
        1.776919711455427f64,
        2.419724474964938f64,
        1.784250094313803f64,
        5.522396286235258f64,
        5.3059754589879615f64,
        5.388005933831694f64,
        5.948431156647074f64,
        4.522846223618106f64,
        3.568500188627606f64,
        11.044792572470516f64,
    ],
    theta1: [
        959.7891933286942f64,
        731.077582955928f64,
        522.3307938967249f64,
        449.1358738582876f64,
        427.10754977009157f64,
        388.83160660922994f64,
        354.1171823199879f64,
        290.6454915444109f64,
        224.66977689099764f64,
        140.70512817020406f64,
        -35.32930378471962f64,
        49.9855316454168f64,
        -0.9065240134858548f64,
        -1.626123264083117f64,
        -1.314581992602129f64,
        -8.810596596992575f64,
        -70.65860756943924f64,
        99.9710632908336f64,
    ],
};
const DECLINATION_ROSALIND: RotationalElement<18usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: -0.2649409804527392f64,
    c1: 0f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0.004886921905584123f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        2.0202186091834364f64,
        2.4729570171507653f64,
        2.356718088967943f64,
        1.0780898789568973f64,
        4.351454891072263f64,
        0.7655014099247129f64,
        1.3554226970987964f64,
        2.746450110938277f64,
        1.776919711455427f64,
        2.419724474964938f64,
        1.784250094313803f64,
        5.522396286235258f64,
        5.3059754589879615f64,
        5.388005933831694f64,
        5.948431156647074f64,
        4.522846223618106f64,
        3.568500188627606f64,
        11.044792572470516f64,
    ],
    theta1: [
        959.7891933286942f64,
        731.077582955928f64,
        522.3307938967249f64,
        449.1358738582876f64,
        427.10754977009157f64,
        388.83160660922994f64,
        354.1171823199879f64,
        290.6454915444109f64,
        224.66977689099764f64,
        140.70512817020406f64,
        -35.32930378471962f64,
        49.9855316454168f64,
        -0.9065240134858548f64,
        -1.626123264083117f64,
        -1.314581992602129f64,
        -8.810596596992575f64,
        -70.65860756943924f64,
        99.9710632908336f64,
    ],
};
const ROTATION_ROSALIND: RotationalElement<18usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 5.496041814530144f64,
    c1: -11.250935609538423f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        -0.0013962634015954637f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        2.0202186091834364f64,
        2.4729570171507653f64,
        2.356718088967943f64,
        1.0780898789568973f64,
        4.351454891072263f64,
        0.7655014099247129f64,
        1.3554226970987964f64,
        2.746450110938277f64,
        1.776919711455427f64,
        2.419724474964938f64,
        1.784250094313803f64,
        5.522396286235258f64,
        5.3059754589879615f64,
        5.388005933831694f64,
        5.948431156647074f64,
        4.522846223618106f64,
        3.568500188627606f64,
        11.044792572470516f64,
    ],
    theta1: [
        959.7891933286942f64,
        731.077582955928f64,
        522.3307938967249f64,
        449.1358738582876f64,
        427.10754977009157f64,
        388.83160660922994f64,
        354.1171823199879f64,
        290.6454915444109f64,
        224.66977689099764f64,
        140.70512817020406f64,
        -35.32930378471962f64,
        49.9855316454168f64,
        -0.9065240134858548f64,
        -1.626123264083117f64,
        -1.314581992602129f64,
        -8.810596596992575f64,
        -70.65860756943924f64,
        99.9710632908336f64,
    ],
};
impl RotationalElements for Rosalind {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_ROSALIND.angle(t),
            DECLINATION_ROSALIND.angle(t),
            ROTATION_ROSALIND.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_ROSALIND.angle_dot(t),
            DECLINATION_ROSALIND.angle_dot(t),
            ROTATION_ROSALIND.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Belinda;
impl Origin for Belinda {
    fn id(&self) -> NaifId {
        NaifId(714i32)
    }
    fn name(&self) -> &'static str {
        "Belinda"
    }
}
impl Display for Belinda {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl MeanRadius for Belinda {
    fn mean_radius(&self) -> f64 {
        33f64
    }
}
impl TriaxialEllipsoid for Belinda {
    fn radii(&self) -> Radii {
        (33f64, 33f64, 33f64)
    }
}
impl Spheroid for Belinda {}
const RIGHT_ASCENSION_BELINDA: RotationalElement<18usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 4.49090669830661f64,
    c1: 0f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        -0.0005235987755982988f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        2.0202186091834364f64,
        2.4729570171507653f64,
        2.356718088967943f64,
        1.0780898789568973f64,
        4.351454891072263f64,
        0.7655014099247129f64,
        1.3554226970987964f64,
        2.746450110938277f64,
        1.776919711455427f64,
        2.419724474964938f64,
        1.784250094313803f64,
        5.522396286235258f64,
        5.3059754589879615f64,
        5.388005933831694f64,
        5.948431156647074f64,
        4.522846223618106f64,
        3.568500188627606f64,
        11.044792572470516f64,
    ],
    theta1: [
        959.7891933286942f64,
        731.077582955928f64,
        522.3307938967249f64,
        449.1358738582876f64,
        427.10754977009157f64,
        388.83160660922994f64,
        354.1171823199879f64,
        290.6454915444109f64,
        224.66977689099764f64,
        140.70512817020406f64,
        -35.32930378471962f64,
        49.9855316454168f64,
        -0.9065240134858548f64,
        -1.626123264083117f64,
        -1.314581992602129f64,
        -8.810596596992575f64,
        -70.65860756943924f64,
        99.9710632908336f64,
    ],
};
const DECLINATION_BELINDA: RotationalElement<18usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: -0.2649409804527392f64,
    c1: 0f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0.0005235987755982988f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        2.0202186091834364f64,
        2.4729570171507653f64,
        2.356718088967943f64,
        1.0780898789568973f64,
        4.351454891072263f64,
        0.7655014099247129f64,
        1.3554226970987964f64,
        2.746450110938277f64,
        1.776919711455427f64,
        2.419724474964938f64,
        1.784250094313803f64,
        5.522396286235258f64,
        5.3059754589879615f64,
        5.388005933831694f64,
        5.948431156647074f64,
        4.522846223618106f64,
        3.568500188627606f64,
        11.044792572470516f64,
    ],
    theta1: [
        959.7891933286942f64,
        731.077582955928f64,
        522.3307938967249f64,
        449.1358738582876f64,
        427.10754977009157f64,
        388.83160660922994f64,
        354.1171823199879f64,
        290.6454915444109f64,
        224.66977689099764f64,
        140.70512817020406f64,
        -35.32930378471962f64,
        49.9855316454168f64,
        -0.9065240134858548f64,
        -1.626123264083117f64,
        -1.314581992602129f64,
        -8.810596596992575f64,
        -70.65860756943924f64,
        99.9710632908336f64,
    ],
};
const ROTATION_BELINDA: RotationalElement<18usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 5.191656392982332f64,
    c1: -10.076882135239488f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        -0.00017453292519943296f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        2.0202186091834364f64,
        2.4729570171507653f64,
        2.356718088967943f64,
        1.0780898789568973f64,
        4.351454891072263f64,
        0.7655014099247129f64,
        1.3554226970987964f64,
        2.746450110938277f64,
        1.776919711455427f64,
        2.419724474964938f64,
        1.784250094313803f64,
        5.522396286235258f64,
        5.3059754589879615f64,
        5.388005933831694f64,
        5.948431156647074f64,
        4.522846223618106f64,
        3.568500188627606f64,
        11.044792572470516f64,
    ],
    theta1: [
        959.7891933286942f64,
        731.077582955928f64,
        522.3307938967249f64,
        449.1358738582876f64,
        427.10754977009157f64,
        388.83160660922994f64,
        354.1171823199879f64,
        290.6454915444109f64,
        224.66977689099764f64,
        140.70512817020406f64,
        -35.32930378471962f64,
        49.9855316454168f64,
        -0.9065240134858548f64,
        -1.626123264083117f64,
        -1.314581992602129f64,
        -8.810596596992575f64,
        -70.65860756943924f64,
        99.9710632908336f64,
    ],
};
impl RotationalElements for Belinda {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_BELINDA.angle(t),
            DECLINATION_BELINDA.angle(t),
            ROTATION_BELINDA.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_BELINDA.angle_dot(t),
            DECLINATION_BELINDA.angle_dot(t),
            ROTATION_BELINDA.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Puck;
impl Origin for Puck {
    fn id(&self) -> NaifId {
        NaifId(715i32)
    }
    fn name(&self) -> &'static str {
        "Puck"
    }
}
impl Display for Puck {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl MeanRadius for Puck {
    fn mean_radius(&self) -> f64 {
        77f64
    }
}
impl TriaxialEllipsoid for Puck {
    fn radii(&self) -> Radii {
        (77f64, 77f64, 77f64)
    }
}
impl Spheroid for Puck {}
const RIGHT_ASCENSION_PUCK: RotationalElement<18usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 4.49090669830661f64,
    c1: 0f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        -0.005759586531581287f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        2.0202186091834364f64,
        2.4729570171507653f64,
        2.356718088967943f64,
        1.0780898789568973f64,
        4.351454891072263f64,
        0.7655014099247129f64,
        1.3554226970987964f64,
        2.746450110938277f64,
        1.776919711455427f64,
        2.419724474964938f64,
        1.784250094313803f64,
        5.522396286235258f64,
        5.3059754589879615f64,
        5.388005933831694f64,
        5.948431156647074f64,
        4.522846223618106f64,
        3.568500188627606f64,
        11.044792572470516f64,
    ],
    theta1: [
        959.7891933286942f64,
        731.077582955928f64,
        522.3307938967249f64,
        449.1358738582876f64,
        427.10754977009157f64,
        388.83160660922994f64,
        354.1171823199879f64,
        290.6454915444109f64,
        224.66977689099764f64,
        140.70512817020406f64,
        -35.32930378471962f64,
        49.9855316454168f64,
        -0.9065240134858548f64,
        -1.626123264083117f64,
        -1.314581992602129f64,
        -8.810596596992575f64,
        -70.65860756943924f64,
        99.9710632908336f64,
    ],
};
const DECLINATION_PUCK: RotationalElement<18usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: -0.2649409804527392f64,
    c1: 0f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0.0054105206811824215f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        2.0202186091834364f64,
        2.4729570171507653f64,
        2.356718088967943f64,
        1.0780898789568973f64,
        4.351454891072263f64,
        0.7655014099247129f64,
        1.3554226970987964f64,
        2.746450110938277f64,
        1.776919711455427f64,
        2.419724474964938f64,
        1.784250094313803f64,
        5.522396286235258f64,
        5.3059754589879615f64,
        5.388005933831694f64,
        5.948431156647074f64,
        4.522846223618106f64,
        3.568500188627606f64,
        11.044792572470516f64,
    ],
    theta1: [
        959.7891933286942f64,
        731.077582955928f64,
        522.3307938967249f64,
        449.1358738582876f64,
        427.10754977009157f64,
        388.83160660922994f64,
        354.1171823199879f64,
        290.6454915444109f64,
        224.66977689099764f64,
        140.70512817020406f64,
        -35.32930378471962f64,
        49.9855316454168f64,
        -0.9065240134858548f64,
        -1.626123264083117f64,
        -1.314581992602129f64,
        -8.810596596992575f64,
        -70.65860756943924f64,
        99.9710632908336f64,
    ],
};
const ROTATION_PUCK: RotationalElement<18usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 1.5924384095196262f64,
    c1: -8.247467318113788f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        -0.0015707963267948964f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        2.0202186091834364f64,
        2.4729570171507653f64,
        2.356718088967943f64,
        1.0780898789568973f64,
        4.351454891072263f64,
        0.7655014099247129f64,
        1.3554226970987964f64,
        2.746450110938277f64,
        1.776919711455427f64,
        2.419724474964938f64,
        1.784250094313803f64,
        5.522396286235258f64,
        5.3059754589879615f64,
        5.388005933831694f64,
        5.948431156647074f64,
        4.522846223618106f64,
        3.568500188627606f64,
        11.044792572470516f64,
    ],
    theta1: [
        959.7891933286942f64,
        731.077582955928f64,
        522.3307938967249f64,
        449.1358738582876f64,
        427.10754977009157f64,
        388.83160660922994f64,
        354.1171823199879f64,
        290.6454915444109f64,
        224.66977689099764f64,
        140.70512817020406f64,
        -35.32930378471962f64,
        49.9855316454168f64,
        -0.9065240134858548f64,
        -1.626123264083117f64,
        -1.314581992602129f64,
        -8.810596596992575f64,
        -70.65860756943924f64,
        99.9710632908336f64,
    ],
};
impl RotationalElements for Puck {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_PUCK.angle(t),
            DECLINATION_PUCK.angle(t),
            ROTATION_PUCK.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_PUCK.angle_dot(t),
            DECLINATION_PUCK.angle_dot(t),
            ROTATION_PUCK.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Caliban;
impl Origin for Caliban {
    fn id(&self) -> NaifId {
        NaifId(716i32)
    }
    fn name(&self) -> &'static str {
        "Caliban"
    }
}
impl Display for Caliban {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Sycorax;
impl Origin for Sycorax {
    fn id(&self) -> NaifId {
        NaifId(717i32)
    }
    fn name(&self) -> &'static str {
        "Sycorax"
    }
}
impl Display for Sycorax {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Prospero;
impl Origin for Prospero {
    fn id(&self) -> NaifId {
        NaifId(718i32)
    }
    fn name(&self) -> &'static str {
        "Prospero"
    }
}
impl Display for Prospero {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Setebos;
impl Origin for Setebos {
    fn id(&self) -> NaifId {
        NaifId(719i32)
    }
    fn name(&self) -> &'static str {
        "Setebos"
    }
}
impl Display for Setebos {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Stephano;
impl Origin for Stephano {
    fn id(&self) -> NaifId {
        NaifId(720i32)
    }
    fn name(&self) -> &'static str {
        "Stephano"
    }
}
impl Display for Stephano {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Trinculo;
impl Origin for Trinculo {
    fn id(&self) -> NaifId {
        NaifId(721i32)
    }
    fn name(&self) -> &'static str {
        "Trinculo"
    }
}
impl Display for Trinculo {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Francisco;
impl Origin for Francisco {
    fn id(&self) -> NaifId {
        NaifId(722i32)
    }
    fn name(&self) -> &'static str {
        "Francisco"
    }
}
impl Display for Francisco {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Margaret;
impl Origin for Margaret {
    fn id(&self) -> NaifId {
        NaifId(723i32)
    }
    fn name(&self) -> &'static str {
        "Margaret"
    }
}
impl Display for Margaret {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Ferdinand;
impl Origin for Ferdinand {
    fn id(&self) -> NaifId {
        NaifId(724i32)
    }
    fn name(&self) -> &'static str {
        "Ferdinand"
    }
}
impl Display for Ferdinand {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Perdita;
impl Origin for Perdita {
    fn id(&self) -> NaifId {
        NaifId(725i32)
    }
    fn name(&self) -> &'static str {
        "Perdita"
    }
}
impl Display for Perdita {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Mab;
impl Origin for Mab {
    fn id(&self) -> NaifId {
        NaifId(726i32)
    }
    fn name(&self) -> &'static str {
        "Mab"
    }
}
impl Display for Mab {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Cupid;
impl Origin for Cupid {
    fn id(&self) -> NaifId {
        NaifId(727i32)
    }
    fn name(&self) -> &'static str {
        "Cupid"
    }
}
impl Display for Cupid {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Triton;
impl Origin for Triton {
    fn id(&self) -> NaifId {
        NaifId(801i32)
    }
    fn name(&self) -> &'static str {
        "Triton"
    }
}
impl Display for Triton {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Triton {
    fn gravitational_parameter(&self) -> f64 {
        1428.495462910464f64
    }
}
impl MeanRadius for Triton {
    fn mean_radius(&self) -> f64 {
        1352.6f64
    }
}
impl TriaxialEllipsoid for Triton {
    fn radii(&self) -> Radii {
        (1352.6f64, 1352.6f64, 1352.6f64)
    }
}
impl Spheroid for Triton {}
const RIGHT_ASCENSION_TRITON: RotationalElement<17usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 5.224817648770225f64,
    c1: 0f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        -0.5646140130201657f64,
        0f64,
        -0.1096066770252439f64,
        -0.03630284844148206f64,
        -0.012915436464758038f64,
        -0.004886921905584123f64,
        -0.0019198621771937625f64,
        -0.0012217304763960308f64,
        -0.00034906585039886593f64,
        -0.00017453292519943296f64,
    ],
    theta0: [
        6.245660728261709f64,
        5.653470513060032f64,
        3.848625533572696f64,
        6.183177941040311f64,
        1.3144074596769295f64,
        0.6171484235051949f64,
        2.4890140462691135f64,
        3.104068074671915f64,
        11.306941026120064f64,
        6.20813614934383f64,
        9.312204224015744f64,
        12.41627229868766f64,
        15.520340373359575f64,
        18.624408448031488f64,
        21.728476522703406f64,
        24.83254459737532f64,
        27.936612672047236f64,
    ],
    theta1: [
        0.9130864514733535f64,
        1092.6913034790819f64,
        961.0515899766616f64,
        812.7038395448996f64,
        455.6949957202075f64,
        250.02539666519567f64,
        49.29857005183183f64,
        0.9130864514733535f64,
        2185.3826069581637f64,
        1.826172902946707f64,
        2.7392593544200605f64,
        3.652345805893414f64,
        4.565432257366767f64,
        5.478518708840121f64,
        6.391605160313474f64,
        7.304691611786828f64,
        8.21777806326018f64,
    ],
};
const DECLINATION_TRITON: RotationalElement<17usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: 0.7185520530460655f64,
    c1: 0f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0.3935717463247213f64,
        0f64,
        0.03665191429188092f64,
        0.009599310885968814f64,
        0.0027925268031909274f64,
        0.0008726646259971648f64,
        0.00034906585039886593f64,
        0.00017453292519943296f64,
        0f64,
        0f64,
    ],
    theta0: [
        6.245660728261709f64,
        5.653470513060032f64,
        3.848625533572696f64,
        6.183177941040311f64,
        1.3144074596769295f64,
        0.6171484235051949f64,
        2.4890140462691135f64,
        3.104068074671915f64,
        11.306941026120064f64,
        6.20813614934383f64,
        9.312204224015744f64,
        12.41627229868766f64,
        15.520340373359575f64,
        18.624408448031488f64,
        21.728476522703406f64,
        24.83254459737532f64,
        27.936612672047236f64,
    ],
    theta1: [
        0.9130864514733535f64,
        1092.6913034790819f64,
        961.0515899766616f64,
        812.7038395448996f64,
        455.6949957202075f64,
        250.02539666519567f64,
        49.29857005183183f64,
        0.9130864514733535f64,
        2185.3826069581637f64,
        1.826172902946707f64,
        2.7392593544200605f64,
        3.652345805893414f64,
        4.565432257366767f64,
        5.478518708840121f64,
        6.391605160313474f64,
        7.304691611786828f64,
        8.21777806326018f64,
    ],
};
const ROTATION_TRITON: RotationalElement<17usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 5.175424830938785f64,
    c1: -1.069140942327404f64,
    c2: 0f64,
    c: [
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0.3883357585687383f64,
        0f64,
        0.11746065865921838f64,
        0.03577924966588375f64,
        0.012915436464758038f64,
        0.004886921905584123f64,
        0.0019198621771937625f64,
        0.0008726646259971648f64,
        0.00034906585039886593f64,
        0.00017453292519943296f64,
    ],
    theta0: [
        6.245660728261709f64,
        5.653470513060032f64,
        3.848625533572696f64,
        6.183177941040311f64,
        1.3144074596769295f64,
        0.6171484235051949f64,
        2.4890140462691135f64,
        3.104068074671915f64,
        11.306941026120064f64,
        6.20813614934383f64,
        9.312204224015744f64,
        12.41627229868766f64,
        15.520340373359575f64,
        18.624408448031488f64,
        21.728476522703406f64,
        24.83254459737532f64,
        27.936612672047236f64,
    ],
    theta1: [
        0.9130864514733535f64,
        1092.6913034790819f64,
        961.0515899766616f64,
        812.7038395448996f64,
        455.6949957202075f64,
        250.02539666519567f64,
        49.29857005183183f64,
        0.9130864514733535f64,
        2185.3826069581637f64,
        1.826172902946707f64,
        2.7392593544200605f64,
        3.652345805893414f64,
        4.565432257366767f64,
        5.478518708840121f64,
        6.391605160313474f64,
        7.304691611786828f64,
        8.21777806326018f64,
    ],
};
impl RotationalElements for Triton {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_TRITON.angle(t),
            DECLINATION_TRITON.angle(t),
            ROTATION_TRITON.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_TRITON.angle_dot(t),
            DECLINATION_TRITON.angle_dot(t),
            ROTATION_TRITON.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Nereid;
impl Origin for Nereid {
    fn id(&self) -> NaifId {
        NaifId(802i32)
    }
    fn name(&self) -> &'static str {
        "Nereid"
    }
}
impl Display for Nereid {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl MeanRadius for Nereid {
    fn mean_radius(&self) -> f64 {
        170f64
    }
}
impl TriaxialEllipsoid for Nereid {
    fn radii(&self) -> Radii {
        (170f64, 170f64, 170f64)
    }
}
impl Spheroid for Nereid {}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Naiad;
impl Origin for Naiad {
    fn id(&self) -> NaifId {
        NaifId(803i32)
    }
    fn name(&self) -> &'static str {
        "Naiad"
    }
}
impl Display for Naiad {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Naiad {
    fn gravitational_parameter(&self) -> f64 {
        0.008530281246540886f64
    }
}
impl MeanRadius for Naiad {
    fn mean_radius(&self) -> f64 {
        29f64
    }
}
impl TriaxialEllipsoid for Naiad {
    fn radii(&self) -> Radii {
        (29f64, 29f64, 29f64)
    }
}
impl Spheroid for Naiad {}
const RIGHT_ASCENSION_NAIAD: RotationalElement<17usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 5.224817648770225f64,
    c1: 0f64,
    c2: 0f64,
    c: [
        0.012217304763960306f64,
        -0.11327186845443199f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0.004363323129985824f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        6.245660728261709f64,
        5.653470513060032f64,
        3.848625533572696f64,
        6.183177941040311f64,
        1.3144074596769295f64,
        0.6171484235051949f64,
        2.4890140462691135f64,
        3.104068074671915f64,
        11.306941026120064f64,
        6.20813614934383f64,
        9.312204224015744f64,
        12.41627229868766f64,
        15.520340373359575f64,
        18.624408448031488f64,
        21.728476522703406f64,
        24.83254459737532f64,
        27.936612672047236f64,
    ],
    theta1: [
        0.9130864514733535f64,
        1092.6913034790819f64,
        961.0515899766616f64,
        812.7038395448996f64,
        455.6949957202075f64,
        250.02539666519567f64,
        49.29857005183183f64,
        0.9130864514733535f64,
        2185.3826069581637f64,
        1.826172902946707f64,
        2.7392593544200605f64,
        3.652345805893414f64,
        4.565432257366767f64,
        5.478518708840121f64,
        6.391605160313474f64,
        7.304691611786828f64,
        8.21777806326018f64,
    ],
};
const DECLINATION_NAIAD: RotationalElement<17usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: 0.7567747636647413f64,
    c1: 0f64,
    c2: 0f64,
    c: [
        -0.00890117918517108f64,
        -0.08290313946973066f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0.0015707963267948964f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        6.245660728261709f64,
        5.653470513060032f64,
        3.848625533572696f64,
        6.183177941040311f64,
        1.3144074596769295f64,
        0.6171484235051949f64,
        2.4890140462691135f64,
        3.104068074671915f64,
        11.306941026120064f64,
        6.20813614934383f64,
        9.312204224015744f64,
        12.41627229868766f64,
        15.520340373359575f64,
        18.624408448031488f64,
        21.728476522703406f64,
        24.83254459737532f64,
        27.936612672047236f64,
    ],
    theta1: [
        0.9130864514733535f64,
        1092.6913034790819f64,
        961.0515899766616f64,
        812.7038395448996f64,
        455.6949957202075f64,
        250.02539666519567f64,
        49.29857005183183f64,
        0.9130864514733535f64,
        2185.3826069581637f64,
        1.826172902946707f64,
        2.7392593544200605f64,
        3.652345805893414f64,
        4.565432257366767f64,
        5.478518708840121f64,
        6.391605160313474f64,
        7.304691611786828f64,
        8.21777806326018f64,
    ],
};
const ROTATION_NAIAD: RotationalElement<17usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 4.434183497616794f64,
    c1: 21.342656148360604f64,
    c2: 0f64,
    c: [
        -0.008377580409572781f64,
        0.07679448708775051f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        -0.00471238898038469f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        6.245660728261709f64,
        5.653470513060032f64,
        3.848625533572696f64,
        6.183177941040311f64,
        1.3144074596769295f64,
        0.6171484235051949f64,
        2.4890140462691135f64,
        3.104068074671915f64,
        11.306941026120064f64,
        6.20813614934383f64,
        9.312204224015744f64,
        12.41627229868766f64,
        15.520340373359575f64,
        18.624408448031488f64,
        21.728476522703406f64,
        24.83254459737532f64,
        27.936612672047236f64,
    ],
    theta1: [
        0.9130864514733535f64,
        1092.6913034790819f64,
        961.0515899766616f64,
        812.7038395448996f64,
        455.6949957202075f64,
        250.02539666519567f64,
        49.29857005183183f64,
        0.9130864514733535f64,
        2185.3826069581637f64,
        1.826172902946707f64,
        2.7392593544200605f64,
        3.652345805893414f64,
        4.565432257366767f64,
        5.478518708840121f64,
        6.391605160313474f64,
        7.304691611786828f64,
        8.21777806326018f64,
    ],
};
impl RotationalElements for Naiad {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_NAIAD.angle(t),
            DECLINATION_NAIAD.angle(t),
            ROTATION_NAIAD.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_NAIAD.angle_dot(t),
            DECLINATION_NAIAD.angle_dot(t),
            ROTATION_NAIAD.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Thalassa;
impl Origin for Thalassa {
    fn id(&self) -> NaifId {
        NaifId(804i32)
    }
    fn name(&self) -> &'static str {
        "Thalassa"
    }
}
impl Display for Thalassa {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Thalassa {
    fn gravitational_parameter(&self) -> f64 {
        0.0235887319799217f64
    }
}
impl MeanRadius for Thalassa {
    fn mean_radius(&self) -> f64 {
        40f64
    }
}
impl TriaxialEllipsoid for Thalassa {
    fn radii(&self) -> Radii {
        (40f64, 40f64, 40f64)
    }
}
impl Spheroid for Thalassa {}
const RIGHT_ASCENSION_THALASSA: RotationalElement<17usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 5.224817648770225f64,
    c1: 0f64,
    c2: 0f64,
    c: [
        0.012217304763960306f64,
        0f64,
        -0.004886921905584123f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        6.245660728261709f64,
        5.653470513060032f64,
        3.848625533572696f64,
        6.183177941040311f64,
        1.3144074596769295f64,
        0.6171484235051949f64,
        2.4890140462691135f64,
        3.104068074671915f64,
        11.306941026120064f64,
        6.20813614934383f64,
        9.312204224015744f64,
        12.41627229868766f64,
        15.520340373359575f64,
        18.624408448031488f64,
        21.728476522703406f64,
        24.83254459737532f64,
        27.936612672047236f64,
    ],
    theta1: [
        0.9130864514733535f64,
        1092.6913034790819f64,
        961.0515899766616f64,
        812.7038395448996f64,
        455.6949957202075f64,
        250.02539666519567f64,
        49.29857005183183f64,
        0.9130864514733535f64,
        2185.3826069581637f64,
        1.826172902946707f64,
        2.7392593544200605f64,
        3.652345805893414f64,
        4.565432257366767f64,
        5.478518708840121f64,
        6.391605160313474f64,
        7.304691611786828f64,
        8.21777806326018f64,
    ],
};
const DECLINATION_THALASSA: RotationalElement<17usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: 0.7583455599915362f64,
    c1: 0f64,
    c2: 0f64,
    c: [
        -0.00890117918517108f64,
        0f64,
        -0.003665191429188092f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        6.245660728261709f64,
        5.653470513060032f64,
        3.848625533572696f64,
        6.183177941040311f64,
        1.3144074596769295f64,
        0.6171484235051949f64,
        2.4890140462691135f64,
        3.104068074671915f64,
        11.306941026120064f64,
        6.20813614934383f64,
        9.312204224015744f64,
        12.41627229868766f64,
        15.520340373359575f64,
        18.624408448031488f64,
        21.728476522703406f64,
        24.83254459737532f64,
        27.936612672047236f64,
    ],
    theta1: [
        0.9130864514733535f64,
        1092.6913034790819f64,
        961.0515899766616f64,
        812.7038395448996f64,
        455.6949957202075f64,
        250.02539666519567f64,
        49.29857005183183f64,
        0.9130864514733535f64,
        2185.3826069581637f64,
        1.826172902946707f64,
        2.7392593544200605f64,
        3.652345805893414f64,
        4.565432257366767f64,
        5.478518708840121f64,
        6.391605160313474f64,
        7.304691611786828f64,
        8.21777806326018f64,
    ],
};
const ROTATION_THALASSA: RotationalElement<17usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 1.7812830345854127f64,
    c1: 20.171739891174827f64,
    c2: 0f64,
    c: [
        -0.008377580409572781f64,
        0f64,
        0.0033161255787892262f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        6.245660728261709f64,
        5.653470513060032f64,
        3.848625533572696f64,
        6.183177941040311f64,
        1.3144074596769295f64,
        0.6171484235051949f64,
        2.4890140462691135f64,
        3.104068074671915f64,
        11.306941026120064f64,
        6.20813614934383f64,
        9.312204224015744f64,
        12.41627229868766f64,
        15.520340373359575f64,
        18.624408448031488f64,
        21.728476522703406f64,
        24.83254459737532f64,
        27.936612672047236f64,
    ],
    theta1: [
        0.9130864514733535f64,
        1092.6913034790819f64,
        961.0515899766616f64,
        812.7038395448996f64,
        455.6949957202075f64,
        250.02539666519567f64,
        49.29857005183183f64,
        0.9130864514733535f64,
        2185.3826069581637f64,
        1.826172902946707f64,
        2.7392593544200605f64,
        3.652345805893414f64,
        4.565432257366767f64,
        5.478518708840121f64,
        6.391605160313474f64,
        7.304691611786828f64,
        8.21777806326018f64,
    ],
};
impl RotationalElements for Thalassa {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_THALASSA.angle(t),
            DECLINATION_THALASSA.angle(t),
            ROTATION_THALASSA.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_THALASSA.angle_dot(t),
            DECLINATION_THALASSA.angle_dot(t),
            ROTATION_THALASSA.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Despina;
impl Origin for Despina {
    fn id(&self) -> NaifId {
        NaifId(805i32)
    }
    fn name(&self) -> &'static str {
        "Despina"
    }
}
impl Display for Despina {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Despina {
    fn gravitational_parameter(&self) -> f64 {
        0.1167318403814998f64
    }
}
impl MeanRadius for Despina {
    fn mean_radius(&self) -> f64 {
        74f64
    }
}
impl TriaxialEllipsoid for Despina {
    fn radii(&self) -> Radii {
        (74f64, 74f64, 74f64)
    }
}
impl Spheroid for Despina {}
const RIGHT_ASCENSION_DESPINA: RotationalElement<17usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 5.224817648770225f64,
    c1: 0f64,
    c2: 0f64,
    c: [
        0.012217304763960306f64,
        0f64,
        0f64,
        -0.0015707963267948964f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        6.245660728261709f64,
        5.653470513060032f64,
        3.848625533572696f64,
        6.183177941040311f64,
        1.3144074596769295f64,
        0.6171484235051949f64,
        2.4890140462691135f64,
        3.104068074671915f64,
        11.306941026120064f64,
        6.20813614934383f64,
        9.312204224015744f64,
        12.41627229868766f64,
        15.520340373359575f64,
        18.624408448031488f64,
        21.728476522703406f64,
        24.83254459737532f64,
        27.936612672047236f64,
    ],
    theta1: [
        0.9130864514733535f64,
        1092.6913034790819f64,
        961.0515899766616f64,
        812.7038395448996f64,
        455.6949957202075f64,
        250.02539666519567f64,
        49.29857005183183f64,
        0.9130864514733535f64,
        2185.3826069581637f64,
        1.826172902946707f64,
        2.7392593544200605f64,
        3.652345805893414f64,
        4.565432257366767f64,
        5.478518708840121f64,
        6.391605160313474f64,
        7.304691611786828f64,
        8.21777806326018f64,
    ],
};
const DECLINATION_DESPINA: RotationalElement<17usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: 0.7583455599915362f64,
    c1: 0f64,
    c2: 0f64,
    c: [
        -0.00890117918517108f64,
        0f64,
        0f64,
        -0.0012217304763960308f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        6.245660728261709f64,
        5.653470513060032f64,
        3.848625533572696f64,
        6.183177941040311f64,
        1.3144074596769295f64,
        0.6171484235051949f64,
        2.4890140462691135f64,
        3.104068074671915f64,
        11.306941026120064f64,
        6.20813614934383f64,
        9.312204224015744f64,
        12.41627229868766f64,
        15.520340373359575f64,
        18.624408448031488f64,
        21.728476522703406f64,
        24.83254459737532f64,
        27.936612672047236f64,
    ],
    theta1: [
        0.9130864514733535f64,
        1092.6913034790819f64,
        961.0515899766616f64,
        812.7038395448996f64,
        455.6949957202075f64,
        250.02539666519567f64,
        49.29857005183183f64,
        0.9130864514733535f64,
        2185.3826069581637f64,
        1.826172902946707f64,
        2.7392593544200605f64,
        3.652345805893414f64,
        4.565432257366767f64,
        5.478518708840121f64,
        6.391605160313474f64,
        7.304691611786828f64,
        8.21777806326018f64,
    ],
};
const ROTATION_DESPINA: RotationalElement<17usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 5.34960869028782f64,
    c1: 18.77510290185297f64,
    c2: 0f64,
    c: [
        -0.008552113334772215f64,
        0f64,
        0f64,
        0.0010471975511965976f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        6.245660728261709f64,
        5.653470513060032f64,
        3.848625533572696f64,
        6.183177941040311f64,
        1.3144074596769295f64,
        0.6171484235051949f64,
        2.4890140462691135f64,
        3.104068074671915f64,
        11.306941026120064f64,
        6.20813614934383f64,
        9.312204224015744f64,
        12.41627229868766f64,
        15.520340373359575f64,
        18.624408448031488f64,
        21.728476522703406f64,
        24.83254459737532f64,
        27.936612672047236f64,
    ],
    theta1: [
        0.9130864514733535f64,
        1092.6913034790819f64,
        961.0515899766616f64,
        812.7038395448996f64,
        455.6949957202075f64,
        250.02539666519567f64,
        49.29857005183183f64,
        0.9130864514733535f64,
        2185.3826069581637f64,
        1.826172902946707f64,
        2.7392593544200605f64,
        3.652345805893414f64,
        4.565432257366767f64,
        5.478518708840121f64,
        6.391605160313474f64,
        7.304691611786828f64,
        8.21777806326018f64,
    ],
};
impl RotationalElements for Despina {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_DESPINA.angle(t),
            DECLINATION_DESPINA.angle(t),
            ROTATION_DESPINA.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_DESPINA.angle_dot(t),
            DECLINATION_DESPINA.angle_dot(t),
            ROTATION_DESPINA.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Galatea;
impl Origin for Galatea {
    fn id(&self) -> NaifId {
        NaifId(806i32)
    }
    fn name(&self) -> &'static str {
        "Galatea"
    }
}
impl Display for Galatea {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Galatea {
    fn gravitational_parameter(&self) -> f64 {
        0.189898503906069f64
    }
}
impl MeanRadius for Galatea {
    fn mean_radius(&self) -> f64 {
        79f64
    }
}
impl TriaxialEllipsoid for Galatea {
    fn radii(&self) -> Radii {
        (79f64, 79f64, 79f64)
    }
}
impl Spheroid for Galatea {}
const RIGHT_ASCENSION_GALATEA: RotationalElement<17usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 5.224817648770225f64,
    c1: 0f64,
    c2: 0f64,
    c: [
        0.012217304763960306f64,
        0f64,
        0f64,
        0f64,
        -0.0012217304763960308f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        6.245660728261709f64,
        5.653470513060032f64,
        3.848625533572696f64,
        6.183177941040311f64,
        1.3144074596769295f64,
        0.6171484235051949f64,
        2.4890140462691135f64,
        3.104068074671915f64,
        11.306941026120064f64,
        6.20813614934383f64,
        9.312204224015744f64,
        12.41627229868766f64,
        15.520340373359575f64,
        18.624408448031488f64,
        21.728476522703406f64,
        24.83254459737532f64,
        27.936612672047236f64,
    ],
    theta1: [
        0.9130864514733535f64,
        1092.6913034790819f64,
        961.0515899766616f64,
        812.7038395448996f64,
        455.6949957202075f64,
        250.02539666519567f64,
        49.29857005183183f64,
        0.9130864514733535f64,
        2185.3826069581637f64,
        1.826172902946707f64,
        2.7392593544200605f64,
        3.652345805893414f64,
        4.565432257366767f64,
        5.478518708840121f64,
        6.391605160313474f64,
        7.304691611786828f64,
        8.21777806326018f64,
    ],
};
const DECLINATION_GALATEA: RotationalElement<17usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: 0.7579964941411373f64,
    c1: 0f64,
    c2: 0f64,
    c: [
        -0.00890117918517108f64,
        0f64,
        0f64,
        0f64,
        -0.0008726646259971648f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        6.245660728261709f64,
        5.653470513060032f64,
        3.848625533572696f64,
        6.183177941040311f64,
        1.3144074596769295f64,
        0.6171484235051949f64,
        2.4890140462691135f64,
        3.104068074671915f64,
        11.306941026120064f64,
        6.20813614934383f64,
        9.312204224015744f64,
        12.41627229868766f64,
        15.520340373359575f64,
        18.624408448031488f64,
        21.728476522703406f64,
        24.83254459737532f64,
        27.936612672047236f64,
    ],
    theta1: [
        0.9130864514733535f64,
        1092.6913034790819f64,
        961.0515899766616f64,
        812.7038395448996f64,
        455.6949957202075f64,
        250.02539666519567f64,
        49.29857005183183f64,
        0.9130864514733535f64,
        2185.3826069581637f64,
        1.826172902946707f64,
        2.7392593544200605f64,
        3.652345805893414f64,
        4.565432257366767f64,
        5.478518708840121f64,
        6.391605160313474f64,
        7.304691611786828f64,
        8.21777806326018f64,
    ],
};
const ROTATION_GALATEA: RotationalElement<17usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 4.504520266472165f64,
    c1: 14.6548275586037f64,
    c2: 0f64,
    c: [
        -0.008377580409572781f64,
        0f64,
        0f64,
        0f64,
        0.0008726646259971648f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        6.245660728261709f64,
        5.653470513060032f64,
        3.848625533572696f64,
        6.183177941040311f64,
        1.3144074596769295f64,
        0.6171484235051949f64,
        2.4890140462691135f64,
        3.104068074671915f64,
        11.306941026120064f64,
        6.20813614934383f64,
        9.312204224015744f64,
        12.41627229868766f64,
        15.520340373359575f64,
        18.624408448031488f64,
        21.728476522703406f64,
        24.83254459737532f64,
        27.936612672047236f64,
    ],
    theta1: [
        0.9130864514733535f64,
        1092.6913034790819f64,
        961.0515899766616f64,
        812.7038395448996f64,
        455.6949957202075f64,
        250.02539666519567f64,
        49.29857005183183f64,
        0.9130864514733535f64,
        2185.3826069581637f64,
        1.826172902946707f64,
        2.7392593544200605f64,
        3.652345805893414f64,
        4.565432257366767f64,
        5.478518708840121f64,
        6.391605160313474f64,
        7.304691611786828f64,
        8.21777806326018f64,
    ],
};
impl RotationalElements for Galatea {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_GALATEA.angle(t),
            DECLINATION_GALATEA.angle(t),
            ROTATION_GALATEA.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_GALATEA.angle_dot(t),
            DECLINATION_GALATEA.angle_dot(t),
            ROTATION_GALATEA.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Larissa;
impl Origin for Larissa {
    fn id(&self) -> NaifId {
        NaifId(807i32)
    }
    fn name(&self) -> &'static str {
        "Larissa"
    }
}
impl Display for Larissa {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Larissa {
    fn gravitational_parameter(&self) -> f64 {
        0.2548437405693583f64
    }
}
impl MeanRadius for Larissa {
    fn mean_radius(&self) -> f64 {
        96f64
    }
}
impl TriaxialEllipsoid for Larissa {
    fn radii(&self) -> Radii {
        (96f64, 96f64, 96f64)
    }
}
impl Spheroid for Larissa {}
const RIGHT_ASCENSION_LARISSA: RotationalElement<17usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 5.224817648770225f64,
    c1: 0f64,
    c2: 0f64,
    c: [
        0.012217304763960306f64,
        0f64,
        0f64,
        0f64,
        0f64,
        -0.00471238898038469f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        6.245660728261709f64,
        5.653470513060032f64,
        3.848625533572696f64,
        6.183177941040311f64,
        1.3144074596769295f64,
        0.6171484235051949f64,
        2.4890140462691135f64,
        3.104068074671915f64,
        11.306941026120064f64,
        6.20813614934383f64,
        9.312204224015744f64,
        12.41627229868766f64,
        15.520340373359575f64,
        18.624408448031488f64,
        21.728476522703406f64,
        24.83254459737532f64,
        27.936612672047236f64,
    ],
    theta1: [
        0.9130864514733535f64,
        1092.6913034790819f64,
        961.0515899766616f64,
        812.7038395448996f64,
        455.6949957202075f64,
        250.02539666519567f64,
        49.29857005183183f64,
        0.9130864514733535f64,
        2185.3826069581637f64,
        1.826172902946707f64,
        2.7392593544200605f64,
        3.652345805893414f64,
        4.565432257366767f64,
        5.478518708840121f64,
        6.391605160313474f64,
        7.304691611786828f64,
        8.21777806326018f64,
    ],
};
const DECLINATION_LARISSA: RotationalElement<17usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: 0.7576474282907384f64,
    c1: 0f64,
    c2: 0f64,
    c: [
        -0.00890117918517108f64,
        0f64,
        0f64,
        0f64,
        0f64,
        -0.003490658503988659f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        6.245660728261709f64,
        5.653470513060032f64,
        3.848625533572696f64,
        6.183177941040311f64,
        1.3144074596769295f64,
        0.6171484235051949f64,
        2.4890140462691135f64,
        3.104068074671915f64,
        11.306941026120064f64,
        6.20813614934383f64,
        9.312204224015744f64,
        12.41627229868766f64,
        15.520340373359575f64,
        18.624408448031488f64,
        21.728476522703406f64,
        24.83254459737532f64,
        27.936612672047236f64,
    ],
    theta1: [
        0.9130864514733535f64,
        1092.6913034790819f64,
        961.0515899766616f64,
        812.7038395448996f64,
        455.6949957202075f64,
        250.02539666519567f64,
        49.29857005183183f64,
        0.9130864514733535f64,
        2185.3826069581637f64,
        1.826172902946707f64,
        2.7392593544200605f64,
        3.652345805893414f64,
        4.565432257366767f64,
        5.478518708840121f64,
        6.391605160313474f64,
        7.304691611786828f64,
        8.21777806326018f64,
    ],
};
const ROTATION_LARISSA: RotationalElement<17usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 3.1312952110030268f64,
    c1: 11.328119671568512f64,
    c2: 0f64,
    c: [
        -0.008377580409572781f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0.0033161255787892262f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        6.245660728261709f64,
        5.653470513060032f64,
        3.848625533572696f64,
        6.183177941040311f64,
        1.3144074596769295f64,
        0.6171484235051949f64,
        2.4890140462691135f64,
        3.104068074671915f64,
        11.306941026120064f64,
        6.20813614934383f64,
        9.312204224015744f64,
        12.41627229868766f64,
        15.520340373359575f64,
        18.624408448031488f64,
        21.728476522703406f64,
        24.83254459737532f64,
        27.936612672047236f64,
    ],
    theta1: [
        0.9130864514733535f64,
        1092.6913034790819f64,
        961.0515899766616f64,
        812.7038395448996f64,
        455.6949957202075f64,
        250.02539666519567f64,
        49.29857005183183f64,
        0.9130864514733535f64,
        2185.3826069581637f64,
        1.826172902946707f64,
        2.7392593544200605f64,
        3.652345805893414f64,
        4.565432257366767f64,
        5.478518708840121f64,
        6.391605160313474f64,
        7.304691611786828f64,
        8.21777806326018f64,
    ],
};
impl RotationalElements for Larissa {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_LARISSA.angle(t),
            DECLINATION_LARISSA.angle(t),
            ROTATION_LARISSA.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_LARISSA.angle_dot(t),
            DECLINATION_LARISSA.angle_dot(t),
            ROTATION_LARISSA.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Proteus;
impl Origin for Proteus {
    fn id(&self) -> NaifId {
        NaifId(808i32)
    }
    fn name(&self) -> &'static str {
        "Proteus"
    }
}
impl Display for Proteus {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Proteus {
    fn gravitational_parameter(&self) -> f64 {
        2.583422379120727f64
    }
}
impl MeanRadius for Proteus {
    fn mean_radius(&self) -> f64 {
        208f64
    }
}
impl TriaxialEllipsoid for Proteus {
    fn radii(&self) -> Radii {
        (218f64, 208f64, 201f64)
    }
}
const RIGHT_ASCENSION_PROTEUS: RotationalElement<17usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 5.22324685244343f64,
    c1: 0f64,
    c2: 0f64,
    c: [
        0.012217304763960306f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        -0.0008726646259971648f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        6.245660728261709f64,
        5.653470513060032f64,
        3.848625533572696f64,
        6.183177941040311f64,
        1.3144074596769295f64,
        0.6171484235051949f64,
        2.4890140462691135f64,
        3.104068074671915f64,
        11.306941026120064f64,
        6.20813614934383f64,
        9.312204224015744f64,
        12.41627229868766f64,
        15.520340373359575f64,
        18.624408448031488f64,
        21.728476522703406f64,
        24.83254459737532f64,
        27.936612672047236f64,
    ],
    theta1: [
        0.9130864514733535f64,
        1092.6913034790819f64,
        961.0515899766616f64,
        812.7038395448996f64,
        455.6949957202075f64,
        250.02539666519567f64,
        49.29857005183183f64,
        0.9130864514733535f64,
        2185.3826069581637f64,
        1.826172902946707f64,
        2.7392593544200605f64,
        3.652345805893414f64,
        4.565432257366767f64,
        5.478518708840121f64,
        6.391605160313474f64,
        7.304691611786828f64,
        8.21777806326018f64,
    ],
};
const DECLINATION_PROTEUS: RotationalElement<17usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: 0.7489207820307667f64,
    c1: 0f64,
    c2: 0f64,
    c: [
        -0.00890117918517108f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        -0.0006981317007977319f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        6.245660728261709f64,
        5.653470513060032f64,
        3.848625533572696f64,
        6.183177941040311f64,
        1.3144074596769295f64,
        0.6171484235051949f64,
        2.4890140462691135f64,
        3.104068074671915f64,
        11.306941026120064f64,
        6.20813614934383f64,
        9.312204224015744f64,
        12.41627229868766f64,
        15.520340373359575f64,
        18.624408448031488f64,
        21.728476522703406f64,
        24.83254459737532f64,
        27.936612672047236f64,
    ],
    theta1: [
        0.9130864514733535f64,
        1092.6913034790819f64,
        961.0515899766616f64,
        812.7038395448996f64,
        455.6949957202075f64,
        250.02539666519567f64,
        49.29857005183183f64,
        0.9130864514733535f64,
        2185.3826069581637f64,
        1.826172902946707f64,
        2.7392593544200605f64,
        3.652345805893414f64,
        4.565432257366767f64,
        5.478518708840121f64,
        6.391605160313474f64,
        7.304691611786828f64,
        8.21777806326018f64,
    ],
};
const ROTATION_PROTEUS: RotationalElement<17usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 1.6297884555123048f64,
    c1: 5.598412754411688f64,
    c2: 0f64,
    c: [
        -0.008377580409572781f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0.0006981317007977319f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
        0f64,
    ],
    theta0: [
        6.245660728261709f64,
        5.653470513060032f64,
        3.848625533572696f64,
        6.183177941040311f64,
        1.3144074596769295f64,
        0.6171484235051949f64,
        2.4890140462691135f64,
        3.104068074671915f64,
        11.306941026120064f64,
        6.20813614934383f64,
        9.312204224015744f64,
        12.41627229868766f64,
        15.520340373359575f64,
        18.624408448031488f64,
        21.728476522703406f64,
        24.83254459737532f64,
        27.936612672047236f64,
    ],
    theta1: [
        0.9130864514733535f64,
        1092.6913034790819f64,
        961.0515899766616f64,
        812.7038395448996f64,
        455.6949957202075f64,
        250.02539666519567f64,
        49.29857005183183f64,
        0.9130864514733535f64,
        2185.3826069581637f64,
        1.826172902946707f64,
        2.7392593544200605f64,
        3.652345805893414f64,
        4.565432257366767f64,
        5.478518708840121f64,
        6.391605160313474f64,
        7.304691611786828f64,
        8.21777806326018f64,
    ],
};
impl RotationalElements for Proteus {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_PROTEUS.angle(t),
            DECLINATION_PROTEUS.angle(t),
            ROTATION_PROTEUS.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_PROTEUS.angle_dot(t),
            DECLINATION_PROTEUS.angle_dot(t),
            ROTATION_PROTEUS.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Halimede;
impl Origin for Halimede {
    fn id(&self) -> NaifId {
        NaifId(809i32)
    }
    fn name(&self) -> &'static str {
        "Halimede"
    }
}
impl Display for Halimede {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Psamathe;
impl Origin for Psamathe {
    fn id(&self) -> NaifId {
        NaifId(810i32)
    }
    fn name(&self) -> &'static str {
        "Psamathe"
    }
}
impl Display for Psamathe {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Sao;
impl Origin for Sao {
    fn id(&self) -> NaifId {
        NaifId(811i32)
    }
    fn name(&self) -> &'static str {
        "Sao"
    }
}
impl Display for Sao {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Laomedeia;
impl Origin for Laomedeia {
    fn id(&self) -> NaifId {
        NaifId(812i32)
    }
    fn name(&self) -> &'static str {
        "Laomedeia"
    }
}
impl Display for Laomedeia {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Neso;
impl Origin for Neso {
    fn id(&self) -> NaifId {
        NaifId(813i32)
    }
    fn name(&self) -> &'static str {
        "Neso"
    }
}
impl Display for Neso {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Charon;
impl Origin for Charon {
    fn id(&self) -> NaifId {
        NaifId(901i32)
    }
    fn name(&self) -> &'static str {
        "Charon"
    }
}
impl Display for Charon {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Charon {
    fn gravitational_parameter(&self) -> f64 {
        105.8799888601881f64
    }
}
impl MeanRadius for Charon {
    fn mean_radius(&self) -> f64 {
        606f64
    }
}
impl TriaxialEllipsoid for Charon {
    fn radii(&self) -> Radii {
        (606f64, 606f64, 606f64)
    }
}
impl Spheroid for Charon {}
const RIGHT_ASCENSION_CHARON: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 2.3211657321048187f64,
    c1: 0f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const DECLINATION_CHARON: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: -0.10756464180041053f64,
    c1: 0f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const ROTATION_CHARON: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 2.1414317257344426f64,
    c1: 0.9837115923543857f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
impl RotationalElements for Charon {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_CHARON.angle(t),
            DECLINATION_CHARON.angle(t),
            ROTATION_CHARON.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_CHARON.angle_dot(t),
            DECLINATION_CHARON.angle_dot(t),
            ROTATION_CHARON.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Nix;
impl Origin for Nix {
    fn id(&self) -> NaifId {
        NaifId(902i32)
    }
    fn name(&self) -> &'static str {
        "Nix"
    }
}
impl Display for Nix {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Nix {
    fn gravitational_parameter(&self) -> f64 {
        0.00304817564816976f64
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Hydra;
impl Origin for Hydra {
    fn id(&self) -> NaifId {
        NaifId(903i32)
    }
    fn name(&self) -> &'static str {
        "Hydra"
    }
}
impl Display for Hydra {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Hydra {
    fn gravitational_parameter(&self) -> f64 {
        0.003211039206155255f64
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Kerberos;
impl Origin for Kerberos {
    fn id(&self) -> NaifId {
        NaifId(904i32)
    }
    fn name(&self) -> &'static str {
        "Kerberos"
    }
}
impl Display for Kerberos {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Kerberos {
    fn gravitational_parameter(&self) -> f64 {
        0.001110040850536676f64
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Styx;
impl Origin for Styx {
    fn id(&self) -> NaifId {
        NaifId(905i32)
    }
    fn name(&self) -> &'static str {
        "Styx"
    }
}
impl Display for Styx {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Styx {
    fn gravitational_parameter(&self) -> f64 {
        0f64
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Gaspra;
impl Origin for Gaspra {
    fn id(&self) -> NaifId {
        NaifId(9511010i32)
    }
    fn name(&self) -> &'static str {
        "Gaspra"
    }
}
impl Display for Gaspra {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl MeanRadius for Gaspra {
    fn mean_radius(&self) -> f64 {
        6.1f64
    }
}
impl TriaxialEllipsoid for Gaspra {
    fn radii(&self) -> Radii {
        (9.1f64, 5.2f64, 4.4f64)
    }
}
const RIGHT_ASCENSION_GASPRA: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 0.16528268016386302f64,
    c1: 0f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const DECLINATION_GASPRA: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: 0.46600291028248597f64,
    c1: 0f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const ROTATION_GASPRA: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 1.4603169851436555f64,
    c1: 21.41364504378302f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
impl RotationalElements for Gaspra {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_GASPRA.angle(t),
            DECLINATION_GASPRA.angle(t),
            ROTATION_GASPRA.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_GASPRA.angle_dot(t),
            DECLINATION_GASPRA.angle_dot(t),
            ROTATION_GASPRA.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Ida;
impl Origin for Ida {
    fn id(&self) -> NaifId {
        NaifId(2431010i32)
    }
    fn name(&self) -> &'static str {
        "Ida"
    }
}
impl Display for Ida {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl MeanRadius for Ida {
    fn mean_radius(&self) -> f64 {
        15.65f64
    }
}
impl TriaxialEllipsoid for Ida {
    fn radii(&self) -> Radii {
        (26.8f64, 12f64, 7.6f64)
    }
}
const RIGHT_ASCENSION_IDA: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 2.9454176456656302f64,
    c1: 0f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const DECLINATION_IDA: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: -1.5205308443374599f64,
    c1: 0f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const ROTATION_IDA: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 4.78307481509046f64,
    c1: 32.54389804704987f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
impl RotationalElements for Ida {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_IDA.angle(t),
            DECLINATION_IDA.angle(t),
            ROTATION_IDA.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_IDA.angle_dot(t),
            DECLINATION_IDA.angle_dot(t),
            ROTATION_IDA.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Dactyl;
impl Origin for Dactyl {
    fn id(&self) -> NaifId {
        NaifId(2431011i32)
    }
    fn name(&self) -> &'static str {
        "Dactyl"
    }
}
impl Display for Dactyl {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Ceres;
impl Origin for Ceres {
    fn id(&self) -> NaifId {
        NaifId(2000001i32)
    }
    fn name(&self) -> &'static str {
        "Ceres"
    }
}
impl Display for Ceres {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Ceres {
    fn gravitational_parameter(&self) -> f64 {
        62.62888864440993f64
    }
}
impl MeanRadius for Ceres {
    fn mean_radius(&self) -> f64 {
        470f64
    }
}
impl TriaxialEllipsoid for Ceres {
    fn radii(&self) -> Radii {
        (487.3f64, 487.3f64, 446f64)
    }
}
impl Spheroid for Ceres {}
const RIGHT_ASCENSION_CERES: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 5.0862035995768355f64,
    c1: 0f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const DECLINATION_CERES: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: 1.165251621801494f64,
    c1: 0f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const ROTATION_CERES: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 2.9784043685283237f64,
    c1: 16.618208323400072f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
impl RotationalElements for Ceres {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_CERES.angle(t),
            DECLINATION_CERES.angle(t),
            ROTATION_CERES.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_CERES.angle_dot(t),
            DECLINATION_CERES.angle_dot(t),
            ROTATION_CERES.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Pallas;
impl Origin for Pallas {
    fn id(&self) -> NaifId {
        NaifId(2000002i32)
    }
    fn name(&self) -> &'static str {
        "Pallas"
    }
}
impl Display for Pallas {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Pallas {
    fn gravitational_parameter(&self) -> f64 {
        13.665878145967422f64
    }
}
const RIGHT_ASCENSION_PALLAS: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 0.5759586531581288f64,
    c1: 0f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const DECLINATION_PALLAS: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: -0.05235987755982989f64,
    c1: 0f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const ROTATION_PALLAS: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 0.6632251157578453f64,
    c1: 19.299913700406368f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
impl RotationalElements for Pallas {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_PALLAS.angle(t),
            DECLINATION_PALLAS.angle(t),
            ROTATION_PALLAS.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_PALLAS.angle_dot(t),
            DECLINATION_PALLAS.angle_dot(t),
            ROTATION_PALLAS.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Vesta;
impl Origin for Vesta {
    fn id(&self) -> NaifId {
        NaifId(2000004i32)
    }
    fn name(&self) -> &'static str {
        "Vesta"
    }
}
impl Display for Vesta {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Vesta {
    fn gravitational_parameter(&self) -> f64 {
        17.288232879171513f64
    }
}
impl TriaxialEllipsoid for Vesta {
    fn radii(&self) -> Radii {
        (289f64, 280f64, 229f64)
    }
}
const RIGHT_ASCENSION_VESTA: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 5.393608440730596f64,
    c1: 0f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const DECLINATION_VESTA: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: 0.7371398095798051f64,
    c1: 0f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const ROTATION_VESTA: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 4.980995152266617f64,
    c1: 28.22778495282912f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
impl RotationalElements for Vesta {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_VESTA.angle(t),
            DECLINATION_VESTA.angle(t),
            ROTATION_VESTA.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_VESTA.angle_dot(t),
            DECLINATION_VESTA.angle_dot(t),
            ROTATION_VESTA.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Psyche;
impl Origin for Psyche {
    fn id(&self) -> NaifId {
        NaifId(2000016i32)
    }
    fn name(&self) -> &'static str {
        "Psyche"
    }
}
impl Display for Psyche {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Psyche {
    fn gravitational_parameter(&self) -> f64 {
        1.5896582441709424f64
    }
}
impl MeanRadius for Psyche {
    fn mean_radius(&self) -> f64 {
        113f64
    }
}
impl TriaxialEllipsoid for Psyche {
    fn radii(&self) -> Radii {
        (139.5f64, 116f64, 94.5f64)
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Lutetia;
impl Origin for Lutetia {
    fn id(&self) -> NaifId {
        NaifId(2000021i32)
    }
    fn name(&self) -> &'static str {
        "Lutetia"
    }
}
impl Display for Lutetia {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl MeanRadius for Lutetia {
    fn mean_radius(&self) -> f64 {
        52.5f64
    }
}
impl TriaxialEllipsoid for Lutetia {
    fn radii(&self) -> Radii {
        (62f64, 50.5f64, 46.5f64)
    }
}
const RIGHT_ASCENSION_LUTETIA: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 0.9075712110370514f64,
    c1: 0f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const DECLINATION_LUTETIA: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: 0.20943951023931956f64,
    c1: 0f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const ROTATION_LUTETIA: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 1.6406094968746698f64,
    c1: 18.4612463429088f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
impl RotationalElements for Lutetia {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_LUTETIA.angle(t),
            DECLINATION_LUTETIA.angle(t),
            ROTATION_LUTETIA.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_LUTETIA.angle_dot(t),
            DECLINATION_LUTETIA.angle_dot(t),
            ROTATION_LUTETIA.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Kleopatra;
impl Origin for Kleopatra {
    fn id(&self) -> NaifId {
        NaifId(2000216i32)
    }
    fn name(&self) -> &'static str {
        "Kleopatra"
    }
}
impl Display for Kleopatra {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Eros;
impl Origin for Eros {
    fn id(&self) -> NaifId {
        NaifId(2000433i32)
    }
    fn name(&self) -> &'static str {
        "Eros"
    }
}
impl Display for Eros {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Eros {
    fn gravitational_parameter(&self) -> f64 {
        0.0004463f64
    }
}
impl MeanRadius for Eros {
    fn mean_radius(&self) -> f64 {
        8.45f64
    }
}
impl TriaxialEllipsoid for Eros {
    fn radii(&self) -> Radii {
        (17f64, 5.5f64, 5.5f64)
    }
}
const RIGHT_ASCENSION_EROS: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 0.1980948701013564f64,
    c1: 0f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const DECLINATION_EROS: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: 0.30054569719342356f64,
    c1: 0f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const ROTATION_EROS: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 5.690995091977911f64,
    c1: 28.612729617819042f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
impl RotationalElements for Eros {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_EROS.angle(t),
            DECLINATION_EROS.angle(t),
            ROTATION_EROS.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_EROS.angle_dot(t),
            DECLINATION_EROS.angle_dot(t),
            ROTATION_EROS.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Davida;
impl Origin for Davida {
    fn id(&self) -> NaifId {
        NaifId(2000511i32)
    }
    fn name(&self) -> &'static str {
        "Davida"
    }
}
impl Display for Davida {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl PointMass for Davida {
    fn gravitational_parameter(&self) -> f64 {
        3.8944831481705644f64
    }
}
impl MeanRadius for Davida {
    fn mean_radius(&self) -> f64 {
        150f64
    }
}
impl TriaxialEllipsoid for Davida {
    fn radii(&self) -> Radii {
        (180f64, 147f64, 127f64)
    }
}
const RIGHT_ASCENSION_DAVIDA: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 5.183627878423159f64,
    c1: 0f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const DECLINATION_DAVIDA: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: 0.08726646259971647f64,
    c1: 0f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const ROTATION_DAVIDA: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 4.679227724596798f64,
    c1: 29.39866372732388f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
impl RotationalElements for Davida {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_DAVIDA.angle(t),
            DECLINATION_DAVIDA.angle(t),
            ROTATION_DAVIDA.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_DAVIDA.angle_dot(t),
            DECLINATION_DAVIDA.angle_dot(t),
            ROTATION_DAVIDA.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Mathilde;
impl Origin for Mathilde {
    fn id(&self) -> NaifId {
        NaifId(2000253i32)
    }
    fn name(&self) -> &'static str {
        "Mathilde"
    }
}
impl Display for Mathilde {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl MeanRadius for Mathilde {
    fn mean_radius(&self) -> f64 {
        26.5f64
    }
}
impl TriaxialEllipsoid for Mathilde {
    fn radii(&self) -> Radii {
        (33f64, 24f64, 23f64)
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Steins;
impl Origin for Steins {
    fn id(&self) -> NaifId {
        NaifId(2002867i32)
    }
    fn name(&self) -> &'static str {
        "Steins"
    }
}
impl Display for Steins {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl MeanRadius for Steins {
    fn mean_radius(&self) -> f64 {
        2.7f64
    }
}
impl TriaxialEllipsoid for Steins {
    fn radii(&self) -> Radii {
        (3.24f64, 2.73f64, 2.04f64)
    }
}
const RIGHT_ASCENSION_STEINS: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 1.5882496193148399f64,
    c1: 0f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const DECLINATION_STEINS: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: -1.0821041362364843f64,
    c1: 0f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const ROTATION_STEINS: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 5.615771401216954f64,
    c1: 24.925032561498227f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
impl RotationalElements for Steins {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_STEINS.angle(t),
            DECLINATION_STEINS.angle(t),
            ROTATION_STEINS.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_STEINS.angle_dot(t),
            DECLINATION_STEINS.angle_dot(t),
            ROTATION_STEINS.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Braille;
impl Origin for Braille {
    fn id(&self) -> NaifId {
        NaifId(2009969i32)
    }
    fn name(&self) -> &'static str {
        "Braille"
    }
}
impl Display for Braille {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct WilsonHarrington;
impl Origin for WilsonHarrington {
    fn id(&self) -> NaifId {
        NaifId(2004015i32)
    }
    fn name(&self) -> &'static str {
        "Wilson-Harrington"
    }
}
impl Display for WilsonHarrington {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Toutatis;
impl Origin for Toutatis {
    fn id(&self) -> NaifId {
        NaifId(2004179i32)
    }
    fn name(&self) -> &'static str {
        "Toutatis"
    }
}
impl Display for Toutatis {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl TriaxialEllipsoid for Toutatis {
    fn radii(&self) -> Radii {
        (2.13f64, 1.015f64, 0.85f64)
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Itokawa;
impl Origin for Itokawa {
    fn id(&self) -> NaifId {
        NaifId(2025143i32)
    }
    fn name(&self) -> &'static str {
        "Itokawa"
    }
}
impl Display for Itokawa {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl TriaxialEllipsoid for Itokawa {
    fn radii(&self) -> Radii {
        (0.268f64, 0.147f64, 0.104f64)
    }
}
const RIGHT_ASCENSION_ITOKAWA: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::RightAscension,
    c0: 1.5800465718304666f64,
    c1: 0f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const DECLINATION_ITOKAWA: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Declination,
    c0: -1.1571532940722404f64,
    c1: 0f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
const ROTATION_ITOKAWA: RotationalElement<0usize> = RotationalElement {
    typ: RotationalElementType::Rotation,
    c0: 0f64,
    c1: 12.429240095029979f64,
    c2: 0f64,
    c: [],
    theta0: [],
    theta1: [],
};
impl RotationalElements for Itokawa {
    fn rotational_elements(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_ITOKAWA.angle(t),
            DECLINATION_ITOKAWA.angle(t),
            ROTATION_ITOKAWA.angle(t),
        )
    }
    fn rotational_element_rates(&self, t: f64) -> Elements {
        (
            RIGHT_ASCENSION_ITOKAWA.angle_dot(t),
            DECLINATION_ITOKAWA.angle_dot(t),
            ROTATION_ITOKAWA.angle_dot(t),
        )
    }
}
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub struct Bennu;
impl Origin for Bennu {
    fn id(&self) -> NaifId {
        NaifId(2101955i32)
    }
    fn name(&self) -> &'static str {
        "Bennu"
    }
}
impl Display for Bennu {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.name())
    }
}
impl TryPointMass for DynOrigin {
    fn try_gravitational_parameter(&self) -> Result<f64, UndefinedOriginPropertyError> {
        match self {
            DynOrigin::Sun => Ok(132712440041.27942f64),
            DynOrigin::Mercury => Ok(22031.868551400003f64),
            DynOrigin::Venus => Ok(324858.592f64),
            DynOrigin::Earth => Ok(398600.43550702266f64),
            DynOrigin::Mars => Ok(42828.37362069909f64),
            DynOrigin::Jupiter => Ok(126686531.9003704f64),
            DynOrigin::Saturn => Ok(37931206.23436167f64),
            DynOrigin::Uranus => Ok(5793951.256527211f64),
            DynOrigin::Neptune => Ok(6835103.145462294f64),
            DynOrigin::Pluto => Ok(869.6138177608748f64),
            DynOrigin::SolarSystemBarycenter => Ok(132712440041.27942f64),
            DynOrigin::MercuryBarycenter => Ok(22031.868551400003f64),
            DynOrigin::VenusBarycenter => Ok(324858.592f64),
            DynOrigin::EarthBarycenter => Ok(403503.2356254802f64),
            DynOrigin::MarsBarycenter => Ok(42828.3758157561f64),
            DynOrigin::JupiterBarycenter => Ok(126712764.09999998f64),
            DynOrigin::SaturnBarycenter => Ok(37940584.8418f64),
            DynOrigin::UranusBarycenter => Ok(5794556.3999999985f64),
            DynOrigin::NeptuneBarycenter => Ok(6836527.100580399f64),
            DynOrigin::PlutoBarycenter => Ok(975.5f64),
            DynOrigin::Moon => Ok(4902.80011845755f64),
            DynOrigin::Phobos => Ok(0.0007087546066894452f64),
            DynOrigin::Deimos => Ok(0.00009615569648120313f64),
            DynOrigin::Io => Ok(5959.915466180539f64),
            DynOrigin::Europa => Ok(3202.712099607295f64),
            DynOrigin::Ganymede => Ok(9887.832752719638f64),
            DynOrigin::Callisto => Ok(7179.283402579837f64),
            DynOrigin::Amalthea => Ok(0.1645634534798259f64),
            DynOrigin::Himalia => Ok(0.1515524299611265f64),
            DynOrigin::Thebe => Ok(0.030148f64),
            DynOrigin::Adrastea => Ok(0.000139f64),
            DynOrigin::Metis => Ok(0.002501f64),
            DynOrigin::Mimas => Ok(2.503488768152587f64),
            DynOrigin::Enceladus => Ok(7.210366688598896f64),
            DynOrigin::Tethys => Ok(41.21352885489587f64),
            DynOrigin::Dione => Ok(73.11607172482067f64),
            DynOrigin::Rhea => Ok(153.9417519146563f64),
            DynOrigin::Titan => Ok(8978.137095521046f64),
            DynOrigin::Hyperion => Ok(0.3704913747932265f64),
            DynOrigin::Iapetus => Ok(120.5151060137642f64),
            DynOrigin::Phoebe => Ok(0.5547860052791678f64),
            DynOrigin::Janus => Ok(0.1265765099012197f64),
            DynOrigin::Epimetheus => Ok(0.03512333288208074f64),
            DynOrigin::Helene => Ok(0.0004757419551776972f64),
            DynOrigin::Atlas => Ok(0.0003718871247516475f64),
            DynOrigin::Prometheus => Ok(0.0107520800100761f64),
            DynOrigin::Pandora => Ok(0.009290325122028795f64),
            DynOrigin::Ariel => Ok(83.46344431770477f64),
            DynOrigin::Umbriel => Ok(85.09338094489388f64),
            DynOrigin::Titania => Ok(226.9437003741248f64),
            DynOrigin::Oberon => Ok(205.3234302535623f64),
            DynOrigin::Miranda => Ok(4.3195168992321f64),
            DynOrigin::Triton => Ok(1428.495462910464f64),
            DynOrigin::Naiad => Ok(0.008530281246540886f64),
            DynOrigin::Thalassa => Ok(0.0235887319799217f64),
            DynOrigin::Despina => Ok(0.1167318403814998f64),
            DynOrigin::Galatea => Ok(0.189898503906069f64),
            DynOrigin::Larissa => Ok(0.2548437405693583f64),
            DynOrigin::Proteus => Ok(2.583422379120727f64),
            DynOrigin::Charon => Ok(105.8799888601881f64),
            DynOrigin::Nix => Ok(0.00304817564816976f64),
            DynOrigin::Hydra => Ok(0.003211039206155255f64),
            DynOrigin::Kerberos => Ok(0.001110040850536676f64),
            DynOrigin::Styx => Ok(0f64),
            DynOrigin::Ceres => Ok(62.62888864440993f64),
            DynOrigin::Pallas => Ok(13.665878145967422f64),
            DynOrigin::Vesta => Ok(17.288232879171513f64),
            DynOrigin::Psyche => Ok(1.5896582441709424f64),
            DynOrigin::Eros => Ok(0.0004463f64),
            DynOrigin::Davida => Ok(3.8944831481705644f64),
            _ => Err(UndefinedOriginPropertyError {
                origin: self.to_string(),
                prop: "gravitational parameter".to_string(),
            }),
        }
    }
}
impl TryMeanRadius for DynOrigin {
    fn try_mean_radius(&self) -> Result<f64, UndefinedOriginPropertyError> {
        match self {
            DynOrigin::Mercury => Ok(2439.4f64),
            DynOrigin::Venus => Ok(6051.8f64),
            DynOrigin::Earth => Ok(6371.0084f64),
            DynOrigin::Mars => Ok(3389.5f64),
            DynOrigin::Jupiter => Ok(69911f64),
            DynOrigin::Saturn => Ok(58232f64),
            DynOrigin::Uranus => Ok(25362f64),
            DynOrigin::Neptune => Ok(24622f64),
            DynOrigin::Pluto => Ok(1188.3f64),
            DynOrigin::Moon => Ok(1737.4f64),
            DynOrigin::Phobos => Ok(11.08f64),
            DynOrigin::Deimos => Ok(6.2f64),
            DynOrigin::Io => Ok(1821.49f64),
            DynOrigin::Europa => Ok(1560.8f64),
            DynOrigin::Ganymede => Ok(2631.2f64),
            DynOrigin::Callisto => Ok(2410.3f64),
            DynOrigin::Amalthea => Ok(83.5f64),
            DynOrigin::Himalia => Ok(85f64),
            DynOrigin::Elara => Ok(40f64),
            DynOrigin::Pasiphae => Ok(18f64),
            DynOrigin::Sinope => Ok(14f64),
            DynOrigin::Lysithea => Ok(12f64),
            DynOrigin::Carme => Ok(15f64),
            DynOrigin::Ananke => Ok(10f64),
            DynOrigin::Leda => Ok(5f64),
            DynOrigin::Thebe => Ok(49.3f64),
            DynOrigin::Adrastea => Ok(8.2f64),
            DynOrigin::Metis => Ok(21.5f64),
            DynOrigin::Mimas => Ok(198.2f64),
            DynOrigin::Enceladus => Ok(252.1f64),
            DynOrigin::Tethys => Ok(531f64),
            DynOrigin::Dione => Ok(561.4f64),
            DynOrigin::Rhea => Ok(763.5f64),
            DynOrigin::Titan => Ok(2575f64),
            DynOrigin::Hyperion => Ok(135f64),
            DynOrigin::Iapetus => Ok(734.3f64),
            DynOrigin::Phoebe => Ok(106.5f64),
            DynOrigin::Janus => Ok(89.2f64),
            DynOrigin::Epimetheus => Ok(58.2f64),
            DynOrigin::Helene => Ok(18f64),
            DynOrigin::Telesto => Ok(12.4f64),
            DynOrigin::Calypso => Ok(9.6f64),
            DynOrigin::Atlas => Ok(15.1f64),
            DynOrigin::Prometheus => Ok(43.1f64),
            DynOrigin::Pandora => Ok(40.6f64),
            DynOrigin::Pan => Ok(14f64),
            DynOrigin::Methone => Ok(1.45f64),
            DynOrigin::Pallene => Ok(2.23f64),
            DynOrigin::Polydeuces => Ok(1.3f64),
            DynOrigin::Daphnis => Ok(3.8f64),
            DynOrigin::Anthe => Ok(0.5f64),
            DynOrigin::Aegaeon => Ok(0.33f64),
            DynOrigin::Ariel => Ok(578.9f64),
            DynOrigin::Umbriel => Ok(584.7f64),
            DynOrigin::Titania => Ok(788.9f64),
            DynOrigin::Oberon => Ok(761.4f64),
            DynOrigin::Miranda => Ok(235.8f64),
            DynOrigin::Cordelia => Ok(13f64),
            DynOrigin::Ophelia => Ok(15f64),
            DynOrigin::Bianca => Ok(21f64),
            DynOrigin::Cressida => Ok(31f64),
            DynOrigin::Desdemona => Ok(27f64),
            DynOrigin::Juliet => Ok(42f64),
            DynOrigin::Portia => Ok(54f64),
            DynOrigin::Rosalind => Ok(27f64),
            DynOrigin::Belinda => Ok(33f64),
            DynOrigin::Puck => Ok(77f64),
            DynOrigin::Triton => Ok(1352.6f64),
            DynOrigin::Nereid => Ok(170f64),
            DynOrigin::Naiad => Ok(29f64),
            DynOrigin::Thalassa => Ok(40f64),
            DynOrigin::Despina => Ok(74f64),
            DynOrigin::Galatea => Ok(79f64),
            DynOrigin::Larissa => Ok(96f64),
            DynOrigin::Proteus => Ok(208f64),
            DynOrigin::Charon => Ok(606f64),
            DynOrigin::Gaspra => Ok(6.1f64),
            DynOrigin::Ida => Ok(15.65f64),
            DynOrigin::Ceres => Ok(470f64),
            DynOrigin::Psyche => Ok(113f64),
            DynOrigin::Lutetia => Ok(52.5f64),
            DynOrigin::Eros => Ok(8.45f64),
            DynOrigin::Davida => Ok(150f64),
            DynOrigin::Mathilde => Ok(26.5f64),
            DynOrigin::Steins => Ok(2.7f64),
            _ => Err(UndefinedOriginPropertyError {
                origin: self.to_string(),
                prop: "mean radius".to_string(),
            }),
        }
    }
}
impl TryTriaxialEllipsoid for DynOrigin {
    fn try_radii(&self) -> Result<Radii, UndefinedOriginPropertyError> {
        match self {
            DynOrigin::Sun => Ok((695700f64, 695700f64, 695700f64)),
            DynOrigin::Mercury => Ok((2440.53f64, 2440.53f64, 2438.26f64)),
            DynOrigin::Venus => Ok((6051.8f64, 6051.8f64, 6051.8f64)),
            DynOrigin::Earth => Ok((6378.1366f64, 6378.1366f64, 6356.7519f64)),
            DynOrigin::Mars => Ok((3396.19f64, 3396.19f64, 3376.2f64)),
            DynOrigin::Jupiter => Ok((71492f64, 71492f64, 66854f64)),
            DynOrigin::Saturn => Ok((60268f64, 60268f64, 54364f64)),
            DynOrigin::Uranus => Ok((25559f64, 25559f64, 24973f64)),
            DynOrigin::Neptune => Ok((24764f64, 24764f64, 24341f64)),
            DynOrigin::Pluto => Ok((1188.3f64, 1188.3f64, 1188.3f64)),
            DynOrigin::Moon => Ok((1737.4f64, 1737.4f64, 1737.4f64)),
            DynOrigin::Phobos => Ok((13f64, 11.4f64, 9.1f64)),
            DynOrigin::Deimos => Ok((7.8f64, 6f64, 5.1f64)),
            DynOrigin::Io => Ok((1829.4f64, 1819.4f64, 1815.7f64)),
            DynOrigin::Europa => Ok((1562.6f64, 1560.3f64, 1559.5f64)),
            DynOrigin::Ganymede => Ok((2631.2f64, 2631.2f64, 2631.2f64)),
            DynOrigin::Callisto => Ok((2410.3f64, 2410.3f64, 2410.3f64)),
            DynOrigin::Amalthea => Ok((125f64, 73f64, 64f64)),
            DynOrigin::Himalia => Ok((85f64, 85f64, 85f64)),
            DynOrigin::Elara => Ok((40f64, 40f64, 40f64)),
            DynOrigin::Pasiphae => Ok((18f64, 18f64, 18f64)),
            DynOrigin::Sinope => Ok((14f64, 14f64, 14f64)),
            DynOrigin::Lysithea => Ok((12f64, 12f64, 12f64)),
            DynOrigin::Carme => Ok((15f64, 15f64, 15f64)),
            DynOrigin::Ananke => Ok((10f64, 10f64, 10f64)),
            DynOrigin::Leda => Ok((5f64, 5f64, 5f64)),
            DynOrigin::Thebe => Ok((58f64, 49f64, 42f64)),
            DynOrigin::Adrastea => Ok((10f64, 8f64, 7f64)),
            DynOrigin::Metis => Ok((30f64, 20f64, 17f64)),
            DynOrigin::Mimas => Ok((207.8f64, 196.7f64, 190.6f64)),
            DynOrigin::Enceladus => Ok((256.6f64, 251.4f64, 248.3f64)),
            DynOrigin::Tethys => Ok((538.4f64, 528.3f64, 526.3f64)),
            DynOrigin::Dione => Ok((563.4f64, 561.3f64, 559.6f64)),
            DynOrigin::Rhea => Ok((765f64, 763.1f64, 762.4f64)),
            DynOrigin::Titan => Ok((2575.15f64, 2574.78f64, 2574.47f64)),
            DynOrigin::Hyperion => Ok((180.1f64, 133f64, 102.7f64)),
            DynOrigin::Iapetus => Ok((745.7f64, 745.7f64, 712.1f64)),
            DynOrigin::Phoebe => Ok((109.4f64, 108.5f64, 101.8f64)),
            DynOrigin::Janus => Ok((101.7f64, 93f64, 76.3f64)),
            DynOrigin::Epimetheus => Ok((64.9f64, 57.3f64, 53f64)),
            DynOrigin::Helene => Ok((22.5f64, 19.6f64, 13.3f64)),
            DynOrigin::Telesto => Ok((16.3f64, 11.8f64, 9.8f64)),
            DynOrigin::Calypso => Ok((15.3f64, 9.3f64, 6.3f64)),
            DynOrigin::Atlas => Ok((20.5f64, 17.8f64, 9.4f64)),
            DynOrigin::Prometheus => Ok((68.2f64, 41.6f64, 28.2f64)),
            DynOrigin::Pandora => Ok((52.2f64, 40.8f64, 31.5f64)),
            DynOrigin::Pan => Ok((17.2f64, 15.4f64, 10.4f64)),
            DynOrigin::Methone => Ok((1.94f64, 1.29f64, 1.21f64)),
            DynOrigin::Pallene => Ok((2.88f64, 2.08f64, 1.8f64)),
            DynOrigin::Polydeuces => Ok((1.5f64, 1.2f64, 1f64)),
            DynOrigin::Daphnis => Ok((4.6f64, 4.5f64, 2.8f64)),
            DynOrigin::Anthe => Ok((0.5f64, 0.5f64, 0.5f64)),
            DynOrigin::Aegaeon => Ok((0.7f64, 0.25f64, 0.2f64)),
            DynOrigin::Ariel => Ok((581.1f64, 577.9f64, 577.7f64)),
            DynOrigin::Umbriel => Ok((584.7f64, 584.7f64, 584.7f64)),
            DynOrigin::Titania => Ok((788.9f64, 788.9f64, 788.9f64)),
            DynOrigin::Oberon => Ok((761.4f64, 761.4f64, 761.4f64)),
            DynOrigin::Miranda => Ok((240.4f64, 234.2f64, 232.9f64)),
            DynOrigin::Cordelia => Ok((13f64, 13f64, 13f64)),
            DynOrigin::Ophelia => Ok((15f64, 15f64, 15f64)),
            DynOrigin::Bianca => Ok((21f64, 21f64, 21f64)),
            DynOrigin::Cressida => Ok((31f64, 31f64, 31f64)),
            DynOrigin::Desdemona => Ok((27f64, 27f64, 27f64)),
            DynOrigin::Juliet => Ok((42f64, 42f64, 42f64)),
            DynOrigin::Portia => Ok((54f64, 54f64, 54f64)),
            DynOrigin::Rosalind => Ok((27f64, 27f64, 27f64)),
            DynOrigin::Belinda => Ok((33f64, 33f64, 33f64)),
            DynOrigin::Puck => Ok((77f64, 77f64, 77f64)),
            DynOrigin::Triton => Ok((1352.6f64, 1352.6f64, 1352.6f64)),
            DynOrigin::Nereid => Ok((170f64, 170f64, 170f64)),
            DynOrigin::Naiad => Ok((29f64, 29f64, 29f64)),
            DynOrigin::Thalassa => Ok((40f64, 40f64, 40f64)),
            DynOrigin::Despina => Ok((74f64, 74f64, 74f64)),
            DynOrigin::Galatea => Ok((79f64, 79f64, 79f64)),
            DynOrigin::Larissa => Ok((96f64, 96f64, 96f64)),
            DynOrigin::Proteus => Ok((218f64, 208f64, 201f64)),
            DynOrigin::Charon => Ok((606f64, 606f64, 606f64)),
            DynOrigin::Gaspra => Ok((9.1f64, 5.2f64, 4.4f64)),
            DynOrigin::Ida => Ok((26.8f64, 12f64, 7.6f64)),
            DynOrigin::Ceres => Ok((487.3f64, 487.3f64, 446f64)),
            DynOrigin::Vesta => Ok((289f64, 280f64, 229f64)),
            DynOrigin::Psyche => Ok((139.5f64, 116f64, 94.5f64)),
            DynOrigin::Lutetia => Ok((62f64, 50.5f64, 46.5f64)),
            DynOrigin::Eros => Ok((17f64, 5.5f64, 5.5f64)),
            DynOrigin::Davida => Ok((180f64, 147f64, 127f64)),
            DynOrigin::Mathilde => Ok((33f64, 24f64, 23f64)),
            DynOrigin::Steins => Ok((3.24f64, 2.73f64, 2.04f64)),
            DynOrigin::Toutatis => Ok((2.13f64, 1.015f64, 0.85f64)),
            DynOrigin::Itokawa => Ok((0.268f64, 0.147f64, 0.104f64)),
            _ => Err(UndefinedOriginPropertyError {
                origin: self.to_string(),
                prop: "radii".to_string(),
            }),
        }
    }
}
impl TrySpheroid for DynOrigin {}
impl TryRotationalElements for DynOrigin {
    fn try_rotational_elements(&self, t: f64) -> Result<Elements, UndefinedOriginPropertyError> {
        match self {
            DynOrigin::Sun => Ok((
                RIGHT_ASCENSION_SUN.angle(t),
                DECLINATION_SUN.angle(t),
                ROTATION_SUN.angle(t),
            )),
            DynOrigin::Mercury => Ok((
                RIGHT_ASCENSION_MERCURY.angle(t),
                DECLINATION_MERCURY.angle(t),
                ROTATION_MERCURY.angle(t),
            )),
            DynOrigin::Venus => Ok((
                RIGHT_ASCENSION_VENUS.angle(t),
                DECLINATION_VENUS.angle(t),
                ROTATION_VENUS.angle(t),
            )),
            DynOrigin::Earth => Ok((
                RIGHT_ASCENSION_EARTH.angle(t),
                DECLINATION_EARTH.angle(t),
                ROTATION_EARTH.angle(t),
            )),
            DynOrigin::Mars => Ok((
                RIGHT_ASCENSION_MARS.angle(t),
                DECLINATION_MARS.angle(t),
                ROTATION_MARS.angle(t),
            )),
            DynOrigin::Jupiter => Ok((
                RIGHT_ASCENSION_JUPITER.angle(t),
                DECLINATION_JUPITER.angle(t),
                ROTATION_JUPITER.angle(t),
            )),
            DynOrigin::Saturn => Ok((
                RIGHT_ASCENSION_SATURN.angle(t),
                DECLINATION_SATURN.angle(t),
                ROTATION_SATURN.angle(t),
            )),
            DynOrigin::Uranus => Ok((
                RIGHT_ASCENSION_URANUS.angle(t),
                DECLINATION_URANUS.angle(t),
                ROTATION_URANUS.angle(t),
            )),
            DynOrigin::Neptune => Ok((
                RIGHT_ASCENSION_NEPTUNE.angle(t),
                DECLINATION_NEPTUNE.angle(t),
                ROTATION_NEPTUNE.angle(t),
            )),
            DynOrigin::Pluto => Ok((
                RIGHT_ASCENSION_PLUTO.angle(t),
                DECLINATION_PLUTO.angle(t),
                ROTATION_PLUTO.angle(t),
            )),
            DynOrigin::Moon => Ok((
                RIGHT_ASCENSION_MOON.angle(t),
                DECLINATION_MOON.angle(t),
                ROTATION_MOON.angle(t),
            )),
            DynOrigin::Phobos => Ok((
                RIGHT_ASCENSION_PHOBOS.angle(t),
                DECLINATION_PHOBOS.angle(t),
                ROTATION_PHOBOS.angle(t),
            )),
            DynOrigin::Deimos => Ok((
                RIGHT_ASCENSION_DEIMOS.angle(t),
                DECLINATION_DEIMOS.angle(t),
                ROTATION_DEIMOS.angle(t),
            )),
            DynOrigin::Io => Ok((
                RIGHT_ASCENSION_IO.angle(t),
                DECLINATION_IO.angle(t),
                ROTATION_IO.angle(t),
            )),
            DynOrigin::Europa => Ok((
                RIGHT_ASCENSION_EUROPA.angle(t),
                DECLINATION_EUROPA.angle(t),
                ROTATION_EUROPA.angle(t),
            )),
            DynOrigin::Ganymede => Ok((
                RIGHT_ASCENSION_GANYMEDE.angle(t),
                DECLINATION_GANYMEDE.angle(t),
                ROTATION_GANYMEDE.angle(t),
            )),
            DynOrigin::Callisto => Ok((
                RIGHT_ASCENSION_CALLISTO.angle(t),
                DECLINATION_CALLISTO.angle(t),
                ROTATION_CALLISTO.angle(t),
            )),
            DynOrigin::Amalthea => Ok((
                RIGHT_ASCENSION_AMALTHEA.angle(t),
                DECLINATION_AMALTHEA.angle(t),
                ROTATION_AMALTHEA.angle(t),
            )),
            DynOrigin::Thebe => Ok((
                RIGHT_ASCENSION_THEBE.angle(t),
                DECLINATION_THEBE.angle(t),
                ROTATION_THEBE.angle(t),
            )),
            DynOrigin::Adrastea => Ok((
                RIGHT_ASCENSION_ADRASTEA.angle(t),
                DECLINATION_ADRASTEA.angle(t),
                ROTATION_ADRASTEA.angle(t),
            )),
            DynOrigin::Metis => Ok((
                RIGHT_ASCENSION_METIS.angle(t),
                DECLINATION_METIS.angle(t),
                ROTATION_METIS.angle(t),
            )),
            DynOrigin::Mimas => Ok((
                RIGHT_ASCENSION_MIMAS.angle(t),
                DECLINATION_MIMAS.angle(t),
                ROTATION_MIMAS.angle(t),
            )),
            DynOrigin::Enceladus => Ok((
                RIGHT_ASCENSION_ENCELADUS.angle(t),
                DECLINATION_ENCELADUS.angle(t),
                ROTATION_ENCELADUS.angle(t),
            )),
            DynOrigin::Tethys => Ok((
                RIGHT_ASCENSION_TETHYS.angle(t),
                DECLINATION_TETHYS.angle(t),
                ROTATION_TETHYS.angle(t),
            )),
            DynOrigin::Dione => Ok((
                RIGHT_ASCENSION_DIONE.angle(t),
                DECLINATION_DIONE.angle(t),
                ROTATION_DIONE.angle(t),
            )),
            DynOrigin::Rhea => Ok((
                RIGHT_ASCENSION_RHEA.angle(t),
                DECLINATION_RHEA.angle(t),
                ROTATION_RHEA.angle(t),
            )),
            DynOrigin::Titan => Ok((
                RIGHT_ASCENSION_TITAN.angle(t),
                DECLINATION_TITAN.angle(t),
                ROTATION_TITAN.angle(t),
            )),
            DynOrigin::Iapetus => Ok((
                RIGHT_ASCENSION_IAPETUS.angle(t),
                DECLINATION_IAPETUS.angle(t),
                ROTATION_IAPETUS.angle(t),
            )),
            DynOrigin::Phoebe => Ok((
                RIGHT_ASCENSION_PHOEBE.angle(t),
                DECLINATION_PHOEBE.angle(t),
                ROTATION_PHOEBE.angle(t),
            )),
            DynOrigin::Janus => Ok((
                RIGHT_ASCENSION_JANUS.angle(t),
                DECLINATION_JANUS.angle(t),
                ROTATION_JANUS.angle(t),
            )),
            DynOrigin::Epimetheus => Ok((
                RIGHT_ASCENSION_EPIMETHEUS.angle(t),
                DECLINATION_EPIMETHEUS.angle(t),
                ROTATION_EPIMETHEUS.angle(t),
            )),
            DynOrigin::Helene => Ok((
                RIGHT_ASCENSION_HELENE.angle(t),
                DECLINATION_HELENE.angle(t),
                ROTATION_HELENE.angle(t),
            )),
            DynOrigin::Telesto => Ok((
                RIGHT_ASCENSION_TELESTO.angle(t),
                DECLINATION_TELESTO.angle(t),
                ROTATION_TELESTO.angle(t),
            )),
            DynOrigin::Calypso => Ok((
                RIGHT_ASCENSION_CALYPSO.angle(t),
                DECLINATION_CALYPSO.angle(t),
                ROTATION_CALYPSO.angle(t),
            )),
            DynOrigin::Atlas => Ok((
                RIGHT_ASCENSION_ATLAS.angle(t),
                DECLINATION_ATLAS.angle(t),
                ROTATION_ATLAS.angle(t),
            )),
            DynOrigin::Prometheus => Ok((
                RIGHT_ASCENSION_PROMETHEUS.angle(t),
                DECLINATION_PROMETHEUS.angle(t),
                ROTATION_PROMETHEUS.angle(t),
            )),
            DynOrigin::Pandora => Ok((
                RIGHT_ASCENSION_PANDORA.angle(t),
                DECLINATION_PANDORA.angle(t),
                ROTATION_PANDORA.angle(t),
            )),
            DynOrigin::Pan => Ok((
                RIGHT_ASCENSION_PAN.angle(t),
                DECLINATION_PAN.angle(t),
                ROTATION_PAN.angle(t),
            )),
            DynOrigin::Ariel => Ok((
                RIGHT_ASCENSION_ARIEL.angle(t),
                DECLINATION_ARIEL.angle(t),
                ROTATION_ARIEL.angle(t),
            )),
            DynOrigin::Umbriel => Ok((
                RIGHT_ASCENSION_UMBRIEL.angle(t),
                DECLINATION_UMBRIEL.angle(t),
                ROTATION_UMBRIEL.angle(t),
            )),
            DynOrigin::Titania => Ok((
                RIGHT_ASCENSION_TITANIA.angle(t),
                DECLINATION_TITANIA.angle(t),
                ROTATION_TITANIA.angle(t),
            )),
            DynOrigin::Oberon => Ok((
                RIGHT_ASCENSION_OBERON.angle(t),
                DECLINATION_OBERON.angle(t),
                ROTATION_OBERON.angle(t),
            )),
            DynOrigin::Miranda => Ok((
                RIGHT_ASCENSION_MIRANDA.angle(t),
                DECLINATION_MIRANDA.angle(t),
                ROTATION_MIRANDA.angle(t),
            )),
            DynOrigin::Cordelia => Ok((
                RIGHT_ASCENSION_CORDELIA.angle(t),
                DECLINATION_CORDELIA.angle(t),
                ROTATION_CORDELIA.angle(t),
            )),
            DynOrigin::Ophelia => Ok((
                RIGHT_ASCENSION_OPHELIA.angle(t),
                DECLINATION_OPHELIA.angle(t),
                ROTATION_OPHELIA.angle(t),
            )),
            DynOrigin::Bianca => Ok((
                RIGHT_ASCENSION_BIANCA.angle(t),
                DECLINATION_BIANCA.angle(t),
                ROTATION_BIANCA.angle(t),
            )),
            DynOrigin::Cressida => Ok((
                RIGHT_ASCENSION_CRESSIDA.angle(t),
                DECLINATION_CRESSIDA.angle(t),
                ROTATION_CRESSIDA.angle(t),
            )),
            DynOrigin::Desdemona => Ok((
                RIGHT_ASCENSION_DESDEMONA.angle(t),
                DECLINATION_DESDEMONA.angle(t),
                ROTATION_DESDEMONA.angle(t),
            )),
            DynOrigin::Juliet => Ok((
                RIGHT_ASCENSION_JULIET.angle(t),
                DECLINATION_JULIET.angle(t),
                ROTATION_JULIET.angle(t),
            )),
            DynOrigin::Portia => Ok((
                RIGHT_ASCENSION_PORTIA.angle(t),
                DECLINATION_PORTIA.angle(t),
                ROTATION_PORTIA.angle(t),
            )),
            DynOrigin::Rosalind => Ok((
                RIGHT_ASCENSION_ROSALIND.angle(t),
                DECLINATION_ROSALIND.angle(t),
                ROTATION_ROSALIND.angle(t),
            )),
            DynOrigin::Belinda => Ok((
                RIGHT_ASCENSION_BELINDA.angle(t),
                DECLINATION_BELINDA.angle(t),
                ROTATION_BELINDA.angle(t),
            )),
            DynOrigin::Puck => Ok((
                RIGHT_ASCENSION_PUCK.angle(t),
                DECLINATION_PUCK.angle(t),
                ROTATION_PUCK.angle(t),
            )),
            DynOrigin::Triton => Ok((
                RIGHT_ASCENSION_TRITON.angle(t),
                DECLINATION_TRITON.angle(t),
                ROTATION_TRITON.angle(t),
            )),
            DynOrigin::Naiad => Ok((
                RIGHT_ASCENSION_NAIAD.angle(t),
                DECLINATION_NAIAD.angle(t),
                ROTATION_NAIAD.angle(t),
            )),
            DynOrigin::Thalassa => Ok((
                RIGHT_ASCENSION_THALASSA.angle(t),
                DECLINATION_THALASSA.angle(t),
                ROTATION_THALASSA.angle(t),
            )),
            DynOrigin::Despina => Ok((
                RIGHT_ASCENSION_DESPINA.angle(t),
                DECLINATION_DESPINA.angle(t),
                ROTATION_DESPINA.angle(t),
            )),
            DynOrigin::Galatea => Ok((
                RIGHT_ASCENSION_GALATEA.angle(t),
                DECLINATION_GALATEA.angle(t),
                ROTATION_GALATEA.angle(t),
            )),
            DynOrigin::Larissa => Ok((
                RIGHT_ASCENSION_LARISSA.angle(t),
                DECLINATION_LARISSA.angle(t),
                ROTATION_LARISSA.angle(t),
            )),
            DynOrigin::Proteus => Ok((
                RIGHT_ASCENSION_PROTEUS.angle(t),
                DECLINATION_PROTEUS.angle(t),
                ROTATION_PROTEUS.angle(t),
            )),
            DynOrigin::Charon => Ok((
                RIGHT_ASCENSION_CHARON.angle(t),
                DECLINATION_CHARON.angle(t),
                ROTATION_CHARON.angle(t),
            )),
            DynOrigin::Gaspra => Ok((
                RIGHT_ASCENSION_GASPRA.angle(t),
                DECLINATION_GASPRA.angle(t),
                ROTATION_GASPRA.angle(t),
            )),
            DynOrigin::Ida => Ok((
                RIGHT_ASCENSION_IDA.angle(t),
                DECLINATION_IDA.angle(t),
                ROTATION_IDA.angle(t),
            )),
            DynOrigin::Ceres => Ok((
                RIGHT_ASCENSION_CERES.angle(t),
                DECLINATION_CERES.angle(t),
                ROTATION_CERES.angle(t),
            )),
            DynOrigin::Pallas => Ok((
                RIGHT_ASCENSION_PALLAS.angle(t),
                DECLINATION_PALLAS.angle(t),
                ROTATION_PALLAS.angle(t),
            )),
            DynOrigin::Vesta => Ok((
                RIGHT_ASCENSION_VESTA.angle(t),
                DECLINATION_VESTA.angle(t),
                ROTATION_VESTA.angle(t),
            )),
            DynOrigin::Lutetia => Ok((
                RIGHT_ASCENSION_LUTETIA.angle(t),
                DECLINATION_LUTETIA.angle(t),
                ROTATION_LUTETIA.angle(t),
            )),
            DynOrigin::Eros => Ok((
                RIGHT_ASCENSION_EROS.angle(t),
                DECLINATION_EROS.angle(t),
                ROTATION_EROS.angle(t),
            )),
            DynOrigin::Davida => Ok((
                RIGHT_ASCENSION_DAVIDA.angle(t),
                DECLINATION_DAVIDA.angle(t),
                ROTATION_DAVIDA.angle(t),
            )),
            DynOrigin::Steins => Ok((
                RIGHT_ASCENSION_STEINS.angle(t),
                DECLINATION_STEINS.angle(t),
                ROTATION_STEINS.angle(t),
            )),
            DynOrigin::Itokawa => Ok((
                RIGHT_ASCENSION_ITOKAWA.angle(t),
                DECLINATION_ITOKAWA.angle(t),
                ROTATION_ITOKAWA.angle(t),
            )),
            _ => Err(UndefinedOriginPropertyError {
                origin: self.to_string(),
                prop: "rotational elements".to_string(),
            }),
        }
    }
    fn try_rotational_element_rates(
        &self,
        t: f64,
    ) -> Result<Elements, UndefinedOriginPropertyError> {
        match self {
            DynOrigin::Sun => Ok((
                RIGHT_ASCENSION_SUN.angle_dot(t),
                DECLINATION_SUN.angle_dot(t),
                ROTATION_SUN.angle_dot(t),
            )),
            DynOrigin::Mercury => Ok((
                RIGHT_ASCENSION_MERCURY.angle_dot(t),
                DECLINATION_MERCURY.angle_dot(t),
                ROTATION_MERCURY.angle_dot(t),
            )),
            DynOrigin::Venus => Ok((
                RIGHT_ASCENSION_VENUS.angle_dot(t),
                DECLINATION_VENUS.angle_dot(t),
                ROTATION_VENUS.angle_dot(t),
            )),
            DynOrigin::Earth => Ok((
                RIGHT_ASCENSION_EARTH.angle_dot(t),
                DECLINATION_EARTH.angle_dot(t),
                ROTATION_EARTH.angle_dot(t),
            )),
            DynOrigin::Mars => Ok((
                RIGHT_ASCENSION_MARS.angle_dot(t),
                DECLINATION_MARS.angle_dot(t),
                ROTATION_MARS.angle_dot(t),
            )),
            DynOrigin::Jupiter => Ok((
                RIGHT_ASCENSION_JUPITER.angle_dot(t),
                DECLINATION_JUPITER.angle_dot(t),
                ROTATION_JUPITER.angle_dot(t),
            )),
            DynOrigin::Saturn => Ok((
                RIGHT_ASCENSION_SATURN.angle_dot(t),
                DECLINATION_SATURN.angle_dot(t),
                ROTATION_SATURN.angle_dot(t),
            )),
            DynOrigin::Uranus => Ok((
                RIGHT_ASCENSION_URANUS.angle_dot(t),
                DECLINATION_URANUS.angle_dot(t),
                ROTATION_URANUS.angle_dot(t),
            )),
            DynOrigin::Neptune => Ok((
                RIGHT_ASCENSION_NEPTUNE.angle_dot(t),
                DECLINATION_NEPTUNE.angle_dot(t),
                ROTATION_NEPTUNE.angle_dot(t),
            )),
            DynOrigin::Pluto => Ok((
                RIGHT_ASCENSION_PLUTO.angle_dot(t),
                DECLINATION_PLUTO.angle_dot(t),
                ROTATION_PLUTO.angle_dot(t),
            )),
            DynOrigin::Moon => Ok((
                RIGHT_ASCENSION_MOON.angle_dot(t),
                DECLINATION_MOON.angle_dot(t),
                ROTATION_MOON.angle_dot(t),
            )),
            DynOrigin::Phobos => Ok((
                RIGHT_ASCENSION_PHOBOS.angle_dot(t),
                DECLINATION_PHOBOS.angle_dot(t),
                ROTATION_PHOBOS.angle_dot(t),
            )),
            DynOrigin::Deimos => Ok((
                RIGHT_ASCENSION_DEIMOS.angle_dot(t),
                DECLINATION_DEIMOS.angle_dot(t),
                ROTATION_DEIMOS.angle_dot(t),
            )),
            DynOrigin::Io => Ok((
                RIGHT_ASCENSION_IO.angle_dot(t),
                DECLINATION_IO.angle_dot(t),
                ROTATION_IO.angle_dot(t),
            )),
            DynOrigin::Europa => Ok((
                RIGHT_ASCENSION_EUROPA.angle_dot(t),
                DECLINATION_EUROPA.angle_dot(t),
                ROTATION_EUROPA.angle_dot(t),
            )),
            DynOrigin::Ganymede => Ok((
                RIGHT_ASCENSION_GANYMEDE.angle_dot(t),
                DECLINATION_GANYMEDE.angle_dot(t),
                ROTATION_GANYMEDE.angle_dot(t),
            )),
            DynOrigin::Callisto => Ok((
                RIGHT_ASCENSION_CALLISTO.angle_dot(t),
                DECLINATION_CALLISTO.angle_dot(t),
                ROTATION_CALLISTO.angle_dot(t),
            )),
            DynOrigin::Amalthea => Ok((
                RIGHT_ASCENSION_AMALTHEA.angle_dot(t),
                DECLINATION_AMALTHEA.angle_dot(t),
                ROTATION_AMALTHEA.angle_dot(t),
            )),
            DynOrigin::Thebe => Ok((
                RIGHT_ASCENSION_THEBE.angle_dot(t),
                DECLINATION_THEBE.angle_dot(t),
                ROTATION_THEBE.angle_dot(t),
            )),
            DynOrigin::Adrastea => Ok((
                RIGHT_ASCENSION_ADRASTEA.angle_dot(t),
                DECLINATION_ADRASTEA.angle_dot(t),
                ROTATION_ADRASTEA.angle_dot(t),
            )),
            DynOrigin::Metis => Ok((
                RIGHT_ASCENSION_METIS.angle_dot(t),
                DECLINATION_METIS.angle_dot(t),
                ROTATION_METIS.angle_dot(t),
            )),
            DynOrigin::Mimas => Ok((
                RIGHT_ASCENSION_MIMAS.angle_dot(t),
                DECLINATION_MIMAS.angle_dot(t),
                ROTATION_MIMAS.angle_dot(t),
            )),
            DynOrigin::Enceladus => Ok((
                RIGHT_ASCENSION_ENCELADUS.angle_dot(t),
                DECLINATION_ENCELADUS.angle_dot(t),
                ROTATION_ENCELADUS.angle_dot(t),
            )),
            DynOrigin::Tethys => Ok((
                RIGHT_ASCENSION_TETHYS.angle_dot(t),
                DECLINATION_TETHYS.angle_dot(t),
                ROTATION_TETHYS.angle_dot(t),
            )),
            DynOrigin::Dione => Ok((
                RIGHT_ASCENSION_DIONE.angle_dot(t),
                DECLINATION_DIONE.angle_dot(t),
                ROTATION_DIONE.angle_dot(t),
            )),
            DynOrigin::Rhea => Ok((
                RIGHT_ASCENSION_RHEA.angle_dot(t),
                DECLINATION_RHEA.angle_dot(t),
                ROTATION_RHEA.angle_dot(t),
            )),
            DynOrigin::Titan => Ok((
                RIGHT_ASCENSION_TITAN.angle_dot(t),
                DECLINATION_TITAN.angle_dot(t),
                ROTATION_TITAN.angle_dot(t),
            )),
            DynOrigin::Iapetus => Ok((
                RIGHT_ASCENSION_IAPETUS.angle_dot(t),
                DECLINATION_IAPETUS.angle_dot(t),
                ROTATION_IAPETUS.angle_dot(t),
            )),
            DynOrigin::Phoebe => Ok((
                RIGHT_ASCENSION_PHOEBE.angle_dot(t),
                DECLINATION_PHOEBE.angle_dot(t),
                ROTATION_PHOEBE.angle_dot(t),
            )),
            DynOrigin::Janus => Ok((
                RIGHT_ASCENSION_JANUS.angle_dot(t),
                DECLINATION_JANUS.angle_dot(t),
                ROTATION_JANUS.angle_dot(t),
            )),
            DynOrigin::Epimetheus => Ok((
                RIGHT_ASCENSION_EPIMETHEUS.angle_dot(t),
                DECLINATION_EPIMETHEUS.angle_dot(t),
                ROTATION_EPIMETHEUS.angle_dot(t),
            )),
            DynOrigin::Helene => Ok((
                RIGHT_ASCENSION_HELENE.angle_dot(t),
                DECLINATION_HELENE.angle_dot(t),
                ROTATION_HELENE.angle_dot(t),
            )),
            DynOrigin::Telesto => Ok((
                RIGHT_ASCENSION_TELESTO.angle_dot(t),
                DECLINATION_TELESTO.angle_dot(t),
                ROTATION_TELESTO.angle_dot(t),
            )),
            DynOrigin::Calypso => Ok((
                RIGHT_ASCENSION_CALYPSO.angle_dot(t),
                DECLINATION_CALYPSO.angle_dot(t),
                ROTATION_CALYPSO.angle_dot(t),
            )),
            DynOrigin::Atlas => Ok((
                RIGHT_ASCENSION_ATLAS.angle_dot(t),
                DECLINATION_ATLAS.angle_dot(t),
                ROTATION_ATLAS.angle_dot(t),
            )),
            DynOrigin::Prometheus => Ok((
                RIGHT_ASCENSION_PROMETHEUS.angle_dot(t),
                DECLINATION_PROMETHEUS.angle_dot(t),
                ROTATION_PROMETHEUS.angle_dot(t),
            )),
            DynOrigin::Pandora => Ok((
                RIGHT_ASCENSION_PANDORA.angle_dot(t),
                DECLINATION_PANDORA.angle_dot(t),
                ROTATION_PANDORA.angle_dot(t),
            )),
            DynOrigin::Pan => Ok((
                RIGHT_ASCENSION_PAN.angle_dot(t),
                DECLINATION_PAN.angle_dot(t),
                ROTATION_PAN.angle_dot(t),
            )),
            DynOrigin::Ariel => Ok((
                RIGHT_ASCENSION_ARIEL.angle_dot(t),
                DECLINATION_ARIEL.angle_dot(t),
                ROTATION_ARIEL.angle_dot(t),
            )),
            DynOrigin::Umbriel => Ok((
                RIGHT_ASCENSION_UMBRIEL.angle_dot(t),
                DECLINATION_UMBRIEL.angle_dot(t),
                ROTATION_UMBRIEL.angle_dot(t),
            )),
            DynOrigin::Titania => Ok((
                RIGHT_ASCENSION_TITANIA.angle_dot(t),
                DECLINATION_TITANIA.angle_dot(t),
                ROTATION_TITANIA.angle_dot(t),
            )),
            DynOrigin::Oberon => Ok((
                RIGHT_ASCENSION_OBERON.angle_dot(t),
                DECLINATION_OBERON.angle_dot(t),
                ROTATION_OBERON.angle_dot(t),
            )),
            DynOrigin::Miranda => Ok((
                RIGHT_ASCENSION_MIRANDA.angle_dot(t),
                DECLINATION_MIRANDA.angle_dot(t),
                ROTATION_MIRANDA.angle_dot(t),
            )),
            DynOrigin::Cordelia => Ok((
                RIGHT_ASCENSION_CORDELIA.angle_dot(t),
                DECLINATION_CORDELIA.angle_dot(t),
                ROTATION_CORDELIA.angle_dot(t),
            )),
            DynOrigin::Ophelia => Ok((
                RIGHT_ASCENSION_OPHELIA.angle_dot(t),
                DECLINATION_OPHELIA.angle_dot(t),
                ROTATION_OPHELIA.angle_dot(t),
            )),
            DynOrigin::Bianca => Ok((
                RIGHT_ASCENSION_BIANCA.angle_dot(t),
                DECLINATION_BIANCA.angle_dot(t),
                ROTATION_BIANCA.angle_dot(t),
            )),
            DynOrigin::Cressida => Ok((
                RIGHT_ASCENSION_CRESSIDA.angle_dot(t),
                DECLINATION_CRESSIDA.angle_dot(t),
                ROTATION_CRESSIDA.angle_dot(t),
            )),
            DynOrigin::Desdemona => Ok((
                RIGHT_ASCENSION_DESDEMONA.angle_dot(t),
                DECLINATION_DESDEMONA.angle_dot(t),
                ROTATION_DESDEMONA.angle_dot(t),
            )),
            DynOrigin::Juliet => Ok((
                RIGHT_ASCENSION_JULIET.angle_dot(t),
                DECLINATION_JULIET.angle_dot(t),
                ROTATION_JULIET.angle_dot(t),
            )),
            DynOrigin::Portia => Ok((
                RIGHT_ASCENSION_PORTIA.angle_dot(t),
                DECLINATION_PORTIA.angle_dot(t),
                ROTATION_PORTIA.angle_dot(t),
            )),
            DynOrigin::Rosalind => Ok((
                RIGHT_ASCENSION_ROSALIND.angle_dot(t),
                DECLINATION_ROSALIND.angle_dot(t),
                ROTATION_ROSALIND.angle_dot(t),
            )),
            DynOrigin::Belinda => Ok((
                RIGHT_ASCENSION_BELINDA.angle_dot(t),
                DECLINATION_BELINDA.angle_dot(t),
                ROTATION_BELINDA.angle_dot(t),
            )),
            DynOrigin::Puck => Ok((
                RIGHT_ASCENSION_PUCK.angle_dot(t),
                DECLINATION_PUCK.angle_dot(t),
                ROTATION_PUCK.angle_dot(t),
            )),
            DynOrigin::Triton => Ok((
                RIGHT_ASCENSION_TRITON.angle_dot(t),
                DECLINATION_TRITON.angle_dot(t),
                ROTATION_TRITON.angle_dot(t),
            )),
            DynOrigin::Naiad => Ok((
                RIGHT_ASCENSION_NAIAD.angle_dot(t),
                DECLINATION_NAIAD.angle_dot(t),
                ROTATION_NAIAD.angle_dot(t),
            )),
            DynOrigin::Thalassa => Ok((
                RIGHT_ASCENSION_THALASSA.angle_dot(t),
                DECLINATION_THALASSA.angle_dot(t),
                ROTATION_THALASSA.angle_dot(t),
            )),
            DynOrigin::Despina => Ok((
                RIGHT_ASCENSION_DESPINA.angle_dot(t),
                DECLINATION_DESPINA.angle_dot(t),
                ROTATION_DESPINA.angle_dot(t),
            )),
            DynOrigin::Galatea => Ok((
                RIGHT_ASCENSION_GALATEA.angle_dot(t),
                DECLINATION_GALATEA.angle_dot(t),
                ROTATION_GALATEA.angle_dot(t),
            )),
            DynOrigin::Larissa => Ok((
                RIGHT_ASCENSION_LARISSA.angle_dot(t),
                DECLINATION_LARISSA.angle_dot(t),
                ROTATION_LARISSA.angle_dot(t),
            )),
            DynOrigin::Proteus => Ok((
                RIGHT_ASCENSION_PROTEUS.angle_dot(t),
                DECLINATION_PROTEUS.angle_dot(t),
                ROTATION_PROTEUS.angle_dot(t),
            )),
            DynOrigin::Charon => Ok((
                RIGHT_ASCENSION_CHARON.angle_dot(t),
                DECLINATION_CHARON.angle_dot(t),
                ROTATION_CHARON.angle_dot(t),
            )),
            DynOrigin::Gaspra => Ok((
                RIGHT_ASCENSION_GASPRA.angle_dot(t),
                DECLINATION_GASPRA.angle_dot(t),
                ROTATION_GASPRA.angle_dot(t),
            )),
            DynOrigin::Ida => Ok((
                RIGHT_ASCENSION_IDA.angle_dot(t),
                DECLINATION_IDA.angle_dot(t),
                ROTATION_IDA.angle_dot(t),
            )),
            DynOrigin::Ceres => Ok((
                RIGHT_ASCENSION_CERES.angle_dot(t),
                DECLINATION_CERES.angle_dot(t),
                ROTATION_CERES.angle_dot(t),
            )),
            DynOrigin::Pallas => Ok((
                RIGHT_ASCENSION_PALLAS.angle_dot(t),
                DECLINATION_PALLAS.angle_dot(t),
                ROTATION_PALLAS.angle_dot(t),
            )),
            DynOrigin::Vesta => Ok((
                RIGHT_ASCENSION_VESTA.angle_dot(t),
                DECLINATION_VESTA.angle_dot(t),
                ROTATION_VESTA.angle_dot(t),
            )),
            DynOrigin::Lutetia => Ok((
                RIGHT_ASCENSION_LUTETIA.angle_dot(t),
                DECLINATION_LUTETIA.angle_dot(t),
                ROTATION_LUTETIA.angle_dot(t),
            )),
            DynOrigin::Eros => Ok((
                RIGHT_ASCENSION_EROS.angle_dot(t),
                DECLINATION_EROS.angle_dot(t),
                ROTATION_EROS.angle_dot(t),
            )),
            DynOrigin::Davida => Ok((
                RIGHT_ASCENSION_DAVIDA.angle_dot(t),
                DECLINATION_DAVIDA.angle_dot(t),
                ROTATION_DAVIDA.angle_dot(t),
            )),
            DynOrigin::Steins => Ok((
                RIGHT_ASCENSION_STEINS.angle_dot(t),
                DECLINATION_STEINS.angle_dot(t),
                ROTATION_STEINS.angle_dot(t),
            )),
            DynOrigin::Itokawa => Ok((
                RIGHT_ASCENSION_ITOKAWA.angle_dot(t),
                DECLINATION_ITOKAWA.angle_dot(t),
                ROTATION_ITOKAWA.angle_dot(t),
            )),
            _ => Err(UndefinedOriginPropertyError {
                origin: self.to_string(),
                prop: "rotational element rates".to_string(),
            }),
        }
    }
}
