/*
 * Copyright (c) 2023. Helge Eichhorn and the LOX contributors
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, you can obtain one at https://mozilla.org/MPL/2.0/.
 */

pub(crate) type LuniSolarFrequencyList = [f64; 5];

pub(crate) const N_FREQUENCY_LISTS: usize = 653;

#[rustfmt::skip]
// @formatter:off (sometimes RustRover ignores the rustfmt skip)
pub(crate) static FREQUENCY_LISTS: [LuniSolarFrequencyList; N_FREQUENCY_LISTS] = [
    [0.0,   0.0,   0.0,   0.0,   1.0],
    [0.0,   0.0,   2.0,  -2.0,   2.0],
    [0.0,   0.0,   2.0,   0.0,   2.0],
    [0.0,   0.0,   0.0,   0.0,   2.0],
    [0.0,   1.0,   0.0,   0.0,   0.0],
    [0.0,   1.0,   2.0,  -2.0,   2.0],
    [1.0,   0.0,   0.0,   0.0,   0.0],
    [0.0,   0.0,   2.0,   0.0,   1.0],
    [1.0,   0.0,   2.0,   0.0,   2.0],
    [0.0,   1.0,  -2.0,   2.0,  -2.0],
    [0.0,   0.0,   2.0,  -2.0,   1.0],
    [1.0,   0.0,  -2.0,   0.0,  -2.0],
    [1.0,   0.0,   0.0,  -2.0,   0.0],
    [1.0,   0.0,   0.0,   0.0,   1.0],
    [1.0,   0.0,   0.0,   0.0,  -1.0],
    [1.0,   0.0,  -2.0,  -2.0,  -2.0],
    [1.0,   0.0,   2.0,   0.0,   1.0],
    [2.0,   0.0,  -2.0,   0.0,  -1.0],
    [0.0,   0.0,   0.0,   2.0,   0.0],
    [0.0,   0.0,   2.0,   2.0,   2.0],
    [2.0,   0.0,   0.0,  -2.0,   0.0],
    [0.0,   2.0,  -2.0,   2.0,  -2.0],
    [2.0,   0.0,   2.0,   0.0,   2.0],
    [1.0,   0.0,   2.0,  -2.0,   2.0],
    [1.0,   0.0,  -2.0,   0.0,  -1.0],
    [2.0,   0.0,   0.0,   0.0,   0.0],
    [0.0,   0.0,   2.0,   0.0,   0.0],
    [0.0,   1.0,   0.0,   0.0,   1.0],
    [1.0,   0.0,   0.0,  -2.0,  -1.0],
    [0.0,   2.0,   2.0,  -2.0,   2.0],
    [0.0,   0.0,   2.0,  -2.0,   0.0],
    [1.0,   0.0,   0.0,  -2.0,   1.0],
    [0.0,   1.0,   0.0,   0.0,  -1.0],
    [0.0,   2.0,   0.0,   0.0,   0.0],
    [1.0,   0.0,  -2.0,  -2.0,  -1.0],
    [1.0,   0.0,   2.0,   2.0,   2.0],
    [0.0,   1.0,   2.0,   0.0,   2.0],
    [2.0,   0.0,  -2.0,   0.0,   0.0],
    [0.0,   0.0,   2.0,   2.0,   1.0],
    [0.0,   1.0,  -2.0,   0.0,  -2.0],
    [0.0,   0.0,   0.0,   2.0,   1.0],
    [1.0,   0.0,   2.0,  -2.0,   1.0],
    [2.0,   0.0,   0.0,  -2.0,  -1.0],
    [2.0,   0.0,   2.0,  -2.0,   2.0],
    [2.0,   0.0,   2.0,   0.0,   1.0],
    [0.0,   0.0,   0.0,   2.0,  -1.0],
    [0.0,   1.0,  -2.0,   2.0,  -1.0],
    [1.0,   1.0,   0.0,  -2.0,   0.0],
    [2.0,   0.0,   0.0,  -2.0,   1.0],
    [1.0,   0.0,   0.0,   2.0,   0.0],
    [0.0,   1.0,   2.0,  -2.0,   1.0],
    [1.0,  -1.0,   0.0,   0.0,   0.0],
    [0.0,   1.0,  -1.0,   1.0,  -1.0],
    [2.0,   0.0,  -2.0,   0.0,  -2.0],
    [0.0,   1.0,   0.0,  -2.0,   0.0],
    [1.0,   0.0,   0.0,  -1.0,   0.0],
    [3.0,   0.0,   2.0,   0.0,   2.0],
    [0.0,   0.0,   0.0,   1.0,   0.0],
    [1.0,  -1.0,   2.0,   0.0,   2.0],
    [1.0,   1.0,  -2.0,  -2.0,  -2.0],
    [1.0,   0.0,  -2.0,   0.0,   0.0],
    [2.0,   0.0,   0.0,   0.0,  -1.0],
    [0.0,   1.0,  -2.0,  -2.0,  -2.0],
    [1.0,   1.0,   2.0,   0.0,   2.0],
    [2.0,   0.0,   0.0,   0.0,   1.0],
    [1.0,   1.0,   0.0,   0.0,   0.0],
    [1.0,   0.0,  -2.0,   2.0,  -1.0],
    [1.0,   0.0,   2.0,   0.0,   0.0],
    [1.0,  -1.0,   0.0,  -1.0,   0.0],
    [1.0,   0.0,   0.0,   0.0,   2.0],
    [1.0,   0.0,  -1.0,   0.0,  -1.0],
    [0.0,   0.0,   2.0,   1.0,   2.0],
    [1.0,   0.0,  -2.0,  -4.0,  -2.0],
    [1.0,  -1.0,   0.0,  -1.0,  -1.0],
    [1.0,   0.0,   2.0,   2.0,   1.0],
    [0.0,   2.0,  -2.0,   2.0,  -1.0],
    [1.0,   0.0,   0.0,   0.0,  -2.0],
    [2.0,   0.0,  -2.0,  -2.0,  -2.0],
    [1.0,   1.0,   2.0,  -2.0,   2.0],
    [2.0,   0.0,  -2.0,  -4.0,  -2.0],
    [1.0,   0.0,  -4.0,   0.0,  -2.0],
    [2.0,   0.0,   2.0,  -2.0,   1.0],
    [1.0,   0.0,   0.0,  -1.0,  -1.0],
    [2.0,   0.0,   2.0,   2.0,   2.0],
    [3.0,   0.0,   0.0,   0.0,   0.0],
    [1.0,   0.0,   0.0,   2.0,   1.0],
    [0.0,   0.0,   2.0,  -2.0,  -1.0],
    [3.0,   0.0,   2.0,  -2.0,   2.0],
    [0.0,   0.0,   4.0,  -2.0,   2.0],
    [1.0,   0.0,   0.0,  -4.0,   0.0],
    [0.0,   1.0,   2.0,   0.0,   1.0],
    [2.0,   0.0,   0.0,  -4.0,   0.0],
    [1.0,   1.0,   0.0,  -2.0,  -1.0],
    [2.0,   0.0,  -2.0,   0.0,   1.0],
    [0.0,   0.0,   2.0,   0.0,  -1.0],
    [0.0,   1.0,  -2.0,   0.0,  -1.0],
    [0.0,   1.0,   0.0,   0.0,   2.0],
    [0.0,   0.0,   2.0,  -1.0,   2.0],
    [0.0,   0.0,   2.0,   4.0,   2.0],
    [2.0,   1.0,   0.0,  -2.0,   0.0],
    [1.0,   1.0,   0.0,  -2.0,   1.0],
    [1.0,  -1.0,   0.0,  -2.0,   0.0],
    [1.0,  -1.0,   0.0,  -1.0,  -2.0],
    [1.0,  -1.0,   0.0,   0.0,   1.0],
    [0.0,   1.0,  -2.0,   2.0,   0.0],
    [0.0,   1.0,   0.0,   0.0,  -2.0],
    [1.0,  -1.0,   2.0,   2.0,   2.0],
    [1.0,   0.0,   0.0,   2.0,  -1.0],
    [1.0,  -1.0,  -2.0,  -2.0,  -2.0],
    [3.0,   0.0,   2.0,   0.0,   1.0],
    [0.0,   1.0,   2.0,   2.0,   2.0],
    [1.0,   0.0,   2.0,  -2.0,   0.0],
    [1.0,   1.0,  -2.0,  -2.0,  -1.0],
    [1.0,   0.0,   2.0,  -4.0,   1.0],
    [0.0,   1.0,  -2.0,  -2.0,  -1.0],
    [2.0,  -1.0,   2.0,   0.0,   2.0],
    [0.0,   0.0,   0.0,   2.0,   2.0],
    [1.0,  -1.0,   2.0,   0.0,   1.0],
    [1.0,  -1.0,  -2.0,   0.0,  -2.0],
    [0.0,   1.0,   0.0,   2.0,   0.0],
    [0.0,   1.0,   2.0,  -2.0,   0.0],
    [0.0,   0.0,   0.0,   1.0,   1.0],
    [1.0,   0.0,  -2.0,  -2.0,   0.0],
    [0.0,   3.0,   2.0,  -2.0,   2.0],
    [2.0,   1.0,   2.0,   0.0,   2.0],
    [1.0,   1.0,   0.0,   0.0,   1.0],
    [2.0,   0.0,   0.0,   2.0,   0.0],
    [1.0,   1.0,   2.0,   0.0,   1.0],
    [1.0,   0.0,   0.0,  -2.0,  -2.0],
    [1.0,   0.0,  -2.0,   2.0,   0.0],
    [1.0,   0.0,  -1.0,   0.0,  -2.0],
    [0.0,   1.0,   0.0,  -2.0,   1.0],
    [0.0,   1.0,   0.0,   1.0,   0.0],
    [0.0,   0.0,   0.0,   1.0,  -1.0],
    [1.0,   0.0,  -2.0,   2.0,  -2.0],
    [1.0,  -1.0,   0.0,   0.0,  -1.0],
    [0.0,   0.0,   0.0,   4.0,   0.0],
    [1.0,  -1.0,   0.0,   2.0,   0.0],
    [1.0,   0.0,   2.0,   1.0,   2.0],
    [1.0,   0.0,   2.0,  -1.0,   2.0],
    [0.0,   0.0,   2.0,   1.0,   1.0],
    [1.0,   0.0,   0.0,  -2.0,   2.0],
    [1.0,   0.0,  -2.0,   0.0,   1.0],
    [1.0,   0.0,  -2.0,  -4.0,  -1.0],
    [0.0,   0.0,   2.0,   2.0,   0.0],
    [1.0,   1.0,   2.0,  -2.0,   1.0],
    [1.0,   0.0,  -2.0,   1.0,  -1.0],
    [0.0,   0.0,   1.0,   0.0,   1.0],
    [2.0,   0.0,  -2.0,  -2.0,  -1.0],
    [4.0,   0.0,   2.0,   0.0,   2.0],
    [2.0,  -1.0,   0.0,   0.0,   0.0],
    [2.0,   1.0,   2.0,  -2.0,   2.0],
    [0.0,   1.0,   2.0,   1.0,   2.0],
    [1.0,   0.0,   4.0,  -2.0,   2.0],
    [1.0,   1.0,   0.0,   0.0,  -1.0],
    [2.0,   0.0,   2.0,   0.0,   0.0],
    [2.0,   0.0,  -2.0,  -4.0,  -1.0],
    [1.0,   0.0,  -1.0,   0.0,   0.0],
    [1.0,   0.0,   0.0,   1.0,   0.0],
    [0.0,   1.0,   0.0,   2.0,   1.0],
    [1.0,   0.0,  -4.0,   0.0,  -1.0],
    [1.0,   0.0,   0.0,  -4.0,  -1.0],
    [2.0,   0.0,   2.0,   2.0,   1.0],
    [2.0,   1.0,   0.0,   0.0,   0.0],
    [0.0,   0.0,   2.0,  -3.0,   2.0],
    [1.0,   2.0,   0.0,  -2.0,   0.0],
    [0.0,   3.0,   0.0,   0.0,   0.0],
    [0.0,   0.0,   4.0,   0.0,   2.0],
    [0.0,   0.0,   2.0,  -4.0,   1.0],
    [2.0,   0.0,   0.0,  -2.0,  -2.0],
    [1.0,   1.0,  -2.0,  -4.0,  -2.0],
    [0.0,   1.0,   0.0,  -2.0,  -1.0],
    [0.0,   0.0,   0.0,   4.0,   1.0],
    [3.0,   0.0,   2.0,  -2.0,   1.0],
    [1.0,   0.0,   2.0,   4.0,   2.0],
    [1.0,   1.0,  -2.0,   0.0,  -2.0],
    [0.0,   0.0,   4.0,  -2.0,   1.0],
    [2.0,  -2.0,   0.0,  -2.0,   0.0],
    [2.0,   1.0,   0.0,  -2.0,  -1.0],
    [0.0,   2.0,   0.0,  -2.0,   0.0],
    [1.0,   0.0,   0.0,  -1.0,   1.0],
    [1.0,   1.0,   2.0,   2.0,   2.0],
    [3.0,   0.0,   0.0,   0.0,  -1.0],
    [2.0,   0.0,   0.0,  -4.0,  -1.0],
    [3.0,   0.0,   2.0,   2.0,   2.0],
    [0.0,   0.0,   2.0,   4.0,   1.0],
    [0.0,   2.0,  -2.0,  -2.0,  -2.0],
    [1.0,  -1.0,   0.0,  -2.0,  -1.0],
    [0.0,   0.0,   2.0,  -1.0,   1.0],
    [2.0,   0.0,   0.0,   2.0,   1.0],
    [1.0,  -1.0,  -2.0,   2.0,  -1.0],
    [0.0,   0.0,   0.0,   2.0,  -2.0],
    [2.0,   0.0,   0.0,  -4.0,   1.0],
    [1.0,   0.0,   0.0,  -4.0,   1.0],
    [2.0,   0.0,   2.0,  -4.0,   1.0],
    [4.0,   0.0,   2.0,  -2.0,   2.0],
    [2.0,   1.0,  -2.0,   0.0,  -1.0],
    [2.0,   1.0,  -2.0,  -4.0,  -2.0],
    [3.0,   0.0,   0.0,  -4.0,   0.0],
    [1.0,  -1.0,   2.0,   2.0,   1.0],
    [1.0,  -1.0,  -2.0,   0.0,  -1.0],
    [0.0,   2.0,   0.0,   0.0,   1.0],
    [1.0,   2.0,  -2.0,  -2.0,  -2.0],
    [1.0,   1.0,   0.0,  -4.0,   0.0],
    [2.0,   0.0,   0.0,  -2.0,   2.0],
    [0.0,   2.0,   2.0,  -2.0,   1.0],
    [1.0,   0.0,   2.0,   0.0,  -1.0],
    [2.0,   1.0,   0.0,  -2.0,   1.0],
    [2.0,  -1.0,  -2.0,   0.0,  -1.0],
    [1.0,  -1.0,  -2.0,  -2.0,  -1.0],
    [0.0,   1.0,  -2.0,   1.0,  -2.0],
    [1.0,   0.0,  -4.0,   2.0,  -2.0],
    [0.0,   1.0,   2.0,   2.0,   1.0],
    [3.0,   0.0,   0.0,   0.0,   1.0],
    [2.0,  -1.0,   2.0,   2.0,   2.0],
    [0.0,   1.0,  -2.0,  -4.0,  -2.0],
    [1.0,   0.0,  -2.0,  -3.0,  -2.0],
    [2.0,   0.0,   0.0,   0.0,   2.0],
    [1.0,  -1.0,   0.0,  -2.0,  -2.0],
    [2.0,   0.0,  -2.0,   2.0,  -1.0],
    [0.0,   2.0,  -2.0,   0.0,  -2.0],
    [3.0,   0.0,  -2.0,   0.0,  -1.0],
    [2.0,  -1.0,   2.0,   0.0,   1.0],
    [1.0,   0.0,  -2.0,  -1.0,  -2.0],
    [0.0,   0.0,   2.0,   0.0,   3.0],
    [2.0,   0.0,  -4.0,   0.0,  -2.0],
    [2.0,   1.0,   0.0,  -4.0,   0.0],
    [1.0,   1.0,  -2.0,   1.0,  -1.0],
    [0.0,   2.0,   2.0,   0.0,   2.0],
    [1.0,  -1.0,   2.0,  -2.0,   2.0],
    [1.0,  -1.0,   0.0,  -2.0,   1.0],
    [2.0,   1.0,   2.0,   0.0,   1.0],
    [1.0,   0.0,   2.0,  -4.0,   2.0],
    [1.0,   1.0,  -2.0,   0.0,  -1.0],
    [1.0,   1.0,   0.0,   2.0,   0.0],
    [1.0,   0.0,   0.0,  -3.0,   0.0],
    [2.0,   0.0,   2.0,  -1.0,   2.0],
    [0.0,   2.0,   0.0,   0.0,  -1.0],
    [2.0,  -1.0,   0.0,  -2.0,   0.0],
    [4.0,   0.0,   0.0,   0.0,   0.0],
    [2.0,   1.0,  -2.0,  -2.0,  -2.0],
    [0.0,   2.0,  -2.0,   2.0,   0.0],
    [1.0,   0.0,   2.0,   1.0,   1.0],
    [1.0,   0.0,  -1.0,   0.0,  -3.0],
    [3.0,  -1.0,   2.0,   0.0,   2.0],
    [2.0,   0.0,   2.0,  -2.0,   0.0],
    [1.0,  -2.0,   0.0,   0.0,   0.0],
    [2.0,   0.0,   0.0,   0.0,  -2.0],
    [1.0,   0.0,   0.0,   4.0,   0.0],
    [0.0,   1.0,   0.0,   1.0,   1.0],
    [1.0,   0.0,   2.0,   2.0,   0.0],
    [0.0,   1.0,   0.0,   2.0,  -1.0],
    [0.0,   1.0,   0.0,   1.0,  -1.0],
    [0.0,   0.0,   2.0,  -2.0,   3.0],
    [3.0,   1.0,   2.0,   0.0,   2.0],
    [1.0,   1.0,   2.0,   1.0,   2.0],
    [1.0,   1.0,  -2.0,   2.0,  -1.0],
    [2.0,  -1.0,   2.0,  -2.0,   2.0],
    [1.0,  -2.0,   2.0,   0.0,   2.0],
    [1.0,   0.0,   2.0,  -4.0,   0.0],
    [0.0,   0.0,   1.0,   0.0,   0.0],
    [1.0,   0.0,   2.0,  -3.0,   1.0],
    [1.0,  -2.0,   0.0,  -2.0,   0.0],
    [2.0,   0.0,   0.0,   2.0,  -1.0],
    [1.0,   1.0,   2.0,  -4.0,   1.0],
    [4.0,   0.0,   2.0,   0.0,   1.0],
    [0.0,   1.0,   2.0,   1.0,   1.0],
    [1.0,   2.0,   2.0,  -2.0,   2.0],
    [2.0,   0.0,   2.0,   1.0,   2.0],
    [2.0,   1.0,   2.0,  -2.0,   1.0],
    [1.0,   0.0,   2.0,  -1.0,   1.0],
    [1.0,   0.0,   4.0,  -2.0,   1.0],
    [1.0,  -1.0,   2.0,  -2.0,   1.0],
    [0.0,   1.0,   0.0,  -4.0,   0.0],
    [3.0,   0.0,  -2.0,  -2.0,  -2.0],
    [0.0,   0.0,   4.0,  -4.0,   2.0],
    [2.0,   0.0,  -4.0,  -2.0,  -2.0],
    [2.0,  -2.0,   0.0,  -2.0,  -1.0],
    [1.0,   0.0,   2.0,  -2.0,  -1.0],
    [2.0,   0.0,  -2.0,  -6.0,  -2.0],
    [1.0,   0.0,  -2.0,   1.0,  -2.0],
    [1.0,   0.0,  -2.0,   2.0,   1.0],
    [1.0,  -1.0,   0.0,   2.0,  -1.0],
    [1.0,   0.0,  -2.0,   1.0,   0.0],
    [2.0,  -1.0,   0.0,  -2.0,   1.0],
    [1.0,  -1.0,   0.0,   2.0,   1.0],
    [2.0,   0.0,  -2.0,  -2.0,   0.0],
    [1.0,   0.0,   2.0,  -3.0,   2.0],
    [0.0,   0.0,   0.0,   4.0,  -1.0],
    [2.0,  -1.0,   0.0,   0.0,   1.0],
    [2.0,   0.0,   4.0,  -2.0,   2.0],
    [0.0,   0.0,   2.0,   3.0,   2.0],
    [0.0,   1.0,   4.0,  -2.0,   2.0],
    [0.0,   1.0,  -2.0,   2.0,   1.0],
    [1.0,   1.0,   0.0,   2.0,   1.0],
    [1.0,   0.0,   0.0,   4.0,   1.0],
    [0.0,   0.0,   4.0,   0.0,   1.0],
    [2.0,   0.0,   0.0,  -3.0,   0.0],
    [1.0,   0.0,   0.0,  -1.0,  -2.0],
    [1.0,  -2.0,  -2.0,  -2.0,  -2.0],
    [3.0,   0.0,   0.0,   2.0,   0.0],
    [2.0,   0.0,   2.0,  -4.0,   2.0],
    [1.0,   1.0,  -2.0,  -4.0,  -1.0],
    [1.0,   0.0,  -2.0,  -6.0,  -2.0],
    [2.0,  -1.0,   0.0,   0.0,  -1.0],
    [2.0,  -1.0,   0.0,   2.0,   0.0],
    [0.0,   1.0,   2.0,  -2.0,  -1.0],
    [1.0,   1.0,   0.0,   1.0,   0.0],
    [1.0,   2.0,   0.0,  -2.0,  -1.0],
    [1.0,   0.0,   0.0,   1.0,  -1.0],
    [0.0,   0.0,   1.0,   0.0,   2.0],
    [3.0,   1.0,   2.0,  -2.0,   2.0],
    [1.0,   0.0,  -4.0,  -2.0,  -2.0],
    [1.0,   0.0,   2.0,   4.0,   1.0],
    [1.0,  -2.0,   2.0,   2.0,   2.0],
    [1.0,  -1.0,  -2.0,  -4.0,  -2.0],
    [0.0,   0.0,   2.0,  -4.0,   2.0],
    [0.0,   0.0,   2.0,  -3.0,   1.0],
    [2.0,   1.0,  -2.0,   0.0,   0.0],
    [3.0,   0.0,  -2.0,  -2.0,  -1.0],
    [2.0,   0.0,   2.0,   4.0,   2.0],
    [0.0,   0.0,   0.0,   0.0,   3.0],
    [2.0,  -1.0,  -2.0,  -2.0,  -2.0],
    [2.0,   0.0,   0.0,  -1.0,   0.0],
    [3.0,   0.0,   2.0,  -4.0,   2.0],
    [2.0,   1.0,   2.0,   2.0,   2.0],
    [0.0,   0.0,   3.0,   0.0,   3.0],
    [1.0,   1.0,   2.0,   2.0,   1.0],
    [2.0,   1.0,   0.0,   0.0,  -1.0],
    [1.0,   2.0,   0.0,  -2.0,   1.0],
    [3.0,   0.0,   2.0,   2.0,   1.0],
    [1.0,  -1.0,  -2.0,   2.0,  -2.0],
    [1.0,   1.0,   0.0,  -1.0,   0.0],
    [1.0,   2.0,   0.0,   0.0,   0.0],
    [1.0,   0.0,   4.0,   0.0,   2.0],
    [1.0,  -1.0,   2.0,   4.0,   2.0],
    [2.0,   1.0,   0.0,   0.0,   1.0],
    [1.0,   0.0,   0.0,   2.0,   2.0],
    [1.0,  -1.0,  -2.0,   2.0,   0.0],
    [0.0,   2.0,  -2.0,  -2.0,  -1.0],
    [2.0,   0.0,  -2.0,   0.0,   2.0],
    [5.0,   0.0,   2.0,   0.0,   2.0],
    [3.0,   0.0,  -2.0,  -6.0,  -2.0],
    [1.0,  -1.0,   2.0,  -1.0,   2.0],
    [3.0,   0.0,   0.0,  -4.0,  -1.0],
    [1.0,   0.0,   0.0,   1.0,   1.0],
    [1.0,   0.0,  -4.0,   2.0,  -1.0],
    [0.0,   1.0,   2.0,  -4.0,   1.0],
    [1.0,   2.0,   2.0,   0.0,   2.0],
    [0.0,   1.0,   0.0,  -2.0,  -2.0],
    [0.0,   0.0,   2.0,  -1.0,   0.0],
    [1.0,   0.0,   1.0,   0.0,   1.0],
    [0.0,   2.0,   0.0,  -2.0,   1.0],
    [3.0,   0.0,   2.0,   0.0,   0.0],
    [1.0,   1.0,  -2.0,   1.0,   0.0],
    [2.0,   1.0,  -2.0,  -4.0,  -1.0],
    [3.0,  -1.0,   0.0,   0.0,   0.0],
    [2.0,  -1.0,  -2.0,   0.0,   0.0],
    [4.0,   0.0,   2.0,  -2.0,   1.0],
    [2.0,   0.0,  -2.0,   2.0,   0.0],
    [1.0,   1.0,   2.0,  -2.0,   0.0],
    [1.0,   0.0,  -2.0,   4.0,  -1.0],
    [1.0,   0.0,  -2.0,  -2.0,   1.0],
    [2.0,   0.0,   2.0,  -4.0,   0.0],
    [1.0,   1.0,   0.0,  -2.0,  -2.0],
    [1.0,   1.0,  -2.0,  -2.0,   0.0],
    [1.0,   0.0,   1.0,  -2.0,   1.0],
    [2.0,  -1.0,  -2.0,  -4.0,  -2.0],
    [3.0,   0.0,  -2.0,   0.0,  -2.0],
    [0.0,   1.0,  -2.0,  -2.0,   0.0],
    [3.0,   0.0,   0.0,  -2.0,  -1.0],
    [1.0,   0.0,  -2.0,  -3.0,  -1.0],
    [0.0,   1.0,   0.0,  -4.0,  -1.0],
    [1.0,  -2.0,   2.0,  -2.0,   1.0],
    [0.0,   1.0,  -2.0,   1.0,  -1.0],
    [1.0,  -1.0,   0.0,   0.0,   2.0],
    [2.0,   0.0,   0.0,   1.0,   0.0],
    [1.0,  -2.0,   0.0,   2.0,   0.0],
    [1.0,   2.0,  -2.0,  -2.0,  -1.0],
    [0.0,   0.0,   4.0,  -4.0,   1.0],
    [0.0,   1.0,   2.0,   4.0,   2.0],
    [0.0,   1.0,  -4.0,   2.0,  -2.0],
    [3.0,   0.0,  -2.0,   0.0,   0.0],
    [2.0,  -1.0,   2.0,   2.0,   1.0],
    [0.0,   1.0,  -2.0,  -4.0,  -1.0],
    [4.0,   0.0,   2.0,   2.0,   2.0],
    [2.0,   0.0,  -2.0,  -3.0,  -2.0],
    [2.0,   0.0,   0.0,  -6.0,   0.0],
    [1.0,   0.0,   2.0,   0.0,   3.0],
    [3.0,   1.0,   0.0,   0.0,   0.0],
    [3.0,   0.0,   0.0,  -4.0,   1.0],
    [1.0,  -1.0,   2.0,   0.0,   0.0],
    [1.0,  -1.0,   0.0,  -4.0,   0.0],
    [2.0,   0.0,  -2.0,   2.0,  -2.0],
    [1.0,   1.0,   0.0,  -2.0,   2.0],
    [4.0,   0.0,   0.0,  -2.0,   0.0],
    [2.0,   2.0,   0.0,  -2.0,   0.0],
    [0.0,   1.0,   2.0,   0.0,   0.0],
    [1.0,   1.0,   0.0,  -4.0,   1.0],
    [1.0,   0.0,   0.0,  -4.0,  -2.0],
    [0.0,   0.0,   0.0,   1.0,   2.0],
    [3.0,   0.0,   0.0,   2.0,   1.0],
    [1.0,   1.0,   0.0,  -4.0,  -1.0],
    [0.0,   0.0,   2.0,   2.0,  -1.0],
    [1.0,   1.0,   2.0,   0.0,   0.0],
    [1.0,  -1.0,   2.0,  -4.0,   1.0],
    [1.0,   1.0,   0.0,   0.0,   2.0],
    [0.0,   0.0,   2.0,   6.0,   2.0],
    [4.0,   0.0,  -2.0,  -2.0,  -1.0],
    [2.0,   1.0,   0.0,  -4.0,  -1.0],
    [0.0,   0.0,   0.0,   3.0,   1.0],
    [1.0,  -1.0,  -2.0,   0.0,   0.0],
    [0.0,   0.0,   2.0,   1.0,   0.0],
    [1.0,   0.0,   0.0,   2.0,  -2.0],
    [3.0,  -1.0,   2.0,   2.0,   2.0],
    [3.0,  -1.0,   2.0,  -2.0,   2.0],
    [1.0,   0.0,   0.0,  -1.0,   2.0],
    [1.0,  -2.0,   2.0,  -2.0,   2.0],
    [0.0,   1.0,   0.0,   2.0,   2.0],
    [0.0,   1.0,  -2.0,  -1.0,  -2.0],
    [1.0,   1.0,  -2.0,   0.0,   0.0],
    [0.0,   2.0,   2.0,  -2.0,   0.0],
    [3.0,  -1.0,  -2.0,  -1.0,  -2.0],
    [1.0,   0.0,   0.0,  -6.0,   0.0],
    [1.0,   0.0,  -2.0,  -4.0,   0.0],
    [2.0,   1.0,   0.0,  -4.0,   1.0],
    [2.0,   0.0,   2.0,   0.0,  -1.0],
    [2.0,   0.0,  -4.0,   0.0,  -1.0],
    [0.0,   0.0,   3.0,   0.0,   2.0],
    [2.0,   1.0,  -2.0,  -2.0,  -1.0],
    [1.0,  -2.0,   0.0,   0.0,   1.0],
    [2.0,  -1.0,   0.0,  -4.0,   0.0],
    [0.0,   0.0,   0.0,   3.0,   0.0],
    [5.0,   0.0,   2.0,  -2.0,   2.0],
    [1.0,   2.0,  -2.0,  -4.0,  -2.0],
    [1.0,   0.0,   4.0,  -4.0,   2.0],
    [0.0,   0.0,   4.0,  -1.0,   2.0],
    [3.0,   1.0,   0.0,  -4.0,   0.0],
    [3.0,   0.0,   0.0,  -6.0,   0.0],
    [2.0,   0.0,   0.0,   2.0,   2.0],
    [2.0,  -2.0,   2.0,   0.0,   2.0],
    [1.0,   0.0,   0.0,  -3.0,   1.0],
    [1.0,  -2.0,  -2.0,   0.0,  -2.0],
    [1.0,  -1.0,  -2.0,  -3.0,  -2.0],
    [0.0,   0.0,   2.0,  -2.0,  -2.0],
    [2.0,   0.0,  -2.0,  -4.0,   0.0],
    [1.0,   0.0,  -4.0,   0.0,   0.0],
    [0.0,   1.0,   0.0,  -1.0,   0.0],
    [4.0,   0.0,   0.0,   0.0,  -1.0],
    [3.0,   0.0,   2.0,  -1.0,   2.0],
    [3.0,  -1.0,   2.0,   0.0,   1.0],
    [2.0,   0.0,   2.0,  -1.0,   1.0],
    [1.0,   2.0,   2.0,  -2.0,   1.0],
    [1.0,   1.0,   0.0,   2.0,  -1.0],
    [0.0,   2.0,   2.0,   0.0,   1.0],
    [3.0,   1.0,   2.0,   0.0,   1.0],
    [1.0,   1.0,   2.0,   1.0,   1.0],
    [1.0,   1.0,   0.0,  -1.0,   1.0],
    [1.0,  -2.0,   0.0,  -2.0,  -1.0],
    [4.0,   0.0,   0.0,  -4.0,   0.0],
    [2.0,   1.0,   0.0,   2.0,   0.0],
    [1.0,  -1.0,   0.0,   4.0,   0.0],
    [0.0,   1.0,   0.0,  -2.0,   2.0],
    [0.0,   0.0,   2.0,   0.0,  -2.0],
    [1.0,   0.0,  -1.0,   0.0,   1.0],
    [3.0,   0.0,   2.0,  -2.0,   0.0],
    [2.0,   0.0,   2.0,   2.0,   0.0],
    [1.0,   2.0,   0.0,  -4.0,   0.0],
    [1.0,  -1.0,   0.0,  -3.0,   0.0],
    [0.0,   1.0,   0.0,   4.0,   0.0],
    [0.0,   1.0,  -2.0,   0.0,   0.0],
    [2.0,   2.0,   2.0,  -2.0,   2.0],
    [0.0,   0.0,   0.0,   1.0,  -2.0],
    [0.0,   2.0,  -2.0,   0.0,  -1.0],
    [4.0,   0.0,   2.0,  -4.0,   2.0],
    [2.0,   0.0,  -4.0,   2.0,  -2.0],
    [2.0,  -1.0,  -2.0,   0.0,  -2.0],
    [1.0,   1.0,   4.0,  -2.0,   2.0],
    [1.0,   1.0,   2.0,  -4.0,   2.0],
    [1.0,   0.0,   2.0,   3.0,   2.0],
    [1.0,   0.0,   0.0,   4.0,  -1.0],
    [0.0,   0.0,   0.0,   4.0,   2.0],
    [2.0,   0.0,   0.0,   4.0,   0.0],
    [1.0,   1.0,  -2.0,   2.0,   0.0],
    [2.0,   1.0,   2.0,   1.0,   2.0],
    [2.0,   1.0,   2.0,  -4.0,   1.0],
    [2.0,   0.0,   2.0,   1.0,   1.0],
    [2.0,   0.0,  -4.0,  -2.0,  -1.0],
    [2.0,   0.0,  -2.0,  -6.0,  -1.0],
    [2.0,  -1.0,   2.0,  -1.0,   2.0],
    [1.0,  -2.0,   2.0,   0.0,   1.0],
    [1.0,  -2.0,   0.0,  -2.0,   1.0],
    [1.0,  -1.0,   0.0,  -4.0,  -1.0],
    [0.0,   2.0,   2.0,   2.0,   2.0],
    [0.0,   2.0,  -2.0,  -4.0,  -2.0],
    [0.0,   1.0,   2.0,   3.0,   2.0],
    [0.0,   1.0,   0.0,  -4.0,   1.0],
    [3.0,   0.0,   0.0,  -2.0,   1.0],
    [2.0,   1.0,  -2.0,   0.0,   1.0],
    [2.0,   0.0,   4.0,  -2.0,   1.0],
    [2.0,   0.0,   0.0,  -3.0,  -1.0],
    [2.0,  -2.0,   0.0,  -2.0,   1.0],
    [2.0,  -1.0,   2.0,  -2.0,   1.0],
    [1.0,   0.0,   0.0,  -6.0,  -1.0],
    [1.0,  -2.0,   0.0,   0.0,  -1.0],
    [1.0,  -2.0,  -2.0,  -2.0,  -1.0],
    [0.0,   1.0,   4.0,  -2.0,   1.0],
    [0.0,   0.0,   2.0,   3.0,   1.0],
    [2.0,  -1.0,   0.0,  -1.0,   0.0],
    [1.0,   3.0,   0.0,  -2.0,   0.0],
    [0.0,   3.0,   0.0,  -2.0,   0.0],
    [2.0,  -2.0,   2.0,  -2.0,   2.0],
    [0.0,   0.0,   4.0,  -2.0,   0.0],
    [4.0,  -1.0,   2.0,   0.0,   2.0],
    [2.0,   2.0,  -2.0,  -4.0,  -2.0],
    [4.0,   1.0,   2.0,   0.0,   2.0],
    [4.0,  -1.0,  -2.0,  -2.0,  -2.0],
    [2.0,   1.0,   0.0,  -2.0,  -2.0],
    [2.0,   1.0,  -2.0,  -6.0,  -2.0],
    [2.0,   0.0,   0.0,  -1.0,   1.0],
    [2.0,  -1.0,  -2.0,   2.0,  -1.0],
    [1.0,   1.0,  -2.0,   2.0,  -2.0],
    [1.0,   1.0,  -2.0,  -3.0,  -2.0],
    [1.0,   0.0,   3.0,   0.0,   3.0],
    [1.0,   0.0,  -2.0,   1.0,   1.0],
    [1.0,   0.0,  -2.0,   0.0,   2.0],
    [1.0,  -1.0,   2.0,   1.0,   2.0],
    [1.0,  -1.0,   0.0,   0.0,  -2.0],
    [1.0,  -1.0,  -4.0,   2.0,  -2.0],
    [0.0,   3.0,  -2.0,  -2.0,  -2.0],
    [0.0,   1.0,   0.0,   4.0,   1.0],
    [0.0,   0.0,   4.0,   2.0,   2.0],
    [3.0,   0.0,  -2.0,  -2.0,   0.0],
    [2.0,  -2.0,   0.0,   0.0,   0.0],
    [1.0,   1.0,   2.0,  -4.0,   0.0],
    [1.0,   1.0,   0.0,  -3.0,   0.0],
    [1.0,   0.0,   2.0,  -3.0,   0.0],
    [1.0,  -1.0,   2.0,  -2.0,   0.0],
    [0.0,   2.0,   0.0,   2.0,   0.0],
    [0.0,   0.0,   2.0,   4.0,   0.0],
    [1.0,   0.0,   1.0,   0.0,   0.0],
    [3.0,   1.0,   2.0,  -2.0,   1.0],
    [3.0,   0.0,   4.0,  -2.0,   2.0],
    [3.0,   0.0,   2.0,   1.0,   2.0],
    [3.0,   0.0,   0.0,   2.0,  -1.0],
    [3.0,   0.0,   0.0,   0.0,   2.0],
    [3.0,   0.0,  -2.0,   2.0,  -1.0],
    [2.0,   0.0,   4.0,  -4.0,   2.0],
    [2.0,   0.0,   2.0,  -3.0,   2.0],
    [2.0,   0.0,   0.0,   4.0,   1.0],
    [2.0,   0.0,   0.0,  -3.0,   1.0],
    [2.0,   0.0,  -4.0,   2.0,  -1.0],
    [2.0,   0.0,  -2.0,  -2.0,   1.0],
    [2.0,  -2.0,   2.0,   2.0,   2.0],
    [2.0,  -2.0,   0.0,  -2.0,  -2.0],
    [2.0,  -1.0,   0.0,   2.0,   1.0],
    [2.0,  -1.0,   0.0,   2.0,  -1.0],
    [1.0,   1.0,   2.0,   4.0,   2.0],
    [1.0,   1.0,   0.0,   1.0,   1.0],
    [1.0,   1.0,   0.0,   1.0,  -1.0],
    [1.0,   1.0,  -2.0,  -6.0,  -2.0],
    [1.0,   0.0,   0.0,  -3.0,  -1.0],
    [1.0,   0.0,  -4.0,  -2.0,  -1.0],
    [1.0,   0.0,  -2.0,  -6.0,  -1.0],
    [1.0,  -2.0,   2.0,   2.0,   1.0],
    [1.0,  -2.0,  -2.0,   2.0,  -1.0],
    [1.0,  -1.0,  -2.0,  -4.0,  -1.0],
    [0.0,   2.0,   0.0,   0.0,   2.0],
    [0.0,   1.0,   2.0,  -4.0,   2.0],
    [0.0,   1.0,  -2.0,   4.0,  -1.0],
    [5.0,   0.0,   0.0,   0.0,   0.0],
    [3.0,   0.0,   0.0,  -3.0,   0.0],
    [2.0,   2.0,   0.0,  -4.0,   0.0],
    [1.0,  -1.0,   2.0,   2.0,   0.0],
    [0.0,   1.0,   0.0,   3.0,   0.0],
    [4.0,   0.0,  -2.0,   0.0,  -1.0],
    [3.0,   0.0,  -2.0,  -6.0,  -1.0],
    [3.0,   0.0,  -2.0,  -1.0,  -1.0],
    [2.0,   1.0,   2.0,   2.0,   1.0],
    [2.0,   1.0,   0.0,   2.0,   1.0],
    [2.0,   0.0,   2.0,   4.0,   1.0],
    [2.0,   0.0,   2.0,  -6.0,   1.0],
    [2.0,   0.0,   2.0,  -2.0,  -1.0],
    [2.0,   0.0,   0.0,  -6.0,  -1.0],
    [2.0,  -1.0,  -2.0,  -2.0,  -1.0],
    [1.0,   2.0,   2.0,   0.0,   1.0],
    [1.0,   2.0,   0.0,   0.0,   1.0],
    [1.0,   0.0,   4.0,   0.0,   1.0],
    [1.0,   0.0,   2.0,  -6.0,   1.0],
    [1.0,   0.0,   2.0,  -4.0,  -1.0],
    [1.0,   0.0,  -1.0,  -2.0,  -1.0],
    [1.0,  -1.0,   2.0,   4.0,   1.0],
    [1.0,  -1.0,   2.0,  -3.0,   1.0],
    [1.0,  -1.0,   0.0,   4.0,   1.0],
    [1.0,  -1.0,  -2.0,   1.0,  -1.0],
    [0.0,   1.0,   2.0,  -2.0,   3.0],
    [3.0,   0.0,   0.0,  -2.0,   0.0],
    [1.0,   0.0,   1.0,  -2.0,   0.0],
    [0.0,   2.0,   0.0,  -4.0,   0.0],
    [0.0,   0.0,   2.0,  -4.0,   0.0],
    [0.0,   0.0,   1.0,  -1.0,   0.0],
    [0.0,   0.0,   0.0,   6.0,   0.0],
    [0.0,   2.0,   0.0,   0.0,  -2.0],
    [0.0,   1.0,  -2.0,   2.0,  -3.0],
    [4.0,   0.0,   0.0,   2.0,   0.0],
    [3.0,   0.0,   0.0,  -1.0,   0.0],
    [3.0,  -1.0,   0.0,   2.0,   0.0],
    [2.0,   1.0,   0.0,   1.0,   0.0],
    [2.0,   1.0,   0.0,  -6.0,   0.0],
    [2.0,  -1.0,   2.0,   0.0,   0.0],
    [1.0,   0.0,   2.0,  -1.0,   0.0],
    [1.0,  -1.0,   0.0,   1.0,   0.0],
    [1.0,  -1.0,  -2.0,  -2.0,   0.0],
    [0.0,   1.0,   2.0,   2.0,   0.0],
    [0.0,   0.0,   2.0,  -3.0,   0.0],
    [2.0,   2.0,   0.0,  -2.0,  -1.0],
    [2.0,  -1.0,  -2.0,   0.0,   1.0],
    [1.0,   2.0,   2.0,  -4.0,   1.0],
    [0.0,   1.0,   4.0,  -4.0,   2.0],
    [0.0,   0.0,   0.0,   3.0,   2.0],
    [5.0,   0.0,   2.0,   0.0,   1.0],
    [4.0,   1.0,   2.0,  -2.0,   2.0],
    [4.0,   0.0,  -2.0,  -2.0,   0.0],
    [3.0,   1.0,   2.0,   2.0,   2.0],
    [3.0,   1.0,   0.0,  -2.0,   0.0],
    [3.0,   1.0,  -2.0,  -6.0,  -2.0],
    [3.0,   0.0,   0.0,   0.0,  -2.0],
    [3.0,   0.0,  -2.0,  -4.0,  -2.0],
    [3.0,  -1.0,   0.0,  -3.0,   0.0],
    [3.0,  -1.0,   0.0,  -2.0,   0.0],
    [2.0,   1.0,   2.0,   0.0,   0.0],
    [2.0,   1.0,   2.0,  -4.0,   2.0],
    [2.0,   1.0,   2.0,  -2.0,   0.0],
    [2.0,   1.0,   0.0,  -3.0,   0.0],
    [2.0,   1.0,  -2.0,   0.0,  -2.0],
    [2.0,   0.0,   0.0,  -4.0,   2.0],
    [2.0,   0.0,   0.0,  -4.0,  -2.0],
    [2.0,   0.0,  -2.0,  -5.0,  -2.0],
    [2.0,  -1.0,   2.0,   4.0,   2.0],
    [2.0,  -1.0,   0.0,  -2.0,   2.0],
    [1.0,   3.0,  -2.0,  -2.0,  -2.0],
    [1.0,   1.0,   0.0,   0.0,  -2.0],
    [1.0,   1.0,   0.0,  -6.0,   0.0],
    [1.0,   1.0,  -2.0,   1.0,  -2.0],
    [1.0,   1.0,  -2.0,  -1.0,  -2.0],
    [1.0,   0.0,   2.0,   1.0,   0.0],
    [1.0,   0.0,   0.0,   3.0,   0.0],
    [1.0,   0.0,   0.0,  -4.0,   2.0],
    [1.0,   0.0,  -2.0,   4.0,  -2.0],
    [1.0,  -2.0,   0.0,  -1.0,   0.0],
    [0.0,   1.0,  -4.0,   2.0,  -1.0],
    [1.0,   0.0,  -2.0,   0.0,  -3.0],
    [0.0,   0.0,   4.0,  -4.0,   4.0],
];
