/*
 * Copyright (c) 2023. Helge Eichhorn and the LOX contributors
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, you can obtain one at https://mozilla.org/MPL/2.0/.
 */

pub(crate) type PlanetaryFrequencyList = [f64; 14];

#[rustfmt::skip]
// @formatter:off (sometimes RustRover ignores the rustfmt skip)
pub(crate) static FREQUENCY_LISTS: [PlanetaryFrequencyList; 656] = [
    [0.0,  0.0,  1.0, -1.0,  1.0,  0.0,  0.0, -1.0,  0.0, -2.0,  5.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0, -5.0,  0.0,  0.0, -1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0, -5.0,  0.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  1.0, -1.0,  1.0,  0.0, -8.0, 12.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  4.0, -8.0,  3.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0, -1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  8.0,-16.0,  4.0,  5.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0,  0.0, -1.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0, -1.0,  2.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  8.0,-13.0,  0.0,  0.0,  0.0,  0.0,  0.0, -1.0],
    [0.0,  0.0,  1.0, -1.0,  1.0,  0.0,  0.0, -1.0,  0.0,  2.0, -5.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  2.0, -2.0,  1.0,  0.0, -5.0,  6.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  4.0, -6.0,  0.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0,  0.0, -1.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0, -8.0,  3.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0, -4.0,  0.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  6.0, -8.0,  3.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0, -2.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0, -3.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0, -2.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0, -4.0,  8.0, -3.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  4.0, -8.0,  3.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0, -5.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0,  1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  1.0, -1.0,  1.0,  0.0,  0.0,  0.0, -2.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [2.0,  0.0,  0.0, -2.0, -1.0,  0.0,  0.0, -2.0,  0.0,  2.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0,  0.0,  0.0,  0.0,  1.0],
    [2.0,  0.0,  0.0, -2.0,  0.0,  0.0,  0.0, -2.0,  0.0,  2.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0,  0.0, -2.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  8.0,-13.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  1.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  5.0, -8.0,  0.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0, -2.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0, -5.0,  0.0,  0.0,  1.0],
    [2.0,  0.0,  0.0, -2.0,  0.0,  0.0,  0.0, -2.0,  0.0,  3.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0,  1.0,  0.0,  0.0, -1.0,  0.0, -1.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0, -4.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0,  1.0,  0.0,  0.0, -1.0,  0.0,  0.0, -1.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0,  0.0, -2.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  5.0, -7.0,  0.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  1.0, -1.0,  0.0,  0.0,  0.0,  0.0, -2.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  4.0,  0.0, -2.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  8.0,-13.0,  0.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0, -1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0],
    [1.0,  0.0,  0.0,  0.0,  0.0,  0.0,-18.0, 16.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0,  1.0,  0.0,  0.0, -1.0,  0.0,  2.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0,  0.0,  1.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  1.0, -1.0,  1.0,  0.0, -5.0,  7.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [1.0,  0.0,  0.0,  0.0,  0.0,  0.0,-10.0,  3.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  2.0, -2.0,  0.0,  0.0, -5.0,  6.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0,  0.0, -1.0,  0.0,  0.0,  0.0,  2.0],
    [1.0,  0.0,  2.0,  0.0,  2.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  4.0, -2.0,  0.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0,  0.0,  0.0,  1.0],
    [1.0,  0.0, -2.0,  0.0, -2.0,  0.0,  0.0,  4.0, -8.0,  3.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0,  1.0,  0.0,  0.0, -1.0,  0.0,  0.0,  2.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  2.0, -2.0,  1.0,  0.0, -3.0,  3.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  8.0,-16.0,  4.0,  5.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  1.0, -1.0,  1.0,  0.0,  0.0,  3.0, -8.0,  3.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  8.0,-11.0,  0.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  8.0,-16.0,  4.0,  5.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0, -1.0,  0.0,  0.0,  0.0,  0.0,  0.0, -1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  4.0, -6.0,  0.0,  0.0,  0.0,  0.0,  0.0, -1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0,  0.0, -3.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0, -4.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  6.0, -8.0,  0.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0, -2.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  8.0,-15.0,  0.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0, -5.0,  0.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0, -3.0,  0.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0,  0.0, -2.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  1.0, -1.0,  1.0,  0.0,  0.0, -5.0,  8.0, -3.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0,  2.0,  0.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0, -2.0,  0.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0, -5.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [2.0,  0.0,  0.0, -2.0,  1.0,  0.0,  0.0, -2.0,  0.0,  3.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  5.0, -8.0,  0.0,  0.0,  0.0,  0.0,  0.0, -1.0],
    [2.0,  0.0,  0.0, -2.0,  0.0,  0.0, -3.0,  3.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  8.0,-13.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0,  0.0, -2.0,  5.0,  0.0,  0.0,  0.0],
    [1.0,  0.0,  0.0, -1.0,  0.0,  0.0, -3.0,  4.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0],
    [1.0,  0.0,  0.0,  0.0, -1.0,  0.0,-18.0, 16.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0,  0.0,  2.0, -5.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0,  0.0],
    [1.0,  0.0,  0.0, -2.0,  0.0,  0.0, 19.0,-21.0,  3.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  1.0,  0.0, -8.0, 13.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0,  1.0,  0.0,  0.0, -1.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  7.0, -9.0,  0.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0,  0.0,  0.0,  0.0,  0.0,  2.0],
    [1.0,  0.0,  0.0,  0.0,  1.0,  0.0,-18.0, 16.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0, -4.0,  0.0,  0.0,  0.0,  0.0,  0.0, -1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  6.0,-16.0,  4.0,  5.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  4.0, -7.0,  0.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0, -7.0,  0.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0, -2.0,  0.0,  0.0,  0.0,  0.0,  0.0, -1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0,  1.0],
    [2.0,  0.0,  0.0, -2.0,  1.0,  0.0,  0.0, -2.0,  0.0,  2.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0, -1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0, -4.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0, -2.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [2.0,  0.0,  0.0, -2.0, -1.0,  0.0,  0.0, -2.0,  0.0,  3.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0, -3.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  2.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  1.0, -2.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  2.0, -2.0,  1.0,  0.0,  0.0, -2.0,  0.0,  2.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0,  0.0, -3.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0, -5.0,  0.0,  0.0,  0.0,  0.0,  0.0, -1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0, -3.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  4.0, -4.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0,  0.0,  0.0,  0.0, -1.0,  0.0, -1.0,  0.0,  0.0,  0.0,  0.0],
    [2.0,  0.0,  0.0, -2.0,  0.0,  0.0, -6.0,  8.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0,  1.0,  0.0,  0.0, -2.0,  2.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  1.0],
    [0.0,  0.0,  1.0, -1.0,  1.0,  0.0,  0.0, -1.0,  0.0,  1.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0, -2.0,  0.0,  0.0,  0.0,  0.0, -1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0, -3.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0, -4.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0, -1.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  8.0,-10.0,  0.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  1.0, -1.0,  1.0,  0.0, -3.0,  4.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  6.0, -9.0,  0.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [1.0,  0.0,  0.0, -1.0,  1.0,  0.0,  0.0, -1.0,  0.0,  2.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  5.0, -7.0,  0.0,  0.0,  0.0,  0.0,  0.0, -1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  5.0, -5.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0, -1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0, -3.0,  0.0,  0.0,  0.0,  0.0,  0.0, -1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  4.0,  0.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  4.0,  0.0, -3.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0, -1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0],
    [0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  2.0, -3.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [1.0,  0.0,  0.0, -1.0,  0.0,  0.0,  0.0, -1.0,  0.0,  1.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0, -3.0,  0.0,  0.0,  0.0,  0.0,  0.0, -1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  5.0, -4.0,  0.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  4.0, -4.0,  0.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  9.0,-11.0,  0.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0, -3.0,  0.0,  0.0,  0.0,  0.0,  0.0, -1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  8.0,-15.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0,  1.0,  0.0, -4.0,  5.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  4.0, -6.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  4.0,  0.0, -1.0,  0.0,  0.0,  0.0,  2.0],
    [1.0,  0.0,  0.0, -1.0,  1.0,  0.0, -3.0,  4.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0,  1.0,  1.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0,  1.0,  0.0,  0.0, -1.0,  0.0, -4.0, 10.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  1.0, -1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0,  0.0,  0.0,  0.0, -1.0,  0.0,  0.0, -1.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0,  0.0, -3.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0, -1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0,  0.0, -4.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0, -5.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  2.0, -2.0,  1.0,  0.0, -4.0,  4.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0,  0.0,  0.0, -1.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  4.0, -3.0,  0.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  1.0, -1.0,  1.0,  0.0,  0.0, -1.0,  0.0,  0.0,  0.0,  0.0,  2.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  4.0, -4.0,  0.0,  0.0,  0.0,  0.0,  0.0, -1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0, -4.0,  0.0,  0.0,  0.0,  0.0, -1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  5.0, -8.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0, -2.0,  0.0,  0.0,  0.0,  0.0,  1.0],
    [0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  2.0, -2.0,  1.0,  0.0,  0.0, -9.0, 13.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [2.0,  0.0,  2.0,  0.0,  2.0,  0.0,  0.0,  2.0,  0.0, -3.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0, -6.0,  0.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  1.0, -1.0,  2.0,  0.0,  0.0, -1.0,  0.0,  0.0,  2.0,  0.0,  0.0,  0.0],
    [1.0,  0.0,  0.0, -1.0, -1.0,  0.0, -3.0,  4.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0, -6.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  6.0, -6.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0,  0.0,  0.0,  0.0,  1.0],
    [1.0,  0.0,  2.0,  0.0,  1.0,  0.0,  0.0, -2.0,  0.0,  3.0,  0.0,  0.0,  0.0,  0.0],
    [1.0,  0.0, -2.0,  0.0, -1.0,  0.0,  0.0, -1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0, -2.0,  4.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0, -5.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0,  1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0,  1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0],
    [0.0,  0.0,  2.0,  0.0,  2.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0, -8.0,  3.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  6.0,-10.0,  0.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  7.0, -8.0,  3.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  1.0,  0.0, -3.0,  5.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0,  1.0,  0.0, -1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0,  0.0,  0.0, -5.0,  7.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0,  0.0, -2.0,  0.0,  0.0,  0.0,  1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0,  0.0, -1.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  7.0,-10.0,  0.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [1.0,  0.0,  0.0, -2.0,  0.0,  0.0,  0.0, -2.0,  0.0,  2.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  2.0, -5.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  6.0, -8.0,  0.0,  0.0,  0.0,  0.0,  0.0, -1.0],
    [0.0,  0.0,  1.0, -1.0,  1.0,  0.0,  0.0, -9.0, 15.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  1.0,  0.0, -2.0,  3.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  1.0,  0.0, -1.0,  1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0, -6.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0, -4.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0,  0.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0,  0.0,  0.0, -1.0,  0.0,  0.0,  2.0],
    [2.0,  0.0,  0.0, -2.0,  1.0,  0.0, -6.0,  8.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  5.0, -5.0,  0.0,  0.0,  0.0,  0.0,  0.0, -1.0],
    [0.0,  0.0,  1.0, -1.0,  1.0,  0.0,  3.0, -6.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0,  1.0,  0.0, -2.0,  2.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0,  1.0,  0.0,  8.0,-14.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  8.0,-15.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  4.0, -6.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  7.0, -7.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [2.0,  0.0,  0.0, -2.0,  1.0,  0.0, -3.0,  3.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0, -1.0,  0.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0,  0.0,  0.0,  1.0,  0.0,  0.0,  2.0],
    [2.0,  0.0, -1.0, -1.0,  0.0,  0.0,  0.0,  3.0, -7.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  4.0, -7.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0, -3.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0,  1.0,  0.0,  0.0, -3.0,  4.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [2.0,  0.0,  0.0, -2.0,  0.0,  0.0,  0.0, -6.0,  8.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [2.0,  0.0,  0.0, -2.0,  0.0,  0.0,  0.0, -5.0,  6.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0,  0.0, -1.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0,  1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0,  2.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  1.0,  0.0, -1.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0, -1.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0, -9.0,  4.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0, -5.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0,  0.0, -4.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0,  1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  7.0,-11.0,  0.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0, -5.0,  4.0,  0.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  1.0, -1.0,  0.0,  0.0,  0.0, -1.0,  0.0, -1.0,  1.0,  0.0,  0.0,  0.0],
    [2.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0, -2.0,  0.0,  3.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  8.0,-15.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  1.0, -1.0,  2.0,  0.0,  0.0, -2.0,  2.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  6.0, -6.0,  0.0,  0.0,  0.0,  0.0,  0.0, -1.0],
    [0.0,  0.0,  1.0, -1.0,  1.0,  0.0,  0.0, -1.0,  0.0, -1.0,  1.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0, -2.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  4.0, -7.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0, -8.0,  3.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0,  1.0,  0.0,  2.0, -4.0,  0.0, -3.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  3.0, -5.0,  0.0,  2.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0,  0.0, -3.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  2.0, -2.0,  2.0,  0.0, -8.0, 11.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  5.0, -8.0,  3.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0, -2.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  1.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  5.0, -9.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  5.0, -5.0,  0.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  7.0, -9.0,  0.0,  0.0,  0.0,  0.0,  0.0, -1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  4.0, -7.0,  0.0,  0.0,  0.0,  0.0,  0.0, -1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0, -1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [1.0,  0.0, -2.0, -2.0, -2.0,  0.0,  0.0, -2.0,  0.0,  2.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0,  1.0,  0.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0,  0.0, -2.0,  5.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0, -3.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  6.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0,  0.0,  2.0, -5.0,  0.0,  0.0,  2.0],
    [2.0,  0.0,  0.0, -2.0, -1.0,  0.0,  0.0, -2.0,  0.0,  0.0,  5.0,  0.0,  0.0,  0.0],
    [2.0,  0.0,  0.0, -2.0, -1.0,  0.0, -6.0,  8.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [1.0,  0.0,  0.0, -2.0,  0.0,  0.0, -3.0,  3.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  8.0, -8.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0,  0.0,  2.0, -5.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  3.0, -7.0,  4.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  2.0, -2.0,  1.0,  0.0, -2.0,  2.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0, -1.0,  0.0,  1.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0,  0.0,  0.0,  0.0, -1.0,  0.0, -2.0,  5.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0,  0.0, -3.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0, -1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0, -3.0,  0.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0, 11.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  6.0,-15.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0,  0.0,  1.0,  0.0,  0.0,  0.0,  2.0],
    [1.0,  0.0,  0.0, -1.0,  0.0,  0.0,  0.0, -3.0,  4.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  1.0,  0.0, -3.0,  7.0, -4.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  5.0,  0.0, -2.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0, -5.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0],
    [0.0,  0.0,  2.0, -2.0,  2.0,  0.0, -5.0,  6.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  2.0, -2.0,  2.0,  0.0, -3.0,  3.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  6.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  4.0, -4.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  4.0, -8.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  4.0, -5.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  5.0, -7.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  6.0,-11.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0, -3.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  1.0, -1.0,  1.0,  0.0,  0.0, -1.0,  0.0,  3.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0,  0.0,  0.0,  0.0, -1.0,  0.0,  2.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0, -2.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  9.0,-12.0,  0.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  4.0, -4.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0],
    [0.0,  0.0,  1.0, -1.0,  0.0,  0.0, -8.0, 12.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0,  1.0,  0.0, -2.0,  3.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  7.0, -7.0,  0.0,  0.0,  0.0,  0.0,  0.0, -1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0, -6.0,  0.0,  0.0,  0.0,  0.0, -1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  6.0, -6.0,  0.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  1.0,  0.0, -4.0,  0.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  1.0, -1.0,  1.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  6.0, -9.0,  0.0,  0.0,  0.0,  0.0,  0.0, -1.0],
    [0.0,  0.0,  1.0, -1.0, -1.0,  0.0,  0.0,  0.0, -2.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0, -5.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [2.0,  0.0,  0.0, -2.0,  0.0,  0.0,  0.0, -2.0,  0.0,  3.0, -1.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0,  0.0,  0.0, -2.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  5.0, -9.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  5.0, -6.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  9.0, -9.0,  0.0,  0.0,  0.0,  0.0,  0.0, -1.0],
    [0.0,  0.0,  1.0, -1.0,  1.0,  0.0,  0.0, -1.0,  0.0,  0.0,  3.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  2.0, -4.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  5.0, -3.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0,  0.0,  0.0,  1.0],
    [0.0,  0.0,  1.0, -1.0,  2.0,  0.0,  0.0, -1.0,  0.0,  2.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  5.0, -9.0,  0.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  5.0, -3.0,  0.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  4.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  2.0,  0.0,  2.0,  0.0,  0.0,  4.0, -8.0,  3.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  2.0,  0.0,  2.0,  0.0,  0.0, -4.0,  8.0, -3.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  5.0,  0.0, -3.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  1.0,  0.0,  0.0,  0.0,  0.0],
    [2.0,  0.0, -1.0, -1.0, -1.0,  0.0,  0.0, -1.0,  0.0,  3.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  4.0, -3.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  4.0, -2.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  5.0,-10.0,  0.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  8.0,-13.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0],
    [0.0,  0.0,  2.0, -2.0,  1.0, -1.0,  0.0,  2.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0,  1.0,  0.0,  0.0, -1.0,  0.0,  0.0,  0.0,  2.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  3.0, -5.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [1.0,  0.0,  0.0, -2.0,  0.0,  0.0,  0.0, -2.0,  0.0,  3.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  2.0, -2.0,  0.0,  0.0, -3.0,  3.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  9.0, -9.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  2.0,  0.0,  2.0,  0.0,  1.0, -1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  2.0, -2.0,  1.0,  0.0,  0.0, -8.0, 11.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  2.0, -2.0,  1.0,  0.0,  0.0, -2.0,  0.0,  0.0,  2.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0,  1.0,  0.0,  0.0, -1.0,  0.0, -1.0,  2.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  5.0, -5.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0, -6.0,  0.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  8.0,-15.0,  0.0,  0.0,  0.0,  0.0, -1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  5.0, -2.0,  0.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  7.0,-13.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0,  0.0, -2.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  3.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  2.0, -2.0,  1.0,  0.0,  0.0, -2.0,  0.0,  3.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  8.0, -8.0,  0.0,  0.0,  0.0,  0.0,  0.0, -1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  8.0,-10.0,  0.0,  0.0,  0.0,  0.0,  0.0, -1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  4.0, -2.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0, -6.0,  0.0,  0.0,  0.0,  0.0,  0.0, -1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0, -4.0,  0.0,  0.0,  0.0,  0.0,  0.0, -1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0, -5.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0,  0.0, -4.0,  0.0,  0.0,  0.0,  0.0],
    [2.0,  0.0,  0.0, -2.0, -1.0,  0.0,  0.0, -5.0,  6.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0, -5.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [2.0,  0.0, -1.0, -1.0, -1.0,  0.0,  0.0,  3.0, -7.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  5.0, -8.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  2.0,  0.0,  2.0,  0.0, -1.0,  1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [2.0,  0.0,  0.0, -2.0,  0.0,  0.0,  0.0, -2.0,  0.0,  4.0, -3.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  6.0,-11.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [2.0,  0.0,  0.0, -2.0,  1.0,  0.0,  0.0, -6.0,  8.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  4.0, -8.0,  1.0,  5.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  6.0, -5.0,  0.0,  0.0,  0.0,  0.0,  2.0],
    [1.0,  0.0, -2.0, -2.0, -2.0,  0.0, -3.0,  3.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0,  2.0,  0.0,  0.0,  0.0, -2.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  2.0,  0.0,  0.0,  4.0, -8.0,  3.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  2.0,  0.0,  0.0, -4.0,  8.0, -3.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  6.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  6.0, -7.0,  0.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  4.0,  0.0,  0.0, -2.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0,  0.0,  0.0, -2.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0,  0.0, -1.0,  0.0,  0.0,  0.0,  1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0, -6.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  4.0, -5.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0, -5.0,  0.0,  2.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  7.0,-13.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0,  0.0, -2.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  1.0, -1.0,  0.0,  0.0,  0.0, -1.0,  0.0,  0.0,  2.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0, -8.0, 15.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [2.0,  0.0,  0.0, -2.0, -2.0,  0.0, -3.0,  3.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [2.0,  0.0, -1.0, -1.0, -1.0,  0.0,  0.0, -1.0,  0.0,  2.0,  0.0,  0.0,  0.0,  0.0],
    [1.0,  0.0,  2.0, -2.0,  2.0,  0.0,  0.0, -2.0,  0.0,  2.0,  0.0,  0.0,  0.0,  0.0],
    [1.0,  0.0, -1.0,  1.0, -1.0,  0.0,-18.0, 17.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  2.0,  0.0,  2.0,  0.0,  0.0,  1.0,  0.0, -1.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  2.0,  0.0,  2.0,  0.0,  0.0, -1.0,  0.0,  1.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  2.0, -2.0, -1.0,  0.0, -5.0,  6.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0,  2.0,  0.0,  0.0, -1.0,  0.0,  1.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  2.0, -2.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  8.0,-16.0,  0.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  5.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  2.0,  0.0,  0.0, -1.0,  2.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [2.0,  0.0, -1.0, -1.0, -2.0,  0.0,  0.0, -1.0,  0.0,  2.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  6.0,-10.0,  0.0,  0.0,  0.0,  0.0,  0.0, -1.0],
    [0.0,  0.0,  1.0, -1.0,  1.0,  0.0,  0.0, -1.0,  0.0, -2.0,  4.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0,  2.0,  0.0,  0.0,  0.0,  0.0,  2.0],
    [2.0,  0.0,  0.0, -2.0, -1.0,  0.0,  0.0, -2.0,  0.0,  4.0, -5.0,  0.0,  0.0,  0.0],
    [2.0,  0.0,  0.0, -2.0, -1.0,  0.0, -3.0,  3.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [2.0,  0.0, -1.0, -1.0, -1.0,  0.0,  0.0, -1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [1.0,  0.0,  1.0, -1.0,  1.0,  0.0,  0.0, -1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [1.0,  0.0,  0.0, -1.0, -1.0,  0.0,  0.0, -2.0,  2.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [1.0,  0.0, -1.0, -1.0, -1.0,  0.0, 20.0,-20.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  2.0, -2.0,  1.0,  0.0,  0.0, -1.0,  0.0,  1.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0,  1.0,  0.0,  1.0, -2.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0,  1.0,  0.0, -2.0,  1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  5.0, -8.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0,  0.0,  0.0, -1.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  9.0,-11.0,  0.0,  0.0,  0.0,  0.0,  0.0, -1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  5.0, -3.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0,  0.0, -3.0,  0.0,  0.0,  0.0, -1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0,  0.0,  1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  6.0, -7.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0, -2.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0, -2.0,  0.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  1.0, -1.0,  1.0,  0.0,  0.0, -1.0,  0.0,  0.0, -2.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0,  2.0,  0.0,  0.0, -1.0,  0.0, -2.0,  5.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  5.0, -7.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0, -3.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  5.0, -8.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0, -6.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [1.0,  0.0,  0.0, -2.0,  0.0,  0.0, 20.0,-21.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  8.0,-12.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  5.0, -6.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  4.0, -4.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0,  2.0,  0.0,  0.0, -1.0,  0.0, -1.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  8.0,-12.0,  0.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  9.0,-17.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  5.0, -6.0,  0.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  4.0, -8.0,  1.0,  5.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  4.0, -6.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0, -7.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [1.0,  0.0,  0.0, -1.0,  1.0,  0.0,  0.0, -3.0,  4.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [1.0,  0.0, -2.0,  0.0, -2.0,  0.0,-10.0,  3.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0, -9.0, 17.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0, -4.0,  0.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [1.0,  0.0, -2.0, -2.0, -2.0,  0.0,  0.0, -2.0,  0.0,  3.0,  0.0,  0.0,  0.0,  0.0],
    [1.0,  0.0, -1.0,  1.0, -1.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  2.0, -2.0,  2.0,  0.0,  0.0, -2.0,  0.0,  2.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0,  2.0,  0.0,  0.0, -1.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0,  2.0,  0.0, -5.0,  7.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  2.0, -2.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  4.0, -5.0,  0.0,  0.0,  0.0,  0.0,  0.0, -1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0, -4.0,  0.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0, -4.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  5.0,-10.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  4.0,  0.0, -4.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0,  0.0, -5.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0,  0.0, -5.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0,  0.0, -2.0,  5.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0,  0.0, -2.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0, -3.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0],
    [1.0,  0.0,  0.0, -2.0,  0.0,  0.0,  0.0,  1.0,  0.0, -1.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0, -7.0,  4.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [2.0,  0.0,  2.0,  0.0,  1.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0, -1.0,  0.0,  0.0, -1.0,  0.0, -1.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  1.0,  0.0, -2.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  6.0,-10.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [1.0,  0.0,  0.0, -1.0,  1.0,  0.0,  0.0, -1.0,  0.0,  1.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  2.0, -2.0,  1.0,  0.0,  0.0,  4.0, -8.0,  3.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  2.0, -2.0,  1.0,  0.0,  0.0,  1.0,  0.0, -1.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  2.0, -2.0,  1.0,  0.0,  0.0, -4.0,  8.0, -3.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  2.0, -2.0,  1.0,  0.0,  0.0, -3.0,  0.0,  3.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  2.0, -2.0,  1.0,  0.0, -5.0,  5.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0,  1.0,  0.0,  1.0, -3.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0,  1.0,  0.0,  0.0, -4.0,  6.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0,  1.0,  0.0,  0.0, -1.0,  0.0,  0.0,  0.0, -1.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0,  1.0,  0.0, -5.0,  6.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  3.0, -4.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  1.0,  0.0, -2.0,  2.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  7.0,-10.0,  0.0,  0.0,  0.0,  0.0,  0.0, -1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  5.0, -5.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  4.0, -5.0,  0.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0, -8.0,  0.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0, -5.0,  0.0,  0.0,  0.0,  0.0,  0.0, -1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0, -2.0,  0.0,  0.0,  0.0,  0.0,  0.0, -1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  7.0, -9.0,  0.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  7.0, -8.0,  0.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0, -8.0,  3.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0,  0.0,  0.0, -2.0,  0.0,  0.0,  1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0, -4.0,  0.0,  0.0,  0.0,  0.0,  1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0,  0.0,  0.0, -1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0,  0.0, -1.0,  0.0,  0.0,  0.0, -1.0],
    [2.0,  0.0,  0.0, -2.0, -1.0,  0.0,  0.0, -6.0,  8.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [2.0,  0.0, -1.0, -1.0,  1.0,  0.0,  0.0,  3.0, -7.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  2.0, -2.0,  1.0,  0.0,  0.0, -7.0,  9.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0, -5.0,  0.0,  0.0,  0.0,  0.0, -1.0],
    [0.0,  0.0,  1.0, -1.0,  2.0,  0.0, -8.0, 12.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0, -2.0,  0.0,  2.0,  0.0,  0.0,  0.0,  0.0],
    [1.0,  0.0,  0.0, -2.0,  0.0,  0.0,  2.0, -2.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  7.0, -8.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [2.0,  0.0,  0.0, -2.0,  1.0,  0.0,  0.0, -5.0,  6.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [2.0,  0.0,  0.0, -2.0, -1.0,  0.0,  0.0, -2.0,  0.0,  3.0, -1.0,  0.0,  0.0,  0.0],
    [1.0,  0.0,  1.0,  1.0,  1.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [1.0,  0.0,  0.0, -2.0,  1.0,  0.0,  0.0, -2.0,  0.0,  2.0,  0.0,  0.0,  0.0,  0.0],
    [1.0,  0.0,  0.0, -2.0, -1.0,  0.0,  0.0, -2.0,  0.0,  2.0,  0.0,  0.0,  0.0,  0.0],
    [1.0,  0.0,  0.0, -1.0, -1.0,  0.0,  0.0, -3.0,  4.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [1.0,  0.0, -1.0,  0.0, -1.0,  0.0, -3.0,  5.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  2.0, -2.0,  1.0,  0.0,  0.0, -4.0,  4.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  2.0, -2.0,  1.0,  0.0,  0.0, -2.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  2.0, -2.0,  1.0,  0.0, -8.0, 11.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  2.0, -2.0,  0.0,  0.0,  0.0, -9.0, 13.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0,  1.0,  2.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0,  1.0,  0.0,  0.0,  1.0, -4.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0,  1.0,  0.0,  0.0, -1.0,  0.0,  1.0, -3.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  7.0,-13.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  2.0,  0.0, -2.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0, -2.0,  2.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  1.0,  0.0, -3.0,  4.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  1.0,  0.0, -4.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  7.0,-11.0,  0.0,  0.0,  0.0,  0.0,  0.0, -1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  6.0, -6.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  6.0, -4.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  5.0, -6.0,  0.0,  0.0,  0.0,  0.0,  0.0, -1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  4.0, -2.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0, -4.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0, -4.0,  0.0,  0.0,  0.0,  0.0,  0.0, -1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  9.0,-17.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  7.0, -7.0,  0.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  4.0, -8.0,  3.0,  0.0,  0.0,  0.0,  1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  4.0, -8.0,  3.0,  0.0,  0.0,  0.0, -1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  4.0, -8.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  4.0, -7.0,  0.0,  0.0,  0.0,  0.0, -1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  1.0,  0.0,  0.0,  0.0,  1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0,  0.0, -4.0,  0.0,  0.0,  0.0,  0.0],
    [2.0,  0.0,  0.0, -2.0,  0.0,  0.0,  0.0, -4.0,  8.0, -3.0,  0.0,  0.0,  0.0,  0.0],
    [2.0,  0.0,  0.0, -2.0,  0.0,  0.0, -2.0,  2.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  4.0, -8.0,  3.0,  0.0,  0.0,  0.0,  0.0],
    [1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0, -4.0,  8.0, -3.0,  0.0,  0.0,  0.0,  0.0],
    [1.0,  0.0,  0.0,  0.0,  0.0,  0.0, -1.0,  1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [1.0,  0.0,  0.0, -2.0,  0.0,  0.0, 17.0,-16.0,  0.0, -2.0,  0.0,  0.0,  0.0,  0.0],
    [1.0,  0.0,  0.0, -1.0,  0.0,  0.0,  0.0, -2.0,  2.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  2.0, -2.0,  0.0,  0.0,  0.0, -2.0,  0.0,  2.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  6.0, -9.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  4.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0,  0.0, -4.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0, -2.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0,  1.0,  0.0,  0.0,  0.0,  0.0,  2.0],
    [2.0,  0.0,  0.0, -2.0,  0.0,  0.0,  0.0, -4.0,  4.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [2.0,  0.0,  0.0, -2.0,  0.0,  0.0,  0.0, -2.0,  0.0,  2.0,  2.0,  0.0,  0.0,  0.0],
    [1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0, -1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0, -1.0,  0.0,  1.0,  0.0,  0.0,  0.0,  0.0],
    [1.0,  0.0,  0.0,  0.0,  0.0,  0.0, -3.0,  3.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [1.0,  0.0,  0.0, -2.0,  0.0,  0.0,  1.0, -1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [1.0,  0.0,  0.0, -2.0,  0.0,  0.0,  0.0,  4.0, -8.0,  3.0,  0.0,  0.0,  0.0,  0.0],
    [1.0,  0.0,  0.0, -2.0,  0.0,  0.0,  0.0, -4.0,  8.0, -3.0,  0.0,  0.0,  0.0,  0.0],
    [1.0,  0.0,  0.0, -2.0,  0.0,  0.0, -2.0,  2.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  2.0, -2.0,  0.0,  0.0, -4.0,  4.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0,  1.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0,  0.0,  0.0,  3.0, -6.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0,  0.0,  0.0,  0.0, -2.0,  2.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0,  0.0,  0.0,  0.0, -1.0,  0.0,  1.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0,  0.0,  0.0,  0.0, -1.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0,  0.0,  0.0, -4.0,  5.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0,  0.0,  0.0, -3.0,  4.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  2.0,  0.0,  0.0,  0.0, -1.0,  0.0,  1.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  8.0, -9.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0, -6.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0,  1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0, -5.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0, -2.0,  0.0,  0.0,  0.0],
    [2.0,  0.0, -2.0, -2.0, -2.0,  0.0,  0.0, -2.0,  0.0,  2.0,  0.0,  0.0,  0.0,  0.0],
    [1.0,  0.0,  0.0,  0.0,  1.0,  0.0,-10.0,  3.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [1.0,  0.0,  0.0,  0.0, -1.0,  0.0,-10.0,  3.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  2.0,  0.0,  2.0,  0.0,  2.0, -3.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  2.0,  0.0,  2.0,  0.0,  2.0, -2.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  2.0,  0.0,  2.0,  0.0, -2.0,  3.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  2.0,  0.0,  2.0,  0.0, -2.0,  2.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  2.0,  0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0, -1.0,  0.0,  2.0,  0.0,  0.0,  0.0,  0.0],
    [2.0,  0.0,  2.0, -2.0,  2.0,  0.0,  0.0, -2.0,  0.0,  3.0,  0.0,  0.0,  0.0,  0.0],
    [2.0,  0.0,  1.0, -3.0,  1.0,  0.0, -6.0,  7.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [2.0,  0.0,  0.0, -2.0,  0.0,  0.0,  2.0, -5.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [2.0,  0.0,  0.0, -2.0,  0.0,  0.0,  0.0, -2.0,  0.0,  5.0, -5.0,  0.0,  0.0,  0.0],
    [2.0,  0.0,  0.0, -2.0,  0.0,  0.0,  0.0, -2.0,  0.0,  1.0,  5.0,  0.0,  0.0,  0.0],
    [2.0,  0.0,  0.0, -2.0,  0.0,  0.0,  0.0, -2.0,  0.0,  0.0,  5.0,  0.0,  0.0,  0.0],
    [2.0,  0.0,  0.0, -2.0,  0.0,  0.0,  0.0, -2.0,  0.0,  0.0,  2.0,  0.0,  0.0,  0.0],
    [2.0,  0.0,  0.0, -2.0,  0.0,  0.0, -4.0,  4.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [2.0,  0.0, -2.0,  0.0, -2.0,  0.0,  0.0,  5.0, -9.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [2.0,  0.0, -1.0, -1.0,  0.0,  0.0,  0.0, -1.0,  0.0,  3.0,  0.0,  0.0,  0.0,  0.0],
    [1.0,  0.0,  2.0,  0.0,  2.0,  0.0,  1.0, -1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [1.0,  0.0,  2.0,  0.0,  2.0,  0.0,  0.0,  4.0, -8.0,  3.0,  0.0,  0.0,  0.0,  0.0],
    [1.0,  0.0,  2.0,  0.0,  2.0,  0.0,  0.0, -4.0,  8.0, -3.0,  0.0,  0.0,  0.0,  0.0],
    [1.0,  0.0,  2.0,  0.0,  2.0,  0.0, -1.0,  1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [1.0,  0.0,  2.0, -2.0,  2.0,  0.0, -3.0,  3.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0,  0.0, -1.0,  0.0,  0.0,  0.0,  0.0],
    [1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0, -2.0,  0.0,  3.0,  0.0,  0.0,  0.0,  0.0],
    [1.0,  0.0,  0.0, -2.0,  0.0,  0.0,  0.0,  2.0,  0.0, -2.0,  0.0,  0.0,  0.0,  0.0],
    [1.0,  0.0, -2.0, -2.0, -2.0,  0.0,  0.0,  1.0,  0.0, -1.0,  0.0,  0.0,  0.0,  0.0],
    [1.0,  0.0, -1.0,  1.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [1.0,  0.0, -1.0, -1.0,  0.0,  0.0,  0.0,  8.0,-15.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  2.0,  2.0,  2.0,  0.0,  0.0,  2.0,  0.0, -2.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  2.0, -2.0,  1.0,  0.0,  1.0, -1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  2.0, -2.0,  1.0,  0.0,  0.0, -2.0,  0.0,  1.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  2.0, -2.0,  1.0,  0.0,  0.0,-10.0, 15.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  2.0, -2.0,  0.0, -1.0,  0.0,  2.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0,  2.0,  0.0,  0.0, -1.0,  0.0,  0.0, -1.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0,  2.0,  0.0, -3.0,  4.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0,  1.0,  0.0, -4.0,  6.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0,  1.0,  0.0, -1.0,  2.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0,  0.0,  0.0,  0.0, -1.0,  0.0,  0.0, -2.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0,  0.0,  0.0, -2.0,  2.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0,  0.0,  0.0, -1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  1.0, -1.0, -1.0,  0.0, -5.0,  7.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  2.0,  0.0,  0.0,  0.0,  2.0,  0.0, -2.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  2.0,  0.0,  0.0, -2.0,  2.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  2.0,  0.0, -3.0,  5.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  1.0,  0.0, -1.0,  2.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  9.0,-13.0,  0.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  8.0,-14.0,  0.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  8.0,-11.0,  0.0,  0.0,  0.0,  0.0,  0.0, -1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  6.0, -9.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  6.0, -8.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  6.0, -7.0,  0.0,  0.0,  0.0,  0.0,  0.0, -1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  5.0, -6.0,  0.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  5.0, -6.0, -4.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  5.0, -4.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  4.0, -8.0,  0.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  4.0, -5.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0, -3.0,  0.0,  2.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0, -1.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0, -1.0,  0.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  7.0,-12.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  6.0, -9.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  6.0, -8.0,  1.0,  5.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  6.0, -4.0,  0.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  6.0,-10.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  5.0,  0.0, -4.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  5.0, -9.0,  0.0,  0.0,  0.0,  0.0, -1.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  5.0, -8.0,  3.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  5.0, -7.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  5.0, -6.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  5.0,-16.0,  4.0,  5.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  5.0,-13.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0,  0.0, -5.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0, -9.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  3.0, -7.0,  0.0,  0.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0,  0.0,  2.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0,  0.0,  0.0, -3.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0, -8.0,  1.0,  5.0,  0.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  1.0, -5.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  2.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0, -3.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0,  0.0, -3.0,  5.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0, -3.0,  0.0,  0.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0, -6.0,  3.0,  0.0, -2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0, -2.0,  0.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  2.0],
    [0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0,  0.0,  0.0]
];
